//  Gnomoradio - gnomoradio/playlist-settings.cc
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "playlist-settings.h"
#include "song-paths.h"

using namespace Gtk;
using namespace Glib;
using namespace Wraporadio;

Gnomoradio::PlaylistSettingsBox::PlaylistSettingsBox (Wraporadio::SongList &songlist)
	: ok_button(_("OK")),
	  modified(false)
{
	box_songlist = songlist;
	type = songlist.get_type();

	/* some initial values for the window */
	set_title(_("Edit Playlist Settings"));
	set_border_width(8);

	/* create and add a vbox */
        VBox *vbox = manage(new VBox(false, 3));
	add(*vbox);

	/* playlist name and type */
	Label *name_label = manage(new Label(_("Name:")));
	Label *type_label = manage(new Label(_("Type:")));
	Label *list_type = manage(new Label);

	HBox *name_hbox = manage(new HBox(false, 5));
	name_hbox->pack_start(*name_label, false, false);
	name_hbox->pack_start(name_entry, false, false);

	name_entry.set_text(songlist.get_name());

	HBox *type_hbox = manage(new HBox(false, 5));
	type_hbox->pack_start(*type_label, false, false);
	type_hbox->pack_start(*list_type, false, false);
	
	vbox->pack_start(*name_hbox, false, false);
	vbox->pack_start(*type_hbox, false, false);

	if (type == SongList::STANDARD) {
	        list_type->set_text(_("Standard Playlist"));
	} else if (type == SongList::LIBRARY) {
		list_type->set_text(_("Local Music Library"));
		name_entry.set_sensitive(false);

		SongPaths *song_paths = manage(new SongPaths);

		vbox->pack_start(*song_paths, false, false, 20);
	} else if (type == SongList::CACHE) {
		list_type->set_text(_("Downloaded Music Cache"));
		name_entry.set_sensitive(false);

		Wraporadio::Init wr;

		Label *line1 = manage(new Label(_("Limit disk usage to")));
		Label *line2 = manage(new Label(_("Megabytes")));

		Adjustment *adj = manage(new Adjustment(wr.get_state().get_rainbow_cache_size(), 30, 20000, 5));
		spin_button.set_adjustment(*adj);
		spin_button.signal_value_changed().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::set_modified_true));

		HBox *hbox = manage(new HBox(false, 3));
		hbox->pack_start(*line1, false, false);
		hbox->pack_start(spin_button, false, false);
		hbox->pack_start(*line2, false, false);

		vbox->pack_start(*hbox, false, false, 25);
	} else if (type == SongList::SEARCH) {
		list_type->set_text(_("Search Playlist"));

		crit_creator.set_criterion(static_cast<SongListSearch*>(&songlist)->get_criteria());
		crit_creator.signal_changed.connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::ok_button_set_sensitive));
		crit_creator.signal_no_more_inputs.connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::ok_button_set_insensitive));
		crit_creator.signal_changed.connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::set_modified_true));

		vbox->pack_start(crit_creator, true, true, 20);
	} else if (type == SongList::HISTORY) {
		list_type->set_text(_("Song History"));
		name_entry.set_sensitive(false);

		Label *line1 = manage(new Label(_("Display songs played in the last")));
		Label *line2 = manage(new Label(_("days")));

		Adjustment *adj = manage(new Adjustment(static_cast<SongListHistory*>(&songlist)->get_number(), 1, 365, 1));
		spin_button.set_adjustment(*adj);
		spin_button.signal_value_changed().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::set_modified_true));

		HBox *hbox = manage(new HBox(false, 3));
		hbox->pack_start(*line1, false, false);
		hbox->pack_start(spin_button, false, false);
		hbox->pack_start(*line2, false, false);

		vbox->pack_start(*hbox, false, false, 25);
	} else if (type == SongList::RADIO) {
		list_type->set_text(_("Radio Playlist"));
		Label *line1 = manage(new Label(_("Import")));
		Label *line2 = manage(new Label(_("% of new playlist songs")));

		Adjustment *adj = manage(new Adjustment(static_cast<SongListRadio*>(&songlist)->get_percent_recommend(), 0, 100, 1));
		spin_button.set_adjustment(*adj);
		spin_button.signal_value_changed().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::set_modified_true));

		HBox *hbox = manage(new HBox(FALSE, 3));
		hbox->pack_start(*line1, false, false);
		hbox->pack_start(spin_button, false, false);
		hbox->pack_start(*line2, false, false);

		vbox->pack_start(*hbox, false, false, 25);
	}

	vbox->pack_start(ok_button, false, false, 8); 

	/* connect signals */
	name_entry.signal_changed().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::ok_button_set_sensitive));

	ok_button.signal_clicked().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::on_ok_clicked));

	signal_hide().connect(SigC::slot(*this, &Gnomoradio::PlaylistSettingsBox::on_hide));
}


Gnomoradio::PlaylistSettingsBox::~PlaylistSettingsBox ()
{

}

void Gnomoradio::PlaylistSettingsBox::on_ok_clicked ()
{
	if (modified) {
		box_songlist.set_name(name_entry.get_text());

		if (type == SongList::CACHE) {
			Wraporadio::Init wr;
			
			wr.get_state().set_rainbow_cache_size(spin_button.get_value_as_int());
		} else if (type == SongList::SEARCH) {
			static_cast<SongListSearch*>(&box_songlist)->set_criteria(crit_creator.get_criterion());
		} else if (type == SongList::HISTORY) {
			static_cast<SongListHistory*>(&box_songlist)->set_number(spin_button.get_value_as_int());
		} else if (type == SongList::RADIO) {
			static_cast<SongListRadio*>(&box_songlist)->set_percent_recommend(spin_button.get_value_as_int());
		}
	}

	hide();
}
