// -*- c++ -*-

//  Gnomoradio - gnomoradio/playlist-druid.h
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYLIST_DRUID_H
#define __PLAYLIST_DRUID_H

#include <gtkmm.h>
#include "druid.h"
#include "criteria-creator.h"

namespace Gnomoradio
{
	class PlaylistDruid : public Gtk::Window
	{
	public:
		PlaylistDruid ();
		~PlaylistDruid ();

	private:
		Druid druid;

		Gtk::Entry playlist_name_entry;

		Gtk::RadioButton blank_list, radio_list, search_list;

		// Radio List
		Gtk::SpinButton frequency;

		// Search List
		CriteriaCreator criteria_creator;

		Gtk::Widget *first_page;
		Gtk::VBox dummy_page;

		void disable_druid_advance () { druid.set_able_to_move_on(false); }

		void enable_druid_advance () { druid.set_able_to_move_on(); }

		void on_no_more_criteria_inputs () { druid.set_able_to_move_on(false); }

		void on_signal_next (Gtk::Widget *from_page);

		// This function is called once a playlist type has been chosen,
		// at that point, the druid is completed appropriately.
		void complete_druid_setup ();

		void on_playlist_name_entry_changed ();

		void create_list ();

		void on_hide_window ();
	};
}

#endif
