//  Gnomoradio - gnomoradio/intro-druid.cc
//  Copyright (C) 2004  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "wraporadio/wraporadio.h"
#include "conf.h"
#include "browser-link.h"
#include "intro-druid.h"

using namespace std;
using namespace Gnomoradio;

void Gnomoradio::IntroDruid::start_if_necessary ()
{
	int last_druid_version = Conf::get_int("druid_version");

#ifndef USE_GCONF
	last_druid_version = druid_version; // no need to re-run
#endif

	if (!Wraporadio::Init().get_state().state_file_exists()
	    || druid_version > last_druid_version)
		(new IntroDruid)->show_all();
}

Gnomoradio::IntroDruid::IntroDruid ()
	: radio_enable_checkbutton(_("Create a new radio playlist"))
{
	set_border_width(8);

	// welcome page
	Gtk::Label *l = new Gtk::Label(_("Welcome to Gnomoradio.  This Druid will help you get acquainted to Gnomoradio and set up some of the features that make it a unique music player."));
	l->set_line_wrap();
	druid.append_page(l);

	// find local music page
	Gtk::VBox *local_music = new Gtk::VBox(false, 8);
	Gtk::Label *lm = manage(new Gtk::Label(_("The first thing that Gnomoradio needs to know is the location of local music (mp3 and ogg files) on your system.  The directories below will be scanned recursively for songs.")));
	lm->set_line_wrap();
	local_music->pack_start(*lm, Gtk::PACK_SHRINK);
	local_music->pack_start(song_paths, Gtk::PACK_SHRINK);
	druid.append_page(local_music);

	// rainbow setup
	Gtk::VBox *rainbow_page = new Gtk::VBox(false, 8);
	Gtk::Label *rb = manage(new Gtk::Label(_("In addition to playing local music, Gnomoradio features Rainbow, a system to download and share freely licensed music.  Occasionally, the program will report your listening preferences to a server to find new music you may like.  If you would like to disable this report, be sure to enable \"Conserve Privacy\" below.")));
	rb->set_line_wrap();
	rainbow_page->pack_start(*rb, Gtk::PACK_SHRINK);
	rainbow_page->pack_start(*manage(rainbow_setup()), Gtk::PACK_SHRINK);
	druid.append_page(rainbow_page);

	// set up radio list
	Gtk::VBox *radio_page = new Gtk::VBox(false, 8);
	Gtk::Label *rp = manage(new Gtk::Label(_("You can now set up a new radio playlist.  This list will automatically choose music, and it will recommend and download new music if Rainbow is enabled.")));
	rp->set_line_wrap();
	radio_page->pack_start(*rp, Gtk::PACK_SHRINK);
	radio_enable_checkbutton.signal_toggled().connect(SigC::slot(*this, &IntroDruid::on_radio_list_enable_toggled));
	radio_page->pack_start(radio_enable_checkbutton, Gtk::PACK_SHRINK);
	Gtk::HBox *frequency_hbox = manage(new Gtk::HBox(false, 4));
	Gtk::Label *frequency_label1 = manage(new Gtk::Label(_("Import ")));
	Gtk::Label *frequency_label2 = manage(new Gtk::Label(_("% of new playlist songs")));
	frequency_hbox->pack_start(*frequency_label1, Gtk::PACK_SHRINK);
	frequency_hbox->pack_start(frequency, Gtk::PACK_SHRINK);
	frequency_hbox->pack_start(*frequency_label2, Gtk::PACK_SHRINK);
	Gtk::Adjustment *freq_adj = new Gtk::Adjustment(15, 0, 100);
	frequency.set_adjustment(*freq_adj);
	frequency.set_sensitive(false);
	radio_page->pack_start(*frequency_hbox, Gtk::PACK_SHRINK);
	druid.append_page(radio_page);

	// finish page (our website)
	Gtk::VBox *finish_page = new Gtk::VBox(false, 8);
	Gtk::Label *fp = manage(new Gtk::Label(_("Gnomoradio should be ready to go.  Please check out our website using the link below, and remember that the success of Gnomoradio depends upon you supporting the artists.  Enjoy.")));
	fp->set_line_wrap();
	Gtk::Button *web_link = manage(new Gtk::Button("http://gnomoradio.org/"));
	web_link->signal_clicked().connect(SigC::bind(SigC::slot(&BrowserLink::open_url), "http://gnomoradio.org/"));
	finish_page->pack_start(*fp, Gtk::PACK_SHRINK);
	finish_page->pack_start(*web_link, Gtk::PACK_SHRINK);
	druid.append_page(finish_page);

	signal_hide().connect(SigC::slot(*this, &IntroDruid::on_hide_window));
	druid.signal_finished.connect(SigC::slot(*this, &IntroDruid::on_finish));

	add(druid);
	set_default_size(400, 250);

	druid.pages_ready();
}

Gnomoradio::IntroDruid::~IntroDruid ()
{
}

void Gnomoradio::IntroDruid::on_hide_window ()
{
	delete this;
}

void Gnomoradio::IntroDruid::on_finish ()
{
	Conf::set("druid_version", druid_version);

	if (radio_enable_checkbutton.get_active()) {
		Glib::ustring list_name(_("Radio List"));
		Wraporadio::SongListRadio(list_name, ((unsigned short) frequency.get_value()));
	}
}

void Gnomoradio::IntroDruid::on_radio_list_enable_toggled ()
{
	frequency.set_sensitive(radio_enable_checkbutton.get_active());
}
