// -*- c++ -*-

//  Gnomoradio - gnomoradio/playlist-chooser-store.h
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYLIST_CHOOSER_STORE_H
#define __PLAYLIST_CHOOSER_STORE_H

#include <gtkmm.h>
#include "playlist-store.h"
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	/* internal representation of the Playlist chooser.  Holds list
	 * of all named SongList's and pointers to their respective 
	 * PlayListStore's
	 */

	class PlaylistChooserStore : public SigC::Object
	{
	public:
		PlaylistChooserStore ();

		Glib::RefPtr<Gtk::ListStore> store;

		Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon_col;
		Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > playing_col;
		Gtk::TreeModelColumn<Glib::ustring> name_col;
		Gtk::TreeModelColumn<Wraporadio::SongList> song_list_col;

	protected:
		void fill_with_playlists ();
		void redo (Wraporadio::ref_ptr<Roboradio::SongList> sl);
	};
}

#endif
