/**************************************************************************
 * BaseString - Functions base of elaborations of the string. 
 * Version:     0.3.7 05/02/2006
 * File:        ErrLog.c
 * Description: Error log.
 * Error:       ID file ?, last number ??
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#include <stdio.h>
#include <string.h>
#include "global.h"
#define _EL_PRIVATE_H
#include "ErrLog.h"
#include "BaseString.h"

// variable for the management of the errors 
struct _ErrPar ErrPar;
static struct _ErrRow ListErr[MAXERR];
static char *StrNull= "";

/**************************************************************************
 * Function: ElAddErr
 * Details:  Adds to the list the error message. 
 *           The ID file used can be found with grep AddErr on the files. 
 * Returns: 
 **************************************************************************/
void ElAddErr1 (int IDErr, char *TypeErr, char *format, char *par1){
  AddErr (IDErr, TypeErr, format, par1, StrNull, StrNull);
}

void ElAddErr2 (int IDErr, char *TypeErr, char *format, char *par1, char *par2){
  AddErr (IDErr, TypeErr, format, par1, par2, StrNull);
}

void ElAddErr (int IDErr, char *TypeErr, char *format, char *par1, char *par2, char *par3){
  AddErr (IDErr, TypeErr, format, par1, par2, par3);
}

/**************************************************************************
 * Function: ElPrintErrs
 * Details:  Print the errors
 * Returns: 
 **************************************************************************/
void ElPrintErrs (){
  int ErrNum;

  for (ErrNum= 0; ErrNum < ErrPar.NumErr; ErrNum++)
    PrintErr (IDMSG, ListErr[ErrNum].ID, ListErr[ErrNum].type,
	      ListErr[ErrNum].text);
} // ElPrintErrs

/**************************************************************************
 * Function: ElInit
 * Details:  Initialize the parameters of the configuration.
 * Returns: 
 **************************************************************************/
void ElInit (){
  ErrPar.NumErr= 0;
  ErrPar.StdPrint= true;
  strcpy (ErrPar.VerbLev, "0");
} //ElInit

/**************************************************************************
 * Function: AddErr
 * Details:  Adds to the list the error message. 
 *           The ID file used can be found with grep AddErr on the files. 
 * Returns: 
 **************************************************************************/
static void AddErr (int IDErr, char *TypeErr, char *format, char *par1, char *par2, char *par3){

  int MaxLen= 15;
  char type[LENSTR + 1], mess[LLENSTR + 1];

// IDErr= cbbaa: 
// aa= error number for file, bb= ID file, c= < 1 is one library

  if (!strcmp (TypeErr, "BS"))
    strcpy (type, "BADSTR");    
  else if (!strcmp (TypeErr, "BR"))
    strcpy (type, "BADROW");
  else if (!strcmp (TypeErr, "FR"))
    strcpy (type, "FULLROWS");
  else if (!strcmp (TypeErr, "BF"))
    strcpy (type, "BADFILE");
  else if (!strcmp (TypeErr, "BO"))
    strcpy (type, "BADOPT");
  else if (!strcmp (TypeErr, "BG"))
    strcpy (type, "BADGRP");
  else if (!strcmp (TypeErr, "BK"))
    strcpy (type, "BADKEY");
  else if (!strcmp (TypeErr, "BV"))
    strcpy (type, "BADVAL");
  else
    *type= '\0';

  cutparstr (mess, LLENSTR, format, par1, par2, par3);

  if (strlen (mess) > LLENSTR)
    fprintf (stderr, _("%sFATAL ERROR: THE ERROR MESSAGE EXCEEDS THE BUFFER\n"), IDMSG);
  else{
    if (ErrPar.StdPrint)
      PrintErr (IDMSG, IDErr, type, mess);
    else{
      if (ErrPar.NumErr < MAXERR){
	ListErr[ErrPar.NumErr].ID= IDErr;
	strcpy (ListErr[ErrPar.NumErr].type, type);
	strcpy (ListErr[ErrPar.NumErr].text, mess);
	ErrPar.NumErr++;
      }
      else
	fprintf (stderr, _("%sFATAL ERROR: THE NUMBER OF ERROR MESSAGES EXCEEDS %d\n"), 
		 IDMSG, MAXERR);      
    } // else if (ErrPar.StdPrint)
  } // else if (strlen (mess) > LLENSTR)
} // AddErr

/**************************************************************************
 * Function: PrintErr
 * Details:  Print the error
 * Returns: 
 **************************************************************************/
static void PrintErr (char *IDMsg, int IDErr, char *TypeErr, char *TxtErr){

  if (*ErrPar.VerbLev == '4')
    fprintf (stderr, "%serr: %d (%s) %s\n", IDMsg, IDErr, TypeErr, TxtErr);
  else
    fprintf (stderr, "%serr: (%s) %s\n", IDMsg, TypeErr, TxtErr);

} // PrintErr

