/**************************************************************************
 * BaseString - Functions for manipulation the string.
 * Version:     0.3.7 19/07/2006
 * File:        BaseString.h
 * Description: Tools of survival to the string. 
 * Platform(s):	GNU/Linux, All
 * Author(s):	Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 *
 * Copyright (C) 2002-6 Della Bianca Giuseppe <bepi@adria.it><bepii@libero.it>
 * This file is part of GesConf.
 *
 * GesConf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GesConf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GesConf; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **************************************************************************/
#ifndef _BASESTRING_H
#define _BASESTRING_H

#include <malloc.h>

void ltrim (char* StrTrim);
void rtrim (char* StrTrim);
void trim (char* StrTrim);
int strcatV (char *StrOut, char *StrIn, long LenBuff);
int strcpyV (char *StrOut, char *StrIn, long LenBuff);
int strncatV (char *StrOut, char *StrIn, long num, long LenBuff);
int strncpyV (char *StrOut, char *StrIn, long num, long LenBuff);
int strrepl (char *StrTo, char *StrFor, char *StrRepl, long LenBuff);
void strtostr (char *SDest, char *SIns, long PosIns, long LenIns);
void strfromstr (char *SDest, char *SIn, long PosIDest, long LenSDest);
long strnspnN (char *StrTo, char *StrFor, long IniFind);
int strtoken (char **pRowIn, char *token, char *separ, long LenBuff);
int AddTxtWithSep (char *GrpOut, char *GrpIn, char *PartGrp, char *sep, long LenBuff);
int CheckRow (char *RowIn);
int ParamsFromRow (char **pRow, char *par[], char *separ, int IniPar, int *NumPOut, 
		   long LenBuff);
void cutparstr (char *str, int MaxLen, char *format, char *par1, char *par2, char *par3);
void *xmalloc (size_t size);

#endif // _BASESTRING_H
