// -*- C++ -*-

/* 
 * Gnome Crystal
 * mendeleiev.cc 
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnome.h>
#include <glade/glade.h>
#include "mendeleiev.h"
#include "latticedlg.h"

extern "C"
{
	static void on_clicked(GtkWidget *widget, void * data)
	{
		gcMendeleievDlg* pBox = (gcMendeleievDlg*)data;
		pBox->Select(widget);
	}
}

gcMendeleievDlg::gcMendeleievDlg(gcLatticeDlg* pParent, int Z): gcDialog(PREFIX"/share/gcrystal/glade/mendeleiev.glade", "mendeleiev", "mendeleiev.html")
{
	m_pParent = pParent;
	m_Z = Z;
	m_button = NULL;
	GtkWidget* button;
	char buf[16];
	for (int i = 0; i < 118;)
	{
		i++;
		snprintf(buf, sizeof(buf), "elt%d", i);
		button = glade_xml_get_widget(xml, buf);
		if (button)
		{
			if (i == Z)
			{
				gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), true);
				m_button = GTK_WIDGET(button);
			}
			gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_clicked), this);
		}
	}
	gtk_widget_show(GTK_WIDGET(dialog));
}

gcMendeleievDlg::~gcMendeleievDlg()
{
	m_pParent->OnCloseChild();
}
	
bool gcMendeleievDlg::Apply()
{
	m_pParent->SetElement(m_Z);
}

void gcMendeleievDlg::Select(GtkWidget* widget)
{
	if (widget != m_button)
	{
		if (m_button) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(m_button), false);
		m_button = widget;
		gchar* name = gtk_widget_get_name(m_button);
		m_Z = atoi(name + 3);
	}
	else
	{
		m_button = NULL;
		m_Z = 0; 
	}
}


