/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Socket And Neural Map Creator
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Include Prototypes
#include "headers/gsnmc.h"

//Geeks Socket And Neural Map Creator (Function)
void GSNMC()

{

    //Variables
    int i,j,k;			//Counters
    float v,n,m;		//Float Values
    int GMSType;		//Geeks Map Simulation Type
    int GMCType;		//Geeks Map Connections Type
    int GNNum;			//Geeks Neurons Number
    int Inputs,Outputs;		//GSockets I/O 
    int APT[2*MAX_PIN];		//All Pin Types
    int Tmp;			//Temp Variable
    FILE *GMap;			//The Geeks Neural Map
    FILE *GIOD;			//The Geeks I/O Distribution
    
    //Create I/O GSockets
    GSocket InSocket;
    GSocket OutSocket;
    
    //Get User Values To Create The I/O GSockets
    printf("# Geeks Neural Map Creator #\n");
    printf("New I/O GSockets Have To Be Created\n");
    printf("Please Make Your Choices To Set Up The New GSockets\n\n");
    
    printf("# Input GSocket #\n");
    
    InSocket.SetST(0);
    
    printf("Please Specify Input GPins Number\n");
    printf("(Min:1,Max:%i)\n",MAX_PIN);
    printf("Choice:");
    
    scanf("%i",&i);
    
    //Check Inputs
    if (i>MAX_PIN)
    
    {
    
        printf("Error: Too Many GPins!\n");
        
        exit(1);
    
    }
    
    printf("\n");
    
    InSocket.SetPins(i);
    
    printf("Now Please Specify Type And State Of Every GPin\n");
    printf("(Types Binary:0,Real:1)\n");
    printf("(States Off:0,On:1)\n");
    
    for (j=i;j>=1;j--)
    
    {
    
        printf("GPin %i\n",i-j+1);
        printf("Choice (Type):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        InSocket.SetPT(i-j,k);
        
        printf("GPin %i\n",i-j+1);
        printf("Choice (State):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        InSocket.SetPS(i-j,k);
    
    }
    
    printf("Now Please Assign Values To The GPins\n");
    printf("(Values:Binary,Integer,Float)\n");
    printf("Please Set Min And Max Values\n");
    printf("(Example:5.5,20.6)\n");
    
    for (j=i;j>=1;j--)
    
    {
    
        m=0.0;
        
        printf("GPin %i\n",i-j+1);
        printf("Choice (Min,Max):");
        
        scanf("%f,%f",&n,&m);
        
        printf("\n");
        
        if (m==0.0)
            InSocket.SetPV(i-j,n);
        else
            InSocket.SetPV(i-j,n,m);
    
    }
    
    printf("# Output GSocket #\n");
    
    OutSocket.SetST(1);
    
    printf("Please Specify Output GPins Number\n");
    printf("(Min:1,Max:%i)\n",MAX_PIN);
    printf("Choice:");
    
    scanf("%i",&i);
    
    //Check Outputs
    if (i>MAX_PIN)
    
    {
    
        printf("Error: Too Many GPins!\n");
        
        exit(1);
    
    }
    
    printf("\n");
    
    OutSocket.SetPins(i);
    
    printf("Now Please Specify Type And State Of Every GPin\n");
    printf("(Types Binary:0,Real:1)\n");
    printf("(States Off:0,On:1)\n");
    
    for (j=i;j>=1;j--)
    
    {
    
        printf("GPin %i\n",i-j+1);
        printf("Choice (Type):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        OutSocket.SetPT(i-j,k);
        
        printf("GPin %i\n",i-j+1);
        printf("Choice (State):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        OutSocket.SetPS(i-j,k);
    
    }
    
    printf("Now Please Assign Values To The GPins\n");
    printf("(Values:Binary,Integer,Float)\n");
    printf("Please Set Min And Max Values\n");
    printf("(Example:5.5,20.6)\n");
    
    for (j=i;j>=1;j--)
    
    {
    
        m=0.0;
        
        printf("GPin %i\n",i-j+1);
        printf("Choice (Min,Max):");
        
        scanf("%f,%f",&n,&m);
        
        printf("\n");
        
        if (m==0.0)
            OutSocket.SetPV(i-j,n);
        else
            OutSocket.SetPV(i-j,n,m);
    
    }
    
    //Get GSockets I/O
    Inputs=InSocket.GetPins();
    Outputs=OutSocket.GetPins();
    
    //Check GSockets Data Types To Set The Simulation Type
    for (i=0;i<Inputs;i++)
        APT[i]=InSocket.GetPT(i);
    
    for (i=Inputs;i<Inputs+Outputs;i++)
        APT[i]=OutSocket.GetPT(i-Inputs);
    
    for (i=0;i<Inputs+Outputs-1;i++)
    
    {
    
        if (APT[i+1]!=APT[i])
        
        {
        
            GMSType=2;
            
            break;
        
        }
        
        else if (APT[i+1]==APT[i])
            GMSType=APT[i];
    
    }
    
    //Get User Values To Create The Neural Map
    printf("# Neural Map #\n");
    printf("Now The GMap Is Ready To Be Created\n");
    printf("Please Specify GMap Connections Type\n");
    printf("(Automatic:0,Manual:1)\n");
    printf("Choice:");
    
    scanf("%i",&GMCType);
    
    //Check GMap Connections Type
    if (GMCType<0 || GMCType>1)
    
    {
    
        printf("Error: Wrong GMap Type!\n");
        
        exit(1);
    
    }
    
    printf("\n");                                               
    
    printf("Please Specify How Many GNeurons Your GMap Will Have\n");
    printf("(Note: GNeurons Must Be Equal Or More Than The Outputs)\n");
    printf("(Min:1,Max:%i)\n",MAX_GN);
    printf("Choice:");
    
    scanf("%i",&GNNum);
    
    //Check GNNum
    if (GNNum>MAX_GN)
    
    {
    
        printf("Error: Too Many GNeurons!\n");
        
        exit(1);
    
    }
    
    //Final GNNum
    GNNum=GNNum+Inputs+Outputs;
    
    //Initialize GIOD
    GIOD=fopen("GIOD","w");
    
    //Set Starting Header
    fprintf(GIOD,"%i\n%i\n",Inputs,Outputs);
    
    //Save I/O GSockets Distribution
    for (i=0;i<=Inputs-1;i++)
    
    {
    
        fprintf(GIOD,"+\n");
        
        j=InSocket.GetPT(i);
        
        fprintf(GIOD,"%i\n",j);
        
        j=InSocket.GetPS(i);
        
        fprintf(GIOD,"%i\n",j);
        
        v=InSocket.GetPV(i,0);
        
        fprintf(GIOD,"%f\n",v);
        
        v=InSocket.GetPV(i,1);
        
        fprintf(GIOD,"%f\n",v);
    
    }
    
    for (i=0;i<=Outputs-1;i++)
    
    {
    
        fprintf(GIOD,"+\n");
        
        j=OutSocket.GetPT(i);
        
        fprintf(GIOD,"%i\n",j);
        
        j=OutSocket.GetPS(i);
        
        fprintf(GIOD,"%i\n",j);
        
        v=OutSocket.GetPV(i,0);
        
        fprintf(GIOD,"%f\n",v);
        
        v=OutSocket.GetPV(i,1);
        
        fprintf(GIOD,"%f\n",v);
    
    }
    
    //Close GIOD
    fclose(GIOD);
    
    //Check For Problematic GMap
    if (GNNum<Outputs)
    
    {
    
        printf("Error: GNeurons Are Less Than The Outputs!\n");
        
        exit(1);
    
    }
    
    //Initialize GMap
    GMap=fopen("GMap","w");
    
    //Set Starting Header
    fprintf(GMap,"%i\n%i\n%i\n%i\n%i\n",GMSType,GMCType,GNNum,Inputs,Outputs);
    
    //GMap Creation (Automatic - Not Optimized)
    j=GNNum/(Inputs+Outputs);	//Layers
    k=GNNum-(Inputs+Outputs);	//Free Neurons (Not Used For I/O)
    
    //Fixate Layers
    if (j==1)
        j++;
    
    //Keep Layers (j)
    Tmp=j;
    
    //Fixate Free Neurons
    if (k==0)
        k++;
    
    fprintf(GMap,"+\n");
    fprintf(GMap,"R\n");
    fprintf(GMap,"%i\n",Tmp);
    
    //Rectangle (Orthogonal)
    if (Inputs==Outputs)
    
    {
    
        for (i=0;i<Tmp;i++)
        
        {
        
            fprintf(GMap,"%i\n",2*k);
        
        }
    
    }
    
    //Delta (Triangle)
    else if (Inputs>Outputs)
    
    {
        for (i=0;i<Tmp;i++)
        
        {
        
            fprintf(GMap,"%i\n",(k/j)+1);
            
            j++;
        
        }
    
    }
    
    //AnaDelta (UpSide Down Triangle)
    else if (Inputs<Outputs)
    
    {
    
        for (i=0;i<Tmp;i++)
        
        {
        
            fprintf(GMap,"%i\n",(k/j)+1);
            
            k++;
        
        }
    
    }
    
    //Close GMap
    fclose(GMap);
    
    //Optimize GMap (Automatically)
    GNMOpt(AUTO);

}

/* ------------------------------------------------------------------------ */
