/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Neuron
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Neuron (Class - Model)
class GNeuron

{

    private:
    
    //Private Variables
    int NFT;			//Neuron Function Type
    int Counter;		//A Counter
    int In;			//Inputs
    float Out;			//Output
    float InSlot[MAX_PIN];	//Inputs Slot (Data Inputs)
    float Weights[MAX_PIN];	//Random Inputs Weights
    float Summary;		//A Summary
    float Base;			//Functions Base
    float SigFunc;		//Sigmoid Function Results
    
    
    
    //Randmomize Weights
    void RandWeights()
    
    {
    
        //Get Random Weights
        for (Counter=0;Counter<In;Counter++)
            Weights[Counter]=rand()%Mod;
    
    }
    
    
    
    //Sum Up
    void Sum()
    
    {
    
        //Reset Summary
        Summary=0;
        
        //New Summary
        for (Counter=0;Counter<In;Counter++)
            Summary+=InSlot[Counter]*Weights[Counter];
    
    }
    
    
    
    //Neuron Function
    void NFunc(int FType)
    
    {
    
        //Get Base From The Average Summary
        Base=Summary/In;
        
        if (FType==0)
        
        {
        
            //Step Function (Unity Sequence)
            if (Summary>Base)
                Out=1;
            else
                Out=0;
            
            printf("Out->%i\n",Out);
        
        }
        
        else if (FType==1)
        
        {
        
            //Sign Function
            if (Summary>Base)
                Out=1;
            else
                Out=-1;
        
            printf("Out->%i\n",Out);
        
        }
        
        else if (FType==2)
        
        {
        
            //Sigmoid Function (Real Systems Sequence)
            SigFunc=1/(1+expf(-1*Summary));
            
            if (Summary>Base)
                Out=SigFunc;
            else
                Out=-SigFunc;
            
            printf("Out->%.3f\n",Out);
        
        }
    
        else
        
        {
        
            printf("Error: Wrong Neuron Function Type Specified!\n");
            
            exit(1);
        
        }
    
    }
    
    
    
    public:
    
    //Public Variables
    int Mod;			//Modulo
    
    
    
    //Enable Neuron
    void Enable(int NFType)
    
    {
    
        //If This Is A New Neuron,Check And Fix Modulo
        if (Mod==0)
            Mod=8;
        
        //Set Neuron Function Type Globally
        NFT=NFType;
        
        //Run Functions
        RandWeights();
        Sum();
        NFunc(NFType);
    
    }
    
    
    
    //Set Input Data
    void InData(int Inputs,float Data)
    
    {
    
        InSlot[Inputs]=Data;
        
        In=Inputs+1;
        
        printf("InSlot->Input%i:%.3f\n",In,InSlot[Inputs]);
    
    }
    
    
    
    //Give Output Data
    float OutData()
    
    {
    
        return Out;
    
    }
    
    
    
    //Get Neuron Function Type
    int GetNFT()
    
    {
    
        //Return The Function Type
        return NFT;
    
    }
    
    
    
    //Get Base
    float GetBase()
    
    {
    
        //Return The NFunc Base
        return Base;
    
    }
    
    
    
    //Get Sum
    float GetSum()
    
    {
    
        //Return The Neuron Summary
        return Summary;
    
    }
    
    
    
    //Get Input Data
    float GetInData(int DIndex)
    
    {
    
        return InSlot[DIndex];
    
    }
    
    
    
    //Get Weights
    float GetWeights(int WIndex)
    
    {
    
        return Weights[WIndex];
    
    }

};

/* ------------------------------------------------------------------------ */
