/*	va_rwn.c */
/* Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* The va_readn() and va_writen() functions were taken from the book 
				"Advanced Programming in the UNIX* Environment" by W. Richard Stevens copy 1993 */

/* The va_write_fd() and va_read_fd() functions were taken from the book
				"UNIX Network Programming - Volume 1 - Networking APIs: Sockets and XTI" 
				 by W. Richard Stevens copy 1998 */

/* This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "my_header.h"

ssize_t va_writen(int fd, const void *vptr, size_t n)
{
	size_t	nleft;
	ssize_t	nwritten;
	const char *ptr;
	
	ptr = vptr;
	nleft = n;
	while (nleft > 0)
	{
		if ( (nwritten = write(fd, ptr, nleft)) < 1)
		{
			return(nwritten);
		}
		nleft -= nwritten;
		ptr   += nwritten;
	}
	return(n);
}

ssize_t va_readn(int fd, void *vptr, size_t n)
{
	size_t	nleft;
	ssize_t	nread;
	char *ptr;

	ptr = vptr;
	nleft = n;
	while (nleft > 0)
	{
		if ( (nread = read(fd, ptr, nleft)) < 0)
		{
			return(nread);
		}
		else if (nread == 0)
		{
			break;
		}
		nleft -= nread;
		ptr 		+= nread;
	}
	return(n - nleft);
}

ssize_t va_write_fd(int fd, void *ptr, size_t nbytes, int sendfd)
{
	struct msghdr msg;
	struct iovec iov[1];
	
//#ifdef HAVE_MSGHDR_MSG_CONTROL
	union {
		struct cmsghdr cm;
		char control[CMSG_SPACE(sizeof(int))];
		} control_un;
		
	struct cmsghdr *cmptr;

	msg.msg_control = control_un.control;
	msg.msg_controllen = sizeof(control_un.control);
	
	cmptr = CMSG_FIRSTHDR(&msg);
	cmptr->cmsg_len = CMSG_LEN(sizeof(int));
	cmptr->cmsg_level = SOL_SOCKET;
	cmptr->cmsg_type = SCM_RIGHTS;
	
	*((int *) CMSG_DATA(cmptr)) = sendfd;
	
//#else
//	msg.msg_accrights = (caddr_t) & sendfd;
//	msg.msg_accrights_len = sizeof(int);
	
//#endif

	msg.msg_name = NULL;
	msg.msg_namelen = 0;
	
	iov[0].iov_base = ptr;
	iov[0].iov_len = nbytes;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;
	
	return(sendmsg(fd, &msg, 0));
	
}


ssize_t va_read_fd(int fd, void * ptr, size_t nbytes, int * recvfd)
{
	struct msghdr msg;
	struct iovec iov[1];
	ssize_t n;
	int newfd;
	
//#ifdef HAVE_MSGHDR_MSG_CONTROL
	union {
		struct cmsghdr cm;
		char control[CMSG_SPACE(sizeof(int))];
		} control_un;
		
	struct cmsghdr *cmptr;
	
	msg.msg_control = control_un.control;
	msg.msg_controllen = sizeof(control_un.control);
	
//#else
//	msg.msg_accrights = (caddr_t) & newfd;
//	msg.msg_accrights_len = sizeof(int);
	
//#endif

	msg.msg_name = NULL;
	msg.msg_namelen = 0;
	
	iov[0].iov_base = ptr;
	iov[0].iov_len = nbytes;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;
	
	if ( (n = recvmsg(fd, &msg, 0)) <= 0)
	{
		return(n);
	}

//#ifdef HAVE_MSGHDR_MSG_CONTROL
	if ( ((cmptr = CMSG_FIRSTHDR(&msg)) != NULL) &&
		  (cmptr->cmsg_len == CMSG_LEN(sizeof(int))) )
	{
		if (cmptr->cmsg_level != SOL_SOCKET)
		{
			syslog(LOG_CRIT,"control level != SOL_SOCKET");
			exit(-1);
		}
		if (cmptr->cmsg_type != SCM_RIGHTS)
		{
			syslog(LOG_CRIT,"control type != SCM_RIGHTS");
			exit(-1);
		}
		*recvfd = *((int *) CMSG_DATA(cmptr));
	}
	else
	{
		*recvfd = -1; /* descriptor not passed */
	}
	
/*	
#else
	if (msg.msg_accrightslen == sizeof(int))
	{
		*recvfd = newfd;
	}
	else
	{
		*recvfd = -1; /* descriptor not passed */
/*	}
	
#endif
*/
	return(n);
}
