/*  va_rand_gauss.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Generate random gaussian numbers, with standard deviation of one
and mean of 0.
*/

float va_rand_gauss(int seed)
{
	float x1, x2, w, y1, y2;
	while(1)
	{
		do 
		{
	  	x1 = 2.0 * va_rand_gen(seed) - 1.0;
		  x2 = 2.0 * va_rand_gen(2*seed) - 1.0;
  		w = x1 * x1 + x2 * x2;
		} while ( w >= 1.0 );

		w = sqrtf( (-2.0 * log( w ) ) / w );
		
		if (isfinite(w))
		{
			y1 = x1 * w;
			y2 = x2 * w;
			break;
		}
	}
	
	if (va_coin_toss(seed+(int)(y1+y2)))
	{
		return(y1);
	}
	else
	{
		return(-y2);
	}
}
