/*  va_io_connect.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

#ifndef MAX_RETRY
#define MAX_RETRY 5
#endif
/* Open a socket, file or fifo for reading / writting */
/* 
return values 
10 = socket unix read/write
20 = socket inet read/write
30 = fifo read
31 = fifo write
40 = FILE read
41 = FILE write
42 = FILE read/write
< 10 = error
*/

int va_io_connect(struct io_connection * con)
{
	int ret;
	int k;
	
	/* Check if already connected */
	if (con->connected == 1)
	{
		return(con->mode);
	}

	if ((con->socket == 1) && (con->fifo == 0) && (con->file == 0) ) //socket case
	{
		if (!strncmp(con->ip,"127.0.0.1",9))
		{
			if ( (con->connfd = socket(PF_LOCAL, SOCK_STREAM, 0)) < 0)
			{
				syslog(LOG_CRIT,"Error creating socket in va_io_connect() local=%d %s",
							con->local,strerror(errno));
				return(-1);
			}
						
			bzero(&(con->cliaddr_un), sizeof(con->cliaddr_un));
			con->cliaddr_un.sun_family = PF_LOCAL;
	
			strcpy(con->cliaddr_un.sun_path,con->filename);
		
			if( (connect(con->connfd, (struct sockaddr *) &(con->cliaddr_un), 
						sizeof(con->cliaddr_un))) <0)
			{
				syslog(LOG_CRIT,"Couldn't connect in va_io_connect: %d %s",
								con->number,strerror(errno));
				return(-1);
			}
			con->local = 1;
			con->connected = 1;
			con->mode = 10;
			return(10); //socket unix rw
		}
		else 
		{
			if ( (con->connfd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
			{
				syslog(LOG_CRIT,"Error creating socket in va_io_connect: %s",strerror(errno));
				return(-1);
			}
				
			bzero(&(con->cliaddr_in), sizeof(con->cliaddr_in));
			con->cliaddr_in.sin_family = PF_INET;
			con->cliaddr_in.sin_port = htons((uint16_t)atoi(con->port));
			if ((ret=inet_pton(PF_INET,con->ip,&(con->cliaddr_in.sin_addr))) < 1)
			{
				syslog(LOG_CRIT,"Error inet_pton() in va_io_connect %d: %s ",ret, strerror(errno));
				return(-1);
			}
			
			for (k=0; k< MAX_RETRY; k++)
			{
				if( (connect(con->connfd, (struct sockaddr *) &(con->cliaddr_in),
					 sizeof(con->cliaddr_in))) <0)
				{
					syslog(LOG_CRIT,"Error connect in va_io_connect: %s",strerror(errno));
					sleep(k+1/2);
					if (k >= MAX_RETRY-1)
					{
						return(-1);
					}
				}
				else
				{
					break;
				}
			}
			
		}
		con->local = 0;
		con->connected = 1;
		con->mode = 20;
		return(20); // socket inet rw
	}
	else if ((con->socket == 0) && (con->fifo == 1) && (con->file == 0) ) //fifo case
	{
		switch (con->io_flag)
		{
			case 0: 
			{
				if ((con->connfd = open(con->filename,O_RDONLY)) <0)
				{
					syslog(LOG_CRIT,"Couldn't open fifo %s for reading in va_io_connect",con->filename);
					return(-1);
				}
				con->connected = 1;
				con->mode = 30;
				return(30); //fifo read;
			}
			case 1:
			{
				if ((con->connfd = open(con->filename,O_WRONLY)) <0)
				{
					syslog(LOG_CRIT,"Couldn't open fifo %s for writting in va_io_connect",con->filename);
					return(-1);
				}
				con->connected = 1;
				con->mode = 31;
				return(31); //fifo write;
			}
		}
	}
	else if ((con->socket == 0) && (con->fifo == 0) && (con->file == 1) ) //fifo case
	{
		switch(con->io_flag)
		{
			case 0:
			{
				if( (con->file_ptr=fopen(con->filename,"r")) == NULL)
				{
					syslog(LOG_CRIT,"Couldn't open file %s for reading in va_io_connect: %s",con->filename,strerror(errno));
					return(-1);
				}
				con->connected = 1;
				con->mode = 40;
				return(40); //FILE read
			}
			case 1:
			{
				if( (con->file_ptr=fopen(con->filename,"w")) == NULL)
				{
					syslog(LOG_CRIT,"Couldn't open file %s for writting in va_io_connect: %s",con->filename,strerror(errno));
					return(-1);
				}
				con->connected = 1;
				con->mode = 41;
				return(41); //FILE write
			}
			case 2:
			{
				if( (con->file_ptr=fopen(con->filename,"rw")) == NULL)
				{
					syslog(LOG_CRIT,"Couldn't open file %s for r/w in va_io_connect: %s",con->filename,strerror(errno));
					return(-1);
				}
				con->connected = 1;
				con->mode = 42;
				return(42); //FILE rw
			}
		}
	}
	return(-1);
}
