/*  va_insert_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
if pos >= 0 then insert char_buffer in position "pos", else append
if pos > block->num, then allocate memory up to (pos+1), and insert in that position.

pack_vector is deleted
*/

void * va_insert_io_block(int pos, char *char_buffer, struct io_block * block)
{
	int k;
	struct io_block * temp_block = NULL;
	size_t len;
	
	if (block == NULL)
	{
		if (!(block = (struct io_block *)va_calloc_io_block(0,0,0,block)));
		{
			syslog(LOG_CRIT,"Error calloc_io_block in va_insert_io_block: %s",strerror(errno));
			return(NULL);
		}
	}
	
	ga_errno = 0;

	if (char_buffer != NULL)
	{	
		len = strlen(char_buffer);
		len ++;
	}
	else 
	{
		len = 5;	//NULL\0
	}
	
	len = (len > block->buffsize) ? len : block->buffsize;	
	
	if (pos > block->num) //expand and insert
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(pos+1,len, 0,temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			ga_errno = 10;
			return(NULL);
		}
		
		temp_block->num = pos+1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			if (block->char_vector[k] != NULL)
			{
				strncpy(temp_block->char_vector[k],block->char_vector[k],block->buffsize);
			}
			else
			{
				free(temp_block->char_vector[k]);
				temp_block->char_vector[k]=NULL;
			}
		}
		
		if (char_buffer != NULL)
		{
			strncpy(temp_block->char_vector[pos],char_buffer,len);
		}
		else 
		{
			free(temp_block->char_vector[pos]);
			temp_block->char_vector[pos] = NULL;
		}
	}
	else if ( (pos >= 0) && (pos < block->num) )//insert
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(block->num+1, len, 0,temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			return(NULL);
		}
		temp_block->num = block->num + 1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			if (k < pos)
			{
				if (block->char_vector[k] != NULL)
				{
					strncpy(temp_block->char_vector[k],block->char_vector[k],block->buffsize);
				}
				else
				{
					free(temp_block->char_vector[k]);
					temp_block->char_vector[k]=NULL;
				}
			}
			else
			{
				if (block->char_vector[k] != NULL)
				{
					strncpy(temp_block->char_vector[k+1],block->char_vector[k],block->buffsize);
				}
				else
				{
					free(temp_block->char_vector[k+1]);
					temp_block->char_vector[k+1]=NULL;
				}
			}
		}
		if (char_buffer != NULL)
		{
			strncpy(temp_block->char_vector[pos],char_buffer,len);
		}
		else
		{
			free(temp_block->char_vector[pos]);
			temp_block->char_vector[pos] = NULL;
		}
	}
	else if (pos < 0) // append
	{
		if (!(temp_block = (struct io_block *)va_calloc_io_block(block->num+1, len, 0, temp_block) ))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_insert_io_block()");
			ga_errno = 10;
			return(NULL);
		}
		temp_block->num = block->num + 1;
		temp_block->connfd = block->connfd;
		
		for (k = 0; k< block->num ; k ++)
		{
			if (block->char_vector[k] != NULL)
			{
				strncpy(temp_block->char_vector[k],block->char_vector[k],block->buffsize);
			}
			else
			{
				free(temp_block->char_vector[k]);
				temp_block->char_vector[k]=NULL;
			}
		}
		
		if (char_buffer != NULL)
		{
			strncpy(temp_block->char_vector[temp_block->num-1],char_buffer,len);
		}
		else
		{
			free(temp_block->char_vector[temp_block->num-1]);
			temp_block->char_vector[temp_block->num-1] = NULL;
		}
	}

	block = (struct io_block *)va_free_io_block(block);
	block = temp_block;
	return(temp_block);
}
