/*  va_free_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * va_free_io_block(struct io_block * block)
{
	int k;
	
	if (block == NULL)
	{
		return(NULL);
	}
	
	for (k=0; k < block->num; k++)
	{
		if (block->char_vector[k] != NULL)
		{
			free(block->char_vector[k]);
		}
	}
	if (block->char_vector != NULL)
	{
		free(block->char_vector);
	}
	
	if (block->pack_vector != NULL)
	{
		free(block->pack_vector);
	}
	free(block);
	block=NULL;
	return(block);
}
