/*  va_dwrite_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

#ifndef MAX_RETRY
#define MAX_RETRY 5
#endif

/* 
Writes block->pack_vector to block->connfd
*/
int va_dwrite_io_block(struct io_block * block)
{
	int k;
	char char_temp[BLOCKSIZE];

	/* First pack everything */
	if (!(block = (struct io_block *)va_pack_io_block(block, IO_SEP)));
	{
		syslog(LOG_CRIT,"Error va_pack_io_block() in va_dwrite_io_block");
		return(-1);
	}	
	
	/* Write packsize before everything else */
	sprintf(char_temp,"PACKSIZE=%d\0",block->packsize);
		
//	syslog(LOG_INFO,"write: %s",char_temp);
	
	k=0;
	while(k < MAX_RETRY)
	{
		if(va_writen(block->connfd,char_temp,BLOCKSIZE) < 1)
		{
			syslog(LOG_CRIT,"Error va_writen() in va_dwrite_io_block %s",strerror(errno));
			k+=1;
			continue;
		}
	
		/* Write everything else */
		if(va_writen(block->connfd,block->pack_vector,block->packsize) < 1)
		{
			syslog(LOG_CRIT,"Error va_writen() in va_dwrite_io_block %s",strerror(errno));
			k+=1;
			continue;
		}
		else
		{
			break;
		}
	}
	if (k >= MAX_RETRY)
	{
		return(-1);
	}
	return(0);
}
