/*  va_dread_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


/* 
Reads block->packsize then reads block->pack_vector
Since first input is the pack_size, block first points
to an empty char_vector and empty pack_vector.
*/

void * va_dread_io_block(struct io_block * block)
{
	char char_temp[BLOCKSIZE];
	
	/* First see if block is allocated */
	if (block == NULL)
	{
		syslog(LOG_INFO,"block unallocated, block->connfd missing");
		return(NULL);
	}
	
	/* Read PACKSIZE */	
	if(va_readn(block->connfd, char_temp ,BLOCKSIZE) < 0)
	{
		syslog(LOG_CRIT,"Error va_readn() in va_dread_io_block %s",strerror(errno));
		return(NULL);
	}
	if (strncmp(char_temp,"PACKSIZE",8))
	{
		syslog(LOG_CRIT,"Malformed block, couldn't read PACKSIZE in va_dread_io_block");
		return(NULL);
	}
	block->packsize = atoi(char_temp+9); 

//	syslog(LOG_INFO,"read: %s",char_temp);

	/* Now calloc pack_vector */	
	if (!(block = (struct io_block *)va_calloc_io_block(0, 0, block->packsize, block) ))
	{
		syslog(LOG_CRIT,"Error va_calloc_io_block() in va_dread_io_block()");
		return(NULL);
	}

	/* Read pack_vector */	
	if(va_readn(block->connfd, block->pack_vector, block->packsize) < 0)
	{
		syslog(LOG_CRIT,"Error va_readn() in va_dread_io_block %s",strerror(errno));
		va_free_io_block(block);
		return(NULL);
	}
	
	/* Unpack pack_vector */
	if (!(block = (struct io_block *)va_unpack_io_block(block, IO_SEP)))
	{
		syslog(LOG_CRIT,"Error va_unpack_io_block in va_dread_io_block: %s",strerror(errno));
		va_free_io_block(block);
		return(NULL);
	}
		
	return(block);
}
