/*  va_copy_io_block.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * va_copy_io_block(struct io_block *origin, struct io_block *destiny)
{
	int k;
	if (destiny == NULL)
	{
		if(!(destiny = (struct io_block *)va_calloc_io_block(origin->num, 
								origin->buffsize, origin->packsize, destiny)))
		{
			syslog(LOG_CRIT,"Error va_calloc_io_block() in va_copy_io_block(): %s", strerror(errno));
			return(NULL);
		}
	}
	else
	{
		if (destiny->num != 0)
		{
			syslog(LOG_CRIT,"Error, destiny already allocated");
			return(NULL);
		}
		else
		{
			if(!(destiny = (struct io_block *)va_calloc_io_block(origin->num, origin->buffsize, origin->packsize, destiny)))
			{
				syslog(LOG_CRIT,"Error va_calloc_io_block() in va_copy_io_block(): %s", strerror(errno));
				return(NULL);
			}
		}
	}
	destiny->connfd = origin->connfd;

	if (origin->packsize > 0)
	{
		strncpy(destiny->pack_vector, origin->pack_vector, origin->packsize);
	}
	else
	{
		destiny->pack_vector = NULL;
	}
	
	for (k=0; k< destiny->num; k++)
	{
		if (origin->char_vector[k] != NULL)
		{
			strcpy(destiny->char_vector[k], origin->char_vector[k]);
		}
		else
		{
			free(destiny->char_vector[k]);
			destiny->char_vector[k] == NULL;
		}
	}
	
	return(destiny);
}
