/*  va_calloc_io_block.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* 
Functions always set dimension according num, buffsize and packsize
Any data inside the structure before call is lost, except for connfd
*/

void * va_calloc_io_block(int num, int buffsize, int packsize, struct io_block * block)
{
	int k,l;
	int connfd = 0;
	
	if (block != NULL)
	{
		connfd = block->connfd;
		/* Free block */
		block = (struct io_block *)va_free_io_block(block);
	}
		
	/* Calloc block */
	if (!(block = (struct io_block *)calloc(1,sizeof(struct io_block)) ))
	{
		syslog(LOG_CRIT,"Error calloc io_block in va_calloc_io_block()");
		return(NULL);
	}
		
	block->connfd = connfd;
	block->num = num;
	block->buffsize = buffsize;
	block->packsize = packsize;
	
	/* Check if block->pack_vector is free */
	if (block->packsize > 0)
	{
		if (!(block->pack_vector = (char *)calloc(packsize,sizeof(char))))
		{
			syslog(LOG_CRIT,"Error calloc block->pack_vector in va_calloc_io_block(): %s",strerror(errno));
			block = va_free_io_block(block);
			return(NULL);
		}
	}
	else
	{
		block->pack_vector = NULL;
		block->packsize = 0;
	}
	
	if (block->num == 0)
	{
		block->char_vector = NULL;
		block->buffsize = 0;
	}
	else
	{
		if (!(block->char_vector = (char **)calloc(block->num,sizeof(char *)) ))
		{
			syslog(LOG_CRIT,"Error calloc block->char_vector in va_calloc_io_block(): %s", strerror(errno));
			free(block);
			return(NULL);
		}
		for (k =0 ; k< block->num; k++)
		{
			if (!(block->char_vector[k] = (char *)calloc(buffsize,sizeof(char)) ))
			{
				syslog(LOG_CRIT,"Error calloc block->char_vector[%d] in va_calloc_io_block()",k);
				for (l=0; l< k; l++)
				{
					free(block->char_vector[l]);
				}
				free(block->char_vector);
				free(block);
				return(NULL);
			}
		}
	}
	return(block);
}
