/*  nn_init_generator_f.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


/*
Return new neural network.

Requires: dimension, layers and type, all in the init_config structure

conf = nn_init_config structure
*/
#define INIT_FILE 		conf.init_filename
#define DIMENSION 		conf.dimension
#define TYPE 				conf.type
#define MOMENTUM 			conf.momentum
#define ALPHA 				conf.alpha
#define CONV_RATE 		conf.conv_rate
#define BIAS_CORR 		conf.bias_corr
#define DELTA_TYPE 		conf.delta_type
#define DELTA_INF 		conf.delta_inf
#define DELTA_DISP 		conf.delta_disp
#define BIAS 				conf.bias
#define DECAYMENT			conf.decayment

void * nn_init_generator_f(struct neural_net * result_net, struct nn_init_config * init_config)
{
	int k,l,m;
	int num_neuron = 0;
	int num_layer;
	int counter;
	int momentum;
	int dimension;
	int num_con;
	int type;
	int connfd;
	
	float range;
	float temp;

	int * num_elem_layer;
	
	struct nn_init_config conf;
	struct neural_net * net = NULL;
	struct neural_net * append_net = NULL;
		
	char char_buffer[BUFFSIZE];
	char char_temp[BUFFSIZE];
	
	
	nn_load_nn_init_config(0,char_buffer, &conf); 

	strcpy(conf.layers, init_config->layers);
	strcpy(conf.dimension, init_config->dimension);
	strcpy(conf.type, init_config->type);
	
	dimension = atoi(DIMENSION);
	type = atoi(TYPE);
	num_layer = n_load_num_values_vector(conf.layers);
	
	if (dimension > 16)
	{
		syslog(LOG_INFO,"Dimension too high, limit below 16");
		dimension = 16;
	}
	
	syslog(LOG_INFO,"num_layer = %d",num_layer);
	
	if (!(num_elem_layer = (int *)calloc(num_layer,sizeof(int)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc num_elem_layer");
		return(NULL);
	}
	
	n_load_int_vector(num_layer, num_elem_layer, conf.layers);
	
	
	num_neuron=0;
	for (k=0; k< num_layer; k++)
	{
		num_neuron += num_elem_layer[k];
	}
	

//	syslog(LOG_INFO,"num_layer: %d num_neuron: %d type: %d",num_layer,num_neuron,type);
	

	/* Memory allocation for net */
	if (!(net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net");
		return(NULL);
	}	

	if (!(net->neuron_array = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net->neuron_array");
		return(NULL);
	}	

	net->dimension = dimension;
	net->num_neuron = num_neuron;
	net->type = type;
	
	for (k= 0; k< num_neuron; k++)
	{
		if ( !strncmp(MOMENTUM,"rr",2) )
		{
			momentum = va_dice_toss(k,MAX_MOMENTUM);
		}
		else
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(*(net->neuron_array+k) = (struct neuron *)n_calloc_neuron(dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc_neuron %d",k);
			return(NULL);
		}
		net->neuron_array[k]->momentum = momentum;
	}
	

	/* Start setting coordinates */
	/* First, the easy ones */
	
	range=1.0/(num_layer-1);
	temp = 0.0;
	l=0;
	m=0;
	for (k=0 ; k< num_neuron; k++)
	{
		if (m == num_elem_layer[l])
		{
			temp += range;
			l += 1;
			m = 0;
		}
		net->neuron_array[k]->x_c[0] = temp;
		net->neuron_array[k]->range[0] = range;
		m += 1;
	}



	/* The hard part */

	for (k=0 ; k< num_neuron; k++)
	{
		for (l= 1; l< dimension; l++)
		{
			temp = va_rand_gen(l);
			net->neuron_array[k]->x_c[l] = temp; //set coordinates
			net->neuron_array[k]->range[l] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																				( temp*va_rand_gen(l) ) ; //set range
		}

		for (l= 0; l< net->neuron_array[k]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
//				temp = va_rand_gen(l)*atof(ALPHA);
				temp = atof(ALPHA);
			}
			else
			{
				temp = va_rand_gen(l)/2;
			}
			net->neuron_array[k]->alpha[l] = temp;
		}
		/* Block parameters */
		if ( net->neuron_array[k]->x_c[0] == 0.0)
		{
			net->neuron_array[k]->block = 12;		//lower
		}
		else if ( net->neuron_array[k]->x_c[0] == 1.0)
		{
			net->neuron_array[k]->block = 13;		//upper
		}
		else
		{
			net->neuron_array[k]->block = 11; 	//inner
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = va_rand_gen(k)/2;
		}
		net->neuron_array[k]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = va_coin_toss(k);
		}
		net->neuron_array[k]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = va_dice_toss(k,NUM_TYPE);
		}
		net->neuron_array[k]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_INF + MAX_DELTA_INF*va_rand_gen(k);
		}
		net->neuron_array[k]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		net->neuron_array[k]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		net->neuron_array[k]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		net->neuron_array[k]->decayment = temp;
	}
	
	/* For the result net */
	/* result_net should be NULL */
	if (result_net != NULL)
	{
		syslog(LOG_ERR,"result_net not free, memory leak");
	}
	/* Memory allocation for result_net */
	if (!(result_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc net");
		return(NULL);
	}	

	if (!(result_net->neuron_array = (struct neuron **)calloc(
																		*num_elem_layer,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc result_net->neuron_array");
		return(NULL);
	}	

	result_net->dimension = dimension;
	result_net->type = type;
	result_net->num_neuron = *num_elem_layer;

	for (k=0 ; k< *num_elem_layer; k++)
	{
		if (!(result_net->neuron_array[k] = (struct neuron *)n_calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc result_net->neuron_array[%d]",k);
			return(NULL);
		}
		n_copy_neuron(net->neuron_array[k],result_net->neuron_array[k]);
	}
	
	
	/* For the append_net */
	if (!(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc net");
		return(NULL);
	}	

	if (!(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		return(NULL);
	}	
	
	append_net->dimension = dimension;
	append_net->num_neuron = 1;
	append_net->type = type;

	for (k = *num_elem_layer; k< num_neuron; k++)
	{
		if (!(append_net->neuron_array[0] = (struct neuron *)n_calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array[0]");
			return(NULL);
		}
		n_copy_neuron(net->neuron_array[k],*(append_net->neuron_array) );
		
		/************************/
		/* VERY IMPORTANT VALUE */
		/************************/		
		append_net->neuron_array[0]->inner = 4;
//		append_net->neuron_array[0]->inner = 3;
		
		result_net = (struct neural_net *)nn_append_neuron(result_net,append_net);
		
		n_free_neuron( *(append_net->neuron_array) );
	}
	
	append_net->num_neuron = 0;

	/* Clean inner value */
	for (k= result_net->num_neuron-1; k+1; k--)
	{
		result_net->neuron_array[k]->inner = 0;
	}
	
	result_net->num_input = num_elem_layer[0];
	result_net->num_output = num_elem_layer[num_layer-1];
	
	syslog(LOG_INFO,"result_net: num_neuron=%d num_input=%d num_output=%d type=%d",
					result_net->num_neuron,result_net->num_input, result_net->num_output, 
					result_net->type);

	/* Free append_net, net */
	free(num_elem_layer);
	net = (struct neural_net *)nn_free_neural_net(net);
	append_net = (struct neural_net *)nn_free_neural_net(append_net);

	return(result_net);
}
