


/*
One type of ordering:
	-	Neurons in layer should be in any order (random generated coordinates), a chaotic mesh 
	
Maybe a less chaotic scheme would be tested in the future (employing line-code branch)

conf = nn_init_config structure
*/
#define INIT_FILE 		conf.init_filename
#define DIMENSION 		conf.dimension
#define TYPE 					conf.type
#define MOMENTUM 			conf.momentum
#define ALPHA 				conf.alpha
#define CONV_RATE 		conf.conv_rate
#define BIAS_CORR 		conf.bias_corr
#define DELTA_TYPE 		conf.delta_type
#define DELTA_INF 		conf.delta_inf
#define DELTA_DISP 		conf.delta_disp
#define BIAS 					conf.bias
#define DECAYMENT			conf.decayment
#define NUM_PARAM			13

int main(int argc, char * argv[])
{
	int k,l,m;
	int num_neuron = 0;
	int num_layer;
	int counter;
	int momentum;
	int dimension;
	int num_con;
	int type;
	int connfd;
	
	float range;
	float temp;

	int * num_elem_layer;
	
	struct nn_init_config conf;
	struct neural_net * net;
	struct neural_net * result_net;
	struct neural_net * append_net;
		
	char char_temp[BUFFSIZE];
	
	if (argc < 2)
	{
		printf("Too few arguments\nUsage:\n %s ",argv[0]);
		printf("init=init_file dimension=# type=# momentum=# alpha=# conv_rate=# bias_corr=# ");
		printf("delta_type=# delta_inf=# delta_disp=# bias=# decayment=# layers=num1:num2:...\n");
		return(1);
	}
	
	openlog("nn_init_gen",LOG_PID,LOG_LOCAL3);
	
	nn_load_nn_init_config(0,char_buffer, &conf); 
	for (k = 1; k< argc; k++)
	{
		nn_load_nn_init_config(1,argv[k], &conf);
	}

	dimension = atoi(DIMENSION);
	type = atoi(TYPE);
	num_layer = n_load_num_values_vector(conf.layers, BUFFSIZE);
	
	if (dimension > 16)
	{
		printf("Dimension too high, limit below 16\n");
		return(1);
	}
	
	syslog(LOG_INFO,"num_layer = %d",num_layer);
	
	if (!(num_elem_layer = (int *)calloc(num_layer,sizeof(int)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc num_elem_layer");
		return(1);
	}
	
	n_load_int_vector(num_layer, num_elem_layer, conf.layers);
	
	
	num_neuron=0;
	for (k=0; k< num_layer; k++)
	{
		num_neuron += num_elem_layer[k];
	}
	

//	syslog(LOG_INFO,"num_layer: %d num_neuron: %d type: %d",num_layer,num_neuron,type);
	

	/* Memory allocation for net */
	if (!(net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net");
		return(1);
	}	

	if (!(net->neuron_array = (struct neuron **)calloc(num_neuron,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_INFO,"Error calloc net->neuron_array");
		return(1);
	}	

	net->dimension = dimension;
	net->num_neuron = num_neuron;
	net->type = type;
	
	for (k= 0; k< num_neuron; k++)
	{
		if ( !strncmp(MOMENTUM,"rr",2) )
		{
			momentum = va_dice_toss(k,MAX_MOMENTUM);
		}
		else
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(*(net->neuron_array+k) = (struct neuron *)n_calloc_neuron(dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc_neuron %d",k);
			return(1);
		}
		net->neuron_array[k]->momentum = momentum;
	}
	

	/* Start setting coordinates */
	/* First, the easy ones */
	
	range=1.0/(num_layer-1);
	temp = 0.0;
	l=0;
	m=0;
	for (k=0 ; k< num_neuron; k++)
	{
		if (m == num_elem_layer[l])
		{
			temp += range;
			l += 1;
			m = 0;
		}
		net->neuron_array[k]->x_c[0] = temp;
		net->neuron_array[k]->range[0] = range;
		m += 1;
	}



	/* The hard part */

	for (k=0 ; k< num_neuron; k++)
	{
		for (l= 1; l< dimension; l++)
		{
			temp = va_rand_gen(l);
			net->neuron_array[k]->x_c[l] = temp; //set coordinates
			net->neuron_array[k]->range[l] = (temp > 0.5) ? (va_rand_gen(l) / 2) : 
																				( temp*va_rand_gen(l) ) ; //set range
		}

		for (l= 0; l< net->neuron_array[k]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
//				temp = va_rand_gen(l)*atof(ALPHA);
				temp = atof(ALPHA);
			}
			else
			{
				temp = va_rand_gen(l)/2;
			}
			net->neuron_array[k]->alpha[l] = temp;
		}
		/* Block parameters */
		if ( net->neuron_array[k]->x_c[0] == 0.0)
		{
			net->neuron_array[k]->block = 12;		//lower
		}
		else if ( net->neuron_array[k]->x_c[0] == 1.0)
		{
			net->neuron_array[k]->block = 13;		//upper
		}
		else
		{
			net->neuron_array[k]->block = 11; 	//inner
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = va_rand_gen(k)/2;
		}
		net->neuron_array[k]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = va_coin_toss(k);
		}
		net->neuron_array[k]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = va_dice_toss(k,NUM_TYPE);
		}
		net->neuron_array[k]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_INF + MAX_DELTA_INF*va_rand_gen(k);
		}
		net->neuron_array[k]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*va_rand_gen(k);
		}
		net->neuron_array[k]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		net->neuron_array[k]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = va_rand_gen(k);
		}
		net->neuron_array[k]->decayment = temp;
	}
	


	/* For the result net */
	/* Memory allocation for result_net */
	if (!(result_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc net");
		return(1);
	}	

	if (!(result_net->neuron_array = (struct neuron **)calloc(
																		*num_elem_layer,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc result_net->neuron_array");
		return(1);
	}	

	result_net->dimension = dimension;
	result_net->type = type;
	result_net->num_neuron = *num_elem_layer;

	for (k=0 ; k< *num_elem_layer; k++)
	{
		if (!(result_net->neuron_array[k] = (struct neuron *)n_calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc result_net->neuron_array[%d]",k);
			return(1);
		}
		n_copy_neuron(net->neuron_array[k],result_net->neuron_array[k]);
	}
	
	
	/* For the append_net */
	if (!(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc net");
		return(1);
	}	

	if (!(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron *)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		return(1);
	}	
	
	append_net->dimension = dimension;
	append_net->num_neuron = 1;
	append_net->type = type;


	
	for (k = *num_elem_layer; k< num_neuron; k++)
	{
		if (!(append_net->neuron_array[0] = (struct neuron *)n_calloc_neuron
					(dimension,net->neuron_array[k]->momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array[0]");
			return(1);
		}
		n_copy_neuron(net->neuron_array[k],*(append_net->neuron_array) );
		
		/************************/
		/* VERY IMPORTANT VALUE */
		/************************/		
		append_net->neuron_array[0]->inner = 4;
//		append_net->neuron_array[0]->inner = 3;
		
		result_net = (struct neural_net *)nn_append_neuron(result_net,append_net);
		
		n_free_neuron( *(append_net->neuron_array) );
	}


	
	/* Clean inner value */
	for (k= result_net->num_neuron-1; k+1; k--)
	{
		result_net->neuron_array[k]->inner = 0;
	}
	
	
	
	result_net->num_input = num_elem_layer[0];
	result_net->num_output = num_elem_layer[num_layer-1];
	
	syslog(LOG_INFO,"result_net: num_neuron=%d num_input=%d num_output=%d type=%d",
					result_net->num_neuron,result_net->num_input, result_net->num_output, 
					result_net->type);

	/* write to fifo */
	if (!strncmp(INIT_FILE,"fifo_",5))
	{
		if( (connfd = open(INIT_FILE, O_WRONLY, 0)) <0)
		{
			syslog(LOG_CRIT,"Error openning %s for writting: %s",INIT_FILE,strerror(errno));
			return(1);
		}
		nn_dwrite_neural_net(result_net, connfd);
	}
	else
	{
		nn_fwrite_neural_net(result_net, INIT_FILE);
	}
	exit(0);
}
