/*  nn_copy_neural_net.c */

/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata*/

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*** Copy the contents of one neuron array into another ***/
//Assuming destiny is already clean
void * nn_copy_neural_net(struct neural_net * origin, struct neural_net * destiny)
{
	int k,l;
	int num_neuron = origin->num_neuron;
	int dimension;
	
	dimension = origin->dimension;
	
	if ( destiny == NULL ) 
	{
		if ( !(destiny = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
		{
			syslog(LOG_CRIT,"Couldn't calloc destiny in copy_neuron_array()");
			return(NULL);
		}
		if (num_neuron > 0)
		{
			if ( !(destiny->neuron_array = (struct neuron **)calloc(num_neuron, 
						sizeof(struct neuron *)) ))
			{
				syslog(LOG_CRIT,"Couldn't calloc destiny in copy_neuron_array()");
				free(destiny);
				return(NULL);
			}
		}
		else 
		{
			destiny->neuron_array = NULL;
		}
	}
	else 
	{
		syslog(LOG_CRIT,"Error destiny still asigned");
		return(destiny);
	}
	
	/*** Memory allocation ***/
	for (k=0; k< num_neuron; k++)
	{
		if( !(destiny->neuron_array[k] = (struct neuron *)n_calloc_neuron(
					dimension, origin->neuron_array[k]->momentum, origin->neuron_array[k]->num_con) ))
		{
			syslog(LOG_CRIT,"Error calloc destiny->neuron_array[%d]",k);
			free(destiny->neuron_array);
			free(destiny);
			return(NULL);
		}
	}
	
	//couldn't use memcpy
	for (k=0; k< num_neuron; k++)
	{
		n_copy_neuron(origin->neuron_array[k],destiny->neuron_array[k]);
	}
	destiny->num_neuron = origin->num_neuron;
	destiny->num_input = origin->num_input;
	destiny->num_output = origin->num_output;
	destiny->age = origin->age;
	destiny->dimension = origin->dimension;
	destiny->type = origin->type;

	return(destiny);
}
