/*  ga_service_server_header.h */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/*  This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef GA_SERVICE_SERVER_HEADER_H
#define GA_SERVICE_SERVER_HEADER_H

/* global config structure */
extern struct ga_server_config conf;

/* global ga_errno */
extern int ga_errno;

/* global alarm time */
extern int time_wait;

/* global exit_flag for sigterm */
extern int exit_flag;

/* global num_provider */
extern int num_provider;

/* global curr_gen for service provider */
extern int current_generation;

/* global generations for service provider */
extern int generations;

/* global pat_generation for co-evolution */
extern int pat_generation;

/* global client index for service provider */
extern struct ga_service_client_index *client_index;

/* global pattern index for service provider */
extern struct ga_pat_index * pat_index;

/* global pattern index for service provider */
extern int num_pat_index;

/* global mutex for client_index in service_provider */
extern pthread_mutex_t index_mutex;

/* global conditional variable for client_index */
extern pthread_cond_t index_cond;

/* global mutex for current_generation variable */
extern pthread_mutex_t generation_mutex;

/* global conditional variable for current_generation variable */
extern pthread_cond_t generation_cond;

/* global mutex for pat_generation variable */
extern pthread_mutex_t pat_mutex;

/* global conditional variable for pat_generation variable */
extern pthread_cond_t pat_cond;

#endif
