/*  ga_service_listen_t.c */
/*  Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Listens for incoming connections and manages client_index */
/* Provides service for an incoming group after
/* Requires:

- global struct ga_service_client_index *client_index
- global int exit_flag
*/

/* Elements after connect should be in service_server, since a single thread for
listen is created */

/* Global variables and mutexes */
#include "ga_service_server_header.h"


void * ga_service_listen_t(void * arg)
{

int listenfd;
int  *connptr;

struct ga_service_listen_thread_param * param = NULL;
struct ga_server_config * conf = NULL;

struct ga_service_accept_client_param accept_param ;

struct sockaddr client_addr;

socklen_t addrlen;
pthread_t tid;

/* Set basic structure values */
param = (struct ga_service_listen_thread_param *)arg;
conf = param->conf;
listenfd = *(param->listenfd);

addrlen = sizeof(struct sockaddr);

syslog(LOG_INFO,"ga_service_listen_t thread Ready for accepting connections");

while (!exit_flag)
{
	/* Malloc connptr */
	if (!(connptr = (int *)malloc(sizeof(int)) ))
	{
		syslog(LOG_CRIT,"Error malloc connptr in ga_sevice_listen_t : %s",strerror(errno));
		pthread_exit((void *)-1);
	}
	
	/* Accept connection */
	if ( (*connptr = accept(listenfd, &client_addr, &addrlen)) <0 )
	{	
		if (errno == EINTR)
		{
			continue;
		}
		else
		{
			syslog(LOG_CRIT,"Error accept() in ga_sevice_listen_t: %s",strerror(errno));
			pthread_exit((void *)-1);
		}
	}
	
	/* Set ga_service_index_manager_param */
	syslog(LOG_INFO,"connptr=%d", *connptr);
	
	accept_param.connptr = connptr;
	
	/* Call index accept client thread  */
	if (pthread_create(&tid, NULL, &ga_service_accept_client_t, 
				(void *)(&accept_param)) != 0)
	{
		syslog(LOG_CRIT,"Error pthread_create ga_service_accept_client_t in ga_sevice_listen_t : %s",strerror(errno));
		pthread_exit((void *)-1);
	}
}

pthread_exit((void *)0);
}
