/*  ga_server.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
		|----------|
		|  master  |
		|----------|
	     /      \
		 /        \
 command		service -->to other command server
    |       
    |
 service --> to other command server

*/

/*
FIXME 17.12.2005 waitpid
*/

#include "my_header.h"
#include "aux_prot.h"

/* Global config structure */
struct ga_server_config conf;

int main(int argc, char * argv[])
{
int servicefd;
int jump_ret;
int run;
int retry;
int status;

char config_filename[BUFFSIZE];

pid_t command_pid = 0;
pid_t service_pid = 0;
pid_t pid = 0;

socklen_t serlen;

struct sigaction sig_usr1_action;

/* Fork and daemonize */
if( (pid = fork()) <0 )
{
	printf("Error fork: %s\n",strerror(errno));
}
else if (pid != 0)
{
	printf("ga_server started pid=%d\n",getpid());
	exit(0);
}

setsid();
openlog("ga_server",LOG_PID,LOG_LOCAL0);
syslog(LOG_INFO,"*********** Daemon started ***********");


/* Check if another config file is set */
if (argc == 1)
{
	sprintf(config_filename,"ga_server_config\0");
}
else
{
	strcpy(config_filename,argv[1]);
}

/* Load config file */
if ((run = ga_server_load_config(&conf, config_filename)) < 0)
{
	syslog(LOG_CRIT,"Error loading ga_server_config, exiting");
	return(1);
}


/*********** COMMAND SERVER *************/
if ((command_pid = fork()) <0)
{
	syslog(LOG_CRIT,"Error fork() command_server");
	return(1);
}

if (command_pid == 0)
{
	setsid();
	if (!(ga_command_server(&conf)))
	{
		syslog(LOG_CRIT,"Error ga_command_server(): %s", strerror(errno));
		return(1);
	}
	exit(0);
}

/********** SERVICE SERVER ***************/
if (conf.run == 1)
{
	if ((service_pid = fork())< 0)
	{
		syslog(LOG_CRIT,"Error fork() service_server");
		return(1);
	}
	if (service_pid == 0)
	{	
		setsid();
		if (!(ga_service_server(&conf)))
		{
			syslog(LOG_CRIT,"Error ga_service_server(): %s", strerror(errno));
			return(1);
		}
		exit(0);
	}	
}


//syslog(LOG_INFO,"***** Exiting *****");
exit(0);
}

