/*  ga_prov_mate.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Select a parent pair */

int ga_prov_mate(int parents[2], struct ga_service_client_index * index)
{
	int k;
	double * fitness;
	
	/* Check if parents are NULL */
/*
	if (parents == NULL)
	{
		if (!(parents = (int **)calloc(index->num_client,sizeof(int *)) ))
		{
			syslog(LOG_CRIT,"Error calloc parents in ga_prov_mate():%s", strerror(errno));
			return(-1);
		}
		for (k=0; k< index->num_client; k++)
		{
			if (!(parents[k] = (int *)calloc(2, sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Error calloc parents[%d] in ga_prov_mate():%s", k, strerror(errno));
				return(-1);
			}
		}
	}
*/
	
	/* Set fitness vector for roulette */
	if (!(fitness = (double *)calloc(index->num_client,sizeof(double))))
	{
		syslog(LOG_CRIT,"Error calloc fitness in ga_prov_mate(): %s", strerror(errno));
		return(-1);
	}
	for (k= 0 ; k< index->num_client; k++)
	{
		if (index->clients[k]->command == 3) // Only tested elements
		{
			fitness[k] = index->clients[k]->fitness;
		}
		else	// Other elements doesn't mate
		{
			fitness[k] = 0;
		}
	}
	
	if ( (parents[0] = va_roulette(index->num_client,fitness)) < 0)
	{
		return(-1);
	}
	if ( (parents[1] = va_roulette(index->num_client,fitness)) < 0)
	{
		return(-1);
	}
	
/*	
	while (parents[1] == parents[0]) // No clonning
	{
		if ( (parents[va_coin_toss(k)] = va_roulette(index->num_client,fitness)) < 0)
		{
			return(-1);
		}
	}
*/
	return(0);
}
