/*  ga_prov_isolate_region.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* remove connections between inner an outer zone */
/* 
Zone are marked by a zero or one value in inner parameter 

Return 1 on success, 0 on fail
*/
int ga_prov_isolate_region(struct neural_net * net)
{
	int k,l,m;
	int new_num_con;
	int counter;
	int * marked;

	struct connection ** temp_con;
	
	/* Sort net just in case */
	if (!nn_sort_neuron_array(net))
	{
		syslog(LOG_ERR,"Error sorting net in ga_prov_isolate_region()");
	}
	
	/* Memory allocation for marked vector */
	if (!(marked = (int *)calloc(net->num_neuron,sizeof(int))))
	{
		syslog(LOG_CRIT,"Error calloc marked vector in ga_prov_isolate_region(): %s",strerror(errno));
		return(0);
	}
	
	/* Check for connections */
	for (k = 1; k< net->num_neuron; k++)
	{
		/* Clean vars*/
		counter = 0;
		bzero(marked,net->num_neuron*sizeof(int));
		/* Check beneath neurons */
		for (l = 0; l< k; l++)
		{
			if ((net->neuron_array[l]->inner + net->neuron_array[k]->inner) == 1) //neurons in different regions
			{			
				if (n_is_above(net->neuron_array[l],net->neuron_array[k],NULL))
				{
					if (n_is_connected(net->neuron_array[l],net->neuron_array[k],NULL))
					{
						counter += 0;
						marked[l] = 1;
					}
				}
			}
		}
		
		if (counter)
		{
			/* Memory reserve of temp_con */
			new_num_con = net->neuron_array[k]->num_con - counter;
			if (!(temp_con = (struct connection **)malloc(new_num_con*sizeof(struct connection *) )))
			{
				syslog(LOG_CRIT,"Error malloc temp_con in ga_prov_isolate_region(): %s",strerror(errno));
				return(0);
			}
			
			/* Copy non severed connections */
			m = 0;
			for (l = 0; l< k; l++)
			{
				if (!marked[l])
				{
					temp_con[m] = net->neuron_array[k]->con[l];
					m += 1;
				}
				else
				{
					if (net->neuron_array[k]->momentum > 0)
					{
						free(net->neuron_array[k]->con[l]->delta_weight);
					}
					free(net->neuron_array[k]->con[l]->con_x);
					free(net->neuron_array[k]->con[l]);
				}
			}
			
			/* Copy temp_con to con */
			free(net->neuron_array[k]->con);
			net->neuron_array[k]->con = temp_con;
		}
	}
	
	return(1);
}
