/* ga_prov_inner_neuron.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/* Mark neurons inside region */

int ga_prov_inner_neuron(struct neural_net *net, float *origin, float *radius)
{
	int k, l;
	
	int counter;
	
	float * upper;
	float * lower;
	
	/* Memory reserve upper, lower */
	if (!(upper = (float *)calloc(net->dimension, sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc upper in ga_prov_inner_neuron(): %s", strerror(errno));
		return(-1);
	}
	if (!(lower = (float *)calloc(net->dimension, sizeof(float)) ))
	{
		syslog(LOG_CRIT,"Error calloc lower in ga_prov_inner_neuron(): %s", strerror(errno));
		return(-1);
	}

	/* Set upper, lower values with 1% of tolerance */
	for (k=0; k< net->dimension; k++)
	{
		upper[k] =  (origin[k] + radius[k])*1.01;
		lower[k] =  (origin[k] - radius[k])*1.01;
	}
	

	/* Check if neuron is inside region */
	for (k=net->num_neuron-1;k+1;k--)
	{
		counter = 0;
		for (l=0; l< net->dimension; l++)
		{
			if ((net->neuron_array[k]->x_c[l] > upper[k]) || 
				(net->neuron_array[k]->x_c[l] < lower[k]) )
			{
				counter = 1;
				break;
			}
		}
		if (!counter)
		{
			net->neuron_array[k]->inner = 1;
		}
		else
		{
			net->neuron_array[k]->inner = 0;
		}
	}
	
	return(0);	
}
