/*  ga_free_pat_index.c */
/* 	Copyright 2004-2006 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag-2.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * ga_free_pat_index(struct ga_pat_index *index)
{
	int k,l,m;
	
	if (index == NULL)
	{
		return(NULL);
	}
	
	for (k=0; k< index->num_cat; k++)
	{
		for (l=0; l< index->cat[k]->num_pat; l++)
		{
			for (m=0 ; m< index->cat[k]->pat[l]->num_input; m++)
			{
				if (index->cat[k]->pat[l]->in_pattern[m] != NULL)
				{
					free(index->cat[k]->pat[l]->in_pattern[m]);
				}
			}
			for (m=0 ; m< index->cat[k]->pat[l]->num_output; m++)
			{
				if (index->cat[k]->pat[l]->out_pattern[m] != NULL)
				{
					free(index->cat[k]->pat[l]->out_pattern[m]);
				}
			}
			switch (index->group_mode)
			{
				case 1: // group by column
				{
					if (*(index->cat[k]->pat[l]->pat_fitness) != NULL)
					{
						free(*(index->cat[k]->pat[l]->pat_fitness));
					}
					break;
				}
				case 3: // group everything
				{
					if (*(index->cat[k]->pat[l]->pat_fitness) != NULL)
					{
						free(*(index->cat[k]->pat[l]->pat_fitness));
					}
					break;
				}
				default:
				{
					for (m=0 ; m< index->cat[k]->pat[l]->num_output; m++)
					{
						if (index->cat[k]->pat[l]->pat_fitness[m] != NULL)
						{
							free(index->cat[k]->pat[l]->pat_fitness[m]);
						}
					}
					break;
				}
			}
			
			if (index->cat[k]->pat[l]->out_pattern != NULL)
			{
				free(index->cat[k]->pat[l]->out_pattern);
			}
			if (index->cat[k]->pat[l]->in_pattern != NULL)
			{
				free(index->cat[k]->pat[l]->in_pattern);
			}
			if (index->cat[k]->pat[l]->pat_fitness != NULL)
			{
				free(index->cat[k]->pat[l]->pat_fitness);
			}
		}
		if (index->cat[k] != NULL)
		{
			free(index->cat[k]);
		}
	}
	if (index->cat != NULL)
	{
		free(index->cat);
	}
	free(index);
	index = NULL;
	return(index);
}
