!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRj0f0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(38,11)
      V(2)=ExZpE*r1x2Z*VRR1(38,11)
      V(3)=r1x2Z*VRR0(38,12)
      V(4)=ExZpE*r1x2Z*VRR1(38,12)
      V(5)=r1x2Z*VRR0(38,13)
      V(6)=ExZpE*r1x2Z*VRR1(38,13)
      V(7)=r1x2Z*VRR0(38,14)
      V(8)=ExZpE*r1x2Z*VRR1(38,14)
      V(9)=r1x2Z*VRR0(38,15)
      V(10)=ExZpE*r1x2Z*VRR1(38,15)
      V(11)=r1x2Z*VRR0(38,16)
      V(12)=ExZpE*r1x2Z*VRR1(38,16)
      V(13)=r1x2Z*VRR0(38,17)
      V(14)=ExZpE*r1x2Z*VRR1(38,17)
      V(15)=r1x2Z*VRR0(38,18)
      V(16)=ExZpE*r1x2Z*VRR1(38,18)
      V(17)=r1x2Z*VRR0(38,19)
      V(18)=ExZpE*r1x2Z*VRR1(38,19)
      V(19)=r1x2Z*VRR0(38,20)
      V(20)=ExZpE*r1x2Z*VRR1(38,20)
      V(21)=r1x2Z*VRR0(39,11)
      V(22)=ExZpE*r1x2Z*VRR1(39,11)
      V(23)=HfxZpE*VRR1(60,5)
      V(24)=r1x2Z*VRR0(39,12)
      V(25)=ExZpE*r1x2Z*VRR1(39,12)
      V(26)=HfxZpE*VRR1(60,6)
      V(27)=2.D0*V(26)
      V(28)=r1x2Z*VRR0(39,13)
      V(29)=ExZpE*r1x2Z*VRR1(39,13)
      V(30)=HfxZpE*VRR1(60,7)
      V(31)=r1x2Z*VRR0(39,14)
      V(32)=ExZpE*r1x2Z*VRR1(39,14)
      V(33)=r1x2Z*VRR0(39,15)
      V(34)=ExZpE*r1x2Z*VRR1(39,15)
      V(35)=HfxZpE*VRR1(60,8)
      V(36)=r1x2Z*VRR0(39,16)
      V(37)=ExZpE*r1x2Z*VRR1(39,16)
      V(38)=HfxZpE*VRR1(60,9)
      V(39)=r1x2Z*VRR0(39,17)
      V(40)=ExZpE*r1x2Z*VRR1(39,17)
      V(41)=r1x2Z*VRR0(39,18)
      V(42)=ExZpE*r1x2Z*VRR1(39,18)
      V(43)=HfxZpE*VRR1(60,10)
      V(44)=r1x2Z*VRR0(39,19)
      V(45)=ExZpE*r1x2Z*VRR1(39,19)
      V(46)=r1x2Z*VRR0(39,20)
      V(47)=ExZpE*r1x2Z*VRR1(39,20)
      V(48)=r1x2Z*VRR0(44,11)
      V(49)=3.D0*V(48)
      V(50)=ExZpE*r1x2Z*VRR1(44,11)
      V(51)=-3.D0*V(50)
      V(52)=r1x2Z*VRR0(44,12)
      V(53)=3.D0*V(52)
      V(54)=ExZpE*r1x2Z*VRR1(44,12)
      V(55)=-3.D0*V(54)
      V(56)=r1x2Z*VRR0(44,13)
      V(57)=3.D0*V(56)
      V(58)=ExZpE*r1x2Z*VRR1(44,13)
      V(59)=-3.D0*V(58)
      V(60)=HfxZpE*VRR1(66,7)
      V(61)=r1x2Z*VRR0(44,14)
      V(62)=3.D0*V(61)
      V(63)=ExZpE*r1x2Z*VRR1(44,14)
      V(64)=-3.D0*V(63)
      V(65)=r1x2Z*VRR0(44,15)
      V(66)=3.D0*V(65)
      V(67)=ExZpE*r1x2Z*VRR1(44,15)
      V(68)=-3.D0*V(67)
      V(69)=r1x2Z*VRR0(44,16)
      V(70)=3.D0*V(69)
      V(71)=ExZpE*r1x2Z*VRR1(44,16)
      V(72)=-3.D0*V(71)
      V(73)=r1x2Z*VRR0(44,17)
      V(74)=3.D0*V(73)
      V(75)=ExZpE*r1x2Z*VRR1(44,17)
      V(76)=-3.D0*V(75)
      V(77)=r1x2Z*VRR0(44,18)
      V(78)=3.D0*V(77)
      V(79)=ExZpE*r1x2Z*VRR1(44,18)
      V(80)=-3.D0*V(79)
      V(81)=HfxZpE*VRR1(66,10)
      V(82)=r1x2Z*VRR0(44,19)
      V(83)=3.D0*V(82)
      V(84)=ExZpE*r1x2Z*VRR1(44,19)
      V(85)=-3.D0*V(84)
      V(86)=r1x2Z*VRR0(44,20)
      V(87)=3.D0*V(86)
      V(88)=ExZpE*r1x2Z*VRR1(44,20)
      V(89)=-3.D0*V(88)
      V(90)=HfxZpE*VRR1(67,5)
      V(91)=r1x2Z*VRR0(45,12)
      V(92)=ExZpE*r1x2Z*VRR1(45,12)
      V(93)=HfxZpE*VRR1(67,6)
      V(94)=2.D0*V(93)
      V(95)=r1x2Z*VRR0(45,13)
      V(96)=ExZpE*r1x2Z*VRR1(45,13)
      V(97)=HfxZpE*VRR1(67,7)
      V(98)=r1x2Z*VRR0(45,15)
      V(99)=ExZpE*r1x2Z*VRR1(45,15)
      V(100)=HfxZpE*VRR1(67,8)
      V(101)=r1x2Z*VRR0(45,16)
      V(102)=ExZpE*r1x2Z*VRR1(45,16)
      V(103)=HfxZpE*VRR1(67,9)
      V(104)=r1x2Z*VRR0(45,17)
      V(105)=ExZpE*r1x2Z*VRR1(45,17)
      V(106)=r1x2Z*VRR0(45,18)
      V(107)=ExZpE*r1x2Z*VRR1(45,18)
      V(108)=HfxZpE*VRR1(67,10)
      V(109)=r1x2Z*VRR0(45,19)
      V(110)=ExZpE*r1x2Z*VRR1(45,19)
      V(111)=r1x2Z*VRR0(47,11)
      V(112)=ExZpE*r1x2Z*VRR1(47,11)
      V(113)=r1x2Z*VRR0(47,12)
      V(114)=ExZpE*r1x2Z*VRR1(47,12)
      V(115)=r1x2Z*VRR0(47,13)
      V(116)=ExZpE*r1x2Z*VRR1(47,13)
      V(117)=r1x2Z*VRR0(47,14)
      V(118)=ExZpE*r1x2Z*VRR1(47,14)
      V(119)=r1x2Z*VRR0(47,15)
      V(120)=ExZpE*r1x2Z*VRR1(47,15)
      V(121)=r1x2Z*VRR0(47,16)
      V(122)=ExZpE*r1x2Z*VRR1(47,16)
      V(123)=r1x2Z*VRR0(47,17)
      V(124)=ExZpE*r1x2Z*VRR1(47,17)
      V(125)=r1x2Z*VRR0(47,18)
      V(126)=ExZpE*r1x2Z*VRR1(47,18)
      V(127)=r1x2Z*VRR0(47,19)
      V(128)=ExZpE*r1x2Z*VRR1(47,19)
      V(129)=r1x2Z*VRR0(47,20)
      V(130)=ExZpE*r1x2Z*VRR1(47,20)
      V(131)=r1x2Z*VRR0(48,11)
      V(132)=3.D0*V(131)
      V(133)=ExZpE*r1x2Z*VRR1(48,11)
      V(134)=-3.D0*V(133)
      V(135)=r1x2Z*VRR0(48,12)
      V(136)=3.D0*V(135)
      V(137)=ExZpE*r1x2Z*VRR1(48,12)
      V(138)=-3.D0*V(137)
      V(139)=r1x2Z*VRR0(48,13)
      V(140)=3.D0*V(139)
      V(141)=ExZpE*r1x2Z*VRR1(48,13)
      V(142)=-3.D0*V(141)
      V(143)=HfxZpE*VRR1(71,7)
      V(144)=r1x2Z*VRR0(48,14)
      V(145)=3.D0*V(144)
      V(146)=ExZpE*r1x2Z*VRR1(48,14)
      V(147)=-3.D0*V(146)
      V(148)=r1x2Z*VRR0(48,15)
      V(149)=3.D0*V(148)
      V(150)=ExZpE*r1x2Z*VRR1(48,15)
      V(151)=-3.D0*V(150)
      V(152)=r1x2Z*VRR0(48,16)
      V(153)=3.D0*V(152)
      V(154)=ExZpE*r1x2Z*VRR1(48,16)
      V(155)=-3.D0*V(154)
      V(156)=r1x2Z*VRR0(48,17)
      V(157)=3.D0*V(156)
      V(158)=ExZpE*r1x2Z*VRR1(48,17)
      V(159)=-3.D0*V(158)
      V(160)=r1x2Z*VRR0(48,18)
      V(161)=3.D0*V(160)
      V(162)=ExZpE*r1x2Z*VRR1(48,18)
      V(163)=-3.D0*V(162)
      V(164)=HfxZpE*VRR1(71,10)
      V(165)=r1x2Z*VRR0(48,19)
      V(166)=3.D0*V(165)
      V(167)=ExZpE*r1x2Z*VRR1(48,19)
      V(168)=-3.D0*V(167)
      V(169)=r1x2Z*VRR0(48,20)
      V(170)=3.D0*V(169)
      V(171)=ExZpE*r1x2Z*VRR1(48,20)
      V(172)=-3.D0*V(171)
      V(173)=HfxZpE*VRR1(72,5)
      V(174)=r1x2Z*VRR0(49,12)
      V(175)=ExZpE*r1x2Z*VRR1(49,12)
      V(176)=HfxZpE*VRR1(72,6)
      V(177)=2.D0*V(176)
      V(178)=r1x2Z*VRR0(49,13)
      V(179)=ExZpE*r1x2Z*VRR1(49,13)
      V(180)=HfxZpE*VRR1(72,7)
      V(181)=r1x2Z*VRR0(49,15)
      V(182)=ExZpE*r1x2Z*VRR1(49,15)
      V(183)=HfxZpE*VRR1(72,8)
      V(184)=2.D0*V(183)
      V(185)=r1x2Z*VRR0(49,16)
      V(186)=ExZpE*r1x2Z*VRR1(49,16)
      V(187)=HfxZpE*VRR1(72,9)
      V(188)=r1x2Z*VRR0(49,17)
      V(189)=ExZpE*r1x2Z*VRR1(49,17)
      V(190)=r1x2Z*VRR0(49,18)
      V(191)=ExZpE*r1x2Z*VRR1(49,18)
      V(192)=HfxZpE*VRR1(72,10)
      V(193)=r1x2Z*VRR0(49,19)
      V(194)=ExZpE*r1x2Z*VRR1(49,19)
      V(195)=HfxZpE*VRR1(73,5)
      V(196)=2.D0*V(187)
      V(197)=r1x2Z*VRR0(49,11)
      V(198)=3.D0*V(197)
      V(199)=ExZpE*r1x2Z*VRR1(49,11)
      V(200)=-3.D0*V(199)
      V(201)=3.D0*V(174)
      V(202)=-3.D0*V(175)
      V(203)=3.D0*V(178)
      V(204)=-3.D0*V(179)
      V(205)=r1x2Z*VRR0(49,14)
      V(206)=3.D0*V(205)
      V(207)=ExZpE*r1x2Z*VRR1(49,14)
      V(208)=-3.D0*V(207)
      V(209)=3.D0*V(181)
      V(210)=-3.D0*V(182)
      V(211)=3.D0*V(185)
      V(212)=-3.D0*V(186)
      V(213)=3.D0*V(188)
      V(214)=-3.D0*V(189)
      V(215)=3.D0*V(190)
      V(216)=-3.D0*V(191)
      V(217)=3.D0*V(193)
      V(218)=-3.D0*V(194)
      V(219)=HfxZpE*VRR1(73,10)
      V(220)=r1x2Z*VRR0(49,20)
      V(221)=3.D0*V(220)
      V(222)=ExZpE*r1x2Z*VRR1(49,20)
      V(223)=-3.D0*V(222)
      V(224)=r1x2Z*VRR0(50,11)
      V(225)=ExZpE*r1x2Z*VRR1(50,11)
      V(226)=r1x2Z*VRR0(50,12)
      V(227)=ExZpE*r1x2Z*VRR1(50,12)
      V(228)=r1x2Z*VRR0(50,13)
      V(229)=ExZpE*r1x2Z*VRR1(50,13)
      V(230)=r1x2Z*VRR0(50,14)
      V(231)=ExZpE*r1x2Z*VRR1(50,14)
      V(232)=r1x2Z*VRR0(50,15)
      V(233)=ExZpE*r1x2Z*VRR1(50,15)
      V(234)=r1x2Z*VRR0(50,16)
      V(235)=ExZpE*r1x2Z*VRR1(50,16)
      V(236)=r1x2Z*VRR0(50,17)
      V(237)=ExZpE*r1x2Z*VRR1(50,17)
      V(238)=r1x2Z*VRR0(50,18)
      V(239)=ExZpE*r1x2Z*VRR1(50,18)
      V(240)=r1x2Z*VRR0(50,19)
      V(241)=ExZpE*r1x2Z*VRR1(50,19)
      V(242)=r1x2Z*VRR0(50,20)
      V(243)=ExZpE*r1x2Z*VRR1(50,20)
      V(244)=r1x2Z*VRR0(51,11)
      V(245)=ExZpE*r1x2Z*VRR1(51,11)
      V(246)=HfxZpE*VRR1(75,5)
      V(247)=r1x2Z*VRR0(51,12)
      V(248)=ExZpE*r1x2Z*VRR1(51,12)
      V(249)=HfxZpE*VRR1(75,6)
      V(250)=r1x2Z*VRR0(51,13)
      V(251)=ExZpE*r1x2Z*VRR1(51,13)
      V(252)=HfxZpE*VRR1(75,7)
      V(253)=r1x2Z*VRR0(51,14)
      V(254)=ExZpE*r1x2Z*VRR1(51,14)
      V(255)=r1x2Z*VRR0(51,15)
      V(256)=ExZpE*r1x2Z*VRR1(51,15)
      V(257)=HfxZpE*VRR1(75,8)
      V(258)=2.D0*V(257)
      V(259)=r1x2Z*VRR0(51,16)
      V(260)=ExZpE*r1x2Z*VRR1(51,16)
      V(261)=HfxZpE*VRR1(75,9)
      V(262)=r1x2Z*VRR0(51,17)
      V(263)=ExZpE*r1x2Z*VRR1(51,17)
      V(264)=r1x2Z*VRR0(51,18)
      V(265)=ExZpE*r1x2Z*VRR1(51,18)
      V(266)=HfxZpE*VRR1(75,10)
      V(267)=r1x2Z*VRR0(51,19)
      V(268)=ExZpE*r1x2Z*VRR1(51,19)
      V(269)=r1x2Z*VRR0(51,20)
      V(270)=ExZpE*r1x2Z*VRR1(51,20)
      V(271)=HfxZpE*VRR1(76,5)
      V(272)=r1x2Z*VRR0(52,12)
      V(273)=2.D0*V(272)
      V(274)=ExZpE*r1x2Z*VRR1(52,12)
      V(275)=-2.D0*V(274)
      V(276)=HfxZpE*VRR1(76,6)
      V(277)=r1x2Z*VRR0(52,13)
      V(278)=2.D0*V(277)
      V(279)=ExZpE*r1x2Z*VRR1(52,13)
      V(280)=-2.D0*V(279)
      V(281)=HfxZpE*VRR1(76,7)
      V(282)=r1x2Z*VRR0(52,15)
      V(283)=2.D0*V(282)
      V(284)=ExZpE*r1x2Z*VRR1(52,15)
      V(285)=-2.D0*V(284)
      V(286)=HfxZpE*VRR1(76,8)
      V(287)=2.D0*V(286)
      V(288)=r1x2Z*VRR0(52,16)
      V(289)=2.D0*V(288)
      V(290)=ExZpE*r1x2Z*VRR1(52,16)
      V(291)=-2.D0*V(290)
      V(292)=HfxZpE*VRR1(76,9)
      V(293)=r1x2Z*VRR0(52,17)
      V(294)=2.D0*V(293)
      V(295)=ExZpE*r1x2Z*VRR1(52,17)
      V(296)=-2.D0*V(295)
      V(297)=r1x2Z*VRR0(52,18)
      V(298)=2.D0*V(297)
      V(299)=ExZpE*r1x2Z*VRR1(52,18)
      V(300)=-2.D0*V(299)
      V(301)=HfxZpE*VRR1(76,10)
      V(302)=r1x2Z*VRR0(52,19)
      V(303)=2.D0*V(302)
      V(304)=ExZpE*r1x2Z*VRR1(52,19)
      V(305)=-2.D0*V(304)
      V(306)=HfxZpE*VRR1(77,5)
      V(307)=HfxZpE*VRR1(78,5)
      V(308)=HfxZpE*VRR1(77,6)
      V(309)=HfxZpE*VRR1(77,7)
      V(310)=HfxZpE*VRR1(77,8)
      V(311)=HfxZpE*VRR1(77,9)
      V(312)=2.D0*V(311)
      V(313)=HfxZpE*VRR1(77,10)
      V(314)=r1x2Z*VRR0(53,11)
      V(315)=ExZpE*r1x2Z*VRR1(53,11)
      V(316)=r1x2Z*VRR0(53,12)
      V(317)=ExZpE*r1x2Z*VRR1(53,12)
      V(318)=r1x2Z*VRR0(53,13)
      V(319)=ExZpE*r1x2Z*VRR1(53,13)
      V(320)=HfxZpE*VRR1(78,6)
      V(321)=r1x2Z*VRR0(53,14)
      V(322)=ExZpE*r1x2Z*VRR1(53,14)
      V(323)=HfxZpE*VRR1(78,7)
      V(324)=r1x2Z*VRR0(53,15)
      V(325)=ExZpE*r1x2Z*VRR1(53,15)
      V(326)=r1x2Z*VRR0(53,16)
      V(327)=ExZpE*r1x2Z*VRR1(53,16)
      V(328)=HfxZpE*VRR1(78,8)
      V(329)=r1x2Z*VRR0(53,17)
      V(330)=ExZpE*r1x2Z*VRR1(53,17)
      V(331)=HfxZpE*VRR1(78,9)
      V(332)=2.D0*V(331)
      V(333)=r1x2Z*VRR0(53,18)
      V(334)=ExZpE*r1x2Z*VRR1(53,18)
      V(335)=r1x2Z*VRR0(53,19)
      V(336)=ExZpE*r1x2Z*VRR1(53,19)
      V(337)=HfxZpE*VRR1(78,10)
      V(338)=r1x2Z*VRR0(53,20)
      V(339)=ExZpE*r1x2Z*VRR1(53,20)
      VRR0(85,11)=6.D0*r1x2Z*VRR0(36,11)+PAx*VRR0(57,11)-6.D0*ExZpE*r1x2Z*VRR1(36,11)+3.D0*HfxZpE*VRR1(57,5)+WPx*VRR1(57,11)
      VRR0(85,12)=6.D0*r1x2Z*VRR0(36,12)+PAx*VRR0(57,12)-6.D0*ExZpE*r1x2Z*VRR1(36,12)+2.D0*HfxZpE*VRR1(57,6)+WPx*VRR1(57,12)
      VRR0(85,13)=6.D0*r1x2Z*VRR0(36,13)+PAx*VRR0(57,13)-6.D0*ExZpE*r1x2Z*VRR1(36,13)+HfxZpE*VRR1(57,7)+WPx*VRR1(57,13)
      VRR0(85,14)=6.D0*r1x2Z*VRR0(36,14)+PAx*VRR0(57,14)-6.D0*ExZpE*r1x2Z*VRR1(36,14)+WPx*VRR1(57,14)
      VRR0(85,15)=6.D0*r1x2Z*VRR0(36,15)+PAx*VRR0(57,15)-6.D0*ExZpE*r1x2Z*VRR1(36,15)+2.D0*HfxZpE*VRR1(57,8)+WPx*VRR1(57,15)
      VRR0(85,16)=6.D0*r1x2Z*VRR0(36,16)+PAx*VRR0(57,16)-6.D0*ExZpE*r1x2Z*VRR1(36,16)+HfxZpE*VRR1(57,9)+WPx*VRR1(57,16)
      VRR0(85,17)=6.D0*r1x2Z*VRR0(36,17)+PAx*VRR0(57,17)-6.D0*ExZpE*r1x2Z*VRR1(36,17)+WPx*VRR1(57,17)
      VRR0(85,18)=6.D0*r1x2Z*VRR0(36,18)+PAx*VRR0(57,18)-6.D0*ExZpE*r1x2Z*VRR1(36,18)+HfxZpE*VRR1(57,10)+WPx*VRR1(57,18)
      VRR0(85,19)=6.D0*r1x2Z*VRR0(36,19)+PAx*VRR0(57,19)-6.D0*ExZpE*r1x2Z*VRR1(36,19)+WPx*VRR1(57,19)
      VRR0(85,20)=6.D0*r1x2Z*VRR0(36,20)+PAx*VRR0(57,20)-6.D0*ExZpE*r1x2Z*VRR1(36,20)+WPx*VRR1(57,20)
      VRR0(86,11)=5.D0*r1x2Z*VRR0(37,11)+PAx*VRR0(58,11)-5.D0*ExZpE*r1x2Z*VRR1(37,11)+3.D0*HfxZpE*VRR1(58,5)+WPx*VRR1(58,11)
      VRR0(86,12)=5.D0*r1x2Z*VRR0(37,12)+PAx*VRR0(58,12)-5.D0*ExZpE*r1x2Z*VRR1(37,12)+2.D0*HfxZpE*VRR1(58,6)+WPx*VRR1(58,12)
      VRR0(86,13)=5.D0*r1x2Z*VRR0(37,13)+PAx*VRR0(58,13)-5.D0*ExZpE*r1x2Z*VRR1(37,13)+HfxZpE*VRR1(58,7)+WPx*VRR1(58,13)
      VRR0(86,14)=5.D0*r1x2Z*VRR0(37,14)+PAx*VRR0(58,14)-5.D0*ExZpE*r1x2Z*VRR1(37,14)+WPx*VRR1(58,14)
      VRR0(86,15)=5.D0*r1x2Z*VRR0(37,15)+PAx*VRR0(58,15)-5.D0*ExZpE*r1x2Z*VRR1(37,15)+2.D0*HfxZpE*VRR1(58,8)+WPx*VRR1(58,15)
      VRR0(86,16)=5.D0*r1x2Z*VRR0(37,16)+PAx*VRR0(58,16)-5.D0*ExZpE*r1x2Z*VRR1(37,16)+HfxZpE*VRR1(58,9)+WPx*VRR1(58,16)
      VRR0(86,17)=5.D0*r1x2Z*VRR0(37,17)+PAx*VRR0(58,17)-5.D0*ExZpE*r1x2Z*VRR1(37,17)+WPx*VRR1(58,17)
      VRR0(86,18)=5.D0*r1x2Z*VRR0(37,18)+PAx*VRR0(58,18)-5.D0*ExZpE*r1x2Z*VRR1(37,18)+HfxZpE*VRR1(58,10)+WPx*VRR1(58,18)
      VRR0(86,19)=5.D0*r1x2Z*VRR0(37,19)+PAx*VRR0(58,19)-5.D0*ExZpE*r1x2Z*VRR1(37,19)+WPx*VRR1(58,19)
      VRR0(86,20)=5.D0*r1x2Z*VRR0(37,20)+PAx*VRR0(58,20)-5.D0*ExZpE*r1x2Z*VRR1(37,20)+WPx*VRR1(58,20)
      VRR0(87,11)=4.D0*V(1)-4.D0*V(2)+PAx*VRR0(59,11)+3.D0*HfxZpE*VRR1(59,5)+WPx*VRR1(59,11)
      VRR0(87,12)=4.D0*V(3)-4.D0*V(4)+PAx*VRR0(59,12)+2.D0*HfxZpE*VRR1(59,6)+WPx*VRR1(59,12)
      VRR0(87,13)=4.D0*V(5)-4.D0*V(6)+PAx*VRR0(59,13)+HfxZpE*VRR1(59,7)+WPx*VRR1(59,13)
      VRR0(87,14)=4.D0*V(7)-4.D0*V(8)+PAx*VRR0(59,14)+WPx*VRR1(59,14)
      VRR0(87,15)=4.D0*V(9)-4.D0*V(10)+PAx*VRR0(59,15)+2.D0*HfxZpE*VRR1(59,8)+WPx*VRR1(59,15)
      VRR0(87,16)=4.D0*V(11)-4.D0*V(12)+PAx*VRR0(59,16)+HfxZpE*VRR1(59,9)+WPx*VRR1(59,16)
      VRR0(87,17)=4.D0*V(13)-4.D0*V(14)+PAx*VRR0(59,17)+WPx*VRR1(59,17)
      VRR0(87,18)=4.D0*V(15)-4.D0*V(16)+PAx*VRR0(59,18)+HfxZpE*VRR1(59,10)+WPx*VRR1(59,18)
      VRR0(87,19)=4.D0*V(17)-4.D0*V(18)+PAx*VRR0(59,19)+WPx*VRR1(59,19)
      VRR0(87,20)=4.D0*V(19)-4.D0*V(20)+PAx*VRR0(59,20)+WPx*VRR1(59,20)
      VRR0(88,11)=3.D0*V(21)-3.D0*V(22)+3.D0*V(23)+PAx*VRR0(60,11)+WPx*VRR1(60,11)
      VRR0(88,12)=3.D0*V(24)-3.D0*V(25)+V(27)+PAx*VRR0(60,12)+WPx*VRR1(60,12)
      VRR0(88,13)=3.D0*V(28)-3.D0*V(29)+V(30)+PAx*VRR0(60,13)+WPx*VRR1(60,13)
      VRR0(88,14)=3.D0*V(31)-3.D0*V(32)+PAx*VRR0(60,14)+WPx*VRR1(60,14)
      VRR0(88,15)=3.D0*V(33)-3.D0*V(34)+2.D0*V(35)+PAx*VRR0(60,15)+WPx*VRR1(60,15)
      VRR0(88,16)=3.D0*V(36)-3.D0*V(37)+V(38)+PAx*VRR0(60,16)+WPx*VRR1(60,16)
      VRR0(88,17)=3.D0*V(39)-3.D0*V(40)+PAx*VRR0(60,17)+WPx*VRR1(60,17)
      VRR0(88,18)=3.D0*V(41)-3.D0*V(42)+V(43)+PAx*VRR0(60,18)+WPx*VRR1(60,18)
      VRR0(88,19)=3.D0*V(44)-3.D0*V(45)+PAx*VRR0(60,19)+WPx*VRR1(60,19)
      VRR0(88,20)=3.D0*V(46)-3.D0*V(47)+PAx*VRR0(60,20)+WPx*VRR1(60,20)
      VRR0(89,11)=3.D0*V(1)-3.D0*V(2)+PAy*VRR0(60,11)+WPy*VRR1(60,11)
      VRR0(89,12)=3.D0*V(3)-3.D0*V(4)+V(23)+PAy*VRR0(60,12)+WPy*VRR1(60,12)
      VRR0(89,13)=3.D0*V(5)-3.D0*V(6)+V(27)+PAy*VRR0(60,13)+WPy*VRR1(60,13)
      VRR0(89,14)=3.D0*V(7)-3.D0*V(8)+3.D0*V(30)+PAy*VRR0(60,14)+WPy*VRR1(60,14)
      VRR0(89,15)=3.D0*V(9)-3.D0*V(10)+PAy*VRR0(60,15)+WPy*VRR1(60,15)
      VRR0(89,16)=3.D0*V(11)-3.D0*V(12)+V(35)+PAy*VRR0(60,16)+WPy*VRR1(60,16)
      VRR0(89,17)=3.D0*V(13)-3.D0*V(14)+2.D0*V(38)+PAy*VRR0(60,17)+WPy*VRR1(60,17)
      VRR0(89,18)=3.D0*V(15)-3.D0*V(16)+PAy*VRR0(60,18)+WPy*VRR1(60,18)
      VRR0(89,19)=3.D0*V(17)-3.D0*V(18)+V(43)+PAy*VRR0(60,19)+WPy*VRR1(60,19)
      VRR0(89,20)=3.D0*V(19)-3.D0*V(20)+PAy*VRR0(60,20)+WPy*VRR1(60,20)
      VRR0(90,11)=4.D0*V(21)-4.D0*V(22)+PAy*VRR0(61,11)+WPy*VRR1(61,11)
      VRR0(90,12)=4.D0*V(24)-4.D0*V(25)+PAy*VRR0(61,12)+HfxZpE*VRR1(61,5)+WPy*VRR1(61,12)
      VRR0(90,13)=4.D0*V(28)-4.D0*V(29)+PAy*VRR0(61,13)+2.D0*HfxZpE*VRR1(61,6)+WPy*VRR1(61,13)
      VRR0(90,14)=4.D0*V(31)-4.D0*V(32)+PAy*VRR0(61,14)+3.D0*HfxZpE*VRR1(61,7)+WPy*VRR1(61,14)
      VRR0(90,15)=4.D0*V(33)-4.D0*V(34)+PAy*VRR0(61,15)+WPy*VRR1(61,15)
      VRR0(90,16)=4.D0*V(36)-4.D0*V(37)+PAy*VRR0(61,16)+HfxZpE*VRR1(61,8)+WPy*VRR1(61,16)
      VRR0(90,17)=4.D0*V(39)-4.D0*V(40)+PAy*VRR0(61,17)+2.D0*HfxZpE*VRR1(61,9)+WPy*VRR1(61,17)
      VRR0(90,18)=4.D0*V(41)-4.D0*V(42)+PAy*VRR0(61,18)+WPy*VRR1(61,18)
      VRR0(90,19)=4.D0*V(44)-4.D0*V(45)+PAy*VRR0(61,19)+HfxZpE*VRR1(61,10)+WPy*VRR1(61,19)
      VRR0(90,20)=4.D0*V(46)-4.D0*V(47)+PAy*VRR0(61,20)+WPy*VRR1(61,20)
      VRR0(91,11)=5.D0*r1x2Z*VRR0(40,11)+PAy*VRR0(62,11)-5.D0*ExZpE*r1x2Z*VRR1(40,11)+WPy*VRR1(62,11)
      VRR0(91,12)=5.D0*r1x2Z*VRR0(40,12)+PAy*VRR0(62,12)-5.D0*ExZpE*r1x2Z*VRR1(40,12)+HfxZpE*VRR1(62,5)+WPy*VRR1(62,12)
      VRR0(91,13)=5.D0*r1x2Z*VRR0(40,13)+PAy*VRR0(62,13)-5.D0*ExZpE*r1x2Z*VRR1(40,13)+2.D0*HfxZpE*VRR1(62,6)+WPy*VRR1(62,13)
      VRR0(91,14)=5.D0*r1x2Z*VRR0(40,14)+PAy*VRR0(62,14)-5.D0*ExZpE*r1x2Z*VRR1(40,14)+3.D0*HfxZpE*VRR1(62,7)+WPy*VRR1(62,14)
      VRR0(91,15)=5.D0*r1x2Z*VRR0(40,15)+PAy*VRR0(62,15)-5.D0*ExZpE*r1x2Z*VRR1(40,15)+WPy*VRR1(62,15)
      VRR0(91,16)=5.D0*r1x2Z*VRR0(40,16)+PAy*VRR0(62,16)-5.D0*ExZpE*r1x2Z*VRR1(40,16)+HfxZpE*VRR1(62,8)+WPy*VRR1(62,16)
      VRR0(91,17)=5.D0*r1x2Z*VRR0(40,17)+PAy*VRR0(62,17)-5.D0*ExZpE*r1x2Z*VRR1(40,17)+2.D0*HfxZpE*VRR1(62,9)+WPy*VRR1(62,17)
      VRR0(91,18)=5.D0*r1x2Z*VRR0(40,18)+PAy*VRR0(62,18)-5.D0*ExZpE*r1x2Z*VRR1(40,18)+WPy*VRR1(62,18)
      VRR0(91,19)=5.D0*r1x2Z*VRR0(40,19)+PAy*VRR0(62,19)-5.D0*ExZpE*r1x2Z*VRR1(40,19)+HfxZpE*VRR1(62,10)+WPy*VRR1(62,19)
      VRR0(91,20)=5.D0*r1x2Z*VRR0(40,20)+PAy*VRR0(62,20)-5.D0*ExZpE*r1x2Z*VRR1(40,20)+WPy*VRR1(62,20)
      VRR0(92,11)=6.D0*r1x2Z*VRR0(41,11)+PAy*VRR0(63,11)-6.D0*ExZpE*r1x2Z*VRR1(41,11)+WPy*VRR1(63,11)
      VRR0(92,12)=6.D0*r1x2Z*VRR0(41,12)+PAy*VRR0(63,12)-6.D0*ExZpE*r1x2Z*VRR1(41,12)+HfxZpE*VRR1(63,5)+WPy*VRR1(63,12)
      VRR0(92,13)=6.D0*r1x2Z*VRR0(41,13)+PAy*VRR0(63,13)-6.D0*ExZpE*r1x2Z*VRR1(41,13)+2.D0*HfxZpE*VRR1(63,6)+WPy*VRR1(63,13)
      VRR0(92,14)=6.D0*r1x2Z*VRR0(41,14)+PAy*VRR0(63,14)-6.D0*ExZpE*r1x2Z*VRR1(41,14)+3.D0*HfxZpE*VRR1(63,7)+WPy*VRR1(63,14)
      VRR0(92,15)=6.D0*r1x2Z*VRR0(41,15)+PAy*VRR0(63,15)-6.D0*ExZpE*r1x2Z*VRR1(41,15)+WPy*VRR1(63,15)
      VRR0(92,16)=6.D0*r1x2Z*VRR0(41,16)+PAy*VRR0(63,16)-6.D0*ExZpE*r1x2Z*VRR1(41,16)+HfxZpE*VRR1(63,8)+WPy*VRR1(63,16)
      VRR0(92,17)=6.D0*r1x2Z*VRR0(41,17)+PAy*VRR0(63,17)-6.D0*ExZpE*r1x2Z*VRR1(41,17)+2.D0*HfxZpE*VRR1(63,9)+WPy*VRR1(63,17)
      VRR0(92,18)=6.D0*r1x2Z*VRR0(41,18)+PAy*VRR0(63,18)-6.D0*ExZpE*r1x2Z*VRR1(41,18)+WPy*VRR1(63,18)
      VRR0(92,19)=6.D0*r1x2Z*VRR0(41,19)+PAy*VRR0(63,19)-6.D0*ExZpE*r1x2Z*VRR1(41,19)+HfxZpE*VRR1(63,10)+WPy*VRR1(63,19)
      VRR0(92,20)=6.D0*r1x2Z*VRR0(41,20)+PAy*VRR0(63,20)-6.D0*ExZpE*r1x2Z*VRR1(41,20)+WPy*VRR1(63,20)
      VRR0(93,11)=5.D0*r1x2Z*VRR0(42,11)+PAx*VRR0(64,11)-5.D0*ExZpE*r1x2Z*VRR1(42,11)+3.D0*HfxZpE*VRR1(64,5)+WPx*VRR1(64,11)
      VRR0(93,12)=5.D0*r1x2Z*VRR0(42,12)+PAx*VRR0(64,12)-5.D0*ExZpE*r1x2Z*VRR1(42,12)+2.D0*HfxZpE*VRR1(64,6)+WPx*VRR1(64,12)
      VRR0(93,13)=5.D0*r1x2Z*VRR0(42,13)+PAx*VRR0(64,13)-5.D0*ExZpE*r1x2Z*VRR1(42,13)+HfxZpE*VRR1(64,7)+WPx*VRR1(64,13)
      VRR0(93,14)=5.D0*r1x2Z*VRR0(42,14)+PAx*VRR0(64,14)-5.D0*ExZpE*r1x2Z*VRR1(42,14)+WPx*VRR1(64,14)
      VRR0(93,15)=5.D0*r1x2Z*VRR0(42,15)+PAx*VRR0(64,15)-5.D0*ExZpE*r1x2Z*VRR1(42,15)+2.D0*HfxZpE*VRR1(64,8)+WPx*VRR1(64,15)
      VRR0(93,16)=5.D0*r1x2Z*VRR0(42,16)+PAx*VRR0(64,16)-5.D0*ExZpE*r1x2Z*VRR1(42,16)+HfxZpE*VRR1(64,9)+WPx*VRR1(64,16)
      VRR0(93,17)=5.D0*r1x2Z*VRR0(42,17)+PAx*VRR0(64,17)-5.D0*ExZpE*r1x2Z*VRR1(42,17)+WPx*VRR1(64,17)
      VRR0(93,18)=5.D0*r1x2Z*VRR0(42,18)+PAx*VRR0(64,18)-5.D0*ExZpE*r1x2Z*VRR1(42,18)+HfxZpE*VRR1(64,10)+WPx*VRR1(64,18)
      VRR0(93,19)=5.D0*r1x2Z*VRR0(42,19)+PAx*VRR0(64,19)-5.D0*ExZpE*r1x2Z*VRR1(42,19)+WPx*VRR1(64,19)
      VRR0(93,20)=5.D0*r1x2Z*VRR0(42,20)+PAx*VRR0(64,20)-5.D0*ExZpE*r1x2Z*VRR1(42,20)+WPx*VRR1(64,20)
      VRR0(94,11)=4.D0*r1x2Z*VRR0(43,11)+PAx*VRR0(65,11)-4.D0*ExZpE*r1x2Z*VRR1(43,11)+3.D0*HfxZpE*VRR1(65,5)+WPx*VRR1(65,11)
      VRR0(94,12)=4.D0*r1x2Z*VRR0(43,12)+PAx*VRR0(65,12)-4.D0*ExZpE*r1x2Z*VRR1(43,12)+2.D0*HfxZpE*VRR1(65,6)+WPx*VRR1(65,12)
      VRR0(94,13)=4.D0*r1x2Z*VRR0(43,13)+PAx*VRR0(65,13)-4.D0*ExZpE*r1x2Z*VRR1(43,13)+HfxZpE*VRR1(65,7)+WPx*VRR1(65,13)
      VRR0(94,14)=4.D0*r1x2Z*VRR0(43,14)+PAx*VRR0(65,14)-4.D0*ExZpE*r1x2Z*VRR1(43,14)+WPx*VRR1(65,14)
      VRR0(94,15)=4.D0*r1x2Z*VRR0(43,15)+PAx*VRR0(65,15)-4.D0*ExZpE*r1x2Z*VRR1(43,15)+2.D0*HfxZpE*VRR1(65,8)+WPx*VRR1(65,15)
      VRR0(94,16)=4.D0*r1x2Z*VRR0(43,16)+PAx*VRR0(65,16)-4.D0*ExZpE*r1x2Z*VRR1(43,16)+HfxZpE*VRR1(65,9)+WPx*VRR1(65,16)
      VRR0(94,17)=4.D0*r1x2Z*VRR0(43,17)+PAx*VRR0(65,17)-4.D0*ExZpE*r1x2Z*VRR1(43,17)+WPx*VRR1(65,17)
      VRR0(94,18)=4.D0*r1x2Z*VRR0(43,18)+PAx*VRR0(65,18)-4.D0*ExZpE*r1x2Z*VRR1(43,18)+HfxZpE*VRR1(65,10)+WPx*VRR1(65,18)
      VRR0(94,19)=4.D0*r1x2Z*VRR0(43,19)+PAx*VRR0(65,19)-4.D0*ExZpE*r1x2Z*VRR1(43,19)+WPx*VRR1(65,19)
      VRR0(94,20)=4.D0*r1x2Z*VRR0(43,20)+PAx*VRR0(65,20)-4.D0*ExZpE*r1x2Z*VRR1(43,20)+WPx*VRR1(65,20)
      VRR0(95,11)=V(49)+V(51)+PAx*VRR0(66,11)+3.D0*HfxZpE*VRR1(66,5)+WPx*VRR1(66,11)
      VRR0(95,12)=V(53)+V(55)+PAx*VRR0(66,12)+2.D0*HfxZpE*VRR1(66,6)+WPx*VRR1(66,12)
      VRR0(95,13)=V(57)+V(59)+V(60)+PAx*VRR0(66,13)+WPx*VRR1(66,13)
      VRR0(95,14)=V(62)+V(64)+PAx*VRR0(66,14)+WPx*VRR1(66,14)
      VRR0(95,15)=V(66)+V(68)+PAx*VRR0(66,15)+2.D0*HfxZpE*VRR1(66,8)+WPx*VRR1(66,15)
      VRR0(95,16)=V(70)+V(72)+PAx*VRR0(66,16)+HfxZpE*VRR1(66,9)+WPx*VRR1(66,16)
      VRR0(95,17)=V(74)+V(76)+PAx*VRR0(66,17)+WPx*VRR1(66,17)
      VRR0(95,18)=V(78)+V(80)+V(81)+PAx*VRR0(66,18)+WPx*VRR1(66,18)
      VRR0(95,19)=V(83)+V(85)+PAx*VRR0(66,19)+WPx*VRR1(66,19)
      VRR0(95,20)=V(87)+V(89)+PAx*VRR0(66,20)+WPx*VRR1(66,20)
      VRR0(96,11)=3.D0*V(90)+2.D0*r1x2E*VRR0(96,2)+QCx*VRR0(96,5)-2.D0*r1x2E*ZxZpE*VRR1(96,2)+WQx*VRR1(96,5)
      VRR0(96,12)=2.D0*V(91)-2.D0*V(92)+V(94)+PAx*VRR0(67,12)+WPx*VRR1(67,12)
      VRR0(96,13)=2.D0*V(95)-2.D0*V(96)+V(97)+PAx*VRR0(67,13)+WPx*VRR1(67,13)
      VRR0(96,14)=3.D0*V(60)+2.D0*r1x2E*VRR0(96,3)+QCy*VRR0(96,7)-2.D0*r1x2E*ZxZpE*VRR1(96,3)+WQy*VRR1(96,7)
      VRR0(96,15)=2.D0*V(98)-2.D0*V(99)+2.D0*V(100)+PAx*VRR0(67,15)+WPx*VRR1(67,15)
      VRR0(96,16)=2.D0*V(101)-2.D0*V(102)+V(103)+PAx*VRR0(67,16)+WPx*VRR1(67,16)
      VRR0(96,17)=2.D0*V(104)-2.D0*V(105)+PAx*VRR0(67,17)+WPx*VRR1(67,17)
      VRR0(96,18)=2.D0*V(106)-2.D0*V(107)+V(108)+PAx*VRR0(67,18)+WPx*VRR1(67,18)
      VRR0(96,19)=2.D0*V(109)-2.D0*V(110)+PAx*VRR0(67,19)+WPx*VRR1(67,19)
      VRR0(96,20)=V(43)+2.D0*r1x2E*VRR0(96,4)+QCz*VRR0(96,10)-2.D0*r1x2E*ZxZpE*VRR1(96,4)+WQz*VRR1(96,10)
      VRR0(97,11)=V(49)+V(51)+PAy*VRR0(67,11)+WPy*VRR1(67,11)
      VRR0(97,12)=V(53)+V(55)+V(90)+PAy*VRR0(67,12)+WPy*VRR1(67,12)
      VRR0(97,13)=V(57)+V(59)+V(94)+PAy*VRR0(67,13)+WPy*VRR1(67,13)
      VRR0(97,14)=V(62)+V(64)+3.D0*V(97)+PAy*VRR0(67,14)+WPy*VRR1(67,14)
      VRR0(97,15)=V(66)+V(68)+PAy*VRR0(67,15)+WPy*VRR1(67,15)
      VRR0(97,16)=V(70)+V(72)+V(100)+PAy*VRR0(67,16)+WPy*VRR1(67,16)
      VRR0(97,17)=V(74)+V(76)+2.D0*V(103)+PAy*VRR0(67,17)+WPy*VRR1(67,17)
      VRR0(97,18)=V(78)+V(80)+PAy*VRR0(67,18)+WPy*VRR1(67,18)
      VRR0(97,19)=V(83)+V(85)+V(108)+PAy*VRR0(67,19)+WPy*VRR1(67,19)
      VRR0(97,20)=V(87)+V(89)+PAy*VRR0(67,20)+WPy*VRR1(67,20)
      VRR0(98,11)=4.D0*r1x2Z*VRR0(45,11)+PAy*VRR0(68,11)-4.D0*ExZpE*r1x2Z*VRR1(45,11)+WPy*VRR1(68,11)
      VRR0(98,12)=4.D0*V(91)-4.D0*V(92)+PAy*VRR0(68,12)+HfxZpE*VRR1(68,5)+WPy*VRR1(68,12)
      VRR0(98,13)=4.D0*V(95)-4.D0*V(96)+PAy*VRR0(68,13)+2.D0*HfxZpE*VRR1(68,6)+WPy*VRR1(68,13)
      VRR0(98,14)=4.D0*r1x2Z*VRR0(45,14)+PAy*VRR0(68,14)-4.D0*ExZpE*r1x2Z*VRR1(45,14)+3.D0*HfxZpE*VRR1(68,7)+WPy*VRR1(68,14)
      VRR0(98,15)=4.D0*V(98)-4.D0*V(99)+PAy*VRR0(68,15)+WPy*VRR1(68,15)
      VRR0(98,16)=4.D0*V(101)-4.D0*V(102)+PAy*VRR0(68,16)+HfxZpE*VRR1(68,8)+WPy*VRR1(68,16)
      VRR0(98,17)=4.D0*V(104)-4.D0*V(105)+PAy*VRR0(68,17)+2.D0*HfxZpE*VRR1(68,9)+WPy*VRR1(68,17)
      VRR0(98,18)=4.D0*V(106)-4.D0*V(107)+PAy*VRR0(68,18)+WPy*VRR1(68,18)
      VRR0(98,19)=4.D0*V(109)-4.D0*V(110)+PAy*VRR0(68,19)+HfxZpE*VRR1(68,10)+WPy*VRR1(68,19)
      VRR0(98,20)=4.D0*r1x2Z*VRR0(45,20)+PAy*VRR0(68,20)-4.D0*ExZpE*r1x2Z*VRR1(45,20)+WPy*VRR1(68,20)
      VRR0(99,11)=5.D0*r1x2Z*VRR0(46,11)+PAy*VRR0(69,11)-5.D0*ExZpE*r1x2Z*VRR1(46,11)+WPy*VRR1(69,11)
      VRR0(99,12)=5.D0*r1x2Z*VRR0(46,12)+PAy*VRR0(69,12)-5.D0*ExZpE*r1x2Z*VRR1(46,12)+HfxZpE*VRR1(69,5)+WPy*VRR1(69,12)
      VRR0(99,13)=5.D0*r1x2Z*VRR0(46,13)+PAy*VRR0(69,13)-5.D0*ExZpE*r1x2Z*VRR1(46,13)+2.D0*HfxZpE*VRR1(69,6)+WPy*VRR1(69,13)
      VRR0(99,14)=5.D0*r1x2Z*VRR0(46,14)+PAy*VRR0(69,14)-5.D0*ExZpE*r1x2Z*VRR1(46,14)+3.D0*HfxZpE*VRR1(69,7)+WPy*VRR1(69,14)
      VRR0(99,15)=5.D0*r1x2Z*VRR0(46,15)+PAy*VRR0(69,15)-5.D0*ExZpE*r1x2Z*VRR1(46,15)+WPy*VRR1(69,15)
      VRR0(99,16)=5.D0*r1x2Z*VRR0(46,16)+PAy*VRR0(69,16)-5.D0*ExZpE*r1x2Z*VRR1(46,16)+HfxZpE*VRR1(69,8)+WPy*VRR1(69,16)
      VRR0(99,17)=5.D0*r1x2Z*VRR0(46,17)+PAy*VRR0(69,17)-5.D0*ExZpE*r1x2Z*VRR1(46,17)+2.D0*HfxZpE*VRR1(69,9)+WPy*VRR1(69,17)
      VRR0(99,18)=5.D0*r1x2Z*VRR0(46,18)+PAy*VRR0(69,18)-5.D0*ExZpE*r1x2Z*VRR1(46,18)+WPy*VRR1(69,18)
      VRR0(99,19)=5.D0*r1x2Z*VRR0(46,19)+PAy*VRR0(69,19)-5.D0*ExZpE*r1x2Z*VRR1(46,19)+HfxZpE*VRR1(69,10)+WPy*VRR1(69,19)
      VRR0(99,20)=5.D0*r1x2Z*VRR0(46,20)+PAy*VRR0(69,20)-5.D0*ExZpE*r1x2Z*VRR1(46,20)+WPy*VRR1(69,20)
      VRR0(100,11)=4.D0*V(111)-4.D0*V(112)+PAx*VRR0(70,11)+3.D0*HfxZpE*VRR1(70,5)+WPx*VRR1(70,11)
      VRR0(100,12)=4.D0*V(113)-4.D0*V(114)+PAx*VRR0(70,12)+2.D0*HfxZpE*VRR1(70,6)+WPx*VRR1(70,12)
      VRR0(100,13)=4.D0*V(115)-4.D0*V(116)+PAx*VRR0(70,13)+HfxZpE*VRR1(70,7)+WPx*VRR1(70,13)
      VRR0(100,14)=4.D0*V(117)-4.D0*V(118)+PAx*VRR0(70,14)+WPx*VRR1(70,14)
      VRR0(100,15)=4.D0*V(119)-4.D0*V(120)+PAx*VRR0(70,15)+2.D0*HfxZpE*VRR1(70,8)+WPx*VRR1(70,15)
      VRR0(100,16)=4.D0*V(121)-4.D0*V(122)+PAx*VRR0(70,16)+HfxZpE*VRR1(70,9)+WPx*VRR1(70,16)
      VRR0(100,17)=4.D0*V(123)-4.D0*V(124)+PAx*VRR0(70,17)+WPx*VRR1(70,17)
      VRR0(100,18)=4.D0*V(125)-4.D0*V(126)+PAx*VRR0(70,18)+HfxZpE*VRR1(70,10)+WPx*VRR1(70,18)
      VRR0(100,19)=4.D0*V(127)-4.D0*V(128)+PAx*VRR0(70,19)+WPx*VRR1(70,19)
      VRR0(100,20)=4.D0*V(129)-4.D0*V(130)+PAx*VRR0(70,20)+WPx*VRR1(70,20)
      VRR0(101,11)=V(132)+V(134)+PAx*VRR0(71,11)+3.D0*HfxZpE*VRR1(71,5)+WPx*VRR1(71,11)
      VRR0(101,12)=V(136)+V(138)+PAx*VRR0(71,12)+2.D0*HfxZpE*VRR1(71,6)+WPx*VRR1(71,12)
      VRR0(101,13)=V(140)+V(142)+V(143)+PAx*VRR0(71,13)+WPx*VRR1(71,13)
      VRR0(101,14)=V(145)+V(147)+PAx*VRR0(71,14)+WPx*VRR1(71,14)
      VRR0(101,15)=V(149)+V(151)+PAx*VRR0(71,15)+2.D0*HfxZpE*VRR1(71,8)+WPx*VRR1(71,15)
      VRR0(101,16)=V(153)+V(155)+PAx*VRR0(71,16)+HfxZpE*VRR1(71,9)+WPx*VRR1(71,16)
      VRR0(101,17)=V(157)+V(159)+PAx*VRR0(71,17)+WPx*VRR1(71,17)
      VRR0(101,18)=V(161)+V(163)+V(164)+PAx*VRR0(71,18)+WPx*VRR1(71,18)
      VRR0(101,19)=V(166)+V(168)+PAx*VRR0(71,19)+WPx*VRR1(71,19)
      VRR0(101,20)=V(170)+V(172)+PAx*VRR0(71,20)+WPx*VRR1(71,20)
      VRR0(102,11)=3.D0*V(173)+2.D0*r1x2E*VRR0(102,2)+QCx*VRR0(102,5)-2.D0*r1x2E*ZxZpE*VRR1(102,2)+WQx*VRR1(102,5)
      VRR0(102,12)=2.D0*V(174)-2.D0*V(175)+V(177)+PAx*VRR0(72,12)+WPx*VRR1(72,12)
      VRR0(102,13)=2.D0*V(178)-2.D0*V(179)+V(180)+PAx*VRR0(72,13)+WPx*VRR1(72,13)
      VRR0(102,14)=2.D0*V(143)+2.D0*r1x2E*VRR0(102,3)+QCy*VRR0(102,7)-2.D0*r1x2E*ZxZpE*VRR1(102,3)+WQy*VRR1(102,7)
      VRR0(102,15)=2.D0*V(181)-2.D0*V(182)+V(184)+PAx*VRR0(72,15)+WPx*VRR1(72,15)
      VRR0(102,16)=2.D0*V(185)-2.D0*V(186)+V(187)+PAx*VRR0(72,16)+WPx*VRR1(72,16)
      VRR0(102,17)=2.D0*V(188)-2.D0*V(189)+PAx*VRR0(72,17)+WPx*VRR1(72,17)
      VRR0(102,18)=2.D0*V(190)-2.D0*V(191)+V(192)+PAx*VRR0(72,18)+WPx*VRR1(72,18)
      VRR0(102,19)=2.D0*V(193)-2.D0*V(194)+PAx*VRR0(72,19)+WPx*VRR1(72,19)
      VRR0(102,20)=2.D0*V(81)+2.D0*r1x2E*VRR0(102,4)+QCz*VRR0(102,10)-2.D0*r1x2E*ZxZpE*VRR1(102,4)+WQz*VRR1(102,10)
      VRR0(103,11)=2.D0*V(195)+2.D0*r1x2E*VRR0(103,2)+QCx*VRR0(103,5)-2.D0*r1x2E*ZxZpE*VRR1(103,2)+WQx*VRR1(103,5)
      VRR0(103,12)=2.D0*V(135)-2.D0*V(137)+V(173)+PAy*VRR0(72,12)+WPy*VRR1(72,12)
      VRR0(103,13)=2.D0*V(139)-2.D0*V(141)+V(177)+PAy*VRR0(72,13)+WPy*VRR1(72,13)
      VRR0(103,14)=3.D0*V(180)+2.D0*r1x2E*VRR0(103,3)+QCy*VRR0(103,7)-2.D0*r1x2E*ZxZpE*VRR1(103,3)+WQy*VRR1(103,7)
      VRR0(103,15)=2.D0*V(148)-2.D0*V(150)+PAy*VRR0(72,15)+WPy*VRR1(72,15)
      VRR0(103,16)=2.D0*V(152)-2.D0*V(154)+V(183)+PAy*VRR0(72,16)+WPy*VRR1(72,16)
      VRR0(103,17)=2.D0*V(156)-2.D0*V(158)+V(196)+PAy*VRR0(72,17)+WPy*VRR1(72,17)
      VRR0(103,18)=2.D0*V(160)-2.D0*V(162)+PAy*VRR0(72,18)+WPy*VRR1(72,18)
      VRR0(103,19)=2.D0*V(165)-2.D0*V(167)+V(192)+PAy*VRR0(72,19)+WPy*VRR1(72,19)
      VRR0(103,20)=2.D0*V(108)+2.D0*r1x2E*VRR0(103,4)+QCz*VRR0(103,10)-2.D0*r1x2E*ZxZpE*VRR1(103,4)+WQz*VRR1(103,10)
      VRR0(104,11)=V(198)+V(200)+PAy*VRR0(73,11)+WPy*VRR1(73,11)
      VRR0(104,12)=V(195)+V(201)+V(202)+PAy*VRR0(73,12)+WPy*VRR1(73,12)
      VRR0(104,13)=V(203)+V(204)+PAy*VRR0(73,13)+2.D0*HfxZpE*VRR1(73,6)+WPy*VRR1(73,13)
      VRR0(104,14)=V(206)+V(208)+PAy*VRR0(73,14)+3.D0*HfxZpE*VRR1(73,7)+WPy*VRR1(73,14)
      VRR0(104,15)=V(209)+V(210)+PAy*VRR0(73,15)+WPy*VRR1(73,15)
      VRR0(104,16)=V(211)+V(212)+PAy*VRR0(73,16)+HfxZpE*VRR1(73,8)+WPy*VRR1(73,16)
      VRR0(104,17)=V(213)+V(214)+PAy*VRR0(73,17)+2.D0*HfxZpE*VRR1(73,9)+WPy*VRR1(73,17)
      VRR0(104,18)=V(215)+V(216)+PAy*VRR0(73,18)+WPy*VRR1(73,18)
      VRR0(104,19)=V(217)+V(218)+V(219)+PAy*VRR0(73,19)+WPy*VRR1(73,19)
      VRR0(104,20)=V(221)+V(223)+PAy*VRR0(73,20)+WPy*VRR1(73,20)
      VRR0(105,11)=4.D0*V(224)-4.D0*V(225)+PAy*VRR0(74,11)+WPy*VRR1(74,11)
      VRR0(105,12)=4.D0*V(226)-4.D0*V(227)+PAy*VRR0(74,12)+HfxZpE*VRR1(74,5)+WPy*VRR1(74,12)
      VRR0(105,13)=4.D0*V(228)-4.D0*V(229)+PAy*VRR0(74,13)+2.D0*HfxZpE*VRR1(74,6)+WPy*VRR1(74,13)
      VRR0(105,14)=4.D0*V(230)-4.D0*V(231)+PAy*VRR0(74,14)+3.D0*HfxZpE*VRR1(74,7)+WPy*VRR1(74,14)
      VRR0(105,15)=4.D0*V(232)-4.D0*V(233)+PAy*VRR0(74,15)+WPy*VRR1(74,15)
      VRR0(105,16)=4.D0*V(234)-4.D0*V(235)+PAy*VRR0(74,16)+HfxZpE*VRR1(74,8)+WPy*VRR1(74,16)
      VRR0(105,17)=4.D0*V(236)-4.D0*V(237)+PAy*VRR0(74,17)+2.D0*HfxZpE*VRR1(74,9)+WPy*VRR1(74,17)
      VRR0(105,18)=4.D0*V(238)-4.D0*V(239)+PAy*VRR0(74,18)+WPy*VRR1(74,18)
      VRR0(105,19)=4.D0*V(240)-4.D0*V(241)+PAy*VRR0(74,19)+HfxZpE*VRR1(74,10)+WPy*VRR1(74,19)
      VRR0(105,20)=4.D0*V(242)-4.D0*V(243)+PAy*VRR0(74,20)+WPy*VRR1(74,20)
      VRR0(106,11)=3.D0*V(244)-3.D0*V(245)+3.D0*V(246)+PAx*VRR0(75,11)+WPx*VRR1(75,11)
      VRR0(106,12)=3.D0*V(247)-3.D0*V(248)+2.D0*V(249)+PAx*VRR0(75,12)+WPx*VRR1(75,12)
      VRR0(106,13)=3.D0*V(250)-3.D0*V(251)+V(252)+PAx*VRR0(75,13)+WPx*VRR1(75,13)
      VRR0(106,14)=3.D0*V(253)-3.D0*V(254)+PAx*VRR0(75,14)+WPx*VRR1(75,14)
      VRR0(106,15)=3.D0*V(255)-3.D0*V(256)+V(258)+PAx*VRR0(75,15)+WPx*VRR1(75,15)
      VRR0(106,16)=3.D0*V(259)-3.D0*V(260)+V(261)+PAx*VRR0(75,16)+WPx*VRR1(75,16)
      VRR0(106,17)=3.D0*V(262)-3.D0*V(263)+PAx*VRR0(75,17)+WPx*VRR1(75,17)
      VRR0(106,18)=3.D0*V(264)-3.D0*V(265)+V(266)+PAx*VRR0(75,18)+WPx*VRR1(75,18)
      VRR0(106,19)=3.D0*V(267)-3.D0*V(268)+PAx*VRR0(75,19)+WPx*VRR1(75,19)
      VRR0(106,20)=3.D0*V(269)-3.D0*V(270)+PAx*VRR0(75,20)+WPx*VRR1(75,20)
      VRR0(107,11)=3.D0*V(271)+2.D0*r1x2E*VRR0(107,2)+QCx*VRR0(107,5)-2.D0*r1x2E*ZxZpE*VRR1(107,2)+WQx*VRR1(107,5)
      VRR0(107,12)=V(273)+V(275)+2.D0*V(276)+PAx*VRR0(76,12)+WPx*VRR1(76,12)
      VRR0(107,13)=V(278)+V(280)+V(281)+PAx*VRR0(76,13)+WPx*VRR1(76,13)
      VRR0(107,14)=V(252)+2.D0*r1x2E*VRR0(107,3)+QCy*VRR0(107,7)-2.D0*r1x2E*ZxZpE*VRR1(107,3)+WQy*VRR1(107,7)
      VRR0(107,15)=V(283)+V(285)+V(287)+PAx*VRR0(76,15)+WPx*VRR1(76,15)
      VRR0(107,16)=V(289)+V(291)+V(292)+PAx*VRR0(76,16)+WPx*VRR1(76,16)
      VRR0(107,17)=V(294)+V(296)+PAx*VRR0(76,17)+WPx*VRR1(76,17)
      VRR0(107,18)=V(298)+V(300)+V(301)+PAx*VRR0(76,18)+WPx*VRR1(76,18)
      VRR0(107,19)=V(303)+V(305)+PAx*VRR0(76,19)+WPx*VRR1(76,19)
      VRR0(107,20)=3.D0*V(164)+2.D0*r1x2E*VRR0(107,4)+QCz*VRR0(107,10)-2.D0*r1x2E*ZxZpE*VRR1(107,4)+WQz*VRR1(107,10)
      VRR0(108,11)=2.D0*V(306)+2.D0*r1x2E*VRR0(108,2)+QCx*VRR0(108,5)-2.D0*r1x2E*ZxZpE*VRR1(108,2)+WQx*VRR1(108,5)
      VRR0(108,12)=2.D0*V(52)-2.D0*V(54)+PAz*VRR0(72,12)+WPz*VRR1(72,12)
      VRR0(108,13)=2.D0*V(56)-2.D0*V(58)+PAz*VRR0(72,13)+WPz*VRR1(72,13)
      VRR0(108,14)=2.D0*V(281)+2.D0*r1x2E*VRR0(108,3)+QCy*VRR0(108,7)-2.D0*r1x2E*ZxZpE*VRR1(108,3)+WQy*VRR1(108,7)
      VRR0(108,15)=2.D0*V(65)-2.D0*V(67)+V(173)+PAz*VRR0(72,15)+WPz*VRR1(72,15)
      VRR0(108,16)=2.D0*V(69)-2.D0*V(71)+V(176)+PAz*VRR0(72,16)+WPz*VRR1(72,16)
      VRR0(108,17)=2.D0*V(73)-2.D0*V(75)+V(180)+PAz*VRR0(72,17)+WPz*VRR1(72,17)
      VRR0(108,18)=2.D0*V(77)-2.D0*V(79)+V(184)+PAz*VRR0(72,18)+WPz*VRR1(72,18)
      VRR0(108,19)=2.D0*V(82)-2.D0*V(84)+V(196)+PAz*VRR0(72,19)+WPz*VRR1(72,19)
      VRR0(108,20)=3.D0*V(192)+2.D0*r1x2E*VRR0(108,4)+QCz*VRR0(108,10)-2.D0*r1x2E*ZxZpE*VRR1(108,4)+WQz*VRR1(108,10)
      VRR0(109,11)=V(307)+2.D0*r1x2E*VRR0(109,2)+QCx*VRR0(109,5)-2.D0*r1x2E*ZxZpE*VRR1(109,2)+WQx*VRR1(109,5)
      VRR0(109,12)=V(273)+V(275)+V(306)+PAy*VRR0(77,12)+WPy*VRR1(77,12)
      VRR0(109,13)=V(278)+V(280)+2.D0*V(308)+PAy*VRR0(77,13)+WPy*VRR1(77,13)
      VRR0(109,14)=3.D0*V(309)+2.D0*r1x2E*VRR0(109,3)+QCy*VRR0(109,7)-2.D0*r1x2E*ZxZpE*VRR1(109,3)+WQy*VRR1(109,7)
      VRR0(109,15)=V(283)+V(285)+PAy*VRR0(77,15)+WPy*VRR1(77,15)
      VRR0(109,16)=V(289)+V(291)+V(310)+PAy*VRR0(77,16)+WPy*VRR1(77,16)
      VRR0(109,17)=V(294)+V(296)+V(312)+PAy*VRR0(77,17)+WPy*VRR1(77,17)
      VRR0(109,18)=V(298)+V(300)+PAy*VRR0(77,18)+WPy*VRR1(77,18)
      VRR0(109,19)=V(303)+V(305)+V(313)+PAy*VRR0(77,19)+WPy*VRR1(77,19)
      VRR0(109,20)=3.D0*V(219)+2.D0*r1x2E*VRR0(109,4)+QCz*VRR0(109,10)-2.D0*r1x2E*ZxZpE*VRR1(109,4)+WQz*VRR1(109,10)
      VRR0(110,11)=3.D0*V(314)-3.D0*V(315)+PAy*VRR0(78,11)+WPy*VRR1(78,11)
      VRR0(110,12)=V(307)+3.D0*V(316)-3.D0*V(317)+PAy*VRR0(78,12)+WPy*VRR1(78,12)
      VRR0(110,13)=3.D0*V(318)-3.D0*V(319)+2.D0*V(320)+PAy*VRR0(78,13)+WPy*VRR1(78,13)
      VRR0(110,14)=3.D0*V(321)-3.D0*V(322)+3.D0*V(323)+PAy*VRR0(78,14)+WPy*VRR1(78,14)
      VRR0(110,15)=3.D0*V(324)-3.D0*V(325)+PAy*VRR0(78,15)+WPy*VRR1(78,15)
      VRR0(110,16)=3.D0*V(326)-3.D0*V(327)+V(328)+PAy*VRR0(78,16)+WPy*VRR1(78,16)
      VRR0(110,17)=3.D0*V(329)-3.D0*V(330)+V(332)+PAy*VRR0(78,17)+WPy*VRR1(78,17)
      VRR0(110,18)=3.D0*V(333)-3.D0*V(334)+PAy*VRR0(78,18)+WPy*VRR1(78,18)
      VRR0(110,19)=3.D0*V(335)-3.D0*V(336)+V(337)+PAy*VRR0(78,19)+WPy*VRR1(78,19)
      VRR0(110,20)=3.D0*V(338)-3.D0*V(339)+PAy*VRR0(78,20)+WPy*VRR1(78,20)
      VRR0(111,11)=3.D0*V(111)-3.D0*V(112)+PAz*VRR0(75,11)+WPz*VRR1(75,11)
      VRR0(111,12)=3.D0*V(113)-3.D0*V(114)+PAz*VRR0(75,12)+WPz*VRR1(75,12)
      VRR0(111,13)=3.D0*V(115)-3.D0*V(116)+PAz*VRR0(75,13)+WPz*VRR1(75,13)
      VRR0(111,14)=3.D0*V(117)-3.D0*V(118)+PAz*VRR0(75,14)+WPz*VRR1(75,14)
      VRR0(111,15)=3.D0*V(119)-3.D0*V(120)+V(246)+PAz*VRR0(75,15)+WPz*VRR1(75,15)
      VRR0(111,16)=3.D0*V(121)-3.D0*V(122)+V(249)+PAz*VRR0(75,16)+WPz*VRR1(75,16)
      VRR0(111,17)=3.D0*V(123)-3.D0*V(124)+V(252)+PAz*VRR0(75,17)+WPz*VRR1(75,17)
      VRR0(111,18)=3.D0*V(125)-3.D0*V(126)+V(258)+PAz*VRR0(75,18)+WPz*VRR1(75,18)
      VRR0(111,19)=3.D0*V(127)-3.D0*V(128)+2.D0*V(261)+PAz*VRR0(75,19)+WPz*VRR1(75,19)
      VRR0(111,20)=3.D0*V(129)-3.D0*V(130)+3.D0*V(266)+PAz*VRR0(75,20)+WPz*VRR1(75,20)
      VRR0(112,11)=V(132)+V(134)+PAz*VRR0(76,11)+WPz*VRR1(76,11)
      VRR0(112,12)=V(136)+V(138)+PAz*VRR0(76,12)+WPz*VRR1(76,12)
      VRR0(112,13)=V(140)+V(142)+PAz*VRR0(76,13)+WPz*VRR1(76,13)
      VRR0(112,14)=V(145)+V(147)+PAz*VRR0(76,14)+WPz*VRR1(76,14)
      VRR0(112,15)=V(149)+V(151)+V(271)+PAz*VRR0(76,15)+WPz*VRR1(76,15)
      VRR0(112,16)=V(153)+V(155)+V(276)+PAz*VRR0(76,16)+WPz*VRR1(76,16)
      VRR0(112,17)=V(157)+V(159)+V(281)+PAz*VRR0(76,17)+WPz*VRR1(76,17)
      VRR0(112,18)=V(161)+V(163)+V(287)+PAz*VRR0(76,18)+WPz*VRR1(76,18)
      VRR0(112,19)=V(166)+V(168)+2.D0*V(292)+PAz*VRR0(76,19)+WPz*VRR1(76,19)
      VRR0(112,20)=V(170)+V(172)+3.D0*V(301)+PAz*VRR0(76,20)+WPz*VRR1(76,20)
      VRR0(113,11)=V(198)+V(200)+PAz*VRR0(77,11)+WPz*VRR1(77,11)
      VRR0(113,12)=V(201)+V(202)+PAz*VRR0(77,12)+WPz*VRR1(77,12)
      VRR0(113,13)=V(203)+V(204)+PAz*VRR0(77,13)+WPz*VRR1(77,13)
      VRR0(113,14)=V(206)+V(208)+PAz*VRR0(77,14)+WPz*VRR1(77,14)
      VRR0(113,15)=V(209)+V(210)+V(306)+PAz*VRR0(77,15)+WPz*VRR1(77,15)
      VRR0(113,16)=V(211)+V(212)+V(308)+PAz*VRR0(77,16)+WPz*VRR1(77,16)
      VRR0(113,17)=V(213)+V(214)+V(309)+PAz*VRR0(77,17)+WPz*VRR1(77,17)
      VRR0(113,18)=V(215)+V(216)+2.D0*V(310)+PAz*VRR0(77,18)+WPz*VRR1(77,18)
      VRR0(113,19)=V(217)+V(218)+V(312)+PAz*VRR0(77,19)+WPz*VRR1(77,19)
      VRR0(113,20)=V(221)+V(223)+3.D0*V(313)+PAz*VRR0(77,20)+WPz*VRR1(77,20)
      VRR0(114,11)=3.D0*V(224)-3.D0*V(225)+PAz*VRR0(78,11)+WPz*VRR1(78,11)
      VRR0(114,12)=3.D0*V(226)-3.D0*V(227)+PAz*VRR0(78,12)+WPz*VRR1(78,12)
      VRR0(114,13)=3.D0*V(228)-3.D0*V(229)+PAz*VRR0(78,13)+WPz*VRR1(78,13)
      VRR0(114,14)=3.D0*V(230)-3.D0*V(231)+PAz*VRR0(78,14)+WPz*VRR1(78,14)
      VRR0(114,15)=3.D0*V(232)-3.D0*V(233)+V(307)+PAz*VRR0(78,15)+WPz*VRR1(78,15)
      VRR0(114,16)=3.D0*V(234)-3.D0*V(235)+V(320)+PAz*VRR0(78,16)+WPz*VRR1(78,16)
      VRR0(114,17)=3.D0*V(236)-3.D0*V(237)+V(323)+PAz*VRR0(78,17)+WPz*VRR1(78,17)
      VRR0(114,18)=3.D0*V(238)-3.D0*V(239)+2.D0*V(328)+PAz*VRR0(78,18)+WPz*VRR1(78,18)
      VRR0(114,19)=3.D0*V(240)-3.D0*V(241)+V(332)+PAz*VRR0(78,19)+WPz*VRR1(78,19)
      VRR0(114,20)=3.D0*V(242)-3.D0*V(243)+3.D0*V(337)+PAz*VRR0(78,20)+WPz*VRR1(78,20)
      VRR0(115,11)=4.D0*V(244)-4.D0*V(245)+PAz*VRR0(79,11)+WPz*VRR1(79,11)
      VRR0(115,12)=4.D0*V(247)-4.D0*V(248)+PAz*VRR0(79,12)+WPz*VRR1(79,12)
      VRR0(115,13)=4.D0*V(250)-4.D0*V(251)+PAz*VRR0(79,13)+WPz*VRR1(79,13)
      VRR0(115,14)=4.D0*V(253)-4.D0*V(254)+PAz*VRR0(79,14)+WPz*VRR1(79,14)
      VRR0(115,15)=4.D0*V(255)-4.D0*V(256)+PAz*VRR0(79,15)+HfxZpE*VRR1(79,5)+WPz*VRR1(79,15)
      VRR0(115,16)=4.D0*V(259)-4.D0*V(260)+PAz*VRR0(79,16)+HfxZpE*VRR1(79,6)+WPz*VRR1(79,16)
      VRR0(115,17)=4.D0*V(262)-4.D0*V(263)+PAz*VRR0(79,17)+HfxZpE*VRR1(79,7)+WPz*VRR1(79,17)
      VRR0(115,18)=4.D0*V(264)-4.D0*V(265)+PAz*VRR0(79,18)+2.D0*HfxZpE*VRR1(79,8)+WPz*VRR1(79,18)
      VRR0(115,19)=4.D0*V(267)-4.D0*V(268)+PAz*VRR0(79,19)+2.D0*HfxZpE*VRR1(79,9)+WPz*VRR1(79,19)
      VRR0(115,20)=4.D0*V(269)-4.D0*V(270)+PAz*VRR0(79,20)+3.D0*HfxZpE*VRR1(79,10)+WPz*VRR1(79,20)
      VRR0(116,11)=4.D0*r1x2Z*VRR0(52,11)+PAz*VRR0(80,11)-4.D0*ExZpE*r1x2Z*VRR1(52,11)+WPz*VRR1(80,11)
      VRR0(116,12)=4.D0*V(272)-4.D0*V(274)+PAz*VRR0(80,12)+WPz*VRR1(80,12)
      VRR0(116,13)=4.D0*V(277)-4.D0*V(279)+PAz*VRR0(80,13)+WPz*VRR1(80,13)
      VRR0(116,14)=4.D0*r1x2Z*VRR0(52,14)+PAz*VRR0(80,14)-4.D0*ExZpE*r1x2Z*VRR1(52,14)+WPz*VRR1(80,14)
      VRR0(116,15)=4.D0*V(282)-4.D0*V(284)+PAz*VRR0(80,15)+HfxZpE*VRR1(80,5)+WPz*VRR1(80,15)
      VRR0(116,16)=4.D0*V(288)-4.D0*V(290)+PAz*VRR0(80,16)+HfxZpE*VRR1(80,6)+WPz*VRR1(80,16)
      VRR0(116,17)=4.D0*V(293)-4.D0*V(295)+PAz*VRR0(80,17)+HfxZpE*VRR1(80,7)+WPz*VRR1(80,17)
      VRR0(116,18)=4.D0*V(297)-4.D0*V(299)+PAz*VRR0(80,18)+2.D0*HfxZpE*VRR1(80,8)+WPz*VRR1(80,18)
      VRR0(116,19)=4.D0*V(302)-4.D0*V(304)+PAz*VRR0(80,19)+2.D0*HfxZpE*VRR1(80,9)+WPz*VRR1(80,19)
      VRR0(116,20)=4.D0*r1x2Z*VRR0(52,20)+PAz*VRR0(80,20)-4.D0*ExZpE*r1x2Z*VRR1(52,20)+3.D0*HfxZpE*VRR1(80,10)+WPz*VRR1(80,20)
      VRR0(117,11)=4.D0*V(314)-4.D0*V(315)+PAz*VRR0(81,11)+WPz*VRR1(81,11)
      VRR0(117,12)=4.D0*V(316)-4.D0*V(317)+PAz*VRR0(81,12)+WPz*VRR1(81,12)
      VRR0(117,13)=4.D0*V(318)-4.D0*V(319)+PAz*VRR0(81,13)+WPz*VRR1(81,13)
      VRR0(117,14)=4.D0*V(321)-4.D0*V(322)+PAz*VRR0(81,14)+WPz*VRR1(81,14)
      VRR0(117,15)=4.D0*V(324)-4.D0*V(325)+PAz*VRR0(81,15)+HfxZpE*VRR1(81,5)+WPz*VRR1(81,15)
      VRR0(117,16)=4.D0*V(326)-4.D0*V(327)+PAz*VRR0(81,16)+HfxZpE*VRR1(81,6)+WPz*VRR1(81,16)
      VRR0(117,17)=4.D0*V(329)-4.D0*V(330)+PAz*VRR0(81,17)+HfxZpE*VRR1(81,7)+WPz*VRR1(81,17)
      VRR0(117,18)=4.D0*V(333)-4.D0*V(334)+PAz*VRR0(81,18)+2.D0*HfxZpE*VRR1(81,8)+WPz*VRR1(81,18)
      VRR0(117,19)=4.D0*V(335)-4.D0*V(336)+PAz*VRR0(81,19)+2.D0*HfxZpE*VRR1(81,9)+WPz*VRR1(81,19)
      VRR0(117,20)=4.D0*V(338)-4.D0*V(339)+PAz*VRR0(81,20)+3.D0*HfxZpE*VRR1(81,10)+WPz*VRR1(81,20)
      VRR0(118,11)=5.D0*r1x2Z*VRR0(54,11)+PAz*VRR0(82,11)-5.D0*ExZpE*r1x2Z*VRR1(54,11)+WPz*VRR1(82,11)
      VRR0(118,12)=5.D0*r1x2Z*VRR0(54,12)+PAz*VRR0(82,12)-5.D0*ExZpE*r1x2Z*VRR1(54,12)+WPz*VRR1(82,12)
      VRR0(118,13)=5.D0*r1x2Z*VRR0(54,13)+PAz*VRR0(82,13)-5.D0*ExZpE*r1x2Z*VRR1(54,13)+WPz*VRR1(82,13)
      VRR0(118,14)=5.D0*r1x2Z*VRR0(54,14)+PAz*VRR0(82,14)-5.D0*ExZpE*r1x2Z*VRR1(54,14)+WPz*VRR1(82,14)
      VRR0(118,15)=5.D0*r1x2Z*VRR0(54,15)+PAz*VRR0(82,15)-5.D0*ExZpE*r1x2Z*VRR1(54,15)+HfxZpE*VRR1(82,5)+WPz*VRR1(82,15)
      VRR0(118,16)=5.D0*r1x2Z*VRR0(54,16)+PAz*VRR0(82,16)-5.D0*ExZpE*r1x2Z*VRR1(54,16)+HfxZpE*VRR1(82,6)+WPz*VRR1(82,16)
      VRR0(118,17)=5.D0*r1x2Z*VRR0(54,17)+PAz*VRR0(82,17)-5.D0*ExZpE*r1x2Z*VRR1(54,17)+HfxZpE*VRR1(82,7)+WPz*VRR1(82,17)
      VRR0(118,18)=5.D0*r1x2Z*VRR0(54,18)+PAz*VRR0(82,18)-5.D0*ExZpE*r1x2Z*VRR1(54,18)+2.D0*HfxZpE*VRR1(82,8)+WPz*VRR1(82,18)
      VRR0(118,19)=5.D0*r1x2Z*VRR0(54,19)+PAz*VRR0(82,19)-5.D0*ExZpE*r1x2Z*VRR1(54,19)+2.D0*HfxZpE*VRR1(82,9)+WPz*VRR1(82,19)
      VRR0(118,20)=5.D0*r1x2Z*VRR0(54,20)+PAz*VRR0(82,20)-5.D0*ExZpE*r1x2Z*VRR1(54,20)+3.D0*HfxZpE*VRR1(82,10)+WPz*VRR1(82,20)
      VRR0(119,11)=5.D0*r1x2Z*VRR0(55,11)+PAz*VRR0(83,11)-5.D0*ExZpE*r1x2Z*VRR1(55,11)+WPz*VRR1(83,11)
      VRR0(119,12)=5.D0*r1x2Z*VRR0(55,12)+PAz*VRR0(83,12)-5.D0*ExZpE*r1x2Z*VRR1(55,12)+WPz*VRR1(83,12)
      VRR0(119,13)=5.D0*r1x2Z*VRR0(55,13)+PAz*VRR0(83,13)-5.D0*ExZpE*r1x2Z*VRR1(55,13)+WPz*VRR1(83,13)
      VRR0(119,14)=5.D0*r1x2Z*VRR0(55,14)+PAz*VRR0(83,14)-5.D0*ExZpE*r1x2Z*VRR1(55,14)+WPz*VRR1(83,14)
      VRR0(119,15)=5.D0*r1x2Z*VRR0(55,15)+PAz*VRR0(83,15)-5.D0*ExZpE*r1x2Z*VRR1(55,15)+HfxZpE*VRR1(83,5)+WPz*VRR1(83,15)
      VRR0(119,16)=5.D0*r1x2Z*VRR0(55,16)+PAz*VRR0(83,16)-5.D0*ExZpE*r1x2Z*VRR1(55,16)+HfxZpE*VRR1(83,6)+WPz*VRR1(83,16)
      VRR0(119,17)=5.D0*r1x2Z*VRR0(55,17)+PAz*VRR0(83,17)-5.D0*ExZpE*r1x2Z*VRR1(55,17)+HfxZpE*VRR1(83,7)+WPz*VRR1(83,17)
      VRR0(119,18)=5.D0*r1x2Z*VRR0(55,18)+PAz*VRR0(83,18)-5.D0*ExZpE*r1x2Z*VRR1(55,18)+2.D0*HfxZpE*VRR1(83,8)+WPz*VRR1(83,18)
      VRR0(119,19)=5.D0*r1x2Z*VRR0(55,19)+PAz*VRR0(83,19)-5.D0*ExZpE*r1x2Z*VRR1(55,19)+2.D0*HfxZpE*VRR1(83,9)+WPz*VRR1(83,19)
      VRR0(119,20)=5.D0*r1x2Z*VRR0(55,20)+PAz*VRR0(83,20)-5.D0*ExZpE*r1x2Z*VRR1(55,20)+3.D0*HfxZpE*VRR1(83,10)+WPz*VRR1(83,20)
      VRR0(120,11)=6.D0*r1x2Z*VRR0(56,11)+PAz*VRR0(84,11)-6.D0*ExZpE*r1x2Z*VRR1(56,11)+WPz*VRR1(84,11)
      VRR0(120,12)=6.D0*r1x2Z*VRR0(56,12)+PAz*VRR0(84,12)-6.D0*ExZpE*r1x2Z*VRR1(56,12)+WPz*VRR1(84,12)
      VRR0(120,13)=6.D0*r1x2Z*VRR0(56,13)+PAz*VRR0(84,13)-6.D0*ExZpE*r1x2Z*VRR1(56,13)+WPz*VRR1(84,13)
      VRR0(120,14)=6.D0*r1x2Z*VRR0(56,14)+PAz*VRR0(84,14)-6.D0*ExZpE*r1x2Z*VRR1(56,14)+WPz*VRR1(84,14)
      VRR0(120,15)=6.D0*r1x2Z*VRR0(56,15)+PAz*VRR0(84,15)-6.D0*ExZpE*r1x2Z*VRR1(56,15)+HfxZpE*VRR1(84,5)+WPz*VRR1(84,15)
      VRR0(120,16)=6.D0*r1x2Z*VRR0(56,16)+PAz*VRR0(84,16)-6.D0*ExZpE*r1x2Z*VRR1(56,16)+HfxZpE*VRR1(84,6)+WPz*VRR1(84,16)
      VRR0(120,17)=6.D0*r1x2Z*VRR0(56,17)+PAz*VRR0(84,17)-6.D0*ExZpE*r1x2Z*VRR1(56,17)+HfxZpE*VRR1(84,7)+WPz*VRR1(84,17)
      VRR0(120,18)=6.D0*r1x2Z*VRR0(56,18)+PAz*VRR0(84,18)-6.D0*ExZpE*r1x2Z*VRR1(56,18)+2.D0*HfxZpE*VRR1(84,8)+WPz*VRR1(84,18)
      VRR0(120,19)=6.D0*r1x2Z*VRR0(56,19)+PAz*VRR0(84,19)-6.D0*ExZpE*r1x2Z*VRR1(56,19)+2.D0*HfxZpE*VRR1(84,9)+WPz*VRR1(84,19)
      VRR0(120,20)=6.D0*r1x2Z*VRR0(56,20)+PAz*VRR0(84,20)-6.D0*ExZpE*r1x2Z*VRR1(56,20)+3.D0*HfxZpE*VRR1(84,10)+WPz*VRR1(84,20)
END SUBROUTINE VRRj0f0
