!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRi0d0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(23,5)
      V(2)=3.D0*V(1)
      V(3)=ExZpE*r1x2Z*VRR1(23,5)
      V(4)=-3.D0*V(3)
      V(5)=r1x2Z*VRR0(23,6)
      V(6)=3.D0*V(5)
      V(7)=ExZpE*r1x2Z*VRR1(23,6)
      V(8)=-3.D0*V(7)
      V(9)=r1x2Z*VRR0(23,7)
      V(10)=3.D0*V(9)
      V(11)=ExZpE*r1x2Z*VRR1(23,7)
      V(12)=-3.D0*V(11)
      V(13)=r1x2Z*VRR0(23,8)
      V(14)=3.D0*V(13)
      V(15)=ExZpE*r1x2Z*VRR1(23,8)
      V(16)=-3.D0*V(15)
      V(17)=r1x2Z*VRR0(23,9)
      V(18)=3.D0*V(17)
      V(19)=ExZpE*r1x2Z*VRR1(23,9)
      V(20)=-3.D0*V(19)
      V(21)=r1x2Z*VRR0(23,10)
      V(22)=3.D0*V(21)
      V(23)=ExZpE*r1x2Z*VRR1(23,10)
      V(24)=-3.D0*V(23)
      V(25)=r1x2Z*VRR0(24,5)
      V(26)=ExZpE*r1x2Z*VRR1(24,5)
      V(27)=HfxZpE*VRR1(39,2)
      V(28)=r1x2Z*VRR0(24,6)
      V(29)=ExZpE*r1x2Z*VRR1(24,6)
      V(30)=HfxZpE*VRR1(39,3)
      V(31)=r1x2Z*VRR0(24,7)
      V(32)=ExZpE*r1x2Z*VRR1(24,7)
      V(33)=r1x2Z*VRR0(24,8)
      V(34)=ExZpE*r1x2Z*VRR1(24,8)
      V(35)=HfxZpE*VRR1(39,4)
      V(36)=r1x2Z*VRR0(24,9)
      V(37)=ExZpE*r1x2Z*VRR1(24,9)
      V(38)=r1x2Z*VRR0(24,10)
      V(39)=ExZpE*r1x2Z*VRR1(24,10)
      V(40)=r1x2Z*VRR0(27,5)
      V(41)=ExZpE*r1x2Z*VRR1(27,5)
      V(42)=r1x2Z*VRR0(27,6)
      V(43)=ExZpE*r1x2Z*VRR1(27,6)
      V(44)=r1x2Z*VRR0(27,7)
      V(45)=ExZpE*r1x2Z*VRR1(27,7)
      V(46)=r1x2Z*VRR0(27,8)
      V(47)=ExZpE*r1x2Z*VRR1(27,8)
      V(48)=r1x2Z*VRR0(27,9)
      V(49)=ExZpE*r1x2Z*VRR1(27,9)
      V(50)=r1x2Z*VRR0(27,10)
      V(51)=ExZpE*r1x2Z*VRR1(27,10)
      V(52)=r1x2Z*VRR0(28,5)
      V(53)=2.D0*V(52)
      V(54)=ExZpE*r1x2Z*VRR1(28,5)
      V(55)=-2.D0*V(54)
      V(56)=HfxZpE*VRR1(44,2)
      V(57)=r1x2Z*VRR0(28,6)
      V(58)=2.D0*V(57)
      V(59)=ExZpE*r1x2Z*VRR1(28,6)
      V(60)=-2.D0*V(59)
      V(61)=HfxZpE*VRR1(44,3)
      V(62)=r1x2Z*VRR0(28,7)
      V(63)=2.D0*V(62)
      V(64)=ExZpE*r1x2Z*VRR1(28,7)
      V(65)=-2.D0*V(64)
      V(66)=r1x2Z*VRR0(28,8)
      V(67)=2.D0*V(66)
      V(68)=ExZpE*r1x2Z*VRR1(28,8)
      V(69)=-2.D0*V(68)
      V(70)=HfxZpE*VRR1(44,4)
      V(71)=r1x2Z*VRR0(28,9)
      V(72)=2.D0*V(71)
      V(73)=ExZpE*r1x2Z*VRR1(28,9)
      V(74)=-2.D0*V(73)
      V(75)=r1x2Z*VRR0(28,10)
      V(76)=2.D0*V(75)
      V(77)=ExZpE*r1x2Z*VRR1(28,10)
      V(78)=-2.D0*V(77)
      V(79)=2.D0*V(40)
      V(80)=-2.D0*V(41)
      V(81)=2.D0*V(42)
      V(82)=-2.D0*V(43)
      V(83)=2.D0*V(44)
      V(84)=-2.D0*V(45)
      V(85)=2.D0*V(46)
      V(86)=-2.D0*V(47)
      V(87)=2.D0*V(48)
      V(88)=-2.D0*V(49)
      V(89)=2.D0*V(50)
      V(90)=-2.D0*V(51)
      V(91)=r1x2Z*VRR0(30,5)
      V(92)=3.D0*V(91)
      V(93)=ExZpE*r1x2Z*VRR1(30,5)
      V(94)=-3.D0*V(93)
      V(95)=r1x2Z*VRR0(30,6)
      V(96)=3.D0*V(95)
      V(97)=ExZpE*r1x2Z*VRR1(30,6)
      V(98)=-3.D0*V(97)
      V(99)=r1x2Z*VRR0(30,7)
      V(100)=3.D0*V(99)
      V(101)=ExZpE*r1x2Z*VRR1(30,7)
      V(102)=-3.D0*V(101)
      V(103)=r1x2Z*VRR0(30,8)
      V(104)=3.D0*V(103)
      V(105)=ExZpE*r1x2Z*VRR1(30,8)
      V(106)=-3.D0*V(105)
      V(107)=r1x2Z*VRR0(30,9)
      V(108)=3.D0*V(107)
      V(109)=ExZpE*r1x2Z*VRR1(30,9)
      V(110)=-3.D0*V(109)
      V(111)=r1x2Z*VRR0(30,10)
      V(112)=3.D0*V(111)
      V(113)=ExZpE*r1x2Z*VRR1(30,10)
      V(114)=-3.D0*V(113)
      V(115)=r1x2Z*VRR0(31,5)
      V(116)=2.D0*V(115)
      V(117)=ExZpE*r1x2Z*VRR1(31,5)
      V(118)=-2.D0*V(117)
      V(119)=HfxZpE*VRR1(48,2)
      V(120)=r1x2Z*VRR0(31,6)
      V(121)=2.D0*V(120)
      V(122)=ExZpE*r1x2Z*VRR1(31,6)
      V(123)=-2.D0*V(122)
      V(124)=HfxZpE*VRR1(48,3)
      V(125)=r1x2Z*VRR0(31,7)
      V(126)=2.D0*V(125)
      V(127)=ExZpE*r1x2Z*VRR1(31,7)
      V(128)=-2.D0*V(127)
      V(129)=r1x2Z*VRR0(31,8)
      V(130)=2.D0*V(129)
      V(131)=ExZpE*r1x2Z*VRR1(31,8)
      V(132)=-2.D0*V(131)
      V(133)=HfxZpE*VRR1(48,4)
      V(134)=r1x2Z*VRR0(31,9)
      V(135)=2.D0*V(134)
      V(136)=ExZpE*r1x2Z*VRR1(31,9)
      V(137)=-2.D0*V(136)
      V(138)=r1x2Z*VRR0(31,10)
      V(139)=2.D0*V(138)
      V(140)=ExZpE*r1x2Z*VRR1(31,10)
      V(141)=-2.D0*V(140)
      V(142)=r1x2E*VRR0(72,1)
      V(143)=HfxZpE*VRR1(49,2)
      V(144)=r1x2E*ZxZpE*VRR1(72,1)
      V(145)=-V(144)
      V(146)=r1x2Z*VRR0(32,6)
      V(147)=ExZpE*r1x2Z*VRR1(32,6)
      V(148)=HfxZpE*VRR1(49,3)
      V(149)=r1x2Z*VRR0(32,8)
      V(150)=ExZpE*r1x2Z*VRR1(32,8)
      V(151)=HfxZpE*VRR1(49,4)
      V(152)=r1x2Z*VRR0(32,9)
      V(153)=ExZpE*r1x2Z*VRR1(32,9)
      V(154)=r1x2Z*VRR0(32,5)
      V(155)=3.D0*V(154)
      V(156)=ExZpE*r1x2Z*VRR1(32,5)
      V(157)=-3.D0*V(156)
      V(158)=3.D0*V(146)
      V(159)=-3.D0*V(147)
      V(160)=r1x2Z*VRR0(32,7)
      V(161)=3.D0*V(160)
      V(162)=ExZpE*r1x2Z*VRR1(32,7)
      V(163)=-3.D0*V(162)
      V(164)=3.D0*V(149)
      V(165)=-3.D0*V(150)
      V(166)=3.D0*V(152)
      V(167)=-3.D0*V(153)
      V(168)=r1x2Z*VRR0(32,10)
      V(169)=3.D0*V(168)
      V(170)=ExZpE*r1x2Z*VRR1(32,10)
      V(171)=-3.D0*V(170)
      V(172)=r1x2Z*VRR0(33,5)
      V(173)=ExZpE*r1x2Z*VRR1(33,5)
      V(174)=HfxZpE*VRR1(51,2)
      V(175)=r1x2Z*VRR0(33,6)
      V(176)=ExZpE*r1x2Z*VRR1(33,6)
      V(177)=HfxZpE*VRR1(51,3)
      V(178)=r1x2Z*VRR0(33,7)
      V(179)=ExZpE*r1x2Z*VRR1(33,7)
      V(180)=r1x2Z*VRR0(33,8)
      V(181)=ExZpE*r1x2Z*VRR1(33,8)
      V(182)=HfxZpE*VRR1(51,4)
      V(183)=r1x2Z*VRR0(33,9)
      V(184)=ExZpE*r1x2Z*VRR1(33,9)
      V(185)=r1x2Z*VRR0(33,10)
      V(186)=ExZpE*r1x2Z*VRR1(33,10)
      V(187)=r1x2Z*VRR0(34,5)
      V(188)=ExZpE*r1x2Z*VRR1(34,5)
      V(189)=r1x2Z*VRR0(34,6)
      V(190)=ExZpE*r1x2Z*VRR1(34,6)
      V(191)=HfxZpE*VRR1(53,2)
      V(192)=r1x2Z*VRR0(34,7)
      V(193)=ExZpE*r1x2Z*VRR1(34,7)
      V(194)=HfxZpE*VRR1(53,3)
      V(195)=r1x2Z*VRR0(34,8)
      V(196)=ExZpE*r1x2Z*VRR1(34,8)
      V(197)=r1x2Z*VRR0(34,9)
      V(198)=ExZpE*r1x2Z*VRR1(34,9)
      V(199)=HfxZpE*VRR1(53,4)
      V(200)=r1x2Z*VRR0(34,10)
      V(201)=ExZpE*r1x2Z*VRR1(34,10)
      VRR0(57,5)=5.D0*r1x2Z*VRR0(21,5)+PAx*VRR0(36,5)-5.D0*ExZpE*r1x2Z*VRR1(21,5)+2.D0*HfxZpE*VRR1(36,2)+WPx*VRR1(36,5)
      VRR0(57,6)=5.D0*r1x2Z*VRR0(21,6)+PAx*VRR0(36,6)-5.D0*ExZpE*r1x2Z*VRR1(21,6)+HfxZpE*VRR1(36,3)+WPx*VRR1(36,6)
      VRR0(57,7)=5.D0*r1x2Z*VRR0(21,7)+PAx*VRR0(36,7)-5.D0*ExZpE*r1x2Z*VRR1(21,7)+WPx*VRR1(36,7)
      VRR0(57,8)=5.D0*r1x2Z*VRR0(21,8)+PAx*VRR0(36,8)-5.D0*ExZpE*r1x2Z*VRR1(21,8)+HfxZpE*VRR1(36,4)+WPx*VRR1(36,8)
      VRR0(57,9)=5.D0*r1x2Z*VRR0(21,9)+PAx*VRR0(36,9)-5.D0*ExZpE*r1x2Z*VRR1(21,9)+WPx*VRR1(36,9)
      VRR0(57,10)=5.D0*r1x2Z*VRR0(21,10)+PAx*VRR0(36,10)-5.D0*ExZpE*r1x2Z*VRR1(21,10)+WPx*VRR1(36,10)
      VRR0(58,5)=4.D0*r1x2Z*VRR0(22,5)+PAx*VRR0(37,5)-4.D0*ExZpE*r1x2Z*VRR1(22,5)+2.D0*HfxZpE*VRR1(37,2)+WPx*VRR1(37,5)
      VRR0(58,6)=4.D0*r1x2Z*VRR0(22,6)+PAx*VRR0(37,6)-4.D0*ExZpE*r1x2Z*VRR1(22,6)+HfxZpE*VRR1(37,3)+WPx*VRR1(37,6)
      VRR0(58,7)=4.D0*r1x2Z*VRR0(22,7)+PAx*VRR0(37,7)-4.D0*ExZpE*r1x2Z*VRR1(22,7)+WPx*VRR1(37,7)
      VRR0(58,8)=4.D0*r1x2Z*VRR0(22,8)+PAx*VRR0(37,8)-4.D0*ExZpE*r1x2Z*VRR1(22,8)+HfxZpE*VRR1(37,4)+WPx*VRR1(37,8)
      VRR0(58,9)=4.D0*r1x2Z*VRR0(22,9)+PAx*VRR0(37,9)-4.D0*ExZpE*r1x2Z*VRR1(22,9)+WPx*VRR1(37,9)
      VRR0(58,10)=4.D0*r1x2Z*VRR0(22,10)+PAx*VRR0(37,10)-4.D0*ExZpE*r1x2Z*VRR1(22,10)+WPx*VRR1(37,10)
      VRR0(59,5)=V(2)+V(4)+PAx*VRR0(38,5)+2.D0*HfxZpE*VRR1(38,2)+WPx*VRR1(38,5)
      VRR0(59,6)=V(6)+V(8)+PAx*VRR0(38,6)+HfxZpE*VRR1(38,3)+WPx*VRR1(38,6)
      VRR0(59,7)=V(10)+V(12)+PAx*VRR0(38,7)+WPx*VRR1(38,7)
      VRR0(59,8)=V(14)+V(16)+PAx*VRR0(38,8)+HfxZpE*VRR1(38,4)+WPx*VRR1(38,8)
      VRR0(59,9)=V(18)+V(20)+PAx*VRR0(38,9)+WPx*VRR1(38,9)
      VRR0(59,10)=V(22)+V(24)+PAx*VRR0(38,10)+WPx*VRR1(38,10)
      VRR0(60,5)=2.D0*V(25)-2.D0*V(26)+2.D0*V(27)+PAx*VRR0(39,5)+WPx*VRR1(39,5)
      VRR0(60,6)=2.D0*V(28)-2.D0*V(29)+V(30)+PAx*VRR0(39,6)+WPx*VRR1(39,6)
      VRR0(60,7)=2.D0*V(31)-2.D0*V(32)+PAx*VRR0(39,7)+WPx*VRR1(39,7)
      VRR0(60,8)=2.D0*V(33)-2.D0*V(34)+V(35)+PAx*VRR0(39,8)+WPx*VRR1(39,8)
      VRR0(60,9)=2.D0*V(36)-2.D0*V(37)+PAx*VRR0(39,9)+WPx*VRR1(39,9)
      VRR0(60,10)=2.D0*V(38)-2.D0*V(39)+PAx*VRR0(39,10)+WPx*VRR1(39,10)
      VRR0(61,5)=V(2)+V(4)+PAy*VRR0(39,5)+WPy*VRR1(39,5)
      VRR0(61,6)=V(6)+V(8)+V(27)+PAy*VRR0(39,6)+WPy*VRR1(39,6)
      VRR0(61,7)=V(10)+V(12)+2.D0*V(30)+PAy*VRR0(39,7)+WPy*VRR1(39,7)
      VRR0(61,8)=V(14)+V(16)+PAy*VRR0(39,8)+WPy*VRR1(39,8)
      VRR0(61,9)=V(18)+V(20)+V(35)+PAy*VRR0(39,9)+WPy*VRR1(39,9)
      VRR0(61,10)=V(22)+V(24)+PAy*VRR0(39,10)+WPy*VRR1(39,10)
      VRR0(62,5)=4.D0*V(25)-4.D0*V(26)+PAy*VRR0(40,5)+WPy*VRR1(40,5)
      VRR0(62,6)=4.D0*V(28)-4.D0*V(29)+PAy*VRR0(40,6)+HfxZpE*VRR1(40,2)+WPy*VRR1(40,6)
      VRR0(62,7)=4.D0*V(31)-4.D0*V(32)+PAy*VRR0(40,7)+2.D0*HfxZpE*VRR1(40,3)+WPy*VRR1(40,7)
      VRR0(62,8)=4.D0*V(33)-4.D0*V(34)+PAy*VRR0(40,8)+WPy*VRR1(40,8)
      VRR0(62,9)=4.D0*V(36)-4.D0*V(37)+PAy*VRR0(40,9)+HfxZpE*VRR1(40,4)+WPy*VRR1(40,9)
      VRR0(62,10)=4.D0*V(38)-4.D0*V(39)+PAy*VRR0(40,10)+WPy*VRR1(40,10)
      VRR0(63,5)=5.D0*r1x2Z*VRR0(25,5)+PAy*VRR0(41,5)-5.D0*ExZpE*r1x2Z*VRR1(25,5)+WPy*VRR1(41,5)
      VRR0(63,6)=5.D0*r1x2Z*VRR0(25,6)+PAy*VRR0(41,6)-5.D0*ExZpE*r1x2Z*VRR1(25,6)+HfxZpE*VRR1(41,2)+WPy*VRR1(41,6)
      VRR0(63,7)=5.D0*r1x2Z*VRR0(25,7)+PAy*VRR0(41,7)-5.D0*ExZpE*r1x2Z*VRR1(25,7)+2.D0*HfxZpE*VRR1(41,3)+WPy*VRR1(41,7)
      VRR0(63,8)=5.D0*r1x2Z*VRR0(25,8)+PAy*VRR0(41,8)-5.D0*ExZpE*r1x2Z*VRR1(25,8)+WPy*VRR1(41,8)
      VRR0(63,9)=5.D0*r1x2Z*VRR0(25,9)+PAy*VRR0(41,9)-5.D0*ExZpE*r1x2Z*VRR1(25,9)+HfxZpE*VRR1(41,4)+WPy*VRR1(41,9)
      VRR0(63,10)=5.D0*r1x2Z*VRR0(25,10)+PAy*VRR0(41,10)-5.D0*ExZpE*r1x2Z*VRR1(25,10)+WPy*VRR1(41,10)
      VRR0(64,5)=4.D0*r1x2Z*VRR0(26,5)+PAx*VRR0(42,5)-4.D0*ExZpE*r1x2Z*VRR1(26,5)+2.D0*HfxZpE*VRR1(42,2)+WPx*VRR1(42,5)
      VRR0(64,6)=4.D0*r1x2Z*VRR0(26,6)+PAx*VRR0(42,6)-4.D0*ExZpE*r1x2Z*VRR1(26,6)+HfxZpE*VRR1(42,3)+WPx*VRR1(42,6)
      VRR0(64,7)=4.D0*r1x2Z*VRR0(26,7)+PAx*VRR0(42,7)-4.D0*ExZpE*r1x2Z*VRR1(26,7)+WPx*VRR1(42,7)
      VRR0(64,8)=4.D0*r1x2Z*VRR0(26,8)+PAx*VRR0(42,8)-4.D0*ExZpE*r1x2Z*VRR1(26,8)+HfxZpE*VRR1(42,4)+WPx*VRR1(42,8)
      VRR0(64,9)=4.D0*r1x2Z*VRR0(26,9)+PAx*VRR0(42,9)-4.D0*ExZpE*r1x2Z*VRR1(26,9)+WPx*VRR1(42,9)
      VRR0(64,10)=4.D0*r1x2Z*VRR0(26,10)+PAx*VRR0(42,10)-4.D0*ExZpE*r1x2Z*VRR1(26,10)+WPx*VRR1(42,10)
      VRR0(65,5)=3.D0*V(40)-3.D0*V(41)+PAx*VRR0(43,5)+2.D0*HfxZpE*VRR1(43,2)+WPx*VRR1(43,5)
      VRR0(65,6)=3.D0*V(42)-3.D0*V(43)+PAx*VRR0(43,6)+HfxZpE*VRR1(43,3)+WPx*VRR1(43,6)
      VRR0(65,7)=3.D0*V(44)-3.D0*V(45)+PAx*VRR0(43,7)+WPx*VRR1(43,7)
      VRR0(65,8)=3.D0*V(46)-3.D0*V(47)+PAx*VRR0(43,8)+HfxZpE*VRR1(43,4)+WPx*VRR1(43,8)
      VRR0(65,9)=3.D0*V(48)-3.D0*V(49)+PAx*VRR0(43,9)+WPx*VRR1(43,9)
      VRR0(65,10)=3.D0*V(50)-3.D0*V(51)+PAx*VRR0(43,10)+WPx*VRR1(43,10)
      VRR0(66,5)=V(53)+V(55)+2.D0*V(56)+PAx*VRR0(44,5)+WPx*VRR1(44,5)
      VRR0(66,6)=V(58)+V(60)+V(61)+PAx*VRR0(44,6)+WPx*VRR1(44,6)
      VRR0(66,7)=V(63)+V(65)+PAx*VRR0(44,7)+WPx*VRR1(44,7)
      VRR0(66,8)=V(67)+V(69)+V(70)+PAx*VRR0(44,8)+WPx*VRR1(44,8)
      VRR0(66,9)=V(72)+V(74)+PAx*VRR0(44,9)+WPx*VRR1(44,9)
      VRR0(66,10)=V(76)+V(78)+PAx*VRR0(44,10)+WPx*VRR1(44,10)
      VRR0(67,5)=V(79)+V(80)+PAy*VRR0(44,5)+WPy*VRR1(44,5)
      VRR0(67,6)=V(56)+V(81)+V(82)+PAy*VRR0(44,6)+WPy*VRR1(44,6)
      VRR0(67,7)=2.D0*V(61)+V(83)+V(84)+PAy*VRR0(44,7)+WPy*VRR1(44,7)
      VRR0(67,8)=V(85)+V(86)+PAy*VRR0(44,8)+WPy*VRR1(44,8)
      VRR0(67,9)=V(70)+V(87)+V(88)+PAy*VRR0(44,9)+WPy*VRR1(44,9)
      VRR0(67,10)=V(89)+V(90)+PAy*VRR0(44,10)+WPy*VRR1(44,10)
      VRR0(68,5)=3.D0*V(52)-3.D0*V(54)+PAy*VRR0(45,5)+WPy*VRR1(45,5)
      VRR0(68,6)=3.D0*V(57)-3.D0*V(59)+PAy*VRR0(45,6)+HfxZpE*VRR1(45,2)+WPy*VRR1(45,6)
      VRR0(68,7)=3.D0*V(62)-3.D0*V(64)+PAy*VRR0(45,7)+2.D0*HfxZpE*VRR1(45,3)+WPy*VRR1(45,7)
      VRR0(68,8)=3.D0*V(66)-3.D0*V(68)+PAy*VRR0(45,8)+WPy*VRR1(45,8)
      VRR0(68,9)=3.D0*V(71)-3.D0*V(73)+PAy*VRR0(45,9)+HfxZpE*VRR1(45,4)+WPy*VRR1(45,9)
      VRR0(68,10)=3.D0*V(75)-3.D0*V(77)+PAy*VRR0(45,10)+WPy*VRR1(45,10)
      VRR0(69,5)=4.D0*r1x2Z*VRR0(29,5)+PAy*VRR0(46,5)-4.D0*ExZpE*r1x2Z*VRR1(29,5)+WPy*VRR1(46,5)
      VRR0(69,6)=4.D0*r1x2Z*VRR0(29,6)+PAy*VRR0(46,6)-4.D0*ExZpE*r1x2Z*VRR1(29,6)+HfxZpE*VRR1(46,2)+WPy*VRR1(46,6)
      VRR0(69,7)=4.D0*r1x2Z*VRR0(29,7)+PAy*VRR0(46,7)-4.D0*ExZpE*r1x2Z*VRR1(29,7)+2.D0*HfxZpE*VRR1(46,3)+WPy*VRR1(46,7)
      VRR0(69,8)=4.D0*r1x2Z*VRR0(29,8)+PAy*VRR0(46,8)-4.D0*ExZpE*r1x2Z*VRR1(29,8)+WPy*VRR1(46,8)
      VRR0(69,9)=4.D0*r1x2Z*VRR0(29,9)+PAy*VRR0(46,9)-4.D0*ExZpE*r1x2Z*VRR1(29,9)+HfxZpE*VRR1(46,4)+WPy*VRR1(46,9)
      VRR0(69,10)=4.D0*r1x2Z*VRR0(29,10)+PAy*VRR0(46,10)-4.D0*ExZpE*r1x2Z*VRR1(29,10)+WPy*VRR1(46,10)
      VRR0(70,5)=V(92)+V(94)+PAx*VRR0(47,5)+2.D0*HfxZpE*VRR1(47,2)+WPx*VRR1(47,5)
      VRR0(70,6)=V(96)+V(98)+PAx*VRR0(47,6)+HfxZpE*VRR1(47,3)+WPx*VRR1(47,6)
      VRR0(70,7)=V(100)+V(102)+PAx*VRR0(47,7)+WPx*VRR1(47,7)
      VRR0(70,8)=V(104)+V(106)+PAx*VRR0(47,8)+HfxZpE*VRR1(47,4)+WPx*VRR1(47,8)
      VRR0(70,9)=V(108)+V(110)+PAx*VRR0(47,9)+WPx*VRR1(47,9)
      VRR0(70,10)=V(112)+V(114)+PAx*VRR0(47,10)+WPx*VRR1(47,10)
      VRR0(71,5)=V(116)+V(118)+2.D0*V(119)+PAx*VRR0(48,5)+WPx*VRR1(48,5)
      VRR0(71,6)=V(121)+V(123)+V(124)+PAx*VRR0(48,6)+WPx*VRR1(48,6)
      VRR0(71,7)=V(126)+V(128)+PAx*VRR0(48,7)+WPx*VRR1(48,7)
      VRR0(71,8)=V(130)+V(132)+V(133)+PAx*VRR0(48,8)+WPx*VRR1(48,8)
      VRR0(71,9)=V(135)+V(137)+PAx*VRR0(48,9)+WPx*VRR1(48,9)
      VRR0(71,10)=V(139)+V(141)+PAx*VRR0(48,10)+WPx*VRR1(48,10)
      VRR0(72,5)=V(142)+2.D0*V(143)+V(145)+QCx*VRR0(72,2)+WQx*VRR1(72,2)
      VRR0(72,6)=V(146)-V(147)+V(148)+PAx*VRR0(49,6)+WPx*VRR1(49,6)
      VRR0(72,7)=2.D0*V(124)+V(142)+V(145)+QCy*VRR0(72,3)+WQy*VRR1(72,3)
      VRR0(72,8)=V(149)-V(150)+V(151)+PAx*VRR0(49,8)+WPx*VRR1(49,8)
      VRR0(72,9)=V(152)-V(153)+PAx*VRR0(49,9)+WPx*VRR1(49,9)
      VRR0(72,10)=2.D0*V(70)+V(142)+V(145)+QCz*VRR0(72,4)+WQz*VRR1(72,4)
      VRR0(73,5)=V(116)+V(118)+PAy*VRR0(49,5)+WPy*VRR1(49,5)
      VRR0(73,6)=V(121)+V(123)+V(143)+PAy*VRR0(49,6)+WPy*VRR1(49,6)
      VRR0(73,7)=V(126)+V(128)+2.D0*V(148)+PAy*VRR0(49,7)+WPy*VRR1(49,7)
      VRR0(73,8)=V(130)+V(132)+PAy*VRR0(49,8)+WPy*VRR1(49,8)
      VRR0(73,9)=V(135)+V(137)+V(151)+PAy*VRR0(49,9)+WPy*VRR1(49,9)
      VRR0(73,10)=V(139)+V(141)+PAy*VRR0(49,10)+WPy*VRR1(49,10)
      VRR0(74,5)=V(155)+V(157)+PAy*VRR0(50,5)+WPy*VRR1(50,5)
      VRR0(74,6)=V(158)+V(159)+PAy*VRR0(50,6)+HfxZpE*VRR1(50,2)+WPy*VRR1(50,6)
      VRR0(74,7)=V(161)+V(163)+PAy*VRR0(50,7)+2.D0*HfxZpE*VRR1(50,3)+WPy*VRR1(50,7)
      VRR0(74,8)=V(164)+V(165)+PAy*VRR0(50,8)+WPy*VRR1(50,8)
      VRR0(74,9)=V(166)+V(167)+PAy*VRR0(50,9)+HfxZpE*VRR1(50,4)+WPy*VRR1(50,9)
      VRR0(74,10)=V(169)+V(171)+PAy*VRR0(50,10)+WPy*VRR1(50,10)
      VRR0(75,5)=2.D0*V(172)-2.D0*V(173)+2.D0*V(174)+PAx*VRR0(51,5)+WPx*VRR1(51,5)
      VRR0(75,6)=2.D0*V(175)-2.D0*V(176)+V(177)+PAx*VRR0(51,6)+WPx*VRR1(51,6)
      VRR0(75,7)=2.D0*V(178)-2.D0*V(179)+PAx*VRR0(51,7)+WPx*VRR1(51,7)
      VRR0(75,8)=2.D0*V(180)-2.D0*V(181)+V(182)+PAx*VRR0(51,8)+WPx*VRR1(51,8)
      VRR0(75,9)=2.D0*V(183)-2.D0*V(184)+PAx*VRR0(51,9)+WPx*VRR1(51,9)
      VRR0(75,10)=2.D0*V(185)-2.D0*V(186)+PAx*VRR0(51,10)+WPx*VRR1(51,10)
      VRR0(76,5)=V(79)+V(80)+PAz*VRR0(48,5)+WPz*VRR1(48,5)
      VRR0(76,6)=V(81)+V(82)+PAz*VRR0(48,6)+WPz*VRR1(48,6)
      VRR0(76,7)=V(83)+V(84)+PAz*VRR0(48,7)+WPz*VRR1(48,7)
      VRR0(76,8)=V(85)+V(86)+V(119)+PAz*VRR0(48,8)+WPz*VRR1(48,8)
      VRR0(76,9)=V(87)+V(88)+V(124)+PAz*VRR0(48,9)+WPz*VRR1(48,9)
      VRR0(76,10)=V(89)+V(90)+2.D0*V(133)+PAz*VRR0(48,10)+WPz*VRR1(48,10)
      VRR0(77,5)=V(53)+V(55)+PAz*VRR0(49,5)+WPz*VRR1(49,5)
      VRR0(77,6)=V(58)+V(60)+PAz*VRR0(49,6)+WPz*VRR1(49,6)
      VRR0(77,7)=V(63)+V(65)+PAz*VRR0(49,7)+WPz*VRR1(49,7)
      VRR0(77,8)=V(67)+V(69)+V(143)+PAz*VRR0(49,8)+WPz*VRR1(49,8)
      VRR0(77,9)=V(72)+V(74)+V(148)+PAz*VRR0(49,9)+WPz*VRR1(49,9)
      VRR0(77,10)=V(76)+V(78)+2.D0*V(151)+PAz*VRR0(49,10)+WPz*VRR1(49,10)
      VRR0(78,5)=2.D0*V(187)-2.D0*V(188)+PAy*VRR0(53,5)+WPy*VRR1(53,5)
      VRR0(78,6)=2.D0*V(189)-2.D0*V(190)+V(191)+PAy*VRR0(53,6)+WPy*VRR1(53,6)
      VRR0(78,7)=2.D0*V(192)-2.D0*V(193)+2.D0*V(194)+PAy*VRR0(53,7)+WPy*VRR1(53,7)
      VRR0(78,8)=2.D0*V(195)-2.D0*V(196)+PAy*VRR0(53,8)+WPy*VRR1(53,8)
      VRR0(78,9)=2.D0*V(197)-2.D0*V(198)+V(199)+PAy*VRR0(53,9)+WPy*VRR1(53,9)
      VRR0(78,10)=2.D0*V(200)-2.D0*V(201)+PAy*VRR0(53,10)+WPy*VRR1(53,10)
      VRR0(79,5)=V(92)+V(94)+PAz*VRR0(51,5)+WPz*VRR1(51,5)
      VRR0(79,6)=V(96)+V(98)+PAz*VRR0(51,6)+WPz*VRR1(51,6)
      VRR0(79,7)=V(100)+V(102)+PAz*VRR0(51,7)+WPz*VRR1(51,7)
      VRR0(79,8)=V(104)+V(106)+V(174)+PAz*VRR0(51,8)+WPz*VRR1(51,8)
      VRR0(79,9)=V(108)+V(110)+V(177)+PAz*VRR0(51,9)+WPz*VRR1(51,9)
      VRR0(79,10)=V(112)+V(114)+2.D0*V(182)+PAz*VRR0(51,10)+WPz*VRR1(51,10)
      VRR0(80,5)=3.D0*V(115)-3.D0*V(117)+PAz*VRR0(52,5)+WPz*VRR1(52,5)
      VRR0(80,6)=3.D0*V(120)-3.D0*V(122)+PAz*VRR0(52,6)+WPz*VRR1(52,6)
      VRR0(80,7)=3.D0*V(125)-3.D0*V(127)+PAz*VRR0(52,7)+WPz*VRR1(52,7)
      VRR0(80,8)=3.D0*V(129)-3.D0*V(131)+PAz*VRR0(52,8)+HfxZpE*VRR1(52,2)+WPz*VRR1(52,8)
      VRR0(80,9)=3.D0*V(134)-3.D0*V(136)+PAz*VRR0(52,9)+HfxZpE*VRR1(52,3)+WPz*VRR1(52,9)
      VRR0(80,10)=3.D0*V(138)-3.D0*V(140)+PAz*VRR0(52,10)+2.D0*HfxZpE*VRR1(52,4)+WPz*VRR1(52,10)
      VRR0(81,5)=V(155)+V(157)+PAz*VRR0(53,5)+WPz*VRR1(53,5)
      VRR0(81,6)=V(158)+V(159)+PAz*VRR0(53,6)+WPz*VRR1(53,6)
      VRR0(81,7)=V(161)+V(163)+PAz*VRR0(53,7)+WPz*VRR1(53,7)
      VRR0(81,8)=V(164)+V(165)+V(191)+PAz*VRR0(53,8)+WPz*VRR1(53,8)
      VRR0(81,9)=V(166)+V(167)+V(194)+PAz*VRR0(53,9)+WPz*VRR1(53,9)
      VRR0(81,10)=V(169)+V(171)+2.D0*V(199)+PAz*VRR0(53,10)+WPz*VRR1(53,10)
      VRR0(82,5)=4.D0*V(172)-4.D0*V(173)+PAz*VRR0(54,5)+WPz*VRR1(54,5)
      VRR0(82,6)=4.D0*V(175)-4.D0*V(176)+PAz*VRR0(54,6)+WPz*VRR1(54,6)
      VRR0(82,7)=4.D0*V(178)-4.D0*V(179)+PAz*VRR0(54,7)+WPz*VRR1(54,7)
      VRR0(82,8)=4.D0*V(180)-4.D0*V(181)+PAz*VRR0(54,8)+HfxZpE*VRR1(54,2)+WPz*VRR1(54,8)
      VRR0(82,9)=4.D0*V(183)-4.D0*V(184)+PAz*VRR0(54,9)+HfxZpE*VRR1(54,3)+WPz*VRR1(54,9)
      VRR0(82,10)=4.D0*V(185)-4.D0*V(186)+PAz*VRR0(54,10)+2.D0*HfxZpE*VRR1(54,4)+WPz*VRR1(54,10)
      VRR0(83,5)=4.D0*V(187)-4.D0*V(188)+PAz*VRR0(55,5)+WPz*VRR1(55,5)
      VRR0(83,6)=4.D0*V(189)-4.D0*V(190)+PAz*VRR0(55,6)+WPz*VRR1(55,6)
      VRR0(83,7)=4.D0*V(192)-4.D0*V(193)+PAz*VRR0(55,7)+WPz*VRR1(55,7)
      VRR0(83,8)=4.D0*V(195)-4.D0*V(196)+PAz*VRR0(55,8)+HfxZpE*VRR1(55,2)+WPz*VRR1(55,8)
      VRR0(83,9)=4.D0*V(197)-4.D0*V(198)+PAz*VRR0(55,9)+HfxZpE*VRR1(55,3)+WPz*VRR1(55,9)
      VRR0(83,10)=4.D0*V(200)-4.D0*V(201)+PAz*VRR0(55,10)+2.D0*HfxZpE*VRR1(55,4)+WPz*VRR1(55,10)
      VRR0(84,5)=5.D0*r1x2Z*VRR0(35,5)+PAz*VRR0(56,5)-5.D0*ExZpE*r1x2Z*VRR1(35,5)+WPz*VRR1(56,5)
      VRR0(84,6)=5.D0*r1x2Z*VRR0(35,6)+PAz*VRR0(56,6)-5.D0*ExZpE*r1x2Z*VRR1(35,6)+WPz*VRR1(56,6)
      VRR0(84,7)=5.D0*r1x2Z*VRR0(35,7)+PAz*VRR0(56,7)-5.D0*ExZpE*r1x2Z*VRR1(35,7)+WPz*VRR1(56,7)
      VRR0(84,8)=5.D0*r1x2Z*VRR0(35,8)+PAz*VRR0(56,8)-5.D0*ExZpE*r1x2Z*VRR1(35,8)+HfxZpE*VRR1(56,2)+WPz*VRR1(56,8)
      VRR0(84,9)=5.D0*r1x2Z*VRR0(35,9)+PAz*VRR0(56,9)-5.D0*ExZpE*r1x2Z*VRR1(35,9)+HfxZpE*VRR1(56,3)+WPz*VRR1(56,9)
      VRR0(84,10)=5.D0*r1x2Z*VRR0(35,10)+PAz*VRR0(56,10)-5.D0*ExZpE*r1x2Z*VRR1(35,10)+2.D0*HfxZpE*VRR1(56,4)+WPz*VRR1(56,10)
END SUBROUTINE VRRi0d0
SUBROUTINE MVRRi0d0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(57,5)=PAx*VS0(36,5)+WPx*VS1(36,5)+r1x2Z*VR1(36,5)&
   +5D0*r1x2Z*(VS0(21,5)-ExZpE*VS1(21,5))&
   +2D0*HfxZpE*VS1(36,2)
VS0(57,6)=PAx*VS0(36,6)+WPx*VS1(36,6)+r1x2Z*VR1(36,6)&
   +5D0*r1x2Z*(VS0(21,6)-ExZpE*VS1(21,6))&
   +HfxZpE*VS1(36,3)
VS0(57,7)=PAx*VS0(36,7)+WPx*VS1(36,7)+r1x2Z*VR1(36,7)&
   +5D0*r1x2Z*(VS0(21,7)-ExZpE*VS1(21,7))
VS0(57,8)=PAx*VS0(36,8)+WPx*VS1(36,8)+r1x2Z*VR1(36,8)&
   +5D0*r1x2Z*(VS0(21,8)-ExZpE*VS1(21,8))&
   +HfxZpE*VS1(36,4)
VS0(57,9)=PAx*VS0(36,9)+WPx*VS1(36,9)+r1x2Z*VR1(36,9)&
   +5D0*r1x2Z*(VS0(21,9)-ExZpE*VS1(21,9))
VS0(57,10)=PAx*VS0(36,10)+WPx*VS1(36,10)+r1x2Z*VR1(36,10)&
   +5D0*r1x2Z*(VS0(21,10)-ExZpE*VS1(21,10))
VS0(58,5)=PAx*VS0(37,5)+WPx*VS1(37,5)+r1x2Z*VR1(37,5)&
   +4D0*r1x2Z*(VS0(22,5)-ExZpE*VS1(22,5))&
   +2D0*HfxZpE*VS1(37,2)
VS0(58,6)=PAx*VS0(37,6)+WPx*VS1(37,6)+r1x2Z*VR1(37,6)&
   +4D0*r1x2Z*(VS0(22,6)-ExZpE*VS1(22,6))&
   +HfxZpE*VS1(37,3)
VS0(58,7)=PAx*VS0(37,7)+WPx*VS1(37,7)+r1x2Z*VR1(37,7)&
   +4D0*r1x2Z*(VS0(22,7)-ExZpE*VS1(22,7))
VS0(58,8)=PAx*VS0(37,8)+WPx*VS1(37,8)+r1x2Z*VR1(37,8)&
   +4D0*r1x2Z*(VS0(22,8)-ExZpE*VS1(22,8))&
   +HfxZpE*VS1(37,4)
VS0(58,9)=PAx*VS0(37,9)+WPx*VS1(37,9)+r1x2Z*VR1(37,9)&
   +4D0*r1x2Z*(VS0(22,9)-ExZpE*VS1(22,9))
VS0(58,10)=PAx*VS0(37,10)+WPx*VS1(37,10)+r1x2Z*VR1(37,10)&
   +4D0*r1x2Z*(VS0(22,10)-ExZpE*VS1(22,10))
VS0(59,5)=PAx*VS0(38,5)+WPx*VS1(38,5)+r1x2Z*VR1(38,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(38,2)
VS0(59,6)=PAx*VS0(38,6)+WPx*VS1(38,6)+r1x2Z*VR1(38,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(38,3)
VS0(59,7)=PAx*VS0(38,7)+WPx*VS1(38,7)+r1x2Z*VR1(38,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))
VS0(59,8)=PAx*VS0(38,8)+WPx*VS1(38,8)+r1x2Z*VR1(38,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))&
   +HfxZpE*VS1(38,4)
VS0(59,9)=PAx*VS0(38,9)+WPx*VS1(38,9)+r1x2Z*VR1(38,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))
VS0(59,10)=PAx*VS0(38,10)+WPx*VS1(38,10)+r1x2Z*VR1(38,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(60,5)=PAx*VS0(39,5)+WPx*VS1(39,5)+r1x2Z*VR1(39,5)&
   +2D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))&
   +2D0*HfxZpE*VS1(39,2)
VS0(60,6)=PAx*VS0(39,6)+WPx*VS1(39,6)+r1x2Z*VR1(39,6)&
   +2D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(39,3)
VS0(60,7)=PAx*VS0(39,7)+WPx*VS1(39,7)+r1x2Z*VR1(39,7)&
   +2D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))
VS0(60,8)=PAx*VS0(39,8)+WPx*VS1(39,8)+r1x2Z*VR1(39,8)&
   +2D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))&
   +HfxZpE*VS1(39,4)
VS0(60,9)=PAx*VS0(39,9)+WPx*VS1(39,9)+r1x2Z*VR1(39,9)&
   +2D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))
VS0(60,10)=PAx*VS0(39,10)+WPx*VS1(39,10)+r1x2Z*VR1(39,10)&
   +2D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(61,5)=PAy*VS0(39,5)+WPy*VS1(39,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))
VS0(61,6)=PAy*VS0(39,6)+WPy*VS1(39,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(39,2)
VS0(61,7)=PAy*VS0(39,7)+WPy*VS1(39,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(39,3)
VS0(61,8)=PAy*VS0(39,8)+WPy*VS1(39,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))
VS0(61,9)=PAy*VS0(39,9)+WPy*VS1(39,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))&
   +HfxZpE*VS1(39,4)
VS0(61,10)=PAy*VS0(39,10)+WPy*VS1(39,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(62,5)=PAy*VS0(40,5)+WPy*VS1(40,5)&
   +4D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))
VS0(62,6)=PAy*VS0(40,6)+WPy*VS1(40,6)&
   +4D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(40,2)
VS0(62,7)=PAy*VS0(40,7)+WPy*VS1(40,7)&
   +4D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))&
   +2D0*HfxZpE*VS1(40,3)
VS0(62,8)=PAy*VS0(40,8)+WPy*VS1(40,8)&
   +4D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))
VS0(62,9)=PAy*VS0(40,9)+WPy*VS1(40,9)&
   +4D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))&
   +HfxZpE*VS1(40,4)
VS0(62,10)=PAy*VS0(40,10)+WPy*VS1(40,10)&
   +4D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(63,5)=PAy*VS0(41,5)+WPy*VS1(41,5)&
   +5D0*r1x2Z*(VS0(25,5)-ExZpE*VS1(25,5))
VS0(63,6)=PAy*VS0(41,6)+WPy*VS1(41,6)&
   +5D0*r1x2Z*(VS0(25,6)-ExZpE*VS1(25,6))&
   +HfxZpE*VS1(41,2)
VS0(63,7)=PAy*VS0(41,7)+WPy*VS1(41,7)&
   +5D0*r1x2Z*(VS0(25,7)-ExZpE*VS1(25,7))&
   +2D0*HfxZpE*VS1(41,3)
VS0(63,8)=PAy*VS0(41,8)+WPy*VS1(41,8)&
   +5D0*r1x2Z*(VS0(25,8)-ExZpE*VS1(25,8))
VS0(63,9)=PAy*VS0(41,9)+WPy*VS1(41,9)&
   +5D0*r1x2Z*(VS0(25,9)-ExZpE*VS1(25,9))&
   +HfxZpE*VS1(41,4)
VS0(63,10)=PAy*VS0(41,10)+WPy*VS1(41,10)&
   +5D0*r1x2Z*(VS0(25,10)-ExZpE*VS1(25,10))
VS0(64,5)=PAx*VS0(42,5)+WPx*VS1(42,5)+r1x2Z*VR1(42,5)&
   +4D0*r1x2Z*(VS0(26,5)-ExZpE*VS1(26,5))&
   +2D0*HfxZpE*VS1(42,2)
VS0(64,6)=PAx*VS0(42,6)+WPx*VS1(42,6)+r1x2Z*VR1(42,6)&
   +4D0*r1x2Z*(VS0(26,6)-ExZpE*VS1(26,6))&
   +HfxZpE*VS1(42,3)
VS0(64,7)=PAx*VS0(42,7)+WPx*VS1(42,7)+r1x2Z*VR1(42,7)&
   +4D0*r1x2Z*(VS0(26,7)-ExZpE*VS1(26,7))
VS0(64,8)=PAx*VS0(42,8)+WPx*VS1(42,8)+r1x2Z*VR1(42,8)&
   +4D0*r1x2Z*(VS0(26,8)-ExZpE*VS1(26,8))&
   +HfxZpE*VS1(42,4)
VS0(64,9)=PAx*VS0(42,9)+WPx*VS1(42,9)+r1x2Z*VR1(42,9)&
   +4D0*r1x2Z*(VS0(26,9)-ExZpE*VS1(26,9))
VS0(64,10)=PAx*VS0(42,10)+WPx*VS1(42,10)+r1x2Z*VR1(42,10)&
   +4D0*r1x2Z*(VS0(26,10)-ExZpE*VS1(26,10))
VS0(65,5)=PAx*VS0(43,5)+WPx*VS1(43,5)+r1x2Z*VR1(43,5)&
   +3D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(43,2)
VS0(65,6)=PAx*VS0(43,6)+WPx*VS1(43,6)+r1x2Z*VR1(43,6)&
   +3D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(43,3)
VS0(65,7)=PAx*VS0(43,7)+WPx*VS1(43,7)+r1x2Z*VR1(43,7)&
   +3D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(65,8)=PAx*VS0(43,8)+WPx*VS1(43,8)+r1x2Z*VR1(43,8)&
   +3D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(43,4)
VS0(65,9)=PAx*VS0(43,9)+WPx*VS1(43,9)+r1x2Z*VR1(43,9)&
   +3D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))
VS0(65,10)=PAx*VS0(43,10)+WPx*VS1(43,10)+r1x2Z*VR1(43,10)&
   +3D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(66,5)=PAx*VS0(44,5)+WPx*VS1(44,5)+r1x2Z*VR1(44,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))&
   +2D0*HfxZpE*VS1(44,2)
VS0(66,6)=PAx*VS0(44,6)+WPx*VS1(44,6)+r1x2Z*VR1(44,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(44,3)
VS0(66,7)=PAx*VS0(44,7)+WPx*VS1(44,7)+r1x2Z*VR1(44,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(66,8)=PAx*VS0(44,8)+WPx*VS1(44,8)+r1x2Z*VR1(44,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(44,4)
VS0(66,9)=PAx*VS0(44,9)+WPx*VS1(44,9)+r1x2Z*VR1(44,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))
VS0(66,10)=PAx*VS0(44,10)+WPx*VS1(44,10)+r1x2Z*VR1(44,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(67,5)=PAy*VS0(44,5)+WPy*VS1(44,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(67,6)=PAy*VS0(44,6)+WPy*VS1(44,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(44,2)
VS0(67,7)=PAy*VS0(44,7)+WPy*VS1(44,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(44,3)
VS0(67,8)=PAy*VS0(44,8)+WPy*VS1(44,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))
VS0(67,9)=PAy*VS0(44,9)+WPy*VS1(44,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(44,4)
VS0(67,10)=PAy*VS0(44,10)+WPy*VS1(44,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(68,5)=PAy*VS0(45,5)+WPy*VS1(45,5)&
   +3D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(68,6)=PAy*VS0(45,6)+WPy*VS1(45,6)&
   +3D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(45,2)
VS0(68,7)=PAy*VS0(45,7)+WPy*VS1(45,7)&
   +3D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(45,3)
VS0(68,8)=PAy*VS0(45,8)+WPy*VS1(45,8)&
   +3D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))
VS0(68,9)=PAy*VS0(45,9)+WPy*VS1(45,9)&
   +3D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(45,4)
VS0(68,10)=PAy*VS0(45,10)+WPy*VS1(45,10)&
   +3D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(69,5)=PAy*VS0(46,5)+WPy*VS1(46,5)&
   +4D0*r1x2Z*(VS0(29,5)-ExZpE*VS1(29,5))
VS0(69,6)=PAy*VS0(46,6)+WPy*VS1(46,6)&
   +4D0*r1x2Z*(VS0(29,6)-ExZpE*VS1(29,6))&
   +HfxZpE*VS1(46,2)
VS0(69,7)=PAy*VS0(46,7)+WPy*VS1(46,7)&
   +4D0*r1x2Z*(VS0(29,7)-ExZpE*VS1(29,7))&
   +2D0*HfxZpE*VS1(46,3)
VS0(69,8)=PAy*VS0(46,8)+WPy*VS1(46,8)&
   +4D0*r1x2Z*(VS0(29,8)-ExZpE*VS1(29,8))
VS0(69,9)=PAy*VS0(46,9)+WPy*VS1(46,9)&
   +4D0*r1x2Z*(VS0(29,9)-ExZpE*VS1(29,9))&
   +HfxZpE*VS1(46,4)
VS0(69,10)=PAy*VS0(46,10)+WPy*VS1(46,10)&
   +4D0*r1x2Z*(VS0(29,10)-ExZpE*VS1(29,10))
VS0(70,5)=PAx*VS0(47,5)+WPx*VS1(47,5)+r1x2Z*VR1(47,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(47,2)
VS0(70,6)=PAx*VS0(47,6)+WPx*VS1(47,6)+r1x2Z*VR1(47,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))&
   +HfxZpE*VS1(47,3)
VS0(70,7)=PAx*VS0(47,7)+WPx*VS1(47,7)+r1x2Z*VR1(47,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(70,8)=PAx*VS0(47,8)+WPx*VS1(47,8)+r1x2Z*VR1(47,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(47,4)
VS0(70,9)=PAx*VS0(47,9)+WPx*VS1(47,9)+r1x2Z*VR1(47,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))
VS0(70,10)=PAx*VS0(47,10)+WPx*VS1(47,10)+r1x2Z*VR1(47,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))
VS0(71,5)=PAx*VS0(48,5)+WPx*VS1(48,5)+r1x2Z*VR1(48,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))&
   +2D0*HfxZpE*VS1(48,2)
VS0(71,6)=PAx*VS0(48,6)+WPx*VS1(48,6)+r1x2Z*VR1(48,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(48,3)
VS0(71,7)=PAx*VS0(48,7)+WPx*VS1(48,7)+r1x2Z*VR1(48,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(71,8)=PAx*VS0(48,8)+WPx*VS1(48,8)+r1x2Z*VR1(48,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(48,4)
VS0(71,9)=PAx*VS0(48,9)+WPx*VS1(48,9)+r1x2Z*VR1(48,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))
VS0(71,10)=PAx*VS0(48,10)+WPx*VS1(48,10)+r1x2Z*VR1(48,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(72,5)=PAx*VS0(49,5)+WPx*VS1(49,5)+r1x2Z*VR1(49,5)&
   +r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))&
   +2D0*HfxZpE*VS1(49,2)
VS0(72,6)=PAx*VS0(49,6)+WPx*VS1(49,6)+r1x2Z*VR1(49,6)&
   +r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(49,3)
VS0(72,7)=PAx*VS0(49,7)+WPx*VS1(49,7)+r1x2Z*VR1(49,7)&
   +r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(72,8)=PAx*VS0(49,8)+WPx*VS1(49,8)+r1x2Z*VR1(49,8)&
   +r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(49,4)
VS0(72,9)=PAx*VS0(49,9)+WPx*VS1(49,9)+r1x2Z*VR1(49,9)&
   +r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))
VS0(72,10)=PAx*VS0(49,10)+WPx*VS1(49,10)+r1x2Z*VR1(49,10)&
   +r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(73,5)=PAy*VS0(49,5)+WPy*VS1(49,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(73,6)=PAy*VS0(49,6)+WPy*VS1(49,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(49,2)
VS0(73,7)=PAy*VS0(49,7)+WPy*VS1(49,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))&
   +2D0*HfxZpE*VS1(49,3)
VS0(73,8)=PAy*VS0(49,8)+WPy*VS1(49,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))
VS0(73,9)=PAy*VS0(49,9)+WPy*VS1(49,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(49,4)
VS0(73,10)=PAy*VS0(49,10)+WPy*VS1(49,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(74,5)=PAy*VS0(50,5)+WPy*VS1(50,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(74,6)=PAy*VS0(50,6)+WPy*VS1(50,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(50,2)
VS0(74,7)=PAy*VS0(50,7)+WPy*VS1(50,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(50,3)
VS0(74,8)=PAy*VS0(50,8)+WPy*VS1(50,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))
VS0(74,9)=PAy*VS0(50,9)+WPy*VS1(50,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(50,4)
VS0(74,10)=PAy*VS0(50,10)+WPy*VS1(50,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(75,5)=PAx*VS0(51,5)+WPx*VS1(51,5)+r1x2Z*VR1(51,5)&
   +2D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))&
   +2D0*HfxZpE*VS1(51,2)
VS0(75,6)=PAx*VS0(51,6)+WPx*VS1(51,6)+r1x2Z*VR1(51,6)&
   +2D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))&
   +HfxZpE*VS1(51,3)
VS0(75,7)=PAx*VS0(51,7)+WPx*VS1(51,7)+r1x2Z*VR1(51,7)&
   +2D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(75,8)=PAx*VS0(51,8)+WPx*VS1(51,8)+r1x2Z*VR1(51,8)&
   +2D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(51,4)
VS0(75,9)=PAx*VS0(51,9)+WPx*VS1(51,9)+r1x2Z*VR1(51,9)&
   +2D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))
VS0(75,10)=PAx*VS0(51,10)+WPx*VS1(51,10)+r1x2Z*VR1(51,10)&
   +2D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))
VS0(76,5)=PAz*VS0(48,5)+WPz*VS1(48,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(76,6)=PAz*VS0(48,6)+WPz*VS1(48,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))
VS0(76,7)=PAz*VS0(48,7)+WPz*VS1(48,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(76,8)=PAz*VS0(48,8)+WPz*VS1(48,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(48,2)
VS0(76,9)=PAz*VS0(48,9)+WPz*VS1(48,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(48,3)
VS0(76,10)=PAz*VS0(48,10)+WPz*VS1(48,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(48,4)
VS0(77,5)=PAz*VS0(49,5)+WPz*VS1(49,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(77,6)=PAz*VS0(49,6)+WPz*VS1(49,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))
VS0(77,7)=PAz*VS0(49,7)+WPz*VS1(49,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(77,8)=PAz*VS0(49,8)+WPz*VS1(49,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(49,2)
VS0(77,9)=PAz*VS0(49,9)+WPz*VS1(49,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(49,3)
VS0(77,10)=PAz*VS0(49,10)+WPz*VS1(49,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(49,4)
VS0(78,5)=PAy*VS0(53,5)+WPy*VS1(53,5)&
   +2D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(78,6)=PAy*VS0(53,6)+WPy*VS1(53,6)&
   +2D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))&
   +HfxZpE*VS1(53,2)
VS0(78,7)=PAy*VS0(53,7)+WPy*VS1(53,7)&
   +2D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))&
   +2D0*HfxZpE*VS1(53,3)
VS0(78,8)=PAy*VS0(53,8)+WPy*VS1(53,8)&
   +2D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))
VS0(78,9)=PAy*VS0(53,9)+WPy*VS1(53,9)&
   +2D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(53,4)
VS0(78,10)=PAy*VS0(53,10)+WPy*VS1(53,10)&
   +2D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))
VS0(79,5)=PAz*VS0(51,5)+WPz*VS1(51,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))
VS0(79,6)=PAz*VS0(51,6)+WPz*VS1(51,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))
VS0(79,7)=PAz*VS0(51,7)+WPz*VS1(51,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(79,8)=PAz*VS0(51,8)+WPz*VS1(51,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(51,2)
VS0(79,9)=PAz*VS0(51,9)+WPz*VS1(51,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))&
   +HfxZpE*VS1(51,3)
VS0(79,10)=PAz*VS0(51,10)+WPz*VS1(51,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(51,4)
VS0(80,5)=PAz*VS0(52,5)+WPz*VS1(52,5)&
   +3D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(80,6)=PAz*VS0(52,6)+WPz*VS1(52,6)&
   +3D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))
VS0(80,7)=PAz*VS0(52,7)+WPz*VS1(52,7)&
   +3D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(80,8)=PAz*VS0(52,8)+WPz*VS1(52,8)&
   +3D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(52,2)
VS0(80,9)=PAz*VS0(52,9)+WPz*VS1(52,9)&
   +3D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(52,3)
VS0(80,10)=PAz*VS0(52,10)+WPz*VS1(52,10)&
   +3D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(52,4)
VS0(81,5)=PAz*VS0(53,5)+WPz*VS1(53,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(81,6)=PAz*VS0(53,6)+WPz*VS1(53,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))
VS0(81,7)=PAz*VS0(53,7)+WPz*VS1(53,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(81,8)=PAz*VS0(53,8)+WPz*VS1(53,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(53,2)
VS0(81,9)=PAz*VS0(53,9)+WPz*VS1(53,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(53,3)
VS0(81,10)=PAz*VS0(53,10)+WPz*VS1(53,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(53,4)
VS0(82,5)=PAz*VS0(54,5)+WPz*VS1(54,5)&
   +4D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))
VS0(82,6)=PAz*VS0(54,6)+WPz*VS1(54,6)&
   +4D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))
VS0(82,7)=PAz*VS0(54,7)+WPz*VS1(54,7)&
   +4D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(82,8)=PAz*VS0(54,8)+WPz*VS1(54,8)&
   +4D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(54,2)
VS0(82,9)=PAz*VS0(54,9)+WPz*VS1(54,9)&
   +4D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))&
   +HfxZpE*VS1(54,3)
VS0(82,10)=PAz*VS0(54,10)+WPz*VS1(54,10)&
   +4D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))&
   +2D0*HfxZpE*VS1(54,4)
VS0(83,5)=PAz*VS0(55,5)+WPz*VS1(55,5)&
   +4D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(83,6)=PAz*VS0(55,6)+WPz*VS1(55,6)&
   +4D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))
VS0(83,7)=PAz*VS0(55,7)+WPz*VS1(55,7)&
   +4D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))
VS0(83,8)=PAz*VS0(55,8)+WPz*VS1(55,8)&
   +4D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))&
   +HfxZpE*VS1(55,2)
VS0(83,9)=PAz*VS0(55,9)+WPz*VS1(55,9)&
   +4D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(55,3)
VS0(83,10)=PAz*VS0(55,10)+WPz*VS1(55,10)&
   +4D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))&
   +2D0*HfxZpE*VS1(55,4)
VS0(84,5)=PAz*VS0(56,5)+WPz*VS1(56,5)&
   +5D0*r1x2Z*(VS0(35,5)-ExZpE*VS1(35,5))
VS0(84,6)=PAz*VS0(56,6)+WPz*VS1(56,6)&
   +5D0*r1x2Z*(VS0(35,6)-ExZpE*VS1(35,6))
VS0(84,7)=PAz*VS0(56,7)+WPz*VS1(56,7)&
   +5D0*r1x2Z*(VS0(35,7)-ExZpE*VS1(35,7))
VS0(84,8)=PAz*VS0(56,8)+WPz*VS1(56,8)&
   +5D0*r1x2Z*(VS0(35,8)-ExZpE*VS1(35,8))&
   +HfxZpE*VS1(56,2)
VS0(84,9)=PAz*VS0(56,9)+WPz*VS1(56,9)&
   +5D0*r1x2Z*(VS0(35,9)-ExZpE*VS1(35,9))&
   +HfxZpE*VS1(56,3)
VS0(84,10)=PAz*VS0(56,10)+WPz*VS1(56,10)&
   +5D0*r1x2Z*(VS0(35,10)-ExZpE*VS1(35,10))&
   +2D0*HfxZpE*VS1(56,4)
CASE(2)
VS0(57,5)=PAx*VS0(36,5)+WPx*VS1(36,5)&
   +5D0*r1x2Z*(VS0(21,5)-ExZpE*VS1(21,5))&
   +2D0*HfxZpE*VS1(36,2)
VS0(57,6)=PAx*VS0(36,6)+WPx*VS1(36,6)&
   +5D0*r1x2Z*(VS0(21,6)-ExZpE*VS1(21,6))&
   +HfxZpE*VS1(36,3)
VS0(57,7)=PAx*VS0(36,7)+WPx*VS1(36,7)&
   +5D0*r1x2Z*(VS0(21,7)-ExZpE*VS1(21,7))
VS0(57,8)=PAx*VS0(36,8)+WPx*VS1(36,8)&
   +5D0*r1x2Z*(VS0(21,8)-ExZpE*VS1(21,8))&
   +HfxZpE*VS1(36,4)
VS0(57,9)=PAx*VS0(36,9)+WPx*VS1(36,9)&
   +5D0*r1x2Z*(VS0(21,9)-ExZpE*VS1(21,9))
VS0(57,10)=PAx*VS0(36,10)+WPx*VS1(36,10)&
   +5D0*r1x2Z*(VS0(21,10)-ExZpE*VS1(21,10))
VS0(58,5)=PAx*VS0(37,5)+WPx*VS1(37,5)&
   +4D0*r1x2Z*(VS0(22,5)-ExZpE*VS1(22,5))&
   +2D0*HfxZpE*VS1(37,2)
VS0(58,6)=PAx*VS0(37,6)+WPx*VS1(37,6)&
   +4D0*r1x2Z*(VS0(22,6)-ExZpE*VS1(22,6))&
   +HfxZpE*VS1(37,3)
VS0(58,7)=PAx*VS0(37,7)+WPx*VS1(37,7)&
   +4D0*r1x2Z*(VS0(22,7)-ExZpE*VS1(22,7))
VS0(58,8)=PAx*VS0(37,8)+WPx*VS1(37,8)&
   +4D0*r1x2Z*(VS0(22,8)-ExZpE*VS1(22,8))&
   +HfxZpE*VS1(37,4)
VS0(58,9)=PAx*VS0(37,9)+WPx*VS1(37,9)&
   +4D0*r1x2Z*(VS0(22,9)-ExZpE*VS1(22,9))
VS0(58,10)=PAx*VS0(37,10)+WPx*VS1(37,10)&
   +4D0*r1x2Z*(VS0(22,10)-ExZpE*VS1(22,10))
VS0(59,5)=PAx*VS0(38,5)+WPx*VS1(38,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(38,2)
VS0(59,6)=PAx*VS0(38,6)+WPx*VS1(38,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(38,3)
VS0(59,7)=PAx*VS0(38,7)+WPx*VS1(38,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))
VS0(59,8)=PAx*VS0(38,8)+WPx*VS1(38,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))&
   +HfxZpE*VS1(38,4)
VS0(59,9)=PAx*VS0(38,9)+WPx*VS1(38,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))
VS0(59,10)=PAx*VS0(38,10)+WPx*VS1(38,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(60,5)=PAx*VS0(39,5)+WPx*VS1(39,5)&
   +2D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))&
   +2D0*HfxZpE*VS1(39,2)
VS0(60,6)=PAx*VS0(39,6)+WPx*VS1(39,6)&
   +2D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(39,3)
VS0(60,7)=PAx*VS0(39,7)+WPx*VS1(39,7)&
   +2D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))
VS0(60,8)=PAx*VS0(39,8)+WPx*VS1(39,8)&
   +2D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))&
   +HfxZpE*VS1(39,4)
VS0(60,9)=PAx*VS0(39,9)+WPx*VS1(39,9)&
   +2D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))
VS0(60,10)=PAx*VS0(39,10)+WPx*VS1(39,10)&
   +2D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(61,5)=PAy*VS0(39,5)+WPy*VS1(39,5)+r1x2Z*VR1(39,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))
VS0(61,6)=PAy*VS0(39,6)+WPy*VS1(39,6)+r1x2Z*VR1(39,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(39,2)
VS0(61,7)=PAy*VS0(39,7)+WPy*VS1(39,7)+r1x2Z*VR1(39,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(39,3)
VS0(61,8)=PAy*VS0(39,8)+WPy*VS1(39,8)+r1x2Z*VR1(39,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))
VS0(61,9)=PAy*VS0(39,9)+WPy*VS1(39,9)+r1x2Z*VR1(39,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))&
   +HfxZpE*VS1(39,4)
VS0(61,10)=PAy*VS0(39,10)+WPy*VS1(39,10)+r1x2Z*VR1(39,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(62,5)=PAy*VS0(40,5)+WPy*VS1(40,5)+r1x2Z*VR1(40,5)&
   +4D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))
VS0(62,6)=PAy*VS0(40,6)+WPy*VS1(40,6)+r1x2Z*VR1(40,6)&
   +4D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(40,2)
VS0(62,7)=PAy*VS0(40,7)+WPy*VS1(40,7)+r1x2Z*VR1(40,7)&
   +4D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))&
   +2D0*HfxZpE*VS1(40,3)
VS0(62,8)=PAy*VS0(40,8)+WPy*VS1(40,8)+r1x2Z*VR1(40,8)&
   +4D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))
VS0(62,9)=PAy*VS0(40,9)+WPy*VS1(40,9)+r1x2Z*VR1(40,9)&
   +4D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))&
   +HfxZpE*VS1(40,4)
VS0(62,10)=PAy*VS0(40,10)+WPy*VS1(40,10)+r1x2Z*VR1(40,10)&
   +4D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(63,5)=PAy*VS0(41,5)+WPy*VS1(41,5)+r1x2Z*VR1(41,5)&
   +5D0*r1x2Z*(VS0(25,5)-ExZpE*VS1(25,5))
VS0(63,6)=PAy*VS0(41,6)+WPy*VS1(41,6)+r1x2Z*VR1(41,6)&
   +5D0*r1x2Z*(VS0(25,6)-ExZpE*VS1(25,6))&
   +HfxZpE*VS1(41,2)
VS0(63,7)=PAy*VS0(41,7)+WPy*VS1(41,7)+r1x2Z*VR1(41,7)&
   +5D0*r1x2Z*(VS0(25,7)-ExZpE*VS1(25,7))&
   +2D0*HfxZpE*VS1(41,3)
VS0(63,8)=PAy*VS0(41,8)+WPy*VS1(41,8)+r1x2Z*VR1(41,8)&
   +5D0*r1x2Z*(VS0(25,8)-ExZpE*VS1(25,8))
VS0(63,9)=PAy*VS0(41,9)+WPy*VS1(41,9)+r1x2Z*VR1(41,9)&
   +5D0*r1x2Z*(VS0(25,9)-ExZpE*VS1(25,9))&
   +HfxZpE*VS1(41,4)
VS0(63,10)=PAy*VS0(41,10)+WPy*VS1(41,10)+r1x2Z*VR1(41,10)&
   +5D0*r1x2Z*(VS0(25,10)-ExZpE*VS1(25,10))
VS0(64,5)=PAx*VS0(42,5)+WPx*VS1(42,5)&
   +4D0*r1x2Z*(VS0(26,5)-ExZpE*VS1(26,5))&
   +2D0*HfxZpE*VS1(42,2)
VS0(64,6)=PAx*VS0(42,6)+WPx*VS1(42,6)&
   +4D0*r1x2Z*(VS0(26,6)-ExZpE*VS1(26,6))&
   +HfxZpE*VS1(42,3)
VS0(64,7)=PAx*VS0(42,7)+WPx*VS1(42,7)&
   +4D0*r1x2Z*(VS0(26,7)-ExZpE*VS1(26,7))
VS0(64,8)=PAx*VS0(42,8)+WPx*VS1(42,8)&
   +4D0*r1x2Z*(VS0(26,8)-ExZpE*VS1(26,8))&
   +HfxZpE*VS1(42,4)
VS0(64,9)=PAx*VS0(42,9)+WPx*VS1(42,9)&
   +4D0*r1x2Z*(VS0(26,9)-ExZpE*VS1(26,9))
VS0(64,10)=PAx*VS0(42,10)+WPx*VS1(42,10)&
   +4D0*r1x2Z*(VS0(26,10)-ExZpE*VS1(26,10))
VS0(65,5)=PAx*VS0(43,5)+WPx*VS1(43,5)&
   +3D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(43,2)
VS0(65,6)=PAx*VS0(43,6)+WPx*VS1(43,6)&
   +3D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(43,3)
VS0(65,7)=PAx*VS0(43,7)+WPx*VS1(43,7)&
   +3D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(65,8)=PAx*VS0(43,8)+WPx*VS1(43,8)&
   +3D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(43,4)
VS0(65,9)=PAx*VS0(43,9)+WPx*VS1(43,9)&
   +3D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))
VS0(65,10)=PAx*VS0(43,10)+WPx*VS1(43,10)&
   +3D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(66,5)=PAx*VS0(44,5)+WPx*VS1(44,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))&
   +2D0*HfxZpE*VS1(44,2)
VS0(66,6)=PAx*VS0(44,6)+WPx*VS1(44,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(44,3)
VS0(66,7)=PAx*VS0(44,7)+WPx*VS1(44,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(66,8)=PAx*VS0(44,8)+WPx*VS1(44,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(44,4)
VS0(66,9)=PAx*VS0(44,9)+WPx*VS1(44,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))
VS0(66,10)=PAx*VS0(44,10)+WPx*VS1(44,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(67,5)=PAy*VS0(44,5)+WPy*VS1(44,5)+r1x2Z*VR1(44,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(67,6)=PAy*VS0(44,6)+WPy*VS1(44,6)+r1x2Z*VR1(44,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(44,2)
VS0(67,7)=PAy*VS0(44,7)+WPy*VS1(44,7)+r1x2Z*VR1(44,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(44,3)
VS0(67,8)=PAy*VS0(44,8)+WPy*VS1(44,8)+r1x2Z*VR1(44,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))
VS0(67,9)=PAy*VS0(44,9)+WPy*VS1(44,9)+r1x2Z*VR1(44,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(44,4)
VS0(67,10)=PAy*VS0(44,10)+WPy*VS1(44,10)+r1x2Z*VR1(44,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(68,5)=PAy*VS0(45,5)+WPy*VS1(45,5)+r1x2Z*VR1(45,5)&
   +3D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(68,6)=PAy*VS0(45,6)+WPy*VS1(45,6)+r1x2Z*VR1(45,6)&
   +3D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(45,2)
VS0(68,7)=PAy*VS0(45,7)+WPy*VS1(45,7)+r1x2Z*VR1(45,7)&
   +3D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(45,3)
VS0(68,8)=PAy*VS0(45,8)+WPy*VS1(45,8)+r1x2Z*VR1(45,8)&
   +3D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))
VS0(68,9)=PAy*VS0(45,9)+WPy*VS1(45,9)+r1x2Z*VR1(45,9)&
   +3D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(45,4)
VS0(68,10)=PAy*VS0(45,10)+WPy*VS1(45,10)+r1x2Z*VR1(45,10)&
   +3D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(69,5)=PAy*VS0(46,5)+WPy*VS1(46,5)+r1x2Z*VR1(46,5)&
   +4D0*r1x2Z*(VS0(29,5)-ExZpE*VS1(29,5))
VS0(69,6)=PAy*VS0(46,6)+WPy*VS1(46,6)+r1x2Z*VR1(46,6)&
   +4D0*r1x2Z*(VS0(29,6)-ExZpE*VS1(29,6))&
   +HfxZpE*VS1(46,2)
VS0(69,7)=PAy*VS0(46,7)+WPy*VS1(46,7)+r1x2Z*VR1(46,7)&
   +4D0*r1x2Z*(VS0(29,7)-ExZpE*VS1(29,7))&
   +2D0*HfxZpE*VS1(46,3)
VS0(69,8)=PAy*VS0(46,8)+WPy*VS1(46,8)+r1x2Z*VR1(46,8)&
   +4D0*r1x2Z*(VS0(29,8)-ExZpE*VS1(29,8))
VS0(69,9)=PAy*VS0(46,9)+WPy*VS1(46,9)+r1x2Z*VR1(46,9)&
   +4D0*r1x2Z*(VS0(29,9)-ExZpE*VS1(29,9))&
   +HfxZpE*VS1(46,4)
VS0(69,10)=PAy*VS0(46,10)+WPy*VS1(46,10)+r1x2Z*VR1(46,10)&
   +4D0*r1x2Z*(VS0(29,10)-ExZpE*VS1(29,10))
VS0(70,5)=PAx*VS0(47,5)+WPx*VS1(47,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(47,2)
VS0(70,6)=PAx*VS0(47,6)+WPx*VS1(47,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))&
   +HfxZpE*VS1(47,3)
VS0(70,7)=PAx*VS0(47,7)+WPx*VS1(47,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(70,8)=PAx*VS0(47,8)+WPx*VS1(47,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(47,4)
VS0(70,9)=PAx*VS0(47,9)+WPx*VS1(47,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))
VS0(70,10)=PAx*VS0(47,10)+WPx*VS1(47,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))
VS0(71,5)=PAx*VS0(48,5)+WPx*VS1(48,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))&
   +2D0*HfxZpE*VS1(48,2)
VS0(71,6)=PAx*VS0(48,6)+WPx*VS1(48,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(48,3)
VS0(71,7)=PAx*VS0(48,7)+WPx*VS1(48,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(71,8)=PAx*VS0(48,8)+WPx*VS1(48,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(48,4)
VS0(71,9)=PAx*VS0(48,9)+WPx*VS1(48,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))
VS0(71,10)=PAx*VS0(48,10)+WPx*VS1(48,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(72,5)=PAx*VS0(49,5)+WPx*VS1(49,5)&
   +r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))&
   +2D0*HfxZpE*VS1(49,2)
VS0(72,6)=PAx*VS0(49,6)+WPx*VS1(49,6)&
   +r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(49,3)
VS0(72,7)=PAx*VS0(49,7)+WPx*VS1(49,7)&
   +r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(72,8)=PAx*VS0(49,8)+WPx*VS1(49,8)&
   +r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(49,4)
VS0(72,9)=PAx*VS0(49,9)+WPx*VS1(49,9)&
   +r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))
VS0(72,10)=PAx*VS0(49,10)+WPx*VS1(49,10)&
   +r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(73,5)=PAy*VS0(49,5)+WPy*VS1(49,5)+r1x2Z*VR1(49,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(73,6)=PAy*VS0(49,6)+WPy*VS1(49,6)+r1x2Z*VR1(49,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(49,2)
VS0(73,7)=PAy*VS0(49,7)+WPy*VS1(49,7)+r1x2Z*VR1(49,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))&
   +2D0*HfxZpE*VS1(49,3)
VS0(73,8)=PAy*VS0(49,8)+WPy*VS1(49,8)+r1x2Z*VR1(49,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))
VS0(73,9)=PAy*VS0(49,9)+WPy*VS1(49,9)+r1x2Z*VR1(49,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(49,4)
VS0(73,10)=PAy*VS0(49,10)+WPy*VS1(49,10)+r1x2Z*VR1(49,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(74,5)=PAy*VS0(50,5)+WPy*VS1(50,5)+r1x2Z*VR1(50,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(74,6)=PAy*VS0(50,6)+WPy*VS1(50,6)+r1x2Z*VR1(50,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(50,2)
VS0(74,7)=PAy*VS0(50,7)+WPy*VS1(50,7)+r1x2Z*VR1(50,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(50,3)
VS0(74,8)=PAy*VS0(50,8)+WPy*VS1(50,8)+r1x2Z*VR1(50,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))
VS0(74,9)=PAy*VS0(50,9)+WPy*VS1(50,9)+r1x2Z*VR1(50,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(50,4)
VS0(74,10)=PAy*VS0(50,10)+WPy*VS1(50,10)+r1x2Z*VR1(50,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(75,5)=PAx*VS0(51,5)+WPx*VS1(51,5)&
   +2D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))&
   +2D0*HfxZpE*VS1(51,2)
VS0(75,6)=PAx*VS0(51,6)+WPx*VS1(51,6)&
   +2D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))&
   +HfxZpE*VS1(51,3)
VS0(75,7)=PAx*VS0(51,7)+WPx*VS1(51,7)&
   +2D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(75,8)=PAx*VS0(51,8)+WPx*VS1(51,8)&
   +2D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(51,4)
VS0(75,9)=PAx*VS0(51,9)+WPx*VS1(51,9)&
   +2D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))
VS0(75,10)=PAx*VS0(51,10)+WPx*VS1(51,10)&
   +2D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))
VS0(76,5)=PAz*VS0(48,5)+WPz*VS1(48,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(76,6)=PAz*VS0(48,6)+WPz*VS1(48,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))
VS0(76,7)=PAz*VS0(48,7)+WPz*VS1(48,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(76,8)=PAz*VS0(48,8)+WPz*VS1(48,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(48,2)
VS0(76,9)=PAz*VS0(48,9)+WPz*VS1(48,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(48,3)
VS0(76,10)=PAz*VS0(48,10)+WPz*VS1(48,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(48,4)
VS0(77,5)=PAz*VS0(49,5)+WPz*VS1(49,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(77,6)=PAz*VS0(49,6)+WPz*VS1(49,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))
VS0(77,7)=PAz*VS0(49,7)+WPz*VS1(49,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(77,8)=PAz*VS0(49,8)+WPz*VS1(49,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(49,2)
VS0(77,9)=PAz*VS0(49,9)+WPz*VS1(49,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(49,3)
VS0(77,10)=PAz*VS0(49,10)+WPz*VS1(49,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(49,4)
VS0(78,5)=PAy*VS0(53,5)+WPy*VS1(53,5)+r1x2Z*VR1(53,5)&
   +2D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(78,6)=PAy*VS0(53,6)+WPy*VS1(53,6)+r1x2Z*VR1(53,6)&
   +2D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))&
   +HfxZpE*VS1(53,2)
VS0(78,7)=PAy*VS0(53,7)+WPy*VS1(53,7)+r1x2Z*VR1(53,7)&
   +2D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))&
   +2D0*HfxZpE*VS1(53,3)
VS0(78,8)=PAy*VS0(53,8)+WPy*VS1(53,8)+r1x2Z*VR1(53,8)&
   +2D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))
VS0(78,9)=PAy*VS0(53,9)+WPy*VS1(53,9)+r1x2Z*VR1(53,9)&
   +2D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(53,4)
VS0(78,10)=PAy*VS0(53,10)+WPy*VS1(53,10)+r1x2Z*VR1(53,10)&
   +2D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))
VS0(79,5)=PAz*VS0(51,5)+WPz*VS1(51,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))
VS0(79,6)=PAz*VS0(51,6)+WPz*VS1(51,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))
VS0(79,7)=PAz*VS0(51,7)+WPz*VS1(51,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(79,8)=PAz*VS0(51,8)+WPz*VS1(51,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(51,2)
VS0(79,9)=PAz*VS0(51,9)+WPz*VS1(51,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))&
   +HfxZpE*VS1(51,3)
VS0(79,10)=PAz*VS0(51,10)+WPz*VS1(51,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(51,4)
VS0(80,5)=PAz*VS0(52,5)+WPz*VS1(52,5)&
   +3D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(80,6)=PAz*VS0(52,6)+WPz*VS1(52,6)&
   +3D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))
VS0(80,7)=PAz*VS0(52,7)+WPz*VS1(52,7)&
   +3D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(80,8)=PAz*VS0(52,8)+WPz*VS1(52,8)&
   +3D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(52,2)
VS0(80,9)=PAz*VS0(52,9)+WPz*VS1(52,9)&
   +3D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(52,3)
VS0(80,10)=PAz*VS0(52,10)+WPz*VS1(52,10)&
   +3D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(52,4)
VS0(81,5)=PAz*VS0(53,5)+WPz*VS1(53,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(81,6)=PAz*VS0(53,6)+WPz*VS1(53,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))
VS0(81,7)=PAz*VS0(53,7)+WPz*VS1(53,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(81,8)=PAz*VS0(53,8)+WPz*VS1(53,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(53,2)
VS0(81,9)=PAz*VS0(53,9)+WPz*VS1(53,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(53,3)
VS0(81,10)=PAz*VS0(53,10)+WPz*VS1(53,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(53,4)
VS0(82,5)=PAz*VS0(54,5)+WPz*VS1(54,5)&
   +4D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))
VS0(82,6)=PAz*VS0(54,6)+WPz*VS1(54,6)&
   +4D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))
VS0(82,7)=PAz*VS0(54,7)+WPz*VS1(54,7)&
   +4D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(82,8)=PAz*VS0(54,8)+WPz*VS1(54,8)&
   +4D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(54,2)
VS0(82,9)=PAz*VS0(54,9)+WPz*VS1(54,9)&
   +4D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))&
   +HfxZpE*VS1(54,3)
VS0(82,10)=PAz*VS0(54,10)+WPz*VS1(54,10)&
   +4D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))&
   +2D0*HfxZpE*VS1(54,4)
VS0(83,5)=PAz*VS0(55,5)+WPz*VS1(55,5)&
   +4D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(83,6)=PAz*VS0(55,6)+WPz*VS1(55,6)&
   +4D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))
VS0(83,7)=PAz*VS0(55,7)+WPz*VS1(55,7)&
   +4D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))
VS0(83,8)=PAz*VS0(55,8)+WPz*VS1(55,8)&
   +4D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))&
   +HfxZpE*VS1(55,2)
VS0(83,9)=PAz*VS0(55,9)+WPz*VS1(55,9)&
   +4D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(55,3)
VS0(83,10)=PAz*VS0(55,10)+WPz*VS1(55,10)&
   +4D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))&
   +2D0*HfxZpE*VS1(55,4)
VS0(84,5)=PAz*VS0(56,5)+WPz*VS1(56,5)&
   +5D0*r1x2Z*(VS0(35,5)-ExZpE*VS1(35,5))
VS0(84,6)=PAz*VS0(56,6)+WPz*VS1(56,6)&
   +5D0*r1x2Z*(VS0(35,6)-ExZpE*VS1(35,6))
VS0(84,7)=PAz*VS0(56,7)+WPz*VS1(56,7)&
   +5D0*r1x2Z*(VS0(35,7)-ExZpE*VS1(35,7))
VS0(84,8)=PAz*VS0(56,8)+WPz*VS1(56,8)&
   +5D0*r1x2Z*(VS0(35,8)-ExZpE*VS1(35,8))&
   +HfxZpE*VS1(56,2)
VS0(84,9)=PAz*VS0(56,9)+WPz*VS1(56,9)&
   +5D0*r1x2Z*(VS0(35,9)-ExZpE*VS1(35,9))&
   +HfxZpE*VS1(56,3)
VS0(84,10)=PAz*VS0(56,10)+WPz*VS1(56,10)&
   +5D0*r1x2Z*(VS0(35,10)-ExZpE*VS1(35,10))&
   +2D0*HfxZpE*VS1(56,4)
CASE(3)
VS0(57,5)=PAx*VS0(36,5)+WPx*VS1(36,5)&
   +5D0*r1x2Z*(VS0(21,5)-ExZpE*VS1(21,5))&
   +2D0*HfxZpE*VS1(36,2)
VS0(57,6)=PAx*VS0(36,6)+WPx*VS1(36,6)&
   +5D0*r1x2Z*(VS0(21,6)-ExZpE*VS1(21,6))&
   +HfxZpE*VS1(36,3)
VS0(57,7)=PAx*VS0(36,7)+WPx*VS1(36,7)&
   +5D0*r1x2Z*(VS0(21,7)-ExZpE*VS1(21,7))
VS0(57,8)=PAx*VS0(36,8)+WPx*VS1(36,8)&
   +5D0*r1x2Z*(VS0(21,8)-ExZpE*VS1(21,8))&
   +HfxZpE*VS1(36,4)
VS0(57,9)=PAx*VS0(36,9)+WPx*VS1(36,9)&
   +5D0*r1x2Z*(VS0(21,9)-ExZpE*VS1(21,9))
VS0(57,10)=PAx*VS0(36,10)+WPx*VS1(36,10)&
   +5D0*r1x2Z*(VS0(21,10)-ExZpE*VS1(21,10))
VS0(58,5)=PAx*VS0(37,5)+WPx*VS1(37,5)&
   +4D0*r1x2Z*(VS0(22,5)-ExZpE*VS1(22,5))&
   +2D0*HfxZpE*VS1(37,2)
VS0(58,6)=PAx*VS0(37,6)+WPx*VS1(37,6)&
   +4D0*r1x2Z*(VS0(22,6)-ExZpE*VS1(22,6))&
   +HfxZpE*VS1(37,3)
VS0(58,7)=PAx*VS0(37,7)+WPx*VS1(37,7)&
   +4D0*r1x2Z*(VS0(22,7)-ExZpE*VS1(22,7))
VS0(58,8)=PAx*VS0(37,8)+WPx*VS1(37,8)&
   +4D0*r1x2Z*(VS0(22,8)-ExZpE*VS1(22,8))&
   +HfxZpE*VS1(37,4)
VS0(58,9)=PAx*VS0(37,9)+WPx*VS1(37,9)&
   +4D0*r1x2Z*(VS0(22,9)-ExZpE*VS1(22,9))
VS0(58,10)=PAx*VS0(37,10)+WPx*VS1(37,10)&
   +4D0*r1x2Z*(VS0(22,10)-ExZpE*VS1(22,10))
VS0(59,5)=PAx*VS0(38,5)+WPx*VS1(38,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))&
   +2D0*HfxZpE*VS1(38,2)
VS0(59,6)=PAx*VS0(38,6)+WPx*VS1(38,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(38,3)
VS0(59,7)=PAx*VS0(38,7)+WPx*VS1(38,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))
VS0(59,8)=PAx*VS0(38,8)+WPx*VS1(38,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))&
   +HfxZpE*VS1(38,4)
VS0(59,9)=PAx*VS0(38,9)+WPx*VS1(38,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))
VS0(59,10)=PAx*VS0(38,10)+WPx*VS1(38,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(60,5)=PAx*VS0(39,5)+WPx*VS1(39,5)&
   +2D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))&
   +2D0*HfxZpE*VS1(39,2)
VS0(60,6)=PAx*VS0(39,6)+WPx*VS1(39,6)&
   +2D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(39,3)
VS0(60,7)=PAx*VS0(39,7)+WPx*VS1(39,7)&
   +2D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))
VS0(60,8)=PAx*VS0(39,8)+WPx*VS1(39,8)&
   +2D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))&
   +HfxZpE*VS1(39,4)
VS0(60,9)=PAx*VS0(39,9)+WPx*VS1(39,9)&
   +2D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))
VS0(60,10)=PAx*VS0(39,10)+WPx*VS1(39,10)&
   +2D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(61,5)=PAy*VS0(39,5)+WPy*VS1(39,5)&
   +3D0*r1x2Z*(VS0(23,5)-ExZpE*VS1(23,5))
VS0(61,6)=PAy*VS0(39,6)+WPy*VS1(39,6)&
   +3D0*r1x2Z*(VS0(23,6)-ExZpE*VS1(23,6))&
   +HfxZpE*VS1(39,2)
VS0(61,7)=PAy*VS0(39,7)+WPy*VS1(39,7)&
   +3D0*r1x2Z*(VS0(23,7)-ExZpE*VS1(23,7))&
   +2D0*HfxZpE*VS1(39,3)
VS0(61,8)=PAy*VS0(39,8)+WPy*VS1(39,8)&
   +3D0*r1x2Z*(VS0(23,8)-ExZpE*VS1(23,8))
VS0(61,9)=PAy*VS0(39,9)+WPy*VS1(39,9)&
   +3D0*r1x2Z*(VS0(23,9)-ExZpE*VS1(23,9))&
   +HfxZpE*VS1(39,4)
VS0(61,10)=PAy*VS0(39,10)+WPy*VS1(39,10)&
   +3D0*r1x2Z*(VS0(23,10)-ExZpE*VS1(23,10))
VS0(62,5)=PAy*VS0(40,5)+WPy*VS1(40,5)&
   +4D0*r1x2Z*(VS0(24,5)-ExZpE*VS1(24,5))
VS0(62,6)=PAy*VS0(40,6)+WPy*VS1(40,6)&
   +4D0*r1x2Z*(VS0(24,6)-ExZpE*VS1(24,6))&
   +HfxZpE*VS1(40,2)
VS0(62,7)=PAy*VS0(40,7)+WPy*VS1(40,7)&
   +4D0*r1x2Z*(VS0(24,7)-ExZpE*VS1(24,7))&
   +2D0*HfxZpE*VS1(40,3)
VS0(62,8)=PAy*VS0(40,8)+WPy*VS1(40,8)&
   +4D0*r1x2Z*(VS0(24,8)-ExZpE*VS1(24,8))
VS0(62,9)=PAy*VS0(40,9)+WPy*VS1(40,9)&
   +4D0*r1x2Z*(VS0(24,9)-ExZpE*VS1(24,9))&
   +HfxZpE*VS1(40,4)
VS0(62,10)=PAy*VS0(40,10)+WPy*VS1(40,10)&
   +4D0*r1x2Z*(VS0(24,10)-ExZpE*VS1(24,10))
VS0(63,5)=PAy*VS0(41,5)+WPy*VS1(41,5)&
   +5D0*r1x2Z*(VS0(25,5)-ExZpE*VS1(25,5))
VS0(63,6)=PAy*VS0(41,6)+WPy*VS1(41,6)&
   +5D0*r1x2Z*(VS0(25,6)-ExZpE*VS1(25,6))&
   +HfxZpE*VS1(41,2)
VS0(63,7)=PAy*VS0(41,7)+WPy*VS1(41,7)&
   +5D0*r1x2Z*(VS0(25,7)-ExZpE*VS1(25,7))&
   +2D0*HfxZpE*VS1(41,3)
VS0(63,8)=PAy*VS0(41,8)+WPy*VS1(41,8)&
   +5D0*r1x2Z*(VS0(25,8)-ExZpE*VS1(25,8))
VS0(63,9)=PAy*VS0(41,9)+WPy*VS1(41,9)&
   +5D0*r1x2Z*(VS0(25,9)-ExZpE*VS1(25,9))&
   +HfxZpE*VS1(41,4)
VS0(63,10)=PAy*VS0(41,10)+WPy*VS1(41,10)&
   +5D0*r1x2Z*(VS0(25,10)-ExZpE*VS1(25,10))
VS0(64,5)=PAx*VS0(42,5)+WPx*VS1(42,5)&
   +4D0*r1x2Z*(VS0(26,5)-ExZpE*VS1(26,5))&
   +2D0*HfxZpE*VS1(42,2)
VS0(64,6)=PAx*VS0(42,6)+WPx*VS1(42,6)&
   +4D0*r1x2Z*(VS0(26,6)-ExZpE*VS1(26,6))&
   +HfxZpE*VS1(42,3)
VS0(64,7)=PAx*VS0(42,7)+WPx*VS1(42,7)&
   +4D0*r1x2Z*(VS0(26,7)-ExZpE*VS1(26,7))
VS0(64,8)=PAx*VS0(42,8)+WPx*VS1(42,8)&
   +4D0*r1x2Z*(VS0(26,8)-ExZpE*VS1(26,8))&
   +HfxZpE*VS1(42,4)
VS0(64,9)=PAx*VS0(42,9)+WPx*VS1(42,9)&
   +4D0*r1x2Z*(VS0(26,9)-ExZpE*VS1(26,9))
VS0(64,10)=PAx*VS0(42,10)+WPx*VS1(42,10)&
   +4D0*r1x2Z*(VS0(26,10)-ExZpE*VS1(26,10))
VS0(65,5)=PAx*VS0(43,5)+WPx*VS1(43,5)&
   +3D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))&
   +2D0*HfxZpE*VS1(43,2)
VS0(65,6)=PAx*VS0(43,6)+WPx*VS1(43,6)&
   +3D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(43,3)
VS0(65,7)=PAx*VS0(43,7)+WPx*VS1(43,7)&
   +3D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(65,8)=PAx*VS0(43,8)+WPx*VS1(43,8)&
   +3D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(43,4)
VS0(65,9)=PAx*VS0(43,9)+WPx*VS1(43,9)&
   +3D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))
VS0(65,10)=PAx*VS0(43,10)+WPx*VS1(43,10)&
   +3D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(66,5)=PAx*VS0(44,5)+WPx*VS1(44,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))&
   +2D0*HfxZpE*VS1(44,2)
VS0(66,6)=PAx*VS0(44,6)+WPx*VS1(44,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(44,3)
VS0(66,7)=PAx*VS0(44,7)+WPx*VS1(44,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(66,8)=PAx*VS0(44,8)+WPx*VS1(44,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(44,4)
VS0(66,9)=PAx*VS0(44,9)+WPx*VS1(44,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))
VS0(66,10)=PAx*VS0(44,10)+WPx*VS1(44,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(67,5)=PAy*VS0(44,5)+WPy*VS1(44,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(67,6)=PAy*VS0(44,6)+WPy*VS1(44,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))&
   +HfxZpE*VS1(44,2)
VS0(67,7)=PAy*VS0(44,7)+WPy*VS1(44,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))&
   +2D0*HfxZpE*VS1(44,3)
VS0(67,8)=PAy*VS0(44,8)+WPy*VS1(44,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))
VS0(67,9)=PAy*VS0(44,9)+WPy*VS1(44,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(44,4)
VS0(67,10)=PAy*VS0(44,10)+WPy*VS1(44,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))
VS0(68,5)=PAy*VS0(45,5)+WPy*VS1(45,5)&
   +3D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(68,6)=PAy*VS0(45,6)+WPy*VS1(45,6)&
   +3D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))&
   +HfxZpE*VS1(45,2)
VS0(68,7)=PAy*VS0(45,7)+WPy*VS1(45,7)&
   +3D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))&
   +2D0*HfxZpE*VS1(45,3)
VS0(68,8)=PAy*VS0(45,8)+WPy*VS1(45,8)&
   +3D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))
VS0(68,9)=PAy*VS0(45,9)+WPy*VS1(45,9)&
   +3D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(45,4)
VS0(68,10)=PAy*VS0(45,10)+WPy*VS1(45,10)&
   +3D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))
VS0(69,5)=PAy*VS0(46,5)+WPy*VS1(46,5)&
   +4D0*r1x2Z*(VS0(29,5)-ExZpE*VS1(29,5))
VS0(69,6)=PAy*VS0(46,6)+WPy*VS1(46,6)&
   +4D0*r1x2Z*(VS0(29,6)-ExZpE*VS1(29,6))&
   +HfxZpE*VS1(46,2)
VS0(69,7)=PAy*VS0(46,7)+WPy*VS1(46,7)&
   +4D0*r1x2Z*(VS0(29,7)-ExZpE*VS1(29,7))&
   +2D0*HfxZpE*VS1(46,3)
VS0(69,8)=PAy*VS0(46,8)+WPy*VS1(46,8)&
   +4D0*r1x2Z*(VS0(29,8)-ExZpE*VS1(29,8))
VS0(69,9)=PAy*VS0(46,9)+WPy*VS1(46,9)&
   +4D0*r1x2Z*(VS0(29,9)-ExZpE*VS1(29,9))&
   +HfxZpE*VS1(46,4)
VS0(69,10)=PAy*VS0(46,10)+WPy*VS1(46,10)&
   +4D0*r1x2Z*(VS0(29,10)-ExZpE*VS1(29,10))
VS0(70,5)=PAx*VS0(47,5)+WPx*VS1(47,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))&
   +2D0*HfxZpE*VS1(47,2)
VS0(70,6)=PAx*VS0(47,6)+WPx*VS1(47,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))&
   +HfxZpE*VS1(47,3)
VS0(70,7)=PAx*VS0(47,7)+WPx*VS1(47,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(70,8)=PAx*VS0(47,8)+WPx*VS1(47,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(47,4)
VS0(70,9)=PAx*VS0(47,9)+WPx*VS1(47,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))
VS0(70,10)=PAx*VS0(47,10)+WPx*VS1(47,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))
VS0(71,5)=PAx*VS0(48,5)+WPx*VS1(48,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))&
   +2D0*HfxZpE*VS1(48,2)
VS0(71,6)=PAx*VS0(48,6)+WPx*VS1(48,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(48,3)
VS0(71,7)=PAx*VS0(48,7)+WPx*VS1(48,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(71,8)=PAx*VS0(48,8)+WPx*VS1(48,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(48,4)
VS0(71,9)=PAx*VS0(48,9)+WPx*VS1(48,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))
VS0(71,10)=PAx*VS0(48,10)+WPx*VS1(48,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(72,5)=PAx*VS0(49,5)+WPx*VS1(49,5)&
   +r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))&
   +2D0*HfxZpE*VS1(49,2)
VS0(72,6)=PAx*VS0(49,6)+WPx*VS1(49,6)&
   +r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(49,3)
VS0(72,7)=PAx*VS0(49,7)+WPx*VS1(49,7)&
   +r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(72,8)=PAx*VS0(49,8)+WPx*VS1(49,8)&
   +r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(49,4)
VS0(72,9)=PAx*VS0(49,9)+WPx*VS1(49,9)&
   +r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))
VS0(72,10)=PAx*VS0(49,10)+WPx*VS1(49,10)&
   +r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(73,5)=PAy*VS0(49,5)+WPy*VS1(49,5)&
   +2D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(73,6)=PAy*VS0(49,6)+WPy*VS1(49,6)&
   +2D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))&
   +HfxZpE*VS1(49,2)
VS0(73,7)=PAy*VS0(49,7)+WPy*VS1(49,7)&
   +2D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))&
   +2D0*HfxZpE*VS1(49,3)
VS0(73,8)=PAy*VS0(49,8)+WPy*VS1(49,8)&
   +2D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))
VS0(73,9)=PAy*VS0(49,9)+WPy*VS1(49,9)&
   +2D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(49,4)
VS0(73,10)=PAy*VS0(49,10)+WPy*VS1(49,10)&
   +2D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))
VS0(74,5)=PAy*VS0(50,5)+WPy*VS1(50,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(74,6)=PAy*VS0(50,6)+WPy*VS1(50,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))&
   +HfxZpE*VS1(50,2)
VS0(74,7)=PAy*VS0(50,7)+WPy*VS1(50,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))&
   +2D0*HfxZpE*VS1(50,3)
VS0(74,8)=PAy*VS0(50,8)+WPy*VS1(50,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))
VS0(74,9)=PAy*VS0(50,9)+WPy*VS1(50,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(50,4)
VS0(74,10)=PAy*VS0(50,10)+WPy*VS1(50,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))
VS0(75,5)=PAx*VS0(51,5)+WPx*VS1(51,5)&
   +2D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))&
   +2D0*HfxZpE*VS1(51,2)
VS0(75,6)=PAx*VS0(51,6)+WPx*VS1(51,6)&
   +2D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))&
   +HfxZpE*VS1(51,3)
VS0(75,7)=PAx*VS0(51,7)+WPx*VS1(51,7)&
   +2D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(75,8)=PAx*VS0(51,8)+WPx*VS1(51,8)&
   +2D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(51,4)
VS0(75,9)=PAx*VS0(51,9)+WPx*VS1(51,9)&
   +2D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))
VS0(75,10)=PAx*VS0(51,10)+WPx*VS1(51,10)&
   +2D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))
VS0(76,5)=PAz*VS0(48,5)+WPz*VS1(48,5)+r1x2Z*VR1(48,5)&
   +2D0*r1x2Z*(VS0(27,5)-ExZpE*VS1(27,5))
VS0(76,6)=PAz*VS0(48,6)+WPz*VS1(48,6)+r1x2Z*VR1(48,6)&
   +2D0*r1x2Z*(VS0(27,6)-ExZpE*VS1(27,6))
VS0(76,7)=PAz*VS0(48,7)+WPz*VS1(48,7)+r1x2Z*VR1(48,7)&
   +2D0*r1x2Z*(VS0(27,7)-ExZpE*VS1(27,7))
VS0(76,8)=PAz*VS0(48,8)+WPz*VS1(48,8)+r1x2Z*VR1(48,8)&
   +2D0*r1x2Z*(VS0(27,8)-ExZpE*VS1(27,8))&
   +HfxZpE*VS1(48,2)
VS0(76,9)=PAz*VS0(48,9)+WPz*VS1(48,9)+r1x2Z*VR1(48,9)&
   +2D0*r1x2Z*(VS0(27,9)-ExZpE*VS1(27,9))&
   +HfxZpE*VS1(48,3)
VS0(76,10)=PAz*VS0(48,10)+WPz*VS1(48,10)+r1x2Z*VR1(48,10)&
   +2D0*r1x2Z*(VS0(27,10)-ExZpE*VS1(27,10))&
   +2D0*HfxZpE*VS1(48,4)
VS0(77,5)=PAz*VS0(49,5)+WPz*VS1(49,5)+r1x2Z*VR1(49,5)&
   +2D0*r1x2Z*(VS0(28,5)-ExZpE*VS1(28,5))
VS0(77,6)=PAz*VS0(49,6)+WPz*VS1(49,6)+r1x2Z*VR1(49,6)&
   +2D0*r1x2Z*(VS0(28,6)-ExZpE*VS1(28,6))
VS0(77,7)=PAz*VS0(49,7)+WPz*VS1(49,7)+r1x2Z*VR1(49,7)&
   +2D0*r1x2Z*(VS0(28,7)-ExZpE*VS1(28,7))
VS0(77,8)=PAz*VS0(49,8)+WPz*VS1(49,8)+r1x2Z*VR1(49,8)&
   +2D0*r1x2Z*(VS0(28,8)-ExZpE*VS1(28,8))&
   +HfxZpE*VS1(49,2)
VS0(77,9)=PAz*VS0(49,9)+WPz*VS1(49,9)+r1x2Z*VR1(49,9)&
   +2D0*r1x2Z*(VS0(28,9)-ExZpE*VS1(28,9))&
   +HfxZpE*VS1(49,3)
VS0(77,10)=PAz*VS0(49,10)+WPz*VS1(49,10)+r1x2Z*VR1(49,10)&
   +2D0*r1x2Z*(VS0(28,10)-ExZpE*VS1(28,10))&
   +2D0*HfxZpE*VS1(49,4)
VS0(78,5)=PAy*VS0(53,5)+WPy*VS1(53,5)&
   +2D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(78,6)=PAy*VS0(53,6)+WPy*VS1(53,6)&
   +2D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))&
   +HfxZpE*VS1(53,2)
VS0(78,7)=PAy*VS0(53,7)+WPy*VS1(53,7)&
   +2D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))&
   +2D0*HfxZpE*VS1(53,3)
VS0(78,8)=PAy*VS0(53,8)+WPy*VS1(53,8)&
   +2D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))
VS0(78,9)=PAy*VS0(53,9)+WPy*VS1(53,9)&
   +2D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(53,4)
VS0(78,10)=PAy*VS0(53,10)+WPy*VS1(53,10)&
   +2D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))
VS0(79,5)=PAz*VS0(51,5)+WPz*VS1(51,5)+r1x2Z*VR1(51,5)&
   +3D0*r1x2Z*(VS0(30,5)-ExZpE*VS1(30,5))
VS0(79,6)=PAz*VS0(51,6)+WPz*VS1(51,6)+r1x2Z*VR1(51,6)&
   +3D0*r1x2Z*(VS0(30,6)-ExZpE*VS1(30,6))
VS0(79,7)=PAz*VS0(51,7)+WPz*VS1(51,7)+r1x2Z*VR1(51,7)&
   +3D0*r1x2Z*(VS0(30,7)-ExZpE*VS1(30,7))
VS0(79,8)=PAz*VS0(51,8)+WPz*VS1(51,8)+r1x2Z*VR1(51,8)&
   +3D0*r1x2Z*(VS0(30,8)-ExZpE*VS1(30,8))&
   +HfxZpE*VS1(51,2)
VS0(79,9)=PAz*VS0(51,9)+WPz*VS1(51,9)+r1x2Z*VR1(51,9)&
   +3D0*r1x2Z*(VS0(30,9)-ExZpE*VS1(30,9))&
   +HfxZpE*VS1(51,3)
VS0(79,10)=PAz*VS0(51,10)+WPz*VS1(51,10)+r1x2Z*VR1(51,10)&
   +3D0*r1x2Z*(VS0(30,10)-ExZpE*VS1(30,10))&
   +2D0*HfxZpE*VS1(51,4)
VS0(80,5)=PAz*VS0(52,5)+WPz*VS1(52,5)+r1x2Z*VR1(52,5)&
   +3D0*r1x2Z*(VS0(31,5)-ExZpE*VS1(31,5))
VS0(80,6)=PAz*VS0(52,6)+WPz*VS1(52,6)+r1x2Z*VR1(52,6)&
   +3D0*r1x2Z*(VS0(31,6)-ExZpE*VS1(31,6))
VS0(80,7)=PAz*VS0(52,7)+WPz*VS1(52,7)+r1x2Z*VR1(52,7)&
   +3D0*r1x2Z*(VS0(31,7)-ExZpE*VS1(31,7))
VS0(80,8)=PAz*VS0(52,8)+WPz*VS1(52,8)+r1x2Z*VR1(52,8)&
   +3D0*r1x2Z*(VS0(31,8)-ExZpE*VS1(31,8))&
   +HfxZpE*VS1(52,2)
VS0(80,9)=PAz*VS0(52,9)+WPz*VS1(52,9)+r1x2Z*VR1(52,9)&
   +3D0*r1x2Z*(VS0(31,9)-ExZpE*VS1(31,9))&
   +HfxZpE*VS1(52,3)
VS0(80,10)=PAz*VS0(52,10)+WPz*VS1(52,10)+r1x2Z*VR1(52,10)&
   +3D0*r1x2Z*(VS0(31,10)-ExZpE*VS1(31,10))&
   +2D0*HfxZpE*VS1(52,4)
VS0(81,5)=PAz*VS0(53,5)+WPz*VS1(53,5)+r1x2Z*VR1(53,5)&
   +3D0*r1x2Z*(VS0(32,5)-ExZpE*VS1(32,5))
VS0(81,6)=PAz*VS0(53,6)+WPz*VS1(53,6)+r1x2Z*VR1(53,6)&
   +3D0*r1x2Z*(VS0(32,6)-ExZpE*VS1(32,6))
VS0(81,7)=PAz*VS0(53,7)+WPz*VS1(53,7)+r1x2Z*VR1(53,7)&
   +3D0*r1x2Z*(VS0(32,7)-ExZpE*VS1(32,7))
VS0(81,8)=PAz*VS0(53,8)+WPz*VS1(53,8)+r1x2Z*VR1(53,8)&
   +3D0*r1x2Z*(VS0(32,8)-ExZpE*VS1(32,8))&
   +HfxZpE*VS1(53,2)
VS0(81,9)=PAz*VS0(53,9)+WPz*VS1(53,9)+r1x2Z*VR1(53,9)&
   +3D0*r1x2Z*(VS0(32,9)-ExZpE*VS1(32,9))&
   +HfxZpE*VS1(53,3)
VS0(81,10)=PAz*VS0(53,10)+WPz*VS1(53,10)+r1x2Z*VR1(53,10)&
   +3D0*r1x2Z*(VS0(32,10)-ExZpE*VS1(32,10))&
   +2D0*HfxZpE*VS1(53,4)
VS0(82,5)=PAz*VS0(54,5)+WPz*VS1(54,5)+r1x2Z*VR1(54,5)&
   +4D0*r1x2Z*(VS0(33,5)-ExZpE*VS1(33,5))
VS0(82,6)=PAz*VS0(54,6)+WPz*VS1(54,6)+r1x2Z*VR1(54,6)&
   +4D0*r1x2Z*(VS0(33,6)-ExZpE*VS1(33,6))
VS0(82,7)=PAz*VS0(54,7)+WPz*VS1(54,7)+r1x2Z*VR1(54,7)&
   +4D0*r1x2Z*(VS0(33,7)-ExZpE*VS1(33,7))
VS0(82,8)=PAz*VS0(54,8)+WPz*VS1(54,8)+r1x2Z*VR1(54,8)&
   +4D0*r1x2Z*(VS0(33,8)-ExZpE*VS1(33,8))&
   +HfxZpE*VS1(54,2)
VS0(82,9)=PAz*VS0(54,9)+WPz*VS1(54,9)+r1x2Z*VR1(54,9)&
   +4D0*r1x2Z*(VS0(33,9)-ExZpE*VS1(33,9))&
   +HfxZpE*VS1(54,3)
VS0(82,10)=PAz*VS0(54,10)+WPz*VS1(54,10)+r1x2Z*VR1(54,10)&
   +4D0*r1x2Z*(VS0(33,10)-ExZpE*VS1(33,10))&
   +2D0*HfxZpE*VS1(54,4)
VS0(83,5)=PAz*VS0(55,5)+WPz*VS1(55,5)+r1x2Z*VR1(55,5)&
   +4D0*r1x2Z*(VS0(34,5)-ExZpE*VS1(34,5))
VS0(83,6)=PAz*VS0(55,6)+WPz*VS1(55,6)+r1x2Z*VR1(55,6)&
   +4D0*r1x2Z*(VS0(34,6)-ExZpE*VS1(34,6))
VS0(83,7)=PAz*VS0(55,7)+WPz*VS1(55,7)+r1x2Z*VR1(55,7)&
   +4D0*r1x2Z*(VS0(34,7)-ExZpE*VS1(34,7))
VS0(83,8)=PAz*VS0(55,8)+WPz*VS1(55,8)+r1x2Z*VR1(55,8)&
   +4D0*r1x2Z*(VS0(34,8)-ExZpE*VS1(34,8))&
   +HfxZpE*VS1(55,2)
VS0(83,9)=PAz*VS0(55,9)+WPz*VS1(55,9)+r1x2Z*VR1(55,9)&
   +4D0*r1x2Z*(VS0(34,9)-ExZpE*VS1(34,9))&
   +HfxZpE*VS1(55,3)
VS0(83,10)=PAz*VS0(55,10)+WPz*VS1(55,10)+r1x2Z*VR1(55,10)&
   +4D0*r1x2Z*(VS0(34,10)-ExZpE*VS1(34,10))&
   +2D0*HfxZpE*VS1(55,4)
VS0(84,5)=PAz*VS0(56,5)+WPz*VS1(56,5)+r1x2Z*VR1(56,5)&
   +5D0*r1x2Z*(VS0(35,5)-ExZpE*VS1(35,5))
VS0(84,6)=PAz*VS0(56,6)+WPz*VS1(56,6)+r1x2Z*VR1(56,6)&
   +5D0*r1x2Z*(VS0(35,6)-ExZpE*VS1(35,6))
VS0(84,7)=PAz*VS0(56,7)+WPz*VS1(56,7)+r1x2Z*VR1(56,7)&
   +5D0*r1x2Z*(VS0(35,7)-ExZpE*VS1(35,7))
VS0(84,8)=PAz*VS0(56,8)+WPz*VS1(56,8)+r1x2Z*VR1(56,8)&
   +5D0*r1x2Z*(VS0(35,8)-ExZpE*VS1(35,8))&
   +HfxZpE*VS1(56,2)
VS0(84,9)=PAz*VS0(56,9)+WPz*VS1(56,9)+r1x2Z*VR1(56,9)&
   +5D0*r1x2Z*(VS0(35,9)-ExZpE*VS1(35,9))&
   +HfxZpE*VS1(56,3)
VS0(84,10)=PAz*VS0(56,10)+WPz*VS1(56,10)+r1x2Z*VR1(56,10)&
   +5D0*r1x2Z*(VS0(35,10)-ExZpE*VS1(35,10))&
   +2D0*HfxZpE*VS1(56,4)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRi0d0'
STOP
END SELECT
END SUBROUTINE MVRRi0d0
