!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0f0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(12,12)
      V(2)=ExZpE*r1x2Z*VRR1(12,12)
      V(3)=r1x2Z*VRR0(12,13)
      V(4)=ExZpE*r1x2Z*VRR1(12,13)
      V(5)=HfxZpE*VRR1(22,7)
      V(6)=r1x2Z*VRR0(12,15)
      V(7)=ExZpE*r1x2Z*VRR1(12,15)
      V(8)=r1x2Z*VRR0(12,16)
      V(9)=ExZpE*r1x2Z*VRR1(12,16)
      V(10)=r1x2Z*VRR0(12,17)
      V(11)=ExZpE*r1x2Z*VRR1(12,17)
      V(12)=r1x2Z*VRR0(12,18)
      V(13)=ExZpE*r1x2Z*VRR1(12,18)
      V(14)=HfxZpE*VRR1(22,10)
      V(15)=r1x2Z*VRR0(12,19)
      V(16)=ExZpE*r1x2Z*VRR1(12,19)
      V(17)=HfxZpE*VRR1(23,5)
      V(18)=r1x2Z*VRR0(13,12)
      V(19)=ExZpE*r1x2Z*VRR1(13,12)
      V(20)=HfxZpE*VRR1(23,6)
      V(21)=2.D0*V(20)
      V(22)=r1x2Z*VRR0(13,13)
      V(23)=ExZpE*r1x2Z*VRR1(13,13)
      V(24)=HfxZpE*VRR1(23,7)
      V(25)=r1x2Z*VRR0(13,15)
      V(26)=ExZpE*r1x2Z*VRR1(13,15)
      V(27)=HfxZpE*VRR1(23,8)
      V(28)=r1x2Z*VRR0(13,16)
      V(29)=ExZpE*r1x2Z*VRR1(13,16)
      V(30)=HfxZpE*VRR1(23,9)
      V(31)=r1x2Z*VRR0(13,17)
      V(32)=ExZpE*r1x2Z*VRR1(13,17)
      V(33)=r1x2Z*VRR0(13,18)
      V(34)=ExZpE*r1x2Z*VRR1(13,18)
      V(35)=HfxZpE*VRR1(23,10)
      V(36)=r1x2Z*VRR0(13,19)
      V(37)=ExZpE*r1x2Z*VRR1(13,19)
      V(38)=HfxZpE*VRR1(24,5)
      V(39)=HfxZpE*VRR1(24,10)
      V(40)=r1x2Z*VRR0(15,12)
      V(41)=ExZpE*r1x2Z*VRR1(15,12)
      V(42)=r1x2Z*VRR0(15,13)
      V(43)=ExZpE*r1x2Z*VRR1(15,13)
      V(44)=HfxZpE*VRR1(26,7)
      V(45)=r1x2Z*VRR0(15,15)
      V(46)=ExZpE*r1x2Z*VRR1(15,15)
      V(47)=r1x2Z*VRR0(15,16)
      V(48)=ExZpE*r1x2Z*VRR1(15,16)
      V(49)=r1x2Z*VRR0(15,17)
      V(50)=ExZpE*r1x2Z*VRR1(15,17)
      V(51)=r1x2Z*VRR0(15,18)
      V(52)=ExZpE*r1x2Z*VRR1(15,18)
      V(53)=HfxZpE*VRR1(26,10)
      V(54)=r1x2Z*VRR0(15,19)
      V(55)=ExZpE*r1x2Z*VRR1(15,19)
      V(56)=r1x2Z*VRR0(16,12)
      V(57)=2.D0*V(56)
      V(58)=ExZpE*r1x2Z*VRR1(16,12)
      V(59)=-2.D0*V(58)
      V(60)=HfxZpE*VRR1(27,6)
      V(61)=2.D0*V(60)
      V(62)=r1x2Z*VRR0(16,13)
      V(63)=2.D0*V(62)
      V(64)=ExZpE*r1x2Z*VRR1(16,13)
      V(65)=-2.D0*V(64)
      V(66)=HfxZpE*VRR1(27,7)
      V(67)=r1x2Z*VRR0(16,15)
      V(68)=2.D0*V(67)
      V(69)=ExZpE*r1x2Z*VRR1(16,15)
      V(70)=-2.D0*V(69)
      V(71)=HfxZpE*VRR1(27,8)
      V(72)=2.D0*V(71)
      V(73)=r1x2Z*VRR0(16,16)
      V(74)=2.D0*V(73)
      V(75)=ExZpE*r1x2Z*VRR1(16,16)
      V(76)=-2.D0*V(75)
      V(77)=HfxZpE*VRR1(27,9)
      V(78)=r1x2Z*VRR0(16,17)
      V(79)=2.D0*V(78)
      V(80)=ExZpE*r1x2Z*VRR1(16,17)
      V(81)=-2.D0*V(80)
      V(82)=r1x2Z*VRR0(16,18)
      V(83)=2.D0*V(82)
      V(84)=ExZpE*r1x2Z*VRR1(16,18)
      V(85)=-2.D0*V(84)
      V(86)=HfxZpE*VRR1(27,10)
      V(87)=r1x2Z*VRR0(16,19)
      V(88)=2.D0*V(87)
      V(89)=ExZpE*r1x2Z*VRR1(16,19)
      V(90)=-2.D0*V(89)
      V(91)=r1x2E*VRR0(44,2)
      V(92)=HfxZpE*VRR1(28,5)
      V(93)=r1x2E*ZxZpE*VRR1(44,2)
      V(94)=r1x2E*VRR0(44,3)
      V(95)=HfxZpE*VRR1(28,6)
      V(96)=2.D0*V(95)
      V(97)=r1x2E*ZxZpE*VRR1(44,3)
      V(98)=-V(97)
      V(99)=-V(93)
      V(100)=r1x2E*VRR0(44,4)
      V(101)=HfxZpE*VRR1(28,8)
      V(102)=2.D0*V(101)
      V(103)=r1x2E*ZxZpE*VRR1(44,4)
      V(104)=-V(103)
      V(105)=r1x2Z*VRR0(17,16)
      V(106)=ExZpE*r1x2Z*VRR1(17,16)
      V(107)=HfxZpE*VRR1(28,9)
      V(108)=2.D0*V(77)
      V(109)=HfxZpE*VRR1(29,5)
      V(110)=2.D0*V(107)
      V(111)=HfxZpE*VRR1(28,10)
      V(112)=r1x2Z*VRR0(17,12)
      V(113)=ExZpE*r1x2Z*VRR1(17,12)
      V(114)=r1x2Z*VRR0(17,13)
      V(115)=ExZpE*r1x2Z*VRR1(17,13)
      V(116)=r1x2Z*VRR0(17,15)
      V(117)=ExZpE*r1x2Z*VRR1(17,15)
      V(118)=r1x2Z*VRR0(17,17)
      V(119)=ExZpE*r1x2Z*VRR1(17,17)
      V(120)=r1x2Z*VRR0(17,18)
      V(121)=ExZpE*r1x2Z*VRR1(17,18)
      V(122)=r1x2Z*VRR0(17,19)
      V(123)=ExZpE*r1x2Z*VRR1(17,19)
      V(124)=HfxZpE*VRR1(29,10)
      V(125)=HfxZpE*VRR1(30,5)
      V(126)=r1x2Z*VRR0(18,12)
      V(127)=ExZpE*r1x2Z*VRR1(18,12)
      V(128)=HfxZpE*VRR1(30,6)
      V(129)=r1x2Z*VRR0(18,13)
      V(130)=ExZpE*r1x2Z*VRR1(18,13)
      V(131)=HfxZpE*VRR1(30,7)
      V(132)=r1x2Z*VRR0(18,15)
      V(133)=ExZpE*r1x2Z*VRR1(18,15)
      V(134)=HfxZpE*VRR1(30,8)
      V(135)=2.D0*V(134)
      V(136)=r1x2Z*VRR0(18,16)
      V(137)=ExZpE*r1x2Z*VRR1(18,16)
      V(138)=HfxZpE*VRR1(30,9)
      V(139)=r1x2Z*VRR0(18,17)
      V(140)=ExZpE*r1x2Z*VRR1(18,17)
      V(141)=r1x2Z*VRR0(18,18)
      V(142)=ExZpE*r1x2Z*VRR1(18,18)
      V(143)=HfxZpE*VRR1(30,10)
      V(144)=r1x2Z*VRR0(18,19)
      V(145)=ExZpE*r1x2Z*VRR1(18,19)
      V(146)=r1x2E*VRR0(48,2)
      V(147)=HfxZpE*VRR1(31,5)
      V(148)=r1x2E*ZxZpE*VRR1(48,2)
      V(149)=r1x2E*VRR0(48,3)
      V(150)=HfxZpE*VRR1(31,6)
      V(151)=2.D0*V(150)
      V(152)=r1x2E*ZxZpE*VRR1(48,3)
      V(153)=-V(152)
      V(154)=-V(148)
      V(155)=r1x2E*VRR0(48,4)
      V(156)=HfxZpE*VRR1(31,8)
      V(157)=2.D0*V(156)
      V(158)=r1x2E*ZxZpE*VRR1(48,4)
      V(159)=-V(158)
      V(160)=r1x2Z*VRR0(19,16)
      V(161)=ExZpE*r1x2Z*VRR1(19,16)
      V(162)=HfxZpE*VRR1(31,9)
      V(163)=r1x2E*VRR0(49,2)
      V(164)=HfxZpE*VRR1(32,5)
      V(165)=r1x2E*ZxZpE*VRR1(49,2)
      V(166)=r1x2E*VRR0(49,3)
      V(167)=HfxZpE*VRR1(32,6)
      V(168)=r1x2E*ZxZpE*VRR1(49,3)
      V(169)=-V(168)
      V(170)=-V(165)
      V(171)=HfxZpE*VRR1(31,7)
      V(172)=r1x2E*VRR0(49,4)
      V(173)=HfxZpE*VRR1(32,8)
      V(174)=r1x2E*ZxZpE*VRR1(49,4)
      V(175)=-V(174)
      V(176)=2.D0*V(162)
      V(177)=r1x2Z*VRR0(19,12)
      V(178)=ExZpE*r1x2Z*VRR1(19,12)
      V(179)=r1x2Z*VRR0(19,13)
      V(180)=ExZpE*r1x2Z*VRR1(19,13)
      V(181)=HfxZpE*VRR1(32,7)
      V(182)=r1x2Z*VRR0(19,15)
      V(183)=ExZpE*r1x2Z*VRR1(19,15)
      V(184)=r1x2Z*VRR0(19,17)
      V(185)=ExZpE*r1x2Z*VRR1(19,17)
      V(186)=HfxZpE*VRR1(32,9)
      V(187)=2.D0*V(186)
      V(188)=r1x2Z*VRR0(19,18)
      V(189)=ExZpE*r1x2Z*VRR1(19,18)
      V(190)=r1x2Z*VRR0(19,19)
      V(191)=ExZpE*r1x2Z*VRR1(19,19)
      V(192)=HfxZpE*VRR1(32,10)
      V(193)=HfxZpE*VRR1(33,5)
      V(194)=HfxZpE*VRR1(34,5)
      V(195)=HfxZpE*VRR1(33,7)
      V(196)=HfxZpE*VRR1(34,7)
      VRR0(36,11)=4.D0*r1x2Z*VRR0(11,11)+PAx*VRR0(21,11)-4.D0*ExZpE*r1x2Z*VRR1(11,11)+3.D0*HfxZpE*VRR1(21,5)+WPx*VRR1(21,11)
      VRR0(36,12)=4.D0*r1x2Z*VRR0(11,12)+PAx*VRR0(21,12)-4.D0*ExZpE*r1x2Z*VRR1(11,12)+2.D0*HfxZpE*VRR1(21,6)+WPx*VRR1(21,12)
      VRR0(36,13)=4.D0*r1x2Z*VRR0(11,13)+PAx*VRR0(21,13)-4.D0*ExZpE*r1x2Z*VRR1(11,13)+HfxZpE*VRR1(21,7)+WPx*VRR1(21,13)
      VRR0(36,14)=4.D0*r1x2Z*VRR0(11,14)+PAx*VRR0(21,14)-4.D0*ExZpE*r1x2Z*VRR1(11,14)+WPx*VRR1(21,14)
      VRR0(36,15)=4.D0*r1x2Z*VRR0(11,15)+PAx*VRR0(21,15)-4.D0*ExZpE*r1x2Z*VRR1(11,15)+2.D0*HfxZpE*VRR1(21,8)+WPx*VRR1(21,15)
      VRR0(36,16)=4.D0*r1x2Z*VRR0(11,16)+PAx*VRR0(21,16)-4.D0*ExZpE*r1x2Z*VRR1(11,16)+HfxZpE*VRR1(21,9)+WPx*VRR1(21,16)
      VRR0(36,17)=4.D0*r1x2Z*VRR0(11,17)+PAx*VRR0(21,17)-4.D0*ExZpE*r1x2Z*VRR1(11,17)+WPx*VRR1(21,17)
      VRR0(36,18)=4.D0*r1x2Z*VRR0(11,18)+PAx*VRR0(21,18)-4.D0*ExZpE*r1x2Z*VRR1(11,18)+HfxZpE*VRR1(21,10)+WPx*VRR1(21,18)
      VRR0(36,19)=4.D0*r1x2Z*VRR0(11,19)+PAx*VRR0(21,19)-4.D0*ExZpE*r1x2Z*VRR1(11,19)+WPx*VRR1(21,19)
      VRR0(36,20)=4.D0*r1x2Z*VRR0(11,20)+PAx*VRR0(21,20)-4.D0*ExZpE*r1x2Z*VRR1(11,20)+WPx*VRR1(21,20)
      VRR0(37,11)=3.D0*r1x2Z*VRR0(12,11)+PAx*VRR0(22,11)-3.D0*ExZpE*r1x2Z*VRR1(12,11)+3.D0*HfxZpE*VRR1(22,5)+WPx*VRR1(22,11)
      VRR0(37,12)=3.D0*V(1)-3.D0*V(2)+PAx*VRR0(22,12)+2.D0*HfxZpE*VRR1(22,6)+WPx*VRR1(22,12)
      VRR0(37,13)=3.D0*V(3)-3.D0*V(4)+V(5)+PAx*VRR0(22,13)+WPx*VRR1(22,13)
      VRR0(37,14)=3.D0*r1x2Z*VRR0(12,14)+PAx*VRR0(22,14)-3.D0*ExZpE*r1x2Z*VRR1(12,14)+WPx*VRR1(22,14)
      VRR0(37,15)=3.D0*V(6)-3.D0*V(7)+PAx*VRR0(22,15)+2.D0*HfxZpE*VRR1(22,8)+WPx*VRR1(22,15)
      VRR0(37,16)=3.D0*V(8)-3.D0*V(9)+PAx*VRR0(22,16)+HfxZpE*VRR1(22,9)+WPx*VRR1(22,16)
      VRR0(37,17)=3.D0*V(10)-3.D0*V(11)+PAx*VRR0(22,17)+WPx*VRR1(22,17)
      VRR0(37,18)=3.D0*V(12)-3.D0*V(13)+V(14)+PAx*VRR0(22,18)+WPx*VRR1(22,18)
      VRR0(37,19)=3.D0*V(15)-3.D0*V(16)+PAx*VRR0(22,19)+WPx*VRR1(22,19)
      VRR0(37,20)=3.D0*r1x2Z*VRR0(12,20)+PAx*VRR0(22,20)-3.D0*ExZpE*r1x2Z*VRR1(12,20)+WPx*VRR1(22,20)
      VRR0(38,11)=3.D0*V(17)+2.D0*r1x2E*VRR0(38,2)+QCx*VRR0(38,5)-2.D0*r1x2E*ZxZpE*VRR1(38,2)+WQx*VRR1(38,5)
      VRR0(38,12)=2.D0*V(18)-2.D0*V(19)+V(21)+PAx*VRR0(23,12)+WPx*VRR1(23,12)
      VRR0(38,13)=2.D0*V(22)-2.D0*V(23)+V(24)+PAx*VRR0(23,13)+WPx*VRR1(23,13)
      VRR0(38,14)=2.D0*V(5)+2.D0*r1x2E*VRR0(38,3)+QCy*VRR0(38,7)-2.D0*r1x2E*ZxZpE*VRR1(38,3)+WQy*VRR1(38,7)
      VRR0(38,15)=2.D0*V(25)-2.D0*V(26)+2.D0*V(27)+PAx*VRR0(23,15)+WPx*VRR1(23,15)
      VRR0(38,16)=2.D0*V(28)-2.D0*V(29)+V(30)+PAx*VRR0(23,16)+WPx*VRR1(23,16)
      VRR0(38,17)=2.D0*V(31)-2.D0*V(32)+PAx*VRR0(23,17)+WPx*VRR1(23,17)
      VRR0(38,18)=2.D0*V(33)-2.D0*V(34)+V(35)+PAx*VRR0(23,18)+WPx*VRR1(23,18)
      VRR0(38,19)=2.D0*V(36)-2.D0*V(37)+PAx*VRR0(23,19)+WPx*VRR1(23,19)
      VRR0(38,20)=2.D0*r1x2E*VRR0(38,4)+QCz*VRR0(38,10)-2.D0*r1x2E*ZxZpE*VRR1(38,4)+WQz*VRR1(38,10)
      VRR0(39,11)=2.D0*V(38)+2.D0*r1x2E*VRR0(39,2)+QCx*VRR0(39,5)-2.D0*r1x2E*ZxZpE*VRR1(39,2)+WQx*VRR1(39,5)
      VRR0(39,12)=2.D0*V(1)-2.D0*V(2)+V(17)+PAy*VRR0(23,12)+WPy*VRR1(23,12)
      VRR0(39,13)=2.D0*V(3)-2.D0*V(4)+V(21)+PAy*VRR0(23,13)+WPy*VRR1(23,13)
      VRR0(39,14)=3.D0*V(24)+2.D0*r1x2E*VRR0(39,3)+QCy*VRR0(39,7)-2.D0*r1x2E*ZxZpE*VRR1(39,3)+WQy*VRR1(39,7)
      VRR0(39,15)=2.D0*V(6)-2.D0*V(7)+PAy*VRR0(23,15)+WPy*VRR1(23,15)
      VRR0(39,16)=2.D0*V(8)-2.D0*V(9)+V(27)+PAy*VRR0(23,16)+WPy*VRR1(23,16)
      VRR0(39,17)=2.D0*V(10)-2.D0*V(11)+2.D0*V(30)+PAy*VRR0(23,17)+WPy*VRR1(23,17)
      VRR0(39,18)=2.D0*V(12)-2.D0*V(13)+PAy*VRR0(23,18)+WPy*VRR1(23,18)
      VRR0(39,19)=2.D0*V(15)-2.D0*V(16)+V(35)+PAy*VRR0(23,19)+WPy*VRR1(23,19)
      VRR0(39,20)=2.D0*r1x2E*VRR0(39,4)+QCz*VRR0(39,10)-2.D0*r1x2E*ZxZpE*VRR1(39,4)+WQz*VRR1(39,10)
      VRR0(40,11)=3.D0*r1x2Z*VRR0(13,11)+PAy*VRR0(24,11)-3.D0*ExZpE*r1x2Z*VRR1(13,11)+WPy*VRR1(24,11)
      VRR0(40,12)=3.D0*V(18)-3.D0*V(19)+V(38)+PAy*VRR0(24,12)+WPy*VRR1(24,12)
      VRR0(40,13)=3.D0*V(22)-3.D0*V(23)+PAy*VRR0(24,13)+2.D0*HfxZpE*VRR1(24,6)+WPy*VRR1(24,13)
      VRR0(40,14)=3.D0*r1x2Z*VRR0(13,14)+PAy*VRR0(24,14)-3.D0*ExZpE*r1x2Z*VRR1(13,14)+3.D0*HfxZpE*VRR1(24,7)+WPy*VRR1(24,14)
      VRR0(40,15)=3.D0*V(25)-3.D0*V(26)+PAy*VRR0(24,15)+WPy*VRR1(24,15)
      VRR0(40,16)=3.D0*V(28)-3.D0*V(29)+PAy*VRR0(24,16)+HfxZpE*VRR1(24,8)+WPy*VRR1(24,16)
      VRR0(40,17)=3.D0*V(31)-3.D0*V(32)+PAy*VRR0(24,17)+2.D0*HfxZpE*VRR1(24,9)+WPy*VRR1(24,17)
      VRR0(40,18)=3.D0*V(33)-3.D0*V(34)+PAy*VRR0(24,18)+WPy*VRR1(24,18)
      VRR0(40,19)=3.D0*V(36)-3.D0*V(37)+V(39)+PAy*VRR0(24,19)+WPy*VRR1(24,19)
      VRR0(40,20)=3.D0*r1x2Z*VRR0(13,20)+PAy*VRR0(24,20)-3.D0*ExZpE*r1x2Z*VRR1(13,20)+WPy*VRR1(24,20)
      VRR0(41,11)=4.D0*r1x2Z*VRR0(14,11)+PAy*VRR0(25,11)-4.D0*ExZpE*r1x2Z*VRR1(14,11)+WPy*VRR1(25,11)
      VRR0(41,12)=4.D0*r1x2Z*VRR0(14,12)+PAy*VRR0(25,12)-4.D0*ExZpE*r1x2Z*VRR1(14,12)+HfxZpE*VRR1(25,5)+WPy*VRR1(25,12)
      VRR0(41,13)=4.D0*r1x2Z*VRR0(14,13)+PAy*VRR0(25,13)-4.D0*ExZpE*r1x2Z*VRR1(14,13)+2.D0*HfxZpE*VRR1(25,6)+WPy*VRR1(25,13)
      VRR0(41,14)=4.D0*r1x2Z*VRR0(14,14)+PAy*VRR0(25,14)-4.D0*ExZpE*r1x2Z*VRR1(14,14)+3.D0*HfxZpE*VRR1(25,7)+WPy*VRR1(25,14)
      VRR0(41,15)=4.D0*r1x2Z*VRR0(14,15)+PAy*VRR0(25,15)-4.D0*ExZpE*r1x2Z*VRR1(14,15)+WPy*VRR1(25,15)
      VRR0(41,16)=4.D0*r1x2Z*VRR0(14,16)+PAy*VRR0(25,16)-4.D0*ExZpE*r1x2Z*VRR1(14,16)+HfxZpE*VRR1(25,8)+WPy*VRR1(25,16)
      VRR0(41,17)=4.D0*r1x2Z*VRR0(14,17)+PAy*VRR0(25,17)-4.D0*ExZpE*r1x2Z*VRR1(14,17)+2.D0*HfxZpE*VRR1(25,9)+WPy*VRR1(25,17)
      VRR0(41,18)=4.D0*r1x2Z*VRR0(14,18)+PAy*VRR0(25,18)-4.D0*ExZpE*r1x2Z*VRR1(14,18)+WPy*VRR1(25,18)
      VRR0(41,19)=4.D0*r1x2Z*VRR0(14,19)+PAy*VRR0(25,19)-4.D0*ExZpE*r1x2Z*VRR1(14,19)+HfxZpE*VRR1(25,10)+WPy*VRR1(25,19)
      VRR0(41,20)=4.D0*r1x2Z*VRR0(14,20)+PAy*VRR0(25,20)-4.D0*ExZpE*r1x2Z*VRR1(14,20)+WPy*VRR1(25,20)
      VRR0(42,11)=3.D0*r1x2Z*VRR0(15,11)+PAx*VRR0(26,11)-3.D0*ExZpE*r1x2Z*VRR1(15,11)+3.D0*HfxZpE*VRR1(26,5)+WPx*VRR1(26,11)
      VRR0(42,12)=3.D0*V(40)-3.D0*V(41)+PAx*VRR0(26,12)+2.D0*HfxZpE*VRR1(26,6)+WPx*VRR1(26,12)
      VRR0(42,13)=3.D0*V(42)-3.D0*V(43)+V(44)+PAx*VRR0(26,13)+WPx*VRR1(26,13)
      VRR0(42,14)=3.D0*r1x2Z*VRR0(15,14)+PAx*VRR0(26,14)-3.D0*ExZpE*r1x2Z*VRR1(15,14)+WPx*VRR1(26,14)
      VRR0(42,15)=3.D0*V(45)-3.D0*V(46)+PAx*VRR0(26,15)+2.D0*HfxZpE*VRR1(26,8)+WPx*VRR1(26,15)
      VRR0(42,16)=3.D0*V(47)-3.D0*V(48)+PAx*VRR0(26,16)+HfxZpE*VRR1(26,9)+WPx*VRR1(26,16)
      VRR0(42,17)=3.D0*V(49)-3.D0*V(50)+PAx*VRR0(26,17)+WPx*VRR1(26,17)
      VRR0(42,18)=3.D0*V(51)-3.D0*V(52)+V(53)+PAx*VRR0(26,18)+WPx*VRR1(26,18)
      VRR0(42,19)=3.D0*V(54)-3.D0*V(55)+PAx*VRR0(26,19)+WPx*VRR1(26,19)
      VRR0(42,20)=3.D0*r1x2Z*VRR0(15,20)+PAx*VRR0(26,20)-3.D0*ExZpE*r1x2Z*VRR1(15,20)+WPx*VRR1(26,20)
      VRR0(43,11)=2.D0*r1x2E*VRR0(43,2)+QCx*VRR0(43,5)+3.D0*HfxZpE*VRR1(27,5)-2.D0*r1x2E*ZxZpE*VRR1(43,2)+WQx*VRR1(43,5)
      VRR0(43,12)=V(57)+V(59)+V(61)+PAx*VRR0(27,12)+WPx*VRR1(27,12)
      VRR0(43,13)=V(63)+V(65)+V(66)+PAx*VRR0(27,13)+WPx*VRR1(27,13)
      VRR0(43,14)=V(44)+2.D0*r1x2E*VRR0(43,3)+QCy*VRR0(43,7)-2.D0*r1x2E*ZxZpE*VRR1(43,3)+WQy*VRR1(43,7)
      VRR0(43,15)=V(68)+V(70)+V(72)+PAx*VRR0(27,15)+WPx*VRR1(27,15)
      VRR0(43,16)=V(74)+V(76)+V(77)+PAx*VRR0(27,16)+WPx*VRR1(27,16)
      VRR0(43,17)=V(79)+V(81)+PAx*VRR0(27,17)+WPx*VRR1(27,17)
      VRR0(43,18)=V(83)+V(85)+V(86)+PAx*VRR0(27,18)+WPx*VRR1(27,18)
      VRR0(43,19)=V(88)+V(90)+PAx*VRR0(27,19)+WPx*VRR1(27,19)
      VRR0(43,20)=V(14)+2.D0*r1x2E*VRR0(43,4)+QCz*VRR0(43,10)-2.D0*r1x2E*ZxZpE*VRR1(43,4)+WQz*VRR1(43,10)
      VRR0(44,11)=2.D0*V(91)+2.D0*V(92)-2.D0*V(93)+QCx*VRR0(44,5)+WQx*VRR1(44,5)
      VRR0(44,12)=V(94)+V(96)+V(98)+QCx*VRR0(44,6)+WQx*VRR1(44,6)
      VRR0(44,13)=V(61)+V(91)+V(99)+QCy*VRR0(44,6)+WQy*VRR1(44,6)
      VRR0(44,14)=2.D0*V(66)+2.D0*V(94)-2.D0*V(97)+QCy*VRR0(44,7)+WQy*VRR1(44,7)
      VRR0(44,15)=V(100)+V(102)+V(104)+QCx*VRR0(44,8)+WQx*VRR1(44,8)
      VRR0(44,16)=V(105)-V(106)+V(107)+PAx*VRR0(28,16)+WPx*VRR1(28,16)
      VRR0(44,17)=V(100)+V(104)+V(108)+QCy*VRR0(44,9)+WQy*VRR1(44,9)
      VRR0(44,18)=V(27)+V(91)+V(99)+QCz*VRR0(44,8)+WQz*VRR1(44,8)
      VRR0(44,19)=V(30)+V(94)+V(98)+QCz*VRR0(44,9)+WQz*VRR1(44,9)
      VRR0(44,20)=V(35)+2.D0*V(100)-2.D0*V(103)+QCz*VRR0(44,10)+WQz*VRR1(44,10)
      VRR0(45,11)=V(109)+2.D0*r1x2E*VRR0(45,2)+QCx*VRR0(45,5)-2.D0*r1x2E*ZxZpE*VRR1(45,2)+WQx*VRR1(45,5)
      VRR0(45,12)=V(57)+V(59)+V(92)+PAy*VRR0(28,12)+WPy*VRR1(28,12)
      VRR0(45,13)=V(63)+V(65)+V(96)+PAy*VRR0(28,13)+WPy*VRR1(28,13)
      VRR0(45,14)=2.D0*r1x2E*VRR0(45,3)+QCy*VRR0(45,7)+3.D0*HfxZpE*VRR1(28,7)-2.D0*r1x2E*ZxZpE*VRR1(45,3)+WQy*VRR1(45,7)
      VRR0(45,15)=V(68)+V(70)+PAy*VRR0(28,15)+WPy*VRR1(28,15)
      VRR0(45,16)=V(74)+V(76)+V(101)+PAy*VRR0(28,16)+WPy*VRR1(28,16)
      VRR0(45,17)=V(79)+V(81)+V(110)+PAy*VRR0(28,17)+WPy*VRR1(28,17)
      VRR0(45,18)=V(83)+V(85)+PAy*VRR0(28,18)+WPy*VRR1(28,18)
      VRR0(45,19)=V(88)+V(90)+V(111)+PAy*VRR0(28,19)+WPy*VRR1(28,19)
      VRR0(45,20)=V(39)+2.D0*r1x2E*VRR0(45,4)+QCz*VRR0(45,10)-2.D0*r1x2E*ZxZpE*VRR1(45,4)+WQz*VRR1(45,10)
      VRR0(46,11)=3.D0*r1x2Z*VRR0(17,11)+PAy*VRR0(29,11)-3.D0*ExZpE*r1x2Z*VRR1(17,11)+WPy*VRR1(29,11)
      VRR0(46,12)=V(109)+3.D0*V(112)-3.D0*V(113)+PAy*VRR0(29,12)+WPy*VRR1(29,12)
      VRR0(46,13)=3.D0*V(114)-3.D0*V(115)+PAy*VRR0(29,13)+2.D0*HfxZpE*VRR1(29,6)+WPy*VRR1(29,13)
      VRR0(46,14)=3.D0*r1x2Z*VRR0(17,14)+PAy*VRR0(29,14)-3.D0*ExZpE*r1x2Z*VRR1(17,14)+3.D0*HfxZpE*VRR1(29,7)+WPy*VRR1(29,14)
      VRR0(46,15)=3.D0*V(116)-3.D0*V(117)+PAy*VRR0(29,15)+WPy*VRR1(29,15)
      VRR0(46,16)=3.D0*V(105)-3.D0*V(106)+PAy*VRR0(29,16)+HfxZpE*VRR1(29,8)+WPy*VRR1(29,16)
      VRR0(46,17)=3.D0*V(118)-3.D0*V(119)+PAy*VRR0(29,17)+2.D0*HfxZpE*VRR1(29,9)+WPy*VRR1(29,17)
      VRR0(46,18)=3.D0*V(120)-3.D0*V(121)+PAy*VRR0(29,18)+WPy*VRR1(29,18)
      VRR0(46,19)=3.D0*V(122)-3.D0*V(123)+V(124)+PAy*VRR0(29,19)+WPy*VRR1(29,19)
      VRR0(46,20)=3.D0*r1x2Z*VRR0(17,20)+PAy*VRR0(29,20)-3.D0*ExZpE*r1x2Z*VRR1(17,20)+WPy*VRR1(29,20)
      VRR0(47,11)=3.D0*V(125)+2.D0*r1x2E*VRR0(47,2)+QCx*VRR0(47,5)-2.D0*r1x2E*ZxZpE*VRR1(47,2)+WQx*VRR1(47,5)
      VRR0(47,12)=2.D0*V(126)-2.D0*V(127)+2.D0*V(128)+PAx*VRR0(30,12)+WPx*VRR1(30,12)
      VRR0(47,13)=2.D0*V(129)-2.D0*V(130)+V(131)+PAx*VRR0(30,13)+WPx*VRR1(30,13)
      VRR0(47,14)=2.D0*r1x2E*VRR0(47,3)+QCy*VRR0(47,7)-2.D0*r1x2E*ZxZpE*VRR1(47,3)+WQy*VRR1(47,7)
      VRR0(47,15)=2.D0*V(132)-2.D0*V(133)+V(135)+PAx*VRR0(30,15)+WPx*VRR1(30,15)
      VRR0(47,16)=2.D0*V(136)-2.D0*V(137)+V(138)+PAx*VRR0(30,16)+WPx*VRR1(30,16)
      VRR0(47,17)=2.D0*V(139)-2.D0*V(140)+PAx*VRR0(30,17)+WPx*VRR1(30,17)
      VRR0(47,18)=2.D0*V(141)-2.D0*V(142)+V(143)+PAx*VRR0(30,18)+WPx*VRR1(30,18)
      VRR0(47,19)=2.D0*V(144)-2.D0*V(145)+PAx*VRR0(30,19)+WPx*VRR1(30,19)
      VRR0(47,20)=2.D0*V(53)+2.D0*r1x2E*VRR0(47,4)+QCz*VRR0(47,10)-2.D0*r1x2E*ZxZpE*VRR1(47,4)+WQz*VRR1(47,10)
      VRR0(48,11)=2.D0*V(146)+2.D0*V(147)-2.D0*V(148)+QCx*VRR0(48,5)+WQx*VRR1(48,5)
      VRR0(48,12)=V(149)+V(151)+V(153)+QCx*VRR0(48,6)+WQx*VRR1(48,6)
      VRR0(48,13)=V(128)+V(146)+V(154)+QCy*VRR0(48,6)+WQy*VRR1(48,6)
      VRR0(48,14)=V(131)+2.D0*V(149)-2.D0*V(152)+QCy*VRR0(48,7)+WQy*VRR1(48,7)
      VRR0(48,15)=V(155)+V(157)+V(159)+QCx*VRR0(48,8)+WQx*VRR1(48,8)
      VRR0(48,16)=V(160)-V(161)+V(162)+PAx*VRR0(31,16)+WPx*VRR1(31,16)
      VRR0(48,17)=V(138)+V(155)+V(159)+QCy*VRR0(48,9)+WQy*VRR1(48,9)
      VRR0(48,18)=V(72)+V(146)+V(154)+QCz*VRR0(48,8)+WQz*VRR1(48,8)
      VRR0(48,19)=V(108)+V(149)+V(153)+QCz*VRR0(48,9)+WQz*VRR1(48,9)
      VRR0(48,20)=2.D0*V(86)+2.D0*V(155)-2.D0*V(158)+QCz*VRR0(48,10)+WQz*VRR1(48,10)
      VRR0(49,11)=2.D0*V(163)+V(164)-2.D0*V(165)+QCx*VRR0(49,5)+WQx*VRR1(49,5)
      VRR0(49,12)=V(166)+V(167)+V(169)+QCx*VRR0(49,6)+WQx*VRR1(49,6)
      VRR0(49,13)=V(151)+V(163)+V(170)+QCy*VRR0(49,6)+WQy*VRR1(49,6)
      VRR0(49,14)=2.D0*V(166)-2.D0*V(168)+2.D0*V(171)+QCy*VRR0(49,7)+WQy*VRR1(49,7)
      VRR0(49,15)=V(172)+V(173)+V(175)+QCx*VRR0(49,8)+WQx*VRR1(49,8)
      VRR0(49,16)=V(136)-V(137)+V(156)+PAy*VRR0(31,16)+WPy*VRR1(31,16)
      VRR0(49,17)=V(172)+V(175)+V(176)+QCy*VRR0(49,9)+WQy*VRR1(49,9)
      VRR0(49,18)=V(102)+V(163)+V(170)+QCz*VRR0(49,8)+WQz*VRR1(49,8)
      VRR0(49,19)=V(110)+V(166)+V(169)+QCz*VRR0(49,9)+WQz*VRR1(49,9)
      VRR0(49,20)=2.D0*V(111)+2.D0*V(172)-2.D0*V(174)+QCz*VRR0(49,10)+WQz*VRR1(49,10)
      VRR0(50,11)=2.D0*r1x2E*VRR0(50,2)+QCx*VRR0(50,5)-2.D0*r1x2E*ZxZpE*VRR1(50,2)+WQx*VRR1(50,5)
      VRR0(50,12)=V(164)+2.D0*V(177)-2.D0*V(178)+PAy*VRR0(32,12)+WPy*VRR1(32,12)
      VRR0(50,13)=2.D0*V(167)+2.D0*V(179)-2.D0*V(180)+PAy*VRR0(32,13)+WPy*VRR1(32,13)
      VRR0(50,14)=3.D0*V(181)+2.D0*r1x2E*VRR0(50,3)+QCy*VRR0(50,7)-2.D0*r1x2E*ZxZpE*VRR1(50,3)+WQy*VRR1(50,7)
      VRR0(50,15)=2.D0*V(182)-2.D0*V(183)+PAy*VRR0(32,15)+WPy*VRR1(32,15)
      VRR0(50,16)=2.D0*V(160)-2.D0*V(161)+V(173)+PAy*VRR0(32,16)+WPy*VRR1(32,16)
      VRR0(50,17)=2.D0*V(184)-2.D0*V(185)+V(187)+PAy*VRR0(32,17)+WPy*VRR1(32,17)
      VRR0(50,18)=2.D0*V(188)-2.D0*V(189)+PAy*VRR0(32,18)+WPy*VRR1(32,18)
      VRR0(50,19)=2.D0*V(190)-2.D0*V(191)+V(192)+PAy*VRR0(32,19)+WPy*VRR1(32,19)
      VRR0(50,20)=2.D0*V(124)+2.D0*r1x2E*VRR0(50,4)+QCz*VRR0(50,10)-2.D0*r1x2E*ZxZpE*VRR1(50,4)+WQz*VRR1(50,10)
      VRR0(51,11)=2.D0*V(193)+2.D0*r1x2E*VRR0(51,2)+QCx*VRR0(51,5)-2.D0*r1x2E*ZxZpE*VRR1(51,2)+WQx*VRR1(51,5)
      VRR0(51,12)=2.D0*V(40)-2.D0*V(41)+PAz*VRR0(30,12)+WPz*VRR1(30,12)
      VRR0(51,13)=2.D0*V(42)-2.D0*V(43)+PAz*VRR0(30,13)+WPz*VRR1(30,13)
      VRR0(51,14)=2.D0*r1x2E*VRR0(51,3)+QCy*VRR0(51,7)-2.D0*r1x2E*ZxZpE*VRR1(51,3)+WQy*VRR1(51,7)
      VRR0(51,15)=2.D0*V(45)-2.D0*V(46)+V(125)+PAz*VRR0(30,15)+WPz*VRR1(30,15)
      VRR0(51,16)=2.D0*V(47)-2.D0*V(48)+V(128)+PAz*VRR0(30,16)+WPz*VRR1(30,16)
      VRR0(51,17)=2.D0*V(49)-2.D0*V(50)+V(131)+PAz*VRR0(30,17)+WPz*VRR1(30,17)
      VRR0(51,18)=2.D0*V(51)-2.D0*V(52)+V(135)+PAz*VRR0(30,18)+WPz*VRR1(30,18)
      VRR0(51,19)=2.D0*V(54)-2.D0*V(55)+2.D0*V(138)+PAz*VRR0(30,19)+WPz*VRR1(30,19)
      VRR0(51,20)=3.D0*V(143)+2.D0*r1x2E*VRR0(51,4)+QCz*VRR0(51,10)-2.D0*r1x2E*ZxZpE*VRR1(51,4)+WQz*VRR1(51,10)
      VRR0(52,11)=V(194)+2.D0*r1x2E*VRR0(52,2)+QCx*VRR0(52,5)-2.D0*r1x2E*ZxZpE*VRR1(52,2)+WQx*VRR1(52,5)
      VRR0(52,12)=V(57)+V(59)+PAz*VRR0(31,12)+WPz*VRR1(31,12)
      VRR0(52,13)=V(63)+V(65)+PAz*VRR0(31,13)+WPz*VRR1(31,13)
      VRR0(52,14)=V(195)+2.D0*r1x2E*VRR0(52,3)+QCy*VRR0(52,7)-2.D0*r1x2E*ZxZpE*VRR1(52,3)+WQy*VRR1(52,7)
      VRR0(52,15)=V(68)+V(70)+V(147)+PAz*VRR0(31,15)+WPz*VRR1(31,15)
      VRR0(52,16)=V(74)+V(76)+V(150)+PAz*VRR0(31,16)+WPz*VRR1(31,16)
      VRR0(52,17)=V(79)+V(81)+V(171)+PAz*VRR0(31,17)+WPz*VRR1(31,17)
      VRR0(52,18)=V(83)+V(85)+V(157)+PAz*VRR0(31,18)+WPz*VRR1(31,18)
      VRR0(52,19)=V(88)+V(90)+V(176)+PAz*VRR0(31,19)+WPz*VRR1(31,19)
      VRR0(52,20)=2.D0*r1x2E*VRR0(52,4)+QCz*VRR0(52,10)+3.D0*HfxZpE*VRR1(31,10)-2.D0*r1x2E*ZxZpE*VRR1(52,4)+WQz*VRR1(52,10)
      VRR0(53,11)=2.D0*r1x2E*VRR0(53,2)+QCx*VRR0(53,5)-2.D0*r1x2E*ZxZpE*VRR1(53,2)+WQx*VRR1(53,5)
      VRR0(53,12)=2.D0*V(112)-2.D0*V(113)+PAz*VRR0(32,12)+WPz*VRR1(32,12)
      VRR0(53,13)=2.D0*V(114)-2.D0*V(115)+PAz*VRR0(32,13)+WPz*VRR1(32,13)
      VRR0(53,14)=2.D0*V(196)+2.D0*r1x2E*VRR0(53,3)+QCy*VRR0(53,7)-2.D0*r1x2E*ZxZpE*VRR1(53,3)+WQy*VRR1(53,7)
      VRR0(53,15)=2.D0*V(116)-2.D0*V(117)+V(164)+PAz*VRR0(32,15)+WPz*VRR1(32,15)
      VRR0(53,16)=2.D0*V(105)-2.D0*V(106)+V(167)+PAz*VRR0(32,16)+WPz*VRR1(32,16)
      VRR0(53,17)=2.D0*V(118)-2.D0*V(119)+V(181)+PAz*VRR0(32,17)+WPz*VRR1(32,17)
      VRR0(53,18)=2.D0*V(120)-2.D0*V(121)+2.D0*V(173)+PAz*VRR0(32,18)+WPz*VRR1(32,18)
      VRR0(53,19)=2.D0*V(122)-2.D0*V(123)+V(187)+PAz*VRR0(32,19)+WPz*VRR1(32,19)
      VRR0(53,20)=3.D0*V(192)+2.D0*r1x2E*VRR0(53,4)+QCz*VRR0(53,10)-2.D0*r1x2E*ZxZpE*VRR1(53,4)+WQz*VRR1(53,10)
      VRR0(54,11)=3.D0*r1x2Z*VRR0(18,11)+PAz*VRR0(33,11)-3.D0*ExZpE*r1x2Z*VRR1(18,11)+WPz*VRR1(33,11)
      VRR0(54,12)=3.D0*V(126)-3.D0*V(127)+PAz*VRR0(33,12)+WPz*VRR1(33,12)
      VRR0(54,13)=3.D0*V(129)-3.D0*V(130)+PAz*VRR0(33,13)+WPz*VRR1(33,13)
      VRR0(54,14)=3.D0*r1x2Z*VRR0(18,14)+PAz*VRR0(33,14)-3.D0*ExZpE*r1x2Z*VRR1(18,14)+WPz*VRR1(33,14)
      VRR0(54,15)=3.D0*V(132)-3.D0*V(133)+V(193)+PAz*VRR0(33,15)+WPz*VRR1(33,15)
      VRR0(54,16)=3.D0*V(136)-3.D0*V(137)+PAz*VRR0(33,16)+HfxZpE*VRR1(33,6)+WPz*VRR1(33,16)
      VRR0(54,17)=3.D0*V(139)-3.D0*V(140)+V(195)+PAz*VRR0(33,17)+WPz*VRR1(33,17)
      VRR0(54,18)=3.D0*V(141)-3.D0*V(142)+PAz*VRR0(33,18)+2.D0*HfxZpE*VRR1(33,8)+WPz*VRR1(33,18)
      VRR0(54,19)=3.D0*V(144)-3.D0*V(145)+PAz*VRR0(33,19)+2.D0*HfxZpE*VRR1(33,9)+WPz*VRR1(33,19)
      VRR0(54,20)=3.D0*r1x2Z*VRR0(18,20)+PAz*VRR0(33,20)-3.D0*ExZpE*r1x2Z*VRR1(18,20)+3.D0*HfxZpE*VRR1(33,10)+WPz*VRR1(33,20)
      VRR0(55,11)=3.D0*r1x2Z*VRR0(19,11)+PAz*VRR0(34,11)-3.D0*ExZpE*r1x2Z*VRR1(19,11)+WPz*VRR1(34,11)
      VRR0(55,12)=3.D0*V(177)-3.D0*V(178)+PAz*VRR0(34,12)+WPz*VRR1(34,12)
      VRR0(55,13)=3.D0*V(179)-3.D0*V(180)+PAz*VRR0(34,13)+WPz*VRR1(34,13)
      VRR0(55,14)=3.D0*r1x2Z*VRR0(19,14)+PAz*VRR0(34,14)-3.D0*ExZpE*r1x2Z*VRR1(19,14)+WPz*VRR1(34,14)
      VRR0(55,15)=3.D0*V(182)-3.D0*V(183)+V(194)+PAz*VRR0(34,15)+WPz*VRR1(34,15)
      VRR0(55,16)=3.D0*V(160)-3.D0*V(161)+PAz*VRR0(34,16)+HfxZpE*VRR1(34,6)+WPz*VRR1(34,16)
      VRR0(55,17)=3.D0*V(184)-3.D0*V(185)+V(196)+PAz*VRR0(34,17)+WPz*VRR1(34,17)
      VRR0(55,18)=3.D0*V(188)-3.D0*V(189)+PAz*VRR0(34,18)+2.D0*HfxZpE*VRR1(34,8)+WPz*VRR1(34,18)
      VRR0(55,19)=3.D0*V(190)-3.D0*V(191)+PAz*VRR0(34,19)+2.D0*HfxZpE*VRR1(34,9)+WPz*VRR1(34,19)
      VRR0(55,20)=3.D0*r1x2Z*VRR0(19,20)+PAz*VRR0(34,20)-3.D0*ExZpE*r1x2Z*VRR1(19,20)+3.D0*HfxZpE*VRR1(34,10)+WPz*VRR1(34,20)
      VRR0(56,11)=4.D0*r1x2Z*VRR0(20,11)+PAz*VRR0(35,11)-4.D0*ExZpE*r1x2Z*VRR1(20,11)+WPz*VRR1(35,11)
      VRR0(56,12)=4.D0*r1x2Z*VRR0(20,12)+PAz*VRR0(35,12)-4.D0*ExZpE*r1x2Z*VRR1(20,12)+WPz*VRR1(35,12)
      VRR0(56,13)=4.D0*r1x2Z*VRR0(20,13)+PAz*VRR0(35,13)-4.D0*ExZpE*r1x2Z*VRR1(20,13)+WPz*VRR1(35,13)
      VRR0(56,14)=4.D0*r1x2Z*VRR0(20,14)+PAz*VRR0(35,14)-4.D0*ExZpE*r1x2Z*VRR1(20,14)+WPz*VRR1(35,14)
      VRR0(56,15)=4.D0*r1x2Z*VRR0(20,15)+PAz*VRR0(35,15)-4.D0*ExZpE*r1x2Z*VRR1(20,15)+HfxZpE*VRR1(35,5)+WPz*VRR1(35,15)
      VRR0(56,16)=4.D0*r1x2Z*VRR0(20,16)+PAz*VRR0(35,16)-4.D0*ExZpE*r1x2Z*VRR1(20,16)+HfxZpE*VRR1(35,6)+WPz*VRR1(35,16)
      VRR0(56,17)=4.D0*r1x2Z*VRR0(20,17)+PAz*VRR0(35,17)-4.D0*ExZpE*r1x2Z*VRR1(20,17)+HfxZpE*VRR1(35,7)+WPz*VRR1(35,17)
      VRR0(56,18)=4.D0*r1x2Z*VRR0(20,18)+PAz*VRR0(35,18)-4.D0*ExZpE*r1x2Z*VRR1(20,18)+2.D0*HfxZpE*VRR1(35,8)+WPz*VRR1(35,18)
      VRR0(56,19)=4.D0*r1x2Z*VRR0(20,19)+PAz*VRR0(35,19)-4.D0*ExZpE*r1x2Z*VRR1(20,19)+2.D0*HfxZpE*VRR1(35,9)+WPz*VRR1(35,19)
      VRR0(56,20)=4.D0*r1x2Z*VRR0(20,20)+PAz*VRR0(35,20)-4.D0*ExZpE*r1x2Z*VRR1(20,20)+3.D0*HfxZpE*VRR1(35,10)+WPz*VRR1(35,20)
END SUBROUTINE VRRh0f0
SUBROUTINE MVRRh0f0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(36,11)=PAx*VS0(21,11)+WPx*VS1(21,11)+r1x2Z*VR1(21,11)&
   +4D0*r1x2Z*(VS0(11,11)-ExZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(21,5)
VS0(36,12)=PAx*VS0(21,12)+WPx*VS1(21,12)+r1x2Z*VR1(21,12)&
   +4D0*r1x2Z*(VS0(11,12)-ExZpE*VS1(11,12))&
   +2D0*HfxZpE*VS1(21,6)
VS0(36,13)=PAx*VS0(21,13)+WPx*VS1(21,13)+r1x2Z*VR1(21,13)&
   +4D0*r1x2Z*(VS0(11,13)-ExZpE*VS1(11,13))&
   +HfxZpE*VS1(21,7)
VS0(36,14)=PAx*VS0(21,14)+WPx*VS1(21,14)+r1x2Z*VR1(21,14)&
   +4D0*r1x2Z*(VS0(11,14)-ExZpE*VS1(11,14))
VS0(36,15)=PAx*VS0(21,15)+WPx*VS1(21,15)+r1x2Z*VR1(21,15)&
   +4D0*r1x2Z*(VS0(11,15)-ExZpE*VS1(11,15))&
   +2D0*HfxZpE*VS1(21,8)
VS0(36,16)=PAx*VS0(21,16)+WPx*VS1(21,16)+r1x2Z*VR1(21,16)&
   +4D0*r1x2Z*(VS0(11,16)-ExZpE*VS1(11,16))&
   +HfxZpE*VS1(21,9)
VS0(36,17)=PAx*VS0(21,17)+WPx*VS1(21,17)+r1x2Z*VR1(21,17)&
   +4D0*r1x2Z*(VS0(11,17)-ExZpE*VS1(11,17))
VS0(36,18)=PAx*VS0(21,18)+WPx*VS1(21,18)+r1x2Z*VR1(21,18)&
   +4D0*r1x2Z*(VS0(11,18)-ExZpE*VS1(11,18))&
   +HfxZpE*VS1(21,10)
VS0(36,19)=PAx*VS0(21,19)+WPx*VS1(21,19)+r1x2Z*VR1(21,19)&
   +4D0*r1x2Z*(VS0(11,19)-ExZpE*VS1(11,19))
VS0(36,20)=PAx*VS0(21,20)+WPx*VS1(21,20)+r1x2Z*VR1(21,20)&
   +4D0*r1x2Z*(VS0(11,20)-ExZpE*VS1(11,20))
VS0(37,11)=PAx*VS0(22,11)+WPx*VS1(22,11)+r1x2Z*VR1(22,11)&
   +3D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))&
   +3D0*HfxZpE*VS1(22,5)
VS0(37,12)=PAx*VS0(22,12)+WPx*VS1(22,12)+r1x2Z*VR1(22,12)&
   +3D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(22,6)
VS0(37,13)=PAx*VS0(22,13)+WPx*VS1(22,13)+r1x2Z*VR1(22,13)&
   +3D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +HfxZpE*VS1(22,7)
VS0(37,14)=PAx*VS0(22,14)+WPx*VS1(22,14)+r1x2Z*VR1(22,14)&
   +3D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))
VS0(37,15)=PAx*VS0(22,15)+WPx*VS1(22,15)+r1x2Z*VR1(22,15)&
   +3D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(22,8)
VS0(37,16)=PAx*VS0(22,16)+WPx*VS1(22,16)+r1x2Z*VR1(22,16)&
   +3D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(22,9)
VS0(37,17)=PAx*VS0(22,17)+WPx*VS1(22,17)+r1x2Z*VR1(22,17)&
   +3D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))
VS0(37,18)=PAx*VS0(22,18)+WPx*VS1(22,18)+r1x2Z*VR1(22,18)&
   +3D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))&
   +HfxZpE*VS1(22,10)
VS0(37,19)=PAx*VS0(22,19)+WPx*VS1(22,19)+r1x2Z*VR1(22,19)&
   +3D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))
VS0(37,20)=PAx*VS0(22,20)+WPx*VS1(22,20)+r1x2Z*VR1(22,20)&
   +3D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(38,11)=PAx*VS0(23,11)+WPx*VS1(23,11)+r1x2Z*VR1(23,11)&
   +2D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))&
   +3D0*HfxZpE*VS1(23,5)
VS0(38,12)=PAx*VS0(23,12)+WPx*VS1(23,12)+r1x2Z*VR1(23,12)&
   +2D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(23,6)
VS0(38,13)=PAx*VS0(23,13)+WPx*VS1(23,13)+r1x2Z*VR1(23,13)&
   +2D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +HfxZpE*VS1(23,7)
VS0(38,14)=PAx*VS0(23,14)+WPx*VS1(23,14)+r1x2Z*VR1(23,14)&
   +2D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))
VS0(38,15)=PAx*VS0(23,15)+WPx*VS1(23,15)+r1x2Z*VR1(23,15)&
   +2D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))&
   +2D0*HfxZpE*VS1(23,8)
VS0(38,16)=PAx*VS0(23,16)+WPx*VS1(23,16)+r1x2Z*VR1(23,16)&
   +2D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(23,9)
VS0(38,17)=PAx*VS0(23,17)+WPx*VS1(23,17)+r1x2Z*VR1(23,17)&
   +2D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))
VS0(38,18)=PAx*VS0(23,18)+WPx*VS1(23,18)+r1x2Z*VR1(23,18)&
   +2D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))&
   +HfxZpE*VS1(23,10)
VS0(38,19)=PAx*VS0(23,19)+WPx*VS1(23,19)+r1x2Z*VR1(23,19)&
   +2D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))
VS0(38,20)=PAx*VS0(23,20)+WPx*VS1(23,20)+r1x2Z*VR1(23,20)&
   +2D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(39,11)=PAy*VS0(23,11)+WPy*VS1(23,11)&
   +2D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))
VS0(39,12)=PAy*VS0(23,12)+WPy*VS1(23,12)&
   +2D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +HfxZpE*VS1(23,5)
VS0(39,13)=PAy*VS0(23,13)+WPy*VS1(23,13)&
   +2D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(23,6)
VS0(39,14)=PAy*VS0(23,14)+WPy*VS1(23,14)&
   +2D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))&
   +3D0*HfxZpE*VS1(23,7)
VS0(39,15)=PAy*VS0(23,15)+WPy*VS1(23,15)&
   +2D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))
VS0(39,16)=PAy*VS0(23,16)+WPy*VS1(23,16)&
   +2D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(23,8)
VS0(39,17)=PAy*VS0(23,17)+WPy*VS1(23,17)&
   +2D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(23,9)
VS0(39,18)=PAy*VS0(23,18)+WPy*VS1(23,18)&
   +2D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))
VS0(39,19)=PAy*VS0(23,19)+WPy*VS1(23,19)&
   +2D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))&
   +HfxZpE*VS1(23,10)
VS0(39,20)=PAy*VS0(23,20)+WPy*VS1(23,20)&
   +2D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(40,11)=PAy*VS0(24,11)+WPy*VS1(24,11)&
   +3D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))
VS0(40,12)=PAy*VS0(24,12)+WPy*VS1(24,12)&
   +3D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +HfxZpE*VS1(24,5)
VS0(40,13)=PAy*VS0(24,13)+WPy*VS1(24,13)&
   +3D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(24,6)
VS0(40,14)=PAy*VS0(24,14)+WPy*VS1(24,14)&
   +3D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))&
   +3D0*HfxZpE*VS1(24,7)
VS0(40,15)=PAy*VS0(24,15)+WPy*VS1(24,15)&
   +3D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))
VS0(40,16)=PAy*VS0(24,16)+WPy*VS1(24,16)&
   +3D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(24,8)
VS0(40,17)=PAy*VS0(24,17)+WPy*VS1(24,17)&
   +3D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(24,9)
VS0(40,18)=PAy*VS0(24,18)+WPy*VS1(24,18)&
   +3D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))
VS0(40,19)=PAy*VS0(24,19)+WPy*VS1(24,19)&
   +3D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))&
   +HfxZpE*VS1(24,10)
VS0(40,20)=PAy*VS0(24,20)+WPy*VS1(24,20)&
   +3D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(41,11)=PAy*VS0(25,11)+WPy*VS1(25,11)&
   +4D0*r1x2Z*(VS0(14,11)-ExZpE*VS1(14,11))
VS0(41,12)=PAy*VS0(25,12)+WPy*VS1(25,12)&
   +4D0*r1x2Z*(VS0(14,12)-ExZpE*VS1(14,12))&
   +HfxZpE*VS1(25,5)
VS0(41,13)=PAy*VS0(25,13)+WPy*VS1(25,13)&
   +4D0*r1x2Z*(VS0(14,13)-ExZpE*VS1(14,13))&
   +2D0*HfxZpE*VS1(25,6)
VS0(41,14)=PAy*VS0(25,14)+WPy*VS1(25,14)&
   +4D0*r1x2Z*(VS0(14,14)-ExZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(25,7)
VS0(41,15)=PAy*VS0(25,15)+WPy*VS1(25,15)&
   +4D0*r1x2Z*(VS0(14,15)-ExZpE*VS1(14,15))
VS0(41,16)=PAy*VS0(25,16)+WPy*VS1(25,16)&
   +4D0*r1x2Z*(VS0(14,16)-ExZpE*VS1(14,16))&
   +HfxZpE*VS1(25,8)
VS0(41,17)=PAy*VS0(25,17)+WPy*VS1(25,17)&
   +4D0*r1x2Z*(VS0(14,17)-ExZpE*VS1(14,17))&
   +2D0*HfxZpE*VS1(25,9)
VS0(41,18)=PAy*VS0(25,18)+WPy*VS1(25,18)&
   +4D0*r1x2Z*(VS0(14,18)-ExZpE*VS1(14,18))
VS0(41,19)=PAy*VS0(25,19)+WPy*VS1(25,19)&
   +4D0*r1x2Z*(VS0(14,19)-ExZpE*VS1(14,19))&
   +HfxZpE*VS1(25,10)
VS0(41,20)=PAy*VS0(25,20)+WPy*VS1(25,20)&
   +4D0*r1x2Z*(VS0(14,20)-ExZpE*VS1(14,20))
VS0(42,11)=PAx*VS0(26,11)+WPx*VS1(26,11)+r1x2Z*VR1(26,11)&
   +3D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))&
   +3D0*HfxZpE*VS1(26,5)
VS0(42,12)=PAx*VS0(26,12)+WPx*VS1(26,12)+r1x2Z*VR1(26,12)&
   +3D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(26,6)
VS0(42,13)=PAx*VS0(26,13)+WPx*VS1(26,13)+r1x2Z*VR1(26,13)&
   +3D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))&
   +HfxZpE*VS1(26,7)
VS0(42,14)=PAx*VS0(26,14)+WPx*VS1(26,14)+r1x2Z*VR1(26,14)&
   +3D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(42,15)=PAx*VS0(26,15)+WPx*VS1(26,15)+r1x2Z*VR1(26,15)&
   +3D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(26,8)
VS0(42,16)=PAx*VS0(26,16)+WPx*VS1(26,16)+r1x2Z*VR1(26,16)&
   +3D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(26,9)
VS0(42,17)=PAx*VS0(26,17)+WPx*VS1(26,17)+r1x2Z*VR1(26,17)&
   +3D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))
VS0(42,18)=PAx*VS0(26,18)+WPx*VS1(26,18)+r1x2Z*VR1(26,18)&
   +3D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +HfxZpE*VS1(26,10)
VS0(42,19)=PAx*VS0(26,19)+WPx*VS1(26,19)+r1x2Z*VR1(26,19)&
   +3D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))
VS0(42,20)=PAx*VS0(26,20)+WPx*VS1(26,20)+r1x2Z*VR1(26,20)&
   +3D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))
VS0(43,11)=PAx*VS0(27,11)+WPx*VS1(27,11)+r1x2Z*VR1(27,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))&
   +3D0*HfxZpE*VS1(27,5)
VS0(43,12)=PAx*VS0(27,12)+WPx*VS1(27,12)+r1x2Z*VR1(27,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +2D0*HfxZpE*VS1(27,6)
VS0(43,13)=PAx*VS0(27,13)+WPx*VS1(27,13)+r1x2Z*VR1(27,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +HfxZpE*VS1(27,7)
VS0(43,14)=PAx*VS0(27,14)+WPx*VS1(27,14)+r1x2Z*VR1(27,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(43,15)=PAx*VS0(27,15)+WPx*VS1(27,15)+r1x2Z*VR1(27,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +2D0*HfxZpE*VS1(27,8)
VS0(43,16)=PAx*VS0(27,16)+WPx*VS1(27,16)+r1x2Z*VR1(27,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(27,9)
VS0(43,17)=PAx*VS0(27,17)+WPx*VS1(27,17)+r1x2Z*VR1(27,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))
VS0(43,18)=PAx*VS0(27,18)+WPx*VS1(27,18)+r1x2Z*VR1(27,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +HfxZpE*VS1(27,10)
VS0(43,19)=PAx*VS0(27,19)+WPx*VS1(27,19)+r1x2Z*VR1(27,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))
VS0(43,20)=PAx*VS0(27,20)+WPx*VS1(27,20)+r1x2Z*VR1(27,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(44,11)=PAx*VS0(28,11)+WPx*VS1(28,11)+r1x2Z*VR1(28,11)&
   +r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))&
   +3D0*HfxZpE*VS1(28,5)
VS0(44,12)=PAx*VS0(28,12)+WPx*VS1(28,12)+r1x2Z*VR1(28,12)&
   +r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(28,6)
VS0(44,13)=PAx*VS0(28,13)+WPx*VS1(28,13)+r1x2Z*VR1(28,13)&
   +r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +HfxZpE*VS1(28,7)
VS0(44,14)=PAx*VS0(28,14)+WPx*VS1(28,14)+r1x2Z*VR1(28,14)&
   +r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(44,15)=PAx*VS0(28,15)+WPx*VS1(28,15)+r1x2Z*VR1(28,15)&
   +r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +2D0*HfxZpE*VS1(28,8)
VS0(44,16)=PAx*VS0(28,16)+WPx*VS1(28,16)+r1x2Z*VR1(28,16)&
   +r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(28,9)
VS0(44,17)=PAx*VS0(28,17)+WPx*VS1(28,17)+r1x2Z*VR1(28,17)&
   +r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))
VS0(44,18)=PAx*VS0(28,18)+WPx*VS1(28,18)+r1x2Z*VR1(28,18)&
   +r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +HfxZpE*VS1(28,10)
VS0(44,19)=PAx*VS0(28,19)+WPx*VS1(28,19)+r1x2Z*VR1(28,19)&
   +r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))
VS0(44,20)=PAx*VS0(28,20)+WPx*VS1(28,20)+r1x2Z*VR1(28,20)&
   +r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(45,11)=PAy*VS0(28,11)+WPy*VS1(28,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(45,12)=PAy*VS0(28,12)+WPy*VS1(28,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +HfxZpE*VS1(28,5)
VS0(45,13)=PAy*VS0(28,13)+WPy*VS1(28,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +2D0*HfxZpE*VS1(28,6)
VS0(45,14)=PAy*VS0(28,14)+WPy*VS1(28,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))&
   +3D0*HfxZpE*VS1(28,7)
VS0(45,15)=PAy*VS0(28,15)+WPy*VS1(28,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))
VS0(45,16)=PAy*VS0(28,16)+WPy*VS1(28,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(28,8)
VS0(45,17)=PAy*VS0(28,17)+WPy*VS1(28,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +2D0*HfxZpE*VS1(28,9)
VS0(45,18)=PAy*VS0(28,18)+WPy*VS1(28,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))
VS0(45,19)=PAy*VS0(28,19)+WPy*VS1(28,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +HfxZpE*VS1(28,10)
VS0(45,20)=PAy*VS0(28,20)+WPy*VS1(28,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(46,11)=PAy*VS0(29,11)+WPy*VS1(29,11)&
   +3D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(46,12)=PAy*VS0(29,12)+WPy*VS1(29,12)&
   +3D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +HfxZpE*VS1(29,5)
VS0(46,13)=PAy*VS0(29,13)+WPy*VS1(29,13)&
   +3D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(29,6)
VS0(46,14)=PAy*VS0(29,14)+WPy*VS1(29,14)&
   +3D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))&
   +3D0*HfxZpE*VS1(29,7)
VS0(46,15)=PAy*VS0(29,15)+WPy*VS1(29,15)&
   +3D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))
VS0(46,16)=PAy*VS0(29,16)+WPy*VS1(29,16)&
   +3D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(29,8)
VS0(46,17)=PAy*VS0(29,17)+WPy*VS1(29,17)&
   +3D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(29,9)
VS0(46,18)=PAy*VS0(29,18)+WPy*VS1(29,18)&
   +3D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))
VS0(46,19)=PAy*VS0(29,19)+WPy*VS1(29,19)&
   +3D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +HfxZpE*VS1(29,10)
VS0(46,20)=PAy*VS0(29,20)+WPy*VS1(29,20)&
   +3D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(47,11)=PAx*VS0(30,11)+WPx*VS1(30,11)+r1x2Z*VR1(30,11)&
   +2D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))&
   +3D0*HfxZpE*VS1(30,5)
VS0(47,12)=PAx*VS0(30,12)+WPx*VS1(30,12)+r1x2Z*VR1(30,12)&
   +2D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +2D0*HfxZpE*VS1(30,6)
VS0(47,13)=PAx*VS0(30,13)+WPx*VS1(30,13)+r1x2Z*VR1(30,13)&
   +2D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +HfxZpE*VS1(30,7)
VS0(47,14)=PAx*VS0(30,14)+WPx*VS1(30,14)+r1x2Z*VR1(30,14)&
   +2D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(47,15)=PAx*VS0(30,15)+WPx*VS1(30,15)+r1x2Z*VR1(30,15)&
   +2D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(30,8)
VS0(47,16)=PAx*VS0(30,16)+WPx*VS1(30,16)+r1x2Z*VR1(30,16)&
   +2D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(30,9)
VS0(47,17)=PAx*VS0(30,17)+WPx*VS1(30,17)+r1x2Z*VR1(30,17)&
   +2D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))
VS0(47,18)=PAx*VS0(30,18)+WPx*VS1(30,18)+r1x2Z*VR1(30,18)&
   +2D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +HfxZpE*VS1(30,10)
VS0(47,19)=PAx*VS0(30,19)+WPx*VS1(30,19)+r1x2Z*VR1(30,19)&
   +2D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))
VS0(47,20)=PAx*VS0(30,20)+WPx*VS1(30,20)+r1x2Z*VR1(30,20)&
   +2D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(48,11)=PAx*VS0(31,11)+WPx*VS1(31,11)+r1x2Z*VR1(31,11)&
   +r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))&
   +3D0*HfxZpE*VS1(31,5)
VS0(48,12)=PAx*VS0(31,12)+WPx*VS1(31,12)+r1x2Z*VR1(31,12)&
   +r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +2D0*HfxZpE*VS1(31,6)
VS0(48,13)=PAx*VS0(31,13)+WPx*VS1(31,13)+r1x2Z*VR1(31,13)&
   +r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +HfxZpE*VS1(31,7)
VS0(48,14)=PAx*VS0(31,14)+WPx*VS1(31,14)+r1x2Z*VR1(31,14)&
   +r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(48,15)=PAx*VS0(31,15)+WPx*VS1(31,15)+r1x2Z*VR1(31,15)&
   +r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(31,8)
VS0(48,16)=PAx*VS0(31,16)+WPx*VS1(31,16)+r1x2Z*VR1(31,16)&
   +r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(31,9)
VS0(48,17)=PAx*VS0(31,17)+WPx*VS1(31,17)+r1x2Z*VR1(31,17)&
   +r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))
VS0(48,18)=PAx*VS0(31,18)+WPx*VS1(31,18)+r1x2Z*VR1(31,18)&
   +r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +HfxZpE*VS1(31,10)
VS0(48,19)=PAx*VS0(31,19)+WPx*VS1(31,19)+r1x2Z*VR1(31,19)&
   +r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))
VS0(48,20)=PAx*VS0(31,20)+WPx*VS1(31,20)+r1x2Z*VR1(31,20)&
   +r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(49,11)=PAy*VS0(31,11)+WPy*VS1(31,11)&
   +r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(49,12)=PAy*VS0(31,12)+WPy*VS1(31,12)&
   +r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +HfxZpE*VS1(31,5)
VS0(49,13)=PAy*VS0(31,13)+WPy*VS1(31,13)&
   +r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +2D0*HfxZpE*VS1(31,6)
VS0(49,14)=PAy*VS0(31,14)+WPy*VS1(31,14)&
   +r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))&
   +3D0*HfxZpE*VS1(31,7)
VS0(49,15)=PAy*VS0(31,15)+WPy*VS1(31,15)&
   +r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))
VS0(49,16)=PAy*VS0(31,16)+WPy*VS1(31,16)&
   +r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(31,8)
VS0(49,17)=PAy*VS0(31,17)+WPy*VS1(31,17)&
   +r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(31,9)
VS0(49,18)=PAy*VS0(31,18)+WPy*VS1(31,18)&
   +r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))
VS0(49,19)=PAy*VS0(31,19)+WPy*VS1(31,19)&
   +r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +HfxZpE*VS1(31,10)
VS0(49,20)=PAy*VS0(31,20)+WPy*VS1(31,20)&
   +r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(50,11)=PAy*VS0(32,11)+WPy*VS1(32,11)&
   +2D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(50,12)=PAy*VS0(32,12)+WPy*VS1(32,12)&
   +2D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +HfxZpE*VS1(32,5)
VS0(50,13)=PAy*VS0(32,13)+WPy*VS1(32,13)&
   +2D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +2D0*HfxZpE*VS1(32,6)
VS0(50,14)=PAy*VS0(32,14)+WPy*VS1(32,14)&
   +2D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))&
   +3D0*HfxZpE*VS1(32,7)
VS0(50,15)=PAy*VS0(32,15)+WPy*VS1(32,15)&
   +2D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))
VS0(50,16)=PAy*VS0(32,16)+WPy*VS1(32,16)&
   +2D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(32,8)
VS0(50,17)=PAy*VS0(32,17)+WPy*VS1(32,17)&
   +2D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(32,9)
VS0(50,18)=PAy*VS0(32,18)+WPy*VS1(32,18)&
   +2D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))
VS0(50,19)=PAy*VS0(32,19)+WPy*VS1(32,19)&
   +2D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +HfxZpE*VS1(32,10)
VS0(50,20)=PAy*VS0(32,20)+WPy*VS1(32,20)&
   +2D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(51,11)=PAz*VS0(30,11)+WPz*VS1(30,11)&
   +2D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))
VS0(51,12)=PAz*VS0(30,12)+WPz*VS1(30,12)&
   +2D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))
VS0(51,13)=PAz*VS0(30,13)+WPz*VS1(30,13)&
   +2D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))
VS0(51,14)=PAz*VS0(30,14)+WPz*VS1(30,14)&
   +2D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(51,15)=PAz*VS0(30,15)+WPz*VS1(30,15)&
   +2D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +HfxZpE*VS1(30,5)
VS0(51,16)=PAz*VS0(30,16)+WPz*VS1(30,16)&
   +2D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(30,6)
VS0(51,17)=PAz*VS0(30,17)+WPz*VS1(30,17)&
   +2D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))&
   +HfxZpE*VS1(30,7)
VS0(51,18)=PAz*VS0(30,18)+WPz*VS1(30,18)&
   +2D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(30,8)
VS0(51,19)=PAz*VS0(30,19)+WPz*VS1(30,19)&
   +2D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(30,9)
VS0(51,20)=PAz*VS0(30,20)+WPz*VS1(30,20)&
   +2D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))&
   +3D0*HfxZpE*VS1(30,10)
VS0(52,11)=PAz*VS0(31,11)+WPz*VS1(31,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(52,12)=PAz*VS0(31,12)+WPz*VS1(31,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))
VS0(52,13)=PAz*VS0(31,13)+WPz*VS1(31,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))
VS0(52,14)=PAz*VS0(31,14)+WPz*VS1(31,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(52,15)=PAz*VS0(31,15)+WPz*VS1(31,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +HfxZpE*VS1(31,5)
VS0(52,16)=PAz*VS0(31,16)+WPz*VS1(31,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(31,6)
VS0(52,17)=PAz*VS0(31,17)+WPz*VS1(31,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +HfxZpE*VS1(31,7)
VS0(52,18)=PAz*VS0(31,18)+WPz*VS1(31,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +2D0*HfxZpE*VS1(31,8)
VS0(52,19)=PAz*VS0(31,19)+WPz*VS1(31,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +2D0*HfxZpE*VS1(31,9)
VS0(52,20)=PAz*VS0(31,20)+WPz*VS1(31,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))&
   +3D0*HfxZpE*VS1(31,10)
VS0(53,11)=PAz*VS0(32,11)+WPz*VS1(32,11)&
   +2D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(53,12)=PAz*VS0(32,12)+WPz*VS1(32,12)&
   +2D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))
VS0(53,13)=PAz*VS0(32,13)+WPz*VS1(32,13)&
   +2D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))
VS0(53,14)=PAz*VS0(32,14)+WPz*VS1(32,14)&
   +2D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(53,15)=PAz*VS0(32,15)+WPz*VS1(32,15)&
   +2D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +HfxZpE*VS1(32,5)
VS0(53,16)=PAz*VS0(32,16)+WPz*VS1(32,16)&
   +2D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(32,6)
VS0(53,17)=PAz*VS0(32,17)+WPz*VS1(32,17)&
   +2D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +HfxZpE*VS1(32,7)
VS0(53,18)=PAz*VS0(32,18)+WPz*VS1(32,18)&
   +2D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(32,8)
VS0(53,19)=PAz*VS0(32,19)+WPz*VS1(32,19)&
   +2D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(32,9)
VS0(53,20)=PAz*VS0(32,20)+WPz*VS1(32,20)&
   +2D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))&
   +3D0*HfxZpE*VS1(32,10)
VS0(54,11)=PAz*VS0(33,11)+WPz*VS1(33,11)&
   +3D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(54,12)=PAz*VS0(33,12)+WPz*VS1(33,12)&
   +3D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))
VS0(54,13)=PAz*VS0(33,13)+WPz*VS1(33,13)&
   +3D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))
VS0(54,14)=PAz*VS0(33,14)+WPz*VS1(33,14)&
   +3D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(54,15)=PAz*VS0(33,15)+WPz*VS1(33,15)&
   +3D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +HfxZpE*VS1(33,5)
VS0(54,16)=PAz*VS0(33,16)+WPz*VS1(33,16)&
   +3D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(33,6)
VS0(54,17)=PAz*VS0(33,17)+WPz*VS1(33,17)&
   +3D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +HfxZpE*VS1(33,7)
VS0(54,18)=PAz*VS0(33,18)+WPz*VS1(33,18)&
   +3D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(33,8)
VS0(54,19)=PAz*VS0(33,19)+WPz*VS1(33,19)&
   +3D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(33,9)
VS0(54,20)=PAz*VS0(33,20)+WPz*VS1(33,20)&
   +3D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))&
   +3D0*HfxZpE*VS1(33,10)
VS0(55,11)=PAz*VS0(34,11)+WPz*VS1(34,11)&
   +3D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(55,12)=PAz*VS0(34,12)+WPz*VS1(34,12)&
   +3D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))
VS0(55,13)=PAz*VS0(34,13)+WPz*VS1(34,13)&
   +3D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))
VS0(55,14)=PAz*VS0(34,14)+WPz*VS1(34,14)&
   +3D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(55,15)=PAz*VS0(34,15)+WPz*VS1(34,15)&
   +3D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +HfxZpE*VS1(34,5)
VS0(55,16)=PAz*VS0(34,16)+WPz*VS1(34,16)&
   +3D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(34,6)
VS0(55,17)=PAz*VS0(34,17)+WPz*VS1(34,17)&
   +3D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +HfxZpE*VS1(34,7)
VS0(55,18)=PAz*VS0(34,18)+WPz*VS1(34,18)&
   +3D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(34,8)
VS0(55,19)=PAz*VS0(34,19)+WPz*VS1(34,19)&
   +3D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(34,9)
VS0(55,20)=PAz*VS0(34,20)+WPz*VS1(34,20)&
   +3D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))&
   +3D0*HfxZpE*VS1(34,10)
VS0(56,11)=PAz*VS0(35,11)+WPz*VS1(35,11)&
   +4D0*r1x2Z*(VS0(20,11)-ExZpE*VS1(20,11))
VS0(56,12)=PAz*VS0(35,12)+WPz*VS1(35,12)&
   +4D0*r1x2Z*(VS0(20,12)-ExZpE*VS1(20,12))
VS0(56,13)=PAz*VS0(35,13)+WPz*VS1(35,13)&
   +4D0*r1x2Z*(VS0(20,13)-ExZpE*VS1(20,13))
VS0(56,14)=PAz*VS0(35,14)+WPz*VS1(35,14)&
   +4D0*r1x2Z*(VS0(20,14)-ExZpE*VS1(20,14))
VS0(56,15)=PAz*VS0(35,15)+WPz*VS1(35,15)&
   +4D0*r1x2Z*(VS0(20,15)-ExZpE*VS1(20,15))&
   +HfxZpE*VS1(35,5)
VS0(56,16)=PAz*VS0(35,16)+WPz*VS1(35,16)&
   +4D0*r1x2Z*(VS0(20,16)-ExZpE*VS1(20,16))&
   +HfxZpE*VS1(35,6)
VS0(56,17)=PAz*VS0(35,17)+WPz*VS1(35,17)&
   +4D0*r1x2Z*(VS0(20,17)-ExZpE*VS1(20,17))&
   +HfxZpE*VS1(35,7)
VS0(56,18)=PAz*VS0(35,18)+WPz*VS1(35,18)&
   +4D0*r1x2Z*(VS0(20,18)-ExZpE*VS1(20,18))&
   +2D0*HfxZpE*VS1(35,8)
VS0(56,19)=PAz*VS0(35,19)+WPz*VS1(35,19)&
   +4D0*r1x2Z*(VS0(20,19)-ExZpE*VS1(20,19))&
   +2D0*HfxZpE*VS1(35,9)
VS0(56,20)=PAz*VS0(35,20)+WPz*VS1(35,20)&
   +4D0*r1x2Z*(VS0(20,20)-ExZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(35,10)
CASE(2)
VS0(36,11)=PAx*VS0(21,11)+WPx*VS1(21,11)&
   +4D0*r1x2Z*(VS0(11,11)-ExZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(21,5)
VS0(36,12)=PAx*VS0(21,12)+WPx*VS1(21,12)&
   +4D0*r1x2Z*(VS0(11,12)-ExZpE*VS1(11,12))&
   +2D0*HfxZpE*VS1(21,6)
VS0(36,13)=PAx*VS0(21,13)+WPx*VS1(21,13)&
   +4D0*r1x2Z*(VS0(11,13)-ExZpE*VS1(11,13))&
   +HfxZpE*VS1(21,7)
VS0(36,14)=PAx*VS0(21,14)+WPx*VS1(21,14)&
   +4D0*r1x2Z*(VS0(11,14)-ExZpE*VS1(11,14))
VS0(36,15)=PAx*VS0(21,15)+WPx*VS1(21,15)&
   +4D0*r1x2Z*(VS0(11,15)-ExZpE*VS1(11,15))&
   +2D0*HfxZpE*VS1(21,8)
VS0(36,16)=PAx*VS0(21,16)+WPx*VS1(21,16)&
   +4D0*r1x2Z*(VS0(11,16)-ExZpE*VS1(11,16))&
   +HfxZpE*VS1(21,9)
VS0(36,17)=PAx*VS0(21,17)+WPx*VS1(21,17)&
   +4D0*r1x2Z*(VS0(11,17)-ExZpE*VS1(11,17))
VS0(36,18)=PAx*VS0(21,18)+WPx*VS1(21,18)&
   +4D0*r1x2Z*(VS0(11,18)-ExZpE*VS1(11,18))&
   +HfxZpE*VS1(21,10)
VS0(36,19)=PAx*VS0(21,19)+WPx*VS1(21,19)&
   +4D0*r1x2Z*(VS0(11,19)-ExZpE*VS1(11,19))
VS0(36,20)=PAx*VS0(21,20)+WPx*VS1(21,20)&
   +4D0*r1x2Z*(VS0(11,20)-ExZpE*VS1(11,20))
VS0(37,11)=PAx*VS0(22,11)+WPx*VS1(22,11)&
   +3D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))&
   +3D0*HfxZpE*VS1(22,5)
VS0(37,12)=PAx*VS0(22,12)+WPx*VS1(22,12)&
   +3D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(22,6)
VS0(37,13)=PAx*VS0(22,13)+WPx*VS1(22,13)&
   +3D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +HfxZpE*VS1(22,7)
VS0(37,14)=PAx*VS0(22,14)+WPx*VS1(22,14)&
   +3D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))
VS0(37,15)=PAx*VS0(22,15)+WPx*VS1(22,15)&
   +3D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(22,8)
VS0(37,16)=PAx*VS0(22,16)+WPx*VS1(22,16)&
   +3D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(22,9)
VS0(37,17)=PAx*VS0(22,17)+WPx*VS1(22,17)&
   +3D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))
VS0(37,18)=PAx*VS0(22,18)+WPx*VS1(22,18)&
   +3D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))&
   +HfxZpE*VS1(22,10)
VS0(37,19)=PAx*VS0(22,19)+WPx*VS1(22,19)&
   +3D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))
VS0(37,20)=PAx*VS0(22,20)+WPx*VS1(22,20)&
   +3D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(38,11)=PAx*VS0(23,11)+WPx*VS1(23,11)&
   +2D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))&
   +3D0*HfxZpE*VS1(23,5)
VS0(38,12)=PAx*VS0(23,12)+WPx*VS1(23,12)&
   +2D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(23,6)
VS0(38,13)=PAx*VS0(23,13)+WPx*VS1(23,13)&
   +2D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +HfxZpE*VS1(23,7)
VS0(38,14)=PAx*VS0(23,14)+WPx*VS1(23,14)&
   +2D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))
VS0(38,15)=PAx*VS0(23,15)+WPx*VS1(23,15)&
   +2D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))&
   +2D0*HfxZpE*VS1(23,8)
VS0(38,16)=PAx*VS0(23,16)+WPx*VS1(23,16)&
   +2D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(23,9)
VS0(38,17)=PAx*VS0(23,17)+WPx*VS1(23,17)&
   +2D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))
VS0(38,18)=PAx*VS0(23,18)+WPx*VS1(23,18)&
   +2D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))&
   +HfxZpE*VS1(23,10)
VS0(38,19)=PAx*VS0(23,19)+WPx*VS1(23,19)&
   +2D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))
VS0(38,20)=PAx*VS0(23,20)+WPx*VS1(23,20)&
   +2D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(39,11)=PAy*VS0(23,11)+WPy*VS1(23,11)+r1x2Z*VR1(23,11)&
   +2D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))
VS0(39,12)=PAy*VS0(23,12)+WPy*VS1(23,12)+r1x2Z*VR1(23,12)&
   +2D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +HfxZpE*VS1(23,5)
VS0(39,13)=PAy*VS0(23,13)+WPy*VS1(23,13)+r1x2Z*VR1(23,13)&
   +2D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(23,6)
VS0(39,14)=PAy*VS0(23,14)+WPy*VS1(23,14)+r1x2Z*VR1(23,14)&
   +2D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))&
   +3D0*HfxZpE*VS1(23,7)
VS0(39,15)=PAy*VS0(23,15)+WPy*VS1(23,15)+r1x2Z*VR1(23,15)&
   +2D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))
VS0(39,16)=PAy*VS0(23,16)+WPy*VS1(23,16)+r1x2Z*VR1(23,16)&
   +2D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(23,8)
VS0(39,17)=PAy*VS0(23,17)+WPy*VS1(23,17)+r1x2Z*VR1(23,17)&
   +2D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(23,9)
VS0(39,18)=PAy*VS0(23,18)+WPy*VS1(23,18)+r1x2Z*VR1(23,18)&
   +2D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))
VS0(39,19)=PAy*VS0(23,19)+WPy*VS1(23,19)+r1x2Z*VR1(23,19)&
   +2D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))&
   +HfxZpE*VS1(23,10)
VS0(39,20)=PAy*VS0(23,20)+WPy*VS1(23,20)+r1x2Z*VR1(23,20)&
   +2D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(40,11)=PAy*VS0(24,11)+WPy*VS1(24,11)+r1x2Z*VR1(24,11)&
   +3D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))
VS0(40,12)=PAy*VS0(24,12)+WPy*VS1(24,12)+r1x2Z*VR1(24,12)&
   +3D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +HfxZpE*VS1(24,5)
VS0(40,13)=PAy*VS0(24,13)+WPy*VS1(24,13)+r1x2Z*VR1(24,13)&
   +3D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(24,6)
VS0(40,14)=PAy*VS0(24,14)+WPy*VS1(24,14)+r1x2Z*VR1(24,14)&
   +3D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))&
   +3D0*HfxZpE*VS1(24,7)
VS0(40,15)=PAy*VS0(24,15)+WPy*VS1(24,15)+r1x2Z*VR1(24,15)&
   +3D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))
VS0(40,16)=PAy*VS0(24,16)+WPy*VS1(24,16)+r1x2Z*VR1(24,16)&
   +3D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(24,8)
VS0(40,17)=PAy*VS0(24,17)+WPy*VS1(24,17)+r1x2Z*VR1(24,17)&
   +3D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(24,9)
VS0(40,18)=PAy*VS0(24,18)+WPy*VS1(24,18)+r1x2Z*VR1(24,18)&
   +3D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))
VS0(40,19)=PAy*VS0(24,19)+WPy*VS1(24,19)+r1x2Z*VR1(24,19)&
   +3D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))&
   +HfxZpE*VS1(24,10)
VS0(40,20)=PAy*VS0(24,20)+WPy*VS1(24,20)+r1x2Z*VR1(24,20)&
   +3D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(41,11)=PAy*VS0(25,11)+WPy*VS1(25,11)+r1x2Z*VR1(25,11)&
   +4D0*r1x2Z*(VS0(14,11)-ExZpE*VS1(14,11))
VS0(41,12)=PAy*VS0(25,12)+WPy*VS1(25,12)+r1x2Z*VR1(25,12)&
   +4D0*r1x2Z*(VS0(14,12)-ExZpE*VS1(14,12))&
   +HfxZpE*VS1(25,5)
VS0(41,13)=PAy*VS0(25,13)+WPy*VS1(25,13)+r1x2Z*VR1(25,13)&
   +4D0*r1x2Z*(VS0(14,13)-ExZpE*VS1(14,13))&
   +2D0*HfxZpE*VS1(25,6)
VS0(41,14)=PAy*VS0(25,14)+WPy*VS1(25,14)+r1x2Z*VR1(25,14)&
   +4D0*r1x2Z*(VS0(14,14)-ExZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(25,7)
VS0(41,15)=PAy*VS0(25,15)+WPy*VS1(25,15)+r1x2Z*VR1(25,15)&
   +4D0*r1x2Z*(VS0(14,15)-ExZpE*VS1(14,15))
VS0(41,16)=PAy*VS0(25,16)+WPy*VS1(25,16)+r1x2Z*VR1(25,16)&
   +4D0*r1x2Z*(VS0(14,16)-ExZpE*VS1(14,16))&
   +HfxZpE*VS1(25,8)
VS0(41,17)=PAy*VS0(25,17)+WPy*VS1(25,17)+r1x2Z*VR1(25,17)&
   +4D0*r1x2Z*(VS0(14,17)-ExZpE*VS1(14,17))&
   +2D0*HfxZpE*VS1(25,9)
VS0(41,18)=PAy*VS0(25,18)+WPy*VS1(25,18)+r1x2Z*VR1(25,18)&
   +4D0*r1x2Z*(VS0(14,18)-ExZpE*VS1(14,18))
VS0(41,19)=PAy*VS0(25,19)+WPy*VS1(25,19)+r1x2Z*VR1(25,19)&
   +4D0*r1x2Z*(VS0(14,19)-ExZpE*VS1(14,19))&
   +HfxZpE*VS1(25,10)
VS0(41,20)=PAy*VS0(25,20)+WPy*VS1(25,20)+r1x2Z*VR1(25,20)&
   +4D0*r1x2Z*(VS0(14,20)-ExZpE*VS1(14,20))
VS0(42,11)=PAx*VS0(26,11)+WPx*VS1(26,11)&
   +3D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))&
   +3D0*HfxZpE*VS1(26,5)
VS0(42,12)=PAx*VS0(26,12)+WPx*VS1(26,12)&
   +3D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(26,6)
VS0(42,13)=PAx*VS0(26,13)+WPx*VS1(26,13)&
   +3D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))&
   +HfxZpE*VS1(26,7)
VS0(42,14)=PAx*VS0(26,14)+WPx*VS1(26,14)&
   +3D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(42,15)=PAx*VS0(26,15)+WPx*VS1(26,15)&
   +3D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(26,8)
VS0(42,16)=PAx*VS0(26,16)+WPx*VS1(26,16)&
   +3D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(26,9)
VS0(42,17)=PAx*VS0(26,17)+WPx*VS1(26,17)&
   +3D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))
VS0(42,18)=PAx*VS0(26,18)+WPx*VS1(26,18)&
   +3D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +HfxZpE*VS1(26,10)
VS0(42,19)=PAx*VS0(26,19)+WPx*VS1(26,19)&
   +3D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))
VS0(42,20)=PAx*VS0(26,20)+WPx*VS1(26,20)&
   +3D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))
VS0(43,11)=PAx*VS0(27,11)+WPx*VS1(27,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))&
   +3D0*HfxZpE*VS1(27,5)
VS0(43,12)=PAx*VS0(27,12)+WPx*VS1(27,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +2D0*HfxZpE*VS1(27,6)
VS0(43,13)=PAx*VS0(27,13)+WPx*VS1(27,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +HfxZpE*VS1(27,7)
VS0(43,14)=PAx*VS0(27,14)+WPx*VS1(27,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(43,15)=PAx*VS0(27,15)+WPx*VS1(27,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +2D0*HfxZpE*VS1(27,8)
VS0(43,16)=PAx*VS0(27,16)+WPx*VS1(27,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(27,9)
VS0(43,17)=PAx*VS0(27,17)+WPx*VS1(27,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))
VS0(43,18)=PAx*VS0(27,18)+WPx*VS1(27,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +HfxZpE*VS1(27,10)
VS0(43,19)=PAx*VS0(27,19)+WPx*VS1(27,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))
VS0(43,20)=PAx*VS0(27,20)+WPx*VS1(27,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(44,11)=PAx*VS0(28,11)+WPx*VS1(28,11)&
   +r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))&
   +3D0*HfxZpE*VS1(28,5)
VS0(44,12)=PAx*VS0(28,12)+WPx*VS1(28,12)&
   +r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(28,6)
VS0(44,13)=PAx*VS0(28,13)+WPx*VS1(28,13)&
   +r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +HfxZpE*VS1(28,7)
VS0(44,14)=PAx*VS0(28,14)+WPx*VS1(28,14)&
   +r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(44,15)=PAx*VS0(28,15)+WPx*VS1(28,15)&
   +r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +2D0*HfxZpE*VS1(28,8)
VS0(44,16)=PAx*VS0(28,16)+WPx*VS1(28,16)&
   +r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(28,9)
VS0(44,17)=PAx*VS0(28,17)+WPx*VS1(28,17)&
   +r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))
VS0(44,18)=PAx*VS0(28,18)+WPx*VS1(28,18)&
   +r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +HfxZpE*VS1(28,10)
VS0(44,19)=PAx*VS0(28,19)+WPx*VS1(28,19)&
   +r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))
VS0(44,20)=PAx*VS0(28,20)+WPx*VS1(28,20)&
   +r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(45,11)=PAy*VS0(28,11)+WPy*VS1(28,11)+r1x2Z*VR1(28,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(45,12)=PAy*VS0(28,12)+WPy*VS1(28,12)+r1x2Z*VR1(28,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +HfxZpE*VS1(28,5)
VS0(45,13)=PAy*VS0(28,13)+WPy*VS1(28,13)+r1x2Z*VR1(28,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +2D0*HfxZpE*VS1(28,6)
VS0(45,14)=PAy*VS0(28,14)+WPy*VS1(28,14)+r1x2Z*VR1(28,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))&
   +3D0*HfxZpE*VS1(28,7)
VS0(45,15)=PAy*VS0(28,15)+WPy*VS1(28,15)+r1x2Z*VR1(28,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))
VS0(45,16)=PAy*VS0(28,16)+WPy*VS1(28,16)+r1x2Z*VR1(28,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(28,8)
VS0(45,17)=PAy*VS0(28,17)+WPy*VS1(28,17)+r1x2Z*VR1(28,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +2D0*HfxZpE*VS1(28,9)
VS0(45,18)=PAy*VS0(28,18)+WPy*VS1(28,18)+r1x2Z*VR1(28,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))
VS0(45,19)=PAy*VS0(28,19)+WPy*VS1(28,19)+r1x2Z*VR1(28,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +HfxZpE*VS1(28,10)
VS0(45,20)=PAy*VS0(28,20)+WPy*VS1(28,20)+r1x2Z*VR1(28,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(46,11)=PAy*VS0(29,11)+WPy*VS1(29,11)+r1x2Z*VR1(29,11)&
   +3D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(46,12)=PAy*VS0(29,12)+WPy*VS1(29,12)+r1x2Z*VR1(29,12)&
   +3D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +HfxZpE*VS1(29,5)
VS0(46,13)=PAy*VS0(29,13)+WPy*VS1(29,13)+r1x2Z*VR1(29,13)&
   +3D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(29,6)
VS0(46,14)=PAy*VS0(29,14)+WPy*VS1(29,14)+r1x2Z*VR1(29,14)&
   +3D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))&
   +3D0*HfxZpE*VS1(29,7)
VS0(46,15)=PAy*VS0(29,15)+WPy*VS1(29,15)+r1x2Z*VR1(29,15)&
   +3D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))
VS0(46,16)=PAy*VS0(29,16)+WPy*VS1(29,16)+r1x2Z*VR1(29,16)&
   +3D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(29,8)
VS0(46,17)=PAy*VS0(29,17)+WPy*VS1(29,17)+r1x2Z*VR1(29,17)&
   +3D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(29,9)
VS0(46,18)=PAy*VS0(29,18)+WPy*VS1(29,18)+r1x2Z*VR1(29,18)&
   +3D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))
VS0(46,19)=PAy*VS0(29,19)+WPy*VS1(29,19)+r1x2Z*VR1(29,19)&
   +3D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +HfxZpE*VS1(29,10)
VS0(46,20)=PAy*VS0(29,20)+WPy*VS1(29,20)+r1x2Z*VR1(29,20)&
   +3D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(47,11)=PAx*VS0(30,11)+WPx*VS1(30,11)&
   +2D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))&
   +3D0*HfxZpE*VS1(30,5)
VS0(47,12)=PAx*VS0(30,12)+WPx*VS1(30,12)&
   +2D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +2D0*HfxZpE*VS1(30,6)
VS0(47,13)=PAx*VS0(30,13)+WPx*VS1(30,13)&
   +2D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +HfxZpE*VS1(30,7)
VS0(47,14)=PAx*VS0(30,14)+WPx*VS1(30,14)&
   +2D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(47,15)=PAx*VS0(30,15)+WPx*VS1(30,15)&
   +2D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(30,8)
VS0(47,16)=PAx*VS0(30,16)+WPx*VS1(30,16)&
   +2D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(30,9)
VS0(47,17)=PAx*VS0(30,17)+WPx*VS1(30,17)&
   +2D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))
VS0(47,18)=PAx*VS0(30,18)+WPx*VS1(30,18)&
   +2D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +HfxZpE*VS1(30,10)
VS0(47,19)=PAx*VS0(30,19)+WPx*VS1(30,19)&
   +2D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))
VS0(47,20)=PAx*VS0(30,20)+WPx*VS1(30,20)&
   +2D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(48,11)=PAx*VS0(31,11)+WPx*VS1(31,11)&
   +r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))&
   +3D0*HfxZpE*VS1(31,5)
VS0(48,12)=PAx*VS0(31,12)+WPx*VS1(31,12)&
   +r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +2D0*HfxZpE*VS1(31,6)
VS0(48,13)=PAx*VS0(31,13)+WPx*VS1(31,13)&
   +r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +HfxZpE*VS1(31,7)
VS0(48,14)=PAx*VS0(31,14)+WPx*VS1(31,14)&
   +r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(48,15)=PAx*VS0(31,15)+WPx*VS1(31,15)&
   +r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(31,8)
VS0(48,16)=PAx*VS0(31,16)+WPx*VS1(31,16)&
   +r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(31,9)
VS0(48,17)=PAx*VS0(31,17)+WPx*VS1(31,17)&
   +r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))
VS0(48,18)=PAx*VS0(31,18)+WPx*VS1(31,18)&
   +r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +HfxZpE*VS1(31,10)
VS0(48,19)=PAx*VS0(31,19)+WPx*VS1(31,19)&
   +r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))
VS0(48,20)=PAx*VS0(31,20)+WPx*VS1(31,20)&
   +r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(49,11)=PAy*VS0(31,11)+WPy*VS1(31,11)+r1x2Z*VR1(31,11)&
   +r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(49,12)=PAy*VS0(31,12)+WPy*VS1(31,12)+r1x2Z*VR1(31,12)&
   +r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +HfxZpE*VS1(31,5)
VS0(49,13)=PAy*VS0(31,13)+WPy*VS1(31,13)+r1x2Z*VR1(31,13)&
   +r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +2D0*HfxZpE*VS1(31,6)
VS0(49,14)=PAy*VS0(31,14)+WPy*VS1(31,14)+r1x2Z*VR1(31,14)&
   +r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))&
   +3D0*HfxZpE*VS1(31,7)
VS0(49,15)=PAy*VS0(31,15)+WPy*VS1(31,15)+r1x2Z*VR1(31,15)&
   +r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))
VS0(49,16)=PAy*VS0(31,16)+WPy*VS1(31,16)+r1x2Z*VR1(31,16)&
   +r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(31,8)
VS0(49,17)=PAy*VS0(31,17)+WPy*VS1(31,17)+r1x2Z*VR1(31,17)&
   +r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(31,9)
VS0(49,18)=PAy*VS0(31,18)+WPy*VS1(31,18)+r1x2Z*VR1(31,18)&
   +r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))
VS0(49,19)=PAy*VS0(31,19)+WPy*VS1(31,19)+r1x2Z*VR1(31,19)&
   +r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +HfxZpE*VS1(31,10)
VS0(49,20)=PAy*VS0(31,20)+WPy*VS1(31,20)+r1x2Z*VR1(31,20)&
   +r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(50,11)=PAy*VS0(32,11)+WPy*VS1(32,11)+r1x2Z*VR1(32,11)&
   +2D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(50,12)=PAy*VS0(32,12)+WPy*VS1(32,12)+r1x2Z*VR1(32,12)&
   +2D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +HfxZpE*VS1(32,5)
VS0(50,13)=PAy*VS0(32,13)+WPy*VS1(32,13)+r1x2Z*VR1(32,13)&
   +2D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +2D0*HfxZpE*VS1(32,6)
VS0(50,14)=PAy*VS0(32,14)+WPy*VS1(32,14)+r1x2Z*VR1(32,14)&
   +2D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))&
   +3D0*HfxZpE*VS1(32,7)
VS0(50,15)=PAy*VS0(32,15)+WPy*VS1(32,15)+r1x2Z*VR1(32,15)&
   +2D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))
VS0(50,16)=PAy*VS0(32,16)+WPy*VS1(32,16)+r1x2Z*VR1(32,16)&
   +2D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(32,8)
VS0(50,17)=PAy*VS0(32,17)+WPy*VS1(32,17)+r1x2Z*VR1(32,17)&
   +2D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(32,9)
VS0(50,18)=PAy*VS0(32,18)+WPy*VS1(32,18)+r1x2Z*VR1(32,18)&
   +2D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))
VS0(50,19)=PAy*VS0(32,19)+WPy*VS1(32,19)+r1x2Z*VR1(32,19)&
   +2D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +HfxZpE*VS1(32,10)
VS0(50,20)=PAy*VS0(32,20)+WPy*VS1(32,20)+r1x2Z*VR1(32,20)&
   +2D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(51,11)=PAz*VS0(30,11)+WPz*VS1(30,11)&
   +2D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))
VS0(51,12)=PAz*VS0(30,12)+WPz*VS1(30,12)&
   +2D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))
VS0(51,13)=PAz*VS0(30,13)+WPz*VS1(30,13)&
   +2D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))
VS0(51,14)=PAz*VS0(30,14)+WPz*VS1(30,14)&
   +2D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(51,15)=PAz*VS0(30,15)+WPz*VS1(30,15)&
   +2D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +HfxZpE*VS1(30,5)
VS0(51,16)=PAz*VS0(30,16)+WPz*VS1(30,16)&
   +2D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(30,6)
VS0(51,17)=PAz*VS0(30,17)+WPz*VS1(30,17)&
   +2D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))&
   +HfxZpE*VS1(30,7)
VS0(51,18)=PAz*VS0(30,18)+WPz*VS1(30,18)&
   +2D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(30,8)
VS0(51,19)=PAz*VS0(30,19)+WPz*VS1(30,19)&
   +2D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(30,9)
VS0(51,20)=PAz*VS0(30,20)+WPz*VS1(30,20)&
   +2D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))&
   +3D0*HfxZpE*VS1(30,10)
VS0(52,11)=PAz*VS0(31,11)+WPz*VS1(31,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(52,12)=PAz*VS0(31,12)+WPz*VS1(31,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))
VS0(52,13)=PAz*VS0(31,13)+WPz*VS1(31,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))
VS0(52,14)=PAz*VS0(31,14)+WPz*VS1(31,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(52,15)=PAz*VS0(31,15)+WPz*VS1(31,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +HfxZpE*VS1(31,5)
VS0(52,16)=PAz*VS0(31,16)+WPz*VS1(31,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(31,6)
VS0(52,17)=PAz*VS0(31,17)+WPz*VS1(31,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +HfxZpE*VS1(31,7)
VS0(52,18)=PAz*VS0(31,18)+WPz*VS1(31,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +2D0*HfxZpE*VS1(31,8)
VS0(52,19)=PAz*VS0(31,19)+WPz*VS1(31,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +2D0*HfxZpE*VS1(31,9)
VS0(52,20)=PAz*VS0(31,20)+WPz*VS1(31,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))&
   +3D0*HfxZpE*VS1(31,10)
VS0(53,11)=PAz*VS0(32,11)+WPz*VS1(32,11)&
   +2D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(53,12)=PAz*VS0(32,12)+WPz*VS1(32,12)&
   +2D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))
VS0(53,13)=PAz*VS0(32,13)+WPz*VS1(32,13)&
   +2D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))
VS0(53,14)=PAz*VS0(32,14)+WPz*VS1(32,14)&
   +2D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(53,15)=PAz*VS0(32,15)+WPz*VS1(32,15)&
   +2D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +HfxZpE*VS1(32,5)
VS0(53,16)=PAz*VS0(32,16)+WPz*VS1(32,16)&
   +2D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(32,6)
VS0(53,17)=PAz*VS0(32,17)+WPz*VS1(32,17)&
   +2D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +HfxZpE*VS1(32,7)
VS0(53,18)=PAz*VS0(32,18)+WPz*VS1(32,18)&
   +2D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(32,8)
VS0(53,19)=PAz*VS0(32,19)+WPz*VS1(32,19)&
   +2D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(32,9)
VS0(53,20)=PAz*VS0(32,20)+WPz*VS1(32,20)&
   +2D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))&
   +3D0*HfxZpE*VS1(32,10)
VS0(54,11)=PAz*VS0(33,11)+WPz*VS1(33,11)&
   +3D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(54,12)=PAz*VS0(33,12)+WPz*VS1(33,12)&
   +3D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))
VS0(54,13)=PAz*VS0(33,13)+WPz*VS1(33,13)&
   +3D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))
VS0(54,14)=PAz*VS0(33,14)+WPz*VS1(33,14)&
   +3D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(54,15)=PAz*VS0(33,15)+WPz*VS1(33,15)&
   +3D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +HfxZpE*VS1(33,5)
VS0(54,16)=PAz*VS0(33,16)+WPz*VS1(33,16)&
   +3D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(33,6)
VS0(54,17)=PAz*VS0(33,17)+WPz*VS1(33,17)&
   +3D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +HfxZpE*VS1(33,7)
VS0(54,18)=PAz*VS0(33,18)+WPz*VS1(33,18)&
   +3D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(33,8)
VS0(54,19)=PAz*VS0(33,19)+WPz*VS1(33,19)&
   +3D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(33,9)
VS0(54,20)=PAz*VS0(33,20)+WPz*VS1(33,20)&
   +3D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))&
   +3D0*HfxZpE*VS1(33,10)
VS0(55,11)=PAz*VS0(34,11)+WPz*VS1(34,11)&
   +3D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(55,12)=PAz*VS0(34,12)+WPz*VS1(34,12)&
   +3D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))
VS0(55,13)=PAz*VS0(34,13)+WPz*VS1(34,13)&
   +3D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))
VS0(55,14)=PAz*VS0(34,14)+WPz*VS1(34,14)&
   +3D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(55,15)=PAz*VS0(34,15)+WPz*VS1(34,15)&
   +3D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +HfxZpE*VS1(34,5)
VS0(55,16)=PAz*VS0(34,16)+WPz*VS1(34,16)&
   +3D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(34,6)
VS0(55,17)=PAz*VS0(34,17)+WPz*VS1(34,17)&
   +3D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +HfxZpE*VS1(34,7)
VS0(55,18)=PAz*VS0(34,18)+WPz*VS1(34,18)&
   +3D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(34,8)
VS0(55,19)=PAz*VS0(34,19)+WPz*VS1(34,19)&
   +3D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(34,9)
VS0(55,20)=PAz*VS0(34,20)+WPz*VS1(34,20)&
   +3D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))&
   +3D0*HfxZpE*VS1(34,10)
VS0(56,11)=PAz*VS0(35,11)+WPz*VS1(35,11)&
   +4D0*r1x2Z*(VS0(20,11)-ExZpE*VS1(20,11))
VS0(56,12)=PAz*VS0(35,12)+WPz*VS1(35,12)&
   +4D0*r1x2Z*(VS0(20,12)-ExZpE*VS1(20,12))
VS0(56,13)=PAz*VS0(35,13)+WPz*VS1(35,13)&
   +4D0*r1x2Z*(VS0(20,13)-ExZpE*VS1(20,13))
VS0(56,14)=PAz*VS0(35,14)+WPz*VS1(35,14)&
   +4D0*r1x2Z*(VS0(20,14)-ExZpE*VS1(20,14))
VS0(56,15)=PAz*VS0(35,15)+WPz*VS1(35,15)&
   +4D0*r1x2Z*(VS0(20,15)-ExZpE*VS1(20,15))&
   +HfxZpE*VS1(35,5)
VS0(56,16)=PAz*VS0(35,16)+WPz*VS1(35,16)&
   +4D0*r1x2Z*(VS0(20,16)-ExZpE*VS1(20,16))&
   +HfxZpE*VS1(35,6)
VS0(56,17)=PAz*VS0(35,17)+WPz*VS1(35,17)&
   +4D0*r1x2Z*(VS0(20,17)-ExZpE*VS1(20,17))&
   +HfxZpE*VS1(35,7)
VS0(56,18)=PAz*VS0(35,18)+WPz*VS1(35,18)&
   +4D0*r1x2Z*(VS0(20,18)-ExZpE*VS1(20,18))&
   +2D0*HfxZpE*VS1(35,8)
VS0(56,19)=PAz*VS0(35,19)+WPz*VS1(35,19)&
   +4D0*r1x2Z*(VS0(20,19)-ExZpE*VS1(20,19))&
   +2D0*HfxZpE*VS1(35,9)
VS0(56,20)=PAz*VS0(35,20)+WPz*VS1(35,20)&
   +4D0*r1x2Z*(VS0(20,20)-ExZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(35,10)
CASE(3)
VS0(36,11)=PAx*VS0(21,11)+WPx*VS1(21,11)&
   +4D0*r1x2Z*(VS0(11,11)-ExZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(21,5)
VS0(36,12)=PAx*VS0(21,12)+WPx*VS1(21,12)&
   +4D0*r1x2Z*(VS0(11,12)-ExZpE*VS1(11,12))&
   +2D0*HfxZpE*VS1(21,6)
VS0(36,13)=PAx*VS0(21,13)+WPx*VS1(21,13)&
   +4D0*r1x2Z*(VS0(11,13)-ExZpE*VS1(11,13))&
   +HfxZpE*VS1(21,7)
VS0(36,14)=PAx*VS0(21,14)+WPx*VS1(21,14)&
   +4D0*r1x2Z*(VS0(11,14)-ExZpE*VS1(11,14))
VS0(36,15)=PAx*VS0(21,15)+WPx*VS1(21,15)&
   +4D0*r1x2Z*(VS0(11,15)-ExZpE*VS1(11,15))&
   +2D0*HfxZpE*VS1(21,8)
VS0(36,16)=PAx*VS0(21,16)+WPx*VS1(21,16)&
   +4D0*r1x2Z*(VS0(11,16)-ExZpE*VS1(11,16))&
   +HfxZpE*VS1(21,9)
VS0(36,17)=PAx*VS0(21,17)+WPx*VS1(21,17)&
   +4D0*r1x2Z*(VS0(11,17)-ExZpE*VS1(11,17))
VS0(36,18)=PAx*VS0(21,18)+WPx*VS1(21,18)&
   +4D0*r1x2Z*(VS0(11,18)-ExZpE*VS1(11,18))&
   +HfxZpE*VS1(21,10)
VS0(36,19)=PAx*VS0(21,19)+WPx*VS1(21,19)&
   +4D0*r1x2Z*(VS0(11,19)-ExZpE*VS1(11,19))
VS0(36,20)=PAx*VS0(21,20)+WPx*VS1(21,20)&
   +4D0*r1x2Z*(VS0(11,20)-ExZpE*VS1(11,20))
VS0(37,11)=PAx*VS0(22,11)+WPx*VS1(22,11)&
   +3D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))&
   +3D0*HfxZpE*VS1(22,5)
VS0(37,12)=PAx*VS0(22,12)+WPx*VS1(22,12)&
   +3D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(22,6)
VS0(37,13)=PAx*VS0(22,13)+WPx*VS1(22,13)&
   +3D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +HfxZpE*VS1(22,7)
VS0(37,14)=PAx*VS0(22,14)+WPx*VS1(22,14)&
   +3D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))
VS0(37,15)=PAx*VS0(22,15)+WPx*VS1(22,15)&
   +3D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(22,8)
VS0(37,16)=PAx*VS0(22,16)+WPx*VS1(22,16)&
   +3D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(22,9)
VS0(37,17)=PAx*VS0(22,17)+WPx*VS1(22,17)&
   +3D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))
VS0(37,18)=PAx*VS0(22,18)+WPx*VS1(22,18)&
   +3D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))&
   +HfxZpE*VS1(22,10)
VS0(37,19)=PAx*VS0(22,19)+WPx*VS1(22,19)&
   +3D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))
VS0(37,20)=PAx*VS0(22,20)+WPx*VS1(22,20)&
   +3D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(38,11)=PAx*VS0(23,11)+WPx*VS1(23,11)&
   +2D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))&
   +3D0*HfxZpE*VS1(23,5)
VS0(38,12)=PAx*VS0(23,12)+WPx*VS1(23,12)&
   +2D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(23,6)
VS0(38,13)=PAx*VS0(23,13)+WPx*VS1(23,13)&
   +2D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +HfxZpE*VS1(23,7)
VS0(38,14)=PAx*VS0(23,14)+WPx*VS1(23,14)&
   +2D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))
VS0(38,15)=PAx*VS0(23,15)+WPx*VS1(23,15)&
   +2D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))&
   +2D0*HfxZpE*VS1(23,8)
VS0(38,16)=PAx*VS0(23,16)+WPx*VS1(23,16)&
   +2D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(23,9)
VS0(38,17)=PAx*VS0(23,17)+WPx*VS1(23,17)&
   +2D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))
VS0(38,18)=PAx*VS0(23,18)+WPx*VS1(23,18)&
   +2D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))&
   +HfxZpE*VS1(23,10)
VS0(38,19)=PAx*VS0(23,19)+WPx*VS1(23,19)&
   +2D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))
VS0(38,20)=PAx*VS0(23,20)+WPx*VS1(23,20)&
   +2D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(39,11)=PAy*VS0(23,11)+WPy*VS1(23,11)&
   +2D0*r1x2Z*(VS0(12,11)-ExZpE*VS1(12,11))
VS0(39,12)=PAy*VS0(23,12)+WPy*VS1(23,12)&
   +2D0*r1x2Z*(VS0(12,12)-ExZpE*VS1(12,12))&
   +HfxZpE*VS1(23,5)
VS0(39,13)=PAy*VS0(23,13)+WPy*VS1(23,13)&
   +2D0*r1x2Z*(VS0(12,13)-ExZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(23,6)
VS0(39,14)=PAy*VS0(23,14)+WPy*VS1(23,14)&
   +2D0*r1x2Z*(VS0(12,14)-ExZpE*VS1(12,14))&
   +3D0*HfxZpE*VS1(23,7)
VS0(39,15)=PAy*VS0(23,15)+WPy*VS1(23,15)&
   +2D0*r1x2Z*(VS0(12,15)-ExZpE*VS1(12,15))
VS0(39,16)=PAy*VS0(23,16)+WPy*VS1(23,16)&
   +2D0*r1x2Z*(VS0(12,16)-ExZpE*VS1(12,16))&
   +HfxZpE*VS1(23,8)
VS0(39,17)=PAy*VS0(23,17)+WPy*VS1(23,17)&
   +2D0*r1x2Z*(VS0(12,17)-ExZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(23,9)
VS0(39,18)=PAy*VS0(23,18)+WPy*VS1(23,18)&
   +2D0*r1x2Z*(VS0(12,18)-ExZpE*VS1(12,18))
VS0(39,19)=PAy*VS0(23,19)+WPy*VS1(23,19)&
   +2D0*r1x2Z*(VS0(12,19)-ExZpE*VS1(12,19))&
   +HfxZpE*VS1(23,10)
VS0(39,20)=PAy*VS0(23,20)+WPy*VS1(23,20)&
   +2D0*r1x2Z*(VS0(12,20)-ExZpE*VS1(12,20))
VS0(40,11)=PAy*VS0(24,11)+WPy*VS1(24,11)&
   +3D0*r1x2Z*(VS0(13,11)-ExZpE*VS1(13,11))
VS0(40,12)=PAy*VS0(24,12)+WPy*VS1(24,12)&
   +3D0*r1x2Z*(VS0(13,12)-ExZpE*VS1(13,12))&
   +HfxZpE*VS1(24,5)
VS0(40,13)=PAy*VS0(24,13)+WPy*VS1(24,13)&
   +3D0*r1x2Z*(VS0(13,13)-ExZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(24,6)
VS0(40,14)=PAy*VS0(24,14)+WPy*VS1(24,14)&
   +3D0*r1x2Z*(VS0(13,14)-ExZpE*VS1(13,14))&
   +3D0*HfxZpE*VS1(24,7)
VS0(40,15)=PAy*VS0(24,15)+WPy*VS1(24,15)&
   +3D0*r1x2Z*(VS0(13,15)-ExZpE*VS1(13,15))
VS0(40,16)=PAy*VS0(24,16)+WPy*VS1(24,16)&
   +3D0*r1x2Z*(VS0(13,16)-ExZpE*VS1(13,16))&
   +HfxZpE*VS1(24,8)
VS0(40,17)=PAy*VS0(24,17)+WPy*VS1(24,17)&
   +3D0*r1x2Z*(VS0(13,17)-ExZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(24,9)
VS0(40,18)=PAy*VS0(24,18)+WPy*VS1(24,18)&
   +3D0*r1x2Z*(VS0(13,18)-ExZpE*VS1(13,18))
VS0(40,19)=PAy*VS0(24,19)+WPy*VS1(24,19)&
   +3D0*r1x2Z*(VS0(13,19)-ExZpE*VS1(13,19))&
   +HfxZpE*VS1(24,10)
VS0(40,20)=PAy*VS0(24,20)+WPy*VS1(24,20)&
   +3D0*r1x2Z*(VS0(13,20)-ExZpE*VS1(13,20))
VS0(41,11)=PAy*VS0(25,11)+WPy*VS1(25,11)&
   +4D0*r1x2Z*(VS0(14,11)-ExZpE*VS1(14,11))
VS0(41,12)=PAy*VS0(25,12)+WPy*VS1(25,12)&
   +4D0*r1x2Z*(VS0(14,12)-ExZpE*VS1(14,12))&
   +HfxZpE*VS1(25,5)
VS0(41,13)=PAy*VS0(25,13)+WPy*VS1(25,13)&
   +4D0*r1x2Z*(VS0(14,13)-ExZpE*VS1(14,13))&
   +2D0*HfxZpE*VS1(25,6)
VS0(41,14)=PAy*VS0(25,14)+WPy*VS1(25,14)&
   +4D0*r1x2Z*(VS0(14,14)-ExZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(25,7)
VS0(41,15)=PAy*VS0(25,15)+WPy*VS1(25,15)&
   +4D0*r1x2Z*(VS0(14,15)-ExZpE*VS1(14,15))
VS0(41,16)=PAy*VS0(25,16)+WPy*VS1(25,16)&
   +4D0*r1x2Z*(VS0(14,16)-ExZpE*VS1(14,16))&
   +HfxZpE*VS1(25,8)
VS0(41,17)=PAy*VS0(25,17)+WPy*VS1(25,17)&
   +4D0*r1x2Z*(VS0(14,17)-ExZpE*VS1(14,17))&
   +2D0*HfxZpE*VS1(25,9)
VS0(41,18)=PAy*VS0(25,18)+WPy*VS1(25,18)&
   +4D0*r1x2Z*(VS0(14,18)-ExZpE*VS1(14,18))
VS0(41,19)=PAy*VS0(25,19)+WPy*VS1(25,19)&
   +4D0*r1x2Z*(VS0(14,19)-ExZpE*VS1(14,19))&
   +HfxZpE*VS1(25,10)
VS0(41,20)=PAy*VS0(25,20)+WPy*VS1(25,20)&
   +4D0*r1x2Z*(VS0(14,20)-ExZpE*VS1(14,20))
VS0(42,11)=PAx*VS0(26,11)+WPx*VS1(26,11)&
   +3D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))&
   +3D0*HfxZpE*VS1(26,5)
VS0(42,12)=PAx*VS0(26,12)+WPx*VS1(26,12)&
   +3D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(26,6)
VS0(42,13)=PAx*VS0(26,13)+WPx*VS1(26,13)&
   +3D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))&
   +HfxZpE*VS1(26,7)
VS0(42,14)=PAx*VS0(26,14)+WPx*VS1(26,14)&
   +3D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(42,15)=PAx*VS0(26,15)+WPx*VS1(26,15)&
   +3D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(26,8)
VS0(42,16)=PAx*VS0(26,16)+WPx*VS1(26,16)&
   +3D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(26,9)
VS0(42,17)=PAx*VS0(26,17)+WPx*VS1(26,17)&
   +3D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))
VS0(42,18)=PAx*VS0(26,18)+WPx*VS1(26,18)&
   +3D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +HfxZpE*VS1(26,10)
VS0(42,19)=PAx*VS0(26,19)+WPx*VS1(26,19)&
   +3D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))
VS0(42,20)=PAx*VS0(26,20)+WPx*VS1(26,20)&
   +3D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))
VS0(43,11)=PAx*VS0(27,11)+WPx*VS1(27,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))&
   +3D0*HfxZpE*VS1(27,5)
VS0(43,12)=PAx*VS0(27,12)+WPx*VS1(27,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +2D0*HfxZpE*VS1(27,6)
VS0(43,13)=PAx*VS0(27,13)+WPx*VS1(27,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +HfxZpE*VS1(27,7)
VS0(43,14)=PAx*VS0(27,14)+WPx*VS1(27,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(43,15)=PAx*VS0(27,15)+WPx*VS1(27,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +2D0*HfxZpE*VS1(27,8)
VS0(43,16)=PAx*VS0(27,16)+WPx*VS1(27,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(27,9)
VS0(43,17)=PAx*VS0(27,17)+WPx*VS1(27,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))
VS0(43,18)=PAx*VS0(27,18)+WPx*VS1(27,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +HfxZpE*VS1(27,10)
VS0(43,19)=PAx*VS0(27,19)+WPx*VS1(27,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))
VS0(43,20)=PAx*VS0(27,20)+WPx*VS1(27,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(44,11)=PAx*VS0(28,11)+WPx*VS1(28,11)&
   +r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))&
   +3D0*HfxZpE*VS1(28,5)
VS0(44,12)=PAx*VS0(28,12)+WPx*VS1(28,12)&
   +r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(28,6)
VS0(44,13)=PAx*VS0(28,13)+WPx*VS1(28,13)&
   +r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +HfxZpE*VS1(28,7)
VS0(44,14)=PAx*VS0(28,14)+WPx*VS1(28,14)&
   +r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(44,15)=PAx*VS0(28,15)+WPx*VS1(28,15)&
   +r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +2D0*HfxZpE*VS1(28,8)
VS0(44,16)=PAx*VS0(28,16)+WPx*VS1(28,16)&
   +r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(28,9)
VS0(44,17)=PAx*VS0(28,17)+WPx*VS1(28,17)&
   +r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))
VS0(44,18)=PAx*VS0(28,18)+WPx*VS1(28,18)&
   +r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +HfxZpE*VS1(28,10)
VS0(44,19)=PAx*VS0(28,19)+WPx*VS1(28,19)&
   +r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))
VS0(44,20)=PAx*VS0(28,20)+WPx*VS1(28,20)&
   +r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(45,11)=PAy*VS0(28,11)+WPy*VS1(28,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(45,12)=PAy*VS0(28,12)+WPy*VS1(28,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))&
   +HfxZpE*VS1(28,5)
VS0(45,13)=PAy*VS0(28,13)+WPy*VS1(28,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))&
   +2D0*HfxZpE*VS1(28,6)
VS0(45,14)=PAy*VS0(28,14)+WPy*VS1(28,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))&
   +3D0*HfxZpE*VS1(28,7)
VS0(45,15)=PAy*VS0(28,15)+WPy*VS1(28,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))
VS0(45,16)=PAy*VS0(28,16)+WPy*VS1(28,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(28,8)
VS0(45,17)=PAy*VS0(28,17)+WPy*VS1(28,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +2D0*HfxZpE*VS1(28,9)
VS0(45,18)=PAy*VS0(28,18)+WPy*VS1(28,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))
VS0(45,19)=PAy*VS0(28,19)+WPy*VS1(28,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +HfxZpE*VS1(28,10)
VS0(45,20)=PAy*VS0(28,20)+WPy*VS1(28,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))
VS0(46,11)=PAy*VS0(29,11)+WPy*VS1(29,11)&
   +3D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(46,12)=PAy*VS0(29,12)+WPy*VS1(29,12)&
   +3D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))&
   +HfxZpE*VS1(29,5)
VS0(46,13)=PAy*VS0(29,13)+WPy*VS1(29,13)&
   +3D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(29,6)
VS0(46,14)=PAy*VS0(29,14)+WPy*VS1(29,14)&
   +3D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))&
   +3D0*HfxZpE*VS1(29,7)
VS0(46,15)=PAy*VS0(29,15)+WPy*VS1(29,15)&
   +3D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))
VS0(46,16)=PAy*VS0(29,16)+WPy*VS1(29,16)&
   +3D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(29,8)
VS0(46,17)=PAy*VS0(29,17)+WPy*VS1(29,17)&
   +3D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(29,9)
VS0(46,18)=PAy*VS0(29,18)+WPy*VS1(29,18)&
   +3D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))
VS0(46,19)=PAy*VS0(29,19)+WPy*VS1(29,19)&
   +3D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +HfxZpE*VS1(29,10)
VS0(46,20)=PAy*VS0(29,20)+WPy*VS1(29,20)&
   +3D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))
VS0(47,11)=PAx*VS0(30,11)+WPx*VS1(30,11)&
   +2D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))&
   +3D0*HfxZpE*VS1(30,5)
VS0(47,12)=PAx*VS0(30,12)+WPx*VS1(30,12)&
   +2D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +2D0*HfxZpE*VS1(30,6)
VS0(47,13)=PAx*VS0(30,13)+WPx*VS1(30,13)&
   +2D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +HfxZpE*VS1(30,7)
VS0(47,14)=PAx*VS0(30,14)+WPx*VS1(30,14)&
   +2D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(47,15)=PAx*VS0(30,15)+WPx*VS1(30,15)&
   +2D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(30,8)
VS0(47,16)=PAx*VS0(30,16)+WPx*VS1(30,16)&
   +2D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(30,9)
VS0(47,17)=PAx*VS0(30,17)+WPx*VS1(30,17)&
   +2D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))
VS0(47,18)=PAx*VS0(30,18)+WPx*VS1(30,18)&
   +2D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +HfxZpE*VS1(30,10)
VS0(47,19)=PAx*VS0(30,19)+WPx*VS1(30,19)&
   +2D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))
VS0(47,20)=PAx*VS0(30,20)+WPx*VS1(30,20)&
   +2D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(48,11)=PAx*VS0(31,11)+WPx*VS1(31,11)&
   +r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))&
   +3D0*HfxZpE*VS1(31,5)
VS0(48,12)=PAx*VS0(31,12)+WPx*VS1(31,12)&
   +r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +2D0*HfxZpE*VS1(31,6)
VS0(48,13)=PAx*VS0(31,13)+WPx*VS1(31,13)&
   +r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +HfxZpE*VS1(31,7)
VS0(48,14)=PAx*VS0(31,14)+WPx*VS1(31,14)&
   +r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(48,15)=PAx*VS0(31,15)+WPx*VS1(31,15)&
   +r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(31,8)
VS0(48,16)=PAx*VS0(31,16)+WPx*VS1(31,16)&
   +r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(31,9)
VS0(48,17)=PAx*VS0(31,17)+WPx*VS1(31,17)&
   +r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))
VS0(48,18)=PAx*VS0(31,18)+WPx*VS1(31,18)&
   +r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +HfxZpE*VS1(31,10)
VS0(48,19)=PAx*VS0(31,19)+WPx*VS1(31,19)&
   +r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))
VS0(48,20)=PAx*VS0(31,20)+WPx*VS1(31,20)&
   +r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(49,11)=PAy*VS0(31,11)+WPy*VS1(31,11)&
   +r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(49,12)=PAy*VS0(31,12)+WPy*VS1(31,12)&
   +r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))&
   +HfxZpE*VS1(31,5)
VS0(49,13)=PAy*VS0(31,13)+WPy*VS1(31,13)&
   +r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))&
   +2D0*HfxZpE*VS1(31,6)
VS0(49,14)=PAy*VS0(31,14)+WPy*VS1(31,14)&
   +r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))&
   +3D0*HfxZpE*VS1(31,7)
VS0(49,15)=PAy*VS0(31,15)+WPy*VS1(31,15)&
   +r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))
VS0(49,16)=PAy*VS0(31,16)+WPy*VS1(31,16)&
   +r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(31,8)
VS0(49,17)=PAy*VS0(31,17)+WPy*VS1(31,17)&
   +r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(31,9)
VS0(49,18)=PAy*VS0(31,18)+WPy*VS1(31,18)&
   +r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))
VS0(49,19)=PAy*VS0(31,19)+WPy*VS1(31,19)&
   +r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +HfxZpE*VS1(31,10)
VS0(49,20)=PAy*VS0(31,20)+WPy*VS1(31,20)&
   +r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))
VS0(50,11)=PAy*VS0(32,11)+WPy*VS1(32,11)&
   +2D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(50,12)=PAy*VS0(32,12)+WPy*VS1(32,12)&
   +2D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))&
   +HfxZpE*VS1(32,5)
VS0(50,13)=PAy*VS0(32,13)+WPy*VS1(32,13)&
   +2D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))&
   +2D0*HfxZpE*VS1(32,6)
VS0(50,14)=PAy*VS0(32,14)+WPy*VS1(32,14)&
   +2D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))&
   +3D0*HfxZpE*VS1(32,7)
VS0(50,15)=PAy*VS0(32,15)+WPy*VS1(32,15)&
   +2D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))
VS0(50,16)=PAy*VS0(32,16)+WPy*VS1(32,16)&
   +2D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(32,8)
VS0(50,17)=PAy*VS0(32,17)+WPy*VS1(32,17)&
   +2D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(32,9)
VS0(50,18)=PAy*VS0(32,18)+WPy*VS1(32,18)&
   +2D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))
VS0(50,19)=PAy*VS0(32,19)+WPy*VS1(32,19)&
   +2D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +HfxZpE*VS1(32,10)
VS0(50,20)=PAy*VS0(32,20)+WPy*VS1(32,20)&
   +2D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))
VS0(51,11)=PAz*VS0(30,11)+WPz*VS1(30,11)+r1x2Z*VR1(30,11)&
   +2D0*r1x2Z*(VS0(15,11)-ExZpE*VS1(15,11))
VS0(51,12)=PAz*VS0(30,12)+WPz*VS1(30,12)+r1x2Z*VR1(30,12)&
   +2D0*r1x2Z*(VS0(15,12)-ExZpE*VS1(15,12))
VS0(51,13)=PAz*VS0(30,13)+WPz*VS1(30,13)+r1x2Z*VR1(30,13)&
   +2D0*r1x2Z*(VS0(15,13)-ExZpE*VS1(15,13))
VS0(51,14)=PAz*VS0(30,14)+WPz*VS1(30,14)+r1x2Z*VR1(30,14)&
   +2D0*r1x2Z*(VS0(15,14)-ExZpE*VS1(15,14))
VS0(51,15)=PAz*VS0(30,15)+WPz*VS1(30,15)+r1x2Z*VR1(30,15)&
   +2D0*r1x2Z*(VS0(15,15)-ExZpE*VS1(15,15))&
   +HfxZpE*VS1(30,5)
VS0(51,16)=PAz*VS0(30,16)+WPz*VS1(30,16)+r1x2Z*VR1(30,16)&
   +2D0*r1x2Z*(VS0(15,16)-ExZpE*VS1(15,16))&
   +HfxZpE*VS1(30,6)
VS0(51,17)=PAz*VS0(30,17)+WPz*VS1(30,17)+r1x2Z*VR1(30,17)&
   +2D0*r1x2Z*(VS0(15,17)-ExZpE*VS1(15,17))&
   +HfxZpE*VS1(30,7)
VS0(51,18)=PAz*VS0(30,18)+WPz*VS1(30,18)+r1x2Z*VR1(30,18)&
   +2D0*r1x2Z*(VS0(15,18)-ExZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(30,8)
VS0(51,19)=PAz*VS0(30,19)+WPz*VS1(30,19)+r1x2Z*VR1(30,19)&
   +2D0*r1x2Z*(VS0(15,19)-ExZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(30,9)
VS0(51,20)=PAz*VS0(30,20)+WPz*VS1(30,20)+r1x2Z*VR1(30,20)&
   +2D0*r1x2Z*(VS0(15,20)-ExZpE*VS1(15,20))&
   +3D0*HfxZpE*VS1(30,10)
VS0(52,11)=PAz*VS0(31,11)+WPz*VS1(31,11)+r1x2Z*VR1(31,11)&
   +2D0*r1x2Z*(VS0(16,11)-ExZpE*VS1(16,11))
VS0(52,12)=PAz*VS0(31,12)+WPz*VS1(31,12)+r1x2Z*VR1(31,12)&
   +2D0*r1x2Z*(VS0(16,12)-ExZpE*VS1(16,12))
VS0(52,13)=PAz*VS0(31,13)+WPz*VS1(31,13)+r1x2Z*VR1(31,13)&
   +2D0*r1x2Z*(VS0(16,13)-ExZpE*VS1(16,13))
VS0(52,14)=PAz*VS0(31,14)+WPz*VS1(31,14)+r1x2Z*VR1(31,14)&
   +2D0*r1x2Z*(VS0(16,14)-ExZpE*VS1(16,14))
VS0(52,15)=PAz*VS0(31,15)+WPz*VS1(31,15)+r1x2Z*VR1(31,15)&
   +2D0*r1x2Z*(VS0(16,15)-ExZpE*VS1(16,15))&
   +HfxZpE*VS1(31,5)
VS0(52,16)=PAz*VS0(31,16)+WPz*VS1(31,16)+r1x2Z*VR1(31,16)&
   +2D0*r1x2Z*(VS0(16,16)-ExZpE*VS1(16,16))&
   +HfxZpE*VS1(31,6)
VS0(52,17)=PAz*VS0(31,17)+WPz*VS1(31,17)+r1x2Z*VR1(31,17)&
   +2D0*r1x2Z*(VS0(16,17)-ExZpE*VS1(16,17))&
   +HfxZpE*VS1(31,7)
VS0(52,18)=PAz*VS0(31,18)+WPz*VS1(31,18)+r1x2Z*VR1(31,18)&
   +2D0*r1x2Z*(VS0(16,18)-ExZpE*VS1(16,18))&
   +2D0*HfxZpE*VS1(31,8)
VS0(52,19)=PAz*VS0(31,19)+WPz*VS1(31,19)+r1x2Z*VR1(31,19)&
   +2D0*r1x2Z*(VS0(16,19)-ExZpE*VS1(16,19))&
   +2D0*HfxZpE*VS1(31,9)
VS0(52,20)=PAz*VS0(31,20)+WPz*VS1(31,20)+r1x2Z*VR1(31,20)&
   +2D0*r1x2Z*(VS0(16,20)-ExZpE*VS1(16,20))&
   +3D0*HfxZpE*VS1(31,10)
VS0(53,11)=PAz*VS0(32,11)+WPz*VS1(32,11)+r1x2Z*VR1(32,11)&
   +2D0*r1x2Z*(VS0(17,11)-ExZpE*VS1(17,11))
VS0(53,12)=PAz*VS0(32,12)+WPz*VS1(32,12)+r1x2Z*VR1(32,12)&
   +2D0*r1x2Z*(VS0(17,12)-ExZpE*VS1(17,12))
VS0(53,13)=PAz*VS0(32,13)+WPz*VS1(32,13)+r1x2Z*VR1(32,13)&
   +2D0*r1x2Z*(VS0(17,13)-ExZpE*VS1(17,13))
VS0(53,14)=PAz*VS0(32,14)+WPz*VS1(32,14)+r1x2Z*VR1(32,14)&
   +2D0*r1x2Z*(VS0(17,14)-ExZpE*VS1(17,14))
VS0(53,15)=PAz*VS0(32,15)+WPz*VS1(32,15)+r1x2Z*VR1(32,15)&
   +2D0*r1x2Z*(VS0(17,15)-ExZpE*VS1(17,15))&
   +HfxZpE*VS1(32,5)
VS0(53,16)=PAz*VS0(32,16)+WPz*VS1(32,16)+r1x2Z*VR1(32,16)&
   +2D0*r1x2Z*(VS0(17,16)-ExZpE*VS1(17,16))&
   +HfxZpE*VS1(32,6)
VS0(53,17)=PAz*VS0(32,17)+WPz*VS1(32,17)+r1x2Z*VR1(32,17)&
   +2D0*r1x2Z*(VS0(17,17)-ExZpE*VS1(17,17))&
   +HfxZpE*VS1(32,7)
VS0(53,18)=PAz*VS0(32,18)+WPz*VS1(32,18)+r1x2Z*VR1(32,18)&
   +2D0*r1x2Z*(VS0(17,18)-ExZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(32,8)
VS0(53,19)=PAz*VS0(32,19)+WPz*VS1(32,19)+r1x2Z*VR1(32,19)&
   +2D0*r1x2Z*(VS0(17,19)-ExZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(32,9)
VS0(53,20)=PAz*VS0(32,20)+WPz*VS1(32,20)+r1x2Z*VR1(32,20)&
   +2D0*r1x2Z*(VS0(17,20)-ExZpE*VS1(17,20))&
   +3D0*HfxZpE*VS1(32,10)
VS0(54,11)=PAz*VS0(33,11)+WPz*VS1(33,11)+r1x2Z*VR1(33,11)&
   +3D0*r1x2Z*(VS0(18,11)-ExZpE*VS1(18,11))
VS0(54,12)=PAz*VS0(33,12)+WPz*VS1(33,12)+r1x2Z*VR1(33,12)&
   +3D0*r1x2Z*(VS0(18,12)-ExZpE*VS1(18,12))
VS0(54,13)=PAz*VS0(33,13)+WPz*VS1(33,13)+r1x2Z*VR1(33,13)&
   +3D0*r1x2Z*(VS0(18,13)-ExZpE*VS1(18,13))
VS0(54,14)=PAz*VS0(33,14)+WPz*VS1(33,14)+r1x2Z*VR1(33,14)&
   +3D0*r1x2Z*(VS0(18,14)-ExZpE*VS1(18,14))
VS0(54,15)=PAz*VS0(33,15)+WPz*VS1(33,15)+r1x2Z*VR1(33,15)&
   +3D0*r1x2Z*(VS0(18,15)-ExZpE*VS1(18,15))&
   +HfxZpE*VS1(33,5)
VS0(54,16)=PAz*VS0(33,16)+WPz*VS1(33,16)+r1x2Z*VR1(33,16)&
   +3D0*r1x2Z*(VS0(18,16)-ExZpE*VS1(18,16))&
   +HfxZpE*VS1(33,6)
VS0(54,17)=PAz*VS0(33,17)+WPz*VS1(33,17)+r1x2Z*VR1(33,17)&
   +3D0*r1x2Z*(VS0(18,17)-ExZpE*VS1(18,17))&
   +HfxZpE*VS1(33,7)
VS0(54,18)=PAz*VS0(33,18)+WPz*VS1(33,18)+r1x2Z*VR1(33,18)&
   +3D0*r1x2Z*(VS0(18,18)-ExZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(33,8)
VS0(54,19)=PAz*VS0(33,19)+WPz*VS1(33,19)+r1x2Z*VR1(33,19)&
   +3D0*r1x2Z*(VS0(18,19)-ExZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(33,9)
VS0(54,20)=PAz*VS0(33,20)+WPz*VS1(33,20)+r1x2Z*VR1(33,20)&
   +3D0*r1x2Z*(VS0(18,20)-ExZpE*VS1(18,20))&
   +3D0*HfxZpE*VS1(33,10)
VS0(55,11)=PAz*VS0(34,11)+WPz*VS1(34,11)+r1x2Z*VR1(34,11)&
   +3D0*r1x2Z*(VS0(19,11)-ExZpE*VS1(19,11))
VS0(55,12)=PAz*VS0(34,12)+WPz*VS1(34,12)+r1x2Z*VR1(34,12)&
   +3D0*r1x2Z*(VS0(19,12)-ExZpE*VS1(19,12))
VS0(55,13)=PAz*VS0(34,13)+WPz*VS1(34,13)+r1x2Z*VR1(34,13)&
   +3D0*r1x2Z*(VS0(19,13)-ExZpE*VS1(19,13))
VS0(55,14)=PAz*VS0(34,14)+WPz*VS1(34,14)+r1x2Z*VR1(34,14)&
   +3D0*r1x2Z*(VS0(19,14)-ExZpE*VS1(19,14))
VS0(55,15)=PAz*VS0(34,15)+WPz*VS1(34,15)+r1x2Z*VR1(34,15)&
   +3D0*r1x2Z*(VS0(19,15)-ExZpE*VS1(19,15))&
   +HfxZpE*VS1(34,5)
VS0(55,16)=PAz*VS0(34,16)+WPz*VS1(34,16)+r1x2Z*VR1(34,16)&
   +3D0*r1x2Z*(VS0(19,16)-ExZpE*VS1(19,16))&
   +HfxZpE*VS1(34,6)
VS0(55,17)=PAz*VS0(34,17)+WPz*VS1(34,17)+r1x2Z*VR1(34,17)&
   +3D0*r1x2Z*(VS0(19,17)-ExZpE*VS1(19,17))&
   +HfxZpE*VS1(34,7)
VS0(55,18)=PAz*VS0(34,18)+WPz*VS1(34,18)+r1x2Z*VR1(34,18)&
   +3D0*r1x2Z*(VS0(19,18)-ExZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(34,8)
VS0(55,19)=PAz*VS0(34,19)+WPz*VS1(34,19)+r1x2Z*VR1(34,19)&
   +3D0*r1x2Z*(VS0(19,19)-ExZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(34,9)
VS0(55,20)=PAz*VS0(34,20)+WPz*VS1(34,20)+r1x2Z*VR1(34,20)&
   +3D0*r1x2Z*(VS0(19,20)-ExZpE*VS1(19,20))&
   +3D0*HfxZpE*VS1(34,10)
VS0(56,11)=PAz*VS0(35,11)+WPz*VS1(35,11)+r1x2Z*VR1(35,11)&
   +4D0*r1x2Z*(VS0(20,11)-ExZpE*VS1(20,11))
VS0(56,12)=PAz*VS0(35,12)+WPz*VS1(35,12)+r1x2Z*VR1(35,12)&
   +4D0*r1x2Z*(VS0(20,12)-ExZpE*VS1(20,12))
VS0(56,13)=PAz*VS0(35,13)+WPz*VS1(35,13)+r1x2Z*VR1(35,13)&
   +4D0*r1x2Z*(VS0(20,13)-ExZpE*VS1(20,13))
VS0(56,14)=PAz*VS0(35,14)+WPz*VS1(35,14)+r1x2Z*VR1(35,14)&
   +4D0*r1x2Z*(VS0(20,14)-ExZpE*VS1(20,14))
VS0(56,15)=PAz*VS0(35,15)+WPz*VS1(35,15)+r1x2Z*VR1(35,15)&
   +4D0*r1x2Z*(VS0(20,15)-ExZpE*VS1(20,15))&
   +HfxZpE*VS1(35,5)
VS0(56,16)=PAz*VS0(35,16)+WPz*VS1(35,16)+r1x2Z*VR1(35,16)&
   +4D0*r1x2Z*(VS0(20,16)-ExZpE*VS1(20,16))&
   +HfxZpE*VS1(35,6)
VS0(56,17)=PAz*VS0(35,17)+WPz*VS1(35,17)+r1x2Z*VR1(35,17)&
   +4D0*r1x2Z*(VS0(20,17)-ExZpE*VS1(20,17))&
   +HfxZpE*VS1(35,7)
VS0(56,18)=PAz*VS0(35,18)+WPz*VS1(35,18)+r1x2Z*VR1(35,18)&
   +4D0*r1x2Z*(VS0(20,18)-ExZpE*VS1(20,18))&
   +2D0*HfxZpE*VS1(35,8)
VS0(56,19)=PAz*VS0(35,19)+WPz*VS1(35,19)+r1x2Z*VR1(35,19)&
   +4D0*r1x2Z*(VS0(20,19)-ExZpE*VS1(20,19))&
   +2D0*HfxZpE*VS1(35,9)
VS0(56,20)=PAz*VS0(35,20)+WPz*VS1(35,20)+r1x2Z*VR1(35,20)&
   +4D0*r1x2Z*(VS0(20,20)-ExZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(35,10)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRh0f0'
STOP
END SELECT
END SUBROUTINE MVRRh0f0
