!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0d0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(12,5)
      V(2)=ExZpE*r1x2Z*VRR1(12,5)
      V(3)=r1x2Z*VRR0(12,6)
      V(4)=ExZpE*r1x2Z*VRR1(12,6)
      V(5)=r1x2Z*VRR0(12,7)
      V(6)=ExZpE*r1x2Z*VRR1(12,7)
      V(7)=r1x2Z*VRR0(12,8)
      V(8)=ExZpE*r1x2Z*VRR1(12,8)
      V(9)=r1x2Z*VRR0(12,9)
      V(10)=ExZpE*r1x2Z*VRR1(12,9)
      V(11)=r1x2Z*VRR0(12,10)
      V(12)=ExZpE*r1x2Z*VRR1(12,10)
      V(13)=r1x2Z*VRR0(13,5)
      V(14)=ExZpE*r1x2Z*VRR1(13,5)
      V(15)=HfxZpE*VRR1(23,2)
      V(16)=r1x2Z*VRR0(13,6)
      V(17)=ExZpE*r1x2Z*VRR1(13,6)
      V(18)=HfxZpE*VRR1(23,3)
      V(19)=r1x2Z*VRR0(13,7)
      V(20)=ExZpE*r1x2Z*VRR1(13,7)
      V(21)=r1x2Z*VRR0(13,8)
      V(22)=ExZpE*r1x2Z*VRR1(13,8)
      V(23)=HfxZpE*VRR1(23,4)
      V(24)=r1x2Z*VRR0(13,9)
      V(25)=ExZpE*r1x2Z*VRR1(13,9)
      V(26)=r1x2Z*VRR0(13,10)
      V(27)=ExZpE*r1x2Z*VRR1(13,10)
      V(28)=r1x2Z*VRR0(15,5)
      V(29)=ExZpE*r1x2Z*VRR1(15,5)
      V(30)=r1x2Z*VRR0(15,6)
      V(31)=ExZpE*r1x2Z*VRR1(15,6)
      V(32)=r1x2Z*VRR0(15,7)
      V(33)=ExZpE*r1x2Z*VRR1(15,7)
      V(34)=r1x2Z*VRR0(15,8)
      V(35)=ExZpE*r1x2Z*VRR1(15,8)
      V(36)=r1x2Z*VRR0(15,9)
      V(37)=ExZpE*r1x2Z*VRR1(15,9)
      V(38)=r1x2Z*VRR0(15,10)
      V(39)=ExZpE*r1x2Z*VRR1(15,10)
      V(40)=r1x2Z*VRR0(16,5)
      V(41)=2.D0*V(40)
      V(42)=ExZpE*r1x2Z*VRR1(16,5)
      V(43)=-2.D0*V(42)
      V(44)=r1x2Z*VRR0(16,6)
      V(45)=2.D0*V(44)
      V(46)=ExZpE*r1x2Z*VRR1(16,6)
      V(47)=-2.D0*V(46)
      V(48)=HfxZpE*VRR1(27,3)
      V(49)=r1x2Z*VRR0(16,7)
      V(50)=2.D0*V(49)
      V(51)=ExZpE*r1x2Z*VRR1(16,7)
      V(52)=-2.D0*V(51)
      V(53)=r1x2Z*VRR0(16,8)
      V(54)=2.D0*V(53)
      V(55)=ExZpE*r1x2Z*VRR1(16,8)
      V(56)=-2.D0*V(55)
      V(57)=HfxZpE*VRR1(27,4)
      V(58)=r1x2Z*VRR0(16,9)
      V(59)=2.D0*V(58)
      V(60)=ExZpE*r1x2Z*VRR1(16,9)
      V(61)=-2.D0*V(60)
      V(62)=r1x2Z*VRR0(16,10)
      V(63)=2.D0*V(62)
      V(64)=ExZpE*r1x2Z*VRR1(16,10)
      V(65)=-2.D0*V(64)
      V(66)=r1x2E*VRR0(44,1)
      V(67)=HfxZpE*VRR1(28,2)
      V(68)=r1x2E*ZxZpE*VRR1(44,1)
      V(69)=-V(68)
      V(70)=r1x2Z*VRR0(17,6)
      V(71)=ExZpE*r1x2Z*VRR1(17,6)
      V(72)=HfxZpE*VRR1(28,3)
      V(73)=r1x2Z*VRR0(17,8)
      V(74)=ExZpE*r1x2Z*VRR1(17,8)
      V(75)=HfxZpE*VRR1(28,4)
      V(76)=r1x2Z*VRR0(17,9)
      V(77)=ExZpE*r1x2Z*VRR1(17,9)
      V(78)=r1x2Z*VRR0(17,5)
      V(79)=ExZpE*r1x2Z*VRR1(17,5)
      V(80)=r1x2Z*VRR0(17,7)
      V(81)=ExZpE*r1x2Z*VRR1(17,7)
      V(82)=r1x2Z*VRR0(17,10)
      V(83)=ExZpE*r1x2Z*VRR1(17,10)
      V(84)=r1x2Z*VRR0(18,5)
      V(85)=ExZpE*r1x2Z*VRR1(18,5)
      V(86)=HfxZpE*VRR1(30,2)
      V(87)=r1x2Z*VRR0(18,6)
      V(88)=ExZpE*r1x2Z*VRR1(18,6)
      V(89)=HfxZpE*VRR1(30,3)
      V(90)=r1x2Z*VRR0(18,7)
      V(91)=ExZpE*r1x2Z*VRR1(18,7)
      V(92)=r1x2Z*VRR0(18,8)
      V(93)=ExZpE*r1x2Z*VRR1(18,8)
      V(94)=HfxZpE*VRR1(30,4)
      V(95)=r1x2Z*VRR0(18,9)
      V(96)=ExZpE*r1x2Z*VRR1(18,9)
      V(97)=r1x2Z*VRR0(18,10)
      V(98)=ExZpE*r1x2Z*VRR1(18,10)
      V(99)=r1x2E*VRR0(48,1)
      V(100)=HfxZpE*VRR1(31,2)
      V(101)=r1x2E*ZxZpE*VRR1(48,1)
      V(102)=-V(101)
      V(103)=r1x2Z*VRR0(19,6)
      V(104)=ExZpE*r1x2Z*VRR1(19,6)
      V(105)=HfxZpE*VRR1(31,3)
      V(106)=r1x2Z*VRR0(19,8)
      V(107)=ExZpE*r1x2Z*VRR1(19,8)
      V(108)=HfxZpE*VRR1(31,4)
      V(109)=r1x2Z*VRR0(19,9)
      V(110)=ExZpE*r1x2Z*VRR1(19,9)
      V(111)=r1x2E*VRR0(49,1)
      V(112)=HfxZpE*VRR1(32,2)
      V(113)=r1x2E*ZxZpE*VRR1(49,1)
      V(114)=-V(113)
      V(115)=r1x2Z*VRR0(19,5)
      V(116)=ExZpE*r1x2Z*VRR1(19,5)
      V(117)=r1x2Z*VRR0(19,7)
      V(118)=ExZpE*r1x2Z*VRR1(19,7)
      V(119)=HfxZpE*VRR1(32,3)
      V(120)=HfxZpE*VRR1(32,4)
      V(121)=r1x2Z*VRR0(19,10)
      V(122)=ExZpE*r1x2Z*VRR1(19,10)
      VRR0(36,5)=4.D0*r1x2Z*VRR0(11,5)+PAx*VRR0(21,5)-4.D0*ExZpE*r1x2Z*VRR1(11,5)+2.D0*HfxZpE*VRR1(21,2)+WPx*VRR1(21,5)
      VRR0(36,6)=4.D0*r1x2Z*VRR0(11,6)+PAx*VRR0(21,6)-4.D0*ExZpE*r1x2Z*VRR1(11,6)+HfxZpE*VRR1(21,3)+WPx*VRR1(21,6)
      VRR0(36,7)=4.D0*r1x2Z*VRR0(11,7)+PAx*VRR0(21,7)-4.D0*ExZpE*r1x2Z*VRR1(11,7)+WPx*VRR1(21,7)
      VRR0(36,8)=4.D0*r1x2Z*VRR0(11,8)+PAx*VRR0(21,8)-4.D0*ExZpE*r1x2Z*VRR1(11,8)+HfxZpE*VRR1(21,4)+WPx*VRR1(21,8)
      VRR0(36,9)=4.D0*r1x2Z*VRR0(11,9)+PAx*VRR0(21,9)-4.D0*ExZpE*r1x2Z*VRR1(11,9)+WPx*VRR1(21,9)
      VRR0(36,10)=4.D0*r1x2Z*VRR0(11,10)+PAx*VRR0(21,10)-4.D0*ExZpE*r1x2Z*VRR1(11,10)+WPx*VRR1(21,10)
      VRR0(37,5)=3.D0*V(1)-3.D0*V(2)+PAx*VRR0(22,5)+2.D0*HfxZpE*VRR1(22,2)+WPx*VRR1(22,5)
      VRR0(37,6)=3.D0*V(3)-3.D0*V(4)+PAx*VRR0(22,6)+HfxZpE*VRR1(22,3)+WPx*VRR1(22,6)
      VRR0(37,7)=3.D0*V(5)-3.D0*V(6)+PAx*VRR0(22,7)+WPx*VRR1(22,7)
      VRR0(37,8)=3.D0*V(7)-3.D0*V(8)+PAx*VRR0(22,8)+HfxZpE*VRR1(22,4)+WPx*VRR1(22,8)
      VRR0(37,9)=3.D0*V(9)-3.D0*V(10)+PAx*VRR0(22,9)+WPx*VRR1(22,9)
      VRR0(37,10)=3.D0*V(11)-3.D0*V(12)+PAx*VRR0(22,10)+WPx*VRR1(22,10)
      VRR0(38,5)=2.D0*V(13)-2.D0*V(14)+2.D0*V(15)+PAx*VRR0(23,5)+WPx*VRR1(23,5)
      VRR0(38,6)=2.D0*V(16)-2.D0*V(17)+V(18)+PAx*VRR0(23,6)+WPx*VRR1(23,6)
      VRR0(38,7)=2.D0*V(19)-2.D0*V(20)+PAx*VRR0(23,7)+WPx*VRR1(23,7)
      VRR0(38,8)=2.D0*V(21)-2.D0*V(22)+V(23)+PAx*VRR0(23,8)+WPx*VRR1(23,8)
      VRR0(38,9)=2.D0*V(24)-2.D0*V(25)+PAx*VRR0(23,9)+WPx*VRR1(23,9)
      VRR0(38,10)=2.D0*V(26)-2.D0*V(27)+PAx*VRR0(23,10)+WPx*VRR1(23,10)
      VRR0(39,5)=2.D0*V(1)-2.D0*V(2)+PAy*VRR0(23,5)+WPy*VRR1(23,5)
      VRR0(39,6)=2.D0*V(3)-2.D0*V(4)+V(15)+PAy*VRR0(23,6)+WPy*VRR1(23,6)
      VRR0(39,7)=2.D0*V(5)-2.D0*V(6)+2.D0*V(18)+PAy*VRR0(23,7)+WPy*VRR1(23,7)
      VRR0(39,8)=2.D0*V(7)-2.D0*V(8)+PAy*VRR0(23,8)+WPy*VRR1(23,8)
      VRR0(39,9)=2.D0*V(9)-2.D0*V(10)+V(23)+PAy*VRR0(23,9)+WPy*VRR1(23,9)
      VRR0(39,10)=2.D0*V(11)-2.D0*V(12)+PAy*VRR0(23,10)+WPy*VRR1(23,10)
      VRR0(40,5)=3.D0*V(13)-3.D0*V(14)+PAy*VRR0(24,5)+WPy*VRR1(24,5)
      VRR0(40,6)=3.D0*V(16)-3.D0*V(17)+PAy*VRR0(24,6)+HfxZpE*VRR1(24,2)+WPy*VRR1(24,6)
      VRR0(40,7)=3.D0*V(19)-3.D0*V(20)+PAy*VRR0(24,7)+2.D0*HfxZpE*VRR1(24,3)+WPy*VRR1(24,7)
      VRR0(40,8)=3.D0*V(21)-3.D0*V(22)+PAy*VRR0(24,8)+WPy*VRR1(24,8)
      VRR0(40,9)=3.D0*V(24)-3.D0*V(25)+PAy*VRR0(24,9)+HfxZpE*VRR1(24,4)+WPy*VRR1(24,9)
      VRR0(40,10)=3.D0*V(26)-3.D0*V(27)+PAy*VRR0(24,10)+WPy*VRR1(24,10)
      VRR0(41,5)=4.D0*r1x2Z*VRR0(14,5)+PAy*VRR0(25,5)-4.D0*ExZpE*r1x2Z*VRR1(14,5)+WPy*VRR1(25,5)
      VRR0(41,6)=4.D0*r1x2Z*VRR0(14,6)+PAy*VRR0(25,6)-4.D0*ExZpE*r1x2Z*VRR1(14,6)+HfxZpE*VRR1(25,2)+WPy*VRR1(25,6)
      VRR0(41,7)=4.D0*r1x2Z*VRR0(14,7)+PAy*VRR0(25,7)-4.D0*ExZpE*r1x2Z*VRR1(14,7)+2.D0*HfxZpE*VRR1(25,3)+WPy*VRR1(25,7)
      VRR0(41,8)=4.D0*r1x2Z*VRR0(14,8)+PAy*VRR0(25,8)-4.D0*ExZpE*r1x2Z*VRR1(14,8)+WPy*VRR1(25,8)
      VRR0(41,9)=4.D0*r1x2Z*VRR0(14,9)+PAy*VRR0(25,9)-4.D0*ExZpE*r1x2Z*VRR1(14,9)+HfxZpE*VRR1(25,4)+WPy*VRR1(25,9)
      VRR0(41,10)=4.D0*r1x2Z*VRR0(14,10)+PAy*VRR0(25,10)-4.D0*ExZpE*r1x2Z*VRR1(14,10)+WPy*VRR1(25,10)
      VRR0(42,5)=3.D0*V(28)-3.D0*V(29)+PAx*VRR0(26,5)+2.D0*HfxZpE*VRR1(26,2)+WPx*VRR1(26,5)
      VRR0(42,6)=3.D0*V(30)-3.D0*V(31)+PAx*VRR0(26,6)+HfxZpE*VRR1(26,3)+WPx*VRR1(26,6)
      VRR0(42,7)=3.D0*V(32)-3.D0*V(33)+PAx*VRR0(26,7)+WPx*VRR1(26,7)
      VRR0(42,8)=3.D0*V(34)-3.D0*V(35)+PAx*VRR0(26,8)+HfxZpE*VRR1(26,4)+WPx*VRR1(26,8)
      VRR0(42,9)=3.D0*V(36)-3.D0*V(37)+PAx*VRR0(26,9)+WPx*VRR1(26,9)
      VRR0(42,10)=3.D0*V(38)-3.D0*V(39)+PAx*VRR0(26,10)+WPx*VRR1(26,10)
      VRR0(43,5)=V(41)+V(43)+PAx*VRR0(27,5)+2.D0*HfxZpE*VRR1(27,2)+WPx*VRR1(27,5)
      VRR0(43,6)=V(45)+V(47)+V(48)+PAx*VRR0(27,6)+WPx*VRR1(27,6)
      VRR0(43,7)=V(50)+V(52)+PAx*VRR0(27,7)+WPx*VRR1(27,7)
      VRR0(43,8)=V(54)+V(56)+V(57)+PAx*VRR0(27,8)+WPx*VRR1(27,8)
      VRR0(43,9)=V(59)+V(61)+PAx*VRR0(27,9)+WPx*VRR1(27,9)
      VRR0(43,10)=V(63)+V(65)+PAx*VRR0(27,10)+WPx*VRR1(27,10)
      VRR0(44,5)=V(66)+2.D0*V(67)+V(69)+QCx*VRR0(44,2)+WQx*VRR1(44,2)
      VRR0(44,6)=V(70)-V(71)+V(72)+PAx*VRR0(28,6)+WPx*VRR1(28,6)
      VRR0(44,7)=2.D0*V(48)+V(66)+V(69)+QCy*VRR0(44,3)+WQy*VRR1(44,3)
      VRR0(44,8)=V(73)-V(74)+V(75)+PAx*VRR0(28,8)+WPx*VRR1(28,8)
      VRR0(44,9)=V(76)-V(77)+PAx*VRR0(28,9)+WPx*VRR1(28,9)
      VRR0(44,10)=V(23)+V(66)+V(69)+QCz*VRR0(44,4)+WQz*VRR1(44,4)
      VRR0(45,5)=V(41)+V(43)+PAy*VRR0(28,5)+WPy*VRR1(28,5)
      VRR0(45,6)=V(45)+V(47)+V(67)+PAy*VRR0(28,6)+WPy*VRR1(28,6)
      VRR0(45,7)=V(50)+V(52)+2.D0*V(72)+PAy*VRR0(28,7)+WPy*VRR1(28,7)
      VRR0(45,8)=V(54)+V(56)+PAy*VRR0(28,8)+WPy*VRR1(28,8)
      VRR0(45,9)=V(59)+V(61)+V(75)+PAy*VRR0(28,9)+WPy*VRR1(28,9)
      VRR0(45,10)=V(63)+V(65)+PAy*VRR0(28,10)+WPy*VRR1(28,10)
      VRR0(46,5)=3.D0*V(78)-3.D0*V(79)+PAy*VRR0(29,5)+WPy*VRR1(29,5)
      VRR0(46,6)=3.D0*V(70)-3.D0*V(71)+PAy*VRR0(29,6)+HfxZpE*VRR1(29,2)+WPy*VRR1(29,6)
      VRR0(46,7)=3.D0*V(80)-3.D0*V(81)+PAy*VRR0(29,7)+2.D0*HfxZpE*VRR1(29,3)+WPy*VRR1(29,7)
      VRR0(46,8)=3.D0*V(73)-3.D0*V(74)+PAy*VRR0(29,8)+WPy*VRR1(29,8)
      VRR0(46,9)=3.D0*V(76)-3.D0*V(77)+PAy*VRR0(29,9)+HfxZpE*VRR1(29,4)+WPy*VRR1(29,9)
      VRR0(46,10)=3.D0*V(82)-3.D0*V(83)+PAy*VRR0(29,10)+WPy*VRR1(29,10)
      VRR0(47,5)=2.D0*V(84)-2.D0*V(85)+2.D0*V(86)+PAx*VRR0(30,5)+WPx*VRR1(30,5)
      VRR0(47,6)=2.D0*V(87)-2.D0*V(88)+V(89)+PAx*VRR0(30,6)+WPx*VRR1(30,6)
      VRR0(47,7)=2.D0*V(90)-2.D0*V(91)+PAx*VRR0(30,7)+WPx*VRR1(30,7)
      VRR0(47,8)=2.D0*V(92)-2.D0*V(93)+V(94)+PAx*VRR0(30,8)+WPx*VRR1(30,8)
      VRR0(47,9)=2.D0*V(95)-2.D0*V(96)+PAx*VRR0(30,9)+WPx*VRR1(30,9)
      VRR0(47,10)=2.D0*V(97)-2.D0*V(98)+PAx*VRR0(30,10)+WPx*VRR1(30,10)
      VRR0(48,5)=V(99)+2.D0*V(100)+V(102)+QCx*VRR0(48,2)+WQx*VRR1(48,2)
      VRR0(48,6)=V(103)-V(104)+V(105)+PAx*VRR0(31,6)+WPx*VRR1(31,6)
      VRR0(48,7)=V(89)+V(99)+V(102)+QCy*VRR0(48,3)+WQy*VRR1(48,3)
      VRR0(48,8)=V(106)-V(107)+V(108)+PAx*VRR0(31,8)+WPx*VRR1(31,8)
      VRR0(48,9)=V(109)-V(110)+PAx*VRR0(31,9)+WPx*VRR1(31,9)
      VRR0(48,10)=2.D0*V(57)+V(99)+V(102)+QCz*VRR0(48,4)+WQz*VRR1(48,4)
      VRR0(49,5)=V(111)+V(112)+V(114)+QCx*VRR0(49,2)+WQx*VRR1(49,2)
      VRR0(49,6)=V(87)-V(88)+V(100)+PAy*VRR0(31,6)+WPy*VRR1(31,6)
      VRR0(49,7)=2.D0*V(105)+V(111)+V(114)+QCy*VRR0(49,3)+WQy*VRR1(49,3)
      VRR0(49,8)=V(92)-V(93)+PAy*VRR0(31,8)+WPy*VRR1(31,8)
      VRR0(49,9)=V(95)-V(96)+V(108)+PAy*VRR0(31,9)+WPy*VRR1(31,9)
      VRR0(49,10)=2.D0*V(75)+V(111)+V(114)+QCz*VRR0(49,4)+WQz*VRR1(49,4)
      VRR0(50,5)=2.D0*V(115)-2.D0*V(116)+PAy*VRR0(32,5)+WPy*VRR1(32,5)
      VRR0(50,6)=2.D0*V(103)-2.D0*V(104)+V(112)+PAy*VRR0(32,6)+WPy*VRR1(32,6)
      VRR0(50,7)=2.D0*V(117)-2.D0*V(118)+2.D0*V(119)+PAy*VRR0(32,7)+WPy*VRR1(32,7)
      VRR0(50,8)=2.D0*V(106)-2.D0*V(107)+PAy*VRR0(32,8)+WPy*VRR1(32,8)
      VRR0(50,9)=2.D0*V(109)-2.D0*V(110)+V(120)+PAy*VRR0(32,9)+WPy*VRR1(32,9)
      VRR0(50,10)=2.D0*V(121)-2.D0*V(122)+PAy*VRR0(32,10)+WPy*VRR1(32,10)
      VRR0(51,5)=2.D0*V(28)-2.D0*V(29)+PAz*VRR0(30,5)+WPz*VRR1(30,5)
      VRR0(51,6)=2.D0*V(30)-2.D0*V(31)+PAz*VRR0(30,6)+WPz*VRR1(30,6)
      VRR0(51,7)=2.D0*V(32)-2.D0*V(33)+PAz*VRR0(30,7)+WPz*VRR1(30,7)
      VRR0(51,8)=2.D0*V(34)-2.D0*V(35)+V(86)+PAz*VRR0(30,8)+WPz*VRR1(30,8)
      VRR0(51,9)=2.D0*V(36)-2.D0*V(37)+V(89)+PAz*VRR0(30,9)+WPz*VRR1(30,9)
      VRR0(51,10)=2.D0*V(38)-2.D0*V(39)+2.D0*V(94)+PAz*VRR0(30,10)+WPz*VRR1(30,10)
      VRR0(52,5)=V(41)+V(43)+PAz*VRR0(31,5)+WPz*VRR1(31,5)
      VRR0(52,6)=V(45)+V(47)+PAz*VRR0(31,6)+WPz*VRR1(31,6)
      VRR0(52,7)=V(50)+V(52)+PAz*VRR0(31,7)+WPz*VRR1(31,7)
      VRR0(52,8)=V(54)+V(56)+V(100)+PAz*VRR0(31,8)+WPz*VRR1(31,8)
      VRR0(52,9)=V(59)+V(61)+V(105)+PAz*VRR0(31,9)+WPz*VRR1(31,9)
      VRR0(52,10)=V(63)+V(65)+2.D0*V(108)+PAz*VRR0(31,10)+WPz*VRR1(31,10)
      VRR0(53,5)=2.D0*V(78)-2.D0*V(79)+PAz*VRR0(32,5)+WPz*VRR1(32,5)
      VRR0(53,6)=2.D0*V(70)-2.D0*V(71)+PAz*VRR0(32,6)+WPz*VRR1(32,6)
      VRR0(53,7)=2.D0*V(80)-2.D0*V(81)+PAz*VRR0(32,7)+WPz*VRR1(32,7)
      VRR0(53,8)=2.D0*V(73)-2.D0*V(74)+V(112)+PAz*VRR0(32,8)+WPz*VRR1(32,8)
      VRR0(53,9)=2.D0*V(76)-2.D0*V(77)+V(119)+PAz*VRR0(32,9)+WPz*VRR1(32,9)
      VRR0(53,10)=2.D0*V(82)-2.D0*V(83)+2.D0*V(120)+PAz*VRR0(32,10)+WPz*VRR1(32,10)
      VRR0(54,5)=3.D0*V(84)-3.D0*V(85)+PAz*VRR0(33,5)+WPz*VRR1(33,5)
      VRR0(54,6)=3.D0*V(87)-3.D0*V(88)+PAz*VRR0(33,6)+WPz*VRR1(33,6)
      VRR0(54,7)=3.D0*V(90)-3.D0*V(91)+PAz*VRR0(33,7)+WPz*VRR1(33,7)
      VRR0(54,8)=3.D0*V(92)-3.D0*V(93)+PAz*VRR0(33,8)+HfxZpE*VRR1(33,2)+WPz*VRR1(33,8)
      VRR0(54,9)=3.D0*V(95)-3.D0*V(96)+PAz*VRR0(33,9)+HfxZpE*VRR1(33,3)+WPz*VRR1(33,9)
      VRR0(54,10)=3.D0*V(97)-3.D0*V(98)+PAz*VRR0(33,10)+2.D0*HfxZpE*VRR1(33,4)+WPz*VRR1(33,10)
      VRR0(55,5)=3.D0*V(115)-3.D0*V(116)+PAz*VRR0(34,5)+WPz*VRR1(34,5)
      VRR0(55,6)=3.D0*V(103)-3.D0*V(104)+PAz*VRR0(34,6)+WPz*VRR1(34,6)
      VRR0(55,7)=3.D0*V(117)-3.D0*V(118)+PAz*VRR0(34,7)+WPz*VRR1(34,7)
      VRR0(55,8)=3.D0*V(106)-3.D0*V(107)+PAz*VRR0(34,8)+HfxZpE*VRR1(34,2)+WPz*VRR1(34,8)
      VRR0(55,9)=3.D0*V(109)-3.D0*V(110)+PAz*VRR0(34,9)+HfxZpE*VRR1(34,3)+WPz*VRR1(34,9)
      VRR0(55,10)=3.D0*V(121)-3.D0*V(122)+PAz*VRR0(34,10)+2.D0*HfxZpE*VRR1(34,4)+WPz*VRR1(34,10)
      VRR0(56,5)=4.D0*r1x2Z*VRR0(20,5)+PAz*VRR0(35,5)-4.D0*ExZpE*r1x2Z*VRR1(20,5)+WPz*VRR1(35,5)
      VRR0(56,6)=4.D0*r1x2Z*VRR0(20,6)+PAz*VRR0(35,6)-4.D0*ExZpE*r1x2Z*VRR1(20,6)+WPz*VRR1(35,6)
      VRR0(56,7)=4.D0*r1x2Z*VRR0(20,7)+PAz*VRR0(35,7)-4.D0*ExZpE*r1x2Z*VRR1(20,7)+WPz*VRR1(35,7)
      VRR0(56,8)=4.D0*r1x2Z*VRR0(20,8)+PAz*VRR0(35,8)-4.D0*ExZpE*r1x2Z*VRR1(20,8)+HfxZpE*VRR1(35,2)+WPz*VRR1(35,8)
      VRR0(56,9)=4.D0*r1x2Z*VRR0(20,9)+PAz*VRR0(35,9)-4.D0*ExZpE*r1x2Z*VRR1(20,9)+HfxZpE*VRR1(35,3)+WPz*VRR1(35,9)
      VRR0(56,10)=4.D0*r1x2Z*VRR0(20,10)+PAz*VRR0(35,10)-4.D0*ExZpE*r1x2Z*VRR1(20,10)+2.D0*HfxZpE*VRR1(35,4)+WPz*VRR1(35,10)
END SUBROUTINE VRRh0d0
SUBROUTINE MVRRh0d0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(36,5)=PAx*VS0(21,5)+WPx*VS1(21,5)+r1x2Z*VR1(21,5)&
   +4D0*r1x2Z*(VS0(11,5)-ExZpE*VS1(11,5))&
   +2D0*HfxZpE*VS1(21,2)
VS0(36,6)=PAx*VS0(21,6)+WPx*VS1(21,6)+r1x2Z*VR1(21,6)&
   +4D0*r1x2Z*(VS0(11,6)-ExZpE*VS1(11,6))&
   +HfxZpE*VS1(21,3)
VS0(36,7)=PAx*VS0(21,7)+WPx*VS1(21,7)+r1x2Z*VR1(21,7)&
   +4D0*r1x2Z*(VS0(11,7)-ExZpE*VS1(11,7))
VS0(36,8)=PAx*VS0(21,8)+WPx*VS1(21,8)+r1x2Z*VR1(21,8)&
   +4D0*r1x2Z*(VS0(11,8)-ExZpE*VS1(11,8))&
   +HfxZpE*VS1(21,4)
VS0(36,9)=PAx*VS0(21,9)+WPx*VS1(21,9)+r1x2Z*VR1(21,9)&
   +4D0*r1x2Z*(VS0(11,9)-ExZpE*VS1(11,9))
VS0(36,10)=PAx*VS0(21,10)+WPx*VS1(21,10)+r1x2Z*VR1(21,10)&
   +4D0*r1x2Z*(VS0(11,10)-ExZpE*VS1(11,10))
VS0(37,5)=PAx*VS0(22,5)+WPx*VS1(22,5)+r1x2Z*VR1(22,5)&
   +3D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(22,2)
VS0(37,6)=PAx*VS0(22,6)+WPx*VS1(22,6)+r1x2Z*VR1(22,6)&
   +3D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(22,3)
VS0(37,7)=PAx*VS0(22,7)+WPx*VS1(22,7)+r1x2Z*VR1(22,7)&
   +3D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))
VS0(37,8)=PAx*VS0(22,8)+WPx*VS1(22,8)+r1x2Z*VR1(22,8)&
   +3D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))&
   +HfxZpE*VS1(22,4)
VS0(37,9)=PAx*VS0(22,9)+WPx*VS1(22,9)+r1x2Z*VR1(22,9)&
   +3D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))
VS0(37,10)=PAx*VS0(22,10)+WPx*VS1(22,10)+r1x2Z*VR1(22,10)&
   +3D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(38,5)=PAx*VS0(23,5)+WPx*VS1(23,5)+r1x2Z*VR1(23,5)&
   +2D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))&
   +2D0*HfxZpE*VS1(23,2)
VS0(38,6)=PAx*VS0(23,6)+WPx*VS1(23,6)+r1x2Z*VR1(23,6)&
   +2D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(23,3)
VS0(38,7)=PAx*VS0(23,7)+WPx*VS1(23,7)+r1x2Z*VR1(23,7)&
   +2D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))
VS0(38,8)=PAx*VS0(23,8)+WPx*VS1(23,8)+r1x2Z*VR1(23,8)&
   +2D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))&
   +HfxZpE*VS1(23,4)
VS0(38,9)=PAx*VS0(23,9)+WPx*VS1(23,9)+r1x2Z*VR1(23,9)&
   +2D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))
VS0(38,10)=PAx*VS0(23,10)+WPx*VS1(23,10)+r1x2Z*VR1(23,10)&
   +2D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(39,5)=PAy*VS0(23,5)+WPy*VS1(23,5)&
   +2D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))
VS0(39,6)=PAy*VS0(23,6)+WPy*VS1(23,6)&
   +2D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(23,2)
VS0(39,7)=PAy*VS0(23,7)+WPy*VS1(23,7)&
   +2D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(23,3)
VS0(39,8)=PAy*VS0(23,8)+WPy*VS1(23,8)&
   +2D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))
VS0(39,9)=PAy*VS0(23,9)+WPy*VS1(23,9)&
   +2D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))&
   +HfxZpE*VS1(23,4)
VS0(39,10)=PAy*VS0(23,10)+WPy*VS1(23,10)&
   +2D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(40,5)=PAy*VS0(24,5)+WPy*VS1(24,5)&
   +3D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))
VS0(40,6)=PAy*VS0(24,6)+WPy*VS1(24,6)&
   +3D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(24,2)
VS0(40,7)=PAy*VS0(24,7)+WPy*VS1(24,7)&
   +3D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(24,3)
VS0(40,8)=PAy*VS0(24,8)+WPy*VS1(24,8)&
   +3D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))
VS0(40,9)=PAy*VS0(24,9)+WPy*VS1(24,9)&
   +3D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))&
   +HfxZpE*VS1(24,4)
VS0(40,10)=PAy*VS0(24,10)+WPy*VS1(24,10)&
   +3D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(41,5)=PAy*VS0(25,5)+WPy*VS1(25,5)&
   +4D0*r1x2Z*(VS0(14,5)-ExZpE*VS1(14,5))
VS0(41,6)=PAy*VS0(25,6)+WPy*VS1(25,6)&
   +4D0*r1x2Z*(VS0(14,6)-ExZpE*VS1(14,6))&
   +HfxZpE*VS1(25,2)
VS0(41,7)=PAy*VS0(25,7)+WPy*VS1(25,7)&
   +4D0*r1x2Z*(VS0(14,7)-ExZpE*VS1(14,7))&
   +2D0*HfxZpE*VS1(25,3)
VS0(41,8)=PAy*VS0(25,8)+WPy*VS1(25,8)&
   +4D0*r1x2Z*(VS0(14,8)-ExZpE*VS1(14,8))
VS0(41,9)=PAy*VS0(25,9)+WPy*VS1(25,9)&
   +4D0*r1x2Z*(VS0(14,9)-ExZpE*VS1(14,9))&
   +HfxZpE*VS1(25,4)
VS0(41,10)=PAy*VS0(25,10)+WPy*VS1(25,10)&
   +4D0*r1x2Z*(VS0(14,10)-ExZpE*VS1(14,10))
VS0(42,5)=PAx*VS0(26,5)+WPx*VS1(26,5)+r1x2Z*VR1(26,5)&
   +3D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(26,2)
VS0(42,6)=PAx*VS0(26,6)+WPx*VS1(26,6)+r1x2Z*VR1(26,6)&
   +3D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))&
   +HfxZpE*VS1(26,3)
VS0(42,7)=PAx*VS0(26,7)+WPx*VS1(26,7)+r1x2Z*VR1(26,7)&
   +3D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(42,8)=PAx*VS0(26,8)+WPx*VS1(26,8)+r1x2Z*VR1(26,8)&
   +3D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(26,4)
VS0(42,9)=PAx*VS0(26,9)+WPx*VS1(26,9)+r1x2Z*VR1(26,9)&
   +3D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))
VS0(42,10)=PAx*VS0(26,10)+WPx*VS1(26,10)+r1x2Z*VR1(26,10)&
   +3D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))
VS0(43,5)=PAx*VS0(27,5)+WPx*VS1(27,5)+r1x2Z*VR1(27,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))&
   +2D0*HfxZpE*VS1(27,2)
VS0(43,6)=PAx*VS0(27,6)+WPx*VS1(27,6)+r1x2Z*VR1(27,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(27,3)
VS0(43,7)=PAx*VS0(27,7)+WPx*VS1(27,7)+r1x2Z*VR1(27,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(43,8)=PAx*VS0(27,8)+WPx*VS1(27,8)+r1x2Z*VR1(27,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(27,4)
VS0(43,9)=PAx*VS0(27,9)+WPx*VS1(27,9)+r1x2Z*VR1(27,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))
VS0(43,10)=PAx*VS0(27,10)+WPx*VS1(27,10)+r1x2Z*VR1(27,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(44,5)=PAx*VS0(28,5)+WPx*VS1(28,5)+r1x2Z*VR1(28,5)&
   +r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))&
   +2D0*HfxZpE*VS1(28,2)
VS0(44,6)=PAx*VS0(28,6)+WPx*VS1(28,6)+r1x2Z*VR1(28,6)&
   +r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(28,3)
VS0(44,7)=PAx*VS0(28,7)+WPx*VS1(28,7)+r1x2Z*VR1(28,7)&
   +r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(44,8)=PAx*VS0(28,8)+WPx*VS1(28,8)+r1x2Z*VR1(28,8)&
   +r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(28,4)
VS0(44,9)=PAx*VS0(28,9)+WPx*VS1(28,9)+r1x2Z*VR1(28,9)&
   +r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))
VS0(44,10)=PAx*VS0(28,10)+WPx*VS1(28,10)+r1x2Z*VR1(28,10)&
   +r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(45,5)=PAy*VS0(28,5)+WPy*VS1(28,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(45,6)=PAy*VS0(28,6)+WPy*VS1(28,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(28,2)
VS0(45,7)=PAy*VS0(28,7)+WPy*VS1(28,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))&
   +2D0*HfxZpE*VS1(28,3)
VS0(45,8)=PAy*VS0(28,8)+WPy*VS1(28,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))
VS0(45,9)=PAy*VS0(28,9)+WPy*VS1(28,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(28,4)
VS0(45,10)=PAy*VS0(28,10)+WPy*VS1(28,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(46,5)=PAy*VS0(29,5)+WPy*VS1(29,5)&
   +3D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(46,6)=PAy*VS0(29,6)+WPy*VS1(29,6)&
   +3D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(29,2)
VS0(46,7)=PAy*VS0(29,7)+WPy*VS1(29,7)&
   +3D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(29,3)
VS0(46,8)=PAy*VS0(29,8)+WPy*VS1(29,8)&
   +3D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))
VS0(46,9)=PAy*VS0(29,9)+WPy*VS1(29,9)&
   +3D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(29,4)
VS0(46,10)=PAy*VS0(29,10)+WPy*VS1(29,10)&
   +3D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(47,5)=PAx*VS0(30,5)+WPx*VS1(30,5)+r1x2Z*VR1(30,5)&
   +2D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))&
   +2D0*HfxZpE*VS1(30,2)
VS0(47,6)=PAx*VS0(30,6)+WPx*VS1(30,6)+r1x2Z*VR1(30,6)&
   +2D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(30,3)
VS0(47,7)=PAx*VS0(30,7)+WPx*VS1(30,7)+r1x2Z*VR1(30,7)&
   +2D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(47,8)=PAx*VS0(30,8)+WPx*VS1(30,8)+r1x2Z*VR1(30,8)&
   +2D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(30,4)
VS0(47,9)=PAx*VS0(30,9)+WPx*VS1(30,9)+r1x2Z*VR1(30,9)&
   +2D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))
VS0(47,10)=PAx*VS0(30,10)+WPx*VS1(30,10)+r1x2Z*VR1(30,10)&
   +2D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(48,5)=PAx*VS0(31,5)+WPx*VS1(31,5)+r1x2Z*VR1(31,5)&
   +r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))&
   +2D0*HfxZpE*VS1(31,2)
VS0(48,6)=PAx*VS0(31,6)+WPx*VS1(31,6)+r1x2Z*VR1(31,6)&
   +r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(31,3)
VS0(48,7)=PAx*VS0(31,7)+WPx*VS1(31,7)+r1x2Z*VR1(31,7)&
   +r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(48,8)=PAx*VS0(31,8)+WPx*VS1(31,8)+r1x2Z*VR1(31,8)&
   +r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(31,4)
VS0(48,9)=PAx*VS0(31,9)+WPx*VS1(31,9)+r1x2Z*VR1(31,9)&
   +r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))
VS0(48,10)=PAx*VS0(31,10)+WPx*VS1(31,10)+r1x2Z*VR1(31,10)&
   +r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(49,5)=PAy*VS0(31,5)+WPy*VS1(31,5)&
   +r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(49,6)=PAy*VS0(31,6)+WPy*VS1(31,6)&
   +r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(31,2)
VS0(49,7)=PAy*VS0(31,7)+WPy*VS1(31,7)&
   +r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))&
   +2D0*HfxZpE*VS1(31,3)
VS0(49,8)=PAy*VS0(31,8)+WPy*VS1(31,8)&
   +r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))
VS0(49,9)=PAy*VS0(31,9)+WPy*VS1(31,9)&
   +r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(31,4)
VS0(49,10)=PAy*VS0(31,10)+WPy*VS1(31,10)&
   +r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(50,5)=PAy*VS0(32,5)+WPy*VS1(32,5)&
   +2D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(50,6)=PAy*VS0(32,6)+WPy*VS1(32,6)&
   +2D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(32,2)
VS0(50,7)=PAy*VS0(32,7)+WPy*VS1(32,7)&
   +2D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))&
   +2D0*HfxZpE*VS1(32,3)
VS0(50,8)=PAy*VS0(32,8)+WPy*VS1(32,8)&
   +2D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))
VS0(50,9)=PAy*VS0(32,9)+WPy*VS1(32,9)&
   +2D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(32,4)
VS0(50,10)=PAy*VS0(32,10)+WPy*VS1(32,10)&
   +2D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(51,5)=PAz*VS0(30,5)+WPz*VS1(30,5)&
   +2D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))
VS0(51,6)=PAz*VS0(30,6)+WPz*VS1(30,6)&
   +2D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))
VS0(51,7)=PAz*VS0(30,7)+WPz*VS1(30,7)&
   +2D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(51,8)=PAz*VS0(30,8)+WPz*VS1(30,8)&
   +2D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(30,2)
VS0(51,9)=PAz*VS0(30,9)+WPz*VS1(30,9)&
   +2D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))&
   +HfxZpE*VS1(30,3)
VS0(51,10)=PAz*VS0(30,10)+WPz*VS1(30,10)&
   +2D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(30,4)
VS0(52,5)=PAz*VS0(31,5)+WPz*VS1(31,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(52,6)=PAz*VS0(31,6)+WPz*VS1(31,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))
VS0(52,7)=PAz*VS0(31,7)+WPz*VS1(31,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(52,8)=PAz*VS0(31,8)+WPz*VS1(31,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(31,2)
VS0(52,9)=PAz*VS0(31,9)+WPz*VS1(31,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(31,3)
VS0(52,10)=PAz*VS0(31,10)+WPz*VS1(31,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))&
   +2D0*HfxZpE*VS1(31,4)
VS0(53,5)=PAz*VS0(32,5)+WPz*VS1(32,5)&
   +2D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(53,6)=PAz*VS0(32,6)+WPz*VS1(32,6)&
   +2D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))
VS0(53,7)=PAz*VS0(32,7)+WPz*VS1(32,7)&
   +2D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(53,8)=PAz*VS0(32,8)+WPz*VS1(32,8)&
   +2D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(32,2)
VS0(53,9)=PAz*VS0(32,9)+WPz*VS1(32,9)&
   +2D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(32,3)
VS0(53,10)=PAz*VS0(32,10)+WPz*VS1(32,10)&
   +2D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(32,4)
VS0(54,5)=PAz*VS0(33,5)+WPz*VS1(33,5)&
   +3D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(54,6)=PAz*VS0(33,6)+WPz*VS1(33,6)&
   +3D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))
VS0(54,7)=PAz*VS0(33,7)+WPz*VS1(33,7)&
   +3D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(54,8)=PAz*VS0(33,8)+WPz*VS1(33,8)&
   +3D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(33,2)
VS0(54,9)=PAz*VS0(33,9)+WPz*VS1(33,9)&
   +3D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(33,3)
VS0(54,10)=PAz*VS0(33,10)+WPz*VS1(33,10)&
   +3D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(33,4)
VS0(55,5)=PAz*VS0(34,5)+WPz*VS1(34,5)&
   +3D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(55,6)=PAz*VS0(34,6)+WPz*VS1(34,6)&
   +3D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))
VS0(55,7)=PAz*VS0(34,7)+WPz*VS1(34,7)&
   +3D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(55,8)=PAz*VS0(34,8)+WPz*VS1(34,8)&
   +3D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(34,2)
VS0(55,9)=PAz*VS0(34,9)+WPz*VS1(34,9)&
   +3D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(34,3)
VS0(55,10)=PAz*VS0(34,10)+WPz*VS1(34,10)&
   +3D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(34,4)
VS0(56,5)=PAz*VS0(35,5)+WPz*VS1(35,5)&
   +4D0*r1x2Z*(VS0(20,5)-ExZpE*VS1(20,5))
VS0(56,6)=PAz*VS0(35,6)+WPz*VS1(35,6)&
   +4D0*r1x2Z*(VS0(20,6)-ExZpE*VS1(20,6))
VS0(56,7)=PAz*VS0(35,7)+WPz*VS1(35,7)&
   +4D0*r1x2Z*(VS0(20,7)-ExZpE*VS1(20,7))
VS0(56,8)=PAz*VS0(35,8)+WPz*VS1(35,8)&
   +4D0*r1x2Z*(VS0(20,8)-ExZpE*VS1(20,8))&
   +HfxZpE*VS1(35,2)
VS0(56,9)=PAz*VS0(35,9)+WPz*VS1(35,9)&
   +4D0*r1x2Z*(VS0(20,9)-ExZpE*VS1(20,9))&
   +HfxZpE*VS1(35,3)
VS0(56,10)=PAz*VS0(35,10)+WPz*VS1(35,10)&
   +4D0*r1x2Z*(VS0(20,10)-ExZpE*VS1(20,10))&
   +2D0*HfxZpE*VS1(35,4)
CASE(2)
VS0(36,5)=PAx*VS0(21,5)+WPx*VS1(21,5)&
   +4D0*r1x2Z*(VS0(11,5)-ExZpE*VS1(11,5))&
   +2D0*HfxZpE*VS1(21,2)
VS0(36,6)=PAx*VS0(21,6)+WPx*VS1(21,6)&
   +4D0*r1x2Z*(VS0(11,6)-ExZpE*VS1(11,6))&
   +HfxZpE*VS1(21,3)
VS0(36,7)=PAx*VS0(21,7)+WPx*VS1(21,7)&
   +4D0*r1x2Z*(VS0(11,7)-ExZpE*VS1(11,7))
VS0(36,8)=PAx*VS0(21,8)+WPx*VS1(21,8)&
   +4D0*r1x2Z*(VS0(11,8)-ExZpE*VS1(11,8))&
   +HfxZpE*VS1(21,4)
VS0(36,9)=PAx*VS0(21,9)+WPx*VS1(21,9)&
   +4D0*r1x2Z*(VS0(11,9)-ExZpE*VS1(11,9))
VS0(36,10)=PAx*VS0(21,10)+WPx*VS1(21,10)&
   +4D0*r1x2Z*(VS0(11,10)-ExZpE*VS1(11,10))
VS0(37,5)=PAx*VS0(22,5)+WPx*VS1(22,5)&
   +3D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(22,2)
VS0(37,6)=PAx*VS0(22,6)+WPx*VS1(22,6)&
   +3D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(22,3)
VS0(37,7)=PAx*VS0(22,7)+WPx*VS1(22,7)&
   +3D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))
VS0(37,8)=PAx*VS0(22,8)+WPx*VS1(22,8)&
   +3D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))&
   +HfxZpE*VS1(22,4)
VS0(37,9)=PAx*VS0(22,9)+WPx*VS1(22,9)&
   +3D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))
VS0(37,10)=PAx*VS0(22,10)+WPx*VS1(22,10)&
   +3D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(38,5)=PAx*VS0(23,5)+WPx*VS1(23,5)&
   +2D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))&
   +2D0*HfxZpE*VS1(23,2)
VS0(38,6)=PAx*VS0(23,6)+WPx*VS1(23,6)&
   +2D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(23,3)
VS0(38,7)=PAx*VS0(23,7)+WPx*VS1(23,7)&
   +2D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))
VS0(38,8)=PAx*VS0(23,8)+WPx*VS1(23,8)&
   +2D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))&
   +HfxZpE*VS1(23,4)
VS0(38,9)=PAx*VS0(23,9)+WPx*VS1(23,9)&
   +2D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))
VS0(38,10)=PAx*VS0(23,10)+WPx*VS1(23,10)&
   +2D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(39,5)=PAy*VS0(23,5)+WPy*VS1(23,5)+r1x2Z*VR1(23,5)&
   +2D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))
VS0(39,6)=PAy*VS0(23,6)+WPy*VS1(23,6)+r1x2Z*VR1(23,6)&
   +2D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(23,2)
VS0(39,7)=PAy*VS0(23,7)+WPy*VS1(23,7)+r1x2Z*VR1(23,7)&
   +2D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(23,3)
VS0(39,8)=PAy*VS0(23,8)+WPy*VS1(23,8)+r1x2Z*VR1(23,8)&
   +2D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))
VS0(39,9)=PAy*VS0(23,9)+WPy*VS1(23,9)+r1x2Z*VR1(23,9)&
   +2D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))&
   +HfxZpE*VS1(23,4)
VS0(39,10)=PAy*VS0(23,10)+WPy*VS1(23,10)+r1x2Z*VR1(23,10)&
   +2D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(40,5)=PAy*VS0(24,5)+WPy*VS1(24,5)+r1x2Z*VR1(24,5)&
   +3D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))
VS0(40,6)=PAy*VS0(24,6)+WPy*VS1(24,6)+r1x2Z*VR1(24,6)&
   +3D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(24,2)
VS0(40,7)=PAy*VS0(24,7)+WPy*VS1(24,7)+r1x2Z*VR1(24,7)&
   +3D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(24,3)
VS0(40,8)=PAy*VS0(24,8)+WPy*VS1(24,8)+r1x2Z*VR1(24,8)&
   +3D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))
VS0(40,9)=PAy*VS0(24,9)+WPy*VS1(24,9)+r1x2Z*VR1(24,9)&
   +3D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))&
   +HfxZpE*VS1(24,4)
VS0(40,10)=PAy*VS0(24,10)+WPy*VS1(24,10)+r1x2Z*VR1(24,10)&
   +3D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(41,5)=PAy*VS0(25,5)+WPy*VS1(25,5)+r1x2Z*VR1(25,5)&
   +4D0*r1x2Z*(VS0(14,5)-ExZpE*VS1(14,5))
VS0(41,6)=PAy*VS0(25,6)+WPy*VS1(25,6)+r1x2Z*VR1(25,6)&
   +4D0*r1x2Z*(VS0(14,6)-ExZpE*VS1(14,6))&
   +HfxZpE*VS1(25,2)
VS0(41,7)=PAy*VS0(25,7)+WPy*VS1(25,7)+r1x2Z*VR1(25,7)&
   +4D0*r1x2Z*(VS0(14,7)-ExZpE*VS1(14,7))&
   +2D0*HfxZpE*VS1(25,3)
VS0(41,8)=PAy*VS0(25,8)+WPy*VS1(25,8)+r1x2Z*VR1(25,8)&
   +4D0*r1x2Z*(VS0(14,8)-ExZpE*VS1(14,8))
VS0(41,9)=PAy*VS0(25,9)+WPy*VS1(25,9)+r1x2Z*VR1(25,9)&
   +4D0*r1x2Z*(VS0(14,9)-ExZpE*VS1(14,9))&
   +HfxZpE*VS1(25,4)
VS0(41,10)=PAy*VS0(25,10)+WPy*VS1(25,10)+r1x2Z*VR1(25,10)&
   +4D0*r1x2Z*(VS0(14,10)-ExZpE*VS1(14,10))
VS0(42,5)=PAx*VS0(26,5)+WPx*VS1(26,5)&
   +3D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(26,2)
VS0(42,6)=PAx*VS0(26,6)+WPx*VS1(26,6)&
   +3D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))&
   +HfxZpE*VS1(26,3)
VS0(42,7)=PAx*VS0(26,7)+WPx*VS1(26,7)&
   +3D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(42,8)=PAx*VS0(26,8)+WPx*VS1(26,8)&
   +3D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(26,4)
VS0(42,9)=PAx*VS0(26,9)+WPx*VS1(26,9)&
   +3D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))
VS0(42,10)=PAx*VS0(26,10)+WPx*VS1(26,10)&
   +3D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))
VS0(43,5)=PAx*VS0(27,5)+WPx*VS1(27,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))&
   +2D0*HfxZpE*VS1(27,2)
VS0(43,6)=PAx*VS0(27,6)+WPx*VS1(27,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(27,3)
VS0(43,7)=PAx*VS0(27,7)+WPx*VS1(27,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(43,8)=PAx*VS0(27,8)+WPx*VS1(27,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(27,4)
VS0(43,9)=PAx*VS0(27,9)+WPx*VS1(27,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))
VS0(43,10)=PAx*VS0(27,10)+WPx*VS1(27,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(44,5)=PAx*VS0(28,5)+WPx*VS1(28,5)&
   +r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))&
   +2D0*HfxZpE*VS1(28,2)
VS0(44,6)=PAx*VS0(28,6)+WPx*VS1(28,6)&
   +r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(28,3)
VS0(44,7)=PAx*VS0(28,7)+WPx*VS1(28,7)&
   +r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(44,8)=PAx*VS0(28,8)+WPx*VS1(28,8)&
   +r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(28,4)
VS0(44,9)=PAx*VS0(28,9)+WPx*VS1(28,9)&
   +r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))
VS0(44,10)=PAx*VS0(28,10)+WPx*VS1(28,10)&
   +r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(45,5)=PAy*VS0(28,5)+WPy*VS1(28,5)+r1x2Z*VR1(28,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(45,6)=PAy*VS0(28,6)+WPy*VS1(28,6)+r1x2Z*VR1(28,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(28,2)
VS0(45,7)=PAy*VS0(28,7)+WPy*VS1(28,7)+r1x2Z*VR1(28,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))&
   +2D0*HfxZpE*VS1(28,3)
VS0(45,8)=PAy*VS0(28,8)+WPy*VS1(28,8)+r1x2Z*VR1(28,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))
VS0(45,9)=PAy*VS0(28,9)+WPy*VS1(28,9)+r1x2Z*VR1(28,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(28,4)
VS0(45,10)=PAy*VS0(28,10)+WPy*VS1(28,10)+r1x2Z*VR1(28,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(46,5)=PAy*VS0(29,5)+WPy*VS1(29,5)+r1x2Z*VR1(29,5)&
   +3D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(46,6)=PAy*VS0(29,6)+WPy*VS1(29,6)+r1x2Z*VR1(29,6)&
   +3D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(29,2)
VS0(46,7)=PAy*VS0(29,7)+WPy*VS1(29,7)+r1x2Z*VR1(29,7)&
   +3D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(29,3)
VS0(46,8)=PAy*VS0(29,8)+WPy*VS1(29,8)+r1x2Z*VR1(29,8)&
   +3D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))
VS0(46,9)=PAy*VS0(29,9)+WPy*VS1(29,9)+r1x2Z*VR1(29,9)&
   +3D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(29,4)
VS0(46,10)=PAy*VS0(29,10)+WPy*VS1(29,10)+r1x2Z*VR1(29,10)&
   +3D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(47,5)=PAx*VS0(30,5)+WPx*VS1(30,5)&
   +2D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))&
   +2D0*HfxZpE*VS1(30,2)
VS0(47,6)=PAx*VS0(30,6)+WPx*VS1(30,6)&
   +2D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(30,3)
VS0(47,7)=PAx*VS0(30,7)+WPx*VS1(30,7)&
   +2D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(47,8)=PAx*VS0(30,8)+WPx*VS1(30,8)&
   +2D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(30,4)
VS0(47,9)=PAx*VS0(30,9)+WPx*VS1(30,9)&
   +2D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))
VS0(47,10)=PAx*VS0(30,10)+WPx*VS1(30,10)&
   +2D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(48,5)=PAx*VS0(31,5)+WPx*VS1(31,5)&
   +r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))&
   +2D0*HfxZpE*VS1(31,2)
VS0(48,6)=PAx*VS0(31,6)+WPx*VS1(31,6)&
   +r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(31,3)
VS0(48,7)=PAx*VS0(31,7)+WPx*VS1(31,7)&
   +r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(48,8)=PAx*VS0(31,8)+WPx*VS1(31,8)&
   +r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(31,4)
VS0(48,9)=PAx*VS0(31,9)+WPx*VS1(31,9)&
   +r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))
VS0(48,10)=PAx*VS0(31,10)+WPx*VS1(31,10)&
   +r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(49,5)=PAy*VS0(31,5)+WPy*VS1(31,5)+r1x2Z*VR1(31,5)&
   +r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(49,6)=PAy*VS0(31,6)+WPy*VS1(31,6)+r1x2Z*VR1(31,6)&
   +r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(31,2)
VS0(49,7)=PAy*VS0(31,7)+WPy*VS1(31,7)+r1x2Z*VR1(31,7)&
   +r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))&
   +2D0*HfxZpE*VS1(31,3)
VS0(49,8)=PAy*VS0(31,8)+WPy*VS1(31,8)+r1x2Z*VR1(31,8)&
   +r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))
VS0(49,9)=PAy*VS0(31,9)+WPy*VS1(31,9)+r1x2Z*VR1(31,9)&
   +r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(31,4)
VS0(49,10)=PAy*VS0(31,10)+WPy*VS1(31,10)+r1x2Z*VR1(31,10)&
   +r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(50,5)=PAy*VS0(32,5)+WPy*VS1(32,5)+r1x2Z*VR1(32,5)&
   +2D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(50,6)=PAy*VS0(32,6)+WPy*VS1(32,6)+r1x2Z*VR1(32,6)&
   +2D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(32,2)
VS0(50,7)=PAy*VS0(32,7)+WPy*VS1(32,7)+r1x2Z*VR1(32,7)&
   +2D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))&
   +2D0*HfxZpE*VS1(32,3)
VS0(50,8)=PAy*VS0(32,8)+WPy*VS1(32,8)+r1x2Z*VR1(32,8)&
   +2D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))
VS0(50,9)=PAy*VS0(32,9)+WPy*VS1(32,9)+r1x2Z*VR1(32,9)&
   +2D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(32,4)
VS0(50,10)=PAy*VS0(32,10)+WPy*VS1(32,10)+r1x2Z*VR1(32,10)&
   +2D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(51,5)=PAz*VS0(30,5)+WPz*VS1(30,5)&
   +2D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))
VS0(51,6)=PAz*VS0(30,6)+WPz*VS1(30,6)&
   +2D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))
VS0(51,7)=PAz*VS0(30,7)+WPz*VS1(30,7)&
   +2D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(51,8)=PAz*VS0(30,8)+WPz*VS1(30,8)&
   +2D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(30,2)
VS0(51,9)=PAz*VS0(30,9)+WPz*VS1(30,9)&
   +2D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))&
   +HfxZpE*VS1(30,3)
VS0(51,10)=PAz*VS0(30,10)+WPz*VS1(30,10)&
   +2D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(30,4)
VS0(52,5)=PAz*VS0(31,5)+WPz*VS1(31,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(52,6)=PAz*VS0(31,6)+WPz*VS1(31,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))
VS0(52,7)=PAz*VS0(31,7)+WPz*VS1(31,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(52,8)=PAz*VS0(31,8)+WPz*VS1(31,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(31,2)
VS0(52,9)=PAz*VS0(31,9)+WPz*VS1(31,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(31,3)
VS0(52,10)=PAz*VS0(31,10)+WPz*VS1(31,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))&
   +2D0*HfxZpE*VS1(31,4)
VS0(53,5)=PAz*VS0(32,5)+WPz*VS1(32,5)&
   +2D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(53,6)=PAz*VS0(32,6)+WPz*VS1(32,6)&
   +2D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))
VS0(53,7)=PAz*VS0(32,7)+WPz*VS1(32,7)&
   +2D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(53,8)=PAz*VS0(32,8)+WPz*VS1(32,8)&
   +2D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(32,2)
VS0(53,9)=PAz*VS0(32,9)+WPz*VS1(32,9)&
   +2D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(32,3)
VS0(53,10)=PAz*VS0(32,10)+WPz*VS1(32,10)&
   +2D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(32,4)
VS0(54,5)=PAz*VS0(33,5)+WPz*VS1(33,5)&
   +3D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(54,6)=PAz*VS0(33,6)+WPz*VS1(33,6)&
   +3D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))
VS0(54,7)=PAz*VS0(33,7)+WPz*VS1(33,7)&
   +3D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(54,8)=PAz*VS0(33,8)+WPz*VS1(33,8)&
   +3D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(33,2)
VS0(54,9)=PAz*VS0(33,9)+WPz*VS1(33,9)&
   +3D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(33,3)
VS0(54,10)=PAz*VS0(33,10)+WPz*VS1(33,10)&
   +3D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(33,4)
VS0(55,5)=PAz*VS0(34,5)+WPz*VS1(34,5)&
   +3D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(55,6)=PAz*VS0(34,6)+WPz*VS1(34,6)&
   +3D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))
VS0(55,7)=PAz*VS0(34,7)+WPz*VS1(34,7)&
   +3D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(55,8)=PAz*VS0(34,8)+WPz*VS1(34,8)&
   +3D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(34,2)
VS0(55,9)=PAz*VS0(34,9)+WPz*VS1(34,9)&
   +3D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(34,3)
VS0(55,10)=PAz*VS0(34,10)+WPz*VS1(34,10)&
   +3D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(34,4)
VS0(56,5)=PAz*VS0(35,5)+WPz*VS1(35,5)&
   +4D0*r1x2Z*(VS0(20,5)-ExZpE*VS1(20,5))
VS0(56,6)=PAz*VS0(35,6)+WPz*VS1(35,6)&
   +4D0*r1x2Z*(VS0(20,6)-ExZpE*VS1(20,6))
VS0(56,7)=PAz*VS0(35,7)+WPz*VS1(35,7)&
   +4D0*r1x2Z*(VS0(20,7)-ExZpE*VS1(20,7))
VS0(56,8)=PAz*VS0(35,8)+WPz*VS1(35,8)&
   +4D0*r1x2Z*(VS0(20,8)-ExZpE*VS1(20,8))&
   +HfxZpE*VS1(35,2)
VS0(56,9)=PAz*VS0(35,9)+WPz*VS1(35,9)&
   +4D0*r1x2Z*(VS0(20,9)-ExZpE*VS1(20,9))&
   +HfxZpE*VS1(35,3)
VS0(56,10)=PAz*VS0(35,10)+WPz*VS1(35,10)&
   +4D0*r1x2Z*(VS0(20,10)-ExZpE*VS1(20,10))&
   +2D0*HfxZpE*VS1(35,4)
CASE(3)
VS0(36,5)=PAx*VS0(21,5)+WPx*VS1(21,5)&
   +4D0*r1x2Z*(VS0(11,5)-ExZpE*VS1(11,5))&
   +2D0*HfxZpE*VS1(21,2)
VS0(36,6)=PAx*VS0(21,6)+WPx*VS1(21,6)&
   +4D0*r1x2Z*(VS0(11,6)-ExZpE*VS1(11,6))&
   +HfxZpE*VS1(21,3)
VS0(36,7)=PAx*VS0(21,7)+WPx*VS1(21,7)&
   +4D0*r1x2Z*(VS0(11,7)-ExZpE*VS1(11,7))
VS0(36,8)=PAx*VS0(21,8)+WPx*VS1(21,8)&
   +4D0*r1x2Z*(VS0(11,8)-ExZpE*VS1(11,8))&
   +HfxZpE*VS1(21,4)
VS0(36,9)=PAx*VS0(21,9)+WPx*VS1(21,9)&
   +4D0*r1x2Z*(VS0(11,9)-ExZpE*VS1(11,9))
VS0(36,10)=PAx*VS0(21,10)+WPx*VS1(21,10)&
   +4D0*r1x2Z*(VS0(11,10)-ExZpE*VS1(11,10))
VS0(37,5)=PAx*VS0(22,5)+WPx*VS1(22,5)&
   +3D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))&
   +2D0*HfxZpE*VS1(22,2)
VS0(37,6)=PAx*VS0(22,6)+WPx*VS1(22,6)&
   +3D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(22,3)
VS0(37,7)=PAx*VS0(22,7)+WPx*VS1(22,7)&
   +3D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))
VS0(37,8)=PAx*VS0(22,8)+WPx*VS1(22,8)&
   +3D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))&
   +HfxZpE*VS1(22,4)
VS0(37,9)=PAx*VS0(22,9)+WPx*VS1(22,9)&
   +3D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))
VS0(37,10)=PAx*VS0(22,10)+WPx*VS1(22,10)&
   +3D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(38,5)=PAx*VS0(23,5)+WPx*VS1(23,5)&
   +2D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))&
   +2D0*HfxZpE*VS1(23,2)
VS0(38,6)=PAx*VS0(23,6)+WPx*VS1(23,6)&
   +2D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(23,3)
VS0(38,7)=PAx*VS0(23,7)+WPx*VS1(23,7)&
   +2D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))
VS0(38,8)=PAx*VS0(23,8)+WPx*VS1(23,8)&
   +2D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))&
   +HfxZpE*VS1(23,4)
VS0(38,9)=PAx*VS0(23,9)+WPx*VS1(23,9)&
   +2D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))
VS0(38,10)=PAx*VS0(23,10)+WPx*VS1(23,10)&
   +2D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(39,5)=PAy*VS0(23,5)+WPy*VS1(23,5)&
   +2D0*r1x2Z*(VS0(12,5)-ExZpE*VS1(12,5))
VS0(39,6)=PAy*VS0(23,6)+WPy*VS1(23,6)&
   +2D0*r1x2Z*(VS0(12,6)-ExZpE*VS1(12,6))&
   +HfxZpE*VS1(23,2)
VS0(39,7)=PAy*VS0(23,7)+WPy*VS1(23,7)&
   +2D0*r1x2Z*(VS0(12,7)-ExZpE*VS1(12,7))&
   +2D0*HfxZpE*VS1(23,3)
VS0(39,8)=PAy*VS0(23,8)+WPy*VS1(23,8)&
   +2D0*r1x2Z*(VS0(12,8)-ExZpE*VS1(12,8))
VS0(39,9)=PAy*VS0(23,9)+WPy*VS1(23,9)&
   +2D0*r1x2Z*(VS0(12,9)-ExZpE*VS1(12,9))&
   +HfxZpE*VS1(23,4)
VS0(39,10)=PAy*VS0(23,10)+WPy*VS1(23,10)&
   +2D0*r1x2Z*(VS0(12,10)-ExZpE*VS1(12,10))
VS0(40,5)=PAy*VS0(24,5)+WPy*VS1(24,5)&
   +3D0*r1x2Z*(VS0(13,5)-ExZpE*VS1(13,5))
VS0(40,6)=PAy*VS0(24,6)+WPy*VS1(24,6)&
   +3D0*r1x2Z*(VS0(13,6)-ExZpE*VS1(13,6))&
   +HfxZpE*VS1(24,2)
VS0(40,7)=PAy*VS0(24,7)+WPy*VS1(24,7)&
   +3D0*r1x2Z*(VS0(13,7)-ExZpE*VS1(13,7))&
   +2D0*HfxZpE*VS1(24,3)
VS0(40,8)=PAy*VS0(24,8)+WPy*VS1(24,8)&
   +3D0*r1x2Z*(VS0(13,8)-ExZpE*VS1(13,8))
VS0(40,9)=PAy*VS0(24,9)+WPy*VS1(24,9)&
   +3D0*r1x2Z*(VS0(13,9)-ExZpE*VS1(13,9))&
   +HfxZpE*VS1(24,4)
VS0(40,10)=PAy*VS0(24,10)+WPy*VS1(24,10)&
   +3D0*r1x2Z*(VS0(13,10)-ExZpE*VS1(13,10))
VS0(41,5)=PAy*VS0(25,5)+WPy*VS1(25,5)&
   +4D0*r1x2Z*(VS0(14,5)-ExZpE*VS1(14,5))
VS0(41,6)=PAy*VS0(25,6)+WPy*VS1(25,6)&
   +4D0*r1x2Z*(VS0(14,6)-ExZpE*VS1(14,6))&
   +HfxZpE*VS1(25,2)
VS0(41,7)=PAy*VS0(25,7)+WPy*VS1(25,7)&
   +4D0*r1x2Z*(VS0(14,7)-ExZpE*VS1(14,7))&
   +2D0*HfxZpE*VS1(25,3)
VS0(41,8)=PAy*VS0(25,8)+WPy*VS1(25,8)&
   +4D0*r1x2Z*(VS0(14,8)-ExZpE*VS1(14,8))
VS0(41,9)=PAy*VS0(25,9)+WPy*VS1(25,9)&
   +4D0*r1x2Z*(VS0(14,9)-ExZpE*VS1(14,9))&
   +HfxZpE*VS1(25,4)
VS0(41,10)=PAy*VS0(25,10)+WPy*VS1(25,10)&
   +4D0*r1x2Z*(VS0(14,10)-ExZpE*VS1(14,10))
VS0(42,5)=PAx*VS0(26,5)+WPx*VS1(26,5)&
   +3D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))&
   +2D0*HfxZpE*VS1(26,2)
VS0(42,6)=PAx*VS0(26,6)+WPx*VS1(26,6)&
   +3D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))&
   +HfxZpE*VS1(26,3)
VS0(42,7)=PAx*VS0(26,7)+WPx*VS1(26,7)&
   +3D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(42,8)=PAx*VS0(26,8)+WPx*VS1(26,8)&
   +3D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(26,4)
VS0(42,9)=PAx*VS0(26,9)+WPx*VS1(26,9)&
   +3D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))
VS0(42,10)=PAx*VS0(26,10)+WPx*VS1(26,10)&
   +3D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))
VS0(43,5)=PAx*VS0(27,5)+WPx*VS1(27,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))&
   +2D0*HfxZpE*VS1(27,2)
VS0(43,6)=PAx*VS0(27,6)+WPx*VS1(27,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(27,3)
VS0(43,7)=PAx*VS0(27,7)+WPx*VS1(27,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(43,8)=PAx*VS0(27,8)+WPx*VS1(27,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(27,4)
VS0(43,9)=PAx*VS0(27,9)+WPx*VS1(27,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))
VS0(43,10)=PAx*VS0(27,10)+WPx*VS1(27,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(44,5)=PAx*VS0(28,5)+WPx*VS1(28,5)&
   +r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))&
   +2D0*HfxZpE*VS1(28,2)
VS0(44,6)=PAx*VS0(28,6)+WPx*VS1(28,6)&
   +r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(28,3)
VS0(44,7)=PAx*VS0(28,7)+WPx*VS1(28,7)&
   +r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(44,8)=PAx*VS0(28,8)+WPx*VS1(28,8)&
   +r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(28,4)
VS0(44,9)=PAx*VS0(28,9)+WPx*VS1(28,9)&
   +r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))
VS0(44,10)=PAx*VS0(28,10)+WPx*VS1(28,10)&
   +r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(45,5)=PAy*VS0(28,5)+WPy*VS1(28,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(45,6)=PAy*VS0(28,6)+WPy*VS1(28,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))&
   +HfxZpE*VS1(28,2)
VS0(45,7)=PAy*VS0(28,7)+WPy*VS1(28,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))&
   +2D0*HfxZpE*VS1(28,3)
VS0(45,8)=PAy*VS0(28,8)+WPy*VS1(28,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))
VS0(45,9)=PAy*VS0(28,9)+WPy*VS1(28,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(28,4)
VS0(45,10)=PAy*VS0(28,10)+WPy*VS1(28,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))
VS0(46,5)=PAy*VS0(29,5)+WPy*VS1(29,5)&
   +3D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(46,6)=PAy*VS0(29,6)+WPy*VS1(29,6)&
   +3D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))&
   +HfxZpE*VS1(29,2)
VS0(46,7)=PAy*VS0(29,7)+WPy*VS1(29,7)&
   +3D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))&
   +2D0*HfxZpE*VS1(29,3)
VS0(46,8)=PAy*VS0(29,8)+WPy*VS1(29,8)&
   +3D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))
VS0(46,9)=PAy*VS0(29,9)+WPy*VS1(29,9)&
   +3D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(29,4)
VS0(46,10)=PAy*VS0(29,10)+WPy*VS1(29,10)&
   +3D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))
VS0(47,5)=PAx*VS0(30,5)+WPx*VS1(30,5)&
   +2D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))&
   +2D0*HfxZpE*VS1(30,2)
VS0(47,6)=PAx*VS0(30,6)+WPx*VS1(30,6)&
   +2D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(30,3)
VS0(47,7)=PAx*VS0(30,7)+WPx*VS1(30,7)&
   +2D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(47,8)=PAx*VS0(30,8)+WPx*VS1(30,8)&
   +2D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(30,4)
VS0(47,9)=PAx*VS0(30,9)+WPx*VS1(30,9)&
   +2D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))
VS0(47,10)=PAx*VS0(30,10)+WPx*VS1(30,10)&
   +2D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(48,5)=PAx*VS0(31,5)+WPx*VS1(31,5)&
   +r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))&
   +2D0*HfxZpE*VS1(31,2)
VS0(48,6)=PAx*VS0(31,6)+WPx*VS1(31,6)&
   +r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(31,3)
VS0(48,7)=PAx*VS0(31,7)+WPx*VS1(31,7)&
   +r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(48,8)=PAx*VS0(31,8)+WPx*VS1(31,8)&
   +r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(31,4)
VS0(48,9)=PAx*VS0(31,9)+WPx*VS1(31,9)&
   +r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))
VS0(48,10)=PAx*VS0(31,10)+WPx*VS1(31,10)&
   +r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(49,5)=PAy*VS0(31,5)+WPy*VS1(31,5)&
   +r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(49,6)=PAy*VS0(31,6)+WPy*VS1(31,6)&
   +r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))&
   +HfxZpE*VS1(31,2)
VS0(49,7)=PAy*VS0(31,7)+WPy*VS1(31,7)&
   +r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))&
   +2D0*HfxZpE*VS1(31,3)
VS0(49,8)=PAy*VS0(31,8)+WPy*VS1(31,8)&
   +r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))
VS0(49,9)=PAy*VS0(31,9)+WPy*VS1(31,9)&
   +r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(31,4)
VS0(49,10)=PAy*VS0(31,10)+WPy*VS1(31,10)&
   +r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))
VS0(50,5)=PAy*VS0(32,5)+WPy*VS1(32,5)&
   +2D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(50,6)=PAy*VS0(32,6)+WPy*VS1(32,6)&
   +2D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))&
   +HfxZpE*VS1(32,2)
VS0(50,7)=PAy*VS0(32,7)+WPy*VS1(32,7)&
   +2D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))&
   +2D0*HfxZpE*VS1(32,3)
VS0(50,8)=PAy*VS0(32,8)+WPy*VS1(32,8)&
   +2D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))
VS0(50,9)=PAy*VS0(32,9)+WPy*VS1(32,9)&
   +2D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(32,4)
VS0(50,10)=PAy*VS0(32,10)+WPy*VS1(32,10)&
   +2D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))
VS0(51,5)=PAz*VS0(30,5)+WPz*VS1(30,5)+r1x2Z*VR1(30,5)&
   +2D0*r1x2Z*(VS0(15,5)-ExZpE*VS1(15,5))
VS0(51,6)=PAz*VS0(30,6)+WPz*VS1(30,6)+r1x2Z*VR1(30,6)&
   +2D0*r1x2Z*(VS0(15,6)-ExZpE*VS1(15,6))
VS0(51,7)=PAz*VS0(30,7)+WPz*VS1(30,7)+r1x2Z*VR1(30,7)&
   +2D0*r1x2Z*(VS0(15,7)-ExZpE*VS1(15,7))
VS0(51,8)=PAz*VS0(30,8)+WPz*VS1(30,8)+r1x2Z*VR1(30,8)&
   +2D0*r1x2Z*(VS0(15,8)-ExZpE*VS1(15,8))&
   +HfxZpE*VS1(30,2)
VS0(51,9)=PAz*VS0(30,9)+WPz*VS1(30,9)+r1x2Z*VR1(30,9)&
   +2D0*r1x2Z*(VS0(15,9)-ExZpE*VS1(15,9))&
   +HfxZpE*VS1(30,3)
VS0(51,10)=PAz*VS0(30,10)+WPz*VS1(30,10)+r1x2Z*VR1(30,10)&
   +2D0*r1x2Z*(VS0(15,10)-ExZpE*VS1(15,10))&
   +2D0*HfxZpE*VS1(30,4)
VS0(52,5)=PAz*VS0(31,5)+WPz*VS1(31,5)+r1x2Z*VR1(31,5)&
   +2D0*r1x2Z*(VS0(16,5)-ExZpE*VS1(16,5))
VS0(52,6)=PAz*VS0(31,6)+WPz*VS1(31,6)+r1x2Z*VR1(31,6)&
   +2D0*r1x2Z*(VS0(16,6)-ExZpE*VS1(16,6))
VS0(52,7)=PAz*VS0(31,7)+WPz*VS1(31,7)+r1x2Z*VR1(31,7)&
   +2D0*r1x2Z*(VS0(16,7)-ExZpE*VS1(16,7))
VS0(52,8)=PAz*VS0(31,8)+WPz*VS1(31,8)+r1x2Z*VR1(31,8)&
   +2D0*r1x2Z*(VS0(16,8)-ExZpE*VS1(16,8))&
   +HfxZpE*VS1(31,2)
VS0(52,9)=PAz*VS0(31,9)+WPz*VS1(31,9)+r1x2Z*VR1(31,9)&
   +2D0*r1x2Z*(VS0(16,9)-ExZpE*VS1(16,9))&
   +HfxZpE*VS1(31,3)
VS0(52,10)=PAz*VS0(31,10)+WPz*VS1(31,10)+r1x2Z*VR1(31,10)&
   +2D0*r1x2Z*(VS0(16,10)-ExZpE*VS1(16,10))&
   +2D0*HfxZpE*VS1(31,4)
VS0(53,5)=PAz*VS0(32,5)+WPz*VS1(32,5)+r1x2Z*VR1(32,5)&
   +2D0*r1x2Z*(VS0(17,5)-ExZpE*VS1(17,5))
VS0(53,6)=PAz*VS0(32,6)+WPz*VS1(32,6)+r1x2Z*VR1(32,6)&
   +2D0*r1x2Z*(VS0(17,6)-ExZpE*VS1(17,6))
VS0(53,7)=PAz*VS0(32,7)+WPz*VS1(32,7)+r1x2Z*VR1(32,7)&
   +2D0*r1x2Z*(VS0(17,7)-ExZpE*VS1(17,7))
VS0(53,8)=PAz*VS0(32,8)+WPz*VS1(32,8)+r1x2Z*VR1(32,8)&
   +2D0*r1x2Z*(VS0(17,8)-ExZpE*VS1(17,8))&
   +HfxZpE*VS1(32,2)
VS0(53,9)=PAz*VS0(32,9)+WPz*VS1(32,9)+r1x2Z*VR1(32,9)&
   +2D0*r1x2Z*(VS0(17,9)-ExZpE*VS1(17,9))&
   +HfxZpE*VS1(32,3)
VS0(53,10)=PAz*VS0(32,10)+WPz*VS1(32,10)+r1x2Z*VR1(32,10)&
   +2D0*r1x2Z*(VS0(17,10)-ExZpE*VS1(17,10))&
   +2D0*HfxZpE*VS1(32,4)
VS0(54,5)=PAz*VS0(33,5)+WPz*VS1(33,5)+r1x2Z*VR1(33,5)&
   +3D0*r1x2Z*(VS0(18,5)-ExZpE*VS1(18,5))
VS0(54,6)=PAz*VS0(33,6)+WPz*VS1(33,6)+r1x2Z*VR1(33,6)&
   +3D0*r1x2Z*(VS0(18,6)-ExZpE*VS1(18,6))
VS0(54,7)=PAz*VS0(33,7)+WPz*VS1(33,7)+r1x2Z*VR1(33,7)&
   +3D0*r1x2Z*(VS0(18,7)-ExZpE*VS1(18,7))
VS0(54,8)=PAz*VS0(33,8)+WPz*VS1(33,8)+r1x2Z*VR1(33,8)&
   +3D0*r1x2Z*(VS0(18,8)-ExZpE*VS1(18,8))&
   +HfxZpE*VS1(33,2)
VS0(54,9)=PAz*VS0(33,9)+WPz*VS1(33,9)+r1x2Z*VR1(33,9)&
   +3D0*r1x2Z*(VS0(18,9)-ExZpE*VS1(18,9))&
   +HfxZpE*VS1(33,3)
VS0(54,10)=PAz*VS0(33,10)+WPz*VS1(33,10)+r1x2Z*VR1(33,10)&
   +3D0*r1x2Z*(VS0(18,10)-ExZpE*VS1(18,10))&
   +2D0*HfxZpE*VS1(33,4)
VS0(55,5)=PAz*VS0(34,5)+WPz*VS1(34,5)+r1x2Z*VR1(34,5)&
   +3D0*r1x2Z*(VS0(19,5)-ExZpE*VS1(19,5))
VS0(55,6)=PAz*VS0(34,6)+WPz*VS1(34,6)+r1x2Z*VR1(34,6)&
   +3D0*r1x2Z*(VS0(19,6)-ExZpE*VS1(19,6))
VS0(55,7)=PAz*VS0(34,7)+WPz*VS1(34,7)+r1x2Z*VR1(34,7)&
   +3D0*r1x2Z*(VS0(19,7)-ExZpE*VS1(19,7))
VS0(55,8)=PAz*VS0(34,8)+WPz*VS1(34,8)+r1x2Z*VR1(34,8)&
   +3D0*r1x2Z*(VS0(19,8)-ExZpE*VS1(19,8))&
   +HfxZpE*VS1(34,2)
VS0(55,9)=PAz*VS0(34,9)+WPz*VS1(34,9)+r1x2Z*VR1(34,9)&
   +3D0*r1x2Z*(VS0(19,9)-ExZpE*VS1(19,9))&
   +HfxZpE*VS1(34,3)
VS0(55,10)=PAz*VS0(34,10)+WPz*VS1(34,10)+r1x2Z*VR1(34,10)&
   +3D0*r1x2Z*(VS0(19,10)-ExZpE*VS1(19,10))&
   +2D0*HfxZpE*VS1(34,4)
VS0(56,5)=PAz*VS0(35,5)+WPz*VS1(35,5)+r1x2Z*VR1(35,5)&
   +4D0*r1x2Z*(VS0(20,5)-ExZpE*VS1(20,5))
VS0(56,6)=PAz*VS0(35,6)+WPz*VS1(35,6)+r1x2Z*VR1(35,6)&
   +4D0*r1x2Z*(VS0(20,6)-ExZpE*VS1(20,6))
VS0(56,7)=PAz*VS0(35,7)+WPz*VS1(35,7)+r1x2Z*VR1(35,7)&
   +4D0*r1x2Z*(VS0(20,7)-ExZpE*VS1(20,7))
VS0(56,8)=PAz*VS0(35,8)+WPz*VS1(35,8)+r1x2Z*VR1(35,8)&
   +4D0*r1x2Z*(VS0(20,8)-ExZpE*VS1(20,8))&
   +HfxZpE*VS1(35,2)
VS0(56,9)=PAz*VS0(35,9)+WPz*VS1(35,9)+r1x2Z*VR1(35,9)&
   +4D0*r1x2Z*(VS0(20,9)-ExZpE*VS1(20,9))&
   +HfxZpE*VS1(35,3)
VS0(56,10)=PAz*VS0(35,10)+WPz*VS1(35,10)+r1x2Z*VR1(35,10)&
   +4D0*r1x2Z*(VS0(20,10)-ExZpE*VS1(20,10))&
   +2D0*HfxZpE*VS1(35,4)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRh0d0'
STOP
END SELECT
END SUBROUTINE MVRRh0d0
