!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0i0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(21,23)
      V(2)=3.D0*V(1)
      V(3)=r1x2E*ZxZpE*VRR1(21,23)
      V(4)=-3.D0*V(3)
      V(5)=HfxZpE*VRR1(11,39)
      V(6)=HfxZpE*VRR1(11,44)
      V(7)=HfxZpE*VRR1(11,45)
      V(8)=r1x2E*VRR0(21,30)
      V(9)=3.D0*V(8)
      V(10)=r1x2E*ZxZpE*VRR1(21,30)
      V(11)=-3.D0*V(10)
      V(12)=HfxZpE*VRR1(11,48)
      V(13)=HfxZpE*VRR1(11,49)
      V(14)=HfxZpE*VRR1(11,50)
      V(15)=r1x2E*VRR0(21,32)
      V(16)=3.D0*V(15)
      V(17)=r1x2E*ZxZpE*VRR1(21,32)
      V(18)=-3.D0*V(17)
      V(19)=HfxZpE*VRR1(11,51)
      V(20)=HfxZpE*VRR1(11,52)
      V(21)=HfxZpE*VRR1(11,53)
      V(22)=r1x2E*VRR0(22,23)
      V(23)=3.D0*V(22)
      V(24)=r1x2E*ZxZpE*VRR1(22,23)
      V(25)=-3.D0*V(24)
      V(26)=r1x2E*VRR0(22,24)
      V(27)=HfxZpE*VRR1(12,39)
      V(28)=r1x2E*ZxZpE*VRR1(22,24)
      V(29)=r1x2E*VRR0(22,27)
      V(30)=r1x2E*ZxZpE*VRR1(22,27)
      V(31)=r1x2E*VRR0(22,28)
      V(32)=2.D0*V(31)
      V(33)=HfxZpE*VRR1(12,44)
      V(34)=r1x2E*ZxZpE*VRR1(22,28)
      V(35)=-2.D0*V(34)
      V(36)=2.D0*V(29)
      V(37)=-2.D0*V(30)
      V(38)=r1x2E*VRR0(22,30)
      V(39)=3.D0*V(38)
      V(40)=r1x2E*ZxZpE*VRR1(22,30)
      V(41)=-3.D0*V(40)
      V(42)=r1x2E*VRR0(22,31)
      V(43)=2.D0*V(42)
      V(44)=HfxZpE*VRR1(12,48)
      V(45)=r1x2E*ZxZpE*VRR1(22,31)
      V(46)=-2.D0*V(45)
      V(47)=r1x2Z*VRR0(6,72)
      V(48)=2.D0*V(47)
      V(49)=ExZpE*r1x2Z*VRR1(6,72)
      V(50)=-2.D0*V(49)
      V(51)=HfxZpE*VRR1(12,49)
      V(52)=2.D0*V(51)
      V(53)=r1x2E*VRR0(22,32)
      V(54)=3.D0*V(53)
      V(55)=r1x2E*ZxZpE*VRR1(22,32)
      V(56)=-3.D0*V(55)
      V(57)=r1x2E*VRR0(22,33)
      V(58)=HfxZpE*VRR1(12,51)
      V(59)=r1x2E*ZxZpE*VRR1(22,33)
      V(60)=r1x2E*VRR0(22,34)
      V(61)=r1x2E*ZxZpE*VRR1(22,34)
      V(62)=r1x2E*VRR0(23,23)
      V(63)=3.D0*V(62)
      V(64)=r1x2E*ZxZpE*VRR1(23,23)
      V(65)=-3.D0*V(64)
      V(66)=r1x2E*VRR0(23,24)
      V(67)=HfxZpE*VRR1(13,39)
      V(68)=r1x2E*ZxZpE*VRR1(23,24)
      V(69)=r1x2E*VRR0(23,27)
      V(70)=r1x2E*ZxZpE*VRR1(23,27)
      V(71)=r1x2E*VRR0(23,28)
      V(72)=2.D0*V(71)
      V(73)=HfxZpE*VRR1(13,44)
      V(74)=r1x2E*ZxZpE*VRR1(23,28)
      V(75)=-2.D0*V(74)
      V(76)=2.D0*V(69)
      V(77)=-2.D0*V(70)
      V(78)=r1x2E*VRR0(23,30)
      V(79)=3.D0*V(78)
      V(80)=r1x2E*ZxZpE*VRR1(23,30)
      V(81)=-3.D0*V(80)
      V(82)=r1x2E*VRR0(23,31)
      V(83)=2.D0*V(82)
      V(84)=HfxZpE*VRR1(13,48)
      V(85)=2.D0*V(84)
      V(86)=r1x2E*ZxZpE*VRR1(23,31)
      V(87)=-2.D0*V(86)
      V(88)=r1x2E*VRR0(23,32)
      V(89)=HfxZpE*VRR1(13,49)
      V(90)=r1x2E*ZxZpE*VRR1(23,32)
      V(91)=3.D0*V(88)
      V(92)=-3.D0*V(90)
      V(93)=r1x2E*VRR0(23,33)
      V(94)=HfxZpE*VRR1(13,51)
      V(95)=r1x2E*ZxZpE*VRR1(23,33)
      V(96)=r1x2E*VRR0(23,34)
      V(97)=HfxZpE*VRR1(12,53)
      V(98)=r1x2E*ZxZpE*VRR1(23,34)
      V(99)=r1x2E*VRR0(24,23)
      V(100)=3.D0*V(99)
      V(101)=HfxZpE*VRR1(14,38)
      V(102)=r1x2E*ZxZpE*VRR1(24,23)
      V(103)=-3.D0*V(102)
      V(104)=r1x2E*VRR0(24,24)
      V(105)=HfxZpE*VRR1(14,39)
      V(106)=r1x2E*ZxZpE*VRR1(24,24)
      V(107)=r1x2E*VRR0(24,27)
      V(108)=HfxZpE*VRR1(14,43)
      V(109)=r1x2E*ZxZpE*VRR1(24,27)
      V(110)=r1x2E*VRR0(24,28)
      V(111)=2.D0*V(110)
      V(112)=HfxZpE*VRR1(14,44)
      V(113)=r1x2E*ZxZpE*VRR1(24,28)
      V(114)=-2.D0*V(113)
      V(115)=2.D0*V(107)
      V(116)=-2.D0*V(109)
      V(117)=r1x2E*VRR0(24,30)
      V(118)=3.D0*V(117)
      V(119)=HfxZpE*VRR1(14,47)
      V(120)=r1x2E*ZxZpE*VRR1(24,30)
      V(121)=-3.D0*V(120)
      V(122)=r1x2E*VRR0(24,31)
      V(123)=2.D0*V(122)
      V(124)=HfxZpE*VRR1(14,48)
      V(125)=r1x2E*ZxZpE*VRR1(24,31)
      V(126)=-2.D0*V(125)
      V(127)=r1x2E*VRR0(24,32)
      V(128)=3.D0*V(127)
      V(129)=r1x2E*ZxZpE*VRR1(24,32)
      V(130)=-3.D0*V(129)
      V(131)=r1x2E*VRR0(24,33)
      V(132)=HfxZpE*VRR1(14,51)
      V(133)=r1x2E*ZxZpE*VRR1(24,33)
      V(134)=r1x2E*VRR0(24,34)
      V(135)=HfxZpE*VRR1(13,53)
      V(136)=r1x2E*ZxZpE*VRR1(24,34)
      V(137)=r1x2E*VRR0(25,23)
      V(138)=3.D0*V(137)
      V(139)=r1x2E*ZxZpE*VRR1(25,23)
      V(140)=-3.D0*V(139)
      V(141)=r1x2E*VRR0(25,30)
      V(142)=3.D0*V(141)
      V(143)=r1x2E*ZxZpE*VRR1(25,30)
      V(144)=-3.D0*V(143)
      V(145)=HfxZpE*VRR1(14,49)
      V(146)=r1x2E*VRR0(25,32)
      V(147)=3.D0*V(146)
      V(148)=r1x2E*ZxZpE*VRR1(25,32)
      V(149)=-3.D0*V(148)
      V(150)=HfxZpE*VRR1(14,52)
      V(151)=HfxZpE*VRR1(14,53)
      V(152)=r1x2E*VRR0(26,23)
      V(153)=3.D0*V(152)
      V(154)=r1x2E*ZxZpE*VRR1(26,23)
      V(155)=-3.D0*V(154)
      V(156)=r1x2E*VRR0(26,24)
      V(157)=HfxZpE*VRR1(15,39)
      V(158)=r1x2E*ZxZpE*VRR1(26,24)
      V(159)=r1x2E*VRR0(26,27)
      V(160)=r1x2E*ZxZpE*VRR1(26,27)
      V(161)=r1x2E*VRR0(26,28)
      V(162)=2.D0*V(161)
      V(163)=HfxZpE*VRR1(15,44)
      V(164)=r1x2E*ZxZpE*VRR1(26,28)
      V(165)=-2.D0*V(164)
      V(166)=2.D0*V(159)
      V(167)=-2.D0*V(160)
      V(168)=r1x2E*VRR0(26,30)
      V(169)=3.D0*V(168)
      V(170)=r1x2E*ZxZpE*VRR1(26,30)
      V(171)=-3.D0*V(170)
      V(172)=r1x2E*VRR0(26,31)
      V(173)=2.D0*V(172)
      V(174)=HfxZpE*VRR1(15,48)
      V(175)=r1x2E*ZxZpE*VRR1(26,31)
      V(176)=-2.D0*V(175)
      V(177)=r1x2Z*VRR0(8,72)
      V(178)=2.D0*V(177)
      V(179)=ExZpE*r1x2Z*VRR1(8,72)
      V(180)=-2.D0*V(179)
      V(181)=HfxZpE*VRR1(15,49)
      V(182)=2.D0*V(181)
      V(183)=r1x2E*VRR0(26,32)
      V(184)=3.D0*V(183)
      V(185)=r1x2E*ZxZpE*VRR1(26,32)
      V(186)=-3.D0*V(185)
      V(187)=r1x2E*VRR0(26,33)
      V(188)=HfxZpE*VRR1(15,51)
      V(189)=r1x2E*ZxZpE*VRR1(26,33)
      V(190)=r1x2E*VRR0(26,34)
      V(191)=r1x2E*ZxZpE*VRR1(26,34)
      V(192)=r1x2E*VRR0(27,23)
      V(193)=3.D0*V(192)
      V(194)=r1x2E*ZxZpE*VRR1(27,23)
      V(195)=-3.D0*V(194)
      V(196)=r1x2E*VRR0(27,24)
      V(197)=HfxZpE*VRR1(16,39)
      V(198)=2.D0*V(197)
      V(199)=r1x2E*ZxZpE*VRR1(27,24)
      V(200)=r1x2E*VRR0(27,27)
      V(201)=r1x2E*ZxZpE*VRR1(27,27)
      V(202)=r1x2E*VRR0(27,28)
      V(203)=2.D0*V(202)
      V(204)=HfxZpE*VRR1(16,44)
      V(205)=2.D0*V(204)
      V(206)=r1x2E*ZxZpE*VRR1(27,28)
      V(207)=-2.D0*V(206)
      V(208)=2.D0*V(200)
      V(209)=-2.D0*V(201)
      V(210)=r1x2E*VRR0(27,30)
      V(211)=3.D0*V(210)
      V(212)=r1x2E*ZxZpE*VRR1(27,30)
      V(213)=-3.D0*V(212)
      V(214)=r1x2E*VRR0(27,31)
      V(215)=2.D0*V(214)
      V(216)=HfxZpE*VRR1(16,48)
      V(217)=2.D0*V(216)
      V(218)=r1x2E*ZxZpE*VRR1(27,31)
      V(219)=-2.D0*V(218)
      V(220)=r1x2E*VRR0(27,32)
      V(221)=HfxZpE*VRR1(16,49)
      V(222)=2.D0*V(221)
      V(223)=r1x2E*ZxZpE*VRR1(27,32)
      V(224)=3.D0*V(220)
      V(225)=-3.D0*V(223)
      V(226)=r1x2E*VRR0(27,33)
      V(227)=HfxZpE*VRR1(16,51)
      V(228)=2.D0*V(227)
      V(229)=r1x2E*ZxZpE*VRR1(27,33)
      V(230)=r1x2E*VRR0(27,34)
      V(231)=HfxZpE*VRR1(15,53)
      V(232)=r1x2E*ZxZpE*VRR1(27,34)
      V(233)=r1x2E*VRR0(28,23)
      V(234)=3.D0*V(233)
      V(235)=r1x2E*ZxZpE*VRR1(28,23)
      V(236)=-3.D0*V(235)
      V(237)=r1x2E*VRR0(28,24)
      V(238)=HfxZpE*VRR1(17,39)
      V(239)=r1x2E*ZxZpE*VRR1(28,24)
      V(240)=r1x2E*VRR0(28,27)
      V(241)=r1x2E*ZxZpE*VRR1(28,27)
      V(242)=r1x2E*VRR0(28,28)
      V(243)=2.D0*V(242)
      V(244)=HfxZpE*VRR1(17,44)
      V(245)=r1x2E*ZxZpE*VRR1(28,28)
      V(246)=-2.D0*V(245)
      V(247)=2.D0*V(240)
      V(248)=-2.D0*V(241)
      V(249)=r1x2E*VRR0(28,30)
      V(250)=3.D0*V(249)
      V(251)=r1x2E*ZxZpE*VRR1(28,30)
      V(252)=-3.D0*V(251)
      V(253)=r1x2E*VRR0(28,31)
      V(254)=2.D0*V(253)
      V(255)=HfxZpE*VRR1(17,48)
      V(256)=r1x2E*ZxZpE*VRR1(28,31)
      V(257)=-2.D0*V(256)
      V(258)=r1x2E*VRR0(28,32)
      V(259)=HfxZpE*VRR1(17,49)
      V(260)=r1x2E*ZxZpE*VRR1(28,32)
      V(261)=3.D0*V(258)
      V(262)=-3.D0*V(260)
      V(263)=r1x2E*VRR0(28,33)
      V(264)=HfxZpE*VRR1(17,51)
      V(265)=r1x2E*ZxZpE*VRR1(28,33)
      V(266)=r1x2E*VRR0(28,34)
      V(267)=HfxZpE*VRR1(16,53)
      V(268)=2.D0*V(267)
      V(269)=r1x2E*ZxZpE*VRR1(28,34)
      V(270)=r1x2E*VRR0(29,23)
      V(271)=3.D0*V(270)
      V(272)=r1x2E*ZxZpE*VRR1(29,23)
      V(273)=-3.D0*V(272)
      V(274)=r1x2E*VRR0(29,24)
      V(275)=r1x2E*ZxZpE*VRR1(29,24)
      V(276)=r1x2E*VRR0(29,27)
      V(277)=r1x2E*ZxZpE*VRR1(29,27)
      V(278)=r1x2E*VRR0(29,28)
      V(279)=2.D0*V(278)
      V(280)=r1x2E*ZxZpE*VRR1(29,28)
      V(281)=-2.D0*V(280)
      V(282)=2.D0*V(276)
      V(283)=-2.D0*V(277)
      V(284)=r1x2E*VRR0(29,30)
      V(285)=3.D0*V(284)
      V(286)=r1x2E*ZxZpE*VRR1(29,30)
      V(287)=-3.D0*V(286)
      V(288)=r1x2E*VRR0(29,31)
      V(289)=2.D0*V(288)
      V(290)=r1x2E*ZxZpE*VRR1(29,31)
      V(291)=-2.D0*V(290)
      V(292)=r1x2Z*VRR0(9,72)
      V(293)=2.D0*V(292)
      V(294)=ExZpE*r1x2Z*VRR1(9,72)
      V(295)=-2.D0*V(294)
      V(296)=2.D0*V(255)
      V(297)=r1x2E*VRR0(29,32)
      V(298)=3.D0*V(297)
      V(299)=r1x2E*ZxZpE*VRR1(29,32)
      V(300)=-3.D0*V(299)
      V(301)=r1x2E*VRR0(29,33)
      V(302)=r1x2E*ZxZpE*VRR1(29,33)
      V(303)=r1x2E*VRR0(29,34)
      V(304)=HfxZpE*VRR1(17,53)
      V(305)=r1x2E*ZxZpE*VRR1(29,34)
      V(306)=r1x2E*VRR0(30,23)
      V(307)=3.D0*V(306)
      V(308)=r1x2E*ZxZpE*VRR1(30,23)
      V(309)=-3.D0*V(308)
      V(310)=r1x2E*VRR0(30,24)
      V(311)=HfxZpE*VRR1(18,39)
      V(312)=r1x2E*ZxZpE*VRR1(30,24)
      V(313)=r1x2E*VRR0(30,27)
      V(314)=r1x2E*ZxZpE*VRR1(30,27)
      V(315)=r1x2E*VRR0(30,28)
      V(316)=2.D0*V(315)
      V(317)=HfxZpE*VRR1(18,44)
      V(318)=2.D0*V(317)
      V(319)=r1x2E*ZxZpE*VRR1(30,28)
      V(320)=-2.D0*V(319)
      V(321)=2.D0*V(313)
      V(322)=-2.D0*V(314)
      V(323)=r1x2E*VRR0(30,30)
      V(324)=3.D0*V(323)
      V(325)=r1x2E*ZxZpE*VRR1(30,30)
      V(326)=-3.D0*V(325)
      V(327)=r1x2E*VRR0(30,31)
      V(328)=2.D0*V(327)
      V(329)=HfxZpE*VRR1(18,48)
      V(330)=r1x2E*ZxZpE*VRR1(30,31)
      V(331)=-2.D0*V(330)
      V(332)=r1x2E*VRR0(30,32)
      V(333)=HfxZpE*VRR1(18,49)
      V(334)=r1x2E*ZxZpE*VRR1(30,32)
      V(335)=3.D0*V(332)
      V(336)=-3.D0*V(334)
      V(337)=r1x2E*VRR0(30,33)
      V(338)=HfxZpE*VRR1(18,51)
      V(339)=r1x2E*ZxZpE*VRR1(30,33)
      V(340)=r1x2E*VRR0(30,34)
      V(341)=r1x2E*ZxZpE*VRR1(30,34)
      V(342)=r1x2E*VRR0(31,23)
      V(343)=3.D0*V(342)
      V(344)=r1x2E*ZxZpE*VRR1(31,23)
      V(345)=-3.D0*V(344)
      V(346)=r1x2E*VRR0(31,24)
      V(347)=HfxZpE*VRR1(19,39)
      V(348)=r1x2E*ZxZpE*VRR1(31,24)
      V(349)=r1x2E*VRR0(31,27)
      V(350)=r1x2E*ZxZpE*VRR1(31,27)
      V(351)=r1x2E*VRR0(31,28)
      V(352)=2.D0*V(351)
      V(353)=HfxZpE*VRR1(19,44)
      V(354)=r1x2E*ZxZpE*VRR1(31,28)
      V(355)=-2.D0*V(354)
      V(356)=2.D0*V(349)
      V(357)=-2.D0*V(350)
      V(358)=r1x2E*VRR0(31,30)
      V(359)=3.D0*V(358)
      V(360)=r1x2E*ZxZpE*VRR1(31,30)
      V(361)=-3.D0*V(360)
      V(362)=r1x2E*VRR0(31,31)
      V(363)=2.D0*V(362)
      V(364)=HfxZpE*VRR1(19,48)
      V(365)=r1x2E*ZxZpE*VRR1(31,31)
      V(366)=-2.D0*V(365)
      V(367)=r1x2E*VRR0(31,32)
      V(368)=HfxZpE*VRR1(19,49)
      V(369)=r1x2E*ZxZpE*VRR1(31,32)
      V(370)=3.D0*V(367)
      V(371)=-3.D0*V(369)
      V(372)=r1x2E*VRR0(31,33)
      V(373)=HfxZpE*VRR1(19,51)
      V(374)=r1x2E*ZxZpE*VRR1(31,33)
      V(375)=r1x2E*VRR0(31,34)
      V(376)=HfxZpE*VRR1(18,53)
      V(377)=r1x2E*ZxZpE*VRR1(31,34)
      V(378)=r1x2E*VRR0(32,23)
      V(379)=3.D0*V(378)
      V(380)=r1x2E*ZxZpE*VRR1(32,23)
      V(381)=-3.D0*V(380)
      V(382)=r1x2E*VRR0(32,24)
      V(383)=r1x2E*ZxZpE*VRR1(32,24)
      V(384)=r1x2E*VRR0(32,27)
      V(385)=r1x2E*ZxZpE*VRR1(32,27)
      V(386)=r1x2E*VRR0(32,28)
      V(387)=2.D0*V(386)
      V(388)=r1x2E*ZxZpE*VRR1(32,28)
      V(389)=-2.D0*V(388)
      V(390)=2.D0*V(384)
      V(391)=2.D0*V(353)
      V(392)=-2.D0*V(385)
      V(393)=r1x2E*VRR0(32,30)
      V(394)=3.D0*V(393)
      V(395)=r1x2E*ZxZpE*VRR1(32,30)
      V(396)=-3.D0*V(395)
      V(397)=r1x2E*VRR0(32,31)
      V(398)=2.D0*V(397)
      V(399)=r1x2E*ZxZpE*VRR1(32,31)
      V(400)=-2.D0*V(399)
      V(401)=r1x2E*VRR0(32,32)
      V(402)=r1x2E*ZxZpE*VRR1(32,32)
      V(403)=3.D0*V(401)
      V(404)=-3.D0*V(402)
      V(405)=r1x2E*VRR0(32,33)
      V(406)=r1x2E*ZxZpE*VRR1(32,33)
      V(407)=r1x2E*VRR0(32,34)
      V(408)=HfxZpE*VRR1(19,53)
      V(409)=r1x2E*ZxZpE*VRR1(32,34)
      V(410)=r1x2E*VRR0(33,23)
      V(411)=3.D0*V(410)
      V(412)=HfxZpE*VRR1(20,38)
      V(413)=r1x2E*ZxZpE*VRR1(33,23)
      V(414)=-3.D0*V(413)
      V(415)=r1x2E*VRR0(33,24)
      V(416)=HfxZpE*VRR1(20,39)
      V(417)=r1x2E*ZxZpE*VRR1(33,24)
      V(418)=r1x2E*VRR0(33,27)
      V(419)=HfxZpE*VRR1(20,43)
      V(420)=r1x2E*ZxZpE*VRR1(33,27)
      V(421)=r1x2E*VRR0(33,28)
      V(422)=2.D0*V(421)
      V(423)=HfxZpE*VRR1(20,44)
      V(424)=r1x2E*ZxZpE*VRR1(33,28)
      V(425)=-2.D0*V(424)
      V(426)=2.D0*V(418)
      V(427)=-2.D0*V(420)
      V(428)=r1x2E*VRR0(33,30)
      V(429)=3.D0*V(428)
      V(430)=HfxZpE*VRR1(20,47)
      V(431)=r1x2E*ZxZpE*VRR1(33,30)
      V(432)=-3.D0*V(431)
      V(433)=r1x2E*VRR0(33,31)
      V(434)=2.D0*V(433)
      V(435)=HfxZpE*VRR1(20,48)
      V(436)=r1x2E*ZxZpE*VRR1(33,31)
      V(437)=-2.D0*V(436)
      V(438)=r1x2E*VRR0(33,32)
      V(439)=3.D0*V(438)
      V(440)=r1x2E*ZxZpE*VRR1(33,32)
      V(441)=-3.D0*V(440)
      V(442)=r1x2E*VRR0(33,33)
      V(443)=HfxZpE*VRR1(20,51)
      V(444)=r1x2E*ZxZpE*VRR1(33,33)
      V(445)=r1x2E*VRR0(33,34)
      V(446)=r1x2E*ZxZpE*VRR1(33,34)
      V(447)=r1x2E*VRR0(34,23)
      V(448)=3.D0*V(447)
      V(449)=r1x2E*ZxZpE*VRR1(34,23)
      V(450)=-3.D0*V(449)
      V(451)=r1x2E*VRR0(34,24)
      V(452)=r1x2E*ZxZpE*VRR1(34,24)
      V(453)=r1x2E*VRR0(34,27)
      V(454)=r1x2E*ZxZpE*VRR1(34,27)
      V(455)=r1x2E*VRR0(34,28)
      V(456)=2.D0*V(455)
      V(457)=r1x2E*ZxZpE*VRR1(34,28)
      V(458)=-2.D0*V(457)
      V(459)=2.D0*V(453)
      V(460)=-2.D0*V(454)
      V(461)=HfxZpE*VRR1(20,45)
      V(462)=r1x2E*VRR0(34,30)
      V(463)=3.D0*V(462)
      V(464)=r1x2E*ZxZpE*VRR1(34,30)
      V(465)=-3.D0*V(464)
      V(466)=r1x2E*VRR0(34,31)
      V(467)=2.D0*V(466)
      V(468)=r1x2E*ZxZpE*VRR1(34,31)
      V(469)=-2.D0*V(468)
      V(470)=HfxZpE*VRR1(20,49)
      V(471)=r1x2E*VRR0(34,32)
      V(472)=3.D0*V(471)
      V(473)=HfxZpE*VRR1(20,50)
      V(474)=r1x2E*ZxZpE*VRR1(34,32)
      V(475)=-3.D0*V(474)
      V(476)=r1x2E*VRR0(34,33)
      V(477)=r1x2E*ZxZpE*VRR1(34,33)
      V(478)=r1x2E*VRR0(34,34)
      V(479)=HfxZpE*VRR1(20,53)
      V(480)=r1x2E*ZxZpE*VRR1(34,34)
      V(481)=r1x2E*VRR0(35,23)
      V(482)=3.D0*V(481)
      V(483)=r1x2E*ZxZpE*VRR1(35,23)
      V(484)=-3.D0*V(483)
      V(485)=r1x2E*VRR0(35,30)
      V(486)=3.D0*V(485)
      V(487)=r1x2E*ZxZpE*VRR1(35,30)
      V(488)=-3.D0*V(487)
      V(489)=r1x2E*VRR0(35,32)
      V(490)=3.D0*V(489)
      V(491)=r1x2E*ZxZpE*VRR1(35,32)
      V(492)=-3.D0*V(491)
      VRR0(21,57)=5.D0*r1x2E*VRR0(21,21)+QCx*VRR0(21,36)+4.D0*HfxZpE*VRR1(11,36)-5.D0*r1x2E*ZxZpE*VRR1(21,21)+WQx*VRR1(21,36)
      VRR0(21,58)=4.D0*r1x2E*VRR0(21,22)+QCx*VRR0(21,37)+4.D0*HfxZpE*VRR1(11,37)-4.D0*r1x2E*ZxZpE*VRR1(21,22)+WQx*VRR1(21,37)
      VRR0(21,59)=V(2)+V(4)+QCx*VRR0(21,38)+4.D0*HfxZpE*VRR1(11,38)+WQx*VRR1(21,38)
      VRR0(21,60)=3.D0*V(5)+3.D0*r1x2Z*VRR0(5,60)+PAx*VRR0(11,60)-3.D0*ExZpE*r1x2Z*VRR1(5,60)+WPx*VRR1(11,60)
      VRR0(21,61)=V(2)+V(4)+QCy*VRR0(21,39)+WQy*VRR1(21,39)
      VRR0(21,62)=4.D0*r1x2E*VRR0(21,24)+QCy*VRR0(21,40)-4.D0*r1x2E*ZxZpE*VRR1(21,24)+WQy*VRR1(21,40)
      VRR0(21,63)=5.D0*r1x2E*VRR0(21,25)+QCy*VRR0(21,41)-5.D0*r1x2E*ZxZpE*VRR1(21,25)+WQy*VRR1(21,41)
      VRR0(21,64)=4.D0*r1x2E*VRR0(21,26)+QCx*VRR0(21,42)+4.D0*HfxZpE*VRR1(11,42)-4.D0*r1x2E*ZxZpE*VRR1(21,26)+WQx*VRR1(21,42)
      VRR0(21,65)=3.D0*r1x2E*VRR0(21,27)+QCx*VRR0(21,43)+4.D0*HfxZpE*VRR1(11,43)-3.D0*r1x2E*ZxZpE*VRR1(21,27)+WQx*VRR1(21,43)
      VRR0(21,66)=3.D0*V(6)+3.D0*r1x2Z*VRR0(5,66)+PAx*VRR0(11,66)-3.D0*ExZpE*r1x2Z*VRR1(5,66)+WPx*VRR1(11,66)
      VRR0(21,67)=2.D0*V(7)+3.D0*r1x2Z*VRR0(5,67)+PAx*VRR0(11,67)-3.D0*ExZpE*r1x2Z*VRR1(5,67)+WPx*VRR1(11,67)
      VRR0(21,68)=3.D0*r1x2E*VRR0(21,28)+QCy*VRR0(21,45)-3.D0*r1x2E*ZxZpE*VRR1(21,28)+WQy*VRR1(21,45)
      VRR0(21,69)=4.D0*r1x2E*VRR0(21,29)+QCy*VRR0(21,46)-4.D0*r1x2E*ZxZpE*VRR1(21,29)+WQy*VRR1(21,46)
      VRR0(21,70)=V(9)+V(11)+QCx*VRR0(21,47)+4.D0*HfxZpE*VRR1(11,47)+WQx*VRR1(21,47)
      VRR0(21,71)=3.D0*V(12)+3.D0*r1x2Z*VRR0(5,71)+PAx*VRR0(11,71)-3.D0*ExZpE*r1x2Z*VRR1(5,71)+WPx*VRR1(11,71)
      VRR0(21,72)=2.D0*V(13)+3.D0*r1x2Z*VRR0(5,72)+PAx*VRR0(11,72)-3.D0*ExZpE*r1x2Z*VRR1(5,72)+WPx*VRR1(11,72)
      VRR0(21,73)=V(14)+3.D0*r1x2Z*VRR0(5,73)+PAx*VRR0(11,73)-3.D0*ExZpE*r1x2Z*VRR1(5,73)+WPx*VRR1(11,73)
      VRR0(21,74)=V(16)+V(18)+QCy*VRR0(21,50)+WQy*VRR1(21,50)
      VRR0(21,75)=3.D0*V(19)+3.D0*r1x2Z*VRR0(5,75)+PAx*VRR0(11,75)-3.D0*ExZpE*r1x2Z*VRR1(5,75)+WPx*VRR1(11,75)
      VRR0(21,76)=2.D0*V(20)+3.D0*r1x2Z*VRR0(5,76)+PAx*VRR0(11,76)-3.D0*ExZpE*r1x2Z*VRR1(5,76)+WPx*VRR1(11,76)
      VRR0(21,77)=V(21)+3.D0*r1x2Z*VRR0(5,77)+PAx*VRR0(11,77)-3.D0*ExZpE*r1x2Z*VRR1(5,77)+WPx*VRR1(11,77)
      VRR0(21,78)=3.D0*r1x2Z*VRR0(5,78)+PAx*VRR0(11,78)-3.D0*ExZpE*r1x2Z*VRR1(5,78)+WPx*VRR1(11,78)
      VRR0(21,79)=V(9)+V(11)+QCz*VRR0(21,51)+WQz*VRR1(21,51)
      VRR0(21,80)=3.D0*r1x2E*VRR0(21,31)+QCz*VRR0(21,52)-3.D0*r1x2E*ZxZpE*VRR1(21,31)+WQz*VRR1(21,52)
      VRR0(21,81)=V(16)+V(18)+QCz*VRR0(21,53)+WQz*VRR1(21,53)
      VRR0(21,82)=4.D0*r1x2E*VRR0(21,33)+QCz*VRR0(21,54)-4.D0*r1x2E*ZxZpE*VRR1(21,33)+WQz*VRR1(21,54)
      VRR0(21,83)=4.D0*r1x2E*VRR0(21,34)+QCz*VRR0(21,55)-4.D0*r1x2E*ZxZpE*VRR1(21,34)+WQz*VRR1(21,55)
      VRR0(21,84)=5.D0*r1x2E*VRR0(21,35)+QCz*VRR0(21,56)-5.D0*r1x2E*ZxZpE*VRR1(21,35)+WQz*VRR1(21,56)
      VRR0(22,57)=5.D0*r1x2E*VRR0(22,21)+QCx*VRR0(22,36)+3.D0*HfxZpE*VRR1(12,36)-5.D0*r1x2E*ZxZpE*VRR1(22,21)+WQx*VRR1(22,36)
      VRR0(22,58)=4.D0*r1x2E*VRR0(22,22)+QCx*VRR0(22,37)+3.D0*HfxZpE*VRR1(12,37)-4.D0*r1x2E*ZxZpE*VRR1(22,22)+WQx*VRR1(22,37)
      VRR0(22,59)=V(23)+V(25)+QCx*VRR0(22,38)+3.D0*HfxZpE*VRR1(12,38)+WQx*VRR1(22,38)
      VRR0(22,60)=2.D0*V(26)+3.D0*V(27)-2.D0*V(28)+QCx*VRR0(22,39)+WQx*VRR1(22,39)
      VRR0(22,61)=V(5)+V(23)+V(25)+QCy*VRR0(22,39)+WQy*VRR1(22,39)
      VRR0(22,62)=4.D0*V(26)-4.D0*V(28)+QCy*VRR0(22,40)+HfxZpE*VRR1(11,40)+WQy*VRR1(22,40)
      VRR0(22,63)=5.D0*r1x2E*VRR0(22,25)+QCy*VRR0(22,41)+HfxZpE*VRR1(11,41)-5.D0*r1x2E*ZxZpE*VRR1(22,25)+WQy*VRR1(22,41)
      VRR0(22,64)=4.D0*r1x2E*VRR0(22,26)+QCx*VRR0(22,42)+3.D0*HfxZpE*VRR1(12,42)-4.D0*r1x2E*ZxZpE*VRR1(22,26)+WQx*VRR1(22,42)
      VRR0(22,65)=3.D0*V(29)-3.D0*V(30)+QCx*VRR0(22,43)+3.D0*HfxZpE*VRR1(12,43)+WQx*VRR1(22,43)
      VRR0(22,66)=V(32)+3.D0*V(33)+V(35)+QCx*VRR0(22,44)+WQx*VRR1(22,44)
      VRR0(22,67)=V(6)+V(36)+V(37)+QCy*VRR0(22,44)+WQy*VRR1(22,44)
      VRR0(22,68)=V(7)+3.D0*V(31)-3.D0*V(34)+QCy*VRR0(22,45)+WQy*VRR1(22,45)
      VRR0(22,69)=4.D0*r1x2E*VRR0(22,29)+QCy*VRR0(22,46)+HfxZpE*VRR1(11,46)-4.D0*r1x2E*ZxZpE*VRR1(22,29)+WQy*VRR1(22,46)
      VRR0(22,70)=V(39)+V(41)+QCx*VRR0(22,47)+3.D0*HfxZpE*VRR1(12,47)+WQx*VRR1(22,47)
      VRR0(22,71)=V(43)+3.D0*V(44)+V(46)+QCx*VRR0(22,48)+WQx*VRR1(22,48)
      VRR0(22,72)=V(48)+V(50)+V(52)+PAx*VRR0(12,72)+WPx*VRR1(12,72)
      VRR0(22,73)=V(13)+V(43)+V(46)+QCy*VRR0(22,49)+WQy*VRR1(22,49)
      VRR0(22,74)=V(14)+V(54)+V(56)+QCy*VRR0(22,50)+WQy*VRR1(22,50)
      VRR0(22,75)=2.D0*V(57)+3.D0*V(58)-2.D0*V(59)+QCx*VRR0(22,51)+WQx*VRR1(22,51)
      VRR0(22,76)=V(36)+V(37)+QCz*VRR0(22,48)+WQz*VRR1(22,48)
      VRR0(22,77)=V(32)+V(35)+QCz*VRR0(22,49)+WQz*VRR1(22,49)
      VRR0(22,78)=V(21)+2.D0*V(60)-2.D0*V(61)+QCy*VRR0(22,53)+WQy*VRR1(22,53)
      VRR0(22,79)=V(39)+V(41)+QCz*VRR0(22,51)+WQz*VRR1(22,51)
      VRR0(22,80)=3.D0*V(42)-3.D0*V(45)+QCz*VRR0(22,52)+WQz*VRR1(22,52)
      VRR0(22,81)=V(54)+V(56)+QCz*VRR0(22,53)+WQz*VRR1(22,53)
      VRR0(22,82)=4.D0*V(57)-4.D0*V(59)+QCz*VRR0(22,54)+WQz*VRR1(22,54)
      VRR0(22,83)=4.D0*V(60)-4.D0*V(61)+QCz*VRR0(22,55)+WQz*VRR1(22,55)
      VRR0(22,84)=5.D0*r1x2E*VRR0(22,35)+QCz*VRR0(22,56)-5.D0*r1x2E*ZxZpE*VRR1(22,35)+WQz*VRR1(22,56)
      VRR0(23,57)=5.D0*r1x2E*VRR0(23,21)+QCx*VRR0(23,36)+2.D0*HfxZpE*VRR1(13,36)-5.D0*r1x2E*ZxZpE*VRR1(23,21)+WQx*VRR1(23,36)
      VRR0(23,58)=4.D0*r1x2E*VRR0(23,22)+QCx*VRR0(23,37)+2.D0*HfxZpE*VRR1(13,37)-4.D0*r1x2E*ZxZpE*VRR1(23,22)+WQx*VRR1(23,37)
      VRR0(23,59)=V(63)+V(65)+QCx*VRR0(23,38)+2.D0*HfxZpE*VRR1(13,38)+WQx*VRR1(23,38)
      VRR0(23,60)=2.D0*V(66)+2.D0*V(67)-2.D0*V(68)+QCx*VRR0(23,39)+WQx*VRR1(23,39)
      VRR0(23,61)=2.D0*V(27)+V(63)+V(65)+QCy*VRR0(23,39)+WQy*VRR1(23,39)
      VRR0(23,62)=4.D0*V(66)-4.D0*V(68)+QCy*VRR0(23,40)+2.D0*HfxZpE*VRR1(12,40)+WQy*VRR1(23,40)
      VRR0(23,63)=5.D0*r1x2E*VRR0(23,25)+QCy*VRR0(23,41)+2.D0*HfxZpE*VRR1(12,41)-5.D0*r1x2E*ZxZpE*VRR1(23,25)+WQy*VRR1(23,41)
      VRR0(23,64)=4.D0*r1x2E*VRR0(23,26)+QCx*VRR0(23,42)+2.D0*HfxZpE*VRR1(13,42)-4.D0*r1x2E*ZxZpE*VRR1(23,26)+WQx*VRR1(23,42)
      VRR0(23,65)=3.D0*V(69)-3.D0*V(70)+QCx*VRR0(23,43)+2.D0*HfxZpE*VRR1(13,43)+WQx*VRR1(23,43)
      VRR0(23,66)=V(72)+2.D0*V(73)+V(75)+QCx*VRR0(23,44)+WQx*VRR1(23,44)
      VRR0(23,67)=2.D0*V(33)+V(76)+V(77)+QCy*VRR0(23,44)+WQy*VRR1(23,44)
      VRR0(23,68)=3.D0*V(71)-3.D0*V(74)+QCy*VRR0(23,45)+2.D0*HfxZpE*VRR1(12,45)+WQy*VRR1(23,45)
      VRR0(23,69)=4.D0*r1x2E*VRR0(23,29)+QCy*VRR0(23,46)+2.D0*HfxZpE*VRR1(12,46)-4.D0*r1x2E*ZxZpE*VRR1(23,29)+WQy*VRR1(23,46)
      VRR0(23,70)=V(79)+V(81)+QCx*VRR0(23,47)+2.D0*HfxZpE*VRR1(13,47)+WQx*VRR1(23,47)
      VRR0(23,71)=V(83)+V(85)+V(87)+QCx*VRR0(23,48)+WQx*VRR1(23,48)
      VRR0(23,72)=V(88)+2.D0*V(89)-V(90)+QCx*VRR0(23,49)+WQx*VRR1(23,49)
      VRR0(23,73)=V(52)+V(83)+V(87)+QCy*VRR0(23,49)+WQy*VRR1(23,49)
      VRR0(23,74)=V(91)+V(92)+QCy*VRR0(23,50)+2.D0*HfxZpE*VRR1(12,50)+WQy*VRR1(23,50)
      VRR0(23,75)=2.D0*V(93)+2.D0*V(94)-2.D0*V(95)+QCx*VRR0(23,51)+WQx*VRR1(23,51)
      VRR0(23,76)=V(76)+V(77)+QCz*VRR0(23,48)+WQz*VRR1(23,48)
      VRR0(23,77)=V(72)+V(75)+QCz*VRR0(23,49)+WQz*VRR1(23,49)
      VRR0(23,78)=2.D0*V(96)+2.D0*V(97)-2.D0*V(98)+QCy*VRR0(23,53)+WQy*VRR1(23,53)
      VRR0(23,79)=V(79)+V(81)+QCz*VRR0(23,51)+WQz*VRR1(23,51)
      VRR0(23,80)=3.D0*V(82)-3.D0*V(86)+QCz*VRR0(23,52)+WQz*VRR1(23,52)
      VRR0(23,81)=V(91)+V(92)+QCz*VRR0(23,53)+WQz*VRR1(23,53)
      VRR0(23,82)=4.D0*V(93)-4.D0*V(95)+QCz*VRR0(23,54)+WQz*VRR1(23,54)
      VRR0(23,83)=4.D0*V(96)-4.D0*V(98)+QCz*VRR0(23,55)+WQz*VRR1(23,55)
      VRR0(23,84)=5.D0*r1x2E*VRR0(23,35)+QCz*VRR0(23,56)-5.D0*r1x2E*ZxZpE*VRR1(23,35)+WQz*VRR1(23,56)
      VRR0(24,57)=5.D0*r1x2E*VRR0(24,21)+QCx*VRR0(24,36)+HfxZpE*VRR1(14,36)-5.D0*r1x2E*ZxZpE*VRR1(24,21)+WQx*VRR1(24,36)
      VRR0(24,58)=4.D0*r1x2E*VRR0(24,22)+QCx*VRR0(24,37)+HfxZpE*VRR1(14,37)-4.D0*r1x2E*ZxZpE*VRR1(24,22)+WQx*VRR1(24,37)
      VRR0(24,59)=V(100)+V(101)+V(103)+QCx*VRR0(24,38)+WQx*VRR1(24,38)
      VRR0(24,60)=2.D0*V(104)+V(105)-2.D0*V(106)+QCx*VRR0(24,39)+WQx*VRR1(24,39)
      VRR0(24,61)=3.D0*V(67)+V(100)+V(103)+QCy*VRR0(24,39)+WQy*VRR1(24,39)
      VRR0(24,62)=4.D0*V(104)-4.D0*V(106)+QCy*VRR0(24,40)+3.D0*HfxZpE*VRR1(13,40)+WQy*VRR1(24,40)
      VRR0(24,63)=5.D0*r1x2E*VRR0(24,25)+QCy*VRR0(24,41)+3.D0*HfxZpE*VRR1(13,41)-5.D0*r1x2E*ZxZpE*VRR1(24,25)+WQy*VRR1(24,41)
      VRR0(24,64)=4.D0*r1x2E*VRR0(24,26)+QCx*VRR0(24,42)+HfxZpE*VRR1(14,42)-4.D0*r1x2E*ZxZpE*VRR1(24,26)+WQx*VRR1(24,42)
      VRR0(24,65)=3.D0*V(107)+V(108)-3.D0*V(109)+QCx*VRR0(24,43)+WQx*VRR1(24,43)
      VRR0(24,66)=V(111)+V(112)+V(114)+QCx*VRR0(24,44)+WQx*VRR1(24,44)
      VRR0(24,67)=3.D0*V(73)+V(115)+V(116)+QCy*VRR0(24,44)+WQy*VRR1(24,44)
      VRR0(24,68)=3.D0*V(110)-3.D0*V(113)+QCy*VRR0(24,45)+3.D0*HfxZpE*VRR1(13,45)+WQy*VRR1(24,45)
      VRR0(24,69)=4.D0*r1x2E*VRR0(24,29)+QCy*VRR0(24,46)+3.D0*HfxZpE*VRR1(13,46)-4.D0*r1x2E*ZxZpE*VRR1(24,29)+WQy*VRR1(24,46)
      VRR0(24,70)=V(118)+V(119)+V(121)+QCx*VRR0(24,47)+WQx*VRR1(24,47)
      VRR0(24,71)=V(123)+V(124)+V(126)+QCx*VRR0(24,48)+WQx*VRR1(24,48)
      VRR0(24,72)=V(48)+V(50)+V(85)+PAy*VRR0(13,72)+WPy*VRR1(13,72)
      VRR0(24,73)=3.D0*V(89)+V(123)+V(126)+QCy*VRR0(24,49)+WQy*VRR1(24,49)
      VRR0(24,74)=V(128)+V(130)+QCy*VRR0(24,50)+3.D0*HfxZpE*VRR1(13,50)+WQy*VRR1(24,50)
      VRR0(24,75)=2.D0*V(131)+V(132)-2.D0*V(133)+QCx*VRR0(24,51)+WQx*VRR1(24,51)
      VRR0(24,76)=V(115)+V(116)+QCz*VRR0(24,48)+WQz*VRR1(24,48)
      VRR0(24,77)=V(111)+V(114)+QCz*VRR0(24,49)+WQz*VRR1(24,49)
      VRR0(24,78)=2.D0*V(134)+3.D0*V(135)-2.D0*V(136)+QCy*VRR0(24,53)+WQy*VRR1(24,53)
      VRR0(24,79)=V(118)+V(121)+QCz*VRR0(24,51)+WQz*VRR1(24,51)
      VRR0(24,80)=3.D0*V(122)-3.D0*V(125)+QCz*VRR0(24,52)+WQz*VRR1(24,52)
      VRR0(24,81)=V(128)+V(130)+QCz*VRR0(24,53)+WQz*VRR1(24,53)
      VRR0(24,82)=4.D0*V(131)-4.D0*V(133)+QCz*VRR0(24,54)+WQz*VRR1(24,54)
      VRR0(24,83)=4.D0*V(134)-4.D0*V(136)+QCz*VRR0(24,55)+WQz*VRR1(24,55)
      VRR0(24,84)=5.D0*r1x2E*VRR0(24,35)+QCz*VRR0(24,56)-5.D0*r1x2E*ZxZpE*VRR1(24,35)+WQz*VRR1(24,56)
      VRR0(25,57)=5.D0*r1x2E*VRR0(25,21)+QCx*VRR0(25,36)-5.D0*r1x2E*ZxZpE*VRR1(25,21)+WQx*VRR1(25,36)
      VRR0(25,58)=4.D0*r1x2E*VRR0(25,22)+QCx*VRR0(25,37)-4.D0*r1x2E*ZxZpE*VRR1(25,22)+WQx*VRR1(25,37)
      VRR0(25,59)=V(138)+V(140)+QCx*VRR0(25,38)+WQx*VRR1(25,38)
      VRR0(25,60)=3.D0*V(101)+3.D0*r1x2Z*VRR0(7,60)+PAy*VRR0(14,60)-3.D0*ExZpE*r1x2Z*VRR1(7,60)+WPy*VRR1(14,60)
      VRR0(25,61)=4.D0*V(105)+V(138)+V(140)+QCy*VRR0(25,39)+WQy*VRR1(25,39)
      VRR0(25,62)=4.D0*r1x2E*VRR0(25,24)+QCy*VRR0(25,40)+4.D0*HfxZpE*VRR1(14,40)-4.D0*r1x2E*ZxZpE*VRR1(25,24)+WQy*VRR1(25,40)
      VRR0(25,63)=5.D0*r1x2E*VRR0(25,25)+QCy*VRR0(25,41)+4.D0*HfxZpE*VRR1(14,41)-5.D0*r1x2E*ZxZpE*VRR1(25,25)+WQy*VRR1(25,41)
      VRR0(25,64)=4.D0*r1x2E*VRR0(25,26)+QCx*VRR0(25,42)-4.D0*r1x2E*ZxZpE*VRR1(25,26)+WQx*VRR1(25,42)
      VRR0(25,65)=3.D0*r1x2E*VRR0(25,27)+QCx*VRR0(25,43)-3.D0*r1x2E*ZxZpE*VRR1(25,27)+WQx*VRR1(25,43)
      VRR0(25,66)=2.D0*V(108)+3.D0*r1x2Z*VRR0(7,66)+PAy*VRR0(14,66)-3.D0*ExZpE*r1x2Z*VRR1(7,66)+WPy*VRR1(14,66)
      VRR0(25,67)=3.D0*V(112)+3.D0*r1x2Z*VRR0(7,67)+PAy*VRR0(14,67)-3.D0*ExZpE*r1x2Z*VRR1(7,67)+WPy*VRR1(14,67)
      VRR0(25,68)=3.D0*r1x2E*VRR0(25,28)+QCy*VRR0(25,45)+4.D0*HfxZpE*VRR1(14,45)-3.D0*r1x2E*ZxZpE*VRR1(25,28)+WQy*VRR1(25,45)
      VRR0(25,69)=4.D0*r1x2E*VRR0(25,29)+QCy*VRR0(25,46)+4.D0*HfxZpE*VRR1(14,46)-4.D0*r1x2E*ZxZpE*VRR1(25,29)+WQy*VRR1(25,46)
      VRR0(25,70)=V(142)+V(144)+QCx*VRR0(25,47)+WQx*VRR1(25,47)
      VRR0(25,71)=V(119)+3.D0*r1x2Z*VRR0(7,71)+PAy*VRR0(14,71)-3.D0*ExZpE*r1x2Z*VRR1(7,71)+WPy*VRR1(14,71)
      VRR0(25,72)=2.D0*V(124)+3.D0*r1x2Z*VRR0(7,72)+PAy*VRR0(14,72)-3.D0*ExZpE*r1x2Z*VRR1(7,72)+WPy*VRR1(14,72)
      VRR0(25,73)=3.D0*V(145)+3.D0*r1x2Z*VRR0(7,73)+PAy*VRR0(14,73)-3.D0*ExZpE*r1x2Z*VRR1(7,73)+WPy*VRR1(14,73)
      VRR0(25,74)=V(147)+V(149)+QCy*VRR0(25,50)+4.D0*HfxZpE*VRR1(14,50)+WQy*VRR1(25,50)
      VRR0(25,75)=3.D0*r1x2Z*VRR0(7,75)+PAy*VRR0(14,75)-3.D0*ExZpE*r1x2Z*VRR1(7,75)+WPy*VRR1(14,75)
      VRR0(25,76)=V(132)+3.D0*r1x2Z*VRR0(7,76)+PAy*VRR0(14,76)-3.D0*ExZpE*r1x2Z*VRR1(7,76)+WPy*VRR1(14,76)
      VRR0(25,77)=2.D0*V(150)+3.D0*r1x2Z*VRR0(7,77)+PAy*VRR0(14,77)-3.D0*ExZpE*r1x2Z*VRR1(7,77)+WPy*VRR1(14,77)
      VRR0(25,78)=3.D0*V(151)+3.D0*r1x2Z*VRR0(7,78)+PAy*VRR0(14,78)-3.D0*ExZpE*r1x2Z*VRR1(7,78)+WPy*VRR1(14,78)
      VRR0(25,79)=V(142)+V(144)+QCz*VRR0(25,51)+WQz*VRR1(25,51)
      VRR0(25,80)=3.D0*r1x2E*VRR0(25,31)+QCz*VRR0(25,52)-3.D0*r1x2E*ZxZpE*VRR1(25,31)+WQz*VRR1(25,52)
      VRR0(25,81)=V(147)+V(149)+QCz*VRR0(25,53)+WQz*VRR1(25,53)
      VRR0(25,82)=4.D0*r1x2E*VRR0(25,33)+QCz*VRR0(25,54)-4.D0*r1x2E*ZxZpE*VRR1(25,33)+WQz*VRR1(25,54)
      VRR0(25,83)=4.D0*r1x2E*VRR0(25,34)+QCz*VRR0(25,55)-4.D0*r1x2E*ZxZpE*VRR1(25,34)+WQz*VRR1(25,55)
      VRR0(25,84)=5.D0*r1x2E*VRR0(25,35)+QCz*VRR0(25,56)-5.D0*r1x2E*ZxZpE*VRR1(25,35)+WQz*VRR1(25,56)
      VRR0(26,57)=5.D0*r1x2E*VRR0(26,21)+QCx*VRR0(26,36)+3.D0*HfxZpE*VRR1(15,36)-5.D0*r1x2E*ZxZpE*VRR1(26,21)+WQx*VRR1(26,36)
      VRR0(26,58)=4.D0*r1x2E*VRR0(26,22)+QCx*VRR0(26,37)+3.D0*HfxZpE*VRR1(15,37)-4.D0*r1x2E*ZxZpE*VRR1(26,22)+WQx*VRR1(26,37)
      VRR0(26,59)=V(153)+V(155)+QCx*VRR0(26,38)+3.D0*HfxZpE*VRR1(15,38)+WQx*VRR1(26,38)
      VRR0(26,60)=2.D0*V(156)+3.D0*V(157)-2.D0*V(158)+QCx*VRR0(26,39)+WQx*VRR1(26,39)
      VRR0(26,61)=V(153)+V(155)+QCy*VRR0(26,39)+WQy*VRR1(26,39)
      VRR0(26,62)=4.D0*V(156)-4.D0*V(158)+QCy*VRR0(26,40)+WQy*VRR1(26,40)
      VRR0(26,63)=5.D0*r1x2E*VRR0(26,25)+QCy*VRR0(26,41)-5.D0*r1x2E*ZxZpE*VRR1(26,25)+WQy*VRR1(26,41)
      VRR0(26,64)=4.D0*r1x2E*VRR0(26,26)+QCx*VRR0(26,42)+3.D0*HfxZpE*VRR1(15,42)-4.D0*r1x2E*ZxZpE*VRR1(26,26)+WQx*VRR1(26,42)
      VRR0(26,65)=3.D0*V(159)-3.D0*V(160)+QCx*VRR0(26,43)+3.D0*HfxZpE*VRR1(15,43)+WQx*VRR1(26,43)
      VRR0(26,66)=V(162)+3.D0*V(163)+V(165)+QCx*VRR0(26,44)+WQx*VRR1(26,44)
      VRR0(26,67)=V(166)+V(167)+QCy*VRR0(26,44)+WQy*VRR1(26,44)
      VRR0(26,68)=3.D0*V(161)-3.D0*V(164)+QCy*VRR0(26,45)+WQy*VRR1(26,45)
      VRR0(26,69)=4.D0*r1x2E*VRR0(26,29)+QCy*VRR0(26,46)-4.D0*r1x2E*ZxZpE*VRR1(26,29)+WQy*VRR1(26,46)
      VRR0(26,70)=V(169)+V(171)+QCx*VRR0(26,47)+3.D0*HfxZpE*VRR1(15,47)+WQx*VRR1(26,47)
      VRR0(26,71)=V(173)+3.D0*V(174)+V(176)+QCx*VRR0(26,48)+WQx*VRR1(26,48)
      VRR0(26,72)=V(178)+V(180)+V(182)+PAx*VRR0(15,72)+WPx*VRR1(15,72)
      VRR0(26,73)=V(173)+V(176)+QCy*VRR0(26,49)+WQy*VRR1(26,49)
      VRR0(26,74)=V(184)+V(186)+QCy*VRR0(26,50)+WQy*VRR1(26,50)
      VRR0(26,75)=2.D0*V(187)+3.D0*V(188)-2.D0*V(189)+QCx*VRR0(26,51)+WQx*VRR1(26,51)
      VRR0(26,76)=V(12)+V(166)+V(167)+QCz*VRR0(26,48)+WQz*VRR1(26,48)
      VRR0(26,77)=V(13)+V(162)+V(165)+QCz*VRR0(26,49)+WQz*VRR1(26,49)
      VRR0(26,78)=2.D0*V(190)-2.D0*V(191)+QCy*VRR0(26,53)+WQy*VRR1(26,53)
      VRR0(26,79)=V(19)+V(169)+V(171)+QCz*VRR0(26,51)+WQz*VRR1(26,51)
      VRR0(26,80)=V(20)+3.D0*V(172)-3.D0*V(175)+QCz*VRR0(26,52)+WQz*VRR1(26,52)
      VRR0(26,81)=V(21)+V(184)+V(186)+QCz*VRR0(26,53)+WQz*VRR1(26,53)
      VRR0(26,82)=4.D0*V(187)-4.D0*V(189)+QCz*VRR0(26,54)+HfxZpE*VRR1(11,54)+WQz*VRR1(26,54)
      VRR0(26,83)=4.D0*V(190)-4.D0*V(191)+QCz*VRR0(26,55)+HfxZpE*VRR1(11,55)+WQz*VRR1(26,55)
      VRR0(26,84)=5.D0*r1x2E*VRR0(26,35)+QCz*VRR0(26,56)+HfxZpE*VRR1(11,56)-5.D0*r1x2E*ZxZpE*VRR1(26,35)+WQz*VRR1(26,56)
      VRR0(27,57)=5.D0*r1x2E*VRR0(27,21)+QCx*VRR0(27,36)+2.D0*HfxZpE*VRR1(16,36)-5.D0*r1x2E*ZxZpE*VRR1(27,21)+WQx*VRR1(27,36)
      VRR0(27,58)=4.D0*r1x2E*VRR0(27,22)+QCx*VRR0(27,37)+2.D0*HfxZpE*VRR1(16,37)-4.D0*r1x2E*ZxZpE*VRR1(27,22)+WQx*VRR1(27,37)
      VRR0(27,59)=V(193)+V(195)+QCx*VRR0(27,38)+2.D0*HfxZpE*VRR1(16,38)+WQx*VRR1(27,38)
      VRR0(27,60)=2.D0*V(196)+V(198)-2.D0*V(199)+QCx*VRR0(27,39)+WQx*VRR1(27,39)
      VRR0(27,61)=V(157)+V(193)+V(195)+QCy*VRR0(27,39)+WQy*VRR1(27,39)
      VRR0(27,62)=4.D0*V(196)-4.D0*V(199)+QCy*VRR0(27,40)+HfxZpE*VRR1(15,40)+WQy*VRR1(27,40)
      VRR0(27,63)=5.D0*r1x2E*VRR0(27,25)+QCy*VRR0(27,41)+HfxZpE*VRR1(15,41)-5.D0*r1x2E*ZxZpE*VRR1(27,25)+WQy*VRR1(27,41)
      VRR0(27,64)=4.D0*r1x2E*VRR0(27,26)+QCx*VRR0(27,42)+2.D0*HfxZpE*VRR1(16,42)-4.D0*r1x2E*ZxZpE*VRR1(27,26)+WQx*VRR1(27,42)
      VRR0(27,65)=3.D0*V(200)-3.D0*V(201)+QCx*VRR0(27,43)+2.D0*HfxZpE*VRR1(16,43)+WQx*VRR1(27,43)
      VRR0(27,66)=V(203)+V(205)+V(207)+QCx*VRR0(27,44)+WQx*VRR1(27,44)
      VRR0(27,67)=V(163)+V(208)+V(209)+QCy*VRR0(27,44)+WQy*VRR1(27,44)
      VRR0(27,68)=3.D0*V(202)-3.D0*V(206)+QCy*VRR0(27,45)+HfxZpE*VRR1(15,45)+WQy*VRR1(27,45)
      VRR0(27,69)=4.D0*r1x2E*VRR0(27,29)+QCy*VRR0(27,46)+HfxZpE*VRR1(15,46)-4.D0*r1x2E*ZxZpE*VRR1(27,29)+WQy*VRR1(27,46)
      VRR0(27,70)=V(211)+V(213)+QCx*VRR0(27,47)+2.D0*HfxZpE*VRR1(16,47)+WQx*VRR1(27,47)
      VRR0(27,71)=V(215)+V(217)+V(219)+QCx*VRR0(27,48)+WQx*VRR1(27,48)
      VRR0(27,72)=V(220)+V(222)-V(223)+QCx*VRR0(27,49)+WQx*VRR1(27,49)
      VRR0(27,73)=V(181)+V(215)+V(219)+QCy*VRR0(27,49)+WQy*VRR1(27,49)
      VRR0(27,74)=V(224)+V(225)+QCy*VRR0(27,50)+HfxZpE*VRR1(15,50)+WQy*VRR1(27,50)
      VRR0(27,75)=2.D0*V(226)+V(228)-2.D0*V(229)+QCx*VRR0(27,51)+WQx*VRR1(27,51)
      VRR0(27,76)=V(44)+V(208)+V(209)+QCz*VRR0(27,48)+WQz*VRR1(27,48)
      VRR0(27,77)=V(51)+V(203)+V(207)+QCz*VRR0(27,49)+WQz*VRR1(27,49)
      VRR0(27,78)=2.D0*V(230)+V(231)-2.D0*V(232)+QCy*VRR0(27,53)+WQy*VRR1(27,53)
      VRR0(27,79)=V(58)+V(211)+V(213)+QCz*VRR0(27,51)+WQz*VRR1(27,51)
      VRR0(27,80)=3.D0*V(214)-3.D0*V(218)+QCz*VRR0(27,52)+HfxZpE*VRR1(12,52)+WQz*VRR1(27,52)
      VRR0(27,81)=V(97)+V(224)+V(225)+QCz*VRR0(27,53)+WQz*VRR1(27,53)
      VRR0(27,82)=4.D0*V(226)-4.D0*V(229)+QCz*VRR0(27,54)+HfxZpE*VRR1(12,54)+WQz*VRR1(27,54)
      VRR0(27,83)=4.D0*V(230)-4.D0*V(232)+QCz*VRR0(27,55)+HfxZpE*VRR1(12,55)+WQz*VRR1(27,55)
      VRR0(27,84)=5.D0*r1x2E*VRR0(27,35)+QCz*VRR0(27,56)+HfxZpE*VRR1(12,56)-5.D0*r1x2E*ZxZpE*VRR1(27,35)+WQz*VRR1(27,56)
      VRR0(28,57)=5.D0*r1x2E*VRR0(28,21)+QCx*VRR0(28,36)+HfxZpE*VRR1(17,36)-5.D0*r1x2E*ZxZpE*VRR1(28,21)+WQx*VRR1(28,36)
      VRR0(28,58)=4.D0*r1x2E*VRR0(28,22)+QCx*VRR0(28,37)+HfxZpE*VRR1(17,37)-4.D0*r1x2E*ZxZpE*VRR1(28,22)+WQx*VRR1(28,37)
      VRR0(28,59)=V(234)+V(236)+QCx*VRR0(28,38)+HfxZpE*VRR1(17,38)+WQx*VRR1(28,38)
      VRR0(28,60)=2.D0*V(237)+V(238)-2.D0*V(239)+QCx*VRR0(28,39)+WQx*VRR1(28,39)
      VRR0(28,61)=V(198)+V(234)+V(236)+QCy*VRR0(28,39)+WQy*VRR1(28,39)
      VRR0(28,62)=4.D0*V(237)-4.D0*V(239)+QCy*VRR0(28,40)+2.D0*HfxZpE*VRR1(16,40)+WQy*VRR1(28,40)
      VRR0(28,63)=5.D0*r1x2E*VRR0(28,25)+QCy*VRR0(28,41)+2.D0*HfxZpE*VRR1(16,41)-5.D0*r1x2E*ZxZpE*VRR1(28,25)+WQy*VRR1(28,41)
      VRR0(28,64)=4.D0*r1x2E*VRR0(28,26)+QCx*VRR0(28,42)+HfxZpE*VRR1(17,42)-4.D0*r1x2E*ZxZpE*VRR1(28,26)+WQx*VRR1(28,42)
      VRR0(28,65)=3.D0*V(240)-3.D0*V(241)+QCx*VRR0(28,43)+HfxZpE*VRR1(17,43)+WQx*VRR1(28,43)
      VRR0(28,66)=V(243)+V(244)+V(246)+QCx*VRR0(28,44)+WQx*VRR1(28,44)
      VRR0(28,67)=V(205)+V(247)+V(248)+QCy*VRR0(28,44)+WQy*VRR1(28,44)
      VRR0(28,68)=3.D0*V(242)-3.D0*V(245)+QCy*VRR0(28,45)+2.D0*HfxZpE*VRR1(16,45)+WQy*VRR1(28,45)
      VRR0(28,69)=4.D0*r1x2E*VRR0(28,29)+QCy*VRR0(28,46)+2.D0*HfxZpE*VRR1(16,46)-4.D0*r1x2E*ZxZpE*VRR1(28,29)+WQy*VRR1(28,46)
      VRR0(28,70)=V(250)+V(252)+QCx*VRR0(28,47)+HfxZpE*VRR1(17,47)+WQx*VRR1(28,47)
      VRR0(28,71)=V(254)+V(255)+V(257)+QCx*VRR0(28,48)+WQx*VRR1(28,48)
      VRR0(28,72)=V(258)+V(259)-V(260)+QCx*VRR0(28,49)+WQx*VRR1(28,49)
      VRR0(28,73)=V(222)+V(254)+V(257)+QCy*VRR0(28,49)+WQy*VRR1(28,49)
      VRR0(28,74)=V(261)+V(262)+QCy*VRR0(28,50)+2.D0*HfxZpE*VRR1(16,50)+WQy*VRR1(28,50)
      VRR0(28,75)=2.D0*V(263)+V(264)-2.D0*V(265)+QCx*VRR0(28,51)+WQx*VRR1(28,51)
      VRR0(28,76)=V(84)+V(247)+V(248)+QCz*VRR0(28,48)+WQz*VRR1(28,48)
      VRR0(28,77)=V(89)+V(243)+V(246)+QCz*VRR0(28,49)+WQz*VRR1(28,49)
      VRR0(28,78)=2.D0*V(266)+V(268)-2.D0*V(269)+QCy*VRR0(28,53)+WQy*VRR1(28,53)
      VRR0(28,79)=V(94)+V(250)+V(252)+QCz*VRR0(28,51)+WQz*VRR1(28,51)
      VRR0(28,80)=3.D0*V(253)-3.D0*V(256)+QCz*VRR0(28,52)+HfxZpE*VRR1(13,52)+WQz*VRR1(28,52)
      VRR0(28,81)=V(135)+V(261)+V(262)+QCz*VRR0(28,53)+WQz*VRR1(28,53)
      VRR0(28,82)=4.D0*V(263)-4.D0*V(265)+QCz*VRR0(28,54)+HfxZpE*VRR1(13,54)+WQz*VRR1(28,54)
      VRR0(28,83)=4.D0*V(266)-4.D0*V(269)+QCz*VRR0(28,55)+HfxZpE*VRR1(13,55)+WQz*VRR1(28,55)
      VRR0(28,84)=5.D0*r1x2E*VRR0(28,35)+QCz*VRR0(28,56)+HfxZpE*VRR1(13,56)-5.D0*r1x2E*ZxZpE*VRR1(28,35)+WQz*VRR1(28,56)
      VRR0(29,57)=5.D0*r1x2E*VRR0(29,21)+QCx*VRR0(29,36)-5.D0*r1x2E*ZxZpE*VRR1(29,21)+WQx*VRR1(29,36)
      VRR0(29,58)=4.D0*r1x2E*VRR0(29,22)+QCx*VRR0(29,37)-4.D0*r1x2E*ZxZpE*VRR1(29,22)+WQx*VRR1(29,37)
      VRR0(29,59)=V(271)+V(273)+QCx*VRR0(29,38)+WQx*VRR1(29,38)
      VRR0(29,60)=2.D0*V(274)-2.D0*V(275)+QCx*VRR0(29,39)+WQx*VRR1(29,39)
      VRR0(29,61)=3.D0*V(238)+V(271)+V(273)+QCy*VRR0(29,39)+WQy*VRR1(29,39)
      VRR0(29,62)=4.D0*V(274)-4.D0*V(275)+QCy*VRR0(29,40)+3.D0*HfxZpE*VRR1(17,40)+WQy*VRR1(29,40)
      VRR0(29,63)=5.D0*r1x2E*VRR0(29,25)+QCy*VRR0(29,41)+3.D0*HfxZpE*VRR1(17,41)-5.D0*r1x2E*ZxZpE*VRR1(29,25)+WQy*VRR1(29,41)
      VRR0(29,64)=4.D0*r1x2E*VRR0(29,26)+QCx*VRR0(29,42)-4.D0*r1x2E*ZxZpE*VRR1(29,26)+WQx*VRR1(29,42)
      VRR0(29,65)=3.D0*V(276)-3.D0*V(277)+QCx*VRR0(29,43)+WQx*VRR1(29,43)
      VRR0(29,66)=V(279)+V(281)+QCx*VRR0(29,44)+WQx*VRR1(29,44)
      VRR0(29,67)=3.D0*V(244)+V(282)+V(283)+QCy*VRR0(29,44)+WQy*VRR1(29,44)
      VRR0(29,68)=3.D0*V(278)-3.D0*V(280)+QCy*VRR0(29,45)+3.D0*HfxZpE*VRR1(17,45)+WQy*VRR1(29,45)
      VRR0(29,69)=4.D0*r1x2E*VRR0(29,29)+QCy*VRR0(29,46)+3.D0*HfxZpE*VRR1(17,46)-4.D0*r1x2E*ZxZpE*VRR1(29,29)+WQy*VRR1(29,46)
      VRR0(29,70)=V(285)+V(287)+QCx*VRR0(29,47)+WQx*VRR1(29,47)
      VRR0(29,71)=V(289)+V(291)+QCx*VRR0(29,48)+WQx*VRR1(29,48)
      VRR0(29,72)=V(293)+V(295)+V(296)+PAy*VRR0(17,72)+WPy*VRR1(17,72)
      VRR0(29,73)=3.D0*V(259)+V(289)+V(291)+QCy*VRR0(29,49)+WQy*VRR1(29,49)
      VRR0(29,74)=V(298)+V(300)+QCy*VRR0(29,50)+3.D0*HfxZpE*VRR1(17,50)+WQy*VRR1(29,50)
      VRR0(29,75)=2.D0*V(301)-2.D0*V(302)+QCx*VRR0(29,51)+WQx*VRR1(29,51)
      VRR0(29,76)=V(124)+V(282)+V(283)+QCz*VRR0(29,48)+WQz*VRR1(29,48)
      VRR0(29,77)=V(145)+V(279)+V(281)+QCz*VRR0(29,49)+WQz*VRR1(29,49)
      VRR0(29,78)=2.D0*V(303)+3.D0*V(304)-2.D0*V(305)+QCy*VRR0(29,53)+WQy*VRR1(29,53)
      VRR0(29,79)=V(132)+V(285)+V(287)+QCz*VRR0(29,51)+WQz*VRR1(29,51)
      VRR0(29,80)=V(150)+3.D0*V(288)-3.D0*V(290)+QCz*VRR0(29,52)+WQz*VRR1(29,52)
      VRR0(29,81)=V(151)+V(298)+V(300)+QCz*VRR0(29,53)+WQz*VRR1(29,53)
      VRR0(29,82)=4.D0*V(301)-4.D0*V(302)+QCz*VRR0(29,54)+HfxZpE*VRR1(14,54)+WQz*VRR1(29,54)
      VRR0(29,83)=4.D0*V(303)-4.D0*V(305)+QCz*VRR0(29,55)+HfxZpE*VRR1(14,55)+WQz*VRR1(29,55)
      VRR0(29,84)=5.D0*r1x2E*VRR0(29,35)+QCz*VRR0(29,56)+HfxZpE*VRR1(14,56)-5.D0*r1x2E*ZxZpE*VRR1(29,35)+WQz*VRR1(29,56)
      VRR0(30,57)=5.D0*r1x2E*VRR0(30,21)+QCx*VRR0(30,36)+2.D0*HfxZpE*VRR1(18,36)-5.D0*r1x2E*ZxZpE*VRR1(30,21)+WQx*VRR1(30,36)
      VRR0(30,58)=4.D0*r1x2E*VRR0(30,22)+QCx*VRR0(30,37)+2.D0*HfxZpE*VRR1(18,37)-4.D0*r1x2E*ZxZpE*VRR1(30,22)+WQx*VRR1(30,37)
      VRR0(30,59)=V(307)+V(309)+QCx*VRR0(30,38)+2.D0*HfxZpE*VRR1(18,38)+WQx*VRR1(30,38)
      VRR0(30,60)=2.D0*V(310)+2.D0*V(311)-2.D0*V(312)+QCx*VRR0(30,39)+WQx*VRR1(30,39)
      VRR0(30,61)=V(307)+V(309)+QCy*VRR0(30,39)+WQy*VRR1(30,39)
      VRR0(30,62)=4.D0*V(310)-4.D0*V(312)+QCy*VRR0(30,40)+WQy*VRR1(30,40)
      VRR0(30,63)=5.D0*r1x2E*VRR0(30,25)+QCy*VRR0(30,41)-5.D0*r1x2E*ZxZpE*VRR1(30,25)+WQy*VRR1(30,41)
      VRR0(30,64)=4.D0*r1x2E*VRR0(30,26)+QCx*VRR0(30,42)+2.D0*HfxZpE*VRR1(18,42)-4.D0*r1x2E*ZxZpE*VRR1(30,26)+WQx*VRR1(30,42)
      VRR0(30,65)=3.D0*V(313)-3.D0*V(314)+QCx*VRR0(30,43)+2.D0*HfxZpE*VRR1(18,43)+WQx*VRR1(30,43)
      VRR0(30,66)=V(316)+V(318)+V(320)+QCx*VRR0(30,44)+WQx*VRR1(30,44)
      VRR0(30,67)=V(321)+V(322)+QCy*VRR0(30,44)+WQy*VRR1(30,44)
      VRR0(30,68)=3.D0*V(315)-3.D0*V(319)+QCy*VRR0(30,45)+WQy*VRR1(30,45)
      VRR0(30,69)=4.D0*r1x2E*VRR0(30,29)+QCy*VRR0(30,46)-4.D0*r1x2E*ZxZpE*VRR1(30,29)+WQy*VRR1(30,46)
      VRR0(30,70)=V(324)+V(326)+QCx*VRR0(30,47)+2.D0*HfxZpE*VRR1(18,47)+WQx*VRR1(30,47)
      VRR0(30,71)=V(328)+2.D0*V(329)+V(331)+QCx*VRR0(30,48)+WQx*VRR1(30,48)
      VRR0(30,72)=V(332)+2.D0*V(333)-V(334)+QCx*VRR0(30,49)+WQx*VRR1(30,49)
      VRR0(30,73)=V(328)+V(331)+QCy*VRR0(30,49)+WQy*VRR1(30,49)
      VRR0(30,74)=V(335)+V(336)+QCy*VRR0(30,50)+WQy*VRR1(30,50)
      VRR0(30,75)=2.D0*V(337)+2.D0*V(338)-2.D0*V(339)+QCx*VRR0(30,51)+WQx*VRR1(30,51)
      VRR0(30,76)=2.D0*V(174)+V(321)+V(322)+QCz*VRR0(30,48)+WQz*VRR1(30,48)
      VRR0(30,77)=V(182)+V(316)+V(320)+QCz*VRR0(30,49)+WQz*VRR1(30,49)
      VRR0(30,78)=2.D0*V(340)-2.D0*V(341)+QCy*VRR0(30,53)+WQy*VRR1(30,53)
      VRR0(30,79)=2.D0*V(188)+V(324)+V(326)+QCz*VRR0(30,51)+WQz*VRR1(30,51)
      VRR0(30,80)=3.D0*V(327)-3.D0*V(330)+QCz*VRR0(30,52)+2.D0*HfxZpE*VRR1(15,52)+WQz*VRR1(30,52)
      VRR0(30,81)=2.D0*V(231)+V(335)+V(336)+QCz*VRR0(30,53)+WQz*VRR1(30,53)
      VRR0(30,82)=4.D0*V(337)-4.D0*V(339)+QCz*VRR0(30,54)+2.D0*HfxZpE*VRR1(15,54)+WQz*VRR1(30,54)
      VRR0(30,83)=4.D0*V(340)-4.D0*V(341)+QCz*VRR0(30,55)+2.D0*HfxZpE*VRR1(15,55)+WQz*VRR1(30,55)
      VRR0(30,84)=5.D0*r1x2E*VRR0(30,35)+QCz*VRR0(30,56)+2.D0*HfxZpE*VRR1(15,56)-5.D0*r1x2E*ZxZpE*VRR1(30,35)+WQz*VRR1(30,56)
      VRR0(31,57)=5.D0*r1x2E*VRR0(31,21)+QCx*VRR0(31,36)+HfxZpE*VRR1(19,36)-5.D0*r1x2E*ZxZpE*VRR1(31,21)+WQx*VRR1(31,36)
      VRR0(31,58)=4.D0*r1x2E*VRR0(31,22)+QCx*VRR0(31,37)+HfxZpE*VRR1(19,37)-4.D0*r1x2E*ZxZpE*VRR1(31,22)+WQx*VRR1(31,37)
      VRR0(31,59)=V(343)+V(345)+QCx*VRR0(31,38)+HfxZpE*VRR1(19,38)+WQx*VRR1(31,38)
      VRR0(31,60)=2.D0*V(346)+V(347)-2.D0*V(348)+QCx*VRR0(31,39)+WQx*VRR1(31,39)
      VRR0(31,61)=V(311)+V(343)+V(345)+QCy*VRR0(31,39)+WQy*VRR1(31,39)
      VRR0(31,62)=4.D0*V(346)-4.D0*V(348)+QCy*VRR0(31,40)+HfxZpE*VRR1(18,40)+WQy*VRR1(31,40)
      VRR0(31,63)=5.D0*r1x2E*VRR0(31,25)+QCy*VRR0(31,41)+HfxZpE*VRR1(18,41)-5.D0*r1x2E*ZxZpE*VRR1(31,25)+WQy*VRR1(31,41)
      VRR0(31,64)=4.D0*r1x2E*VRR0(31,26)+QCx*VRR0(31,42)+HfxZpE*VRR1(19,42)-4.D0*r1x2E*ZxZpE*VRR1(31,26)+WQx*VRR1(31,42)
      VRR0(31,65)=3.D0*V(349)-3.D0*V(350)+QCx*VRR0(31,43)+HfxZpE*VRR1(19,43)+WQx*VRR1(31,43)
      VRR0(31,66)=V(352)+V(353)+V(355)+QCx*VRR0(31,44)+WQx*VRR1(31,44)
      VRR0(31,67)=V(317)+V(356)+V(357)+QCy*VRR0(31,44)+WQy*VRR1(31,44)
      VRR0(31,68)=3.D0*V(351)-3.D0*V(354)+QCy*VRR0(31,45)+HfxZpE*VRR1(18,45)+WQy*VRR1(31,45)
      VRR0(31,69)=4.D0*r1x2E*VRR0(31,29)+QCy*VRR0(31,46)+HfxZpE*VRR1(18,46)-4.D0*r1x2E*ZxZpE*VRR1(31,29)+WQy*VRR1(31,46)
      VRR0(31,70)=V(359)+V(361)+QCx*VRR0(31,47)+HfxZpE*VRR1(19,47)+WQx*VRR1(31,47)
      VRR0(31,71)=V(363)+V(364)+V(366)+QCx*VRR0(31,48)+WQx*VRR1(31,48)
      VRR0(31,72)=V(367)+V(368)-V(369)+QCx*VRR0(31,49)+WQx*VRR1(31,49)
      VRR0(31,73)=V(333)+V(363)+V(366)+QCy*VRR0(31,49)+WQy*VRR1(31,49)
      VRR0(31,74)=V(370)+V(371)+QCy*VRR0(31,50)+HfxZpE*VRR1(18,50)+WQy*VRR1(31,50)
      VRR0(31,75)=2.D0*V(372)+V(373)-2.D0*V(374)+QCx*VRR0(31,51)+WQx*VRR1(31,51)
      VRR0(31,76)=V(217)+V(356)+V(357)+QCz*VRR0(31,48)+WQz*VRR1(31,48)
      VRR0(31,77)=V(222)+V(352)+V(355)+QCz*VRR0(31,49)+WQz*VRR1(31,49)
      VRR0(31,78)=2.D0*V(375)+V(376)-2.D0*V(377)+QCy*VRR0(31,53)+WQy*VRR1(31,53)
      VRR0(31,79)=V(228)+V(359)+V(361)+QCz*VRR0(31,51)+WQz*VRR1(31,51)
      VRR0(31,80)=3.D0*V(362)-3.D0*V(365)+QCz*VRR0(31,52)+2.D0*HfxZpE*VRR1(16,52)+WQz*VRR1(31,52)
      VRR0(31,81)=V(268)+V(370)+V(371)+QCz*VRR0(31,53)+WQz*VRR1(31,53)
      VRR0(31,82)=4.D0*V(372)-4.D0*V(374)+QCz*VRR0(31,54)+2.D0*HfxZpE*VRR1(16,54)+WQz*VRR1(31,54)
      VRR0(31,83)=4.D0*V(375)-4.D0*V(377)+QCz*VRR0(31,55)+2.D0*HfxZpE*VRR1(16,55)+WQz*VRR1(31,55)
      VRR0(31,84)=5.D0*r1x2E*VRR0(31,35)+QCz*VRR0(31,56)+2.D0*HfxZpE*VRR1(16,56)-5.D0*r1x2E*ZxZpE*VRR1(31,35)+WQz*VRR1(31,56)
      VRR0(32,57)=5.D0*r1x2E*VRR0(32,21)+QCx*VRR0(32,36)-5.D0*r1x2E*ZxZpE*VRR1(32,21)+WQx*VRR1(32,36)
      VRR0(32,58)=4.D0*r1x2E*VRR0(32,22)+QCx*VRR0(32,37)-4.D0*r1x2E*ZxZpE*VRR1(32,22)+WQx*VRR1(32,37)
      VRR0(32,59)=V(379)+V(381)+QCx*VRR0(32,38)+WQx*VRR1(32,38)
      VRR0(32,60)=2.D0*V(382)-2.D0*V(383)+QCx*VRR0(32,39)+WQx*VRR1(32,39)
      VRR0(32,61)=2.D0*V(347)+V(379)+V(381)+QCy*VRR0(32,39)+WQy*VRR1(32,39)
      VRR0(32,62)=4.D0*V(382)-4.D0*V(383)+QCy*VRR0(32,40)+2.D0*HfxZpE*VRR1(19,40)+WQy*VRR1(32,40)
      VRR0(32,63)=5.D0*r1x2E*VRR0(32,25)+QCy*VRR0(32,41)+2.D0*HfxZpE*VRR1(19,41)-5.D0*r1x2E*ZxZpE*VRR1(32,25)+WQy*VRR1(32,41)
      VRR0(32,64)=4.D0*r1x2E*VRR0(32,26)+QCx*VRR0(32,42)-4.D0*r1x2E*ZxZpE*VRR1(32,26)+WQx*VRR1(32,42)
      VRR0(32,65)=3.D0*V(384)-3.D0*V(385)+QCx*VRR0(32,43)+WQx*VRR1(32,43)
      VRR0(32,66)=V(387)+V(389)+QCx*VRR0(32,44)+WQx*VRR1(32,44)
      VRR0(32,67)=V(390)+V(391)+V(392)+QCy*VRR0(32,44)+WQy*VRR1(32,44)
      VRR0(32,68)=3.D0*V(386)-3.D0*V(388)+QCy*VRR0(32,45)+2.D0*HfxZpE*VRR1(19,45)+WQy*VRR1(32,45)
      VRR0(32,69)=4.D0*r1x2E*VRR0(32,29)+QCy*VRR0(32,46)+2.D0*HfxZpE*VRR1(19,46)-4.D0*r1x2E*ZxZpE*VRR1(32,29)+WQy*VRR1(32,46)
      VRR0(32,70)=V(394)+V(396)+QCx*VRR0(32,47)+WQx*VRR1(32,47)
      VRR0(32,71)=V(398)+V(400)+QCx*VRR0(32,48)+WQx*VRR1(32,48)
      VRR0(32,72)=V(401)-V(402)+QCx*VRR0(32,49)+WQx*VRR1(32,49)
      VRR0(32,73)=2.D0*V(368)+V(398)+V(400)+QCy*VRR0(32,49)+WQy*VRR1(32,49)
      VRR0(32,74)=V(403)+V(404)+QCy*VRR0(32,50)+2.D0*HfxZpE*VRR1(19,50)+WQy*VRR1(32,50)
      VRR0(32,75)=2.D0*V(405)-2.D0*V(406)+QCx*VRR0(32,51)+WQx*VRR1(32,51)
      VRR0(32,76)=V(296)+V(390)+V(392)+QCz*VRR0(32,48)+WQz*VRR1(32,48)
      VRR0(32,77)=2.D0*V(259)+V(387)+V(389)+QCz*VRR0(32,49)+WQz*VRR1(32,49)
      VRR0(32,78)=2.D0*V(407)+2.D0*V(408)-2.D0*V(409)+QCy*VRR0(32,53)+WQy*VRR1(32,53)
      VRR0(32,79)=2.D0*V(264)+V(394)+V(396)+QCz*VRR0(32,51)+WQz*VRR1(32,51)
      VRR0(32,80)=3.D0*V(397)-3.D0*V(399)+QCz*VRR0(32,52)+2.D0*HfxZpE*VRR1(17,52)+WQz*VRR1(32,52)
      VRR0(32,81)=2.D0*V(304)+V(403)+V(404)+QCz*VRR0(32,53)+WQz*VRR1(32,53)
      VRR0(32,82)=4.D0*V(405)-4.D0*V(406)+QCz*VRR0(32,54)+2.D0*HfxZpE*VRR1(17,54)+WQz*VRR1(32,54)
      VRR0(32,83)=4.D0*V(407)-4.D0*V(409)+QCz*VRR0(32,55)+2.D0*HfxZpE*VRR1(17,55)+WQz*VRR1(32,55)
      VRR0(32,84)=5.D0*r1x2E*VRR0(32,35)+QCz*VRR0(32,56)+2.D0*HfxZpE*VRR1(17,56)-5.D0*r1x2E*ZxZpE*VRR1(32,35)+WQz*VRR1(32,56)
      VRR0(33,57)=5.D0*r1x2E*VRR0(33,21)+QCx*VRR0(33,36)+HfxZpE*VRR1(20,36)-5.D0*r1x2E*ZxZpE*VRR1(33,21)+WQx*VRR1(33,36)
      VRR0(33,58)=4.D0*r1x2E*VRR0(33,22)+QCx*VRR0(33,37)+HfxZpE*VRR1(20,37)-4.D0*r1x2E*ZxZpE*VRR1(33,22)+WQx*VRR1(33,37)
      VRR0(33,59)=V(411)+V(412)+V(414)+QCx*VRR0(33,38)+WQx*VRR1(33,38)
      VRR0(33,60)=2.D0*V(415)+V(416)-2.D0*V(417)+QCx*VRR0(33,39)+WQx*VRR1(33,39)
      VRR0(33,61)=V(411)+V(414)+QCy*VRR0(33,39)+WQy*VRR1(33,39)
      VRR0(33,62)=4.D0*V(415)-4.D0*V(417)+QCy*VRR0(33,40)+WQy*VRR1(33,40)
      VRR0(33,63)=5.D0*r1x2E*VRR0(33,25)+QCy*VRR0(33,41)-5.D0*r1x2E*ZxZpE*VRR1(33,25)+WQy*VRR1(33,41)
      VRR0(33,64)=4.D0*r1x2E*VRR0(33,26)+QCx*VRR0(33,42)+HfxZpE*VRR1(20,42)-4.D0*r1x2E*ZxZpE*VRR1(33,26)+WQx*VRR1(33,42)
      VRR0(33,65)=3.D0*V(418)+V(419)-3.D0*V(420)+QCx*VRR0(33,43)+WQx*VRR1(33,43)
      VRR0(33,66)=V(422)+V(423)+V(425)+QCx*VRR0(33,44)+WQx*VRR1(33,44)
      VRR0(33,67)=V(426)+V(427)+QCy*VRR0(33,44)+WQy*VRR1(33,44)
      VRR0(33,68)=3.D0*V(421)-3.D0*V(424)+QCy*VRR0(33,45)+WQy*VRR1(33,45)
      VRR0(33,69)=4.D0*r1x2E*VRR0(33,29)+QCy*VRR0(33,46)-4.D0*r1x2E*ZxZpE*VRR1(33,29)+WQy*VRR1(33,46)
      VRR0(33,70)=V(429)+V(430)+V(432)+QCx*VRR0(33,47)+WQx*VRR1(33,47)
      VRR0(33,71)=V(434)+V(435)+V(437)+QCx*VRR0(33,48)+WQx*VRR1(33,48)
      VRR0(33,72)=V(178)+V(180)+V(318)+PAz*VRR0(18,72)+WPz*VRR1(18,72)
      VRR0(33,73)=V(434)+V(437)+QCy*VRR0(33,49)+WQy*VRR1(33,49)
      VRR0(33,74)=V(439)+V(441)+QCy*VRR0(33,50)+WQy*VRR1(33,50)
      VRR0(33,75)=2.D0*V(442)+V(443)-2.D0*V(444)+QCx*VRR0(33,51)+WQx*VRR1(33,51)
      VRR0(33,76)=3.D0*V(329)+V(426)+V(427)+QCz*VRR0(33,48)+WQz*VRR1(33,48)
      VRR0(33,77)=3.D0*V(333)+V(422)+V(425)+QCz*VRR0(33,49)+WQz*VRR1(33,49)
      VRR0(33,78)=2.D0*V(445)-2.D0*V(446)+QCy*VRR0(33,53)+WQy*VRR1(33,53)
      VRR0(33,79)=3.D0*V(338)+V(429)+V(432)+QCz*VRR0(33,51)+WQz*VRR1(33,51)
      VRR0(33,80)=3.D0*V(433)-3.D0*V(436)+QCz*VRR0(33,52)+3.D0*HfxZpE*VRR1(18,52)+WQz*VRR1(33,52)
      VRR0(33,81)=3.D0*V(376)+V(439)+V(441)+QCz*VRR0(33,53)+WQz*VRR1(33,53)
      VRR0(33,82)=4.D0*V(442)-4.D0*V(444)+QCz*VRR0(33,54)+3.D0*HfxZpE*VRR1(18,54)+WQz*VRR1(33,54)
      VRR0(33,83)=4.D0*V(445)-4.D0*V(446)+QCz*VRR0(33,55)+3.D0*HfxZpE*VRR1(18,55)+WQz*VRR1(33,55)
      VRR0(33,84)=5.D0*r1x2E*VRR0(33,35)+QCz*VRR0(33,56)+3.D0*HfxZpE*VRR1(18,56)-5.D0*r1x2E*ZxZpE*VRR1(33,35)+WQz*VRR1(33,56)
      VRR0(34,57)=5.D0*r1x2E*VRR0(34,21)+QCx*VRR0(34,36)-5.D0*r1x2E*ZxZpE*VRR1(34,21)+WQx*VRR1(34,36)
      VRR0(34,58)=4.D0*r1x2E*VRR0(34,22)+QCx*VRR0(34,37)-4.D0*r1x2E*ZxZpE*VRR1(34,22)+WQx*VRR1(34,37)
      VRR0(34,59)=V(448)+V(450)+QCx*VRR0(34,38)+WQx*VRR1(34,38)
      VRR0(34,60)=2.D0*V(451)-2.D0*V(452)+QCx*VRR0(34,39)+WQx*VRR1(34,39)
      VRR0(34,61)=V(416)+V(448)+V(450)+QCy*VRR0(34,39)+WQy*VRR1(34,39)
      VRR0(34,62)=4.D0*V(451)-4.D0*V(452)+QCy*VRR0(34,40)+HfxZpE*VRR1(20,40)+WQy*VRR1(34,40)
      VRR0(34,63)=5.D0*r1x2E*VRR0(34,25)+QCy*VRR0(34,41)+HfxZpE*VRR1(20,41)-5.D0*r1x2E*ZxZpE*VRR1(34,25)+WQy*VRR1(34,41)
      VRR0(34,64)=4.D0*r1x2E*VRR0(34,26)+QCx*VRR0(34,42)-4.D0*r1x2E*ZxZpE*VRR1(34,26)+WQx*VRR1(34,42)
      VRR0(34,65)=3.D0*V(453)-3.D0*V(454)+QCx*VRR0(34,43)+WQx*VRR1(34,43)
      VRR0(34,66)=V(456)+V(458)+QCx*VRR0(34,44)+WQx*VRR1(34,44)
      VRR0(34,67)=V(423)+V(459)+V(460)+QCy*VRR0(34,44)+WQy*VRR1(34,44)
      VRR0(34,68)=3.D0*V(455)-3.D0*V(457)+V(461)+QCy*VRR0(34,45)+WQy*VRR1(34,45)
      VRR0(34,69)=4.D0*r1x2E*VRR0(34,29)+QCy*VRR0(34,46)+HfxZpE*VRR1(20,46)-4.D0*r1x2E*ZxZpE*VRR1(34,29)+WQy*VRR1(34,46)
      VRR0(34,70)=V(463)+V(465)+QCx*VRR0(34,47)+WQx*VRR1(34,47)
      VRR0(34,71)=V(467)+V(469)+QCx*VRR0(34,48)+WQx*VRR1(34,48)
      VRR0(34,72)=V(293)+V(295)+V(391)+PAz*VRR0(19,72)+WPz*VRR1(19,72)
      VRR0(34,73)=V(467)+V(469)+V(470)+QCy*VRR0(34,49)+WQy*VRR1(34,49)
      VRR0(34,74)=V(472)+V(473)+V(475)+QCy*VRR0(34,50)+WQy*VRR1(34,50)
      VRR0(34,75)=2.D0*V(476)-2.D0*V(477)+QCx*VRR0(34,51)+WQx*VRR1(34,51)
      VRR0(34,76)=3.D0*V(364)+V(459)+V(460)+QCz*VRR0(34,48)+WQz*VRR1(34,48)
      VRR0(34,77)=3.D0*V(368)+V(456)+V(458)+QCz*VRR0(34,49)+WQz*VRR1(34,49)
      VRR0(34,78)=2.D0*V(478)+V(479)-2.D0*V(480)+QCy*VRR0(34,53)+WQy*VRR1(34,53)
      VRR0(34,79)=3.D0*V(373)+V(463)+V(465)+QCz*VRR0(34,51)+WQz*VRR1(34,51)
      VRR0(34,80)=3.D0*V(466)-3.D0*V(468)+QCz*VRR0(34,52)+3.D0*HfxZpE*VRR1(19,52)+WQz*VRR1(34,52)
      VRR0(34,81)=3.D0*V(408)+V(472)+V(475)+QCz*VRR0(34,53)+WQz*VRR1(34,53)
      VRR0(34,82)=4.D0*V(476)-4.D0*V(477)+QCz*VRR0(34,54)+3.D0*HfxZpE*VRR1(19,54)+WQz*VRR1(34,54)
      VRR0(34,83)=4.D0*V(478)-4.D0*V(480)+QCz*VRR0(34,55)+3.D0*HfxZpE*VRR1(19,55)+WQz*VRR1(34,55)
      VRR0(34,84)=5.D0*r1x2E*VRR0(34,35)+QCz*VRR0(34,56)+3.D0*HfxZpE*VRR1(19,56)-5.D0*r1x2E*ZxZpE*VRR1(34,35)+WQz*VRR1(34,56)
      VRR0(35,57)=5.D0*r1x2E*VRR0(35,21)+QCx*VRR0(35,36)-5.D0*r1x2E*ZxZpE*VRR1(35,21)+WQx*VRR1(35,36)
      VRR0(35,58)=4.D0*r1x2E*VRR0(35,22)+QCx*VRR0(35,37)-4.D0*r1x2E*ZxZpE*VRR1(35,22)+WQx*VRR1(35,37)
      VRR0(35,59)=V(482)+V(484)+QCx*VRR0(35,38)+WQx*VRR1(35,38)
      VRR0(35,60)=3.D0*r1x2Z*VRR0(10,60)+PAz*VRR0(20,60)-3.D0*ExZpE*r1x2Z*VRR1(10,60)+WPz*VRR1(20,60)
      VRR0(35,61)=V(482)+V(484)+QCy*VRR0(35,39)+WQy*VRR1(35,39)
      VRR0(35,62)=4.D0*r1x2E*VRR0(35,24)+QCy*VRR0(35,40)-4.D0*r1x2E*ZxZpE*VRR1(35,24)+WQy*VRR1(35,40)
      VRR0(35,63)=5.D0*r1x2E*VRR0(35,25)+QCy*VRR0(35,41)-5.D0*r1x2E*ZxZpE*VRR1(35,25)+WQy*VRR1(35,41)
      VRR0(35,64)=4.D0*r1x2E*VRR0(35,26)+QCx*VRR0(35,42)-4.D0*r1x2E*ZxZpE*VRR1(35,26)+WQx*VRR1(35,42)
      VRR0(35,65)=3.D0*r1x2E*VRR0(35,27)+QCx*VRR0(35,43)-3.D0*r1x2E*ZxZpE*VRR1(35,27)+WQx*VRR1(35,43)
      VRR0(35,66)=V(412)+3.D0*r1x2Z*VRR0(10,66)+PAz*VRR0(20,66)-3.D0*ExZpE*r1x2Z*VRR1(10,66)+WPz*VRR1(20,66)
      VRR0(35,67)=V(416)+3.D0*r1x2Z*VRR0(10,67)+PAz*VRR0(20,67)-3.D0*ExZpE*r1x2Z*VRR1(10,67)+WPz*VRR1(20,67)
      VRR0(35,68)=3.D0*r1x2E*VRR0(35,28)+QCy*VRR0(35,45)-3.D0*r1x2E*ZxZpE*VRR1(35,28)+WQy*VRR1(35,45)
      VRR0(35,69)=4.D0*r1x2E*VRR0(35,29)+QCy*VRR0(35,46)-4.D0*r1x2E*ZxZpE*VRR1(35,29)+WQy*VRR1(35,46)
      VRR0(35,70)=V(486)+V(488)+QCx*VRR0(35,47)+WQx*VRR1(35,47)
      VRR0(35,71)=2.D0*V(419)+3.D0*r1x2Z*VRR0(10,71)+PAz*VRR0(20,71)-3.D0*ExZpE*r1x2Z*VRR1(10,71)+WPz*VRR1(20,71)
      VRR0(35,72)=2.D0*V(423)+3.D0*r1x2Z*VRR0(10,72)+PAz*VRR0(20,72)-3.D0*ExZpE*r1x2Z*VRR1(10,72)+WPz*VRR1(20,72)
      VRR0(35,73)=2.D0*V(461)+3.D0*r1x2Z*VRR0(10,73)+PAz*VRR0(20,73)-3.D0*ExZpE*r1x2Z*VRR1(10,73)+WPz*VRR1(20,73)
      VRR0(35,74)=V(490)+V(492)+QCy*VRR0(35,50)+WQy*VRR1(35,50)
      VRR0(35,75)=3.D0*V(430)+3.D0*r1x2Z*VRR0(10,75)+PAz*VRR0(20,75)-3.D0*ExZpE*r1x2Z*VRR1(10,75)+WPz*VRR1(20,75)
      VRR0(35,76)=3.D0*V(435)+3.D0*r1x2Z*VRR0(10,76)+PAz*VRR0(20,76)-3.D0*ExZpE*r1x2Z*VRR1(10,76)+WPz*VRR1(20,76)
      VRR0(35,77)=3.D0*V(470)+3.D0*r1x2Z*VRR0(10,77)+PAz*VRR0(20,77)-3.D0*ExZpE*r1x2Z*VRR1(10,77)+WPz*VRR1(20,77)
      VRR0(35,78)=3.D0*V(473)+3.D0*r1x2Z*VRR0(10,78)+PAz*VRR0(20,78)-3.D0*ExZpE*r1x2Z*VRR1(10,78)+WPz*VRR1(20,78)
      VRR0(35,79)=4.D0*V(443)+V(486)+V(488)+QCz*VRR0(35,51)+WQz*VRR1(35,51)
      VRR0(35,80)=3.D0*r1x2E*VRR0(35,31)+QCz*VRR0(35,52)+4.D0*HfxZpE*VRR1(20,52)-3.D0*r1x2E*ZxZpE*VRR1(35,31)+WQz*VRR1(35,52)
      VRR0(35,81)=4.D0*V(479)+V(490)+V(492)+QCz*VRR0(35,53)+WQz*VRR1(35,53)
      VRR0(35,82)=4.D0*r1x2E*VRR0(35,33)+QCz*VRR0(35,54)+4.D0*HfxZpE*VRR1(20,54)-4.D0*r1x2E*ZxZpE*VRR1(35,33)+WQz*VRR1(35,54)
      VRR0(35,83)=4.D0*r1x2E*VRR0(35,34)+QCz*VRR0(35,55)+4.D0*HfxZpE*VRR1(20,55)-4.D0*r1x2E*ZxZpE*VRR1(35,34)+WQz*VRR1(35,55)
      VRR0(35,84)=5.D0*r1x2E*VRR0(35,35)+QCz*VRR0(35,56)+4.D0*HfxZpE*VRR1(20,56)-5.D0*r1x2E*ZxZpE*VRR1(35,35)+WQz*VRR1(35,56)
END SUBROUTINE VRRg0i0
SUBROUTINE MVRRg0i0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,57)=QCx*VS0(21,36)+WQx*VS1(21,36)-r1x2E*VR1(21,36)&
   +5D0*r1x2E*(VS0(21,21)-ZxZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(11,36)
VS0(21,58)=QCx*VS0(21,37)+WQx*VS1(21,37)-r1x2E*VR1(21,37)&
   +4D0*r1x2E*(VS0(21,22)-ZxZpE*VS1(21,22))&
   +4D0*HfxZpE*VS1(11,37)
VS0(21,59)=QCx*VS0(21,38)+WQx*VS1(21,38)-r1x2E*VR1(21,38)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))&
   +4D0*HfxZpE*VS1(11,38)
VS0(21,60)=QCx*VS0(21,39)+WQx*VS1(21,39)-r1x2E*VR1(21,39)&
   +2D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))&
   +4D0*HfxZpE*VS1(11,39)
VS0(21,61)=QCy*VS0(21,39)+WQy*VS1(21,39)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))
VS0(21,62)=QCy*VS0(21,40)+WQy*VS1(21,40)&
   +4D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))
VS0(21,63)=QCy*VS0(21,41)+WQy*VS1(21,41)&
   +5D0*r1x2E*(VS0(21,25)-ZxZpE*VS1(21,25))
VS0(21,64)=QCx*VS0(21,42)+WQx*VS1(21,42)-r1x2E*VR1(21,42)&
   +4D0*r1x2E*(VS0(21,26)-ZxZpE*VS1(21,26))&
   +4D0*HfxZpE*VS1(11,42)
VS0(21,65)=QCx*VS0(21,43)+WQx*VS1(21,43)-r1x2E*VR1(21,43)&
   +3D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))&
   +4D0*HfxZpE*VS1(11,43)
VS0(21,66)=QCx*VS0(21,44)+WQx*VS1(21,44)-r1x2E*VR1(21,44)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))&
   +4D0*HfxZpE*VS1(11,44)
VS0(21,67)=QCy*VS0(21,44)+WQy*VS1(21,44)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,68)=QCy*VS0(21,45)+WQy*VS1(21,45)&
   +3D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,69)=QCy*VS0(21,46)+WQy*VS1(21,46)&
   +4D0*r1x2E*(VS0(21,29)-ZxZpE*VS1(21,29))
VS0(21,70)=QCx*VS0(21,47)+WQx*VS1(21,47)-r1x2E*VR1(21,47)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))&
   +4D0*HfxZpE*VS1(11,47)
VS0(21,71)=QCx*VS0(21,48)+WQx*VS1(21,48)-r1x2E*VR1(21,48)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))&
   +4D0*HfxZpE*VS1(11,48)
VS0(21,72)=QCx*VS0(21,49)+WQx*VS1(21,49)-r1x2E*VR1(21,49)&
   +r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))&
   +4D0*HfxZpE*VS1(11,49)
VS0(21,73)=QCy*VS0(21,49)+WQy*VS1(21,49)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,74)=QCy*VS0(21,50)+WQy*VS1(21,50)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,75)=QCx*VS0(21,51)+WQx*VS1(21,51)-r1x2E*VR1(21,51)&
   +2D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))&
   +4D0*HfxZpE*VS1(11,51)
VS0(21,76)=QCz*VS0(21,48)+WQz*VS1(21,48)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,77)=QCz*VS0(21,49)+WQz*VS1(21,49)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,78)=QCy*VS0(21,53)+WQy*VS1(21,53)&
   +2D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,79)=QCz*VS0(21,51)+WQz*VS1(21,51)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))
VS0(21,80)=QCz*VS0(21,52)+WQz*VS1(21,52)&
   +3D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,81)=QCz*VS0(21,53)+WQz*VS1(21,53)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,82)=QCz*VS0(21,54)+WQz*VS1(21,54)&
   +4D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))
VS0(21,83)=QCz*VS0(21,55)+WQz*VS1(21,55)&
   +4D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,84)=QCz*VS0(21,56)+WQz*VS1(21,56)&
   +5D0*r1x2E*(VS0(21,35)-ZxZpE*VS1(21,35))
VS0(22,57)=QCx*VS0(22,36)+WQx*VS1(22,36)-r1x2E*VR1(22,36)&
   +5D0*r1x2E*(VS0(22,21)-ZxZpE*VS1(22,21))&
   +3D0*HfxZpE*VS1(12,36)
VS0(22,58)=QCx*VS0(22,37)+WQx*VS1(22,37)-r1x2E*VR1(22,37)&
   +4D0*r1x2E*(VS0(22,22)-ZxZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(12,37)
VS0(22,59)=QCx*VS0(22,38)+WQx*VS1(22,38)-r1x2E*VR1(22,38)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +3D0*HfxZpE*VS1(12,38)
VS0(22,60)=QCx*VS0(22,39)+WQx*VS1(22,39)-r1x2E*VR1(22,39)&
   +2D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +3D0*HfxZpE*VS1(12,39)
VS0(22,61)=QCy*VS0(22,39)+WQy*VS1(22,39)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +HfxZpE*VS1(11,39)
VS0(22,62)=QCy*VS0(22,40)+WQy*VS1(22,40)&
   +4D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +HfxZpE*VS1(11,40)
VS0(22,63)=QCy*VS0(22,41)+WQy*VS1(22,41)&
   +5D0*r1x2E*(VS0(22,25)-ZxZpE*VS1(22,25))&
   +HfxZpE*VS1(11,41)
VS0(22,64)=QCx*VS0(22,42)+WQx*VS1(22,42)-r1x2E*VR1(22,42)&
   +4D0*r1x2E*(VS0(22,26)-ZxZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(12,42)
VS0(22,65)=QCx*VS0(22,43)+WQx*VS1(22,43)-r1x2E*VR1(22,43)&
   +3D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +3D0*HfxZpE*VS1(12,43)
VS0(22,66)=QCx*VS0(22,44)+WQx*VS1(22,44)-r1x2E*VR1(22,44)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +3D0*HfxZpE*VS1(12,44)
VS0(22,67)=QCy*VS0(22,44)+WQy*VS1(22,44)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +HfxZpE*VS1(11,44)
VS0(22,68)=QCy*VS0(22,45)+WQy*VS1(22,45)&
   +3D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +HfxZpE*VS1(11,45)
VS0(22,69)=QCy*VS0(22,46)+WQy*VS1(22,46)&
   +4D0*r1x2E*(VS0(22,29)-ZxZpE*VS1(22,29))&
   +HfxZpE*VS1(11,46)
VS0(22,70)=QCx*VS0(22,47)+WQx*VS1(22,47)-r1x2E*VR1(22,47)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))&
   +3D0*HfxZpE*VS1(12,47)
VS0(22,71)=QCx*VS0(22,48)+WQx*VS1(22,48)-r1x2E*VR1(22,48)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +3D0*HfxZpE*VS1(12,48)
VS0(22,72)=QCx*VS0(22,49)+WQx*VS1(22,49)-r1x2E*VR1(22,49)&
   +r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +3D0*HfxZpE*VS1(12,49)
VS0(22,73)=QCy*VS0(22,49)+WQy*VS1(22,49)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +HfxZpE*VS1(11,49)
VS0(22,74)=QCy*VS0(22,50)+WQy*VS1(22,50)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +HfxZpE*VS1(11,50)
VS0(22,75)=QCx*VS0(22,51)+WQx*VS1(22,51)-r1x2E*VR1(22,51)&
   +2D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))&
   +3D0*HfxZpE*VS1(12,51)
VS0(22,76)=QCz*VS0(22,48)+WQz*VS1(22,48)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))
VS0(22,77)=QCz*VS0(22,49)+WQz*VS1(22,49)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))
VS0(22,78)=QCy*VS0(22,53)+WQy*VS1(22,53)&
   +2D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))&
   +HfxZpE*VS1(11,53)
VS0(22,79)=QCz*VS0(22,51)+WQz*VS1(22,51)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))
VS0(22,80)=QCz*VS0(22,52)+WQz*VS1(22,52)&
   +3D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))
VS0(22,81)=QCz*VS0(22,53)+WQz*VS1(22,53)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))
VS0(22,82)=QCz*VS0(22,54)+WQz*VS1(22,54)&
   +4D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))
VS0(22,83)=QCz*VS0(22,55)+WQz*VS1(22,55)&
   +4D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))
VS0(22,84)=QCz*VS0(22,56)+WQz*VS1(22,56)&
   +5D0*r1x2E*(VS0(22,35)-ZxZpE*VS1(22,35))
VS0(23,57)=QCx*VS0(23,36)+WQx*VS1(23,36)-r1x2E*VR1(23,36)&
   +5D0*r1x2E*(VS0(23,21)-ZxZpE*VS1(23,21))&
   +2D0*HfxZpE*VS1(13,36)
VS0(23,58)=QCx*VS0(23,37)+WQx*VS1(23,37)-r1x2E*VR1(23,37)&
   +4D0*r1x2E*(VS0(23,22)-ZxZpE*VS1(23,22))&
   +2D0*HfxZpE*VS1(13,37)
VS0(23,59)=QCx*VS0(23,38)+WQx*VS1(23,38)-r1x2E*VR1(23,38)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(13,38)
VS0(23,60)=QCx*VS0(23,39)+WQx*VS1(23,39)-r1x2E*VR1(23,39)&
   +2D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(13,39)
VS0(23,61)=QCy*VS0(23,39)+WQy*VS1(23,39)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(12,39)
VS0(23,62)=QCy*VS0(23,40)+WQy*VS1(23,40)&
   +4D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(12,40)
VS0(23,63)=QCy*VS0(23,41)+WQy*VS1(23,41)&
   +5D0*r1x2E*(VS0(23,25)-ZxZpE*VS1(23,25))&
   +2D0*HfxZpE*VS1(12,41)
VS0(23,64)=QCx*VS0(23,42)+WQx*VS1(23,42)-r1x2E*VR1(23,42)&
   +4D0*r1x2E*(VS0(23,26)-ZxZpE*VS1(23,26))&
   +2D0*HfxZpE*VS1(13,42)
VS0(23,65)=QCx*VS0(23,43)+WQx*VS1(23,43)-r1x2E*VR1(23,43)&
   +3D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(13,43)
VS0(23,66)=QCx*VS0(23,44)+WQx*VS1(23,44)-r1x2E*VR1(23,44)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(13,44)
VS0(23,67)=QCy*VS0(23,44)+WQy*VS1(23,44)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(12,44)
VS0(23,68)=QCy*VS0(23,45)+WQy*VS1(23,45)&
   +3D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(12,45)
VS0(23,69)=QCy*VS0(23,46)+WQy*VS1(23,46)&
   +4D0*r1x2E*(VS0(23,29)-ZxZpE*VS1(23,29))&
   +2D0*HfxZpE*VS1(12,46)
VS0(23,70)=QCx*VS0(23,47)+WQx*VS1(23,47)-r1x2E*VR1(23,47)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(13,47)
VS0(23,71)=QCx*VS0(23,48)+WQx*VS1(23,48)-r1x2E*VR1(23,48)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(13,48)
VS0(23,72)=QCx*VS0(23,49)+WQx*VS1(23,49)-r1x2E*VR1(23,49)&
   +r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(13,49)
VS0(23,73)=QCy*VS0(23,49)+WQy*VS1(23,49)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(12,49)
VS0(23,74)=QCy*VS0(23,50)+WQy*VS1(23,50)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(12,50)
VS0(23,75)=QCx*VS0(23,51)+WQx*VS1(23,51)-r1x2E*VR1(23,51)&
   +2D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))&
   +2D0*HfxZpE*VS1(13,51)
VS0(23,76)=QCz*VS0(23,48)+WQz*VS1(23,48)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))
VS0(23,77)=QCz*VS0(23,49)+WQz*VS1(23,49)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))
VS0(23,78)=QCy*VS0(23,53)+WQy*VS1(23,53)&
   +2D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))&
   +2D0*HfxZpE*VS1(12,53)
VS0(23,79)=QCz*VS0(23,51)+WQz*VS1(23,51)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))
VS0(23,80)=QCz*VS0(23,52)+WQz*VS1(23,52)&
   +3D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))
VS0(23,81)=QCz*VS0(23,53)+WQz*VS1(23,53)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))
VS0(23,82)=QCz*VS0(23,54)+WQz*VS1(23,54)&
   +4D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))
VS0(23,83)=QCz*VS0(23,55)+WQz*VS1(23,55)&
   +4D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))
VS0(23,84)=QCz*VS0(23,56)+WQz*VS1(23,56)&
   +5D0*r1x2E*(VS0(23,35)-ZxZpE*VS1(23,35))
VS0(24,57)=QCx*VS0(24,36)+WQx*VS1(24,36)-r1x2E*VR1(24,36)&
   +5D0*r1x2E*(VS0(24,21)-ZxZpE*VS1(24,21))&
   +HfxZpE*VS1(14,36)
VS0(24,58)=QCx*VS0(24,37)+WQx*VS1(24,37)-r1x2E*VR1(24,37)&
   +4D0*r1x2E*(VS0(24,22)-ZxZpE*VS1(24,22))&
   +HfxZpE*VS1(14,37)
VS0(24,59)=QCx*VS0(24,38)+WQx*VS1(24,38)-r1x2E*VR1(24,38)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +HfxZpE*VS1(14,38)
VS0(24,60)=QCx*VS0(24,39)+WQx*VS1(24,39)-r1x2E*VR1(24,39)&
   +2D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +HfxZpE*VS1(14,39)
VS0(24,61)=QCy*VS0(24,39)+WQy*VS1(24,39)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +3D0*HfxZpE*VS1(13,39)
VS0(24,62)=QCy*VS0(24,40)+WQy*VS1(24,40)&
   +4D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(13,40)
VS0(24,63)=QCy*VS0(24,41)+WQy*VS1(24,41)&
   +5D0*r1x2E*(VS0(24,25)-ZxZpE*VS1(24,25))&
   +3D0*HfxZpE*VS1(13,41)
VS0(24,64)=QCx*VS0(24,42)+WQx*VS1(24,42)-r1x2E*VR1(24,42)&
   +4D0*r1x2E*(VS0(24,26)-ZxZpE*VS1(24,26))&
   +HfxZpE*VS1(14,42)
VS0(24,65)=QCx*VS0(24,43)+WQx*VS1(24,43)-r1x2E*VR1(24,43)&
   +3D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +HfxZpE*VS1(14,43)
VS0(24,66)=QCx*VS0(24,44)+WQx*VS1(24,44)-r1x2E*VR1(24,44)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +HfxZpE*VS1(14,44)
VS0(24,67)=QCy*VS0(24,44)+WQy*VS1(24,44)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +3D0*HfxZpE*VS1(13,44)
VS0(24,68)=QCy*VS0(24,45)+WQy*VS1(24,45)&
   +3D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +3D0*HfxZpE*VS1(13,45)
VS0(24,69)=QCy*VS0(24,46)+WQy*VS1(24,46)&
   +4D0*r1x2E*(VS0(24,29)-ZxZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(13,46)
VS0(24,70)=QCx*VS0(24,47)+WQx*VS1(24,47)-r1x2E*VR1(24,47)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))&
   +HfxZpE*VS1(14,47)
VS0(24,71)=QCx*VS0(24,48)+WQx*VS1(24,48)-r1x2E*VR1(24,48)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +HfxZpE*VS1(14,48)
VS0(24,72)=QCx*VS0(24,49)+WQx*VS1(24,49)-r1x2E*VR1(24,49)&
   +r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +HfxZpE*VS1(14,49)
VS0(24,73)=QCy*VS0(24,49)+WQy*VS1(24,49)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +3D0*HfxZpE*VS1(13,49)
VS0(24,74)=QCy*VS0(24,50)+WQy*VS1(24,50)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +3D0*HfxZpE*VS1(13,50)
VS0(24,75)=QCx*VS0(24,51)+WQx*VS1(24,51)-r1x2E*VR1(24,51)&
   +2D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))&
   +HfxZpE*VS1(14,51)
VS0(24,76)=QCz*VS0(24,48)+WQz*VS1(24,48)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))
VS0(24,77)=QCz*VS0(24,49)+WQz*VS1(24,49)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))
VS0(24,78)=QCy*VS0(24,53)+WQy*VS1(24,53)&
   +2D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))&
   +3D0*HfxZpE*VS1(13,53)
VS0(24,79)=QCz*VS0(24,51)+WQz*VS1(24,51)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))
VS0(24,80)=QCz*VS0(24,52)+WQz*VS1(24,52)&
   +3D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))
VS0(24,81)=QCz*VS0(24,53)+WQz*VS1(24,53)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))
VS0(24,82)=QCz*VS0(24,54)+WQz*VS1(24,54)&
   +4D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))
VS0(24,83)=QCz*VS0(24,55)+WQz*VS1(24,55)&
   +4D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))
VS0(24,84)=QCz*VS0(24,56)+WQz*VS1(24,56)&
   +5D0*r1x2E*(VS0(24,35)-ZxZpE*VS1(24,35))
VS0(25,57)=QCx*VS0(25,36)+WQx*VS1(25,36)-r1x2E*VR1(25,36)&
   +5D0*r1x2E*(VS0(25,21)-ZxZpE*VS1(25,21))
VS0(25,58)=QCx*VS0(25,37)+WQx*VS1(25,37)-r1x2E*VR1(25,37)&
   +4D0*r1x2E*(VS0(25,22)-ZxZpE*VS1(25,22))
VS0(25,59)=QCx*VS0(25,38)+WQx*VS1(25,38)-r1x2E*VR1(25,38)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))
VS0(25,60)=QCx*VS0(25,39)+WQx*VS1(25,39)-r1x2E*VR1(25,39)&
   +2D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))
VS0(25,61)=QCy*VS0(25,39)+WQy*VS1(25,39)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))&
   +4D0*HfxZpE*VS1(14,39)
VS0(25,62)=QCy*VS0(25,40)+WQy*VS1(25,40)&
   +4D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))&
   +4D0*HfxZpE*VS1(14,40)
VS0(25,63)=QCy*VS0(25,41)+WQy*VS1(25,41)&
   +5D0*r1x2E*(VS0(25,25)-ZxZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(14,41)
VS0(25,64)=QCx*VS0(25,42)+WQx*VS1(25,42)-r1x2E*VR1(25,42)&
   +4D0*r1x2E*(VS0(25,26)-ZxZpE*VS1(25,26))
VS0(25,65)=QCx*VS0(25,43)+WQx*VS1(25,43)-r1x2E*VR1(25,43)&
   +3D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,66)=QCx*VS0(25,44)+WQx*VS1(25,44)-r1x2E*VR1(25,44)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,67)=QCy*VS0(25,44)+WQy*VS1(25,44)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))&
   +4D0*HfxZpE*VS1(14,44)
VS0(25,68)=QCy*VS0(25,45)+WQy*VS1(25,45)&
   +3D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))&
   +4D0*HfxZpE*VS1(14,45)
VS0(25,69)=QCy*VS0(25,46)+WQy*VS1(25,46)&
   +4D0*r1x2E*(VS0(25,29)-ZxZpE*VS1(25,29))&
   +4D0*HfxZpE*VS1(14,46)
VS0(25,70)=QCx*VS0(25,47)+WQx*VS1(25,47)-r1x2E*VR1(25,47)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,71)=QCx*VS0(25,48)+WQx*VS1(25,48)-r1x2E*VR1(25,48)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,72)=QCx*VS0(25,49)+WQx*VS1(25,49)-r1x2E*VR1(25,49)&
   +r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,73)=QCy*VS0(25,49)+WQy*VS1(25,49)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))&
   +4D0*HfxZpE*VS1(14,49)
VS0(25,74)=QCy*VS0(25,50)+WQy*VS1(25,50)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))&
   +4D0*HfxZpE*VS1(14,50)
VS0(25,75)=QCx*VS0(25,51)+WQx*VS1(25,51)-r1x2E*VR1(25,51)&
   +2D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,76)=QCz*VS0(25,48)+WQz*VS1(25,48)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,77)=QCz*VS0(25,49)+WQz*VS1(25,49)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,78)=QCy*VS0(25,53)+WQy*VS1(25,53)&
   +2D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))&
   +4D0*HfxZpE*VS1(14,53)
VS0(25,79)=QCz*VS0(25,51)+WQz*VS1(25,51)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,80)=QCz*VS0(25,52)+WQz*VS1(25,52)&
   +3D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,81)=QCz*VS0(25,53)+WQz*VS1(25,53)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,82)=QCz*VS0(25,54)+WQz*VS1(25,54)&
   +4D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,83)=QCz*VS0(25,55)+WQz*VS1(25,55)&
   +4D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))
VS0(25,84)=QCz*VS0(25,56)+WQz*VS1(25,56)&
   +5D0*r1x2E*(VS0(25,35)-ZxZpE*VS1(25,35))
VS0(26,57)=QCx*VS0(26,36)+WQx*VS1(26,36)-r1x2E*VR1(26,36)&
   +5D0*r1x2E*(VS0(26,21)-ZxZpE*VS1(26,21))&
   +3D0*HfxZpE*VS1(15,36)
VS0(26,58)=QCx*VS0(26,37)+WQx*VS1(26,37)-r1x2E*VR1(26,37)&
   +4D0*r1x2E*(VS0(26,22)-ZxZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(15,37)
VS0(26,59)=QCx*VS0(26,38)+WQx*VS1(26,38)-r1x2E*VR1(26,38)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))&
   +3D0*HfxZpE*VS1(15,38)
VS0(26,60)=QCx*VS0(26,39)+WQx*VS1(26,39)-r1x2E*VR1(26,39)&
   +2D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))&
   +3D0*HfxZpE*VS1(15,39)
VS0(26,61)=QCy*VS0(26,39)+WQy*VS1(26,39)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))
VS0(26,62)=QCy*VS0(26,40)+WQy*VS1(26,40)&
   +4D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))
VS0(26,63)=QCy*VS0(26,41)+WQy*VS1(26,41)&
   +5D0*r1x2E*(VS0(26,25)-ZxZpE*VS1(26,25))
VS0(26,64)=QCx*VS0(26,42)+WQx*VS1(26,42)-r1x2E*VR1(26,42)&
   +4D0*r1x2E*(VS0(26,26)-ZxZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(15,42)
VS0(26,65)=QCx*VS0(26,43)+WQx*VS1(26,43)-r1x2E*VR1(26,43)&
   +3D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +3D0*HfxZpE*VS1(15,43)
VS0(26,66)=QCx*VS0(26,44)+WQx*VS1(26,44)-r1x2E*VR1(26,44)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +3D0*HfxZpE*VS1(15,44)
VS0(26,67)=QCy*VS0(26,44)+WQy*VS1(26,44)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))
VS0(26,68)=QCy*VS0(26,45)+WQy*VS1(26,45)&
   +3D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))
VS0(26,69)=QCy*VS0(26,46)+WQy*VS1(26,46)&
   +4D0*r1x2E*(VS0(26,29)-ZxZpE*VS1(26,29))
VS0(26,70)=QCx*VS0(26,47)+WQx*VS1(26,47)-r1x2E*VR1(26,47)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +3D0*HfxZpE*VS1(15,47)
VS0(26,71)=QCx*VS0(26,48)+WQx*VS1(26,48)-r1x2E*VR1(26,48)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +3D0*HfxZpE*VS1(15,48)
VS0(26,72)=QCx*VS0(26,49)+WQx*VS1(26,49)-r1x2E*VR1(26,49)&
   +r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +3D0*HfxZpE*VS1(15,49)
VS0(26,73)=QCy*VS0(26,49)+WQy*VS1(26,49)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))
VS0(26,74)=QCy*VS0(26,50)+WQy*VS1(26,50)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))
VS0(26,75)=QCx*VS0(26,51)+WQx*VS1(26,51)-r1x2E*VR1(26,51)&
   +2D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +3D0*HfxZpE*VS1(15,51)
VS0(26,76)=QCz*VS0(26,48)+WQz*VS1(26,48)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +HfxZpE*VS1(11,48)
VS0(26,77)=QCz*VS0(26,49)+WQz*VS1(26,49)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +HfxZpE*VS1(11,49)
VS0(26,78)=QCy*VS0(26,53)+WQy*VS1(26,53)&
   +2D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))
VS0(26,79)=QCz*VS0(26,51)+WQz*VS1(26,51)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +HfxZpE*VS1(11,51)
VS0(26,80)=QCz*VS0(26,52)+WQz*VS1(26,52)&
   +3D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +HfxZpE*VS1(11,52)
VS0(26,81)=QCz*VS0(26,53)+WQz*VS1(26,53)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +HfxZpE*VS1(11,53)
VS0(26,82)=QCz*VS0(26,54)+WQz*VS1(26,54)&
   +4D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +HfxZpE*VS1(11,54)
VS0(26,83)=QCz*VS0(26,55)+WQz*VS1(26,55)&
   +4D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))&
   +HfxZpE*VS1(11,55)
VS0(26,84)=QCz*VS0(26,56)+WQz*VS1(26,56)&
   +5D0*r1x2E*(VS0(26,35)-ZxZpE*VS1(26,35))&
   +HfxZpE*VS1(11,56)
VS0(27,57)=QCx*VS0(27,36)+WQx*VS1(27,36)-r1x2E*VR1(27,36)&
   +5D0*r1x2E*(VS0(27,21)-ZxZpE*VS1(27,21))&
   +2D0*HfxZpE*VS1(16,36)
VS0(27,58)=QCx*VS0(27,37)+WQx*VS1(27,37)-r1x2E*VR1(27,37)&
   +4D0*r1x2E*(VS0(27,22)-ZxZpE*VS1(27,22))&
   +2D0*HfxZpE*VS1(16,37)
VS0(27,59)=QCx*VS0(27,38)+WQx*VS1(27,38)-r1x2E*VR1(27,38)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(16,38)
VS0(27,60)=QCx*VS0(27,39)+WQx*VS1(27,39)-r1x2E*VR1(27,39)&
   +2D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +2D0*HfxZpE*VS1(16,39)
VS0(27,61)=QCy*VS0(27,39)+WQy*VS1(27,39)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +HfxZpE*VS1(15,39)
VS0(27,62)=QCy*VS0(27,40)+WQy*VS1(27,40)&
   +4D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +HfxZpE*VS1(15,40)
VS0(27,63)=QCy*VS0(27,41)+WQy*VS1(27,41)&
   +5D0*r1x2E*(VS0(27,25)-ZxZpE*VS1(27,25))&
   +HfxZpE*VS1(15,41)
VS0(27,64)=QCx*VS0(27,42)+WQx*VS1(27,42)-r1x2E*VR1(27,42)&
   +4D0*r1x2E*(VS0(27,26)-ZxZpE*VS1(27,26))&
   +2D0*HfxZpE*VS1(16,42)
VS0(27,65)=QCx*VS0(27,43)+WQx*VS1(27,43)-r1x2E*VR1(27,43)&
   +3D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(16,43)
VS0(27,66)=QCx*VS0(27,44)+WQx*VS1(27,44)-r1x2E*VR1(27,44)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(16,44)
VS0(27,67)=QCy*VS0(27,44)+WQy*VS1(27,44)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(15,44)
VS0(27,68)=QCy*VS0(27,45)+WQy*VS1(27,45)&
   +3D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(15,45)
VS0(27,69)=QCy*VS0(27,46)+WQy*VS1(27,46)&
   +4D0*r1x2E*(VS0(27,29)-ZxZpE*VS1(27,29))&
   +HfxZpE*VS1(15,46)
VS0(27,70)=QCx*VS0(27,47)+WQx*VS1(27,47)-r1x2E*VR1(27,47)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(16,47)
VS0(27,71)=QCx*VS0(27,48)+WQx*VS1(27,48)-r1x2E*VR1(27,48)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(16,48)
VS0(27,72)=QCx*VS0(27,49)+WQx*VS1(27,49)-r1x2E*VR1(27,49)&
   +r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(16,49)
VS0(27,73)=QCy*VS0(27,49)+WQy*VS1(27,49)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(15,49)
VS0(27,74)=QCy*VS0(27,50)+WQy*VS1(27,50)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(15,50)
VS0(27,75)=QCx*VS0(27,51)+WQx*VS1(27,51)-r1x2E*VR1(27,51)&
   +2D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +2D0*HfxZpE*VS1(16,51)
VS0(27,76)=QCz*VS0(27,48)+WQz*VS1(27,48)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(12,48)
VS0(27,77)=QCz*VS0(27,49)+WQz*VS1(27,49)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(12,49)
VS0(27,78)=QCy*VS0(27,53)+WQy*VS1(27,53)&
   +2D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(15,53)
VS0(27,79)=QCz*VS0(27,51)+WQz*VS1(27,51)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +HfxZpE*VS1(12,51)
VS0(27,80)=QCz*VS0(27,52)+WQz*VS1(27,52)&
   +3D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(12,52)
VS0(27,81)=QCz*VS0(27,53)+WQz*VS1(27,53)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(12,53)
VS0(27,82)=QCz*VS0(27,54)+WQz*VS1(27,54)&
   +4D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +HfxZpE*VS1(12,54)
VS0(27,83)=QCz*VS0(27,55)+WQz*VS1(27,55)&
   +4D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(12,55)
VS0(27,84)=QCz*VS0(27,56)+WQz*VS1(27,56)&
   +5D0*r1x2E*(VS0(27,35)-ZxZpE*VS1(27,35))&
   +HfxZpE*VS1(12,56)
VS0(28,57)=QCx*VS0(28,36)+WQx*VS1(28,36)-r1x2E*VR1(28,36)&
   +5D0*r1x2E*(VS0(28,21)-ZxZpE*VS1(28,21))&
   +HfxZpE*VS1(17,36)
VS0(28,58)=QCx*VS0(28,37)+WQx*VS1(28,37)-r1x2E*VR1(28,37)&
   +4D0*r1x2E*(VS0(28,22)-ZxZpE*VS1(28,22))&
   +HfxZpE*VS1(17,37)
VS0(28,59)=QCx*VS0(28,38)+WQx*VS1(28,38)-r1x2E*VR1(28,38)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +HfxZpE*VS1(17,38)
VS0(28,60)=QCx*VS0(28,39)+WQx*VS1(28,39)-r1x2E*VR1(28,39)&
   +2D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +HfxZpE*VS1(17,39)
VS0(28,61)=QCy*VS0(28,39)+WQy*VS1(28,39)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(16,39)
VS0(28,62)=QCy*VS0(28,40)+WQy*VS1(28,40)&
   +4D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +2D0*HfxZpE*VS1(16,40)
VS0(28,63)=QCy*VS0(28,41)+WQy*VS1(28,41)&
   +5D0*r1x2E*(VS0(28,25)-ZxZpE*VS1(28,25))&
   +2D0*HfxZpE*VS1(16,41)
VS0(28,64)=QCx*VS0(28,42)+WQx*VS1(28,42)-r1x2E*VR1(28,42)&
   +4D0*r1x2E*(VS0(28,26)-ZxZpE*VS1(28,26))&
   +HfxZpE*VS1(17,42)
VS0(28,65)=QCx*VS0(28,43)+WQx*VS1(28,43)-r1x2E*VR1(28,43)&
   +3D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(17,43)
VS0(28,66)=QCx*VS0(28,44)+WQx*VS1(28,44)-r1x2E*VR1(28,44)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(17,44)
VS0(28,67)=QCy*VS0(28,44)+WQy*VS1(28,44)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(16,44)
VS0(28,68)=QCy*VS0(28,45)+WQy*VS1(28,45)&
   +3D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(16,45)
VS0(28,69)=QCy*VS0(28,46)+WQy*VS1(28,46)&
   +4D0*r1x2E*(VS0(28,29)-ZxZpE*VS1(28,29))&
   +2D0*HfxZpE*VS1(16,46)
VS0(28,70)=QCx*VS0(28,47)+WQx*VS1(28,47)-r1x2E*VR1(28,47)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(17,47)
VS0(28,71)=QCx*VS0(28,48)+WQx*VS1(28,48)-r1x2E*VR1(28,48)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(17,48)
VS0(28,72)=QCx*VS0(28,49)+WQx*VS1(28,49)-r1x2E*VR1(28,49)&
   +r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(17,49)
VS0(28,73)=QCy*VS0(28,49)+WQy*VS1(28,49)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(16,49)
VS0(28,74)=QCy*VS0(28,50)+WQy*VS1(28,50)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(16,50)
VS0(28,75)=QCx*VS0(28,51)+WQx*VS1(28,51)-r1x2E*VR1(28,51)&
   +2D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(17,51)
VS0(28,76)=QCz*VS0(28,48)+WQz*VS1(28,48)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(13,48)
VS0(28,77)=QCz*VS0(28,49)+WQz*VS1(28,49)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(13,49)
VS0(28,78)=QCy*VS0(28,53)+WQy*VS1(28,53)&
   +2D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +2D0*HfxZpE*VS1(16,53)
VS0(28,79)=QCz*VS0(28,51)+WQz*VS1(28,51)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(13,51)
VS0(28,80)=QCz*VS0(28,52)+WQz*VS1(28,52)&
   +3D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(13,52)
VS0(28,81)=QCz*VS0(28,53)+WQz*VS1(28,53)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(13,53)
VS0(28,82)=QCz*VS0(28,54)+WQz*VS1(28,54)&
   +4D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(13,54)
VS0(28,83)=QCz*VS0(28,55)+WQz*VS1(28,55)&
   +4D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +HfxZpE*VS1(13,55)
VS0(28,84)=QCz*VS0(28,56)+WQz*VS1(28,56)&
   +5D0*r1x2E*(VS0(28,35)-ZxZpE*VS1(28,35))&
   +HfxZpE*VS1(13,56)
VS0(29,57)=QCx*VS0(29,36)+WQx*VS1(29,36)-r1x2E*VR1(29,36)&
   +5D0*r1x2E*(VS0(29,21)-ZxZpE*VS1(29,21))
VS0(29,58)=QCx*VS0(29,37)+WQx*VS1(29,37)-r1x2E*VR1(29,37)&
   +4D0*r1x2E*(VS0(29,22)-ZxZpE*VS1(29,22))
VS0(29,59)=QCx*VS0(29,38)+WQx*VS1(29,38)-r1x2E*VR1(29,38)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))
VS0(29,60)=QCx*VS0(29,39)+WQx*VS1(29,39)-r1x2E*VR1(29,39)&
   +2D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))
VS0(29,61)=QCy*VS0(29,39)+WQy*VS1(29,39)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))&
   +3D0*HfxZpE*VS1(17,39)
VS0(29,62)=QCy*VS0(29,40)+WQy*VS1(29,40)&
   +4D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(17,40)
VS0(29,63)=QCy*VS0(29,41)+WQy*VS1(29,41)&
   +5D0*r1x2E*(VS0(29,25)-ZxZpE*VS1(29,25))&
   +3D0*HfxZpE*VS1(17,41)
VS0(29,64)=QCx*VS0(29,42)+WQx*VS1(29,42)-r1x2E*VR1(29,42)&
   +4D0*r1x2E*(VS0(29,26)-ZxZpE*VS1(29,26))
VS0(29,65)=QCx*VS0(29,43)+WQx*VS1(29,43)-r1x2E*VR1(29,43)&
   +3D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))
VS0(29,66)=QCx*VS0(29,44)+WQx*VS1(29,44)-r1x2E*VR1(29,44)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))
VS0(29,67)=QCy*VS0(29,44)+WQy*VS1(29,44)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +3D0*HfxZpE*VS1(17,44)
VS0(29,68)=QCy*VS0(29,45)+WQy*VS1(29,45)&
   +3D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +3D0*HfxZpE*VS1(17,45)
VS0(29,69)=QCy*VS0(29,46)+WQy*VS1(29,46)&
   +4D0*r1x2E*(VS0(29,29)-ZxZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(17,46)
VS0(29,70)=QCx*VS0(29,47)+WQx*VS1(29,47)-r1x2E*VR1(29,47)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))
VS0(29,71)=QCx*VS0(29,48)+WQx*VS1(29,48)-r1x2E*VR1(29,48)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))
VS0(29,72)=QCx*VS0(29,49)+WQx*VS1(29,49)-r1x2E*VR1(29,49)&
   +r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))
VS0(29,73)=QCy*VS0(29,49)+WQy*VS1(29,49)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +3D0*HfxZpE*VS1(17,49)
VS0(29,74)=QCy*VS0(29,50)+WQy*VS1(29,50)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +3D0*HfxZpE*VS1(17,50)
VS0(29,75)=QCx*VS0(29,51)+WQx*VS1(29,51)-r1x2E*VR1(29,51)&
   +2D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))
VS0(29,76)=QCz*VS0(29,48)+WQz*VS1(29,48)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +HfxZpE*VS1(14,48)
VS0(29,77)=QCz*VS0(29,49)+WQz*VS1(29,49)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +HfxZpE*VS1(14,49)
VS0(29,78)=QCy*VS0(29,53)+WQy*VS1(29,53)&
   +2D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +3D0*HfxZpE*VS1(17,53)
VS0(29,79)=QCz*VS0(29,51)+WQz*VS1(29,51)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))&
   +HfxZpE*VS1(14,51)
VS0(29,80)=QCz*VS0(29,52)+WQz*VS1(29,52)&
   +3D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +HfxZpE*VS1(14,52)
VS0(29,81)=QCz*VS0(29,53)+WQz*VS1(29,53)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +HfxZpE*VS1(14,53)
VS0(29,82)=QCz*VS0(29,54)+WQz*VS1(29,54)&
   +4D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))&
   +HfxZpE*VS1(14,54)
VS0(29,83)=QCz*VS0(29,55)+WQz*VS1(29,55)&
   +4D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +HfxZpE*VS1(14,55)
VS0(29,84)=QCz*VS0(29,56)+WQz*VS1(29,56)&
   +5D0*r1x2E*(VS0(29,35)-ZxZpE*VS1(29,35))&
   +HfxZpE*VS1(14,56)
VS0(30,57)=QCx*VS0(30,36)+WQx*VS1(30,36)-r1x2E*VR1(30,36)&
   +5D0*r1x2E*(VS0(30,21)-ZxZpE*VS1(30,21))&
   +2D0*HfxZpE*VS1(18,36)
VS0(30,58)=QCx*VS0(30,37)+WQx*VS1(30,37)-r1x2E*VR1(30,37)&
   +4D0*r1x2E*(VS0(30,22)-ZxZpE*VS1(30,22))&
   +2D0*HfxZpE*VS1(18,37)
VS0(30,59)=QCx*VS0(30,38)+WQx*VS1(30,38)-r1x2E*VR1(30,38)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(18,38)
VS0(30,60)=QCx*VS0(30,39)+WQx*VS1(30,39)-r1x2E*VR1(30,39)&
   +2D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))&
   +2D0*HfxZpE*VS1(18,39)
VS0(30,61)=QCy*VS0(30,39)+WQy*VS1(30,39)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))
VS0(30,62)=QCy*VS0(30,40)+WQy*VS1(30,40)&
   +4D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))
VS0(30,63)=QCy*VS0(30,41)+WQy*VS1(30,41)&
   +5D0*r1x2E*(VS0(30,25)-ZxZpE*VS1(30,25))
VS0(30,64)=QCx*VS0(30,42)+WQx*VS1(30,42)-r1x2E*VR1(30,42)&
   +4D0*r1x2E*(VS0(30,26)-ZxZpE*VS1(30,26))&
   +2D0*HfxZpE*VS1(18,42)
VS0(30,65)=QCx*VS0(30,43)+WQx*VS1(30,43)-r1x2E*VR1(30,43)&
   +3D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(18,43)
VS0(30,66)=QCx*VS0(30,44)+WQx*VS1(30,44)-r1x2E*VR1(30,44)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(18,44)
VS0(30,67)=QCy*VS0(30,44)+WQy*VS1(30,44)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))
VS0(30,68)=QCy*VS0(30,45)+WQy*VS1(30,45)&
   +3D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))
VS0(30,69)=QCy*VS0(30,46)+WQy*VS1(30,46)&
   +4D0*r1x2E*(VS0(30,29)-ZxZpE*VS1(30,29))
VS0(30,70)=QCx*VS0(30,47)+WQx*VS1(30,47)-r1x2E*VR1(30,47)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(18,47)
VS0(30,71)=QCx*VS0(30,48)+WQx*VS1(30,48)-r1x2E*VR1(30,48)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(18,48)
VS0(30,72)=QCx*VS0(30,49)+WQx*VS1(30,49)-r1x2E*VR1(30,49)&
   +r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(18,49)
VS0(30,73)=QCy*VS0(30,49)+WQy*VS1(30,49)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))
VS0(30,74)=QCy*VS0(30,50)+WQy*VS1(30,50)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))
VS0(30,75)=QCx*VS0(30,51)+WQx*VS1(30,51)-r1x2E*VR1(30,51)&
   +2D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(18,51)
VS0(30,76)=QCz*VS0(30,48)+WQz*VS1(30,48)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(15,48)
VS0(30,77)=QCz*VS0(30,49)+WQz*VS1(30,49)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(15,49)
VS0(30,78)=QCy*VS0(30,53)+WQy*VS1(30,53)&
   +2D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))
VS0(30,79)=QCz*VS0(30,51)+WQz*VS1(30,51)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(15,51)
VS0(30,80)=QCz*VS0(30,52)+WQz*VS1(30,52)&
   +3D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(15,52)
VS0(30,81)=QCz*VS0(30,53)+WQz*VS1(30,53)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(15,53)
VS0(30,82)=QCz*VS0(30,54)+WQz*VS1(30,54)&
   +4D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(15,54)
VS0(30,83)=QCz*VS0(30,55)+WQz*VS1(30,55)&
   +4D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))&
   +2D0*HfxZpE*VS1(15,55)
VS0(30,84)=QCz*VS0(30,56)+WQz*VS1(30,56)&
   +5D0*r1x2E*(VS0(30,35)-ZxZpE*VS1(30,35))&
   +2D0*HfxZpE*VS1(15,56)
VS0(31,57)=QCx*VS0(31,36)+WQx*VS1(31,36)-r1x2E*VR1(31,36)&
   +5D0*r1x2E*(VS0(31,21)-ZxZpE*VS1(31,21))&
   +HfxZpE*VS1(19,36)
VS0(31,58)=QCx*VS0(31,37)+WQx*VS1(31,37)-r1x2E*VR1(31,37)&
   +4D0*r1x2E*(VS0(31,22)-ZxZpE*VS1(31,22))&
   +HfxZpE*VS1(19,37)
VS0(31,59)=QCx*VS0(31,38)+WQx*VS1(31,38)-r1x2E*VR1(31,38)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(19,38)
VS0(31,60)=QCx*VS0(31,39)+WQx*VS1(31,39)-r1x2E*VR1(31,39)&
   +2D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(19,39)
VS0(31,61)=QCy*VS0(31,39)+WQy*VS1(31,39)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(18,39)
VS0(31,62)=QCy*VS0(31,40)+WQy*VS1(31,40)&
   +4D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(18,40)
VS0(31,63)=QCy*VS0(31,41)+WQy*VS1(31,41)&
   +5D0*r1x2E*(VS0(31,25)-ZxZpE*VS1(31,25))&
   +HfxZpE*VS1(18,41)
VS0(31,64)=QCx*VS0(31,42)+WQx*VS1(31,42)-r1x2E*VR1(31,42)&
   +4D0*r1x2E*(VS0(31,26)-ZxZpE*VS1(31,26))&
   +HfxZpE*VS1(19,42)
VS0(31,65)=QCx*VS0(31,43)+WQx*VS1(31,43)-r1x2E*VR1(31,43)&
   +3D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(19,43)
VS0(31,66)=QCx*VS0(31,44)+WQx*VS1(31,44)-r1x2E*VR1(31,44)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(19,44)
VS0(31,67)=QCy*VS0(31,44)+WQy*VS1(31,44)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(18,44)
VS0(31,68)=QCy*VS0(31,45)+WQy*VS1(31,45)&
   +3D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(18,45)
VS0(31,69)=QCy*VS0(31,46)+WQy*VS1(31,46)&
   +4D0*r1x2E*(VS0(31,29)-ZxZpE*VS1(31,29))&
   +HfxZpE*VS1(18,46)
VS0(31,70)=QCx*VS0(31,47)+WQx*VS1(31,47)-r1x2E*VR1(31,47)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +HfxZpE*VS1(19,47)
VS0(31,71)=QCx*VS0(31,48)+WQx*VS1(31,48)-r1x2E*VR1(31,48)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(19,48)
VS0(31,72)=QCx*VS0(31,49)+WQx*VS1(31,49)-r1x2E*VR1(31,49)&
   +r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(19,49)
VS0(31,73)=QCy*VS0(31,49)+WQy*VS1(31,49)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(18,49)
VS0(31,74)=QCy*VS0(31,50)+WQy*VS1(31,50)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(18,50)
VS0(31,75)=QCx*VS0(31,51)+WQx*VS1(31,51)-r1x2E*VR1(31,51)&
   +2D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +HfxZpE*VS1(19,51)
VS0(31,76)=QCz*VS0(31,48)+WQz*VS1(31,48)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(16,48)
VS0(31,77)=QCz*VS0(31,49)+WQz*VS1(31,49)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(16,49)
VS0(31,78)=QCy*VS0(31,53)+WQy*VS1(31,53)&
   +2D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +HfxZpE*VS1(18,53)
VS0(31,79)=QCz*VS0(31,51)+WQz*VS1(31,51)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(16,51)
VS0(31,80)=QCz*VS0(31,52)+WQz*VS1(31,52)&
   +3D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(16,52)
VS0(31,81)=QCz*VS0(31,53)+WQz*VS1(31,53)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(16,53)
VS0(31,82)=QCz*VS0(31,54)+WQz*VS1(31,54)&
   +4D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +2D0*HfxZpE*VS1(16,54)
VS0(31,83)=QCz*VS0(31,55)+WQz*VS1(31,55)&
   +4D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +2D0*HfxZpE*VS1(16,55)
VS0(31,84)=QCz*VS0(31,56)+WQz*VS1(31,56)&
   +5D0*r1x2E*(VS0(31,35)-ZxZpE*VS1(31,35))&
   +2D0*HfxZpE*VS1(16,56)
VS0(32,57)=QCx*VS0(32,36)+WQx*VS1(32,36)-r1x2E*VR1(32,36)&
   +5D0*r1x2E*(VS0(32,21)-ZxZpE*VS1(32,21))
VS0(32,58)=QCx*VS0(32,37)+WQx*VS1(32,37)-r1x2E*VR1(32,37)&
   +4D0*r1x2E*(VS0(32,22)-ZxZpE*VS1(32,22))
VS0(32,59)=QCx*VS0(32,38)+WQx*VS1(32,38)-r1x2E*VR1(32,38)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))
VS0(32,60)=QCx*VS0(32,39)+WQx*VS1(32,39)-r1x2E*VR1(32,39)&
   +2D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))
VS0(32,61)=QCy*VS0(32,39)+WQy*VS1(32,39)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(19,39)
VS0(32,62)=QCy*VS0(32,40)+WQy*VS1(32,40)&
   +4D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))&
   +2D0*HfxZpE*VS1(19,40)
VS0(32,63)=QCy*VS0(32,41)+WQy*VS1(32,41)&
   +5D0*r1x2E*(VS0(32,25)-ZxZpE*VS1(32,25))&
   +2D0*HfxZpE*VS1(19,41)
VS0(32,64)=QCx*VS0(32,42)+WQx*VS1(32,42)-r1x2E*VR1(32,42)&
   +4D0*r1x2E*(VS0(32,26)-ZxZpE*VS1(32,26))
VS0(32,65)=QCx*VS0(32,43)+WQx*VS1(32,43)-r1x2E*VR1(32,43)&
   +3D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))
VS0(32,66)=QCx*VS0(32,44)+WQx*VS1(32,44)-r1x2E*VR1(32,44)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))
VS0(32,67)=QCy*VS0(32,44)+WQy*VS1(32,44)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(19,44)
VS0(32,68)=QCy*VS0(32,45)+WQy*VS1(32,45)&
   +3D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(19,45)
VS0(32,69)=QCy*VS0(32,46)+WQy*VS1(32,46)&
   +4D0*r1x2E*(VS0(32,29)-ZxZpE*VS1(32,29))&
   +2D0*HfxZpE*VS1(19,46)
VS0(32,70)=QCx*VS0(32,47)+WQx*VS1(32,47)-r1x2E*VR1(32,47)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))
VS0(32,71)=QCx*VS0(32,48)+WQx*VS1(32,48)-r1x2E*VR1(32,48)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))
VS0(32,72)=QCx*VS0(32,49)+WQx*VS1(32,49)-r1x2E*VR1(32,49)&
   +r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))
VS0(32,73)=QCy*VS0(32,49)+WQy*VS1(32,49)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(19,49)
VS0(32,74)=QCy*VS0(32,50)+WQy*VS1(32,50)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(19,50)
VS0(32,75)=QCx*VS0(32,51)+WQx*VS1(32,51)-r1x2E*VR1(32,51)&
   +2D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))
VS0(32,76)=QCz*VS0(32,48)+WQz*VS1(32,48)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(17,48)
VS0(32,77)=QCz*VS0(32,49)+WQz*VS1(32,49)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(17,49)
VS0(32,78)=QCy*VS0(32,53)+WQy*VS1(32,53)&
   +2D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(19,53)
VS0(32,79)=QCz*VS0(32,51)+WQz*VS1(32,51)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(17,51)
VS0(32,80)=QCz*VS0(32,52)+WQz*VS1(32,52)&
   +3D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(17,52)
VS0(32,81)=QCz*VS0(32,53)+WQz*VS1(32,53)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(17,53)
VS0(32,82)=QCz*VS0(32,54)+WQz*VS1(32,54)&
   +4D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))&
   +2D0*HfxZpE*VS1(17,54)
VS0(32,83)=QCz*VS0(32,55)+WQz*VS1(32,55)&
   +4D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(17,55)
VS0(32,84)=QCz*VS0(32,56)+WQz*VS1(32,56)&
   +5D0*r1x2E*(VS0(32,35)-ZxZpE*VS1(32,35))&
   +2D0*HfxZpE*VS1(17,56)
VS0(33,57)=QCx*VS0(33,36)+WQx*VS1(33,36)-r1x2E*VR1(33,36)&
   +5D0*r1x2E*(VS0(33,21)-ZxZpE*VS1(33,21))&
   +HfxZpE*VS1(20,36)
VS0(33,58)=QCx*VS0(33,37)+WQx*VS1(33,37)-r1x2E*VR1(33,37)&
   +4D0*r1x2E*(VS0(33,22)-ZxZpE*VS1(33,22))&
   +HfxZpE*VS1(20,37)
VS0(33,59)=QCx*VS0(33,38)+WQx*VS1(33,38)-r1x2E*VR1(33,38)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))&
   +HfxZpE*VS1(20,38)
VS0(33,60)=QCx*VS0(33,39)+WQx*VS1(33,39)-r1x2E*VR1(33,39)&
   +2D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))&
   +HfxZpE*VS1(20,39)
VS0(33,61)=QCy*VS0(33,39)+WQy*VS1(33,39)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))
VS0(33,62)=QCy*VS0(33,40)+WQy*VS1(33,40)&
   +4D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))
VS0(33,63)=QCy*VS0(33,41)+WQy*VS1(33,41)&
   +5D0*r1x2E*(VS0(33,25)-ZxZpE*VS1(33,25))
VS0(33,64)=QCx*VS0(33,42)+WQx*VS1(33,42)-r1x2E*VR1(33,42)&
   +4D0*r1x2E*(VS0(33,26)-ZxZpE*VS1(33,26))&
   +HfxZpE*VS1(20,42)
VS0(33,65)=QCx*VS0(33,43)+WQx*VS1(33,43)-r1x2E*VR1(33,43)&
   +3D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +HfxZpE*VS1(20,43)
VS0(33,66)=QCx*VS0(33,44)+WQx*VS1(33,44)-r1x2E*VR1(33,44)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +HfxZpE*VS1(20,44)
VS0(33,67)=QCy*VS0(33,44)+WQy*VS1(33,44)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))
VS0(33,68)=QCy*VS0(33,45)+WQy*VS1(33,45)&
   +3D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))
VS0(33,69)=QCy*VS0(33,46)+WQy*VS1(33,46)&
   +4D0*r1x2E*(VS0(33,29)-ZxZpE*VS1(33,29))
VS0(33,70)=QCx*VS0(33,47)+WQx*VS1(33,47)-r1x2E*VR1(33,47)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +HfxZpE*VS1(20,47)
VS0(33,71)=QCx*VS0(33,48)+WQx*VS1(33,48)-r1x2E*VR1(33,48)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +HfxZpE*VS1(20,48)
VS0(33,72)=QCx*VS0(33,49)+WQx*VS1(33,49)-r1x2E*VR1(33,49)&
   +r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +HfxZpE*VS1(20,49)
VS0(33,73)=QCy*VS0(33,49)+WQy*VS1(33,49)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))
VS0(33,74)=QCy*VS0(33,50)+WQy*VS1(33,50)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))
VS0(33,75)=QCx*VS0(33,51)+WQx*VS1(33,51)-r1x2E*VR1(33,51)&
   +2D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +HfxZpE*VS1(20,51)
VS0(33,76)=QCz*VS0(33,48)+WQz*VS1(33,48)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +3D0*HfxZpE*VS1(18,48)
VS0(33,77)=QCz*VS0(33,49)+WQz*VS1(33,49)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +3D0*HfxZpE*VS1(18,49)
VS0(33,78)=QCy*VS0(33,53)+WQy*VS1(33,53)&
   +2D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))
VS0(33,79)=QCz*VS0(33,51)+WQz*VS1(33,51)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +3D0*HfxZpE*VS1(18,51)
VS0(33,80)=QCz*VS0(33,52)+WQz*VS1(33,52)&
   +3D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +3D0*HfxZpE*VS1(18,52)
VS0(33,81)=QCz*VS0(33,53)+WQz*VS1(33,53)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +3D0*HfxZpE*VS1(18,53)
VS0(33,82)=QCz*VS0(33,54)+WQz*VS1(33,54)&
   +4D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(18,54)
VS0(33,83)=QCz*VS0(33,55)+WQz*VS1(33,55)&
   +4D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(18,55)
VS0(33,84)=QCz*VS0(33,56)+WQz*VS1(33,56)&
   +5D0*r1x2E*(VS0(33,35)-ZxZpE*VS1(33,35))&
   +3D0*HfxZpE*VS1(18,56)
VS0(34,57)=QCx*VS0(34,36)+WQx*VS1(34,36)-r1x2E*VR1(34,36)&
   +5D0*r1x2E*(VS0(34,21)-ZxZpE*VS1(34,21))
VS0(34,58)=QCx*VS0(34,37)+WQx*VS1(34,37)-r1x2E*VR1(34,37)&
   +4D0*r1x2E*(VS0(34,22)-ZxZpE*VS1(34,22))
VS0(34,59)=QCx*VS0(34,38)+WQx*VS1(34,38)-r1x2E*VR1(34,38)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))
VS0(34,60)=QCx*VS0(34,39)+WQx*VS1(34,39)-r1x2E*VR1(34,39)&
   +2D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))
VS0(34,61)=QCy*VS0(34,39)+WQy*VS1(34,39)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))&
   +HfxZpE*VS1(20,39)
VS0(34,62)=QCy*VS0(34,40)+WQy*VS1(34,40)&
   +4D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))&
   +HfxZpE*VS1(20,40)
VS0(34,63)=QCy*VS0(34,41)+WQy*VS1(34,41)&
   +5D0*r1x2E*(VS0(34,25)-ZxZpE*VS1(34,25))&
   +HfxZpE*VS1(20,41)
VS0(34,64)=QCx*VS0(34,42)+WQx*VS1(34,42)-r1x2E*VR1(34,42)&
   +4D0*r1x2E*(VS0(34,26)-ZxZpE*VS1(34,26))
VS0(34,65)=QCx*VS0(34,43)+WQx*VS1(34,43)-r1x2E*VR1(34,43)&
   +3D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))
VS0(34,66)=QCx*VS0(34,44)+WQx*VS1(34,44)-r1x2E*VR1(34,44)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))
VS0(34,67)=QCy*VS0(34,44)+WQy*VS1(34,44)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +HfxZpE*VS1(20,44)
VS0(34,68)=QCy*VS0(34,45)+WQy*VS1(34,45)&
   +3D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +HfxZpE*VS1(20,45)
VS0(34,69)=QCy*VS0(34,46)+WQy*VS1(34,46)&
   +4D0*r1x2E*(VS0(34,29)-ZxZpE*VS1(34,29))&
   +HfxZpE*VS1(20,46)
VS0(34,70)=QCx*VS0(34,47)+WQx*VS1(34,47)-r1x2E*VR1(34,47)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))
VS0(34,71)=QCx*VS0(34,48)+WQx*VS1(34,48)-r1x2E*VR1(34,48)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))
VS0(34,72)=QCx*VS0(34,49)+WQx*VS1(34,49)-r1x2E*VR1(34,49)&
   +r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))
VS0(34,73)=QCy*VS0(34,49)+WQy*VS1(34,49)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +HfxZpE*VS1(20,49)
VS0(34,74)=QCy*VS0(34,50)+WQy*VS1(34,50)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +HfxZpE*VS1(20,50)
VS0(34,75)=QCx*VS0(34,51)+WQx*VS1(34,51)-r1x2E*VR1(34,51)&
   +2D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))
VS0(34,76)=QCz*VS0(34,48)+WQz*VS1(34,48)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +3D0*HfxZpE*VS1(19,48)
VS0(34,77)=QCz*VS0(34,49)+WQz*VS1(34,49)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +3D0*HfxZpE*VS1(19,49)
VS0(34,78)=QCy*VS0(34,53)+WQy*VS1(34,53)&
   +2D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +HfxZpE*VS1(20,53)
VS0(34,79)=QCz*VS0(34,51)+WQz*VS1(34,51)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))&
   +3D0*HfxZpE*VS1(19,51)
VS0(34,80)=QCz*VS0(34,52)+WQz*VS1(34,52)&
   +3D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +3D0*HfxZpE*VS1(19,52)
VS0(34,81)=QCz*VS0(34,53)+WQz*VS1(34,53)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +3D0*HfxZpE*VS1(19,53)
VS0(34,82)=QCz*VS0(34,54)+WQz*VS1(34,54)&
   +4D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(19,54)
VS0(34,83)=QCz*VS0(34,55)+WQz*VS1(34,55)&
   +4D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(19,55)
VS0(34,84)=QCz*VS0(34,56)+WQz*VS1(34,56)&
   +5D0*r1x2E*(VS0(34,35)-ZxZpE*VS1(34,35))&
   +3D0*HfxZpE*VS1(19,56)
VS0(35,57)=QCx*VS0(35,36)+WQx*VS1(35,36)-r1x2E*VR1(35,36)&
   +5D0*r1x2E*(VS0(35,21)-ZxZpE*VS1(35,21))
VS0(35,58)=QCx*VS0(35,37)+WQx*VS1(35,37)-r1x2E*VR1(35,37)&
   +4D0*r1x2E*(VS0(35,22)-ZxZpE*VS1(35,22))
VS0(35,59)=QCx*VS0(35,38)+WQx*VS1(35,38)-r1x2E*VR1(35,38)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,60)=QCx*VS0(35,39)+WQx*VS1(35,39)-r1x2E*VR1(35,39)&
   +2D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,61)=QCy*VS0(35,39)+WQy*VS1(35,39)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,62)=QCy*VS0(35,40)+WQy*VS1(35,40)&
   +4D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,63)=QCy*VS0(35,41)+WQy*VS1(35,41)&
   +5D0*r1x2E*(VS0(35,25)-ZxZpE*VS1(35,25))
VS0(35,64)=QCx*VS0(35,42)+WQx*VS1(35,42)-r1x2E*VR1(35,42)&
   +4D0*r1x2E*(VS0(35,26)-ZxZpE*VS1(35,26))
VS0(35,65)=QCx*VS0(35,43)+WQx*VS1(35,43)-r1x2E*VR1(35,43)&
   +3D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,66)=QCx*VS0(35,44)+WQx*VS1(35,44)-r1x2E*VR1(35,44)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,67)=QCy*VS0(35,44)+WQy*VS1(35,44)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,68)=QCy*VS0(35,45)+WQy*VS1(35,45)&
   +3D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,69)=QCy*VS0(35,46)+WQy*VS1(35,46)&
   +4D0*r1x2E*(VS0(35,29)-ZxZpE*VS1(35,29))
VS0(35,70)=QCx*VS0(35,47)+WQx*VS1(35,47)-r1x2E*VR1(35,47)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))
VS0(35,71)=QCx*VS0(35,48)+WQx*VS1(35,48)-r1x2E*VR1(35,48)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,72)=QCx*VS0(35,49)+WQx*VS1(35,49)-r1x2E*VR1(35,49)&
   +r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,73)=QCy*VS0(35,49)+WQy*VS1(35,49)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,74)=QCy*VS0(35,50)+WQy*VS1(35,50)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,75)=QCx*VS0(35,51)+WQx*VS1(35,51)-r1x2E*VR1(35,51)&
   +2D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))
VS0(35,76)=QCz*VS0(35,48)+WQz*VS1(35,48)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))&
   +4D0*HfxZpE*VS1(20,48)
VS0(35,77)=QCz*VS0(35,49)+WQz*VS1(35,49)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))&
   +4D0*HfxZpE*VS1(20,49)
VS0(35,78)=QCy*VS0(35,53)+WQy*VS1(35,53)&
   +2D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))
VS0(35,79)=QCz*VS0(35,51)+WQz*VS1(35,51)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))&
   +4D0*HfxZpE*VS1(20,51)
VS0(35,80)=QCz*VS0(35,52)+WQz*VS1(35,52)&
   +3D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))&
   +4D0*HfxZpE*VS1(20,52)
VS0(35,81)=QCz*VS0(35,53)+WQz*VS1(35,53)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))&
   +4D0*HfxZpE*VS1(20,53)
VS0(35,82)=QCz*VS0(35,54)+WQz*VS1(35,54)&
   +4D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))&
   +4D0*HfxZpE*VS1(20,54)
VS0(35,83)=QCz*VS0(35,55)+WQz*VS1(35,55)&
   +4D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))&
   +4D0*HfxZpE*VS1(20,55)
VS0(35,84)=QCz*VS0(35,56)+WQz*VS1(35,56)&
   +5D0*r1x2E*(VS0(35,35)-ZxZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(20,56)
CASE(2)
VS0(21,57)=QCx*VS0(21,36)+WQx*VS1(21,36)&
   +5D0*r1x2E*(VS0(21,21)-ZxZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(11,36)
VS0(21,58)=QCx*VS0(21,37)+WQx*VS1(21,37)&
   +4D0*r1x2E*(VS0(21,22)-ZxZpE*VS1(21,22))&
   +4D0*HfxZpE*VS1(11,37)
VS0(21,59)=QCx*VS0(21,38)+WQx*VS1(21,38)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))&
   +4D0*HfxZpE*VS1(11,38)
VS0(21,60)=QCx*VS0(21,39)+WQx*VS1(21,39)&
   +2D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))&
   +4D0*HfxZpE*VS1(11,39)
VS0(21,61)=QCy*VS0(21,39)+WQy*VS1(21,39)-r1x2E*VR1(21,39)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))
VS0(21,62)=QCy*VS0(21,40)+WQy*VS1(21,40)-r1x2E*VR1(21,40)&
   +4D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))
VS0(21,63)=QCy*VS0(21,41)+WQy*VS1(21,41)-r1x2E*VR1(21,41)&
   +5D0*r1x2E*(VS0(21,25)-ZxZpE*VS1(21,25))
VS0(21,64)=QCx*VS0(21,42)+WQx*VS1(21,42)&
   +4D0*r1x2E*(VS0(21,26)-ZxZpE*VS1(21,26))&
   +4D0*HfxZpE*VS1(11,42)
VS0(21,65)=QCx*VS0(21,43)+WQx*VS1(21,43)&
   +3D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))&
   +4D0*HfxZpE*VS1(11,43)
VS0(21,66)=QCx*VS0(21,44)+WQx*VS1(21,44)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))&
   +4D0*HfxZpE*VS1(11,44)
VS0(21,67)=QCy*VS0(21,44)+WQy*VS1(21,44)-r1x2E*VR1(21,44)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,68)=QCy*VS0(21,45)+WQy*VS1(21,45)-r1x2E*VR1(21,45)&
   +3D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,69)=QCy*VS0(21,46)+WQy*VS1(21,46)-r1x2E*VR1(21,46)&
   +4D0*r1x2E*(VS0(21,29)-ZxZpE*VS1(21,29))
VS0(21,70)=QCx*VS0(21,47)+WQx*VS1(21,47)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))&
   +4D0*HfxZpE*VS1(11,47)
VS0(21,71)=QCx*VS0(21,48)+WQx*VS1(21,48)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))&
   +4D0*HfxZpE*VS1(11,48)
VS0(21,72)=QCx*VS0(21,49)+WQx*VS1(21,49)&
   +r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))&
   +4D0*HfxZpE*VS1(11,49)
VS0(21,73)=QCy*VS0(21,49)+WQy*VS1(21,49)-r1x2E*VR1(21,49)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,74)=QCy*VS0(21,50)+WQy*VS1(21,50)-r1x2E*VR1(21,50)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,75)=QCx*VS0(21,51)+WQx*VS1(21,51)&
   +2D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))&
   +4D0*HfxZpE*VS1(11,51)
VS0(21,76)=QCz*VS0(21,48)+WQz*VS1(21,48)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,77)=QCz*VS0(21,49)+WQz*VS1(21,49)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,78)=QCy*VS0(21,53)+WQy*VS1(21,53)-r1x2E*VR1(21,53)&
   +2D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,79)=QCz*VS0(21,51)+WQz*VS1(21,51)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))
VS0(21,80)=QCz*VS0(21,52)+WQz*VS1(21,52)&
   +3D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,81)=QCz*VS0(21,53)+WQz*VS1(21,53)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,82)=QCz*VS0(21,54)+WQz*VS1(21,54)&
   +4D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))
VS0(21,83)=QCz*VS0(21,55)+WQz*VS1(21,55)&
   +4D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,84)=QCz*VS0(21,56)+WQz*VS1(21,56)&
   +5D0*r1x2E*(VS0(21,35)-ZxZpE*VS1(21,35))
VS0(22,57)=QCx*VS0(22,36)+WQx*VS1(22,36)&
   +5D0*r1x2E*(VS0(22,21)-ZxZpE*VS1(22,21))&
   +3D0*HfxZpE*VS1(12,36)
VS0(22,58)=QCx*VS0(22,37)+WQx*VS1(22,37)&
   +4D0*r1x2E*(VS0(22,22)-ZxZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(12,37)
VS0(22,59)=QCx*VS0(22,38)+WQx*VS1(22,38)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +3D0*HfxZpE*VS1(12,38)
VS0(22,60)=QCx*VS0(22,39)+WQx*VS1(22,39)&
   +2D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +3D0*HfxZpE*VS1(12,39)
VS0(22,61)=QCy*VS0(22,39)+WQy*VS1(22,39)-r1x2E*VR1(22,39)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +HfxZpE*VS1(11,39)
VS0(22,62)=QCy*VS0(22,40)+WQy*VS1(22,40)-r1x2E*VR1(22,40)&
   +4D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +HfxZpE*VS1(11,40)
VS0(22,63)=QCy*VS0(22,41)+WQy*VS1(22,41)-r1x2E*VR1(22,41)&
   +5D0*r1x2E*(VS0(22,25)-ZxZpE*VS1(22,25))&
   +HfxZpE*VS1(11,41)
VS0(22,64)=QCx*VS0(22,42)+WQx*VS1(22,42)&
   +4D0*r1x2E*(VS0(22,26)-ZxZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(12,42)
VS0(22,65)=QCx*VS0(22,43)+WQx*VS1(22,43)&
   +3D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +3D0*HfxZpE*VS1(12,43)
VS0(22,66)=QCx*VS0(22,44)+WQx*VS1(22,44)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +3D0*HfxZpE*VS1(12,44)
VS0(22,67)=QCy*VS0(22,44)+WQy*VS1(22,44)-r1x2E*VR1(22,44)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +HfxZpE*VS1(11,44)
VS0(22,68)=QCy*VS0(22,45)+WQy*VS1(22,45)-r1x2E*VR1(22,45)&
   +3D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +HfxZpE*VS1(11,45)
VS0(22,69)=QCy*VS0(22,46)+WQy*VS1(22,46)-r1x2E*VR1(22,46)&
   +4D0*r1x2E*(VS0(22,29)-ZxZpE*VS1(22,29))&
   +HfxZpE*VS1(11,46)
VS0(22,70)=QCx*VS0(22,47)+WQx*VS1(22,47)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))&
   +3D0*HfxZpE*VS1(12,47)
VS0(22,71)=QCx*VS0(22,48)+WQx*VS1(22,48)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +3D0*HfxZpE*VS1(12,48)
VS0(22,72)=QCx*VS0(22,49)+WQx*VS1(22,49)&
   +r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +3D0*HfxZpE*VS1(12,49)
VS0(22,73)=QCy*VS0(22,49)+WQy*VS1(22,49)-r1x2E*VR1(22,49)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +HfxZpE*VS1(11,49)
VS0(22,74)=QCy*VS0(22,50)+WQy*VS1(22,50)-r1x2E*VR1(22,50)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +HfxZpE*VS1(11,50)
VS0(22,75)=QCx*VS0(22,51)+WQx*VS1(22,51)&
   +2D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))&
   +3D0*HfxZpE*VS1(12,51)
VS0(22,76)=QCz*VS0(22,48)+WQz*VS1(22,48)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))
VS0(22,77)=QCz*VS0(22,49)+WQz*VS1(22,49)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))
VS0(22,78)=QCy*VS0(22,53)+WQy*VS1(22,53)-r1x2E*VR1(22,53)&
   +2D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))&
   +HfxZpE*VS1(11,53)
VS0(22,79)=QCz*VS0(22,51)+WQz*VS1(22,51)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))
VS0(22,80)=QCz*VS0(22,52)+WQz*VS1(22,52)&
   +3D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))
VS0(22,81)=QCz*VS0(22,53)+WQz*VS1(22,53)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))
VS0(22,82)=QCz*VS0(22,54)+WQz*VS1(22,54)&
   +4D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))
VS0(22,83)=QCz*VS0(22,55)+WQz*VS1(22,55)&
   +4D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))
VS0(22,84)=QCz*VS0(22,56)+WQz*VS1(22,56)&
   +5D0*r1x2E*(VS0(22,35)-ZxZpE*VS1(22,35))
VS0(23,57)=QCx*VS0(23,36)+WQx*VS1(23,36)&
   +5D0*r1x2E*(VS0(23,21)-ZxZpE*VS1(23,21))&
   +2D0*HfxZpE*VS1(13,36)
VS0(23,58)=QCx*VS0(23,37)+WQx*VS1(23,37)&
   +4D0*r1x2E*(VS0(23,22)-ZxZpE*VS1(23,22))&
   +2D0*HfxZpE*VS1(13,37)
VS0(23,59)=QCx*VS0(23,38)+WQx*VS1(23,38)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(13,38)
VS0(23,60)=QCx*VS0(23,39)+WQx*VS1(23,39)&
   +2D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(13,39)
VS0(23,61)=QCy*VS0(23,39)+WQy*VS1(23,39)-r1x2E*VR1(23,39)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(12,39)
VS0(23,62)=QCy*VS0(23,40)+WQy*VS1(23,40)-r1x2E*VR1(23,40)&
   +4D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(12,40)
VS0(23,63)=QCy*VS0(23,41)+WQy*VS1(23,41)-r1x2E*VR1(23,41)&
   +5D0*r1x2E*(VS0(23,25)-ZxZpE*VS1(23,25))&
   +2D0*HfxZpE*VS1(12,41)
VS0(23,64)=QCx*VS0(23,42)+WQx*VS1(23,42)&
   +4D0*r1x2E*(VS0(23,26)-ZxZpE*VS1(23,26))&
   +2D0*HfxZpE*VS1(13,42)
VS0(23,65)=QCx*VS0(23,43)+WQx*VS1(23,43)&
   +3D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(13,43)
VS0(23,66)=QCx*VS0(23,44)+WQx*VS1(23,44)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(13,44)
VS0(23,67)=QCy*VS0(23,44)+WQy*VS1(23,44)-r1x2E*VR1(23,44)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(12,44)
VS0(23,68)=QCy*VS0(23,45)+WQy*VS1(23,45)-r1x2E*VR1(23,45)&
   +3D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(12,45)
VS0(23,69)=QCy*VS0(23,46)+WQy*VS1(23,46)-r1x2E*VR1(23,46)&
   +4D0*r1x2E*(VS0(23,29)-ZxZpE*VS1(23,29))&
   +2D0*HfxZpE*VS1(12,46)
VS0(23,70)=QCx*VS0(23,47)+WQx*VS1(23,47)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(13,47)
VS0(23,71)=QCx*VS0(23,48)+WQx*VS1(23,48)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(13,48)
VS0(23,72)=QCx*VS0(23,49)+WQx*VS1(23,49)&
   +r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(13,49)
VS0(23,73)=QCy*VS0(23,49)+WQy*VS1(23,49)-r1x2E*VR1(23,49)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(12,49)
VS0(23,74)=QCy*VS0(23,50)+WQy*VS1(23,50)-r1x2E*VR1(23,50)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(12,50)
VS0(23,75)=QCx*VS0(23,51)+WQx*VS1(23,51)&
   +2D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))&
   +2D0*HfxZpE*VS1(13,51)
VS0(23,76)=QCz*VS0(23,48)+WQz*VS1(23,48)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))
VS0(23,77)=QCz*VS0(23,49)+WQz*VS1(23,49)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))
VS0(23,78)=QCy*VS0(23,53)+WQy*VS1(23,53)-r1x2E*VR1(23,53)&
   +2D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))&
   +2D0*HfxZpE*VS1(12,53)
VS0(23,79)=QCz*VS0(23,51)+WQz*VS1(23,51)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))
VS0(23,80)=QCz*VS0(23,52)+WQz*VS1(23,52)&
   +3D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))
VS0(23,81)=QCz*VS0(23,53)+WQz*VS1(23,53)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))
VS0(23,82)=QCz*VS0(23,54)+WQz*VS1(23,54)&
   +4D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))
VS0(23,83)=QCz*VS0(23,55)+WQz*VS1(23,55)&
   +4D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))
VS0(23,84)=QCz*VS0(23,56)+WQz*VS1(23,56)&
   +5D0*r1x2E*(VS0(23,35)-ZxZpE*VS1(23,35))
VS0(24,57)=QCx*VS0(24,36)+WQx*VS1(24,36)&
   +5D0*r1x2E*(VS0(24,21)-ZxZpE*VS1(24,21))&
   +HfxZpE*VS1(14,36)
VS0(24,58)=QCx*VS0(24,37)+WQx*VS1(24,37)&
   +4D0*r1x2E*(VS0(24,22)-ZxZpE*VS1(24,22))&
   +HfxZpE*VS1(14,37)
VS0(24,59)=QCx*VS0(24,38)+WQx*VS1(24,38)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +HfxZpE*VS1(14,38)
VS0(24,60)=QCx*VS0(24,39)+WQx*VS1(24,39)&
   +2D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +HfxZpE*VS1(14,39)
VS0(24,61)=QCy*VS0(24,39)+WQy*VS1(24,39)-r1x2E*VR1(24,39)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +3D0*HfxZpE*VS1(13,39)
VS0(24,62)=QCy*VS0(24,40)+WQy*VS1(24,40)-r1x2E*VR1(24,40)&
   +4D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(13,40)
VS0(24,63)=QCy*VS0(24,41)+WQy*VS1(24,41)-r1x2E*VR1(24,41)&
   +5D0*r1x2E*(VS0(24,25)-ZxZpE*VS1(24,25))&
   +3D0*HfxZpE*VS1(13,41)
VS0(24,64)=QCx*VS0(24,42)+WQx*VS1(24,42)&
   +4D0*r1x2E*(VS0(24,26)-ZxZpE*VS1(24,26))&
   +HfxZpE*VS1(14,42)
VS0(24,65)=QCx*VS0(24,43)+WQx*VS1(24,43)&
   +3D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +HfxZpE*VS1(14,43)
VS0(24,66)=QCx*VS0(24,44)+WQx*VS1(24,44)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +HfxZpE*VS1(14,44)
VS0(24,67)=QCy*VS0(24,44)+WQy*VS1(24,44)-r1x2E*VR1(24,44)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +3D0*HfxZpE*VS1(13,44)
VS0(24,68)=QCy*VS0(24,45)+WQy*VS1(24,45)-r1x2E*VR1(24,45)&
   +3D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +3D0*HfxZpE*VS1(13,45)
VS0(24,69)=QCy*VS0(24,46)+WQy*VS1(24,46)-r1x2E*VR1(24,46)&
   +4D0*r1x2E*(VS0(24,29)-ZxZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(13,46)
VS0(24,70)=QCx*VS0(24,47)+WQx*VS1(24,47)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))&
   +HfxZpE*VS1(14,47)
VS0(24,71)=QCx*VS0(24,48)+WQx*VS1(24,48)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +HfxZpE*VS1(14,48)
VS0(24,72)=QCx*VS0(24,49)+WQx*VS1(24,49)&
   +r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +HfxZpE*VS1(14,49)
VS0(24,73)=QCy*VS0(24,49)+WQy*VS1(24,49)-r1x2E*VR1(24,49)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +3D0*HfxZpE*VS1(13,49)
VS0(24,74)=QCy*VS0(24,50)+WQy*VS1(24,50)-r1x2E*VR1(24,50)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +3D0*HfxZpE*VS1(13,50)
VS0(24,75)=QCx*VS0(24,51)+WQx*VS1(24,51)&
   +2D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))&
   +HfxZpE*VS1(14,51)
VS0(24,76)=QCz*VS0(24,48)+WQz*VS1(24,48)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))
VS0(24,77)=QCz*VS0(24,49)+WQz*VS1(24,49)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))
VS0(24,78)=QCy*VS0(24,53)+WQy*VS1(24,53)-r1x2E*VR1(24,53)&
   +2D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))&
   +3D0*HfxZpE*VS1(13,53)
VS0(24,79)=QCz*VS0(24,51)+WQz*VS1(24,51)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))
VS0(24,80)=QCz*VS0(24,52)+WQz*VS1(24,52)&
   +3D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))
VS0(24,81)=QCz*VS0(24,53)+WQz*VS1(24,53)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))
VS0(24,82)=QCz*VS0(24,54)+WQz*VS1(24,54)&
   +4D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))
VS0(24,83)=QCz*VS0(24,55)+WQz*VS1(24,55)&
   +4D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))
VS0(24,84)=QCz*VS0(24,56)+WQz*VS1(24,56)&
   +5D0*r1x2E*(VS0(24,35)-ZxZpE*VS1(24,35))
VS0(25,57)=QCx*VS0(25,36)+WQx*VS1(25,36)&
   +5D0*r1x2E*(VS0(25,21)-ZxZpE*VS1(25,21))
VS0(25,58)=QCx*VS0(25,37)+WQx*VS1(25,37)&
   +4D0*r1x2E*(VS0(25,22)-ZxZpE*VS1(25,22))
VS0(25,59)=QCx*VS0(25,38)+WQx*VS1(25,38)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))
VS0(25,60)=QCx*VS0(25,39)+WQx*VS1(25,39)&
   +2D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))
VS0(25,61)=QCy*VS0(25,39)+WQy*VS1(25,39)-r1x2E*VR1(25,39)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))&
   +4D0*HfxZpE*VS1(14,39)
VS0(25,62)=QCy*VS0(25,40)+WQy*VS1(25,40)-r1x2E*VR1(25,40)&
   +4D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))&
   +4D0*HfxZpE*VS1(14,40)
VS0(25,63)=QCy*VS0(25,41)+WQy*VS1(25,41)-r1x2E*VR1(25,41)&
   +5D0*r1x2E*(VS0(25,25)-ZxZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(14,41)
VS0(25,64)=QCx*VS0(25,42)+WQx*VS1(25,42)&
   +4D0*r1x2E*(VS0(25,26)-ZxZpE*VS1(25,26))
VS0(25,65)=QCx*VS0(25,43)+WQx*VS1(25,43)&
   +3D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,66)=QCx*VS0(25,44)+WQx*VS1(25,44)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,67)=QCy*VS0(25,44)+WQy*VS1(25,44)-r1x2E*VR1(25,44)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))&
   +4D0*HfxZpE*VS1(14,44)
VS0(25,68)=QCy*VS0(25,45)+WQy*VS1(25,45)-r1x2E*VR1(25,45)&
   +3D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))&
   +4D0*HfxZpE*VS1(14,45)
VS0(25,69)=QCy*VS0(25,46)+WQy*VS1(25,46)-r1x2E*VR1(25,46)&
   +4D0*r1x2E*(VS0(25,29)-ZxZpE*VS1(25,29))&
   +4D0*HfxZpE*VS1(14,46)
VS0(25,70)=QCx*VS0(25,47)+WQx*VS1(25,47)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,71)=QCx*VS0(25,48)+WQx*VS1(25,48)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,72)=QCx*VS0(25,49)+WQx*VS1(25,49)&
   +r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,73)=QCy*VS0(25,49)+WQy*VS1(25,49)-r1x2E*VR1(25,49)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))&
   +4D0*HfxZpE*VS1(14,49)
VS0(25,74)=QCy*VS0(25,50)+WQy*VS1(25,50)-r1x2E*VR1(25,50)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))&
   +4D0*HfxZpE*VS1(14,50)
VS0(25,75)=QCx*VS0(25,51)+WQx*VS1(25,51)&
   +2D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,76)=QCz*VS0(25,48)+WQz*VS1(25,48)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,77)=QCz*VS0(25,49)+WQz*VS1(25,49)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,78)=QCy*VS0(25,53)+WQy*VS1(25,53)-r1x2E*VR1(25,53)&
   +2D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))&
   +4D0*HfxZpE*VS1(14,53)
VS0(25,79)=QCz*VS0(25,51)+WQz*VS1(25,51)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,80)=QCz*VS0(25,52)+WQz*VS1(25,52)&
   +3D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,81)=QCz*VS0(25,53)+WQz*VS1(25,53)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,82)=QCz*VS0(25,54)+WQz*VS1(25,54)&
   +4D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,83)=QCz*VS0(25,55)+WQz*VS1(25,55)&
   +4D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))
VS0(25,84)=QCz*VS0(25,56)+WQz*VS1(25,56)&
   +5D0*r1x2E*(VS0(25,35)-ZxZpE*VS1(25,35))
VS0(26,57)=QCx*VS0(26,36)+WQx*VS1(26,36)&
   +5D0*r1x2E*(VS0(26,21)-ZxZpE*VS1(26,21))&
   +3D0*HfxZpE*VS1(15,36)
VS0(26,58)=QCx*VS0(26,37)+WQx*VS1(26,37)&
   +4D0*r1x2E*(VS0(26,22)-ZxZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(15,37)
VS0(26,59)=QCx*VS0(26,38)+WQx*VS1(26,38)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))&
   +3D0*HfxZpE*VS1(15,38)
VS0(26,60)=QCx*VS0(26,39)+WQx*VS1(26,39)&
   +2D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))&
   +3D0*HfxZpE*VS1(15,39)
VS0(26,61)=QCy*VS0(26,39)+WQy*VS1(26,39)-r1x2E*VR1(26,39)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))
VS0(26,62)=QCy*VS0(26,40)+WQy*VS1(26,40)-r1x2E*VR1(26,40)&
   +4D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))
VS0(26,63)=QCy*VS0(26,41)+WQy*VS1(26,41)-r1x2E*VR1(26,41)&
   +5D0*r1x2E*(VS0(26,25)-ZxZpE*VS1(26,25))
VS0(26,64)=QCx*VS0(26,42)+WQx*VS1(26,42)&
   +4D0*r1x2E*(VS0(26,26)-ZxZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(15,42)
VS0(26,65)=QCx*VS0(26,43)+WQx*VS1(26,43)&
   +3D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +3D0*HfxZpE*VS1(15,43)
VS0(26,66)=QCx*VS0(26,44)+WQx*VS1(26,44)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +3D0*HfxZpE*VS1(15,44)
VS0(26,67)=QCy*VS0(26,44)+WQy*VS1(26,44)-r1x2E*VR1(26,44)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))
VS0(26,68)=QCy*VS0(26,45)+WQy*VS1(26,45)-r1x2E*VR1(26,45)&
   +3D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))
VS0(26,69)=QCy*VS0(26,46)+WQy*VS1(26,46)-r1x2E*VR1(26,46)&
   +4D0*r1x2E*(VS0(26,29)-ZxZpE*VS1(26,29))
VS0(26,70)=QCx*VS0(26,47)+WQx*VS1(26,47)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +3D0*HfxZpE*VS1(15,47)
VS0(26,71)=QCx*VS0(26,48)+WQx*VS1(26,48)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +3D0*HfxZpE*VS1(15,48)
VS0(26,72)=QCx*VS0(26,49)+WQx*VS1(26,49)&
   +r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +3D0*HfxZpE*VS1(15,49)
VS0(26,73)=QCy*VS0(26,49)+WQy*VS1(26,49)-r1x2E*VR1(26,49)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))
VS0(26,74)=QCy*VS0(26,50)+WQy*VS1(26,50)-r1x2E*VR1(26,50)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))
VS0(26,75)=QCx*VS0(26,51)+WQx*VS1(26,51)&
   +2D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +3D0*HfxZpE*VS1(15,51)
VS0(26,76)=QCz*VS0(26,48)+WQz*VS1(26,48)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +HfxZpE*VS1(11,48)
VS0(26,77)=QCz*VS0(26,49)+WQz*VS1(26,49)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +HfxZpE*VS1(11,49)
VS0(26,78)=QCy*VS0(26,53)+WQy*VS1(26,53)-r1x2E*VR1(26,53)&
   +2D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))
VS0(26,79)=QCz*VS0(26,51)+WQz*VS1(26,51)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +HfxZpE*VS1(11,51)
VS0(26,80)=QCz*VS0(26,52)+WQz*VS1(26,52)&
   +3D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +HfxZpE*VS1(11,52)
VS0(26,81)=QCz*VS0(26,53)+WQz*VS1(26,53)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +HfxZpE*VS1(11,53)
VS0(26,82)=QCz*VS0(26,54)+WQz*VS1(26,54)&
   +4D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +HfxZpE*VS1(11,54)
VS0(26,83)=QCz*VS0(26,55)+WQz*VS1(26,55)&
   +4D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))&
   +HfxZpE*VS1(11,55)
VS0(26,84)=QCz*VS0(26,56)+WQz*VS1(26,56)&
   +5D0*r1x2E*(VS0(26,35)-ZxZpE*VS1(26,35))&
   +HfxZpE*VS1(11,56)
VS0(27,57)=QCx*VS0(27,36)+WQx*VS1(27,36)&
   +5D0*r1x2E*(VS0(27,21)-ZxZpE*VS1(27,21))&
   +2D0*HfxZpE*VS1(16,36)
VS0(27,58)=QCx*VS0(27,37)+WQx*VS1(27,37)&
   +4D0*r1x2E*(VS0(27,22)-ZxZpE*VS1(27,22))&
   +2D0*HfxZpE*VS1(16,37)
VS0(27,59)=QCx*VS0(27,38)+WQx*VS1(27,38)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(16,38)
VS0(27,60)=QCx*VS0(27,39)+WQx*VS1(27,39)&
   +2D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +2D0*HfxZpE*VS1(16,39)
VS0(27,61)=QCy*VS0(27,39)+WQy*VS1(27,39)-r1x2E*VR1(27,39)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +HfxZpE*VS1(15,39)
VS0(27,62)=QCy*VS0(27,40)+WQy*VS1(27,40)-r1x2E*VR1(27,40)&
   +4D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +HfxZpE*VS1(15,40)
VS0(27,63)=QCy*VS0(27,41)+WQy*VS1(27,41)-r1x2E*VR1(27,41)&
   +5D0*r1x2E*(VS0(27,25)-ZxZpE*VS1(27,25))&
   +HfxZpE*VS1(15,41)
VS0(27,64)=QCx*VS0(27,42)+WQx*VS1(27,42)&
   +4D0*r1x2E*(VS0(27,26)-ZxZpE*VS1(27,26))&
   +2D0*HfxZpE*VS1(16,42)
VS0(27,65)=QCx*VS0(27,43)+WQx*VS1(27,43)&
   +3D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(16,43)
VS0(27,66)=QCx*VS0(27,44)+WQx*VS1(27,44)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(16,44)
VS0(27,67)=QCy*VS0(27,44)+WQy*VS1(27,44)-r1x2E*VR1(27,44)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(15,44)
VS0(27,68)=QCy*VS0(27,45)+WQy*VS1(27,45)-r1x2E*VR1(27,45)&
   +3D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(15,45)
VS0(27,69)=QCy*VS0(27,46)+WQy*VS1(27,46)-r1x2E*VR1(27,46)&
   +4D0*r1x2E*(VS0(27,29)-ZxZpE*VS1(27,29))&
   +HfxZpE*VS1(15,46)
VS0(27,70)=QCx*VS0(27,47)+WQx*VS1(27,47)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(16,47)
VS0(27,71)=QCx*VS0(27,48)+WQx*VS1(27,48)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(16,48)
VS0(27,72)=QCx*VS0(27,49)+WQx*VS1(27,49)&
   +r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(16,49)
VS0(27,73)=QCy*VS0(27,49)+WQy*VS1(27,49)-r1x2E*VR1(27,49)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(15,49)
VS0(27,74)=QCy*VS0(27,50)+WQy*VS1(27,50)-r1x2E*VR1(27,50)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(15,50)
VS0(27,75)=QCx*VS0(27,51)+WQx*VS1(27,51)&
   +2D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +2D0*HfxZpE*VS1(16,51)
VS0(27,76)=QCz*VS0(27,48)+WQz*VS1(27,48)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(12,48)
VS0(27,77)=QCz*VS0(27,49)+WQz*VS1(27,49)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(12,49)
VS0(27,78)=QCy*VS0(27,53)+WQy*VS1(27,53)-r1x2E*VR1(27,53)&
   +2D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(15,53)
VS0(27,79)=QCz*VS0(27,51)+WQz*VS1(27,51)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +HfxZpE*VS1(12,51)
VS0(27,80)=QCz*VS0(27,52)+WQz*VS1(27,52)&
   +3D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(12,52)
VS0(27,81)=QCz*VS0(27,53)+WQz*VS1(27,53)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(12,53)
VS0(27,82)=QCz*VS0(27,54)+WQz*VS1(27,54)&
   +4D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +HfxZpE*VS1(12,54)
VS0(27,83)=QCz*VS0(27,55)+WQz*VS1(27,55)&
   +4D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(12,55)
VS0(27,84)=QCz*VS0(27,56)+WQz*VS1(27,56)&
   +5D0*r1x2E*(VS0(27,35)-ZxZpE*VS1(27,35))&
   +HfxZpE*VS1(12,56)
VS0(28,57)=QCx*VS0(28,36)+WQx*VS1(28,36)&
   +5D0*r1x2E*(VS0(28,21)-ZxZpE*VS1(28,21))&
   +HfxZpE*VS1(17,36)
VS0(28,58)=QCx*VS0(28,37)+WQx*VS1(28,37)&
   +4D0*r1x2E*(VS0(28,22)-ZxZpE*VS1(28,22))&
   +HfxZpE*VS1(17,37)
VS0(28,59)=QCx*VS0(28,38)+WQx*VS1(28,38)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +HfxZpE*VS1(17,38)
VS0(28,60)=QCx*VS0(28,39)+WQx*VS1(28,39)&
   +2D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +HfxZpE*VS1(17,39)
VS0(28,61)=QCy*VS0(28,39)+WQy*VS1(28,39)-r1x2E*VR1(28,39)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(16,39)
VS0(28,62)=QCy*VS0(28,40)+WQy*VS1(28,40)-r1x2E*VR1(28,40)&
   +4D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +2D0*HfxZpE*VS1(16,40)
VS0(28,63)=QCy*VS0(28,41)+WQy*VS1(28,41)-r1x2E*VR1(28,41)&
   +5D0*r1x2E*(VS0(28,25)-ZxZpE*VS1(28,25))&
   +2D0*HfxZpE*VS1(16,41)
VS0(28,64)=QCx*VS0(28,42)+WQx*VS1(28,42)&
   +4D0*r1x2E*(VS0(28,26)-ZxZpE*VS1(28,26))&
   +HfxZpE*VS1(17,42)
VS0(28,65)=QCx*VS0(28,43)+WQx*VS1(28,43)&
   +3D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(17,43)
VS0(28,66)=QCx*VS0(28,44)+WQx*VS1(28,44)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(17,44)
VS0(28,67)=QCy*VS0(28,44)+WQy*VS1(28,44)-r1x2E*VR1(28,44)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(16,44)
VS0(28,68)=QCy*VS0(28,45)+WQy*VS1(28,45)-r1x2E*VR1(28,45)&
   +3D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(16,45)
VS0(28,69)=QCy*VS0(28,46)+WQy*VS1(28,46)-r1x2E*VR1(28,46)&
   +4D0*r1x2E*(VS0(28,29)-ZxZpE*VS1(28,29))&
   +2D0*HfxZpE*VS1(16,46)
VS0(28,70)=QCx*VS0(28,47)+WQx*VS1(28,47)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(17,47)
VS0(28,71)=QCx*VS0(28,48)+WQx*VS1(28,48)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(17,48)
VS0(28,72)=QCx*VS0(28,49)+WQx*VS1(28,49)&
   +r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(17,49)
VS0(28,73)=QCy*VS0(28,49)+WQy*VS1(28,49)-r1x2E*VR1(28,49)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(16,49)
VS0(28,74)=QCy*VS0(28,50)+WQy*VS1(28,50)-r1x2E*VR1(28,50)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(16,50)
VS0(28,75)=QCx*VS0(28,51)+WQx*VS1(28,51)&
   +2D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(17,51)
VS0(28,76)=QCz*VS0(28,48)+WQz*VS1(28,48)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(13,48)
VS0(28,77)=QCz*VS0(28,49)+WQz*VS1(28,49)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(13,49)
VS0(28,78)=QCy*VS0(28,53)+WQy*VS1(28,53)-r1x2E*VR1(28,53)&
   +2D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +2D0*HfxZpE*VS1(16,53)
VS0(28,79)=QCz*VS0(28,51)+WQz*VS1(28,51)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(13,51)
VS0(28,80)=QCz*VS0(28,52)+WQz*VS1(28,52)&
   +3D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(13,52)
VS0(28,81)=QCz*VS0(28,53)+WQz*VS1(28,53)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(13,53)
VS0(28,82)=QCz*VS0(28,54)+WQz*VS1(28,54)&
   +4D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(13,54)
VS0(28,83)=QCz*VS0(28,55)+WQz*VS1(28,55)&
   +4D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +HfxZpE*VS1(13,55)
VS0(28,84)=QCz*VS0(28,56)+WQz*VS1(28,56)&
   +5D0*r1x2E*(VS0(28,35)-ZxZpE*VS1(28,35))&
   +HfxZpE*VS1(13,56)
VS0(29,57)=QCx*VS0(29,36)+WQx*VS1(29,36)&
   +5D0*r1x2E*(VS0(29,21)-ZxZpE*VS1(29,21))
VS0(29,58)=QCx*VS0(29,37)+WQx*VS1(29,37)&
   +4D0*r1x2E*(VS0(29,22)-ZxZpE*VS1(29,22))
VS0(29,59)=QCx*VS0(29,38)+WQx*VS1(29,38)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))
VS0(29,60)=QCx*VS0(29,39)+WQx*VS1(29,39)&
   +2D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))
VS0(29,61)=QCy*VS0(29,39)+WQy*VS1(29,39)-r1x2E*VR1(29,39)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))&
   +3D0*HfxZpE*VS1(17,39)
VS0(29,62)=QCy*VS0(29,40)+WQy*VS1(29,40)-r1x2E*VR1(29,40)&
   +4D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(17,40)
VS0(29,63)=QCy*VS0(29,41)+WQy*VS1(29,41)-r1x2E*VR1(29,41)&
   +5D0*r1x2E*(VS0(29,25)-ZxZpE*VS1(29,25))&
   +3D0*HfxZpE*VS1(17,41)
VS0(29,64)=QCx*VS0(29,42)+WQx*VS1(29,42)&
   +4D0*r1x2E*(VS0(29,26)-ZxZpE*VS1(29,26))
VS0(29,65)=QCx*VS0(29,43)+WQx*VS1(29,43)&
   +3D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))
VS0(29,66)=QCx*VS0(29,44)+WQx*VS1(29,44)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))
VS0(29,67)=QCy*VS0(29,44)+WQy*VS1(29,44)-r1x2E*VR1(29,44)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +3D0*HfxZpE*VS1(17,44)
VS0(29,68)=QCy*VS0(29,45)+WQy*VS1(29,45)-r1x2E*VR1(29,45)&
   +3D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +3D0*HfxZpE*VS1(17,45)
VS0(29,69)=QCy*VS0(29,46)+WQy*VS1(29,46)-r1x2E*VR1(29,46)&
   +4D0*r1x2E*(VS0(29,29)-ZxZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(17,46)
VS0(29,70)=QCx*VS0(29,47)+WQx*VS1(29,47)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))
VS0(29,71)=QCx*VS0(29,48)+WQx*VS1(29,48)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))
VS0(29,72)=QCx*VS0(29,49)+WQx*VS1(29,49)&
   +r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))
VS0(29,73)=QCy*VS0(29,49)+WQy*VS1(29,49)-r1x2E*VR1(29,49)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +3D0*HfxZpE*VS1(17,49)
VS0(29,74)=QCy*VS0(29,50)+WQy*VS1(29,50)-r1x2E*VR1(29,50)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +3D0*HfxZpE*VS1(17,50)
VS0(29,75)=QCx*VS0(29,51)+WQx*VS1(29,51)&
   +2D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))
VS0(29,76)=QCz*VS0(29,48)+WQz*VS1(29,48)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +HfxZpE*VS1(14,48)
VS0(29,77)=QCz*VS0(29,49)+WQz*VS1(29,49)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +HfxZpE*VS1(14,49)
VS0(29,78)=QCy*VS0(29,53)+WQy*VS1(29,53)-r1x2E*VR1(29,53)&
   +2D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +3D0*HfxZpE*VS1(17,53)
VS0(29,79)=QCz*VS0(29,51)+WQz*VS1(29,51)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))&
   +HfxZpE*VS1(14,51)
VS0(29,80)=QCz*VS0(29,52)+WQz*VS1(29,52)&
   +3D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +HfxZpE*VS1(14,52)
VS0(29,81)=QCz*VS0(29,53)+WQz*VS1(29,53)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +HfxZpE*VS1(14,53)
VS0(29,82)=QCz*VS0(29,54)+WQz*VS1(29,54)&
   +4D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))&
   +HfxZpE*VS1(14,54)
VS0(29,83)=QCz*VS0(29,55)+WQz*VS1(29,55)&
   +4D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +HfxZpE*VS1(14,55)
VS0(29,84)=QCz*VS0(29,56)+WQz*VS1(29,56)&
   +5D0*r1x2E*(VS0(29,35)-ZxZpE*VS1(29,35))&
   +HfxZpE*VS1(14,56)
VS0(30,57)=QCx*VS0(30,36)+WQx*VS1(30,36)&
   +5D0*r1x2E*(VS0(30,21)-ZxZpE*VS1(30,21))&
   +2D0*HfxZpE*VS1(18,36)
VS0(30,58)=QCx*VS0(30,37)+WQx*VS1(30,37)&
   +4D0*r1x2E*(VS0(30,22)-ZxZpE*VS1(30,22))&
   +2D0*HfxZpE*VS1(18,37)
VS0(30,59)=QCx*VS0(30,38)+WQx*VS1(30,38)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(18,38)
VS0(30,60)=QCx*VS0(30,39)+WQx*VS1(30,39)&
   +2D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))&
   +2D0*HfxZpE*VS1(18,39)
VS0(30,61)=QCy*VS0(30,39)+WQy*VS1(30,39)-r1x2E*VR1(30,39)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))
VS0(30,62)=QCy*VS0(30,40)+WQy*VS1(30,40)-r1x2E*VR1(30,40)&
   +4D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))
VS0(30,63)=QCy*VS0(30,41)+WQy*VS1(30,41)-r1x2E*VR1(30,41)&
   +5D0*r1x2E*(VS0(30,25)-ZxZpE*VS1(30,25))
VS0(30,64)=QCx*VS0(30,42)+WQx*VS1(30,42)&
   +4D0*r1x2E*(VS0(30,26)-ZxZpE*VS1(30,26))&
   +2D0*HfxZpE*VS1(18,42)
VS0(30,65)=QCx*VS0(30,43)+WQx*VS1(30,43)&
   +3D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(18,43)
VS0(30,66)=QCx*VS0(30,44)+WQx*VS1(30,44)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(18,44)
VS0(30,67)=QCy*VS0(30,44)+WQy*VS1(30,44)-r1x2E*VR1(30,44)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))
VS0(30,68)=QCy*VS0(30,45)+WQy*VS1(30,45)-r1x2E*VR1(30,45)&
   +3D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))
VS0(30,69)=QCy*VS0(30,46)+WQy*VS1(30,46)-r1x2E*VR1(30,46)&
   +4D0*r1x2E*(VS0(30,29)-ZxZpE*VS1(30,29))
VS0(30,70)=QCx*VS0(30,47)+WQx*VS1(30,47)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(18,47)
VS0(30,71)=QCx*VS0(30,48)+WQx*VS1(30,48)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(18,48)
VS0(30,72)=QCx*VS0(30,49)+WQx*VS1(30,49)&
   +r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(18,49)
VS0(30,73)=QCy*VS0(30,49)+WQy*VS1(30,49)-r1x2E*VR1(30,49)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))
VS0(30,74)=QCy*VS0(30,50)+WQy*VS1(30,50)-r1x2E*VR1(30,50)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))
VS0(30,75)=QCx*VS0(30,51)+WQx*VS1(30,51)&
   +2D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(18,51)
VS0(30,76)=QCz*VS0(30,48)+WQz*VS1(30,48)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(15,48)
VS0(30,77)=QCz*VS0(30,49)+WQz*VS1(30,49)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(15,49)
VS0(30,78)=QCy*VS0(30,53)+WQy*VS1(30,53)-r1x2E*VR1(30,53)&
   +2D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))
VS0(30,79)=QCz*VS0(30,51)+WQz*VS1(30,51)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(15,51)
VS0(30,80)=QCz*VS0(30,52)+WQz*VS1(30,52)&
   +3D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(15,52)
VS0(30,81)=QCz*VS0(30,53)+WQz*VS1(30,53)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(15,53)
VS0(30,82)=QCz*VS0(30,54)+WQz*VS1(30,54)&
   +4D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(15,54)
VS0(30,83)=QCz*VS0(30,55)+WQz*VS1(30,55)&
   +4D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))&
   +2D0*HfxZpE*VS1(15,55)
VS0(30,84)=QCz*VS0(30,56)+WQz*VS1(30,56)&
   +5D0*r1x2E*(VS0(30,35)-ZxZpE*VS1(30,35))&
   +2D0*HfxZpE*VS1(15,56)
VS0(31,57)=QCx*VS0(31,36)+WQx*VS1(31,36)&
   +5D0*r1x2E*(VS0(31,21)-ZxZpE*VS1(31,21))&
   +HfxZpE*VS1(19,36)
VS0(31,58)=QCx*VS0(31,37)+WQx*VS1(31,37)&
   +4D0*r1x2E*(VS0(31,22)-ZxZpE*VS1(31,22))&
   +HfxZpE*VS1(19,37)
VS0(31,59)=QCx*VS0(31,38)+WQx*VS1(31,38)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(19,38)
VS0(31,60)=QCx*VS0(31,39)+WQx*VS1(31,39)&
   +2D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(19,39)
VS0(31,61)=QCy*VS0(31,39)+WQy*VS1(31,39)-r1x2E*VR1(31,39)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(18,39)
VS0(31,62)=QCy*VS0(31,40)+WQy*VS1(31,40)-r1x2E*VR1(31,40)&
   +4D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(18,40)
VS0(31,63)=QCy*VS0(31,41)+WQy*VS1(31,41)-r1x2E*VR1(31,41)&
   +5D0*r1x2E*(VS0(31,25)-ZxZpE*VS1(31,25))&
   +HfxZpE*VS1(18,41)
VS0(31,64)=QCx*VS0(31,42)+WQx*VS1(31,42)&
   +4D0*r1x2E*(VS0(31,26)-ZxZpE*VS1(31,26))&
   +HfxZpE*VS1(19,42)
VS0(31,65)=QCx*VS0(31,43)+WQx*VS1(31,43)&
   +3D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(19,43)
VS0(31,66)=QCx*VS0(31,44)+WQx*VS1(31,44)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(19,44)
VS0(31,67)=QCy*VS0(31,44)+WQy*VS1(31,44)-r1x2E*VR1(31,44)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(18,44)
VS0(31,68)=QCy*VS0(31,45)+WQy*VS1(31,45)-r1x2E*VR1(31,45)&
   +3D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(18,45)
VS0(31,69)=QCy*VS0(31,46)+WQy*VS1(31,46)-r1x2E*VR1(31,46)&
   +4D0*r1x2E*(VS0(31,29)-ZxZpE*VS1(31,29))&
   +HfxZpE*VS1(18,46)
VS0(31,70)=QCx*VS0(31,47)+WQx*VS1(31,47)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +HfxZpE*VS1(19,47)
VS0(31,71)=QCx*VS0(31,48)+WQx*VS1(31,48)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(19,48)
VS0(31,72)=QCx*VS0(31,49)+WQx*VS1(31,49)&
   +r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(19,49)
VS0(31,73)=QCy*VS0(31,49)+WQy*VS1(31,49)-r1x2E*VR1(31,49)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(18,49)
VS0(31,74)=QCy*VS0(31,50)+WQy*VS1(31,50)-r1x2E*VR1(31,50)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(18,50)
VS0(31,75)=QCx*VS0(31,51)+WQx*VS1(31,51)&
   +2D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +HfxZpE*VS1(19,51)
VS0(31,76)=QCz*VS0(31,48)+WQz*VS1(31,48)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(16,48)
VS0(31,77)=QCz*VS0(31,49)+WQz*VS1(31,49)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(16,49)
VS0(31,78)=QCy*VS0(31,53)+WQy*VS1(31,53)-r1x2E*VR1(31,53)&
   +2D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +HfxZpE*VS1(18,53)
VS0(31,79)=QCz*VS0(31,51)+WQz*VS1(31,51)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(16,51)
VS0(31,80)=QCz*VS0(31,52)+WQz*VS1(31,52)&
   +3D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(16,52)
VS0(31,81)=QCz*VS0(31,53)+WQz*VS1(31,53)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(16,53)
VS0(31,82)=QCz*VS0(31,54)+WQz*VS1(31,54)&
   +4D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +2D0*HfxZpE*VS1(16,54)
VS0(31,83)=QCz*VS0(31,55)+WQz*VS1(31,55)&
   +4D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +2D0*HfxZpE*VS1(16,55)
VS0(31,84)=QCz*VS0(31,56)+WQz*VS1(31,56)&
   +5D0*r1x2E*(VS0(31,35)-ZxZpE*VS1(31,35))&
   +2D0*HfxZpE*VS1(16,56)
VS0(32,57)=QCx*VS0(32,36)+WQx*VS1(32,36)&
   +5D0*r1x2E*(VS0(32,21)-ZxZpE*VS1(32,21))
VS0(32,58)=QCx*VS0(32,37)+WQx*VS1(32,37)&
   +4D0*r1x2E*(VS0(32,22)-ZxZpE*VS1(32,22))
VS0(32,59)=QCx*VS0(32,38)+WQx*VS1(32,38)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))
VS0(32,60)=QCx*VS0(32,39)+WQx*VS1(32,39)&
   +2D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))
VS0(32,61)=QCy*VS0(32,39)+WQy*VS1(32,39)-r1x2E*VR1(32,39)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(19,39)
VS0(32,62)=QCy*VS0(32,40)+WQy*VS1(32,40)-r1x2E*VR1(32,40)&
   +4D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))&
   +2D0*HfxZpE*VS1(19,40)
VS0(32,63)=QCy*VS0(32,41)+WQy*VS1(32,41)-r1x2E*VR1(32,41)&
   +5D0*r1x2E*(VS0(32,25)-ZxZpE*VS1(32,25))&
   +2D0*HfxZpE*VS1(19,41)
VS0(32,64)=QCx*VS0(32,42)+WQx*VS1(32,42)&
   +4D0*r1x2E*(VS0(32,26)-ZxZpE*VS1(32,26))
VS0(32,65)=QCx*VS0(32,43)+WQx*VS1(32,43)&
   +3D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))
VS0(32,66)=QCx*VS0(32,44)+WQx*VS1(32,44)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))
VS0(32,67)=QCy*VS0(32,44)+WQy*VS1(32,44)-r1x2E*VR1(32,44)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(19,44)
VS0(32,68)=QCy*VS0(32,45)+WQy*VS1(32,45)-r1x2E*VR1(32,45)&
   +3D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(19,45)
VS0(32,69)=QCy*VS0(32,46)+WQy*VS1(32,46)-r1x2E*VR1(32,46)&
   +4D0*r1x2E*(VS0(32,29)-ZxZpE*VS1(32,29))&
   +2D0*HfxZpE*VS1(19,46)
VS0(32,70)=QCx*VS0(32,47)+WQx*VS1(32,47)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))
VS0(32,71)=QCx*VS0(32,48)+WQx*VS1(32,48)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))
VS0(32,72)=QCx*VS0(32,49)+WQx*VS1(32,49)&
   +r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))
VS0(32,73)=QCy*VS0(32,49)+WQy*VS1(32,49)-r1x2E*VR1(32,49)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(19,49)
VS0(32,74)=QCy*VS0(32,50)+WQy*VS1(32,50)-r1x2E*VR1(32,50)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(19,50)
VS0(32,75)=QCx*VS0(32,51)+WQx*VS1(32,51)&
   +2D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))
VS0(32,76)=QCz*VS0(32,48)+WQz*VS1(32,48)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(17,48)
VS0(32,77)=QCz*VS0(32,49)+WQz*VS1(32,49)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(17,49)
VS0(32,78)=QCy*VS0(32,53)+WQy*VS1(32,53)-r1x2E*VR1(32,53)&
   +2D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(19,53)
VS0(32,79)=QCz*VS0(32,51)+WQz*VS1(32,51)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(17,51)
VS0(32,80)=QCz*VS0(32,52)+WQz*VS1(32,52)&
   +3D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(17,52)
VS0(32,81)=QCz*VS0(32,53)+WQz*VS1(32,53)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(17,53)
VS0(32,82)=QCz*VS0(32,54)+WQz*VS1(32,54)&
   +4D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))&
   +2D0*HfxZpE*VS1(17,54)
VS0(32,83)=QCz*VS0(32,55)+WQz*VS1(32,55)&
   +4D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(17,55)
VS0(32,84)=QCz*VS0(32,56)+WQz*VS1(32,56)&
   +5D0*r1x2E*(VS0(32,35)-ZxZpE*VS1(32,35))&
   +2D0*HfxZpE*VS1(17,56)
VS0(33,57)=QCx*VS0(33,36)+WQx*VS1(33,36)&
   +5D0*r1x2E*(VS0(33,21)-ZxZpE*VS1(33,21))&
   +HfxZpE*VS1(20,36)
VS0(33,58)=QCx*VS0(33,37)+WQx*VS1(33,37)&
   +4D0*r1x2E*(VS0(33,22)-ZxZpE*VS1(33,22))&
   +HfxZpE*VS1(20,37)
VS0(33,59)=QCx*VS0(33,38)+WQx*VS1(33,38)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))&
   +HfxZpE*VS1(20,38)
VS0(33,60)=QCx*VS0(33,39)+WQx*VS1(33,39)&
   +2D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))&
   +HfxZpE*VS1(20,39)
VS0(33,61)=QCy*VS0(33,39)+WQy*VS1(33,39)-r1x2E*VR1(33,39)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))
VS0(33,62)=QCy*VS0(33,40)+WQy*VS1(33,40)-r1x2E*VR1(33,40)&
   +4D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))
VS0(33,63)=QCy*VS0(33,41)+WQy*VS1(33,41)-r1x2E*VR1(33,41)&
   +5D0*r1x2E*(VS0(33,25)-ZxZpE*VS1(33,25))
VS0(33,64)=QCx*VS0(33,42)+WQx*VS1(33,42)&
   +4D0*r1x2E*(VS0(33,26)-ZxZpE*VS1(33,26))&
   +HfxZpE*VS1(20,42)
VS0(33,65)=QCx*VS0(33,43)+WQx*VS1(33,43)&
   +3D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +HfxZpE*VS1(20,43)
VS0(33,66)=QCx*VS0(33,44)+WQx*VS1(33,44)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +HfxZpE*VS1(20,44)
VS0(33,67)=QCy*VS0(33,44)+WQy*VS1(33,44)-r1x2E*VR1(33,44)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))
VS0(33,68)=QCy*VS0(33,45)+WQy*VS1(33,45)-r1x2E*VR1(33,45)&
   +3D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))
VS0(33,69)=QCy*VS0(33,46)+WQy*VS1(33,46)-r1x2E*VR1(33,46)&
   +4D0*r1x2E*(VS0(33,29)-ZxZpE*VS1(33,29))
VS0(33,70)=QCx*VS0(33,47)+WQx*VS1(33,47)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +HfxZpE*VS1(20,47)
VS0(33,71)=QCx*VS0(33,48)+WQx*VS1(33,48)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +HfxZpE*VS1(20,48)
VS0(33,72)=QCx*VS0(33,49)+WQx*VS1(33,49)&
   +r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +HfxZpE*VS1(20,49)
VS0(33,73)=QCy*VS0(33,49)+WQy*VS1(33,49)-r1x2E*VR1(33,49)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))
VS0(33,74)=QCy*VS0(33,50)+WQy*VS1(33,50)-r1x2E*VR1(33,50)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))
VS0(33,75)=QCx*VS0(33,51)+WQx*VS1(33,51)&
   +2D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +HfxZpE*VS1(20,51)
VS0(33,76)=QCz*VS0(33,48)+WQz*VS1(33,48)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +3D0*HfxZpE*VS1(18,48)
VS0(33,77)=QCz*VS0(33,49)+WQz*VS1(33,49)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +3D0*HfxZpE*VS1(18,49)
VS0(33,78)=QCy*VS0(33,53)+WQy*VS1(33,53)-r1x2E*VR1(33,53)&
   +2D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))
VS0(33,79)=QCz*VS0(33,51)+WQz*VS1(33,51)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +3D0*HfxZpE*VS1(18,51)
VS0(33,80)=QCz*VS0(33,52)+WQz*VS1(33,52)&
   +3D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +3D0*HfxZpE*VS1(18,52)
VS0(33,81)=QCz*VS0(33,53)+WQz*VS1(33,53)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +3D0*HfxZpE*VS1(18,53)
VS0(33,82)=QCz*VS0(33,54)+WQz*VS1(33,54)&
   +4D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(18,54)
VS0(33,83)=QCz*VS0(33,55)+WQz*VS1(33,55)&
   +4D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(18,55)
VS0(33,84)=QCz*VS0(33,56)+WQz*VS1(33,56)&
   +5D0*r1x2E*(VS0(33,35)-ZxZpE*VS1(33,35))&
   +3D0*HfxZpE*VS1(18,56)
VS0(34,57)=QCx*VS0(34,36)+WQx*VS1(34,36)&
   +5D0*r1x2E*(VS0(34,21)-ZxZpE*VS1(34,21))
VS0(34,58)=QCx*VS0(34,37)+WQx*VS1(34,37)&
   +4D0*r1x2E*(VS0(34,22)-ZxZpE*VS1(34,22))
VS0(34,59)=QCx*VS0(34,38)+WQx*VS1(34,38)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))
VS0(34,60)=QCx*VS0(34,39)+WQx*VS1(34,39)&
   +2D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))
VS0(34,61)=QCy*VS0(34,39)+WQy*VS1(34,39)-r1x2E*VR1(34,39)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))&
   +HfxZpE*VS1(20,39)
VS0(34,62)=QCy*VS0(34,40)+WQy*VS1(34,40)-r1x2E*VR1(34,40)&
   +4D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))&
   +HfxZpE*VS1(20,40)
VS0(34,63)=QCy*VS0(34,41)+WQy*VS1(34,41)-r1x2E*VR1(34,41)&
   +5D0*r1x2E*(VS0(34,25)-ZxZpE*VS1(34,25))&
   +HfxZpE*VS1(20,41)
VS0(34,64)=QCx*VS0(34,42)+WQx*VS1(34,42)&
   +4D0*r1x2E*(VS0(34,26)-ZxZpE*VS1(34,26))
VS0(34,65)=QCx*VS0(34,43)+WQx*VS1(34,43)&
   +3D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))
VS0(34,66)=QCx*VS0(34,44)+WQx*VS1(34,44)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))
VS0(34,67)=QCy*VS0(34,44)+WQy*VS1(34,44)-r1x2E*VR1(34,44)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +HfxZpE*VS1(20,44)
VS0(34,68)=QCy*VS0(34,45)+WQy*VS1(34,45)-r1x2E*VR1(34,45)&
   +3D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +HfxZpE*VS1(20,45)
VS0(34,69)=QCy*VS0(34,46)+WQy*VS1(34,46)-r1x2E*VR1(34,46)&
   +4D0*r1x2E*(VS0(34,29)-ZxZpE*VS1(34,29))&
   +HfxZpE*VS1(20,46)
VS0(34,70)=QCx*VS0(34,47)+WQx*VS1(34,47)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))
VS0(34,71)=QCx*VS0(34,48)+WQx*VS1(34,48)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))
VS0(34,72)=QCx*VS0(34,49)+WQx*VS1(34,49)&
   +r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))
VS0(34,73)=QCy*VS0(34,49)+WQy*VS1(34,49)-r1x2E*VR1(34,49)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +HfxZpE*VS1(20,49)
VS0(34,74)=QCy*VS0(34,50)+WQy*VS1(34,50)-r1x2E*VR1(34,50)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +HfxZpE*VS1(20,50)
VS0(34,75)=QCx*VS0(34,51)+WQx*VS1(34,51)&
   +2D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))
VS0(34,76)=QCz*VS0(34,48)+WQz*VS1(34,48)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +3D0*HfxZpE*VS1(19,48)
VS0(34,77)=QCz*VS0(34,49)+WQz*VS1(34,49)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +3D0*HfxZpE*VS1(19,49)
VS0(34,78)=QCy*VS0(34,53)+WQy*VS1(34,53)-r1x2E*VR1(34,53)&
   +2D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +HfxZpE*VS1(20,53)
VS0(34,79)=QCz*VS0(34,51)+WQz*VS1(34,51)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))&
   +3D0*HfxZpE*VS1(19,51)
VS0(34,80)=QCz*VS0(34,52)+WQz*VS1(34,52)&
   +3D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +3D0*HfxZpE*VS1(19,52)
VS0(34,81)=QCz*VS0(34,53)+WQz*VS1(34,53)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +3D0*HfxZpE*VS1(19,53)
VS0(34,82)=QCz*VS0(34,54)+WQz*VS1(34,54)&
   +4D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(19,54)
VS0(34,83)=QCz*VS0(34,55)+WQz*VS1(34,55)&
   +4D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(19,55)
VS0(34,84)=QCz*VS0(34,56)+WQz*VS1(34,56)&
   +5D0*r1x2E*(VS0(34,35)-ZxZpE*VS1(34,35))&
   +3D0*HfxZpE*VS1(19,56)
VS0(35,57)=QCx*VS0(35,36)+WQx*VS1(35,36)&
   +5D0*r1x2E*(VS0(35,21)-ZxZpE*VS1(35,21))
VS0(35,58)=QCx*VS0(35,37)+WQx*VS1(35,37)&
   +4D0*r1x2E*(VS0(35,22)-ZxZpE*VS1(35,22))
VS0(35,59)=QCx*VS0(35,38)+WQx*VS1(35,38)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,60)=QCx*VS0(35,39)+WQx*VS1(35,39)&
   +2D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,61)=QCy*VS0(35,39)+WQy*VS1(35,39)-r1x2E*VR1(35,39)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,62)=QCy*VS0(35,40)+WQy*VS1(35,40)-r1x2E*VR1(35,40)&
   +4D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,63)=QCy*VS0(35,41)+WQy*VS1(35,41)-r1x2E*VR1(35,41)&
   +5D0*r1x2E*(VS0(35,25)-ZxZpE*VS1(35,25))
VS0(35,64)=QCx*VS0(35,42)+WQx*VS1(35,42)&
   +4D0*r1x2E*(VS0(35,26)-ZxZpE*VS1(35,26))
VS0(35,65)=QCx*VS0(35,43)+WQx*VS1(35,43)&
   +3D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,66)=QCx*VS0(35,44)+WQx*VS1(35,44)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,67)=QCy*VS0(35,44)+WQy*VS1(35,44)-r1x2E*VR1(35,44)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,68)=QCy*VS0(35,45)+WQy*VS1(35,45)-r1x2E*VR1(35,45)&
   +3D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,69)=QCy*VS0(35,46)+WQy*VS1(35,46)-r1x2E*VR1(35,46)&
   +4D0*r1x2E*(VS0(35,29)-ZxZpE*VS1(35,29))
VS0(35,70)=QCx*VS0(35,47)+WQx*VS1(35,47)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))
VS0(35,71)=QCx*VS0(35,48)+WQx*VS1(35,48)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,72)=QCx*VS0(35,49)+WQx*VS1(35,49)&
   +r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,73)=QCy*VS0(35,49)+WQy*VS1(35,49)-r1x2E*VR1(35,49)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,74)=QCy*VS0(35,50)+WQy*VS1(35,50)-r1x2E*VR1(35,50)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,75)=QCx*VS0(35,51)+WQx*VS1(35,51)&
   +2D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))
VS0(35,76)=QCz*VS0(35,48)+WQz*VS1(35,48)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))&
   +4D0*HfxZpE*VS1(20,48)
VS0(35,77)=QCz*VS0(35,49)+WQz*VS1(35,49)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))&
   +4D0*HfxZpE*VS1(20,49)
VS0(35,78)=QCy*VS0(35,53)+WQy*VS1(35,53)-r1x2E*VR1(35,53)&
   +2D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))
VS0(35,79)=QCz*VS0(35,51)+WQz*VS1(35,51)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))&
   +4D0*HfxZpE*VS1(20,51)
VS0(35,80)=QCz*VS0(35,52)+WQz*VS1(35,52)&
   +3D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))&
   +4D0*HfxZpE*VS1(20,52)
VS0(35,81)=QCz*VS0(35,53)+WQz*VS1(35,53)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))&
   +4D0*HfxZpE*VS1(20,53)
VS0(35,82)=QCz*VS0(35,54)+WQz*VS1(35,54)&
   +4D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))&
   +4D0*HfxZpE*VS1(20,54)
VS0(35,83)=QCz*VS0(35,55)+WQz*VS1(35,55)&
   +4D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))&
   +4D0*HfxZpE*VS1(20,55)
VS0(35,84)=QCz*VS0(35,56)+WQz*VS1(35,56)&
   +5D0*r1x2E*(VS0(35,35)-ZxZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(20,56)
CASE(3)
VS0(21,57)=QCx*VS0(21,36)+WQx*VS1(21,36)&
   +5D0*r1x2E*(VS0(21,21)-ZxZpE*VS1(21,21))&
   +4D0*HfxZpE*VS1(11,36)
VS0(21,58)=QCx*VS0(21,37)+WQx*VS1(21,37)&
   +4D0*r1x2E*(VS0(21,22)-ZxZpE*VS1(21,22))&
   +4D0*HfxZpE*VS1(11,37)
VS0(21,59)=QCx*VS0(21,38)+WQx*VS1(21,38)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))&
   +4D0*HfxZpE*VS1(11,38)
VS0(21,60)=QCx*VS0(21,39)+WQx*VS1(21,39)&
   +2D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))&
   +4D0*HfxZpE*VS1(11,39)
VS0(21,61)=QCy*VS0(21,39)+WQy*VS1(21,39)&
   +3D0*r1x2E*(VS0(21,23)-ZxZpE*VS1(21,23))
VS0(21,62)=QCy*VS0(21,40)+WQy*VS1(21,40)&
   +4D0*r1x2E*(VS0(21,24)-ZxZpE*VS1(21,24))
VS0(21,63)=QCy*VS0(21,41)+WQy*VS1(21,41)&
   +5D0*r1x2E*(VS0(21,25)-ZxZpE*VS1(21,25))
VS0(21,64)=QCx*VS0(21,42)+WQx*VS1(21,42)&
   +4D0*r1x2E*(VS0(21,26)-ZxZpE*VS1(21,26))&
   +4D0*HfxZpE*VS1(11,42)
VS0(21,65)=QCx*VS0(21,43)+WQx*VS1(21,43)&
   +3D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))&
   +4D0*HfxZpE*VS1(11,43)
VS0(21,66)=QCx*VS0(21,44)+WQx*VS1(21,44)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))&
   +4D0*HfxZpE*VS1(11,44)
VS0(21,67)=QCy*VS0(21,44)+WQy*VS1(21,44)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,68)=QCy*VS0(21,45)+WQy*VS1(21,45)&
   +3D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,69)=QCy*VS0(21,46)+WQy*VS1(21,46)&
   +4D0*r1x2E*(VS0(21,29)-ZxZpE*VS1(21,29))
VS0(21,70)=QCx*VS0(21,47)+WQx*VS1(21,47)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))&
   +4D0*HfxZpE*VS1(11,47)
VS0(21,71)=QCx*VS0(21,48)+WQx*VS1(21,48)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))&
   +4D0*HfxZpE*VS1(11,48)
VS0(21,72)=QCx*VS0(21,49)+WQx*VS1(21,49)&
   +r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))&
   +4D0*HfxZpE*VS1(11,49)
VS0(21,73)=QCy*VS0(21,49)+WQy*VS1(21,49)&
   +2D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,74)=QCy*VS0(21,50)+WQy*VS1(21,50)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,75)=QCx*VS0(21,51)+WQx*VS1(21,51)&
   +2D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))&
   +4D0*HfxZpE*VS1(11,51)
VS0(21,76)=QCz*VS0(21,48)+WQz*VS1(21,48)-r1x2E*VR1(21,48)&
   +2D0*r1x2E*(VS0(21,27)-ZxZpE*VS1(21,27))
VS0(21,77)=QCz*VS0(21,49)+WQz*VS1(21,49)-r1x2E*VR1(21,49)&
   +2D0*r1x2E*(VS0(21,28)-ZxZpE*VS1(21,28))
VS0(21,78)=QCy*VS0(21,53)+WQy*VS1(21,53)&
   +2D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,79)=QCz*VS0(21,51)+WQz*VS1(21,51)-r1x2E*VR1(21,51)&
   +3D0*r1x2E*(VS0(21,30)-ZxZpE*VS1(21,30))
VS0(21,80)=QCz*VS0(21,52)+WQz*VS1(21,52)-r1x2E*VR1(21,52)&
   +3D0*r1x2E*(VS0(21,31)-ZxZpE*VS1(21,31))
VS0(21,81)=QCz*VS0(21,53)+WQz*VS1(21,53)-r1x2E*VR1(21,53)&
   +3D0*r1x2E*(VS0(21,32)-ZxZpE*VS1(21,32))
VS0(21,82)=QCz*VS0(21,54)+WQz*VS1(21,54)-r1x2E*VR1(21,54)&
   +4D0*r1x2E*(VS0(21,33)-ZxZpE*VS1(21,33))
VS0(21,83)=QCz*VS0(21,55)+WQz*VS1(21,55)-r1x2E*VR1(21,55)&
   +4D0*r1x2E*(VS0(21,34)-ZxZpE*VS1(21,34))
VS0(21,84)=QCz*VS0(21,56)+WQz*VS1(21,56)-r1x2E*VR1(21,56)&
   +5D0*r1x2E*(VS0(21,35)-ZxZpE*VS1(21,35))
VS0(22,57)=QCx*VS0(22,36)+WQx*VS1(22,36)&
   +5D0*r1x2E*(VS0(22,21)-ZxZpE*VS1(22,21))&
   +3D0*HfxZpE*VS1(12,36)
VS0(22,58)=QCx*VS0(22,37)+WQx*VS1(22,37)&
   +4D0*r1x2E*(VS0(22,22)-ZxZpE*VS1(22,22))&
   +3D0*HfxZpE*VS1(12,37)
VS0(22,59)=QCx*VS0(22,38)+WQx*VS1(22,38)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +3D0*HfxZpE*VS1(12,38)
VS0(22,60)=QCx*VS0(22,39)+WQx*VS1(22,39)&
   +2D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +3D0*HfxZpE*VS1(12,39)
VS0(22,61)=QCy*VS0(22,39)+WQy*VS1(22,39)&
   +3D0*r1x2E*(VS0(22,23)-ZxZpE*VS1(22,23))&
   +HfxZpE*VS1(11,39)
VS0(22,62)=QCy*VS0(22,40)+WQy*VS1(22,40)&
   +4D0*r1x2E*(VS0(22,24)-ZxZpE*VS1(22,24))&
   +HfxZpE*VS1(11,40)
VS0(22,63)=QCy*VS0(22,41)+WQy*VS1(22,41)&
   +5D0*r1x2E*(VS0(22,25)-ZxZpE*VS1(22,25))&
   +HfxZpE*VS1(11,41)
VS0(22,64)=QCx*VS0(22,42)+WQx*VS1(22,42)&
   +4D0*r1x2E*(VS0(22,26)-ZxZpE*VS1(22,26))&
   +3D0*HfxZpE*VS1(12,42)
VS0(22,65)=QCx*VS0(22,43)+WQx*VS1(22,43)&
   +3D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +3D0*HfxZpE*VS1(12,43)
VS0(22,66)=QCx*VS0(22,44)+WQx*VS1(22,44)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +3D0*HfxZpE*VS1(12,44)
VS0(22,67)=QCy*VS0(22,44)+WQy*VS1(22,44)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))&
   +HfxZpE*VS1(11,44)
VS0(22,68)=QCy*VS0(22,45)+WQy*VS1(22,45)&
   +3D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))&
   +HfxZpE*VS1(11,45)
VS0(22,69)=QCy*VS0(22,46)+WQy*VS1(22,46)&
   +4D0*r1x2E*(VS0(22,29)-ZxZpE*VS1(22,29))&
   +HfxZpE*VS1(11,46)
VS0(22,70)=QCx*VS0(22,47)+WQx*VS1(22,47)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))&
   +3D0*HfxZpE*VS1(12,47)
VS0(22,71)=QCx*VS0(22,48)+WQx*VS1(22,48)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +3D0*HfxZpE*VS1(12,48)
VS0(22,72)=QCx*VS0(22,49)+WQx*VS1(22,49)&
   +r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +3D0*HfxZpE*VS1(12,49)
VS0(22,73)=QCy*VS0(22,49)+WQy*VS1(22,49)&
   +2D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))&
   +HfxZpE*VS1(11,49)
VS0(22,74)=QCy*VS0(22,50)+WQy*VS1(22,50)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))&
   +HfxZpE*VS1(11,50)
VS0(22,75)=QCx*VS0(22,51)+WQx*VS1(22,51)&
   +2D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))&
   +3D0*HfxZpE*VS1(12,51)
VS0(22,76)=QCz*VS0(22,48)+WQz*VS1(22,48)-r1x2E*VR1(22,48)&
   +2D0*r1x2E*(VS0(22,27)-ZxZpE*VS1(22,27))
VS0(22,77)=QCz*VS0(22,49)+WQz*VS1(22,49)-r1x2E*VR1(22,49)&
   +2D0*r1x2E*(VS0(22,28)-ZxZpE*VS1(22,28))
VS0(22,78)=QCy*VS0(22,53)+WQy*VS1(22,53)&
   +2D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))&
   +HfxZpE*VS1(11,53)
VS0(22,79)=QCz*VS0(22,51)+WQz*VS1(22,51)-r1x2E*VR1(22,51)&
   +3D0*r1x2E*(VS0(22,30)-ZxZpE*VS1(22,30))
VS0(22,80)=QCz*VS0(22,52)+WQz*VS1(22,52)-r1x2E*VR1(22,52)&
   +3D0*r1x2E*(VS0(22,31)-ZxZpE*VS1(22,31))
VS0(22,81)=QCz*VS0(22,53)+WQz*VS1(22,53)-r1x2E*VR1(22,53)&
   +3D0*r1x2E*(VS0(22,32)-ZxZpE*VS1(22,32))
VS0(22,82)=QCz*VS0(22,54)+WQz*VS1(22,54)-r1x2E*VR1(22,54)&
   +4D0*r1x2E*(VS0(22,33)-ZxZpE*VS1(22,33))
VS0(22,83)=QCz*VS0(22,55)+WQz*VS1(22,55)-r1x2E*VR1(22,55)&
   +4D0*r1x2E*(VS0(22,34)-ZxZpE*VS1(22,34))
VS0(22,84)=QCz*VS0(22,56)+WQz*VS1(22,56)-r1x2E*VR1(22,56)&
   +5D0*r1x2E*(VS0(22,35)-ZxZpE*VS1(22,35))
VS0(23,57)=QCx*VS0(23,36)+WQx*VS1(23,36)&
   +5D0*r1x2E*(VS0(23,21)-ZxZpE*VS1(23,21))&
   +2D0*HfxZpE*VS1(13,36)
VS0(23,58)=QCx*VS0(23,37)+WQx*VS1(23,37)&
   +4D0*r1x2E*(VS0(23,22)-ZxZpE*VS1(23,22))&
   +2D0*HfxZpE*VS1(13,37)
VS0(23,59)=QCx*VS0(23,38)+WQx*VS1(23,38)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(13,38)
VS0(23,60)=QCx*VS0(23,39)+WQx*VS1(23,39)&
   +2D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(13,39)
VS0(23,61)=QCy*VS0(23,39)+WQy*VS1(23,39)&
   +3D0*r1x2E*(VS0(23,23)-ZxZpE*VS1(23,23))&
   +2D0*HfxZpE*VS1(12,39)
VS0(23,62)=QCy*VS0(23,40)+WQy*VS1(23,40)&
   +4D0*r1x2E*(VS0(23,24)-ZxZpE*VS1(23,24))&
   +2D0*HfxZpE*VS1(12,40)
VS0(23,63)=QCy*VS0(23,41)+WQy*VS1(23,41)&
   +5D0*r1x2E*(VS0(23,25)-ZxZpE*VS1(23,25))&
   +2D0*HfxZpE*VS1(12,41)
VS0(23,64)=QCx*VS0(23,42)+WQx*VS1(23,42)&
   +4D0*r1x2E*(VS0(23,26)-ZxZpE*VS1(23,26))&
   +2D0*HfxZpE*VS1(13,42)
VS0(23,65)=QCx*VS0(23,43)+WQx*VS1(23,43)&
   +3D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(13,43)
VS0(23,66)=QCx*VS0(23,44)+WQx*VS1(23,44)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(13,44)
VS0(23,67)=QCy*VS0(23,44)+WQy*VS1(23,44)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))&
   +2D0*HfxZpE*VS1(12,44)
VS0(23,68)=QCy*VS0(23,45)+WQy*VS1(23,45)&
   +3D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))&
   +2D0*HfxZpE*VS1(12,45)
VS0(23,69)=QCy*VS0(23,46)+WQy*VS1(23,46)&
   +4D0*r1x2E*(VS0(23,29)-ZxZpE*VS1(23,29))&
   +2D0*HfxZpE*VS1(12,46)
VS0(23,70)=QCx*VS0(23,47)+WQx*VS1(23,47)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))&
   +2D0*HfxZpE*VS1(13,47)
VS0(23,71)=QCx*VS0(23,48)+WQx*VS1(23,48)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(13,48)
VS0(23,72)=QCx*VS0(23,49)+WQx*VS1(23,49)&
   +r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(13,49)
VS0(23,73)=QCy*VS0(23,49)+WQy*VS1(23,49)&
   +2D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))&
   +2D0*HfxZpE*VS1(12,49)
VS0(23,74)=QCy*VS0(23,50)+WQy*VS1(23,50)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))&
   +2D0*HfxZpE*VS1(12,50)
VS0(23,75)=QCx*VS0(23,51)+WQx*VS1(23,51)&
   +2D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))&
   +2D0*HfxZpE*VS1(13,51)
VS0(23,76)=QCz*VS0(23,48)+WQz*VS1(23,48)-r1x2E*VR1(23,48)&
   +2D0*r1x2E*(VS0(23,27)-ZxZpE*VS1(23,27))
VS0(23,77)=QCz*VS0(23,49)+WQz*VS1(23,49)-r1x2E*VR1(23,49)&
   +2D0*r1x2E*(VS0(23,28)-ZxZpE*VS1(23,28))
VS0(23,78)=QCy*VS0(23,53)+WQy*VS1(23,53)&
   +2D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))&
   +2D0*HfxZpE*VS1(12,53)
VS0(23,79)=QCz*VS0(23,51)+WQz*VS1(23,51)-r1x2E*VR1(23,51)&
   +3D0*r1x2E*(VS0(23,30)-ZxZpE*VS1(23,30))
VS0(23,80)=QCz*VS0(23,52)+WQz*VS1(23,52)-r1x2E*VR1(23,52)&
   +3D0*r1x2E*(VS0(23,31)-ZxZpE*VS1(23,31))
VS0(23,81)=QCz*VS0(23,53)+WQz*VS1(23,53)-r1x2E*VR1(23,53)&
   +3D0*r1x2E*(VS0(23,32)-ZxZpE*VS1(23,32))
VS0(23,82)=QCz*VS0(23,54)+WQz*VS1(23,54)-r1x2E*VR1(23,54)&
   +4D0*r1x2E*(VS0(23,33)-ZxZpE*VS1(23,33))
VS0(23,83)=QCz*VS0(23,55)+WQz*VS1(23,55)-r1x2E*VR1(23,55)&
   +4D0*r1x2E*(VS0(23,34)-ZxZpE*VS1(23,34))
VS0(23,84)=QCz*VS0(23,56)+WQz*VS1(23,56)-r1x2E*VR1(23,56)&
   +5D0*r1x2E*(VS0(23,35)-ZxZpE*VS1(23,35))
VS0(24,57)=QCx*VS0(24,36)+WQx*VS1(24,36)&
   +5D0*r1x2E*(VS0(24,21)-ZxZpE*VS1(24,21))&
   +HfxZpE*VS1(14,36)
VS0(24,58)=QCx*VS0(24,37)+WQx*VS1(24,37)&
   +4D0*r1x2E*(VS0(24,22)-ZxZpE*VS1(24,22))&
   +HfxZpE*VS1(14,37)
VS0(24,59)=QCx*VS0(24,38)+WQx*VS1(24,38)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +HfxZpE*VS1(14,38)
VS0(24,60)=QCx*VS0(24,39)+WQx*VS1(24,39)&
   +2D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +HfxZpE*VS1(14,39)
VS0(24,61)=QCy*VS0(24,39)+WQy*VS1(24,39)&
   +3D0*r1x2E*(VS0(24,23)-ZxZpE*VS1(24,23))&
   +3D0*HfxZpE*VS1(13,39)
VS0(24,62)=QCy*VS0(24,40)+WQy*VS1(24,40)&
   +4D0*r1x2E*(VS0(24,24)-ZxZpE*VS1(24,24))&
   +3D0*HfxZpE*VS1(13,40)
VS0(24,63)=QCy*VS0(24,41)+WQy*VS1(24,41)&
   +5D0*r1x2E*(VS0(24,25)-ZxZpE*VS1(24,25))&
   +3D0*HfxZpE*VS1(13,41)
VS0(24,64)=QCx*VS0(24,42)+WQx*VS1(24,42)&
   +4D0*r1x2E*(VS0(24,26)-ZxZpE*VS1(24,26))&
   +HfxZpE*VS1(14,42)
VS0(24,65)=QCx*VS0(24,43)+WQx*VS1(24,43)&
   +3D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +HfxZpE*VS1(14,43)
VS0(24,66)=QCx*VS0(24,44)+WQx*VS1(24,44)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +HfxZpE*VS1(14,44)
VS0(24,67)=QCy*VS0(24,44)+WQy*VS1(24,44)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))&
   +3D0*HfxZpE*VS1(13,44)
VS0(24,68)=QCy*VS0(24,45)+WQy*VS1(24,45)&
   +3D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))&
   +3D0*HfxZpE*VS1(13,45)
VS0(24,69)=QCy*VS0(24,46)+WQy*VS1(24,46)&
   +4D0*r1x2E*(VS0(24,29)-ZxZpE*VS1(24,29))&
   +3D0*HfxZpE*VS1(13,46)
VS0(24,70)=QCx*VS0(24,47)+WQx*VS1(24,47)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))&
   +HfxZpE*VS1(14,47)
VS0(24,71)=QCx*VS0(24,48)+WQx*VS1(24,48)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +HfxZpE*VS1(14,48)
VS0(24,72)=QCx*VS0(24,49)+WQx*VS1(24,49)&
   +r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +HfxZpE*VS1(14,49)
VS0(24,73)=QCy*VS0(24,49)+WQy*VS1(24,49)&
   +2D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))&
   +3D0*HfxZpE*VS1(13,49)
VS0(24,74)=QCy*VS0(24,50)+WQy*VS1(24,50)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))&
   +3D0*HfxZpE*VS1(13,50)
VS0(24,75)=QCx*VS0(24,51)+WQx*VS1(24,51)&
   +2D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))&
   +HfxZpE*VS1(14,51)
VS0(24,76)=QCz*VS0(24,48)+WQz*VS1(24,48)-r1x2E*VR1(24,48)&
   +2D0*r1x2E*(VS0(24,27)-ZxZpE*VS1(24,27))
VS0(24,77)=QCz*VS0(24,49)+WQz*VS1(24,49)-r1x2E*VR1(24,49)&
   +2D0*r1x2E*(VS0(24,28)-ZxZpE*VS1(24,28))
VS0(24,78)=QCy*VS0(24,53)+WQy*VS1(24,53)&
   +2D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))&
   +3D0*HfxZpE*VS1(13,53)
VS0(24,79)=QCz*VS0(24,51)+WQz*VS1(24,51)-r1x2E*VR1(24,51)&
   +3D0*r1x2E*(VS0(24,30)-ZxZpE*VS1(24,30))
VS0(24,80)=QCz*VS0(24,52)+WQz*VS1(24,52)-r1x2E*VR1(24,52)&
   +3D0*r1x2E*(VS0(24,31)-ZxZpE*VS1(24,31))
VS0(24,81)=QCz*VS0(24,53)+WQz*VS1(24,53)-r1x2E*VR1(24,53)&
   +3D0*r1x2E*(VS0(24,32)-ZxZpE*VS1(24,32))
VS0(24,82)=QCz*VS0(24,54)+WQz*VS1(24,54)-r1x2E*VR1(24,54)&
   +4D0*r1x2E*(VS0(24,33)-ZxZpE*VS1(24,33))
VS0(24,83)=QCz*VS0(24,55)+WQz*VS1(24,55)-r1x2E*VR1(24,55)&
   +4D0*r1x2E*(VS0(24,34)-ZxZpE*VS1(24,34))
VS0(24,84)=QCz*VS0(24,56)+WQz*VS1(24,56)-r1x2E*VR1(24,56)&
   +5D0*r1x2E*(VS0(24,35)-ZxZpE*VS1(24,35))
VS0(25,57)=QCx*VS0(25,36)+WQx*VS1(25,36)&
   +5D0*r1x2E*(VS0(25,21)-ZxZpE*VS1(25,21))
VS0(25,58)=QCx*VS0(25,37)+WQx*VS1(25,37)&
   +4D0*r1x2E*(VS0(25,22)-ZxZpE*VS1(25,22))
VS0(25,59)=QCx*VS0(25,38)+WQx*VS1(25,38)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))
VS0(25,60)=QCx*VS0(25,39)+WQx*VS1(25,39)&
   +2D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))
VS0(25,61)=QCy*VS0(25,39)+WQy*VS1(25,39)&
   +3D0*r1x2E*(VS0(25,23)-ZxZpE*VS1(25,23))&
   +4D0*HfxZpE*VS1(14,39)
VS0(25,62)=QCy*VS0(25,40)+WQy*VS1(25,40)&
   +4D0*r1x2E*(VS0(25,24)-ZxZpE*VS1(25,24))&
   +4D0*HfxZpE*VS1(14,40)
VS0(25,63)=QCy*VS0(25,41)+WQy*VS1(25,41)&
   +5D0*r1x2E*(VS0(25,25)-ZxZpE*VS1(25,25))&
   +4D0*HfxZpE*VS1(14,41)
VS0(25,64)=QCx*VS0(25,42)+WQx*VS1(25,42)&
   +4D0*r1x2E*(VS0(25,26)-ZxZpE*VS1(25,26))
VS0(25,65)=QCx*VS0(25,43)+WQx*VS1(25,43)&
   +3D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,66)=QCx*VS0(25,44)+WQx*VS1(25,44)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,67)=QCy*VS0(25,44)+WQy*VS1(25,44)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))&
   +4D0*HfxZpE*VS1(14,44)
VS0(25,68)=QCy*VS0(25,45)+WQy*VS1(25,45)&
   +3D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))&
   +4D0*HfxZpE*VS1(14,45)
VS0(25,69)=QCy*VS0(25,46)+WQy*VS1(25,46)&
   +4D0*r1x2E*(VS0(25,29)-ZxZpE*VS1(25,29))&
   +4D0*HfxZpE*VS1(14,46)
VS0(25,70)=QCx*VS0(25,47)+WQx*VS1(25,47)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,71)=QCx*VS0(25,48)+WQx*VS1(25,48)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,72)=QCx*VS0(25,49)+WQx*VS1(25,49)&
   +r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,73)=QCy*VS0(25,49)+WQy*VS1(25,49)&
   +2D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))&
   +4D0*HfxZpE*VS1(14,49)
VS0(25,74)=QCy*VS0(25,50)+WQy*VS1(25,50)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))&
   +4D0*HfxZpE*VS1(14,50)
VS0(25,75)=QCx*VS0(25,51)+WQx*VS1(25,51)&
   +2D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,76)=QCz*VS0(25,48)+WQz*VS1(25,48)-r1x2E*VR1(25,48)&
   +2D0*r1x2E*(VS0(25,27)-ZxZpE*VS1(25,27))
VS0(25,77)=QCz*VS0(25,49)+WQz*VS1(25,49)-r1x2E*VR1(25,49)&
   +2D0*r1x2E*(VS0(25,28)-ZxZpE*VS1(25,28))
VS0(25,78)=QCy*VS0(25,53)+WQy*VS1(25,53)&
   +2D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))&
   +4D0*HfxZpE*VS1(14,53)
VS0(25,79)=QCz*VS0(25,51)+WQz*VS1(25,51)-r1x2E*VR1(25,51)&
   +3D0*r1x2E*(VS0(25,30)-ZxZpE*VS1(25,30))
VS0(25,80)=QCz*VS0(25,52)+WQz*VS1(25,52)-r1x2E*VR1(25,52)&
   +3D0*r1x2E*(VS0(25,31)-ZxZpE*VS1(25,31))
VS0(25,81)=QCz*VS0(25,53)+WQz*VS1(25,53)-r1x2E*VR1(25,53)&
   +3D0*r1x2E*(VS0(25,32)-ZxZpE*VS1(25,32))
VS0(25,82)=QCz*VS0(25,54)+WQz*VS1(25,54)-r1x2E*VR1(25,54)&
   +4D0*r1x2E*(VS0(25,33)-ZxZpE*VS1(25,33))
VS0(25,83)=QCz*VS0(25,55)+WQz*VS1(25,55)-r1x2E*VR1(25,55)&
   +4D0*r1x2E*(VS0(25,34)-ZxZpE*VS1(25,34))
VS0(25,84)=QCz*VS0(25,56)+WQz*VS1(25,56)-r1x2E*VR1(25,56)&
   +5D0*r1x2E*(VS0(25,35)-ZxZpE*VS1(25,35))
VS0(26,57)=QCx*VS0(26,36)+WQx*VS1(26,36)&
   +5D0*r1x2E*(VS0(26,21)-ZxZpE*VS1(26,21))&
   +3D0*HfxZpE*VS1(15,36)
VS0(26,58)=QCx*VS0(26,37)+WQx*VS1(26,37)&
   +4D0*r1x2E*(VS0(26,22)-ZxZpE*VS1(26,22))&
   +3D0*HfxZpE*VS1(15,37)
VS0(26,59)=QCx*VS0(26,38)+WQx*VS1(26,38)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))&
   +3D0*HfxZpE*VS1(15,38)
VS0(26,60)=QCx*VS0(26,39)+WQx*VS1(26,39)&
   +2D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))&
   +3D0*HfxZpE*VS1(15,39)
VS0(26,61)=QCy*VS0(26,39)+WQy*VS1(26,39)&
   +3D0*r1x2E*(VS0(26,23)-ZxZpE*VS1(26,23))
VS0(26,62)=QCy*VS0(26,40)+WQy*VS1(26,40)&
   +4D0*r1x2E*(VS0(26,24)-ZxZpE*VS1(26,24))
VS0(26,63)=QCy*VS0(26,41)+WQy*VS1(26,41)&
   +5D0*r1x2E*(VS0(26,25)-ZxZpE*VS1(26,25))
VS0(26,64)=QCx*VS0(26,42)+WQx*VS1(26,42)&
   +4D0*r1x2E*(VS0(26,26)-ZxZpE*VS1(26,26))&
   +3D0*HfxZpE*VS1(15,42)
VS0(26,65)=QCx*VS0(26,43)+WQx*VS1(26,43)&
   +3D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +3D0*HfxZpE*VS1(15,43)
VS0(26,66)=QCx*VS0(26,44)+WQx*VS1(26,44)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +3D0*HfxZpE*VS1(15,44)
VS0(26,67)=QCy*VS0(26,44)+WQy*VS1(26,44)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))
VS0(26,68)=QCy*VS0(26,45)+WQy*VS1(26,45)&
   +3D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))
VS0(26,69)=QCy*VS0(26,46)+WQy*VS1(26,46)&
   +4D0*r1x2E*(VS0(26,29)-ZxZpE*VS1(26,29))
VS0(26,70)=QCx*VS0(26,47)+WQx*VS1(26,47)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +3D0*HfxZpE*VS1(15,47)
VS0(26,71)=QCx*VS0(26,48)+WQx*VS1(26,48)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +3D0*HfxZpE*VS1(15,48)
VS0(26,72)=QCx*VS0(26,49)+WQx*VS1(26,49)&
   +r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +3D0*HfxZpE*VS1(15,49)
VS0(26,73)=QCy*VS0(26,49)+WQy*VS1(26,49)&
   +2D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))
VS0(26,74)=QCy*VS0(26,50)+WQy*VS1(26,50)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))
VS0(26,75)=QCx*VS0(26,51)+WQx*VS1(26,51)&
   +2D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +3D0*HfxZpE*VS1(15,51)
VS0(26,76)=QCz*VS0(26,48)+WQz*VS1(26,48)-r1x2E*VR1(26,48)&
   +2D0*r1x2E*(VS0(26,27)-ZxZpE*VS1(26,27))&
   +HfxZpE*VS1(11,48)
VS0(26,77)=QCz*VS0(26,49)+WQz*VS1(26,49)-r1x2E*VR1(26,49)&
   +2D0*r1x2E*(VS0(26,28)-ZxZpE*VS1(26,28))&
   +HfxZpE*VS1(11,49)
VS0(26,78)=QCy*VS0(26,53)+WQy*VS1(26,53)&
   +2D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))
VS0(26,79)=QCz*VS0(26,51)+WQz*VS1(26,51)-r1x2E*VR1(26,51)&
   +3D0*r1x2E*(VS0(26,30)-ZxZpE*VS1(26,30))&
   +HfxZpE*VS1(11,51)
VS0(26,80)=QCz*VS0(26,52)+WQz*VS1(26,52)-r1x2E*VR1(26,52)&
   +3D0*r1x2E*(VS0(26,31)-ZxZpE*VS1(26,31))&
   +HfxZpE*VS1(11,52)
VS0(26,81)=QCz*VS0(26,53)+WQz*VS1(26,53)-r1x2E*VR1(26,53)&
   +3D0*r1x2E*(VS0(26,32)-ZxZpE*VS1(26,32))&
   +HfxZpE*VS1(11,53)
VS0(26,82)=QCz*VS0(26,54)+WQz*VS1(26,54)-r1x2E*VR1(26,54)&
   +4D0*r1x2E*(VS0(26,33)-ZxZpE*VS1(26,33))&
   +HfxZpE*VS1(11,54)
VS0(26,83)=QCz*VS0(26,55)+WQz*VS1(26,55)-r1x2E*VR1(26,55)&
   +4D0*r1x2E*(VS0(26,34)-ZxZpE*VS1(26,34))&
   +HfxZpE*VS1(11,55)
VS0(26,84)=QCz*VS0(26,56)+WQz*VS1(26,56)-r1x2E*VR1(26,56)&
   +5D0*r1x2E*(VS0(26,35)-ZxZpE*VS1(26,35))&
   +HfxZpE*VS1(11,56)
VS0(27,57)=QCx*VS0(27,36)+WQx*VS1(27,36)&
   +5D0*r1x2E*(VS0(27,21)-ZxZpE*VS1(27,21))&
   +2D0*HfxZpE*VS1(16,36)
VS0(27,58)=QCx*VS0(27,37)+WQx*VS1(27,37)&
   +4D0*r1x2E*(VS0(27,22)-ZxZpE*VS1(27,22))&
   +2D0*HfxZpE*VS1(16,37)
VS0(27,59)=QCx*VS0(27,38)+WQx*VS1(27,38)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +2D0*HfxZpE*VS1(16,38)
VS0(27,60)=QCx*VS0(27,39)+WQx*VS1(27,39)&
   +2D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +2D0*HfxZpE*VS1(16,39)
VS0(27,61)=QCy*VS0(27,39)+WQy*VS1(27,39)&
   +3D0*r1x2E*(VS0(27,23)-ZxZpE*VS1(27,23))&
   +HfxZpE*VS1(15,39)
VS0(27,62)=QCy*VS0(27,40)+WQy*VS1(27,40)&
   +4D0*r1x2E*(VS0(27,24)-ZxZpE*VS1(27,24))&
   +HfxZpE*VS1(15,40)
VS0(27,63)=QCy*VS0(27,41)+WQy*VS1(27,41)&
   +5D0*r1x2E*(VS0(27,25)-ZxZpE*VS1(27,25))&
   +HfxZpE*VS1(15,41)
VS0(27,64)=QCx*VS0(27,42)+WQx*VS1(27,42)&
   +4D0*r1x2E*(VS0(27,26)-ZxZpE*VS1(27,26))&
   +2D0*HfxZpE*VS1(16,42)
VS0(27,65)=QCx*VS0(27,43)+WQx*VS1(27,43)&
   +3D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +2D0*HfxZpE*VS1(16,43)
VS0(27,66)=QCx*VS0(27,44)+WQx*VS1(27,44)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +2D0*HfxZpE*VS1(16,44)
VS0(27,67)=QCy*VS0(27,44)+WQy*VS1(27,44)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(15,44)
VS0(27,68)=QCy*VS0(27,45)+WQy*VS1(27,45)&
   +3D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(15,45)
VS0(27,69)=QCy*VS0(27,46)+WQy*VS1(27,46)&
   +4D0*r1x2E*(VS0(27,29)-ZxZpE*VS1(27,29))&
   +HfxZpE*VS1(15,46)
VS0(27,70)=QCx*VS0(27,47)+WQx*VS1(27,47)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +2D0*HfxZpE*VS1(16,47)
VS0(27,71)=QCx*VS0(27,48)+WQx*VS1(27,48)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +2D0*HfxZpE*VS1(16,48)
VS0(27,72)=QCx*VS0(27,49)+WQx*VS1(27,49)&
   +r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +2D0*HfxZpE*VS1(16,49)
VS0(27,73)=QCy*VS0(27,49)+WQy*VS1(27,49)&
   +2D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(15,49)
VS0(27,74)=QCy*VS0(27,50)+WQy*VS1(27,50)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(15,50)
VS0(27,75)=QCx*VS0(27,51)+WQx*VS1(27,51)&
   +2D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +2D0*HfxZpE*VS1(16,51)
VS0(27,76)=QCz*VS0(27,48)+WQz*VS1(27,48)-r1x2E*VR1(27,48)&
   +2D0*r1x2E*(VS0(27,27)-ZxZpE*VS1(27,27))&
   +HfxZpE*VS1(12,48)
VS0(27,77)=QCz*VS0(27,49)+WQz*VS1(27,49)-r1x2E*VR1(27,49)&
   +2D0*r1x2E*(VS0(27,28)-ZxZpE*VS1(27,28))&
   +HfxZpE*VS1(12,49)
VS0(27,78)=QCy*VS0(27,53)+WQy*VS1(27,53)&
   +2D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(15,53)
VS0(27,79)=QCz*VS0(27,51)+WQz*VS1(27,51)-r1x2E*VR1(27,51)&
   +3D0*r1x2E*(VS0(27,30)-ZxZpE*VS1(27,30))&
   +HfxZpE*VS1(12,51)
VS0(27,80)=QCz*VS0(27,52)+WQz*VS1(27,52)-r1x2E*VR1(27,52)&
   +3D0*r1x2E*(VS0(27,31)-ZxZpE*VS1(27,31))&
   +HfxZpE*VS1(12,52)
VS0(27,81)=QCz*VS0(27,53)+WQz*VS1(27,53)-r1x2E*VR1(27,53)&
   +3D0*r1x2E*(VS0(27,32)-ZxZpE*VS1(27,32))&
   +HfxZpE*VS1(12,53)
VS0(27,82)=QCz*VS0(27,54)+WQz*VS1(27,54)-r1x2E*VR1(27,54)&
   +4D0*r1x2E*(VS0(27,33)-ZxZpE*VS1(27,33))&
   +HfxZpE*VS1(12,54)
VS0(27,83)=QCz*VS0(27,55)+WQz*VS1(27,55)-r1x2E*VR1(27,55)&
   +4D0*r1x2E*(VS0(27,34)-ZxZpE*VS1(27,34))&
   +HfxZpE*VS1(12,55)
VS0(27,84)=QCz*VS0(27,56)+WQz*VS1(27,56)-r1x2E*VR1(27,56)&
   +5D0*r1x2E*(VS0(27,35)-ZxZpE*VS1(27,35))&
   +HfxZpE*VS1(12,56)
VS0(28,57)=QCx*VS0(28,36)+WQx*VS1(28,36)&
   +5D0*r1x2E*(VS0(28,21)-ZxZpE*VS1(28,21))&
   +HfxZpE*VS1(17,36)
VS0(28,58)=QCx*VS0(28,37)+WQx*VS1(28,37)&
   +4D0*r1x2E*(VS0(28,22)-ZxZpE*VS1(28,22))&
   +HfxZpE*VS1(17,37)
VS0(28,59)=QCx*VS0(28,38)+WQx*VS1(28,38)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +HfxZpE*VS1(17,38)
VS0(28,60)=QCx*VS0(28,39)+WQx*VS1(28,39)&
   +2D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +HfxZpE*VS1(17,39)
VS0(28,61)=QCy*VS0(28,39)+WQy*VS1(28,39)&
   +3D0*r1x2E*(VS0(28,23)-ZxZpE*VS1(28,23))&
   +2D0*HfxZpE*VS1(16,39)
VS0(28,62)=QCy*VS0(28,40)+WQy*VS1(28,40)&
   +4D0*r1x2E*(VS0(28,24)-ZxZpE*VS1(28,24))&
   +2D0*HfxZpE*VS1(16,40)
VS0(28,63)=QCy*VS0(28,41)+WQy*VS1(28,41)&
   +5D0*r1x2E*(VS0(28,25)-ZxZpE*VS1(28,25))&
   +2D0*HfxZpE*VS1(16,41)
VS0(28,64)=QCx*VS0(28,42)+WQx*VS1(28,42)&
   +4D0*r1x2E*(VS0(28,26)-ZxZpE*VS1(28,26))&
   +HfxZpE*VS1(17,42)
VS0(28,65)=QCx*VS0(28,43)+WQx*VS1(28,43)&
   +3D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(17,43)
VS0(28,66)=QCx*VS0(28,44)+WQx*VS1(28,44)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(17,44)
VS0(28,67)=QCy*VS0(28,44)+WQy*VS1(28,44)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +2D0*HfxZpE*VS1(16,44)
VS0(28,68)=QCy*VS0(28,45)+WQy*VS1(28,45)&
   +3D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +2D0*HfxZpE*VS1(16,45)
VS0(28,69)=QCy*VS0(28,46)+WQy*VS1(28,46)&
   +4D0*r1x2E*(VS0(28,29)-ZxZpE*VS1(28,29))&
   +2D0*HfxZpE*VS1(16,46)
VS0(28,70)=QCx*VS0(28,47)+WQx*VS1(28,47)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(17,47)
VS0(28,71)=QCx*VS0(28,48)+WQx*VS1(28,48)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(17,48)
VS0(28,72)=QCx*VS0(28,49)+WQx*VS1(28,49)&
   +r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(17,49)
VS0(28,73)=QCy*VS0(28,49)+WQy*VS1(28,49)&
   +2D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +2D0*HfxZpE*VS1(16,49)
VS0(28,74)=QCy*VS0(28,50)+WQy*VS1(28,50)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +2D0*HfxZpE*VS1(16,50)
VS0(28,75)=QCx*VS0(28,51)+WQx*VS1(28,51)&
   +2D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(17,51)
VS0(28,76)=QCz*VS0(28,48)+WQz*VS1(28,48)-r1x2E*VR1(28,48)&
   +2D0*r1x2E*(VS0(28,27)-ZxZpE*VS1(28,27))&
   +HfxZpE*VS1(13,48)
VS0(28,77)=QCz*VS0(28,49)+WQz*VS1(28,49)-r1x2E*VR1(28,49)&
   +2D0*r1x2E*(VS0(28,28)-ZxZpE*VS1(28,28))&
   +HfxZpE*VS1(13,49)
VS0(28,78)=QCy*VS0(28,53)+WQy*VS1(28,53)&
   +2D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +2D0*HfxZpE*VS1(16,53)
VS0(28,79)=QCz*VS0(28,51)+WQz*VS1(28,51)-r1x2E*VR1(28,51)&
   +3D0*r1x2E*(VS0(28,30)-ZxZpE*VS1(28,30))&
   +HfxZpE*VS1(13,51)
VS0(28,80)=QCz*VS0(28,52)+WQz*VS1(28,52)-r1x2E*VR1(28,52)&
   +3D0*r1x2E*(VS0(28,31)-ZxZpE*VS1(28,31))&
   +HfxZpE*VS1(13,52)
VS0(28,81)=QCz*VS0(28,53)+WQz*VS1(28,53)-r1x2E*VR1(28,53)&
   +3D0*r1x2E*(VS0(28,32)-ZxZpE*VS1(28,32))&
   +HfxZpE*VS1(13,53)
VS0(28,82)=QCz*VS0(28,54)+WQz*VS1(28,54)-r1x2E*VR1(28,54)&
   +4D0*r1x2E*(VS0(28,33)-ZxZpE*VS1(28,33))&
   +HfxZpE*VS1(13,54)
VS0(28,83)=QCz*VS0(28,55)+WQz*VS1(28,55)-r1x2E*VR1(28,55)&
   +4D0*r1x2E*(VS0(28,34)-ZxZpE*VS1(28,34))&
   +HfxZpE*VS1(13,55)
VS0(28,84)=QCz*VS0(28,56)+WQz*VS1(28,56)-r1x2E*VR1(28,56)&
   +5D0*r1x2E*(VS0(28,35)-ZxZpE*VS1(28,35))&
   +HfxZpE*VS1(13,56)
VS0(29,57)=QCx*VS0(29,36)+WQx*VS1(29,36)&
   +5D0*r1x2E*(VS0(29,21)-ZxZpE*VS1(29,21))
VS0(29,58)=QCx*VS0(29,37)+WQx*VS1(29,37)&
   +4D0*r1x2E*(VS0(29,22)-ZxZpE*VS1(29,22))
VS0(29,59)=QCx*VS0(29,38)+WQx*VS1(29,38)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))
VS0(29,60)=QCx*VS0(29,39)+WQx*VS1(29,39)&
   +2D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))
VS0(29,61)=QCy*VS0(29,39)+WQy*VS1(29,39)&
   +3D0*r1x2E*(VS0(29,23)-ZxZpE*VS1(29,23))&
   +3D0*HfxZpE*VS1(17,39)
VS0(29,62)=QCy*VS0(29,40)+WQy*VS1(29,40)&
   +4D0*r1x2E*(VS0(29,24)-ZxZpE*VS1(29,24))&
   +3D0*HfxZpE*VS1(17,40)
VS0(29,63)=QCy*VS0(29,41)+WQy*VS1(29,41)&
   +5D0*r1x2E*(VS0(29,25)-ZxZpE*VS1(29,25))&
   +3D0*HfxZpE*VS1(17,41)
VS0(29,64)=QCx*VS0(29,42)+WQx*VS1(29,42)&
   +4D0*r1x2E*(VS0(29,26)-ZxZpE*VS1(29,26))
VS0(29,65)=QCx*VS0(29,43)+WQx*VS1(29,43)&
   +3D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))
VS0(29,66)=QCx*VS0(29,44)+WQx*VS1(29,44)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))
VS0(29,67)=QCy*VS0(29,44)+WQy*VS1(29,44)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +3D0*HfxZpE*VS1(17,44)
VS0(29,68)=QCy*VS0(29,45)+WQy*VS1(29,45)&
   +3D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +3D0*HfxZpE*VS1(17,45)
VS0(29,69)=QCy*VS0(29,46)+WQy*VS1(29,46)&
   +4D0*r1x2E*(VS0(29,29)-ZxZpE*VS1(29,29))&
   +3D0*HfxZpE*VS1(17,46)
VS0(29,70)=QCx*VS0(29,47)+WQx*VS1(29,47)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))
VS0(29,71)=QCx*VS0(29,48)+WQx*VS1(29,48)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))
VS0(29,72)=QCx*VS0(29,49)+WQx*VS1(29,49)&
   +r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))
VS0(29,73)=QCy*VS0(29,49)+WQy*VS1(29,49)&
   +2D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +3D0*HfxZpE*VS1(17,49)
VS0(29,74)=QCy*VS0(29,50)+WQy*VS1(29,50)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +3D0*HfxZpE*VS1(17,50)
VS0(29,75)=QCx*VS0(29,51)+WQx*VS1(29,51)&
   +2D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))
VS0(29,76)=QCz*VS0(29,48)+WQz*VS1(29,48)-r1x2E*VR1(29,48)&
   +2D0*r1x2E*(VS0(29,27)-ZxZpE*VS1(29,27))&
   +HfxZpE*VS1(14,48)
VS0(29,77)=QCz*VS0(29,49)+WQz*VS1(29,49)-r1x2E*VR1(29,49)&
   +2D0*r1x2E*(VS0(29,28)-ZxZpE*VS1(29,28))&
   +HfxZpE*VS1(14,49)
VS0(29,78)=QCy*VS0(29,53)+WQy*VS1(29,53)&
   +2D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +3D0*HfxZpE*VS1(17,53)
VS0(29,79)=QCz*VS0(29,51)+WQz*VS1(29,51)-r1x2E*VR1(29,51)&
   +3D0*r1x2E*(VS0(29,30)-ZxZpE*VS1(29,30))&
   +HfxZpE*VS1(14,51)
VS0(29,80)=QCz*VS0(29,52)+WQz*VS1(29,52)-r1x2E*VR1(29,52)&
   +3D0*r1x2E*(VS0(29,31)-ZxZpE*VS1(29,31))&
   +HfxZpE*VS1(14,52)
VS0(29,81)=QCz*VS0(29,53)+WQz*VS1(29,53)-r1x2E*VR1(29,53)&
   +3D0*r1x2E*(VS0(29,32)-ZxZpE*VS1(29,32))&
   +HfxZpE*VS1(14,53)
VS0(29,82)=QCz*VS0(29,54)+WQz*VS1(29,54)-r1x2E*VR1(29,54)&
   +4D0*r1x2E*(VS0(29,33)-ZxZpE*VS1(29,33))&
   +HfxZpE*VS1(14,54)
VS0(29,83)=QCz*VS0(29,55)+WQz*VS1(29,55)-r1x2E*VR1(29,55)&
   +4D0*r1x2E*(VS0(29,34)-ZxZpE*VS1(29,34))&
   +HfxZpE*VS1(14,55)
VS0(29,84)=QCz*VS0(29,56)+WQz*VS1(29,56)-r1x2E*VR1(29,56)&
   +5D0*r1x2E*(VS0(29,35)-ZxZpE*VS1(29,35))&
   +HfxZpE*VS1(14,56)
VS0(30,57)=QCx*VS0(30,36)+WQx*VS1(30,36)&
   +5D0*r1x2E*(VS0(30,21)-ZxZpE*VS1(30,21))&
   +2D0*HfxZpE*VS1(18,36)
VS0(30,58)=QCx*VS0(30,37)+WQx*VS1(30,37)&
   +4D0*r1x2E*(VS0(30,22)-ZxZpE*VS1(30,22))&
   +2D0*HfxZpE*VS1(18,37)
VS0(30,59)=QCx*VS0(30,38)+WQx*VS1(30,38)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))&
   +2D0*HfxZpE*VS1(18,38)
VS0(30,60)=QCx*VS0(30,39)+WQx*VS1(30,39)&
   +2D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))&
   +2D0*HfxZpE*VS1(18,39)
VS0(30,61)=QCy*VS0(30,39)+WQy*VS1(30,39)&
   +3D0*r1x2E*(VS0(30,23)-ZxZpE*VS1(30,23))
VS0(30,62)=QCy*VS0(30,40)+WQy*VS1(30,40)&
   +4D0*r1x2E*(VS0(30,24)-ZxZpE*VS1(30,24))
VS0(30,63)=QCy*VS0(30,41)+WQy*VS1(30,41)&
   +5D0*r1x2E*(VS0(30,25)-ZxZpE*VS1(30,25))
VS0(30,64)=QCx*VS0(30,42)+WQx*VS1(30,42)&
   +4D0*r1x2E*(VS0(30,26)-ZxZpE*VS1(30,26))&
   +2D0*HfxZpE*VS1(18,42)
VS0(30,65)=QCx*VS0(30,43)+WQx*VS1(30,43)&
   +3D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(18,43)
VS0(30,66)=QCx*VS0(30,44)+WQx*VS1(30,44)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(18,44)
VS0(30,67)=QCy*VS0(30,44)+WQy*VS1(30,44)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))
VS0(30,68)=QCy*VS0(30,45)+WQy*VS1(30,45)&
   +3D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))
VS0(30,69)=QCy*VS0(30,46)+WQy*VS1(30,46)&
   +4D0*r1x2E*(VS0(30,29)-ZxZpE*VS1(30,29))
VS0(30,70)=QCx*VS0(30,47)+WQx*VS1(30,47)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(18,47)
VS0(30,71)=QCx*VS0(30,48)+WQx*VS1(30,48)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(18,48)
VS0(30,72)=QCx*VS0(30,49)+WQx*VS1(30,49)&
   +r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(18,49)
VS0(30,73)=QCy*VS0(30,49)+WQy*VS1(30,49)&
   +2D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))
VS0(30,74)=QCy*VS0(30,50)+WQy*VS1(30,50)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))
VS0(30,75)=QCx*VS0(30,51)+WQx*VS1(30,51)&
   +2D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(18,51)
VS0(30,76)=QCz*VS0(30,48)+WQz*VS1(30,48)-r1x2E*VR1(30,48)&
   +2D0*r1x2E*(VS0(30,27)-ZxZpE*VS1(30,27))&
   +2D0*HfxZpE*VS1(15,48)
VS0(30,77)=QCz*VS0(30,49)+WQz*VS1(30,49)-r1x2E*VR1(30,49)&
   +2D0*r1x2E*(VS0(30,28)-ZxZpE*VS1(30,28))&
   +2D0*HfxZpE*VS1(15,49)
VS0(30,78)=QCy*VS0(30,53)+WQy*VS1(30,53)&
   +2D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))
VS0(30,79)=QCz*VS0(30,51)+WQz*VS1(30,51)-r1x2E*VR1(30,51)&
   +3D0*r1x2E*(VS0(30,30)-ZxZpE*VS1(30,30))&
   +2D0*HfxZpE*VS1(15,51)
VS0(30,80)=QCz*VS0(30,52)+WQz*VS1(30,52)-r1x2E*VR1(30,52)&
   +3D0*r1x2E*(VS0(30,31)-ZxZpE*VS1(30,31))&
   +2D0*HfxZpE*VS1(15,52)
VS0(30,81)=QCz*VS0(30,53)+WQz*VS1(30,53)-r1x2E*VR1(30,53)&
   +3D0*r1x2E*(VS0(30,32)-ZxZpE*VS1(30,32))&
   +2D0*HfxZpE*VS1(15,53)
VS0(30,82)=QCz*VS0(30,54)+WQz*VS1(30,54)-r1x2E*VR1(30,54)&
   +4D0*r1x2E*(VS0(30,33)-ZxZpE*VS1(30,33))&
   +2D0*HfxZpE*VS1(15,54)
VS0(30,83)=QCz*VS0(30,55)+WQz*VS1(30,55)-r1x2E*VR1(30,55)&
   +4D0*r1x2E*(VS0(30,34)-ZxZpE*VS1(30,34))&
   +2D0*HfxZpE*VS1(15,55)
VS0(30,84)=QCz*VS0(30,56)+WQz*VS1(30,56)-r1x2E*VR1(30,56)&
   +5D0*r1x2E*(VS0(30,35)-ZxZpE*VS1(30,35))&
   +2D0*HfxZpE*VS1(15,56)
VS0(31,57)=QCx*VS0(31,36)+WQx*VS1(31,36)&
   +5D0*r1x2E*(VS0(31,21)-ZxZpE*VS1(31,21))&
   +HfxZpE*VS1(19,36)
VS0(31,58)=QCx*VS0(31,37)+WQx*VS1(31,37)&
   +4D0*r1x2E*(VS0(31,22)-ZxZpE*VS1(31,22))&
   +HfxZpE*VS1(19,37)
VS0(31,59)=QCx*VS0(31,38)+WQx*VS1(31,38)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(19,38)
VS0(31,60)=QCx*VS0(31,39)+WQx*VS1(31,39)&
   +2D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(19,39)
VS0(31,61)=QCy*VS0(31,39)+WQy*VS1(31,39)&
   +3D0*r1x2E*(VS0(31,23)-ZxZpE*VS1(31,23))&
   +HfxZpE*VS1(18,39)
VS0(31,62)=QCy*VS0(31,40)+WQy*VS1(31,40)&
   +4D0*r1x2E*(VS0(31,24)-ZxZpE*VS1(31,24))&
   +HfxZpE*VS1(18,40)
VS0(31,63)=QCy*VS0(31,41)+WQy*VS1(31,41)&
   +5D0*r1x2E*(VS0(31,25)-ZxZpE*VS1(31,25))&
   +HfxZpE*VS1(18,41)
VS0(31,64)=QCx*VS0(31,42)+WQx*VS1(31,42)&
   +4D0*r1x2E*(VS0(31,26)-ZxZpE*VS1(31,26))&
   +HfxZpE*VS1(19,42)
VS0(31,65)=QCx*VS0(31,43)+WQx*VS1(31,43)&
   +3D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(19,43)
VS0(31,66)=QCx*VS0(31,44)+WQx*VS1(31,44)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(19,44)
VS0(31,67)=QCy*VS0(31,44)+WQy*VS1(31,44)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +HfxZpE*VS1(18,44)
VS0(31,68)=QCy*VS0(31,45)+WQy*VS1(31,45)&
   +3D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +HfxZpE*VS1(18,45)
VS0(31,69)=QCy*VS0(31,46)+WQy*VS1(31,46)&
   +4D0*r1x2E*(VS0(31,29)-ZxZpE*VS1(31,29))&
   +HfxZpE*VS1(18,46)
VS0(31,70)=QCx*VS0(31,47)+WQx*VS1(31,47)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +HfxZpE*VS1(19,47)
VS0(31,71)=QCx*VS0(31,48)+WQx*VS1(31,48)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(19,48)
VS0(31,72)=QCx*VS0(31,49)+WQx*VS1(31,49)&
   +r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(19,49)
VS0(31,73)=QCy*VS0(31,49)+WQy*VS1(31,49)&
   +2D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +HfxZpE*VS1(18,49)
VS0(31,74)=QCy*VS0(31,50)+WQy*VS1(31,50)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +HfxZpE*VS1(18,50)
VS0(31,75)=QCx*VS0(31,51)+WQx*VS1(31,51)&
   +2D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +HfxZpE*VS1(19,51)
VS0(31,76)=QCz*VS0(31,48)+WQz*VS1(31,48)-r1x2E*VR1(31,48)&
   +2D0*r1x2E*(VS0(31,27)-ZxZpE*VS1(31,27))&
   +2D0*HfxZpE*VS1(16,48)
VS0(31,77)=QCz*VS0(31,49)+WQz*VS1(31,49)-r1x2E*VR1(31,49)&
   +2D0*r1x2E*(VS0(31,28)-ZxZpE*VS1(31,28))&
   +2D0*HfxZpE*VS1(16,49)
VS0(31,78)=QCy*VS0(31,53)+WQy*VS1(31,53)&
   +2D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +HfxZpE*VS1(18,53)
VS0(31,79)=QCz*VS0(31,51)+WQz*VS1(31,51)-r1x2E*VR1(31,51)&
   +3D0*r1x2E*(VS0(31,30)-ZxZpE*VS1(31,30))&
   +2D0*HfxZpE*VS1(16,51)
VS0(31,80)=QCz*VS0(31,52)+WQz*VS1(31,52)-r1x2E*VR1(31,52)&
   +3D0*r1x2E*(VS0(31,31)-ZxZpE*VS1(31,31))&
   +2D0*HfxZpE*VS1(16,52)
VS0(31,81)=QCz*VS0(31,53)+WQz*VS1(31,53)-r1x2E*VR1(31,53)&
   +3D0*r1x2E*(VS0(31,32)-ZxZpE*VS1(31,32))&
   +2D0*HfxZpE*VS1(16,53)
VS0(31,82)=QCz*VS0(31,54)+WQz*VS1(31,54)-r1x2E*VR1(31,54)&
   +4D0*r1x2E*(VS0(31,33)-ZxZpE*VS1(31,33))&
   +2D0*HfxZpE*VS1(16,54)
VS0(31,83)=QCz*VS0(31,55)+WQz*VS1(31,55)-r1x2E*VR1(31,55)&
   +4D0*r1x2E*(VS0(31,34)-ZxZpE*VS1(31,34))&
   +2D0*HfxZpE*VS1(16,55)
VS0(31,84)=QCz*VS0(31,56)+WQz*VS1(31,56)-r1x2E*VR1(31,56)&
   +5D0*r1x2E*(VS0(31,35)-ZxZpE*VS1(31,35))&
   +2D0*HfxZpE*VS1(16,56)
VS0(32,57)=QCx*VS0(32,36)+WQx*VS1(32,36)&
   +5D0*r1x2E*(VS0(32,21)-ZxZpE*VS1(32,21))
VS0(32,58)=QCx*VS0(32,37)+WQx*VS1(32,37)&
   +4D0*r1x2E*(VS0(32,22)-ZxZpE*VS1(32,22))
VS0(32,59)=QCx*VS0(32,38)+WQx*VS1(32,38)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))
VS0(32,60)=QCx*VS0(32,39)+WQx*VS1(32,39)&
   +2D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))
VS0(32,61)=QCy*VS0(32,39)+WQy*VS1(32,39)&
   +3D0*r1x2E*(VS0(32,23)-ZxZpE*VS1(32,23))&
   +2D0*HfxZpE*VS1(19,39)
VS0(32,62)=QCy*VS0(32,40)+WQy*VS1(32,40)&
   +4D0*r1x2E*(VS0(32,24)-ZxZpE*VS1(32,24))&
   +2D0*HfxZpE*VS1(19,40)
VS0(32,63)=QCy*VS0(32,41)+WQy*VS1(32,41)&
   +5D0*r1x2E*(VS0(32,25)-ZxZpE*VS1(32,25))&
   +2D0*HfxZpE*VS1(19,41)
VS0(32,64)=QCx*VS0(32,42)+WQx*VS1(32,42)&
   +4D0*r1x2E*(VS0(32,26)-ZxZpE*VS1(32,26))
VS0(32,65)=QCx*VS0(32,43)+WQx*VS1(32,43)&
   +3D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))
VS0(32,66)=QCx*VS0(32,44)+WQx*VS1(32,44)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))
VS0(32,67)=QCy*VS0(32,44)+WQy*VS1(32,44)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(19,44)
VS0(32,68)=QCy*VS0(32,45)+WQy*VS1(32,45)&
   +3D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(19,45)
VS0(32,69)=QCy*VS0(32,46)+WQy*VS1(32,46)&
   +4D0*r1x2E*(VS0(32,29)-ZxZpE*VS1(32,29))&
   +2D0*HfxZpE*VS1(19,46)
VS0(32,70)=QCx*VS0(32,47)+WQx*VS1(32,47)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))
VS0(32,71)=QCx*VS0(32,48)+WQx*VS1(32,48)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))
VS0(32,72)=QCx*VS0(32,49)+WQx*VS1(32,49)&
   +r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))
VS0(32,73)=QCy*VS0(32,49)+WQy*VS1(32,49)&
   +2D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(19,49)
VS0(32,74)=QCy*VS0(32,50)+WQy*VS1(32,50)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(19,50)
VS0(32,75)=QCx*VS0(32,51)+WQx*VS1(32,51)&
   +2D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))
VS0(32,76)=QCz*VS0(32,48)+WQz*VS1(32,48)-r1x2E*VR1(32,48)&
   +2D0*r1x2E*(VS0(32,27)-ZxZpE*VS1(32,27))&
   +2D0*HfxZpE*VS1(17,48)
VS0(32,77)=QCz*VS0(32,49)+WQz*VS1(32,49)-r1x2E*VR1(32,49)&
   +2D0*r1x2E*(VS0(32,28)-ZxZpE*VS1(32,28))&
   +2D0*HfxZpE*VS1(17,49)
VS0(32,78)=QCy*VS0(32,53)+WQy*VS1(32,53)&
   +2D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(19,53)
VS0(32,79)=QCz*VS0(32,51)+WQz*VS1(32,51)-r1x2E*VR1(32,51)&
   +3D0*r1x2E*(VS0(32,30)-ZxZpE*VS1(32,30))&
   +2D0*HfxZpE*VS1(17,51)
VS0(32,80)=QCz*VS0(32,52)+WQz*VS1(32,52)-r1x2E*VR1(32,52)&
   +3D0*r1x2E*(VS0(32,31)-ZxZpE*VS1(32,31))&
   +2D0*HfxZpE*VS1(17,52)
VS0(32,81)=QCz*VS0(32,53)+WQz*VS1(32,53)-r1x2E*VR1(32,53)&
   +3D0*r1x2E*(VS0(32,32)-ZxZpE*VS1(32,32))&
   +2D0*HfxZpE*VS1(17,53)
VS0(32,82)=QCz*VS0(32,54)+WQz*VS1(32,54)-r1x2E*VR1(32,54)&
   +4D0*r1x2E*(VS0(32,33)-ZxZpE*VS1(32,33))&
   +2D0*HfxZpE*VS1(17,54)
VS0(32,83)=QCz*VS0(32,55)+WQz*VS1(32,55)-r1x2E*VR1(32,55)&
   +4D0*r1x2E*(VS0(32,34)-ZxZpE*VS1(32,34))&
   +2D0*HfxZpE*VS1(17,55)
VS0(32,84)=QCz*VS0(32,56)+WQz*VS1(32,56)-r1x2E*VR1(32,56)&
   +5D0*r1x2E*(VS0(32,35)-ZxZpE*VS1(32,35))&
   +2D0*HfxZpE*VS1(17,56)
VS0(33,57)=QCx*VS0(33,36)+WQx*VS1(33,36)&
   +5D0*r1x2E*(VS0(33,21)-ZxZpE*VS1(33,21))&
   +HfxZpE*VS1(20,36)
VS0(33,58)=QCx*VS0(33,37)+WQx*VS1(33,37)&
   +4D0*r1x2E*(VS0(33,22)-ZxZpE*VS1(33,22))&
   +HfxZpE*VS1(20,37)
VS0(33,59)=QCx*VS0(33,38)+WQx*VS1(33,38)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))&
   +HfxZpE*VS1(20,38)
VS0(33,60)=QCx*VS0(33,39)+WQx*VS1(33,39)&
   +2D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))&
   +HfxZpE*VS1(20,39)
VS0(33,61)=QCy*VS0(33,39)+WQy*VS1(33,39)&
   +3D0*r1x2E*(VS0(33,23)-ZxZpE*VS1(33,23))
VS0(33,62)=QCy*VS0(33,40)+WQy*VS1(33,40)&
   +4D0*r1x2E*(VS0(33,24)-ZxZpE*VS1(33,24))
VS0(33,63)=QCy*VS0(33,41)+WQy*VS1(33,41)&
   +5D0*r1x2E*(VS0(33,25)-ZxZpE*VS1(33,25))
VS0(33,64)=QCx*VS0(33,42)+WQx*VS1(33,42)&
   +4D0*r1x2E*(VS0(33,26)-ZxZpE*VS1(33,26))&
   +HfxZpE*VS1(20,42)
VS0(33,65)=QCx*VS0(33,43)+WQx*VS1(33,43)&
   +3D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +HfxZpE*VS1(20,43)
VS0(33,66)=QCx*VS0(33,44)+WQx*VS1(33,44)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +HfxZpE*VS1(20,44)
VS0(33,67)=QCy*VS0(33,44)+WQy*VS1(33,44)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))
VS0(33,68)=QCy*VS0(33,45)+WQy*VS1(33,45)&
   +3D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))
VS0(33,69)=QCy*VS0(33,46)+WQy*VS1(33,46)&
   +4D0*r1x2E*(VS0(33,29)-ZxZpE*VS1(33,29))
VS0(33,70)=QCx*VS0(33,47)+WQx*VS1(33,47)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +HfxZpE*VS1(20,47)
VS0(33,71)=QCx*VS0(33,48)+WQx*VS1(33,48)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +HfxZpE*VS1(20,48)
VS0(33,72)=QCx*VS0(33,49)+WQx*VS1(33,49)&
   +r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +HfxZpE*VS1(20,49)
VS0(33,73)=QCy*VS0(33,49)+WQy*VS1(33,49)&
   +2D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))
VS0(33,74)=QCy*VS0(33,50)+WQy*VS1(33,50)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))
VS0(33,75)=QCx*VS0(33,51)+WQx*VS1(33,51)&
   +2D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +HfxZpE*VS1(20,51)
VS0(33,76)=QCz*VS0(33,48)+WQz*VS1(33,48)-r1x2E*VR1(33,48)&
   +2D0*r1x2E*(VS0(33,27)-ZxZpE*VS1(33,27))&
   +3D0*HfxZpE*VS1(18,48)
VS0(33,77)=QCz*VS0(33,49)+WQz*VS1(33,49)-r1x2E*VR1(33,49)&
   +2D0*r1x2E*(VS0(33,28)-ZxZpE*VS1(33,28))&
   +3D0*HfxZpE*VS1(18,49)
VS0(33,78)=QCy*VS0(33,53)+WQy*VS1(33,53)&
   +2D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))
VS0(33,79)=QCz*VS0(33,51)+WQz*VS1(33,51)-r1x2E*VR1(33,51)&
   +3D0*r1x2E*(VS0(33,30)-ZxZpE*VS1(33,30))&
   +3D0*HfxZpE*VS1(18,51)
VS0(33,80)=QCz*VS0(33,52)+WQz*VS1(33,52)-r1x2E*VR1(33,52)&
   +3D0*r1x2E*(VS0(33,31)-ZxZpE*VS1(33,31))&
   +3D0*HfxZpE*VS1(18,52)
VS0(33,81)=QCz*VS0(33,53)+WQz*VS1(33,53)-r1x2E*VR1(33,53)&
   +3D0*r1x2E*(VS0(33,32)-ZxZpE*VS1(33,32))&
   +3D0*HfxZpE*VS1(18,53)
VS0(33,82)=QCz*VS0(33,54)+WQz*VS1(33,54)-r1x2E*VR1(33,54)&
   +4D0*r1x2E*(VS0(33,33)-ZxZpE*VS1(33,33))&
   +3D0*HfxZpE*VS1(18,54)
VS0(33,83)=QCz*VS0(33,55)+WQz*VS1(33,55)-r1x2E*VR1(33,55)&
   +4D0*r1x2E*(VS0(33,34)-ZxZpE*VS1(33,34))&
   +3D0*HfxZpE*VS1(18,55)
VS0(33,84)=QCz*VS0(33,56)+WQz*VS1(33,56)-r1x2E*VR1(33,56)&
   +5D0*r1x2E*(VS0(33,35)-ZxZpE*VS1(33,35))&
   +3D0*HfxZpE*VS1(18,56)
VS0(34,57)=QCx*VS0(34,36)+WQx*VS1(34,36)&
   +5D0*r1x2E*(VS0(34,21)-ZxZpE*VS1(34,21))
VS0(34,58)=QCx*VS0(34,37)+WQx*VS1(34,37)&
   +4D0*r1x2E*(VS0(34,22)-ZxZpE*VS1(34,22))
VS0(34,59)=QCx*VS0(34,38)+WQx*VS1(34,38)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))
VS0(34,60)=QCx*VS0(34,39)+WQx*VS1(34,39)&
   +2D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))
VS0(34,61)=QCy*VS0(34,39)+WQy*VS1(34,39)&
   +3D0*r1x2E*(VS0(34,23)-ZxZpE*VS1(34,23))&
   +HfxZpE*VS1(20,39)
VS0(34,62)=QCy*VS0(34,40)+WQy*VS1(34,40)&
   +4D0*r1x2E*(VS0(34,24)-ZxZpE*VS1(34,24))&
   +HfxZpE*VS1(20,40)
VS0(34,63)=QCy*VS0(34,41)+WQy*VS1(34,41)&
   +5D0*r1x2E*(VS0(34,25)-ZxZpE*VS1(34,25))&
   +HfxZpE*VS1(20,41)
VS0(34,64)=QCx*VS0(34,42)+WQx*VS1(34,42)&
   +4D0*r1x2E*(VS0(34,26)-ZxZpE*VS1(34,26))
VS0(34,65)=QCx*VS0(34,43)+WQx*VS1(34,43)&
   +3D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))
VS0(34,66)=QCx*VS0(34,44)+WQx*VS1(34,44)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))
VS0(34,67)=QCy*VS0(34,44)+WQy*VS1(34,44)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +HfxZpE*VS1(20,44)
VS0(34,68)=QCy*VS0(34,45)+WQy*VS1(34,45)&
   +3D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +HfxZpE*VS1(20,45)
VS0(34,69)=QCy*VS0(34,46)+WQy*VS1(34,46)&
   +4D0*r1x2E*(VS0(34,29)-ZxZpE*VS1(34,29))&
   +HfxZpE*VS1(20,46)
VS0(34,70)=QCx*VS0(34,47)+WQx*VS1(34,47)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))
VS0(34,71)=QCx*VS0(34,48)+WQx*VS1(34,48)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))
VS0(34,72)=QCx*VS0(34,49)+WQx*VS1(34,49)&
   +r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))
VS0(34,73)=QCy*VS0(34,49)+WQy*VS1(34,49)&
   +2D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +HfxZpE*VS1(20,49)
VS0(34,74)=QCy*VS0(34,50)+WQy*VS1(34,50)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +HfxZpE*VS1(20,50)
VS0(34,75)=QCx*VS0(34,51)+WQx*VS1(34,51)&
   +2D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))
VS0(34,76)=QCz*VS0(34,48)+WQz*VS1(34,48)-r1x2E*VR1(34,48)&
   +2D0*r1x2E*(VS0(34,27)-ZxZpE*VS1(34,27))&
   +3D0*HfxZpE*VS1(19,48)
VS0(34,77)=QCz*VS0(34,49)+WQz*VS1(34,49)-r1x2E*VR1(34,49)&
   +2D0*r1x2E*(VS0(34,28)-ZxZpE*VS1(34,28))&
   +3D0*HfxZpE*VS1(19,49)
VS0(34,78)=QCy*VS0(34,53)+WQy*VS1(34,53)&
   +2D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +HfxZpE*VS1(20,53)
VS0(34,79)=QCz*VS0(34,51)+WQz*VS1(34,51)-r1x2E*VR1(34,51)&
   +3D0*r1x2E*(VS0(34,30)-ZxZpE*VS1(34,30))&
   +3D0*HfxZpE*VS1(19,51)
VS0(34,80)=QCz*VS0(34,52)+WQz*VS1(34,52)-r1x2E*VR1(34,52)&
   +3D0*r1x2E*(VS0(34,31)-ZxZpE*VS1(34,31))&
   +3D0*HfxZpE*VS1(19,52)
VS0(34,81)=QCz*VS0(34,53)+WQz*VS1(34,53)-r1x2E*VR1(34,53)&
   +3D0*r1x2E*(VS0(34,32)-ZxZpE*VS1(34,32))&
   +3D0*HfxZpE*VS1(19,53)
VS0(34,82)=QCz*VS0(34,54)+WQz*VS1(34,54)-r1x2E*VR1(34,54)&
   +4D0*r1x2E*(VS0(34,33)-ZxZpE*VS1(34,33))&
   +3D0*HfxZpE*VS1(19,54)
VS0(34,83)=QCz*VS0(34,55)+WQz*VS1(34,55)-r1x2E*VR1(34,55)&
   +4D0*r1x2E*(VS0(34,34)-ZxZpE*VS1(34,34))&
   +3D0*HfxZpE*VS1(19,55)
VS0(34,84)=QCz*VS0(34,56)+WQz*VS1(34,56)-r1x2E*VR1(34,56)&
   +5D0*r1x2E*(VS0(34,35)-ZxZpE*VS1(34,35))&
   +3D0*HfxZpE*VS1(19,56)
VS0(35,57)=QCx*VS0(35,36)+WQx*VS1(35,36)&
   +5D0*r1x2E*(VS0(35,21)-ZxZpE*VS1(35,21))
VS0(35,58)=QCx*VS0(35,37)+WQx*VS1(35,37)&
   +4D0*r1x2E*(VS0(35,22)-ZxZpE*VS1(35,22))
VS0(35,59)=QCx*VS0(35,38)+WQx*VS1(35,38)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,60)=QCx*VS0(35,39)+WQx*VS1(35,39)&
   +2D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,61)=QCy*VS0(35,39)+WQy*VS1(35,39)&
   +3D0*r1x2E*(VS0(35,23)-ZxZpE*VS1(35,23))
VS0(35,62)=QCy*VS0(35,40)+WQy*VS1(35,40)&
   +4D0*r1x2E*(VS0(35,24)-ZxZpE*VS1(35,24))
VS0(35,63)=QCy*VS0(35,41)+WQy*VS1(35,41)&
   +5D0*r1x2E*(VS0(35,25)-ZxZpE*VS1(35,25))
VS0(35,64)=QCx*VS0(35,42)+WQx*VS1(35,42)&
   +4D0*r1x2E*(VS0(35,26)-ZxZpE*VS1(35,26))
VS0(35,65)=QCx*VS0(35,43)+WQx*VS1(35,43)&
   +3D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,66)=QCx*VS0(35,44)+WQx*VS1(35,44)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,67)=QCy*VS0(35,44)+WQy*VS1(35,44)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))
VS0(35,68)=QCy*VS0(35,45)+WQy*VS1(35,45)&
   +3D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))
VS0(35,69)=QCy*VS0(35,46)+WQy*VS1(35,46)&
   +4D0*r1x2E*(VS0(35,29)-ZxZpE*VS1(35,29))
VS0(35,70)=QCx*VS0(35,47)+WQx*VS1(35,47)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))
VS0(35,71)=QCx*VS0(35,48)+WQx*VS1(35,48)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,72)=QCx*VS0(35,49)+WQx*VS1(35,49)&
   +r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,73)=QCy*VS0(35,49)+WQy*VS1(35,49)&
   +2D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))
VS0(35,74)=QCy*VS0(35,50)+WQy*VS1(35,50)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))
VS0(35,75)=QCx*VS0(35,51)+WQx*VS1(35,51)&
   +2D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))
VS0(35,76)=QCz*VS0(35,48)+WQz*VS1(35,48)-r1x2E*VR1(35,48)&
   +2D0*r1x2E*(VS0(35,27)-ZxZpE*VS1(35,27))&
   +4D0*HfxZpE*VS1(20,48)
VS0(35,77)=QCz*VS0(35,49)+WQz*VS1(35,49)-r1x2E*VR1(35,49)&
   +2D0*r1x2E*(VS0(35,28)-ZxZpE*VS1(35,28))&
   +4D0*HfxZpE*VS1(20,49)
VS0(35,78)=QCy*VS0(35,53)+WQy*VS1(35,53)&
   +2D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))
VS0(35,79)=QCz*VS0(35,51)+WQz*VS1(35,51)-r1x2E*VR1(35,51)&
   +3D0*r1x2E*(VS0(35,30)-ZxZpE*VS1(35,30))&
   +4D0*HfxZpE*VS1(20,51)
VS0(35,80)=QCz*VS0(35,52)+WQz*VS1(35,52)-r1x2E*VR1(35,52)&
   +3D0*r1x2E*(VS0(35,31)-ZxZpE*VS1(35,31))&
   +4D0*HfxZpE*VS1(20,52)
VS0(35,81)=QCz*VS0(35,53)+WQz*VS1(35,53)-r1x2E*VR1(35,53)&
   +3D0*r1x2E*(VS0(35,32)-ZxZpE*VS1(35,32))&
   +4D0*HfxZpE*VS1(20,53)
VS0(35,82)=QCz*VS0(35,54)+WQz*VS1(35,54)-r1x2E*VR1(35,54)&
   +4D0*r1x2E*(VS0(35,33)-ZxZpE*VS1(35,33))&
   +4D0*HfxZpE*VS1(20,54)
VS0(35,83)=QCz*VS0(35,55)+WQz*VS1(35,55)-r1x2E*VR1(35,55)&
   +4D0*r1x2E*(VS0(35,34)-ZxZpE*VS1(35,34))&
   +4D0*HfxZpE*VS1(20,55)
VS0(35,84)=QCz*VS0(35,56)+WQz*VS1(35,56)-r1x2E*VR1(35,56)&
   +5D0*r1x2E*(VS0(35,35)-ZxZpE*VS1(35,35))&
   +4D0*HfxZpE*VS1(20,56)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0i0'
STOP
END SELECT
END SUBROUTINE MVRRg0i0
