!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRf0h0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(11,12)
      V(2)=r1x2E*ZxZpE*VRR1(11,12)
      V(3)=r1x2E*VRR0(11,13)
      V(4)=HfxZpE*VRR1(5,23)
      V(5)=r1x2E*ZxZpE*VRR1(11,13)
      V(6)=r1x2E*VRR0(11,15)
      V(7)=r1x2E*ZxZpE*VRR1(11,15)
      V(8)=r1x2E*VRR0(11,16)
      V(9)=2.D0*V(8)
      V(10)=r1x2E*ZxZpE*VRR1(11,16)
      V(11)=-2.D0*V(10)
      V(12)=HfxZpE*VRR1(5,28)
      V(13)=r1x2E*VRR0(11,17)
      V(14)=r1x2E*ZxZpE*VRR1(11,17)
      V(15)=r1x2E*VRR0(11,18)
      V(16)=HfxZpE*VRR1(5,30)
      V(17)=r1x2E*ZxZpE*VRR1(11,18)
      V(18)=HfxZpE*VRR1(5,31)
      V(19)=HfxZpE*VRR1(5,32)
      V(20)=r1x2E*VRR0(11,19)
      V(21)=r1x2E*ZxZpE*VRR1(11,19)
      V(22)=r1x2E*VRR0(12,12)
      V(23)=r1x2E*ZxZpE*VRR1(12,12)
      V(24)=r1x2E*VRR0(12,13)
      V(25)=HfxZpE*VRR1(6,23)
      V(26)=2.D0*V(25)
      V(27)=r1x2E*ZxZpE*VRR1(12,13)
      V(28)=r1x2E*VRR0(12,15)
      V(29)=r1x2E*ZxZpE*VRR1(12,15)
      V(30)=r1x2E*VRR0(12,16)
      V(31)=2.D0*V(30)
      V(32)=r1x2E*ZxZpE*VRR1(12,16)
      V(33)=-2.D0*V(32)
      V(34)=r1x2E*VRR0(12,17)
      V(35)=HfxZpE*VRR1(6,28)
      V(36)=2.D0*V(35)
      V(37)=r1x2E*ZxZpE*VRR1(12,17)
      V(38)=r1x2E*VRR0(12,18)
      V(39)=HfxZpE*VRR1(6,30)
      V(40)=r1x2E*ZxZpE*VRR1(12,18)
      V(41)=r1x2E*VRR0(12,19)
      V(42)=HfxZpE*VRR1(6,31)
      V(43)=2.D0*V(42)
      V(44)=r1x2E*ZxZpE*VRR1(12,19)
      V(45)=r1x2E*VRR0(13,12)
      V(46)=r1x2E*ZxZpE*VRR1(13,12)
      V(47)=r1x2E*VRR0(13,13)
      V(48)=HfxZpE*VRR1(7,23)
      V(49)=r1x2E*ZxZpE*VRR1(13,13)
      V(50)=r1x2E*VRR0(13,15)
      V(51)=r1x2E*ZxZpE*VRR1(13,15)
      V(52)=r1x2E*VRR0(13,16)
      V(53)=2.D0*V(52)
      V(54)=HfxZpE*VRR1(7,27)
      V(55)=r1x2E*ZxZpE*VRR1(13,16)
      V(56)=-2.D0*V(55)
      V(57)=r1x2E*VRR0(13,17)
      V(58)=HfxZpE*VRR1(7,28)
      V(59)=r1x2E*ZxZpE*VRR1(13,17)
      V(60)=r1x2E*VRR0(13,18)
      V(61)=HfxZpE*VRR1(7,30)
      V(62)=r1x2E*ZxZpE*VRR1(13,18)
      V(63)=r1x2E*VRR0(13,19)
      V(64)=HfxZpE*VRR1(7,31)
      V(65)=r1x2E*ZxZpE*VRR1(13,19)
      V(66)=HfxZpE*VRR1(6,32)
      V(67)=r1x2E*VRR0(14,12)
      V(68)=r1x2E*ZxZpE*VRR1(14,12)
      V(69)=r1x2E*VRR0(14,13)
      V(70)=r1x2E*ZxZpE*VRR1(14,13)
      V(71)=r1x2E*VRR0(14,15)
      V(72)=r1x2E*ZxZpE*VRR1(14,15)
      V(73)=r1x2E*VRR0(14,16)
      V(74)=2.D0*V(73)
      V(75)=r1x2E*ZxZpE*VRR1(14,16)
      V(76)=-2.D0*V(75)
      V(77)=r1x2E*VRR0(14,17)
      V(78)=r1x2E*ZxZpE*VRR1(14,17)
      V(79)=r1x2E*VRR0(14,18)
      V(80)=r1x2E*ZxZpE*VRR1(14,18)
      V(81)=r1x2E*VRR0(14,19)
      V(82)=HfxZpE*VRR1(7,32)
      V(83)=r1x2E*ZxZpE*VRR1(14,19)
      V(84)=r1x2E*VRR0(15,12)
      V(85)=r1x2E*ZxZpE*VRR1(15,12)
      V(86)=r1x2E*VRR0(15,13)
      V(87)=HfxZpE*VRR1(8,23)
      V(88)=r1x2E*ZxZpE*VRR1(15,13)
      V(89)=r1x2E*VRR0(15,15)
      V(90)=r1x2E*ZxZpE*VRR1(15,15)
      V(91)=r1x2E*VRR0(15,16)
      V(92)=2.D0*V(91)
      V(93)=r1x2E*ZxZpE*VRR1(15,16)
      V(94)=-2.D0*V(93)
      V(95)=r1x2E*VRR0(15,17)
      V(96)=HfxZpE*VRR1(8,28)
      V(97)=r1x2E*ZxZpE*VRR1(15,17)
      V(98)=r1x2E*VRR0(15,18)
      V(99)=HfxZpE*VRR1(8,30)
      V(100)=2.D0*V(99)
      V(101)=r1x2E*ZxZpE*VRR1(15,18)
      V(102)=r1x2E*VRR0(15,19)
      V(103)=HfxZpE*VRR1(8,31)
      V(104)=2.D0*V(103)
      V(105)=r1x2E*ZxZpE*VRR1(15,19)
      V(106)=r1x2E*VRR0(16,12)
      V(107)=r1x2E*ZxZpE*VRR1(16,12)
      V(108)=r1x2E*VRR0(16,13)
      V(109)=HfxZpE*VRR1(9,23)
      V(110)=r1x2E*ZxZpE*VRR1(16,13)
      V(111)=r1x2E*VRR0(16,15)
      V(112)=r1x2E*ZxZpE*VRR1(16,15)
      V(113)=r1x2E*VRR0(16,16)
      V(114)=2.D0*V(113)
      V(115)=r1x2E*ZxZpE*VRR1(16,16)
      V(116)=-2.D0*V(115)
      V(117)=r1x2E*VRR0(16,17)
      V(118)=HfxZpE*VRR1(9,28)
      V(119)=r1x2E*ZxZpE*VRR1(16,17)
      V(120)=r1x2E*VRR0(16,18)
      V(121)=HfxZpE*VRR1(9,30)
      V(122)=r1x2E*ZxZpE*VRR1(16,18)
      V(123)=r1x2E*VRR0(16,19)
      V(124)=HfxZpE*VRR1(9,31)
      V(125)=r1x2E*ZxZpE*VRR1(16,19)
      V(126)=HfxZpE*VRR1(8,32)
      V(127)=r1x2E*VRR0(17,12)
      V(128)=r1x2E*ZxZpE*VRR1(17,12)
      V(129)=r1x2E*VRR0(17,13)
      V(130)=r1x2E*ZxZpE*VRR1(17,13)
      V(131)=r1x2E*VRR0(17,15)
      V(132)=r1x2E*ZxZpE*VRR1(17,15)
      V(133)=r1x2E*VRR0(17,16)
      V(134)=2.D0*V(133)
      V(135)=r1x2E*ZxZpE*VRR1(17,16)
      V(136)=-2.D0*V(135)
      V(137)=r1x2E*VRR0(17,17)
      V(138)=r1x2E*ZxZpE*VRR1(17,17)
      V(139)=r1x2E*VRR0(17,18)
      V(140)=r1x2E*ZxZpE*VRR1(17,18)
      V(141)=r1x2E*VRR0(17,19)
      V(142)=r1x2E*ZxZpE*VRR1(17,19)
      V(143)=2.D0*V(124)
      V(144)=HfxZpE*VRR1(9,32)
      V(145)=2.D0*V(144)
      V(146)=r1x2E*VRR0(18,12)
      V(147)=r1x2E*ZxZpE*VRR1(18,12)
      V(148)=r1x2E*VRR0(18,13)
      V(149)=HfxZpE*VRR1(10,23)
      V(150)=r1x2E*ZxZpE*VRR1(18,13)
      V(151)=r1x2E*VRR0(18,15)
      V(152)=r1x2E*ZxZpE*VRR1(18,15)
      V(153)=r1x2E*VRR0(18,16)
      V(154)=2.D0*V(153)
      V(155)=HfxZpE*VRR1(10,27)
      V(156)=r1x2E*ZxZpE*VRR1(18,16)
      V(157)=-2.D0*V(156)
      V(158)=r1x2E*VRR0(18,17)
      V(159)=HfxZpE*VRR1(10,28)
      V(160)=r1x2E*ZxZpE*VRR1(18,17)
      V(161)=r1x2E*VRR0(18,18)
      V(162)=HfxZpE*VRR1(10,30)
      V(163)=r1x2E*ZxZpE*VRR1(18,18)
      V(164)=r1x2E*VRR0(18,19)
      V(165)=HfxZpE*VRR1(10,31)
      V(166)=r1x2E*ZxZpE*VRR1(18,19)
      V(167)=r1x2E*VRR0(19,12)
      V(168)=r1x2E*ZxZpE*VRR1(19,12)
      V(169)=r1x2E*VRR0(19,13)
      V(170)=r1x2E*ZxZpE*VRR1(19,13)
      V(171)=r1x2E*VRR0(19,15)
      V(172)=r1x2E*ZxZpE*VRR1(19,15)
      V(173)=r1x2E*VRR0(19,16)
      V(174)=2.D0*V(173)
      V(175)=r1x2E*ZxZpE*VRR1(19,16)
      V(176)=-2.D0*V(175)
      V(177)=r1x2E*VRR0(19,17)
      V(178)=r1x2E*ZxZpE*VRR1(19,17)
      V(179)=r1x2E*VRR0(19,18)
      V(180)=r1x2E*ZxZpE*VRR1(19,18)
      V(181)=r1x2E*VRR0(19,19)
      V(182)=r1x2E*ZxZpE*VRR1(19,19)
      V(183)=HfxZpE*VRR1(10,32)
      V(184)=r1x2E*VRR0(20,12)
      V(185)=r1x2E*ZxZpE*VRR1(20,12)
      V(186)=r1x2E*VRR0(20,13)
      V(187)=r1x2E*ZxZpE*VRR1(20,13)
      V(188)=r1x2E*VRR0(20,15)
      V(189)=r1x2E*ZxZpE*VRR1(20,15)
      V(190)=r1x2E*VRR0(20,16)
      V(191)=2.D0*V(190)
      V(192)=r1x2E*ZxZpE*VRR1(20,16)
      V(193)=-2.D0*V(192)
      V(194)=r1x2E*VRR0(20,17)
      V(195)=r1x2E*ZxZpE*VRR1(20,17)
      V(196)=r1x2E*VRR0(20,18)
      V(197)=r1x2E*ZxZpE*VRR1(20,18)
      V(198)=r1x2E*VRR0(20,19)
      V(199)=r1x2E*ZxZpE*VRR1(20,19)
      VRR0(11,36)=4.D0*r1x2E*VRR0(11,11)+QCx*VRR0(11,21)+3.D0*HfxZpE*VRR1(5,21)-4.D0*r1x2E*ZxZpE*VRR1(11,11)+WQx*VRR1(11,21)
      VRR0(11,37)=3.D0*V(1)-3.D0*V(2)+QCx*VRR0(11,22)+3.D0*HfxZpE*VRR1(5,22)+WQx*VRR1(11,22)
      VRR0(11,38)=2.D0*V(3)+3.D0*V(4)-2.D0*V(5)+QCx*VRR0(11,23)+WQx*VRR1(11,23)
      VRR0(11,39)=2.D0*V(1)-2.D0*V(2)+QCy*VRR0(11,23)+WQy*VRR1(11,23)
      VRR0(11,40)=3.D0*V(3)-3.D0*V(5)+QCy*VRR0(11,24)+WQy*VRR1(11,24)
      VRR0(11,41)=4.D0*r1x2E*VRR0(11,14)+QCy*VRR0(11,25)-4.D0*r1x2E*ZxZpE*VRR1(11,14)+WQy*VRR1(11,25)
      VRR0(11,42)=3.D0*V(6)-3.D0*V(7)+QCx*VRR0(11,26)+3.D0*HfxZpE*VRR1(5,26)+WQx*VRR1(11,26)
      VRR0(11,43)=V(9)+V(11)+QCx*VRR0(11,27)+3.D0*HfxZpE*VRR1(5,27)+WQx*VRR1(11,27)
      VRR0(11,44)=2.D0*V(12)+2.D0*r1x2Z*VRR0(2,44)+PAx*VRR0(5,44)-2.D0*ExZpE*r1x2Z*VRR1(2,44)+WPx*VRR1(5,44)
      VRR0(11,45)=V(9)+V(11)+QCy*VRR0(11,28)+WQy*VRR1(11,28)
      VRR0(11,46)=3.D0*V(13)-3.D0*V(14)+QCy*VRR0(11,29)+WQy*VRR1(11,29)
      VRR0(11,47)=2.D0*V(15)+3.D0*V(16)-2.D0*V(17)+QCx*VRR0(11,30)+WQx*VRR1(11,30)
      VRR0(11,48)=2.D0*V(18)+2.D0*r1x2Z*VRR0(2,48)+PAx*VRR0(5,48)-2.D0*ExZpE*r1x2Z*VRR1(2,48)+WPx*VRR1(5,48)
      VRR0(11,49)=V(19)+2.D0*r1x2Z*VRR0(2,49)+PAx*VRR0(5,49)-2.D0*ExZpE*r1x2Z*VRR1(2,49)+WPx*VRR1(5,49)
      VRR0(11,50)=2.D0*V(20)-2.D0*V(21)+QCy*VRR0(11,32)+WQy*VRR1(11,32)
      VRR0(11,51)=2.D0*V(6)-2.D0*V(7)+QCz*VRR0(11,30)+WQz*VRR1(11,30)
      VRR0(11,52)=V(9)+V(11)+QCz*VRR0(11,31)+WQz*VRR1(11,31)
      VRR0(11,53)=2.D0*V(13)-2.D0*V(14)+QCz*VRR0(11,32)+WQz*VRR1(11,32)
      VRR0(11,54)=3.D0*V(15)-3.D0*V(17)+QCz*VRR0(11,33)+WQz*VRR1(11,33)
      VRR0(11,55)=3.D0*V(20)-3.D0*V(21)+QCz*VRR0(11,34)+WQz*VRR1(11,34)
      VRR0(11,56)=4.D0*r1x2E*VRR0(11,20)+QCz*VRR0(11,35)-4.D0*r1x2E*ZxZpE*VRR1(11,20)+WQz*VRR1(11,35)
      VRR0(12,36)=4.D0*r1x2E*VRR0(12,11)+QCx*VRR0(12,21)+2.D0*HfxZpE*VRR1(6,21)-4.D0*r1x2E*ZxZpE*VRR1(12,11)+WQx*VRR1(12,21)
      VRR0(12,37)=3.D0*V(22)-3.D0*V(23)+QCx*VRR0(12,22)+2.D0*HfxZpE*VRR1(6,22)+WQx*VRR1(12,22)
      VRR0(12,38)=2.D0*V(24)+V(26)-2.D0*V(27)+QCx*VRR0(12,23)+WQx*VRR1(12,23)
      VRR0(12,39)=V(4)+2.D0*V(22)-2.D0*V(23)+QCy*VRR0(12,23)+WQy*VRR1(12,23)
      VRR0(12,40)=3.D0*V(24)-3.D0*V(27)+QCy*VRR0(12,24)+HfxZpE*VRR1(5,24)+WQy*VRR1(12,24)
      VRR0(12,41)=4.D0*r1x2E*VRR0(12,14)+QCy*VRR0(12,25)+HfxZpE*VRR1(5,25)-4.D0*r1x2E*ZxZpE*VRR1(12,14)+WQy*VRR1(12,25)
      VRR0(12,42)=3.D0*V(28)-3.D0*V(29)+QCx*VRR0(12,26)+2.D0*HfxZpE*VRR1(6,26)+WQx*VRR1(12,26)
      VRR0(12,43)=V(31)+V(33)+QCx*VRR0(12,27)+2.D0*HfxZpE*VRR1(6,27)+WQx*VRR1(12,27)
      VRR0(12,44)=V(34)+V(36)-V(37)+QCx*VRR0(12,28)+WQx*VRR1(12,28)
      VRR0(12,45)=V(12)+V(31)+V(33)+QCy*VRR0(12,28)+WQy*VRR1(12,28)
      VRR0(12,46)=3.D0*V(34)-3.D0*V(37)+QCy*VRR0(12,29)+HfxZpE*VRR1(5,29)+WQy*VRR1(12,29)
      VRR0(12,47)=2.D0*V(38)+2.D0*V(39)-2.D0*V(40)+QCx*VRR0(12,30)+WQx*VRR1(12,30)
      VRR0(12,48)=V(41)+V(43)-V(44)+QCx*VRR0(12,31)+WQx*VRR1(12,31)
      VRR0(12,49)=V(18)+V(38)-V(40)+QCy*VRR0(12,31)+WQy*VRR1(12,31)
      VRR0(12,50)=V(19)+2.D0*V(41)-2.D0*V(44)+QCy*VRR0(12,32)+WQy*VRR1(12,32)
      VRR0(12,51)=2.D0*V(28)-2.D0*V(29)+QCz*VRR0(12,30)+WQz*VRR1(12,30)
      VRR0(12,52)=V(31)+V(33)+QCz*VRR0(12,31)+WQz*VRR1(12,31)
      VRR0(12,53)=2.D0*V(34)-2.D0*V(37)+QCz*VRR0(12,32)+WQz*VRR1(12,32)
      VRR0(12,54)=3.D0*V(38)-3.D0*V(40)+QCz*VRR0(12,33)+WQz*VRR1(12,33)
      VRR0(12,55)=3.D0*V(41)-3.D0*V(44)+QCz*VRR0(12,34)+WQz*VRR1(12,34)
      VRR0(12,56)=4.D0*r1x2E*VRR0(12,20)+QCz*VRR0(12,35)-4.D0*r1x2E*ZxZpE*VRR1(12,20)+WQz*VRR1(12,35)
      VRR0(13,36)=4.D0*r1x2E*VRR0(13,11)+QCx*VRR0(13,21)+HfxZpE*VRR1(7,21)-4.D0*r1x2E*ZxZpE*VRR1(13,11)+WQx*VRR1(13,21)
      VRR0(13,37)=3.D0*V(45)-3.D0*V(46)+QCx*VRR0(13,22)+HfxZpE*VRR1(7,22)+WQx*VRR1(13,22)
      VRR0(13,38)=2.D0*V(47)+V(48)-2.D0*V(49)+QCx*VRR0(13,23)+WQx*VRR1(13,23)
      VRR0(13,39)=V(26)+2.D0*V(45)-2.D0*V(46)+QCy*VRR0(13,23)+WQy*VRR1(13,23)
      VRR0(13,40)=3.D0*V(47)-3.D0*V(49)+QCy*VRR0(13,24)+2.D0*HfxZpE*VRR1(6,24)+WQy*VRR1(13,24)
      VRR0(13,41)=4.D0*r1x2E*VRR0(13,14)+QCy*VRR0(13,25)+2.D0*HfxZpE*VRR1(6,25)-4.D0*r1x2E*ZxZpE*VRR1(13,14)+WQy*VRR1(13,25)
      VRR0(13,42)=3.D0*V(50)-3.D0*V(51)+QCx*VRR0(13,26)+HfxZpE*VRR1(7,26)+WQx*VRR1(13,26)
      VRR0(13,43)=V(53)+V(54)+V(56)+QCx*VRR0(13,27)+WQx*VRR1(13,27)
      VRR0(13,44)=V(57)+V(58)-V(59)+QCx*VRR0(13,28)+WQx*VRR1(13,28)
      VRR0(13,45)=V(36)+V(53)+V(56)+QCy*VRR0(13,28)+WQy*VRR1(13,28)
      VRR0(13,46)=3.D0*V(57)-3.D0*V(59)+QCy*VRR0(13,29)+2.D0*HfxZpE*VRR1(6,29)+WQy*VRR1(13,29)
      VRR0(13,47)=2.D0*V(60)+V(61)-2.D0*V(62)+QCx*VRR0(13,30)+WQx*VRR1(13,30)
      VRR0(13,48)=V(63)+V(64)-V(65)+QCx*VRR0(13,31)+WQx*VRR1(13,31)
      VRR0(13,49)=V(43)+V(60)-V(62)+QCy*VRR0(13,31)+WQy*VRR1(13,31)
      VRR0(13,50)=2.D0*V(63)-2.D0*V(65)+2.D0*V(66)+QCy*VRR0(13,32)+WQy*VRR1(13,32)
      VRR0(13,51)=2.D0*V(50)-2.D0*V(51)+QCz*VRR0(13,30)+WQz*VRR1(13,30)
      VRR0(13,52)=V(53)+V(56)+QCz*VRR0(13,31)+WQz*VRR1(13,31)
      VRR0(13,53)=2.D0*V(57)-2.D0*V(59)+QCz*VRR0(13,32)+WQz*VRR1(13,32)
      VRR0(13,54)=3.D0*V(60)-3.D0*V(62)+QCz*VRR0(13,33)+WQz*VRR1(13,33)
      VRR0(13,55)=3.D0*V(63)-3.D0*V(65)+QCz*VRR0(13,34)+WQz*VRR1(13,34)
      VRR0(13,56)=4.D0*r1x2E*VRR0(13,20)+QCz*VRR0(13,35)-4.D0*r1x2E*ZxZpE*VRR1(13,20)+WQz*VRR1(13,35)
      VRR0(14,36)=4.D0*r1x2E*VRR0(14,11)+QCx*VRR0(14,21)-4.D0*r1x2E*ZxZpE*VRR1(14,11)+WQx*VRR1(14,21)
      VRR0(14,37)=3.D0*V(67)-3.D0*V(68)+QCx*VRR0(14,22)+WQx*VRR1(14,22)
      VRR0(14,38)=2.D0*V(69)-2.D0*V(70)+QCx*VRR0(14,23)+WQx*VRR1(14,23)
      VRR0(14,39)=3.D0*V(48)+2.D0*V(67)-2.D0*V(68)+QCy*VRR0(14,23)+WQy*VRR1(14,23)
      VRR0(14,40)=3.D0*V(69)-3.D0*V(70)+QCy*VRR0(14,24)+3.D0*HfxZpE*VRR1(7,24)+WQy*VRR1(14,24)
      VRR0(14,41)=4.D0*r1x2E*VRR0(14,14)+QCy*VRR0(14,25)+3.D0*HfxZpE*VRR1(7,25)-4.D0*r1x2E*ZxZpE*VRR1(14,14)+WQy*VRR1(14,25)
      VRR0(14,42)=3.D0*V(71)-3.D0*V(72)+QCx*VRR0(14,26)+WQx*VRR1(14,26)
      VRR0(14,43)=V(74)+V(76)+QCx*VRR0(14,27)+WQx*VRR1(14,27)
      VRR0(14,44)=2.D0*V(54)+2.D0*r1x2Z*VRR0(3,44)+PAy*VRR0(7,44)-2.D0*ExZpE*r1x2Z*VRR1(3,44)+WPy*VRR1(7,44)
      VRR0(14,45)=3.D0*V(58)+V(74)+V(76)+QCy*VRR0(14,28)+WQy*VRR1(14,28)
      VRR0(14,46)=3.D0*V(77)-3.D0*V(78)+QCy*VRR0(14,29)+3.D0*HfxZpE*VRR1(7,29)+WQy*VRR1(14,29)
      VRR0(14,47)=2.D0*V(79)-2.D0*V(80)+QCx*VRR0(14,30)+WQx*VRR1(14,30)
      VRR0(14,48)=V(61)+2.D0*r1x2Z*VRR0(3,48)+PAy*VRR0(7,48)-2.D0*ExZpE*r1x2Z*VRR1(3,48)+WPy*VRR1(7,48)
      VRR0(14,49)=2.D0*V(64)+2.D0*r1x2Z*VRR0(3,49)+PAy*VRR0(7,49)-2.D0*ExZpE*r1x2Z*VRR1(3,49)+WPy*VRR1(7,49)
      VRR0(14,50)=2.D0*V(81)+3.D0*V(82)-2.D0*V(83)+QCy*VRR0(14,32)+WQy*VRR1(14,32)
      VRR0(14,51)=2.D0*V(71)-2.D0*V(72)+QCz*VRR0(14,30)+WQz*VRR1(14,30)
      VRR0(14,52)=V(74)+V(76)+QCz*VRR0(14,31)+WQz*VRR1(14,31)
      VRR0(14,53)=2.D0*V(77)-2.D0*V(78)+QCz*VRR0(14,32)+WQz*VRR1(14,32)
      VRR0(14,54)=3.D0*V(79)-3.D0*V(80)+QCz*VRR0(14,33)+WQz*VRR1(14,33)
      VRR0(14,55)=3.D0*V(81)-3.D0*V(83)+QCz*VRR0(14,34)+WQz*VRR1(14,34)
      VRR0(14,56)=4.D0*r1x2E*VRR0(14,20)+QCz*VRR0(14,35)-4.D0*r1x2E*ZxZpE*VRR1(14,20)+WQz*VRR1(14,35)
      VRR0(15,36)=4.D0*r1x2E*VRR0(15,11)+QCx*VRR0(15,21)+2.D0*HfxZpE*VRR1(8,21)-4.D0*r1x2E*ZxZpE*VRR1(15,11)+WQx*VRR1(15,21)
      VRR0(15,37)=3.D0*V(84)-3.D0*V(85)+QCx*VRR0(15,22)+2.D0*HfxZpE*VRR1(8,22)+WQx*VRR1(15,22)
      VRR0(15,38)=2.D0*V(86)+2.D0*V(87)-2.D0*V(88)+QCx*VRR0(15,23)+WQx*VRR1(15,23)
      VRR0(15,39)=2.D0*V(84)-2.D0*V(85)+QCy*VRR0(15,23)+WQy*VRR1(15,23)
      VRR0(15,40)=3.D0*V(86)-3.D0*V(88)+QCy*VRR0(15,24)+WQy*VRR1(15,24)
      VRR0(15,41)=4.D0*r1x2E*VRR0(15,14)+QCy*VRR0(15,25)-4.D0*r1x2E*ZxZpE*VRR1(15,14)+WQy*VRR1(15,25)
      VRR0(15,42)=3.D0*V(89)-3.D0*V(90)+QCx*VRR0(15,26)+2.D0*HfxZpE*VRR1(8,26)+WQx*VRR1(15,26)
      VRR0(15,43)=V(92)+V(94)+QCx*VRR0(15,27)+2.D0*HfxZpE*VRR1(8,27)+WQx*VRR1(15,27)
      VRR0(15,44)=V(95)+2.D0*V(96)-V(97)+QCx*VRR0(15,28)+WQx*VRR1(15,28)
      VRR0(15,45)=V(92)+V(94)+QCy*VRR0(15,28)+WQy*VRR1(15,28)
      VRR0(15,46)=3.D0*V(95)-3.D0*V(97)+QCy*VRR0(15,29)+WQy*VRR1(15,29)
      VRR0(15,47)=2.D0*V(98)+V(100)-2.D0*V(101)+QCx*VRR0(15,30)+WQx*VRR1(15,30)
      VRR0(15,48)=V(102)+V(104)-V(105)+QCx*VRR0(15,31)+WQx*VRR1(15,31)
      VRR0(15,49)=V(98)-V(101)+QCy*VRR0(15,31)+WQy*VRR1(15,31)
      VRR0(15,50)=2.D0*V(102)-2.D0*V(105)+QCy*VRR0(15,32)+WQy*VRR1(15,32)
      VRR0(15,51)=V(16)+2.D0*V(89)-2.D0*V(90)+QCz*VRR0(15,30)+WQz*VRR1(15,30)
      VRR0(15,52)=V(18)+V(92)+V(94)+QCz*VRR0(15,31)+WQz*VRR1(15,31)
      VRR0(15,53)=V(19)+2.D0*V(95)-2.D0*V(97)+QCz*VRR0(15,32)+WQz*VRR1(15,32)
      VRR0(15,54)=3.D0*V(98)-3.D0*V(101)+QCz*VRR0(15,33)+HfxZpE*VRR1(5,33)+WQz*VRR1(15,33)
      VRR0(15,55)=3.D0*V(102)-3.D0*V(105)+QCz*VRR0(15,34)+HfxZpE*VRR1(5,34)+WQz*VRR1(15,34)
      VRR0(15,56)=4.D0*r1x2E*VRR0(15,20)+QCz*VRR0(15,35)+HfxZpE*VRR1(5,35)-4.D0*r1x2E*ZxZpE*VRR1(15,20)+WQz*VRR1(15,35)
      VRR0(16,36)=4.D0*r1x2E*VRR0(16,11)+QCx*VRR0(16,21)+HfxZpE*VRR1(9,21)-4.D0*r1x2E*ZxZpE*VRR1(16,11)+WQx*VRR1(16,21)
      VRR0(16,37)=3.D0*V(106)-3.D0*V(107)+QCx*VRR0(16,22)+HfxZpE*VRR1(9,22)+WQx*VRR1(16,22)
      VRR0(16,38)=2.D0*V(108)+V(109)-2.D0*V(110)+QCx*VRR0(16,23)+WQx*VRR1(16,23)
      VRR0(16,39)=V(87)+2.D0*V(106)-2.D0*V(107)+QCy*VRR0(16,23)+WQy*VRR1(16,23)
      VRR0(16,40)=3.D0*V(108)-3.D0*V(110)+QCy*VRR0(16,24)+HfxZpE*VRR1(8,24)+WQy*VRR1(16,24)
      VRR0(16,41)=4.D0*r1x2E*VRR0(16,14)+QCy*VRR0(16,25)+HfxZpE*VRR1(8,25)-4.D0*r1x2E*ZxZpE*VRR1(16,14)+WQy*VRR1(16,25)
      VRR0(16,42)=3.D0*V(111)-3.D0*V(112)+QCx*VRR0(16,26)+HfxZpE*VRR1(9,26)+WQx*VRR1(16,26)
      VRR0(16,43)=V(114)+V(116)+QCx*VRR0(16,27)+HfxZpE*VRR1(9,27)+WQx*VRR1(16,27)
      VRR0(16,44)=V(117)+V(118)-V(119)+QCx*VRR0(16,28)+WQx*VRR1(16,28)
      VRR0(16,45)=V(96)+V(114)+V(116)+QCy*VRR0(16,28)+WQy*VRR1(16,28)
      VRR0(16,46)=3.D0*V(117)-3.D0*V(119)+QCy*VRR0(16,29)+HfxZpE*VRR1(8,29)+WQy*VRR1(16,29)
      VRR0(16,47)=2.D0*V(120)+V(121)-2.D0*V(122)+QCx*VRR0(16,30)+WQx*VRR1(16,30)
      VRR0(16,48)=V(123)+V(124)-V(125)+QCx*VRR0(16,31)+WQx*VRR1(16,31)
      VRR0(16,49)=V(103)+V(120)-V(122)+QCy*VRR0(16,31)+WQy*VRR1(16,31)
      VRR0(16,50)=2.D0*V(123)-2.D0*V(125)+V(126)+QCy*VRR0(16,32)+WQy*VRR1(16,32)
      VRR0(16,51)=V(39)+2.D0*V(111)-2.D0*V(112)+QCz*VRR0(16,30)+WQz*VRR1(16,30)
      VRR0(16,52)=V(42)+V(114)+V(116)+QCz*VRR0(16,31)+WQz*VRR1(16,31)
      VRR0(16,53)=V(66)+2.D0*V(117)-2.D0*V(119)+QCz*VRR0(16,32)+WQz*VRR1(16,32)
      VRR0(16,54)=3.D0*V(120)-3.D0*V(122)+QCz*VRR0(16,33)+HfxZpE*VRR1(6,33)+WQz*VRR1(16,33)
      VRR0(16,55)=3.D0*V(123)-3.D0*V(125)+QCz*VRR0(16,34)+HfxZpE*VRR1(6,34)+WQz*VRR1(16,34)
      VRR0(16,56)=4.D0*r1x2E*VRR0(16,20)+QCz*VRR0(16,35)+HfxZpE*VRR1(6,35)-4.D0*r1x2E*ZxZpE*VRR1(16,20)+WQz*VRR1(16,35)
      VRR0(17,36)=4.D0*r1x2E*VRR0(17,11)+QCx*VRR0(17,21)-4.D0*r1x2E*ZxZpE*VRR1(17,11)+WQx*VRR1(17,21)
      VRR0(17,37)=3.D0*V(127)-3.D0*V(128)+QCx*VRR0(17,22)+WQx*VRR1(17,22)
      VRR0(17,38)=2.D0*V(129)-2.D0*V(130)+QCx*VRR0(17,23)+WQx*VRR1(17,23)
      VRR0(17,39)=2.D0*V(109)+2.D0*V(127)-2.D0*V(128)+QCy*VRR0(17,23)+WQy*VRR1(17,23)
      VRR0(17,40)=3.D0*V(129)-3.D0*V(130)+QCy*VRR0(17,24)+2.D0*HfxZpE*VRR1(9,24)+WQy*VRR1(17,24)
      VRR0(17,41)=4.D0*r1x2E*VRR0(17,14)+QCy*VRR0(17,25)+2.D0*HfxZpE*VRR1(9,25)-4.D0*r1x2E*ZxZpE*VRR1(17,14)+WQy*VRR1(17,25)
      VRR0(17,42)=3.D0*V(131)-3.D0*V(132)+QCx*VRR0(17,26)+WQx*VRR1(17,26)
      VRR0(17,43)=V(134)+V(136)+QCx*VRR0(17,27)+WQx*VRR1(17,27)
      VRR0(17,44)=V(137)-V(138)+QCx*VRR0(17,28)+WQx*VRR1(17,28)
      VRR0(17,45)=2.D0*V(118)+V(134)+V(136)+QCy*VRR0(17,28)+WQy*VRR1(17,28)
      VRR0(17,46)=3.D0*V(137)-3.D0*V(138)+QCy*VRR0(17,29)+2.D0*HfxZpE*VRR1(9,29)+WQy*VRR1(17,29)
      VRR0(17,47)=2.D0*V(139)-2.D0*V(140)+QCx*VRR0(17,30)+WQx*VRR1(17,30)
      VRR0(17,48)=V(141)-V(142)+QCx*VRR0(17,31)+WQx*VRR1(17,31)
      VRR0(17,49)=V(139)-V(140)+V(143)+QCy*VRR0(17,31)+WQy*VRR1(17,31)
      VRR0(17,50)=2.D0*V(141)-2.D0*V(142)+V(145)+QCy*VRR0(17,32)+WQy*VRR1(17,32)
      VRR0(17,51)=V(61)+2.D0*V(131)-2.D0*V(132)+QCz*VRR0(17,30)+WQz*VRR1(17,30)
      VRR0(17,52)=V(64)+V(134)+V(136)+QCz*VRR0(17,31)+WQz*VRR1(17,31)
      VRR0(17,53)=V(82)+2.D0*V(137)-2.D0*V(138)+QCz*VRR0(17,32)+WQz*VRR1(17,32)
      VRR0(17,54)=3.D0*V(139)-3.D0*V(140)+QCz*VRR0(17,33)+HfxZpE*VRR1(7,33)+WQz*VRR1(17,33)
      VRR0(17,55)=3.D0*V(141)-3.D0*V(142)+QCz*VRR0(17,34)+HfxZpE*VRR1(7,34)+WQz*VRR1(17,34)
      VRR0(17,56)=4.D0*r1x2E*VRR0(17,20)+QCz*VRR0(17,35)+HfxZpE*VRR1(7,35)-4.D0*r1x2E*ZxZpE*VRR1(17,20)+WQz*VRR1(17,35)
      VRR0(18,36)=4.D0*r1x2E*VRR0(18,11)+QCx*VRR0(18,21)+HfxZpE*VRR1(10,21)-4.D0*r1x2E*ZxZpE*VRR1(18,11)+WQx*VRR1(18,21)
      VRR0(18,37)=3.D0*V(146)-3.D0*V(147)+QCx*VRR0(18,22)+HfxZpE*VRR1(10,22)+WQx*VRR1(18,22)
      VRR0(18,38)=2.D0*V(148)+V(149)-2.D0*V(150)+QCx*VRR0(18,23)+WQx*VRR1(18,23)
      VRR0(18,39)=2.D0*V(146)-2.D0*V(147)+QCy*VRR0(18,23)+WQy*VRR1(18,23)
      VRR0(18,40)=3.D0*V(148)-3.D0*V(150)+QCy*VRR0(18,24)+WQy*VRR1(18,24)
      VRR0(18,41)=4.D0*r1x2E*VRR0(18,14)+QCy*VRR0(18,25)-4.D0*r1x2E*ZxZpE*VRR1(18,14)+WQy*VRR1(18,25)
      VRR0(18,42)=3.D0*V(151)-3.D0*V(152)+QCx*VRR0(18,26)+HfxZpE*VRR1(10,26)+WQx*VRR1(18,26)
      VRR0(18,43)=V(154)+V(155)+V(157)+QCx*VRR0(18,27)+WQx*VRR1(18,27)
      VRR0(18,44)=V(158)+V(159)-V(160)+QCx*VRR0(18,28)+WQx*VRR1(18,28)
      VRR0(18,45)=V(154)+V(157)+QCy*VRR0(18,28)+WQy*VRR1(18,28)
      VRR0(18,46)=3.D0*V(158)-3.D0*V(160)+QCy*VRR0(18,29)+WQy*VRR1(18,29)
      VRR0(18,47)=2.D0*V(161)+V(162)-2.D0*V(163)+QCx*VRR0(18,30)+WQx*VRR1(18,30)
      VRR0(18,48)=V(164)+V(165)-V(166)+QCx*VRR0(18,31)+WQx*VRR1(18,31)
      VRR0(18,49)=V(161)-V(163)+QCy*VRR0(18,31)+WQy*VRR1(18,31)
      VRR0(18,50)=2.D0*V(164)-2.D0*V(166)+QCy*VRR0(18,32)+WQy*VRR1(18,32)
      VRR0(18,51)=V(100)+2.D0*V(151)-2.D0*V(152)+QCz*VRR0(18,30)+WQz*VRR1(18,30)
      VRR0(18,52)=V(104)+V(154)+V(157)+QCz*VRR0(18,31)+WQz*VRR1(18,31)
      VRR0(18,53)=2.D0*V(126)+2.D0*V(158)-2.D0*V(160)+QCz*VRR0(18,32)+WQz*VRR1(18,32)
      VRR0(18,54)=3.D0*V(161)-3.D0*V(163)+QCz*VRR0(18,33)+2.D0*HfxZpE*VRR1(8,33)+WQz*VRR1(18,33)
      VRR0(18,55)=3.D0*V(164)-3.D0*V(166)+QCz*VRR0(18,34)+2.D0*HfxZpE*VRR1(8,34)+WQz*VRR1(18,34)
      VRR0(18,56)=4.D0*r1x2E*VRR0(18,20)+QCz*VRR0(18,35)+2.D0*HfxZpE*VRR1(8,35)-4.D0*r1x2E*ZxZpE*VRR1(18,20)+WQz*VRR1(18,35)
      VRR0(19,36)=4.D0*r1x2E*VRR0(19,11)+QCx*VRR0(19,21)-4.D0*r1x2E*ZxZpE*VRR1(19,11)+WQx*VRR1(19,21)
      VRR0(19,37)=3.D0*V(167)-3.D0*V(168)+QCx*VRR0(19,22)+WQx*VRR1(19,22)
      VRR0(19,38)=2.D0*V(169)-2.D0*V(170)+QCx*VRR0(19,23)+WQx*VRR1(19,23)
      VRR0(19,39)=V(149)+2.D0*V(167)-2.D0*V(168)+QCy*VRR0(19,23)+WQy*VRR1(19,23)
      VRR0(19,40)=3.D0*V(169)-3.D0*V(170)+QCy*VRR0(19,24)+HfxZpE*VRR1(10,24)+WQy*VRR1(19,24)
      VRR0(19,41)=4.D0*r1x2E*VRR0(19,14)+QCy*VRR0(19,25)+HfxZpE*VRR1(10,25)-4.D0*r1x2E*ZxZpE*VRR1(19,14)+WQy*VRR1(19,25)
      VRR0(19,42)=3.D0*V(171)-3.D0*V(172)+QCx*VRR0(19,26)+WQx*VRR1(19,26)
      VRR0(19,43)=V(174)+V(176)+QCx*VRR0(19,27)+WQx*VRR1(19,27)
      VRR0(19,44)=V(177)-V(178)+QCx*VRR0(19,28)+WQx*VRR1(19,28)
      VRR0(19,45)=V(159)+V(174)+V(176)+QCy*VRR0(19,28)+WQy*VRR1(19,28)
      VRR0(19,46)=3.D0*V(177)-3.D0*V(178)+QCy*VRR0(19,29)+HfxZpE*VRR1(10,29)+WQy*VRR1(19,29)
      VRR0(19,47)=2.D0*V(179)-2.D0*V(180)+QCx*VRR0(19,30)+WQx*VRR1(19,30)
      VRR0(19,48)=V(181)-V(182)+QCx*VRR0(19,31)+WQx*VRR1(19,31)
      VRR0(19,49)=V(165)+V(179)-V(180)+QCy*VRR0(19,31)+WQy*VRR1(19,31)
      VRR0(19,50)=2.D0*V(181)-2.D0*V(182)+V(183)+QCy*VRR0(19,32)+WQy*VRR1(19,32)
      VRR0(19,51)=2.D0*V(121)+2.D0*V(171)-2.D0*V(172)+QCz*VRR0(19,30)+WQz*VRR1(19,30)
      VRR0(19,52)=V(143)+V(174)+V(176)+QCz*VRR0(19,31)+WQz*VRR1(19,31)
      VRR0(19,53)=V(145)+2.D0*V(177)-2.D0*V(178)+QCz*VRR0(19,32)+WQz*VRR1(19,32)
      VRR0(19,54)=3.D0*V(179)-3.D0*V(180)+QCz*VRR0(19,33)+2.D0*HfxZpE*VRR1(9,33)+WQz*VRR1(19,33)
      VRR0(19,55)=3.D0*V(181)-3.D0*V(182)+QCz*VRR0(19,34)+2.D0*HfxZpE*VRR1(9,34)+WQz*VRR1(19,34)
      VRR0(19,56)=4.D0*r1x2E*VRR0(19,20)+QCz*VRR0(19,35)+2.D0*HfxZpE*VRR1(9,35)-4.D0*r1x2E*ZxZpE*VRR1(19,20)+WQz*VRR1(19,35)
      VRR0(20,36)=4.D0*r1x2E*VRR0(20,11)+QCx*VRR0(20,21)-4.D0*r1x2E*ZxZpE*VRR1(20,11)+WQx*VRR1(20,21)
      VRR0(20,37)=3.D0*V(184)-3.D0*V(185)+QCx*VRR0(20,22)+WQx*VRR1(20,22)
      VRR0(20,38)=2.D0*V(186)-2.D0*V(187)+QCx*VRR0(20,23)+WQx*VRR1(20,23)
      VRR0(20,39)=2.D0*V(184)-2.D0*V(185)+QCy*VRR0(20,23)+WQy*VRR1(20,23)
      VRR0(20,40)=3.D0*V(186)-3.D0*V(187)+QCy*VRR0(20,24)+WQy*VRR1(20,24)
      VRR0(20,41)=4.D0*r1x2E*VRR0(20,14)+QCy*VRR0(20,25)-4.D0*r1x2E*ZxZpE*VRR1(20,14)+WQy*VRR1(20,25)
      VRR0(20,42)=3.D0*V(188)-3.D0*V(189)+QCx*VRR0(20,26)+WQx*VRR1(20,26)
      VRR0(20,43)=V(191)+V(193)+QCx*VRR0(20,27)+WQx*VRR1(20,27)
      VRR0(20,44)=V(149)+2.D0*r1x2Z*VRR0(4,44)+PAz*VRR0(10,44)-2.D0*ExZpE*r1x2Z*VRR1(4,44)+WPz*VRR1(10,44)
      VRR0(20,45)=V(191)+V(193)+QCy*VRR0(20,28)+WQy*VRR1(20,28)
      VRR0(20,46)=3.D0*V(194)-3.D0*V(195)+QCy*VRR0(20,29)+WQy*VRR1(20,29)
      VRR0(20,47)=2.D0*V(196)-2.D0*V(197)+QCx*VRR0(20,30)+WQx*VRR1(20,30)
      VRR0(20,48)=2.D0*V(155)+2.D0*r1x2Z*VRR0(4,48)+PAz*VRR0(10,48)-2.D0*ExZpE*r1x2Z*VRR1(4,48)+WPz*VRR1(10,48)
      VRR0(20,49)=2.D0*V(159)+2.D0*r1x2Z*VRR0(4,49)+PAz*VRR0(10,49)-2.D0*ExZpE*r1x2Z*VRR1(4,49)+WPz*VRR1(10,49)
      VRR0(20,50)=2.D0*V(198)-2.D0*V(199)+QCy*VRR0(20,32)+WQy*VRR1(20,32)
      VRR0(20,51)=3.D0*V(162)+2.D0*V(188)-2.D0*V(189)+QCz*VRR0(20,30)+WQz*VRR1(20,30)
      VRR0(20,52)=3.D0*V(165)+V(191)+V(193)+QCz*VRR0(20,31)+WQz*VRR1(20,31)
      VRR0(20,53)=3.D0*V(183)+2.D0*V(194)-2.D0*V(195)+QCz*VRR0(20,32)+WQz*VRR1(20,32)
      VRR0(20,54)=3.D0*V(196)-3.D0*V(197)+QCz*VRR0(20,33)+3.D0*HfxZpE*VRR1(10,33)+WQz*VRR1(20,33)
      VRR0(20,55)=3.D0*V(198)-3.D0*V(199)+QCz*VRR0(20,34)+3.D0*HfxZpE*VRR1(10,34)+WQz*VRR1(20,34)
      VRR0(20,56)=4.D0*r1x2E*VRR0(20,20)+QCz*VRR0(20,35)+3.D0*HfxZpE*VRR1(10,35)-4.D0*r1x2E*ZxZpE*VRR1(20,20)+WQz*VRR1(20,35)
END SUBROUTINE VRRf0h0
SUBROUTINE MVRRf0h0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(11,36)=QCx*VS0(11,21)+WQx*VS1(11,21)-r1x2E*VR1(11,21)&
   +4D0*r1x2E*(VS0(11,11)-ZxZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(5,21)
VS0(11,37)=QCx*VS0(11,22)+WQx*VS1(11,22)-r1x2E*VR1(11,22)&
   +3D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))&
   +3D0*HfxZpE*VS1(5,22)
VS0(11,38)=QCx*VS0(11,23)+WQx*VS1(11,23)-r1x2E*VR1(11,23)&
   +2D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))&
   +3D0*HfxZpE*VS1(5,23)
VS0(11,39)=QCy*VS0(11,23)+WQy*VS1(11,23)&
   +2D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))
VS0(11,40)=QCy*VS0(11,24)+WQy*VS1(11,24)&
   +3D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))
VS0(11,41)=QCy*VS0(11,25)+WQy*VS1(11,25)&
   +4D0*r1x2E*(VS0(11,14)-ZxZpE*VS1(11,14))
VS0(11,42)=QCx*VS0(11,26)+WQx*VS1(11,26)-r1x2E*VR1(11,26)&
   +3D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))&
   +3D0*HfxZpE*VS1(5,26)
VS0(11,43)=QCx*VS0(11,27)+WQx*VS1(11,27)-r1x2E*VR1(11,27)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))&
   +3D0*HfxZpE*VS1(5,27)
VS0(11,44)=QCx*VS0(11,28)+WQx*VS1(11,28)-r1x2E*VR1(11,28)&
   +r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))&
   +3D0*HfxZpE*VS1(5,28)
VS0(11,45)=QCy*VS0(11,28)+WQy*VS1(11,28)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,46)=QCy*VS0(11,29)+WQy*VS1(11,29)&
   +3D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,47)=QCx*VS0(11,30)+WQx*VS1(11,30)-r1x2E*VR1(11,30)&
   +2D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))&
   +3D0*HfxZpE*VS1(5,30)
VS0(11,48)=QCx*VS0(11,31)+WQx*VS1(11,31)-r1x2E*VR1(11,31)&
   +r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))&
   +3D0*HfxZpE*VS1(5,31)
VS0(11,49)=QCy*VS0(11,31)+WQy*VS1(11,31)&
   +r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,50)=QCy*VS0(11,32)+WQy*VS1(11,32)&
   +2D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,51)=QCz*VS0(11,30)+WQz*VS1(11,30)&
   +2D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))
VS0(11,52)=QCz*VS0(11,31)+WQz*VS1(11,31)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,53)=QCz*VS0(11,32)+WQz*VS1(11,32)&
   +2D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,54)=QCz*VS0(11,33)+WQz*VS1(11,33)&
   +3D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,55)=QCz*VS0(11,34)+WQz*VS1(11,34)&
   +3D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,56)=QCz*VS0(11,35)+WQz*VS1(11,35)&
   +4D0*r1x2E*(VS0(11,20)-ZxZpE*VS1(11,20))
VS0(12,36)=QCx*VS0(12,21)+WQx*VS1(12,21)-r1x2E*VR1(12,21)&
   +4D0*r1x2E*(VS0(12,11)-ZxZpE*VS1(12,11))&
   +2D0*HfxZpE*VS1(6,21)
VS0(12,37)=QCx*VS0(12,22)+WQx*VS1(12,22)-r1x2E*VR1(12,22)&
   +3D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(6,22)
VS0(12,38)=QCx*VS0(12,23)+WQx*VS1(12,23)-r1x2E*VR1(12,23)&
   +2D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(6,23)
VS0(12,39)=QCy*VS0(12,23)+WQy*VS1(12,23)&
   +2D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +HfxZpE*VS1(5,23)
VS0(12,40)=QCy*VS0(12,24)+WQy*VS1(12,24)&
   +3D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +HfxZpE*VS1(5,24)
VS0(12,41)=QCy*VS0(12,25)+WQy*VS1(12,25)&
   +4D0*r1x2E*(VS0(12,14)-ZxZpE*VS1(12,14))&
   +HfxZpE*VS1(5,25)
VS0(12,42)=QCx*VS0(12,26)+WQx*VS1(12,26)-r1x2E*VR1(12,26)&
   +3D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(6,26)
VS0(12,43)=QCx*VS0(12,27)+WQx*VS1(12,27)-r1x2E*VR1(12,27)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +2D0*HfxZpE*VS1(6,27)
VS0(12,44)=QCx*VS0(12,28)+WQx*VS1(12,28)-r1x2E*VR1(12,28)&
   +r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(6,28)
VS0(12,45)=QCy*VS0(12,28)+WQy*VS1(12,28)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +HfxZpE*VS1(5,28)
VS0(12,46)=QCy*VS0(12,29)+WQy*VS1(12,29)&
   +3D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +HfxZpE*VS1(5,29)
VS0(12,47)=QCx*VS0(12,30)+WQx*VS1(12,30)-r1x2E*VR1(12,30)&
   +2D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +2D0*HfxZpE*VS1(6,30)
VS0(12,48)=QCx*VS0(12,31)+WQx*VS1(12,31)-r1x2E*VR1(12,31)&
   +r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +2D0*HfxZpE*VS1(6,31)
VS0(12,49)=QCy*VS0(12,31)+WQy*VS1(12,31)&
   +r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +HfxZpE*VS1(5,31)
VS0(12,50)=QCy*VS0(12,32)+WQy*VS1(12,32)&
   +2D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +HfxZpE*VS1(5,32)
VS0(12,51)=QCz*VS0(12,30)+WQz*VS1(12,30)&
   +2D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))
VS0(12,52)=QCz*VS0(12,31)+WQz*VS1(12,31)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))
VS0(12,53)=QCz*VS0(12,32)+WQz*VS1(12,32)&
   +2D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))
VS0(12,54)=QCz*VS0(12,33)+WQz*VS1(12,33)&
   +3D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))
VS0(12,55)=QCz*VS0(12,34)+WQz*VS1(12,34)&
   +3D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))
VS0(12,56)=QCz*VS0(12,35)+WQz*VS1(12,35)&
   +4D0*r1x2E*(VS0(12,20)-ZxZpE*VS1(12,20))
VS0(13,36)=QCx*VS0(13,21)+WQx*VS1(13,21)-r1x2E*VR1(13,21)&
   +4D0*r1x2E*(VS0(13,11)-ZxZpE*VS1(13,11))&
   +HfxZpE*VS1(7,21)
VS0(13,37)=QCx*VS0(13,22)+WQx*VS1(13,22)-r1x2E*VR1(13,22)&
   +3D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +HfxZpE*VS1(7,22)
VS0(13,38)=QCx*VS0(13,23)+WQx*VS1(13,23)-r1x2E*VR1(13,23)&
   +2D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +HfxZpE*VS1(7,23)
VS0(13,39)=QCy*VS0(13,23)+WQy*VS1(13,23)&
   +2D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(6,23)
VS0(13,40)=QCy*VS0(13,24)+WQy*VS1(13,24)&
   +3D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(6,24)
VS0(13,41)=QCy*VS0(13,25)+WQy*VS1(13,25)&
   +4D0*r1x2E*(VS0(13,14)-ZxZpE*VS1(13,14))&
   +2D0*HfxZpE*VS1(6,25)
VS0(13,42)=QCx*VS0(13,26)+WQx*VS1(13,26)-r1x2E*VR1(13,26)&
   +3D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))&
   +HfxZpE*VS1(7,26)
VS0(13,43)=QCx*VS0(13,27)+WQx*VS1(13,27)-r1x2E*VR1(13,27)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +HfxZpE*VS1(7,27)
VS0(13,44)=QCx*VS0(13,28)+WQx*VS1(13,28)-r1x2E*VR1(13,28)&
   +r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +HfxZpE*VS1(7,28)
VS0(13,45)=QCy*VS0(13,28)+WQy*VS1(13,28)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +2D0*HfxZpE*VS1(6,28)
VS0(13,46)=QCy*VS0(13,29)+WQy*VS1(13,29)&
   +3D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(6,29)
VS0(13,47)=QCx*VS0(13,30)+WQx*VS1(13,30)-r1x2E*VR1(13,30)&
   +2D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +HfxZpE*VS1(7,30)
VS0(13,48)=QCx*VS0(13,31)+WQx*VS1(13,31)-r1x2E*VR1(13,31)&
   +r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +HfxZpE*VS1(7,31)
VS0(13,49)=QCy*VS0(13,31)+WQy*VS1(13,31)&
   +r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +2D0*HfxZpE*VS1(6,31)
VS0(13,50)=QCy*VS0(13,32)+WQy*VS1(13,32)&
   +2D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +2D0*HfxZpE*VS1(6,32)
VS0(13,51)=QCz*VS0(13,30)+WQz*VS1(13,30)&
   +2D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))
VS0(13,52)=QCz*VS0(13,31)+WQz*VS1(13,31)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))
VS0(13,53)=QCz*VS0(13,32)+WQz*VS1(13,32)&
   +2D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))
VS0(13,54)=QCz*VS0(13,33)+WQz*VS1(13,33)&
   +3D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))
VS0(13,55)=QCz*VS0(13,34)+WQz*VS1(13,34)&
   +3D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))
VS0(13,56)=QCz*VS0(13,35)+WQz*VS1(13,35)&
   +4D0*r1x2E*(VS0(13,20)-ZxZpE*VS1(13,20))
VS0(14,36)=QCx*VS0(14,21)+WQx*VS1(14,21)-r1x2E*VR1(14,21)&
   +4D0*r1x2E*(VS0(14,11)-ZxZpE*VS1(14,11))
VS0(14,37)=QCx*VS0(14,22)+WQx*VS1(14,22)-r1x2E*VR1(14,22)&
   +3D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))
VS0(14,38)=QCx*VS0(14,23)+WQx*VS1(14,23)-r1x2E*VR1(14,23)&
   +2D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))
VS0(14,39)=QCy*VS0(14,23)+WQy*VS1(14,23)&
   +2D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))&
   +3D0*HfxZpE*VS1(7,23)
VS0(14,40)=QCy*VS0(14,24)+WQy*VS1(14,24)&
   +3D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))&
   +3D0*HfxZpE*VS1(7,24)
VS0(14,41)=QCy*VS0(14,25)+WQy*VS1(14,25)&
   +4D0*r1x2E*(VS0(14,14)-ZxZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(7,25)
VS0(14,42)=QCx*VS0(14,26)+WQx*VS1(14,26)-r1x2E*VR1(14,26)&
   +3D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,43)=QCx*VS0(14,27)+WQx*VS1(14,27)-r1x2E*VR1(14,27)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,44)=QCx*VS0(14,28)+WQx*VS1(14,28)-r1x2E*VR1(14,28)&
   +r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,45)=QCy*VS0(14,28)+WQy*VS1(14,28)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))&
   +3D0*HfxZpE*VS1(7,28)
VS0(14,46)=QCy*VS0(14,29)+WQy*VS1(14,29)&
   +3D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))&
   +3D0*HfxZpE*VS1(7,29)
VS0(14,47)=QCx*VS0(14,30)+WQx*VS1(14,30)-r1x2E*VR1(14,30)&
   +2D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,48)=QCx*VS0(14,31)+WQx*VS1(14,31)-r1x2E*VR1(14,31)&
   +r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,49)=QCy*VS0(14,31)+WQy*VS1(14,31)&
   +r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))&
   +3D0*HfxZpE*VS1(7,31)
VS0(14,50)=QCy*VS0(14,32)+WQy*VS1(14,32)&
   +2D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))&
   +3D0*HfxZpE*VS1(7,32)
VS0(14,51)=QCz*VS0(14,30)+WQz*VS1(14,30)&
   +2D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,52)=QCz*VS0(14,31)+WQz*VS1(14,31)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,53)=QCz*VS0(14,32)+WQz*VS1(14,32)&
   +2D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,54)=QCz*VS0(14,33)+WQz*VS1(14,33)&
   +3D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,55)=QCz*VS0(14,34)+WQz*VS1(14,34)&
   +3D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,56)=QCz*VS0(14,35)+WQz*VS1(14,35)&
   +4D0*r1x2E*(VS0(14,20)-ZxZpE*VS1(14,20))
VS0(15,36)=QCx*VS0(15,21)+WQx*VS1(15,21)-r1x2E*VR1(15,21)&
   +4D0*r1x2E*(VS0(15,11)-ZxZpE*VS1(15,11))&
   +2D0*HfxZpE*VS1(8,21)
VS0(15,37)=QCx*VS0(15,22)+WQx*VS1(15,22)-r1x2E*VR1(15,22)&
   +3D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(8,22)
VS0(15,38)=QCx*VS0(15,23)+WQx*VS1(15,23)-r1x2E*VR1(15,23)&
   +2D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))&
   +2D0*HfxZpE*VS1(8,23)
VS0(15,39)=QCy*VS0(15,23)+WQy*VS1(15,23)&
   +2D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))
VS0(15,40)=QCy*VS0(15,24)+WQy*VS1(15,24)&
   +3D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))
VS0(15,41)=QCy*VS0(15,25)+WQy*VS1(15,25)&
   +4D0*r1x2E*(VS0(15,14)-ZxZpE*VS1(15,14))
VS0(15,42)=QCx*VS0(15,26)+WQx*VS1(15,26)-r1x2E*VR1(15,26)&
   +3D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(8,26)
VS0(15,43)=QCx*VS0(15,27)+WQx*VS1(15,27)-r1x2E*VR1(15,27)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +2D0*HfxZpE*VS1(8,27)
VS0(15,44)=QCx*VS0(15,28)+WQx*VS1(15,28)-r1x2E*VR1(15,28)&
   +r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +2D0*HfxZpE*VS1(8,28)
VS0(15,45)=QCy*VS0(15,28)+WQy*VS1(15,28)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))
VS0(15,46)=QCy*VS0(15,29)+WQy*VS1(15,29)&
   +3D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))
VS0(15,47)=QCx*VS0(15,30)+WQx*VS1(15,30)-r1x2E*VR1(15,30)&
   +2D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(8,30)
VS0(15,48)=QCx*VS0(15,31)+WQx*VS1(15,31)-r1x2E*VR1(15,31)&
   +r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(8,31)
VS0(15,49)=QCy*VS0(15,31)+WQy*VS1(15,31)&
   +r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))
VS0(15,50)=QCy*VS0(15,32)+WQy*VS1(15,32)&
   +2D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))
VS0(15,51)=QCz*VS0(15,30)+WQz*VS1(15,30)&
   +2D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +HfxZpE*VS1(5,30)
VS0(15,52)=QCz*VS0(15,31)+WQz*VS1(15,31)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +HfxZpE*VS1(5,31)
VS0(15,53)=QCz*VS0(15,32)+WQz*VS1(15,32)&
   +2D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +HfxZpE*VS1(5,32)
VS0(15,54)=QCz*VS0(15,33)+WQz*VS1(15,33)&
   +3D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +HfxZpE*VS1(5,33)
VS0(15,55)=QCz*VS0(15,34)+WQz*VS1(15,34)&
   +3D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +HfxZpE*VS1(5,34)
VS0(15,56)=QCz*VS0(15,35)+WQz*VS1(15,35)&
   +4D0*r1x2E*(VS0(15,20)-ZxZpE*VS1(15,20))&
   +HfxZpE*VS1(5,35)
VS0(16,36)=QCx*VS0(16,21)+WQx*VS1(16,21)-r1x2E*VR1(16,21)&
   +4D0*r1x2E*(VS0(16,11)-ZxZpE*VS1(16,11))&
   +HfxZpE*VS1(9,21)
VS0(16,37)=QCx*VS0(16,22)+WQx*VS1(16,22)-r1x2E*VR1(16,22)&
   +3D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(9,22)
VS0(16,38)=QCx*VS0(16,23)+WQx*VS1(16,23)-r1x2E*VR1(16,23)&
   +2D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(9,23)
VS0(16,39)=QCy*VS0(16,23)+WQy*VS1(16,23)&
   +2D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(8,23)
VS0(16,40)=QCy*VS0(16,24)+WQy*VS1(16,24)&
   +3D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(8,24)
VS0(16,41)=QCy*VS0(16,25)+WQy*VS1(16,25)&
   +4D0*r1x2E*(VS0(16,14)-ZxZpE*VS1(16,14))&
   +HfxZpE*VS1(8,25)
VS0(16,42)=QCx*VS0(16,26)+WQx*VS1(16,26)-r1x2E*VR1(16,26)&
   +3D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(9,26)
VS0(16,43)=QCx*VS0(16,27)+WQx*VS1(16,27)-r1x2E*VR1(16,27)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(9,27)
VS0(16,44)=QCx*VS0(16,28)+WQx*VS1(16,28)-r1x2E*VR1(16,28)&
   +r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(9,28)
VS0(16,45)=QCy*VS0(16,28)+WQy*VS1(16,28)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(8,28)
VS0(16,46)=QCy*VS0(16,29)+WQy*VS1(16,29)&
   +3D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(8,29)
VS0(16,47)=QCx*VS0(16,30)+WQx*VS1(16,30)-r1x2E*VR1(16,30)&
   +2D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(9,30)
VS0(16,48)=QCx*VS0(16,31)+WQx*VS1(16,31)-r1x2E*VR1(16,31)&
   +r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(9,31)
VS0(16,49)=QCy*VS0(16,31)+WQy*VS1(16,31)&
   +r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(8,31)
VS0(16,50)=QCy*VS0(16,32)+WQy*VS1(16,32)&
   +2D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(8,32)
VS0(16,51)=QCz*VS0(16,30)+WQz*VS1(16,30)&
   +2D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(6,30)
VS0(16,52)=QCz*VS0(16,31)+WQz*VS1(16,31)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(6,31)
VS0(16,53)=QCz*VS0(16,32)+WQz*VS1(16,32)&
   +2D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(6,32)
VS0(16,54)=QCz*VS0(16,33)+WQz*VS1(16,33)&
   +3D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(6,33)
VS0(16,55)=QCz*VS0(16,34)+WQz*VS1(16,34)&
   +3D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(6,34)
VS0(16,56)=QCz*VS0(16,35)+WQz*VS1(16,35)&
   +4D0*r1x2E*(VS0(16,20)-ZxZpE*VS1(16,20))&
   +HfxZpE*VS1(6,35)
VS0(17,36)=QCx*VS0(17,21)+WQx*VS1(17,21)-r1x2E*VR1(17,21)&
   +4D0*r1x2E*(VS0(17,11)-ZxZpE*VS1(17,11))
VS0(17,37)=QCx*VS0(17,22)+WQx*VS1(17,22)-r1x2E*VR1(17,22)&
   +3D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))
VS0(17,38)=QCx*VS0(17,23)+WQx*VS1(17,23)-r1x2E*VR1(17,23)&
   +2D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))
VS0(17,39)=QCy*VS0(17,23)+WQy*VS1(17,23)&
   +2D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(9,23)
VS0(17,40)=QCy*VS0(17,24)+WQy*VS1(17,24)&
   +3D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(9,24)
VS0(17,41)=QCy*VS0(17,25)+WQy*VS1(17,25)&
   +4D0*r1x2E*(VS0(17,14)-ZxZpE*VS1(17,14))&
   +2D0*HfxZpE*VS1(9,25)
VS0(17,42)=QCx*VS0(17,26)+WQx*VS1(17,26)-r1x2E*VR1(17,26)&
   +3D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))
VS0(17,43)=QCx*VS0(17,27)+WQx*VS1(17,27)-r1x2E*VR1(17,27)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))
VS0(17,44)=QCx*VS0(17,28)+WQx*VS1(17,28)-r1x2E*VR1(17,28)&
   +r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))
VS0(17,45)=QCy*VS0(17,28)+WQy*VS1(17,28)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +2D0*HfxZpE*VS1(9,28)
VS0(17,46)=QCy*VS0(17,29)+WQy*VS1(17,29)&
   +3D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(9,29)
VS0(17,47)=QCx*VS0(17,30)+WQx*VS1(17,30)-r1x2E*VR1(17,30)&
   +2D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))
VS0(17,48)=QCx*VS0(17,31)+WQx*VS1(17,31)-r1x2E*VR1(17,31)&
   +r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))
VS0(17,49)=QCy*VS0(17,31)+WQy*VS1(17,31)&
   +r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(9,31)
VS0(17,50)=QCy*VS0(17,32)+WQy*VS1(17,32)&
   +2D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(9,32)
VS0(17,51)=QCz*VS0(17,30)+WQz*VS1(17,30)&
   +2D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))&
   +HfxZpE*VS1(7,30)
VS0(17,52)=QCz*VS0(17,31)+WQz*VS1(17,31)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +HfxZpE*VS1(7,31)
VS0(17,53)=QCz*VS0(17,32)+WQz*VS1(17,32)&
   +2D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +HfxZpE*VS1(7,32)
VS0(17,54)=QCz*VS0(17,33)+WQz*VS1(17,33)&
   +3D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +HfxZpE*VS1(7,33)
VS0(17,55)=QCz*VS0(17,34)+WQz*VS1(17,34)&
   +3D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +HfxZpE*VS1(7,34)
VS0(17,56)=QCz*VS0(17,35)+WQz*VS1(17,35)&
   +4D0*r1x2E*(VS0(17,20)-ZxZpE*VS1(17,20))&
   +HfxZpE*VS1(7,35)
VS0(18,36)=QCx*VS0(18,21)+WQx*VS1(18,21)-r1x2E*VR1(18,21)&
   +4D0*r1x2E*(VS0(18,11)-ZxZpE*VS1(18,11))&
   +HfxZpE*VS1(10,21)
VS0(18,37)=QCx*VS0(18,22)+WQx*VS1(18,22)-r1x2E*VR1(18,22)&
   +3D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))&
   +HfxZpE*VS1(10,22)
VS0(18,38)=QCx*VS0(18,23)+WQx*VS1(18,23)-r1x2E*VR1(18,23)&
   +2D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))&
   +HfxZpE*VS1(10,23)
VS0(18,39)=QCy*VS0(18,23)+WQy*VS1(18,23)&
   +2D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))
VS0(18,40)=QCy*VS0(18,24)+WQy*VS1(18,24)&
   +3D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))
VS0(18,41)=QCy*VS0(18,25)+WQy*VS1(18,25)&
   +4D0*r1x2E*(VS0(18,14)-ZxZpE*VS1(18,14))
VS0(18,42)=QCx*VS0(18,26)+WQx*VS1(18,26)-r1x2E*VR1(18,26)&
   +3D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +HfxZpE*VS1(10,26)
VS0(18,43)=QCx*VS0(18,27)+WQx*VS1(18,27)-r1x2E*VR1(18,27)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +HfxZpE*VS1(10,27)
VS0(18,44)=QCx*VS0(18,28)+WQx*VS1(18,28)-r1x2E*VR1(18,28)&
   +r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +HfxZpE*VS1(10,28)
VS0(18,45)=QCy*VS0(18,28)+WQy*VS1(18,28)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))
VS0(18,46)=QCy*VS0(18,29)+WQy*VS1(18,29)&
   +3D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))
VS0(18,47)=QCx*VS0(18,30)+WQx*VS1(18,30)-r1x2E*VR1(18,30)&
   +2D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +HfxZpE*VS1(10,30)
VS0(18,48)=QCx*VS0(18,31)+WQx*VS1(18,31)-r1x2E*VR1(18,31)&
   +r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +HfxZpE*VS1(10,31)
VS0(18,49)=QCy*VS0(18,31)+WQy*VS1(18,31)&
   +r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))
VS0(18,50)=QCy*VS0(18,32)+WQy*VS1(18,32)&
   +2D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))
VS0(18,51)=QCz*VS0(18,30)+WQz*VS1(18,30)&
   +2D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(8,30)
VS0(18,52)=QCz*VS0(18,31)+WQz*VS1(18,31)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +2D0*HfxZpE*VS1(8,31)
VS0(18,53)=QCz*VS0(18,32)+WQz*VS1(18,32)&
   +2D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(8,32)
VS0(18,54)=QCz*VS0(18,33)+WQz*VS1(18,33)&
   +3D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(8,33)
VS0(18,55)=QCz*VS0(18,34)+WQz*VS1(18,34)&
   +3D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(8,34)
VS0(18,56)=QCz*VS0(18,35)+WQz*VS1(18,35)&
   +4D0*r1x2E*(VS0(18,20)-ZxZpE*VS1(18,20))&
   +2D0*HfxZpE*VS1(8,35)
VS0(19,36)=QCx*VS0(19,21)+WQx*VS1(19,21)-r1x2E*VR1(19,21)&
   +4D0*r1x2E*(VS0(19,11)-ZxZpE*VS1(19,11))
VS0(19,37)=QCx*VS0(19,22)+WQx*VS1(19,22)-r1x2E*VR1(19,22)&
   +3D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))
VS0(19,38)=QCx*VS0(19,23)+WQx*VS1(19,23)-r1x2E*VR1(19,23)&
   +2D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))
VS0(19,39)=QCy*VS0(19,23)+WQy*VS1(19,23)&
   +2D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))&
   +HfxZpE*VS1(10,23)
VS0(19,40)=QCy*VS0(19,24)+WQy*VS1(19,24)&
   +3D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))&
   +HfxZpE*VS1(10,24)
VS0(19,41)=QCy*VS0(19,25)+WQy*VS1(19,25)&
   +4D0*r1x2E*(VS0(19,14)-ZxZpE*VS1(19,14))&
   +HfxZpE*VS1(10,25)
VS0(19,42)=QCx*VS0(19,26)+WQx*VS1(19,26)-r1x2E*VR1(19,26)&
   +3D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))
VS0(19,43)=QCx*VS0(19,27)+WQx*VS1(19,27)-r1x2E*VR1(19,27)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))
VS0(19,44)=QCx*VS0(19,28)+WQx*VS1(19,28)-r1x2E*VR1(19,28)&
   +r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))
VS0(19,45)=QCy*VS0(19,28)+WQy*VS1(19,28)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +HfxZpE*VS1(10,28)
VS0(19,46)=QCy*VS0(19,29)+WQy*VS1(19,29)&
   +3D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +HfxZpE*VS1(10,29)
VS0(19,47)=QCx*VS0(19,30)+WQx*VS1(19,30)-r1x2E*VR1(19,30)&
   +2D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))
VS0(19,48)=QCx*VS0(19,31)+WQx*VS1(19,31)-r1x2E*VR1(19,31)&
   +r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))
VS0(19,49)=QCy*VS0(19,31)+WQy*VS1(19,31)&
   +r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +HfxZpE*VS1(10,31)
VS0(19,50)=QCy*VS0(19,32)+WQy*VS1(19,32)&
   +2D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +HfxZpE*VS1(10,32)
VS0(19,51)=QCz*VS0(19,30)+WQz*VS1(19,30)&
   +2D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(9,30)
VS0(19,52)=QCz*VS0(19,31)+WQz*VS1(19,31)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +2D0*HfxZpE*VS1(9,31)
VS0(19,53)=QCz*VS0(19,32)+WQz*VS1(19,32)&
   +2D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(9,32)
VS0(19,54)=QCz*VS0(19,33)+WQz*VS1(19,33)&
   +3D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(9,33)
VS0(19,55)=QCz*VS0(19,34)+WQz*VS1(19,34)&
   +3D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(9,34)
VS0(19,56)=QCz*VS0(19,35)+WQz*VS1(19,35)&
   +4D0*r1x2E*(VS0(19,20)-ZxZpE*VS1(19,20))&
   +2D0*HfxZpE*VS1(9,35)
VS0(20,36)=QCx*VS0(20,21)+WQx*VS1(20,21)-r1x2E*VR1(20,21)&
   +4D0*r1x2E*(VS0(20,11)-ZxZpE*VS1(20,11))
VS0(20,37)=QCx*VS0(20,22)+WQx*VS1(20,22)-r1x2E*VR1(20,22)&
   +3D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,38)=QCx*VS0(20,23)+WQx*VS1(20,23)-r1x2E*VR1(20,23)&
   +2D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,39)=QCy*VS0(20,23)+WQy*VS1(20,23)&
   +2D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,40)=QCy*VS0(20,24)+WQy*VS1(20,24)&
   +3D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,41)=QCy*VS0(20,25)+WQy*VS1(20,25)&
   +4D0*r1x2E*(VS0(20,14)-ZxZpE*VS1(20,14))
VS0(20,42)=QCx*VS0(20,26)+WQx*VS1(20,26)-r1x2E*VR1(20,26)&
   +3D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))
VS0(20,43)=QCx*VS0(20,27)+WQx*VS1(20,27)-r1x2E*VR1(20,27)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,44)=QCx*VS0(20,28)+WQx*VS1(20,28)-r1x2E*VR1(20,28)&
   +r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,45)=QCy*VS0(20,28)+WQy*VS1(20,28)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,46)=QCy*VS0(20,29)+WQy*VS1(20,29)&
   +3D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,47)=QCx*VS0(20,30)+WQx*VS1(20,30)-r1x2E*VR1(20,30)&
   +2D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,48)=QCx*VS0(20,31)+WQx*VS1(20,31)-r1x2E*VR1(20,31)&
   +r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,49)=QCy*VS0(20,31)+WQy*VS1(20,31)&
   +r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,50)=QCy*VS0(20,32)+WQy*VS1(20,32)&
   +2D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,51)=QCz*VS0(20,30)+WQz*VS1(20,30)&
   +2D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))&
   +3D0*HfxZpE*VS1(10,30)
VS0(20,52)=QCz*VS0(20,31)+WQz*VS1(20,31)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))&
   +3D0*HfxZpE*VS1(10,31)
VS0(20,53)=QCz*VS0(20,32)+WQz*VS1(20,32)&
   +2D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))&
   +3D0*HfxZpE*VS1(10,32)
VS0(20,54)=QCz*VS0(20,33)+WQz*VS1(20,33)&
   +3D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))&
   +3D0*HfxZpE*VS1(10,33)
VS0(20,55)=QCz*VS0(20,34)+WQz*VS1(20,34)&
   +3D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))&
   +3D0*HfxZpE*VS1(10,34)
VS0(20,56)=QCz*VS0(20,35)+WQz*VS1(20,35)&
   +4D0*r1x2E*(VS0(20,20)-ZxZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(10,35)
CASE(2)
VS0(11,36)=QCx*VS0(11,21)+WQx*VS1(11,21)&
   +4D0*r1x2E*(VS0(11,11)-ZxZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(5,21)
VS0(11,37)=QCx*VS0(11,22)+WQx*VS1(11,22)&
   +3D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))&
   +3D0*HfxZpE*VS1(5,22)
VS0(11,38)=QCx*VS0(11,23)+WQx*VS1(11,23)&
   +2D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))&
   +3D0*HfxZpE*VS1(5,23)
VS0(11,39)=QCy*VS0(11,23)+WQy*VS1(11,23)-r1x2E*VR1(11,23)&
   +2D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))
VS0(11,40)=QCy*VS0(11,24)+WQy*VS1(11,24)-r1x2E*VR1(11,24)&
   +3D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))
VS0(11,41)=QCy*VS0(11,25)+WQy*VS1(11,25)-r1x2E*VR1(11,25)&
   +4D0*r1x2E*(VS0(11,14)-ZxZpE*VS1(11,14))
VS0(11,42)=QCx*VS0(11,26)+WQx*VS1(11,26)&
   +3D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))&
   +3D0*HfxZpE*VS1(5,26)
VS0(11,43)=QCx*VS0(11,27)+WQx*VS1(11,27)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))&
   +3D0*HfxZpE*VS1(5,27)
VS0(11,44)=QCx*VS0(11,28)+WQx*VS1(11,28)&
   +r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))&
   +3D0*HfxZpE*VS1(5,28)
VS0(11,45)=QCy*VS0(11,28)+WQy*VS1(11,28)-r1x2E*VR1(11,28)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,46)=QCy*VS0(11,29)+WQy*VS1(11,29)-r1x2E*VR1(11,29)&
   +3D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,47)=QCx*VS0(11,30)+WQx*VS1(11,30)&
   +2D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))&
   +3D0*HfxZpE*VS1(5,30)
VS0(11,48)=QCx*VS0(11,31)+WQx*VS1(11,31)&
   +r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))&
   +3D0*HfxZpE*VS1(5,31)
VS0(11,49)=QCy*VS0(11,31)+WQy*VS1(11,31)-r1x2E*VR1(11,31)&
   +r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,50)=QCy*VS0(11,32)+WQy*VS1(11,32)-r1x2E*VR1(11,32)&
   +2D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,51)=QCz*VS0(11,30)+WQz*VS1(11,30)&
   +2D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))
VS0(11,52)=QCz*VS0(11,31)+WQz*VS1(11,31)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,53)=QCz*VS0(11,32)+WQz*VS1(11,32)&
   +2D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,54)=QCz*VS0(11,33)+WQz*VS1(11,33)&
   +3D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,55)=QCz*VS0(11,34)+WQz*VS1(11,34)&
   +3D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,56)=QCz*VS0(11,35)+WQz*VS1(11,35)&
   +4D0*r1x2E*(VS0(11,20)-ZxZpE*VS1(11,20))
VS0(12,36)=QCx*VS0(12,21)+WQx*VS1(12,21)&
   +4D0*r1x2E*(VS0(12,11)-ZxZpE*VS1(12,11))&
   +2D0*HfxZpE*VS1(6,21)
VS0(12,37)=QCx*VS0(12,22)+WQx*VS1(12,22)&
   +3D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(6,22)
VS0(12,38)=QCx*VS0(12,23)+WQx*VS1(12,23)&
   +2D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(6,23)
VS0(12,39)=QCy*VS0(12,23)+WQy*VS1(12,23)-r1x2E*VR1(12,23)&
   +2D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +HfxZpE*VS1(5,23)
VS0(12,40)=QCy*VS0(12,24)+WQy*VS1(12,24)-r1x2E*VR1(12,24)&
   +3D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +HfxZpE*VS1(5,24)
VS0(12,41)=QCy*VS0(12,25)+WQy*VS1(12,25)-r1x2E*VR1(12,25)&
   +4D0*r1x2E*(VS0(12,14)-ZxZpE*VS1(12,14))&
   +HfxZpE*VS1(5,25)
VS0(12,42)=QCx*VS0(12,26)+WQx*VS1(12,26)&
   +3D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(6,26)
VS0(12,43)=QCx*VS0(12,27)+WQx*VS1(12,27)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +2D0*HfxZpE*VS1(6,27)
VS0(12,44)=QCx*VS0(12,28)+WQx*VS1(12,28)&
   +r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(6,28)
VS0(12,45)=QCy*VS0(12,28)+WQy*VS1(12,28)-r1x2E*VR1(12,28)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +HfxZpE*VS1(5,28)
VS0(12,46)=QCy*VS0(12,29)+WQy*VS1(12,29)-r1x2E*VR1(12,29)&
   +3D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +HfxZpE*VS1(5,29)
VS0(12,47)=QCx*VS0(12,30)+WQx*VS1(12,30)&
   +2D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +2D0*HfxZpE*VS1(6,30)
VS0(12,48)=QCx*VS0(12,31)+WQx*VS1(12,31)&
   +r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +2D0*HfxZpE*VS1(6,31)
VS0(12,49)=QCy*VS0(12,31)+WQy*VS1(12,31)-r1x2E*VR1(12,31)&
   +r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +HfxZpE*VS1(5,31)
VS0(12,50)=QCy*VS0(12,32)+WQy*VS1(12,32)-r1x2E*VR1(12,32)&
   +2D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +HfxZpE*VS1(5,32)
VS0(12,51)=QCz*VS0(12,30)+WQz*VS1(12,30)&
   +2D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))
VS0(12,52)=QCz*VS0(12,31)+WQz*VS1(12,31)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))
VS0(12,53)=QCz*VS0(12,32)+WQz*VS1(12,32)&
   +2D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))
VS0(12,54)=QCz*VS0(12,33)+WQz*VS1(12,33)&
   +3D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))
VS0(12,55)=QCz*VS0(12,34)+WQz*VS1(12,34)&
   +3D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))
VS0(12,56)=QCz*VS0(12,35)+WQz*VS1(12,35)&
   +4D0*r1x2E*(VS0(12,20)-ZxZpE*VS1(12,20))
VS0(13,36)=QCx*VS0(13,21)+WQx*VS1(13,21)&
   +4D0*r1x2E*(VS0(13,11)-ZxZpE*VS1(13,11))&
   +HfxZpE*VS1(7,21)
VS0(13,37)=QCx*VS0(13,22)+WQx*VS1(13,22)&
   +3D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +HfxZpE*VS1(7,22)
VS0(13,38)=QCx*VS0(13,23)+WQx*VS1(13,23)&
   +2D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +HfxZpE*VS1(7,23)
VS0(13,39)=QCy*VS0(13,23)+WQy*VS1(13,23)-r1x2E*VR1(13,23)&
   +2D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(6,23)
VS0(13,40)=QCy*VS0(13,24)+WQy*VS1(13,24)-r1x2E*VR1(13,24)&
   +3D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(6,24)
VS0(13,41)=QCy*VS0(13,25)+WQy*VS1(13,25)-r1x2E*VR1(13,25)&
   +4D0*r1x2E*(VS0(13,14)-ZxZpE*VS1(13,14))&
   +2D0*HfxZpE*VS1(6,25)
VS0(13,42)=QCx*VS0(13,26)+WQx*VS1(13,26)&
   +3D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))&
   +HfxZpE*VS1(7,26)
VS0(13,43)=QCx*VS0(13,27)+WQx*VS1(13,27)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +HfxZpE*VS1(7,27)
VS0(13,44)=QCx*VS0(13,28)+WQx*VS1(13,28)&
   +r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +HfxZpE*VS1(7,28)
VS0(13,45)=QCy*VS0(13,28)+WQy*VS1(13,28)-r1x2E*VR1(13,28)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +2D0*HfxZpE*VS1(6,28)
VS0(13,46)=QCy*VS0(13,29)+WQy*VS1(13,29)-r1x2E*VR1(13,29)&
   +3D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(6,29)
VS0(13,47)=QCx*VS0(13,30)+WQx*VS1(13,30)&
   +2D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +HfxZpE*VS1(7,30)
VS0(13,48)=QCx*VS0(13,31)+WQx*VS1(13,31)&
   +r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +HfxZpE*VS1(7,31)
VS0(13,49)=QCy*VS0(13,31)+WQy*VS1(13,31)-r1x2E*VR1(13,31)&
   +r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +2D0*HfxZpE*VS1(6,31)
VS0(13,50)=QCy*VS0(13,32)+WQy*VS1(13,32)-r1x2E*VR1(13,32)&
   +2D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +2D0*HfxZpE*VS1(6,32)
VS0(13,51)=QCz*VS0(13,30)+WQz*VS1(13,30)&
   +2D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))
VS0(13,52)=QCz*VS0(13,31)+WQz*VS1(13,31)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))
VS0(13,53)=QCz*VS0(13,32)+WQz*VS1(13,32)&
   +2D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))
VS0(13,54)=QCz*VS0(13,33)+WQz*VS1(13,33)&
   +3D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))
VS0(13,55)=QCz*VS0(13,34)+WQz*VS1(13,34)&
   +3D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))
VS0(13,56)=QCz*VS0(13,35)+WQz*VS1(13,35)&
   +4D0*r1x2E*(VS0(13,20)-ZxZpE*VS1(13,20))
VS0(14,36)=QCx*VS0(14,21)+WQx*VS1(14,21)&
   +4D0*r1x2E*(VS0(14,11)-ZxZpE*VS1(14,11))
VS0(14,37)=QCx*VS0(14,22)+WQx*VS1(14,22)&
   +3D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))
VS0(14,38)=QCx*VS0(14,23)+WQx*VS1(14,23)&
   +2D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))
VS0(14,39)=QCy*VS0(14,23)+WQy*VS1(14,23)-r1x2E*VR1(14,23)&
   +2D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))&
   +3D0*HfxZpE*VS1(7,23)
VS0(14,40)=QCy*VS0(14,24)+WQy*VS1(14,24)-r1x2E*VR1(14,24)&
   +3D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))&
   +3D0*HfxZpE*VS1(7,24)
VS0(14,41)=QCy*VS0(14,25)+WQy*VS1(14,25)-r1x2E*VR1(14,25)&
   +4D0*r1x2E*(VS0(14,14)-ZxZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(7,25)
VS0(14,42)=QCx*VS0(14,26)+WQx*VS1(14,26)&
   +3D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,43)=QCx*VS0(14,27)+WQx*VS1(14,27)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,44)=QCx*VS0(14,28)+WQx*VS1(14,28)&
   +r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,45)=QCy*VS0(14,28)+WQy*VS1(14,28)-r1x2E*VR1(14,28)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))&
   +3D0*HfxZpE*VS1(7,28)
VS0(14,46)=QCy*VS0(14,29)+WQy*VS1(14,29)-r1x2E*VR1(14,29)&
   +3D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))&
   +3D0*HfxZpE*VS1(7,29)
VS0(14,47)=QCx*VS0(14,30)+WQx*VS1(14,30)&
   +2D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,48)=QCx*VS0(14,31)+WQx*VS1(14,31)&
   +r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,49)=QCy*VS0(14,31)+WQy*VS1(14,31)-r1x2E*VR1(14,31)&
   +r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))&
   +3D0*HfxZpE*VS1(7,31)
VS0(14,50)=QCy*VS0(14,32)+WQy*VS1(14,32)-r1x2E*VR1(14,32)&
   +2D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))&
   +3D0*HfxZpE*VS1(7,32)
VS0(14,51)=QCz*VS0(14,30)+WQz*VS1(14,30)&
   +2D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,52)=QCz*VS0(14,31)+WQz*VS1(14,31)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,53)=QCz*VS0(14,32)+WQz*VS1(14,32)&
   +2D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,54)=QCz*VS0(14,33)+WQz*VS1(14,33)&
   +3D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,55)=QCz*VS0(14,34)+WQz*VS1(14,34)&
   +3D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,56)=QCz*VS0(14,35)+WQz*VS1(14,35)&
   +4D0*r1x2E*(VS0(14,20)-ZxZpE*VS1(14,20))
VS0(15,36)=QCx*VS0(15,21)+WQx*VS1(15,21)&
   +4D0*r1x2E*(VS0(15,11)-ZxZpE*VS1(15,11))&
   +2D0*HfxZpE*VS1(8,21)
VS0(15,37)=QCx*VS0(15,22)+WQx*VS1(15,22)&
   +3D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(8,22)
VS0(15,38)=QCx*VS0(15,23)+WQx*VS1(15,23)&
   +2D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))&
   +2D0*HfxZpE*VS1(8,23)
VS0(15,39)=QCy*VS0(15,23)+WQy*VS1(15,23)-r1x2E*VR1(15,23)&
   +2D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))
VS0(15,40)=QCy*VS0(15,24)+WQy*VS1(15,24)-r1x2E*VR1(15,24)&
   +3D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))
VS0(15,41)=QCy*VS0(15,25)+WQy*VS1(15,25)-r1x2E*VR1(15,25)&
   +4D0*r1x2E*(VS0(15,14)-ZxZpE*VS1(15,14))
VS0(15,42)=QCx*VS0(15,26)+WQx*VS1(15,26)&
   +3D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(8,26)
VS0(15,43)=QCx*VS0(15,27)+WQx*VS1(15,27)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +2D0*HfxZpE*VS1(8,27)
VS0(15,44)=QCx*VS0(15,28)+WQx*VS1(15,28)&
   +r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +2D0*HfxZpE*VS1(8,28)
VS0(15,45)=QCy*VS0(15,28)+WQy*VS1(15,28)-r1x2E*VR1(15,28)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))
VS0(15,46)=QCy*VS0(15,29)+WQy*VS1(15,29)-r1x2E*VR1(15,29)&
   +3D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))
VS0(15,47)=QCx*VS0(15,30)+WQx*VS1(15,30)&
   +2D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(8,30)
VS0(15,48)=QCx*VS0(15,31)+WQx*VS1(15,31)&
   +r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(8,31)
VS0(15,49)=QCy*VS0(15,31)+WQy*VS1(15,31)-r1x2E*VR1(15,31)&
   +r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))
VS0(15,50)=QCy*VS0(15,32)+WQy*VS1(15,32)-r1x2E*VR1(15,32)&
   +2D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))
VS0(15,51)=QCz*VS0(15,30)+WQz*VS1(15,30)&
   +2D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +HfxZpE*VS1(5,30)
VS0(15,52)=QCz*VS0(15,31)+WQz*VS1(15,31)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +HfxZpE*VS1(5,31)
VS0(15,53)=QCz*VS0(15,32)+WQz*VS1(15,32)&
   +2D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +HfxZpE*VS1(5,32)
VS0(15,54)=QCz*VS0(15,33)+WQz*VS1(15,33)&
   +3D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +HfxZpE*VS1(5,33)
VS0(15,55)=QCz*VS0(15,34)+WQz*VS1(15,34)&
   +3D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +HfxZpE*VS1(5,34)
VS0(15,56)=QCz*VS0(15,35)+WQz*VS1(15,35)&
   +4D0*r1x2E*(VS0(15,20)-ZxZpE*VS1(15,20))&
   +HfxZpE*VS1(5,35)
VS0(16,36)=QCx*VS0(16,21)+WQx*VS1(16,21)&
   +4D0*r1x2E*(VS0(16,11)-ZxZpE*VS1(16,11))&
   +HfxZpE*VS1(9,21)
VS0(16,37)=QCx*VS0(16,22)+WQx*VS1(16,22)&
   +3D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(9,22)
VS0(16,38)=QCx*VS0(16,23)+WQx*VS1(16,23)&
   +2D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(9,23)
VS0(16,39)=QCy*VS0(16,23)+WQy*VS1(16,23)-r1x2E*VR1(16,23)&
   +2D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(8,23)
VS0(16,40)=QCy*VS0(16,24)+WQy*VS1(16,24)-r1x2E*VR1(16,24)&
   +3D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(8,24)
VS0(16,41)=QCy*VS0(16,25)+WQy*VS1(16,25)-r1x2E*VR1(16,25)&
   +4D0*r1x2E*(VS0(16,14)-ZxZpE*VS1(16,14))&
   +HfxZpE*VS1(8,25)
VS0(16,42)=QCx*VS0(16,26)+WQx*VS1(16,26)&
   +3D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(9,26)
VS0(16,43)=QCx*VS0(16,27)+WQx*VS1(16,27)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(9,27)
VS0(16,44)=QCx*VS0(16,28)+WQx*VS1(16,28)&
   +r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(9,28)
VS0(16,45)=QCy*VS0(16,28)+WQy*VS1(16,28)-r1x2E*VR1(16,28)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(8,28)
VS0(16,46)=QCy*VS0(16,29)+WQy*VS1(16,29)-r1x2E*VR1(16,29)&
   +3D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(8,29)
VS0(16,47)=QCx*VS0(16,30)+WQx*VS1(16,30)&
   +2D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(9,30)
VS0(16,48)=QCx*VS0(16,31)+WQx*VS1(16,31)&
   +r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(9,31)
VS0(16,49)=QCy*VS0(16,31)+WQy*VS1(16,31)-r1x2E*VR1(16,31)&
   +r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(8,31)
VS0(16,50)=QCy*VS0(16,32)+WQy*VS1(16,32)-r1x2E*VR1(16,32)&
   +2D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(8,32)
VS0(16,51)=QCz*VS0(16,30)+WQz*VS1(16,30)&
   +2D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(6,30)
VS0(16,52)=QCz*VS0(16,31)+WQz*VS1(16,31)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(6,31)
VS0(16,53)=QCz*VS0(16,32)+WQz*VS1(16,32)&
   +2D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(6,32)
VS0(16,54)=QCz*VS0(16,33)+WQz*VS1(16,33)&
   +3D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(6,33)
VS0(16,55)=QCz*VS0(16,34)+WQz*VS1(16,34)&
   +3D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(6,34)
VS0(16,56)=QCz*VS0(16,35)+WQz*VS1(16,35)&
   +4D0*r1x2E*(VS0(16,20)-ZxZpE*VS1(16,20))&
   +HfxZpE*VS1(6,35)
VS0(17,36)=QCx*VS0(17,21)+WQx*VS1(17,21)&
   +4D0*r1x2E*(VS0(17,11)-ZxZpE*VS1(17,11))
VS0(17,37)=QCx*VS0(17,22)+WQx*VS1(17,22)&
   +3D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))
VS0(17,38)=QCx*VS0(17,23)+WQx*VS1(17,23)&
   +2D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))
VS0(17,39)=QCy*VS0(17,23)+WQy*VS1(17,23)-r1x2E*VR1(17,23)&
   +2D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(9,23)
VS0(17,40)=QCy*VS0(17,24)+WQy*VS1(17,24)-r1x2E*VR1(17,24)&
   +3D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(9,24)
VS0(17,41)=QCy*VS0(17,25)+WQy*VS1(17,25)-r1x2E*VR1(17,25)&
   +4D0*r1x2E*(VS0(17,14)-ZxZpE*VS1(17,14))&
   +2D0*HfxZpE*VS1(9,25)
VS0(17,42)=QCx*VS0(17,26)+WQx*VS1(17,26)&
   +3D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))
VS0(17,43)=QCx*VS0(17,27)+WQx*VS1(17,27)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))
VS0(17,44)=QCx*VS0(17,28)+WQx*VS1(17,28)&
   +r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))
VS0(17,45)=QCy*VS0(17,28)+WQy*VS1(17,28)-r1x2E*VR1(17,28)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +2D0*HfxZpE*VS1(9,28)
VS0(17,46)=QCy*VS0(17,29)+WQy*VS1(17,29)-r1x2E*VR1(17,29)&
   +3D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(9,29)
VS0(17,47)=QCx*VS0(17,30)+WQx*VS1(17,30)&
   +2D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))
VS0(17,48)=QCx*VS0(17,31)+WQx*VS1(17,31)&
   +r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))
VS0(17,49)=QCy*VS0(17,31)+WQy*VS1(17,31)-r1x2E*VR1(17,31)&
   +r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(9,31)
VS0(17,50)=QCy*VS0(17,32)+WQy*VS1(17,32)-r1x2E*VR1(17,32)&
   +2D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(9,32)
VS0(17,51)=QCz*VS0(17,30)+WQz*VS1(17,30)&
   +2D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))&
   +HfxZpE*VS1(7,30)
VS0(17,52)=QCz*VS0(17,31)+WQz*VS1(17,31)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +HfxZpE*VS1(7,31)
VS0(17,53)=QCz*VS0(17,32)+WQz*VS1(17,32)&
   +2D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +HfxZpE*VS1(7,32)
VS0(17,54)=QCz*VS0(17,33)+WQz*VS1(17,33)&
   +3D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +HfxZpE*VS1(7,33)
VS0(17,55)=QCz*VS0(17,34)+WQz*VS1(17,34)&
   +3D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +HfxZpE*VS1(7,34)
VS0(17,56)=QCz*VS0(17,35)+WQz*VS1(17,35)&
   +4D0*r1x2E*(VS0(17,20)-ZxZpE*VS1(17,20))&
   +HfxZpE*VS1(7,35)
VS0(18,36)=QCx*VS0(18,21)+WQx*VS1(18,21)&
   +4D0*r1x2E*(VS0(18,11)-ZxZpE*VS1(18,11))&
   +HfxZpE*VS1(10,21)
VS0(18,37)=QCx*VS0(18,22)+WQx*VS1(18,22)&
   +3D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))&
   +HfxZpE*VS1(10,22)
VS0(18,38)=QCx*VS0(18,23)+WQx*VS1(18,23)&
   +2D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))&
   +HfxZpE*VS1(10,23)
VS0(18,39)=QCy*VS0(18,23)+WQy*VS1(18,23)-r1x2E*VR1(18,23)&
   +2D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))
VS0(18,40)=QCy*VS0(18,24)+WQy*VS1(18,24)-r1x2E*VR1(18,24)&
   +3D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))
VS0(18,41)=QCy*VS0(18,25)+WQy*VS1(18,25)-r1x2E*VR1(18,25)&
   +4D0*r1x2E*(VS0(18,14)-ZxZpE*VS1(18,14))
VS0(18,42)=QCx*VS0(18,26)+WQx*VS1(18,26)&
   +3D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +HfxZpE*VS1(10,26)
VS0(18,43)=QCx*VS0(18,27)+WQx*VS1(18,27)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +HfxZpE*VS1(10,27)
VS0(18,44)=QCx*VS0(18,28)+WQx*VS1(18,28)&
   +r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +HfxZpE*VS1(10,28)
VS0(18,45)=QCy*VS0(18,28)+WQy*VS1(18,28)-r1x2E*VR1(18,28)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))
VS0(18,46)=QCy*VS0(18,29)+WQy*VS1(18,29)-r1x2E*VR1(18,29)&
   +3D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))
VS0(18,47)=QCx*VS0(18,30)+WQx*VS1(18,30)&
   +2D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +HfxZpE*VS1(10,30)
VS0(18,48)=QCx*VS0(18,31)+WQx*VS1(18,31)&
   +r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +HfxZpE*VS1(10,31)
VS0(18,49)=QCy*VS0(18,31)+WQy*VS1(18,31)-r1x2E*VR1(18,31)&
   +r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))
VS0(18,50)=QCy*VS0(18,32)+WQy*VS1(18,32)-r1x2E*VR1(18,32)&
   +2D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))
VS0(18,51)=QCz*VS0(18,30)+WQz*VS1(18,30)&
   +2D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(8,30)
VS0(18,52)=QCz*VS0(18,31)+WQz*VS1(18,31)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +2D0*HfxZpE*VS1(8,31)
VS0(18,53)=QCz*VS0(18,32)+WQz*VS1(18,32)&
   +2D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(8,32)
VS0(18,54)=QCz*VS0(18,33)+WQz*VS1(18,33)&
   +3D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(8,33)
VS0(18,55)=QCz*VS0(18,34)+WQz*VS1(18,34)&
   +3D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(8,34)
VS0(18,56)=QCz*VS0(18,35)+WQz*VS1(18,35)&
   +4D0*r1x2E*(VS0(18,20)-ZxZpE*VS1(18,20))&
   +2D0*HfxZpE*VS1(8,35)
VS0(19,36)=QCx*VS0(19,21)+WQx*VS1(19,21)&
   +4D0*r1x2E*(VS0(19,11)-ZxZpE*VS1(19,11))
VS0(19,37)=QCx*VS0(19,22)+WQx*VS1(19,22)&
   +3D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))
VS0(19,38)=QCx*VS0(19,23)+WQx*VS1(19,23)&
   +2D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))
VS0(19,39)=QCy*VS0(19,23)+WQy*VS1(19,23)-r1x2E*VR1(19,23)&
   +2D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))&
   +HfxZpE*VS1(10,23)
VS0(19,40)=QCy*VS0(19,24)+WQy*VS1(19,24)-r1x2E*VR1(19,24)&
   +3D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))&
   +HfxZpE*VS1(10,24)
VS0(19,41)=QCy*VS0(19,25)+WQy*VS1(19,25)-r1x2E*VR1(19,25)&
   +4D0*r1x2E*(VS0(19,14)-ZxZpE*VS1(19,14))&
   +HfxZpE*VS1(10,25)
VS0(19,42)=QCx*VS0(19,26)+WQx*VS1(19,26)&
   +3D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))
VS0(19,43)=QCx*VS0(19,27)+WQx*VS1(19,27)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))
VS0(19,44)=QCx*VS0(19,28)+WQx*VS1(19,28)&
   +r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))
VS0(19,45)=QCy*VS0(19,28)+WQy*VS1(19,28)-r1x2E*VR1(19,28)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +HfxZpE*VS1(10,28)
VS0(19,46)=QCy*VS0(19,29)+WQy*VS1(19,29)-r1x2E*VR1(19,29)&
   +3D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +HfxZpE*VS1(10,29)
VS0(19,47)=QCx*VS0(19,30)+WQx*VS1(19,30)&
   +2D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))
VS0(19,48)=QCx*VS0(19,31)+WQx*VS1(19,31)&
   +r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))
VS0(19,49)=QCy*VS0(19,31)+WQy*VS1(19,31)-r1x2E*VR1(19,31)&
   +r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +HfxZpE*VS1(10,31)
VS0(19,50)=QCy*VS0(19,32)+WQy*VS1(19,32)-r1x2E*VR1(19,32)&
   +2D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +HfxZpE*VS1(10,32)
VS0(19,51)=QCz*VS0(19,30)+WQz*VS1(19,30)&
   +2D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(9,30)
VS0(19,52)=QCz*VS0(19,31)+WQz*VS1(19,31)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +2D0*HfxZpE*VS1(9,31)
VS0(19,53)=QCz*VS0(19,32)+WQz*VS1(19,32)&
   +2D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(9,32)
VS0(19,54)=QCz*VS0(19,33)+WQz*VS1(19,33)&
   +3D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(9,33)
VS0(19,55)=QCz*VS0(19,34)+WQz*VS1(19,34)&
   +3D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(9,34)
VS0(19,56)=QCz*VS0(19,35)+WQz*VS1(19,35)&
   +4D0*r1x2E*(VS0(19,20)-ZxZpE*VS1(19,20))&
   +2D0*HfxZpE*VS1(9,35)
VS0(20,36)=QCx*VS0(20,21)+WQx*VS1(20,21)&
   +4D0*r1x2E*(VS0(20,11)-ZxZpE*VS1(20,11))
VS0(20,37)=QCx*VS0(20,22)+WQx*VS1(20,22)&
   +3D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,38)=QCx*VS0(20,23)+WQx*VS1(20,23)&
   +2D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,39)=QCy*VS0(20,23)+WQy*VS1(20,23)-r1x2E*VR1(20,23)&
   +2D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,40)=QCy*VS0(20,24)+WQy*VS1(20,24)-r1x2E*VR1(20,24)&
   +3D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,41)=QCy*VS0(20,25)+WQy*VS1(20,25)-r1x2E*VR1(20,25)&
   +4D0*r1x2E*(VS0(20,14)-ZxZpE*VS1(20,14))
VS0(20,42)=QCx*VS0(20,26)+WQx*VS1(20,26)&
   +3D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))
VS0(20,43)=QCx*VS0(20,27)+WQx*VS1(20,27)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,44)=QCx*VS0(20,28)+WQx*VS1(20,28)&
   +r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,45)=QCy*VS0(20,28)+WQy*VS1(20,28)-r1x2E*VR1(20,28)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,46)=QCy*VS0(20,29)+WQy*VS1(20,29)-r1x2E*VR1(20,29)&
   +3D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,47)=QCx*VS0(20,30)+WQx*VS1(20,30)&
   +2D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,48)=QCx*VS0(20,31)+WQx*VS1(20,31)&
   +r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,49)=QCy*VS0(20,31)+WQy*VS1(20,31)-r1x2E*VR1(20,31)&
   +r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,50)=QCy*VS0(20,32)+WQy*VS1(20,32)-r1x2E*VR1(20,32)&
   +2D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,51)=QCz*VS0(20,30)+WQz*VS1(20,30)&
   +2D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))&
   +3D0*HfxZpE*VS1(10,30)
VS0(20,52)=QCz*VS0(20,31)+WQz*VS1(20,31)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))&
   +3D0*HfxZpE*VS1(10,31)
VS0(20,53)=QCz*VS0(20,32)+WQz*VS1(20,32)&
   +2D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))&
   +3D0*HfxZpE*VS1(10,32)
VS0(20,54)=QCz*VS0(20,33)+WQz*VS1(20,33)&
   +3D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))&
   +3D0*HfxZpE*VS1(10,33)
VS0(20,55)=QCz*VS0(20,34)+WQz*VS1(20,34)&
   +3D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))&
   +3D0*HfxZpE*VS1(10,34)
VS0(20,56)=QCz*VS0(20,35)+WQz*VS1(20,35)&
   +4D0*r1x2E*(VS0(20,20)-ZxZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(10,35)
CASE(3)
VS0(11,36)=QCx*VS0(11,21)+WQx*VS1(11,21)&
   +4D0*r1x2E*(VS0(11,11)-ZxZpE*VS1(11,11))&
   +3D0*HfxZpE*VS1(5,21)
VS0(11,37)=QCx*VS0(11,22)+WQx*VS1(11,22)&
   +3D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))&
   +3D0*HfxZpE*VS1(5,22)
VS0(11,38)=QCx*VS0(11,23)+WQx*VS1(11,23)&
   +2D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))&
   +3D0*HfxZpE*VS1(5,23)
VS0(11,39)=QCy*VS0(11,23)+WQy*VS1(11,23)&
   +2D0*r1x2E*(VS0(11,12)-ZxZpE*VS1(11,12))
VS0(11,40)=QCy*VS0(11,24)+WQy*VS1(11,24)&
   +3D0*r1x2E*(VS0(11,13)-ZxZpE*VS1(11,13))
VS0(11,41)=QCy*VS0(11,25)+WQy*VS1(11,25)&
   +4D0*r1x2E*(VS0(11,14)-ZxZpE*VS1(11,14))
VS0(11,42)=QCx*VS0(11,26)+WQx*VS1(11,26)&
   +3D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))&
   +3D0*HfxZpE*VS1(5,26)
VS0(11,43)=QCx*VS0(11,27)+WQx*VS1(11,27)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))&
   +3D0*HfxZpE*VS1(5,27)
VS0(11,44)=QCx*VS0(11,28)+WQx*VS1(11,28)&
   +r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))&
   +3D0*HfxZpE*VS1(5,28)
VS0(11,45)=QCy*VS0(11,28)+WQy*VS1(11,28)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,46)=QCy*VS0(11,29)+WQy*VS1(11,29)&
   +3D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,47)=QCx*VS0(11,30)+WQx*VS1(11,30)&
   +2D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))&
   +3D0*HfxZpE*VS1(5,30)
VS0(11,48)=QCx*VS0(11,31)+WQx*VS1(11,31)&
   +r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))&
   +3D0*HfxZpE*VS1(5,31)
VS0(11,49)=QCy*VS0(11,31)+WQy*VS1(11,31)&
   +r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,50)=QCy*VS0(11,32)+WQy*VS1(11,32)&
   +2D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,51)=QCz*VS0(11,30)+WQz*VS1(11,30)-r1x2E*VR1(11,30)&
   +2D0*r1x2E*(VS0(11,15)-ZxZpE*VS1(11,15))
VS0(11,52)=QCz*VS0(11,31)+WQz*VS1(11,31)-r1x2E*VR1(11,31)&
   +2D0*r1x2E*(VS0(11,16)-ZxZpE*VS1(11,16))
VS0(11,53)=QCz*VS0(11,32)+WQz*VS1(11,32)-r1x2E*VR1(11,32)&
   +2D0*r1x2E*(VS0(11,17)-ZxZpE*VS1(11,17))
VS0(11,54)=QCz*VS0(11,33)+WQz*VS1(11,33)-r1x2E*VR1(11,33)&
   +3D0*r1x2E*(VS0(11,18)-ZxZpE*VS1(11,18))
VS0(11,55)=QCz*VS0(11,34)+WQz*VS1(11,34)-r1x2E*VR1(11,34)&
   +3D0*r1x2E*(VS0(11,19)-ZxZpE*VS1(11,19))
VS0(11,56)=QCz*VS0(11,35)+WQz*VS1(11,35)-r1x2E*VR1(11,35)&
   +4D0*r1x2E*(VS0(11,20)-ZxZpE*VS1(11,20))
VS0(12,36)=QCx*VS0(12,21)+WQx*VS1(12,21)&
   +4D0*r1x2E*(VS0(12,11)-ZxZpE*VS1(12,11))&
   +2D0*HfxZpE*VS1(6,21)
VS0(12,37)=QCx*VS0(12,22)+WQx*VS1(12,22)&
   +3D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +2D0*HfxZpE*VS1(6,22)
VS0(12,38)=QCx*VS0(12,23)+WQx*VS1(12,23)&
   +2D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +2D0*HfxZpE*VS1(6,23)
VS0(12,39)=QCy*VS0(12,23)+WQy*VS1(12,23)&
   +2D0*r1x2E*(VS0(12,12)-ZxZpE*VS1(12,12))&
   +HfxZpE*VS1(5,23)
VS0(12,40)=QCy*VS0(12,24)+WQy*VS1(12,24)&
   +3D0*r1x2E*(VS0(12,13)-ZxZpE*VS1(12,13))&
   +HfxZpE*VS1(5,24)
VS0(12,41)=QCy*VS0(12,25)+WQy*VS1(12,25)&
   +4D0*r1x2E*(VS0(12,14)-ZxZpE*VS1(12,14))&
   +HfxZpE*VS1(5,25)
VS0(12,42)=QCx*VS0(12,26)+WQx*VS1(12,26)&
   +3D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))&
   +2D0*HfxZpE*VS1(6,26)
VS0(12,43)=QCx*VS0(12,27)+WQx*VS1(12,27)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +2D0*HfxZpE*VS1(6,27)
VS0(12,44)=QCx*VS0(12,28)+WQx*VS1(12,28)&
   +r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +2D0*HfxZpE*VS1(6,28)
VS0(12,45)=QCy*VS0(12,28)+WQy*VS1(12,28)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))&
   +HfxZpE*VS1(5,28)
VS0(12,46)=QCy*VS0(12,29)+WQy*VS1(12,29)&
   +3D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))&
   +HfxZpE*VS1(5,29)
VS0(12,47)=QCx*VS0(12,30)+WQx*VS1(12,30)&
   +2D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +2D0*HfxZpE*VS1(6,30)
VS0(12,48)=QCx*VS0(12,31)+WQx*VS1(12,31)&
   +r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +2D0*HfxZpE*VS1(6,31)
VS0(12,49)=QCy*VS0(12,31)+WQy*VS1(12,31)&
   +r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))&
   +HfxZpE*VS1(5,31)
VS0(12,50)=QCy*VS0(12,32)+WQy*VS1(12,32)&
   +2D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))&
   +HfxZpE*VS1(5,32)
VS0(12,51)=QCz*VS0(12,30)+WQz*VS1(12,30)-r1x2E*VR1(12,30)&
   +2D0*r1x2E*(VS0(12,15)-ZxZpE*VS1(12,15))
VS0(12,52)=QCz*VS0(12,31)+WQz*VS1(12,31)-r1x2E*VR1(12,31)&
   +2D0*r1x2E*(VS0(12,16)-ZxZpE*VS1(12,16))
VS0(12,53)=QCz*VS0(12,32)+WQz*VS1(12,32)-r1x2E*VR1(12,32)&
   +2D0*r1x2E*(VS0(12,17)-ZxZpE*VS1(12,17))
VS0(12,54)=QCz*VS0(12,33)+WQz*VS1(12,33)-r1x2E*VR1(12,33)&
   +3D0*r1x2E*(VS0(12,18)-ZxZpE*VS1(12,18))
VS0(12,55)=QCz*VS0(12,34)+WQz*VS1(12,34)-r1x2E*VR1(12,34)&
   +3D0*r1x2E*(VS0(12,19)-ZxZpE*VS1(12,19))
VS0(12,56)=QCz*VS0(12,35)+WQz*VS1(12,35)-r1x2E*VR1(12,35)&
   +4D0*r1x2E*(VS0(12,20)-ZxZpE*VS1(12,20))
VS0(13,36)=QCx*VS0(13,21)+WQx*VS1(13,21)&
   +4D0*r1x2E*(VS0(13,11)-ZxZpE*VS1(13,11))&
   +HfxZpE*VS1(7,21)
VS0(13,37)=QCx*VS0(13,22)+WQx*VS1(13,22)&
   +3D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +HfxZpE*VS1(7,22)
VS0(13,38)=QCx*VS0(13,23)+WQx*VS1(13,23)&
   +2D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +HfxZpE*VS1(7,23)
VS0(13,39)=QCy*VS0(13,23)+WQy*VS1(13,23)&
   +2D0*r1x2E*(VS0(13,12)-ZxZpE*VS1(13,12))&
   +2D0*HfxZpE*VS1(6,23)
VS0(13,40)=QCy*VS0(13,24)+WQy*VS1(13,24)&
   +3D0*r1x2E*(VS0(13,13)-ZxZpE*VS1(13,13))&
   +2D0*HfxZpE*VS1(6,24)
VS0(13,41)=QCy*VS0(13,25)+WQy*VS1(13,25)&
   +4D0*r1x2E*(VS0(13,14)-ZxZpE*VS1(13,14))&
   +2D0*HfxZpE*VS1(6,25)
VS0(13,42)=QCx*VS0(13,26)+WQx*VS1(13,26)&
   +3D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))&
   +HfxZpE*VS1(7,26)
VS0(13,43)=QCx*VS0(13,27)+WQx*VS1(13,27)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +HfxZpE*VS1(7,27)
VS0(13,44)=QCx*VS0(13,28)+WQx*VS1(13,28)&
   +r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +HfxZpE*VS1(7,28)
VS0(13,45)=QCy*VS0(13,28)+WQy*VS1(13,28)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))&
   +2D0*HfxZpE*VS1(6,28)
VS0(13,46)=QCy*VS0(13,29)+WQy*VS1(13,29)&
   +3D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))&
   +2D0*HfxZpE*VS1(6,29)
VS0(13,47)=QCx*VS0(13,30)+WQx*VS1(13,30)&
   +2D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +HfxZpE*VS1(7,30)
VS0(13,48)=QCx*VS0(13,31)+WQx*VS1(13,31)&
   +r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +HfxZpE*VS1(7,31)
VS0(13,49)=QCy*VS0(13,31)+WQy*VS1(13,31)&
   +r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))&
   +2D0*HfxZpE*VS1(6,31)
VS0(13,50)=QCy*VS0(13,32)+WQy*VS1(13,32)&
   +2D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))&
   +2D0*HfxZpE*VS1(6,32)
VS0(13,51)=QCz*VS0(13,30)+WQz*VS1(13,30)-r1x2E*VR1(13,30)&
   +2D0*r1x2E*(VS0(13,15)-ZxZpE*VS1(13,15))
VS0(13,52)=QCz*VS0(13,31)+WQz*VS1(13,31)-r1x2E*VR1(13,31)&
   +2D0*r1x2E*(VS0(13,16)-ZxZpE*VS1(13,16))
VS0(13,53)=QCz*VS0(13,32)+WQz*VS1(13,32)-r1x2E*VR1(13,32)&
   +2D0*r1x2E*(VS0(13,17)-ZxZpE*VS1(13,17))
VS0(13,54)=QCz*VS0(13,33)+WQz*VS1(13,33)-r1x2E*VR1(13,33)&
   +3D0*r1x2E*(VS0(13,18)-ZxZpE*VS1(13,18))
VS0(13,55)=QCz*VS0(13,34)+WQz*VS1(13,34)-r1x2E*VR1(13,34)&
   +3D0*r1x2E*(VS0(13,19)-ZxZpE*VS1(13,19))
VS0(13,56)=QCz*VS0(13,35)+WQz*VS1(13,35)-r1x2E*VR1(13,35)&
   +4D0*r1x2E*(VS0(13,20)-ZxZpE*VS1(13,20))
VS0(14,36)=QCx*VS0(14,21)+WQx*VS1(14,21)&
   +4D0*r1x2E*(VS0(14,11)-ZxZpE*VS1(14,11))
VS0(14,37)=QCx*VS0(14,22)+WQx*VS1(14,22)&
   +3D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))
VS0(14,38)=QCx*VS0(14,23)+WQx*VS1(14,23)&
   +2D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))
VS0(14,39)=QCy*VS0(14,23)+WQy*VS1(14,23)&
   +2D0*r1x2E*(VS0(14,12)-ZxZpE*VS1(14,12))&
   +3D0*HfxZpE*VS1(7,23)
VS0(14,40)=QCy*VS0(14,24)+WQy*VS1(14,24)&
   +3D0*r1x2E*(VS0(14,13)-ZxZpE*VS1(14,13))&
   +3D0*HfxZpE*VS1(7,24)
VS0(14,41)=QCy*VS0(14,25)+WQy*VS1(14,25)&
   +4D0*r1x2E*(VS0(14,14)-ZxZpE*VS1(14,14))&
   +3D0*HfxZpE*VS1(7,25)
VS0(14,42)=QCx*VS0(14,26)+WQx*VS1(14,26)&
   +3D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,43)=QCx*VS0(14,27)+WQx*VS1(14,27)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,44)=QCx*VS0(14,28)+WQx*VS1(14,28)&
   +r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,45)=QCy*VS0(14,28)+WQy*VS1(14,28)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))&
   +3D0*HfxZpE*VS1(7,28)
VS0(14,46)=QCy*VS0(14,29)+WQy*VS1(14,29)&
   +3D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))&
   +3D0*HfxZpE*VS1(7,29)
VS0(14,47)=QCx*VS0(14,30)+WQx*VS1(14,30)&
   +2D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,48)=QCx*VS0(14,31)+WQx*VS1(14,31)&
   +r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,49)=QCy*VS0(14,31)+WQy*VS1(14,31)&
   +r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))&
   +3D0*HfxZpE*VS1(7,31)
VS0(14,50)=QCy*VS0(14,32)+WQy*VS1(14,32)&
   +2D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))&
   +3D0*HfxZpE*VS1(7,32)
VS0(14,51)=QCz*VS0(14,30)+WQz*VS1(14,30)-r1x2E*VR1(14,30)&
   +2D0*r1x2E*(VS0(14,15)-ZxZpE*VS1(14,15))
VS0(14,52)=QCz*VS0(14,31)+WQz*VS1(14,31)-r1x2E*VR1(14,31)&
   +2D0*r1x2E*(VS0(14,16)-ZxZpE*VS1(14,16))
VS0(14,53)=QCz*VS0(14,32)+WQz*VS1(14,32)-r1x2E*VR1(14,32)&
   +2D0*r1x2E*(VS0(14,17)-ZxZpE*VS1(14,17))
VS0(14,54)=QCz*VS0(14,33)+WQz*VS1(14,33)-r1x2E*VR1(14,33)&
   +3D0*r1x2E*(VS0(14,18)-ZxZpE*VS1(14,18))
VS0(14,55)=QCz*VS0(14,34)+WQz*VS1(14,34)-r1x2E*VR1(14,34)&
   +3D0*r1x2E*(VS0(14,19)-ZxZpE*VS1(14,19))
VS0(14,56)=QCz*VS0(14,35)+WQz*VS1(14,35)-r1x2E*VR1(14,35)&
   +4D0*r1x2E*(VS0(14,20)-ZxZpE*VS1(14,20))
VS0(15,36)=QCx*VS0(15,21)+WQx*VS1(15,21)&
   +4D0*r1x2E*(VS0(15,11)-ZxZpE*VS1(15,11))&
   +2D0*HfxZpE*VS1(8,21)
VS0(15,37)=QCx*VS0(15,22)+WQx*VS1(15,22)&
   +3D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))&
   +2D0*HfxZpE*VS1(8,22)
VS0(15,38)=QCx*VS0(15,23)+WQx*VS1(15,23)&
   +2D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))&
   +2D0*HfxZpE*VS1(8,23)
VS0(15,39)=QCy*VS0(15,23)+WQy*VS1(15,23)&
   +2D0*r1x2E*(VS0(15,12)-ZxZpE*VS1(15,12))
VS0(15,40)=QCy*VS0(15,24)+WQy*VS1(15,24)&
   +3D0*r1x2E*(VS0(15,13)-ZxZpE*VS1(15,13))
VS0(15,41)=QCy*VS0(15,25)+WQy*VS1(15,25)&
   +4D0*r1x2E*(VS0(15,14)-ZxZpE*VS1(15,14))
VS0(15,42)=QCx*VS0(15,26)+WQx*VS1(15,26)&
   +3D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +2D0*HfxZpE*VS1(8,26)
VS0(15,43)=QCx*VS0(15,27)+WQx*VS1(15,27)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +2D0*HfxZpE*VS1(8,27)
VS0(15,44)=QCx*VS0(15,28)+WQx*VS1(15,28)&
   +r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +2D0*HfxZpE*VS1(8,28)
VS0(15,45)=QCy*VS0(15,28)+WQy*VS1(15,28)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))
VS0(15,46)=QCy*VS0(15,29)+WQy*VS1(15,29)&
   +3D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))
VS0(15,47)=QCx*VS0(15,30)+WQx*VS1(15,30)&
   +2D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +2D0*HfxZpE*VS1(8,30)
VS0(15,48)=QCx*VS0(15,31)+WQx*VS1(15,31)&
   +r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +2D0*HfxZpE*VS1(8,31)
VS0(15,49)=QCy*VS0(15,31)+WQy*VS1(15,31)&
   +r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))
VS0(15,50)=QCy*VS0(15,32)+WQy*VS1(15,32)&
   +2D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))
VS0(15,51)=QCz*VS0(15,30)+WQz*VS1(15,30)-r1x2E*VR1(15,30)&
   +2D0*r1x2E*(VS0(15,15)-ZxZpE*VS1(15,15))&
   +HfxZpE*VS1(5,30)
VS0(15,52)=QCz*VS0(15,31)+WQz*VS1(15,31)-r1x2E*VR1(15,31)&
   +2D0*r1x2E*(VS0(15,16)-ZxZpE*VS1(15,16))&
   +HfxZpE*VS1(5,31)
VS0(15,53)=QCz*VS0(15,32)+WQz*VS1(15,32)-r1x2E*VR1(15,32)&
   +2D0*r1x2E*(VS0(15,17)-ZxZpE*VS1(15,17))&
   +HfxZpE*VS1(5,32)
VS0(15,54)=QCz*VS0(15,33)+WQz*VS1(15,33)-r1x2E*VR1(15,33)&
   +3D0*r1x2E*(VS0(15,18)-ZxZpE*VS1(15,18))&
   +HfxZpE*VS1(5,33)
VS0(15,55)=QCz*VS0(15,34)+WQz*VS1(15,34)-r1x2E*VR1(15,34)&
   +3D0*r1x2E*(VS0(15,19)-ZxZpE*VS1(15,19))&
   +HfxZpE*VS1(5,34)
VS0(15,56)=QCz*VS0(15,35)+WQz*VS1(15,35)-r1x2E*VR1(15,35)&
   +4D0*r1x2E*(VS0(15,20)-ZxZpE*VS1(15,20))&
   +HfxZpE*VS1(5,35)
VS0(16,36)=QCx*VS0(16,21)+WQx*VS1(16,21)&
   +4D0*r1x2E*(VS0(16,11)-ZxZpE*VS1(16,11))&
   +HfxZpE*VS1(9,21)
VS0(16,37)=QCx*VS0(16,22)+WQx*VS1(16,22)&
   +3D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(9,22)
VS0(16,38)=QCx*VS0(16,23)+WQx*VS1(16,23)&
   +2D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(9,23)
VS0(16,39)=QCy*VS0(16,23)+WQy*VS1(16,23)&
   +2D0*r1x2E*(VS0(16,12)-ZxZpE*VS1(16,12))&
   +HfxZpE*VS1(8,23)
VS0(16,40)=QCy*VS0(16,24)+WQy*VS1(16,24)&
   +3D0*r1x2E*(VS0(16,13)-ZxZpE*VS1(16,13))&
   +HfxZpE*VS1(8,24)
VS0(16,41)=QCy*VS0(16,25)+WQy*VS1(16,25)&
   +4D0*r1x2E*(VS0(16,14)-ZxZpE*VS1(16,14))&
   +HfxZpE*VS1(8,25)
VS0(16,42)=QCx*VS0(16,26)+WQx*VS1(16,26)&
   +3D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(9,26)
VS0(16,43)=QCx*VS0(16,27)+WQx*VS1(16,27)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(9,27)
VS0(16,44)=QCx*VS0(16,28)+WQx*VS1(16,28)&
   +r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(9,28)
VS0(16,45)=QCy*VS0(16,28)+WQy*VS1(16,28)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(8,28)
VS0(16,46)=QCy*VS0(16,29)+WQy*VS1(16,29)&
   +3D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(8,29)
VS0(16,47)=QCx*VS0(16,30)+WQx*VS1(16,30)&
   +2D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(9,30)
VS0(16,48)=QCx*VS0(16,31)+WQx*VS1(16,31)&
   +r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(9,31)
VS0(16,49)=QCy*VS0(16,31)+WQy*VS1(16,31)&
   +r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(8,31)
VS0(16,50)=QCy*VS0(16,32)+WQy*VS1(16,32)&
   +2D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(8,32)
VS0(16,51)=QCz*VS0(16,30)+WQz*VS1(16,30)-r1x2E*VR1(16,30)&
   +2D0*r1x2E*(VS0(16,15)-ZxZpE*VS1(16,15))&
   +HfxZpE*VS1(6,30)
VS0(16,52)=QCz*VS0(16,31)+WQz*VS1(16,31)-r1x2E*VR1(16,31)&
   +2D0*r1x2E*(VS0(16,16)-ZxZpE*VS1(16,16))&
   +HfxZpE*VS1(6,31)
VS0(16,53)=QCz*VS0(16,32)+WQz*VS1(16,32)-r1x2E*VR1(16,32)&
   +2D0*r1x2E*(VS0(16,17)-ZxZpE*VS1(16,17))&
   +HfxZpE*VS1(6,32)
VS0(16,54)=QCz*VS0(16,33)+WQz*VS1(16,33)-r1x2E*VR1(16,33)&
   +3D0*r1x2E*(VS0(16,18)-ZxZpE*VS1(16,18))&
   +HfxZpE*VS1(6,33)
VS0(16,55)=QCz*VS0(16,34)+WQz*VS1(16,34)-r1x2E*VR1(16,34)&
   +3D0*r1x2E*(VS0(16,19)-ZxZpE*VS1(16,19))&
   +HfxZpE*VS1(6,34)
VS0(16,56)=QCz*VS0(16,35)+WQz*VS1(16,35)-r1x2E*VR1(16,35)&
   +4D0*r1x2E*(VS0(16,20)-ZxZpE*VS1(16,20))&
   +HfxZpE*VS1(6,35)
VS0(17,36)=QCx*VS0(17,21)+WQx*VS1(17,21)&
   +4D0*r1x2E*(VS0(17,11)-ZxZpE*VS1(17,11))
VS0(17,37)=QCx*VS0(17,22)+WQx*VS1(17,22)&
   +3D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))
VS0(17,38)=QCx*VS0(17,23)+WQx*VS1(17,23)&
   +2D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))
VS0(17,39)=QCy*VS0(17,23)+WQy*VS1(17,23)&
   +2D0*r1x2E*(VS0(17,12)-ZxZpE*VS1(17,12))&
   +2D0*HfxZpE*VS1(9,23)
VS0(17,40)=QCy*VS0(17,24)+WQy*VS1(17,24)&
   +3D0*r1x2E*(VS0(17,13)-ZxZpE*VS1(17,13))&
   +2D0*HfxZpE*VS1(9,24)
VS0(17,41)=QCy*VS0(17,25)+WQy*VS1(17,25)&
   +4D0*r1x2E*(VS0(17,14)-ZxZpE*VS1(17,14))&
   +2D0*HfxZpE*VS1(9,25)
VS0(17,42)=QCx*VS0(17,26)+WQx*VS1(17,26)&
   +3D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))
VS0(17,43)=QCx*VS0(17,27)+WQx*VS1(17,27)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))
VS0(17,44)=QCx*VS0(17,28)+WQx*VS1(17,28)&
   +r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))
VS0(17,45)=QCy*VS0(17,28)+WQy*VS1(17,28)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +2D0*HfxZpE*VS1(9,28)
VS0(17,46)=QCy*VS0(17,29)+WQy*VS1(17,29)&
   +3D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +2D0*HfxZpE*VS1(9,29)
VS0(17,47)=QCx*VS0(17,30)+WQx*VS1(17,30)&
   +2D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))
VS0(17,48)=QCx*VS0(17,31)+WQx*VS1(17,31)&
   +r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))
VS0(17,49)=QCy*VS0(17,31)+WQy*VS1(17,31)&
   +r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +2D0*HfxZpE*VS1(9,31)
VS0(17,50)=QCy*VS0(17,32)+WQy*VS1(17,32)&
   +2D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +2D0*HfxZpE*VS1(9,32)
VS0(17,51)=QCz*VS0(17,30)+WQz*VS1(17,30)-r1x2E*VR1(17,30)&
   +2D0*r1x2E*(VS0(17,15)-ZxZpE*VS1(17,15))&
   +HfxZpE*VS1(7,30)
VS0(17,52)=QCz*VS0(17,31)+WQz*VS1(17,31)-r1x2E*VR1(17,31)&
   +2D0*r1x2E*(VS0(17,16)-ZxZpE*VS1(17,16))&
   +HfxZpE*VS1(7,31)
VS0(17,53)=QCz*VS0(17,32)+WQz*VS1(17,32)-r1x2E*VR1(17,32)&
   +2D0*r1x2E*(VS0(17,17)-ZxZpE*VS1(17,17))&
   +HfxZpE*VS1(7,32)
VS0(17,54)=QCz*VS0(17,33)+WQz*VS1(17,33)-r1x2E*VR1(17,33)&
   +3D0*r1x2E*(VS0(17,18)-ZxZpE*VS1(17,18))&
   +HfxZpE*VS1(7,33)
VS0(17,55)=QCz*VS0(17,34)+WQz*VS1(17,34)-r1x2E*VR1(17,34)&
   +3D0*r1x2E*(VS0(17,19)-ZxZpE*VS1(17,19))&
   +HfxZpE*VS1(7,34)
VS0(17,56)=QCz*VS0(17,35)+WQz*VS1(17,35)-r1x2E*VR1(17,35)&
   +4D0*r1x2E*(VS0(17,20)-ZxZpE*VS1(17,20))&
   +HfxZpE*VS1(7,35)
VS0(18,36)=QCx*VS0(18,21)+WQx*VS1(18,21)&
   +4D0*r1x2E*(VS0(18,11)-ZxZpE*VS1(18,11))&
   +HfxZpE*VS1(10,21)
VS0(18,37)=QCx*VS0(18,22)+WQx*VS1(18,22)&
   +3D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))&
   +HfxZpE*VS1(10,22)
VS0(18,38)=QCx*VS0(18,23)+WQx*VS1(18,23)&
   +2D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))&
   +HfxZpE*VS1(10,23)
VS0(18,39)=QCy*VS0(18,23)+WQy*VS1(18,23)&
   +2D0*r1x2E*(VS0(18,12)-ZxZpE*VS1(18,12))
VS0(18,40)=QCy*VS0(18,24)+WQy*VS1(18,24)&
   +3D0*r1x2E*(VS0(18,13)-ZxZpE*VS1(18,13))
VS0(18,41)=QCy*VS0(18,25)+WQy*VS1(18,25)&
   +4D0*r1x2E*(VS0(18,14)-ZxZpE*VS1(18,14))
VS0(18,42)=QCx*VS0(18,26)+WQx*VS1(18,26)&
   +3D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +HfxZpE*VS1(10,26)
VS0(18,43)=QCx*VS0(18,27)+WQx*VS1(18,27)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +HfxZpE*VS1(10,27)
VS0(18,44)=QCx*VS0(18,28)+WQx*VS1(18,28)&
   +r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +HfxZpE*VS1(10,28)
VS0(18,45)=QCy*VS0(18,28)+WQy*VS1(18,28)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))
VS0(18,46)=QCy*VS0(18,29)+WQy*VS1(18,29)&
   +3D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))
VS0(18,47)=QCx*VS0(18,30)+WQx*VS1(18,30)&
   +2D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +HfxZpE*VS1(10,30)
VS0(18,48)=QCx*VS0(18,31)+WQx*VS1(18,31)&
   +r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +HfxZpE*VS1(10,31)
VS0(18,49)=QCy*VS0(18,31)+WQy*VS1(18,31)&
   +r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))
VS0(18,50)=QCy*VS0(18,32)+WQy*VS1(18,32)&
   +2D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))
VS0(18,51)=QCz*VS0(18,30)+WQz*VS1(18,30)-r1x2E*VR1(18,30)&
   +2D0*r1x2E*(VS0(18,15)-ZxZpE*VS1(18,15))&
   +2D0*HfxZpE*VS1(8,30)
VS0(18,52)=QCz*VS0(18,31)+WQz*VS1(18,31)-r1x2E*VR1(18,31)&
   +2D0*r1x2E*(VS0(18,16)-ZxZpE*VS1(18,16))&
   +2D0*HfxZpE*VS1(8,31)
VS0(18,53)=QCz*VS0(18,32)+WQz*VS1(18,32)-r1x2E*VR1(18,32)&
   +2D0*r1x2E*(VS0(18,17)-ZxZpE*VS1(18,17))&
   +2D0*HfxZpE*VS1(8,32)
VS0(18,54)=QCz*VS0(18,33)+WQz*VS1(18,33)-r1x2E*VR1(18,33)&
   +3D0*r1x2E*(VS0(18,18)-ZxZpE*VS1(18,18))&
   +2D0*HfxZpE*VS1(8,33)
VS0(18,55)=QCz*VS0(18,34)+WQz*VS1(18,34)-r1x2E*VR1(18,34)&
   +3D0*r1x2E*(VS0(18,19)-ZxZpE*VS1(18,19))&
   +2D0*HfxZpE*VS1(8,34)
VS0(18,56)=QCz*VS0(18,35)+WQz*VS1(18,35)-r1x2E*VR1(18,35)&
   +4D0*r1x2E*(VS0(18,20)-ZxZpE*VS1(18,20))&
   +2D0*HfxZpE*VS1(8,35)
VS0(19,36)=QCx*VS0(19,21)+WQx*VS1(19,21)&
   +4D0*r1x2E*(VS0(19,11)-ZxZpE*VS1(19,11))
VS0(19,37)=QCx*VS0(19,22)+WQx*VS1(19,22)&
   +3D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))
VS0(19,38)=QCx*VS0(19,23)+WQx*VS1(19,23)&
   +2D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))
VS0(19,39)=QCy*VS0(19,23)+WQy*VS1(19,23)&
   +2D0*r1x2E*(VS0(19,12)-ZxZpE*VS1(19,12))&
   +HfxZpE*VS1(10,23)
VS0(19,40)=QCy*VS0(19,24)+WQy*VS1(19,24)&
   +3D0*r1x2E*(VS0(19,13)-ZxZpE*VS1(19,13))&
   +HfxZpE*VS1(10,24)
VS0(19,41)=QCy*VS0(19,25)+WQy*VS1(19,25)&
   +4D0*r1x2E*(VS0(19,14)-ZxZpE*VS1(19,14))&
   +HfxZpE*VS1(10,25)
VS0(19,42)=QCx*VS0(19,26)+WQx*VS1(19,26)&
   +3D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))
VS0(19,43)=QCx*VS0(19,27)+WQx*VS1(19,27)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))
VS0(19,44)=QCx*VS0(19,28)+WQx*VS1(19,28)&
   +r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))
VS0(19,45)=QCy*VS0(19,28)+WQy*VS1(19,28)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +HfxZpE*VS1(10,28)
VS0(19,46)=QCy*VS0(19,29)+WQy*VS1(19,29)&
   +3D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +HfxZpE*VS1(10,29)
VS0(19,47)=QCx*VS0(19,30)+WQx*VS1(19,30)&
   +2D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))
VS0(19,48)=QCx*VS0(19,31)+WQx*VS1(19,31)&
   +r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))
VS0(19,49)=QCy*VS0(19,31)+WQy*VS1(19,31)&
   +r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +HfxZpE*VS1(10,31)
VS0(19,50)=QCy*VS0(19,32)+WQy*VS1(19,32)&
   +2D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +HfxZpE*VS1(10,32)
VS0(19,51)=QCz*VS0(19,30)+WQz*VS1(19,30)-r1x2E*VR1(19,30)&
   +2D0*r1x2E*(VS0(19,15)-ZxZpE*VS1(19,15))&
   +2D0*HfxZpE*VS1(9,30)
VS0(19,52)=QCz*VS0(19,31)+WQz*VS1(19,31)-r1x2E*VR1(19,31)&
   +2D0*r1x2E*(VS0(19,16)-ZxZpE*VS1(19,16))&
   +2D0*HfxZpE*VS1(9,31)
VS0(19,53)=QCz*VS0(19,32)+WQz*VS1(19,32)-r1x2E*VR1(19,32)&
   +2D0*r1x2E*(VS0(19,17)-ZxZpE*VS1(19,17))&
   +2D0*HfxZpE*VS1(9,32)
VS0(19,54)=QCz*VS0(19,33)+WQz*VS1(19,33)-r1x2E*VR1(19,33)&
   +3D0*r1x2E*(VS0(19,18)-ZxZpE*VS1(19,18))&
   +2D0*HfxZpE*VS1(9,33)
VS0(19,55)=QCz*VS0(19,34)+WQz*VS1(19,34)-r1x2E*VR1(19,34)&
   +3D0*r1x2E*(VS0(19,19)-ZxZpE*VS1(19,19))&
   +2D0*HfxZpE*VS1(9,34)
VS0(19,56)=QCz*VS0(19,35)+WQz*VS1(19,35)-r1x2E*VR1(19,35)&
   +4D0*r1x2E*(VS0(19,20)-ZxZpE*VS1(19,20))&
   +2D0*HfxZpE*VS1(9,35)
VS0(20,36)=QCx*VS0(20,21)+WQx*VS1(20,21)&
   +4D0*r1x2E*(VS0(20,11)-ZxZpE*VS1(20,11))
VS0(20,37)=QCx*VS0(20,22)+WQx*VS1(20,22)&
   +3D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,38)=QCx*VS0(20,23)+WQx*VS1(20,23)&
   +2D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,39)=QCy*VS0(20,23)+WQy*VS1(20,23)&
   +2D0*r1x2E*(VS0(20,12)-ZxZpE*VS1(20,12))
VS0(20,40)=QCy*VS0(20,24)+WQy*VS1(20,24)&
   +3D0*r1x2E*(VS0(20,13)-ZxZpE*VS1(20,13))
VS0(20,41)=QCy*VS0(20,25)+WQy*VS1(20,25)&
   +4D0*r1x2E*(VS0(20,14)-ZxZpE*VS1(20,14))
VS0(20,42)=QCx*VS0(20,26)+WQx*VS1(20,26)&
   +3D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))
VS0(20,43)=QCx*VS0(20,27)+WQx*VS1(20,27)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,44)=QCx*VS0(20,28)+WQx*VS1(20,28)&
   +r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,45)=QCy*VS0(20,28)+WQy*VS1(20,28)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))
VS0(20,46)=QCy*VS0(20,29)+WQy*VS1(20,29)&
   +3D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))
VS0(20,47)=QCx*VS0(20,30)+WQx*VS1(20,30)&
   +2D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,48)=QCx*VS0(20,31)+WQx*VS1(20,31)&
   +r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,49)=QCy*VS0(20,31)+WQy*VS1(20,31)&
   +r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))
VS0(20,50)=QCy*VS0(20,32)+WQy*VS1(20,32)&
   +2D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))
VS0(20,51)=QCz*VS0(20,30)+WQz*VS1(20,30)-r1x2E*VR1(20,30)&
   +2D0*r1x2E*(VS0(20,15)-ZxZpE*VS1(20,15))&
   +3D0*HfxZpE*VS1(10,30)
VS0(20,52)=QCz*VS0(20,31)+WQz*VS1(20,31)-r1x2E*VR1(20,31)&
   +2D0*r1x2E*(VS0(20,16)-ZxZpE*VS1(20,16))&
   +3D0*HfxZpE*VS1(10,31)
VS0(20,53)=QCz*VS0(20,32)+WQz*VS1(20,32)-r1x2E*VR1(20,32)&
   +2D0*r1x2E*(VS0(20,17)-ZxZpE*VS1(20,17))&
   +3D0*HfxZpE*VS1(10,32)
VS0(20,54)=QCz*VS0(20,33)+WQz*VS1(20,33)-r1x2E*VR1(20,33)&
   +3D0*r1x2E*(VS0(20,18)-ZxZpE*VS1(20,18))&
   +3D0*HfxZpE*VS1(10,33)
VS0(20,55)=QCz*VS0(20,34)+WQz*VS1(20,34)-r1x2E*VR1(20,34)&
   +3D0*r1x2E*(VS0(20,19)-ZxZpE*VS1(20,19))&
   +3D0*HfxZpE*VS1(10,34)
VS0(20,56)=QCz*VS0(20,35)+WQz*VS1(20,35)-r1x2E*VR1(20,35)&
   +4D0*r1x2E*(VS0(20,20)-ZxZpE*VS1(20,20))&
   +3D0*HfxZpE*VS1(10,35)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRf0h0'
STOP
END SELECT
END SUBROUTINE MVRRf0h0
