!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRj0p0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(38,2)
      V(2)=ExZpE*r1x2Z*VRR1(38,2)
      V(3)=r1x2Z*VRR0(38,3)
      V(4)=ExZpE*r1x2Z*VRR1(38,3)
      V(5)=r1x2Z*VRR0(38,4)
      V(6)=ExZpE*r1x2Z*VRR1(38,4)
      V(7)=r1x2Z*VRR0(39,2)
      V(8)=ExZpE*r1x2Z*VRR1(39,2)
      V(9)=HfxZpE*VRR1(60,1)
      V(10)=r1x2Z*VRR0(39,3)
      V(11)=ExZpE*r1x2Z*VRR1(39,3)
      V(12)=r1x2Z*VRR0(39,4)
      V(13)=ExZpE*r1x2Z*VRR1(39,4)
      V(14)=r1x2Z*VRR0(44,2)
      V(15)=3.D0*V(14)
      V(16)=ExZpE*r1x2Z*VRR1(44,2)
      V(17)=-3.D0*V(16)
      V(18)=r1x2Z*VRR0(44,3)
      V(19)=3.D0*V(18)
      V(20)=ExZpE*r1x2Z*VRR1(44,3)
      V(21)=-3.D0*V(20)
      V(22)=r1x2Z*VRR0(44,4)
      V(23)=3.D0*V(22)
      V(24)=ExZpE*r1x2Z*VRR1(44,4)
      V(25)=-3.D0*V(24)
      V(26)=r1x2Z*VRR0(45,2)
      V(27)=ExZpE*r1x2Z*VRR1(45,2)
      V(28)=HfxZpE*VRR1(67,1)
      V(29)=r1x2Z*VRR0(45,3)
      V(30)=ExZpE*r1x2Z*VRR1(45,3)
      V(31)=r1x2Z*VRR0(45,4)
      V(32)=ExZpE*r1x2Z*VRR1(45,4)
      V(33)=r1x2Z*VRR0(47,2)
      V(34)=ExZpE*r1x2Z*VRR1(47,2)
      V(35)=r1x2Z*VRR0(47,3)
      V(36)=ExZpE*r1x2Z*VRR1(47,3)
      V(37)=r1x2Z*VRR0(47,4)
      V(38)=ExZpE*r1x2Z*VRR1(47,4)
      V(39)=r1x2Z*VRR0(48,2)
      V(40)=3.D0*V(39)
      V(41)=ExZpE*r1x2Z*VRR1(48,2)
      V(42)=-3.D0*V(41)
      V(43)=r1x2Z*VRR0(48,3)
      V(44)=3.D0*V(43)
      V(45)=ExZpE*r1x2Z*VRR1(48,3)
      V(46)=-3.D0*V(45)
      V(47)=r1x2Z*VRR0(48,4)
      V(48)=3.D0*V(47)
      V(49)=ExZpE*r1x2Z*VRR1(48,4)
      V(50)=-3.D0*V(49)
      V(51)=r1x2Z*VRR0(49,2)
      V(52)=ExZpE*r1x2Z*VRR1(49,2)
      V(53)=HfxZpE*VRR1(72,1)
      V(54)=r1x2Z*VRR0(49,3)
      V(55)=ExZpE*r1x2Z*VRR1(49,3)
      V(56)=r1x2Z*VRR0(49,4)
      V(57)=ExZpE*r1x2Z*VRR1(49,4)
      V(58)=3.D0*V(51)
      V(59)=-3.D0*V(52)
      V(60)=3.D0*V(54)
      V(61)=-3.D0*V(55)
      V(62)=3.D0*V(56)
      V(63)=-3.D0*V(57)
      V(64)=r1x2Z*VRR0(50,2)
      V(65)=ExZpE*r1x2Z*VRR1(50,2)
      V(66)=r1x2Z*VRR0(50,3)
      V(67)=ExZpE*r1x2Z*VRR1(50,3)
      V(68)=r1x2Z*VRR0(50,4)
      V(69)=ExZpE*r1x2Z*VRR1(50,4)
      V(70)=r1x2Z*VRR0(51,2)
      V(71)=ExZpE*r1x2Z*VRR1(51,2)
      V(72)=HfxZpE*VRR1(75,1)
      V(73)=r1x2Z*VRR0(51,3)
      V(74)=ExZpE*r1x2Z*VRR1(51,3)
      V(75)=r1x2Z*VRR0(51,4)
      V(76)=ExZpE*r1x2Z*VRR1(51,4)
      V(77)=r1x2Z*VRR0(52,2)
      V(78)=2.D0*V(77)
      V(79)=ExZpE*r1x2Z*VRR1(52,2)
      V(80)=-2.D0*V(79)
      V(81)=HfxZpE*VRR1(76,1)
      V(82)=r1x2Z*VRR0(52,3)
      V(83)=2.D0*V(82)
      V(84)=ExZpE*r1x2Z*VRR1(52,3)
      V(85)=-2.D0*V(84)
      V(86)=r1x2Z*VRR0(52,4)
      V(87)=2.D0*V(86)
      V(88)=ExZpE*r1x2Z*VRR1(52,4)
      V(89)=-2.D0*V(88)
      V(90)=HfxZpE*VRR1(77,1)
      V(91)=r1x2Z*VRR0(53,2)
      V(92)=ExZpE*r1x2Z*VRR1(53,2)
      V(93)=r1x2Z*VRR0(53,3)
      V(94)=ExZpE*r1x2Z*VRR1(53,3)
      V(95)=HfxZpE*VRR1(78,1)
      V(96)=r1x2Z*VRR0(53,4)
      V(97)=ExZpE*r1x2Z*VRR1(53,4)
      VRR0(85,2)=6.D0*r1x2Z*VRR0(36,2)+PAx*VRR0(57,2)-6.D0*ExZpE*r1x2Z*VRR1(36,2)+HfxZpE*VRR1(57,1)+WPx*VRR1(57,2)
      VRR0(85,3)=6.D0*r1x2Z*VRR0(36,3)+PAx*VRR0(57,3)-6.D0*ExZpE*r1x2Z*VRR1(36,3)+WPx*VRR1(57,3)
      VRR0(85,4)=6.D0*r1x2Z*VRR0(36,4)+PAx*VRR0(57,4)-6.D0*ExZpE*r1x2Z*VRR1(36,4)+WPx*VRR1(57,4)
      VRR0(86,2)=5.D0*r1x2Z*VRR0(37,2)+PAx*VRR0(58,2)-5.D0*ExZpE*r1x2Z*VRR1(37,2)+HfxZpE*VRR1(58,1)+WPx*VRR1(58,2)
      VRR0(86,3)=5.D0*r1x2Z*VRR0(37,3)+PAx*VRR0(58,3)-5.D0*ExZpE*r1x2Z*VRR1(37,3)+WPx*VRR1(58,3)
      VRR0(86,4)=5.D0*r1x2Z*VRR0(37,4)+PAx*VRR0(58,4)-5.D0*ExZpE*r1x2Z*VRR1(37,4)+WPx*VRR1(58,4)
      VRR0(87,2)=4.D0*V(1)-4.D0*V(2)+PAx*VRR0(59,2)+HfxZpE*VRR1(59,1)+WPx*VRR1(59,2)
      VRR0(87,3)=4.D0*V(3)-4.D0*V(4)+PAx*VRR0(59,3)+WPx*VRR1(59,3)
      VRR0(87,4)=4.D0*V(5)-4.D0*V(6)+PAx*VRR0(59,4)+WPx*VRR1(59,4)
      VRR0(88,2)=3.D0*V(7)-3.D0*V(8)+V(9)+PAx*VRR0(60,2)+WPx*VRR1(60,2)
      VRR0(88,3)=3.D0*V(10)-3.D0*V(11)+PAx*VRR0(60,3)+WPx*VRR1(60,3)
      VRR0(88,4)=3.D0*V(12)-3.D0*V(13)+PAx*VRR0(60,4)+WPx*VRR1(60,4)
      VRR0(89,2)=3.D0*V(1)-3.D0*V(2)+PAy*VRR0(60,2)+WPy*VRR1(60,2)
      VRR0(89,3)=3.D0*V(3)-3.D0*V(4)+V(9)+PAy*VRR0(60,3)+WPy*VRR1(60,3)
      VRR0(89,4)=3.D0*V(5)-3.D0*V(6)+PAy*VRR0(60,4)+WPy*VRR1(60,4)
      VRR0(90,2)=4.D0*V(7)-4.D0*V(8)+PAy*VRR0(61,2)+WPy*VRR1(61,2)
      VRR0(90,3)=4.D0*V(10)-4.D0*V(11)+PAy*VRR0(61,3)+HfxZpE*VRR1(61,1)+WPy*VRR1(61,3)
      VRR0(90,4)=4.D0*V(12)-4.D0*V(13)+PAy*VRR0(61,4)+WPy*VRR1(61,4)
      VRR0(91,2)=5.D0*r1x2Z*VRR0(40,2)+PAy*VRR0(62,2)-5.D0*ExZpE*r1x2Z*VRR1(40,2)+WPy*VRR1(62,2)
      VRR0(91,3)=5.D0*r1x2Z*VRR0(40,3)+PAy*VRR0(62,3)-5.D0*ExZpE*r1x2Z*VRR1(40,3)+HfxZpE*VRR1(62,1)+WPy*VRR1(62,3)
      VRR0(91,4)=5.D0*r1x2Z*VRR0(40,4)+PAy*VRR0(62,4)-5.D0*ExZpE*r1x2Z*VRR1(40,4)+WPy*VRR1(62,4)
      VRR0(92,2)=6.D0*r1x2Z*VRR0(41,2)+PAy*VRR0(63,2)-6.D0*ExZpE*r1x2Z*VRR1(41,2)+WPy*VRR1(63,2)
      VRR0(92,3)=6.D0*r1x2Z*VRR0(41,3)+PAy*VRR0(63,3)-6.D0*ExZpE*r1x2Z*VRR1(41,3)+HfxZpE*VRR1(63,1)+WPy*VRR1(63,3)
      VRR0(92,4)=6.D0*r1x2Z*VRR0(41,4)+PAy*VRR0(63,4)-6.D0*ExZpE*r1x2Z*VRR1(41,4)+WPy*VRR1(63,4)
      VRR0(93,2)=5.D0*r1x2Z*VRR0(42,2)+PAx*VRR0(64,2)-5.D0*ExZpE*r1x2Z*VRR1(42,2)+HfxZpE*VRR1(64,1)+WPx*VRR1(64,2)
      VRR0(93,3)=5.D0*r1x2Z*VRR0(42,3)+PAx*VRR0(64,3)-5.D0*ExZpE*r1x2Z*VRR1(42,3)+WPx*VRR1(64,3)
      VRR0(93,4)=5.D0*r1x2Z*VRR0(42,4)+PAx*VRR0(64,4)-5.D0*ExZpE*r1x2Z*VRR1(42,4)+WPx*VRR1(64,4)
      VRR0(94,2)=4.D0*r1x2Z*VRR0(43,2)+PAx*VRR0(65,2)-4.D0*ExZpE*r1x2Z*VRR1(43,2)+HfxZpE*VRR1(65,1)+WPx*VRR1(65,2)
      VRR0(94,3)=4.D0*r1x2Z*VRR0(43,3)+PAx*VRR0(65,3)-4.D0*ExZpE*r1x2Z*VRR1(43,3)+WPx*VRR1(65,3)
      VRR0(94,4)=4.D0*r1x2Z*VRR0(43,4)+PAx*VRR0(65,4)-4.D0*ExZpE*r1x2Z*VRR1(43,4)+WPx*VRR1(65,4)
      VRR0(95,2)=V(15)+V(17)+PAx*VRR0(66,2)+HfxZpE*VRR1(66,1)+WPx*VRR1(66,2)
      VRR0(95,3)=V(19)+V(21)+PAx*VRR0(66,3)+WPx*VRR1(66,3)
      VRR0(95,4)=V(23)+V(25)+PAx*VRR0(66,4)+WPx*VRR1(66,4)
      VRR0(96,2)=2.D0*V(26)-2.D0*V(27)+V(28)+PAx*VRR0(67,2)+WPx*VRR1(67,2)
      VRR0(96,3)=2.D0*V(29)-2.D0*V(30)+PAx*VRR0(67,3)+WPx*VRR1(67,3)
      VRR0(96,4)=2.D0*V(31)-2.D0*V(32)+PAx*VRR0(67,4)+WPx*VRR1(67,4)
      VRR0(97,2)=V(15)+V(17)+PAy*VRR0(67,2)+WPy*VRR1(67,2)
      VRR0(97,3)=V(19)+V(21)+V(28)+PAy*VRR0(67,3)+WPy*VRR1(67,3)
      VRR0(97,4)=V(23)+V(25)+PAy*VRR0(67,4)+WPy*VRR1(67,4)
      VRR0(98,2)=4.D0*V(26)-4.D0*V(27)+PAy*VRR0(68,2)+WPy*VRR1(68,2)
      VRR0(98,3)=4.D0*V(29)-4.D0*V(30)+PAy*VRR0(68,3)+HfxZpE*VRR1(68,1)+WPy*VRR1(68,3)
      VRR0(98,4)=4.D0*V(31)-4.D0*V(32)+PAy*VRR0(68,4)+WPy*VRR1(68,4)
      VRR0(99,2)=5.D0*r1x2Z*VRR0(46,2)+PAy*VRR0(69,2)-5.D0*ExZpE*r1x2Z*VRR1(46,2)+WPy*VRR1(69,2)
      VRR0(99,3)=5.D0*r1x2Z*VRR0(46,3)+PAy*VRR0(69,3)-5.D0*ExZpE*r1x2Z*VRR1(46,3)+HfxZpE*VRR1(69,1)+WPy*VRR1(69,3)
      VRR0(99,4)=5.D0*r1x2Z*VRR0(46,4)+PAy*VRR0(69,4)-5.D0*ExZpE*r1x2Z*VRR1(46,4)+WPy*VRR1(69,4)
      VRR0(100,2)=4.D0*V(33)-4.D0*V(34)+PAx*VRR0(70,2)+HfxZpE*VRR1(70,1)+WPx*VRR1(70,2)
      VRR0(100,3)=4.D0*V(35)-4.D0*V(36)+PAx*VRR0(70,3)+WPx*VRR1(70,3)
      VRR0(100,4)=4.D0*V(37)-4.D0*V(38)+PAx*VRR0(70,4)+WPx*VRR1(70,4)
      VRR0(101,2)=V(40)+V(42)+PAx*VRR0(71,2)+HfxZpE*VRR1(71,1)+WPx*VRR1(71,2)
      VRR0(101,3)=V(44)+V(46)+PAx*VRR0(71,3)+WPx*VRR1(71,3)
      VRR0(101,4)=V(48)+V(50)+PAx*VRR0(71,4)+WPx*VRR1(71,4)
      VRR0(102,2)=2.D0*V(51)-2.D0*V(52)+V(53)+PAx*VRR0(72,2)+WPx*VRR1(72,2)
      VRR0(102,3)=2.D0*V(54)-2.D0*V(55)+PAx*VRR0(72,3)+WPx*VRR1(72,3)
      VRR0(102,4)=2.D0*V(56)-2.D0*V(57)+PAx*VRR0(72,4)+WPx*VRR1(72,4)
      VRR0(103,2)=2.D0*V(39)-2.D0*V(41)+PAy*VRR0(72,2)+WPy*VRR1(72,2)
      VRR0(103,3)=2.D0*V(43)-2.D0*V(45)+V(53)+PAy*VRR0(72,3)+WPy*VRR1(72,3)
      VRR0(103,4)=2.D0*V(47)-2.D0*V(49)+PAy*VRR0(72,4)+WPy*VRR1(72,4)
      VRR0(104,2)=V(58)+V(59)+PAy*VRR0(73,2)+WPy*VRR1(73,2)
      VRR0(104,3)=V(60)+V(61)+PAy*VRR0(73,3)+HfxZpE*VRR1(73,1)+WPy*VRR1(73,3)
      VRR0(104,4)=V(62)+V(63)+PAy*VRR0(73,4)+WPy*VRR1(73,4)
      VRR0(105,2)=4.D0*V(64)-4.D0*V(65)+PAy*VRR0(74,2)+WPy*VRR1(74,2)
      VRR0(105,3)=4.D0*V(66)-4.D0*V(67)+PAy*VRR0(74,3)+HfxZpE*VRR1(74,1)+WPy*VRR1(74,3)
      VRR0(105,4)=4.D0*V(68)-4.D0*V(69)+PAy*VRR0(74,4)+WPy*VRR1(74,4)
      VRR0(106,2)=3.D0*V(70)-3.D0*V(71)+V(72)+PAx*VRR0(75,2)+WPx*VRR1(75,2)
      VRR0(106,3)=3.D0*V(73)-3.D0*V(74)+PAx*VRR0(75,3)+WPx*VRR1(75,3)
      VRR0(106,4)=3.D0*V(75)-3.D0*V(76)+PAx*VRR0(75,4)+WPx*VRR1(75,4)
      VRR0(107,2)=V(78)+V(80)+V(81)+PAx*VRR0(76,2)+WPx*VRR1(76,2)
      VRR0(107,3)=V(83)+V(85)+PAx*VRR0(76,3)+WPx*VRR1(76,3)
      VRR0(107,4)=V(87)+V(89)+PAx*VRR0(76,4)+WPx*VRR1(76,4)
      VRR0(108,2)=2.D0*V(14)-2.D0*V(16)+PAz*VRR0(72,2)+WPz*VRR1(72,2)
      VRR0(108,3)=2.D0*V(18)-2.D0*V(20)+PAz*VRR0(72,3)+WPz*VRR1(72,3)
      VRR0(108,4)=2.D0*V(22)-2.D0*V(24)+V(53)+PAz*VRR0(72,4)+WPz*VRR1(72,4)
      VRR0(109,2)=V(78)+V(80)+PAy*VRR0(77,2)+WPy*VRR1(77,2)
      VRR0(109,3)=V(83)+V(85)+V(90)+PAy*VRR0(77,3)+WPy*VRR1(77,3)
      VRR0(109,4)=V(87)+V(89)+PAy*VRR0(77,4)+WPy*VRR1(77,4)
      VRR0(110,2)=3.D0*V(91)-3.D0*V(92)+PAy*VRR0(78,2)+WPy*VRR1(78,2)
      VRR0(110,3)=3.D0*V(93)-3.D0*V(94)+V(95)+PAy*VRR0(78,3)+WPy*VRR1(78,3)
      VRR0(110,4)=3.D0*V(96)-3.D0*V(97)+PAy*VRR0(78,4)+WPy*VRR1(78,4)
      VRR0(111,2)=3.D0*V(33)-3.D0*V(34)+PAz*VRR0(75,2)+WPz*VRR1(75,2)
      VRR0(111,3)=3.D0*V(35)-3.D0*V(36)+PAz*VRR0(75,3)+WPz*VRR1(75,3)
      VRR0(111,4)=3.D0*V(37)-3.D0*V(38)+V(72)+PAz*VRR0(75,4)+WPz*VRR1(75,4)
      VRR0(112,2)=V(40)+V(42)+PAz*VRR0(76,2)+WPz*VRR1(76,2)
      VRR0(112,3)=V(44)+V(46)+PAz*VRR0(76,3)+WPz*VRR1(76,3)
      VRR0(112,4)=V(48)+V(50)+V(81)+PAz*VRR0(76,4)+WPz*VRR1(76,4)
      VRR0(113,2)=V(58)+V(59)+PAz*VRR0(77,2)+WPz*VRR1(77,2)
      VRR0(113,3)=V(60)+V(61)+PAz*VRR0(77,3)+WPz*VRR1(77,3)
      VRR0(113,4)=V(62)+V(63)+V(90)+PAz*VRR0(77,4)+WPz*VRR1(77,4)
      VRR0(114,2)=3.D0*V(64)-3.D0*V(65)+PAz*VRR0(78,2)+WPz*VRR1(78,2)
      VRR0(114,3)=3.D0*V(66)-3.D0*V(67)+PAz*VRR0(78,3)+WPz*VRR1(78,3)
      VRR0(114,4)=3.D0*V(68)-3.D0*V(69)+V(95)+PAz*VRR0(78,4)+WPz*VRR1(78,4)
      VRR0(115,2)=4.D0*V(70)-4.D0*V(71)+PAz*VRR0(79,2)+WPz*VRR1(79,2)
      VRR0(115,3)=4.D0*V(73)-4.D0*V(74)+PAz*VRR0(79,3)+WPz*VRR1(79,3)
      VRR0(115,4)=4.D0*V(75)-4.D0*V(76)+PAz*VRR0(79,4)+HfxZpE*VRR1(79,1)+WPz*VRR1(79,4)
      VRR0(116,2)=4.D0*V(77)-4.D0*V(79)+PAz*VRR0(80,2)+WPz*VRR1(80,2)
      VRR0(116,3)=4.D0*V(82)-4.D0*V(84)+PAz*VRR0(80,3)+WPz*VRR1(80,3)
      VRR0(116,4)=4.D0*V(86)-4.D0*V(88)+PAz*VRR0(80,4)+HfxZpE*VRR1(80,1)+WPz*VRR1(80,4)
      VRR0(117,2)=4.D0*V(91)-4.D0*V(92)+PAz*VRR0(81,2)+WPz*VRR1(81,2)
      VRR0(117,3)=4.D0*V(93)-4.D0*V(94)+PAz*VRR0(81,3)+WPz*VRR1(81,3)
      VRR0(117,4)=4.D0*V(96)-4.D0*V(97)+PAz*VRR0(81,4)+HfxZpE*VRR1(81,1)+WPz*VRR1(81,4)
      VRR0(118,2)=5.D0*r1x2Z*VRR0(54,2)+PAz*VRR0(82,2)-5.D0*ExZpE*r1x2Z*VRR1(54,2)+WPz*VRR1(82,2)
      VRR0(118,3)=5.D0*r1x2Z*VRR0(54,3)+PAz*VRR0(82,3)-5.D0*ExZpE*r1x2Z*VRR1(54,3)+WPz*VRR1(82,3)
      VRR0(118,4)=5.D0*r1x2Z*VRR0(54,4)+PAz*VRR0(82,4)-5.D0*ExZpE*r1x2Z*VRR1(54,4)+HfxZpE*VRR1(82,1)+WPz*VRR1(82,4)
      VRR0(119,2)=5.D0*r1x2Z*VRR0(55,2)+PAz*VRR0(83,2)-5.D0*ExZpE*r1x2Z*VRR1(55,2)+WPz*VRR1(83,2)
      VRR0(119,3)=5.D0*r1x2Z*VRR0(55,3)+PAz*VRR0(83,3)-5.D0*ExZpE*r1x2Z*VRR1(55,3)+WPz*VRR1(83,3)
      VRR0(119,4)=5.D0*r1x2Z*VRR0(55,4)+PAz*VRR0(83,4)-5.D0*ExZpE*r1x2Z*VRR1(55,4)+HfxZpE*VRR1(83,1)+WPz*VRR1(83,4)
      VRR0(120,2)=6.D0*r1x2Z*VRR0(56,2)+PAz*VRR0(84,2)-6.D0*ExZpE*r1x2Z*VRR1(56,2)+WPz*VRR1(84,2)
      VRR0(120,3)=6.D0*r1x2Z*VRR0(56,3)+PAz*VRR0(84,3)-6.D0*ExZpE*r1x2Z*VRR1(56,3)+WPz*VRR1(84,3)
      VRR0(120,4)=6.D0*r1x2Z*VRR0(56,4)+PAz*VRR0(84,4)-6.D0*ExZpE*r1x2Z*VRR1(56,4)+HfxZpE*VRR1(84,1)+WPz*VRR1(84,4)
END SUBROUTINE VRRj0p0
