!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRi0p0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(23,2)
      V(2)=3.D0*V(1)
      V(3)=ExZpE*r1x2Z*VRR1(23,2)
      V(4)=-3.D0*V(3)
      V(5)=r1x2Z*VRR0(23,3)
      V(6)=3.D0*V(5)
      V(7)=ExZpE*r1x2Z*VRR1(23,3)
      V(8)=-3.D0*V(7)
      V(9)=r1x2Z*VRR0(23,4)
      V(10)=3.D0*V(9)
      V(11)=ExZpE*r1x2Z*VRR1(23,4)
      V(12)=-3.D0*V(11)
      V(13)=r1x2Z*VRR0(24,2)
      V(14)=ExZpE*r1x2Z*VRR1(24,2)
      V(15)=HfxZpE*VRR1(39,1)
      V(16)=r1x2Z*VRR0(24,3)
      V(17)=ExZpE*r1x2Z*VRR1(24,3)
      V(18)=r1x2Z*VRR0(24,4)
      V(19)=ExZpE*r1x2Z*VRR1(24,4)
      V(20)=r1x2Z*VRR0(27,2)
      V(21)=ExZpE*r1x2Z*VRR1(27,2)
      V(22)=r1x2Z*VRR0(27,3)
      V(23)=ExZpE*r1x2Z*VRR1(27,3)
      V(24)=r1x2Z*VRR0(27,4)
      V(25)=ExZpE*r1x2Z*VRR1(27,4)
      V(26)=r1x2Z*VRR0(28,2)
      V(27)=2.D0*V(26)
      V(28)=ExZpE*r1x2Z*VRR1(28,2)
      V(29)=-2.D0*V(28)
      V(30)=HfxZpE*VRR1(44,1)
      V(31)=r1x2Z*VRR0(28,3)
      V(32)=2.D0*V(31)
      V(33)=ExZpE*r1x2Z*VRR1(28,3)
      V(34)=-2.D0*V(33)
      V(35)=r1x2Z*VRR0(28,4)
      V(36)=2.D0*V(35)
      V(37)=ExZpE*r1x2Z*VRR1(28,4)
      V(38)=-2.D0*V(37)
      V(39)=2.D0*V(20)
      V(40)=-2.D0*V(21)
      V(41)=2.D0*V(22)
      V(42)=-2.D0*V(23)
      V(43)=2.D0*V(24)
      V(44)=-2.D0*V(25)
      V(45)=r1x2Z*VRR0(30,2)
      V(46)=3.D0*V(45)
      V(47)=ExZpE*r1x2Z*VRR1(30,2)
      V(48)=-3.D0*V(47)
      V(49)=r1x2Z*VRR0(30,3)
      V(50)=3.D0*V(49)
      V(51)=ExZpE*r1x2Z*VRR1(30,3)
      V(52)=-3.D0*V(51)
      V(53)=r1x2Z*VRR0(30,4)
      V(54)=3.D0*V(53)
      V(55)=ExZpE*r1x2Z*VRR1(30,4)
      V(56)=-3.D0*V(55)
      V(57)=r1x2Z*VRR0(31,2)
      V(58)=2.D0*V(57)
      V(59)=ExZpE*r1x2Z*VRR1(31,2)
      V(60)=-2.D0*V(59)
      V(61)=HfxZpE*VRR1(48,1)
      V(62)=r1x2Z*VRR0(31,3)
      V(63)=2.D0*V(62)
      V(64)=ExZpE*r1x2Z*VRR1(31,3)
      V(65)=-2.D0*V(64)
      V(66)=r1x2Z*VRR0(31,4)
      V(67)=2.D0*V(66)
      V(68)=ExZpE*r1x2Z*VRR1(31,4)
      V(69)=-2.D0*V(68)
      V(70)=r1x2Z*VRR0(32,2)
      V(71)=ExZpE*r1x2Z*VRR1(32,2)
      V(72)=HfxZpE*VRR1(49,1)
      V(73)=r1x2Z*VRR0(32,3)
      V(74)=ExZpE*r1x2Z*VRR1(32,3)
      V(75)=r1x2Z*VRR0(32,4)
      V(76)=ExZpE*r1x2Z*VRR1(32,4)
      V(77)=3.D0*V(70)
      V(78)=-3.D0*V(71)
      V(79)=3.D0*V(73)
      V(80)=-3.D0*V(74)
      V(81)=3.D0*V(75)
      V(82)=-3.D0*V(76)
      V(83)=r1x2Z*VRR0(33,2)
      V(84)=ExZpE*r1x2Z*VRR1(33,2)
      V(85)=HfxZpE*VRR1(51,1)
      V(86)=r1x2Z*VRR0(33,3)
      V(87)=ExZpE*r1x2Z*VRR1(33,3)
      V(88)=r1x2Z*VRR0(33,4)
      V(89)=ExZpE*r1x2Z*VRR1(33,4)
      V(90)=r1x2Z*VRR0(34,2)
      V(91)=ExZpE*r1x2Z*VRR1(34,2)
      V(92)=r1x2Z*VRR0(34,3)
      V(93)=ExZpE*r1x2Z*VRR1(34,3)
      V(94)=HfxZpE*VRR1(53,1)
      V(95)=r1x2Z*VRR0(34,4)
      V(96)=ExZpE*r1x2Z*VRR1(34,4)
      VRR0(57,2)=5.D0*r1x2Z*VRR0(21,2)+PAx*VRR0(36,2)-5.D0*ExZpE*r1x2Z*VRR1(21,2)+HfxZpE*VRR1(36,1)+WPx*VRR1(36,2)
      VRR0(57,3)=5.D0*r1x2Z*VRR0(21,3)+PAx*VRR0(36,3)-5.D0*ExZpE*r1x2Z*VRR1(21,3)+WPx*VRR1(36,3)
      VRR0(57,4)=5.D0*r1x2Z*VRR0(21,4)+PAx*VRR0(36,4)-5.D0*ExZpE*r1x2Z*VRR1(21,4)+WPx*VRR1(36,4)
      VRR0(58,2)=4.D0*r1x2Z*VRR0(22,2)+PAx*VRR0(37,2)-4.D0*ExZpE*r1x2Z*VRR1(22,2)+HfxZpE*VRR1(37,1)+WPx*VRR1(37,2)
      VRR0(58,3)=4.D0*r1x2Z*VRR0(22,3)+PAx*VRR0(37,3)-4.D0*ExZpE*r1x2Z*VRR1(22,3)+WPx*VRR1(37,3)
      VRR0(58,4)=4.D0*r1x2Z*VRR0(22,4)+PAx*VRR0(37,4)-4.D0*ExZpE*r1x2Z*VRR1(22,4)+WPx*VRR1(37,4)
      VRR0(59,2)=V(2)+V(4)+PAx*VRR0(38,2)+HfxZpE*VRR1(38,1)+WPx*VRR1(38,2)
      VRR0(59,3)=V(6)+V(8)+PAx*VRR0(38,3)+WPx*VRR1(38,3)
      VRR0(59,4)=V(10)+V(12)+PAx*VRR0(38,4)+WPx*VRR1(38,4)
      VRR0(60,2)=2.D0*V(13)-2.D0*V(14)+V(15)+PAx*VRR0(39,2)+WPx*VRR1(39,2)
      VRR0(60,3)=2.D0*V(16)-2.D0*V(17)+PAx*VRR0(39,3)+WPx*VRR1(39,3)
      VRR0(60,4)=2.D0*V(18)-2.D0*V(19)+PAx*VRR0(39,4)+WPx*VRR1(39,4)
      VRR0(61,2)=V(2)+V(4)+PAy*VRR0(39,2)+WPy*VRR1(39,2)
      VRR0(61,3)=V(6)+V(8)+V(15)+PAy*VRR0(39,3)+WPy*VRR1(39,3)
      VRR0(61,4)=V(10)+V(12)+PAy*VRR0(39,4)+WPy*VRR1(39,4)
      VRR0(62,2)=4.D0*V(13)-4.D0*V(14)+PAy*VRR0(40,2)+WPy*VRR1(40,2)
      VRR0(62,3)=4.D0*V(16)-4.D0*V(17)+PAy*VRR0(40,3)+HfxZpE*VRR1(40,1)+WPy*VRR1(40,3)
      VRR0(62,4)=4.D0*V(18)-4.D0*V(19)+PAy*VRR0(40,4)+WPy*VRR1(40,4)
      VRR0(63,2)=5.D0*r1x2Z*VRR0(25,2)+PAy*VRR0(41,2)-5.D0*ExZpE*r1x2Z*VRR1(25,2)+WPy*VRR1(41,2)
      VRR0(63,3)=5.D0*r1x2Z*VRR0(25,3)+PAy*VRR0(41,3)-5.D0*ExZpE*r1x2Z*VRR1(25,3)+HfxZpE*VRR1(41,1)+WPy*VRR1(41,3)
      VRR0(63,4)=5.D0*r1x2Z*VRR0(25,4)+PAy*VRR0(41,4)-5.D0*ExZpE*r1x2Z*VRR1(25,4)+WPy*VRR1(41,4)
      VRR0(64,2)=4.D0*r1x2Z*VRR0(26,2)+PAx*VRR0(42,2)-4.D0*ExZpE*r1x2Z*VRR1(26,2)+HfxZpE*VRR1(42,1)+WPx*VRR1(42,2)
      VRR0(64,3)=4.D0*r1x2Z*VRR0(26,3)+PAx*VRR0(42,3)-4.D0*ExZpE*r1x2Z*VRR1(26,3)+WPx*VRR1(42,3)
      VRR0(64,4)=4.D0*r1x2Z*VRR0(26,4)+PAx*VRR0(42,4)-4.D0*ExZpE*r1x2Z*VRR1(26,4)+WPx*VRR1(42,4)
      VRR0(65,2)=3.D0*V(20)-3.D0*V(21)+PAx*VRR0(43,2)+HfxZpE*VRR1(43,1)+WPx*VRR1(43,2)
      VRR0(65,3)=3.D0*V(22)-3.D0*V(23)+PAx*VRR0(43,3)+WPx*VRR1(43,3)
      VRR0(65,4)=3.D0*V(24)-3.D0*V(25)+PAx*VRR0(43,4)+WPx*VRR1(43,4)
      VRR0(66,2)=V(27)+V(29)+V(30)+PAx*VRR0(44,2)+WPx*VRR1(44,2)
      VRR0(66,3)=V(32)+V(34)+PAx*VRR0(44,3)+WPx*VRR1(44,3)
      VRR0(66,4)=V(36)+V(38)+PAx*VRR0(44,4)+WPx*VRR1(44,4)
      VRR0(67,2)=V(39)+V(40)+PAy*VRR0(44,2)+WPy*VRR1(44,2)
      VRR0(67,3)=V(30)+V(41)+V(42)+PAy*VRR0(44,3)+WPy*VRR1(44,3)
      VRR0(67,4)=V(43)+V(44)+PAy*VRR0(44,4)+WPy*VRR1(44,4)
      VRR0(68,2)=3.D0*V(26)-3.D0*V(28)+PAy*VRR0(45,2)+WPy*VRR1(45,2)
      VRR0(68,3)=3.D0*V(31)-3.D0*V(33)+PAy*VRR0(45,3)+HfxZpE*VRR1(45,1)+WPy*VRR1(45,3)
      VRR0(68,4)=3.D0*V(35)-3.D0*V(37)+PAy*VRR0(45,4)+WPy*VRR1(45,4)
      VRR0(69,2)=4.D0*r1x2Z*VRR0(29,2)+PAy*VRR0(46,2)-4.D0*ExZpE*r1x2Z*VRR1(29,2)+WPy*VRR1(46,2)
      VRR0(69,3)=4.D0*r1x2Z*VRR0(29,3)+PAy*VRR0(46,3)-4.D0*ExZpE*r1x2Z*VRR1(29,3)+HfxZpE*VRR1(46,1)+WPy*VRR1(46,3)
      VRR0(69,4)=4.D0*r1x2Z*VRR0(29,4)+PAy*VRR0(46,4)-4.D0*ExZpE*r1x2Z*VRR1(29,4)+WPy*VRR1(46,4)
      VRR0(70,2)=V(46)+V(48)+PAx*VRR0(47,2)+HfxZpE*VRR1(47,1)+WPx*VRR1(47,2)
      VRR0(70,3)=V(50)+V(52)+PAx*VRR0(47,3)+WPx*VRR1(47,3)
      VRR0(70,4)=V(54)+V(56)+PAx*VRR0(47,4)+WPx*VRR1(47,4)
      VRR0(71,2)=V(58)+V(60)+V(61)+PAx*VRR0(48,2)+WPx*VRR1(48,2)
      VRR0(71,3)=V(63)+V(65)+PAx*VRR0(48,3)+WPx*VRR1(48,3)
      VRR0(71,4)=V(67)+V(69)+PAx*VRR0(48,4)+WPx*VRR1(48,4)
      VRR0(72,2)=V(70)-V(71)+V(72)+PAx*VRR0(49,2)+WPx*VRR1(49,2)
      VRR0(72,3)=V(73)-V(74)+PAx*VRR0(49,3)+WPx*VRR1(49,3)
      VRR0(72,4)=V(75)-V(76)+PAx*VRR0(49,4)+WPx*VRR1(49,4)
      VRR0(73,2)=V(58)+V(60)+PAy*VRR0(49,2)+WPy*VRR1(49,2)
      VRR0(73,3)=V(63)+V(65)+V(72)+PAy*VRR0(49,3)+WPy*VRR1(49,3)
      VRR0(73,4)=V(67)+V(69)+PAy*VRR0(49,4)+WPy*VRR1(49,4)
      VRR0(74,2)=V(77)+V(78)+PAy*VRR0(50,2)+WPy*VRR1(50,2)
      VRR0(74,3)=V(79)+V(80)+PAy*VRR0(50,3)+HfxZpE*VRR1(50,1)+WPy*VRR1(50,3)
      VRR0(74,4)=V(81)+V(82)+PAy*VRR0(50,4)+WPy*VRR1(50,4)
      VRR0(75,2)=2.D0*V(83)-2.D0*V(84)+V(85)+PAx*VRR0(51,2)+WPx*VRR1(51,2)
      VRR0(75,3)=2.D0*V(86)-2.D0*V(87)+PAx*VRR0(51,3)+WPx*VRR1(51,3)
      VRR0(75,4)=2.D0*V(88)-2.D0*V(89)+PAx*VRR0(51,4)+WPx*VRR1(51,4)
      VRR0(76,2)=V(39)+V(40)+PAz*VRR0(48,2)+WPz*VRR1(48,2)
      VRR0(76,3)=V(41)+V(42)+PAz*VRR0(48,3)+WPz*VRR1(48,3)
      VRR0(76,4)=V(43)+V(44)+V(61)+PAz*VRR0(48,4)+WPz*VRR1(48,4)
      VRR0(77,2)=V(27)+V(29)+PAz*VRR0(49,2)+WPz*VRR1(49,2)
      VRR0(77,3)=V(32)+V(34)+PAz*VRR0(49,3)+WPz*VRR1(49,3)
      VRR0(77,4)=V(36)+V(38)+V(72)+PAz*VRR0(49,4)+WPz*VRR1(49,4)
      VRR0(78,2)=2.D0*V(90)-2.D0*V(91)+PAy*VRR0(53,2)+WPy*VRR1(53,2)
      VRR0(78,3)=2.D0*V(92)-2.D0*V(93)+V(94)+PAy*VRR0(53,3)+WPy*VRR1(53,3)
      VRR0(78,4)=2.D0*V(95)-2.D0*V(96)+PAy*VRR0(53,4)+WPy*VRR1(53,4)
      VRR0(79,2)=V(46)+V(48)+PAz*VRR0(51,2)+WPz*VRR1(51,2)
      VRR0(79,3)=V(50)+V(52)+PAz*VRR0(51,3)+WPz*VRR1(51,3)
      VRR0(79,4)=V(54)+V(56)+V(85)+PAz*VRR0(51,4)+WPz*VRR1(51,4)
      VRR0(80,2)=3.D0*V(57)-3.D0*V(59)+PAz*VRR0(52,2)+WPz*VRR1(52,2)
      VRR0(80,3)=3.D0*V(62)-3.D0*V(64)+PAz*VRR0(52,3)+WPz*VRR1(52,3)
      VRR0(80,4)=3.D0*V(66)-3.D0*V(68)+PAz*VRR0(52,4)+HfxZpE*VRR1(52,1)+WPz*VRR1(52,4)
      VRR0(81,2)=V(77)+V(78)+PAz*VRR0(53,2)+WPz*VRR1(53,2)
      VRR0(81,3)=V(79)+V(80)+PAz*VRR0(53,3)+WPz*VRR1(53,3)
      VRR0(81,4)=V(81)+V(82)+V(94)+PAz*VRR0(53,4)+WPz*VRR1(53,4)
      VRR0(82,2)=4.D0*V(83)-4.D0*V(84)+PAz*VRR0(54,2)+WPz*VRR1(54,2)
      VRR0(82,3)=4.D0*V(86)-4.D0*V(87)+PAz*VRR0(54,3)+WPz*VRR1(54,3)
      VRR0(82,4)=4.D0*V(88)-4.D0*V(89)+PAz*VRR0(54,4)+HfxZpE*VRR1(54,1)+WPz*VRR1(54,4)
      VRR0(83,2)=4.D0*V(90)-4.D0*V(91)+PAz*VRR0(55,2)+WPz*VRR1(55,2)
      VRR0(83,3)=4.D0*V(92)-4.D0*V(93)+PAz*VRR0(55,3)+WPz*VRR1(55,3)
      VRR0(83,4)=4.D0*V(95)-4.D0*V(96)+PAz*VRR0(55,4)+HfxZpE*VRR1(55,1)+WPz*VRR1(55,4)
      VRR0(84,2)=5.D0*r1x2Z*VRR0(35,2)+PAz*VRR0(56,2)-5.D0*ExZpE*r1x2Z*VRR1(35,2)+WPz*VRR1(56,2)
      VRR0(84,3)=5.D0*r1x2Z*VRR0(35,3)+PAz*VRR0(56,3)-5.D0*ExZpE*r1x2Z*VRR1(35,3)+WPz*VRR1(56,3)
      VRR0(84,4)=5.D0*r1x2Z*VRR0(35,4)+PAz*VRR0(56,4)-5.D0*ExZpE*r1x2Z*VRR1(35,4)+HfxZpE*VRR1(56,1)+WPz*VRR1(56,4)
END SUBROUTINE VRRi0p0
SUBROUTINE MVRRi0p0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(57,2)=PAx*VS0(36,2)+WPx*VS1(36,2)+r1x2Z*VR1(36,2)&
   +5D0*r1x2Z*(VS0(21,2)-ExZpE*VS1(21,2))&
   +HfxZpE*VS1(36,1)
VS0(57,3)=PAx*VS0(36,3)+WPx*VS1(36,3)+r1x2Z*VR1(36,3)&
   +5D0*r1x2Z*(VS0(21,3)-ExZpE*VS1(21,3))
VS0(57,4)=PAx*VS0(36,4)+WPx*VS1(36,4)+r1x2Z*VR1(36,4)&
   +5D0*r1x2Z*(VS0(21,4)-ExZpE*VS1(21,4))
VS0(58,2)=PAx*VS0(37,2)+WPx*VS1(37,2)+r1x2Z*VR1(37,2)&
   +4D0*r1x2Z*(VS0(22,2)-ExZpE*VS1(22,2))&
   +HfxZpE*VS1(37,1)
VS0(58,3)=PAx*VS0(37,3)+WPx*VS1(37,3)+r1x2Z*VR1(37,3)&
   +4D0*r1x2Z*(VS0(22,3)-ExZpE*VS1(22,3))
VS0(58,4)=PAx*VS0(37,4)+WPx*VS1(37,4)+r1x2Z*VR1(37,4)&
   +4D0*r1x2Z*(VS0(22,4)-ExZpE*VS1(22,4))
VS0(59,2)=PAx*VS0(38,2)+WPx*VS1(38,2)+r1x2Z*VR1(38,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))&
   +HfxZpE*VS1(38,1)
VS0(59,3)=PAx*VS0(38,3)+WPx*VS1(38,3)+r1x2Z*VR1(38,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))
VS0(59,4)=PAx*VS0(38,4)+WPx*VS1(38,4)+r1x2Z*VR1(38,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(60,2)=PAx*VS0(39,2)+WPx*VS1(39,2)+r1x2Z*VR1(39,2)&
   +2D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))&
   +HfxZpE*VS1(39,1)
VS0(60,3)=PAx*VS0(39,3)+WPx*VS1(39,3)+r1x2Z*VR1(39,3)&
   +2D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))
VS0(60,4)=PAx*VS0(39,4)+WPx*VS1(39,4)+r1x2Z*VR1(39,4)&
   +2D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(61,2)=PAy*VS0(39,2)+WPy*VS1(39,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))
VS0(61,3)=PAy*VS0(39,3)+WPy*VS1(39,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))&
   +HfxZpE*VS1(39,1)
VS0(61,4)=PAy*VS0(39,4)+WPy*VS1(39,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(62,2)=PAy*VS0(40,2)+WPy*VS1(40,2)&
   +4D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))
VS0(62,3)=PAy*VS0(40,3)+WPy*VS1(40,3)&
   +4D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))&
   +HfxZpE*VS1(40,1)
VS0(62,4)=PAy*VS0(40,4)+WPy*VS1(40,4)&
   +4D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(63,2)=PAy*VS0(41,2)+WPy*VS1(41,2)&
   +5D0*r1x2Z*(VS0(25,2)-ExZpE*VS1(25,2))
VS0(63,3)=PAy*VS0(41,3)+WPy*VS1(41,3)&
   +5D0*r1x2Z*(VS0(25,3)-ExZpE*VS1(25,3))&
   +HfxZpE*VS1(41,1)
VS0(63,4)=PAy*VS0(41,4)+WPy*VS1(41,4)&
   +5D0*r1x2Z*(VS0(25,4)-ExZpE*VS1(25,4))
VS0(64,2)=PAx*VS0(42,2)+WPx*VS1(42,2)+r1x2Z*VR1(42,2)&
   +4D0*r1x2Z*(VS0(26,2)-ExZpE*VS1(26,2))&
   +HfxZpE*VS1(42,1)
VS0(64,3)=PAx*VS0(42,3)+WPx*VS1(42,3)+r1x2Z*VR1(42,3)&
   +4D0*r1x2Z*(VS0(26,3)-ExZpE*VS1(26,3))
VS0(64,4)=PAx*VS0(42,4)+WPx*VS1(42,4)+r1x2Z*VR1(42,4)&
   +4D0*r1x2Z*(VS0(26,4)-ExZpE*VS1(26,4))
VS0(65,2)=PAx*VS0(43,2)+WPx*VS1(43,2)+r1x2Z*VR1(43,2)&
   +3D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))&
   +HfxZpE*VS1(43,1)
VS0(65,3)=PAx*VS0(43,3)+WPx*VS1(43,3)+r1x2Z*VR1(43,3)&
   +3D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(65,4)=PAx*VS0(43,4)+WPx*VS1(43,4)+r1x2Z*VR1(43,4)&
   +3D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(66,2)=PAx*VS0(44,2)+WPx*VS1(44,2)+r1x2Z*VR1(44,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))&
   +HfxZpE*VS1(44,1)
VS0(66,3)=PAx*VS0(44,3)+WPx*VS1(44,3)+r1x2Z*VR1(44,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(66,4)=PAx*VS0(44,4)+WPx*VS1(44,4)+r1x2Z*VR1(44,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(67,2)=PAy*VS0(44,2)+WPy*VS1(44,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(67,3)=PAy*VS0(44,3)+WPy*VS1(44,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))&
   +HfxZpE*VS1(44,1)
VS0(67,4)=PAy*VS0(44,4)+WPy*VS1(44,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(68,2)=PAy*VS0(45,2)+WPy*VS1(45,2)&
   +3D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(68,3)=PAy*VS0(45,3)+WPy*VS1(45,3)&
   +3D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))&
   +HfxZpE*VS1(45,1)
VS0(68,4)=PAy*VS0(45,4)+WPy*VS1(45,4)&
   +3D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(69,2)=PAy*VS0(46,2)+WPy*VS1(46,2)&
   +4D0*r1x2Z*(VS0(29,2)-ExZpE*VS1(29,2))
VS0(69,3)=PAy*VS0(46,3)+WPy*VS1(46,3)&
   +4D0*r1x2Z*(VS0(29,3)-ExZpE*VS1(29,3))&
   +HfxZpE*VS1(46,1)
VS0(69,4)=PAy*VS0(46,4)+WPy*VS1(46,4)&
   +4D0*r1x2Z*(VS0(29,4)-ExZpE*VS1(29,4))
VS0(70,2)=PAx*VS0(47,2)+WPx*VS1(47,2)+r1x2Z*VR1(47,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))&
   +HfxZpE*VS1(47,1)
VS0(70,3)=PAx*VS0(47,3)+WPx*VS1(47,3)+r1x2Z*VR1(47,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(70,4)=PAx*VS0(47,4)+WPx*VS1(47,4)+r1x2Z*VR1(47,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))
VS0(71,2)=PAx*VS0(48,2)+WPx*VS1(48,2)+r1x2Z*VR1(48,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))&
   +HfxZpE*VS1(48,1)
VS0(71,3)=PAx*VS0(48,3)+WPx*VS1(48,3)+r1x2Z*VR1(48,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(71,4)=PAx*VS0(48,4)+WPx*VS1(48,4)+r1x2Z*VR1(48,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(72,2)=PAx*VS0(49,2)+WPx*VS1(49,2)+r1x2Z*VR1(49,2)&
   +r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))&
   +HfxZpE*VS1(49,1)
VS0(72,3)=PAx*VS0(49,3)+WPx*VS1(49,3)+r1x2Z*VR1(49,3)&
   +r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(72,4)=PAx*VS0(49,4)+WPx*VS1(49,4)+r1x2Z*VR1(49,4)&
   +r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(73,2)=PAy*VS0(49,2)+WPy*VS1(49,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(73,3)=PAy*VS0(49,3)+WPy*VS1(49,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))&
   +HfxZpE*VS1(49,1)
VS0(73,4)=PAy*VS0(49,4)+WPy*VS1(49,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(74,2)=PAy*VS0(50,2)+WPy*VS1(50,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(74,3)=PAy*VS0(50,3)+WPy*VS1(50,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))&
   +HfxZpE*VS1(50,1)
VS0(74,4)=PAy*VS0(50,4)+WPy*VS1(50,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(75,2)=PAx*VS0(51,2)+WPx*VS1(51,2)+r1x2Z*VR1(51,2)&
   +2D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))&
   +HfxZpE*VS1(51,1)
VS0(75,3)=PAx*VS0(51,3)+WPx*VS1(51,3)+r1x2Z*VR1(51,3)&
   +2D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(75,4)=PAx*VS0(51,4)+WPx*VS1(51,4)+r1x2Z*VR1(51,4)&
   +2D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))
VS0(76,2)=PAz*VS0(48,2)+WPz*VS1(48,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(76,3)=PAz*VS0(48,3)+WPz*VS1(48,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(76,4)=PAz*VS0(48,4)+WPz*VS1(48,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))&
   +HfxZpE*VS1(48,1)
VS0(77,2)=PAz*VS0(49,2)+WPz*VS1(49,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(77,3)=PAz*VS0(49,3)+WPz*VS1(49,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(77,4)=PAz*VS0(49,4)+WPz*VS1(49,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))&
   +HfxZpE*VS1(49,1)
VS0(78,2)=PAy*VS0(53,2)+WPy*VS1(53,2)&
   +2D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(78,3)=PAy*VS0(53,3)+WPy*VS1(53,3)&
   +2D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))&
   +HfxZpE*VS1(53,1)
VS0(78,4)=PAy*VS0(53,4)+WPy*VS1(53,4)&
   +2D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))
VS0(79,2)=PAz*VS0(51,2)+WPz*VS1(51,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))
VS0(79,3)=PAz*VS0(51,3)+WPz*VS1(51,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(79,4)=PAz*VS0(51,4)+WPz*VS1(51,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))&
   +HfxZpE*VS1(51,1)
VS0(80,2)=PAz*VS0(52,2)+WPz*VS1(52,2)&
   +3D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(80,3)=PAz*VS0(52,3)+WPz*VS1(52,3)&
   +3D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(80,4)=PAz*VS0(52,4)+WPz*VS1(52,4)&
   +3D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))&
   +HfxZpE*VS1(52,1)
VS0(81,2)=PAz*VS0(53,2)+WPz*VS1(53,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(81,3)=PAz*VS0(53,3)+WPz*VS1(53,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(81,4)=PAz*VS0(53,4)+WPz*VS1(53,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))&
   +HfxZpE*VS1(53,1)
VS0(82,2)=PAz*VS0(54,2)+WPz*VS1(54,2)&
   +4D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))
VS0(82,3)=PAz*VS0(54,3)+WPz*VS1(54,3)&
   +4D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(82,4)=PAz*VS0(54,4)+WPz*VS1(54,4)&
   +4D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))&
   +HfxZpE*VS1(54,1)
VS0(83,2)=PAz*VS0(55,2)+WPz*VS1(55,2)&
   +4D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(83,3)=PAz*VS0(55,3)+WPz*VS1(55,3)&
   +4D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))
VS0(83,4)=PAz*VS0(55,4)+WPz*VS1(55,4)&
   +4D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))&
   +HfxZpE*VS1(55,1)
VS0(84,2)=PAz*VS0(56,2)+WPz*VS1(56,2)&
   +5D0*r1x2Z*(VS0(35,2)-ExZpE*VS1(35,2))
VS0(84,3)=PAz*VS0(56,3)+WPz*VS1(56,3)&
   +5D0*r1x2Z*(VS0(35,3)-ExZpE*VS1(35,3))
VS0(84,4)=PAz*VS0(56,4)+WPz*VS1(56,4)&
   +5D0*r1x2Z*(VS0(35,4)-ExZpE*VS1(35,4))&
   +HfxZpE*VS1(56,1)
CASE(2)
VS0(57,2)=PAx*VS0(36,2)+WPx*VS1(36,2)&
   +5D0*r1x2Z*(VS0(21,2)-ExZpE*VS1(21,2))&
   +HfxZpE*VS1(36,1)
VS0(57,3)=PAx*VS0(36,3)+WPx*VS1(36,3)&
   +5D0*r1x2Z*(VS0(21,3)-ExZpE*VS1(21,3))
VS0(57,4)=PAx*VS0(36,4)+WPx*VS1(36,4)&
   +5D0*r1x2Z*(VS0(21,4)-ExZpE*VS1(21,4))
VS0(58,2)=PAx*VS0(37,2)+WPx*VS1(37,2)&
   +4D0*r1x2Z*(VS0(22,2)-ExZpE*VS1(22,2))&
   +HfxZpE*VS1(37,1)
VS0(58,3)=PAx*VS0(37,3)+WPx*VS1(37,3)&
   +4D0*r1x2Z*(VS0(22,3)-ExZpE*VS1(22,3))
VS0(58,4)=PAx*VS0(37,4)+WPx*VS1(37,4)&
   +4D0*r1x2Z*(VS0(22,4)-ExZpE*VS1(22,4))
VS0(59,2)=PAx*VS0(38,2)+WPx*VS1(38,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))&
   +HfxZpE*VS1(38,1)
VS0(59,3)=PAx*VS0(38,3)+WPx*VS1(38,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))
VS0(59,4)=PAx*VS0(38,4)+WPx*VS1(38,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(60,2)=PAx*VS0(39,2)+WPx*VS1(39,2)&
   +2D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))&
   +HfxZpE*VS1(39,1)
VS0(60,3)=PAx*VS0(39,3)+WPx*VS1(39,3)&
   +2D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))
VS0(60,4)=PAx*VS0(39,4)+WPx*VS1(39,4)&
   +2D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(61,2)=PAy*VS0(39,2)+WPy*VS1(39,2)+r1x2Z*VR1(39,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))
VS0(61,3)=PAy*VS0(39,3)+WPy*VS1(39,3)+r1x2Z*VR1(39,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))&
   +HfxZpE*VS1(39,1)
VS0(61,4)=PAy*VS0(39,4)+WPy*VS1(39,4)+r1x2Z*VR1(39,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(62,2)=PAy*VS0(40,2)+WPy*VS1(40,2)+r1x2Z*VR1(40,2)&
   +4D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))
VS0(62,3)=PAy*VS0(40,3)+WPy*VS1(40,3)+r1x2Z*VR1(40,3)&
   +4D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))&
   +HfxZpE*VS1(40,1)
VS0(62,4)=PAy*VS0(40,4)+WPy*VS1(40,4)+r1x2Z*VR1(40,4)&
   +4D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(63,2)=PAy*VS0(41,2)+WPy*VS1(41,2)+r1x2Z*VR1(41,2)&
   +5D0*r1x2Z*(VS0(25,2)-ExZpE*VS1(25,2))
VS0(63,3)=PAy*VS0(41,3)+WPy*VS1(41,3)+r1x2Z*VR1(41,3)&
   +5D0*r1x2Z*(VS0(25,3)-ExZpE*VS1(25,3))&
   +HfxZpE*VS1(41,1)
VS0(63,4)=PAy*VS0(41,4)+WPy*VS1(41,4)+r1x2Z*VR1(41,4)&
   +5D0*r1x2Z*(VS0(25,4)-ExZpE*VS1(25,4))
VS0(64,2)=PAx*VS0(42,2)+WPx*VS1(42,2)&
   +4D0*r1x2Z*(VS0(26,2)-ExZpE*VS1(26,2))&
   +HfxZpE*VS1(42,1)
VS0(64,3)=PAx*VS0(42,3)+WPx*VS1(42,3)&
   +4D0*r1x2Z*(VS0(26,3)-ExZpE*VS1(26,3))
VS0(64,4)=PAx*VS0(42,4)+WPx*VS1(42,4)&
   +4D0*r1x2Z*(VS0(26,4)-ExZpE*VS1(26,4))
VS0(65,2)=PAx*VS0(43,2)+WPx*VS1(43,2)&
   +3D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))&
   +HfxZpE*VS1(43,1)
VS0(65,3)=PAx*VS0(43,3)+WPx*VS1(43,3)&
   +3D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(65,4)=PAx*VS0(43,4)+WPx*VS1(43,4)&
   +3D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(66,2)=PAx*VS0(44,2)+WPx*VS1(44,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))&
   +HfxZpE*VS1(44,1)
VS0(66,3)=PAx*VS0(44,3)+WPx*VS1(44,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(66,4)=PAx*VS0(44,4)+WPx*VS1(44,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(67,2)=PAy*VS0(44,2)+WPy*VS1(44,2)+r1x2Z*VR1(44,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(67,3)=PAy*VS0(44,3)+WPy*VS1(44,3)+r1x2Z*VR1(44,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))&
   +HfxZpE*VS1(44,1)
VS0(67,4)=PAy*VS0(44,4)+WPy*VS1(44,4)+r1x2Z*VR1(44,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(68,2)=PAy*VS0(45,2)+WPy*VS1(45,2)+r1x2Z*VR1(45,2)&
   +3D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(68,3)=PAy*VS0(45,3)+WPy*VS1(45,3)+r1x2Z*VR1(45,3)&
   +3D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))&
   +HfxZpE*VS1(45,1)
VS0(68,4)=PAy*VS0(45,4)+WPy*VS1(45,4)+r1x2Z*VR1(45,4)&
   +3D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(69,2)=PAy*VS0(46,2)+WPy*VS1(46,2)+r1x2Z*VR1(46,2)&
   +4D0*r1x2Z*(VS0(29,2)-ExZpE*VS1(29,2))
VS0(69,3)=PAy*VS0(46,3)+WPy*VS1(46,3)+r1x2Z*VR1(46,3)&
   +4D0*r1x2Z*(VS0(29,3)-ExZpE*VS1(29,3))&
   +HfxZpE*VS1(46,1)
VS0(69,4)=PAy*VS0(46,4)+WPy*VS1(46,4)+r1x2Z*VR1(46,4)&
   +4D0*r1x2Z*(VS0(29,4)-ExZpE*VS1(29,4))
VS0(70,2)=PAx*VS0(47,2)+WPx*VS1(47,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))&
   +HfxZpE*VS1(47,1)
VS0(70,3)=PAx*VS0(47,3)+WPx*VS1(47,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(70,4)=PAx*VS0(47,4)+WPx*VS1(47,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))
VS0(71,2)=PAx*VS0(48,2)+WPx*VS1(48,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))&
   +HfxZpE*VS1(48,1)
VS0(71,3)=PAx*VS0(48,3)+WPx*VS1(48,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(71,4)=PAx*VS0(48,4)+WPx*VS1(48,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(72,2)=PAx*VS0(49,2)+WPx*VS1(49,2)&
   +r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))&
   +HfxZpE*VS1(49,1)
VS0(72,3)=PAx*VS0(49,3)+WPx*VS1(49,3)&
   +r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(72,4)=PAx*VS0(49,4)+WPx*VS1(49,4)&
   +r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(73,2)=PAy*VS0(49,2)+WPy*VS1(49,2)+r1x2Z*VR1(49,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(73,3)=PAy*VS0(49,3)+WPy*VS1(49,3)+r1x2Z*VR1(49,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))&
   +HfxZpE*VS1(49,1)
VS0(73,4)=PAy*VS0(49,4)+WPy*VS1(49,4)+r1x2Z*VR1(49,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(74,2)=PAy*VS0(50,2)+WPy*VS1(50,2)+r1x2Z*VR1(50,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(74,3)=PAy*VS0(50,3)+WPy*VS1(50,3)+r1x2Z*VR1(50,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))&
   +HfxZpE*VS1(50,1)
VS0(74,4)=PAy*VS0(50,4)+WPy*VS1(50,4)+r1x2Z*VR1(50,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(75,2)=PAx*VS0(51,2)+WPx*VS1(51,2)&
   +2D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))&
   +HfxZpE*VS1(51,1)
VS0(75,3)=PAx*VS0(51,3)+WPx*VS1(51,3)&
   +2D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(75,4)=PAx*VS0(51,4)+WPx*VS1(51,4)&
   +2D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))
VS0(76,2)=PAz*VS0(48,2)+WPz*VS1(48,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(76,3)=PAz*VS0(48,3)+WPz*VS1(48,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(76,4)=PAz*VS0(48,4)+WPz*VS1(48,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))&
   +HfxZpE*VS1(48,1)
VS0(77,2)=PAz*VS0(49,2)+WPz*VS1(49,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(77,3)=PAz*VS0(49,3)+WPz*VS1(49,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(77,4)=PAz*VS0(49,4)+WPz*VS1(49,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))&
   +HfxZpE*VS1(49,1)
VS0(78,2)=PAy*VS0(53,2)+WPy*VS1(53,2)+r1x2Z*VR1(53,2)&
   +2D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(78,3)=PAy*VS0(53,3)+WPy*VS1(53,3)+r1x2Z*VR1(53,3)&
   +2D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))&
   +HfxZpE*VS1(53,1)
VS0(78,4)=PAy*VS0(53,4)+WPy*VS1(53,4)+r1x2Z*VR1(53,4)&
   +2D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))
VS0(79,2)=PAz*VS0(51,2)+WPz*VS1(51,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))
VS0(79,3)=PAz*VS0(51,3)+WPz*VS1(51,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(79,4)=PAz*VS0(51,4)+WPz*VS1(51,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))&
   +HfxZpE*VS1(51,1)
VS0(80,2)=PAz*VS0(52,2)+WPz*VS1(52,2)&
   +3D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(80,3)=PAz*VS0(52,3)+WPz*VS1(52,3)&
   +3D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(80,4)=PAz*VS0(52,4)+WPz*VS1(52,4)&
   +3D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))&
   +HfxZpE*VS1(52,1)
VS0(81,2)=PAz*VS0(53,2)+WPz*VS1(53,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(81,3)=PAz*VS0(53,3)+WPz*VS1(53,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(81,4)=PAz*VS0(53,4)+WPz*VS1(53,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))&
   +HfxZpE*VS1(53,1)
VS0(82,2)=PAz*VS0(54,2)+WPz*VS1(54,2)&
   +4D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))
VS0(82,3)=PAz*VS0(54,3)+WPz*VS1(54,3)&
   +4D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(82,4)=PAz*VS0(54,4)+WPz*VS1(54,4)&
   +4D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))&
   +HfxZpE*VS1(54,1)
VS0(83,2)=PAz*VS0(55,2)+WPz*VS1(55,2)&
   +4D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(83,3)=PAz*VS0(55,3)+WPz*VS1(55,3)&
   +4D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))
VS0(83,4)=PAz*VS0(55,4)+WPz*VS1(55,4)&
   +4D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))&
   +HfxZpE*VS1(55,1)
VS0(84,2)=PAz*VS0(56,2)+WPz*VS1(56,2)&
   +5D0*r1x2Z*(VS0(35,2)-ExZpE*VS1(35,2))
VS0(84,3)=PAz*VS0(56,3)+WPz*VS1(56,3)&
   +5D0*r1x2Z*(VS0(35,3)-ExZpE*VS1(35,3))
VS0(84,4)=PAz*VS0(56,4)+WPz*VS1(56,4)&
   +5D0*r1x2Z*(VS0(35,4)-ExZpE*VS1(35,4))&
   +HfxZpE*VS1(56,1)
CASE(3)
VS0(57,2)=PAx*VS0(36,2)+WPx*VS1(36,2)&
   +5D0*r1x2Z*(VS0(21,2)-ExZpE*VS1(21,2))&
   +HfxZpE*VS1(36,1)
VS0(57,3)=PAx*VS0(36,3)+WPx*VS1(36,3)&
   +5D0*r1x2Z*(VS0(21,3)-ExZpE*VS1(21,3))
VS0(57,4)=PAx*VS0(36,4)+WPx*VS1(36,4)&
   +5D0*r1x2Z*(VS0(21,4)-ExZpE*VS1(21,4))
VS0(58,2)=PAx*VS0(37,2)+WPx*VS1(37,2)&
   +4D0*r1x2Z*(VS0(22,2)-ExZpE*VS1(22,2))&
   +HfxZpE*VS1(37,1)
VS0(58,3)=PAx*VS0(37,3)+WPx*VS1(37,3)&
   +4D0*r1x2Z*(VS0(22,3)-ExZpE*VS1(22,3))
VS0(58,4)=PAx*VS0(37,4)+WPx*VS1(37,4)&
   +4D0*r1x2Z*(VS0(22,4)-ExZpE*VS1(22,4))
VS0(59,2)=PAx*VS0(38,2)+WPx*VS1(38,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))&
   +HfxZpE*VS1(38,1)
VS0(59,3)=PAx*VS0(38,3)+WPx*VS1(38,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))
VS0(59,4)=PAx*VS0(38,4)+WPx*VS1(38,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(60,2)=PAx*VS0(39,2)+WPx*VS1(39,2)&
   +2D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))&
   +HfxZpE*VS1(39,1)
VS0(60,3)=PAx*VS0(39,3)+WPx*VS1(39,3)&
   +2D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))
VS0(60,4)=PAx*VS0(39,4)+WPx*VS1(39,4)&
   +2D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(61,2)=PAy*VS0(39,2)+WPy*VS1(39,2)&
   +3D0*r1x2Z*(VS0(23,2)-ExZpE*VS1(23,2))
VS0(61,3)=PAy*VS0(39,3)+WPy*VS1(39,3)&
   +3D0*r1x2Z*(VS0(23,3)-ExZpE*VS1(23,3))&
   +HfxZpE*VS1(39,1)
VS0(61,4)=PAy*VS0(39,4)+WPy*VS1(39,4)&
   +3D0*r1x2Z*(VS0(23,4)-ExZpE*VS1(23,4))
VS0(62,2)=PAy*VS0(40,2)+WPy*VS1(40,2)&
   +4D0*r1x2Z*(VS0(24,2)-ExZpE*VS1(24,2))
VS0(62,3)=PAy*VS0(40,3)+WPy*VS1(40,3)&
   +4D0*r1x2Z*(VS0(24,3)-ExZpE*VS1(24,3))&
   +HfxZpE*VS1(40,1)
VS0(62,4)=PAy*VS0(40,4)+WPy*VS1(40,4)&
   +4D0*r1x2Z*(VS0(24,4)-ExZpE*VS1(24,4))
VS0(63,2)=PAy*VS0(41,2)+WPy*VS1(41,2)&
   +5D0*r1x2Z*(VS0(25,2)-ExZpE*VS1(25,2))
VS0(63,3)=PAy*VS0(41,3)+WPy*VS1(41,3)&
   +5D0*r1x2Z*(VS0(25,3)-ExZpE*VS1(25,3))&
   +HfxZpE*VS1(41,1)
VS0(63,4)=PAy*VS0(41,4)+WPy*VS1(41,4)&
   +5D0*r1x2Z*(VS0(25,4)-ExZpE*VS1(25,4))
VS0(64,2)=PAx*VS0(42,2)+WPx*VS1(42,2)&
   +4D0*r1x2Z*(VS0(26,2)-ExZpE*VS1(26,2))&
   +HfxZpE*VS1(42,1)
VS0(64,3)=PAx*VS0(42,3)+WPx*VS1(42,3)&
   +4D0*r1x2Z*(VS0(26,3)-ExZpE*VS1(26,3))
VS0(64,4)=PAx*VS0(42,4)+WPx*VS1(42,4)&
   +4D0*r1x2Z*(VS0(26,4)-ExZpE*VS1(26,4))
VS0(65,2)=PAx*VS0(43,2)+WPx*VS1(43,2)&
   +3D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))&
   +HfxZpE*VS1(43,1)
VS0(65,3)=PAx*VS0(43,3)+WPx*VS1(43,3)&
   +3D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(65,4)=PAx*VS0(43,4)+WPx*VS1(43,4)&
   +3D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(66,2)=PAx*VS0(44,2)+WPx*VS1(44,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))&
   +HfxZpE*VS1(44,1)
VS0(66,3)=PAx*VS0(44,3)+WPx*VS1(44,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(66,4)=PAx*VS0(44,4)+WPx*VS1(44,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(67,2)=PAy*VS0(44,2)+WPy*VS1(44,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(67,3)=PAy*VS0(44,3)+WPy*VS1(44,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))&
   +HfxZpE*VS1(44,1)
VS0(67,4)=PAy*VS0(44,4)+WPy*VS1(44,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))
VS0(68,2)=PAy*VS0(45,2)+WPy*VS1(45,2)&
   +3D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(68,3)=PAy*VS0(45,3)+WPy*VS1(45,3)&
   +3D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))&
   +HfxZpE*VS1(45,1)
VS0(68,4)=PAy*VS0(45,4)+WPy*VS1(45,4)&
   +3D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))
VS0(69,2)=PAy*VS0(46,2)+WPy*VS1(46,2)&
   +4D0*r1x2Z*(VS0(29,2)-ExZpE*VS1(29,2))
VS0(69,3)=PAy*VS0(46,3)+WPy*VS1(46,3)&
   +4D0*r1x2Z*(VS0(29,3)-ExZpE*VS1(29,3))&
   +HfxZpE*VS1(46,1)
VS0(69,4)=PAy*VS0(46,4)+WPy*VS1(46,4)&
   +4D0*r1x2Z*(VS0(29,4)-ExZpE*VS1(29,4))
VS0(70,2)=PAx*VS0(47,2)+WPx*VS1(47,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))&
   +HfxZpE*VS1(47,1)
VS0(70,3)=PAx*VS0(47,3)+WPx*VS1(47,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(70,4)=PAx*VS0(47,4)+WPx*VS1(47,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))
VS0(71,2)=PAx*VS0(48,2)+WPx*VS1(48,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))&
   +HfxZpE*VS1(48,1)
VS0(71,3)=PAx*VS0(48,3)+WPx*VS1(48,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(71,4)=PAx*VS0(48,4)+WPx*VS1(48,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(72,2)=PAx*VS0(49,2)+WPx*VS1(49,2)&
   +r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))&
   +HfxZpE*VS1(49,1)
VS0(72,3)=PAx*VS0(49,3)+WPx*VS1(49,3)&
   +r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(72,4)=PAx*VS0(49,4)+WPx*VS1(49,4)&
   +r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(73,2)=PAy*VS0(49,2)+WPy*VS1(49,2)&
   +2D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(73,3)=PAy*VS0(49,3)+WPy*VS1(49,3)&
   +2D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))&
   +HfxZpE*VS1(49,1)
VS0(73,4)=PAy*VS0(49,4)+WPy*VS1(49,4)&
   +2D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))
VS0(74,2)=PAy*VS0(50,2)+WPy*VS1(50,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(74,3)=PAy*VS0(50,3)+WPy*VS1(50,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))&
   +HfxZpE*VS1(50,1)
VS0(74,4)=PAy*VS0(50,4)+WPy*VS1(50,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))
VS0(75,2)=PAx*VS0(51,2)+WPx*VS1(51,2)&
   +2D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))&
   +HfxZpE*VS1(51,1)
VS0(75,3)=PAx*VS0(51,3)+WPx*VS1(51,3)&
   +2D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(75,4)=PAx*VS0(51,4)+WPx*VS1(51,4)&
   +2D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))
VS0(76,2)=PAz*VS0(48,2)+WPz*VS1(48,2)+r1x2Z*VR1(48,2)&
   +2D0*r1x2Z*(VS0(27,2)-ExZpE*VS1(27,2))
VS0(76,3)=PAz*VS0(48,3)+WPz*VS1(48,3)+r1x2Z*VR1(48,3)&
   +2D0*r1x2Z*(VS0(27,3)-ExZpE*VS1(27,3))
VS0(76,4)=PAz*VS0(48,4)+WPz*VS1(48,4)+r1x2Z*VR1(48,4)&
   +2D0*r1x2Z*(VS0(27,4)-ExZpE*VS1(27,4))&
   +HfxZpE*VS1(48,1)
VS0(77,2)=PAz*VS0(49,2)+WPz*VS1(49,2)+r1x2Z*VR1(49,2)&
   +2D0*r1x2Z*(VS0(28,2)-ExZpE*VS1(28,2))
VS0(77,3)=PAz*VS0(49,3)+WPz*VS1(49,3)+r1x2Z*VR1(49,3)&
   +2D0*r1x2Z*(VS0(28,3)-ExZpE*VS1(28,3))
VS0(77,4)=PAz*VS0(49,4)+WPz*VS1(49,4)+r1x2Z*VR1(49,4)&
   +2D0*r1x2Z*(VS0(28,4)-ExZpE*VS1(28,4))&
   +HfxZpE*VS1(49,1)
VS0(78,2)=PAy*VS0(53,2)+WPy*VS1(53,2)&
   +2D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(78,3)=PAy*VS0(53,3)+WPy*VS1(53,3)&
   +2D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))&
   +HfxZpE*VS1(53,1)
VS0(78,4)=PAy*VS0(53,4)+WPy*VS1(53,4)&
   +2D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))
VS0(79,2)=PAz*VS0(51,2)+WPz*VS1(51,2)+r1x2Z*VR1(51,2)&
   +3D0*r1x2Z*(VS0(30,2)-ExZpE*VS1(30,2))
VS0(79,3)=PAz*VS0(51,3)+WPz*VS1(51,3)+r1x2Z*VR1(51,3)&
   +3D0*r1x2Z*(VS0(30,3)-ExZpE*VS1(30,3))
VS0(79,4)=PAz*VS0(51,4)+WPz*VS1(51,4)+r1x2Z*VR1(51,4)&
   +3D0*r1x2Z*(VS0(30,4)-ExZpE*VS1(30,4))&
   +HfxZpE*VS1(51,1)
VS0(80,2)=PAz*VS0(52,2)+WPz*VS1(52,2)+r1x2Z*VR1(52,2)&
   +3D0*r1x2Z*(VS0(31,2)-ExZpE*VS1(31,2))
VS0(80,3)=PAz*VS0(52,3)+WPz*VS1(52,3)+r1x2Z*VR1(52,3)&
   +3D0*r1x2Z*(VS0(31,3)-ExZpE*VS1(31,3))
VS0(80,4)=PAz*VS0(52,4)+WPz*VS1(52,4)+r1x2Z*VR1(52,4)&
   +3D0*r1x2Z*(VS0(31,4)-ExZpE*VS1(31,4))&
   +HfxZpE*VS1(52,1)
VS0(81,2)=PAz*VS0(53,2)+WPz*VS1(53,2)+r1x2Z*VR1(53,2)&
   +3D0*r1x2Z*(VS0(32,2)-ExZpE*VS1(32,2))
VS0(81,3)=PAz*VS0(53,3)+WPz*VS1(53,3)+r1x2Z*VR1(53,3)&
   +3D0*r1x2Z*(VS0(32,3)-ExZpE*VS1(32,3))
VS0(81,4)=PAz*VS0(53,4)+WPz*VS1(53,4)+r1x2Z*VR1(53,4)&
   +3D0*r1x2Z*(VS0(32,4)-ExZpE*VS1(32,4))&
   +HfxZpE*VS1(53,1)
VS0(82,2)=PAz*VS0(54,2)+WPz*VS1(54,2)+r1x2Z*VR1(54,2)&
   +4D0*r1x2Z*(VS0(33,2)-ExZpE*VS1(33,2))
VS0(82,3)=PAz*VS0(54,3)+WPz*VS1(54,3)+r1x2Z*VR1(54,3)&
   +4D0*r1x2Z*(VS0(33,3)-ExZpE*VS1(33,3))
VS0(82,4)=PAz*VS0(54,4)+WPz*VS1(54,4)+r1x2Z*VR1(54,4)&
   +4D0*r1x2Z*(VS0(33,4)-ExZpE*VS1(33,4))&
   +HfxZpE*VS1(54,1)
VS0(83,2)=PAz*VS0(55,2)+WPz*VS1(55,2)+r1x2Z*VR1(55,2)&
   +4D0*r1x2Z*(VS0(34,2)-ExZpE*VS1(34,2))
VS0(83,3)=PAz*VS0(55,3)+WPz*VS1(55,3)+r1x2Z*VR1(55,3)&
   +4D0*r1x2Z*(VS0(34,3)-ExZpE*VS1(34,3))
VS0(83,4)=PAz*VS0(55,4)+WPz*VS1(55,4)+r1x2Z*VR1(55,4)&
   +4D0*r1x2Z*(VS0(34,4)-ExZpE*VS1(34,4))&
   +HfxZpE*VS1(55,1)
VS0(84,2)=PAz*VS0(56,2)+WPz*VS1(56,2)+r1x2Z*VR1(56,2)&
   +5D0*r1x2Z*(VS0(35,2)-ExZpE*VS1(35,2))
VS0(84,3)=PAz*VS0(56,3)+WPz*VS1(56,3)+r1x2Z*VR1(56,3)&
   +5D0*r1x2Z*(VS0(35,3)-ExZpE*VS1(35,3))
VS0(84,4)=PAz*VS0(56,4)+WPz*VS1(56,4)+r1x2Z*VR1(56,4)&
   +5D0*r1x2Z*(VS0(35,4)-ExZpE*VS1(35,4))&
   +HfxZpE*VS1(56,1)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRi0p0'
STOP
END SELECT
END SUBROUTINE MVRRi0p0
