!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRh0i0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=HfxZpE*VRR1(21,39)
      V(2)=HfxZpE*VRR1(21,40)
      V(3)=HfxZpE*VRR1(21,45)
      V(4)=HfxZpE*VRR1(21,46)
      V(5)=HfxZpE*VRR1(21,50)
      V(6)=HfxZpE*VRR1(21,51)
      V(7)=HfxZpE*VRR1(21,52)
      V(8)=HfxZpE*VRR1(21,53)
      V(9)=HfxZpE*VRR1(21,54)
      V(10)=HfxZpE*VRR1(21,55)
      V(11)=r1x2E*VRR0(37,23)
      V(12)=3.D0*V(11)
      V(13)=r1x2E*ZxZpE*VRR1(37,23)
      V(14)=-3.D0*V(13)
      V(15)=HfxZpE*VRR1(22,39)
      V(16)=HfxZpE*VRR1(22,44)
      V(17)=HfxZpE*VRR1(22,45)
      V(18)=2.D0*V(17)
      V(19)=r1x2E*VRR0(37,30)
      V(20)=3.D0*V(19)
      V(21)=r1x2E*ZxZpE*VRR1(37,30)
      V(22)=-3.D0*V(21)
      V(23)=HfxZpE*VRR1(22,48)
      V(24)=r1x2Z*VRR0(12,72)
      V(25)=ExZpE*r1x2Z*VRR1(12,72)
      V(26)=HfxZpE*VRR1(22,49)
      V(27)=2.D0*V(26)
      V(28)=HfxZpE*VRR1(22,50)
      V(29)=r1x2E*VRR0(37,32)
      V(30)=3.D0*V(29)
      V(31)=r1x2E*ZxZpE*VRR1(37,32)
      V(32)=-3.D0*V(31)
      V(33)=HfxZpE*VRR1(22,51)
      V(34)=HfxZpE*VRR1(22,52)
      V(35)=HfxZpE*VRR1(22,53)
      V(36)=r1x2E*VRR0(38,23)
      V(37)=3.D0*V(36)
      V(38)=r1x2E*ZxZpE*VRR1(38,23)
      V(39)=-3.D0*V(38)
      V(40)=r1x2E*VRR0(38,24)
      V(41)=HfxZpE*VRR1(23,39)
      V(42)=3.D0*V(41)
      V(43)=r1x2E*ZxZpE*VRR1(38,24)
      V(44)=r1x2E*VRR0(38,27)
      V(45)=r1x2E*ZxZpE*VRR1(38,27)
      V(46)=r1x2E*VRR0(38,28)
      V(47)=2.D0*V(46)
      V(48)=HfxZpE*VRR1(23,44)
      V(49)=3.D0*V(48)
      V(50)=r1x2E*ZxZpE*VRR1(38,28)
      V(51)=-2.D0*V(50)
      V(52)=2.D0*V(44)
      V(53)=-2.D0*V(45)
      V(54)=r1x2E*VRR0(38,30)
      V(55)=3.D0*V(54)
      V(56)=r1x2E*ZxZpE*VRR1(38,30)
      V(57)=-3.D0*V(56)
      V(58)=r1x2E*VRR0(38,31)
      V(59)=2.D0*V(58)
      V(60)=HfxZpE*VRR1(23,48)
      V(61)=r1x2E*ZxZpE*VRR1(38,31)
      V(62)=-2.D0*V(61)
      V(63)=r1x2Z*VRR0(13,72)
      V(64)=ExZpE*r1x2Z*VRR1(13,72)
      V(65)=HfxZpE*VRR1(23,49)
      V(66)=r1x2E*VRR0(38,32)
      V(67)=3.D0*V(66)
      V(68)=r1x2E*ZxZpE*VRR1(38,32)
      V(69)=-3.D0*V(68)
      V(70)=r1x2E*VRR0(38,33)
      V(71)=HfxZpE*VRR1(23,51)
      V(72)=r1x2E*ZxZpE*VRR1(38,33)
      V(73)=r1x2E*VRR0(38,34)
      V(74)=r1x2E*ZxZpE*VRR1(38,34)
      V(75)=r1x2E*VRR0(39,23)
      V(76)=3.D0*V(75)
      V(77)=HfxZpE*VRR1(24,38)
      V(78)=r1x2E*ZxZpE*VRR1(39,23)
      V(79)=-3.D0*V(78)
      V(80)=r1x2E*VRR0(39,24)
      V(81)=HfxZpE*VRR1(24,39)
      V(82)=r1x2E*ZxZpE*VRR1(39,24)
      V(83)=r1x2E*VRR0(39,27)
      V(84)=HfxZpE*VRR1(24,43)
      V(85)=2.D0*V(84)
      V(86)=r1x2E*ZxZpE*VRR1(39,27)
      V(87)=r1x2E*VRR0(39,28)
      V(88)=2.D0*V(87)
      V(89)=HfxZpE*VRR1(24,44)
      V(90)=r1x2E*ZxZpE*VRR1(39,28)
      V(91)=-2.D0*V(90)
      V(92)=2.D0*V(83)
      V(93)=-2.D0*V(86)
      V(94)=r1x2E*VRR0(39,30)
      V(95)=3.D0*V(94)
      V(96)=HfxZpE*VRR1(24,47)
      V(97)=r1x2E*ZxZpE*VRR1(39,30)
      V(98)=-3.D0*V(97)
      V(99)=r1x2E*VRR0(39,31)
      V(100)=2.D0*V(99)
      V(101)=HfxZpE*VRR1(24,48)
      V(102)=2.D0*V(101)
      V(103)=r1x2E*ZxZpE*VRR1(39,31)
      V(104)=-2.D0*V(103)
      V(105)=r1x2E*VRR0(39,32)
      V(106)=3.D0*V(105)
      V(107)=r1x2E*ZxZpE*VRR1(39,32)
      V(108)=-3.D0*V(107)
      V(109)=r1x2E*VRR0(39,33)
      V(110)=HfxZpE*VRR1(24,51)
      V(111)=r1x2E*ZxZpE*VRR1(39,33)
      V(112)=r1x2E*VRR0(39,34)
      V(113)=HfxZpE*VRR1(23,53)
      V(114)=r1x2E*ZxZpE*VRR1(39,34)
      V(115)=HfxZpE*VRR1(25,37)
      V(116)=r1x2E*VRR0(40,23)
      V(117)=3.D0*V(116)
      V(118)=HfxZpE*VRR1(25,38)
      V(119)=r1x2E*ZxZpE*VRR1(40,23)
      V(120)=-3.D0*V(119)
      V(121)=HfxZpE*VRR1(25,42)
      V(122)=HfxZpE*VRR1(25,43)
      V(123)=r1x2E*VRR0(40,30)
      V(124)=3.D0*V(123)
      V(125)=HfxZpE*VRR1(25,47)
      V(126)=r1x2E*ZxZpE*VRR1(40,30)
      V(127)=-3.D0*V(126)
      V(128)=HfxZpE*VRR1(24,49)
      V(129)=r1x2E*VRR0(40,32)
      V(130)=3.D0*V(129)
      V(131)=r1x2E*ZxZpE*VRR1(40,32)
      V(132)=-3.D0*V(131)
      V(133)=HfxZpE*VRR1(24,52)
      V(134)=HfxZpE*VRR1(24,53)
      V(135)=HfxZpE*VRR1(25,51)
      V(136)=HfxZpE*VRR1(25,52)
      V(137)=HfxZpE*VRR1(25,53)
      V(138)=HfxZpE*VRR1(25,54)
      V(139)=HfxZpE*VRR1(25,55)
      V(140)=r1x2E*VRR0(42,23)
      V(141)=3.D0*V(140)
      V(142)=r1x2E*ZxZpE*VRR1(42,23)
      V(143)=-3.D0*V(142)
      V(144)=HfxZpE*VRR1(26,39)
      V(145)=HfxZpE*VRR1(26,44)
      V(146)=HfxZpE*VRR1(26,45)
      V(147)=r1x2E*VRR0(42,30)
      V(148)=3.D0*V(147)
      V(149)=r1x2E*ZxZpE*VRR1(42,30)
      V(150)=-3.D0*V(149)
      V(151)=HfxZpE*VRR1(26,48)
      V(152)=r1x2Z*VRR0(15,72)
      V(153)=ExZpE*r1x2Z*VRR1(15,72)
      V(154)=HfxZpE*VRR1(26,49)
      V(155)=2.D0*V(154)
      V(156)=HfxZpE*VRR1(26,50)
      V(157)=r1x2E*VRR0(42,32)
      V(158)=3.D0*V(157)
      V(159)=r1x2E*ZxZpE*VRR1(42,32)
      V(160)=-3.D0*V(159)
      V(161)=HfxZpE*VRR1(26,51)
      V(162)=HfxZpE*VRR1(26,52)
      V(163)=2.D0*V(162)
      V(164)=HfxZpE*VRR1(26,53)
      V(165)=r1x2E*VRR0(43,23)
      V(166)=3.D0*V(165)
      V(167)=r1x2E*ZxZpE*VRR1(43,23)
      V(168)=-3.D0*V(167)
      V(169)=r1x2E*VRR0(43,24)
      V(170)=HfxZpE*VRR1(27,39)
      V(171)=r1x2E*ZxZpE*VRR1(43,24)
      V(172)=r1x2E*VRR0(43,27)
      V(173)=r1x2E*ZxZpE*VRR1(43,27)
      V(174)=r1x2E*VRR0(43,28)
      V(175)=2.D0*V(174)
      V(176)=HfxZpE*VRR1(27,44)
      V(177)=r1x2E*ZxZpE*VRR1(43,28)
      V(178)=-2.D0*V(177)
      V(179)=2.D0*V(172)
      V(180)=-2.D0*V(173)
      V(181)=r1x2E*VRR0(43,30)
      V(182)=3.D0*V(181)
      V(183)=r1x2E*ZxZpE*VRR1(43,30)
      V(184)=-3.D0*V(183)
      V(185)=r1x2E*VRR0(43,31)
      V(186)=2.D0*V(185)
      V(187)=HfxZpE*VRR1(27,48)
      V(188)=r1x2E*ZxZpE*VRR1(43,31)
      V(189)=-2.D0*V(188)
      V(190)=r1x2Z*VRR0(16,72)
      V(191)=2.D0*V(190)
      V(192)=ExZpE*r1x2Z*VRR1(16,72)
      V(193)=-2.D0*V(192)
      V(194)=HfxZpE*VRR1(27,49)
      V(195)=2.D0*V(194)
      V(196)=r1x2E*VRR0(43,32)
      V(197)=3.D0*V(196)
      V(198)=r1x2E*ZxZpE*VRR1(43,32)
      V(199)=-3.D0*V(198)
      V(200)=r1x2E*VRR0(43,33)
      V(201)=HfxZpE*VRR1(27,51)
      V(202)=r1x2E*ZxZpE*VRR1(43,33)
      V(203)=r1x2E*VRR0(43,34)
      V(204)=r1x2E*ZxZpE*VRR1(43,34)
      V(205)=r1x2E*VRR0(44,23)
      V(206)=3.D0*V(205)
      V(207)=r1x2E*ZxZpE*VRR1(44,23)
      V(208)=-3.D0*V(207)
      V(209)=r1x2E*VRR0(44,24)
      V(210)=HfxZpE*VRR1(28,39)
      V(211)=r1x2E*ZxZpE*VRR1(44,24)
      V(212)=r1x2E*VRR0(44,27)
      V(213)=r1x2E*ZxZpE*VRR1(44,27)
      V(214)=r1x2E*VRR0(44,28)
      V(215)=2.D0*V(214)
      V(216)=HfxZpE*VRR1(28,44)
      V(217)=r1x2E*ZxZpE*VRR1(44,28)
      V(218)=-2.D0*V(217)
      V(219)=2.D0*V(212)
      V(220)=-2.D0*V(213)
      V(221)=r1x2E*VRR0(44,30)
      V(222)=3.D0*V(221)
      V(223)=r1x2E*ZxZpE*VRR1(44,30)
      V(224)=-3.D0*V(223)
      V(225)=r1x2E*VRR0(44,31)
      V(226)=2.D0*V(225)
      V(227)=HfxZpE*VRR1(28,48)
      V(228)=2.D0*V(227)
      V(229)=r1x2E*ZxZpE*VRR1(44,31)
      V(230)=-2.D0*V(229)
      V(231)=r1x2E*VRR0(44,32)
      V(232)=HfxZpE*VRR1(28,49)
      V(233)=2.D0*V(232)
      V(234)=r1x2E*ZxZpE*VRR1(44,32)
      V(235)=3.D0*V(231)
      V(236)=-3.D0*V(234)
      V(237)=r1x2E*VRR0(44,33)
      V(238)=HfxZpE*VRR1(28,51)
      V(239)=2.D0*V(238)
      V(240)=r1x2E*ZxZpE*VRR1(44,33)
      V(241)=r1x2E*VRR0(44,34)
      V(242)=HfxZpE*VRR1(27,53)
      V(243)=2.D0*V(242)
      V(244)=r1x2E*ZxZpE*VRR1(44,34)
      V(245)=r1x2E*VRR0(45,23)
      V(246)=3.D0*V(245)
      V(247)=HfxZpE*VRR1(29,38)
      V(248)=r1x2E*ZxZpE*VRR1(45,23)
      V(249)=-3.D0*V(248)
      V(250)=r1x2E*VRR0(45,24)
      V(251)=HfxZpE*VRR1(29,39)
      V(252)=r1x2E*ZxZpE*VRR1(45,24)
      V(253)=r1x2E*VRR0(45,27)
      V(254)=HfxZpE*VRR1(29,43)
      V(255)=r1x2E*ZxZpE*VRR1(45,27)
      V(256)=r1x2E*VRR0(45,28)
      V(257)=2.D0*V(256)
      V(258)=HfxZpE*VRR1(29,44)
      V(259)=r1x2E*ZxZpE*VRR1(45,28)
      V(260)=-2.D0*V(259)
      V(261)=2.D0*V(253)
      V(262)=-2.D0*V(255)
      V(263)=r1x2E*VRR0(45,30)
      V(264)=3.D0*V(263)
      V(265)=HfxZpE*VRR1(29,47)
      V(266)=r1x2E*ZxZpE*VRR1(45,30)
      V(267)=-3.D0*V(266)
      V(268)=r1x2E*VRR0(45,31)
      V(269)=2.D0*V(268)
      V(270)=HfxZpE*VRR1(29,48)
      V(271)=r1x2E*ZxZpE*VRR1(45,31)
      V(272)=-2.D0*V(271)
      V(273)=r1x2E*VRR0(45,32)
      V(274)=3.D0*V(273)
      V(275)=r1x2E*ZxZpE*VRR1(45,32)
      V(276)=-3.D0*V(275)
      V(277)=r1x2E*VRR0(45,33)
      V(278)=HfxZpE*VRR1(29,51)
      V(279)=r1x2E*ZxZpE*VRR1(45,33)
      V(280)=r1x2E*VRR0(45,34)
      V(281)=HfxZpE*VRR1(28,53)
      V(282)=r1x2E*ZxZpE*VRR1(45,34)
      V(283)=r1x2E*VRR0(46,23)
      V(284)=3.D0*V(283)
      V(285)=r1x2E*ZxZpE*VRR1(46,23)
      V(286)=-3.D0*V(285)
      V(287)=r1x2E*VRR0(46,30)
      V(288)=3.D0*V(287)
      V(289)=r1x2E*ZxZpE*VRR1(46,30)
      V(290)=-3.D0*V(289)
      V(291)=r1x2Z*VRR0(17,72)
      V(292)=ExZpE*r1x2Z*VRR1(17,72)
      V(293)=2.D0*V(270)
      V(294)=HfxZpE*VRR1(29,49)
      V(295)=r1x2E*VRR0(46,32)
      V(296)=3.D0*V(295)
      V(297)=r1x2E*ZxZpE*VRR1(46,32)
      V(298)=-3.D0*V(297)
      V(299)=HfxZpE*VRR1(29,52)
      V(300)=2.D0*V(299)
      V(301)=HfxZpE*VRR1(29,53)
      V(302)=r1x2E*VRR0(47,23)
      V(303)=3.D0*V(302)
      V(304)=r1x2E*ZxZpE*VRR1(47,23)
      V(305)=-3.D0*V(304)
      V(306)=r1x2E*VRR0(47,24)
      V(307)=HfxZpE*VRR1(30,39)
      V(308)=r1x2E*ZxZpE*VRR1(47,24)
      V(309)=r1x2E*VRR0(47,27)
      V(310)=r1x2E*ZxZpE*VRR1(47,27)
      V(311)=r1x2E*VRR0(47,28)
      V(312)=2.D0*V(311)
      V(313)=HfxZpE*VRR1(30,44)
      V(314)=r1x2E*ZxZpE*VRR1(47,28)
      V(315)=-2.D0*V(314)
      V(316)=2.D0*V(309)
      V(317)=-2.D0*V(310)
      V(318)=r1x2E*VRR0(47,30)
      V(319)=3.D0*V(318)
      V(320)=r1x2E*ZxZpE*VRR1(47,30)
      V(321)=-3.D0*V(320)
      V(322)=r1x2E*VRR0(47,31)
      V(323)=2.D0*V(322)
      V(324)=HfxZpE*VRR1(30,48)
      V(325)=3.D0*V(324)
      V(326)=r1x2E*ZxZpE*VRR1(47,31)
      V(327)=-2.D0*V(326)
      V(328)=r1x2Z*VRR0(18,72)
      V(329)=ExZpE*r1x2Z*VRR1(18,72)
      V(330)=HfxZpE*VRR1(30,49)
      V(331)=r1x2E*VRR0(47,32)
      V(332)=3.D0*V(331)
      V(333)=r1x2E*ZxZpE*VRR1(47,32)
      V(334)=-3.D0*V(333)
      V(335)=r1x2E*VRR0(47,33)
      V(336)=HfxZpE*VRR1(30,51)
      V(337)=3.D0*V(336)
      V(338)=r1x2E*ZxZpE*VRR1(47,33)
      V(339)=r1x2E*VRR0(47,34)
      V(340)=r1x2E*ZxZpE*VRR1(47,34)
      V(341)=r1x2E*VRR0(48,23)
      V(342)=3.D0*V(341)
      V(343)=r1x2E*ZxZpE*VRR1(48,23)
      V(344)=-3.D0*V(343)
      V(345)=r1x2E*VRR0(48,24)
      V(346)=HfxZpE*VRR1(31,39)
      V(347)=2.D0*V(346)
      V(348)=r1x2E*ZxZpE*VRR1(48,24)
      V(349)=r1x2E*VRR0(48,27)
      V(350)=r1x2E*ZxZpE*VRR1(48,27)
      V(351)=r1x2E*VRR0(48,28)
      V(352)=2.D0*V(351)
      V(353)=HfxZpE*VRR1(31,44)
      V(354)=2.D0*V(353)
      V(355)=r1x2E*ZxZpE*VRR1(48,28)
      V(356)=-2.D0*V(355)
      V(357)=2.D0*V(349)
      V(358)=-2.D0*V(350)
      V(359)=r1x2E*VRR0(48,30)
      V(360)=3.D0*V(359)
      V(361)=r1x2E*ZxZpE*VRR1(48,30)
      V(362)=-3.D0*V(361)
      V(363)=r1x2E*VRR0(48,31)
      V(364)=2.D0*V(363)
      V(365)=HfxZpE*VRR1(31,48)
      V(366)=r1x2E*ZxZpE*VRR1(48,31)
      V(367)=-2.D0*V(366)
      V(368)=r1x2E*VRR0(48,32)
      V(369)=HfxZpE*VRR1(31,49)
      V(370)=2.D0*V(369)
      V(371)=r1x2E*ZxZpE*VRR1(48,32)
      V(372)=3.D0*V(368)
      V(373)=-3.D0*V(371)
      V(374)=r1x2E*VRR0(48,33)
      V(375)=HfxZpE*VRR1(31,51)
      V(376)=r1x2E*ZxZpE*VRR1(48,33)
      V(377)=r1x2E*VRR0(48,34)
      V(378)=HfxZpE*VRR1(30,53)
      V(379)=r1x2E*ZxZpE*VRR1(48,34)
      V(380)=r1x2E*VRR0(49,23)
      V(381)=3.D0*V(380)
      V(382)=r1x2E*ZxZpE*VRR1(49,23)
      V(383)=-3.D0*V(382)
      V(384)=r1x2E*VRR0(49,24)
      V(385)=HfxZpE*VRR1(32,39)
      V(386)=r1x2E*ZxZpE*VRR1(49,24)
      V(387)=r1x2E*VRR0(49,27)
      V(388)=r1x2E*ZxZpE*VRR1(49,27)
      V(389)=r1x2E*VRR0(49,28)
      V(390)=2.D0*V(389)
      V(391)=HfxZpE*VRR1(32,44)
      V(392)=r1x2E*ZxZpE*VRR1(49,28)
      V(393)=-2.D0*V(392)
      V(394)=2.D0*V(387)
      V(395)=-2.D0*V(388)
      V(396)=r1x2E*VRR0(49,30)
      V(397)=3.D0*V(396)
      V(398)=r1x2E*ZxZpE*VRR1(49,30)
      V(399)=-3.D0*V(398)
      V(400)=r1x2E*VRR0(49,31)
      V(401)=2.D0*V(400)
      V(402)=HfxZpE*VRR1(32,48)
      V(403)=r1x2E*ZxZpE*VRR1(49,31)
      V(404)=-2.D0*V(403)
      V(405)=r1x2E*VRR0(49,32)
      V(406)=HfxZpE*VRR1(32,49)
      V(407)=r1x2E*ZxZpE*VRR1(49,32)
      V(408)=3.D0*V(405)
      V(409)=-3.D0*V(407)
      V(410)=r1x2E*VRR0(49,33)
      V(411)=HfxZpE*VRR1(32,51)
      V(412)=r1x2E*ZxZpE*VRR1(49,33)
      V(413)=r1x2E*VRR0(49,34)
      V(414)=HfxZpE*VRR1(31,53)
      V(415)=r1x2E*ZxZpE*VRR1(49,34)
      V(416)=r1x2E*VRR0(50,23)
      V(417)=3.D0*V(416)
      V(418)=r1x2E*ZxZpE*VRR1(50,23)
      V(419)=-3.D0*V(418)
      V(420)=r1x2E*VRR0(50,24)
      V(421)=r1x2E*ZxZpE*VRR1(50,24)
      V(422)=r1x2E*VRR0(50,27)
      V(423)=r1x2E*ZxZpE*VRR1(50,27)
      V(424)=r1x2E*VRR0(50,28)
      V(425)=2.D0*V(424)
      V(426)=r1x2E*ZxZpE*VRR1(50,28)
      V(427)=-2.D0*V(426)
      V(428)=2.D0*V(422)
      V(429)=-2.D0*V(423)
      V(430)=r1x2E*VRR0(50,30)
      V(431)=3.D0*V(430)
      V(432)=r1x2E*ZxZpE*VRR1(50,30)
      V(433)=-3.D0*V(432)
      V(434)=r1x2E*VRR0(50,31)
      V(435)=2.D0*V(434)
      V(436)=r1x2E*ZxZpE*VRR1(50,31)
      V(437)=-2.D0*V(436)
      V(438)=r1x2Z*VRR0(19,72)
      V(439)=ExZpE*r1x2Z*VRR1(19,72)
      V(440)=3.D0*V(406)
      V(441)=r1x2E*VRR0(50,32)
      V(442)=3.D0*V(441)
      V(443)=r1x2E*ZxZpE*VRR1(50,32)
      V(444)=-3.D0*V(443)
      V(445)=r1x2E*VRR0(50,33)
      V(446)=r1x2E*ZxZpE*VRR1(50,33)
      V(447)=r1x2E*VRR0(50,34)
      V(448)=HfxZpE*VRR1(32,53)
      V(449)=3.D0*V(448)
      V(450)=r1x2E*ZxZpE*VRR1(50,34)
      V(451)=r1x2E*VRR0(51,23)
      V(452)=3.D0*V(451)
      V(453)=HfxZpE*VRR1(33,38)
      V(454)=r1x2E*ZxZpE*VRR1(51,23)
      V(455)=-3.D0*V(454)
      V(456)=r1x2E*VRR0(51,24)
      V(457)=HfxZpE*VRR1(33,39)
      V(458)=r1x2E*ZxZpE*VRR1(51,24)
      V(459)=r1x2E*VRR0(51,27)
      V(460)=HfxZpE*VRR1(33,43)
      V(461)=2.D0*V(460)
      V(462)=r1x2E*ZxZpE*VRR1(51,27)
      V(463)=r1x2E*VRR0(51,28)
      V(464)=2.D0*V(463)
      V(465)=HfxZpE*VRR1(33,44)
      V(466)=2.D0*V(465)
      V(467)=r1x2E*ZxZpE*VRR1(51,28)
      V(468)=-2.D0*V(467)
      V(469)=2.D0*V(459)
      V(470)=-2.D0*V(462)
      V(471)=r1x2E*VRR0(51,30)
      V(472)=3.D0*V(471)
      V(473)=HfxZpE*VRR1(33,47)
      V(474)=r1x2E*ZxZpE*VRR1(51,30)
      V(475)=-3.D0*V(474)
      V(476)=r1x2E*VRR0(51,31)
      V(477)=2.D0*V(476)
      V(478)=HfxZpE*VRR1(33,48)
      V(479)=r1x2E*ZxZpE*VRR1(51,31)
      V(480)=-2.D0*V(479)
      V(481)=r1x2E*VRR0(51,32)
      V(482)=3.D0*V(481)
      V(483)=r1x2E*ZxZpE*VRR1(51,32)
      V(484)=-3.D0*V(483)
      V(485)=r1x2E*VRR0(51,33)
      V(486)=HfxZpE*VRR1(33,51)
      V(487)=r1x2E*ZxZpE*VRR1(51,33)
      V(488)=r1x2E*VRR0(51,34)
      V(489)=r1x2E*ZxZpE*VRR1(51,34)
      V(490)=r1x2E*VRR0(52,23)
      V(491)=3.D0*V(490)
      V(492)=HfxZpE*VRR1(34,38)
      V(493)=r1x2E*ZxZpE*VRR1(52,23)
      V(494)=-3.D0*V(493)
      V(495)=r1x2E*VRR0(52,24)
      V(496)=HfxZpE*VRR1(34,39)
      V(497)=r1x2E*ZxZpE*VRR1(52,24)
      V(498)=r1x2E*VRR0(52,27)
      V(499)=HfxZpE*VRR1(34,43)
      V(500)=r1x2E*ZxZpE*VRR1(52,27)
      V(501)=r1x2E*VRR0(52,28)
      V(502)=2.D0*V(501)
      V(503)=HfxZpE*VRR1(34,44)
      V(504)=r1x2E*ZxZpE*VRR1(52,28)
      V(505)=-2.D0*V(504)
      V(506)=2.D0*V(498)
      V(507)=-2.D0*V(500)
      V(508)=HfxZpE*VRR1(33,45)
      V(509)=r1x2E*VRR0(52,30)
      V(510)=3.D0*V(509)
      V(511)=HfxZpE*VRR1(34,47)
      V(512)=r1x2E*ZxZpE*VRR1(52,30)
      V(513)=-3.D0*V(512)
      V(514)=r1x2E*VRR0(52,31)
      V(515)=2.D0*V(514)
      V(516)=HfxZpE*VRR1(34,48)
      V(517)=r1x2E*ZxZpE*VRR1(52,31)
      V(518)=-2.D0*V(517)
      V(519)=HfxZpE*VRR1(33,49)
      V(520)=r1x2E*VRR0(52,32)
      V(521)=3.D0*V(520)
      V(522)=HfxZpE*VRR1(33,50)
      V(523)=r1x2E*ZxZpE*VRR1(52,32)
      V(524)=-3.D0*V(523)
      V(525)=r1x2E*VRR0(52,33)
      V(526)=HfxZpE*VRR1(34,51)
      V(527)=r1x2E*ZxZpE*VRR1(52,33)
      V(528)=r1x2E*VRR0(52,34)
      V(529)=HfxZpE*VRR1(33,53)
      V(530)=r1x2E*ZxZpE*VRR1(52,34)
      V(531)=r1x2E*VRR0(53,23)
      V(532)=3.D0*V(531)
      V(533)=r1x2E*ZxZpE*VRR1(53,23)
      V(534)=-3.D0*V(533)
      V(535)=r1x2E*VRR0(53,24)
      V(536)=r1x2E*ZxZpE*VRR1(53,24)
      V(537)=r1x2E*VRR0(53,27)
      V(538)=r1x2E*ZxZpE*VRR1(53,27)
      V(539)=r1x2E*VRR0(53,28)
      V(540)=2.D0*V(539)
      V(541)=r1x2E*ZxZpE*VRR1(53,28)
      V(542)=-2.D0*V(541)
      V(543)=2.D0*V(537)
      V(544)=2.D0*V(503)
      V(545)=-2.D0*V(538)
      V(546)=HfxZpE*VRR1(34,45)
      V(547)=2.D0*V(546)
      V(548)=r1x2E*VRR0(53,30)
      V(549)=3.D0*V(548)
      V(550)=r1x2E*ZxZpE*VRR1(53,30)
      V(551)=-3.D0*V(550)
      V(552)=r1x2E*VRR0(53,31)
      V(553)=2.D0*V(552)
      V(554)=r1x2E*ZxZpE*VRR1(53,31)
      V(555)=-2.D0*V(554)
      V(556)=HfxZpE*VRR1(34,49)
      V(557)=r1x2E*VRR0(53,32)
      V(558)=3.D0*V(557)
      V(559)=HfxZpE*VRR1(34,50)
      V(560)=r1x2E*ZxZpE*VRR1(53,32)
      V(561)=-3.D0*V(560)
      V(562)=r1x2E*VRR0(53,33)
      V(563)=r1x2E*ZxZpE*VRR1(53,33)
      V(564)=r1x2E*VRR0(53,34)
      V(565)=HfxZpE*VRR1(34,53)
      V(566)=r1x2E*ZxZpE*VRR1(53,34)
      V(567)=HfxZpE*VRR1(35,37)
      V(568)=r1x2E*VRR0(54,23)
      V(569)=3.D0*V(568)
      V(570)=HfxZpE*VRR1(35,38)
      V(571)=r1x2E*ZxZpE*VRR1(54,23)
      V(572)=-3.D0*V(571)
      V(573)=HfxZpE*VRR1(35,42)
      V(574)=HfxZpE*VRR1(35,43)
      V(575)=r1x2E*VRR0(54,30)
      V(576)=3.D0*V(575)
      V(577)=HfxZpE*VRR1(35,47)
      V(578)=r1x2E*ZxZpE*VRR1(54,30)
      V(579)=-3.D0*V(578)
      V(580)=r1x2E*VRR0(54,32)
      V(581)=3.D0*V(580)
      V(582)=r1x2E*ZxZpE*VRR1(54,32)
      V(583)=-3.D0*V(582)
      V(584)=r1x2E*VRR0(55,23)
      V(585)=3.D0*V(584)
      V(586)=r1x2E*ZxZpE*VRR1(55,23)
      V(587)=-3.D0*V(586)
      V(588)=HfxZpE*VRR1(35,39)
      V(589)=HfxZpE*VRR1(35,40)
      V(590)=HfxZpE*VRR1(35,45)
      V(591)=HfxZpE*VRR1(35,46)
      V(592)=r1x2E*VRR0(55,30)
      V(593)=3.D0*V(592)
      V(594)=r1x2E*ZxZpE*VRR1(55,30)
      V(595)=-3.D0*V(594)
      V(596)=r1x2E*VRR0(55,32)
      V(597)=3.D0*V(596)
      V(598)=HfxZpE*VRR1(35,50)
      V(599)=r1x2E*ZxZpE*VRR1(55,32)
      V(600)=-3.D0*V(599)
      VRR0(36,57)=5.D0*r1x2E*VRR0(36,21)+QCx*VRR0(36,36)+5.D0*HfxZpE*VRR1(21,36)-5.D0*r1x2E*ZxZpE*VRR1(36,21)+WQx*VRR1(36,36)
      VRR0(36,58)=4.D0*r1x2E*VRR0(36,22)+QCx*VRR0(36,37)+5.D0*HfxZpE*VRR1(21,37)-4.D0*r1x2E*ZxZpE*VRR1(36,22)+WQx*VRR1(36,37)
      VRR0(36,59)=4.D0*r1x2Z*VRR0(11,59)+PAx*VRR0(21,59)-4.D0*ExZpE*r1x2Z*VRR1(11,59)+4.D0*HfxZpE*VRR1(21,38)+WPx*VRR1(21,59)
      VRR0(36,60)=3.D0*V(1)+4.D0*r1x2Z*VRR0(11,60)+PAx*VRR0(21,60)-4.D0*ExZpE*r1x2Z*VRR1(11,60)+WPx*VRR1(21,60)
      VRR0(36,61)=2.D0*V(2)+4.D0*r1x2Z*VRR0(11,61)+PAx*VRR0(21,61)-4.D0*ExZpE*r1x2Z*VRR1(11,61)+WPx*VRR1(21,61)
      VRR0(36,62)=4.D0*r1x2E*VRR0(36,24)+QCy*VRR0(36,40)-4.D0*r1x2E*ZxZpE*VRR1(36,24)+WQy*VRR1(36,40)
      VRR0(36,63)=5.D0*r1x2E*VRR0(36,25)+QCy*VRR0(36,41)-5.D0*r1x2E*ZxZpE*VRR1(36,25)+WQy*VRR1(36,41)
      VRR0(36,64)=4.D0*r1x2E*VRR0(36,26)+QCx*VRR0(36,42)+5.D0*HfxZpE*VRR1(21,42)-4.D0*r1x2E*ZxZpE*VRR1(36,26)+WQx*VRR1(36,42)
      VRR0(36,65)=4.D0*r1x2Z*VRR0(11,65)+PAx*VRR0(21,65)-4.D0*ExZpE*r1x2Z*VRR1(11,65)+4.D0*HfxZpE*VRR1(21,43)+WPx*VRR1(21,65)
      VRR0(36,66)=4.D0*r1x2Z*VRR0(11,66)+PAx*VRR0(21,66)-4.D0*ExZpE*r1x2Z*VRR1(11,66)+3.D0*HfxZpE*VRR1(21,44)+WPx*VRR1(21,66)
      VRR0(36,67)=2.D0*V(3)+4.D0*r1x2Z*VRR0(11,67)+PAx*VRR0(21,67)-4.D0*ExZpE*r1x2Z*VRR1(11,67)+WPx*VRR1(21,67)
      VRR0(36,68)=V(4)+4.D0*r1x2Z*VRR0(11,68)+PAx*VRR0(21,68)-4.D0*ExZpE*r1x2Z*VRR1(11,68)+WPx*VRR1(21,68)
      VRR0(36,69)=4.D0*r1x2E*VRR0(36,29)+QCy*VRR0(36,46)-4.D0*r1x2E*ZxZpE*VRR1(36,29)+WQy*VRR1(36,46)
      VRR0(36,70)=4.D0*r1x2Z*VRR0(11,70)+PAx*VRR0(21,70)-4.D0*ExZpE*r1x2Z*VRR1(11,70)+4.D0*HfxZpE*VRR1(21,47)+WPx*VRR1(21,70)
      VRR0(36,71)=4.D0*r1x2Z*VRR0(11,71)+PAx*VRR0(21,71)-4.D0*ExZpE*r1x2Z*VRR1(11,71)+3.D0*HfxZpE*VRR1(21,48)+WPx*VRR1(21,71)
      VRR0(36,72)=4.D0*r1x2Z*VRR0(11,72)+PAx*VRR0(21,72)-4.D0*ExZpE*r1x2Z*VRR1(11,72)+2.D0*HfxZpE*VRR1(21,49)+WPx*VRR1(21,72)
      VRR0(36,73)=V(5)+4.D0*r1x2Z*VRR0(11,73)+PAx*VRR0(21,73)-4.D0*ExZpE*r1x2Z*VRR1(11,73)+WPx*VRR1(21,73)
      VRR0(36,74)=4.D0*r1x2Z*VRR0(11,74)+PAx*VRR0(21,74)-4.D0*ExZpE*r1x2Z*VRR1(11,74)+WPx*VRR1(21,74)
      VRR0(36,75)=3.D0*V(6)+4.D0*r1x2Z*VRR0(11,75)+PAx*VRR0(21,75)-4.D0*ExZpE*r1x2Z*VRR1(11,75)+WPx*VRR1(21,75)
      VRR0(36,76)=2.D0*V(7)+4.D0*r1x2Z*VRR0(11,76)+PAx*VRR0(21,76)-4.D0*ExZpE*r1x2Z*VRR1(11,76)+WPx*VRR1(21,76)
      VRR0(36,77)=V(8)+4.D0*r1x2Z*VRR0(11,77)+PAx*VRR0(21,77)-4.D0*ExZpE*r1x2Z*VRR1(11,77)+WPx*VRR1(21,77)
      VRR0(36,78)=4.D0*r1x2Z*VRR0(11,78)+PAx*VRR0(21,78)-4.D0*ExZpE*r1x2Z*VRR1(11,78)+WPx*VRR1(21,78)
      VRR0(36,79)=2.D0*V(9)+4.D0*r1x2Z*VRR0(11,79)+PAx*VRR0(21,79)-4.D0*ExZpE*r1x2Z*VRR1(11,79)+WPx*VRR1(21,79)
      VRR0(36,80)=V(10)+4.D0*r1x2Z*VRR0(11,80)+PAx*VRR0(21,80)-4.D0*ExZpE*r1x2Z*VRR1(11,80)+WPx*VRR1(21,80)
      VRR0(36,81)=4.D0*r1x2Z*VRR0(11,81)+PAx*VRR0(21,81)-4.D0*ExZpE*r1x2Z*VRR1(11,81)+WPx*VRR1(21,81)
      VRR0(36,82)=4.D0*r1x2E*VRR0(36,33)+QCz*VRR0(36,54)-4.D0*r1x2E*ZxZpE*VRR1(36,33)+WQz*VRR1(36,54)
      VRR0(36,83)=4.D0*r1x2E*VRR0(36,34)+QCz*VRR0(36,55)-4.D0*r1x2E*ZxZpE*VRR1(36,34)+WQz*VRR1(36,55)
      VRR0(36,84)=5.D0*r1x2E*VRR0(36,35)+QCz*VRR0(36,56)-5.D0*r1x2E*ZxZpE*VRR1(36,35)+WQz*VRR1(36,56)
      VRR0(37,57)=5.D0*r1x2E*VRR0(37,21)+QCx*VRR0(37,36)+4.D0*HfxZpE*VRR1(22,36)-5.D0*r1x2E*ZxZpE*VRR1(37,21)+WQx*VRR1(37,36)
      VRR0(37,58)=4.D0*r1x2E*VRR0(37,22)+QCx*VRR0(37,37)+4.D0*HfxZpE*VRR1(22,37)-4.D0*r1x2E*ZxZpE*VRR1(37,22)+WQx*VRR1(37,37)
      VRR0(37,59)=V(12)+V(14)+QCx*VRR0(37,38)+4.D0*HfxZpE*VRR1(22,38)+WQx*VRR1(37,38)
      VRR0(37,60)=3.D0*V(15)+3.D0*r1x2Z*VRR0(12,60)+PAx*VRR0(22,60)-3.D0*ExZpE*r1x2Z*VRR1(12,60)+WPx*VRR1(22,60)
      VRR0(37,61)=V(1)+V(12)+V(14)+QCy*VRR0(37,39)+WQy*VRR1(37,39)
      VRR0(37,62)=V(2)+4.D0*r1x2E*VRR0(37,24)+QCy*VRR0(37,40)-4.D0*r1x2E*ZxZpE*VRR1(37,24)+WQy*VRR1(37,40)
      VRR0(37,63)=5.D0*r1x2E*VRR0(37,25)+QCy*VRR0(37,41)+HfxZpE*VRR1(21,41)-5.D0*r1x2E*ZxZpE*VRR1(37,25)+WQy*VRR1(37,41)
      VRR0(37,64)=4.D0*r1x2E*VRR0(37,26)+QCx*VRR0(37,42)+4.D0*HfxZpE*VRR1(22,42)-4.D0*r1x2E*ZxZpE*VRR1(37,26)+WQx*VRR1(37,42)
      VRR0(37,65)=3.D0*r1x2E*VRR0(37,27)+QCx*VRR0(37,43)+4.D0*HfxZpE*VRR1(22,43)-3.D0*r1x2E*ZxZpE*VRR1(37,27)+WQx*VRR1(37,43)
      VRR0(37,66)=3.D0*V(16)+3.D0*r1x2Z*VRR0(12,66)+PAx*VRR0(22,66)-3.D0*ExZpE*r1x2Z*VRR1(12,66)+WPx*VRR1(22,66)
      VRR0(37,67)=V(18)+3.D0*r1x2Z*VRR0(12,67)+PAx*VRR0(22,67)-3.D0*ExZpE*r1x2Z*VRR1(12,67)+WPx*VRR1(22,67)
      VRR0(37,68)=V(3)+3.D0*r1x2E*VRR0(37,28)+QCy*VRR0(37,45)-3.D0*r1x2E*ZxZpE*VRR1(37,28)+WQy*VRR1(37,45)
      VRR0(37,69)=V(4)+4.D0*r1x2E*VRR0(37,29)+QCy*VRR0(37,46)-4.D0*r1x2E*ZxZpE*VRR1(37,29)+WQy*VRR1(37,46)
      VRR0(37,70)=V(20)+V(22)+QCx*VRR0(37,47)+4.D0*HfxZpE*VRR1(22,47)+WQx*VRR1(37,47)
      VRR0(37,71)=3.D0*V(23)+3.D0*r1x2Z*VRR0(12,71)+PAx*VRR0(22,71)-3.D0*ExZpE*r1x2Z*VRR1(12,71)+WPx*VRR1(22,71)
      VRR0(37,72)=3.D0*V(24)-3.D0*V(25)+V(27)+PAx*VRR0(22,72)+WPx*VRR1(22,72)
      VRR0(37,73)=V(28)+3.D0*r1x2Z*VRR0(12,73)+PAx*VRR0(22,73)-3.D0*ExZpE*r1x2Z*VRR1(12,73)+WPx*VRR1(22,73)
      VRR0(37,74)=V(5)+V(30)+V(32)+QCy*VRR0(37,50)+WQy*VRR1(37,50)
      VRR0(37,75)=3.D0*V(33)+3.D0*r1x2Z*VRR0(12,75)+PAx*VRR0(22,75)-3.D0*ExZpE*r1x2Z*VRR1(12,75)+WPx*VRR1(22,75)
      VRR0(37,76)=2.D0*V(34)+3.D0*r1x2Z*VRR0(12,76)+PAx*VRR0(22,76)-3.D0*ExZpE*r1x2Z*VRR1(12,76)+WPx*VRR1(22,76)
      VRR0(37,77)=V(35)+3.D0*r1x2Z*VRR0(12,77)+PAx*VRR0(22,77)-3.D0*ExZpE*r1x2Z*VRR1(12,77)+WPx*VRR1(22,77)
      VRR0(37,78)=3.D0*r1x2Z*VRR0(12,78)+PAx*VRR0(22,78)-3.D0*ExZpE*r1x2Z*VRR1(12,78)+WPx*VRR1(22,78)
      VRR0(37,79)=V(20)+V(22)+QCz*VRR0(37,51)+WQz*VRR1(37,51)
      VRR0(37,80)=3.D0*r1x2E*VRR0(37,31)+QCz*VRR0(37,52)-3.D0*r1x2E*ZxZpE*VRR1(37,31)+WQz*VRR1(37,52)
      VRR0(37,81)=V(30)+V(32)+QCz*VRR0(37,53)+WQz*VRR1(37,53)
      VRR0(37,82)=4.D0*r1x2E*VRR0(37,33)+QCz*VRR0(37,54)-4.D0*r1x2E*ZxZpE*VRR1(37,33)+WQz*VRR1(37,54)
      VRR0(37,83)=4.D0*r1x2E*VRR0(37,34)+QCz*VRR0(37,55)-4.D0*r1x2E*ZxZpE*VRR1(37,34)+WQz*VRR1(37,55)
      VRR0(37,84)=5.D0*r1x2E*VRR0(37,35)+QCz*VRR0(37,56)-5.D0*r1x2E*ZxZpE*VRR1(37,35)+WQz*VRR1(37,56)
      VRR0(38,57)=5.D0*r1x2E*VRR0(38,21)+QCx*VRR0(38,36)+3.D0*HfxZpE*VRR1(23,36)-5.D0*r1x2E*ZxZpE*VRR1(38,21)+WQx*VRR1(38,36)
      VRR0(38,58)=4.D0*r1x2E*VRR0(38,22)+QCx*VRR0(38,37)+3.D0*HfxZpE*VRR1(23,37)-4.D0*r1x2E*ZxZpE*VRR1(38,22)+WQx*VRR1(38,37)
      VRR0(38,59)=V(37)+V(39)+QCx*VRR0(38,38)+3.D0*HfxZpE*VRR1(23,38)+WQx*VRR1(38,38)
      VRR0(38,60)=2.D0*V(40)+V(42)-2.D0*V(43)+QCx*VRR0(38,39)+WQx*VRR1(38,39)
      VRR0(38,61)=2.D0*V(15)+V(37)+V(39)+QCy*VRR0(38,39)+WQy*VRR1(38,39)
      VRR0(38,62)=4.D0*V(40)-4.D0*V(43)+QCy*VRR0(38,40)+2.D0*HfxZpE*VRR1(22,40)+WQy*VRR1(38,40)
      VRR0(38,63)=5.D0*r1x2E*VRR0(38,25)+QCy*VRR0(38,41)+2.D0*HfxZpE*VRR1(22,41)-5.D0*r1x2E*ZxZpE*VRR1(38,25)+WQy*VRR1(38,41)
      VRR0(38,64)=4.D0*r1x2E*VRR0(38,26)+QCx*VRR0(38,42)+3.D0*HfxZpE*VRR1(23,42)-4.D0*r1x2E*ZxZpE*VRR1(38,26)+WQx*VRR1(38,42)
      VRR0(38,65)=3.D0*V(44)-3.D0*V(45)+QCx*VRR0(38,43)+3.D0*HfxZpE*VRR1(23,43)+WQx*VRR1(38,43)
      VRR0(38,66)=V(47)+V(49)+V(51)+QCx*VRR0(38,44)+WQx*VRR1(38,44)
      VRR0(38,67)=2.D0*V(16)+V(52)+V(53)+QCy*VRR0(38,44)+WQy*VRR1(38,44)
      VRR0(38,68)=V(18)+3.D0*V(46)-3.D0*V(50)+QCy*VRR0(38,45)+WQy*VRR1(38,45)
      VRR0(38,69)=4.D0*r1x2E*VRR0(38,29)+QCy*VRR0(38,46)+2.D0*HfxZpE*VRR1(22,46)-4.D0*r1x2E*ZxZpE*VRR1(38,29)+WQy*VRR1(38,46)
      VRR0(38,70)=V(55)+V(57)+QCx*VRR0(38,47)+3.D0*HfxZpE*VRR1(23,47)+WQx*VRR1(38,47)
      VRR0(38,71)=V(59)+3.D0*V(60)+V(62)+QCx*VRR0(38,48)+WQx*VRR1(38,48)
      VRR0(38,72)=2.D0*V(63)-2.D0*V(64)+2.D0*V(65)+PAx*VRR0(23,72)+WPx*VRR1(23,72)
      VRR0(38,73)=V(27)+V(59)+V(62)+QCy*VRR0(38,49)+WQy*VRR1(38,49)
      VRR0(38,74)=2.D0*V(28)+V(67)+V(69)+QCy*VRR0(38,50)+WQy*VRR1(38,50)
      VRR0(38,75)=2.D0*V(70)+3.D0*V(71)-2.D0*V(72)+QCx*VRR0(38,51)+WQx*VRR1(38,51)
      VRR0(38,76)=V(52)+V(53)+QCz*VRR0(38,48)+WQz*VRR1(38,48)
      VRR0(38,77)=V(47)+V(51)+QCz*VRR0(38,49)+WQz*VRR1(38,49)
      VRR0(38,78)=2.D0*V(35)+2.D0*V(73)-2.D0*V(74)+QCy*VRR0(38,53)+WQy*VRR1(38,53)
      VRR0(38,79)=V(55)+V(57)+QCz*VRR0(38,51)+WQz*VRR1(38,51)
      VRR0(38,80)=3.D0*V(58)-3.D0*V(61)+QCz*VRR0(38,52)+WQz*VRR1(38,52)
      VRR0(38,81)=V(67)+V(69)+QCz*VRR0(38,53)+WQz*VRR1(38,53)
      VRR0(38,82)=4.D0*V(70)-4.D0*V(72)+QCz*VRR0(38,54)+WQz*VRR1(38,54)
      VRR0(38,83)=4.D0*V(73)-4.D0*V(74)+QCz*VRR0(38,55)+WQz*VRR1(38,55)
      VRR0(38,84)=5.D0*r1x2E*VRR0(38,35)+QCz*VRR0(38,56)-5.D0*r1x2E*ZxZpE*VRR1(38,35)+WQz*VRR1(38,56)
      VRR0(39,57)=5.D0*r1x2E*VRR0(39,21)+QCx*VRR0(39,36)+2.D0*HfxZpE*VRR1(24,36)-5.D0*r1x2E*ZxZpE*VRR1(39,21)+WQx*VRR1(39,36)
      VRR0(39,58)=4.D0*r1x2E*VRR0(39,22)+QCx*VRR0(39,37)+2.D0*HfxZpE*VRR1(24,37)-4.D0*r1x2E*ZxZpE*VRR1(39,22)+WQx*VRR1(39,37)
      VRR0(39,59)=V(76)+2.D0*V(77)+V(79)+QCx*VRR0(39,38)+WQx*VRR1(39,38)
      VRR0(39,60)=2.D0*V(80)+2.D0*V(81)-2.D0*V(82)+QCx*VRR0(39,39)+WQx*VRR1(39,39)
      VRR0(39,61)=V(42)+V(76)+V(79)+QCy*VRR0(39,39)+WQy*VRR1(39,39)
      VRR0(39,62)=4.D0*V(80)-4.D0*V(82)+QCy*VRR0(39,40)+3.D0*HfxZpE*VRR1(23,40)+WQy*VRR1(39,40)
      VRR0(39,63)=5.D0*r1x2E*VRR0(39,25)+QCy*VRR0(39,41)+3.D0*HfxZpE*VRR1(23,41)-5.D0*r1x2E*ZxZpE*VRR1(39,25)+WQy*VRR1(39,41)
      VRR0(39,64)=4.D0*r1x2E*VRR0(39,26)+QCx*VRR0(39,42)+2.D0*HfxZpE*VRR1(24,42)-4.D0*r1x2E*ZxZpE*VRR1(39,26)+WQx*VRR1(39,42)
      VRR0(39,65)=3.D0*V(83)+V(85)-3.D0*V(86)+QCx*VRR0(39,43)+WQx*VRR1(39,43)
      VRR0(39,66)=V(88)+2.D0*V(89)+V(91)+QCx*VRR0(39,44)+WQx*VRR1(39,44)
      VRR0(39,67)=V(49)+V(92)+V(93)+QCy*VRR0(39,44)+WQy*VRR1(39,44)
      VRR0(39,68)=3.D0*V(87)-3.D0*V(90)+QCy*VRR0(39,45)+3.D0*HfxZpE*VRR1(23,45)+WQy*VRR1(39,45)
      VRR0(39,69)=4.D0*r1x2E*VRR0(39,29)+QCy*VRR0(39,46)+3.D0*HfxZpE*VRR1(23,46)-4.D0*r1x2E*ZxZpE*VRR1(39,29)+WQy*VRR1(39,46)
      VRR0(39,70)=V(95)+2.D0*V(96)+V(98)+QCx*VRR0(39,47)+WQx*VRR1(39,47)
      VRR0(39,71)=V(100)+V(102)+V(104)+QCx*VRR0(39,48)+WQx*VRR1(39,48)
      VRR0(39,72)=2.D0*V(24)-2.D0*V(25)+2.D0*V(60)+PAy*VRR0(23,72)+WPy*VRR1(23,72)
      VRR0(39,73)=3.D0*V(65)+V(100)+V(104)+QCy*VRR0(39,49)+WQy*VRR1(39,49)
      VRR0(39,74)=V(106)+V(108)+QCy*VRR0(39,50)+3.D0*HfxZpE*VRR1(23,50)+WQy*VRR1(39,50)
      VRR0(39,75)=2.D0*V(109)+2.D0*V(110)-2.D0*V(111)+QCx*VRR0(39,51)+WQx*VRR1(39,51)
      VRR0(39,76)=V(92)+V(93)+QCz*VRR0(39,48)+WQz*VRR1(39,48)
      VRR0(39,77)=V(88)+V(91)+QCz*VRR0(39,49)+WQz*VRR1(39,49)
      VRR0(39,78)=2.D0*V(112)+3.D0*V(113)-2.D0*V(114)+QCy*VRR0(39,53)+WQy*VRR1(39,53)
      VRR0(39,79)=V(95)+V(98)+QCz*VRR0(39,51)+WQz*VRR1(39,51)
      VRR0(39,80)=3.D0*V(99)-3.D0*V(103)+QCz*VRR0(39,52)+WQz*VRR1(39,52)
      VRR0(39,81)=V(106)+V(108)+QCz*VRR0(39,53)+WQz*VRR1(39,53)
      VRR0(39,82)=4.D0*V(109)-4.D0*V(111)+QCz*VRR0(39,54)+WQz*VRR1(39,54)
      VRR0(39,83)=4.D0*V(112)-4.D0*V(114)+QCz*VRR0(39,55)+WQz*VRR1(39,55)
      VRR0(39,84)=5.D0*r1x2E*VRR0(39,35)+QCz*VRR0(39,56)-5.D0*r1x2E*ZxZpE*VRR1(39,35)+WQz*VRR1(39,56)
      VRR0(40,57)=5.D0*r1x2E*VRR0(40,21)+QCx*VRR0(40,36)+HfxZpE*VRR1(25,36)-5.D0*r1x2E*ZxZpE*VRR1(40,21)+WQx*VRR1(40,36)
      VRR0(40,58)=V(115)+4.D0*r1x2E*VRR0(40,22)+QCx*VRR0(40,37)-4.D0*r1x2E*ZxZpE*VRR1(40,22)+WQx*VRR1(40,37)
      VRR0(40,59)=V(117)+V(118)+V(120)+QCx*VRR0(40,38)+WQx*VRR1(40,38)
      VRR0(40,60)=3.D0*V(77)+3.D0*r1x2Z*VRR0(13,60)+PAy*VRR0(24,60)-3.D0*ExZpE*r1x2Z*VRR1(13,60)+WPy*VRR1(24,60)
      VRR0(40,61)=4.D0*V(81)+V(117)+V(120)+QCy*VRR0(40,39)+WQy*VRR1(40,39)
      VRR0(40,62)=4.D0*r1x2E*VRR0(40,24)+QCy*VRR0(40,40)+4.D0*HfxZpE*VRR1(24,40)-4.D0*r1x2E*ZxZpE*VRR1(40,24)+WQy*VRR1(40,40)
      VRR0(40,63)=5.D0*r1x2E*VRR0(40,25)+QCy*VRR0(40,41)+4.D0*HfxZpE*VRR1(24,41)-5.D0*r1x2E*ZxZpE*VRR1(40,25)+WQy*VRR1(40,41)
      VRR0(40,64)=V(121)+4.D0*r1x2E*VRR0(40,26)+QCx*VRR0(40,42)-4.D0*r1x2E*ZxZpE*VRR1(40,26)+WQx*VRR1(40,42)
      VRR0(40,65)=V(122)+3.D0*r1x2E*VRR0(40,27)+QCx*VRR0(40,43)-3.D0*r1x2E*ZxZpE*VRR1(40,27)+WQx*VRR1(40,43)
      VRR0(40,66)=V(85)+3.D0*r1x2Z*VRR0(13,66)+PAy*VRR0(24,66)-3.D0*ExZpE*r1x2Z*VRR1(13,66)+WPy*VRR1(24,66)
      VRR0(40,67)=3.D0*V(89)+3.D0*r1x2Z*VRR0(13,67)+PAy*VRR0(24,67)-3.D0*ExZpE*r1x2Z*VRR1(13,67)+WPy*VRR1(24,67)
      VRR0(40,68)=3.D0*r1x2E*VRR0(40,28)+QCy*VRR0(40,45)+4.D0*HfxZpE*VRR1(24,45)-3.D0*r1x2E*ZxZpE*VRR1(40,28)+WQy*VRR1(40,45)
      VRR0(40,69)=4.D0*r1x2E*VRR0(40,29)+QCy*VRR0(40,46)+4.D0*HfxZpE*VRR1(24,46)-4.D0*r1x2E*ZxZpE*VRR1(40,29)+WQy*VRR1(40,46)
      VRR0(40,70)=V(124)+V(125)+V(127)+QCx*VRR0(40,47)+WQx*VRR1(40,47)
      VRR0(40,71)=V(96)+3.D0*r1x2Z*VRR0(13,71)+PAy*VRR0(24,71)-3.D0*ExZpE*r1x2Z*VRR1(13,71)+WPy*VRR1(24,71)
      VRR0(40,72)=3.D0*V(63)-3.D0*V(64)+V(102)+PAy*VRR0(24,72)+WPy*VRR1(24,72)
      VRR0(40,73)=3.D0*V(128)+3.D0*r1x2Z*VRR0(13,73)+PAy*VRR0(24,73)-3.D0*ExZpE*r1x2Z*VRR1(13,73)+WPy*VRR1(24,73)
      VRR0(40,74)=V(130)+V(132)+QCy*VRR0(40,50)+4.D0*HfxZpE*VRR1(24,50)+WQy*VRR1(40,50)
      VRR0(40,75)=3.D0*r1x2Z*VRR0(13,75)+PAy*VRR0(24,75)-3.D0*ExZpE*r1x2Z*VRR1(13,75)+WPy*VRR1(24,75)
      VRR0(40,76)=V(110)+3.D0*r1x2Z*VRR0(13,76)+PAy*VRR0(24,76)-3.D0*ExZpE*r1x2Z*VRR1(13,76)+WPy*VRR1(24,76)
      VRR0(40,77)=2.D0*V(133)+3.D0*r1x2Z*VRR0(13,77)+PAy*VRR0(24,77)-3.D0*ExZpE*r1x2Z*VRR1(13,77)+WPy*VRR1(24,77)
      VRR0(40,78)=3.D0*V(134)+3.D0*r1x2Z*VRR0(13,78)+PAy*VRR0(24,78)-3.D0*ExZpE*r1x2Z*VRR1(13,78)+WPy*VRR1(24,78)
      VRR0(40,79)=V(124)+V(127)+QCz*VRR0(40,51)+WQz*VRR1(40,51)
      VRR0(40,80)=3.D0*r1x2E*VRR0(40,31)+QCz*VRR0(40,52)-3.D0*r1x2E*ZxZpE*VRR1(40,31)+WQz*VRR1(40,52)
      VRR0(40,81)=V(130)+V(132)+QCz*VRR0(40,53)+WQz*VRR1(40,53)
      VRR0(40,82)=4.D0*r1x2E*VRR0(40,33)+QCz*VRR0(40,54)-4.D0*r1x2E*ZxZpE*VRR1(40,33)+WQz*VRR1(40,54)
      VRR0(40,83)=4.D0*r1x2E*VRR0(40,34)+QCz*VRR0(40,55)-4.D0*r1x2E*ZxZpE*VRR1(40,34)+WQz*VRR1(40,55)
      VRR0(40,84)=5.D0*r1x2E*VRR0(40,35)+QCz*VRR0(40,56)-5.D0*r1x2E*ZxZpE*VRR1(40,35)+WQz*VRR1(40,56)
      VRR0(41,57)=5.D0*r1x2E*VRR0(41,21)+QCx*VRR0(41,36)-5.D0*r1x2E*ZxZpE*VRR1(41,21)+WQx*VRR1(41,36)
      VRR0(41,58)=4.D0*r1x2E*VRR0(41,22)+QCx*VRR0(41,37)-4.D0*r1x2E*ZxZpE*VRR1(41,22)+WQx*VRR1(41,37)
      VRR0(41,59)=2.D0*V(115)+4.D0*r1x2Z*VRR0(14,59)+PAy*VRR0(25,59)-4.D0*ExZpE*r1x2Z*VRR1(14,59)+WPy*VRR1(25,59)
      VRR0(41,60)=3.D0*V(118)+4.D0*r1x2Z*VRR0(14,60)+PAy*VRR0(25,60)-4.D0*ExZpE*r1x2Z*VRR1(14,60)+WPy*VRR1(25,60)
      VRR0(41,61)=4.D0*r1x2Z*VRR0(14,61)+PAy*VRR0(25,61)-4.D0*ExZpE*r1x2Z*VRR1(14,61)+4.D0*HfxZpE*VRR1(25,39)+WPy*VRR1(25,61)
      VRR0(41,62)=4.D0*r1x2E*VRR0(41,24)+QCy*VRR0(41,40)+5.D0*HfxZpE*VRR1(25,40)-4.D0*r1x2E*ZxZpE*VRR1(41,24)+WQy*VRR1(41,40)
      VRR0(41,63)=5.D0*r1x2E*VRR0(41,25)+QCy*VRR0(41,41)+5.D0*HfxZpE*VRR1(25,41)-5.D0*r1x2E*ZxZpE*VRR1(41,25)+WQy*VRR1(41,41)
      VRR0(41,64)=4.D0*r1x2E*VRR0(41,26)+QCx*VRR0(41,42)-4.D0*r1x2E*ZxZpE*VRR1(41,26)+WQx*VRR1(41,42)
      VRR0(41,65)=V(121)+4.D0*r1x2Z*VRR0(14,65)+PAy*VRR0(25,65)-4.D0*ExZpE*r1x2Z*VRR1(14,65)+WPy*VRR1(25,65)
      VRR0(41,66)=2.D0*V(122)+4.D0*r1x2Z*VRR0(14,66)+PAy*VRR0(25,66)-4.D0*ExZpE*r1x2Z*VRR1(14,66)+WPy*VRR1(25,66)
      VRR0(41,67)=4.D0*r1x2Z*VRR0(14,67)+PAy*VRR0(25,67)-4.D0*ExZpE*r1x2Z*VRR1(14,67)+3.D0*HfxZpE*VRR1(25,44)+WPy*VRR1(25,67)
      VRR0(41,68)=4.D0*r1x2Z*VRR0(14,68)+PAy*VRR0(25,68)-4.D0*ExZpE*r1x2Z*VRR1(14,68)+4.D0*HfxZpE*VRR1(25,45)+WPy*VRR1(25,68)
      VRR0(41,69)=4.D0*r1x2E*VRR0(41,29)+QCy*VRR0(41,46)+5.D0*HfxZpE*VRR1(25,46)-4.D0*r1x2E*ZxZpE*VRR1(41,29)+WQy*VRR1(41,46)
      VRR0(41,70)=4.D0*r1x2Z*VRR0(14,70)+PAy*VRR0(25,70)-4.D0*ExZpE*r1x2Z*VRR1(14,70)+WPy*VRR1(25,70)
      VRR0(41,71)=V(125)+4.D0*r1x2Z*VRR0(14,71)+PAy*VRR0(25,71)-4.D0*ExZpE*r1x2Z*VRR1(14,71)+WPy*VRR1(25,71)
      VRR0(41,72)=4.D0*r1x2Z*VRR0(14,72)+PAy*VRR0(25,72)-4.D0*ExZpE*r1x2Z*VRR1(14,72)+2.D0*HfxZpE*VRR1(25,48)+WPy*VRR1(25,72)
      VRR0(41,73)=4.D0*r1x2Z*VRR0(14,73)+PAy*VRR0(25,73)-4.D0*ExZpE*r1x2Z*VRR1(14,73)+3.D0*HfxZpE*VRR1(25,49)+WPy*VRR1(25,73)
      VRR0(41,74)=4.D0*r1x2Z*VRR0(14,74)+PAy*VRR0(25,74)-4.D0*ExZpE*r1x2Z*VRR1(14,74)+4.D0*HfxZpE*VRR1(25,50)+WPy*VRR1(25,74)
      VRR0(41,75)=4.D0*r1x2Z*VRR0(14,75)+PAy*VRR0(25,75)-4.D0*ExZpE*r1x2Z*VRR1(14,75)+WPy*VRR1(25,75)
      VRR0(41,76)=V(135)+4.D0*r1x2Z*VRR0(14,76)+PAy*VRR0(25,76)-4.D0*ExZpE*r1x2Z*VRR1(14,76)+WPy*VRR1(25,76)
      VRR0(41,77)=2.D0*V(136)+4.D0*r1x2Z*VRR0(14,77)+PAy*VRR0(25,77)-4.D0*ExZpE*r1x2Z*VRR1(14,77)+WPy*VRR1(25,77)
      VRR0(41,78)=3.D0*V(137)+4.D0*r1x2Z*VRR0(14,78)+PAy*VRR0(25,78)-4.D0*ExZpE*r1x2Z*VRR1(14,78)+WPy*VRR1(25,78)
      VRR0(41,79)=4.D0*r1x2Z*VRR0(14,79)+PAy*VRR0(25,79)-4.D0*ExZpE*r1x2Z*VRR1(14,79)+WPy*VRR1(25,79)
      VRR0(41,80)=V(138)+4.D0*r1x2Z*VRR0(14,80)+PAy*VRR0(25,80)-4.D0*ExZpE*r1x2Z*VRR1(14,80)+WPy*VRR1(25,80)
      VRR0(41,81)=2.D0*V(139)+4.D0*r1x2Z*VRR0(14,81)+PAy*VRR0(25,81)-4.D0*ExZpE*r1x2Z*VRR1(14,81)+WPy*VRR1(25,81)
      VRR0(41,82)=4.D0*r1x2E*VRR0(41,33)+QCz*VRR0(41,54)-4.D0*r1x2E*ZxZpE*VRR1(41,33)+WQz*VRR1(41,54)
      VRR0(41,83)=4.D0*r1x2E*VRR0(41,34)+QCz*VRR0(41,55)-4.D0*r1x2E*ZxZpE*VRR1(41,34)+WQz*VRR1(41,55)
      VRR0(41,84)=5.D0*r1x2E*VRR0(41,35)+QCz*VRR0(41,56)-5.D0*r1x2E*ZxZpE*VRR1(41,35)+WQz*VRR1(41,56)
      VRR0(42,57)=5.D0*r1x2E*VRR0(42,21)+QCx*VRR0(42,36)+4.D0*HfxZpE*VRR1(26,36)-5.D0*r1x2E*ZxZpE*VRR1(42,21)+WQx*VRR1(42,36)
      VRR0(42,58)=4.D0*r1x2E*VRR0(42,22)+QCx*VRR0(42,37)+4.D0*HfxZpE*VRR1(26,37)-4.D0*r1x2E*ZxZpE*VRR1(42,22)+WQx*VRR1(42,37)
      VRR0(42,59)=V(141)+V(143)+QCx*VRR0(42,38)+4.D0*HfxZpE*VRR1(26,38)+WQx*VRR1(42,38)
      VRR0(42,60)=3.D0*V(144)+3.D0*r1x2Z*VRR0(15,60)+PAx*VRR0(26,60)-3.D0*ExZpE*r1x2Z*VRR1(15,60)+WPx*VRR1(26,60)
      VRR0(42,61)=V(141)+V(143)+QCy*VRR0(42,39)+WQy*VRR1(42,39)
      VRR0(42,62)=4.D0*r1x2E*VRR0(42,24)+QCy*VRR0(42,40)-4.D0*r1x2E*ZxZpE*VRR1(42,24)+WQy*VRR1(42,40)
      VRR0(42,63)=5.D0*r1x2E*VRR0(42,25)+QCy*VRR0(42,41)-5.D0*r1x2E*ZxZpE*VRR1(42,25)+WQy*VRR1(42,41)
      VRR0(42,64)=4.D0*r1x2E*VRR0(42,26)+QCx*VRR0(42,42)+4.D0*HfxZpE*VRR1(26,42)-4.D0*r1x2E*ZxZpE*VRR1(42,26)+WQx*VRR1(42,42)
      VRR0(42,65)=3.D0*r1x2E*VRR0(42,27)+QCx*VRR0(42,43)+4.D0*HfxZpE*VRR1(26,43)-3.D0*r1x2E*ZxZpE*VRR1(42,27)+WQx*VRR1(42,43)
      VRR0(42,66)=3.D0*V(145)+3.D0*r1x2Z*VRR0(15,66)+PAx*VRR0(26,66)-3.D0*ExZpE*r1x2Z*VRR1(15,66)+WPx*VRR1(26,66)
      VRR0(42,67)=2.D0*V(146)+3.D0*r1x2Z*VRR0(15,67)+PAx*VRR0(26,67)-3.D0*ExZpE*r1x2Z*VRR1(15,67)+WPx*VRR1(26,67)
      VRR0(42,68)=3.D0*r1x2E*VRR0(42,28)+QCy*VRR0(42,45)-3.D0*r1x2E*ZxZpE*VRR1(42,28)+WQy*VRR1(42,45)
      VRR0(42,69)=4.D0*r1x2E*VRR0(42,29)+QCy*VRR0(42,46)-4.D0*r1x2E*ZxZpE*VRR1(42,29)+WQy*VRR1(42,46)
      VRR0(42,70)=V(148)+V(150)+QCx*VRR0(42,47)+4.D0*HfxZpE*VRR1(26,47)+WQx*VRR1(42,47)
      VRR0(42,71)=3.D0*V(151)+3.D0*r1x2Z*VRR0(15,71)+PAx*VRR0(26,71)-3.D0*ExZpE*r1x2Z*VRR1(15,71)+WPx*VRR1(26,71)
      VRR0(42,72)=3.D0*V(152)-3.D0*V(153)+V(155)+PAx*VRR0(26,72)+WPx*VRR1(26,72)
      VRR0(42,73)=V(156)+3.D0*r1x2Z*VRR0(15,73)+PAx*VRR0(26,73)-3.D0*ExZpE*r1x2Z*VRR1(15,73)+WPx*VRR1(26,73)
      VRR0(42,74)=V(158)+V(160)+QCy*VRR0(42,50)+WQy*VRR1(42,50)
      VRR0(42,75)=3.D0*V(161)+3.D0*r1x2Z*VRR0(15,75)+PAx*VRR0(26,75)-3.D0*ExZpE*r1x2Z*VRR1(15,75)+WPx*VRR1(26,75)
      VRR0(42,76)=V(163)+3.D0*r1x2Z*VRR0(15,76)+PAx*VRR0(26,76)-3.D0*ExZpE*r1x2Z*VRR1(15,76)+WPx*VRR1(26,76)
      VRR0(42,77)=V(164)+3.D0*r1x2Z*VRR0(15,77)+PAx*VRR0(26,77)-3.D0*ExZpE*r1x2Z*VRR1(15,77)+WPx*VRR1(26,77)
      VRR0(42,78)=3.D0*r1x2Z*VRR0(15,78)+PAx*VRR0(26,78)-3.D0*ExZpE*r1x2Z*VRR1(15,78)+WPx*VRR1(26,78)
      VRR0(42,79)=V(6)+V(148)+V(150)+QCz*VRR0(42,51)+WQz*VRR1(42,51)
      VRR0(42,80)=V(7)+3.D0*r1x2E*VRR0(42,31)+QCz*VRR0(42,52)-3.D0*r1x2E*ZxZpE*VRR1(42,31)+WQz*VRR1(42,52)
      VRR0(42,81)=V(8)+V(158)+V(160)+QCz*VRR0(42,53)+WQz*VRR1(42,53)
      VRR0(42,82)=V(9)+4.D0*r1x2E*VRR0(42,33)+QCz*VRR0(42,54)-4.D0*r1x2E*ZxZpE*VRR1(42,33)+WQz*VRR1(42,54)
      VRR0(42,83)=V(10)+4.D0*r1x2E*VRR0(42,34)+QCz*VRR0(42,55)-4.D0*r1x2E*ZxZpE*VRR1(42,34)+WQz*VRR1(42,55)
      VRR0(42,84)=5.D0*r1x2E*VRR0(42,35)+QCz*VRR0(42,56)+HfxZpE*VRR1(21,56)-5.D0*r1x2E*ZxZpE*VRR1(42,35)+WQz*VRR1(42,56)
      VRR0(43,57)=5.D0*r1x2E*VRR0(43,21)+QCx*VRR0(43,36)+3.D0*HfxZpE*VRR1(27,36)-5.D0*r1x2E*ZxZpE*VRR1(43,21)+WQx*VRR1(43,36)
      VRR0(43,58)=4.D0*r1x2E*VRR0(43,22)+QCx*VRR0(43,37)+3.D0*HfxZpE*VRR1(27,37)-4.D0*r1x2E*ZxZpE*VRR1(43,22)+WQx*VRR1(43,37)
      VRR0(43,59)=V(166)+V(168)+QCx*VRR0(43,38)+3.D0*HfxZpE*VRR1(27,38)+WQx*VRR1(43,38)
      VRR0(43,60)=2.D0*V(169)+3.D0*V(170)-2.D0*V(171)+QCx*VRR0(43,39)+WQx*VRR1(43,39)
      VRR0(43,61)=V(144)+V(166)+V(168)+QCy*VRR0(43,39)+WQy*VRR1(43,39)
      VRR0(43,62)=4.D0*V(169)-4.D0*V(171)+QCy*VRR0(43,40)+HfxZpE*VRR1(26,40)+WQy*VRR1(43,40)
      VRR0(43,63)=5.D0*r1x2E*VRR0(43,25)+QCy*VRR0(43,41)+HfxZpE*VRR1(26,41)-5.D0*r1x2E*ZxZpE*VRR1(43,25)+WQy*VRR1(43,41)
      VRR0(43,64)=4.D0*r1x2E*VRR0(43,26)+QCx*VRR0(43,42)+3.D0*HfxZpE*VRR1(27,42)-4.D0*r1x2E*ZxZpE*VRR1(43,26)+WQx*VRR1(43,42)
      VRR0(43,65)=3.D0*V(172)-3.D0*V(173)+QCx*VRR0(43,43)+3.D0*HfxZpE*VRR1(27,43)+WQx*VRR1(43,43)
      VRR0(43,66)=V(175)+3.D0*V(176)+V(178)+QCx*VRR0(43,44)+WQx*VRR1(43,44)
      VRR0(43,67)=V(145)+V(179)+V(180)+QCy*VRR0(43,44)+WQy*VRR1(43,44)
      VRR0(43,68)=V(146)+3.D0*V(174)-3.D0*V(177)+QCy*VRR0(43,45)+WQy*VRR1(43,45)
      VRR0(43,69)=4.D0*r1x2E*VRR0(43,29)+QCy*VRR0(43,46)+HfxZpE*VRR1(26,46)-4.D0*r1x2E*ZxZpE*VRR1(43,29)+WQy*VRR1(43,46)
      VRR0(43,70)=V(182)+V(184)+QCx*VRR0(43,47)+3.D0*HfxZpE*VRR1(27,47)+WQx*VRR1(43,47)
      VRR0(43,71)=V(186)+3.D0*V(187)+V(189)+QCx*VRR0(43,48)+WQx*VRR1(43,48)
      VRR0(43,72)=V(191)+V(193)+V(195)+PAx*VRR0(27,72)+WPx*VRR1(27,72)
      VRR0(43,73)=V(154)+V(186)+V(189)+QCy*VRR0(43,49)+WQy*VRR1(43,49)
      VRR0(43,74)=V(156)+V(197)+V(199)+QCy*VRR0(43,50)+WQy*VRR1(43,50)
      VRR0(43,75)=2.D0*V(200)+3.D0*V(201)-2.D0*V(202)+QCx*VRR0(43,51)+WQx*VRR1(43,51)
      VRR0(43,76)=V(23)+V(179)+V(180)+QCz*VRR0(43,48)+WQz*VRR1(43,48)
      VRR0(43,77)=V(26)+V(175)+V(178)+QCz*VRR0(43,49)+WQz*VRR1(43,49)
      VRR0(43,78)=V(164)+2.D0*V(203)-2.D0*V(204)+QCy*VRR0(43,53)+WQy*VRR1(43,53)
      VRR0(43,79)=V(33)+V(182)+V(184)+QCz*VRR0(43,51)+WQz*VRR1(43,51)
      VRR0(43,80)=V(34)+3.D0*V(185)-3.D0*V(188)+QCz*VRR0(43,52)+WQz*VRR1(43,52)
      VRR0(43,81)=V(35)+V(197)+V(199)+QCz*VRR0(43,53)+WQz*VRR1(43,53)
      VRR0(43,82)=4.D0*V(200)-4.D0*V(202)+QCz*VRR0(43,54)+HfxZpE*VRR1(22,54)+WQz*VRR1(43,54)
      VRR0(43,83)=4.D0*V(203)-4.D0*V(204)+QCz*VRR0(43,55)+HfxZpE*VRR1(22,55)+WQz*VRR1(43,55)
      VRR0(43,84)=5.D0*r1x2E*VRR0(43,35)+QCz*VRR0(43,56)+HfxZpE*VRR1(22,56)-5.D0*r1x2E*ZxZpE*VRR1(43,35)+WQz*VRR1(43,56)
      VRR0(44,57)=5.D0*r1x2E*VRR0(44,21)+QCx*VRR0(44,36)+2.D0*HfxZpE*VRR1(28,36)-5.D0*r1x2E*ZxZpE*VRR1(44,21)+WQx*VRR1(44,36)
      VRR0(44,58)=4.D0*r1x2E*VRR0(44,22)+QCx*VRR0(44,37)+2.D0*HfxZpE*VRR1(28,37)-4.D0*r1x2E*ZxZpE*VRR1(44,22)+WQx*VRR1(44,37)
      VRR0(44,59)=V(206)+V(208)+QCx*VRR0(44,38)+2.D0*HfxZpE*VRR1(28,38)+WQx*VRR1(44,38)
      VRR0(44,60)=2.D0*V(209)+2.D0*V(210)-2.D0*V(211)+QCx*VRR0(44,39)+WQx*VRR1(44,39)
      VRR0(44,61)=2.D0*V(170)+V(206)+V(208)+QCy*VRR0(44,39)+WQy*VRR1(44,39)
      VRR0(44,62)=4.D0*V(209)-4.D0*V(211)+QCy*VRR0(44,40)+2.D0*HfxZpE*VRR1(27,40)+WQy*VRR1(44,40)
      VRR0(44,63)=5.D0*r1x2E*VRR0(44,25)+QCy*VRR0(44,41)+2.D0*HfxZpE*VRR1(27,41)-5.D0*r1x2E*ZxZpE*VRR1(44,25)+WQy*VRR1(44,41)
      VRR0(44,64)=4.D0*r1x2E*VRR0(44,26)+QCx*VRR0(44,42)+2.D0*HfxZpE*VRR1(28,42)-4.D0*r1x2E*ZxZpE*VRR1(44,26)+WQx*VRR1(44,42)
      VRR0(44,65)=3.D0*V(212)-3.D0*V(213)+QCx*VRR0(44,43)+2.D0*HfxZpE*VRR1(28,43)+WQx*VRR1(44,43)
      VRR0(44,66)=V(215)+2.D0*V(216)+V(218)+QCx*VRR0(44,44)+WQx*VRR1(44,44)
      VRR0(44,67)=2.D0*V(176)+V(219)+V(220)+QCy*VRR0(44,44)+WQy*VRR1(44,44)
      VRR0(44,68)=3.D0*V(214)-3.D0*V(217)+QCy*VRR0(44,45)+2.D0*HfxZpE*VRR1(27,45)+WQy*VRR1(44,45)
      VRR0(44,69)=4.D0*r1x2E*VRR0(44,29)+QCy*VRR0(44,46)+2.D0*HfxZpE*VRR1(27,46)-4.D0*r1x2E*ZxZpE*VRR1(44,29)+WQy*VRR1(44,46)
      VRR0(44,70)=V(222)+V(224)+QCx*VRR0(44,47)+2.D0*HfxZpE*VRR1(28,47)+WQx*VRR1(44,47)
      VRR0(44,71)=V(226)+V(228)+V(230)+QCx*VRR0(44,48)+WQx*VRR1(44,48)
      VRR0(44,72)=V(231)+V(233)-V(234)+QCx*VRR0(44,49)+WQx*VRR1(44,49)
      VRR0(44,73)=V(195)+V(226)+V(230)+QCy*VRR0(44,49)+WQy*VRR1(44,49)
      VRR0(44,74)=V(235)+V(236)+QCy*VRR0(44,50)+2.D0*HfxZpE*VRR1(27,50)+WQy*VRR1(44,50)
      VRR0(44,75)=2.D0*V(237)+V(239)-2.D0*V(240)+QCx*VRR0(44,51)+WQx*VRR1(44,51)
      VRR0(44,76)=V(60)+V(219)+V(220)+QCz*VRR0(44,48)+WQz*VRR1(44,48)
      VRR0(44,77)=V(65)+V(215)+V(218)+QCz*VRR0(44,49)+WQz*VRR1(44,49)
      VRR0(44,78)=2.D0*V(241)+V(243)-2.D0*V(244)+QCy*VRR0(44,53)+WQy*VRR1(44,53)
      VRR0(44,79)=V(71)+V(222)+V(224)+QCz*VRR0(44,51)+WQz*VRR1(44,51)
      VRR0(44,80)=3.D0*V(225)-3.D0*V(229)+QCz*VRR0(44,52)+HfxZpE*VRR1(23,52)+WQz*VRR1(44,52)
      VRR0(44,81)=V(113)+V(235)+V(236)+QCz*VRR0(44,53)+WQz*VRR1(44,53)
      VRR0(44,82)=4.D0*V(237)-4.D0*V(240)+QCz*VRR0(44,54)+HfxZpE*VRR1(23,54)+WQz*VRR1(44,54)
      VRR0(44,83)=4.D0*V(241)-4.D0*V(244)+QCz*VRR0(44,55)+HfxZpE*VRR1(23,55)+WQz*VRR1(44,55)
      VRR0(44,84)=5.D0*r1x2E*VRR0(44,35)+QCz*VRR0(44,56)+HfxZpE*VRR1(23,56)-5.D0*r1x2E*ZxZpE*VRR1(44,35)+WQz*VRR1(44,56)
      VRR0(45,57)=5.D0*r1x2E*VRR0(45,21)+QCx*VRR0(45,36)+HfxZpE*VRR1(29,36)-5.D0*r1x2E*ZxZpE*VRR1(45,21)+WQx*VRR1(45,36)
      VRR0(45,58)=4.D0*r1x2E*VRR0(45,22)+QCx*VRR0(45,37)+HfxZpE*VRR1(29,37)-4.D0*r1x2E*ZxZpE*VRR1(45,22)+WQx*VRR1(45,37)
      VRR0(45,59)=V(246)+V(247)+V(249)+QCx*VRR0(45,38)+WQx*VRR1(45,38)
      VRR0(45,60)=2.D0*V(250)+V(251)-2.D0*V(252)+QCx*VRR0(45,39)+WQx*VRR1(45,39)
      VRR0(45,61)=3.D0*V(210)+V(246)+V(249)+QCy*VRR0(45,39)+WQy*VRR1(45,39)
      VRR0(45,62)=4.D0*V(250)-4.D0*V(252)+QCy*VRR0(45,40)+3.D0*HfxZpE*VRR1(28,40)+WQy*VRR1(45,40)
      VRR0(45,63)=5.D0*r1x2E*VRR0(45,25)+QCy*VRR0(45,41)+3.D0*HfxZpE*VRR1(28,41)-5.D0*r1x2E*ZxZpE*VRR1(45,25)+WQy*VRR1(45,41)
      VRR0(45,64)=4.D0*r1x2E*VRR0(45,26)+QCx*VRR0(45,42)+HfxZpE*VRR1(29,42)-4.D0*r1x2E*ZxZpE*VRR1(45,26)+WQx*VRR1(45,42)
      VRR0(45,65)=3.D0*V(253)+V(254)-3.D0*V(255)+QCx*VRR0(45,43)+WQx*VRR1(45,43)
      VRR0(45,66)=V(257)+V(258)+V(260)+QCx*VRR0(45,44)+WQx*VRR1(45,44)
      VRR0(45,67)=3.D0*V(216)+V(261)+V(262)+QCy*VRR0(45,44)+WQy*VRR1(45,44)
      VRR0(45,68)=3.D0*V(256)-3.D0*V(259)+QCy*VRR0(45,45)+3.D0*HfxZpE*VRR1(28,45)+WQy*VRR1(45,45)
      VRR0(45,69)=4.D0*r1x2E*VRR0(45,29)+QCy*VRR0(45,46)+3.D0*HfxZpE*VRR1(28,46)-4.D0*r1x2E*ZxZpE*VRR1(45,29)+WQy*VRR1(45,46)
      VRR0(45,70)=V(264)+V(265)+V(267)+QCx*VRR0(45,47)+WQx*VRR1(45,47)
      VRR0(45,71)=V(269)+V(270)+V(272)+QCx*VRR0(45,48)+WQx*VRR1(45,48)
      VRR0(45,72)=V(191)+V(193)+V(228)+PAy*VRR0(28,72)+WPy*VRR1(28,72)
      VRR0(45,73)=3.D0*V(232)+V(269)+V(272)+QCy*VRR0(45,49)+WQy*VRR1(45,49)
      VRR0(45,74)=V(274)+V(276)+QCy*VRR0(45,50)+3.D0*HfxZpE*VRR1(28,50)+WQy*VRR1(45,50)
      VRR0(45,75)=2.D0*V(277)+V(278)-2.D0*V(279)+QCx*VRR0(45,51)+WQx*VRR1(45,51)
      VRR0(45,76)=V(101)+V(261)+V(262)+QCz*VRR0(45,48)+WQz*VRR1(45,48)
      VRR0(45,77)=V(128)+V(257)+V(260)+QCz*VRR0(45,49)+WQz*VRR1(45,49)
      VRR0(45,78)=2.D0*V(280)+3.D0*V(281)-2.D0*V(282)+QCy*VRR0(45,53)+WQy*VRR1(45,53)
      VRR0(45,79)=V(110)+V(264)+V(267)+QCz*VRR0(45,51)+WQz*VRR1(45,51)
      VRR0(45,80)=V(133)+3.D0*V(268)-3.D0*V(271)+QCz*VRR0(45,52)+WQz*VRR1(45,52)
      VRR0(45,81)=V(134)+V(274)+V(276)+QCz*VRR0(45,53)+WQz*VRR1(45,53)
      VRR0(45,82)=4.D0*V(277)-4.D0*V(279)+QCz*VRR0(45,54)+HfxZpE*VRR1(24,54)+WQz*VRR1(45,54)
      VRR0(45,83)=4.D0*V(280)-4.D0*V(282)+QCz*VRR0(45,55)+HfxZpE*VRR1(24,55)+WQz*VRR1(45,55)
      VRR0(45,84)=5.D0*r1x2E*VRR0(45,35)+QCz*VRR0(45,56)+HfxZpE*VRR1(24,56)-5.D0*r1x2E*ZxZpE*VRR1(45,35)+WQz*VRR1(45,56)
      VRR0(46,57)=5.D0*r1x2E*VRR0(46,21)+QCx*VRR0(46,36)-5.D0*r1x2E*ZxZpE*VRR1(46,21)+WQx*VRR1(46,36)
      VRR0(46,58)=4.D0*r1x2E*VRR0(46,22)+QCx*VRR0(46,37)-4.D0*r1x2E*ZxZpE*VRR1(46,22)+WQx*VRR1(46,37)
      VRR0(46,59)=V(284)+V(286)+QCx*VRR0(46,38)+WQx*VRR1(46,38)
      VRR0(46,60)=3.D0*V(247)+3.D0*r1x2Z*VRR0(17,60)+PAy*VRR0(29,60)-3.D0*ExZpE*r1x2Z*VRR1(17,60)+WPy*VRR1(29,60)
      VRR0(46,61)=4.D0*V(251)+V(284)+V(286)+QCy*VRR0(46,39)+WQy*VRR1(46,39)
      VRR0(46,62)=4.D0*r1x2E*VRR0(46,24)+QCy*VRR0(46,40)+4.D0*HfxZpE*VRR1(29,40)-4.D0*r1x2E*ZxZpE*VRR1(46,24)+WQy*VRR1(46,40)
      VRR0(46,63)=5.D0*r1x2E*VRR0(46,25)+QCy*VRR0(46,41)+4.D0*HfxZpE*VRR1(29,41)-5.D0*r1x2E*ZxZpE*VRR1(46,25)+WQy*VRR1(46,41)
      VRR0(46,64)=4.D0*r1x2E*VRR0(46,26)+QCx*VRR0(46,42)-4.D0*r1x2E*ZxZpE*VRR1(46,26)+WQx*VRR1(46,42)
      VRR0(46,65)=3.D0*r1x2E*VRR0(46,27)+QCx*VRR0(46,43)-3.D0*r1x2E*ZxZpE*VRR1(46,27)+WQx*VRR1(46,43)
      VRR0(46,66)=2.D0*V(254)+3.D0*r1x2Z*VRR0(17,66)+PAy*VRR0(29,66)-3.D0*ExZpE*r1x2Z*VRR1(17,66)+WPy*VRR1(29,66)
      VRR0(46,67)=3.D0*V(258)+3.D0*r1x2Z*VRR0(17,67)+PAy*VRR0(29,67)-3.D0*ExZpE*r1x2Z*VRR1(17,67)+WPy*VRR1(29,67)
      VRR0(46,68)=3.D0*r1x2E*VRR0(46,28)+QCy*VRR0(46,45)+4.D0*HfxZpE*VRR1(29,45)-3.D0*r1x2E*ZxZpE*VRR1(46,28)+WQy*VRR1(46,45)
      VRR0(46,69)=4.D0*r1x2E*VRR0(46,29)+QCy*VRR0(46,46)+4.D0*HfxZpE*VRR1(29,46)-4.D0*r1x2E*ZxZpE*VRR1(46,29)+WQy*VRR1(46,46)
      VRR0(46,70)=V(288)+V(290)+QCx*VRR0(46,47)+WQx*VRR1(46,47)
      VRR0(46,71)=V(265)+3.D0*r1x2Z*VRR0(17,71)+PAy*VRR0(29,71)-3.D0*ExZpE*r1x2Z*VRR1(17,71)+WPy*VRR1(29,71)
      VRR0(46,72)=3.D0*V(291)-3.D0*V(292)+V(293)+PAy*VRR0(29,72)+WPy*VRR1(29,72)
      VRR0(46,73)=3.D0*V(294)+3.D0*r1x2Z*VRR0(17,73)+PAy*VRR0(29,73)-3.D0*ExZpE*r1x2Z*VRR1(17,73)+WPy*VRR1(29,73)
      VRR0(46,74)=V(296)+V(298)+QCy*VRR0(46,50)+4.D0*HfxZpE*VRR1(29,50)+WQy*VRR1(46,50)
      VRR0(46,75)=3.D0*r1x2Z*VRR0(17,75)+PAy*VRR0(29,75)-3.D0*ExZpE*r1x2Z*VRR1(17,75)+WPy*VRR1(29,75)
      VRR0(46,76)=V(278)+3.D0*r1x2Z*VRR0(17,76)+PAy*VRR0(29,76)-3.D0*ExZpE*r1x2Z*VRR1(17,76)+WPy*VRR1(29,76)
      VRR0(46,77)=V(300)+3.D0*r1x2Z*VRR0(17,77)+PAy*VRR0(29,77)-3.D0*ExZpE*r1x2Z*VRR1(17,77)+WPy*VRR1(29,77)
      VRR0(46,78)=3.D0*V(301)+3.D0*r1x2Z*VRR0(17,78)+PAy*VRR0(29,78)-3.D0*ExZpE*r1x2Z*VRR1(17,78)+WPy*VRR1(29,78)
      VRR0(46,79)=V(135)+V(288)+V(290)+QCz*VRR0(46,51)+WQz*VRR1(46,51)
      VRR0(46,80)=V(136)+3.D0*r1x2E*VRR0(46,31)+QCz*VRR0(46,52)-3.D0*r1x2E*ZxZpE*VRR1(46,31)+WQz*VRR1(46,52)
      VRR0(46,81)=V(137)+V(296)+V(298)+QCz*VRR0(46,53)+WQz*VRR1(46,53)
      VRR0(46,82)=V(138)+4.D0*r1x2E*VRR0(46,33)+QCz*VRR0(46,54)-4.D0*r1x2E*ZxZpE*VRR1(46,33)+WQz*VRR1(46,54)
      VRR0(46,83)=V(139)+4.D0*r1x2E*VRR0(46,34)+QCz*VRR0(46,55)-4.D0*r1x2E*ZxZpE*VRR1(46,34)+WQz*VRR1(46,55)
      VRR0(46,84)=5.D0*r1x2E*VRR0(46,35)+QCz*VRR0(46,56)+HfxZpE*VRR1(25,56)-5.D0*r1x2E*ZxZpE*VRR1(46,35)+WQz*VRR1(46,56)
      VRR0(47,57)=5.D0*r1x2E*VRR0(47,21)+QCx*VRR0(47,36)+3.D0*HfxZpE*VRR1(30,36)-5.D0*r1x2E*ZxZpE*VRR1(47,21)+WQx*VRR1(47,36)
      VRR0(47,58)=4.D0*r1x2E*VRR0(47,22)+QCx*VRR0(47,37)+3.D0*HfxZpE*VRR1(30,37)-4.D0*r1x2E*ZxZpE*VRR1(47,22)+WQx*VRR1(47,37)
      VRR0(47,59)=V(303)+V(305)+QCx*VRR0(47,38)+3.D0*HfxZpE*VRR1(30,38)+WQx*VRR1(47,38)
      VRR0(47,60)=2.D0*V(306)+3.D0*V(307)-2.D0*V(308)+QCx*VRR0(47,39)+WQx*VRR1(47,39)
      VRR0(47,61)=V(303)+V(305)+QCy*VRR0(47,39)+WQy*VRR1(47,39)
      VRR0(47,62)=4.D0*V(306)-4.D0*V(308)+QCy*VRR0(47,40)+WQy*VRR1(47,40)
      VRR0(47,63)=5.D0*r1x2E*VRR0(47,25)+QCy*VRR0(47,41)-5.D0*r1x2E*ZxZpE*VRR1(47,25)+WQy*VRR1(47,41)
      VRR0(47,64)=4.D0*r1x2E*VRR0(47,26)+QCx*VRR0(47,42)+3.D0*HfxZpE*VRR1(30,42)-4.D0*r1x2E*ZxZpE*VRR1(47,26)+WQx*VRR1(47,42)
      VRR0(47,65)=3.D0*V(309)-3.D0*V(310)+QCx*VRR0(47,43)+3.D0*HfxZpE*VRR1(30,43)+WQx*VRR1(47,43)
      VRR0(47,66)=V(312)+3.D0*V(313)+V(315)+QCx*VRR0(47,44)+WQx*VRR1(47,44)
      VRR0(47,67)=V(316)+V(317)+QCy*VRR0(47,44)+WQy*VRR1(47,44)
      VRR0(47,68)=3.D0*V(311)-3.D0*V(314)+QCy*VRR0(47,45)+WQy*VRR1(47,45)
      VRR0(47,69)=4.D0*r1x2E*VRR0(47,29)+QCy*VRR0(47,46)-4.D0*r1x2E*ZxZpE*VRR1(47,29)+WQy*VRR1(47,46)
      VRR0(47,70)=V(319)+V(321)+QCx*VRR0(47,47)+3.D0*HfxZpE*VRR1(30,47)+WQx*VRR1(47,47)
      VRR0(47,71)=V(323)+V(325)+V(327)+QCx*VRR0(47,48)+WQx*VRR1(47,48)
      VRR0(47,72)=2.D0*V(328)-2.D0*V(329)+2.D0*V(330)+PAx*VRR0(30,72)+WPx*VRR1(30,72)
      VRR0(47,73)=V(323)+V(327)+QCy*VRR0(47,49)+WQy*VRR1(47,49)
      VRR0(47,74)=V(332)+V(334)+QCy*VRR0(47,50)+WQy*VRR1(47,50)
      VRR0(47,75)=2.D0*V(335)+V(337)-2.D0*V(338)+QCx*VRR0(47,51)+WQx*VRR1(47,51)
      VRR0(47,76)=2.D0*V(151)+V(316)+V(317)+QCz*VRR0(47,48)+WQz*VRR1(47,48)
      VRR0(47,77)=V(155)+V(312)+V(315)+QCz*VRR0(47,49)+WQz*VRR1(47,49)
      VRR0(47,78)=2.D0*V(339)-2.D0*V(340)+QCy*VRR0(47,53)+WQy*VRR1(47,53)
      VRR0(47,79)=2.D0*V(161)+V(319)+V(321)+QCz*VRR0(47,51)+WQz*VRR1(47,51)
      VRR0(47,80)=V(163)+3.D0*V(322)-3.D0*V(326)+QCz*VRR0(47,52)+WQz*VRR1(47,52)
      VRR0(47,81)=2.D0*V(164)+V(332)+V(334)+QCz*VRR0(47,53)+WQz*VRR1(47,53)
      VRR0(47,82)=4.D0*V(335)-4.D0*V(338)+QCz*VRR0(47,54)+2.D0*HfxZpE*VRR1(26,54)+WQz*VRR1(47,54)
      VRR0(47,83)=4.D0*V(339)-4.D0*V(340)+QCz*VRR0(47,55)+2.D0*HfxZpE*VRR1(26,55)+WQz*VRR1(47,55)
      VRR0(47,84)=5.D0*r1x2E*VRR0(47,35)+QCz*VRR0(47,56)+2.D0*HfxZpE*VRR1(26,56)-5.D0*r1x2E*ZxZpE*VRR1(47,35)+WQz*VRR1(47,56)
      VRR0(48,57)=5.D0*r1x2E*VRR0(48,21)+QCx*VRR0(48,36)+2.D0*HfxZpE*VRR1(31,36)-5.D0*r1x2E*ZxZpE*VRR1(48,21)+WQx*VRR1(48,36)
      VRR0(48,58)=4.D0*r1x2E*VRR0(48,22)+QCx*VRR0(48,37)+2.D0*HfxZpE*VRR1(31,37)-4.D0*r1x2E*ZxZpE*VRR1(48,22)+WQx*VRR1(48,37)
      VRR0(48,59)=V(342)+V(344)+QCx*VRR0(48,38)+2.D0*HfxZpE*VRR1(31,38)+WQx*VRR1(48,38)
      VRR0(48,60)=2.D0*V(345)+V(347)-2.D0*V(348)+QCx*VRR0(48,39)+WQx*VRR1(48,39)
      VRR0(48,61)=V(307)+V(342)+V(344)+QCy*VRR0(48,39)+WQy*VRR1(48,39)
      VRR0(48,62)=4.D0*V(345)-4.D0*V(348)+QCy*VRR0(48,40)+HfxZpE*VRR1(30,40)+WQy*VRR1(48,40)
      VRR0(48,63)=5.D0*r1x2E*VRR0(48,25)+QCy*VRR0(48,41)+HfxZpE*VRR1(30,41)-5.D0*r1x2E*ZxZpE*VRR1(48,25)+WQy*VRR1(48,41)
      VRR0(48,64)=4.D0*r1x2E*VRR0(48,26)+QCx*VRR0(48,42)+2.D0*HfxZpE*VRR1(31,42)-4.D0*r1x2E*ZxZpE*VRR1(48,26)+WQx*VRR1(48,42)
      VRR0(48,65)=3.D0*V(349)-3.D0*V(350)+QCx*VRR0(48,43)+2.D0*HfxZpE*VRR1(31,43)+WQx*VRR1(48,43)
      VRR0(48,66)=V(352)+V(354)+V(356)+QCx*VRR0(48,44)+WQx*VRR1(48,44)
      VRR0(48,67)=V(313)+V(357)+V(358)+QCy*VRR0(48,44)+WQy*VRR1(48,44)
      VRR0(48,68)=3.D0*V(351)-3.D0*V(355)+QCy*VRR0(48,45)+HfxZpE*VRR1(30,45)+WQy*VRR1(48,45)
      VRR0(48,69)=4.D0*r1x2E*VRR0(48,29)+QCy*VRR0(48,46)+HfxZpE*VRR1(30,46)-4.D0*r1x2E*ZxZpE*VRR1(48,29)+WQy*VRR1(48,46)
      VRR0(48,70)=V(360)+V(362)+QCx*VRR0(48,47)+2.D0*HfxZpE*VRR1(31,47)+WQx*VRR1(48,47)
      VRR0(48,71)=V(364)+2.D0*V(365)+V(367)+QCx*VRR0(48,48)+WQx*VRR1(48,48)
      VRR0(48,72)=V(368)+V(370)-V(371)+QCx*VRR0(48,49)+WQx*VRR1(48,49)
      VRR0(48,73)=V(330)+V(364)+V(367)+QCy*VRR0(48,49)+WQy*VRR1(48,49)
      VRR0(48,74)=V(372)+V(373)+QCy*VRR0(48,50)+HfxZpE*VRR1(30,50)+WQy*VRR1(48,50)
      VRR0(48,75)=2.D0*V(374)+2.D0*V(375)-2.D0*V(376)+QCx*VRR0(48,51)+WQx*VRR1(48,51)
      VRR0(48,76)=2.D0*V(187)+V(357)+V(358)+QCz*VRR0(48,48)+WQz*VRR1(48,48)
      VRR0(48,77)=V(195)+V(352)+V(356)+QCz*VRR0(48,49)+WQz*VRR1(48,49)
      VRR0(48,78)=2.D0*V(377)+V(378)-2.D0*V(379)+QCy*VRR0(48,53)+WQy*VRR1(48,53)
      VRR0(48,79)=2.D0*V(201)+V(360)+V(362)+QCz*VRR0(48,51)+WQz*VRR1(48,51)
      VRR0(48,80)=3.D0*V(363)-3.D0*V(366)+QCz*VRR0(48,52)+2.D0*HfxZpE*VRR1(27,52)+WQz*VRR1(48,52)
      VRR0(48,81)=V(243)+V(372)+V(373)+QCz*VRR0(48,53)+WQz*VRR1(48,53)
      VRR0(48,82)=4.D0*V(374)-4.D0*V(376)+QCz*VRR0(48,54)+2.D0*HfxZpE*VRR1(27,54)+WQz*VRR1(48,54)
      VRR0(48,83)=4.D0*V(377)-4.D0*V(379)+QCz*VRR0(48,55)+2.D0*HfxZpE*VRR1(27,55)+WQz*VRR1(48,55)
      VRR0(48,84)=5.D0*r1x2E*VRR0(48,35)+QCz*VRR0(48,56)+2.D0*HfxZpE*VRR1(27,56)-5.D0*r1x2E*ZxZpE*VRR1(48,35)+WQz*VRR1(48,56)
      VRR0(49,57)=5.D0*r1x2E*VRR0(49,21)+QCx*VRR0(49,36)+HfxZpE*VRR1(32,36)-5.D0*r1x2E*ZxZpE*VRR1(49,21)+WQx*VRR1(49,36)
      VRR0(49,58)=4.D0*r1x2E*VRR0(49,22)+QCx*VRR0(49,37)+HfxZpE*VRR1(32,37)-4.D0*r1x2E*ZxZpE*VRR1(49,22)+WQx*VRR1(49,37)
      VRR0(49,59)=V(381)+V(383)+QCx*VRR0(49,38)+HfxZpE*VRR1(32,38)+WQx*VRR1(49,38)
      VRR0(49,60)=2.D0*V(384)+V(385)-2.D0*V(386)+QCx*VRR0(49,39)+WQx*VRR1(49,39)
      VRR0(49,61)=V(347)+V(381)+V(383)+QCy*VRR0(49,39)+WQy*VRR1(49,39)
      VRR0(49,62)=4.D0*V(384)-4.D0*V(386)+QCy*VRR0(49,40)+2.D0*HfxZpE*VRR1(31,40)+WQy*VRR1(49,40)
      VRR0(49,63)=5.D0*r1x2E*VRR0(49,25)+QCy*VRR0(49,41)+2.D0*HfxZpE*VRR1(31,41)-5.D0*r1x2E*ZxZpE*VRR1(49,25)+WQy*VRR1(49,41)
      VRR0(49,64)=4.D0*r1x2E*VRR0(49,26)+QCx*VRR0(49,42)+HfxZpE*VRR1(32,42)-4.D0*r1x2E*ZxZpE*VRR1(49,26)+WQx*VRR1(49,42)
      VRR0(49,65)=3.D0*V(387)-3.D0*V(388)+QCx*VRR0(49,43)+HfxZpE*VRR1(32,43)+WQx*VRR1(49,43)
      VRR0(49,66)=V(390)+V(391)+V(393)+QCx*VRR0(49,44)+WQx*VRR1(49,44)
      VRR0(49,67)=V(354)+V(394)+V(395)+QCy*VRR0(49,44)+WQy*VRR1(49,44)
      VRR0(49,68)=3.D0*V(389)-3.D0*V(392)+QCy*VRR0(49,45)+2.D0*HfxZpE*VRR1(31,45)+WQy*VRR1(49,45)
      VRR0(49,69)=4.D0*r1x2E*VRR0(49,29)+QCy*VRR0(49,46)+2.D0*HfxZpE*VRR1(31,46)-4.D0*r1x2E*ZxZpE*VRR1(49,29)+WQy*VRR1(49,46)
      VRR0(49,70)=V(397)+V(399)+QCx*VRR0(49,47)+HfxZpE*VRR1(32,47)+WQx*VRR1(49,47)
      VRR0(49,71)=V(401)+V(402)+V(404)+QCx*VRR0(49,48)+WQx*VRR1(49,48)
      VRR0(49,72)=V(405)+V(406)-V(407)+QCx*VRR0(49,49)+WQx*VRR1(49,49)
      VRR0(49,73)=V(370)+V(401)+V(404)+QCy*VRR0(49,49)+WQy*VRR1(49,49)
      VRR0(49,74)=V(408)+V(409)+QCy*VRR0(49,50)+2.D0*HfxZpE*VRR1(31,50)+WQy*VRR1(49,50)
      VRR0(49,75)=2.D0*V(410)+V(411)-2.D0*V(412)+QCx*VRR0(49,51)+WQx*VRR1(49,51)
      VRR0(49,76)=V(228)+V(394)+V(395)+QCz*VRR0(49,48)+WQz*VRR1(49,48)
      VRR0(49,77)=V(233)+V(390)+V(393)+QCz*VRR0(49,49)+WQz*VRR1(49,49)
      VRR0(49,78)=2.D0*V(413)+2.D0*V(414)-2.D0*V(415)+QCy*VRR0(49,53)+WQy*VRR1(49,53)
      VRR0(49,79)=V(239)+V(397)+V(399)+QCz*VRR0(49,51)+WQz*VRR1(49,51)
      VRR0(49,80)=3.D0*V(400)-3.D0*V(403)+QCz*VRR0(49,52)+2.D0*HfxZpE*VRR1(28,52)+WQz*VRR1(49,52)
      VRR0(49,81)=2.D0*V(281)+V(408)+V(409)+QCz*VRR0(49,53)+WQz*VRR1(49,53)
      VRR0(49,82)=4.D0*V(410)-4.D0*V(412)+QCz*VRR0(49,54)+2.D0*HfxZpE*VRR1(28,54)+WQz*VRR1(49,54)
      VRR0(49,83)=4.D0*V(413)-4.D0*V(415)+QCz*VRR0(49,55)+2.D0*HfxZpE*VRR1(28,55)+WQz*VRR1(49,55)
      VRR0(49,84)=5.D0*r1x2E*VRR0(49,35)+QCz*VRR0(49,56)+2.D0*HfxZpE*VRR1(28,56)-5.D0*r1x2E*ZxZpE*VRR1(49,35)+WQz*VRR1(49,56)
      VRR0(50,57)=5.D0*r1x2E*VRR0(50,21)+QCx*VRR0(50,36)-5.D0*r1x2E*ZxZpE*VRR1(50,21)+WQx*VRR1(50,36)
      VRR0(50,58)=4.D0*r1x2E*VRR0(50,22)+QCx*VRR0(50,37)-4.D0*r1x2E*ZxZpE*VRR1(50,22)+WQx*VRR1(50,37)
      VRR0(50,59)=V(417)+V(419)+QCx*VRR0(50,38)+WQx*VRR1(50,38)
      VRR0(50,60)=2.D0*V(420)-2.D0*V(421)+QCx*VRR0(50,39)+WQx*VRR1(50,39)
      VRR0(50,61)=3.D0*V(385)+V(417)+V(419)+QCy*VRR0(50,39)+WQy*VRR1(50,39)
      VRR0(50,62)=4.D0*V(420)-4.D0*V(421)+QCy*VRR0(50,40)+3.D0*HfxZpE*VRR1(32,40)+WQy*VRR1(50,40)
      VRR0(50,63)=5.D0*r1x2E*VRR0(50,25)+QCy*VRR0(50,41)+3.D0*HfxZpE*VRR1(32,41)-5.D0*r1x2E*ZxZpE*VRR1(50,25)+WQy*VRR1(50,41)
      VRR0(50,64)=4.D0*r1x2E*VRR0(50,26)+QCx*VRR0(50,42)-4.D0*r1x2E*ZxZpE*VRR1(50,26)+WQx*VRR1(50,42)
      VRR0(50,65)=3.D0*V(422)-3.D0*V(423)+QCx*VRR0(50,43)+WQx*VRR1(50,43)
      VRR0(50,66)=V(425)+V(427)+QCx*VRR0(50,44)+WQx*VRR1(50,44)
      VRR0(50,67)=3.D0*V(391)+V(428)+V(429)+QCy*VRR0(50,44)+WQy*VRR1(50,44)
      VRR0(50,68)=3.D0*V(424)-3.D0*V(426)+QCy*VRR0(50,45)+3.D0*HfxZpE*VRR1(32,45)+WQy*VRR1(50,45)
      VRR0(50,69)=4.D0*r1x2E*VRR0(50,29)+QCy*VRR0(50,46)+3.D0*HfxZpE*VRR1(32,46)-4.D0*r1x2E*ZxZpE*VRR1(50,29)+WQy*VRR1(50,46)
      VRR0(50,70)=V(431)+V(433)+QCx*VRR0(50,47)+WQx*VRR1(50,47)
      VRR0(50,71)=V(435)+V(437)+QCx*VRR0(50,48)+WQx*VRR1(50,48)
      VRR0(50,72)=2.D0*V(402)+2.D0*V(438)-2.D0*V(439)+PAy*VRR0(32,72)+WPy*VRR1(32,72)
      VRR0(50,73)=V(435)+V(437)+V(440)+QCy*VRR0(50,49)+WQy*VRR1(50,49)
      VRR0(50,74)=V(442)+V(444)+QCy*VRR0(50,50)+3.D0*HfxZpE*VRR1(32,50)+WQy*VRR1(50,50)
      VRR0(50,75)=2.D0*V(445)-2.D0*V(446)+QCx*VRR0(50,51)+WQx*VRR1(50,51)
      VRR0(50,76)=V(293)+V(428)+V(429)+QCz*VRR0(50,48)+WQz*VRR1(50,48)
      VRR0(50,77)=2.D0*V(294)+V(425)+V(427)+QCz*VRR0(50,49)+WQz*VRR1(50,49)
      VRR0(50,78)=2.D0*V(447)+V(449)-2.D0*V(450)+QCy*VRR0(50,53)+WQy*VRR1(50,53)
      VRR0(50,79)=2.D0*V(278)+V(431)+V(433)+QCz*VRR0(50,51)+WQz*VRR1(50,51)
      VRR0(50,80)=V(300)+3.D0*V(434)-3.D0*V(436)+QCz*VRR0(50,52)+WQz*VRR1(50,52)
      VRR0(50,81)=2.D0*V(301)+V(442)+V(444)+QCz*VRR0(50,53)+WQz*VRR1(50,53)
      VRR0(50,82)=4.D0*V(445)-4.D0*V(446)+QCz*VRR0(50,54)+2.D0*HfxZpE*VRR1(29,54)+WQz*VRR1(50,54)
      VRR0(50,83)=4.D0*V(447)-4.D0*V(450)+QCz*VRR0(50,55)+2.D0*HfxZpE*VRR1(29,55)+WQz*VRR1(50,55)
      VRR0(50,84)=5.D0*r1x2E*VRR0(50,35)+QCz*VRR0(50,56)+2.D0*HfxZpE*VRR1(29,56)-5.D0*r1x2E*ZxZpE*VRR1(50,35)+WQz*VRR1(50,56)
      VRR0(51,57)=5.D0*r1x2E*VRR0(51,21)+QCx*VRR0(51,36)+2.D0*HfxZpE*VRR1(33,36)-5.D0*r1x2E*ZxZpE*VRR1(51,21)+WQx*VRR1(51,36)
      VRR0(51,58)=4.D0*r1x2E*VRR0(51,22)+QCx*VRR0(51,37)+2.D0*HfxZpE*VRR1(33,37)-4.D0*r1x2E*ZxZpE*VRR1(51,22)+WQx*VRR1(51,37)
      VRR0(51,59)=V(452)+2.D0*V(453)+V(455)+QCx*VRR0(51,38)+WQx*VRR1(51,38)
      VRR0(51,60)=2.D0*V(456)+2.D0*V(457)-2.D0*V(458)+QCx*VRR0(51,39)+WQx*VRR1(51,39)
      VRR0(51,61)=V(452)+V(455)+QCy*VRR0(51,39)+WQy*VRR1(51,39)
      VRR0(51,62)=4.D0*V(456)-4.D0*V(458)+QCy*VRR0(51,40)+WQy*VRR1(51,40)
      VRR0(51,63)=5.D0*r1x2E*VRR0(51,25)+QCy*VRR0(51,41)-5.D0*r1x2E*ZxZpE*VRR1(51,25)+WQy*VRR1(51,41)
      VRR0(51,64)=4.D0*r1x2E*VRR0(51,26)+QCx*VRR0(51,42)+2.D0*HfxZpE*VRR1(33,42)-4.D0*r1x2E*ZxZpE*VRR1(51,26)+WQx*VRR1(51,42)
      VRR0(51,65)=3.D0*V(459)+V(461)-3.D0*V(462)+QCx*VRR0(51,43)+WQx*VRR1(51,43)
      VRR0(51,66)=V(464)+V(466)+V(468)+QCx*VRR0(51,44)+WQx*VRR1(51,44)
      VRR0(51,67)=V(469)+V(470)+QCy*VRR0(51,44)+WQy*VRR1(51,44)
      VRR0(51,68)=3.D0*V(463)-3.D0*V(467)+QCy*VRR0(51,45)+WQy*VRR1(51,45)
      VRR0(51,69)=4.D0*r1x2E*VRR0(51,29)+QCy*VRR0(51,46)-4.D0*r1x2E*ZxZpE*VRR1(51,29)+WQy*VRR1(51,46)
      VRR0(51,70)=V(472)+2.D0*V(473)+V(475)+QCx*VRR0(51,47)+WQx*VRR1(51,47)
      VRR0(51,71)=V(477)+2.D0*V(478)+V(480)+QCx*VRR0(51,48)+WQx*VRR1(51,48)
      VRR0(51,72)=2.D0*V(152)-2.D0*V(153)+2.D0*V(313)+PAz*VRR0(30,72)+WPz*VRR1(30,72)
      VRR0(51,73)=V(477)+V(480)+QCy*VRR0(51,49)+WQy*VRR1(51,49)
      VRR0(51,74)=V(482)+V(484)+QCy*VRR0(51,50)+WQy*VRR1(51,50)
      VRR0(51,75)=2.D0*V(485)+2.D0*V(486)-2.D0*V(487)+QCx*VRR0(51,51)+WQx*VRR1(51,51)
      VRR0(51,76)=V(325)+V(469)+V(470)+QCz*VRR0(51,48)+WQz*VRR1(51,48)
      VRR0(51,77)=3.D0*V(330)+V(464)+V(468)+QCz*VRR0(51,49)+WQz*VRR1(51,49)
      VRR0(51,78)=2.D0*V(488)-2.D0*V(489)+QCy*VRR0(51,53)+WQy*VRR1(51,53)
      VRR0(51,79)=V(337)+V(472)+V(475)+QCz*VRR0(51,51)+WQz*VRR1(51,51)
      VRR0(51,80)=3.D0*V(476)-3.D0*V(479)+QCz*VRR0(51,52)+3.D0*HfxZpE*VRR1(30,52)+WQz*VRR1(51,52)
      VRR0(51,81)=3.D0*V(378)+V(482)+V(484)+QCz*VRR0(51,53)+WQz*VRR1(51,53)
      VRR0(51,82)=4.D0*V(485)-4.D0*V(487)+QCz*VRR0(51,54)+3.D0*HfxZpE*VRR1(30,54)+WQz*VRR1(51,54)
      VRR0(51,83)=4.D0*V(488)-4.D0*V(489)+QCz*VRR0(51,55)+3.D0*HfxZpE*VRR1(30,55)+WQz*VRR1(51,55)
      VRR0(51,84)=5.D0*r1x2E*VRR0(51,35)+QCz*VRR0(51,56)+3.D0*HfxZpE*VRR1(30,56)-5.D0*r1x2E*ZxZpE*VRR1(51,35)+WQz*VRR1(51,56)
      VRR0(52,57)=5.D0*r1x2E*VRR0(52,21)+QCx*VRR0(52,36)+HfxZpE*VRR1(34,36)-5.D0*r1x2E*ZxZpE*VRR1(52,21)+WQx*VRR1(52,36)
      VRR0(52,58)=4.D0*r1x2E*VRR0(52,22)+QCx*VRR0(52,37)+HfxZpE*VRR1(34,37)-4.D0*r1x2E*ZxZpE*VRR1(52,22)+WQx*VRR1(52,37)
      VRR0(52,59)=V(491)+V(492)+V(494)+QCx*VRR0(52,38)+WQx*VRR1(52,38)
      VRR0(52,60)=2.D0*V(495)+V(496)-2.D0*V(497)+QCx*VRR0(52,39)+WQx*VRR1(52,39)
      VRR0(52,61)=V(457)+V(491)+V(494)+QCy*VRR0(52,39)+WQy*VRR1(52,39)
      VRR0(52,62)=4.D0*V(495)-4.D0*V(497)+QCy*VRR0(52,40)+HfxZpE*VRR1(33,40)+WQy*VRR1(52,40)
      VRR0(52,63)=5.D0*r1x2E*VRR0(52,25)+QCy*VRR0(52,41)+HfxZpE*VRR1(33,41)-5.D0*r1x2E*ZxZpE*VRR1(52,25)+WQy*VRR1(52,41)
      VRR0(52,64)=4.D0*r1x2E*VRR0(52,26)+QCx*VRR0(52,42)+HfxZpE*VRR1(34,42)-4.D0*r1x2E*ZxZpE*VRR1(52,26)+WQx*VRR1(52,42)
      VRR0(52,65)=3.D0*V(498)+V(499)-3.D0*V(500)+QCx*VRR0(52,43)+WQx*VRR1(52,43)
      VRR0(52,66)=V(502)+V(503)+V(505)+QCx*VRR0(52,44)+WQx*VRR1(52,44)
      VRR0(52,67)=V(465)+V(506)+V(507)+QCy*VRR0(52,44)+WQy*VRR1(52,44)
      VRR0(52,68)=3.D0*V(501)-3.D0*V(504)+V(508)+QCy*VRR0(52,45)+WQy*VRR1(52,45)
      VRR0(52,69)=4.D0*r1x2E*VRR0(52,29)+QCy*VRR0(52,46)+HfxZpE*VRR1(33,46)-4.D0*r1x2E*ZxZpE*VRR1(52,29)+WQy*VRR1(52,46)
      VRR0(52,70)=V(510)+V(511)+V(513)+QCx*VRR0(52,47)+WQx*VRR1(52,47)
      VRR0(52,71)=V(515)+V(516)+V(518)+QCx*VRR0(52,48)+WQx*VRR1(52,48)
      VRR0(52,72)=V(191)+V(193)+V(354)+PAz*VRR0(31,72)+WPz*VRR1(31,72)
      VRR0(52,73)=V(515)+V(518)+V(519)+QCy*VRR0(52,49)+WQy*VRR1(52,49)
      VRR0(52,74)=V(521)+V(522)+V(524)+QCy*VRR0(52,50)+WQy*VRR1(52,50)
      VRR0(52,75)=2.D0*V(525)+V(526)-2.D0*V(527)+QCx*VRR0(52,51)+WQx*VRR1(52,51)
      VRR0(52,76)=3.D0*V(365)+V(506)+V(507)+QCz*VRR0(52,48)+WQz*VRR1(52,48)
      VRR0(52,77)=3.D0*V(369)+V(502)+V(505)+QCz*VRR0(52,49)+WQz*VRR1(52,49)
      VRR0(52,78)=2.D0*V(528)+V(529)-2.D0*V(530)+QCy*VRR0(52,53)+WQy*VRR1(52,53)
      VRR0(52,79)=3.D0*V(375)+V(510)+V(513)+QCz*VRR0(52,51)+WQz*VRR1(52,51)
      VRR0(52,80)=3.D0*V(514)-3.D0*V(517)+QCz*VRR0(52,52)+3.D0*HfxZpE*VRR1(31,52)+WQz*VRR1(52,52)
      VRR0(52,81)=3.D0*V(414)+V(521)+V(524)+QCz*VRR0(52,53)+WQz*VRR1(52,53)
      VRR0(52,82)=4.D0*V(525)-4.D0*V(527)+QCz*VRR0(52,54)+3.D0*HfxZpE*VRR1(31,54)+WQz*VRR1(52,54)
      VRR0(52,83)=4.D0*V(528)-4.D0*V(530)+QCz*VRR0(52,55)+3.D0*HfxZpE*VRR1(31,55)+WQz*VRR1(52,55)
      VRR0(52,84)=5.D0*r1x2E*VRR0(52,35)+QCz*VRR0(52,56)+3.D0*HfxZpE*VRR1(31,56)-5.D0*r1x2E*ZxZpE*VRR1(52,35)+WQz*VRR1(52,56)
      VRR0(53,57)=5.D0*r1x2E*VRR0(53,21)+QCx*VRR0(53,36)-5.D0*r1x2E*ZxZpE*VRR1(53,21)+WQx*VRR1(53,36)
      VRR0(53,58)=4.D0*r1x2E*VRR0(53,22)+QCx*VRR0(53,37)-4.D0*r1x2E*ZxZpE*VRR1(53,22)+WQx*VRR1(53,37)
      VRR0(53,59)=V(532)+V(534)+QCx*VRR0(53,38)+WQx*VRR1(53,38)
      VRR0(53,60)=2.D0*V(535)-2.D0*V(536)+QCx*VRR0(53,39)+WQx*VRR1(53,39)
      VRR0(53,61)=2.D0*V(496)+V(532)+V(534)+QCy*VRR0(53,39)+WQy*VRR1(53,39)
      VRR0(53,62)=4.D0*V(535)-4.D0*V(536)+QCy*VRR0(53,40)+2.D0*HfxZpE*VRR1(34,40)+WQy*VRR1(53,40)
      VRR0(53,63)=5.D0*r1x2E*VRR0(53,25)+QCy*VRR0(53,41)+2.D0*HfxZpE*VRR1(34,41)-5.D0*r1x2E*ZxZpE*VRR1(53,25)+WQy*VRR1(53,41)
      VRR0(53,64)=4.D0*r1x2E*VRR0(53,26)+QCx*VRR0(53,42)-4.D0*r1x2E*ZxZpE*VRR1(53,26)+WQx*VRR1(53,42)
      VRR0(53,65)=3.D0*V(537)-3.D0*V(538)+QCx*VRR0(53,43)+WQx*VRR1(53,43)
      VRR0(53,66)=V(540)+V(542)+QCx*VRR0(53,44)+WQx*VRR1(53,44)
      VRR0(53,67)=V(543)+V(544)+V(545)+QCy*VRR0(53,44)+WQy*VRR1(53,44)
      VRR0(53,68)=3.D0*V(539)-3.D0*V(541)+V(547)+QCy*VRR0(53,45)+WQy*VRR1(53,45)
      VRR0(53,69)=4.D0*r1x2E*VRR0(53,29)+QCy*VRR0(53,46)+2.D0*HfxZpE*VRR1(34,46)-4.D0*r1x2E*ZxZpE*VRR1(53,29)+WQy*VRR1(53,46)
      VRR0(53,70)=V(549)+V(551)+QCx*VRR0(53,47)+WQx*VRR1(53,47)
      VRR0(53,71)=V(553)+V(555)+QCx*VRR0(53,48)+WQx*VRR1(53,48)
      VRR0(53,72)=2.D0*V(291)-2.D0*V(292)+2.D0*V(391)+PAz*VRR0(32,72)+WPz*VRR1(32,72)
      VRR0(53,73)=V(553)+V(555)+2.D0*V(556)+QCy*VRR0(53,49)+WQy*VRR1(53,49)
      VRR0(53,74)=V(558)+2.D0*V(559)+V(561)+QCy*VRR0(53,50)+WQy*VRR1(53,50)
      VRR0(53,75)=2.D0*V(562)-2.D0*V(563)+QCx*VRR0(53,51)+WQx*VRR1(53,51)
      VRR0(53,76)=3.D0*V(402)+V(543)+V(545)+QCz*VRR0(53,48)+WQz*VRR1(53,48)
      VRR0(53,77)=V(440)+V(540)+V(542)+QCz*VRR0(53,49)+WQz*VRR1(53,49)
      VRR0(53,78)=2.D0*V(564)+2.D0*V(565)-2.D0*V(566)+QCy*VRR0(53,53)+WQy*VRR1(53,53)
      VRR0(53,79)=3.D0*V(411)+V(549)+V(551)+QCz*VRR0(53,51)+WQz*VRR1(53,51)
      VRR0(53,80)=3.D0*V(552)-3.D0*V(554)+QCz*VRR0(53,52)+3.D0*HfxZpE*VRR1(32,52)+WQz*VRR1(53,52)
      VRR0(53,81)=V(449)+V(558)+V(561)+QCz*VRR0(53,53)+WQz*VRR1(53,53)
      VRR0(53,82)=4.D0*V(562)-4.D0*V(563)+QCz*VRR0(53,54)+3.D0*HfxZpE*VRR1(32,54)+WQz*VRR1(53,54)
      VRR0(53,83)=4.D0*V(564)-4.D0*V(566)+QCz*VRR0(53,55)+3.D0*HfxZpE*VRR1(32,55)+WQz*VRR1(53,55)
      VRR0(53,84)=5.D0*r1x2E*VRR0(53,35)+QCz*VRR0(53,56)+3.D0*HfxZpE*VRR1(32,56)-5.D0*r1x2E*ZxZpE*VRR1(53,35)+WQz*VRR1(53,56)
      VRR0(54,57)=5.D0*r1x2E*VRR0(54,21)+QCx*VRR0(54,36)+HfxZpE*VRR1(35,36)-5.D0*r1x2E*ZxZpE*VRR1(54,21)+WQx*VRR1(54,36)
      VRR0(54,58)=V(567)+4.D0*r1x2E*VRR0(54,22)+QCx*VRR0(54,37)-4.D0*r1x2E*ZxZpE*VRR1(54,22)+WQx*VRR1(54,37)
      VRR0(54,59)=V(569)+V(570)+V(572)+QCx*VRR0(54,38)+WQx*VRR1(54,38)
      VRR0(54,60)=3.D0*r1x2Z*VRR0(18,60)+PAz*VRR0(33,60)-3.D0*ExZpE*r1x2Z*VRR1(18,60)+WPz*VRR1(33,60)
      VRR0(54,61)=V(569)+V(572)+QCy*VRR0(54,39)+WQy*VRR1(54,39)
      VRR0(54,62)=4.D0*r1x2E*VRR0(54,24)+QCy*VRR0(54,40)-4.D0*r1x2E*ZxZpE*VRR1(54,24)+WQy*VRR1(54,40)
      VRR0(54,63)=5.D0*r1x2E*VRR0(54,25)+QCy*VRR0(54,41)-5.D0*r1x2E*ZxZpE*VRR1(54,25)+WQy*VRR1(54,41)
      VRR0(54,64)=V(573)+4.D0*r1x2E*VRR0(54,26)+QCx*VRR0(54,42)-4.D0*r1x2E*ZxZpE*VRR1(54,26)+WQx*VRR1(54,42)
      VRR0(54,65)=V(574)+3.D0*r1x2E*VRR0(54,27)+QCx*VRR0(54,43)-3.D0*r1x2E*ZxZpE*VRR1(54,27)+WQx*VRR1(54,43)
      VRR0(54,66)=V(453)+3.D0*r1x2Z*VRR0(18,66)+PAz*VRR0(33,66)-3.D0*ExZpE*r1x2Z*VRR1(18,66)+WPz*VRR1(33,66)
      VRR0(54,67)=V(457)+3.D0*r1x2Z*VRR0(18,67)+PAz*VRR0(33,67)-3.D0*ExZpE*r1x2Z*VRR1(18,67)+WPz*VRR1(33,67)
      VRR0(54,68)=3.D0*r1x2E*VRR0(54,28)+QCy*VRR0(54,45)-3.D0*r1x2E*ZxZpE*VRR1(54,28)+WQy*VRR1(54,45)
      VRR0(54,69)=4.D0*r1x2E*VRR0(54,29)+QCy*VRR0(54,46)-4.D0*r1x2E*ZxZpE*VRR1(54,29)+WQy*VRR1(54,46)
      VRR0(54,70)=V(576)+V(577)+V(579)+QCx*VRR0(54,47)+WQx*VRR1(54,47)
      VRR0(54,71)=V(461)+3.D0*r1x2Z*VRR0(18,71)+PAz*VRR0(33,71)-3.D0*ExZpE*r1x2Z*VRR1(18,71)+WPz*VRR1(33,71)
      VRR0(54,72)=3.D0*V(328)-3.D0*V(329)+V(466)+PAz*VRR0(33,72)+WPz*VRR1(33,72)
      VRR0(54,73)=2.D0*V(508)+3.D0*r1x2Z*VRR0(18,73)+PAz*VRR0(33,73)-3.D0*ExZpE*r1x2Z*VRR1(18,73)+WPz*VRR1(33,73)
      VRR0(54,74)=V(581)+V(583)+QCy*VRR0(54,50)+WQy*VRR1(54,50)
      VRR0(54,75)=3.D0*V(473)+3.D0*r1x2Z*VRR0(18,75)+PAz*VRR0(33,75)-3.D0*ExZpE*r1x2Z*VRR1(18,75)+WPz*VRR1(33,75)
      VRR0(54,76)=3.D0*V(478)+3.D0*r1x2Z*VRR0(18,76)+PAz*VRR0(33,76)-3.D0*ExZpE*r1x2Z*VRR1(18,76)+WPz*VRR1(33,76)
      VRR0(54,77)=3.D0*V(519)+3.D0*r1x2Z*VRR0(18,77)+PAz*VRR0(33,77)-3.D0*ExZpE*r1x2Z*VRR1(18,77)+WPz*VRR1(33,77)
      VRR0(54,78)=3.D0*V(522)+3.D0*r1x2Z*VRR0(18,78)+PAz*VRR0(33,78)-3.D0*ExZpE*r1x2Z*VRR1(18,78)+WPz*VRR1(33,78)
      VRR0(54,79)=4.D0*V(486)+V(576)+V(579)+QCz*VRR0(54,51)+WQz*VRR1(54,51)
      VRR0(54,80)=3.D0*r1x2E*VRR0(54,31)+QCz*VRR0(54,52)+4.D0*HfxZpE*VRR1(33,52)-3.D0*r1x2E*ZxZpE*VRR1(54,31)+WQz*VRR1(54,52)
      VRR0(54,81)=4.D0*V(529)+V(581)+V(583)+QCz*VRR0(54,53)+WQz*VRR1(54,53)
      VRR0(54,82)=4.D0*r1x2E*VRR0(54,33)+QCz*VRR0(54,54)+4.D0*HfxZpE*VRR1(33,54)-4.D0*r1x2E*ZxZpE*VRR1(54,33)+WQz*VRR1(54,54)
      VRR0(54,83)=4.D0*r1x2E*VRR0(54,34)+QCz*VRR0(54,55)+4.D0*HfxZpE*VRR1(33,55)-4.D0*r1x2E*ZxZpE*VRR1(54,34)+WQz*VRR1(54,55)
      VRR0(54,84)=5.D0*r1x2E*VRR0(54,35)+QCz*VRR0(54,56)+4.D0*HfxZpE*VRR1(33,56)-5.D0*r1x2E*ZxZpE*VRR1(54,35)+WQz*VRR1(54,56)
      VRR0(55,57)=5.D0*r1x2E*VRR0(55,21)+QCx*VRR0(55,36)-5.D0*r1x2E*ZxZpE*VRR1(55,21)+WQx*VRR1(55,36)
      VRR0(55,58)=4.D0*r1x2E*VRR0(55,22)+QCx*VRR0(55,37)-4.D0*r1x2E*ZxZpE*VRR1(55,22)+WQx*VRR1(55,37)
      VRR0(55,59)=V(585)+V(587)+QCx*VRR0(55,38)+WQx*VRR1(55,38)
      VRR0(55,60)=3.D0*r1x2Z*VRR0(19,60)+PAz*VRR0(34,60)-3.D0*ExZpE*r1x2Z*VRR1(19,60)+WPz*VRR1(34,60)
      VRR0(55,61)=V(585)+V(587)+V(588)+QCy*VRR0(55,39)+WQy*VRR1(55,39)
      VRR0(55,62)=V(589)+4.D0*r1x2E*VRR0(55,24)+QCy*VRR0(55,40)-4.D0*r1x2E*ZxZpE*VRR1(55,24)+WQy*VRR1(55,40)
      VRR0(55,63)=5.D0*r1x2E*VRR0(55,25)+QCy*VRR0(55,41)+HfxZpE*VRR1(35,41)-5.D0*r1x2E*ZxZpE*VRR1(55,25)+WQy*VRR1(55,41)
      VRR0(55,64)=4.D0*r1x2E*VRR0(55,26)+QCx*VRR0(55,42)-4.D0*r1x2E*ZxZpE*VRR1(55,26)+WQx*VRR1(55,42)
      VRR0(55,65)=3.D0*r1x2E*VRR0(55,27)+QCx*VRR0(55,43)-3.D0*r1x2E*ZxZpE*VRR1(55,27)+WQx*VRR1(55,43)
      VRR0(55,66)=V(492)+3.D0*r1x2Z*VRR0(19,66)+PAz*VRR0(34,66)-3.D0*ExZpE*r1x2Z*VRR1(19,66)+WPz*VRR1(34,66)
      VRR0(55,67)=V(496)+3.D0*r1x2Z*VRR0(19,67)+PAz*VRR0(34,67)-3.D0*ExZpE*r1x2Z*VRR1(19,67)+WPz*VRR1(34,67)
      VRR0(55,68)=V(590)+3.D0*r1x2E*VRR0(55,28)+QCy*VRR0(55,45)-3.D0*r1x2E*ZxZpE*VRR1(55,28)+WQy*VRR1(55,45)
      VRR0(55,69)=V(591)+4.D0*r1x2E*VRR0(55,29)+QCy*VRR0(55,46)-4.D0*r1x2E*ZxZpE*VRR1(55,29)+WQy*VRR1(55,46)
      VRR0(55,70)=V(593)+V(595)+QCx*VRR0(55,47)+WQx*VRR1(55,47)
      VRR0(55,71)=2.D0*V(499)+3.D0*r1x2Z*VRR0(19,71)+PAz*VRR0(34,71)-3.D0*ExZpE*r1x2Z*VRR1(19,71)+WPz*VRR1(34,71)
      VRR0(55,72)=3.D0*V(438)-3.D0*V(439)+V(544)+PAz*VRR0(34,72)+WPz*VRR1(34,72)
      VRR0(55,73)=V(547)+3.D0*r1x2Z*VRR0(19,73)+PAz*VRR0(34,73)-3.D0*ExZpE*r1x2Z*VRR1(19,73)+WPz*VRR1(34,73)
      VRR0(55,74)=V(597)+V(598)+V(600)+QCy*VRR0(55,50)+WQy*VRR1(55,50)
      VRR0(55,75)=3.D0*V(511)+3.D0*r1x2Z*VRR0(19,75)+PAz*VRR0(34,75)-3.D0*ExZpE*r1x2Z*VRR1(19,75)+WPz*VRR1(34,75)
      VRR0(55,76)=3.D0*V(516)+3.D0*r1x2Z*VRR0(19,76)+PAz*VRR0(34,76)-3.D0*ExZpE*r1x2Z*VRR1(19,76)+WPz*VRR1(34,76)
      VRR0(55,77)=3.D0*V(556)+3.D0*r1x2Z*VRR0(19,77)+PAz*VRR0(34,77)-3.D0*ExZpE*r1x2Z*VRR1(19,77)+WPz*VRR1(34,77)
      VRR0(55,78)=3.D0*V(559)+3.D0*r1x2Z*VRR0(19,78)+PAz*VRR0(34,78)-3.D0*ExZpE*r1x2Z*VRR1(19,78)+WPz*VRR1(34,78)
      VRR0(55,79)=4.D0*V(526)+V(593)+V(595)+QCz*VRR0(55,51)+WQz*VRR1(55,51)
      VRR0(55,80)=3.D0*r1x2E*VRR0(55,31)+QCz*VRR0(55,52)+4.D0*HfxZpE*VRR1(34,52)-3.D0*r1x2E*ZxZpE*VRR1(55,31)+WQz*VRR1(55,52)
      VRR0(55,81)=4.D0*V(565)+V(597)+V(600)+QCz*VRR0(55,53)+WQz*VRR1(55,53)
      VRR0(55,82)=4.D0*r1x2E*VRR0(55,33)+QCz*VRR0(55,54)+4.D0*HfxZpE*VRR1(34,54)-4.D0*r1x2E*ZxZpE*VRR1(55,33)+WQz*VRR1(55,54)
      VRR0(55,83)=4.D0*r1x2E*VRR0(55,34)+QCz*VRR0(55,55)+4.D0*HfxZpE*VRR1(34,55)-4.D0*r1x2E*ZxZpE*VRR1(55,34)+WQz*VRR1(55,55)
      VRR0(55,84)=5.D0*r1x2E*VRR0(55,35)+QCz*VRR0(55,56)+4.D0*HfxZpE*VRR1(34,56)-5.D0*r1x2E*ZxZpE*VRR1(55,35)+WQz*VRR1(55,56)
      VRR0(56,57)=5.D0*r1x2E*VRR0(56,21)+QCx*VRR0(56,36)-5.D0*r1x2E*ZxZpE*VRR1(56,21)+WQx*VRR1(56,36)
      VRR0(56,58)=4.D0*r1x2E*VRR0(56,22)+QCx*VRR0(56,37)-4.D0*r1x2E*ZxZpE*VRR1(56,22)+WQx*VRR1(56,37)
      VRR0(56,59)=4.D0*r1x2Z*VRR0(20,59)+PAz*VRR0(35,59)-4.D0*ExZpE*r1x2Z*VRR1(20,59)+WPz*VRR1(35,59)
      VRR0(56,60)=4.D0*r1x2Z*VRR0(20,60)+PAz*VRR0(35,60)-4.D0*ExZpE*r1x2Z*VRR1(20,60)+WPz*VRR1(35,60)
      VRR0(56,61)=4.D0*r1x2Z*VRR0(20,61)+PAz*VRR0(35,61)-4.D0*ExZpE*r1x2Z*VRR1(20,61)+WPz*VRR1(35,61)
      VRR0(56,62)=4.D0*r1x2E*VRR0(56,24)+QCy*VRR0(56,40)-4.D0*r1x2E*ZxZpE*VRR1(56,24)+WQy*VRR1(56,40)
      VRR0(56,63)=5.D0*r1x2E*VRR0(56,25)+QCy*VRR0(56,41)-5.D0*r1x2E*ZxZpE*VRR1(56,25)+WQy*VRR1(56,41)
      VRR0(56,64)=4.D0*r1x2E*VRR0(56,26)+QCx*VRR0(56,42)-4.D0*r1x2E*ZxZpE*VRR1(56,26)+WQx*VRR1(56,42)
      VRR0(56,65)=V(567)+4.D0*r1x2Z*VRR0(20,65)+PAz*VRR0(35,65)-4.D0*ExZpE*r1x2Z*VRR1(20,65)+WPz*VRR1(35,65)
      VRR0(56,66)=V(570)+4.D0*r1x2Z*VRR0(20,66)+PAz*VRR0(35,66)-4.D0*ExZpE*r1x2Z*VRR1(20,66)+WPz*VRR1(35,66)
      VRR0(56,67)=V(588)+4.D0*r1x2Z*VRR0(20,67)+PAz*VRR0(35,67)-4.D0*ExZpE*r1x2Z*VRR1(20,67)+WPz*VRR1(35,67)
      VRR0(56,68)=V(589)+4.D0*r1x2Z*VRR0(20,68)+PAz*VRR0(35,68)-4.D0*ExZpE*r1x2Z*VRR1(20,68)+WPz*VRR1(35,68)
      VRR0(56,69)=4.D0*r1x2E*VRR0(56,29)+QCy*VRR0(56,46)-4.D0*r1x2E*ZxZpE*VRR1(56,29)+WQy*VRR1(56,46)
      VRR0(56,70)=2.D0*V(573)+4.D0*r1x2Z*VRR0(20,70)+PAz*VRR0(35,70)-4.D0*ExZpE*r1x2Z*VRR1(20,70)+WPz*VRR1(35,70)
      VRR0(56,71)=2.D0*V(574)+4.D0*r1x2Z*VRR0(20,71)+PAz*VRR0(35,71)-4.D0*ExZpE*r1x2Z*VRR1(20,71)+WPz*VRR1(35,71)
      VRR0(56,72)=4.D0*r1x2Z*VRR0(20,72)+PAz*VRR0(35,72)-4.D0*ExZpE*r1x2Z*VRR1(20,72)+2.D0*HfxZpE*VRR1(35,44)+WPz*VRR1(35,72)
      VRR0(56,73)=2.D0*V(590)+4.D0*r1x2Z*VRR0(20,73)+PAz*VRR0(35,73)-4.D0*ExZpE*r1x2Z*VRR1(20,73)+WPz*VRR1(35,73)
      VRR0(56,74)=2.D0*V(591)+4.D0*r1x2Z*VRR0(20,74)+PAz*VRR0(35,74)-4.D0*ExZpE*r1x2Z*VRR1(20,74)+WPz*VRR1(35,74)
      VRR0(56,75)=3.D0*V(577)+4.D0*r1x2Z*VRR0(20,75)+PAz*VRR0(35,75)-4.D0*ExZpE*r1x2Z*VRR1(20,75)+WPz*VRR1(35,75)
      VRR0(56,76)=4.D0*r1x2Z*VRR0(20,76)+PAz*VRR0(35,76)-4.D0*ExZpE*r1x2Z*VRR1(20,76)+3.D0*HfxZpE*VRR1(35,48)+WPz*VRR1(35,76)
      VRR0(56,77)=4.D0*r1x2Z*VRR0(20,77)+PAz*VRR0(35,77)-4.D0*ExZpE*r1x2Z*VRR1(20,77)+3.D0*HfxZpE*VRR1(35,49)+WPz*VRR1(35,77)
      VRR0(56,78)=3.D0*V(598)+4.D0*r1x2Z*VRR0(20,78)+PAz*VRR0(35,78)-4.D0*ExZpE*r1x2Z*VRR1(20,78)+WPz*VRR1(35,78)
      VRR0(56,79)=4.D0*r1x2Z*VRR0(20,79)+PAz*VRR0(35,79)-4.D0*ExZpE*r1x2Z*VRR1(20,79)+4.D0*HfxZpE*VRR1(35,51)+WPz*VRR1(35,79)
      VRR0(56,80)=4.D0*r1x2Z*VRR0(20,80)+PAz*VRR0(35,80)-4.D0*ExZpE*r1x2Z*VRR1(20,80)+4.D0*HfxZpE*VRR1(35,52)+WPz*VRR1(35,80)
      VRR0(56,81)=4.D0*r1x2Z*VRR0(20,81)+PAz*VRR0(35,81)-4.D0*ExZpE*r1x2Z*VRR1(20,81)+4.D0*HfxZpE*VRR1(35,53)+WPz*VRR1(35,81)
      VRR0(56,82)=4.D0*r1x2E*VRR0(56,33)+QCz*VRR0(56,54)+5.D0*HfxZpE*VRR1(35,54)-4.D0*r1x2E*ZxZpE*VRR1(56,33)+WQz*VRR1(56,54)
      VRR0(56,83)=4.D0*r1x2E*VRR0(56,34)+QCz*VRR0(56,55)+5.D0*HfxZpE*VRR1(35,55)-4.D0*r1x2E*ZxZpE*VRR1(56,34)+WQz*VRR1(56,55)
      VRR0(56,84)=5.D0*r1x2E*VRR0(56,35)+QCz*VRR0(56,56)+5.D0*HfxZpE*VRR1(35,56)-5.D0*r1x2E*ZxZpE*VRR1(56,35)+WQz*VRR1(56,56)
END SUBROUTINE VRRh0i0
SUBROUTINE MVRRh0i0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(36,57)=QCx*VS0(36,36)+WQx*VS1(36,36)-r1x2E*VR1(36,36)&
   +5D0*r1x2E*(VS0(36,21)-ZxZpE*VS1(36,21))&
   +5D0*HfxZpE*VS1(21,36)
VS0(36,58)=QCx*VS0(36,37)+WQx*VS1(36,37)-r1x2E*VR1(36,37)&
   +4D0*r1x2E*(VS0(36,22)-ZxZpE*VS1(36,22))&
   +5D0*HfxZpE*VS1(21,37)
VS0(36,59)=QCx*VS0(36,38)+WQx*VS1(36,38)-r1x2E*VR1(36,38)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))&
   +5D0*HfxZpE*VS1(21,38)
VS0(36,60)=QCx*VS0(36,39)+WQx*VS1(36,39)-r1x2E*VR1(36,39)&
   +2D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))&
   +5D0*HfxZpE*VS1(21,39)
VS0(36,61)=QCy*VS0(36,39)+WQy*VS1(36,39)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))
VS0(36,62)=QCy*VS0(36,40)+WQy*VS1(36,40)&
   +4D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))
VS0(36,63)=QCy*VS0(36,41)+WQy*VS1(36,41)&
   +5D0*r1x2E*(VS0(36,25)-ZxZpE*VS1(36,25))
VS0(36,64)=QCx*VS0(36,42)+WQx*VS1(36,42)-r1x2E*VR1(36,42)&
   +4D0*r1x2E*(VS0(36,26)-ZxZpE*VS1(36,26))&
   +5D0*HfxZpE*VS1(21,42)
VS0(36,65)=QCx*VS0(36,43)+WQx*VS1(36,43)-r1x2E*VR1(36,43)&
   +3D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))&
   +5D0*HfxZpE*VS1(21,43)
VS0(36,66)=QCx*VS0(36,44)+WQx*VS1(36,44)-r1x2E*VR1(36,44)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))&
   +5D0*HfxZpE*VS1(21,44)
VS0(36,67)=QCy*VS0(36,44)+WQy*VS1(36,44)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,68)=QCy*VS0(36,45)+WQy*VS1(36,45)&
   +3D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,69)=QCy*VS0(36,46)+WQy*VS1(36,46)&
   +4D0*r1x2E*(VS0(36,29)-ZxZpE*VS1(36,29))
VS0(36,70)=QCx*VS0(36,47)+WQx*VS1(36,47)-r1x2E*VR1(36,47)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))&
   +5D0*HfxZpE*VS1(21,47)
VS0(36,71)=QCx*VS0(36,48)+WQx*VS1(36,48)-r1x2E*VR1(36,48)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))&
   +5D0*HfxZpE*VS1(21,48)
VS0(36,72)=QCx*VS0(36,49)+WQx*VS1(36,49)-r1x2E*VR1(36,49)&
   +r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))&
   +5D0*HfxZpE*VS1(21,49)
VS0(36,73)=QCy*VS0(36,49)+WQy*VS1(36,49)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,74)=QCy*VS0(36,50)+WQy*VS1(36,50)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,75)=QCx*VS0(36,51)+WQx*VS1(36,51)-r1x2E*VR1(36,51)&
   +2D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))&
   +5D0*HfxZpE*VS1(21,51)
VS0(36,76)=QCz*VS0(36,48)+WQz*VS1(36,48)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,77)=QCz*VS0(36,49)+WQz*VS1(36,49)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,78)=QCy*VS0(36,53)+WQy*VS1(36,53)&
   +2D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,79)=QCz*VS0(36,51)+WQz*VS1(36,51)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))
VS0(36,80)=QCz*VS0(36,52)+WQz*VS1(36,52)&
   +3D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,81)=QCz*VS0(36,53)+WQz*VS1(36,53)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,82)=QCz*VS0(36,54)+WQz*VS1(36,54)&
   +4D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))
VS0(36,83)=QCz*VS0(36,55)+WQz*VS1(36,55)&
   +4D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,84)=QCz*VS0(36,56)+WQz*VS1(36,56)&
   +5D0*r1x2E*(VS0(36,35)-ZxZpE*VS1(36,35))
VS0(37,57)=QCx*VS0(37,36)+WQx*VS1(37,36)-r1x2E*VR1(37,36)&
   +5D0*r1x2E*(VS0(37,21)-ZxZpE*VS1(37,21))&
   +4D0*HfxZpE*VS1(22,36)
VS0(37,58)=QCx*VS0(37,37)+WQx*VS1(37,37)-r1x2E*VR1(37,37)&
   +4D0*r1x2E*(VS0(37,22)-ZxZpE*VS1(37,22))&
   +4D0*HfxZpE*VS1(22,37)
VS0(37,59)=QCx*VS0(37,38)+WQx*VS1(37,38)-r1x2E*VR1(37,38)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +4D0*HfxZpE*VS1(22,38)
VS0(37,60)=QCx*VS0(37,39)+WQx*VS1(37,39)-r1x2E*VR1(37,39)&
   +2D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +4D0*HfxZpE*VS1(22,39)
VS0(37,61)=QCy*VS0(37,39)+WQy*VS1(37,39)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +HfxZpE*VS1(21,39)
VS0(37,62)=QCy*VS0(37,40)+WQy*VS1(37,40)&
   +4D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +HfxZpE*VS1(21,40)
VS0(37,63)=QCy*VS0(37,41)+WQy*VS1(37,41)&
   +5D0*r1x2E*(VS0(37,25)-ZxZpE*VS1(37,25))&
   +HfxZpE*VS1(21,41)
VS0(37,64)=QCx*VS0(37,42)+WQx*VS1(37,42)-r1x2E*VR1(37,42)&
   +4D0*r1x2E*(VS0(37,26)-ZxZpE*VS1(37,26))&
   +4D0*HfxZpE*VS1(22,42)
VS0(37,65)=QCx*VS0(37,43)+WQx*VS1(37,43)-r1x2E*VR1(37,43)&
   +3D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +4D0*HfxZpE*VS1(22,43)
VS0(37,66)=QCx*VS0(37,44)+WQx*VS1(37,44)-r1x2E*VR1(37,44)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +4D0*HfxZpE*VS1(22,44)
VS0(37,67)=QCy*VS0(37,44)+WQy*VS1(37,44)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +HfxZpE*VS1(21,44)
VS0(37,68)=QCy*VS0(37,45)+WQy*VS1(37,45)&
   +3D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +HfxZpE*VS1(21,45)
VS0(37,69)=QCy*VS0(37,46)+WQy*VS1(37,46)&
   +4D0*r1x2E*(VS0(37,29)-ZxZpE*VS1(37,29))&
   +HfxZpE*VS1(21,46)
VS0(37,70)=QCx*VS0(37,47)+WQx*VS1(37,47)-r1x2E*VR1(37,47)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))&
   +4D0*HfxZpE*VS1(22,47)
VS0(37,71)=QCx*VS0(37,48)+WQx*VS1(37,48)-r1x2E*VR1(37,48)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +4D0*HfxZpE*VS1(22,48)
VS0(37,72)=QCx*VS0(37,49)+WQx*VS1(37,49)-r1x2E*VR1(37,49)&
   +r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +4D0*HfxZpE*VS1(22,49)
VS0(37,73)=QCy*VS0(37,49)+WQy*VS1(37,49)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +HfxZpE*VS1(21,49)
VS0(37,74)=QCy*VS0(37,50)+WQy*VS1(37,50)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +HfxZpE*VS1(21,50)
VS0(37,75)=QCx*VS0(37,51)+WQx*VS1(37,51)-r1x2E*VR1(37,51)&
   +2D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))&
   +4D0*HfxZpE*VS1(22,51)
VS0(37,76)=QCz*VS0(37,48)+WQz*VS1(37,48)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))
VS0(37,77)=QCz*VS0(37,49)+WQz*VS1(37,49)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))
VS0(37,78)=QCy*VS0(37,53)+WQy*VS1(37,53)&
   +2D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))&
   +HfxZpE*VS1(21,53)
VS0(37,79)=QCz*VS0(37,51)+WQz*VS1(37,51)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))
VS0(37,80)=QCz*VS0(37,52)+WQz*VS1(37,52)&
   +3D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))
VS0(37,81)=QCz*VS0(37,53)+WQz*VS1(37,53)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))
VS0(37,82)=QCz*VS0(37,54)+WQz*VS1(37,54)&
   +4D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))
VS0(37,83)=QCz*VS0(37,55)+WQz*VS1(37,55)&
   +4D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))
VS0(37,84)=QCz*VS0(37,56)+WQz*VS1(37,56)&
   +5D0*r1x2E*(VS0(37,35)-ZxZpE*VS1(37,35))
VS0(38,57)=QCx*VS0(38,36)+WQx*VS1(38,36)-r1x2E*VR1(38,36)&
   +5D0*r1x2E*(VS0(38,21)-ZxZpE*VS1(38,21))&
   +3D0*HfxZpE*VS1(23,36)
VS0(38,58)=QCx*VS0(38,37)+WQx*VS1(38,37)-r1x2E*VR1(38,37)&
   +4D0*r1x2E*(VS0(38,22)-ZxZpE*VS1(38,22))&
   +3D0*HfxZpE*VS1(23,37)
VS0(38,59)=QCx*VS0(38,38)+WQx*VS1(38,38)-r1x2E*VR1(38,38)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +3D0*HfxZpE*VS1(23,38)
VS0(38,60)=QCx*VS0(38,39)+WQx*VS1(38,39)-r1x2E*VR1(38,39)&
   +2D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +3D0*HfxZpE*VS1(23,39)
VS0(38,61)=QCy*VS0(38,39)+WQy*VS1(38,39)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +2D0*HfxZpE*VS1(22,39)
VS0(38,62)=QCy*VS0(38,40)+WQy*VS1(38,40)&
   +4D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +2D0*HfxZpE*VS1(22,40)
VS0(38,63)=QCy*VS0(38,41)+WQy*VS1(38,41)&
   +5D0*r1x2E*(VS0(38,25)-ZxZpE*VS1(38,25))&
   +2D0*HfxZpE*VS1(22,41)
VS0(38,64)=QCx*VS0(38,42)+WQx*VS1(38,42)-r1x2E*VR1(38,42)&
   +4D0*r1x2E*(VS0(38,26)-ZxZpE*VS1(38,26))&
   +3D0*HfxZpE*VS1(23,42)
VS0(38,65)=QCx*VS0(38,43)+WQx*VS1(38,43)-r1x2E*VR1(38,43)&
   +3D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +3D0*HfxZpE*VS1(23,43)
VS0(38,66)=QCx*VS0(38,44)+WQx*VS1(38,44)-r1x2E*VR1(38,44)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +3D0*HfxZpE*VS1(23,44)
VS0(38,67)=QCy*VS0(38,44)+WQy*VS1(38,44)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +2D0*HfxZpE*VS1(22,44)
VS0(38,68)=QCy*VS0(38,45)+WQy*VS1(38,45)&
   +3D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +2D0*HfxZpE*VS1(22,45)
VS0(38,69)=QCy*VS0(38,46)+WQy*VS1(38,46)&
   +4D0*r1x2E*(VS0(38,29)-ZxZpE*VS1(38,29))&
   +2D0*HfxZpE*VS1(22,46)
VS0(38,70)=QCx*VS0(38,47)+WQx*VS1(38,47)-r1x2E*VR1(38,47)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))&
   +3D0*HfxZpE*VS1(23,47)
VS0(38,71)=QCx*VS0(38,48)+WQx*VS1(38,48)-r1x2E*VR1(38,48)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +3D0*HfxZpE*VS1(23,48)
VS0(38,72)=QCx*VS0(38,49)+WQx*VS1(38,49)-r1x2E*VR1(38,49)&
   +r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +3D0*HfxZpE*VS1(23,49)
VS0(38,73)=QCy*VS0(38,49)+WQy*VS1(38,49)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +2D0*HfxZpE*VS1(22,49)
VS0(38,74)=QCy*VS0(38,50)+WQy*VS1(38,50)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +2D0*HfxZpE*VS1(22,50)
VS0(38,75)=QCx*VS0(38,51)+WQx*VS1(38,51)-r1x2E*VR1(38,51)&
   +2D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))&
   +3D0*HfxZpE*VS1(23,51)
VS0(38,76)=QCz*VS0(38,48)+WQz*VS1(38,48)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))
VS0(38,77)=QCz*VS0(38,49)+WQz*VS1(38,49)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))
VS0(38,78)=QCy*VS0(38,53)+WQy*VS1(38,53)&
   +2D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))&
   +2D0*HfxZpE*VS1(22,53)
VS0(38,79)=QCz*VS0(38,51)+WQz*VS1(38,51)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))
VS0(38,80)=QCz*VS0(38,52)+WQz*VS1(38,52)&
   +3D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))
VS0(38,81)=QCz*VS0(38,53)+WQz*VS1(38,53)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))
VS0(38,82)=QCz*VS0(38,54)+WQz*VS1(38,54)&
   +4D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))
VS0(38,83)=QCz*VS0(38,55)+WQz*VS1(38,55)&
   +4D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))
VS0(38,84)=QCz*VS0(38,56)+WQz*VS1(38,56)&
   +5D0*r1x2E*(VS0(38,35)-ZxZpE*VS1(38,35))
VS0(39,57)=QCx*VS0(39,36)+WQx*VS1(39,36)-r1x2E*VR1(39,36)&
   +5D0*r1x2E*(VS0(39,21)-ZxZpE*VS1(39,21))&
   +2D0*HfxZpE*VS1(24,36)
VS0(39,58)=QCx*VS0(39,37)+WQx*VS1(39,37)-r1x2E*VR1(39,37)&
   +4D0*r1x2E*(VS0(39,22)-ZxZpE*VS1(39,22))&
   +2D0*HfxZpE*VS1(24,37)
VS0(39,59)=QCx*VS0(39,38)+WQx*VS1(39,38)-r1x2E*VR1(39,38)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +2D0*HfxZpE*VS1(24,38)
VS0(39,60)=QCx*VS0(39,39)+WQx*VS1(39,39)-r1x2E*VR1(39,39)&
   +2D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +2D0*HfxZpE*VS1(24,39)
VS0(39,61)=QCy*VS0(39,39)+WQy*VS1(39,39)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +3D0*HfxZpE*VS1(23,39)
VS0(39,62)=QCy*VS0(39,40)+WQy*VS1(39,40)&
   +4D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +3D0*HfxZpE*VS1(23,40)
VS0(39,63)=QCy*VS0(39,41)+WQy*VS1(39,41)&
   +5D0*r1x2E*(VS0(39,25)-ZxZpE*VS1(39,25))&
   +3D0*HfxZpE*VS1(23,41)
VS0(39,64)=QCx*VS0(39,42)+WQx*VS1(39,42)-r1x2E*VR1(39,42)&
   +4D0*r1x2E*(VS0(39,26)-ZxZpE*VS1(39,26))&
   +2D0*HfxZpE*VS1(24,42)
VS0(39,65)=QCx*VS0(39,43)+WQx*VS1(39,43)-r1x2E*VR1(39,43)&
   +3D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +2D0*HfxZpE*VS1(24,43)
VS0(39,66)=QCx*VS0(39,44)+WQx*VS1(39,44)-r1x2E*VR1(39,44)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +2D0*HfxZpE*VS1(24,44)
VS0(39,67)=QCy*VS0(39,44)+WQy*VS1(39,44)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +3D0*HfxZpE*VS1(23,44)
VS0(39,68)=QCy*VS0(39,45)+WQy*VS1(39,45)&
   +3D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +3D0*HfxZpE*VS1(23,45)
VS0(39,69)=QCy*VS0(39,46)+WQy*VS1(39,46)&
   +4D0*r1x2E*(VS0(39,29)-ZxZpE*VS1(39,29))&
   +3D0*HfxZpE*VS1(23,46)
VS0(39,70)=QCx*VS0(39,47)+WQx*VS1(39,47)-r1x2E*VR1(39,47)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))&
   +2D0*HfxZpE*VS1(24,47)
VS0(39,71)=QCx*VS0(39,48)+WQx*VS1(39,48)-r1x2E*VR1(39,48)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +2D0*HfxZpE*VS1(24,48)
VS0(39,72)=QCx*VS0(39,49)+WQx*VS1(39,49)-r1x2E*VR1(39,49)&
   +r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +2D0*HfxZpE*VS1(24,49)
VS0(39,73)=QCy*VS0(39,49)+WQy*VS1(39,49)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +3D0*HfxZpE*VS1(23,49)
VS0(39,74)=QCy*VS0(39,50)+WQy*VS1(39,50)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +3D0*HfxZpE*VS1(23,50)
VS0(39,75)=QCx*VS0(39,51)+WQx*VS1(39,51)-r1x2E*VR1(39,51)&
   +2D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))&
   +2D0*HfxZpE*VS1(24,51)
VS0(39,76)=QCz*VS0(39,48)+WQz*VS1(39,48)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))
VS0(39,77)=QCz*VS0(39,49)+WQz*VS1(39,49)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))
VS0(39,78)=QCy*VS0(39,53)+WQy*VS1(39,53)&
   +2D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))&
   +3D0*HfxZpE*VS1(23,53)
VS0(39,79)=QCz*VS0(39,51)+WQz*VS1(39,51)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))
VS0(39,80)=QCz*VS0(39,52)+WQz*VS1(39,52)&
   +3D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))
VS0(39,81)=QCz*VS0(39,53)+WQz*VS1(39,53)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))
VS0(39,82)=QCz*VS0(39,54)+WQz*VS1(39,54)&
   +4D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))
VS0(39,83)=QCz*VS0(39,55)+WQz*VS1(39,55)&
   +4D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))
VS0(39,84)=QCz*VS0(39,56)+WQz*VS1(39,56)&
   +5D0*r1x2E*(VS0(39,35)-ZxZpE*VS1(39,35))
VS0(40,57)=QCx*VS0(40,36)+WQx*VS1(40,36)-r1x2E*VR1(40,36)&
   +5D0*r1x2E*(VS0(40,21)-ZxZpE*VS1(40,21))&
   +HfxZpE*VS1(25,36)
VS0(40,58)=QCx*VS0(40,37)+WQx*VS1(40,37)-r1x2E*VR1(40,37)&
   +4D0*r1x2E*(VS0(40,22)-ZxZpE*VS1(40,22))&
   +HfxZpE*VS1(25,37)
VS0(40,59)=QCx*VS0(40,38)+WQx*VS1(40,38)-r1x2E*VR1(40,38)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +HfxZpE*VS1(25,38)
VS0(40,60)=QCx*VS0(40,39)+WQx*VS1(40,39)-r1x2E*VR1(40,39)&
   +2D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +HfxZpE*VS1(25,39)
VS0(40,61)=QCy*VS0(40,39)+WQy*VS1(40,39)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +4D0*HfxZpE*VS1(24,39)
VS0(40,62)=QCy*VS0(40,40)+WQy*VS1(40,40)&
   +4D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +4D0*HfxZpE*VS1(24,40)
VS0(40,63)=QCy*VS0(40,41)+WQy*VS1(40,41)&
   +5D0*r1x2E*(VS0(40,25)-ZxZpE*VS1(40,25))&
   +4D0*HfxZpE*VS1(24,41)
VS0(40,64)=QCx*VS0(40,42)+WQx*VS1(40,42)-r1x2E*VR1(40,42)&
   +4D0*r1x2E*(VS0(40,26)-ZxZpE*VS1(40,26))&
   +HfxZpE*VS1(25,42)
VS0(40,65)=QCx*VS0(40,43)+WQx*VS1(40,43)-r1x2E*VR1(40,43)&
   +3D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +HfxZpE*VS1(25,43)
VS0(40,66)=QCx*VS0(40,44)+WQx*VS1(40,44)-r1x2E*VR1(40,44)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +HfxZpE*VS1(25,44)
VS0(40,67)=QCy*VS0(40,44)+WQy*VS1(40,44)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +4D0*HfxZpE*VS1(24,44)
VS0(40,68)=QCy*VS0(40,45)+WQy*VS1(40,45)&
   +3D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +4D0*HfxZpE*VS1(24,45)
VS0(40,69)=QCy*VS0(40,46)+WQy*VS1(40,46)&
   +4D0*r1x2E*(VS0(40,29)-ZxZpE*VS1(40,29))&
   +4D0*HfxZpE*VS1(24,46)
VS0(40,70)=QCx*VS0(40,47)+WQx*VS1(40,47)-r1x2E*VR1(40,47)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))&
   +HfxZpE*VS1(25,47)
VS0(40,71)=QCx*VS0(40,48)+WQx*VS1(40,48)-r1x2E*VR1(40,48)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +HfxZpE*VS1(25,48)
VS0(40,72)=QCx*VS0(40,49)+WQx*VS1(40,49)-r1x2E*VR1(40,49)&
   +r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +HfxZpE*VS1(25,49)
VS0(40,73)=QCy*VS0(40,49)+WQy*VS1(40,49)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +4D0*HfxZpE*VS1(24,49)
VS0(40,74)=QCy*VS0(40,50)+WQy*VS1(40,50)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +4D0*HfxZpE*VS1(24,50)
VS0(40,75)=QCx*VS0(40,51)+WQx*VS1(40,51)-r1x2E*VR1(40,51)&
   +2D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))&
   +HfxZpE*VS1(25,51)
VS0(40,76)=QCz*VS0(40,48)+WQz*VS1(40,48)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))
VS0(40,77)=QCz*VS0(40,49)+WQz*VS1(40,49)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))
VS0(40,78)=QCy*VS0(40,53)+WQy*VS1(40,53)&
   +2D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))&
   +4D0*HfxZpE*VS1(24,53)
VS0(40,79)=QCz*VS0(40,51)+WQz*VS1(40,51)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))
VS0(40,80)=QCz*VS0(40,52)+WQz*VS1(40,52)&
   +3D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))
VS0(40,81)=QCz*VS0(40,53)+WQz*VS1(40,53)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))
VS0(40,82)=QCz*VS0(40,54)+WQz*VS1(40,54)&
   +4D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))
VS0(40,83)=QCz*VS0(40,55)+WQz*VS1(40,55)&
   +4D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))
VS0(40,84)=QCz*VS0(40,56)+WQz*VS1(40,56)&
   +5D0*r1x2E*(VS0(40,35)-ZxZpE*VS1(40,35))
VS0(41,57)=QCx*VS0(41,36)+WQx*VS1(41,36)-r1x2E*VR1(41,36)&
   +5D0*r1x2E*(VS0(41,21)-ZxZpE*VS1(41,21))
VS0(41,58)=QCx*VS0(41,37)+WQx*VS1(41,37)-r1x2E*VR1(41,37)&
   +4D0*r1x2E*(VS0(41,22)-ZxZpE*VS1(41,22))
VS0(41,59)=QCx*VS0(41,38)+WQx*VS1(41,38)-r1x2E*VR1(41,38)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))
VS0(41,60)=QCx*VS0(41,39)+WQx*VS1(41,39)-r1x2E*VR1(41,39)&
   +2D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))
VS0(41,61)=QCy*VS0(41,39)+WQy*VS1(41,39)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))&
   +5D0*HfxZpE*VS1(25,39)
VS0(41,62)=QCy*VS0(41,40)+WQy*VS1(41,40)&
   +4D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))&
   +5D0*HfxZpE*VS1(25,40)
VS0(41,63)=QCy*VS0(41,41)+WQy*VS1(41,41)&
   +5D0*r1x2E*(VS0(41,25)-ZxZpE*VS1(41,25))&
   +5D0*HfxZpE*VS1(25,41)
VS0(41,64)=QCx*VS0(41,42)+WQx*VS1(41,42)-r1x2E*VR1(41,42)&
   +4D0*r1x2E*(VS0(41,26)-ZxZpE*VS1(41,26))
VS0(41,65)=QCx*VS0(41,43)+WQx*VS1(41,43)-r1x2E*VR1(41,43)&
   +3D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,66)=QCx*VS0(41,44)+WQx*VS1(41,44)-r1x2E*VR1(41,44)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,67)=QCy*VS0(41,44)+WQy*VS1(41,44)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))&
   +5D0*HfxZpE*VS1(25,44)
VS0(41,68)=QCy*VS0(41,45)+WQy*VS1(41,45)&
   +3D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))&
   +5D0*HfxZpE*VS1(25,45)
VS0(41,69)=QCy*VS0(41,46)+WQy*VS1(41,46)&
   +4D0*r1x2E*(VS0(41,29)-ZxZpE*VS1(41,29))&
   +5D0*HfxZpE*VS1(25,46)
VS0(41,70)=QCx*VS0(41,47)+WQx*VS1(41,47)-r1x2E*VR1(41,47)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,71)=QCx*VS0(41,48)+WQx*VS1(41,48)-r1x2E*VR1(41,48)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,72)=QCx*VS0(41,49)+WQx*VS1(41,49)-r1x2E*VR1(41,49)&
   +r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,73)=QCy*VS0(41,49)+WQy*VS1(41,49)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))&
   +5D0*HfxZpE*VS1(25,49)
VS0(41,74)=QCy*VS0(41,50)+WQy*VS1(41,50)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))&
   +5D0*HfxZpE*VS1(25,50)
VS0(41,75)=QCx*VS0(41,51)+WQx*VS1(41,51)-r1x2E*VR1(41,51)&
   +2D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,76)=QCz*VS0(41,48)+WQz*VS1(41,48)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,77)=QCz*VS0(41,49)+WQz*VS1(41,49)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,78)=QCy*VS0(41,53)+WQy*VS1(41,53)&
   +2D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))&
   +5D0*HfxZpE*VS1(25,53)
VS0(41,79)=QCz*VS0(41,51)+WQz*VS1(41,51)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,80)=QCz*VS0(41,52)+WQz*VS1(41,52)&
   +3D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,81)=QCz*VS0(41,53)+WQz*VS1(41,53)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,82)=QCz*VS0(41,54)+WQz*VS1(41,54)&
   +4D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,83)=QCz*VS0(41,55)+WQz*VS1(41,55)&
   +4D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))
VS0(41,84)=QCz*VS0(41,56)+WQz*VS1(41,56)&
   +5D0*r1x2E*(VS0(41,35)-ZxZpE*VS1(41,35))
VS0(42,57)=QCx*VS0(42,36)+WQx*VS1(42,36)-r1x2E*VR1(42,36)&
   +5D0*r1x2E*(VS0(42,21)-ZxZpE*VS1(42,21))&
   +4D0*HfxZpE*VS1(26,36)
VS0(42,58)=QCx*VS0(42,37)+WQx*VS1(42,37)-r1x2E*VR1(42,37)&
   +4D0*r1x2E*(VS0(42,22)-ZxZpE*VS1(42,22))&
   +4D0*HfxZpE*VS1(26,37)
VS0(42,59)=QCx*VS0(42,38)+WQx*VS1(42,38)-r1x2E*VR1(42,38)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))&
   +4D0*HfxZpE*VS1(26,38)
VS0(42,60)=QCx*VS0(42,39)+WQx*VS1(42,39)-r1x2E*VR1(42,39)&
   +2D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))&
   +4D0*HfxZpE*VS1(26,39)
VS0(42,61)=QCy*VS0(42,39)+WQy*VS1(42,39)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))
VS0(42,62)=QCy*VS0(42,40)+WQy*VS1(42,40)&
   +4D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))
VS0(42,63)=QCy*VS0(42,41)+WQy*VS1(42,41)&
   +5D0*r1x2E*(VS0(42,25)-ZxZpE*VS1(42,25))
VS0(42,64)=QCx*VS0(42,42)+WQx*VS1(42,42)-r1x2E*VR1(42,42)&
   +4D0*r1x2E*(VS0(42,26)-ZxZpE*VS1(42,26))&
   +4D0*HfxZpE*VS1(26,42)
VS0(42,65)=QCx*VS0(42,43)+WQx*VS1(42,43)-r1x2E*VR1(42,43)&
   +3D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +4D0*HfxZpE*VS1(26,43)
VS0(42,66)=QCx*VS0(42,44)+WQx*VS1(42,44)-r1x2E*VR1(42,44)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +4D0*HfxZpE*VS1(26,44)
VS0(42,67)=QCy*VS0(42,44)+WQy*VS1(42,44)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))
VS0(42,68)=QCy*VS0(42,45)+WQy*VS1(42,45)&
   +3D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))
VS0(42,69)=QCy*VS0(42,46)+WQy*VS1(42,46)&
   +4D0*r1x2E*(VS0(42,29)-ZxZpE*VS1(42,29))
VS0(42,70)=QCx*VS0(42,47)+WQx*VS1(42,47)-r1x2E*VR1(42,47)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +4D0*HfxZpE*VS1(26,47)
VS0(42,71)=QCx*VS0(42,48)+WQx*VS1(42,48)-r1x2E*VR1(42,48)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +4D0*HfxZpE*VS1(26,48)
VS0(42,72)=QCx*VS0(42,49)+WQx*VS1(42,49)-r1x2E*VR1(42,49)&
   +r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +4D0*HfxZpE*VS1(26,49)
VS0(42,73)=QCy*VS0(42,49)+WQy*VS1(42,49)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))
VS0(42,74)=QCy*VS0(42,50)+WQy*VS1(42,50)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))
VS0(42,75)=QCx*VS0(42,51)+WQx*VS1(42,51)-r1x2E*VR1(42,51)&
   +2D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +4D0*HfxZpE*VS1(26,51)
VS0(42,76)=QCz*VS0(42,48)+WQz*VS1(42,48)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +HfxZpE*VS1(21,48)
VS0(42,77)=QCz*VS0(42,49)+WQz*VS1(42,49)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +HfxZpE*VS1(21,49)
VS0(42,78)=QCy*VS0(42,53)+WQy*VS1(42,53)&
   +2D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))
VS0(42,79)=QCz*VS0(42,51)+WQz*VS1(42,51)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +HfxZpE*VS1(21,51)
VS0(42,80)=QCz*VS0(42,52)+WQz*VS1(42,52)&
   +3D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +HfxZpE*VS1(21,52)
VS0(42,81)=QCz*VS0(42,53)+WQz*VS1(42,53)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +HfxZpE*VS1(21,53)
VS0(42,82)=QCz*VS0(42,54)+WQz*VS1(42,54)&
   +4D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +HfxZpE*VS1(21,54)
VS0(42,83)=QCz*VS0(42,55)+WQz*VS1(42,55)&
   +4D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))&
   +HfxZpE*VS1(21,55)
VS0(42,84)=QCz*VS0(42,56)+WQz*VS1(42,56)&
   +5D0*r1x2E*(VS0(42,35)-ZxZpE*VS1(42,35))&
   +HfxZpE*VS1(21,56)
VS0(43,57)=QCx*VS0(43,36)+WQx*VS1(43,36)-r1x2E*VR1(43,36)&
   +5D0*r1x2E*(VS0(43,21)-ZxZpE*VS1(43,21))&
   +3D0*HfxZpE*VS1(27,36)
VS0(43,58)=QCx*VS0(43,37)+WQx*VS1(43,37)-r1x2E*VR1(43,37)&
   +4D0*r1x2E*(VS0(43,22)-ZxZpE*VS1(43,22))&
   +3D0*HfxZpE*VS1(27,37)
VS0(43,59)=QCx*VS0(43,38)+WQx*VS1(43,38)-r1x2E*VR1(43,38)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +3D0*HfxZpE*VS1(27,38)
VS0(43,60)=QCx*VS0(43,39)+WQx*VS1(43,39)-r1x2E*VR1(43,39)&
   +2D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +3D0*HfxZpE*VS1(27,39)
VS0(43,61)=QCy*VS0(43,39)+WQy*VS1(43,39)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +HfxZpE*VS1(26,39)
VS0(43,62)=QCy*VS0(43,40)+WQy*VS1(43,40)&
   +4D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +HfxZpE*VS1(26,40)
VS0(43,63)=QCy*VS0(43,41)+WQy*VS1(43,41)&
   +5D0*r1x2E*(VS0(43,25)-ZxZpE*VS1(43,25))&
   +HfxZpE*VS1(26,41)
VS0(43,64)=QCx*VS0(43,42)+WQx*VS1(43,42)-r1x2E*VR1(43,42)&
   +4D0*r1x2E*(VS0(43,26)-ZxZpE*VS1(43,26))&
   +3D0*HfxZpE*VS1(27,42)
VS0(43,65)=QCx*VS0(43,43)+WQx*VS1(43,43)-r1x2E*VR1(43,43)&
   +3D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +3D0*HfxZpE*VS1(27,43)
VS0(43,66)=QCx*VS0(43,44)+WQx*VS1(43,44)-r1x2E*VR1(43,44)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +3D0*HfxZpE*VS1(27,44)
VS0(43,67)=QCy*VS0(43,44)+WQy*VS1(43,44)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(26,44)
VS0(43,68)=QCy*VS0(43,45)+WQy*VS1(43,45)&
   +3D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(26,45)
VS0(43,69)=QCy*VS0(43,46)+WQy*VS1(43,46)&
   +4D0*r1x2E*(VS0(43,29)-ZxZpE*VS1(43,29))&
   +HfxZpE*VS1(26,46)
VS0(43,70)=QCx*VS0(43,47)+WQx*VS1(43,47)-r1x2E*VR1(43,47)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +3D0*HfxZpE*VS1(27,47)
VS0(43,71)=QCx*VS0(43,48)+WQx*VS1(43,48)-r1x2E*VR1(43,48)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +3D0*HfxZpE*VS1(27,48)
VS0(43,72)=QCx*VS0(43,49)+WQx*VS1(43,49)-r1x2E*VR1(43,49)&
   +r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +3D0*HfxZpE*VS1(27,49)
VS0(43,73)=QCy*VS0(43,49)+WQy*VS1(43,49)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(26,49)
VS0(43,74)=QCy*VS0(43,50)+WQy*VS1(43,50)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(26,50)
VS0(43,75)=QCx*VS0(43,51)+WQx*VS1(43,51)-r1x2E*VR1(43,51)&
   +2D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +3D0*HfxZpE*VS1(27,51)
VS0(43,76)=QCz*VS0(43,48)+WQz*VS1(43,48)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(22,48)
VS0(43,77)=QCz*VS0(43,49)+WQz*VS1(43,49)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(22,49)
VS0(43,78)=QCy*VS0(43,53)+WQy*VS1(43,53)&
   +2D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(26,53)
VS0(43,79)=QCz*VS0(43,51)+WQz*VS1(43,51)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +HfxZpE*VS1(22,51)
VS0(43,80)=QCz*VS0(43,52)+WQz*VS1(43,52)&
   +3D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(22,52)
VS0(43,81)=QCz*VS0(43,53)+WQz*VS1(43,53)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(22,53)
VS0(43,82)=QCz*VS0(43,54)+WQz*VS1(43,54)&
   +4D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +HfxZpE*VS1(22,54)
VS0(43,83)=QCz*VS0(43,55)+WQz*VS1(43,55)&
   +4D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(22,55)
VS0(43,84)=QCz*VS0(43,56)+WQz*VS1(43,56)&
   +5D0*r1x2E*(VS0(43,35)-ZxZpE*VS1(43,35))&
   +HfxZpE*VS1(22,56)
VS0(44,57)=QCx*VS0(44,36)+WQx*VS1(44,36)-r1x2E*VR1(44,36)&
   +5D0*r1x2E*(VS0(44,21)-ZxZpE*VS1(44,21))&
   +2D0*HfxZpE*VS1(28,36)
VS0(44,58)=QCx*VS0(44,37)+WQx*VS1(44,37)-r1x2E*VR1(44,37)&
   +4D0*r1x2E*(VS0(44,22)-ZxZpE*VS1(44,22))&
   +2D0*HfxZpE*VS1(28,37)
VS0(44,59)=QCx*VS0(44,38)+WQx*VS1(44,38)-r1x2E*VR1(44,38)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(28,38)
VS0(44,60)=QCx*VS0(44,39)+WQx*VS1(44,39)-r1x2E*VR1(44,39)&
   +2D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(28,39)
VS0(44,61)=QCy*VS0(44,39)+WQy*VS1(44,39)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(27,39)
VS0(44,62)=QCy*VS0(44,40)+WQy*VS1(44,40)&
   +4D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(27,40)
VS0(44,63)=QCy*VS0(44,41)+WQy*VS1(44,41)&
   +5D0*r1x2E*(VS0(44,25)-ZxZpE*VS1(44,25))&
   +2D0*HfxZpE*VS1(27,41)
VS0(44,64)=QCx*VS0(44,42)+WQx*VS1(44,42)-r1x2E*VR1(44,42)&
   +4D0*r1x2E*(VS0(44,26)-ZxZpE*VS1(44,26))&
   +2D0*HfxZpE*VS1(28,42)
VS0(44,65)=QCx*VS0(44,43)+WQx*VS1(44,43)-r1x2E*VR1(44,43)&
   +3D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(28,43)
VS0(44,66)=QCx*VS0(44,44)+WQx*VS1(44,44)-r1x2E*VR1(44,44)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(28,44)
VS0(44,67)=QCy*VS0(44,44)+WQy*VS1(44,44)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(27,44)
VS0(44,68)=QCy*VS0(44,45)+WQy*VS1(44,45)&
   +3D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(27,45)
VS0(44,69)=QCy*VS0(44,46)+WQy*VS1(44,46)&
   +4D0*r1x2E*(VS0(44,29)-ZxZpE*VS1(44,29))&
   +2D0*HfxZpE*VS1(27,46)
VS0(44,70)=QCx*VS0(44,47)+WQx*VS1(44,47)-r1x2E*VR1(44,47)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +2D0*HfxZpE*VS1(28,47)
VS0(44,71)=QCx*VS0(44,48)+WQx*VS1(44,48)-r1x2E*VR1(44,48)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(28,48)
VS0(44,72)=QCx*VS0(44,49)+WQx*VS1(44,49)-r1x2E*VR1(44,49)&
   +r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(28,49)
VS0(44,73)=QCy*VS0(44,49)+WQy*VS1(44,49)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(27,49)
VS0(44,74)=QCy*VS0(44,50)+WQy*VS1(44,50)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(27,50)
VS0(44,75)=QCx*VS0(44,51)+WQx*VS1(44,51)-r1x2E*VR1(44,51)&
   +2D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +2D0*HfxZpE*VS1(28,51)
VS0(44,76)=QCz*VS0(44,48)+WQz*VS1(44,48)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +HfxZpE*VS1(23,48)
VS0(44,77)=QCz*VS0(44,49)+WQz*VS1(44,49)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +HfxZpE*VS1(23,49)
VS0(44,78)=QCy*VS0(44,53)+WQy*VS1(44,53)&
   +2D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +2D0*HfxZpE*VS1(27,53)
VS0(44,79)=QCz*VS0(44,51)+WQz*VS1(44,51)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +HfxZpE*VS1(23,51)
VS0(44,80)=QCz*VS0(44,52)+WQz*VS1(44,52)&
   +3D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +HfxZpE*VS1(23,52)
VS0(44,81)=QCz*VS0(44,53)+WQz*VS1(44,53)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +HfxZpE*VS1(23,53)
VS0(44,82)=QCz*VS0(44,54)+WQz*VS1(44,54)&
   +4D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +HfxZpE*VS1(23,54)
VS0(44,83)=QCz*VS0(44,55)+WQz*VS1(44,55)&
   +4D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +HfxZpE*VS1(23,55)
VS0(44,84)=QCz*VS0(44,56)+WQz*VS1(44,56)&
   +5D0*r1x2E*(VS0(44,35)-ZxZpE*VS1(44,35))&
   +HfxZpE*VS1(23,56)
VS0(45,57)=QCx*VS0(45,36)+WQx*VS1(45,36)-r1x2E*VR1(45,36)&
   +5D0*r1x2E*(VS0(45,21)-ZxZpE*VS1(45,21))&
   +HfxZpE*VS1(29,36)
VS0(45,58)=QCx*VS0(45,37)+WQx*VS1(45,37)-r1x2E*VR1(45,37)&
   +4D0*r1x2E*(VS0(45,22)-ZxZpE*VS1(45,22))&
   +HfxZpE*VS1(29,37)
VS0(45,59)=QCx*VS0(45,38)+WQx*VS1(45,38)-r1x2E*VR1(45,38)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +HfxZpE*VS1(29,38)
VS0(45,60)=QCx*VS0(45,39)+WQx*VS1(45,39)-r1x2E*VR1(45,39)&
   +2D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +HfxZpE*VS1(29,39)
VS0(45,61)=QCy*VS0(45,39)+WQy*VS1(45,39)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +3D0*HfxZpE*VS1(28,39)
VS0(45,62)=QCy*VS0(45,40)+WQy*VS1(45,40)&
   +4D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +3D0*HfxZpE*VS1(28,40)
VS0(45,63)=QCy*VS0(45,41)+WQy*VS1(45,41)&
   +5D0*r1x2E*(VS0(45,25)-ZxZpE*VS1(45,25))&
   +3D0*HfxZpE*VS1(28,41)
VS0(45,64)=QCx*VS0(45,42)+WQx*VS1(45,42)-r1x2E*VR1(45,42)&
   +4D0*r1x2E*(VS0(45,26)-ZxZpE*VS1(45,26))&
   +HfxZpE*VS1(29,42)
VS0(45,65)=QCx*VS0(45,43)+WQx*VS1(45,43)-r1x2E*VR1(45,43)&
   +3D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(29,43)
VS0(45,66)=QCx*VS0(45,44)+WQx*VS1(45,44)-r1x2E*VR1(45,44)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(29,44)
VS0(45,67)=QCy*VS0(45,44)+WQy*VS1(45,44)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +3D0*HfxZpE*VS1(28,44)
VS0(45,68)=QCy*VS0(45,45)+WQy*VS1(45,45)&
   +3D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +3D0*HfxZpE*VS1(28,45)
VS0(45,69)=QCy*VS0(45,46)+WQy*VS1(45,46)&
   +4D0*r1x2E*(VS0(45,29)-ZxZpE*VS1(45,29))&
   +3D0*HfxZpE*VS1(28,46)
VS0(45,70)=QCx*VS0(45,47)+WQx*VS1(45,47)-r1x2E*VR1(45,47)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(29,47)
VS0(45,71)=QCx*VS0(45,48)+WQx*VS1(45,48)-r1x2E*VR1(45,48)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(29,48)
VS0(45,72)=QCx*VS0(45,49)+WQx*VS1(45,49)-r1x2E*VR1(45,49)&
   +r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(29,49)
VS0(45,73)=QCy*VS0(45,49)+WQy*VS1(45,49)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +3D0*HfxZpE*VS1(28,49)
VS0(45,74)=QCy*VS0(45,50)+WQy*VS1(45,50)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +3D0*HfxZpE*VS1(28,50)
VS0(45,75)=QCx*VS0(45,51)+WQx*VS1(45,51)-r1x2E*VR1(45,51)&
   +2D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(29,51)
VS0(45,76)=QCz*VS0(45,48)+WQz*VS1(45,48)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(24,48)
VS0(45,77)=QCz*VS0(45,49)+WQz*VS1(45,49)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(24,49)
VS0(45,78)=QCy*VS0(45,53)+WQy*VS1(45,53)&
   +2D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +3D0*HfxZpE*VS1(28,53)
VS0(45,79)=QCz*VS0(45,51)+WQz*VS1(45,51)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(24,51)
VS0(45,80)=QCz*VS0(45,52)+WQz*VS1(45,52)&
   +3D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(24,52)
VS0(45,81)=QCz*VS0(45,53)+WQz*VS1(45,53)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(24,53)
VS0(45,82)=QCz*VS0(45,54)+WQz*VS1(45,54)&
   +4D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(24,54)
VS0(45,83)=QCz*VS0(45,55)+WQz*VS1(45,55)&
   +4D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +HfxZpE*VS1(24,55)
VS0(45,84)=QCz*VS0(45,56)+WQz*VS1(45,56)&
   +5D0*r1x2E*(VS0(45,35)-ZxZpE*VS1(45,35))&
   +HfxZpE*VS1(24,56)
VS0(46,57)=QCx*VS0(46,36)+WQx*VS1(46,36)-r1x2E*VR1(46,36)&
   +5D0*r1x2E*(VS0(46,21)-ZxZpE*VS1(46,21))
VS0(46,58)=QCx*VS0(46,37)+WQx*VS1(46,37)-r1x2E*VR1(46,37)&
   +4D0*r1x2E*(VS0(46,22)-ZxZpE*VS1(46,22))
VS0(46,59)=QCx*VS0(46,38)+WQx*VS1(46,38)-r1x2E*VR1(46,38)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))
VS0(46,60)=QCx*VS0(46,39)+WQx*VS1(46,39)-r1x2E*VR1(46,39)&
   +2D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))
VS0(46,61)=QCy*VS0(46,39)+WQy*VS1(46,39)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))&
   +4D0*HfxZpE*VS1(29,39)
VS0(46,62)=QCy*VS0(46,40)+WQy*VS1(46,40)&
   +4D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))&
   +4D0*HfxZpE*VS1(29,40)
VS0(46,63)=QCy*VS0(46,41)+WQy*VS1(46,41)&
   +5D0*r1x2E*(VS0(46,25)-ZxZpE*VS1(46,25))&
   +4D0*HfxZpE*VS1(29,41)
VS0(46,64)=QCx*VS0(46,42)+WQx*VS1(46,42)-r1x2E*VR1(46,42)&
   +4D0*r1x2E*(VS0(46,26)-ZxZpE*VS1(46,26))
VS0(46,65)=QCx*VS0(46,43)+WQx*VS1(46,43)-r1x2E*VR1(46,43)&
   +3D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))
VS0(46,66)=QCx*VS0(46,44)+WQx*VS1(46,44)-r1x2E*VR1(46,44)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))
VS0(46,67)=QCy*VS0(46,44)+WQy*VS1(46,44)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +4D0*HfxZpE*VS1(29,44)
VS0(46,68)=QCy*VS0(46,45)+WQy*VS1(46,45)&
   +3D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +4D0*HfxZpE*VS1(29,45)
VS0(46,69)=QCy*VS0(46,46)+WQy*VS1(46,46)&
   +4D0*r1x2E*(VS0(46,29)-ZxZpE*VS1(46,29))&
   +4D0*HfxZpE*VS1(29,46)
VS0(46,70)=QCx*VS0(46,47)+WQx*VS1(46,47)-r1x2E*VR1(46,47)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))
VS0(46,71)=QCx*VS0(46,48)+WQx*VS1(46,48)-r1x2E*VR1(46,48)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))
VS0(46,72)=QCx*VS0(46,49)+WQx*VS1(46,49)-r1x2E*VR1(46,49)&
   +r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))
VS0(46,73)=QCy*VS0(46,49)+WQy*VS1(46,49)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +4D0*HfxZpE*VS1(29,49)
VS0(46,74)=QCy*VS0(46,50)+WQy*VS1(46,50)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +4D0*HfxZpE*VS1(29,50)
VS0(46,75)=QCx*VS0(46,51)+WQx*VS1(46,51)-r1x2E*VR1(46,51)&
   +2D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))
VS0(46,76)=QCz*VS0(46,48)+WQz*VS1(46,48)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +HfxZpE*VS1(25,48)
VS0(46,77)=QCz*VS0(46,49)+WQz*VS1(46,49)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +HfxZpE*VS1(25,49)
VS0(46,78)=QCy*VS0(46,53)+WQy*VS1(46,53)&
   +2D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +4D0*HfxZpE*VS1(29,53)
VS0(46,79)=QCz*VS0(46,51)+WQz*VS1(46,51)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))&
   +HfxZpE*VS1(25,51)
VS0(46,80)=QCz*VS0(46,52)+WQz*VS1(46,52)&
   +3D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +HfxZpE*VS1(25,52)
VS0(46,81)=QCz*VS0(46,53)+WQz*VS1(46,53)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +HfxZpE*VS1(25,53)
VS0(46,82)=QCz*VS0(46,54)+WQz*VS1(46,54)&
   +4D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))&
   +HfxZpE*VS1(25,54)
VS0(46,83)=QCz*VS0(46,55)+WQz*VS1(46,55)&
   +4D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +HfxZpE*VS1(25,55)
VS0(46,84)=QCz*VS0(46,56)+WQz*VS1(46,56)&
   +5D0*r1x2E*(VS0(46,35)-ZxZpE*VS1(46,35))&
   +HfxZpE*VS1(25,56)
VS0(47,57)=QCx*VS0(47,36)+WQx*VS1(47,36)-r1x2E*VR1(47,36)&
   +5D0*r1x2E*(VS0(47,21)-ZxZpE*VS1(47,21))&
   +3D0*HfxZpE*VS1(30,36)
VS0(47,58)=QCx*VS0(47,37)+WQx*VS1(47,37)-r1x2E*VR1(47,37)&
   +4D0*r1x2E*(VS0(47,22)-ZxZpE*VS1(47,22))&
   +3D0*HfxZpE*VS1(30,37)
VS0(47,59)=QCx*VS0(47,38)+WQx*VS1(47,38)-r1x2E*VR1(47,38)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))&
   +3D0*HfxZpE*VS1(30,38)
VS0(47,60)=QCx*VS0(47,39)+WQx*VS1(47,39)-r1x2E*VR1(47,39)&
   +2D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))&
   +3D0*HfxZpE*VS1(30,39)
VS0(47,61)=QCy*VS0(47,39)+WQy*VS1(47,39)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))
VS0(47,62)=QCy*VS0(47,40)+WQy*VS1(47,40)&
   +4D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))
VS0(47,63)=QCy*VS0(47,41)+WQy*VS1(47,41)&
   +5D0*r1x2E*(VS0(47,25)-ZxZpE*VS1(47,25))
VS0(47,64)=QCx*VS0(47,42)+WQx*VS1(47,42)-r1x2E*VR1(47,42)&
   +4D0*r1x2E*(VS0(47,26)-ZxZpE*VS1(47,26))&
   +3D0*HfxZpE*VS1(30,42)
VS0(47,65)=QCx*VS0(47,43)+WQx*VS1(47,43)-r1x2E*VR1(47,43)&
   +3D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +3D0*HfxZpE*VS1(30,43)
VS0(47,66)=QCx*VS0(47,44)+WQx*VS1(47,44)-r1x2E*VR1(47,44)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +3D0*HfxZpE*VS1(30,44)
VS0(47,67)=QCy*VS0(47,44)+WQy*VS1(47,44)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))
VS0(47,68)=QCy*VS0(47,45)+WQy*VS1(47,45)&
   +3D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))
VS0(47,69)=QCy*VS0(47,46)+WQy*VS1(47,46)&
   +4D0*r1x2E*(VS0(47,29)-ZxZpE*VS1(47,29))
VS0(47,70)=QCx*VS0(47,47)+WQx*VS1(47,47)-r1x2E*VR1(47,47)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +3D0*HfxZpE*VS1(30,47)
VS0(47,71)=QCx*VS0(47,48)+WQx*VS1(47,48)-r1x2E*VR1(47,48)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +3D0*HfxZpE*VS1(30,48)
VS0(47,72)=QCx*VS0(47,49)+WQx*VS1(47,49)-r1x2E*VR1(47,49)&
   +r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +3D0*HfxZpE*VS1(30,49)
VS0(47,73)=QCy*VS0(47,49)+WQy*VS1(47,49)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))
VS0(47,74)=QCy*VS0(47,50)+WQy*VS1(47,50)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))
VS0(47,75)=QCx*VS0(47,51)+WQx*VS1(47,51)-r1x2E*VR1(47,51)&
   +2D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +3D0*HfxZpE*VS1(30,51)
VS0(47,76)=QCz*VS0(47,48)+WQz*VS1(47,48)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +2D0*HfxZpE*VS1(26,48)
VS0(47,77)=QCz*VS0(47,49)+WQz*VS1(47,49)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +2D0*HfxZpE*VS1(26,49)
VS0(47,78)=QCy*VS0(47,53)+WQy*VS1(47,53)&
   +2D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))
VS0(47,79)=QCz*VS0(47,51)+WQz*VS1(47,51)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +2D0*HfxZpE*VS1(26,51)
VS0(47,80)=QCz*VS0(47,52)+WQz*VS1(47,52)&
   +3D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +2D0*HfxZpE*VS1(26,52)
VS0(47,81)=QCz*VS0(47,53)+WQz*VS1(47,53)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +2D0*HfxZpE*VS1(26,53)
VS0(47,82)=QCz*VS0(47,54)+WQz*VS1(47,54)&
   +4D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +2D0*HfxZpE*VS1(26,54)
VS0(47,83)=QCz*VS0(47,55)+WQz*VS1(47,55)&
   +4D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))&
   +2D0*HfxZpE*VS1(26,55)
VS0(47,84)=QCz*VS0(47,56)+WQz*VS1(47,56)&
   +5D0*r1x2E*(VS0(47,35)-ZxZpE*VS1(47,35))&
   +2D0*HfxZpE*VS1(26,56)
VS0(48,57)=QCx*VS0(48,36)+WQx*VS1(48,36)-r1x2E*VR1(48,36)&
   +5D0*r1x2E*(VS0(48,21)-ZxZpE*VS1(48,21))&
   +2D0*HfxZpE*VS1(31,36)
VS0(48,58)=QCx*VS0(48,37)+WQx*VS1(48,37)-r1x2E*VR1(48,37)&
   +4D0*r1x2E*(VS0(48,22)-ZxZpE*VS1(48,22))&
   +2D0*HfxZpE*VS1(31,37)
VS0(48,59)=QCx*VS0(48,38)+WQx*VS1(48,38)-r1x2E*VR1(48,38)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +2D0*HfxZpE*VS1(31,38)
VS0(48,60)=QCx*VS0(48,39)+WQx*VS1(48,39)-r1x2E*VR1(48,39)&
   +2D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +2D0*HfxZpE*VS1(31,39)
VS0(48,61)=QCy*VS0(48,39)+WQy*VS1(48,39)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +HfxZpE*VS1(30,39)
VS0(48,62)=QCy*VS0(48,40)+WQy*VS1(48,40)&
   +4D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +HfxZpE*VS1(30,40)
VS0(48,63)=QCy*VS0(48,41)+WQy*VS1(48,41)&
   +5D0*r1x2E*(VS0(48,25)-ZxZpE*VS1(48,25))&
   +HfxZpE*VS1(30,41)
VS0(48,64)=QCx*VS0(48,42)+WQx*VS1(48,42)-r1x2E*VR1(48,42)&
   +4D0*r1x2E*(VS0(48,26)-ZxZpE*VS1(48,26))&
   +2D0*HfxZpE*VS1(31,42)
VS0(48,65)=QCx*VS0(48,43)+WQx*VS1(48,43)-r1x2E*VR1(48,43)&
   +3D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(31,43)
VS0(48,66)=QCx*VS0(48,44)+WQx*VS1(48,44)-r1x2E*VR1(48,44)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(31,44)
VS0(48,67)=QCy*VS0(48,44)+WQy*VS1(48,44)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +HfxZpE*VS1(30,44)
VS0(48,68)=QCy*VS0(48,45)+WQy*VS1(48,45)&
   +3D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +HfxZpE*VS1(30,45)
VS0(48,69)=QCy*VS0(48,46)+WQy*VS1(48,46)&
   +4D0*r1x2E*(VS0(48,29)-ZxZpE*VS1(48,29))&
   +HfxZpE*VS1(30,46)
VS0(48,70)=QCx*VS0(48,47)+WQx*VS1(48,47)-r1x2E*VR1(48,47)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(31,47)
VS0(48,71)=QCx*VS0(48,48)+WQx*VS1(48,48)-r1x2E*VR1(48,48)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(31,48)
VS0(48,72)=QCx*VS0(48,49)+WQx*VS1(48,49)-r1x2E*VR1(48,49)&
   +r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(31,49)
VS0(48,73)=QCy*VS0(48,49)+WQy*VS1(48,49)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +HfxZpE*VS1(30,49)
VS0(48,74)=QCy*VS0(48,50)+WQy*VS1(48,50)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +HfxZpE*VS1(30,50)
VS0(48,75)=QCx*VS0(48,51)+WQx*VS1(48,51)-r1x2E*VR1(48,51)&
   +2D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(31,51)
VS0(48,76)=QCz*VS0(48,48)+WQz*VS1(48,48)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(27,48)
VS0(48,77)=QCz*VS0(48,49)+WQz*VS1(48,49)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(27,49)
VS0(48,78)=QCy*VS0(48,53)+WQy*VS1(48,53)&
   +2D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +HfxZpE*VS1(30,53)
VS0(48,79)=QCz*VS0(48,51)+WQz*VS1(48,51)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(27,51)
VS0(48,80)=QCz*VS0(48,52)+WQz*VS1(48,52)&
   +3D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(27,52)
VS0(48,81)=QCz*VS0(48,53)+WQz*VS1(48,53)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(27,53)
VS0(48,82)=QCz*VS0(48,54)+WQz*VS1(48,54)&
   +4D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(27,54)
VS0(48,83)=QCz*VS0(48,55)+WQz*VS1(48,55)&
   +4D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +2D0*HfxZpE*VS1(27,55)
VS0(48,84)=QCz*VS0(48,56)+WQz*VS1(48,56)&
   +5D0*r1x2E*(VS0(48,35)-ZxZpE*VS1(48,35))&
   +2D0*HfxZpE*VS1(27,56)
VS0(49,57)=QCx*VS0(49,36)+WQx*VS1(49,36)-r1x2E*VR1(49,36)&
   +5D0*r1x2E*(VS0(49,21)-ZxZpE*VS1(49,21))&
   +HfxZpE*VS1(32,36)
VS0(49,58)=QCx*VS0(49,37)+WQx*VS1(49,37)-r1x2E*VR1(49,37)&
   +4D0*r1x2E*(VS0(49,22)-ZxZpE*VS1(49,22))&
   +HfxZpE*VS1(32,37)
VS0(49,59)=QCx*VS0(49,38)+WQx*VS1(49,38)-r1x2E*VR1(49,38)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +HfxZpE*VS1(32,38)
VS0(49,60)=QCx*VS0(49,39)+WQx*VS1(49,39)-r1x2E*VR1(49,39)&
   +2D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +HfxZpE*VS1(32,39)
VS0(49,61)=QCy*VS0(49,39)+WQy*VS1(49,39)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +2D0*HfxZpE*VS1(31,39)
VS0(49,62)=QCy*VS0(49,40)+WQy*VS1(49,40)&
   +4D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +2D0*HfxZpE*VS1(31,40)
VS0(49,63)=QCy*VS0(49,41)+WQy*VS1(49,41)&
   +5D0*r1x2E*(VS0(49,25)-ZxZpE*VS1(49,25))&
   +2D0*HfxZpE*VS1(31,41)
VS0(49,64)=QCx*VS0(49,42)+WQx*VS1(49,42)-r1x2E*VR1(49,42)&
   +4D0*r1x2E*(VS0(49,26)-ZxZpE*VS1(49,26))&
   +HfxZpE*VS1(32,42)
VS0(49,65)=QCx*VS0(49,43)+WQx*VS1(49,43)-r1x2E*VR1(49,43)&
   +3D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +HfxZpE*VS1(32,43)
VS0(49,66)=QCx*VS0(49,44)+WQx*VS1(49,44)-r1x2E*VR1(49,44)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +HfxZpE*VS1(32,44)
VS0(49,67)=QCy*VS0(49,44)+WQy*VS1(49,44)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(31,44)
VS0(49,68)=QCy*VS0(49,45)+WQy*VS1(49,45)&
   +3D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(31,45)
VS0(49,69)=QCy*VS0(49,46)+WQy*VS1(49,46)&
   +4D0*r1x2E*(VS0(49,29)-ZxZpE*VS1(49,29))&
   +2D0*HfxZpE*VS1(31,46)
VS0(49,70)=QCx*VS0(49,47)+WQx*VS1(49,47)-r1x2E*VR1(49,47)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +HfxZpE*VS1(32,47)
VS0(49,71)=QCx*VS0(49,48)+WQx*VS1(49,48)-r1x2E*VR1(49,48)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +HfxZpE*VS1(32,48)
VS0(49,72)=QCx*VS0(49,49)+WQx*VS1(49,49)-r1x2E*VR1(49,49)&
   +r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +HfxZpE*VS1(32,49)
VS0(49,73)=QCy*VS0(49,49)+WQy*VS1(49,49)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(31,49)
VS0(49,74)=QCy*VS0(49,50)+WQy*VS1(49,50)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(31,50)
VS0(49,75)=QCx*VS0(49,51)+WQx*VS1(49,51)-r1x2E*VR1(49,51)&
   +2D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +HfxZpE*VS1(32,51)
VS0(49,76)=QCz*VS0(49,48)+WQz*VS1(49,48)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(28,48)
VS0(49,77)=QCz*VS0(49,49)+WQz*VS1(49,49)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(28,49)
VS0(49,78)=QCy*VS0(49,53)+WQy*VS1(49,53)&
   +2D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(31,53)
VS0(49,79)=QCz*VS0(49,51)+WQz*VS1(49,51)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +2D0*HfxZpE*VS1(28,51)
VS0(49,80)=QCz*VS0(49,52)+WQz*VS1(49,52)&
   +3D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(28,52)
VS0(49,81)=QCz*VS0(49,53)+WQz*VS1(49,53)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(28,53)
VS0(49,82)=QCz*VS0(49,54)+WQz*VS1(49,54)&
   +4D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +2D0*HfxZpE*VS1(28,54)
VS0(49,83)=QCz*VS0(49,55)+WQz*VS1(49,55)&
   +4D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(28,55)
VS0(49,84)=QCz*VS0(49,56)+WQz*VS1(49,56)&
   +5D0*r1x2E*(VS0(49,35)-ZxZpE*VS1(49,35))&
   +2D0*HfxZpE*VS1(28,56)
VS0(50,57)=QCx*VS0(50,36)+WQx*VS1(50,36)-r1x2E*VR1(50,36)&
   +5D0*r1x2E*(VS0(50,21)-ZxZpE*VS1(50,21))
VS0(50,58)=QCx*VS0(50,37)+WQx*VS1(50,37)-r1x2E*VR1(50,37)&
   +4D0*r1x2E*(VS0(50,22)-ZxZpE*VS1(50,22))
VS0(50,59)=QCx*VS0(50,38)+WQx*VS1(50,38)-r1x2E*VR1(50,38)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))
VS0(50,60)=QCx*VS0(50,39)+WQx*VS1(50,39)-r1x2E*VR1(50,39)&
   +2D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))
VS0(50,61)=QCy*VS0(50,39)+WQy*VS1(50,39)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))&
   +3D0*HfxZpE*VS1(32,39)
VS0(50,62)=QCy*VS0(50,40)+WQy*VS1(50,40)&
   +4D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))&
   +3D0*HfxZpE*VS1(32,40)
VS0(50,63)=QCy*VS0(50,41)+WQy*VS1(50,41)&
   +5D0*r1x2E*(VS0(50,25)-ZxZpE*VS1(50,25))&
   +3D0*HfxZpE*VS1(32,41)
VS0(50,64)=QCx*VS0(50,42)+WQx*VS1(50,42)-r1x2E*VR1(50,42)&
   +4D0*r1x2E*(VS0(50,26)-ZxZpE*VS1(50,26))
VS0(50,65)=QCx*VS0(50,43)+WQx*VS1(50,43)-r1x2E*VR1(50,43)&
   +3D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))
VS0(50,66)=QCx*VS0(50,44)+WQx*VS1(50,44)-r1x2E*VR1(50,44)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))
VS0(50,67)=QCy*VS0(50,44)+WQy*VS1(50,44)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +3D0*HfxZpE*VS1(32,44)
VS0(50,68)=QCy*VS0(50,45)+WQy*VS1(50,45)&
   +3D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +3D0*HfxZpE*VS1(32,45)
VS0(50,69)=QCy*VS0(50,46)+WQy*VS1(50,46)&
   +4D0*r1x2E*(VS0(50,29)-ZxZpE*VS1(50,29))&
   +3D0*HfxZpE*VS1(32,46)
VS0(50,70)=QCx*VS0(50,47)+WQx*VS1(50,47)-r1x2E*VR1(50,47)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))
VS0(50,71)=QCx*VS0(50,48)+WQx*VS1(50,48)-r1x2E*VR1(50,48)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))
VS0(50,72)=QCx*VS0(50,49)+WQx*VS1(50,49)-r1x2E*VR1(50,49)&
   +r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))
VS0(50,73)=QCy*VS0(50,49)+WQy*VS1(50,49)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +3D0*HfxZpE*VS1(32,49)
VS0(50,74)=QCy*VS0(50,50)+WQy*VS1(50,50)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +3D0*HfxZpE*VS1(32,50)
VS0(50,75)=QCx*VS0(50,51)+WQx*VS1(50,51)-r1x2E*VR1(50,51)&
   +2D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))
VS0(50,76)=QCz*VS0(50,48)+WQz*VS1(50,48)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +2D0*HfxZpE*VS1(29,48)
VS0(50,77)=QCz*VS0(50,49)+WQz*VS1(50,49)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +2D0*HfxZpE*VS1(29,49)
VS0(50,78)=QCy*VS0(50,53)+WQy*VS1(50,53)&
   +2D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +3D0*HfxZpE*VS1(32,53)
VS0(50,79)=QCz*VS0(50,51)+WQz*VS1(50,51)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))&
   +2D0*HfxZpE*VS1(29,51)
VS0(50,80)=QCz*VS0(50,52)+WQz*VS1(50,52)&
   +3D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +2D0*HfxZpE*VS1(29,52)
VS0(50,81)=QCz*VS0(50,53)+WQz*VS1(50,53)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +2D0*HfxZpE*VS1(29,53)
VS0(50,82)=QCz*VS0(50,54)+WQz*VS1(50,54)&
   +4D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))&
   +2D0*HfxZpE*VS1(29,54)
VS0(50,83)=QCz*VS0(50,55)+WQz*VS1(50,55)&
   +4D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +2D0*HfxZpE*VS1(29,55)
VS0(50,84)=QCz*VS0(50,56)+WQz*VS1(50,56)&
   +5D0*r1x2E*(VS0(50,35)-ZxZpE*VS1(50,35))&
   +2D0*HfxZpE*VS1(29,56)
VS0(51,57)=QCx*VS0(51,36)+WQx*VS1(51,36)-r1x2E*VR1(51,36)&
   +5D0*r1x2E*(VS0(51,21)-ZxZpE*VS1(51,21))&
   +2D0*HfxZpE*VS1(33,36)
VS0(51,58)=QCx*VS0(51,37)+WQx*VS1(51,37)-r1x2E*VR1(51,37)&
   +4D0*r1x2E*(VS0(51,22)-ZxZpE*VS1(51,22))&
   +2D0*HfxZpE*VS1(33,37)
VS0(51,59)=QCx*VS0(51,38)+WQx*VS1(51,38)-r1x2E*VR1(51,38)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))&
   +2D0*HfxZpE*VS1(33,38)
VS0(51,60)=QCx*VS0(51,39)+WQx*VS1(51,39)-r1x2E*VR1(51,39)&
   +2D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))&
   +2D0*HfxZpE*VS1(33,39)
VS0(51,61)=QCy*VS0(51,39)+WQy*VS1(51,39)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))
VS0(51,62)=QCy*VS0(51,40)+WQy*VS1(51,40)&
   +4D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))
VS0(51,63)=QCy*VS0(51,41)+WQy*VS1(51,41)&
   +5D0*r1x2E*(VS0(51,25)-ZxZpE*VS1(51,25))
VS0(51,64)=QCx*VS0(51,42)+WQx*VS1(51,42)-r1x2E*VR1(51,42)&
   +4D0*r1x2E*(VS0(51,26)-ZxZpE*VS1(51,26))&
   +2D0*HfxZpE*VS1(33,42)
VS0(51,65)=QCx*VS0(51,43)+WQx*VS1(51,43)-r1x2E*VR1(51,43)&
   +3D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +2D0*HfxZpE*VS1(33,43)
VS0(51,66)=QCx*VS0(51,44)+WQx*VS1(51,44)-r1x2E*VR1(51,44)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +2D0*HfxZpE*VS1(33,44)
VS0(51,67)=QCy*VS0(51,44)+WQy*VS1(51,44)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))
VS0(51,68)=QCy*VS0(51,45)+WQy*VS1(51,45)&
   +3D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))
VS0(51,69)=QCy*VS0(51,46)+WQy*VS1(51,46)&
   +4D0*r1x2E*(VS0(51,29)-ZxZpE*VS1(51,29))
VS0(51,70)=QCx*VS0(51,47)+WQx*VS1(51,47)-r1x2E*VR1(51,47)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +2D0*HfxZpE*VS1(33,47)
VS0(51,71)=QCx*VS0(51,48)+WQx*VS1(51,48)-r1x2E*VR1(51,48)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +2D0*HfxZpE*VS1(33,48)
VS0(51,72)=QCx*VS0(51,49)+WQx*VS1(51,49)-r1x2E*VR1(51,49)&
   +r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +2D0*HfxZpE*VS1(33,49)
VS0(51,73)=QCy*VS0(51,49)+WQy*VS1(51,49)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))
VS0(51,74)=QCy*VS0(51,50)+WQy*VS1(51,50)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))
VS0(51,75)=QCx*VS0(51,51)+WQx*VS1(51,51)-r1x2E*VR1(51,51)&
   +2D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +2D0*HfxZpE*VS1(33,51)
VS0(51,76)=QCz*VS0(51,48)+WQz*VS1(51,48)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +3D0*HfxZpE*VS1(30,48)
VS0(51,77)=QCz*VS0(51,49)+WQz*VS1(51,49)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +3D0*HfxZpE*VS1(30,49)
VS0(51,78)=QCy*VS0(51,53)+WQy*VS1(51,53)&
   +2D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))
VS0(51,79)=QCz*VS0(51,51)+WQz*VS1(51,51)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +3D0*HfxZpE*VS1(30,51)
VS0(51,80)=QCz*VS0(51,52)+WQz*VS1(51,52)&
   +3D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +3D0*HfxZpE*VS1(30,52)
VS0(51,81)=QCz*VS0(51,53)+WQz*VS1(51,53)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +3D0*HfxZpE*VS1(30,53)
VS0(51,82)=QCz*VS0(51,54)+WQz*VS1(51,54)&
   +4D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +3D0*HfxZpE*VS1(30,54)
VS0(51,83)=QCz*VS0(51,55)+WQz*VS1(51,55)&
   +4D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))&
   +3D0*HfxZpE*VS1(30,55)
VS0(51,84)=QCz*VS0(51,56)+WQz*VS1(51,56)&
   +5D0*r1x2E*(VS0(51,35)-ZxZpE*VS1(51,35))&
   +3D0*HfxZpE*VS1(30,56)
VS0(52,57)=QCx*VS0(52,36)+WQx*VS1(52,36)-r1x2E*VR1(52,36)&
   +5D0*r1x2E*(VS0(52,21)-ZxZpE*VS1(52,21))&
   +HfxZpE*VS1(34,36)
VS0(52,58)=QCx*VS0(52,37)+WQx*VS1(52,37)-r1x2E*VR1(52,37)&
   +4D0*r1x2E*(VS0(52,22)-ZxZpE*VS1(52,22))&
   +HfxZpE*VS1(34,37)
VS0(52,59)=QCx*VS0(52,38)+WQx*VS1(52,38)-r1x2E*VR1(52,38)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(34,38)
VS0(52,60)=QCx*VS0(52,39)+WQx*VS1(52,39)-r1x2E*VR1(52,39)&
   +2D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(34,39)
VS0(52,61)=QCy*VS0(52,39)+WQy*VS1(52,39)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(33,39)
VS0(52,62)=QCy*VS0(52,40)+WQy*VS1(52,40)&
   +4D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(33,40)
VS0(52,63)=QCy*VS0(52,41)+WQy*VS1(52,41)&
   +5D0*r1x2E*(VS0(52,25)-ZxZpE*VS1(52,25))&
   +HfxZpE*VS1(33,41)
VS0(52,64)=QCx*VS0(52,42)+WQx*VS1(52,42)-r1x2E*VR1(52,42)&
   +4D0*r1x2E*(VS0(52,26)-ZxZpE*VS1(52,26))&
   +HfxZpE*VS1(34,42)
VS0(52,65)=QCx*VS0(52,43)+WQx*VS1(52,43)-r1x2E*VR1(52,43)&
   +3D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(34,43)
VS0(52,66)=QCx*VS0(52,44)+WQx*VS1(52,44)-r1x2E*VR1(52,44)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(34,44)
VS0(52,67)=QCy*VS0(52,44)+WQy*VS1(52,44)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(33,44)
VS0(52,68)=QCy*VS0(52,45)+WQy*VS1(52,45)&
   +3D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(33,45)
VS0(52,69)=QCy*VS0(52,46)+WQy*VS1(52,46)&
   +4D0*r1x2E*(VS0(52,29)-ZxZpE*VS1(52,29))&
   +HfxZpE*VS1(33,46)
VS0(52,70)=QCx*VS0(52,47)+WQx*VS1(52,47)-r1x2E*VR1(52,47)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +HfxZpE*VS1(34,47)
VS0(52,71)=QCx*VS0(52,48)+WQx*VS1(52,48)-r1x2E*VR1(52,48)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(34,48)
VS0(52,72)=QCx*VS0(52,49)+WQx*VS1(52,49)-r1x2E*VR1(52,49)&
   +r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(34,49)
VS0(52,73)=QCy*VS0(52,49)+WQy*VS1(52,49)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(33,49)
VS0(52,74)=QCy*VS0(52,50)+WQy*VS1(52,50)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(33,50)
VS0(52,75)=QCx*VS0(52,51)+WQx*VS1(52,51)-r1x2E*VR1(52,51)&
   +2D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +HfxZpE*VS1(34,51)
VS0(52,76)=QCz*VS0(52,48)+WQz*VS1(52,48)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +3D0*HfxZpE*VS1(31,48)
VS0(52,77)=QCz*VS0(52,49)+WQz*VS1(52,49)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +3D0*HfxZpE*VS1(31,49)
VS0(52,78)=QCy*VS0(52,53)+WQy*VS1(52,53)&
   +2D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +HfxZpE*VS1(33,53)
VS0(52,79)=QCz*VS0(52,51)+WQz*VS1(52,51)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +3D0*HfxZpE*VS1(31,51)
VS0(52,80)=QCz*VS0(52,52)+WQz*VS1(52,52)&
   +3D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +3D0*HfxZpE*VS1(31,52)
VS0(52,81)=QCz*VS0(52,53)+WQz*VS1(52,53)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +3D0*HfxZpE*VS1(31,53)
VS0(52,82)=QCz*VS0(52,54)+WQz*VS1(52,54)&
   +4D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +3D0*HfxZpE*VS1(31,54)
VS0(52,83)=QCz*VS0(52,55)+WQz*VS1(52,55)&
   +4D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +3D0*HfxZpE*VS1(31,55)
VS0(52,84)=QCz*VS0(52,56)+WQz*VS1(52,56)&
   +5D0*r1x2E*(VS0(52,35)-ZxZpE*VS1(52,35))&
   +3D0*HfxZpE*VS1(31,56)
VS0(53,57)=QCx*VS0(53,36)+WQx*VS1(53,36)-r1x2E*VR1(53,36)&
   +5D0*r1x2E*(VS0(53,21)-ZxZpE*VS1(53,21))
VS0(53,58)=QCx*VS0(53,37)+WQx*VS1(53,37)-r1x2E*VR1(53,37)&
   +4D0*r1x2E*(VS0(53,22)-ZxZpE*VS1(53,22))
VS0(53,59)=QCx*VS0(53,38)+WQx*VS1(53,38)-r1x2E*VR1(53,38)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))
VS0(53,60)=QCx*VS0(53,39)+WQx*VS1(53,39)-r1x2E*VR1(53,39)&
   +2D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))
VS0(53,61)=QCy*VS0(53,39)+WQy*VS1(53,39)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))&
   +2D0*HfxZpE*VS1(34,39)
VS0(53,62)=QCy*VS0(53,40)+WQy*VS1(53,40)&
   +4D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))&
   +2D0*HfxZpE*VS1(34,40)
VS0(53,63)=QCy*VS0(53,41)+WQy*VS1(53,41)&
   +5D0*r1x2E*(VS0(53,25)-ZxZpE*VS1(53,25))&
   +2D0*HfxZpE*VS1(34,41)
VS0(53,64)=QCx*VS0(53,42)+WQx*VS1(53,42)-r1x2E*VR1(53,42)&
   +4D0*r1x2E*(VS0(53,26)-ZxZpE*VS1(53,26))
VS0(53,65)=QCx*VS0(53,43)+WQx*VS1(53,43)-r1x2E*VR1(53,43)&
   +3D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))
VS0(53,66)=QCx*VS0(53,44)+WQx*VS1(53,44)-r1x2E*VR1(53,44)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))
VS0(53,67)=QCy*VS0(53,44)+WQy*VS1(53,44)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +2D0*HfxZpE*VS1(34,44)
VS0(53,68)=QCy*VS0(53,45)+WQy*VS1(53,45)&
   +3D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +2D0*HfxZpE*VS1(34,45)
VS0(53,69)=QCy*VS0(53,46)+WQy*VS1(53,46)&
   +4D0*r1x2E*(VS0(53,29)-ZxZpE*VS1(53,29))&
   +2D0*HfxZpE*VS1(34,46)
VS0(53,70)=QCx*VS0(53,47)+WQx*VS1(53,47)-r1x2E*VR1(53,47)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))
VS0(53,71)=QCx*VS0(53,48)+WQx*VS1(53,48)-r1x2E*VR1(53,48)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))
VS0(53,72)=QCx*VS0(53,49)+WQx*VS1(53,49)-r1x2E*VR1(53,49)&
   +r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))
VS0(53,73)=QCy*VS0(53,49)+WQy*VS1(53,49)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +2D0*HfxZpE*VS1(34,49)
VS0(53,74)=QCy*VS0(53,50)+WQy*VS1(53,50)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +2D0*HfxZpE*VS1(34,50)
VS0(53,75)=QCx*VS0(53,51)+WQx*VS1(53,51)-r1x2E*VR1(53,51)&
   +2D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))
VS0(53,76)=QCz*VS0(53,48)+WQz*VS1(53,48)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +3D0*HfxZpE*VS1(32,48)
VS0(53,77)=QCz*VS0(53,49)+WQz*VS1(53,49)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +3D0*HfxZpE*VS1(32,49)
VS0(53,78)=QCy*VS0(53,53)+WQy*VS1(53,53)&
   +2D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +2D0*HfxZpE*VS1(34,53)
VS0(53,79)=QCz*VS0(53,51)+WQz*VS1(53,51)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))&
   +3D0*HfxZpE*VS1(32,51)
VS0(53,80)=QCz*VS0(53,52)+WQz*VS1(53,52)&
   +3D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +3D0*HfxZpE*VS1(32,52)
VS0(53,81)=QCz*VS0(53,53)+WQz*VS1(53,53)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +3D0*HfxZpE*VS1(32,53)
VS0(53,82)=QCz*VS0(53,54)+WQz*VS1(53,54)&
   +4D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))&
   +3D0*HfxZpE*VS1(32,54)
VS0(53,83)=QCz*VS0(53,55)+WQz*VS1(53,55)&
   +4D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +3D0*HfxZpE*VS1(32,55)
VS0(53,84)=QCz*VS0(53,56)+WQz*VS1(53,56)&
   +5D0*r1x2E*(VS0(53,35)-ZxZpE*VS1(53,35))&
   +3D0*HfxZpE*VS1(32,56)
VS0(54,57)=QCx*VS0(54,36)+WQx*VS1(54,36)-r1x2E*VR1(54,36)&
   +5D0*r1x2E*(VS0(54,21)-ZxZpE*VS1(54,21))&
   +HfxZpE*VS1(35,36)
VS0(54,58)=QCx*VS0(54,37)+WQx*VS1(54,37)-r1x2E*VR1(54,37)&
   +4D0*r1x2E*(VS0(54,22)-ZxZpE*VS1(54,22))&
   +HfxZpE*VS1(35,37)
VS0(54,59)=QCx*VS0(54,38)+WQx*VS1(54,38)-r1x2E*VR1(54,38)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))&
   +HfxZpE*VS1(35,38)
VS0(54,60)=QCx*VS0(54,39)+WQx*VS1(54,39)-r1x2E*VR1(54,39)&
   +2D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))&
   +HfxZpE*VS1(35,39)
VS0(54,61)=QCy*VS0(54,39)+WQy*VS1(54,39)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))
VS0(54,62)=QCy*VS0(54,40)+WQy*VS1(54,40)&
   +4D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))
VS0(54,63)=QCy*VS0(54,41)+WQy*VS1(54,41)&
   +5D0*r1x2E*(VS0(54,25)-ZxZpE*VS1(54,25))
VS0(54,64)=QCx*VS0(54,42)+WQx*VS1(54,42)-r1x2E*VR1(54,42)&
   +4D0*r1x2E*(VS0(54,26)-ZxZpE*VS1(54,26))&
   +HfxZpE*VS1(35,42)
VS0(54,65)=QCx*VS0(54,43)+WQx*VS1(54,43)-r1x2E*VR1(54,43)&
   +3D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +HfxZpE*VS1(35,43)
VS0(54,66)=QCx*VS0(54,44)+WQx*VS1(54,44)-r1x2E*VR1(54,44)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +HfxZpE*VS1(35,44)
VS0(54,67)=QCy*VS0(54,44)+WQy*VS1(54,44)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))
VS0(54,68)=QCy*VS0(54,45)+WQy*VS1(54,45)&
   +3D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))
VS0(54,69)=QCy*VS0(54,46)+WQy*VS1(54,46)&
   +4D0*r1x2E*(VS0(54,29)-ZxZpE*VS1(54,29))
VS0(54,70)=QCx*VS0(54,47)+WQx*VS1(54,47)-r1x2E*VR1(54,47)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +HfxZpE*VS1(35,47)
VS0(54,71)=QCx*VS0(54,48)+WQx*VS1(54,48)-r1x2E*VR1(54,48)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +HfxZpE*VS1(35,48)
VS0(54,72)=QCx*VS0(54,49)+WQx*VS1(54,49)-r1x2E*VR1(54,49)&
   +r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +HfxZpE*VS1(35,49)
VS0(54,73)=QCy*VS0(54,49)+WQy*VS1(54,49)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))
VS0(54,74)=QCy*VS0(54,50)+WQy*VS1(54,50)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))
VS0(54,75)=QCx*VS0(54,51)+WQx*VS1(54,51)-r1x2E*VR1(54,51)&
   +2D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +HfxZpE*VS1(35,51)
VS0(54,76)=QCz*VS0(54,48)+WQz*VS1(54,48)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +4D0*HfxZpE*VS1(33,48)
VS0(54,77)=QCz*VS0(54,49)+WQz*VS1(54,49)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +4D0*HfxZpE*VS1(33,49)
VS0(54,78)=QCy*VS0(54,53)+WQy*VS1(54,53)&
   +2D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))
VS0(54,79)=QCz*VS0(54,51)+WQz*VS1(54,51)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +4D0*HfxZpE*VS1(33,51)
VS0(54,80)=QCz*VS0(54,52)+WQz*VS1(54,52)&
   +3D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +4D0*HfxZpE*VS1(33,52)
VS0(54,81)=QCz*VS0(54,53)+WQz*VS1(54,53)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +4D0*HfxZpE*VS1(33,53)
VS0(54,82)=QCz*VS0(54,54)+WQz*VS1(54,54)&
   +4D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +4D0*HfxZpE*VS1(33,54)
VS0(54,83)=QCz*VS0(54,55)+WQz*VS1(54,55)&
   +4D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))&
   +4D0*HfxZpE*VS1(33,55)
VS0(54,84)=QCz*VS0(54,56)+WQz*VS1(54,56)&
   +5D0*r1x2E*(VS0(54,35)-ZxZpE*VS1(54,35))&
   +4D0*HfxZpE*VS1(33,56)
VS0(55,57)=QCx*VS0(55,36)+WQx*VS1(55,36)-r1x2E*VR1(55,36)&
   +5D0*r1x2E*(VS0(55,21)-ZxZpE*VS1(55,21))
VS0(55,58)=QCx*VS0(55,37)+WQx*VS1(55,37)-r1x2E*VR1(55,37)&
   +4D0*r1x2E*(VS0(55,22)-ZxZpE*VS1(55,22))
VS0(55,59)=QCx*VS0(55,38)+WQx*VS1(55,38)-r1x2E*VR1(55,38)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))
VS0(55,60)=QCx*VS0(55,39)+WQx*VS1(55,39)-r1x2E*VR1(55,39)&
   +2D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))
VS0(55,61)=QCy*VS0(55,39)+WQy*VS1(55,39)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))&
   +HfxZpE*VS1(35,39)
VS0(55,62)=QCy*VS0(55,40)+WQy*VS1(55,40)&
   +4D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))&
   +HfxZpE*VS1(35,40)
VS0(55,63)=QCy*VS0(55,41)+WQy*VS1(55,41)&
   +5D0*r1x2E*(VS0(55,25)-ZxZpE*VS1(55,25))&
   +HfxZpE*VS1(35,41)
VS0(55,64)=QCx*VS0(55,42)+WQx*VS1(55,42)-r1x2E*VR1(55,42)&
   +4D0*r1x2E*(VS0(55,26)-ZxZpE*VS1(55,26))
VS0(55,65)=QCx*VS0(55,43)+WQx*VS1(55,43)-r1x2E*VR1(55,43)&
   +3D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))
VS0(55,66)=QCx*VS0(55,44)+WQx*VS1(55,44)-r1x2E*VR1(55,44)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))
VS0(55,67)=QCy*VS0(55,44)+WQy*VS1(55,44)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +HfxZpE*VS1(35,44)
VS0(55,68)=QCy*VS0(55,45)+WQy*VS1(55,45)&
   +3D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +HfxZpE*VS1(35,45)
VS0(55,69)=QCy*VS0(55,46)+WQy*VS1(55,46)&
   +4D0*r1x2E*(VS0(55,29)-ZxZpE*VS1(55,29))&
   +HfxZpE*VS1(35,46)
VS0(55,70)=QCx*VS0(55,47)+WQx*VS1(55,47)-r1x2E*VR1(55,47)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))
VS0(55,71)=QCx*VS0(55,48)+WQx*VS1(55,48)-r1x2E*VR1(55,48)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))
VS0(55,72)=QCx*VS0(55,49)+WQx*VS1(55,49)-r1x2E*VR1(55,49)&
   +r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))
VS0(55,73)=QCy*VS0(55,49)+WQy*VS1(55,49)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +HfxZpE*VS1(35,49)
VS0(55,74)=QCy*VS0(55,50)+WQy*VS1(55,50)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +HfxZpE*VS1(35,50)
VS0(55,75)=QCx*VS0(55,51)+WQx*VS1(55,51)-r1x2E*VR1(55,51)&
   +2D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))
VS0(55,76)=QCz*VS0(55,48)+WQz*VS1(55,48)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +4D0*HfxZpE*VS1(34,48)
VS0(55,77)=QCz*VS0(55,49)+WQz*VS1(55,49)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +4D0*HfxZpE*VS1(34,49)
VS0(55,78)=QCy*VS0(55,53)+WQy*VS1(55,53)&
   +2D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +HfxZpE*VS1(35,53)
VS0(55,79)=QCz*VS0(55,51)+WQz*VS1(55,51)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))&
   +4D0*HfxZpE*VS1(34,51)
VS0(55,80)=QCz*VS0(55,52)+WQz*VS1(55,52)&
   +3D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +4D0*HfxZpE*VS1(34,52)
VS0(55,81)=QCz*VS0(55,53)+WQz*VS1(55,53)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +4D0*HfxZpE*VS1(34,53)
VS0(55,82)=QCz*VS0(55,54)+WQz*VS1(55,54)&
   +4D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))&
   +4D0*HfxZpE*VS1(34,54)
VS0(55,83)=QCz*VS0(55,55)+WQz*VS1(55,55)&
   +4D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +4D0*HfxZpE*VS1(34,55)
VS0(55,84)=QCz*VS0(55,56)+WQz*VS1(55,56)&
   +5D0*r1x2E*(VS0(55,35)-ZxZpE*VS1(55,35))&
   +4D0*HfxZpE*VS1(34,56)
VS0(56,57)=QCx*VS0(56,36)+WQx*VS1(56,36)-r1x2E*VR1(56,36)&
   +5D0*r1x2E*(VS0(56,21)-ZxZpE*VS1(56,21))
VS0(56,58)=QCx*VS0(56,37)+WQx*VS1(56,37)-r1x2E*VR1(56,37)&
   +4D0*r1x2E*(VS0(56,22)-ZxZpE*VS1(56,22))
VS0(56,59)=QCx*VS0(56,38)+WQx*VS1(56,38)-r1x2E*VR1(56,38)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,60)=QCx*VS0(56,39)+WQx*VS1(56,39)-r1x2E*VR1(56,39)&
   +2D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,61)=QCy*VS0(56,39)+WQy*VS1(56,39)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,62)=QCy*VS0(56,40)+WQy*VS1(56,40)&
   +4D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,63)=QCy*VS0(56,41)+WQy*VS1(56,41)&
   +5D0*r1x2E*(VS0(56,25)-ZxZpE*VS1(56,25))
VS0(56,64)=QCx*VS0(56,42)+WQx*VS1(56,42)-r1x2E*VR1(56,42)&
   +4D0*r1x2E*(VS0(56,26)-ZxZpE*VS1(56,26))
VS0(56,65)=QCx*VS0(56,43)+WQx*VS1(56,43)-r1x2E*VR1(56,43)&
   +3D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,66)=QCx*VS0(56,44)+WQx*VS1(56,44)-r1x2E*VR1(56,44)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,67)=QCy*VS0(56,44)+WQy*VS1(56,44)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,68)=QCy*VS0(56,45)+WQy*VS1(56,45)&
   +3D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,69)=QCy*VS0(56,46)+WQy*VS1(56,46)&
   +4D0*r1x2E*(VS0(56,29)-ZxZpE*VS1(56,29))
VS0(56,70)=QCx*VS0(56,47)+WQx*VS1(56,47)-r1x2E*VR1(56,47)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))
VS0(56,71)=QCx*VS0(56,48)+WQx*VS1(56,48)-r1x2E*VR1(56,48)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,72)=QCx*VS0(56,49)+WQx*VS1(56,49)-r1x2E*VR1(56,49)&
   +r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,73)=QCy*VS0(56,49)+WQy*VS1(56,49)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,74)=QCy*VS0(56,50)+WQy*VS1(56,50)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,75)=QCx*VS0(56,51)+WQx*VS1(56,51)-r1x2E*VR1(56,51)&
   +2D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))
VS0(56,76)=QCz*VS0(56,48)+WQz*VS1(56,48)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))&
   +5D0*HfxZpE*VS1(35,48)
VS0(56,77)=QCz*VS0(56,49)+WQz*VS1(56,49)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))&
   +5D0*HfxZpE*VS1(35,49)
VS0(56,78)=QCy*VS0(56,53)+WQy*VS1(56,53)&
   +2D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))
VS0(56,79)=QCz*VS0(56,51)+WQz*VS1(56,51)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))&
   +5D0*HfxZpE*VS1(35,51)
VS0(56,80)=QCz*VS0(56,52)+WQz*VS1(56,52)&
   +3D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))&
   +5D0*HfxZpE*VS1(35,52)
VS0(56,81)=QCz*VS0(56,53)+WQz*VS1(56,53)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))&
   +5D0*HfxZpE*VS1(35,53)
VS0(56,82)=QCz*VS0(56,54)+WQz*VS1(56,54)&
   +4D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))&
   +5D0*HfxZpE*VS1(35,54)
VS0(56,83)=QCz*VS0(56,55)+WQz*VS1(56,55)&
   +4D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))&
   +5D0*HfxZpE*VS1(35,55)
VS0(56,84)=QCz*VS0(56,56)+WQz*VS1(56,56)&
   +5D0*r1x2E*(VS0(56,35)-ZxZpE*VS1(56,35))&
   +5D0*HfxZpE*VS1(35,56)
CASE(2)
VS0(36,57)=QCx*VS0(36,36)+WQx*VS1(36,36)&
   +5D0*r1x2E*(VS0(36,21)-ZxZpE*VS1(36,21))&
   +5D0*HfxZpE*VS1(21,36)
VS0(36,58)=QCx*VS0(36,37)+WQx*VS1(36,37)&
   +4D0*r1x2E*(VS0(36,22)-ZxZpE*VS1(36,22))&
   +5D0*HfxZpE*VS1(21,37)
VS0(36,59)=QCx*VS0(36,38)+WQx*VS1(36,38)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))&
   +5D0*HfxZpE*VS1(21,38)
VS0(36,60)=QCx*VS0(36,39)+WQx*VS1(36,39)&
   +2D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))&
   +5D0*HfxZpE*VS1(21,39)
VS0(36,61)=QCy*VS0(36,39)+WQy*VS1(36,39)-r1x2E*VR1(36,39)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))
VS0(36,62)=QCy*VS0(36,40)+WQy*VS1(36,40)-r1x2E*VR1(36,40)&
   +4D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))
VS0(36,63)=QCy*VS0(36,41)+WQy*VS1(36,41)-r1x2E*VR1(36,41)&
   +5D0*r1x2E*(VS0(36,25)-ZxZpE*VS1(36,25))
VS0(36,64)=QCx*VS0(36,42)+WQx*VS1(36,42)&
   +4D0*r1x2E*(VS0(36,26)-ZxZpE*VS1(36,26))&
   +5D0*HfxZpE*VS1(21,42)
VS0(36,65)=QCx*VS0(36,43)+WQx*VS1(36,43)&
   +3D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))&
   +5D0*HfxZpE*VS1(21,43)
VS0(36,66)=QCx*VS0(36,44)+WQx*VS1(36,44)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))&
   +5D0*HfxZpE*VS1(21,44)
VS0(36,67)=QCy*VS0(36,44)+WQy*VS1(36,44)-r1x2E*VR1(36,44)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,68)=QCy*VS0(36,45)+WQy*VS1(36,45)-r1x2E*VR1(36,45)&
   +3D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,69)=QCy*VS0(36,46)+WQy*VS1(36,46)-r1x2E*VR1(36,46)&
   +4D0*r1x2E*(VS0(36,29)-ZxZpE*VS1(36,29))
VS0(36,70)=QCx*VS0(36,47)+WQx*VS1(36,47)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))&
   +5D0*HfxZpE*VS1(21,47)
VS0(36,71)=QCx*VS0(36,48)+WQx*VS1(36,48)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))&
   +5D0*HfxZpE*VS1(21,48)
VS0(36,72)=QCx*VS0(36,49)+WQx*VS1(36,49)&
   +r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))&
   +5D0*HfxZpE*VS1(21,49)
VS0(36,73)=QCy*VS0(36,49)+WQy*VS1(36,49)-r1x2E*VR1(36,49)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,74)=QCy*VS0(36,50)+WQy*VS1(36,50)-r1x2E*VR1(36,50)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,75)=QCx*VS0(36,51)+WQx*VS1(36,51)&
   +2D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))&
   +5D0*HfxZpE*VS1(21,51)
VS0(36,76)=QCz*VS0(36,48)+WQz*VS1(36,48)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,77)=QCz*VS0(36,49)+WQz*VS1(36,49)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,78)=QCy*VS0(36,53)+WQy*VS1(36,53)-r1x2E*VR1(36,53)&
   +2D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,79)=QCz*VS0(36,51)+WQz*VS1(36,51)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))
VS0(36,80)=QCz*VS0(36,52)+WQz*VS1(36,52)&
   +3D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,81)=QCz*VS0(36,53)+WQz*VS1(36,53)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,82)=QCz*VS0(36,54)+WQz*VS1(36,54)&
   +4D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))
VS0(36,83)=QCz*VS0(36,55)+WQz*VS1(36,55)&
   +4D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,84)=QCz*VS0(36,56)+WQz*VS1(36,56)&
   +5D0*r1x2E*(VS0(36,35)-ZxZpE*VS1(36,35))
VS0(37,57)=QCx*VS0(37,36)+WQx*VS1(37,36)&
   +5D0*r1x2E*(VS0(37,21)-ZxZpE*VS1(37,21))&
   +4D0*HfxZpE*VS1(22,36)
VS0(37,58)=QCx*VS0(37,37)+WQx*VS1(37,37)&
   +4D0*r1x2E*(VS0(37,22)-ZxZpE*VS1(37,22))&
   +4D0*HfxZpE*VS1(22,37)
VS0(37,59)=QCx*VS0(37,38)+WQx*VS1(37,38)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +4D0*HfxZpE*VS1(22,38)
VS0(37,60)=QCx*VS0(37,39)+WQx*VS1(37,39)&
   +2D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +4D0*HfxZpE*VS1(22,39)
VS0(37,61)=QCy*VS0(37,39)+WQy*VS1(37,39)-r1x2E*VR1(37,39)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +HfxZpE*VS1(21,39)
VS0(37,62)=QCy*VS0(37,40)+WQy*VS1(37,40)-r1x2E*VR1(37,40)&
   +4D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +HfxZpE*VS1(21,40)
VS0(37,63)=QCy*VS0(37,41)+WQy*VS1(37,41)-r1x2E*VR1(37,41)&
   +5D0*r1x2E*(VS0(37,25)-ZxZpE*VS1(37,25))&
   +HfxZpE*VS1(21,41)
VS0(37,64)=QCx*VS0(37,42)+WQx*VS1(37,42)&
   +4D0*r1x2E*(VS0(37,26)-ZxZpE*VS1(37,26))&
   +4D0*HfxZpE*VS1(22,42)
VS0(37,65)=QCx*VS0(37,43)+WQx*VS1(37,43)&
   +3D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +4D0*HfxZpE*VS1(22,43)
VS0(37,66)=QCx*VS0(37,44)+WQx*VS1(37,44)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +4D0*HfxZpE*VS1(22,44)
VS0(37,67)=QCy*VS0(37,44)+WQy*VS1(37,44)-r1x2E*VR1(37,44)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +HfxZpE*VS1(21,44)
VS0(37,68)=QCy*VS0(37,45)+WQy*VS1(37,45)-r1x2E*VR1(37,45)&
   +3D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +HfxZpE*VS1(21,45)
VS0(37,69)=QCy*VS0(37,46)+WQy*VS1(37,46)-r1x2E*VR1(37,46)&
   +4D0*r1x2E*(VS0(37,29)-ZxZpE*VS1(37,29))&
   +HfxZpE*VS1(21,46)
VS0(37,70)=QCx*VS0(37,47)+WQx*VS1(37,47)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))&
   +4D0*HfxZpE*VS1(22,47)
VS0(37,71)=QCx*VS0(37,48)+WQx*VS1(37,48)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +4D0*HfxZpE*VS1(22,48)
VS0(37,72)=QCx*VS0(37,49)+WQx*VS1(37,49)&
   +r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +4D0*HfxZpE*VS1(22,49)
VS0(37,73)=QCy*VS0(37,49)+WQy*VS1(37,49)-r1x2E*VR1(37,49)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +HfxZpE*VS1(21,49)
VS0(37,74)=QCy*VS0(37,50)+WQy*VS1(37,50)-r1x2E*VR1(37,50)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +HfxZpE*VS1(21,50)
VS0(37,75)=QCx*VS0(37,51)+WQx*VS1(37,51)&
   +2D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))&
   +4D0*HfxZpE*VS1(22,51)
VS0(37,76)=QCz*VS0(37,48)+WQz*VS1(37,48)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))
VS0(37,77)=QCz*VS0(37,49)+WQz*VS1(37,49)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))
VS0(37,78)=QCy*VS0(37,53)+WQy*VS1(37,53)-r1x2E*VR1(37,53)&
   +2D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))&
   +HfxZpE*VS1(21,53)
VS0(37,79)=QCz*VS0(37,51)+WQz*VS1(37,51)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))
VS0(37,80)=QCz*VS0(37,52)+WQz*VS1(37,52)&
   +3D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))
VS0(37,81)=QCz*VS0(37,53)+WQz*VS1(37,53)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))
VS0(37,82)=QCz*VS0(37,54)+WQz*VS1(37,54)&
   +4D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))
VS0(37,83)=QCz*VS0(37,55)+WQz*VS1(37,55)&
   +4D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))
VS0(37,84)=QCz*VS0(37,56)+WQz*VS1(37,56)&
   +5D0*r1x2E*(VS0(37,35)-ZxZpE*VS1(37,35))
VS0(38,57)=QCx*VS0(38,36)+WQx*VS1(38,36)&
   +5D0*r1x2E*(VS0(38,21)-ZxZpE*VS1(38,21))&
   +3D0*HfxZpE*VS1(23,36)
VS0(38,58)=QCx*VS0(38,37)+WQx*VS1(38,37)&
   +4D0*r1x2E*(VS0(38,22)-ZxZpE*VS1(38,22))&
   +3D0*HfxZpE*VS1(23,37)
VS0(38,59)=QCx*VS0(38,38)+WQx*VS1(38,38)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +3D0*HfxZpE*VS1(23,38)
VS0(38,60)=QCx*VS0(38,39)+WQx*VS1(38,39)&
   +2D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +3D0*HfxZpE*VS1(23,39)
VS0(38,61)=QCy*VS0(38,39)+WQy*VS1(38,39)-r1x2E*VR1(38,39)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +2D0*HfxZpE*VS1(22,39)
VS0(38,62)=QCy*VS0(38,40)+WQy*VS1(38,40)-r1x2E*VR1(38,40)&
   +4D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +2D0*HfxZpE*VS1(22,40)
VS0(38,63)=QCy*VS0(38,41)+WQy*VS1(38,41)-r1x2E*VR1(38,41)&
   +5D0*r1x2E*(VS0(38,25)-ZxZpE*VS1(38,25))&
   +2D0*HfxZpE*VS1(22,41)
VS0(38,64)=QCx*VS0(38,42)+WQx*VS1(38,42)&
   +4D0*r1x2E*(VS0(38,26)-ZxZpE*VS1(38,26))&
   +3D0*HfxZpE*VS1(23,42)
VS0(38,65)=QCx*VS0(38,43)+WQx*VS1(38,43)&
   +3D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +3D0*HfxZpE*VS1(23,43)
VS0(38,66)=QCx*VS0(38,44)+WQx*VS1(38,44)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +3D0*HfxZpE*VS1(23,44)
VS0(38,67)=QCy*VS0(38,44)+WQy*VS1(38,44)-r1x2E*VR1(38,44)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +2D0*HfxZpE*VS1(22,44)
VS0(38,68)=QCy*VS0(38,45)+WQy*VS1(38,45)-r1x2E*VR1(38,45)&
   +3D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +2D0*HfxZpE*VS1(22,45)
VS0(38,69)=QCy*VS0(38,46)+WQy*VS1(38,46)-r1x2E*VR1(38,46)&
   +4D0*r1x2E*(VS0(38,29)-ZxZpE*VS1(38,29))&
   +2D0*HfxZpE*VS1(22,46)
VS0(38,70)=QCx*VS0(38,47)+WQx*VS1(38,47)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))&
   +3D0*HfxZpE*VS1(23,47)
VS0(38,71)=QCx*VS0(38,48)+WQx*VS1(38,48)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +3D0*HfxZpE*VS1(23,48)
VS0(38,72)=QCx*VS0(38,49)+WQx*VS1(38,49)&
   +r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +3D0*HfxZpE*VS1(23,49)
VS0(38,73)=QCy*VS0(38,49)+WQy*VS1(38,49)-r1x2E*VR1(38,49)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +2D0*HfxZpE*VS1(22,49)
VS0(38,74)=QCy*VS0(38,50)+WQy*VS1(38,50)-r1x2E*VR1(38,50)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +2D0*HfxZpE*VS1(22,50)
VS0(38,75)=QCx*VS0(38,51)+WQx*VS1(38,51)&
   +2D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))&
   +3D0*HfxZpE*VS1(23,51)
VS0(38,76)=QCz*VS0(38,48)+WQz*VS1(38,48)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))
VS0(38,77)=QCz*VS0(38,49)+WQz*VS1(38,49)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))
VS0(38,78)=QCy*VS0(38,53)+WQy*VS1(38,53)-r1x2E*VR1(38,53)&
   +2D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))&
   +2D0*HfxZpE*VS1(22,53)
VS0(38,79)=QCz*VS0(38,51)+WQz*VS1(38,51)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))
VS0(38,80)=QCz*VS0(38,52)+WQz*VS1(38,52)&
   +3D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))
VS0(38,81)=QCz*VS0(38,53)+WQz*VS1(38,53)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))
VS0(38,82)=QCz*VS0(38,54)+WQz*VS1(38,54)&
   +4D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))
VS0(38,83)=QCz*VS0(38,55)+WQz*VS1(38,55)&
   +4D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))
VS0(38,84)=QCz*VS0(38,56)+WQz*VS1(38,56)&
   +5D0*r1x2E*(VS0(38,35)-ZxZpE*VS1(38,35))
VS0(39,57)=QCx*VS0(39,36)+WQx*VS1(39,36)&
   +5D0*r1x2E*(VS0(39,21)-ZxZpE*VS1(39,21))&
   +2D0*HfxZpE*VS1(24,36)
VS0(39,58)=QCx*VS0(39,37)+WQx*VS1(39,37)&
   +4D0*r1x2E*(VS0(39,22)-ZxZpE*VS1(39,22))&
   +2D0*HfxZpE*VS1(24,37)
VS0(39,59)=QCx*VS0(39,38)+WQx*VS1(39,38)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +2D0*HfxZpE*VS1(24,38)
VS0(39,60)=QCx*VS0(39,39)+WQx*VS1(39,39)&
   +2D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +2D0*HfxZpE*VS1(24,39)
VS0(39,61)=QCy*VS0(39,39)+WQy*VS1(39,39)-r1x2E*VR1(39,39)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +3D0*HfxZpE*VS1(23,39)
VS0(39,62)=QCy*VS0(39,40)+WQy*VS1(39,40)-r1x2E*VR1(39,40)&
   +4D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +3D0*HfxZpE*VS1(23,40)
VS0(39,63)=QCy*VS0(39,41)+WQy*VS1(39,41)-r1x2E*VR1(39,41)&
   +5D0*r1x2E*(VS0(39,25)-ZxZpE*VS1(39,25))&
   +3D0*HfxZpE*VS1(23,41)
VS0(39,64)=QCx*VS0(39,42)+WQx*VS1(39,42)&
   +4D0*r1x2E*(VS0(39,26)-ZxZpE*VS1(39,26))&
   +2D0*HfxZpE*VS1(24,42)
VS0(39,65)=QCx*VS0(39,43)+WQx*VS1(39,43)&
   +3D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +2D0*HfxZpE*VS1(24,43)
VS0(39,66)=QCx*VS0(39,44)+WQx*VS1(39,44)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +2D0*HfxZpE*VS1(24,44)
VS0(39,67)=QCy*VS0(39,44)+WQy*VS1(39,44)-r1x2E*VR1(39,44)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +3D0*HfxZpE*VS1(23,44)
VS0(39,68)=QCy*VS0(39,45)+WQy*VS1(39,45)-r1x2E*VR1(39,45)&
   +3D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +3D0*HfxZpE*VS1(23,45)
VS0(39,69)=QCy*VS0(39,46)+WQy*VS1(39,46)-r1x2E*VR1(39,46)&
   +4D0*r1x2E*(VS0(39,29)-ZxZpE*VS1(39,29))&
   +3D0*HfxZpE*VS1(23,46)
VS0(39,70)=QCx*VS0(39,47)+WQx*VS1(39,47)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))&
   +2D0*HfxZpE*VS1(24,47)
VS0(39,71)=QCx*VS0(39,48)+WQx*VS1(39,48)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +2D0*HfxZpE*VS1(24,48)
VS0(39,72)=QCx*VS0(39,49)+WQx*VS1(39,49)&
   +r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +2D0*HfxZpE*VS1(24,49)
VS0(39,73)=QCy*VS0(39,49)+WQy*VS1(39,49)-r1x2E*VR1(39,49)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +3D0*HfxZpE*VS1(23,49)
VS0(39,74)=QCy*VS0(39,50)+WQy*VS1(39,50)-r1x2E*VR1(39,50)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +3D0*HfxZpE*VS1(23,50)
VS0(39,75)=QCx*VS0(39,51)+WQx*VS1(39,51)&
   +2D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))&
   +2D0*HfxZpE*VS1(24,51)
VS0(39,76)=QCz*VS0(39,48)+WQz*VS1(39,48)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))
VS0(39,77)=QCz*VS0(39,49)+WQz*VS1(39,49)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))
VS0(39,78)=QCy*VS0(39,53)+WQy*VS1(39,53)-r1x2E*VR1(39,53)&
   +2D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))&
   +3D0*HfxZpE*VS1(23,53)
VS0(39,79)=QCz*VS0(39,51)+WQz*VS1(39,51)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))
VS0(39,80)=QCz*VS0(39,52)+WQz*VS1(39,52)&
   +3D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))
VS0(39,81)=QCz*VS0(39,53)+WQz*VS1(39,53)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))
VS0(39,82)=QCz*VS0(39,54)+WQz*VS1(39,54)&
   +4D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))
VS0(39,83)=QCz*VS0(39,55)+WQz*VS1(39,55)&
   +4D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))
VS0(39,84)=QCz*VS0(39,56)+WQz*VS1(39,56)&
   +5D0*r1x2E*(VS0(39,35)-ZxZpE*VS1(39,35))
VS0(40,57)=QCx*VS0(40,36)+WQx*VS1(40,36)&
   +5D0*r1x2E*(VS0(40,21)-ZxZpE*VS1(40,21))&
   +HfxZpE*VS1(25,36)
VS0(40,58)=QCx*VS0(40,37)+WQx*VS1(40,37)&
   +4D0*r1x2E*(VS0(40,22)-ZxZpE*VS1(40,22))&
   +HfxZpE*VS1(25,37)
VS0(40,59)=QCx*VS0(40,38)+WQx*VS1(40,38)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +HfxZpE*VS1(25,38)
VS0(40,60)=QCx*VS0(40,39)+WQx*VS1(40,39)&
   +2D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +HfxZpE*VS1(25,39)
VS0(40,61)=QCy*VS0(40,39)+WQy*VS1(40,39)-r1x2E*VR1(40,39)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +4D0*HfxZpE*VS1(24,39)
VS0(40,62)=QCy*VS0(40,40)+WQy*VS1(40,40)-r1x2E*VR1(40,40)&
   +4D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +4D0*HfxZpE*VS1(24,40)
VS0(40,63)=QCy*VS0(40,41)+WQy*VS1(40,41)-r1x2E*VR1(40,41)&
   +5D0*r1x2E*(VS0(40,25)-ZxZpE*VS1(40,25))&
   +4D0*HfxZpE*VS1(24,41)
VS0(40,64)=QCx*VS0(40,42)+WQx*VS1(40,42)&
   +4D0*r1x2E*(VS0(40,26)-ZxZpE*VS1(40,26))&
   +HfxZpE*VS1(25,42)
VS0(40,65)=QCx*VS0(40,43)+WQx*VS1(40,43)&
   +3D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +HfxZpE*VS1(25,43)
VS0(40,66)=QCx*VS0(40,44)+WQx*VS1(40,44)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +HfxZpE*VS1(25,44)
VS0(40,67)=QCy*VS0(40,44)+WQy*VS1(40,44)-r1x2E*VR1(40,44)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +4D0*HfxZpE*VS1(24,44)
VS0(40,68)=QCy*VS0(40,45)+WQy*VS1(40,45)-r1x2E*VR1(40,45)&
   +3D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +4D0*HfxZpE*VS1(24,45)
VS0(40,69)=QCy*VS0(40,46)+WQy*VS1(40,46)-r1x2E*VR1(40,46)&
   +4D0*r1x2E*(VS0(40,29)-ZxZpE*VS1(40,29))&
   +4D0*HfxZpE*VS1(24,46)
VS0(40,70)=QCx*VS0(40,47)+WQx*VS1(40,47)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))&
   +HfxZpE*VS1(25,47)
VS0(40,71)=QCx*VS0(40,48)+WQx*VS1(40,48)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +HfxZpE*VS1(25,48)
VS0(40,72)=QCx*VS0(40,49)+WQx*VS1(40,49)&
   +r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +HfxZpE*VS1(25,49)
VS0(40,73)=QCy*VS0(40,49)+WQy*VS1(40,49)-r1x2E*VR1(40,49)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +4D0*HfxZpE*VS1(24,49)
VS0(40,74)=QCy*VS0(40,50)+WQy*VS1(40,50)-r1x2E*VR1(40,50)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +4D0*HfxZpE*VS1(24,50)
VS0(40,75)=QCx*VS0(40,51)+WQx*VS1(40,51)&
   +2D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))&
   +HfxZpE*VS1(25,51)
VS0(40,76)=QCz*VS0(40,48)+WQz*VS1(40,48)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))
VS0(40,77)=QCz*VS0(40,49)+WQz*VS1(40,49)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))
VS0(40,78)=QCy*VS0(40,53)+WQy*VS1(40,53)-r1x2E*VR1(40,53)&
   +2D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))&
   +4D0*HfxZpE*VS1(24,53)
VS0(40,79)=QCz*VS0(40,51)+WQz*VS1(40,51)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))
VS0(40,80)=QCz*VS0(40,52)+WQz*VS1(40,52)&
   +3D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))
VS0(40,81)=QCz*VS0(40,53)+WQz*VS1(40,53)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))
VS0(40,82)=QCz*VS0(40,54)+WQz*VS1(40,54)&
   +4D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))
VS0(40,83)=QCz*VS0(40,55)+WQz*VS1(40,55)&
   +4D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))
VS0(40,84)=QCz*VS0(40,56)+WQz*VS1(40,56)&
   +5D0*r1x2E*(VS0(40,35)-ZxZpE*VS1(40,35))
VS0(41,57)=QCx*VS0(41,36)+WQx*VS1(41,36)&
   +5D0*r1x2E*(VS0(41,21)-ZxZpE*VS1(41,21))
VS0(41,58)=QCx*VS0(41,37)+WQx*VS1(41,37)&
   +4D0*r1x2E*(VS0(41,22)-ZxZpE*VS1(41,22))
VS0(41,59)=QCx*VS0(41,38)+WQx*VS1(41,38)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))
VS0(41,60)=QCx*VS0(41,39)+WQx*VS1(41,39)&
   +2D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))
VS0(41,61)=QCy*VS0(41,39)+WQy*VS1(41,39)-r1x2E*VR1(41,39)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))&
   +5D0*HfxZpE*VS1(25,39)
VS0(41,62)=QCy*VS0(41,40)+WQy*VS1(41,40)-r1x2E*VR1(41,40)&
   +4D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))&
   +5D0*HfxZpE*VS1(25,40)
VS0(41,63)=QCy*VS0(41,41)+WQy*VS1(41,41)-r1x2E*VR1(41,41)&
   +5D0*r1x2E*(VS0(41,25)-ZxZpE*VS1(41,25))&
   +5D0*HfxZpE*VS1(25,41)
VS0(41,64)=QCx*VS0(41,42)+WQx*VS1(41,42)&
   +4D0*r1x2E*(VS0(41,26)-ZxZpE*VS1(41,26))
VS0(41,65)=QCx*VS0(41,43)+WQx*VS1(41,43)&
   +3D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,66)=QCx*VS0(41,44)+WQx*VS1(41,44)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,67)=QCy*VS0(41,44)+WQy*VS1(41,44)-r1x2E*VR1(41,44)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))&
   +5D0*HfxZpE*VS1(25,44)
VS0(41,68)=QCy*VS0(41,45)+WQy*VS1(41,45)-r1x2E*VR1(41,45)&
   +3D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))&
   +5D0*HfxZpE*VS1(25,45)
VS0(41,69)=QCy*VS0(41,46)+WQy*VS1(41,46)-r1x2E*VR1(41,46)&
   +4D0*r1x2E*(VS0(41,29)-ZxZpE*VS1(41,29))&
   +5D0*HfxZpE*VS1(25,46)
VS0(41,70)=QCx*VS0(41,47)+WQx*VS1(41,47)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,71)=QCx*VS0(41,48)+WQx*VS1(41,48)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,72)=QCx*VS0(41,49)+WQx*VS1(41,49)&
   +r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,73)=QCy*VS0(41,49)+WQy*VS1(41,49)-r1x2E*VR1(41,49)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))&
   +5D0*HfxZpE*VS1(25,49)
VS0(41,74)=QCy*VS0(41,50)+WQy*VS1(41,50)-r1x2E*VR1(41,50)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))&
   +5D0*HfxZpE*VS1(25,50)
VS0(41,75)=QCx*VS0(41,51)+WQx*VS1(41,51)&
   +2D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,76)=QCz*VS0(41,48)+WQz*VS1(41,48)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,77)=QCz*VS0(41,49)+WQz*VS1(41,49)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,78)=QCy*VS0(41,53)+WQy*VS1(41,53)-r1x2E*VR1(41,53)&
   +2D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))&
   +5D0*HfxZpE*VS1(25,53)
VS0(41,79)=QCz*VS0(41,51)+WQz*VS1(41,51)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,80)=QCz*VS0(41,52)+WQz*VS1(41,52)&
   +3D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,81)=QCz*VS0(41,53)+WQz*VS1(41,53)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,82)=QCz*VS0(41,54)+WQz*VS1(41,54)&
   +4D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,83)=QCz*VS0(41,55)+WQz*VS1(41,55)&
   +4D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))
VS0(41,84)=QCz*VS0(41,56)+WQz*VS1(41,56)&
   +5D0*r1x2E*(VS0(41,35)-ZxZpE*VS1(41,35))
VS0(42,57)=QCx*VS0(42,36)+WQx*VS1(42,36)&
   +5D0*r1x2E*(VS0(42,21)-ZxZpE*VS1(42,21))&
   +4D0*HfxZpE*VS1(26,36)
VS0(42,58)=QCx*VS0(42,37)+WQx*VS1(42,37)&
   +4D0*r1x2E*(VS0(42,22)-ZxZpE*VS1(42,22))&
   +4D0*HfxZpE*VS1(26,37)
VS0(42,59)=QCx*VS0(42,38)+WQx*VS1(42,38)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))&
   +4D0*HfxZpE*VS1(26,38)
VS0(42,60)=QCx*VS0(42,39)+WQx*VS1(42,39)&
   +2D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))&
   +4D0*HfxZpE*VS1(26,39)
VS0(42,61)=QCy*VS0(42,39)+WQy*VS1(42,39)-r1x2E*VR1(42,39)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))
VS0(42,62)=QCy*VS0(42,40)+WQy*VS1(42,40)-r1x2E*VR1(42,40)&
   +4D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))
VS0(42,63)=QCy*VS0(42,41)+WQy*VS1(42,41)-r1x2E*VR1(42,41)&
   +5D0*r1x2E*(VS0(42,25)-ZxZpE*VS1(42,25))
VS0(42,64)=QCx*VS0(42,42)+WQx*VS1(42,42)&
   +4D0*r1x2E*(VS0(42,26)-ZxZpE*VS1(42,26))&
   +4D0*HfxZpE*VS1(26,42)
VS0(42,65)=QCx*VS0(42,43)+WQx*VS1(42,43)&
   +3D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +4D0*HfxZpE*VS1(26,43)
VS0(42,66)=QCx*VS0(42,44)+WQx*VS1(42,44)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +4D0*HfxZpE*VS1(26,44)
VS0(42,67)=QCy*VS0(42,44)+WQy*VS1(42,44)-r1x2E*VR1(42,44)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))
VS0(42,68)=QCy*VS0(42,45)+WQy*VS1(42,45)-r1x2E*VR1(42,45)&
   +3D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))
VS0(42,69)=QCy*VS0(42,46)+WQy*VS1(42,46)-r1x2E*VR1(42,46)&
   +4D0*r1x2E*(VS0(42,29)-ZxZpE*VS1(42,29))
VS0(42,70)=QCx*VS0(42,47)+WQx*VS1(42,47)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +4D0*HfxZpE*VS1(26,47)
VS0(42,71)=QCx*VS0(42,48)+WQx*VS1(42,48)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +4D0*HfxZpE*VS1(26,48)
VS0(42,72)=QCx*VS0(42,49)+WQx*VS1(42,49)&
   +r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +4D0*HfxZpE*VS1(26,49)
VS0(42,73)=QCy*VS0(42,49)+WQy*VS1(42,49)-r1x2E*VR1(42,49)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))
VS0(42,74)=QCy*VS0(42,50)+WQy*VS1(42,50)-r1x2E*VR1(42,50)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))
VS0(42,75)=QCx*VS0(42,51)+WQx*VS1(42,51)&
   +2D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +4D0*HfxZpE*VS1(26,51)
VS0(42,76)=QCz*VS0(42,48)+WQz*VS1(42,48)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +HfxZpE*VS1(21,48)
VS0(42,77)=QCz*VS0(42,49)+WQz*VS1(42,49)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +HfxZpE*VS1(21,49)
VS0(42,78)=QCy*VS0(42,53)+WQy*VS1(42,53)-r1x2E*VR1(42,53)&
   +2D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))
VS0(42,79)=QCz*VS0(42,51)+WQz*VS1(42,51)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +HfxZpE*VS1(21,51)
VS0(42,80)=QCz*VS0(42,52)+WQz*VS1(42,52)&
   +3D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +HfxZpE*VS1(21,52)
VS0(42,81)=QCz*VS0(42,53)+WQz*VS1(42,53)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +HfxZpE*VS1(21,53)
VS0(42,82)=QCz*VS0(42,54)+WQz*VS1(42,54)&
   +4D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +HfxZpE*VS1(21,54)
VS0(42,83)=QCz*VS0(42,55)+WQz*VS1(42,55)&
   +4D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))&
   +HfxZpE*VS1(21,55)
VS0(42,84)=QCz*VS0(42,56)+WQz*VS1(42,56)&
   +5D0*r1x2E*(VS0(42,35)-ZxZpE*VS1(42,35))&
   +HfxZpE*VS1(21,56)
VS0(43,57)=QCx*VS0(43,36)+WQx*VS1(43,36)&
   +5D0*r1x2E*(VS0(43,21)-ZxZpE*VS1(43,21))&
   +3D0*HfxZpE*VS1(27,36)
VS0(43,58)=QCx*VS0(43,37)+WQx*VS1(43,37)&
   +4D0*r1x2E*(VS0(43,22)-ZxZpE*VS1(43,22))&
   +3D0*HfxZpE*VS1(27,37)
VS0(43,59)=QCx*VS0(43,38)+WQx*VS1(43,38)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +3D0*HfxZpE*VS1(27,38)
VS0(43,60)=QCx*VS0(43,39)+WQx*VS1(43,39)&
   +2D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +3D0*HfxZpE*VS1(27,39)
VS0(43,61)=QCy*VS0(43,39)+WQy*VS1(43,39)-r1x2E*VR1(43,39)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +HfxZpE*VS1(26,39)
VS0(43,62)=QCy*VS0(43,40)+WQy*VS1(43,40)-r1x2E*VR1(43,40)&
   +4D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +HfxZpE*VS1(26,40)
VS0(43,63)=QCy*VS0(43,41)+WQy*VS1(43,41)-r1x2E*VR1(43,41)&
   +5D0*r1x2E*(VS0(43,25)-ZxZpE*VS1(43,25))&
   +HfxZpE*VS1(26,41)
VS0(43,64)=QCx*VS0(43,42)+WQx*VS1(43,42)&
   +4D0*r1x2E*(VS0(43,26)-ZxZpE*VS1(43,26))&
   +3D0*HfxZpE*VS1(27,42)
VS0(43,65)=QCx*VS0(43,43)+WQx*VS1(43,43)&
   +3D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +3D0*HfxZpE*VS1(27,43)
VS0(43,66)=QCx*VS0(43,44)+WQx*VS1(43,44)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +3D0*HfxZpE*VS1(27,44)
VS0(43,67)=QCy*VS0(43,44)+WQy*VS1(43,44)-r1x2E*VR1(43,44)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(26,44)
VS0(43,68)=QCy*VS0(43,45)+WQy*VS1(43,45)-r1x2E*VR1(43,45)&
   +3D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(26,45)
VS0(43,69)=QCy*VS0(43,46)+WQy*VS1(43,46)-r1x2E*VR1(43,46)&
   +4D0*r1x2E*(VS0(43,29)-ZxZpE*VS1(43,29))&
   +HfxZpE*VS1(26,46)
VS0(43,70)=QCx*VS0(43,47)+WQx*VS1(43,47)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +3D0*HfxZpE*VS1(27,47)
VS0(43,71)=QCx*VS0(43,48)+WQx*VS1(43,48)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +3D0*HfxZpE*VS1(27,48)
VS0(43,72)=QCx*VS0(43,49)+WQx*VS1(43,49)&
   +r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +3D0*HfxZpE*VS1(27,49)
VS0(43,73)=QCy*VS0(43,49)+WQy*VS1(43,49)-r1x2E*VR1(43,49)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(26,49)
VS0(43,74)=QCy*VS0(43,50)+WQy*VS1(43,50)-r1x2E*VR1(43,50)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(26,50)
VS0(43,75)=QCx*VS0(43,51)+WQx*VS1(43,51)&
   +2D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +3D0*HfxZpE*VS1(27,51)
VS0(43,76)=QCz*VS0(43,48)+WQz*VS1(43,48)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(22,48)
VS0(43,77)=QCz*VS0(43,49)+WQz*VS1(43,49)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(22,49)
VS0(43,78)=QCy*VS0(43,53)+WQy*VS1(43,53)-r1x2E*VR1(43,53)&
   +2D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(26,53)
VS0(43,79)=QCz*VS0(43,51)+WQz*VS1(43,51)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +HfxZpE*VS1(22,51)
VS0(43,80)=QCz*VS0(43,52)+WQz*VS1(43,52)&
   +3D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(22,52)
VS0(43,81)=QCz*VS0(43,53)+WQz*VS1(43,53)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(22,53)
VS0(43,82)=QCz*VS0(43,54)+WQz*VS1(43,54)&
   +4D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +HfxZpE*VS1(22,54)
VS0(43,83)=QCz*VS0(43,55)+WQz*VS1(43,55)&
   +4D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(22,55)
VS0(43,84)=QCz*VS0(43,56)+WQz*VS1(43,56)&
   +5D0*r1x2E*(VS0(43,35)-ZxZpE*VS1(43,35))&
   +HfxZpE*VS1(22,56)
VS0(44,57)=QCx*VS0(44,36)+WQx*VS1(44,36)&
   +5D0*r1x2E*(VS0(44,21)-ZxZpE*VS1(44,21))&
   +2D0*HfxZpE*VS1(28,36)
VS0(44,58)=QCx*VS0(44,37)+WQx*VS1(44,37)&
   +4D0*r1x2E*(VS0(44,22)-ZxZpE*VS1(44,22))&
   +2D0*HfxZpE*VS1(28,37)
VS0(44,59)=QCx*VS0(44,38)+WQx*VS1(44,38)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(28,38)
VS0(44,60)=QCx*VS0(44,39)+WQx*VS1(44,39)&
   +2D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(28,39)
VS0(44,61)=QCy*VS0(44,39)+WQy*VS1(44,39)-r1x2E*VR1(44,39)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(27,39)
VS0(44,62)=QCy*VS0(44,40)+WQy*VS1(44,40)-r1x2E*VR1(44,40)&
   +4D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(27,40)
VS0(44,63)=QCy*VS0(44,41)+WQy*VS1(44,41)-r1x2E*VR1(44,41)&
   +5D0*r1x2E*(VS0(44,25)-ZxZpE*VS1(44,25))&
   +2D0*HfxZpE*VS1(27,41)
VS0(44,64)=QCx*VS0(44,42)+WQx*VS1(44,42)&
   +4D0*r1x2E*(VS0(44,26)-ZxZpE*VS1(44,26))&
   +2D0*HfxZpE*VS1(28,42)
VS0(44,65)=QCx*VS0(44,43)+WQx*VS1(44,43)&
   +3D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(28,43)
VS0(44,66)=QCx*VS0(44,44)+WQx*VS1(44,44)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(28,44)
VS0(44,67)=QCy*VS0(44,44)+WQy*VS1(44,44)-r1x2E*VR1(44,44)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(27,44)
VS0(44,68)=QCy*VS0(44,45)+WQy*VS1(44,45)-r1x2E*VR1(44,45)&
   +3D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(27,45)
VS0(44,69)=QCy*VS0(44,46)+WQy*VS1(44,46)-r1x2E*VR1(44,46)&
   +4D0*r1x2E*(VS0(44,29)-ZxZpE*VS1(44,29))&
   +2D0*HfxZpE*VS1(27,46)
VS0(44,70)=QCx*VS0(44,47)+WQx*VS1(44,47)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +2D0*HfxZpE*VS1(28,47)
VS0(44,71)=QCx*VS0(44,48)+WQx*VS1(44,48)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(28,48)
VS0(44,72)=QCx*VS0(44,49)+WQx*VS1(44,49)&
   +r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(28,49)
VS0(44,73)=QCy*VS0(44,49)+WQy*VS1(44,49)-r1x2E*VR1(44,49)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(27,49)
VS0(44,74)=QCy*VS0(44,50)+WQy*VS1(44,50)-r1x2E*VR1(44,50)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(27,50)
VS0(44,75)=QCx*VS0(44,51)+WQx*VS1(44,51)&
   +2D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +2D0*HfxZpE*VS1(28,51)
VS0(44,76)=QCz*VS0(44,48)+WQz*VS1(44,48)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +HfxZpE*VS1(23,48)
VS0(44,77)=QCz*VS0(44,49)+WQz*VS1(44,49)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +HfxZpE*VS1(23,49)
VS0(44,78)=QCy*VS0(44,53)+WQy*VS1(44,53)-r1x2E*VR1(44,53)&
   +2D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +2D0*HfxZpE*VS1(27,53)
VS0(44,79)=QCz*VS0(44,51)+WQz*VS1(44,51)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +HfxZpE*VS1(23,51)
VS0(44,80)=QCz*VS0(44,52)+WQz*VS1(44,52)&
   +3D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +HfxZpE*VS1(23,52)
VS0(44,81)=QCz*VS0(44,53)+WQz*VS1(44,53)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +HfxZpE*VS1(23,53)
VS0(44,82)=QCz*VS0(44,54)+WQz*VS1(44,54)&
   +4D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +HfxZpE*VS1(23,54)
VS0(44,83)=QCz*VS0(44,55)+WQz*VS1(44,55)&
   +4D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +HfxZpE*VS1(23,55)
VS0(44,84)=QCz*VS0(44,56)+WQz*VS1(44,56)&
   +5D0*r1x2E*(VS0(44,35)-ZxZpE*VS1(44,35))&
   +HfxZpE*VS1(23,56)
VS0(45,57)=QCx*VS0(45,36)+WQx*VS1(45,36)&
   +5D0*r1x2E*(VS0(45,21)-ZxZpE*VS1(45,21))&
   +HfxZpE*VS1(29,36)
VS0(45,58)=QCx*VS0(45,37)+WQx*VS1(45,37)&
   +4D0*r1x2E*(VS0(45,22)-ZxZpE*VS1(45,22))&
   +HfxZpE*VS1(29,37)
VS0(45,59)=QCx*VS0(45,38)+WQx*VS1(45,38)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +HfxZpE*VS1(29,38)
VS0(45,60)=QCx*VS0(45,39)+WQx*VS1(45,39)&
   +2D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +HfxZpE*VS1(29,39)
VS0(45,61)=QCy*VS0(45,39)+WQy*VS1(45,39)-r1x2E*VR1(45,39)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +3D0*HfxZpE*VS1(28,39)
VS0(45,62)=QCy*VS0(45,40)+WQy*VS1(45,40)-r1x2E*VR1(45,40)&
   +4D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +3D0*HfxZpE*VS1(28,40)
VS0(45,63)=QCy*VS0(45,41)+WQy*VS1(45,41)-r1x2E*VR1(45,41)&
   +5D0*r1x2E*(VS0(45,25)-ZxZpE*VS1(45,25))&
   +3D0*HfxZpE*VS1(28,41)
VS0(45,64)=QCx*VS0(45,42)+WQx*VS1(45,42)&
   +4D0*r1x2E*(VS0(45,26)-ZxZpE*VS1(45,26))&
   +HfxZpE*VS1(29,42)
VS0(45,65)=QCx*VS0(45,43)+WQx*VS1(45,43)&
   +3D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(29,43)
VS0(45,66)=QCx*VS0(45,44)+WQx*VS1(45,44)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(29,44)
VS0(45,67)=QCy*VS0(45,44)+WQy*VS1(45,44)-r1x2E*VR1(45,44)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +3D0*HfxZpE*VS1(28,44)
VS0(45,68)=QCy*VS0(45,45)+WQy*VS1(45,45)-r1x2E*VR1(45,45)&
   +3D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +3D0*HfxZpE*VS1(28,45)
VS0(45,69)=QCy*VS0(45,46)+WQy*VS1(45,46)-r1x2E*VR1(45,46)&
   +4D0*r1x2E*(VS0(45,29)-ZxZpE*VS1(45,29))&
   +3D0*HfxZpE*VS1(28,46)
VS0(45,70)=QCx*VS0(45,47)+WQx*VS1(45,47)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(29,47)
VS0(45,71)=QCx*VS0(45,48)+WQx*VS1(45,48)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(29,48)
VS0(45,72)=QCx*VS0(45,49)+WQx*VS1(45,49)&
   +r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(29,49)
VS0(45,73)=QCy*VS0(45,49)+WQy*VS1(45,49)-r1x2E*VR1(45,49)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +3D0*HfxZpE*VS1(28,49)
VS0(45,74)=QCy*VS0(45,50)+WQy*VS1(45,50)-r1x2E*VR1(45,50)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +3D0*HfxZpE*VS1(28,50)
VS0(45,75)=QCx*VS0(45,51)+WQx*VS1(45,51)&
   +2D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(29,51)
VS0(45,76)=QCz*VS0(45,48)+WQz*VS1(45,48)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(24,48)
VS0(45,77)=QCz*VS0(45,49)+WQz*VS1(45,49)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(24,49)
VS0(45,78)=QCy*VS0(45,53)+WQy*VS1(45,53)-r1x2E*VR1(45,53)&
   +2D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +3D0*HfxZpE*VS1(28,53)
VS0(45,79)=QCz*VS0(45,51)+WQz*VS1(45,51)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(24,51)
VS0(45,80)=QCz*VS0(45,52)+WQz*VS1(45,52)&
   +3D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(24,52)
VS0(45,81)=QCz*VS0(45,53)+WQz*VS1(45,53)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(24,53)
VS0(45,82)=QCz*VS0(45,54)+WQz*VS1(45,54)&
   +4D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(24,54)
VS0(45,83)=QCz*VS0(45,55)+WQz*VS1(45,55)&
   +4D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +HfxZpE*VS1(24,55)
VS0(45,84)=QCz*VS0(45,56)+WQz*VS1(45,56)&
   +5D0*r1x2E*(VS0(45,35)-ZxZpE*VS1(45,35))&
   +HfxZpE*VS1(24,56)
VS0(46,57)=QCx*VS0(46,36)+WQx*VS1(46,36)&
   +5D0*r1x2E*(VS0(46,21)-ZxZpE*VS1(46,21))
VS0(46,58)=QCx*VS0(46,37)+WQx*VS1(46,37)&
   +4D0*r1x2E*(VS0(46,22)-ZxZpE*VS1(46,22))
VS0(46,59)=QCx*VS0(46,38)+WQx*VS1(46,38)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))
VS0(46,60)=QCx*VS0(46,39)+WQx*VS1(46,39)&
   +2D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))
VS0(46,61)=QCy*VS0(46,39)+WQy*VS1(46,39)-r1x2E*VR1(46,39)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))&
   +4D0*HfxZpE*VS1(29,39)
VS0(46,62)=QCy*VS0(46,40)+WQy*VS1(46,40)-r1x2E*VR1(46,40)&
   +4D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))&
   +4D0*HfxZpE*VS1(29,40)
VS0(46,63)=QCy*VS0(46,41)+WQy*VS1(46,41)-r1x2E*VR1(46,41)&
   +5D0*r1x2E*(VS0(46,25)-ZxZpE*VS1(46,25))&
   +4D0*HfxZpE*VS1(29,41)
VS0(46,64)=QCx*VS0(46,42)+WQx*VS1(46,42)&
   +4D0*r1x2E*(VS0(46,26)-ZxZpE*VS1(46,26))
VS0(46,65)=QCx*VS0(46,43)+WQx*VS1(46,43)&
   +3D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))
VS0(46,66)=QCx*VS0(46,44)+WQx*VS1(46,44)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))
VS0(46,67)=QCy*VS0(46,44)+WQy*VS1(46,44)-r1x2E*VR1(46,44)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +4D0*HfxZpE*VS1(29,44)
VS0(46,68)=QCy*VS0(46,45)+WQy*VS1(46,45)-r1x2E*VR1(46,45)&
   +3D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +4D0*HfxZpE*VS1(29,45)
VS0(46,69)=QCy*VS0(46,46)+WQy*VS1(46,46)-r1x2E*VR1(46,46)&
   +4D0*r1x2E*(VS0(46,29)-ZxZpE*VS1(46,29))&
   +4D0*HfxZpE*VS1(29,46)
VS0(46,70)=QCx*VS0(46,47)+WQx*VS1(46,47)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))
VS0(46,71)=QCx*VS0(46,48)+WQx*VS1(46,48)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))
VS0(46,72)=QCx*VS0(46,49)+WQx*VS1(46,49)&
   +r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))
VS0(46,73)=QCy*VS0(46,49)+WQy*VS1(46,49)-r1x2E*VR1(46,49)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +4D0*HfxZpE*VS1(29,49)
VS0(46,74)=QCy*VS0(46,50)+WQy*VS1(46,50)-r1x2E*VR1(46,50)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +4D0*HfxZpE*VS1(29,50)
VS0(46,75)=QCx*VS0(46,51)+WQx*VS1(46,51)&
   +2D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))
VS0(46,76)=QCz*VS0(46,48)+WQz*VS1(46,48)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +HfxZpE*VS1(25,48)
VS0(46,77)=QCz*VS0(46,49)+WQz*VS1(46,49)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +HfxZpE*VS1(25,49)
VS0(46,78)=QCy*VS0(46,53)+WQy*VS1(46,53)-r1x2E*VR1(46,53)&
   +2D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +4D0*HfxZpE*VS1(29,53)
VS0(46,79)=QCz*VS0(46,51)+WQz*VS1(46,51)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))&
   +HfxZpE*VS1(25,51)
VS0(46,80)=QCz*VS0(46,52)+WQz*VS1(46,52)&
   +3D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +HfxZpE*VS1(25,52)
VS0(46,81)=QCz*VS0(46,53)+WQz*VS1(46,53)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +HfxZpE*VS1(25,53)
VS0(46,82)=QCz*VS0(46,54)+WQz*VS1(46,54)&
   +4D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))&
   +HfxZpE*VS1(25,54)
VS0(46,83)=QCz*VS0(46,55)+WQz*VS1(46,55)&
   +4D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +HfxZpE*VS1(25,55)
VS0(46,84)=QCz*VS0(46,56)+WQz*VS1(46,56)&
   +5D0*r1x2E*(VS0(46,35)-ZxZpE*VS1(46,35))&
   +HfxZpE*VS1(25,56)
VS0(47,57)=QCx*VS0(47,36)+WQx*VS1(47,36)&
   +5D0*r1x2E*(VS0(47,21)-ZxZpE*VS1(47,21))&
   +3D0*HfxZpE*VS1(30,36)
VS0(47,58)=QCx*VS0(47,37)+WQx*VS1(47,37)&
   +4D0*r1x2E*(VS0(47,22)-ZxZpE*VS1(47,22))&
   +3D0*HfxZpE*VS1(30,37)
VS0(47,59)=QCx*VS0(47,38)+WQx*VS1(47,38)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))&
   +3D0*HfxZpE*VS1(30,38)
VS0(47,60)=QCx*VS0(47,39)+WQx*VS1(47,39)&
   +2D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))&
   +3D0*HfxZpE*VS1(30,39)
VS0(47,61)=QCy*VS0(47,39)+WQy*VS1(47,39)-r1x2E*VR1(47,39)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))
VS0(47,62)=QCy*VS0(47,40)+WQy*VS1(47,40)-r1x2E*VR1(47,40)&
   +4D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))
VS0(47,63)=QCy*VS0(47,41)+WQy*VS1(47,41)-r1x2E*VR1(47,41)&
   +5D0*r1x2E*(VS0(47,25)-ZxZpE*VS1(47,25))
VS0(47,64)=QCx*VS0(47,42)+WQx*VS1(47,42)&
   +4D0*r1x2E*(VS0(47,26)-ZxZpE*VS1(47,26))&
   +3D0*HfxZpE*VS1(30,42)
VS0(47,65)=QCx*VS0(47,43)+WQx*VS1(47,43)&
   +3D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +3D0*HfxZpE*VS1(30,43)
VS0(47,66)=QCx*VS0(47,44)+WQx*VS1(47,44)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +3D0*HfxZpE*VS1(30,44)
VS0(47,67)=QCy*VS0(47,44)+WQy*VS1(47,44)-r1x2E*VR1(47,44)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))
VS0(47,68)=QCy*VS0(47,45)+WQy*VS1(47,45)-r1x2E*VR1(47,45)&
   +3D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))
VS0(47,69)=QCy*VS0(47,46)+WQy*VS1(47,46)-r1x2E*VR1(47,46)&
   +4D0*r1x2E*(VS0(47,29)-ZxZpE*VS1(47,29))
VS0(47,70)=QCx*VS0(47,47)+WQx*VS1(47,47)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +3D0*HfxZpE*VS1(30,47)
VS0(47,71)=QCx*VS0(47,48)+WQx*VS1(47,48)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +3D0*HfxZpE*VS1(30,48)
VS0(47,72)=QCx*VS0(47,49)+WQx*VS1(47,49)&
   +r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +3D0*HfxZpE*VS1(30,49)
VS0(47,73)=QCy*VS0(47,49)+WQy*VS1(47,49)-r1x2E*VR1(47,49)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))
VS0(47,74)=QCy*VS0(47,50)+WQy*VS1(47,50)-r1x2E*VR1(47,50)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))
VS0(47,75)=QCx*VS0(47,51)+WQx*VS1(47,51)&
   +2D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +3D0*HfxZpE*VS1(30,51)
VS0(47,76)=QCz*VS0(47,48)+WQz*VS1(47,48)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +2D0*HfxZpE*VS1(26,48)
VS0(47,77)=QCz*VS0(47,49)+WQz*VS1(47,49)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +2D0*HfxZpE*VS1(26,49)
VS0(47,78)=QCy*VS0(47,53)+WQy*VS1(47,53)-r1x2E*VR1(47,53)&
   +2D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))
VS0(47,79)=QCz*VS0(47,51)+WQz*VS1(47,51)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +2D0*HfxZpE*VS1(26,51)
VS0(47,80)=QCz*VS0(47,52)+WQz*VS1(47,52)&
   +3D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +2D0*HfxZpE*VS1(26,52)
VS0(47,81)=QCz*VS0(47,53)+WQz*VS1(47,53)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +2D0*HfxZpE*VS1(26,53)
VS0(47,82)=QCz*VS0(47,54)+WQz*VS1(47,54)&
   +4D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +2D0*HfxZpE*VS1(26,54)
VS0(47,83)=QCz*VS0(47,55)+WQz*VS1(47,55)&
   +4D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))&
   +2D0*HfxZpE*VS1(26,55)
VS0(47,84)=QCz*VS0(47,56)+WQz*VS1(47,56)&
   +5D0*r1x2E*(VS0(47,35)-ZxZpE*VS1(47,35))&
   +2D0*HfxZpE*VS1(26,56)
VS0(48,57)=QCx*VS0(48,36)+WQx*VS1(48,36)&
   +5D0*r1x2E*(VS0(48,21)-ZxZpE*VS1(48,21))&
   +2D0*HfxZpE*VS1(31,36)
VS0(48,58)=QCx*VS0(48,37)+WQx*VS1(48,37)&
   +4D0*r1x2E*(VS0(48,22)-ZxZpE*VS1(48,22))&
   +2D0*HfxZpE*VS1(31,37)
VS0(48,59)=QCx*VS0(48,38)+WQx*VS1(48,38)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +2D0*HfxZpE*VS1(31,38)
VS0(48,60)=QCx*VS0(48,39)+WQx*VS1(48,39)&
   +2D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +2D0*HfxZpE*VS1(31,39)
VS0(48,61)=QCy*VS0(48,39)+WQy*VS1(48,39)-r1x2E*VR1(48,39)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +HfxZpE*VS1(30,39)
VS0(48,62)=QCy*VS0(48,40)+WQy*VS1(48,40)-r1x2E*VR1(48,40)&
   +4D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +HfxZpE*VS1(30,40)
VS0(48,63)=QCy*VS0(48,41)+WQy*VS1(48,41)-r1x2E*VR1(48,41)&
   +5D0*r1x2E*(VS0(48,25)-ZxZpE*VS1(48,25))&
   +HfxZpE*VS1(30,41)
VS0(48,64)=QCx*VS0(48,42)+WQx*VS1(48,42)&
   +4D0*r1x2E*(VS0(48,26)-ZxZpE*VS1(48,26))&
   +2D0*HfxZpE*VS1(31,42)
VS0(48,65)=QCx*VS0(48,43)+WQx*VS1(48,43)&
   +3D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(31,43)
VS0(48,66)=QCx*VS0(48,44)+WQx*VS1(48,44)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(31,44)
VS0(48,67)=QCy*VS0(48,44)+WQy*VS1(48,44)-r1x2E*VR1(48,44)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +HfxZpE*VS1(30,44)
VS0(48,68)=QCy*VS0(48,45)+WQy*VS1(48,45)-r1x2E*VR1(48,45)&
   +3D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +HfxZpE*VS1(30,45)
VS0(48,69)=QCy*VS0(48,46)+WQy*VS1(48,46)-r1x2E*VR1(48,46)&
   +4D0*r1x2E*(VS0(48,29)-ZxZpE*VS1(48,29))&
   +HfxZpE*VS1(30,46)
VS0(48,70)=QCx*VS0(48,47)+WQx*VS1(48,47)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(31,47)
VS0(48,71)=QCx*VS0(48,48)+WQx*VS1(48,48)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(31,48)
VS0(48,72)=QCx*VS0(48,49)+WQx*VS1(48,49)&
   +r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(31,49)
VS0(48,73)=QCy*VS0(48,49)+WQy*VS1(48,49)-r1x2E*VR1(48,49)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +HfxZpE*VS1(30,49)
VS0(48,74)=QCy*VS0(48,50)+WQy*VS1(48,50)-r1x2E*VR1(48,50)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +HfxZpE*VS1(30,50)
VS0(48,75)=QCx*VS0(48,51)+WQx*VS1(48,51)&
   +2D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(31,51)
VS0(48,76)=QCz*VS0(48,48)+WQz*VS1(48,48)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(27,48)
VS0(48,77)=QCz*VS0(48,49)+WQz*VS1(48,49)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(27,49)
VS0(48,78)=QCy*VS0(48,53)+WQy*VS1(48,53)-r1x2E*VR1(48,53)&
   +2D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +HfxZpE*VS1(30,53)
VS0(48,79)=QCz*VS0(48,51)+WQz*VS1(48,51)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(27,51)
VS0(48,80)=QCz*VS0(48,52)+WQz*VS1(48,52)&
   +3D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(27,52)
VS0(48,81)=QCz*VS0(48,53)+WQz*VS1(48,53)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(27,53)
VS0(48,82)=QCz*VS0(48,54)+WQz*VS1(48,54)&
   +4D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(27,54)
VS0(48,83)=QCz*VS0(48,55)+WQz*VS1(48,55)&
   +4D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +2D0*HfxZpE*VS1(27,55)
VS0(48,84)=QCz*VS0(48,56)+WQz*VS1(48,56)&
   +5D0*r1x2E*(VS0(48,35)-ZxZpE*VS1(48,35))&
   +2D0*HfxZpE*VS1(27,56)
VS0(49,57)=QCx*VS0(49,36)+WQx*VS1(49,36)&
   +5D0*r1x2E*(VS0(49,21)-ZxZpE*VS1(49,21))&
   +HfxZpE*VS1(32,36)
VS0(49,58)=QCx*VS0(49,37)+WQx*VS1(49,37)&
   +4D0*r1x2E*(VS0(49,22)-ZxZpE*VS1(49,22))&
   +HfxZpE*VS1(32,37)
VS0(49,59)=QCx*VS0(49,38)+WQx*VS1(49,38)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +HfxZpE*VS1(32,38)
VS0(49,60)=QCx*VS0(49,39)+WQx*VS1(49,39)&
   +2D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +HfxZpE*VS1(32,39)
VS0(49,61)=QCy*VS0(49,39)+WQy*VS1(49,39)-r1x2E*VR1(49,39)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +2D0*HfxZpE*VS1(31,39)
VS0(49,62)=QCy*VS0(49,40)+WQy*VS1(49,40)-r1x2E*VR1(49,40)&
   +4D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +2D0*HfxZpE*VS1(31,40)
VS0(49,63)=QCy*VS0(49,41)+WQy*VS1(49,41)-r1x2E*VR1(49,41)&
   +5D0*r1x2E*(VS0(49,25)-ZxZpE*VS1(49,25))&
   +2D0*HfxZpE*VS1(31,41)
VS0(49,64)=QCx*VS0(49,42)+WQx*VS1(49,42)&
   +4D0*r1x2E*(VS0(49,26)-ZxZpE*VS1(49,26))&
   +HfxZpE*VS1(32,42)
VS0(49,65)=QCx*VS0(49,43)+WQx*VS1(49,43)&
   +3D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +HfxZpE*VS1(32,43)
VS0(49,66)=QCx*VS0(49,44)+WQx*VS1(49,44)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +HfxZpE*VS1(32,44)
VS0(49,67)=QCy*VS0(49,44)+WQy*VS1(49,44)-r1x2E*VR1(49,44)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(31,44)
VS0(49,68)=QCy*VS0(49,45)+WQy*VS1(49,45)-r1x2E*VR1(49,45)&
   +3D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(31,45)
VS0(49,69)=QCy*VS0(49,46)+WQy*VS1(49,46)-r1x2E*VR1(49,46)&
   +4D0*r1x2E*(VS0(49,29)-ZxZpE*VS1(49,29))&
   +2D0*HfxZpE*VS1(31,46)
VS0(49,70)=QCx*VS0(49,47)+WQx*VS1(49,47)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +HfxZpE*VS1(32,47)
VS0(49,71)=QCx*VS0(49,48)+WQx*VS1(49,48)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +HfxZpE*VS1(32,48)
VS0(49,72)=QCx*VS0(49,49)+WQx*VS1(49,49)&
   +r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +HfxZpE*VS1(32,49)
VS0(49,73)=QCy*VS0(49,49)+WQy*VS1(49,49)-r1x2E*VR1(49,49)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(31,49)
VS0(49,74)=QCy*VS0(49,50)+WQy*VS1(49,50)-r1x2E*VR1(49,50)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(31,50)
VS0(49,75)=QCx*VS0(49,51)+WQx*VS1(49,51)&
   +2D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +HfxZpE*VS1(32,51)
VS0(49,76)=QCz*VS0(49,48)+WQz*VS1(49,48)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(28,48)
VS0(49,77)=QCz*VS0(49,49)+WQz*VS1(49,49)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(28,49)
VS0(49,78)=QCy*VS0(49,53)+WQy*VS1(49,53)-r1x2E*VR1(49,53)&
   +2D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(31,53)
VS0(49,79)=QCz*VS0(49,51)+WQz*VS1(49,51)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +2D0*HfxZpE*VS1(28,51)
VS0(49,80)=QCz*VS0(49,52)+WQz*VS1(49,52)&
   +3D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(28,52)
VS0(49,81)=QCz*VS0(49,53)+WQz*VS1(49,53)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(28,53)
VS0(49,82)=QCz*VS0(49,54)+WQz*VS1(49,54)&
   +4D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +2D0*HfxZpE*VS1(28,54)
VS0(49,83)=QCz*VS0(49,55)+WQz*VS1(49,55)&
   +4D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(28,55)
VS0(49,84)=QCz*VS0(49,56)+WQz*VS1(49,56)&
   +5D0*r1x2E*(VS0(49,35)-ZxZpE*VS1(49,35))&
   +2D0*HfxZpE*VS1(28,56)
VS0(50,57)=QCx*VS0(50,36)+WQx*VS1(50,36)&
   +5D0*r1x2E*(VS0(50,21)-ZxZpE*VS1(50,21))
VS0(50,58)=QCx*VS0(50,37)+WQx*VS1(50,37)&
   +4D0*r1x2E*(VS0(50,22)-ZxZpE*VS1(50,22))
VS0(50,59)=QCx*VS0(50,38)+WQx*VS1(50,38)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))
VS0(50,60)=QCx*VS0(50,39)+WQx*VS1(50,39)&
   +2D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))
VS0(50,61)=QCy*VS0(50,39)+WQy*VS1(50,39)-r1x2E*VR1(50,39)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))&
   +3D0*HfxZpE*VS1(32,39)
VS0(50,62)=QCy*VS0(50,40)+WQy*VS1(50,40)-r1x2E*VR1(50,40)&
   +4D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))&
   +3D0*HfxZpE*VS1(32,40)
VS0(50,63)=QCy*VS0(50,41)+WQy*VS1(50,41)-r1x2E*VR1(50,41)&
   +5D0*r1x2E*(VS0(50,25)-ZxZpE*VS1(50,25))&
   +3D0*HfxZpE*VS1(32,41)
VS0(50,64)=QCx*VS0(50,42)+WQx*VS1(50,42)&
   +4D0*r1x2E*(VS0(50,26)-ZxZpE*VS1(50,26))
VS0(50,65)=QCx*VS0(50,43)+WQx*VS1(50,43)&
   +3D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))
VS0(50,66)=QCx*VS0(50,44)+WQx*VS1(50,44)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))
VS0(50,67)=QCy*VS0(50,44)+WQy*VS1(50,44)-r1x2E*VR1(50,44)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +3D0*HfxZpE*VS1(32,44)
VS0(50,68)=QCy*VS0(50,45)+WQy*VS1(50,45)-r1x2E*VR1(50,45)&
   +3D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +3D0*HfxZpE*VS1(32,45)
VS0(50,69)=QCy*VS0(50,46)+WQy*VS1(50,46)-r1x2E*VR1(50,46)&
   +4D0*r1x2E*(VS0(50,29)-ZxZpE*VS1(50,29))&
   +3D0*HfxZpE*VS1(32,46)
VS0(50,70)=QCx*VS0(50,47)+WQx*VS1(50,47)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))
VS0(50,71)=QCx*VS0(50,48)+WQx*VS1(50,48)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))
VS0(50,72)=QCx*VS0(50,49)+WQx*VS1(50,49)&
   +r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))
VS0(50,73)=QCy*VS0(50,49)+WQy*VS1(50,49)-r1x2E*VR1(50,49)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +3D0*HfxZpE*VS1(32,49)
VS0(50,74)=QCy*VS0(50,50)+WQy*VS1(50,50)-r1x2E*VR1(50,50)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +3D0*HfxZpE*VS1(32,50)
VS0(50,75)=QCx*VS0(50,51)+WQx*VS1(50,51)&
   +2D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))
VS0(50,76)=QCz*VS0(50,48)+WQz*VS1(50,48)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +2D0*HfxZpE*VS1(29,48)
VS0(50,77)=QCz*VS0(50,49)+WQz*VS1(50,49)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +2D0*HfxZpE*VS1(29,49)
VS0(50,78)=QCy*VS0(50,53)+WQy*VS1(50,53)-r1x2E*VR1(50,53)&
   +2D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +3D0*HfxZpE*VS1(32,53)
VS0(50,79)=QCz*VS0(50,51)+WQz*VS1(50,51)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))&
   +2D0*HfxZpE*VS1(29,51)
VS0(50,80)=QCz*VS0(50,52)+WQz*VS1(50,52)&
   +3D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +2D0*HfxZpE*VS1(29,52)
VS0(50,81)=QCz*VS0(50,53)+WQz*VS1(50,53)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +2D0*HfxZpE*VS1(29,53)
VS0(50,82)=QCz*VS0(50,54)+WQz*VS1(50,54)&
   +4D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))&
   +2D0*HfxZpE*VS1(29,54)
VS0(50,83)=QCz*VS0(50,55)+WQz*VS1(50,55)&
   +4D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +2D0*HfxZpE*VS1(29,55)
VS0(50,84)=QCz*VS0(50,56)+WQz*VS1(50,56)&
   +5D0*r1x2E*(VS0(50,35)-ZxZpE*VS1(50,35))&
   +2D0*HfxZpE*VS1(29,56)
VS0(51,57)=QCx*VS0(51,36)+WQx*VS1(51,36)&
   +5D0*r1x2E*(VS0(51,21)-ZxZpE*VS1(51,21))&
   +2D0*HfxZpE*VS1(33,36)
VS0(51,58)=QCx*VS0(51,37)+WQx*VS1(51,37)&
   +4D0*r1x2E*(VS0(51,22)-ZxZpE*VS1(51,22))&
   +2D0*HfxZpE*VS1(33,37)
VS0(51,59)=QCx*VS0(51,38)+WQx*VS1(51,38)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))&
   +2D0*HfxZpE*VS1(33,38)
VS0(51,60)=QCx*VS0(51,39)+WQx*VS1(51,39)&
   +2D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))&
   +2D0*HfxZpE*VS1(33,39)
VS0(51,61)=QCy*VS0(51,39)+WQy*VS1(51,39)-r1x2E*VR1(51,39)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))
VS0(51,62)=QCy*VS0(51,40)+WQy*VS1(51,40)-r1x2E*VR1(51,40)&
   +4D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))
VS0(51,63)=QCy*VS0(51,41)+WQy*VS1(51,41)-r1x2E*VR1(51,41)&
   +5D0*r1x2E*(VS0(51,25)-ZxZpE*VS1(51,25))
VS0(51,64)=QCx*VS0(51,42)+WQx*VS1(51,42)&
   +4D0*r1x2E*(VS0(51,26)-ZxZpE*VS1(51,26))&
   +2D0*HfxZpE*VS1(33,42)
VS0(51,65)=QCx*VS0(51,43)+WQx*VS1(51,43)&
   +3D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +2D0*HfxZpE*VS1(33,43)
VS0(51,66)=QCx*VS0(51,44)+WQx*VS1(51,44)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +2D0*HfxZpE*VS1(33,44)
VS0(51,67)=QCy*VS0(51,44)+WQy*VS1(51,44)-r1x2E*VR1(51,44)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))
VS0(51,68)=QCy*VS0(51,45)+WQy*VS1(51,45)-r1x2E*VR1(51,45)&
   +3D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))
VS0(51,69)=QCy*VS0(51,46)+WQy*VS1(51,46)-r1x2E*VR1(51,46)&
   +4D0*r1x2E*(VS0(51,29)-ZxZpE*VS1(51,29))
VS0(51,70)=QCx*VS0(51,47)+WQx*VS1(51,47)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +2D0*HfxZpE*VS1(33,47)
VS0(51,71)=QCx*VS0(51,48)+WQx*VS1(51,48)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +2D0*HfxZpE*VS1(33,48)
VS0(51,72)=QCx*VS0(51,49)+WQx*VS1(51,49)&
   +r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +2D0*HfxZpE*VS1(33,49)
VS0(51,73)=QCy*VS0(51,49)+WQy*VS1(51,49)-r1x2E*VR1(51,49)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))
VS0(51,74)=QCy*VS0(51,50)+WQy*VS1(51,50)-r1x2E*VR1(51,50)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))
VS0(51,75)=QCx*VS0(51,51)+WQx*VS1(51,51)&
   +2D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +2D0*HfxZpE*VS1(33,51)
VS0(51,76)=QCz*VS0(51,48)+WQz*VS1(51,48)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +3D0*HfxZpE*VS1(30,48)
VS0(51,77)=QCz*VS0(51,49)+WQz*VS1(51,49)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +3D0*HfxZpE*VS1(30,49)
VS0(51,78)=QCy*VS0(51,53)+WQy*VS1(51,53)-r1x2E*VR1(51,53)&
   +2D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))
VS0(51,79)=QCz*VS0(51,51)+WQz*VS1(51,51)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +3D0*HfxZpE*VS1(30,51)
VS0(51,80)=QCz*VS0(51,52)+WQz*VS1(51,52)&
   +3D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +3D0*HfxZpE*VS1(30,52)
VS0(51,81)=QCz*VS0(51,53)+WQz*VS1(51,53)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +3D0*HfxZpE*VS1(30,53)
VS0(51,82)=QCz*VS0(51,54)+WQz*VS1(51,54)&
   +4D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +3D0*HfxZpE*VS1(30,54)
VS0(51,83)=QCz*VS0(51,55)+WQz*VS1(51,55)&
   +4D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))&
   +3D0*HfxZpE*VS1(30,55)
VS0(51,84)=QCz*VS0(51,56)+WQz*VS1(51,56)&
   +5D0*r1x2E*(VS0(51,35)-ZxZpE*VS1(51,35))&
   +3D0*HfxZpE*VS1(30,56)
VS0(52,57)=QCx*VS0(52,36)+WQx*VS1(52,36)&
   +5D0*r1x2E*(VS0(52,21)-ZxZpE*VS1(52,21))&
   +HfxZpE*VS1(34,36)
VS0(52,58)=QCx*VS0(52,37)+WQx*VS1(52,37)&
   +4D0*r1x2E*(VS0(52,22)-ZxZpE*VS1(52,22))&
   +HfxZpE*VS1(34,37)
VS0(52,59)=QCx*VS0(52,38)+WQx*VS1(52,38)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(34,38)
VS0(52,60)=QCx*VS0(52,39)+WQx*VS1(52,39)&
   +2D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(34,39)
VS0(52,61)=QCy*VS0(52,39)+WQy*VS1(52,39)-r1x2E*VR1(52,39)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(33,39)
VS0(52,62)=QCy*VS0(52,40)+WQy*VS1(52,40)-r1x2E*VR1(52,40)&
   +4D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(33,40)
VS0(52,63)=QCy*VS0(52,41)+WQy*VS1(52,41)-r1x2E*VR1(52,41)&
   +5D0*r1x2E*(VS0(52,25)-ZxZpE*VS1(52,25))&
   +HfxZpE*VS1(33,41)
VS0(52,64)=QCx*VS0(52,42)+WQx*VS1(52,42)&
   +4D0*r1x2E*(VS0(52,26)-ZxZpE*VS1(52,26))&
   +HfxZpE*VS1(34,42)
VS0(52,65)=QCx*VS0(52,43)+WQx*VS1(52,43)&
   +3D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(34,43)
VS0(52,66)=QCx*VS0(52,44)+WQx*VS1(52,44)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(34,44)
VS0(52,67)=QCy*VS0(52,44)+WQy*VS1(52,44)-r1x2E*VR1(52,44)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(33,44)
VS0(52,68)=QCy*VS0(52,45)+WQy*VS1(52,45)-r1x2E*VR1(52,45)&
   +3D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(33,45)
VS0(52,69)=QCy*VS0(52,46)+WQy*VS1(52,46)-r1x2E*VR1(52,46)&
   +4D0*r1x2E*(VS0(52,29)-ZxZpE*VS1(52,29))&
   +HfxZpE*VS1(33,46)
VS0(52,70)=QCx*VS0(52,47)+WQx*VS1(52,47)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +HfxZpE*VS1(34,47)
VS0(52,71)=QCx*VS0(52,48)+WQx*VS1(52,48)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(34,48)
VS0(52,72)=QCx*VS0(52,49)+WQx*VS1(52,49)&
   +r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(34,49)
VS0(52,73)=QCy*VS0(52,49)+WQy*VS1(52,49)-r1x2E*VR1(52,49)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(33,49)
VS0(52,74)=QCy*VS0(52,50)+WQy*VS1(52,50)-r1x2E*VR1(52,50)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(33,50)
VS0(52,75)=QCx*VS0(52,51)+WQx*VS1(52,51)&
   +2D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +HfxZpE*VS1(34,51)
VS0(52,76)=QCz*VS0(52,48)+WQz*VS1(52,48)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +3D0*HfxZpE*VS1(31,48)
VS0(52,77)=QCz*VS0(52,49)+WQz*VS1(52,49)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +3D0*HfxZpE*VS1(31,49)
VS0(52,78)=QCy*VS0(52,53)+WQy*VS1(52,53)-r1x2E*VR1(52,53)&
   +2D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +HfxZpE*VS1(33,53)
VS0(52,79)=QCz*VS0(52,51)+WQz*VS1(52,51)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +3D0*HfxZpE*VS1(31,51)
VS0(52,80)=QCz*VS0(52,52)+WQz*VS1(52,52)&
   +3D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +3D0*HfxZpE*VS1(31,52)
VS0(52,81)=QCz*VS0(52,53)+WQz*VS1(52,53)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +3D0*HfxZpE*VS1(31,53)
VS0(52,82)=QCz*VS0(52,54)+WQz*VS1(52,54)&
   +4D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +3D0*HfxZpE*VS1(31,54)
VS0(52,83)=QCz*VS0(52,55)+WQz*VS1(52,55)&
   +4D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +3D0*HfxZpE*VS1(31,55)
VS0(52,84)=QCz*VS0(52,56)+WQz*VS1(52,56)&
   +5D0*r1x2E*(VS0(52,35)-ZxZpE*VS1(52,35))&
   +3D0*HfxZpE*VS1(31,56)
VS0(53,57)=QCx*VS0(53,36)+WQx*VS1(53,36)&
   +5D0*r1x2E*(VS0(53,21)-ZxZpE*VS1(53,21))
VS0(53,58)=QCx*VS0(53,37)+WQx*VS1(53,37)&
   +4D0*r1x2E*(VS0(53,22)-ZxZpE*VS1(53,22))
VS0(53,59)=QCx*VS0(53,38)+WQx*VS1(53,38)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))
VS0(53,60)=QCx*VS0(53,39)+WQx*VS1(53,39)&
   +2D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))
VS0(53,61)=QCy*VS0(53,39)+WQy*VS1(53,39)-r1x2E*VR1(53,39)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))&
   +2D0*HfxZpE*VS1(34,39)
VS0(53,62)=QCy*VS0(53,40)+WQy*VS1(53,40)-r1x2E*VR1(53,40)&
   +4D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))&
   +2D0*HfxZpE*VS1(34,40)
VS0(53,63)=QCy*VS0(53,41)+WQy*VS1(53,41)-r1x2E*VR1(53,41)&
   +5D0*r1x2E*(VS0(53,25)-ZxZpE*VS1(53,25))&
   +2D0*HfxZpE*VS1(34,41)
VS0(53,64)=QCx*VS0(53,42)+WQx*VS1(53,42)&
   +4D0*r1x2E*(VS0(53,26)-ZxZpE*VS1(53,26))
VS0(53,65)=QCx*VS0(53,43)+WQx*VS1(53,43)&
   +3D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))
VS0(53,66)=QCx*VS0(53,44)+WQx*VS1(53,44)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))
VS0(53,67)=QCy*VS0(53,44)+WQy*VS1(53,44)-r1x2E*VR1(53,44)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +2D0*HfxZpE*VS1(34,44)
VS0(53,68)=QCy*VS0(53,45)+WQy*VS1(53,45)-r1x2E*VR1(53,45)&
   +3D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +2D0*HfxZpE*VS1(34,45)
VS0(53,69)=QCy*VS0(53,46)+WQy*VS1(53,46)-r1x2E*VR1(53,46)&
   +4D0*r1x2E*(VS0(53,29)-ZxZpE*VS1(53,29))&
   +2D0*HfxZpE*VS1(34,46)
VS0(53,70)=QCx*VS0(53,47)+WQx*VS1(53,47)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))
VS0(53,71)=QCx*VS0(53,48)+WQx*VS1(53,48)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))
VS0(53,72)=QCx*VS0(53,49)+WQx*VS1(53,49)&
   +r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))
VS0(53,73)=QCy*VS0(53,49)+WQy*VS1(53,49)-r1x2E*VR1(53,49)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +2D0*HfxZpE*VS1(34,49)
VS0(53,74)=QCy*VS0(53,50)+WQy*VS1(53,50)-r1x2E*VR1(53,50)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +2D0*HfxZpE*VS1(34,50)
VS0(53,75)=QCx*VS0(53,51)+WQx*VS1(53,51)&
   +2D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))
VS0(53,76)=QCz*VS0(53,48)+WQz*VS1(53,48)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +3D0*HfxZpE*VS1(32,48)
VS0(53,77)=QCz*VS0(53,49)+WQz*VS1(53,49)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +3D0*HfxZpE*VS1(32,49)
VS0(53,78)=QCy*VS0(53,53)+WQy*VS1(53,53)-r1x2E*VR1(53,53)&
   +2D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +2D0*HfxZpE*VS1(34,53)
VS0(53,79)=QCz*VS0(53,51)+WQz*VS1(53,51)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))&
   +3D0*HfxZpE*VS1(32,51)
VS0(53,80)=QCz*VS0(53,52)+WQz*VS1(53,52)&
   +3D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +3D0*HfxZpE*VS1(32,52)
VS0(53,81)=QCz*VS0(53,53)+WQz*VS1(53,53)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +3D0*HfxZpE*VS1(32,53)
VS0(53,82)=QCz*VS0(53,54)+WQz*VS1(53,54)&
   +4D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))&
   +3D0*HfxZpE*VS1(32,54)
VS0(53,83)=QCz*VS0(53,55)+WQz*VS1(53,55)&
   +4D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +3D0*HfxZpE*VS1(32,55)
VS0(53,84)=QCz*VS0(53,56)+WQz*VS1(53,56)&
   +5D0*r1x2E*(VS0(53,35)-ZxZpE*VS1(53,35))&
   +3D0*HfxZpE*VS1(32,56)
VS0(54,57)=QCx*VS0(54,36)+WQx*VS1(54,36)&
   +5D0*r1x2E*(VS0(54,21)-ZxZpE*VS1(54,21))&
   +HfxZpE*VS1(35,36)
VS0(54,58)=QCx*VS0(54,37)+WQx*VS1(54,37)&
   +4D0*r1x2E*(VS0(54,22)-ZxZpE*VS1(54,22))&
   +HfxZpE*VS1(35,37)
VS0(54,59)=QCx*VS0(54,38)+WQx*VS1(54,38)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))&
   +HfxZpE*VS1(35,38)
VS0(54,60)=QCx*VS0(54,39)+WQx*VS1(54,39)&
   +2D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))&
   +HfxZpE*VS1(35,39)
VS0(54,61)=QCy*VS0(54,39)+WQy*VS1(54,39)-r1x2E*VR1(54,39)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))
VS0(54,62)=QCy*VS0(54,40)+WQy*VS1(54,40)-r1x2E*VR1(54,40)&
   +4D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))
VS0(54,63)=QCy*VS0(54,41)+WQy*VS1(54,41)-r1x2E*VR1(54,41)&
   +5D0*r1x2E*(VS0(54,25)-ZxZpE*VS1(54,25))
VS0(54,64)=QCx*VS0(54,42)+WQx*VS1(54,42)&
   +4D0*r1x2E*(VS0(54,26)-ZxZpE*VS1(54,26))&
   +HfxZpE*VS1(35,42)
VS0(54,65)=QCx*VS0(54,43)+WQx*VS1(54,43)&
   +3D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +HfxZpE*VS1(35,43)
VS0(54,66)=QCx*VS0(54,44)+WQx*VS1(54,44)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +HfxZpE*VS1(35,44)
VS0(54,67)=QCy*VS0(54,44)+WQy*VS1(54,44)-r1x2E*VR1(54,44)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))
VS0(54,68)=QCy*VS0(54,45)+WQy*VS1(54,45)-r1x2E*VR1(54,45)&
   +3D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))
VS0(54,69)=QCy*VS0(54,46)+WQy*VS1(54,46)-r1x2E*VR1(54,46)&
   +4D0*r1x2E*(VS0(54,29)-ZxZpE*VS1(54,29))
VS0(54,70)=QCx*VS0(54,47)+WQx*VS1(54,47)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +HfxZpE*VS1(35,47)
VS0(54,71)=QCx*VS0(54,48)+WQx*VS1(54,48)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +HfxZpE*VS1(35,48)
VS0(54,72)=QCx*VS0(54,49)+WQx*VS1(54,49)&
   +r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +HfxZpE*VS1(35,49)
VS0(54,73)=QCy*VS0(54,49)+WQy*VS1(54,49)-r1x2E*VR1(54,49)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))
VS0(54,74)=QCy*VS0(54,50)+WQy*VS1(54,50)-r1x2E*VR1(54,50)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))
VS0(54,75)=QCx*VS0(54,51)+WQx*VS1(54,51)&
   +2D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +HfxZpE*VS1(35,51)
VS0(54,76)=QCz*VS0(54,48)+WQz*VS1(54,48)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +4D0*HfxZpE*VS1(33,48)
VS0(54,77)=QCz*VS0(54,49)+WQz*VS1(54,49)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +4D0*HfxZpE*VS1(33,49)
VS0(54,78)=QCy*VS0(54,53)+WQy*VS1(54,53)-r1x2E*VR1(54,53)&
   +2D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))
VS0(54,79)=QCz*VS0(54,51)+WQz*VS1(54,51)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +4D0*HfxZpE*VS1(33,51)
VS0(54,80)=QCz*VS0(54,52)+WQz*VS1(54,52)&
   +3D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +4D0*HfxZpE*VS1(33,52)
VS0(54,81)=QCz*VS0(54,53)+WQz*VS1(54,53)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +4D0*HfxZpE*VS1(33,53)
VS0(54,82)=QCz*VS0(54,54)+WQz*VS1(54,54)&
   +4D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +4D0*HfxZpE*VS1(33,54)
VS0(54,83)=QCz*VS0(54,55)+WQz*VS1(54,55)&
   +4D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))&
   +4D0*HfxZpE*VS1(33,55)
VS0(54,84)=QCz*VS0(54,56)+WQz*VS1(54,56)&
   +5D0*r1x2E*(VS0(54,35)-ZxZpE*VS1(54,35))&
   +4D0*HfxZpE*VS1(33,56)
VS0(55,57)=QCx*VS0(55,36)+WQx*VS1(55,36)&
   +5D0*r1x2E*(VS0(55,21)-ZxZpE*VS1(55,21))
VS0(55,58)=QCx*VS0(55,37)+WQx*VS1(55,37)&
   +4D0*r1x2E*(VS0(55,22)-ZxZpE*VS1(55,22))
VS0(55,59)=QCx*VS0(55,38)+WQx*VS1(55,38)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))
VS0(55,60)=QCx*VS0(55,39)+WQx*VS1(55,39)&
   +2D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))
VS0(55,61)=QCy*VS0(55,39)+WQy*VS1(55,39)-r1x2E*VR1(55,39)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))&
   +HfxZpE*VS1(35,39)
VS0(55,62)=QCy*VS0(55,40)+WQy*VS1(55,40)-r1x2E*VR1(55,40)&
   +4D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))&
   +HfxZpE*VS1(35,40)
VS0(55,63)=QCy*VS0(55,41)+WQy*VS1(55,41)-r1x2E*VR1(55,41)&
   +5D0*r1x2E*(VS0(55,25)-ZxZpE*VS1(55,25))&
   +HfxZpE*VS1(35,41)
VS0(55,64)=QCx*VS0(55,42)+WQx*VS1(55,42)&
   +4D0*r1x2E*(VS0(55,26)-ZxZpE*VS1(55,26))
VS0(55,65)=QCx*VS0(55,43)+WQx*VS1(55,43)&
   +3D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))
VS0(55,66)=QCx*VS0(55,44)+WQx*VS1(55,44)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))
VS0(55,67)=QCy*VS0(55,44)+WQy*VS1(55,44)-r1x2E*VR1(55,44)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +HfxZpE*VS1(35,44)
VS0(55,68)=QCy*VS0(55,45)+WQy*VS1(55,45)-r1x2E*VR1(55,45)&
   +3D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +HfxZpE*VS1(35,45)
VS0(55,69)=QCy*VS0(55,46)+WQy*VS1(55,46)-r1x2E*VR1(55,46)&
   +4D0*r1x2E*(VS0(55,29)-ZxZpE*VS1(55,29))&
   +HfxZpE*VS1(35,46)
VS0(55,70)=QCx*VS0(55,47)+WQx*VS1(55,47)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))
VS0(55,71)=QCx*VS0(55,48)+WQx*VS1(55,48)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))
VS0(55,72)=QCx*VS0(55,49)+WQx*VS1(55,49)&
   +r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))
VS0(55,73)=QCy*VS0(55,49)+WQy*VS1(55,49)-r1x2E*VR1(55,49)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +HfxZpE*VS1(35,49)
VS0(55,74)=QCy*VS0(55,50)+WQy*VS1(55,50)-r1x2E*VR1(55,50)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +HfxZpE*VS1(35,50)
VS0(55,75)=QCx*VS0(55,51)+WQx*VS1(55,51)&
   +2D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))
VS0(55,76)=QCz*VS0(55,48)+WQz*VS1(55,48)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +4D0*HfxZpE*VS1(34,48)
VS0(55,77)=QCz*VS0(55,49)+WQz*VS1(55,49)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +4D0*HfxZpE*VS1(34,49)
VS0(55,78)=QCy*VS0(55,53)+WQy*VS1(55,53)-r1x2E*VR1(55,53)&
   +2D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +HfxZpE*VS1(35,53)
VS0(55,79)=QCz*VS0(55,51)+WQz*VS1(55,51)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))&
   +4D0*HfxZpE*VS1(34,51)
VS0(55,80)=QCz*VS0(55,52)+WQz*VS1(55,52)&
   +3D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +4D0*HfxZpE*VS1(34,52)
VS0(55,81)=QCz*VS0(55,53)+WQz*VS1(55,53)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +4D0*HfxZpE*VS1(34,53)
VS0(55,82)=QCz*VS0(55,54)+WQz*VS1(55,54)&
   +4D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))&
   +4D0*HfxZpE*VS1(34,54)
VS0(55,83)=QCz*VS0(55,55)+WQz*VS1(55,55)&
   +4D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +4D0*HfxZpE*VS1(34,55)
VS0(55,84)=QCz*VS0(55,56)+WQz*VS1(55,56)&
   +5D0*r1x2E*(VS0(55,35)-ZxZpE*VS1(55,35))&
   +4D0*HfxZpE*VS1(34,56)
VS0(56,57)=QCx*VS0(56,36)+WQx*VS1(56,36)&
   +5D0*r1x2E*(VS0(56,21)-ZxZpE*VS1(56,21))
VS0(56,58)=QCx*VS0(56,37)+WQx*VS1(56,37)&
   +4D0*r1x2E*(VS0(56,22)-ZxZpE*VS1(56,22))
VS0(56,59)=QCx*VS0(56,38)+WQx*VS1(56,38)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,60)=QCx*VS0(56,39)+WQx*VS1(56,39)&
   +2D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,61)=QCy*VS0(56,39)+WQy*VS1(56,39)-r1x2E*VR1(56,39)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,62)=QCy*VS0(56,40)+WQy*VS1(56,40)-r1x2E*VR1(56,40)&
   +4D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,63)=QCy*VS0(56,41)+WQy*VS1(56,41)-r1x2E*VR1(56,41)&
   +5D0*r1x2E*(VS0(56,25)-ZxZpE*VS1(56,25))
VS0(56,64)=QCx*VS0(56,42)+WQx*VS1(56,42)&
   +4D0*r1x2E*(VS0(56,26)-ZxZpE*VS1(56,26))
VS0(56,65)=QCx*VS0(56,43)+WQx*VS1(56,43)&
   +3D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,66)=QCx*VS0(56,44)+WQx*VS1(56,44)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,67)=QCy*VS0(56,44)+WQy*VS1(56,44)-r1x2E*VR1(56,44)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,68)=QCy*VS0(56,45)+WQy*VS1(56,45)-r1x2E*VR1(56,45)&
   +3D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,69)=QCy*VS0(56,46)+WQy*VS1(56,46)-r1x2E*VR1(56,46)&
   +4D0*r1x2E*(VS0(56,29)-ZxZpE*VS1(56,29))
VS0(56,70)=QCx*VS0(56,47)+WQx*VS1(56,47)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))
VS0(56,71)=QCx*VS0(56,48)+WQx*VS1(56,48)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,72)=QCx*VS0(56,49)+WQx*VS1(56,49)&
   +r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,73)=QCy*VS0(56,49)+WQy*VS1(56,49)-r1x2E*VR1(56,49)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,74)=QCy*VS0(56,50)+WQy*VS1(56,50)-r1x2E*VR1(56,50)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,75)=QCx*VS0(56,51)+WQx*VS1(56,51)&
   +2D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))
VS0(56,76)=QCz*VS0(56,48)+WQz*VS1(56,48)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))&
   +5D0*HfxZpE*VS1(35,48)
VS0(56,77)=QCz*VS0(56,49)+WQz*VS1(56,49)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))&
   +5D0*HfxZpE*VS1(35,49)
VS0(56,78)=QCy*VS0(56,53)+WQy*VS1(56,53)-r1x2E*VR1(56,53)&
   +2D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))
VS0(56,79)=QCz*VS0(56,51)+WQz*VS1(56,51)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))&
   +5D0*HfxZpE*VS1(35,51)
VS0(56,80)=QCz*VS0(56,52)+WQz*VS1(56,52)&
   +3D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))&
   +5D0*HfxZpE*VS1(35,52)
VS0(56,81)=QCz*VS0(56,53)+WQz*VS1(56,53)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))&
   +5D0*HfxZpE*VS1(35,53)
VS0(56,82)=QCz*VS0(56,54)+WQz*VS1(56,54)&
   +4D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))&
   +5D0*HfxZpE*VS1(35,54)
VS0(56,83)=QCz*VS0(56,55)+WQz*VS1(56,55)&
   +4D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))&
   +5D0*HfxZpE*VS1(35,55)
VS0(56,84)=QCz*VS0(56,56)+WQz*VS1(56,56)&
   +5D0*r1x2E*(VS0(56,35)-ZxZpE*VS1(56,35))&
   +5D0*HfxZpE*VS1(35,56)
CASE(3)
VS0(36,57)=QCx*VS0(36,36)+WQx*VS1(36,36)&
   +5D0*r1x2E*(VS0(36,21)-ZxZpE*VS1(36,21))&
   +5D0*HfxZpE*VS1(21,36)
VS0(36,58)=QCx*VS0(36,37)+WQx*VS1(36,37)&
   +4D0*r1x2E*(VS0(36,22)-ZxZpE*VS1(36,22))&
   +5D0*HfxZpE*VS1(21,37)
VS0(36,59)=QCx*VS0(36,38)+WQx*VS1(36,38)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))&
   +5D0*HfxZpE*VS1(21,38)
VS0(36,60)=QCx*VS0(36,39)+WQx*VS1(36,39)&
   +2D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))&
   +5D0*HfxZpE*VS1(21,39)
VS0(36,61)=QCy*VS0(36,39)+WQy*VS1(36,39)&
   +3D0*r1x2E*(VS0(36,23)-ZxZpE*VS1(36,23))
VS0(36,62)=QCy*VS0(36,40)+WQy*VS1(36,40)&
   +4D0*r1x2E*(VS0(36,24)-ZxZpE*VS1(36,24))
VS0(36,63)=QCy*VS0(36,41)+WQy*VS1(36,41)&
   +5D0*r1x2E*(VS0(36,25)-ZxZpE*VS1(36,25))
VS0(36,64)=QCx*VS0(36,42)+WQx*VS1(36,42)&
   +4D0*r1x2E*(VS0(36,26)-ZxZpE*VS1(36,26))&
   +5D0*HfxZpE*VS1(21,42)
VS0(36,65)=QCx*VS0(36,43)+WQx*VS1(36,43)&
   +3D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))&
   +5D0*HfxZpE*VS1(21,43)
VS0(36,66)=QCx*VS0(36,44)+WQx*VS1(36,44)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))&
   +5D0*HfxZpE*VS1(21,44)
VS0(36,67)=QCy*VS0(36,44)+WQy*VS1(36,44)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,68)=QCy*VS0(36,45)+WQy*VS1(36,45)&
   +3D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,69)=QCy*VS0(36,46)+WQy*VS1(36,46)&
   +4D0*r1x2E*(VS0(36,29)-ZxZpE*VS1(36,29))
VS0(36,70)=QCx*VS0(36,47)+WQx*VS1(36,47)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))&
   +5D0*HfxZpE*VS1(21,47)
VS0(36,71)=QCx*VS0(36,48)+WQx*VS1(36,48)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))&
   +5D0*HfxZpE*VS1(21,48)
VS0(36,72)=QCx*VS0(36,49)+WQx*VS1(36,49)&
   +r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))&
   +5D0*HfxZpE*VS1(21,49)
VS0(36,73)=QCy*VS0(36,49)+WQy*VS1(36,49)&
   +2D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,74)=QCy*VS0(36,50)+WQy*VS1(36,50)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,75)=QCx*VS0(36,51)+WQx*VS1(36,51)&
   +2D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))&
   +5D0*HfxZpE*VS1(21,51)
VS0(36,76)=QCz*VS0(36,48)+WQz*VS1(36,48)-r1x2E*VR1(36,48)&
   +2D0*r1x2E*(VS0(36,27)-ZxZpE*VS1(36,27))
VS0(36,77)=QCz*VS0(36,49)+WQz*VS1(36,49)-r1x2E*VR1(36,49)&
   +2D0*r1x2E*(VS0(36,28)-ZxZpE*VS1(36,28))
VS0(36,78)=QCy*VS0(36,53)+WQy*VS1(36,53)&
   +2D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,79)=QCz*VS0(36,51)+WQz*VS1(36,51)-r1x2E*VR1(36,51)&
   +3D0*r1x2E*(VS0(36,30)-ZxZpE*VS1(36,30))
VS0(36,80)=QCz*VS0(36,52)+WQz*VS1(36,52)-r1x2E*VR1(36,52)&
   +3D0*r1x2E*(VS0(36,31)-ZxZpE*VS1(36,31))
VS0(36,81)=QCz*VS0(36,53)+WQz*VS1(36,53)-r1x2E*VR1(36,53)&
   +3D0*r1x2E*(VS0(36,32)-ZxZpE*VS1(36,32))
VS0(36,82)=QCz*VS0(36,54)+WQz*VS1(36,54)-r1x2E*VR1(36,54)&
   +4D0*r1x2E*(VS0(36,33)-ZxZpE*VS1(36,33))
VS0(36,83)=QCz*VS0(36,55)+WQz*VS1(36,55)-r1x2E*VR1(36,55)&
   +4D0*r1x2E*(VS0(36,34)-ZxZpE*VS1(36,34))
VS0(36,84)=QCz*VS0(36,56)+WQz*VS1(36,56)-r1x2E*VR1(36,56)&
   +5D0*r1x2E*(VS0(36,35)-ZxZpE*VS1(36,35))
VS0(37,57)=QCx*VS0(37,36)+WQx*VS1(37,36)&
   +5D0*r1x2E*(VS0(37,21)-ZxZpE*VS1(37,21))&
   +4D0*HfxZpE*VS1(22,36)
VS0(37,58)=QCx*VS0(37,37)+WQx*VS1(37,37)&
   +4D0*r1x2E*(VS0(37,22)-ZxZpE*VS1(37,22))&
   +4D0*HfxZpE*VS1(22,37)
VS0(37,59)=QCx*VS0(37,38)+WQx*VS1(37,38)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +4D0*HfxZpE*VS1(22,38)
VS0(37,60)=QCx*VS0(37,39)+WQx*VS1(37,39)&
   +2D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +4D0*HfxZpE*VS1(22,39)
VS0(37,61)=QCy*VS0(37,39)+WQy*VS1(37,39)&
   +3D0*r1x2E*(VS0(37,23)-ZxZpE*VS1(37,23))&
   +HfxZpE*VS1(21,39)
VS0(37,62)=QCy*VS0(37,40)+WQy*VS1(37,40)&
   +4D0*r1x2E*(VS0(37,24)-ZxZpE*VS1(37,24))&
   +HfxZpE*VS1(21,40)
VS0(37,63)=QCy*VS0(37,41)+WQy*VS1(37,41)&
   +5D0*r1x2E*(VS0(37,25)-ZxZpE*VS1(37,25))&
   +HfxZpE*VS1(21,41)
VS0(37,64)=QCx*VS0(37,42)+WQx*VS1(37,42)&
   +4D0*r1x2E*(VS0(37,26)-ZxZpE*VS1(37,26))&
   +4D0*HfxZpE*VS1(22,42)
VS0(37,65)=QCx*VS0(37,43)+WQx*VS1(37,43)&
   +3D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +4D0*HfxZpE*VS1(22,43)
VS0(37,66)=QCx*VS0(37,44)+WQx*VS1(37,44)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +4D0*HfxZpE*VS1(22,44)
VS0(37,67)=QCy*VS0(37,44)+WQy*VS1(37,44)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))&
   +HfxZpE*VS1(21,44)
VS0(37,68)=QCy*VS0(37,45)+WQy*VS1(37,45)&
   +3D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))&
   +HfxZpE*VS1(21,45)
VS0(37,69)=QCy*VS0(37,46)+WQy*VS1(37,46)&
   +4D0*r1x2E*(VS0(37,29)-ZxZpE*VS1(37,29))&
   +HfxZpE*VS1(21,46)
VS0(37,70)=QCx*VS0(37,47)+WQx*VS1(37,47)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))&
   +4D0*HfxZpE*VS1(22,47)
VS0(37,71)=QCx*VS0(37,48)+WQx*VS1(37,48)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +4D0*HfxZpE*VS1(22,48)
VS0(37,72)=QCx*VS0(37,49)+WQx*VS1(37,49)&
   +r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +4D0*HfxZpE*VS1(22,49)
VS0(37,73)=QCy*VS0(37,49)+WQy*VS1(37,49)&
   +2D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))&
   +HfxZpE*VS1(21,49)
VS0(37,74)=QCy*VS0(37,50)+WQy*VS1(37,50)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))&
   +HfxZpE*VS1(21,50)
VS0(37,75)=QCx*VS0(37,51)+WQx*VS1(37,51)&
   +2D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))&
   +4D0*HfxZpE*VS1(22,51)
VS0(37,76)=QCz*VS0(37,48)+WQz*VS1(37,48)-r1x2E*VR1(37,48)&
   +2D0*r1x2E*(VS0(37,27)-ZxZpE*VS1(37,27))
VS0(37,77)=QCz*VS0(37,49)+WQz*VS1(37,49)-r1x2E*VR1(37,49)&
   +2D0*r1x2E*(VS0(37,28)-ZxZpE*VS1(37,28))
VS0(37,78)=QCy*VS0(37,53)+WQy*VS1(37,53)&
   +2D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))&
   +HfxZpE*VS1(21,53)
VS0(37,79)=QCz*VS0(37,51)+WQz*VS1(37,51)-r1x2E*VR1(37,51)&
   +3D0*r1x2E*(VS0(37,30)-ZxZpE*VS1(37,30))
VS0(37,80)=QCz*VS0(37,52)+WQz*VS1(37,52)-r1x2E*VR1(37,52)&
   +3D0*r1x2E*(VS0(37,31)-ZxZpE*VS1(37,31))
VS0(37,81)=QCz*VS0(37,53)+WQz*VS1(37,53)-r1x2E*VR1(37,53)&
   +3D0*r1x2E*(VS0(37,32)-ZxZpE*VS1(37,32))
VS0(37,82)=QCz*VS0(37,54)+WQz*VS1(37,54)-r1x2E*VR1(37,54)&
   +4D0*r1x2E*(VS0(37,33)-ZxZpE*VS1(37,33))
VS0(37,83)=QCz*VS0(37,55)+WQz*VS1(37,55)-r1x2E*VR1(37,55)&
   +4D0*r1x2E*(VS0(37,34)-ZxZpE*VS1(37,34))
VS0(37,84)=QCz*VS0(37,56)+WQz*VS1(37,56)-r1x2E*VR1(37,56)&
   +5D0*r1x2E*(VS0(37,35)-ZxZpE*VS1(37,35))
VS0(38,57)=QCx*VS0(38,36)+WQx*VS1(38,36)&
   +5D0*r1x2E*(VS0(38,21)-ZxZpE*VS1(38,21))&
   +3D0*HfxZpE*VS1(23,36)
VS0(38,58)=QCx*VS0(38,37)+WQx*VS1(38,37)&
   +4D0*r1x2E*(VS0(38,22)-ZxZpE*VS1(38,22))&
   +3D0*HfxZpE*VS1(23,37)
VS0(38,59)=QCx*VS0(38,38)+WQx*VS1(38,38)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +3D0*HfxZpE*VS1(23,38)
VS0(38,60)=QCx*VS0(38,39)+WQx*VS1(38,39)&
   +2D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +3D0*HfxZpE*VS1(23,39)
VS0(38,61)=QCy*VS0(38,39)+WQy*VS1(38,39)&
   +3D0*r1x2E*(VS0(38,23)-ZxZpE*VS1(38,23))&
   +2D0*HfxZpE*VS1(22,39)
VS0(38,62)=QCy*VS0(38,40)+WQy*VS1(38,40)&
   +4D0*r1x2E*(VS0(38,24)-ZxZpE*VS1(38,24))&
   +2D0*HfxZpE*VS1(22,40)
VS0(38,63)=QCy*VS0(38,41)+WQy*VS1(38,41)&
   +5D0*r1x2E*(VS0(38,25)-ZxZpE*VS1(38,25))&
   +2D0*HfxZpE*VS1(22,41)
VS0(38,64)=QCx*VS0(38,42)+WQx*VS1(38,42)&
   +4D0*r1x2E*(VS0(38,26)-ZxZpE*VS1(38,26))&
   +3D0*HfxZpE*VS1(23,42)
VS0(38,65)=QCx*VS0(38,43)+WQx*VS1(38,43)&
   +3D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +3D0*HfxZpE*VS1(23,43)
VS0(38,66)=QCx*VS0(38,44)+WQx*VS1(38,44)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +3D0*HfxZpE*VS1(23,44)
VS0(38,67)=QCy*VS0(38,44)+WQy*VS1(38,44)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))&
   +2D0*HfxZpE*VS1(22,44)
VS0(38,68)=QCy*VS0(38,45)+WQy*VS1(38,45)&
   +3D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))&
   +2D0*HfxZpE*VS1(22,45)
VS0(38,69)=QCy*VS0(38,46)+WQy*VS1(38,46)&
   +4D0*r1x2E*(VS0(38,29)-ZxZpE*VS1(38,29))&
   +2D0*HfxZpE*VS1(22,46)
VS0(38,70)=QCx*VS0(38,47)+WQx*VS1(38,47)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))&
   +3D0*HfxZpE*VS1(23,47)
VS0(38,71)=QCx*VS0(38,48)+WQx*VS1(38,48)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +3D0*HfxZpE*VS1(23,48)
VS0(38,72)=QCx*VS0(38,49)+WQx*VS1(38,49)&
   +r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +3D0*HfxZpE*VS1(23,49)
VS0(38,73)=QCy*VS0(38,49)+WQy*VS1(38,49)&
   +2D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))&
   +2D0*HfxZpE*VS1(22,49)
VS0(38,74)=QCy*VS0(38,50)+WQy*VS1(38,50)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))&
   +2D0*HfxZpE*VS1(22,50)
VS0(38,75)=QCx*VS0(38,51)+WQx*VS1(38,51)&
   +2D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))&
   +3D0*HfxZpE*VS1(23,51)
VS0(38,76)=QCz*VS0(38,48)+WQz*VS1(38,48)-r1x2E*VR1(38,48)&
   +2D0*r1x2E*(VS0(38,27)-ZxZpE*VS1(38,27))
VS0(38,77)=QCz*VS0(38,49)+WQz*VS1(38,49)-r1x2E*VR1(38,49)&
   +2D0*r1x2E*(VS0(38,28)-ZxZpE*VS1(38,28))
VS0(38,78)=QCy*VS0(38,53)+WQy*VS1(38,53)&
   +2D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))&
   +2D0*HfxZpE*VS1(22,53)
VS0(38,79)=QCz*VS0(38,51)+WQz*VS1(38,51)-r1x2E*VR1(38,51)&
   +3D0*r1x2E*(VS0(38,30)-ZxZpE*VS1(38,30))
VS0(38,80)=QCz*VS0(38,52)+WQz*VS1(38,52)-r1x2E*VR1(38,52)&
   +3D0*r1x2E*(VS0(38,31)-ZxZpE*VS1(38,31))
VS0(38,81)=QCz*VS0(38,53)+WQz*VS1(38,53)-r1x2E*VR1(38,53)&
   +3D0*r1x2E*(VS0(38,32)-ZxZpE*VS1(38,32))
VS0(38,82)=QCz*VS0(38,54)+WQz*VS1(38,54)-r1x2E*VR1(38,54)&
   +4D0*r1x2E*(VS0(38,33)-ZxZpE*VS1(38,33))
VS0(38,83)=QCz*VS0(38,55)+WQz*VS1(38,55)-r1x2E*VR1(38,55)&
   +4D0*r1x2E*(VS0(38,34)-ZxZpE*VS1(38,34))
VS0(38,84)=QCz*VS0(38,56)+WQz*VS1(38,56)-r1x2E*VR1(38,56)&
   +5D0*r1x2E*(VS0(38,35)-ZxZpE*VS1(38,35))
VS0(39,57)=QCx*VS0(39,36)+WQx*VS1(39,36)&
   +5D0*r1x2E*(VS0(39,21)-ZxZpE*VS1(39,21))&
   +2D0*HfxZpE*VS1(24,36)
VS0(39,58)=QCx*VS0(39,37)+WQx*VS1(39,37)&
   +4D0*r1x2E*(VS0(39,22)-ZxZpE*VS1(39,22))&
   +2D0*HfxZpE*VS1(24,37)
VS0(39,59)=QCx*VS0(39,38)+WQx*VS1(39,38)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +2D0*HfxZpE*VS1(24,38)
VS0(39,60)=QCx*VS0(39,39)+WQx*VS1(39,39)&
   +2D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +2D0*HfxZpE*VS1(24,39)
VS0(39,61)=QCy*VS0(39,39)+WQy*VS1(39,39)&
   +3D0*r1x2E*(VS0(39,23)-ZxZpE*VS1(39,23))&
   +3D0*HfxZpE*VS1(23,39)
VS0(39,62)=QCy*VS0(39,40)+WQy*VS1(39,40)&
   +4D0*r1x2E*(VS0(39,24)-ZxZpE*VS1(39,24))&
   +3D0*HfxZpE*VS1(23,40)
VS0(39,63)=QCy*VS0(39,41)+WQy*VS1(39,41)&
   +5D0*r1x2E*(VS0(39,25)-ZxZpE*VS1(39,25))&
   +3D0*HfxZpE*VS1(23,41)
VS0(39,64)=QCx*VS0(39,42)+WQx*VS1(39,42)&
   +4D0*r1x2E*(VS0(39,26)-ZxZpE*VS1(39,26))&
   +2D0*HfxZpE*VS1(24,42)
VS0(39,65)=QCx*VS0(39,43)+WQx*VS1(39,43)&
   +3D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +2D0*HfxZpE*VS1(24,43)
VS0(39,66)=QCx*VS0(39,44)+WQx*VS1(39,44)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +2D0*HfxZpE*VS1(24,44)
VS0(39,67)=QCy*VS0(39,44)+WQy*VS1(39,44)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))&
   +3D0*HfxZpE*VS1(23,44)
VS0(39,68)=QCy*VS0(39,45)+WQy*VS1(39,45)&
   +3D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))&
   +3D0*HfxZpE*VS1(23,45)
VS0(39,69)=QCy*VS0(39,46)+WQy*VS1(39,46)&
   +4D0*r1x2E*(VS0(39,29)-ZxZpE*VS1(39,29))&
   +3D0*HfxZpE*VS1(23,46)
VS0(39,70)=QCx*VS0(39,47)+WQx*VS1(39,47)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))&
   +2D0*HfxZpE*VS1(24,47)
VS0(39,71)=QCx*VS0(39,48)+WQx*VS1(39,48)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +2D0*HfxZpE*VS1(24,48)
VS0(39,72)=QCx*VS0(39,49)+WQx*VS1(39,49)&
   +r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +2D0*HfxZpE*VS1(24,49)
VS0(39,73)=QCy*VS0(39,49)+WQy*VS1(39,49)&
   +2D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))&
   +3D0*HfxZpE*VS1(23,49)
VS0(39,74)=QCy*VS0(39,50)+WQy*VS1(39,50)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))&
   +3D0*HfxZpE*VS1(23,50)
VS0(39,75)=QCx*VS0(39,51)+WQx*VS1(39,51)&
   +2D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))&
   +2D0*HfxZpE*VS1(24,51)
VS0(39,76)=QCz*VS0(39,48)+WQz*VS1(39,48)-r1x2E*VR1(39,48)&
   +2D0*r1x2E*(VS0(39,27)-ZxZpE*VS1(39,27))
VS0(39,77)=QCz*VS0(39,49)+WQz*VS1(39,49)-r1x2E*VR1(39,49)&
   +2D0*r1x2E*(VS0(39,28)-ZxZpE*VS1(39,28))
VS0(39,78)=QCy*VS0(39,53)+WQy*VS1(39,53)&
   +2D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))&
   +3D0*HfxZpE*VS1(23,53)
VS0(39,79)=QCz*VS0(39,51)+WQz*VS1(39,51)-r1x2E*VR1(39,51)&
   +3D0*r1x2E*(VS0(39,30)-ZxZpE*VS1(39,30))
VS0(39,80)=QCz*VS0(39,52)+WQz*VS1(39,52)-r1x2E*VR1(39,52)&
   +3D0*r1x2E*(VS0(39,31)-ZxZpE*VS1(39,31))
VS0(39,81)=QCz*VS0(39,53)+WQz*VS1(39,53)-r1x2E*VR1(39,53)&
   +3D0*r1x2E*(VS0(39,32)-ZxZpE*VS1(39,32))
VS0(39,82)=QCz*VS0(39,54)+WQz*VS1(39,54)-r1x2E*VR1(39,54)&
   +4D0*r1x2E*(VS0(39,33)-ZxZpE*VS1(39,33))
VS0(39,83)=QCz*VS0(39,55)+WQz*VS1(39,55)-r1x2E*VR1(39,55)&
   +4D0*r1x2E*(VS0(39,34)-ZxZpE*VS1(39,34))
VS0(39,84)=QCz*VS0(39,56)+WQz*VS1(39,56)-r1x2E*VR1(39,56)&
   +5D0*r1x2E*(VS0(39,35)-ZxZpE*VS1(39,35))
VS0(40,57)=QCx*VS0(40,36)+WQx*VS1(40,36)&
   +5D0*r1x2E*(VS0(40,21)-ZxZpE*VS1(40,21))&
   +HfxZpE*VS1(25,36)
VS0(40,58)=QCx*VS0(40,37)+WQx*VS1(40,37)&
   +4D0*r1x2E*(VS0(40,22)-ZxZpE*VS1(40,22))&
   +HfxZpE*VS1(25,37)
VS0(40,59)=QCx*VS0(40,38)+WQx*VS1(40,38)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +HfxZpE*VS1(25,38)
VS0(40,60)=QCx*VS0(40,39)+WQx*VS1(40,39)&
   +2D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +HfxZpE*VS1(25,39)
VS0(40,61)=QCy*VS0(40,39)+WQy*VS1(40,39)&
   +3D0*r1x2E*(VS0(40,23)-ZxZpE*VS1(40,23))&
   +4D0*HfxZpE*VS1(24,39)
VS0(40,62)=QCy*VS0(40,40)+WQy*VS1(40,40)&
   +4D0*r1x2E*(VS0(40,24)-ZxZpE*VS1(40,24))&
   +4D0*HfxZpE*VS1(24,40)
VS0(40,63)=QCy*VS0(40,41)+WQy*VS1(40,41)&
   +5D0*r1x2E*(VS0(40,25)-ZxZpE*VS1(40,25))&
   +4D0*HfxZpE*VS1(24,41)
VS0(40,64)=QCx*VS0(40,42)+WQx*VS1(40,42)&
   +4D0*r1x2E*(VS0(40,26)-ZxZpE*VS1(40,26))&
   +HfxZpE*VS1(25,42)
VS0(40,65)=QCx*VS0(40,43)+WQx*VS1(40,43)&
   +3D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +HfxZpE*VS1(25,43)
VS0(40,66)=QCx*VS0(40,44)+WQx*VS1(40,44)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +HfxZpE*VS1(25,44)
VS0(40,67)=QCy*VS0(40,44)+WQy*VS1(40,44)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))&
   +4D0*HfxZpE*VS1(24,44)
VS0(40,68)=QCy*VS0(40,45)+WQy*VS1(40,45)&
   +3D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))&
   +4D0*HfxZpE*VS1(24,45)
VS0(40,69)=QCy*VS0(40,46)+WQy*VS1(40,46)&
   +4D0*r1x2E*(VS0(40,29)-ZxZpE*VS1(40,29))&
   +4D0*HfxZpE*VS1(24,46)
VS0(40,70)=QCx*VS0(40,47)+WQx*VS1(40,47)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))&
   +HfxZpE*VS1(25,47)
VS0(40,71)=QCx*VS0(40,48)+WQx*VS1(40,48)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +HfxZpE*VS1(25,48)
VS0(40,72)=QCx*VS0(40,49)+WQx*VS1(40,49)&
   +r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +HfxZpE*VS1(25,49)
VS0(40,73)=QCy*VS0(40,49)+WQy*VS1(40,49)&
   +2D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))&
   +4D0*HfxZpE*VS1(24,49)
VS0(40,74)=QCy*VS0(40,50)+WQy*VS1(40,50)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))&
   +4D0*HfxZpE*VS1(24,50)
VS0(40,75)=QCx*VS0(40,51)+WQx*VS1(40,51)&
   +2D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))&
   +HfxZpE*VS1(25,51)
VS0(40,76)=QCz*VS0(40,48)+WQz*VS1(40,48)-r1x2E*VR1(40,48)&
   +2D0*r1x2E*(VS0(40,27)-ZxZpE*VS1(40,27))
VS0(40,77)=QCz*VS0(40,49)+WQz*VS1(40,49)-r1x2E*VR1(40,49)&
   +2D0*r1x2E*(VS0(40,28)-ZxZpE*VS1(40,28))
VS0(40,78)=QCy*VS0(40,53)+WQy*VS1(40,53)&
   +2D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))&
   +4D0*HfxZpE*VS1(24,53)
VS0(40,79)=QCz*VS0(40,51)+WQz*VS1(40,51)-r1x2E*VR1(40,51)&
   +3D0*r1x2E*(VS0(40,30)-ZxZpE*VS1(40,30))
VS0(40,80)=QCz*VS0(40,52)+WQz*VS1(40,52)-r1x2E*VR1(40,52)&
   +3D0*r1x2E*(VS0(40,31)-ZxZpE*VS1(40,31))
VS0(40,81)=QCz*VS0(40,53)+WQz*VS1(40,53)-r1x2E*VR1(40,53)&
   +3D0*r1x2E*(VS0(40,32)-ZxZpE*VS1(40,32))
VS0(40,82)=QCz*VS0(40,54)+WQz*VS1(40,54)-r1x2E*VR1(40,54)&
   +4D0*r1x2E*(VS0(40,33)-ZxZpE*VS1(40,33))
VS0(40,83)=QCz*VS0(40,55)+WQz*VS1(40,55)-r1x2E*VR1(40,55)&
   +4D0*r1x2E*(VS0(40,34)-ZxZpE*VS1(40,34))
VS0(40,84)=QCz*VS0(40,56)+WQz*VS1(40,56)-r1x2E*VR1(40,56)&
   +5D0*r1x2E*(VS0(40,35)-ZxZpE*VS1(40,35))
VS0(41,57)=QCx*VS0(41,36)+WQx*VS1(41,36)&
   +5D0*r1x2E*(VS0(41,21)-ZxZpE*VS1(41,21))
VS0(41,58)=QCx*VS0(41,37)+WQx*VS1(41,37)&
   +4D0*r1x2E*(VS0(41,22)-ZxZpE*VS1(41,22))
VS0(41,59)=QCx*VS0(41,38)+WQx*VS1(41,38)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))
VS0(41,60)=QCx*VS0(41,39)+WQx*VS1(41,39)&
   +2D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))
VS0(41,61)=QCy*VS0(41,39)+WQy*VS1(41,39)&
   +3D0*r1x2E*(VS0(41,23)-ZxZpE*VS1(41,23))&
   +5D0*HfxZpE*VS1(25,39)
VS0(41,62)=QCy*VS0(41,40)+WQy*VS1(41,40)&
   +4D0*r1x2E*(VS0(41,24)-ZxZpE*VS1(41,24))&
   +5D0*HfxZpE*VS1(25,40)
VS0(41,63)=QCy*VS0(41,41)+WQy*VS1(41,41)&
   +5D0*r1x2E*(VS0(41,25)-ZxZpE*VS1(41,25))&
   +5D0*HfxZpE*VS1(25,41)
VS0(41,64)=QCx*VS0(41,42)+WQx*VS1(41,42)&
   +4D0*r1x2E*(VS0(41,26)-ZxZpE*VS1(41,26))
VS0(41,65)=QCx*VS0(41,43)+WQx*VS1(41,43)&
   +3D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,66)=QCx*VS0(41,44)+WQx*VS1(41,44)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,67)=QCy*VS0(41,44)+WQy*VS1(41,44)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))&
   +5D0*HfxZpE*VS1(25,44)
VS0(41,68)=QCy*VS0(41,45)+WQy*VS1(41,45)&
   +3D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))&
   +5D0*HfxZpE*VS1(25,45)
VS0(41,69)=QCy*VS0(41,46)+WQy*VS1(41,46)&
   +4D0*r1x2E*(VS0(41,29)-ZxZpE*VS1(41,29))&
   +5D0*HfxZpE*VS1(25,46)
VS0(41,70)=QCx*VS0(41,47)+WQx*VS1(41,47)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,71)=QCx*VS0(41,48)+WQx*VS1(41,48)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,72)=QCx*VS0(41,49)+WQx*VS1(41,49)&
   +r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,73)=QCy*VS0(41,49)+WQy*VS1(41,49)&
   +2D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))&
   +5D0*HfxZpE*VS1(25,49)
VS0(41,74)=QCy*VS0(41,50)+WQy*VS1(41,50)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))&
   +5D0*HfxZpE*VS1(25,50)
VS0(41,75)=QCx*VS0(41,51)+WQx*VS1(41,51)&
   +2D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,76)=QCz*VS0(41,48)+WQz*VS1(41,48)-r1x2E*VR1(41,48)&
   +2D0*r1x2E*(VS0(41,27)-ZxZpE*VS1(41,27))
VS0(41,77)=QCz*VS0(41,49)+WQz*VS1(41,49)-r1x2E*VR1(41,49)&
   +2D0*r1x2E*(VS0(41,28)-ZxZpE*VS1(41,28))
VS0(41,78)=QCy*VS0(41,53)+WQy*VS1(41,53)&
   +2D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))&
   +5D0*HfxZpE*VS1(25,53)
VS0(41,79)=QCz*VS0(41,51)+WQz*VS1(41,51)-r1x2E*VR1(41,51)&
   +3D0*r1x2E*(VS0(41,30)-ZxZpE*VS1(41,30))
VS0(41,80)=QCz*VS0(41,52)+WQz*VS1(41,52)-r1x2E*VR1(41,52)&
   +3D0*r1x2E*(VS0(41,31)-ZxZpE*VS1(41,31))
VS0(41,81)=QCz*VS0(41,53)+WQz*VS1(41,53)-r1x2E*VR1(41,53)&
   +3D0*r1x2E*(VS0(41,32)-ZxZpE*VS1(41,32))
VS0(41,82)=QCz*VS0(41,54)+WQz*VS1(41,54)-r1x2E*VR1(41,54)&
   +4D0*r1x2E*(VS0(41,33)-ZxZpE*VS1(41,33))
VS0(41,83)=QCz*VS0(41,55)+WQz*VS1(41,55)-r1x2E*VR1(41,55)&
   +4D0*r1x2E*(VS0(41,34)-ZxZpE*VS1(41,34))
VS0(41,84)=QCz*VS0(41,56)+WQz*VS1(41,56)-r1x2E*VR1(41,56)&
   +5D0*r1x2E*(VS0(41,35)-ZxZpE*VS1(41,35))
VS0(42,57)=QCx*VS0(42,36)+WQx*VS1(42,36)&
   +5D0*r1x2E*(VS0(42,21)-ZxZpE*VS1(42,21))&
   +4D0*HfxZpE*VS1(26,36)
VS0(42,58)=QCx*VS0(42,37)+WQx*VS1(42,37)&
   +4D0*r1x2E*(VS0(42,22)-ZxZpE*VS1(42,22))&
   +4D0*HfxZpE*VS1(26,37)
VS0(42,59)=QCx*VS0(42,38)+WQx*VS1(42,38)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))&
   +4D0*HfxZpE*VS1(26,38)
VS0(42,60)=QCx*VS0(42,39)+WQx*VS1(42,39)&
   +2D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))&
   +4D0*HfxZpE*VS1(26,39)
VS0(42,61)=QCy*VS0(42,39)+WQy*VS1(42,39)&
   +3D0*r1x2E*(VS0(42,23)-ZxZpE*VS1(42,23))
VS0(42,62)=QCy*VS0(42,40)+WQy*VS1(42,40)&
   +4D0*r1x2E*(VS0(42,24)-ZxZpE*VS1(42,24))
VS0(42,63)=QCy*VS0(42,41)+WQy*VS1(42,41)&
   +5D0*r1x2E*(VS0(42,25)-ZxZpE*VS1(42,25))
VS0(42,64)=QCx*VS0(42,42)+WQx*VS1(42,42)&
   +4D0*r1x2E*(VS0(42,26)-ZxZpE*VS1(42,26))&
   +4D0*HfxZpE*VS1(26,42)
VS0(42,65)=QCx*VS0(42,43)+WQx*VS1(42,43)&
   +3D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +4D0*HfxZpE*VS1(26,43)
VS0(42,66)=QCx*VS0(42,44)+WQx*VS1(42,44)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +4D0*HfxZpE*VS1(26,44)
VS0(42,67)=QCy*VS0(42,44)+WQy*VS1(42,44)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))
VS0(42,68)=QCy*VS0(42,45)+WQy*VS1(42,45)&
   +3D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))
VS0(42,69)=QCy*VS0(42,46)+WQy*VS1(42,46)&
   +4D0*r1x2E*(VS0(42,29)-ZxZpE*VS1(42,29))
VS0(42,70)=QCx*VS0(42,47)+WQx*VS1(42,47)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +4D0*HfxZpE*VS1(26,47)
VS0(42,71)=QCx*VS0(42,48)+WQx*VS1(42,48)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +4D0*HfxZpE*VS1(26,48)
VS0(42,72)=QCx*VS0(42,49)+WQx*VS1(42,49)&
   +r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +4D0*HfxZpE*VS1(26,49)
VS0(42,73)=QCy*VS0(42,49)+WQy*VS1(42,49)&
   +2D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))
VS0(42,74)=QCy*VS0(42,50)+WQy*VS1(42,50)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))
VS0(42,75)=QCx*VS0(42,51)+WQx*VS1(42,51)&
   +2D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +4D0*HfxZpE*VS1(26,51)
VS0(42,76)=QCz*VS0(42,48)+WQz*VS1(42,48)-r1x2E*VR1(42,48)&
   +2D0*r1x2E*(VS0(42,27)-ZxZpE*VS1(42,27))&
   +HfxZpE*VS1(21,48)
VS0(42,77)=QCz*VS0(42,49)+WQz*VS1(42,49)-r1x2E*VR1(42,49)&
   +2D0*r1x2E*(VS0(42,28)-ZxZpE*VS1(42,28))&
   +HfxZpE*VS1(21,49)
VS0(42,78)=QCy*VS0(42,53)+WQy*VS1(42,53)&
   +2D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))
VS0(42,79)=QCz*VS0(42,51)+WQz*VS1(42,51)-r1x2E*VR1(42,51)&
   +3D0*r1x2E*(VS0(42,30)-ZxZpE*VS1(42,30))&
   +HfxZpE*VS1(21,51)
VS0(42,80)=QCz*VS0(42,52)+WQz*VS1(42,52)-r1x2E*VR1(42,52)&
   +3D0*r1x2E*(VS0(42,31)-ZxZpE*VS1(42,31))&
   +HfxZpE*VS1(21,52)
VS0(42,81)=QCz*VS0(42,53)+WQz*VS1(42,53)-r1x2E*VR1(42,53)&
   +3D0*r1x2E*(VS0(42,32)-ZxZpE*VS1(42,32))&
   +HfxZpE*VS1(21,53)
VS0(42,82)=QCz*VS0(42,54)+WQz*VS1(42,54)-r1x2E*VR1(42,54)&
   +4D0*r1x2E*(VS0(42,33)-ZxZpE*VS1(42,33))&
   +HfxZpE*VS1(21,54)
VS0(42,83)=QCz*VS0(42,55)+WQz*VS1(42,55)-r1x2E*VR1(42,55)&
   +4D0*r1x2E*(VS0(42,34)-ZxZpE*VS1(42,34))&
   +HfxZpE*VS1(21,55)
VS0(42,84)=QCz*VS0(42,56)+WQz*VS1(42,56)-r1x2E*VR1(42,56)&
   +5D0*r1x2E*(VS0(42,35)-ZxZpE*VS1(42,35))&
   +HfxZpE*VS1(21,56)
VS0(43,57)=QCx*VS0(43,36)+WQx*VS1(43,36)&
   +5D0*r1x2E*(VS0(43,21)-ZxZpE*VS1(43,21))&
   +3D0*HfxZpE*VS1(27,36)
VS0(43,58)=QCx*VS0(43,37)+WQx*VS1(43,37)&
   +4D0*r1x2E*(VS0(43,22)-ZxZpE*VS1(43,22))&
   +3D0*HfxZpE*VS1(27,37)
VS0(43,59)=QCx*VS0(43,38)+WQx*VS1(43,38)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +3D0*HfxZpE*VS1(27,38)
VS0(43,60)=QCx*VS0(43,39)+WQx*VS1(43,39)&
   +2D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +3D0*HfxZpE*VS1(27,39)
VS0(43,61)=QCy*VS0(43,39)+WQy*VS1(43,39)&
   +3D0*r1x2E*(VS0(43,23)-ZxZpE*VS1(43,23))&
   +HfxZpE*VS1(26,39)
VS0(43,62)=QCy*VS0(43,40)+WQy*VS1(43,40)&
   +4D0*r1x2E*(VS0(43,24)-ZxZpE*VS1(43,24))&
   +HfxZpE*VS1(26,40)
VS0(43,63)=QCy*VS0(43,41)+WQy*VS1(43,41)&
   +5D0*r1x2E*(VS0(43,25)-ZxZpE*VS1(43,25))&
   +HfxZpE*VS1(26,41)
VS0(43,64)=QCx*VS0(43,42)+WQx*VS1(43,42)&
   +4D0*r1x2E*(VS0(43,26)-ZxZpE*VS1(43,26))&
   +3D0*HfxZpE*VS1(27,42)
VS0(43,65)=QCx*VS0(43,43)+WQx*VS1(43,43)&
   +3D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +3D0*HfxZpE*VS1(27,43)
VS0(43,66)=QCx*VS0(43,44)+WQx*VS1(43,44)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +3D0*HfxZpE*VS1(27,44)
VS0(43,67)=QCy*VS0(43,44)+WQy*VS1(43,44)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(26,44)
VS0(43,68)=QCy*VS0(43,45)+WQy*VS1(43,45)&
   +3D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(26,45)
VS0(43,69)=QCy*VS0(43,46)+WQy*VS1(43,46)&
   +4D0*r1x2E*(VS0(43,29)-ZxZpE*VS1(43,29))&
   +HfxZpE*VS1(26,46)
VS0(43,70)=QCx*VS0(43,47)+WQx*VS1(43,47)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +3D0*HfxZpE*VS1(27,47)
VS0(43,71)=QCx*VS0(43,48)+WQx*VS1(43,48)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +3D0*HfxZpE*VS1(27,48)
VS0(43,72)=QCx*VS0(43,49)+WQx*VS1(43,49)&
   +r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +3D0*HfxZpE*VS1(27,49)
VS0(43,73)=QCy*VS0(43,49)+WQy*VS1(43,49)&
   +2D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(26,49)
VS0(43,74)=QCy*VS0(43,50)+WQy*VS1(43,50)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(26,50)
VS0(43,75)=QCx*VS0(43,51)+WQx*VS1(43,51)&
   +2D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +3D0*HfxZpE*VS1(27,51)
VS0(43,76)=QCz*VS0(43,48)+WQz*VS1(43,48)-r1x2E*VR1(43,48)&
   +2D0*r1x2E*(VS0(43,27)-ZxZpE*VS1(43,27))&
   +HfxZpE*VS1(22,48)
VS0(43,77)=QCz*VS0(43,49)+WQz*VS1(43,49)-r1x2E*VR1(43,49)&
   +2D0*r1x2E*(VS0(43,28)-ZxZpE*VS1(43,28))&
   +HfxZpE*VS1(22,49)
VS0(43,78)=QCy*VS0(43,53)+WQy*VS1(43,53)&
   +2D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(26,53)
VS0(43,79)=QCz*VS0(43,51)+WQz*VS1(43,51)-r1x2E*VR1(43,51)&
   +3D0*r1x2E*(VS0(43,30)-ZxZpE*VS1(43,30))&
   +HfxZpE*VS1(22,51)
VS0(43,80)=QCz*VS0(43,52)+WQz*VS1(43,52)-r1x2E*VR1(43,52)&
   +3D0*r1x2E*(VS0(43,31)-ZxZpE*VS1(43,31))&
   +HfxZpE*VS1(22,52)
VS0(43,81)=QCz*VS0(43,53)+WQz*VS1(43,53)-r1x2E*VR1(43,53)&
   +3D0*r1x2E*(VS0(43,32)-ZxZpE*VS1(43,32))&
   +HfxZpE*VS1(22,53)
VS0(43,82)=QCz*VS0(43,54)+WQz*VS1(43,54)-r1x2E*VR1(43,54)&
   +4D0*r1x2E*(VS0(43,33)-ZxZpE*VS1(43,33))&
   +HfxZpE*VS1(22,54)
VS0(43,83)=QCz*VS0(43,55)+WQz*VS1(43,55)-r1x2E*VR1(43,55)&
   +4D0*r1x2E*(VS0(43,34)-ZxZpE*VS1(43,34))&
   +HfxZpE*VS1(22,55)
VS0(43,84)=QCz*VS0(43,56)+WQz*VS1(43,56)-r1x2E*VR1(43,56)&
   +5D0*r1x2E*(VS0(43,35)-ZxZpE*VS1(43,35))&
   +HfxZpE*VS1(22,56)
VS0(44,57)=QCx*VS0(44,36)+WQx*VS1(44,36)&
   +5D0*r1x2E*(VS0(44,21)-ZxZpE*VS1(44,21))&
   +2D0*HfxZpE*VS1(28,36)
VS0(44,58)=QCx*VS0(44,37)+WQx*VS1(44,37)&
   +4D0*r1x2E*(VS0(44,22)-ZxZpE*VS1(44,22))&
   +2D0*HfxZpE*VS1(28,37)
VS0(44,59)=QCx*VS0(44,38)+WQx*VS1(44,38)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(28,38)
VS0(44,60)=QCx*VS0(44,39)+WQx*VS1(44,39)&
   +2D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(28,39)
VS0(44,61)=QCy*VS0(44,39)+WQy*VS1(44,39)&
   +3D0*r1x2E*(VS0(44,23)-ZxZpE*VS1(44,23))&
   +2D0*HfxZpE*VS1(27,39)
VS0(44,62)=QCy*VS0(44,40)+WQy*VS1(44,40)&
   +4D0*r1x2E*(VS0(44,24)-ZxZpE*VS1(44,24))&
   +2D0*HfxZpE*VS1(27,40)
VS0(44,63)=QCy*VS0(44,41)+WQy*VS1(44,41)&
   +5D0*r1x2E*(VS0(44,25)-ZxZpE*VS1(44,25))&
   +2D0*HfxZpE*VS1(27,41)
VS0(44,64)=QCx*VS0(44,42)+WQx*VS1(44,42)&
   +4D0*r1x2E*(VS0(44,26)-ZxZpE*VS1(44,26))&
   +2D0*HfxZpE*VS1(28,42)
VS0(44,65)=QCx*VS0(44,43)+WQx*VS1(44,43)&
   +3D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(28,43)
VS0(44,66)=QCx*VS0(44,44)+WQx*VS1(44,44)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(28,44)
VS0(44,67)=QCy*VS0(44,44)+WQy*VS1(44,44)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +2D0*HfxZpE*VS1(27,44)
VS0(44,68)=QCy*VS0(44,45)+WQy*VS1(44,45)&
   +3D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +2D0*HfxZpE*VS1(27,45)
VS0(44,69)=QCy*VS0(44,46)+WQy*VS1(44,46)&
   +4D0*r1x2E*(VS0(44,29)-ZxZpE*VS1(44,29))&
   +2D0*HfxZpE*VS1(27,46)
VS0(44,70)=QCx*VS0(44,47)+WQx*VS1(44,47)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +2D0*HfxZpE*VS1(28,47)
VS0(44,71)=QCx*VS0(44,48)+WQx*VS1(44,48)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(28,48)
VS0(44,72)=QCx*VS0(44,49)+WQx*VS1(44,49)&
   +r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(28,49)
VS0(44,73)=QCy*VS0(44,49)+WQy*VS1(44,49)&
   +2D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +2D0*HfxZpE*VS1(27,49)
VS0(44,74)=QCy*VS0(44,50)+WQy*VS1(44,50)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +2D0*HfxZpE*VS1(27,50)
VS0(44,75)=QCx*VS0(44,51)+WQx*VS1(44,51)&
   +2D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +2D0*HfxZpE*VS1(28,51)
VS0(44,76)=QCz*VS0(44,48)+WQz*VS1(44,48)-r1x2E*VR1(44,48)&
   +2D0*r1x2E*(VS0(44,27)-ZxZpE*VS1(44,27))&
   +HfxZpE*VS1(23,48)
VS0(44,77)=QCz*VS0(44,49)+WQz*VS1(44,49)-r1x2E*VR1(44,49)&
   +2D0*r1x2E*(VS0(44,28)-ZxZpE*VS1(44,28))&
   +HfxZpE*VS1(23,49)
VS0(44,78)=QCy*VS0(44,53)+WQy*VS1(44,53)&
   +2D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +2D0*HfxZpE*VS1(27,53)
VS0(44,79)=QCz*VS0(44,51)+WQz*VS1(44,51)-r1x2E*VR1(44,51)&
   +3D0*r1x2E*(VS0(44,30)-ZxZpE*VS1(44,30))&
   +HfxZpE*VS1(23,51)
VS0(44,80)=QCz*VS0(44,52)+WQz*VS1(44,52)-r1x2E*VR1(44,52)&
   +3D0*r1x2E*(VS0(44,31)-ZxZpE*VS1(44,31))&
   +HfxZpE*VS1(23,52)
VS0(44,81)=QCz*VS0(44,53)+WQz*VS1(44,53)-r1x2E*VR1(44,53)&
   +3D0*r1x2E*(VS0(44,32)-ZxZpE*VS1(44,32))&
   +HfxZpE*VS1(23,53)
VS0(44,82)=QCz*VS0(44,54)+WQz*VS1(44,54)-r1x2E*VR1(44,54)&
   +4D0*r1x2E*(VS0(44,33)-ZxZpE*VS1(44,33))&
   +HfxZpE*VS1(23,54)
VS0(44,83)=QCz*VS0(44,55)+WQz*VS1(44,55)-r1x2E*VR1(44,55)&
   +4D0*r1x2E*(VS0(44,34)-ZxZpE*VS1(44,34))&
   +HfxZpE*VS1(23,55)
VS0(44,84)=QCz*VS0(44,56)+WQz*VS1(44,56)-r1x2E*VR1(44,56)&
   +5D0*r1x2E*(VS0(44,35)-ZxZpE*VS1(44,35))&
   +HfxZpE*VS1(23,56)
VS0(45,57)=QCx*VS0(45,36)+WQx*VS1(45,36)&
   +5D0*r1x2E*(VS0(45,21)-ZxZpE*VS1(45,21))&
   +HfxZpE*VS1(29,36)
VS0(45,58)=QCx*VS0(45,37)+WQx*VS1(45,37)&
   +4D0*r1x2E*(VS0(45,22)-ZxZpE*VS1(45,22))&
   +HfxZpE*VS1(29,37)
VS0(45,59)=QCx*VS0(45,38)+WQx*VS1(45,38)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +HfxZpE*VS1(29,38)
VS0(45,60)=QCx*VS0(45,39)+WQx*VS1(45,39)&
   +2D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +HfxZpE*VS1(29,39)
VS0(45,61)=QCy*VS0(45,39)+WQy*VS1(45,39)&
   +3D0*r1x2E*(VS0(45,23)-ZxZpE*VS1(45,23))&
   +3D0*HfxZpE*VS1(28,39)
VS0(45,62)=QCy*VS0(45,40)+WQy*VS1(45,40)&
   +4D0*r1x2E*(VS0(45,24)-ZxZpE*VS1(45,24))&
   +3D0*HfxZpE*VS1(28,40)
VS0(45,63)=QCy*VS0(45,41)+WQy*VS1(45,41)&
   +5D0*r1x2E*(VS0(45,25)-ZxZpE*VS1(45,25))&
   +3D0*HfxZpE*VS1(28,41)
VS0(45,64)=QCx*VS0(45,42)+WQx*VS1(45,42)&
   +4D0*r1x2E*(VS0(45,26)-ZxZpE*VS1(45,26))&
   +HfxZpE*VS1(29,42)
VS0(45,65)=QCx*VS0(45,43)+WQx*VS1(45,43)&
   +3D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(29,43)
VS0(45,66)=QCx*VS0(45,44)+WQx*VS1(45,44)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(29,44)
VS0(45,67)=QCy*VS0(45,44)+WQy*VS1(45,44)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +3D0*HfxZpE*VS1(28,44)
VS0(45,68)=QCy*VS0(45,45)+WQy*VS1(45,45)&
   +3D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +3D0*HfxZpE*VS1(28,45)
VS0(45,69)=QCy*VS0(45,46)+WQy*VS1(45,46)&
   +4D0*r1x2E*(VS0(45,29)-ZxZpE*VS1(45,29))&
   +3D0*HfxZpE*VS1(28,46)
VS0(45,70)=QCx*VS0(45,47)+WQx*VS1(45,47)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(29,47)
VS0(45,71)=QCx*VS0(45,48)+WQx*VS1(45,48)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(29,48)
VS0(45,72)=QCx*VS0(45,49)+WQx*VS1(45,49)&
   +r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(29,49)
VS0(45,73)=QCy*VS0(45,49)+WQy*VS1(45,49)&
   +2D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +3D0*HfxZpE*VS1(28,49)
VS0(45,74)=QCy*VS0(45,50)+WQy*VS1(45,50)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +3D0*HfxZpE*VS1(28,50)
VS0(45,75)=QCx*VS0(45,51)+WQx*VS1(45,51)&
   +2D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(29,51)
VS0(45,76)=QCz*VS0(45,48)+WQz*VS1(45,48)-r1x2E*VR1(45,48)&
   +2D0*r1x2E*(VS0(45,27)-ZxZpE*VS1(45,27))&
   +HfxZpE*VS1(24,48)
VS0(45,77)=QCz*VS0(45,49)+WQz*VS1(45,49)-r1x2E*VR1(45,49)&
   +2D0*r1x2E*(VS0(45,28)-ZxZpE*VS1(45,28))&
   +HfxZpE*VS1(24,49)
VS0(45,78)=QCy*VS0(45,53)+WQy*VS1(45,53)&
   +2D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +3D0*HfxZpE*VS1(28,53)
VS0(45,79)=QCz*VS0(45,51)+WQz*VS1(45,51)-r1x2E*VR1(45,51)&
   +3D0*r1x2E*(VS0(45,30)-ZxZpE*VS1(45,30))&
   +HfxZpE*VS1(24,51)
VS0(45,80)=QCz*VS0(45,52)+WQz*VS1(45,52)-r1x2E*VR1(45,52)&
   +3D0*r1x2E*(VS0(45,31)-ZxZpE*VS1(45,31))&
   +HfxZpE*VS1(24,52)
VS0(45,81)=QCz*VS0(45,53)+WQz*VS1(45,53)-r1x2E*VR1(45,53)&
   +3D0*r1x2E*(VS0(45,32)-ZxZpE*VS1(45,32))&
   +HfxZpE*VS1(24,53)
VS0(45,82)=QCz*VS0(45,54)+WQz*VS1(45,54)-r1x2E*VR1(45,54)&
   +4D0*r1x2E*(VS0(45,33)-ZxZpE*VS1(45,33))&
   +HfxZpE*VS1(24,54)
VS0(45,83)=QCz*VS0(45,55)+WQz*VS1(45,55)-r1x2E*VR1(45,55)&
   +4D0*r1x2E*(VS0(45,34)-ZxZpE*VS1(45,34))&
   +HfxZpE*VS1(24,55)
VS0(45,84)=QCz*VS0(45,56)+WQz*VS1(45,56)-r1x2E*VR1(45,56)&
   +5D0*r1x2E*(VS0(45,35)-ZxZpE*VS1(45,35))&
   +HfxZpE*VS1(24,56)
VS0(46,57)=QCx*VS0(46,36)+WQx*VS1(46,36)&
   +5D0*r1x2E*(VS0(46,21)-ZxZpE*VS1(46,21))
VS0(46,58)=QCx*VS0(46,37)+WQx*VS1(46,37)&
   +4D0*r1x2E*(VS0(46,22)-ZxZpE*VS1(46,22))
VS0(46,59)=QCx*VS0(46,38)+WQx*VS1(46,38)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))
VS0(46,60)=QCx*VS0(46,39)+WQx*VS1(46,39)&
   +2D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))
VS0(46,61)=QCy*VS0(46,39)+WQy*VS1(46,39)&
   +3D0*r1x2E*(VS0(46,23)-ZxZpE*VS1(46,23))&
   +4D0*HfxZpE*VS1(29,39)
VS0(46,62)=QCy*VS0(46,40)+WQy*VS1(46,40)&
   +4D0*r1x2E*(VS0(46,24)-ZxZpE*VS1(46,24))&
   +4D0*HfxZpE*VS1(29,40)
VS0(46,63)=QCy*VS0(46,41)+WQy*VS1(46,41)&
   +5D0*r1x2E*(VS0(46,25)-ZxZpE*VS1(46,25))&
   +4D0*HfxZpE*VS1(29,41)
VS0(46,64)=QCx*VS0(46,42)+WQx*VS1(46,42)&
   +4D0*r1x2E*(VS0(46,26)-ZxZpE*VS1(46,26))
VS0(46,65)=QCx*VS0(46,43)+WQx*VS1(46,43)&
   +3D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))
VS0(46,66)=QCx*VS0(46,44)+WQx*VS1(46,44)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))
VS0(46,67)=QCy*VS0(46,44)+WQy*VS1(46,44)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +4D0*HfxZpE*VS1(29,44)
VS0(46,68)=QCy*VS0(46,45)+WQy*VS1(46,45)&
   +3D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +4D0*HfxZpE*VS1(29,45)
VS0(46,69)=QCy*VS0(46,46)+WQy*VS1(46,46)&
   +4D0*r1x2E*(VS0(46,29)-ZxZpE*VS1(46,29))&
   +4D0*HfxZpE*VS1(29,46)
VS0(46,70)=QCx*VS0(46,47)+WQx*VS1(46,47)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))
VS0(46,71)=QCx*VS0(46,48)+WQx*VS1(46,48)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))
VS0(46,72)=QCx*VS0(46,49)+WQx*VS1(46,49)&
   +r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))
VS0(46,73)=QCy*VS0(46,49)+WQy*VS1(46,49)&
   +2D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +4D0*HfxZpE*VS1(29,49)
VS0(46,74)=QCy*VS0(46,50)+WQy*VS1(46,50)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +4D0*HfxZpE*VS1(29,50)
VS0(46,75)=QCx*VS0(46,51)+WQx*VS1(46,51)&
   +2D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))
VS0(46,76)=QCz*VS0(46,48)+WQz*VS1(46,48)-r1x2E*VR1(46,48)&
   +2D0*r1x2E*(VS0(46,27)-ZxZpE*VS1(46,27))&
   +HfxZpE*VS1(25,48)
VS0(46,77)=QCz*VS0(46,49)+WQz*VS1(46,49)-r1x2E*VR1(46,49)&
   +2D0*r1x2E*(VS0(46,28)-ZxZpE*VS1(46,28))&
   +HfxZpE*VS1(25,49)
VS0(46,78)=QCy*VS0(46,53)+WQy*VS1(46,53)&
   +2D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +4D0*HfxZpE*VS1(29,53)
VS0(46,79)=QCz*VS0(46,51)+WQz*VS1(46,51)-r1x2E*VR1(46,51)&
   +3D0*r1x2E*(VS0(46,30)-ZxZpE*VS1(46,30))&
   +HfxZpE*VS1(25,51)
VS0(46,80)=QCz*VS0(46,52)+WQz*VS1(46,52)-r1x2E*VR1(46,52)&
   +3D0*r1x2E*(VS0(46,31)-ZxZpE*VS1(46,31))&
   +HfxZpE*VS1(25,52)
VS0(46,81)=QCz*VS0(46,53)+WQz*VS1(46,53)-r1x2E*VR1(46,53)&
   +3D0*r1x2E*(VS0(46,32)-ZxZpE*VS1(46,32))&
   +HfxZpE*VS1(25,53)
VS0(46,82)=QCz*VS0(46,54)+WQz*VS1(46,54)-r1x2E*VR1(46,54)&
   +4D0*r1x2E*(VS0(46,33)-ZxZpE*VS1(46,33))&
   +HfxZpE*VS1(25,54)
VS0(46,83)=QCz*VS0(46,55)+WQz*VS1(46,55)-r1x2E*VR1(46,55)&
   +4D0*r1x2E*(VS0(46,34)-ZxZpE*VS1(46,34))&
   +HfxZpE*VS1(25,55)
VS0(46,84)=QCz*VS0(46,56)+WQz*VS1(46,56)-r1x2E*VR1(46,56)&
   +5D0*r1x2E*(VS0(46,35)-ZxZpE*VS1(46,35))&
   +HfxZpE*VS1(25,56)
VS0(47,57)=QCx*VS0(47,36)+WQx*VS1(47,36)&
   +5D0*r1x2E*(VS0(47,21)-ZxZpE*VS1(47,21))&
   +3D0*HfxZpE*VS1(30,36)
VS0(47,58)=QCx*VS0(47,37)+WQx*VS1(47,37)&
   +4D0*r1x2E*(VS0(47,22)-ZxZpE*VS1(47,22))&
   +3D0*HfxZpE*VS1(30,37)
VS0(47,59)=QCx*VS0(47,38)+WQx*VS1(47,38)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))&
   +3D0*HfxZpE*VS1(30,38)
VS0(47,60)=QCx*VS0(47,39)+WQx*VS1(47,39)&
   +2D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))&
   +3D0*HfxZpE*VS1(30,39)
VS0(47,61)=QCy*VS0(47,39)+WQy*VS1(47,39)&
   +3D0*r1x2E*(VS0(47,23)-ZxZpE*VS1(47,23))
VS0(47,62)=QCy*VS0(47,40)+WQy*VS1(47,40)&
   +4D0*r1x2E*(VS0(47,24)-ZxZpE*VS1(47,24))
VS0(47,63)=QCy*VS0(47,41)+WQy*VS1(47,41)&
   +5D0*r1x2E*(VS0(47,25)-ZxZpE*VS1(47,25))
VS0(47,64)=QCx*VS0(47,42)+WQx*VS1(47,42)&
   +4D0*r1x2E*(VS0(47,26)-ZxZpE*VS1(47,26))&
   +3D0*HfxZpE*VS1(30,42)
VS0(47,65)=QCx*VS0(47,43)+WQx*VS1(47,43)&
   +3D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +3D0*HfxZpE*VS1(30,43)
VS0(47,66)=QCx*VS0(47,44)+WQx*VS1(47,44)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +3D0*HfxZpE*VS1(30,44)
VS0(47,67)=QCy*VS0(47,44)+WQy*VS1(47,44)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))
VS0(47,68)=QCy*VS0(47,45)+WQy*VS1(47,45)&
   +3D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))
VS0(47,69)=QCy*VS0(47,46)+WQy*VS1(47,46)&
   +4D0*r1x2E*(VS0(47,29)-ZxZpE*VS1(47,29))
VS0(47,70)=QCx*VS0(47,47)+WQx*VS1(47,47)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +3D0*HfxZpE*VS1(30,47)
VS0(47,71)=QCx*VS0(47,48)+WQx*VS1(47,48)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +3D0*HfxZpE*VS1(30,48)
VS0(47,72)=QCx*VS0(47,49)+WQx*VS1(47,49)&
   +r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +3D0*HfxZpE*VS1(30,49)
VS0(47,73)=QCy*VS0(47,49)+WQy*VS1(47,49)&
   +2D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))
VS0(47,74)=QCy*VS0(47,50)+WQy*VS1(47,50)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))
VS0(47,75)=QCx*VS0(47,51)+WQx*VS1(47,51)&
   +2D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +3D0*HfxZpE*VS1(30,51)
VS0(47,76)=QCz*VS0(47,48)+WQz*VS1(47,48)-r1x2E*VR1(47,48)&
   +2D0*r1x2E*(VS0(47,27)-ZxZpE*VS1(47,27))&
   +2D0*HfxZpE*VS1(26,48)
VS0(47,77)=QCz*VS0(47,49)+WQz*VS1(47,49)-r1x2E*VR1(47,49)&
   +2D0*r1x2E*(VS0(47,28)-ZxZpE*VS1(47,28))&
   +2D0*HfxZpE*VS1(26,49)
VS0(47,78)=QCy*VS0(47,53)+WQy*VS1(47,53)&
   +2D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))
VS0(47,79)=QCz*VS0(47,51)+WQz*VS1(47,51)-r1x2E*VR1(47,51)&
   +3D0*r1x2E*(VS0(47,30)-ZxZpE*VS1(47,30))&
   +2D0*HfxZpE*VS1(26,51)
VS0(47,80)=QCz*VS0(47,52)+WQz*VS1(47,52)-r1x2E*VR1(47,52)&
   +3D0*r1x2E*(VS0(47,31)-ZxZpE*VS1(47,31))&
   +2D0*HfxZpE*VS1(26,52)
VS0(47,81)=QCz*VS0(47,53)+WQz*VS1(47,53)-r1x2E*VR1(47,53)&
   +3D0*r1x2E*(VS0(47,32)-ZxZpE*VS1(47,32))&
   +2D0*HfxZpE*VS1(26,53)
VS0(47,82)=QCz*VS0(47,54)+WQz*VS1(47,54)-r1x2E*VR1(47,54)&
   +4D0*r1x2E*(VS0(47,33)-ZxZpE*VS1(47,33))&
   +2D0*HfxZpE*VS1(26,54)
VS0(47,83)=QCz*VS0(47,55)+WQz*VS1(47,55)-r1x2E*VR1(47,55)&
   +4D0*r1x2E*(VS0(47,34)-ZxZpE*VS1(47,34))&
   +2D0*HfxZpE*VS1(26,55)
VS0(47,84)=QCz*VS0(47,56)+WQz*VS1(47,56)-r1x2E*VR1(47,56)&
   +5D0*r1x2E*(VS0(47,35)-ZxZpE*VS1(47,35))&
   +2D0*HfxZpE*VS1(26,56)
VS0(48,57)=QCx*VS0(48,36)+WQx*VS1(48,36)&
   +5D0*r1x2E*(VS0(48,21)-ZxZpE*VS1(48,21))&
   +2D0*HfxZpE*VS1(31,36)
VS0(48,58)=QCx*VS0(48,37)+WQx*VS1(48,37)&
   +4D0*r1x2E*(VS0(48,22)-ZxZpE*VS1(48,22))&
   +2D0*HfxZpE*VS1(31,37)
VS0(48,59)=QCx*VS0(48,38)+WQx*VS1(48,38)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +2D0*HfxZpE*VS1(31,38)
VS0(48,60)=QCx*VS0(48,39)+WQx*VS1(48,39)&
   +2D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +2D0*HfxZpE*VS1(31,39)
VS0(48,61)=QCy*VS0(48,39)+WQy*VS1(48,39)&
   +3D0*r1x2E*(VS0(48,23)-ZxZpE*VS1(48,23))&
   +HfxZpE*VS1(30,39)
VS0(48,62)=QCy*VS0(48,40)+WQy*VS1(48,40)&
   +4D0*r1x2E*(VS0(48,24)-ZxZpE*VS1(48,24))&
   +HfxZpE*VS1(30,40)
VS0(48,63)=QCy*VS0(48,41)+WQy*VS1(48,41)&
   +5D0*r1x2E*(VS0(48,25)-ZxZpE*VS1(48,25))&
   +HfxZpE*VS1(30,41)
VS0(48,64)=QCx*VS0(48,42)+WQx*VS1(48,42)&
   +4D0*r1x2E*(VS0(48,26)-ZxZpE*VS1(48,26))&
   +2D0*HfxZpE*VS1(31,42)
VS0(48,65)=QCx*VS0(48,43)+WQx*VS1(48,43)&
   +3D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(31,43)
VS0(48,66)=QCx*VS0(48,44)+WQx*VS1(48,44)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(31,44)
VS0(48,67)=QCy*VS0(48,44)+WQy*VS1(48,44)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +HfxZpE*VS1(30,44)
VS0(48,68)=QCy*VS0(48,45)+WQy*VS1(48,45)&
   +3D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +HfxZpE*VS1(30,45)
VS0(48,69)=QCy*VS0(48,46)+WQy*VS1(48,46)&
   +4D0*r1x2E*(VS0(48,29)-ZxZpE*VS1(48,29))&
   +HfxZpE*VS1(30,46)
VS0(48,70)=QCx*VS0(48,47)+WQx*VS1(48,47)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(31,47)
VS0(48,71)=QCx*VS0(48,48)+WQx*VS1(48,48)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(31,48)
VS0(48,72)=QCx*VS0(48,49)+WQx*VS1(48,49)&
   +r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(31,49)
VS0(48,73)=QCy*VS0(48,49)+WQy*VS1(48,49)&
   +2D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +HfxZpE*VS1(30,49)
VS0(48,74)=QCy*VS0(48,50)+WQy*VS1(48,50)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +HfxZpE*VS1(30,50)
VS0(48,75)=QCx*VS0(48,51)+WQx*VS1(48,51)&
   +2D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(31,51)
VS0(48,76)=QCz*VS0(48,48)+WQz*VS1(48,48)-r1x2E*VR1(48,48)&
   +2D0*r1x2E*(VS0(48,27)-ZxZpE*VS1(48,27))&
   +2D0*HfxZpE*VS1(27,48)
VS0(48,77)=QCz*VS0(48,49)+WQz*VS1(48,49)-r1x2E*VR1(48,49)&
   +2D0*r1x2E*(VS0(48,28)-ZxZpE*VS1(48,28))&
   +2D0*HfxZpE*VS1(27,49)
VS0(48,78)=QCy*VS0(48,53)+WQy*VS1(48,53)&
   +2D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +HfxZpE*VS1(30,53)
VS0(48,79)=QCz*VS0(48,51)+WQz*VS1(48,51)-r1x2E*VR1(48,51)&
   +3D0*r1x2E*(VS0(48,30)-ZxZpE*VS1(48,30))&
   +2D0*HfxZpE*VS1(27,51)
VS0(48,80)=QCz*VS0(48,52)+WQz*VS1(48,52)-r1x2E*VR1(48,52)&
   +3D0*r1x2E*(VS0(48,31)-ZxZpE*VS1(48,31))&
   +2D0*HfxZpE*VS1(27,52)
VS0(48,81)=QCz*VS0(48,53)+WQz*VS1(48,53)-r1x2E*VR1(48,53)&
   +3D0*r1x2E*(VS0(48,32)-ZxZpE*VS1(48,32))&
   +2D0*HfxZpE*VS1(27,53)
VS0(48,82)=QCz*VS0(48,54)+WQz*VS1(48,54)-r1x2E*VR1(48,54)&
   +4D0*r1x2E*(VS0(48,33)-ZxZpE*VS1(48,33))&
   +2D0*HfxZpE*VS1(27,54)
VS0(48,83)=QCz*VS0(48,55)+WQz*VS1(48,55)-r1x2E*VR1(48,55)&
   +4D0*r1x2E*(VS0(48,34)-ZxZpE*VS1(48,34))&
   +2D0*HfxZpE*VS1(27,55)
VS0(48,84)=QCz*VS0(48,56)+WQz*VS1(48,56)-r1x2E*VR1(48,56)&
   +5D0*r1x2E*(VS0(48,35)-ZxZpE*VS1(48,35))&
   +2D0*HfxZpE*VS1(27,56)
VS0(49,57)=QCx*VS0(49,36)+WQx*VS1(49,36)&
   +5D0*r1x2E*(VS0(49,21)-ZxZpE*VS1(49,21))&
   +HfxZpE*VS1(32,36)
VS0(49,58)=QCx*VS0(49,37)+WQx*VS1(49,37)&
   +4D0*r1x2E*(VS0(49,22)-ZxZpE*VS1(49,22))&
   +HfxZpE*VS1(32,37)
VS0(49,59)=QCx*VS0(49,38)+WQx*VS1(49,38)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +HfxZpE*VS1(32,38)
VS0(49,60)=QCx*VS0(49,39)+WQx*VS1(49,39)&
   +2D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +HfxZpE*VS1(32,39)
VS0(49,61)=QCy*VS0(49,39)+WQy*VS1(49,39)&
   +3D0*r1x2E*(VS0(49,23)-ZxZpE*VS1(49,23))&
   +2D0*HfxZpE*VS1(31,39)
VS0(49,62)=QCy*VS0(49,40)+WQy*VS1(49,40)&
   +4D0*r1x2E*(VS0(49,24)-ZxZpE*VS1(49,24))&
   +2D0*HfxZpE*VS1(31,40)
VS0(49,63)=QCy*VS0(49,41)+WQy*VS1(49,41)&
   +5D0*r1x2E*(VS0(49,25)-ZxZpE*VS1(49,25))&
   +2D0*HfxZpE*VS1(31,41)
VS0(49,64)=QCx*VS0(49,42)+WQx*VS1(49,42)&
   +4D0*r1x2E*(VS0(49,26)-ZxZpE*VS1(49,26))&
   +HfxZpE*VS1(32,42)
VS0(49,65)=QCx*VS0(49,43)+WQx*VS1(49,43)&
   +3D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +HfxZpE*VS1(32,43)
VS0(49,66)=QCx*VS0(49,44)+WQx*VS1(49,44)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +HfxZpE*VS1(32,44)
VS0(49,67)=QCy*VS0(49,44)+WQy*VS1(49,44)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(31,44)
VS0(49,68)=QCy*VS0(49,45)+WQy*VS1(49,45)&
   +3D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(31,45)
VS0(49,69)=QCy*VS0(49,46)+WQy*VS1(49,46)&
   +4D0*r1x2E*(VS0(49,29)-ZxZpE*VS1(49,29))&
   +2D0*HfxZpE*VS1(31,46)
VS0(49,70)=QCx*VS0(49,47)+WQx*VS1(49,47)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +HfxZpE*VS1(32,47)
VS0(49,71)=QCx*VS0(49,48)+WQx*VS1(49,48)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +HfxZpE*VS1(32,48)
VS0(49,72)=QCx*VS0(49,49)+WQx*VS1(49,49)&
   +r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +HfxZpE*VS1(32,49)
VS0(49,73)=QCy*VS0(49,49)+WQy*VS1(49,49)&
   +2D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(31,49)
VS0(49,74)=QCy*VS0(49,50)+WQy*VS1(49,50)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(31,50)
VS0(49,75)=QCx*VS0(49,51)+WQx*VS1(49,51)&
   +2D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +HfxZpE*VS1(32,51)
VS0(49,76)=QCz*VS0(49,48)+WQz*VS1(49,48)-r1x2E*VR1(49,48)&
   +2D0*r1x2E*(VS0(49,27)-ZxZpE*VS1(49,27))&
   +2D0*HfxZpE*VS1(28,48)
VS0(49,77)=QCz*VS0(49,49)+WQz*VS1(49,49)-r1x2E*VR1(49,49)&
   +2D0*r1x2E*(VS0(49,28)-ZxZpE*VS1(49,28))&
   +2D0*HfxZpE*VS1(28,49)
VS0(49,78)=QCy*VS0(49,53)+WQy*VS1(49,53)&
   +2D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(31,53)
VS0(49,79)=QCz*VS0(49,51)+WQz*VS1(49,51)-r1x2E*VR1(49,51)&
   +3D0*r1x2E*(VS0(49,30)-ZxZpE*VS1(49,30))&
   +2D0*HfxZpE*VS1(28,51)
VS0(49,80)=QCz*VS0(49,52)+WQz*VS1(49,52)-r1x2E*VR1(49,52)&
   +3D0*r1x2E*(VS0(49,31)-ZxZpE*VS1(49,31))&
   +2D0*HfxZpE*VS1(28,52)
VS0(49,81)=QCz*VS0(49,53)+WQz*VS1(49,53)-r1x2E*VR1(49,53)&
   +3D0*r1x2E*(VS0(49,32)-ZxZpE*VS1(49,32))&
   +2D0*HfxZpE*VS1(28,53)
VS0(49,82)=QCz*VS0(49,54)+WQz*VS1(49,54)-r1x2E*VR1(49,54)&
   +4D0*r1x2E*(VS0(49,33)-ZxZpE*VS1(49,33))&
   +2D0*HfxZpE*VS1(28,54)
VS0(49,83)=QCz*VS0(49,55)+WQz*VS1(49,55)-r1x2E*VR1(49,55)&
   +4D0*r1x2E*(VS0(49,34)-ZxZpE*VS1(49,34))&
   +2D0*HfxZpE*VS1(28,55)
VS0(49,84)=QCz*VS0(49,56)+WQz*VS1(49,56)-r1x2E*VR1(49,56)&
   +5D0*r1x2E*(VS0(49,35)-ZxZpE*VS1(49,35))&
   +2D0*HfxZpE*VS1(28,56)
VS0(50,57)=QCx*VS0(50,36)+WQx*VS1(50,36)&
   +5D0*r1x2E*(VS0(50,21)-ZxZpE*VS1(50,21))
VS0(50,58)=QCx*VS0(50,37)+WQx*VS1(50,37)&
   +4D0*r1x2E*(VS0(50,22)-ZxZpE*VS1(50,22))
VS0(50,59)=QCx*VS0(50,38)+WQx*VS1(50,38)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))
VS0(50,60)=QCx*VS0(50,39)+WQx*VS1(50,39)&
   +2D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))
VS0(50,61)=QCy*VS0(50,39)+WQy*VS1(50,39)&
   +3D0*r1x2E*(VS0(50,23)-ZxZpE*VS1(50,23))&
   +3D0*HfxZpE*VS1(32,39)
VS0(50,62)=QCy*VS0(50,40)+WQy*VS1(50,40)&
   +4D0*r1x2E*(VS0(50,24)-ZxZpE*VS1(50,24))&
   +3D0*HfxZpE*VS1(32,40)
VS0(50,63)=QCy*VS0(50,41)+WQy*VS1(50,41)&
   +5D0*r1x2E*(VS0(50,25)-ZxZpE*VS1(50,25))&
   +3D0*HfxZpE*VS1(32,41)
VS0(50,64)=QCx*VS0(50,42)+WQx*VS1(50,42)&
   +4D0*r1x2E*(VS0(50,26)-ZxZpE*VS1(50,26))
VS0(50,65)=QCx*VS0(50,43)+WQx*VS1(50,43)&
   +3D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))
VS0(50,66)=QCx*VS0(50,44)+WQx*VS1(50,44)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))
VS0(50,67)=QCy*VS0(50,44)+WQy*VS1(50,44)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +3D0*HfxZpE*VS1(32,44)
VS0(50,68)=QCy*VS0(50,45)+WQy*VS1(50,45)&
   +3D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +3D0*HfxZpE*VS1(32,45)
VS0(50,69)=QCy*VS0(50,46)+WQy*VS1(50,46)&
   +4D0*r1x2E*(VS0(50,29)-ZxZpE*VS1(50,29))&
   +3D0*HfxZpE*VS1(32,46)
VS0(50,70)=QCx*VS0(50,47)+WQx*VS1(50,47)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))
VS0(50,71)=QCx*VS0(50,48)+WQx*VS1(50,48)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))
VS0(50,72)=QCx*VS0(50,49)+WQx*VS1(50,49)&
   +r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))
VS0(50,73)=QCy*VS0(50,49)+WQy*VS1(50,49)&
   +2D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +3D0*HfxZpE*VS1(32,49)
VS0(50,74)=QCy*VS0(50,50)+WQy*VS1(50,50)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +3D0*HfxZpE*VS1(32,50)
VS0(50,75)=QCx*VS0(50,51)+WQx*VS1(50,51)&
   +2D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))
VS0(50,76)=QCz*VS0(50,48)+WQz*VS1(50,48)-r1x2E*VR1(50,48)&
   +2D0*r1x2E*(VS0(50,27)-ZxZpE*VS1(50,27))&
   +2D0*HfxZpE*VS1(29,48)
VS0(50,77)=QCz*VS0(50,49)+WQz*VS1(50,49)-r1x2E*VR1(50,49)&
   +2D0*r1x2E*(VS0(50,28)-ZxZpE*VS1(50,28))&
   +2D0*HfxZpE*VS1(29,49)
VS0(50,78)=QCy*VS0(50,53)+WQy*VS1(50,53)&
   +2D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +3D0*HfxZpE*VS1(32,53)
VS0(50,79)=QCz*VS0(50,51)+WQz*VS1(50,51)-r1x2E*VR1(50,51)&
   +3D0*r1x2E*(VS0(50,30)-ZxZpE*VS1(50,30))&
   +2D0*HfxZpE*VS1(29,51)
VS0(50,80)=QCz*VS0(50,52)+WQz*VS1(50,52)-r1x2E*VR1(50,52)&
   +3D0*r1x2E*(VS0(50,31)-ZxZpE*VS1(50,31))&
   +2D0*HfxZpE*VS1(29,52)
VS0(50,81)=QCz*VS0(50,53)+WQz*VS1(50,53)-r1x2E*VR1(50,53)&
   +3D0*r1x2E*(VS0(50,32)-ZxZpE*VS1(50,32))&
   +2D0*HfxZpE*VS1(29,53)
VS0(50,82)=QCz*VS0(50,54)+WQz*VS1(50,54)-r1x2E*VR1(50,54)&
   +4D0*r1x2E*(VS0(50,33)-ZxZpE*VS1(50,33))&
   +2D0*HfxZpE*VS1(29,54)
VS0(50,83)=QCz*VS0(50,55)+WQz*VS1(50,55)-r1x2E*VR1(50,55)&
   +4D0*r1x2E*(VS0(50,34)-ZxZpE*VS1(50,34))&
   +2D0*HfxZpE*VS1(29,55)
VS0(50,84)=QCz*VS0(50,56)+WQz*VS1(50,56)-r1x2E*VR1(50,56)&
   +5D0*r1x2E*(VS0(50,35)-ZxZpE*VS1(50,35))&
   +2D0*HfxZpE*VS1(29,56)
VS0(51,57)=QCx*VS0(51,36)+WQx*VS1(51,36)&
   +5D0*r1x2E*(VS0(51,21)-ZxZpE*VS1(51,21))&
   +2D0*HfxZpE*VS1(33,36)
VS0(51,58)=QCx*VS0(51,37)+WQx*VS1(51,37)&
   +4D0*r1x2E*(VS0(51,22)-ZxZpE*VS1(51,22))&
   +2D0*HfxZpE*VS1(33,37)
VS0(51,59)=QCx*VS0(51,38)+WQx*VS1(51,38)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))&
   +2D0*HfxZpE*VS1(33,38)
VS0(51,60)=QCx*VS0(51,39)+WQx*VS1(51,39)&
   +2D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))&
   +2D0*HfxZpE*VS1(33,39)
VS0(51,61)=QCy*VS0(51,39)+WQy*VS1(51,39)&
   +3D0*r1x2E*(VS0(51,23)-ZxZpE*VS1(51,23))
VS0(51,62)=QCy*VS0(51,40)+WQy*VS1(51,40)&
   +4D0*r1x2E*(VS0(51,24)-ZxZpE*VS1(51,24))
VS0(51,63)=QCy*VS0(51,41)+WQy*VS1(51,41)&
   +5D0*r1x2E*(VS0(51,25)-ZxZpE*VS1(51,25))
VS0(51,64)=QCx*VS0(51,42)+WQx*VS1(51,42)&
   +4D0*r1x2E*(VS0(51,26)-ZxZpE*VS1(51,26))&
   +2D0*HfxZpE*VS1(33,42)
VS0(51,65)=QCx*VS0(51,43)+WQx*VS1(51,43)&
   +3D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +2D0*HfxZpE*VS1(33,43)
VS0(51,66)=QCx*VS0(51,44)+WQx*VS1(51,44)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +2D0*HfxZpE*VS1(33,44)
VS0(51,67)=QCy*VS0(51,44)+WQy*VS1(51,44)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))
VS0(51,68)=QCy*VS0(51,45)+WQy*VS1(51,45)&
   +3D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))
VS0(51,69)=QCy*VS0(51,46)+WQy*VS1(51,46)&
   +4D0*r1x2E*(VS0(51,29)-ZxZpE*VS1(51,29))
VS0(51,70)=QCx*VS0(51,47)+WQx*VS1(51,47)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +2D0*HfxZpE*VS1(33,47)
VS0(51,71)=QCx*VS0(51,48)+WQx*VS1(51,48)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +2D0*HfxZpE*VS1(33,48)
VS0(51,72)=QCx*VS0(51,49)+WQx*VS1(51,49)&
   +r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +2D0*HfxZpE*VS1(33,49)
VS0(51,73)=QCy*VS0(51,49)+WQy*VS1(51,49)&
   +2D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))
VS0(51,74)=QCy*VS0(51,50)+WQy*VS1(51,50)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))
VS0(51,75)=QCx*VS0(51,51)+WQx*VS1(51,51)&
   +2D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +2D0*HfxZpE*VS1(33,51)
VS0(51,76)=QCz*VS0(51,48)+WQz*VS1(51,48)-r1x2E*VR1(51,48)&
   +2D0*r1x2E*(VS0(51,27)-ZxZpE*VS1(51,27))&
   +3D0*HfxZpE*VS1(30,48)
VS0(51,77)=QCz*VS0(51,49)+WQz*VS1(51,49)-r1x2E*VR1(51,49)&
   +2D0*r1x2E*(VS0(51,28)-ZxZpE*VS1(51,28))&
   +3D0*HfxZpE*VS1(30,49)
VS0(51,78)=QCy*VS0(51,53)+WQy*VS1(51,53)&
   +2D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))
VS0(51,79)=QCz*VS0(51,51)+WQz*VS1(51,51)-r1x2E*VR1(51,51)&
   +3D0*r1x2E*(VS0(51,30)-ZxZpE*VS1(51,30))&
   +3D0*HfxZpE*VS1(30,51)
VS0(51,80)=QCz*VS0(51,52)+WQz*VS1(51,52)-r1x2E*VR1(51,52)&
   +3D0*r1x2E*(VS0(51,31)-ZxZpE*VS1(51,31))&
   +3D0*HfxZpE*VS1(30,52)
VS0(51,81)=QCz*VS0(51,53)+WQz*VS1(51,53)-r1x2E*VR1(51,53)&
   +3D0*r1x2E*(VS0(51,32)-ZxZpE*VS1(51,32))&
   +3D0*HfxZpE*VS1(30,53)
VS0(51,82)=QCz*VS0(51,54)+WQz*VS1(51,54)-r1x2E*VR1(51,54)&
   +4D0*r1x2E*(VS0(51,33)-ZxZpE*VS1(51,33))&
   +3D0*HfxZpE*VS1(30,54)
VS0(51,83)=QCz*VS0(51,55)+WQz*VS1(51,55)-r1x2E*VR1(51,55)&
   +4D0*r1x2E*(VS0(51,34)-ZxZpE*VS1(51,34))&
   +3D0*HfxZpE*VS1(30,55)
VS0(51,84)=QCz*VS0(51,56)+WQz*VS1(51,56)-r1x2E*VR1(51,56)&
   +5D0*r1x2E*(VS0(51,35)-ZxZpE*VS1(51,35))&
   +3D0*HfxZpE*VS1(30,56)
VS0(52,57)=QCx*VS0(52,36)+WQx*VS1(52,36)&
   +5D0*r1x2E*(VS0(52,21)-ZxZpE*VS1(52,21))&
   +HfxZpE*VS1(34,36)
VS0(52,58)=QCx*VS0(52,37)+WQx*VS1(52,37)&
   +4D0*r1x2E*(VS0(52,22)-ZxZpE*VS1(52,22))&
   +HfxZpE*VS1(34,37)
VS0(52,59)=QCx*VS0(52,38)+WQx*VS1(52,38)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(34,38)
VS0(52,60)=QCx*VS0(52,39)+WQx*VS1(52,39)&
   +2D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(34,39)
VS0(52,61)=QCy*VS0(52,39)+WQy*VS1(52,39)&
   +3D0*r1x2E*(VS0(52,23)-ZxZpE*VS1(52,23))&
   +HfxZpE*VS1(33,39)
VS0(52,62)=QCy*VS0(52,40)+WQy*VS1(52,40)&
   +4D0*r1x2E*(VS0(52,24)-ZxZpE*VS1(52,24))&
   +HfxZpE*VS1(33,40)
VS0(52,63)=QCy*VS0(52,41)+WQy*VS1(52,41)&
   +5D0*r1x2E*(VS0(52,25)-ZxZpE*VS1(52,25))&
   +HfxZpE*VS1(33,41)
VS0(52,64)=QCx*VS0(52,42)+WQx*VS1(52,42)&
   +4D0*r1x2E*(VS0(52,26)-ZxZpE*VS1(52,26))&
   +HfxZpE*VS1(34,42)
VS0(52,65)=QCx*VS0(52,43)+WQx*VS1(52,43)&
   +3D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(34,43)
VS0(52,66)=QCx*VS0(52,44)+WQx*VS1(52,44)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(34,44)
VS0(52,67)=QCy*VS0(52,44)+WQy*VS1(52,44)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +HfxZpE*VS1(33,44)
VS0(52,68)=QCy*VS0(52,45)+WQy*VS1(52,45)&
   +3D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +HfxZpE*VS1(33,45)
VS0(52,69)=QCy*VS0(52,46)+WQy*VS1(52,46)&
   +4D0*r1x2E*(VS0(52,29)-ZxZpE*VS1(52,29))&
   +HfxZpE*VS1(33,46)
VS0(52,70)=QCx*VS0(52,47)+WQx*VS1(52,47)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +HfxZpE*VS1(34,47)
VS0(52,71)=QCx*VS0(52,48)+WQx*VS1(52,48)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(34,48)
VS0(52,72)=QCx*VS0(52,49)+WQx*VS1(52,49)&
   +r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(34,49)
VS0(52,73)=QCy*VS0(52,49)+WQy*VS1(52,49)&
   +2D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +HfxZpE*VS1(33,49)
VS0(52,74)=QCy*VS0(52,50)+WQy*VS1(52,50)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +HfxZpE*VS1(33,50)
VS0(52,75)=QCx*VS0(52,51)+WQx*VS1(52,51)&
   +2D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +HfxZpE*VS1(34,51)
VS0(52,76)=QCz*VS0(52,48)+WQz*VS1(52,48)-r1x2E*VR1(52,48)&
   +2D0*r1x2E*(VS0(52,27)-ZxZpE*VS1(52,27))&
   +3D0*HfxZpE*VS1(31,48)
VS0(52,77)=QCz*VS0(52,49)+WQz*VS1(52,49)-r1x2E*VR1(52,49)&
   +2D0*r1x2E*(VS0(52,28)-ZxZpE*VS1(52,28))&
   +3D0*HfxZpE*VS1(31,49)
VS0(52,78)=QCy*VS0(52,53)+WQy*VS1(52,53)&
   +2D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +HfxZpE*VS1(33,53)
VS0(52,79)=QCz*VS0(52,51)+WQz*VS1(52,51)-r1x2E*VR1(52,51)&
   +3D0*r1x2E*(VS0(52,30)-ZxZpE*VS1(52,30))&
   +3D0*HfxZpE*VS1(31,51)
VS0(52,80)=QCz*VS0(52,52)+WQz*VS1(52,52)-r1x2E*VR1(52,52)&
   +3D0*r1x2E*(VS0(52,31)-ZxZpE*VS1(52,31))&
   +3D0*HfxZpE*VS1(31,52)
VS0(52,81)=QCz*VS0(52,53)+WQz*VS1(52,53)-r1x2E*VR1(52,53)&
   +3D0*r1x2E*(VS0(52,32)-ZxZpE*VS1(52,32))&
   +3D0*HfxZpE*VS1(31,53)
VS0(52,82)=QCz*VS0(52,54)+WQz*VS1(52,54)-r1x2E*VR1(52,54)&
   +4D0*r1x2E*(VS0(52,33)-ZxZpE*VS1(52,33))&
   +3D0*HfxZpE*VS1(31,54)
VS0(52,83)=QCz*VS0(52,55)+WQz*VS1(52,55)-r1x2E*VR1(52,55)&
   +4D0*r1x2E*(VS0(52,34)-ZxZpE*VS1(52,34))&
   +3D0*HfxZpE*VS1(31,55)
VS0(52,84)=QCz*VS0(52,56)+WQz*VS1(52,56)-r1x2E*VR1(52,56)&
   +5D0*r1x2E*(VS0(52,35)-ZxZpE*VS1(52,35))&
   +3D0*HfxZpE*VS1(31,56)
VS0(53,57)=QCx*VS0(53,36)+WQx*VS1(53,36)&
   +5D0*r1x2E*(VS0(53,21)-ZxZpE*VS1(53,21))
VS0(53,58)=QCx*VS0(53,37)+WQx*VS1(53,37)&
   +4D0*r1x2E*(VS0(53,22)-ZxZpE*VS1(53,22))
VS0(53,59)=QCx*VS0(53,38)+WQx*VS1(53,38)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))
VS0(53,60)=QCx*VS0(53,39)+WQx*VS1(53,39)&
   +2D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))
VS0(53,61)=QCy*VS0(53,39)+WQy*VS1(53,39)&
   +3D0*r1x2E*(VS0(53,23)-ZxZpE*VS1(53,23))&
   +2D0*HfxZpE*VS1(34,39)
VS0(53,62)=QCy*VS0(53,40)+WQy*VS1(53,40)&
   +4D0*r1x2E*(VS0(53,24)-ZxZpE*VS1(53,24))&
   +2D0*HfxZpE*VS1(34,40)
VS0(53,63)=QCy*VS0(53,41)+WQy*VS1(53,41)&
   +5D0*r1x2E*(VS0(53,25)-ZxZpE*VS1(53,25))&
   +2D0*HfxZpE*VS1(34,41)
VS0(53,64)=QCx*VS0(53,42)+WQx*VS1(53,42)&
   +4D0*r1x2E*(VS0(53,26)-ZxZpE*VS1(53,26))
VS0(53,65)=QCx*VS0(53,43)+WQx*VS1(53,43)&
   +3D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))
VS0(53,66)=QCx*VS0(53,44)+WQx*VS1(53,44)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))
VS0(53,67)=QCy*VS0(53,44)+WQy*VS1(53,44)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +2D0*HfxZpE*VS1(34,44)
VS0(53,68)=QCy*VS0(53,45)+WQy*VS1(53,45)&
   +3D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +2D0*HfxZpE*VS1(34,45)
VS0(53,69)=QCy*VS0(53,46)+WQy*VS1(53,46)&
   +4D0*r1x2E*(VS0(53,29)-ZxZpE*VS1(53,29))&
   +2D0*HfxZpE*VS1(34,46)
VS0(53,70)=QCx*VS0(53,47)+WQx*VS1(53,47)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))
VS0(53,71)=QCx*VS0(53,48)+WQx*VS1(53,48)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))
VS0(53,72)=QCx*VS0(53,49)+WQx*VS1(53,49)&
   +r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))
VS0(53,73)=QCy*VS0(53,49)+WQy*VS1(53,49)&
   +2D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +2D0*HfxZpE*VS1(34,49)
VS0(53,74)=QCy*VS0(53,50)+WQy*VS1(53,50)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +2D0*HfxZpE*VS1(34,50)
VS0(53,75)=QCx*VS0(53,51)+WQx*VS1(53,51)&
   +2D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))
VS0(53,76)=QCz*VS0(53,48)+WQz*VS1(53,48)-r1x2E*VR1(53,48)&
   +2D0*r1x2E*(VS0(53,27)-ZxZpE*VS1(53,27))&
   +3D0*HfxZpE*VS1(32,48)
VS0(53,77)=QCz*VS0(53,49)+WQz*VS1(53,49)-r1x2E*VR1(53,49)&
   +2D0*r1x2E*(VS0(53,28)-ZxZpE*VS1(53,28))&
   +3D0*HfxZpE*VS1(32,49)
VS0(53,78)=QCy*VS0(53,53)+WQy*VS1(53,53)&
   +2D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +2D0*HfxZpE*VS1(34,53)
VS0(53,79)=QCz*VS0(53,51)+WQz*VS1(53,51)-r1x2E*VR1(53,51)&
   +3D0*r1x2E*(VS0(53,30)-ZxZpE*VS1(53,30))&
   +3D0*HfxZpE*VS1(32,51)
VS0(53,80)=QCz*VS0(53,52)+WQz*VS1(53,52)-r1x2E*VR1(53,52)&
   +3D0*r1x2E*(VS0(53,31)-ZxZpE*VS1(53,31))&
   +3D0*HfxZpE*VS1(32,52)
VS0(53,81)=QCz*VS0(53,53)+WQz*VS1(53,53)-r1x2E*VR1(53,53)&
   +3D0*r1x2E*(VS0(53,32)-ZxZpE*VS1(53,32))&
   +3D0*HfxZpE*VS1(32,53)
VS0(53,82)=QCz*VS0(53,54)+WQz*VS1(53,54)-r1x2E*VR1(53,54)&
   +4D0*r1x2E*(VS0(53,33)-ZxZpE*VS1(53,33))&
   +3D0*HfxZpE*VS1(32,54)
VS0(53,83)=QCz*VS0(53,55)+WQz*VS1(53,55)-r1x2E*VR1(53,55)&
   +4D0*r1x2E*(VS0(53,34)-ZxZpE*VS1(53,34))&
   +3D0*HfxZpE*VS1(32,55)
VS0(53,84)=QCz*VS0(53,56)+WQz*VS1(53,56)-r1x2E*VR1(53,56)&
   +5D0*r1x2E*(VS0(53,35)-ZxZpE*VS1(53,35))&
   +3D0*HfxZpE*VS1(32,56)
VS0(54,57)=QCx*VS0(54,36)+WQx*VS1(54,36)&
   +5D0*r1x2E*(VS0(54,21)-ZxZpE*VS1(54,21))&
   +HfxZpE*VS1(35,36)
VS0(54,58)=QCx*VS0(54,37)+WQx*VS1(54,37)&
   +4D0*r1x2E*(VS0(54,22)-ZxZpE*VS1(54,22))&
   +HfxZpE*VS1(35,37)
VS0(54,59)=QCx*VS0(54,38)+WQx*VS1(54,38)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))&
   +HfxZpE*VS1(35,38)
VS0(54,60)=QCx*VS0(54,39)+WQx*VS1(54,39)&
   +2D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))&
   +HfxZpE*VS1(35,39)
VS0(54,61)=QCy*VS0(54,39)+WQy*VS1(54,39)&
   +3D0*r1x2E*(VS0(54,23)-ZxZpE*VS1(54,23))
VS0(54,62)=QCy*VS0(54,40)+WQy*VS1(54,40)&
   +4D0*r1x2E*(VS0(54,24)-ZxZpE*VS1(54,24))
VS0(54,63)=QCy*VS0(54,41)+WQy*VS1(54,41)&
   +5D0*r1x2E*(VS0(54,25)-ZxZpE*VS1(54,25))
VS0(54,64)=QCx*VS0(54,42)+WQx*VS1(54,42)&
   +4D0*r1x2E*(VS0(54,26)-ZxZpE*VS1(54,26))&
   +HfxZpE*VS1(35,42)
VS0(54,65)=QCx*VS0(54,43)+WQx*VS1(54,43)&
   +3D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +HfxZpE*VS1(35,43)
VS0(54,66)=QCx*VS0(54,44)+WQx*VS1(54,44)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +HfxZpE*VS1(35,44)
VS0(54,67)=QCy*VS0(54,44)+WQy*VS1(54,44)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))
VS0(54,68)=QCy*VS0(54,45)+WQy*VS1(54,45)&
   +3D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))
VS0(54,69)=QCy*VS0(54,46)+WQy*VS1(54,46)&
   +4D0*r1x2E*(VS0(54,29)-ZxZpE*VS1(54,29))
VS0(54,70)=QCx*VS0(54,47)+WQx*VS1(54,47)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +HfxZpE*VS1(35,47)
VS0(54,71)=QCx*VS0(54,48)+WQx*VS1(54,48)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +HfxZpE*VS1(35,48)
VS0(54,72)=QCx*VS0(54,49)+WQx*VS1(54,49)&
   +r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +HfxZpE*VS1(35,49)
VS0(54,73)=QCy*VS0(54,49)+WQy*VS1(54,49)&
   +2D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))
VS0(54,74)=QCy*VS0(54,50)+WQy*VS1(54,50)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))
VS0(54,75)=QCx*VS0(54,51)+WQx*VS1(54,51)&
   +2D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +HfxZpE*VS1(35,51)
VS0(54,76)=QCz*VS0(54,48)+WQz*VS1(54,48)-r1x2E*VR1(54,48)&
   +2D0*r1x2E*(VS0(54,27)-ZxZpE*VS1(54,27))&
   +4D0*HfxZpE*VS1(33,48)
VS0(54,77)=QCz*VS0(54,49)+WQz*VS1(54,49)-r1x2E*VR1(54,49)&
   +2D0*r1x2E*(VS0(54,28)-ZxZpE*VS1(54,28))&
   +4D0*HfxZpE*VS1(33,49)
VS0(54,78)=QCy*VS0(54,53)+WQy*VS1(54,53)&
   +2D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))
VS0(54,79)=QCz*VS0(54,51)+WQz*VS1(54,51)-r1x2E*VR1(54,51)&
   +3D0*r1x2E*(VS0(54,30)-ZxZpE*VS1(54,30))&
   +4D0*HfxZpE*VS1(33,51)
VS0(54,80)=QCz*VS0(54,52)+WQz*VS1(54,52)-r1x2E*VR1(54,52)&
   +3D0*r1x2E*(VS0(54,31)-ZxZpE*VS1(54,31))&
   +4D0*HfxZpE*VS1(33,52)
VS0(54,81)=QCz*VS0(54,53)+WQz*VS1(54,53)-r1x2E*VR1(54,53)&
   +3D0*r1x2E*(VS0(54,32)-ZxZpE*VS1(54,32))&
   +4D0*HfxZpE*VS1(33,53)
VS0(54,82)=QCz*VS0(54,54)+WQz*VS1(54,54)-r1x2E*VR1(54,54)&
   +4D0*r1x2E*(VS0(54,33)-ZxZpE*VS1(54,33))&
   +4D0*HfxZpE*VS1(33,54)
VS0(54,83)=QCz*VS0(54,55)+WQz*VS1(54,55)-r1x2E*VR1(54,55)&
   +4D0*r1x2E*(VS0(54,34)-ZxZpE*VS1(54,34))&
   +4D0*HfxZpE*VS1(33,55)
VS0(54,84)=QCz*VS0(54,56)+WQz*VS1(54,56)-r1x2E*VR1(54,56)&
   +5D0*r1x2E*(VS0(54,35)-ZxZpE*VS1(54,35))&
   +4D0*HfxZpE*VS1(33,56)
VS0(55,57)=QCx*VS0(55,36)+WQx*VS1(55,36)&
   +5D0*r1x2E*(VS0(55,21)-ZxZpE*VS1(55,21))
VS0(55,58)=QCx*VS0(55,37)+WQx*VS1(55,37)&
   +4D0*r1x2E*(VS0(55,22)-ZxZpE*VS1(55,22))
VS0(55,59)=QCx*VS0(55,38)+WQx*VS1(55,38)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))
VS0(55,60)=QCx*VS0(55,39)+WQx*VS1(55,39)&
   +2D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))
VS0(55,61)=QCy*VS0(55,39)+WQy*VS1(55,39)&
   +3D0*r1x2E*(VS0(55,23)-ZxZpE*VS1(55,23))&
   +HfxZpE*VS1(35,39)
VS0(55,62)=QCy*VS0(55,40)+WQy*VS1(55,40)&
   +4D0*r1x2E*(VS0(55,24)-ZxZpE*VS1(55,24))&
   +HfxZpE*VS1(35,40)
VS0(55,63)=QCy*VS0(55,41)+WQy*VS1(55,41)&
   +5D0*r1x2E*(VS0(55,25)-ZxZpE*VS1(55,25))&
   +HfxZpE*VS1(35,41)
VS0(55,64)=QCx*VS0(55,42)+WQx*VS1(55,42)&
   +4D0*r1x2E*(VS0(55,26)-ZxZpE*VS1(55,26))
VS0(55,65)=QCx*VS0(55,43)+WQx*VS1(55,43)&
   +3D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))
VS0(55,66)=QCx*VS0(55,44)+WQx*VS1(55,44)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))
VS0(55,67)=QCy*VS0(55,44)+WQy*VS1(55,44)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +HfxZpE*VS1(35,44)
VS0(55,68)=QCy*VS0(55,45)+WQy*VS1(55,45)&
   +3D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +HfxZpE*VS1(35,45)
VS0(55,69)=QCy*VS0(55,46)+WQy*VS1(55,46)&
   +4D0*r1x2E*(VS0(55,29)-ZxZpE*VS1(55,29))&
   +HfxZpE*VS1(35,46)
VS0(55,70)=QCx*VS0(55,47)+WQx*VS1(55,47)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))
VS0(55,71)=QCx*VS0(55,48)+WQx*VS1(55,48)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))
VS0(55,72)=QCx*VS0(55,49)+WQx*VS1(55,49)&
   +r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))
VS0(55,73)=QCy*VS0(55,49)+WQy*VS1(55,49)&
   +2D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +HfxZpE*VS1(35,49)
VS0(55,74)=QCy*VS0(55,50)+WQy*VS1(55,50)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +HfxZpE*VS1(35,50)
VS0(55,75)=QCx*VS0(55,51)+WQx*VS1(55,51)&
   +2D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))
VS0(55,76)=QCz*VS0(55,48)+WQz*VS1(55,48)-r1x2E*VR1(55,48)&
   +2D0*r1x2E*(VS0(55,27)-ZxZpE*VS1(55,27))&
   +4D0*HfxZpE*VS1(34,48)
VS0(55,77)=QCz*VS0(55,49)+WQz*VS1(55,49)-r1x2E*VR1(55,49)&
   +2D0*r1x2E*(VS0(55,28)-ZxZpE*VS1(55,28))&
   +4D0*HfxZpE*VS1(34,49)
VS0(55,78)=QCy*VS0(55,53)+WQy*VS1(55,53)&
   +2D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +HfxZpE*VS1(35,53)
VS0(55,79)=QCz*VS0(55,51)+WQz*VS1(55,51)-r1x2E*VR1(55,51)&
   +3D0*r1x2E*(VS0(55,30)-ZxZpE*VS1(55,30))&
   +4D0*HfxZpE*VS1(34,51)
VS0(55,80)=QCz*VS0(55,52)+WQz*VS1(55,52)-r1x2E*VR1(55,52)&
   +3D0*r1x2E*(VS0(55,31)-ZxZpE*VS1(55,31))&
   +4D0*HfxZpE*VS1(34,52)
VS0(55,81)=QCz*VS0(55,53)+WQz*VS1(55,53)-r1x2E*VR1(55,53)&
   +3D0*r1x2E*(VS0(55,32)-ZxZpE*VS1(55,32))&
   +4D0*HfxZpE*VS1(34,53)
VS0(55,82)=QCz*VS0(55,54)+WQz*VS1(55,54)-r1x2E*VR1(55,54)&
   +4D0*r1x2E*(VS0(55,33)-ZxZpE*VS1(55,33))&
   +4D0*HfxZpE*VS1(34,54)
VS0(55,83)=QCz*VS0(55,55)+WQz*VS1(55,55)-r1x2E*VR1(55,55)&
   +4D0*r1x2E*(VS0(55,34)-ZxZpE*VS1(55,34))&
   +4D0*HfxZpE*VS1(34,55)
VS0(55,84)=QCz*VS0(55,56)+WQz*VS1(55,56)-r1x2E*VR1(55,56)&
   +5D0*r1x2E*(VS0(55,35)-ZxZpE*VS1(55,35))&
   +4D0*HfxZpE*VS1(34,56)
VS0(56,57)=QCx*VS0(56,36)+WQx*VS1(56,36)&
   +5D0*r1x2E*(VS0(56,21)-ZxZpE*VS1(56,21))
VS0(56,58)=QCx*VS0(56,37)+WQx*VS1(56,37)&
   +4D0*r1x2E*(VS0(56,22)-ZxZpE*VS1(56,22))
VS0(56,59)=QCx*VS0(56,38)+WQx*VS1(56,38)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,60)=QCx*VS0(56,39)+WQx*VS1(56,39)&
   +2D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,61)=QCy*VS0(56,39)+WQy*VS1(56,39)&
   +3D0*r1x2E*(VS0(56,23)-ZxZpE*VS1(56,23))
VS0(56,62)=QCy*VS0(56,40)+WQy*VS1(56,40)&
   +4D0*r1x2E*(VS0(56,24)-ZxZpE*VS1(56,24))
VS0(56,63)=QCy*VS0(56,41)+WQy*VS1(56,41)&
   +5D0*r1x2E*(VS0(56,25)-ZxZpE*VS1(56,25))
VS0(56,64)=QCx*VS0(56,42)+WQx*VS1(56,42)&
   +4D0*r1x2E*(VS0(56,26)-ZxZpE*VS1(56,26))
VS0(56,65)=QCx*VS0(56,43)+WQx*VS1(56,43)&
   +3D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,66)=QCx*VS0(56,44)+WQx*VS1(56,44)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,67)=QCy*VS0(56,44)+WQy*VS1(56,44)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))
VS0(56,68)=QCy*VS0(56,45)+WQy*VS1(56,45)&
   +3D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))
VS0(56,69)=QCy*VS0(56,46)+WQy*VS1(56,46)&
   +4D0*r1x2E*(VS0(56,29)-ZxZpE*VS1(56,29))
VS0(56,70)=QCx*VS0(56,47)+WQx*VS1(56,47)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))
VS0(56,71)=QCx*VS0(56,48)+WQx*VS1(56,48)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,72)=QCx*VS0(56,49)+WQx*VS1(56,49)&
   +r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,73)=QCy*VS0(56,49)+WQy*VS1(56,49)&
   +2D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))
VS0(56,74)=QCy*VS0(56,50)+WQy*VS1(56,50)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))
VS0(56,75)=QCx*VS0(56,51)+WQx*VS1(56,51)&
   +2D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))
VS0(56,76)=QCz*VS0(56,48)+WQz*VS1(56,48)-r1x2E*VR1(56,48)&
   +2D0*r1x2E*(VS0(56,27)-ZxZpE*VS1(56,27))&
   +5D0*HfxZpE*VS1(35,48)
VS0(56,77)=QCz*VS0(56,49)+WQz*VS1(56,49)-r1x2E*VR1(56,49)&
   +2D0*r1x2E*(VS0(56,28)-ZxZpE*VS1(56,28))&
   +5D0*HfxZpE*VS1(35,49)
VS0(56,78)=QCy*VS0(56,53)+WQy*VS1(56,53)&
   +2D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))
VS0(56,79)=QCz*VS0(56,51)+WQz*VS1(56,51)-r1x2E*VR1(56,51)&
   +3D0*r1x2E*(VS0(56,30)-ZxZpE*VS1(56,30))&
   +5D0*HfxZpE*VS1(35,51)
VS0(56,80)=QCz*VS0(56,52)+WQz*VS1(56,52)-r1x2E*VR1(56,52)&
   +3D0*r1x2E*(VS0(56,31)-ZxZpE*VS1(56,31))&
   +5D0*HfxZpE*VS1(35,52)
VS0(56,81)=QCz*VS0(56,53)+WQz*VS1(56,53)-r1x2E*VR1(56,53)&
   +3D0*r1x2E*(VS0(56,32)-ZxZpE*VS1(56,32))&
   +5D0*HfxZpE*VS1(35,53)
VS0(56,82)=QCz*VS0(56,54)+WQz*VS1(56,54)-r1x2E*VR1(56,54)&
   +4D0*r1x2E*(VS0(56,33)-ZxZpE*VS1(56,33))&
   +5D0*HfxZpE*VS1(35,54)
VS0(56,83)=QCz*VS0(56,55)+WQz*VS1(56,55)-r1x2E*VR1(56,55)&
   +4D0*r1x2E*(VS0(56,34)-ZxZpE*VS1(56,34))&
   +5D0*HfxZpE*VS1(35,55)
VS0(56,84)=QCz*VS0(56,56)+WQz*VS1(56,56)-r1x2E*VR1(56,56)&
   +5D0*r1x2E*(VS0(56,35)-ZxZpE*VS1(56,35))&
   +5D0*HfxZpE*VS1(35,56)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRh0i0'
STOP
END SELECT
END SUBROUTINE MVRRh0i0
