!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0j0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2E*VRR0(21,38)
      V(2)=r1x2E*ZxZpE*VRR1(21,38)
      V(3)=r1x2E*VRR0(21,39)
      V(4)=HfxZpE*VRR1(11,60)
      V(5)=r1x2E*ZxZpE*VRR1(21,39)
      V(6)=r1x2E*VRR0(21,44)
      V(7)=3.D0*V(6)
      V(8)=r1x2E*ZxZpE*VRR1(21,44)
      V(9)=-3.D0*V(8)
      V(10)=HfxZpE*VRR1(11,67)
      V(11)=r1x2E*VRR0(21,47)
      V(12)=r1x2E*ZxZpE*VRR1(21,47)
      V(13)=r1x2E*VRR0(21,48)
      V(14)=3.D0*V(13)
      V(15)=r1x2E*ZxZpE*VRR1(21,48)
      V(16)=-3.D0*V(15)
      V(17)=HfxZpE*VRR1(11,72)
      V(18)=HfxZpE*VRR1(11,73)
      V(19)=r1x2E*VRR0(21,49)
      V(20)=3.D0*V(19)
      V(21)=r1x2E*ZxZpE*VRR1(21,49)
      V(22)=-3.D0*V(21)
      V(23)=r1x2E*VRR0(21,50)
      V(24)=r1x2E*ZxZpE*VRR1(21,50)
      V(25)=r1x2E*VRR0(21,51)
      V(26)=HfxZpE*VRR1(11,75)
      V(27)=r1x2E*ZxZpE*VRR1(21,51)
      V(28)=HfxZpE*VRR1(11,76)
      V(29)=HfxZpE*VRR1(11,77)
      V(30)=HfxZpE*VRR1(11,78)
      V(31)=r1x2E*VRR0(21,53)
      V(32)=r1x2E*ZxZpE*VRR1(21,53)
      V(33)=r1x2E*VRR0(22,38)
      V(34)=r1x2E*ZxZpE*VRR1(22,38)
      V(35)=r1x2E*VRR0(22,39)
      V(36)=HfxZpE*VRR1(12,60)
      V(37)=r1x2E*ZxZpE*VRR1(22,39)
      V(38)=r1x2E*VRR0(22,44)
      V(39)=3.D0*V(38)
      V(40)=r1x2E*ZxZpE*VRR1(22,44)
      V(41)=-3.D0*V(40)
      V(42)=r1x2E*VRR0(22,45)
      V(43)=HfxZpE*VRR1(12,67)
      V(44)=r1x2E*ZxZpE*VRR1(22,45)
      V(45)=r1x2E*VRR0(22,47)
      V(46)=r1x2E*ZxZpE*VRR1(22,47)
      V(47)=r1x2E*VRR0(22,48)
      V(48)=3.D0*V(47)
      V(49)=r1x2E*ZxZpE*VRR1(22,48)
      V(50)=-3.D0*V(49)
      V(51)=r1x2E*VRR0(22,49)
      V(52)=HfxZpE*VRR1(12,72)
      V(53)=r1x2E*ZxZpE*VRR1(22,49)
      V(54)=3.D0*V(51)
      V(55)=-3.D0*V(53)
      V(56)=r1x2E*VRR0(22,50)
      V(57)=r1x2E*ZxZpE*VRR1(22,50)
      V(58)=r1x2E*VRR0(22,51)
      V(59)=HfxZpE*VRR1(12,75)
      V(60)=r1x2E*ZxZpE*VRR1(22,51)
      V(61)=r1x2E*VRR0(22,52)
      V(62)=2.D0*V(61)
      V(63)=HfxZpE*VRR1(12,76)
      V(64)=r1x2E*ZxZpE*VRR1(22,52)
      V(65)=-2.D0*V(64)
      V(66)=r1x2E*VRR0(22,53)
      V(67)=r1x2E*ZxZpE*VRR1(22,53)
      V(68)=r1x2E*VRR0(23,38)
      V(69)=r1x2E*ZxZpE*VRR1(23,38)
      V(70)=r1x2E*VRR0(23,39)
      V(71)=HfxZpE*VRR1(13,60)
      V(72)=r1x2E*ZxZpE*VRR1(23,39)
      V(73)=r1x2E*VRR0(23,44)
      V(74)=3.D0*V(73)
      V(75)=r1x2E*ZxZpE*VRR1(23,44)
      V(76)=-3.D0*V(75)
      V(77)=r1x2E*VRR0(23,45)
      V(78)=HfxZpE*VRR1(13,67)
      V(79)=r1x2E*ZxZpE*VRR1(23,45)
      V(80)=r1x2E*VRR0(23,47)
      V(81)=r1x2E*ZxZpE*VRR1(23,47)
      V(82)=r1x2E*VRR0(23,48)
      V(83)=3.D0*V(82)
      V(84)=r1x2E*ZxZpE*VRR1(23,48)
      V(85)=-3.D0*V(84)
      V(86)=r1x2E*VRR0(23,49)
      V(87)=HfxZpE*VRR1(13,72)
      V(88)=r1x2E*ZxZpE*VRR1(23,49)
      V(89)=3.D0*V(86)
      V(90)=-3.D0*V(88)
      V(91)=r1x2E*VRR0(23,50)
      V(92)=r1x2E*ZxZpE*VRR1(23,50)
      V(93)=r1x2E*VRR0(23,51)
      V(94)=HfxZpE*VRR1(13,75)
      V(95)=r1x2E*ZxZpE*VRR1(23,51)
      V(96)=r1x2E*VRR0(23,52)
      V(97)=2.D0*V(96)
      V(98)=HfxZpE*VRR1(13,76)
      V(99)=r1x2E*ZxZpE*VRR1(23,52)
      V(100)=-2.D0*V(99)
      V(101)=HfxZpE*VRR1(12,77)
      V(102)=r1x2E*VRR0(23,53)
      V(103)=HfxZpE*VRR1(12,78)
      V(104)=r1x2E*ZxZpE*VRR1(23,53)
      V(105)=r1x2E*VRR0(24,38)
      V(106)=r1x2E*ZxZpE*VRR1(24,38)
      V(107)=r1x2E*VRR0(24,39)
      V(108)=HfxZpE*VRR1(14,60)
      V(109)=r1x2E*ZxZpE*VRR1(24,39)
      V(110)=r1x2E*VRR0(24,44)
      V(111)=3.D0*V(110)
      V(112)=HfxZpE*VRR1(14,66)
      V(113)=r1x2E*ZxZpE*VRR1(24,44)
      V(114)=-3.D0*V(113)
      V(115)=r1x2E*VRR0(24,45)
      V(116)=HfxZpE*VRR1(14,67)
      V(117)=r1x2E*ZxZpE*VRR1(24,45)
      V(118)=r1x2E*VRR0(24,47)
      V(119)=r1x2E*ZxZpE*VRR1(24,47)
      V(120)=r1x2E*VRR0(24,48)
      V(121)=3.D0*V(120)
      V(122)=HfxZpE*VRR1(14,71)
      V(123)=r1x2E*ZxZpE*VRR1(24,48)
      V(124)=-3.D0*V(123)
      V(125)=r1x2E*VRR0(24,49)
      V(126)=HfxZpE*VRR1(14,72)
      V(127)=r1x2E*ZxZpE*VRR1(24,49)
      V(128)=3.D0*V(125)
      V(129)=-3.D0*V(127)
      V(130)=r1x2E*VRR0(24,50)
      V(131)=r1x2E*ZxZpE*VRR1(24,50)
      V(132)=r1x2E*VRR0(24,51)
      V(133)=HfxZpE*VRR1(14,75)
      V(134)=r1x2E*ZxZpE*VRR1(24,51)
      V(135)=r1x2E*VRR0(24,52)
      V(136)=2.D0*V(135)
      V(137)=HfxZpE*VRR1(14,76)
      V(138)=r1x2E*ZxZpE*VRR1(24,52)
      V(139)=-2.D0*V(138)
      V(140)=HfxZpE*VRR1(13,77)
      V(141)=r1x2E*VRR0(24,53)
      V(142)=HfxZpE*VRR1(13,78)
      V(143)=r1x2E*ZxZpE*VRR1(24,53)
      V(144)=r1x2E*VRR0(25,38)
      V(145)=r1x2E*ZxZpE*VRR1(25,38)
      V(146)=r1x2E*VRR0(25,39)
      V(147)=r1x2E*ZxZpE*VRR1(25,39)
      V(148)=r1x2E*VRR0(25,44)
      V(149)=3.D0*V(148)
      V(150)=r1x2E*ZxZpE*VRR1(25,44)
      V(151)=-3.D0*V(150)
      V(152)=r1x2E*VRR0(25,47)
      V(153)=r1x2E*ZxZpE*VRR1(25,47)
      V(154)=r1x2E*VRR0(25,48)
      V(155)=3.D0*V(154)
      V(156)=r1x2E*ZxZpE*VRR1(25,48)
      V(157)=-3.D0*V(156)
      V(158)=r1x2E*VRR0(25,49)
      V(159)=3.D0*V(158)
      V(160)=r1x2E*ZxZpE*VRR1(25,49)
      V(161)=-3.D0*V(160)
      V(162)=r1x2E*VRR0(25,50)
      V(163)=r1x2E*ZxZpE*VRR1(25,50)
      V(164)=r1x2E*VRR0(25,51)
      V(165)=r1x2E*ZxZpE*VRR1(25,51)
      V(166)=HfxZpE*VRR1(14,77)
      V(167)=r1x2E*VRR0(25,53)
      V(168)=HfxZpE*VRR1(14,78)
      V(169)=r1x2E*ZxZpE*VRR1(25,53)
      V(170)=r1x2E*VRR0(26,38)
      V(171)=r1x2E*ZxZpE*VRR1(26,38)
      V(172)=r1x2E*VRR0(26,39)
      V(173)=HfxZpE*VRR1(15,60)
      V(174)=r1x2E*ZxZpE*VRR1(26,39)
      V(175)=r1x2E*VRR0(26,44)
      V(176)=3.D0*V(175)
      V(177)=r1x2E*ZxZpE*VRR1(26,44)
      V(178)=-3.D0*V(177)
      V(179)=r1x2E*VRR0(26,45)
      V(180)=HfxZpE*VRR1(15,67)
      V(181)=r1x2E*ZxZpE*VRR1(26,45)
      V(182)=r1x2E*VRR0(26,47)
      V(183)=r1x2E*ZxZpE*VRR1(26,47)
      V(184)=r1x2E*VRR0(26,48)
      V(185)=3.D0*V(184)
      V(186)=r1x2E*ZxZpE*VRR1(26,48)
      V(187)=-3.D0*V(186)
      V(188)=r1x2E*VRR0(26,49)
      V(189)=HfxZpE*VRR1(15,72)
      V(190)=r1x2E*ZxZpE*VRR1(26,49)
      V(191)=3.D0*V(188)
      V(192)=-3.D0*V(190)
      V(193)=r1x2E*VRR0(26,50)
      V(194)=r1x2E*ZxZpE*VRR1(26,50)
      V(195)=r1x2E*VRR0(26,51)
      V(196)=HfxZpE*VRR1(15,75)
      V(197)=r1x2E*ZxZpE*VRR1(26,51)
      V(198)=r1x2E*VRR0(26,52)
      V(199)=2.D0*V(198)
      V(200)=HfxZpE*VRR1(15,76)
      V(201)=r1x2E*ZxZpE*VRR1(26,52)
      V(202)=-2.D0*V(201)
      V(203)=r1x2E*VRR0(26,53)
      V(204)=r1x2E*ZxZpE*VRR1(26,53)
      V(205)=r1x2E*VRR0(27,38)
      V(206)=r1x2E*ZxZpE*VRR1(27,38)
      V(207)=r1x2E*VRR0(27,39)
      V(208)=HfxZpE*VRR1(16,60)
      V(209)=2.D0*V(208)
      V(210)=r1x2E*ZxZpE*VRR1(27,39)
      V(211)=r1x2E*VRR0(27,44)
      V(212)=3.D0*V(211)
      V(213)=r1x2E*ZxZpE*VRR1(27,44)
      V(214)=-3.D0*V(213)
      V(215)=r1x2E*VRR0(27,45)
      V(216)=HfxZpE*VRR1(16,67)
      V(217)=2.D0*V(216)
      V(218)=r1x2E*ZxZpE*VRR1(27,45)
      V(219)=r1x2E*VRR0(27,47)
      V(220)=r1x2E*ZxZpE*VRR1(27,47)
      V(221)=r1x2E*VRR0(27,48)
      V(222)=3.D0*V(221)
      V(223)=r1x2E*ZxZpE*VRR1(27,48)
      V(224)=-3.D0*V(223)
      V(225)=r1x2E*VRR0(27,49)
      V(226)=HfxZpE*VRR1(16,72)
      V(227)=2.D0*V(226)
      V(228)=r1x2E*ZxZpE*VRR1(27,49)
      V(229)=3.D0*V(225)
      V(230)=-3.D0*V(228)
      V(231)=r1x2E*VRR0(27,50)
      V(232)=r1x2E*ZxZpE*VRR1(27,50)
      V(233)=r1x2E*VRR0(27,51)
      V(234)=HfxZpE*VRR1(16,75)
      V(235)=2.D0*V(234)
      V(236)=r1x2E*ZxZpE*VRR1(27,51)
      V(237)=r1x2E*VRR0(27,52)
      V(238)=2.D0*V(237)
      V(239)=HfxZpE*VRR1(16,76)
      V(240)=2.D0*V(239)
      V(241)=r1x2E*ZxZpE*VRR1(27,52)
      V(242)=-2.D0*V(241)
      V(243)=HfxZpE*VRR1(15,77)
      V(244)=r1x2E*VRR0(27,53)
      V(245)=HfxZpE*VRR1(15,78)
      V(246)=r1x2E*ZxZpE*VRR1(27,53)
      V(247)=r1x2E*VRR0(28,38)
      V(248)=r1x2E*ZxZpE*VRR1(28,38)
      V(249)=r1x2E*VRR0(28,39)
      V(250)=HfxZpE*VRR1(17,60)
      V(251)=r1x2E*ZxZpE*VRR1(28,39)
      V(252)=r1x2E*VRR0(28,44)
      V(253)=3.D0*V(252)
      V(254)=r1x2E*ZxZpE*VRR1(28,44)
      V(255)=-3.D0*V(254)
      V(256)=r1x2E*VRR0(28,45)
      V(257)=HfxZpE*VRR1(17,67)
      V(258)=r1x2E*ZxZpE*VRR1(28,45)
      V(259)=r1x2E*VRR0(28,47)
      V(260)=r1x2E*ZxZpE*VRR1(28,47)
      V(261)=r1x2E*VRR0(28,48)
      V(262)=3.D0*V(261)
      V(263)=r1x2E*ZxZpE*VRR1(28,48)
      V(264)=-3.D0*V(263)
      V(265)=r1x2E*VRR0(28,49)
      V(266)=HfxZpE*VRR1(17,72)
      V(267)=r1x2E*ZxZpE*VRR1(28,49)
      V(268)=3.D0*V(265)
      V(269)=-3.D0*V(267)
      V(270)=r1x2E*VRR0(28,50)
      V(271)=r1x2E*ZxZpE*VRR1(28,50)
      V(272)=r1x2E*VRR0(28,51)
      V(273)=HfxZpE*VRR1(17,75)
      V(274)=r1x2E*ZxZpE*VRR1(28,51)
      V(275)=r1x2E*VRR0(28,52)
      V(276)=2.D0*V(275)
      V(277)=HfxZpE*VRR1(17,76)
      V(278)=r1x2E*ZxZpE*VRR1(28,52)
      V(279)=-2.D0*V(278)
      V(280)=HfxZpE*VRR1(16,77)
      V(281)=2.D0*V(280)
      V(282)=r1x2E*VRR0(28,53)
      V(283)=HfxZpE*VRR1(16,78)
      V(284)=2.D0*V(283)
      V(285)=r1x2E*ZxZpE*VRR1(28,53)
      V(286)=r1x2E*VRR0(29,38)
      V(287)=r1x2E*ZxZpE*VRR1(29,38)
      V(288)=r1x2E*VRR0(29,39)
      V(289)=r1x2E*ZxZpE*VRR1(29,39)
      V(290)=r1x2E*VRR0(29,44)
      V(291)=3.D0*V(290)
      V(292)=r1x2E*ZxZpE*VRR1(29,44)
      V(293)=-3.D0*V(292)
      V(294)=r1x2E*VRR0(29,45)
      V(295)=r1x2E*ZxZpE*VRR1(29,45)
      V(296)=r1x2E*VRR0(29,47)
      V(297)=r1x2E*ZxZpE*VRR1(29,47)
      V(298)=r1x2E*VRR0(29,48)
      V(299)=3.D0*V(298)
      V(300)=r1x2E*ZxZpE*VRR1(29,48)
      V(301)=-3.D0*V(300)
      V(302)=r1x2E*VRR0(29,49)
      V(303)=r1x2E*ZxZpE*VRR1(29,49)
      V(304)=3.D0*V(302)
      V(305)=-3.D0*V(303)
      V(306)=r1x2E*VRR0(29,50)
      V(307)=r1x2E*ZxZpE*VRR1(29,50)
      V(308)=r1x2E*VRR0(29,51)
      V(309)=r1x2E*ZxZpE*VRR1(29,51)
      V(310)=r1x2E*VRR0(29,52)
      V(311)=2.D0*V(310)
      V(312)=r1x2E*ZxZpE*VRR1(29,52)
      V(313)=-2.D0*V(312)
      V(314)=HfxZpE*VRR1(17,77)
      V(315)=r1x2E*VRR0(29,53)
      V(316)=HfxZpE*VRR1(17,78)
      V(317)=r1x2E*ZxZpE*VRR1(29,53)
      V(318)=r1x2E*VRR0(30,38)
      V(319)=r1x2E*ZxZpE*VRR1(30,38)
      V(320)=r1x2E*VRR0(30,39)
      V(321)=HfxZpE*VRR1(18,60)
      V(322)=r1x2E*ZxZpE*VRR1(30,39)
      V(323)=r1x2E*VRR0(30,44)
      V(324)=3.D0*V(323)
      V(325)=r1x2E*ZxZpE*VRR1(30,44)
      V(326)=-3.D0*V(325)
      V(327)=r1x2E*VRR0(30,45)
      V(328)=HfxZpE*VRR1(18,67)
      V(329)=r1x2E*ZxZpE*VRR1(30,45)
      V(330)=r1x2E*VRR0(30,47)
      V(331)=r1x2E*ZxZpE*VRR1(30,47)
      V(332)=r1x2E*VRR0(30,48)
      V(333)=3.D0*V(332)
      V(334)=r1x2E*ZxZpE*VRR1(30,48)
      V(335)=-3.D0*V(334)
      V(336)=r1x2E*VRR0(30,49)
      V(337)=HfxZpE*VRR1(18,72)
      V(338)=r1x2E*ZxZpE*VRR1(30,49)
      V(339)=3.D0*V(336)
      V(340)=-3.D0*V(338)
      V(341)=r1x2E*VRR0(30,50)
      V(342)=r1x2E*ZxZpE*VRR1(30,50)
      V(343)=r1x2E*VRR0(30,51)
      V(344)=HfxZpE*VRR1(18,75)
      V(345)=r1x2E*ZxZpE*VRR1(30,51)
      V(346)=r1x2E*VRR0(30,52)
      V(347)=2.D0*V(346)
      V(348)=HfxZpE*VRR1(18,76)
      V(349)=r1x2E*ZxZpE*VRR1(30,52)
      V(350)=-2.D0*V(349)
      V(351)=r1x2E*VRR0(30,53)
      V(352)=r1x2E*ZxZpE*VRR1(30,53)
      V(353)=r1x2E*VRR0(31,38)
      V(354)=r1x2E*ZxZpE*VRR1(31,38)
      V(355)=r1x2E*VRR0(31,39)
      V(356)=HfxZpE*VRR1(19,60)
      V(357)=r1x2E*ZxZpE*VRR1(31,39)
      V(358)=r1x2E*VRR0(31,44)
      V(359)=3.D0*V(358)
      V(360)=r1x2E*ZxZpE*VRR1(31,44)
      V(361)=-3.D0*V(360)
      V(362)=r1x2E*VRR0(31,45)
      V(363)=HfxZpE*VRR1(19,67)
      V(364)=r1x2E*ZxZpE*VRR1(31,45)
      V(365)=r1x2E*VRR0(31,47)
      V(366)=r1x2E*ZxZpE*VRR1(31,47)
      V(367)=r1x2E*VRR0(31,48)
      V(368)=3.D0*V(367)
      V(369)=r1x2E*ZxZpE*VRR1(31,48)
      V(370)=-3.D0*V(369)
      V(371)=r1x2E*VRR0(31,49)
      V(372)=HfxZpE*VRR1(19,72)
      V(373)=r1x2E*ZxZpE*VRR1(31,49)
      V(374)=3.D0*V(371)
      V(375)=-3.D0*V(373)
      V(376)=r1x2E*VRR0(31,50)
      V(377)=r1x2E*ZxZpE*VRR1(31,50)
      V(378)=r1x2E*VRR0(31,51)
      V(379)=HfxZpE*VRR1(19,75)
      V(380)=r1x2E*ZxZpE*VRR1(31,51)
      V(381)=r1x2E*VRR0(31,52)
      V(382)=2.D0*V(381)
      V(383)=HfxZpE*VRR1(19,76)
      V(384)=r1x2E*ZxZpE*VRR1(31,52)
      V(385)=-2.D0*V(384)
      V(386)=HfxZpE*VRR1(18,77)
      V(387)=r1x2E*VRR0(31,53)
      V(388)=HfxZpE*VRR1(18,78)
      V(389)=r1x2E*ZxZpE*VRR1(31,53)
      V(390)=r1x2E*VRR0(32,38)
      V(391)=r1x2E*ZxZpE*VRR1(32,38)
      V(392)=r1x2E*VRR0(32,39)
      V(393)=r1x2E*ZxZpE*VRR1(32,39)
      V(394)=r1x2E*VRR0(32,44)
      V(395)=3.D0*V(394)
      V(396)=r1x2E*ZxZpE*VRR1(32,44)
      V(397)=-3.D0*V(396)
      V(398)=r1x2E*VRR0(32,45)
      V(399)=r1x2E*ZxZpE*VRR1(32,45)
      V(400)=r1x2E*VRR0(32,47)
      V(401)=r1x2E*ZxZpE*VRR1(32,47)
      V(402)=r1x2E*VRR0(32,48)
      V(403)=3.D0*V(402)
      V(404)=r1x2E*ZxZpE*VRR1(32,48)
      V(405)=-3.D0*V(404)
      V(406)=r1x2E*VRR0(32,49)
      V(407)=r1x2E*ZxZpE*VRR1(32,49)
      V(408)=3.D0*V(406)
      V(409)=-3.D0*V(407)
      V(410)=r1x2E*VRR0(32,50)
      V(411)=r1x2E*ZxZpE*VRR1(32,50)
      V(412)=r1x2E*VRR0(32,51)
      V(413)=r1x2E*ZxZpE*VRR1(32,51)
      V(414)=r1x2E*VRR0(32,52)
      V(415)=2.D0*V(414)
      V(416)=r1x2E*ZxZpE*VRR1(32,52)
      V(417)=-2.D0*V(416)
      V(418)=HfxZpE*VRR1(19,77)
      V(419)=r1x2E*VRR0(32,53)
      V(420)=HfxZpE*VRR1(19,78)
      V(421)=r1x2E*ZxZpE*VRR1(32,53)
      V(422)=r1x2E*VRR0(33,38)
      V(423)=r1x2E*ZxZpE*VRR1(33,38)
      V(424)=r1x2E*VRR0(33,39)
      V(425)=HfxZpE*VRR1(20,60)
      V(426)=r1x2E*ZxZpE*VRR1(33,39)
      V(427)=r1x2E*VRR0(33,44)
      V(428)=3.D0*V(427)
      V(429)=HfxZpE*VRR1(20,66)
      V(430)=r1x2E*ZxZpE*VRR1(33,44)
      V(431)=-3.D0*V(430)
      V(432)=r1x2E*VRR0(33,45)
      V(433)=HfxZpE*VRR1(20,67)
      V(434)=r1x2E*ZxZpE*VRR1(33,45)
      V(435)=r1x2E*VRR0(33,47)
      V(436)=r1x2E*ZxZpE*VRR1(33,47)
      V(437)=r1x2E*VRR0(33,48)
      V(438)=3.D0*V(437)
      V(439)=HfxZpE*VRR1(20,71)
      V(440)=r1x2E*ZxZpE*VRR1(33,48)
      V(441)=-3.D0*V(440)
      V(442)=r1x2E*VRR0(33,49)
      V(443)=HfxZpE*VRR1(20,72)
      V(444)=r1x2E*ZxZpE*VRR1(33,49)
      V(445)=3.D0*V(442)
      V(446)=-3.D0*V(444)
      V(447)=r1x2E*VRR0(33,50)
      V(448)=r1x2E*ZxZpE*VRR1(33,50)
      V(449)=r1x2E*VRR0(33,51)
      V(450)=HfxZpE*VRR1(20,75)
      V(451)=r1x2E*ZxZpE*VRR1(33,51)
      V(452)=r1x2E*VRR0(33,52)
      V(453)=2.D0*V(452)
      V(454)=HfxZpE*VRR1(20,76)
      V(455)=r1x2E*ZxZpE*VRR1(33,52)
      V(456)=-2.D0*V(455)
      V(457)=r1x2E*VRR0(33,53)
      V(458)=r1x2E*ZxZpE*VRR1(33,53)
      V(459)=r1x2E*VRR0(34,38)
      V(460)=r1x2E*ZxZpE*VRR1(34,38)
      V(461)=r1x2E*VRR0(34,39)
      V(462)=r1x2E*ZxZpE*VRR1(34,39)
      V(463)=r1x2E*VRR0(34,44)
      V(464)=3.D0*V(463)
      V(465)=r1x2E*ZxZpE*VRR1(34,44)
      V(466)=-3.D0*V(465)
      V(467)=r1x2E*VRR0(34,45)
      V(468)=r1x2E*ZxZpE*VRR1(34,45)
      V(469)=r1x2E*VRR0(34,47)
      V(470)=r1x2E*ZxZpE*VRR1(34,47)
      V(471)=r1x2E*VRR0(34,48)
      V(472)=3.D0*V(471)
      V(473)=r1x2E*ZxZpE*VRR1(34,48)
      V(474)=-3.D0*V(473)
      V(475)=r1x2E*VRR0(34,49)
      V(476)=r1x2E*ZxZpE*VRR1(34,49)
      V(477)=3.D0*V(475)
      V(478)=HfxZpE*VRR1(20,73)
      V(479)=-3.D0*V(476)
      V(480)=r1x2E*VRR0(34,50)
      V(481)=r1x2E*ZxZpE*VRR1(34,50)
      V(482)=r1x2E*VRR0(34,51)
      V(483)=r1x2E*ZxZpE*VRR1(34,51)
      V(484)=r1x2E*VRR0(34,52)
      V(485)=2.D0*V(484)
      V(486)=r1x2E*ZxZpE*VRR1(34,52)
      V(487)=-2.D0*V(486)
      V(488)=HfxZpE*VRR1(20,77)
      V(489)=r1x2E*VRR0(34,53)
      V(490)=HfxZpE*VRR1(20,78)
      V(491)=r1x2E*ZxZpE*VRR1(34,53)
      V(492)=r1x2E*VRR0(35,38)
      V(493)=r1x2E*ZxZpE*VRR1(35,38)
      V(494)=r1x2E*VRR0(35,39)
      V(495)=r1x2E*ZxZpE*VRR1(35,39)
      V(496)=r1x2E*VRR0(35,44)
      V(497)=3.D0*V(496)
      V(498)=r1x2E*ZxZpE*VRR1(35,44)
      V(499)=-3.D0*V(498)
      V(500)=r1x2E*VRR0(35,47)
      V(501)=r1x2E*ZxZpE*VRR1(35,47)
      V(502)=r1x2E*VRR0(35,48)
      V(503)=3.D0*V(502)
      V(504)=r1x2E*ZxZpE*VRR1(35,48)
      V(505)=-3.D0*V(504)
      V(506)=r1x2E*VRR0(35,49)
      V(507)=3.D0*V(506)
      V(508)=r1x2E*ZxZpE*VRR1(35,49)
      V(509)=-3.D0*V(508)
      V(510)=r1x2E*VRR0(35,50)
      V(511)=r1x2E*ZxZpE*VRR1(35,50)
      V(512)=r1x2E*VRR0(35,51)
      V(513)=r1x2E*ZxZpE*VRR1(35,51)
      V(514)=r1x2E*VRR0(35,53)
      V(515)=r1x2E*ZxZpE*VRR1(35,53)
      VRR0(21,85)=6.D0*r1x2E*VRR0(21,36)+QCx*VRR0(21,57)+4.D0*HfxZpE*VRR1(11,57)-6.D0*r1x2E*ZxZpE*VRR1(21,36)+WQx*VRR1(21,57)
      VRR0(21,86)=5.D0*r1x2E*VRR0(21,37)+QCx*VRR0(21,58)+4.D0*HfxZpE*VRR1(11,58)-5.D0*r1x2E*ZxZpE*VRR1(21,37)+WQx*VRR1(21,58)
      VRR0(21,87)=4.D0*V(1)-4.D0*V(2)+QCx*VRR0(21,59)+4.D0*HfxZpE*VRR1(11,59)+WQx*VRR1(21,59)
      VRR0(21,88)=3.D0*V(3)+4.D0*V(4)-3.D0*V(5)+QCx*VRR0(21,60)+WQx*VRR1(21,60)
      VRR0(21,89)=3.D0*V(1)-3.D0*V(2)+QCy*VRR0(21,60)+WQy*VRR1(21,60)
      VRR0(21,90)=4.D0*V(3)-4.D0*V(5)+QCy*VRR0(21,61)+WQy*VRR1(21,61)
      VRR0(21,91)=5.D0*r1x2E*VRR0(21,40)+QCy*VRR0(21,62)-5.D0*r1x2E*ZxZpE*VRR1(21,40)+WQy*VRR1(21,62)
      VRR0(21,92)=6.D0*r1x2E*VRR0(21,41)+QCy*VRR0(21,63)-6.D0*r1x2E*ZxZpE*VRR1(21,41)+WQy*VRR1(21,63)
      VRR0(21,93)=5.D0*r1x2E*VRR0(21,42)+QCx*VRR0(21,64)+4.D0*HfxZpE*VRR1(11,64)-5.D0*r1x2E*ZxZpE*VRR1(21,42)+WQx*VRR1(21,64)
      VRR0(21,94)=4.D0*r1x2E*VRR0(21,43)+QCx*VRR0(21,65)+4.D0*HfxZpE*VRR1(11,65)-4.D0*r1x2E*ZxZpE*VRR1(21,43)+WQx*VRR1(21,65)
      VRR0(21,95)=V(7)+V(9)+QCx*VRR0(21,66)+4.D0*HfxZpE*VRR1(11,66)+WQx*VRR1(21,66)
      VRR0(21,96)=3.D0*V(10)+3.D0*r1x2Z*VRR0(5,96)+PAx*VRR0(11,96)-3.D0*ExZpE*r1x2Z*VRR1(5,96)+WPx*VRR1(11,96)
      VRR0(21,97)=V(7)+V(9)+QCy*VRR0(21,67)+WQy*VRR1(21,67)
      VRR0(21,98)=4.D0*r1x2E*VRR0(21,45)+QCy*VRR0(21,68)-4.D0*r1x2E*ZxZpE*VRR1(21,45)+WQy*VRR1(21,68)
      VRR0(21,99)=5.D0*r1x2E*VRR0(21,46)+QCy*VRR0(21,69)-5.D0*r1x2E*ZxZpE*VRR1(21,46)+WQy*VRR1(21,69)
      VRR0(21,100)=4.D0*V(11)-4.D0*V(12)+QCx*VRR0(21,70)+4.D0*HfxZpE*VRR1(11,70)+WQx*VRR1(21,70)
      VRR0(21,101)=V(14)+V(16)+QCx*VRR0(21,71)+4.D0*HfxZpE*VRR1(11,71)+WQx*VRR1(21,71)
      VRR0(21,102)=3.D0*V(17)+3.D0*r1x2Z*VRR0(5,102)+PAx*VRR0(11,102)-3.D0*ExZpE*r1x2Z*VRR1(5,102)+WPx*VRR1(11,102)
      VRR0(21,103)=2.D0*V(18)+3.D0*r1x2Z*VRR0(5,103)+PAx*VRR0(11,103)-3.D0*ExZpE*r1x2Z*VRR1(5,103)+WPx*VRR1(11,103)
      VRR0(21,104)=V(20)+V(22)+QCy*VRR0(21,73)+WQy*VRR1(21,73)
      VRR0(21,105)=4.D0*V(23)-4.D0*V(24)+QCy*VRR0(21,74)+WQy*VRR1(21,74)
      VRR0(21,106)=3.D0*V(25)+4.D0*V(26)-3.D0*V(27)+QCx*VRR0(21,75)+WQx*VRR1(21,75)
      VRR0(21,107)=3.D0*V(28)+3.D0*r1x2Z*VRR0(5,107)+PAx*VRR0(11,107)-3.D0*ExZpE*r1x2Z*VRR1(5,107)+WPx*VRR1(11,107)
      VRR0(21,108)=2.D0*V(29)+3.D0*r1x2Z*VRR0(5,108)+PAx*VRR0(11,108)-3.D0*ExZpE*r1x2Z*VRR1(5,108)+WPx*VRR1(11,108)
      VRR0(21,109)=V(30)+3.D0*r1x2Z*VRR0(5,109)+PAx*VRR0(11,109)-3.D0*ExZpE*r1x2Z*VRR1(5,109)+WPx*VRR1(11,109)
      VRR0(21,110)=3.D0*V(31)-3.D0*V(32)+QCy*VRR0(21,78)+WQy*VRR1(21,78)
      VRR0(21,111)=3.D0*V(11)-3.D0*V(12)+QCz*VRR0(21,75)+WQz*VRR1(21,75)
      VRR0(21,112)=V(14)+V(16)+QCz*VRR0(21,76)+WQz*VRR1(21,76)
      VRR0(21,113)=V(20)+V(22)+QCz*VRR0(21,77)+WQz*VRR1(21,77)
      VRR0(21,114)=3.D0*V(23)-3.D0*V(24)+QCz*VRR0(21,78)+WQz*VRR1(21,78)
      VRR0(21,115)=4.D0*V(25)-4.D0*V(27)+QCz*VRR0(21,79)+WQz*VRR1(21,79)
      VRR0(21,116)=4.D0*r1x2E*VRR0(21,52)+QCz*VRR0(21,80)-4.D0*r1x2E*ZxZpE*VRR1(21,52)+WQz*VRR1(21,80)
      VRR0(21,117)=4.D0*V(31)-4.D0*V(32)+QCz*VRR0(21,81)+WQz*VRR1(21,81)
      VRR0(21,118)=5.D0*r1x2E*VRR0(21,54)+QCz*VRR0(21,82)-5.D0*r1x2E*ZxZpE*VRR1(21,54)+WQz*VRR1(21,82)
      VRR0(21,119)=5.D0*r1x2E*VRR0(21,55)+QCz*VRR0(21,83)-5.D0*r1x2E*ZxZpE*VRR1(21,55)+WQz*VRR1(21,83)
      VRR0(21,120)=6.D0*r1x2E*VRR0(21,56)+QCz*VRR0(21,84)-6.D0*r1x2E*ZxZpE*VRR1(21,56)+WQz*VRR1(21,84)
      VRR0(22,85)=6.D0*r1x2E*VRR0(22,36)+QCx*VRR0(22,57)+3.D0*HfxZpE*VRR1(12,57)-6.D0*r1x2E*ZxZpE*VRR1(22,36)+WQx*VRR1(22,57)
      VRR0(22,86)=5.D0*r1x2E*VRR0(22,37)+QCx*VRR0(22,58)+3.D0*HfxZpE*VRR1(12,58)-5.D0*r1x2E*ZxZpE*VRR1(22,37)+WQx*VRR1(22,58)
      VRR0(22,87)=4.D0*V(33)-4.D0*V(34)+QCx*VRR0(22,59)+3.D0*HfxZpE*VRR1(12,59)+WQx*VRR1(22,59)
      VRR0(22,88)=3.D0*V(35)+3.D0*V(36)-3.D0*V(37)+QCx*VRR0(22,60)+WQx*VRR1(22,60)
      VRR0(22,89)=V(4)+3.D0*V(33)-3.D0*V(34)+QCy*VRR0(22,60)+WQy*VRR1(22,60)
      VRR0(22,90)=4.D0*V(35)-4.D0*V(37)+QCy*VRR0(22,61)+HfxZpE*VRR1(11,61)+WQy*VRR1(22,61)
      VRR0(22,91)=5.D0*r1x2E*VRR0(22,40)+QCy*VRR0(22,62)+HfxZpE*VRR1(11,62)-5.D0*r1x2E*ZxZpE*VRR1(22,40)+WQy*VRR1(22,62)
      VRR0(22,92)=6.D0*r1x2E*VRR0(22,41)+QCy*VRR0(22,63)+HfxZpE*VRR1(11,63)-6.D0*r1x2E*ZxZpE*VRR1(22,41)+WQy*VRR1(22,63)
      VRR0(22,93)=5.D0*r1x2E*VRR0(22,42)+QCx*VRR0(22,64)+3.D0*HfxZpE*VRR1(12,64)-5.D0*r1x2E*ZxZpE*VRR1(22,42)+WQx*VRR1(22,64)
      VRR0(22,94)=4.D0*r1x2E*VRR0(22,43)+QCx*VRR0(22,65)+3.D0*HfxZpE*VRR1(12,65)-4.D0*r1x2E*ZxZpE*VRR1(22,43)+WQx*VRR1(22,65)
      VRR0(22,95)=V(39)+V(41)+QCx*VRR0(22,66)+3.D0*HfxZpE*VRR1(12,66)+WQx*VRR1(22,66)
      VRR0(22,96)=2.D0*V(42)+3.D0*V(43)-2.D0*V(44)+QCx*VRR0(22,67)+WQx*VRR1(22,67)
      VRR0(22,97)=V(10)+V(39)+V(41)+QCy*VRR0(22,67)+WQy*VRR1(22,67)
      VRR0(22,98)=4.D0*V(42)-4.D0*V(44)+QCy*VRR0(22,68)+HfxZpE*VRR1(11,68)+WQy*VRR1(22,68)
      VRR0(22,99)=5.D0*r1x2E*VRR0(22,46)+QCy*VRR0(22,69)+HfxZpE*VRR1(11,69)-5.D0*r1x2E*ZxZpE*VRR1(22,46)+WQy*VRR1(22,69)
      VRR0(22,100)=4.D0*V(45)-4.D0*V(46)+QCx*VRR0(22,70)+3.D0*HfxZpE*VRR1(12,70)+WQx*VRR1(22,70)
      VRR0(22,101)=V(48)+V(50)+QCx*VRR0(22,71)+3.D0*HfxZpE*VRR1(12,71)+WQx*VRR1(22,71)
      VRR0(22,102)=2.D0*V(51)+3.D0*V(52)-2.D0*V(53)+QCx*VRR0(22,72)+WQx*VRR1(22,72)
      VRR0(22,103)=V(17)+2.D0*V(47)-2.D0*V(49)+QCy*VRR0(22,72)+WQy*VRR1(22,72)
      VRR0(22,104)=V(18)+V(54)+V(55)+QCy*VRR0(22,73)+WQy*VRR1(22,73)
      VRR0(22,105)=4.D0*V(56)-4.D0*V(57)+QCy*VRR0(22,74)+HfxZpE*VRR1(11,74)+WQy*VRR1(22,74)
      VRR0(22,106)=3.D0*V(58)+3.D0*V(59)-3.D0*V(60)+QCx*VRR0(22,75)+WQx*VRR1(22,75)
      VRR0(22,107)=V(62)+3.D0*V(63)+V(65)+QCx*VRR0(22,76)+WQx*VRR1(22,76)
      VRR0(22,108)=2.D0*V(38)-2.D0*V(40)+QCz*VRR0(22,72)+WQz*VRR1(22,72)
      VRR0(22,109)=V(29)+V(62)+V(65)+QCy*VRR0(22,77)+WQy*VRR1(22,77)
      VRR0(22,110)=V(30)+3.D0*V(66)-3.D0*V(67)+QCy*VRR0(22,78)+WQy*VRR1(22,78)
      VRR0(22,111)=3.D0*V(45)-3.D0*V(46)+QCz*VRR0(22,75)+WQz*VRR1(22,75)
      VRR0(22,112)=V(48)+V(50)+QCz*VRR0(22,76)+WQz*VRR1(22,76)
      VRR0(22,113)=V(54)+V(55)+QCz*VRR0(22,77)+WQz*VRR1(22,77)
      VRR0(22,114)=3.D0*V(56)-3.D0*V(57)+QCz*VRR0(22,78)+WQz*VRR1(22,78)
      VRR0(22,115)=4.D0*V(58)-4.D0*V(60)+QCz*VRR0(22,79)+WQz*VRR1(22,79)
      VRR0(22,116)=4.D0*V(61)-4.D0*V(64)+QCz*VRR0(22,80)+WQz*VRR1(22,80)
      VRR0(22,117)=4.D0*V(66)-4.D0*V(67)+QCz*VRR0(22,81)+WQz*VRR1(22,81)
      VRR0(22,118)=5.D0*r1x2E*VRR0(22,54)+QCz*VRR0(22,82)-5.D0*r1x2E*ZxZpE*VRR1(22,54)+WQz*VRR1(22,82)
      VRR0(22,119)=5.D0*r1x2E*VRR0(22,55)+QCz*VRR0(22,83)-5.D0*r1x2E*ZxZpE*VRR1(22,55)+WQz*VRR1(22,83)
      VRR0(22,120)=6.D0*r1x2E*VRR0(22,56)+QCz*VRR0(22,84)-6.D0*r1x2E*ZxZpE*VRR1(22,56)+WQz*VRR1(22,84)
      VRR0(23,85)=6.D0*r1x2E*VRR0(23,36)+QCx*VRR0(23,57)+2.D0*HfxZpE*VRR1(13,57)-6.D0*r1x2E*ZxZpE*VRR1(23,36)+WQx*VRR1(23,57)
      VRR0(23,86)=5.D0*r1x2E*VRR0(23,37)+QCx*VRR0(23,58)+2.D0*HfxZpE*VRR1(13,58)-5.D0*r1x2E*ZxZpE*VRR1(23,37)+WQx*VRR1(23,58)
      VRR0(23,87)=4.D0*V(68)-4.D0*V(69)+QCx*VRR0(23,59)+2.D0*HfxZpE*VRR1(13,59)+WQx*VRR1(23,59)
      VRR0(23,88)=3.D0*V(70)+2.D0*V(71)-3.D0*V(72)+QCx*VRR0(23,60)+WQx*VRR1(23,60)
      VRR0(23,89)=2.D0*V(36)+3.D0*V(68)-3.D0*V(69)+QCy*VRR0(23,60)+WQy*VRR1(23,60)
      VRR0(23,90)=4.D0*V(70)-4.D0*V(72)+QCy*VRR0(23,61)+2.D0*HfxZpE*VRR1(12,61)+WQy*VRR1(23,61)
      VRR0(23,91)=5.D0*r1x2E*VRR0(23,40)+QCy*VRR0(23,62)+2.D0*HfxZpE*VRR1(12,62)-5.D0*r1x2E*ZxZpE*VRR1(23,40)+WQy*VRR1(23,62)
      VRR0(23,92)=6.D0*r1x2E*VRR0(23,41)+QCy*VRR0(23,63)+2.D0*HfxZpE*VRR1(12,63)-6.D0*r1x2E*ZxZpE*VRR1(23,41)+WQy*VRR1(23,63)
      VRR0(23,93)=5.D0*r1x2E*VRR0(23,42)+QCx*VRR0(23,64)+2.D0*HfxZpE*VRR1(13,64)-5.D0*r1x2E*ZxZpE*VRR1(23,42)+WQx*VRR1(23,64)
      VRR0(23,94)=4.D0*r1x2E*VRR0(23,43)+QCx*VRR0(23,65)+2.D0*HfxZpE*VRR1(13,65)-4.D0*r1x2E*ZxZpE*VRR1(23,43)+WQx*VRR1(23,65)
      VRR0(23,95)=V(74)+V(76)+QCx*VRR0(23,66)+2.D0*HfxZpE*VRR1(13,66)+WQx*VRR1(23,66)
      VRR0(23,96)=2.D0*V(77)+2.D0*V(78)-2.D0*V(79)+QCx*VRR0(23,67)+WQx*VRR1(23,67)
      VRR0(23,97)=2.D0*V(43)+V(74)+V(76)+QCy*VRR0(23,67)+WQy*VRR1(23,67)
      VRR0(23,98)=4.D0*V(77)-4.D0*V(79)+QCy*VRR0(23,68)+2.D0*HfxZpE*VRR1(12,68)+WQy*VRR1(23,68)
      VRR0(23,99)=5.D0*r1x2E*VRR0(23,46)+QCy*VRR0(23,69)+2.D0*HfxZpE*VRR1(12,69)-5.D0*r1x2E*ZxZpE*VRR1(23,46)+WQy*VRR1(23,69)
      VRR0(23,100)=4.D0*V(80)-4.D0*V(81)+QCx*VRR0(23,70)+2.D0*HfxZpE*VRR1(13,70)+WQx*VRR1(23,70)
      VRR0(23,101)=V(83)+V(85)+QCx*VRR0(23,71)+2.D0*HfxZpE*VRR1(13,71)+WQx*VRR1(23,71)
      VRR0(23,102)=2.D0*V(86)+2.D0*V(87)-2.D0*V(88)+QCx*VRR0(23,72)+WQx*VRR1(23,72)
      VRR0(23,103)=2.D0*V(52)+2.D0*V(82)-2.D0*V(84)+QCy*VRR0(23,72)+WQy*VRR1(23,72)
      VRR0(23,104)=V(89)+V(90)+QCy*VRR0(23,73)+2.D0*HfxZpE*VRR1(12,73)+WQy*VRR1(23,73)
      VRR0(23,105)=4.D0*V(91)-4.D0*V(92)+QCy*VRR0(23,74)+2.D0*HfxZpE*VRR1(12,74)+WQy*VRR1(23,74)
      VRR0(23,106)=3.D0*V(93)+2.D0*V(94)-3.D0*V(95)+QCx*VRR0(23,75)+WQx*VRR1(23,75)
      VRR0(23,107)=V(97)+2.D0*V(98)+V(100)+QCx*VRR0(23,76)+WQx*VRR1(23,76)
      VRR0(23,108)=2.D0*V(73)-2.D0*V(75)+QCz*VRR0(23,72)+WQz*VRR1(23,72)
      VRR0(23,109)=V(97)+V(100)+2.D0*V(101)+QCy*VRR0(23,77)+WQy*VRR1(23,77)
      VRR0(23,110)=3.D0*V(102)+2.D0*V(103)-3.D0*V(104)+QCy*VRR0(23,78)+WQy*VRR1(23,78)
      VRR0(23,111)=3.D0*V(80)-3.D0*V(81)+QCz*VRR0(23,75)+WQz*VRR1(23,75)
      VRR0(23,112)=V(83)+V(85)+QCz*VRR0(23,76)+WQz*VRR1(23,76)
      VRR0(23,113)=V(89)+V(90)+QCz*VRR0(23,77)+WQz*VRR1(23,77)
      VRR0(23,114)=3.D0*V(91)-3.D0*V(92)+QCz*VRR0(23,78)+WQz*VRR1(23,78)
      VRR0(23,115)=4.D0*V(93)-4.D0*V(95)+QCz*VRR0(23,79)+WQz*VRR1(23,79)
      VRR0(23,116)=4.D0*V(96)-4.D0*V(99)+QCz*VRR0(23,80)+WQz*VRR1(23,80)
      VRR0(23,117)=4.D0*V(102)-4.D0*V(104)+QCz*VRR0(23,81)+WQz*VRR1(23,81)
      VRR0(23,118)=5.D0*r1x2E*VRR0(23,54)+QCz*VRR0(23,82)-5.D0*r1x2E*ZxZpE*VRR1(23,54)+WQz*VRR1(23,82)
      VRR0(23,119)=5.D0*r1x2E*VRR0(23,55)+QCz*VRR0(23,83)-5.D0*r1x2E*ZxZpE*VRR1(23,55)+WQz*VRR1(23,83)
      VRR0(23,120)=6.D0*r1x2E*VRR0(23,56)+QCz*VRR0(23,84)-6.D0*r1x2E*ZxZpE*VRR1(23,56)+WQz*VRR1(23,84)
      VRR0(24,85)=6.D0*r1x2E*VRR0(24,36)+QCx*VRR0(24,57)+HfxZpE*VRR1(14,57)-6.D0*r1x2E*ZxZpE*VRR1(24,36)+WQx*VRR1(24,57)
      VRR0(24,86)=5.D0*r1x2E*VRR0(24,37)+QCx*VRR0(24,58)+HfxZpE*VRR1(14,58)-5.D0*r1x2E*ZxZpE*VRR1(24,37)+WQx*VRR1(24,58)
      VRR0(24,87)=4.D0*V(105)-4.D0*V(106)+QCx*VRR0(24,59)+HfxZpE*VRR1(14,59)+WQx*VRR1(24,59)
      VRR0(24,88)=3.D0*V(107)+V(108)-3.D0*V(109)+QCx*VRR0(24,60)+WQx*VRR1(24,60)
      VRR0(24,89)=3.D0*V(71)+3.D0*V(105)-3.D0*V(106)+QCy*VRR0(24,60)+WQy*VRR1(24,60)
      VRR0(24,90)=4.D0*V(107)-4.D0*V(109)+QCy*VRR0(24,61)+3.D0*HfxZpE*VRR1(13,61)+WQy*VRR1(24,61)
      VRR0(24,91)=5.D0*r1x2E*VRR0(24,40)+QCy*VRR0(24,62)+3.D0*HfxZpE*VRR1(13,62)-5.D0*r1x2E*ZxZpE*VRR1(24,40)+WQy*VRR1(24,62)
      VRR0(24,92)=6.D0*r1x2E*VRR0(24,41)+QCy*VRR0(24,63)+3.D0*HfxZpE*VRR1(13,63)-6.D0*r1x2E*ZxZpE*VRR1(24,41)+WQy*VRR1(24,63)
      VRR0(24,93)=5.D0*r1x2E*VRR0(24,42)+QCx*VRR0(24,64)+HfxZpE*VRR1(14,64)-5.D0*r1x2E*ZxZpE*VRR1(24,42)+WQx*VRR1(24,64)
      VRR0(24,94)=4.D0*r1x2E*VRR0(24,43)+QCx*VRR0(24,65)+HfxZpE*VRR1(14,65)-4.D0*r1x2E*ZxZpE*VRR1(24,43)+WQx*VRR1(24,65)
      VRR0(24,95)=V(111)+V(112)+V(114)+QCx*VRR0(24,66)+WQx*VRR1(24,66)
      VRR0(24,96)=2.D0*V(115)+V(116)-2.D0*V(117)+QCx*VRR0(24,67)+WQx*VRR1(24,67)
      VRR0(24,97)=3.D0*V(78)+V(111)+V(114)+QCy*VRR0(24,67)+WQy*VRR1(24,67)
      VRR0(24,98)=4.D0*V(115)-4.D0*V(117)+QCy*VRR0(24,68)+3.D0*HfxZpE*VRR1(13,68)+WQy*VRR1(24,68)
      VRR0(24,99)=5.D0*r1x2E*VRR0(24,46)+QCy*VRR0(24,69)+3.D0*HfxZpE*VRR1(13,69)-5.D0*r1x2E*ZxZpE*VRR1(24,46)+WQy*VRR1(24,69)
      VRR0(24,100)=4.D0*V(118)-4.D0*V(119)+QCx*VRR0(24,70)+HfxZpE*VRR1(14,70)+WQx*VRR1(24,70)
      VRR0(24,101)=V(121)+V(122)+V(124)+QCx*VRR0(24,71)+WQx*VRR1(24,71)
      VRR0(24,102)=2.D0*V(125)+V(126)-2.D0*V(127)+QCx*VRR0(24,72)+WQx*VRR1(24,72)
      VRR0(24,103)=3.D0*V(87)+2.D0*V(120)-2.D0*V(123)+QCy*VRR0(24,72)+WQy*VRR1(24,72)
      VRR0(24,104)=V(128)+V(129)+QCy*VRR0(24,73)+3.D0*HfxZpE*VRR1(13,73)+WQy*VRR1(24,73)
      VRR0(24,105)=4.D0*V(130)-4.D0*V(131)+QCy*VRR0(24,74)+3.D0*HfxZpE*VRR1(13,74)+WQy*VRR1(24,74)
      VRR0(24,106)=3.D0*V(132)+V(133)-3.D0*V(134)+QCx*VRR0(24,75)+WQx*VRR1(24,75)
      VRR0(24,107)=V(136)+V(137)+V(139)+QCx*VRR0(24,76)+WQx*VRR1(24,76)
      VRR0(24,108)=2.D0*V(110)-2.D0*V(113)+QCz*VRR0(24,72)+WQz*VRR1(24,72)
      VRR0(24,109)=V(136)+V(139)+3.D0*V(140)+QCy*VRR0(24,77)+WQy*VRR1(24,77)
      VRR0(24,110)=3.D0*V(141)+3.D0*V(142)-3.D0*V(143)+QCy*VRR0(24,78)+WQy*VRR1(24,78)
      VRR0(24,111)=3.D0*V(118)-3.D0*V(119)+QCz*VRR0(24,75)+WQz*VRR1(24,75)
      VRR0(24,112)=V(121)+V(124)+QCz*VRR0(24,76)+WQz*VRR1(24,76)
      VRR0(24,113)=V(128)+V(129)+QCz*VRR0(24,77)+WQz*VRR1(24,77)
      VRR0(24,114)=3.D0*V(130)-3.D0*V(131)+QCz*VRR0(24,78)+WQz*VRR1(24,78)
      VRR0(24,115)=4.D0*V(132)-4.D0*V(134)+QCz*VRR0(24,79)+WQz*VRR1(24,79)
      VRR0(24,116)=4.D0*V(135)-4.D0*V(138)+QCz*VRR0(24,80)+WQz*VRR1(24,80)
      VRR0(24,117)=4.D0*V(141)-4.D0*V(143)+QCz*VRR0(24,81)+WQz*VRR1(24,81)
      VRR0(24,118)=5.D0*r1x2E*VRR0(24,54)+QCz*VRR0(24,82)-5.D0*r1x2E*ZxZpE*VRR1(24,54)+WQz*VRR1(24,82)
      VRR0(24,119)=5.D0*r1x2E*VRR0(24,55)+QCz*VRR0(24,83)-5.D0*r1x2E*ZxZpE*VRR1(24,55)+WQz*VRR1(24,83)
      VRR0(24,120)=6.D0*r1x2E*VRR0(24,56)+QCz*VRR0(24,84)-6.D0*r1x2E*ZxZpE*VRR1(24,56)+WQz*VRR1(24,84)
      VRR0(25,85)=6.D0*r1x2E*VRR0(25,36)+QCx*VRR0(25,57)-6.D0*r1x2E*ZxZpE*VRR1(25,36)+WQx*VRR1(25,57)
      VRR0(25,86)=5.D0*r1x2E*VRR0(25,37)+QCx*VRR0(25,58)-5.D0*r1x2E*ZxZpE*VRR1(25,37)+WQx*VRR1(25,58)
      VRR0(25,87)=4.D0*V(144)-4.D0*V(145)+QCx*VRR0(25,59)+WQx*VRR1(25,59)
      VRR0(25,88)=3.D0*V(146)-3.D0*V(147)+QCx*VRR0(25,60)+WQx*VRR1(25,60)
      VRR0(25,89)=4.D0*V(108)+3.D0*V(144)-3.D0*V(145)+QCy*VRR0(25,60)+WQy*VRR1(25,60)
      VRR0(25,90)=4.D0*V(146)-4.D0*V(147)+QCy*VRR0(25,61)+4.D0*HfxZpE*VRR1(14,61)+WQy*VRR1(25,61)
      VRR0(25,91)=5.D0*r1x2E*VRR0(25,40)+QCy*VRR0(25,62)+4.D0*HfxZpE*VRR1(14,62)-5.D0*r1x2E*ZxZpE*VRR1(25,40)+WQy*VRR1(25,62)
      VRR0(25,92)=6.D0*r1x2E*VRR0(25,41)+QCy*VRR0(25,63)+4.D0*HfxZpE*VRR1(14,63)-6.D0*r1x2E*ZxZpE*VRR1(25,41)+WQy*VRR1(25,63)
      VRR0(25,93)=5.D0*r1x2E*VRR0(25,42)+QCx*VRR0(25,64)-5.D0*r1x2E*ZxZpE*VRR1(25,42)+WQx*VRR1(25,64)
      VRR0(25,94)=4.D0*r1x2E*VRR0(25,43)+QCx*VRR0(25,65)-4.D0*r1x2E*ZxZpE*VRR1(25,43)+WQx*VRR1(25,65)
      VRR0(25,95)=V(149)+V(151)+QCx*VRR0(25,66)+WQx*VRR1(25,66)
      VRR0(25,96)=3.D0*V(112)+3.D0*r1x2Z*VRR0(7,96)+PAy*VRR0(14,96)-3.D0*ExZpE*r1x2Z*VRR1(7,96)+WPy*VRR1(14,96)
      VRR0(25,97)=4.D0*V(116)+V(149)+V(151)+QCy*VRR0(25,67)+WQy*VRR1(25,67)
      VRR0(25,98)=4.D0*r1x2E*VRR0(25,45)+QCy*VRR0(25,68)+4.D0*HfxZpE*VRR1(14,68)-4.D0*r1x2E*ZxZpE*VRR1(25,45)+WQy*VRR1(25,68)
      VRR0(25,99)=5.D0*r1x2E*VRR0(25,46)+QCy*VRR0(25,69)+4.D0*HfxZpE*VRR1(14,69)-5.D0*r1x2E*ZxZpE*VRR1(25,46)+WQy*VRR1(25,69)
      VRR0(25,100)=4.D0*V(152)-4.D0*V(153)+QCx*VRR0(25,70)+WQx*VRR1(25,70)
      VRR0(25,101)=V(155)+V(157)+QCx*VRR0(25,71)+WQx*VRR1(25,71)
      VRR0(25,102)=2.D0*V(122)+3.D0*r1x2Z*VRR0(7,102)+PAy*VRR0(14,102)-3.D0*ExZpE*r1x2Z*VRR1(7,102)+WPy*VRR1(14,102)
      VRR0(25,103)=3.D0*V(126)+3.D0*r1x2Z*VRR0(7,103)+PAy*VRR0(14,103)-3.D0*ExZpE*r1x2Z*VRR1(7,103)+WPy*VRR1(14,103)
      VRR0(25,104)=V(159)+V(161)+QCy*VRR0(25,73)+4.D0*HfxZpE*VRR1(14,73)+WQy*VRR1(25,73)
      VRR0(25,105)=4.D0*V(162)-4.D0*V(163)+QCy*VRR0(25,74)+4.D0*HfxZpE*VRR1(14,74)+WQy*VRR1(25,74)
      VRR0(25,106)=3.D0*V(164)-3.D0*V(165)+QCx*VRR0(25,75)+WQx*VRR1(25,75)
      VRR0(25,107)=V(133)+3.D0*r1x2Z*VRR0(7,107)+PAy*VRR0(14,107)-3.D0*ExZpE*r1x2Z*VRR1(7,107)+WPy*VRR1(14,107)
      VRR0(25,108)=2.D0*V(137)+3.D0*r1x2Z*VRR0(7,108)+PAy*VRR0(14,108)-3.D0*ExZpE*r1x2Z*VRR1(7,108)+WPy*VRR1(14,108)
      VRR0(25,109)=3.D0*V(166)+3.D0*r1x2Z*VRR0(7,109)+PAy*VRR0(14,109)-3.D0*ExZpE*r1x2Z*VRR1(7,109)+WPy*VRR1(14,109)
      VRR0(25,110)=3.D0*V(167)+4.D0*V(168)-3.D0*V(169)+QCy*VRR0(25,78)+WQy*VRR1(25,78)
      VRR0(25,111)=3.D0*V(152)-3.D0*V(153)+QCz*VRR0(25,75)+WQz*VRR1(25,75)
      VRR0(25,112)=V(155)+V(157)+QCz*VRR0(25,76)+WQz*VRR1(25,76)
      VRR0(25,113)=V(159)+V(161)+QCz*VRR0(25,77)+WQz*VRR1(25,77)
      VRR0(25,114)=3.D0*V(162)-3.D0*V(163)+QCz*VRR0(25,78)+WQz*VRR1(25,78)
      VRR0(25,115)=4.D0*V(164)-4.D0*V(165)+QCz*VRR0(25,79)+WQz*VRR1(25,79)
      VRR0(25,116)=4.D0*r1x2E*VRR0(25,52)+QCz*VRR0(25,80)-4.D0*r1x2E*ZxZpE*VRR1(25,52)+WQz*VRR1(25,80)
      VRR0(25,117)=4.D0*V(167)-4.D0*V(169)+QCz*VRR0(25,81)+WQz*VRR1(25,81)
      VRR0(25,118)=5.D0*r1x2E*VRR0(25,54)+QCz*VRR0(25,82)-5.D0*r1x2E*ZxZpE*VRR1(25,54)+WQz*VRR1(25,82)
      VRR0(25,119)=5.D0*r1x2E*VRR0(25,55)+QCz*VRR0(25,83)-5.D0*r1x2E*ZxZpE*VRR1(25,55)+WQz*VRR1(25,83)
      VRR0(25,120)=6.D0*r1x2E*VRR0(25,56)+QCz*VRR0(25,84)-6.D0*r1x2E*ZxZpE*VRR1(25,56)+WQz*VRR1(25,84)
      VRR0(26,85)=6.D0*r1x2E*VRR0(26,36)+QCx*VRR0(26,57)+3.D0*HfxZpE*VRR1(15,57)-6.D0*r1x2E*ZxZpE*VRR1(26,36)+WQx*VRR1(26,57)
      VRR0(26,86)=5.D0*r1x2E*VRR0(26,37)+QCx*VRR0(26,58)+3.D0*HfxZpE*VRR1(15,58)-5.D0*r1x2E*ZxZpE*VRR1(26,37)+WQx*VRR1(26,58)
      VRR0(26,87)=4.D0*V(170)-4.D0*V(171)+QCx*VRR0(26,59)+3.D0*HfxZpE*VRR1(15,59)+WQx*VRR1(26,59)
      VRR0(26,88)=3.D0*V(172)+3.D0*V(173)-3.D0*V(174)+QCx*VRR0(26,60)+WQx*VRR1(26,60)
      VRR0(26,89)=3.D0*V(170)-3.D0*V(171)+QCy*VRR0(26,60)+WQy*VRR1(26,60)
      VRR0(26,90)=4.D0*V(172)-4.D0*V(174)+QCy*VRR0(26,61)+WQy*VRR1(26,61)
      VRR0(26,91)=5.D0*r1x2E*VRR0(26,40)+QCy*VRR0(26,62)-5.D0*r1x2E*ZxZpE*VRR1(26,40)+WQy*VRR1(26,62)
      VRR0(26,92)=6.D0*r1x2E*VRR0(26,41)+QCy*VRR0(26,63)-6.D0*r1x2E*ZxZpE*VRR1(26,41)+WQy*VRR1(26,63)
      VRR0(26,93)=5.D0*r1x2E*VRR0(26,42)+QCx*VRR0(26,64)+3.D0*HfxZpE*VRR1(15,64)-5.D0*r1x2E*ZxZpE*VRR1(26,42)+WQx*VRR1(26,64)
      VRR0(26,94)=4.D0*r1x2E*VRR0(26,43)+QCx*VRR0(26,65)+3.D0*HfxZpE*VRR1(15,65)-4.D0*r1x2E*ZxZpE*VRR1(26,43)+WQx*VRR1(26,65)
      VRR0(26,95)=V(176)+V(178)+QCx*VRR0(26,66)+3.D0*HfxZpE*VRR1(15,66)+WQx*VRR1(26,66)
      VRR0(26,96)=2.D0*V(179)+3.D0*V(180)-2.D0*V(181)+QCx*VRR0(26,67)+WQx*VRR1(26,67)
      VRR0(26,97)=V(176)+V(178)+QCy*VRR0(26,67)+WQy*VRR1(26,67)
      VRR0(26,98)=4.D0*V(179)-4.D0*V(181)+QCy*VRR0(26,68)+WQy*VRR1(26,68)
      VRR0(26,99)=5.D0*r1x2E*VRR0(26,46)+QCy*VRR0(26,69)-5.D0*r1x2E*ZxZpE*VRR1(26,46)+WQy*VRR1(26,69)
      VRR0(26,100)=4.D0*V(182)-4.D0*V(183)+QCx*VRR0(26,70)+3.D0*HfxZpE*VRR1(15,70)+WQx*VRR1(26,70)
      VRR0(26,101)=V(185)+V(187)+QCx*VRR0(26,71)+3.D0*HfxZpE*VRR1(15,71)+WQx*VRR1(26,71)
      VRR0(26,102)=2.D0*V(188)+3.D0*V(189)-2.D0*V(190)+QCx*VRR0(26,72)+WQx*VRR1(26,72)
      VRR0(26,103)=2.D0*V(184)-2.D0*V(186)+QCy*VRR0(26,72)+WQy*VRR1(26,72)
      VRR0(26,104)=V(191)+V(192)+QCy*VRR0(26,73)+WQy*VRR1(26,73)
      VRR0(26,105)=4.D0*V(193)-4.D0*V(194)+QCy*VRR0(26,74)+WQy*VRR1(26,74)
      VRR0(26,106)=3.D0*V(195)+3.D0*V(196)-3.D0*V(197)+QCx*VRR0(26,75)+WQx*VRR1(26,75)
      VRR0(26,107)=V(199)+3.D0*V(200)+V(202)+QCx*VRR0(26,76)+WQx*VRR1(26,76)
      VRR0(26,108)=V(17)+2.D0*V(175)-2.D0*V(177)+QCz*VRR0(26,72)+WQz*VRR1(26,72)
      VRR0(26,109)=V(199)+V(202)+QCy*VRR0(26,77)+WQy*VRR1(26,77)
      VRR0(26,110)=3.D0*V(203)-3.D0*V(204)+QCy*VRR0(26,78)+WQy*VRR1(26,78)
      VRR0(26,111)=V(26)+3.D0*V(182)-3.D0*V(183)+QCz*VRR0(26,75)+WQz*VRR1(26,75)
      VRR0(26,112)=V(28)+V(185)+V(187)+QCz*VRR0(26,76)+WQz*VRR1(26,76)
      VRR0(26,113)=V(29)+V(191)+V(192)+QCz*VRR0(26,77)+WQz*VRR1(26,77)
      VRR0(26,114)=V(30)+3.D0*V(193)-3.D0*V(194)+QCz*VRR0(26,78)+WQz*VRR1(26,78)
      VRR0(26,115)=4.D0*V(195)-4.D0*V(197)+QCz*VRR0(26,79)+HfxZpE*VRR1(11,79)+WQz*VRR1(26,79)
      VRR0(26,116)=4.D0*V(198)-4.D0*V(201)+QCz*VRR0(26,80)+HfxZpE*VRR1(11,80)+WQz*VRR1(26,80)
      VRR0(26,117)=4.D0*V(203)-4.D0*V(204)+QCz*VRR0(26,81)+HfxZpE*VRR1(11,81)+WQz*VRR1(26,81)
      VRR0(26,118)=5.D0*r1x2E*VRR0(26,54)+QCz*VRR0(26,82)+HfxZpE*VRR1(11,82)-5.D0*r1x2E*ZxZpE*VRR1(26,54)+WQz*VRR1(26,82)
      VRR0(26,119)=5.D0*r1x2E*VRR0(26,55)+QCz*VRR0(26,83)+HfxZpE*VRR1(11,83)-5.D0*r1x2E*ZxZpE*VRR1(26,55)+WQz*VRR1(26,83)
      VRR0(26,120)=6.D0*r1x2E*VRR0(26,56)+QCz*VRR0(26,84)+HfxZpE*VRR1(11,84)-6.D0*r1x2E*ZxZpE*VRR1(26,56)+WQz*VRR1(26,84)
      VRR0(27,85)=6.D0*r1x2E*VRR0(27,36)+QCx*VRR0(27,57)+2.D0*HfxZpE*VRR1(16,57)-6.D0*r1x2E*ZxZpE*VRR1(27,36)+WQx*VRR1(27,57)
      VRR0(27,86)=5.D0*r1x2E*VRR0(27,37)+QCx*VRR0(27,58)+2.D0*HfxZpE*VRR1(16,58)-5.D0*r1x2E*ZxZpE*VRR1(27,37)+WQx*VRR1(27,58)
      VRR0(27,87)=4.D0*V(205)-4.D0*V(206)+QCx*VRR0(27,59)+2.D0*HfxZpE*VRR1(16,59)+WQx*VRR1(27,59)
      VRR0(27,88)=3.D0*V(207)+V(209)-3.D0*V(210)+QCx*VRR0(27,60)+WQx*VRR1(27,60)
      VRR0(27,89)=V(173)+3.D0*V(205)-3.D0*V(206)+QCy*VRR0(27,60)+WQy*VRR1(27,60)
      VRR0(27,90)=4.D0*V(207)-4.D0*V(210)+QCy*VRR0(27,61)+HfxZpE*VRR1(15,61)+WQy*VRR1(27,61)
      VRR0(27,91)=5.D0*r1x2E*VRR0(27,40)+QCy*VRR0(27,62)+HfxZpE*VRR1(15,62)-5.D0*r1x2E*ZxZpE*VRR1(27,40)+WQy*VRR1(27,62)
      VRR0(27,92)=6.D0*r1x2E*VRR0(27,41)+QCy*VRR0(27,63)+HfxZpE*VRR1(15,63)-6.D0*r1x2E*ZxZpE*VRR1(27,41)+WQy*VRR1(27,63)
      VRR0(27,93)=5.D0*r1x2E*VRR0(27,42)+QCx*VRR0(27,64)+2.D0*HfxZpE*VRR1(16,64)-5.D0*r1x2E*ZxZpE*VRR1(27,42)+WQx*VRR1(27,64)
      VRR0(27,94)=4.D0*r1x2E*VRR0(27,43)+QCx*VRR0(27,65)+2.D0*HfxZpE*VRR1(16,65)-4.D0*r1x2E*ZxZpE*VRR1(27,43)+WQx*VRR1(27,65)
      VRR0(27,95)=V(212)+V(214)+QCx*VRR0(27,66)+2.D0*HfxZpE*VRR1(16,66)+WQx*VRR1(27,66)
      VRR0(27,96)=2.D0*V(215)+V(217)-2.D0*V(218)+QCx*VRR0(27,67)+WQx*VRR1(27,67)
      VRR0(27,97)=V(180)+V(212)+V(214)+QCy*VRR0(27,67)+WQy*VRR1(27,67)
      VRR0(27,98)=4.D0*V(215)-4.D0*V(218)+QCy*VRR0(27,68)+HfxZpE*VRR1(15,68)+WQy*VRR1(27,68)
      VRR0(27,99)=5.D0*r1x2E*VRR0(27,46)+QCy*VRR0(27,69)+HfxZpE*VRR1(15,69)-5.D0*r1x2E*ZxZpE*VRR1(27,46)+WQy*VRR1(27,69)
      VRR0(27,100)=4.D0*V(219)-4.D0*V(220)+QCx*VRR0(27,70)+2.D0*HfxZpE*VRR1(16,70)+WQx*VRR1(27,70)
      VRR0(27,101)=V(222)+V(224)+QCx*VRR0(27,71)+2.D0*HfxZpE*VRR1(16,71)+WQx*VRR1(27,71)
      VRR0(27,102)=2.D0*V(225)+V(227)-2.D0*V(228)+QCx*VRR0(27,72)+WQx*VRR1(27,72)
      VRR0(27,103)=V(189)+2.D0*V(221)-2.D0*V(223)+QCy*VRR0(27,72)+WQy*VRR1(27,72)
      VRR0(27,104)=V(229)+V(230)+QCy*VRR0(27,73)+HfxZpE*VRR1(15,73)+WQy*VRR1(27,73)
      VRR0(27,105)=4.D0*V(231)-4.D0*V(232)+QCy*VRR0(27,74)+HfxZpE*VRR1(15,74)+WQy*VRR1(27,74)
      VRR0(27,106)=3.D0*V(233)+V(235)-3.D0*V(236)+QCx*VRR0(27,75)+WQx*VRR1(27,75)
      VRR0(27,107)=V(238)+V(240)+V(242)+QCx*VRR0(27,76)+WQx*VRR1(27,76)
      VRR0(27,108)=V(52)+2.D0*V(211)-2.D0*V(213)+QCz*VRR0(27,72)+WQz*VRR1(27,72)
      VRR0(27,109)=V(238)+V(242)+V(243)+QCy*VRR0(27,77)+WQy*VRR1(27,77)
      VRR0(27,110)=3.D0*V(244)+V(245)-3.D0*V(246)+QCy*VRR0(27,78)+WQy*VRR1(27,78)
      VRR0(27,111)=V(59)+3.D0*V(219)-3.D0*V(220)+QCz*VRR0(27,75)+WQz*VRR1(27,75)
      VRR0(27,112)=V(63)+V(222)+V(224)+QCz*VRR0(27,76)+WQz*VRR1(27,76)
      VRR0(27,113)=V(101)+V(229)+V(230)+QCz*VRR0(27,77)+WQz*VRR1(27,77)
      VRR0(27,114)=V(103)+3.D0*V(231)-3.D0*V(232)+QCz*VRR0(27,78)+WQz*VRR1(27,78)
      VRR0(27,115)=4.D0*V(233)-4.D0*V(236)+QCz*VRR0(27,79)+HfxZpE*VRR1(12,79)+WQz*VRR1(27,79)
      VRR0(27,116)=4.D0*V(237)-4.D0*V(241)+QCz*VRR0(27,80)+HfxZpE*VRR1(12,80)+WQz*VRR1(27,80)
      VRR0(27,117)=4.D0*V(244)-4.D0*V(246)+QCz*VRR0(27,81)+HfxZpE*VRR1(12,81)+WQz*VRR1(27,81)
      VRR0(27,118)=5.D0*r1x2E*VRR0(27,54)+QCz*VRR0(27,82)+HfxZpE*VRR1(12,82)-5.D0*r1x2E*ZxZpE*VRR1(27,54)+WQz*VRR1(27,82)
      VRR0(27,119)=5.D0*r1x2E*VRR0(27,55)+QCz*VRR0(27,83)+HfxZpE*VRR1(12,83)-5.D0*r1x2E*ZxZpE*VRR1(27,55)+WQz*VRR1(27,83)
      VRR0(27,120)=6.D0*r1x2E*VRR0(27,56)+QCz*VRR0(27,84)+HfxZpE*VRR1(12,84)-6.D0*r1x2E*ZxZpE*VRR1(27,56)+WQz*VRR1(27,84)
      VRR0(28,85)=6.D0*r1x2E*VRR0(28,36)+QCx*VRR0(28,57)+HfxZpE*VRR1(17,57)-6.D0*r1x2E*ZxZpE*VRR1(28,36)+WQx*VRR1(28,57)
      VRR0(28,86)=5.D0*r1x2E*VRR0(28,37)+QCx*VRR0(28,58)+HfxZpE*VRR1(17,58)-5.D0*r1x2E*ZxZpE*VRR1(28,37)+WQx*VRR1(28,58)
      VRR0(28,87)=4.D0*V(247)-4.D0*V(248)+QCx*VRR0(28,59)+HfxZpE*VRR1(17,59)+WQx*VRR1(28,59)
      VRR0(28,88)=3.D0*V(249)+V(250)-3.D0*V(251)+QCx*VRR0(28,60)+WQx*VRR1(28,60)
      VRR0(28,89)=V(209)+3.D0*V(247)-3.D0*V(248)+QCy*VRR0(28,60)+WQy*VRR1(28,60)
      VRR0(28,90)=4.D0*V(249)-4.D0*V(251)+QCy*VRR0(28,61)+2.D0*HfxZpE*VRR1(16,61)+WQy*VRR1(28,61)
      VRR0(28,91)=5.D0*r1x2E*VRR0(28,40)+QCy*VRR0(28,62)+2.D0*HfxZpE*VRR1(16,62)-5.D0*r1x2E*ZxZpE*VRR1(28,40)+WQy*VRR1(28,62)
      VRR0(28,92)=6.D0*r1x2E*VRR0(28,41)+QCy*VRR0(28,63)+2.D0*HfxZpE*VRR1(16,63)-6.D0*r1x2E*ZxZpE*VRR1(28,41)+WQy*VRR1(28,63)
      VRR0(28,93)=5.D0*r1x2E*VRR0(28,42)+QCx*VRR0(28,64)+HfxZpE*VRR1(17,64)-5.D0*r1x2E*ZxZpE*VRR1(28,42)+WQx*VRR1(28,64)
      VRR0(28,94)=4.D0*r1x2E*VRR0(28,43)+QCx*VRR0(28,65)+HfxZpE*VRR1(17,65)-4.D0*r1x2E*ZxZpE*VRR1(28,43)+WQx*VRR1(28,65)
      VRR0(28,95)=V(253)+V(255)+QCx*VRR0(28,66)+HfxZpE*VRR1(17,66)+WQx*VRR1(28,66)
      VRR0(28,96)=2.D0*V(256)+V(257)-2.D0*V(258)+QCx*VRR0(28,67)+WQx*VRR1(28,67)
      VRR0(28,97)=V(217)+V(253)+V(255)+QCy*VRR0(28,67)+WQy*VRR1(28,67)
      VRR0(28,98)=4.D0*V(256)-4.D0*V(258)+QCy*VRR0(28,68)+2.D0*HfxZpE*VRR1(16,68)+WQy*VRR1(28,68)
      VRR0(28,99)=5.D0*r1x2E*VRR0(28,46)+QCy*VRR0(28,69)+2.D0*HfxZpE*VRR1(16,69)-5.D0*r1x2E*ZxZpE*VRR1(28,46)+WQy*VRR1(28,69)
      VRR0(28,100)=4.D0*V(259)-4.D0*V(260)+QCx*VRR0(28,70)+HfxZpE*VRR1(17,70)+WQx*VRR1(28,70)
      VRR0(28,101)=V(262)+V(264)+QCx*VRR0(28,71)+HfxZpE*VRR1(17,71)+WQx*VRR1(28,71)
      VRR0(28,102)=2.D0*V(265)+V(266)-2.D0*V(267)+QCx*VRR0(28,72)+WQx*VRR1(28,72)
      VRR0(28,103)=V(227)+2.D0*V(261)-2.D0*V(263)+QCy*VRR0(28,72)+WQy*VRR1(28,72)
      VRR0(28,104)=V(268)+V(269)+QCy*VRR0(28,73)+2.D0*HfxZpE*VRR1(16,73)+WQy*VRR1(28,73)
      VRR0(28,105)=4.D0*V(270)-4.D0*V(271)+QCy*VRR0(28,74)+2.D0*HfxZpE*VRR1(16,74)+WQy*VRR1(28,74)
      VRR0(28,106)=3.D0*V(272)+V(273)-3.D0*V(274)+QCx*VRR0(28,75)+WQx*VRR1(28,75)
      VRR0(28,107)=V(276)+V(277)+V(279)+QCx*VRR0(28,76)+WQx*VRR1(28,76)
      VRR0(28,108)=V(87)+2.D0*V(252)-2.D0*V(254)+QCz*VRR0(28,72)+WQz*VRR1(28,72)
      VRR0(28,109)=V(276)+V(279)+V(281)+QCy*VRR0(28,77)+WQy*VRR1(28,77)
      VRR0(28,110)=3.D0*V(282)+V(284)-3.D0*V(285)+QCy*VRR0(28,78)+WQy*VRR1(28,78)
      VRR0(28,111)=V(94)+3.D0*V(259)-3.D0*V(260)+QCz*VRR0(28,75)+WQz*VRR1(28,75)
      VRR0(28,112)=V(98)+V(262)+V(264)+QCz*VRR0(28,76)+WQz*VRR1(28,76)
      VRR0(28,113)=V(140)+V(268)+V(269)+QCz*VRR0(28,77)+WQz*VRR1(28,77)
      VRR0(28,114)=V(142)+3.D0*V(270)-3.D0*V(271)+QCz*VRR0(28,78)+WQz*VRR1(28,78)
      VRR0(28,115)=4.D0*V(272)-4.D0*V(274)+QCz*VRR0(28,79)+HfxZpE*VRR1(13,79)+WQz*VRR1(28,79)
      VRR0(28,116)=4.D0*V(275)-4.D0*V(278)+QCz*VRR0(28,80)+HfxZpE*VRR1(13,80)+WQz*VRR1(28,80)
      VRR0(28,117)=4.D0*V(282)-4.D0*V(285)+QCz*VRR0(28,81)+HfxZpE*VRR1(13,81)+WQz*VRR1(28,81)
      VRR0(28,118)=5.D0*r1x2E*VRR0(28,54)+QCz*VRR0(28,82)+HfxZpE*VRR1(13,82)-5.D0*r1x2E*ZxZpE*VRR1(28,54)+WQz*VRR1(28,82)
      VRR0(28,119)=5.D0*r1x2E*VRR0(28,55)+QCz*VRR0(28,83)+HfxZpE*VRR1(13,83)-5.D0*r1x2E*ZxZpE*VRR1(28,55)+WQz*VRR1(28,83)
      VRR0(28,120)=6.D0*r1x2E*VRR0(28,56)+QCz*VRR0(28,84)+HfxZpE*VRR1(13,84)-6.D0*r1x2E*ZxZpE*VRR1(28,56)+WQz*VRR1(28,84)
      VRR0(29,85)=6.D0*r1x2E*VRR0(29,36)+QCx*VRR0(29,57)-6.D0*r1x2E*ZxZpE*VRR1(29,36)+WQx*VRR1(29,57)
      VRR0(29,86)=5.D0*r1x2E*VRR0(29,37)+QCx*VRR0(29,58)-5.D0*r1x2E*ZxZpE*VRR1(29,37)+WQx*VRR1(29,58)
      VRR0(29,87)=4.D0*V(286)-4.D0*V(287)+QCx*VRR0(29,59)+WQx*VRR1(29,59)
      VRR0(29,88)=3.D0*V(288)-3.D0*V(289)+QCx*VRR0(29,60)+WQx*VRR1(29,60)
      VRR0(29,89)=3.D0*V(250)+3.D0*V(286)-3.D0*V(287)+QCy*VRR0(29,60)+WQy*VRR1(29,60)
      VRR0(29,90)=4.D0*V(288)-4.D0*V(289)+QCy*VRR0(29,61)+3.D0*HfxZpE*VRR1(17,61)+WQy*VRR1(29,61)
      VRR0(29,91)=5.D0*r1x2E*VRR0(29,40)+QCy*VRR0(29,62)+3.D0*HfxZpE*VRR1(17,62)-5.D0*r1x2E*ZxZpE*VRR1(29,40)+WQy*VRR1(29,62)
      VRR0(29,92)=6.D0*r1x2E*VRR0(29,41)+QCy*VRR0(29,63)+3.D0*HfxZpE*VRR1(17,63)-6.D0*r1x2E*ZxZpE*VRR1(29,41)+WQy*VRR1(29,63)
      VRR0(29,93)=5.D0*r1x2E*VRR0(29,42)+QCx*VRR0(29,64)-5.D0*r1x2E*ZxZpE*VRR1(29,42)+WQx*VRR1(29,64)
      VRR0(29,94)=4.D0*r1x2E*VRR0(29,43)+QCx*VRR0(29,65)-4.D0*r1x2E*ZxZpE*VRR1(29,43)+WQx*VRR1(29,65)
      VRR0(29,95)=V(291)+V(293)+QCx*VRR0(29,66)+WQx*VRR1(29,66)
      VRR0(29,96)=2.D0*V(294)-2.D0*V(295)+QCx*VRR0(29,67)+WQx*VRR1(29,67)
      VRR0(29,97)=3.D0*V(257)+V(291)+V(293)+QCy*VRR0(29,67)+WQy*VRR1(29,67)
      VRR0(29,98)=4.D0*V(294)-4.D0*V(295)+QCy*VRR0(29,68)+3.D0*HfxZpE*VRR1(17,68)+WQy*VRR1(29,68)
      VRR0(29,99)=5.D0*r1x2E*VRR0(29,46)+QCy*VRR0(29,69)+3.D0*HfxZpE*VRR1(17,69)-5.D0*r1x2E*ZxZpE*VRR1(29,46)+WQy*VRR1(29,69)
      VRR0(29,100)=4.D0*V(296)-4.D0*V(297)+QCx*VRR0(29,70)+WQx*VRR1(29,70)
      VRR0(29,101)=V(299)+V(301)+QCx*VRR0(29,71)+WQx*VRR1(29,71)
      VRR0(29,102)=2.D0*V(302)-2.D0*V(303)+QCx*VRR0(29,72)+WQx*VRR1(29,72)
      VRR0(29,103)=3.D0*V(266)+2.D0*V(298)-2.D0*V(300)+QCy*VRR0(29,72)+WQy*VRR1(29,72)
      VRR0(29,104)=V(304)+V(305)+QCy*VRR0(29,73)+3.D0*HfxZpE*VRR1(17,73)+WQy*VRR1(29,73)
      VRR0(29,105)=4.D0*V(306)-4.D0*V(307)+QCy*VRR0(29,74)+3.D0*HfxZpE*VRR1(17,74)+WQy*VRR1(29,74)
      VRR0(29,106)=3.D0*V(308)-3.D0*V(309)+QCx*VRR0(29,75)+WQx*VRR1(29,75)
      VRR0(29,107)=V(311)+V(313)+QCx*VRR0(29,76)+WQx*VRR1(29,76)
      VRR0(29,108)=V(126)+2.D0*V(290)-2.D0*V(292)+QCz*VRR0(29,72)+WQz*VRR1(29,72)
      VRR0(29,109)=V(311)+V(313)+3.D0*V(314)+QCy*VRR0(29,77)+WQy*VRR1(29,77)
      VRR0(29,110)=3.D0*V(315)+3.D0*V(316)-3.D0*V(317)+QCy*VRR0(29,78)+WQy*VRR1(29,78)
      VRR0(29,111)=V(133)+3.D0*V(296)-3.D0*V(297)+QCz*VRR0(29,75)+WQz*VRR1(29,75)
      VRR0(29,112)=V(137)+V(299)+V(301)+QCz*VRR0(29,76)+WQz*VRR1(29,76)
      VRR0(29,113)=V(166)+V(304)+V(305)+QCz*VRR0(29,77)+WQz*VRR1(29,77)
      VRR0(29,114)=V(168)+3.D0*V(306)-3.D0*V(307)+QCz*VRR0(29,78)+WQz*VRR1(29,78)
      VRR0(29,115)=4.D0*V(308)-4.D0*V(309)+QCz*VRR0(29,79)+HfxZpE*VRR1(14,79)+WQz*VRR1(29,79)
      VRR0(29,116)=4.D0*V(310)-4.D0*V(312)+QCz*VRR0(29,80)+HfxZpE*VRR1(14,80)+WQz*VRR1(29,80)
      VRR0(29,117)=4.D0*V(315)-4.D0*V(317)+QCz*VRR0(29,81)+HfxZpE*VRR1(14,81)+WQz*VRR1(29,81)
      VRR0(29,118)=5.D0*r1x2E*VRR0(29,54)+QCz*VRR0(29,82)+HfxZpE*VRR1(14,82)-5.D0*r1x2E*ZxZpE*VRR1(29,54)+WQz*VRR1(29,82)
      VRR0(29,119)=5.D0*r1x2E*VRR0(29,55)+QCz*VRR0(29,83)+HfxZpE*VRR1(14,83)-5.D0*r1x2E*ZxZpE*VRR1(29,55)+WQz*VRR1(29,83)
      VRR0(29,120)=6.D0*r1x2E*VRR0(29,56)+QCz*VRR0(29,84)+HfxZpE*VRR1(14,84)-6.D0*r1x2E*ZxZpE*VRR1(29,56)+WQz*VRR1(29,84)
      VRR0(30,85)=6.D0*r1x2E*VRR0(30,36)+QCx*VRR0(30,57)+2.D0*HfxZpE*VRR1(18,57)-6.D0*r1x2E*ZxZpE*VRR1(30,36)+WQx*VRR1(30,57)
      VRR0(30,86)=5.D0*r1x2E*VRR0(30,37)+QCx*VRR0(30,58)+2.D0*HfxZpE*VRR1(18,58)-5.D0*r1x2E*ZxZpE*VRR1(30,37)+WQx*VRR1(30,58)
      VRR0(30,87)=4.D0*V(318)-4.D0*V(319)+QCx*VRR0(30,59)+2.D0*HfxZpE*VRR1(18,59)+WQx*VRR1(30,59)
      VRR0(30,88)=3.D0*V(320)+2.D0*V(321)-3.D0*V(322)+QCx*VRR0(30,60)+WQx*VRR1(30,60)
      VRR0(30,89)=3.D0*V(318)-3.D0*V(319)+QCy*VRR0(30,60)+WQy*VRR1(30,60)
      VRR0(30,90)=4.D0*V(320)-4.D0*V(322)+QCy*VRR0(30,61)+WQy*VRR1(30,61)
      VRR0(30,91)=5.D0*r1x2E*VRR0(30,40)+QCy*VRR0(30,62)-5.D0*r1x2E*ZxZpE*VRR1(30,40)+WQy*VRR1(30,62)
      VRR0(30,92)=6.D0*r1x2E*VRR0(30,41)+QCy*VRR0(30,63)-6.D0*r1x2E*ZxZpE*VRR1(30,41)+WQy*VRR1(30,63)
      VRR0(30,93)=5.D0*r1x2E*VRR0(30,42)+QCx*VRR0(30,64)+2.D0*HfxZpE*VRR1(18,64)-5.D0*r1x2E*ZxZpE*VRR1(30,42)+WQx*VRR1(30,64)
      VRR0(30,94)=4.D0*r1x2E*VRR0(30,43)+QCx*VRR0(30,65)+2.D0*HfxZpE*VRR1(18,65)-4.D0*r1x2E*ZxZpE*VRR1(30,43)+WQx*VRR1(30,65)
      VRR0(30,95)=V(324)+V(326)+QCx*VRR0(30,66)+2.D0*HfxZpE*VRR1(18,66)+WQx*VRR1(30,66)
      VRR0(30,96)=2.D0*V(327)+2.D0*V(328)-2.D0*V(329)+QCx*VRR0(30,67)+WQx*VRR1(30,67)
      VRR0(30,97)=V(324)+V(326)+QCy*VRR0(30,67)+WQy*VRR1(30,67)
      VRR0(30,98)=4.D0*V(327)-4.D0*V(329)+QCy*VRR0(30,68)+WQy*VRR1(30,68)
      VRR0(30,99)=5.D0*r1x2E*VRR0(30,46)+QCy*VRR0(30,69)-5.D0*r1x2E*ZxZpE*VRR1(30,46)+WQy*VRR1(30,69)
      VRR0(30,100)=4.D0*V(330)-4.D0*V(331)+QCx*VRR0(30,70)+2.D0*HfxZpE*VRR1(18,70)+WQx*VRR1(30,70)
      VRR0(30,101)=V(333)+V(335)+QCx*VRR0(30,71)+2.D0*HfxZpE*VRR1(18,71)+WQx*VRR1(30,71)
      VRR0(30,102)=2.D0*V(336)+2.D0*V(337)-2.D0*V(338)+QCx*VRR0(30,72)+WQx*VRR1(30,72)
      VRR0(30,103)=2.D0*V(332)-2.D0*V(334)+QCy*VRR0(30,72)+WQy*VRR1(30,72)
      VRR0(30,104)=V(339)+V(340)+QCy*VRR0(30,73)+WQy*VRR1(30,73)
      VRR0(30,105)=4.D0*V(341)-4.D0*V(342)+QCy*VRR0(30,74)+WQy*VRR1(30,74)
      VRR0(30,106)=3.D0*V(343)+2.D0*V(344)-3.D0*V(345)+QCx*VRR0(30,75)+WQx*VRR1(30,75)
      VRR0(30,107)=V(347)+2.D0*V(348)+V(350)+QCx*VRR0(30,76)+WQx*VRR1(30,76)
      VRR0(30,108)=2.D0*V(189)+2.D0*V(323)-2.D0*V(325)+QCz*VRR0(30,72)+WQz*VRR1(30,72)
      VRR0(30,109)=V(347)+V(350)+QCy*VRR0(30,77)+WQy*VRR1(30,77)
      VRR0(30,110)=3.D0*V(351)-3.D0*V(352)+QCy*VRR0(30,78)+WQy*VRR1(30,78)
      VRR0(30,111)=2.D0*V(196)+3.D0*V(330)-3.D0*V(331)+QCz*VRR0(30,75)+WQz*VRR1(30,75)
      VRR0(30,112)=2.D0*V(200)+V(333)+V(335)+QCz*VRR0(30,76)+WQz*VRR1(30,76)
      VRR0(30,113)=2.D0*V(243)+V(339)+V(340)+QCz*VRR0(30,77)+WQz*VRR1(30,77)
      VRR0(30,114)=2.D0*V(245)+3.D0*V(341)-3.D0*V(342)+QCz*VRR0(30,78)+WQz*VRR1(30,78)
      VRR0(30,115)=4.D0*V(343)-4.D0*V(345)+QCz*VRR0(30,79)+2.D0*HfxZpE*VRR1(15,79)+WQz*VRR1(30,79)
      VRR0(30,116)=4.D0*V(346)-4.D0*V(349)+QCz*VRR0(30,80)+2.D0*HfxZpE*VRR1(15,80)+WQz*VRR1(30,80)
      VRR0(30,117)=4.D0*V(351)-4.D0*V(352)+QCz*VRR0(30,81)+2.D0*HfxZpE*VRR1(15,81)+WQz*VRR1(30,81)
      VRR0(30,118)=5.D0*r1x2E*VRR0(30,54)+QCz*VRR0(30,82)+2.D0*HfxZpE*VRR1(15,82)-5.D0*r1x2E*ZxZpE*VRR1(30,54)+WQz*VRR1(30,82)
      VRR0(30,119)=5.D0*r1x2E*VRR0(30,55)+QCz*VRR0(30,83)+2.D0*HfxZpE*VRR1(15,83)-5.D0*r1x2E*ZxZpE*VRR1(30,55)+WQz*VRR1(30,83)
      VRR0(30,120)=6.D0*r1x2E*VRR0(30,56)+QCz*VRR0(30,84)+2.D0*HfxZpE*VRR1(15,84)-6.D0*r1x2E*ZxZpE*VRR1(30,56)+WQz*VRR1(30,84)
      VRR0(31,85)=6.D0*r1x2E*VRR0(31,36)+QCx*VRR0(31,57)+HfxZpE*VRR1(19,57)-6.D0*r1x2E*ZxZpE*VRR1(31,36)+WQx*VRR1(31,57)
      VRR0(31,86)=5.D0*r1x2E*VRR0(31,37)+QCx*VRR0(31,58)+HfxZpE*VRR1(19,58)-5.D0*r1x2E*ZxZpE*VRR1(31,37)+WQx*VRR1(31,58)
      VRR0(31,87)=4.D0*V(353)-4.D0*V(354)+QCx*VRR0(31,59)+HfxZpE*VRR1(19,59)+WQx*VRR1(31,59)
      VRR0(31,88)=3.D0*V(355)+V(356)-3.D0*V(357)+QCx*VRR0(31,60)+WQx*VRR1(31,60)
      VRR0(31,89)=V(321)+3.D0*V(353)-3.D0*V(354)+QCy*VRR0(31,60)+WQy*VRR1(31,60)
      VRR0(31,90)=4.D0*V(355)-4.D0*V(357)+QCy*VRR0(31,61)+HfxZpE*VRR1(18,61)+WQy*VRR1(31,61)
      VRR0(31,91)=5.D0*r1x2E*VRR0(31,40)+QCy*VRR0(31,62)+HfxZpE*VRR1(18,62)-5.D0*r1x2E*ZxZpE*VRR1(31,40)+WQy*VRR1(31,62)
      VRR0(31,92)=6.D0*r1x2E*VRR0(31,41)+QCy*VRR0(31,63)+HfxZpE*VRR1(18,63)-6.D0*r1x2E*ZxZpE*VRR1(31,41)+WQy*VRR1(31,63)
      VRR0(31,93)=5.D0*r1x2E*VRR0(31,42)+QCx*VRR0(31,64)+HfxZpE*VRR1(19,64)-5.D0*r1x2E*ZxZpE*VRR1(31,42)+WQx*VRR1(31,64)
      VRR0(31,94)=4.D0*r1x2E*VRR0(31,43)+QCx*VRR0(31,65)+HfxZpE*VRR1(19,65)-4.D0*r1x2E*ZxZpE*VRR1(31,43)+WQx*VRR1(31,65)
      VRR0(31,95)=V(359)+V(361)+QCx*VRR0(31,66)+HfxZpE*VRR1(19,66)+WQx*VRR1(31,66)
      VRR0(31,96)=2.D0*V(362)+V(363)-2.D0*V(364)+QCx*VRR0(31,67)+WQx*VRR1(31,67)
      VRR0(31,97)=V(328)+V(359)+V(361)+QCy*VRR0(31,67)+WQy*VRR1(31,67)
      VRR0(31,98)=4.D0*V(362)-4.D0*V(364)+QCy*VRR0(31,68)+HfxZpE*VRR1(18,68)+WQy*VRR1(31,68)
      VRR0(31,99)=5.D0*r1x2E*VRR0(31,46)+QCy*VRR0(31,69)+HfxZpE*VRR1(18,69)-5.D0*r1x2E*ZxZpE*VRR1(31,46)+WQy*VRR1(31,69)
      VRR0(31,100)=4.D0*V(365)-4.D0*V(366)+QCx*VRR0(31,70)+HfxZpE*VRR1(19,70)+WQx*VRR1(31,70)
      VRR0(31,101)=V(368)+V(370)+QCx*VRR0(31,71)+HfxZpE*VRR1(19,71)+WQx*VRR1(31,71)
      VRR0(31,102)=2.D0*V(371)+V(372)-2.D0*V(373)+QCx*VRR0(31,72)+WQx*VRR1(31,72)
      VRR0(31,103)=V(337)+2.D0*V(367)-2.D0*V(369)+QCy*VRR0(31,72)+WQy*VRR1(31,72)
      VRR0(31,104)=V(374)+V(375)+QCy*VRR0(31,73)+HfxZpE*VRR1(18,73)+WQy*VRR1(31,73)
      VRR0(31,105)=4.D0*V(376)-4.D0*V(377)+QCy*VRR0(31,74)+HfxZpE*VRR1(18,74)+WQy*VRR1(31,74)
      VRR0(31,106)=3.D0*V(378)+V(379)-3.D0*V(380)+QCx*VRR0(31,75)+WQx*VRR1(31,75)
      VRR0(31,107)=V(382)+V(383)+V(385)+QCx*VRR0(31,76)+WQx*VRR1(31,76)
      VRR0(31,108)=V(227)+2.D0*V(358)-2.D0*V(360)+QCz*VRR0(31,72)+WQz*VRR1(31,72)
      VRR0(31,109)=V(382)+V(385)+V(386)+QCy*VRR0(31,77)+WQy*VRR1(31,77)
      VRR0(31,110)=3.D0*V(387)+V(388)-3.D0*V(389)+QCy*VRR0(31,78)+WQy*VRR1(31,78)
      VRR0(31,111)=V(235)+3.D0*V(365)-3.D0*V(366)+QCz*VRR0(31,75)+WQz*VRR1(31,75)
      VRR0(31,112)=V(240)+V(368)+V(370)+QCz*VRR0(31,76)+WQz*VRR1(31,76)
      VRR0(31,113)=V(281)+V(374)+V(375)+QCz*VRR0(31,77)+WQz*VRR1(31,77)
      VRR0(31,114)=V(284)+3.D0*V(376)-3.D0*V(377)+QCz*VRR0(31,78)+WQz*VRR1(31,78)
      VRR0(31,115)=4.D0*V(378)-4.D0*V(380)+QCz*VRR0(31,79)+2.D0*HfxZpE*VRR1(16,79)+WQz*VRR1(31,79)
      VRR0(31,116)=4.D0*V(381)-4.D0*V(384)+QCz*VRR0(31,80)+2.D0*HfxZpE*VRR1(16,80)+WQz*VRR1(31,80)
      VRR0(31,117)=4.D0*V(387)-4.D0*V(389)+QCz*VRR0(31,81)+2.D0*HfxZpE*VRR1(16,81)+WQz*VRR1(31,81)
      VRR0(31,118)=5.D0*r1x2E*VRR0(31,54)+QCz*VRR0(31,82)+2.D0*HfxZpE*VRR1(16,82)-5.D0*r1x2E*ZxZpE*VRR1(31,54)+WQz*VRR1(31,82)
      VRR0(31,119)=5.D0*r1x2E*VRR0(31,55)+QCz*VRR0(31,83)+2.D0*HfxZpE*VRR1(16,83)-5.D0*r1x2E*ZxZpE*VRR1(31,55)+WQz*VRR1(31,83)
      VRR0(31,120)=6.D0*r1x2E*VRR0(31,56)+QCz*VRR0(31,84)+2.D0*HfxZpE*VRR1(16,84)-6.D0*r1x2E*ZxZpE*VRR1(31,56)+WQz*VRR1(31,84)
      VRR0(32,85)=6.D0*r1x2E*VRR0(32,36)+QCx*VRR0(32,57)-6.D0*r1x2E*ZxZpE*VRR1(32,36)+WQx*VRR1(32,57)
      VRR0(32,86)=5.D0*r1x2E*VRR0(32,37)+QCx*VRR0(32,58)-5.D0*r1x2E*ZxZpE*VRR1(32,37)+WQx*VRR1(32,58)
      VRR0(32,87)=4.D0*V(390)-4.D0*V(391)+QCx*VRR0(32,59)+WQx*VRR1(32,59)
      VRR0(32,88)=3.D0*V(392)-3.D0*V(393)+QCx*VRR0(32,60)+WQx*VRR1(32,60)
      VRR0(32,89)=2.D0*V(356)+3.D0*V(390)-3.D0*V(391)+QCy*VRR0(32,60)+WQy*VRR1(32,60)
      VRR0(32,90)=4.D0*V(392)-4.D0*V(393)+QCy*VRR0(32,61)+2.D0*HfxZpE*VRR1(19,61)+WQy*VRR1(32,61)
      VRR0(32,91)=5.D0*r1x2E*VRR0(32,40)+QCy*VRR0(32,62)+2.D0*HfxZpE*VRR1(19,62)-5.D0*r1x2E*ZxZpE*VRR1(32,40)+WQy*VRR1(32,62)
      VRR0(32,92)=6.D0*r1x2E*VRR0(32,41)+QCy*VRR0(32,63)+2.D0*HfxZpE*VRR1(19,63)-6.D0*r1x2E*ZxZpE*VRR1(32,41)+WQy*VRR1(32,63)
      VRR0(32,93)=5.D0*r1x2E*VRR0(32,42)+QCx*VRR0(32,64)-5.D0*r1x2E*ZxZpE*VRR1(32,42)+WQx*VRR1(32,64)
      VRR0(32,94)=4.D0*r1x2E*VRR0(32,43)+QCx*VRR0(32,65)-4.D0*r1x2E*ZxZpE*VRR1(32,43)+WQx*VRR1(32,65)
      VRR0(32,95)=V(395)+V(397)+QCx*VRR0(32,66)+WQx*VRR1(32,66)
      VRR0(32,96)=2.D0*V(398)-2.D0*V(399)+QCx*VRR0(32,67)+WQx*VRR1(32,67)
      VRR0(32,97)=2.D0*V(363)+V(395)+V(397)+QCy*VRR0(32,67)+WQy*VRR1(32,67)
      VRR0(32,98)=4.D0*V(398)-4.D0*V(399)+QCy*VRR0(32,68)+2.D0*HfxZpE*VRR1(19,68)+WQy*VRR1(32,68)
      VRR0(32,99)=5.D0*r1x2E*VRR0(32,46)+QCy*VRR0(32,69)+2.D0*HfxZpE*VRR1(19,69)-5.D0*r1x2E*ZxZpE*VRR1(32,46)+WQy*VRR1(32,69)
      VRR0(32,100)=4.D0*V(400)-4.D0*V(401)+QCx*VRR0(32,70)+WQx*VRR1(32,70)
      VRR0(32,101)=V(403)+V(405)+QCx*VRR0(32,71)+WQx*VRR1(32,71)
      VRR0(32,102)=2.D0*V(406)-2.D0*V(407)+QCx*VRR0(32,72)+WQx*VRR1(32,72)
      VRR0(32,103)=2.D0*V(372)+2.D0*V(402)-2.D0*V(404)+QCy*VRR0(32,72)+WQy*VRR1(32,72)
      VRR0(32,104)=V(408)+V(409)+QCy*VRR0(32,73)+2.D0*HfxZpE*VRR1(19,73)+WQy*VRR1(32,73)
      VRR0(32,105)=4.D0*V(410)-4.D0*V(411)+QCy*VRR0(32,74)+2.D0*HfxZpE*VRR1(19,74)+WQy*VRR1(32,74)
      VRR0(32,106)=3.D0*V(412)-3.D0*V(413)+QCx*VRR0(32,75)+WQx*VRR1(32,75)
      VRR0(32,107)=V(415)+V(417)+QCx*VRR0(32,76)+WQx*VRR1(32,76)
      VRR0(32,108)=2.D0*V(266)+2.D0*V(394)-2.D0*V(396)+QCz*VRR0(32,72)+WQz*VRR1(32,72)
      VRR0(32,109)=V(415)+V(417)+2.D0*V(418)+QCy*VRR0(32,77)+WQy*VRR1(32,77)
      VRR0(32,110)=3.D0*V(419)+2.D0*V(420)-3.D0*V(421)+QCy*VRR0(32,78)+WQy*VRR1(32,78)
      VRR0(32,111)=2.D0*V(273)+3.D0*V(400)-3.D0*V(401)+QCz*VRR0(32,75)+WQz*VRR1(32,75)
      VRR0(32,112)=2.D0*V(277)+V(403)+V(405)+QCz*VRR0(32,76)+WQz*VRR1(32,76)
      VRR0(32,113)=2.D0*V(314)+V(408)+V(409)+QCz*VRR0(32,77)+WQz*VRR1(32,77)
      VRR0(32,114)=2.D0*V(316)+3.D0*V(410)-3.D0*V(411)+QCz*VRR0(32,78)+WQz*VRR1(32,78)
      VRR0(32,115)=4.D0*V(412)-4.D0*V(413)+QCz*VRR0(32,79)+2.D0*HfxZpE*VRR1(17,79)+WQz*VRR1(32,79)
      VRR0(32,116)=4.D0*V(414)-4.D0*V(416)+QCz*VRR0(32,80)+2.D0*HfxZpE*VRR1(17,80)+WQz*VRR1(32,80)
      VRR0(32,117)=4.D0*V(419)-4.D0*V(421)+QCz*VRR0(32,81)+2.D0*HfxZpE*VRR1(17,81)+WQz*VRR1(32,81)
      VRR0(32,118)=5.D0*r1x2E*VRR0(32,54)+QCz*VRR0(32,82)+2.D0*HfxZpE*VRR1(17,82)-5.D0*r1x2E*ZxZpE*VRR1(32,54)+WQz*VRR1(32,82)
      VRR0(32,119)=5.D0*r1x2E*VRR0(32,55)+QCz*VRR0(32,83)+2.D0*HfxZpE*VRR1(17,83)-5.D0*r1x2E*ZxZpE*VRR1(32,55)+WQz*VRR1(32,83)
      VRR0(32,120)=6.D0*r1x2E*VRR0(32,56)+QCz*VRR0(32,84)+2.D0*HfxZpE*VRR1(17,84)-6.D0*r1x2E*ZxZpE*VRR1(32,56)+WQz*VRR1(32,84)
      VRR0(33,85)=6.D0*r1x2E*VRR0(33,36)+QCx*VRR0(33,57)+HfxZpE*VRR1(20,57)-6.D0*r1x2E*ZxZpE*VRR1(33,36)+WQx*VRR1(33,57)
      VRR0(33,86)=5.D0*r1x2E*VRR0(33,37)+QCx*VRR0(33,58)+HfxZpE*VRR1(20,58)-5.D0*r1x2E*ZxZpE*VRR1(33,37)+WQx*VRR1(33,58)
      VRR0(33,87)=4.D0*V(422)-4.D0*V(423)+QCx*VRR0(33,59)+HfxZpE*VRR1(20,59)+WQx*VRR1(33,59)
      VRR0(33,88)=3.D0*V(424)+V(425)-3.D0*V(426)+QCx*VRR0(33,60)+WQx*VRR1(33,60)
      VRR0(33,89)=3.D0*V(422)-3.D0*V(423)+QCy*VRR0(33,60)+WQy*VRR1(33,60)
      VRR0(33,90)=4.D0*V(424)-4.D0*V(426)+QCy*VRR0(33,61)+WQy*VRR1(33,61)
      VRR0(33,91)=5.D0*r1x2E*VRR0(33,40)+QCy*VRR0(33,62)-5.D0*r1x2E*ZxZpE*VRR1(33,40)+WQy*VRR1(33,62)
      VRR0(33,92)=6.D0*r1x2E*VRR0(33,41)+QCy*VRR0(33,63)-6.D0*r1x2E*ZxZpE*VRR1(33,41)+WQy*VRR1(33,63)
      VRR0(33,93)=5.D0*r1x2E*VRR0(33,42)+QCx*VRR0(33,64)+HfxZpE*VRR1(20,64)-5.D0*r1x2E*ZxZpE*VRR1(33,42)+WQx*VRR1(33,64)
      VRR0(33,94)=4.D0*r1x2E*VRR0(33,43)+QCx*VRR0(33,65)+HfxZpE*VRR1(20,65)-4.D0*r1x2E*ZxZpE*VRR1(33,43)+WQx*VRR1(33,65)
      VRR0(33,95)=V(428)+V(429)+V(431)+QCx*VRR0(33,66)+WQx*VRR1(33,66)
      VRR0(33,96)=2.D0*V(432)+V(433)-2.D0*V(434)+QCx*VRR0(33,67)+WQx*VRR1(33,67)
      VRR0(33,97)=V(428)+V(431)+QCy*VRR0(33,67)+WQy*VRR1(33,67)
      VRR0(33,98)=4.D0*V(432)-4.D0*V(434)+QCy*VRR0(33,68)+WQy*VRR1(33,68)
      VRR0(33,99)=5.D0*r1x2E*VRR0(33,46)+QCy*VRR0(33,69)-5.D0*r1x2E*ZxZpE*VRR1(33,46)+WQy*VRR1(33,69)
      VRR0(33,100)=4.D0*V(435)-4.D0*V(436)+QCx*VRR0(33,70)+HfxZpE*VRR1(20,70)+WQx*VRR1(33,70)
      VRR0(33,101)=V(438)+V(439)+V(441)+QCx*VRR0(33,71)+WQx*VRR1(33,71)
      VRR0(33,102)=2.D0*V(442)+V(443)-2.D0*V(444)+QCx*VRR0(33,72)+WQx*VRR1(33,72)
      VRR0(33,103)=2.D0*V(437)-2.D0*V(440)+QCy*VRR0(33,72)+WQy*VRR1(33,72)
      VRR0(33,104)=V(445)+V(446)+QCy*VRR0(33,73)+WQy*VRR1(33,73)
      VRR0(33,105)=4.D0*V(447)-4.D0*V(448)+QCy*VRR0(33,74)+WQy*VRR1(33,74)
      VRR0(33,106)=3.D0*V(449)+V(450)-3.D0*V(451)+QCx*VRR0(33,75)+WQx*VRR1(33,75)
      VRR0(33,107)=V(453)+V(454)+V(456)+QCx*VRR0(33,76)+WQx*VRR1(33,76)
      VRR0(33,108)=3.D0*V(337)+2.D0*V(427)-2.D0*V(430)+QCz*VRR0(33,72)+WQz*VRR1(33,72)
      VRR0(33,109)=V(453)+V(456)+QCy*VRR0(33,77)+WQy*VRR1(33,77)
      VRR0(33,110)=3.D0*V(457)-3.D0*V(458)+QCy*VRR0(33,78)+WQy*VRR1(33,78)
      VRR0(33,111)=3.D0*V(344)+3.D0*V(435)-3.D0*V(436)+QCz*VRR0(33,75)+WQz*VRR1(33,75)
      VRR0(33,112)=3.D0*V(348)+V(438)+V(441)+QCz*VRR0(33,76)+WQz*VRR1(33,76)
      VRR0(33,113)=3.D0*V(386)+V(445)+V(446)+QCz*VRR0(33,77)+WQz*VRR1(33,77)
      VRR0(33,114)=3.D0*V(388)+3.D0*V(447)-3.D0*V(448)+QCz*VRR0(33,78)+WQz*VRR1(33,78)
      VRR0(33,115)=4.D0*V(449)-4.D0*V(451)+QCz*VRR0(33,79)+3.D0*HfxZpE*VRR1(18,79)+WQz*VRR1(33,79)
      VRR0(33,116)=4.D0*V(452)-4.D0*V(455)+QCz*VRR0(33,80)+3.D0*HfxZpE*VRR1(18,80)+WQz*VRR1(33,80)
      VRR0(33,117)=4.D0*V(457)-4.D0*V(458)+QCz*VRR0(33,81)+3.D0*HfxZpE*VRR1(18,81)+WQz*VRR1(33,81)
      VRR0(33,118)=5.D0*r1x2E*VRR0(33,54)+QCz*VRR0(33,82)+3.D0*HfxZpE*VRR1(18,82)-5.D0*r1x2E*ZxZpE*VRR1(33,54)+WQz*VRR1(33,82)
      VRR0(33,119)=5.D0*r1x2E*VRR0(33,55)+QCz*VRR0(33,83)+3.D0*HfxZpE*VRR1(18,83)-5.D0*r1x2E*ZxZpE*VRR1(33,55)+WQz*VRR1(33,83)
      VRR0(33,120)=6.D0*r1x2E*VRR0(33,56)+QCz*VRR0(33,84)+3.D0*HfxZpE*VRR1(18,84)-6.D0*r1x2E*ZxZpE*VRR1(33,56)+WQz*VRR1(33,84)
      VRR0(34,85)=6.D0*r1x2E*VRR0(34,36)+QCx*VRR0(34,57)-6.D0*r1x2E*ZxZpE*VRR1(34,36)+WQx*VRR1(34,57)
      VRR0(34,86)=5.D0*r1x2E*VRR0(34,37)+QCx*VRR0(34,58)-5.D0*r1x2E*ZxZpE*VRR1(34,37)+WQx*VRR1(34,58)
      VRR0(34,87)=4.D0*V(459)-4.D0*V(460)+QCx*VRR0(34,59)+WQx*VRR1(34,59)
      VRR0(34,88)=3.D0*V(461)-3.D0*V(462)+QCx*VRR0(34,60)+WQx*VRR1(34,60)
      VRR0(34,89)=V(425)+3.D0*V(459)-3.D0*V(460)+QCy*VRR0(34,60)+WQy*VRR1(34,60)
      VRR0(34,90)=4.D0*V(461)-4.D0*V(462)+QCy*VRR0(34,61)+HfxZpE*VRR1(20,61)+WQy*VRR1(34,61)
      VRR0(34,91)=5.D0*r1x2E*VRR0(34,40)+QCy*VRR0(34,62)+HfxZpE*VRR1(20,62)-5.D0*r1x2E*ZxZpE*VRR1(34,40)+WQy*VRR1(34,62)
      VRR0(34,92)=6.D0*r1x2E*VRR0(34,41)+QCy*VRR0(34,63)+HfxZpE*VRR1(20,63)-6.D0*r1x2E*ZxZpE*VRR1(34,41)+WQy*VRR1(34,63)
      VRR0(34,93)=5.D0*r1x2E*VRR0(34,42)+QCx*VRR0(34,64)-5.D0*r1x2E*ZxZpE*VRR1(34,42)+WQx*VRR1(34,64)
      VRR0(34,94)=4.D0*r1x2E*VRR0(34,43)+QCx*VRR0(34,65)-4.D0*r1x2E*ZxZpE*VRR1(34,43)+WQx*VRR1(34,65)
      VRR0(34,95)=V(464)+V(466)+QCx*VRR0(34,66)+WQx*VRR1(34,66)
      VRR0(34,96)=2.D0*V(467)-2.D0*V(468)+QCx*VRR0(34,67)+WQx*VRR1(34,67)
      VRR0(34,97)=V(433)+V(464)+V(466)+QCy*VRR0(34,67)+WQy*VRR1(34,67)
      VRR0(34,98)=4.D0*V(467)-4.D0*V(468)+QCy*VRR0(34,68)+HfxZpE*VRR1(20,68)+WQy*VRR1(34,68)
      VRR0(34,99)=5.D0*r1x2E*VRR0(34,46)+QCy*VRR0(34,69)+HfxZpE*VRR1(20,69)-5.D0*r1x2E*ZxZpE*VRR1(34,46)+WQy*VRR1(34,69)
      VRR0(34,100)=4.D0*V(469)-4.D0*V(470)+QCx*VRR0(34,70)+WQx*VRR1(34,70)
      VRR0(34,101)=V(472)+V(474)+QCx*VRR0(34,71)+WQx*VRR1(34,71)
      VRR0(34,102)=2.D0*V(475)-2.D0*V(476)+QCx*VRR0(34,72)+WQx*VRR1(34,72)
      VRR0(34,103)=V(443)+2.D0*V(471)-2.D0*V(473)+QCy*VRR0(34,72)+WQy*VRR1(34,72)
      VRR0(34,104)=V(477)+V(478)+V(479)+QCy*VRR0(34,73)+WQy*VRR1(34,73)
      VRR0(34,105)=4.D0*V(480)-4.D0*V(481)+QCy*VRR0(34,74)+HfxZpE*VRR1(20,74)+WQy*VRR1(34,74)
      VRR0(34,106)=3.D0*V(482)-3.D0*V(483)+QCx*VRR0(34,75)+WQx*VRR1(34,75)
      VRR0(34,107)=V(485)+V(487)+QCx*VRR0(34,76)+WQx*VRR1(34,76)
      VRR0(34,108)=3.D0*V(372)+2.D0*V(463)-2.D0*V(465)+QCz*VRR0(34,72)+WQz*VRR1(34,72)
      VRR0(34,109)=V(485)+V(487)+V(488)+QCy*VRR0(34,77)+WQy*VRR1(34,77)
      VRR0(34,110)=3.D0*V(489)+V(490)-3.D0*V(491)+QCy*VRR0(34,78)+WQy*VRR1(34,78)
      VRR0(34,111)=3.D0*V(379)+3.D0*V(469)-3.D0*V(470)+QCz*VRR0(34,75)+WQz*VRR1(34,75)
      VRR0(34,112)=3.D0*V(383)+V(472)+V(474)+QCz*VRR0(34,76)+WQz*VRR1(34,76)
      VRR0(34,113)=3.D0*V(418)+V(477)+V(479)+QCz*VRR0(34,77)+WQz*VRR1(34,77)
      VRR0(34,114)=3.D0*V(420)+3.D0*V(480)-3.D0*V(481)+QCz*VRR0(34,78)+WQz*VRR1(34,78)
      VRR0(34,115)=4.D0*V(482)-4.D0*V(483)+QCz*VRR0(34,79)+3.D0*HfxZpE*VRR1(19,79)+WQz*VRR1(34,79)
      VRR0(34,116)=4.D0*V(484)-4.D0*V(486)+QCz*VRR0(34,80)+3.D0*HfxZpE*VRR1(19,80)+WQz*VRR1(34,80)
      VRR0(34,117)=4.D0*V(489)-4.D0*V(491)+QCz*VRR0(34,81)+3.D0*HfxZpE*VRR1(19,81)+WQz*VRR1(34,81)
      VRR0(34,118)=5.D0*r1x2E*VRR0(34,54)+QCz*VRR0(34,82)+3.D0*HfxZpE*VRR1(19,82)-5.D0*r1x2E*ZxZpE*VRR1(34,54)+WQz*VRR1(34,82)
      VRR0(34,119)=5.D0*r1x2E*VRR0(34,55)+QCz*VRR0(34,83)+3.D0*HfxZpE*VRR1(19,83)-5.D0*r1x2E*ZxZpE*VRR1(34,55)+WQz*VRR1(34,83)
      VRR0(34,120)=6.D0*r1x2E*VRR0(34,56)+QCz*VRR0(34,84)+3.D0*HfxZpE*VRR1(19,84)-6.D0*r1x2E*ZxZpE*VRR1(34,56)+WQz*VRR1(34,84)
      VRR0(35,85)=6.D0*r1x2E*VRR0(35,36)+QCx*VRR0(35,57)-6.D0*r1x2E*ZxZpE*VRR1(35,36)+WQx*VRR1(35,57)
      VRR0(35,86)=5.D0*r1x2E*VRR0(35,37)+QCx*VRR0(35,58)-5.D0*r1x2E*ZxZpE*VRR1(35,37)+WQx*VRR1(35,58)
      VRR0(35,87)=4.D0*V(492)-4.D0*V(493)+QCx*VRR0(35,59)+WQx*VRR1(35,59)
      VRR0(35,88)=3.D0*V(494)-3.D0*V(495)+QCx*VRR0(35,60)+WQx*VRR1(35,60)
      VRR0(35,89)=3.D0*V(492)-3.D0*V(493)+QCy*VRR0(35,60)+WQy*VRR1(35,60)
      VRR0(35,90)=4.D0*V(494)-4.D0*V(495)+QCy*VRR0(35,61)+WQy*VRR1(35,61)
      VRR0(35,91)=5.D0*r1x2E*VRR0(35,40)+QCy*VRR0(35,62)-5.D0*r1x2E*ZxZpE*VRR1(35,40)+WQy*VRR1(35,62)
      VRR0(35,92)=6.D0*r1x2E*VRR0(35,41)+QCy*VRR0(35,63)-6.D0*r1x2E*ZxZpE*VRR1(35,41)+WQy*VRR1(35,63)
      VRR0(35,93)=5.D0*r1x2E*VRR0(35,42)+QCx*VRR0(35,64)-5.D0*r1x2E*ZxZpE*VRR1(35,42)+WQx*VRR1(35,64)
      VRR0(35,94)=4.D0*r1x2E*VRR0(35,43)+QCx*VRR0(35,65)-4.D0*r1x2E*ZxZpE*VRR1(35,43)+WQx*VRR1(35,65)
      VRR0(35,95)=V(497)+V(499)+QCx*VRR0(35,66)+WQx*VRR1(35,66)
      VRR0(35,96)=V(425)+3.D0*r1x2Z*VRR0(10,96)+PAz*VRR0(20,96)-3.D0*ExZpE*r1x2Z*VRR1(10,96)+WPz*VRR1(20,96)
      VRR0(35,97)=V(497)+V(499)+QCy*VRR0(35,67)+WQy*VRR1(35,67)
      VRR0(35,98)=4.D0*r1x2E*VRR0(35,45)+QCy*VRR0(35,68)-4.D0*r1x2E*ZxZpE*VRR1(35,45)+WQy*VRR1(35,68)
      VRR0(35,99)=5.D0*r1x2E*VRR0(35,46)+QCy*VRR0(35,69)-5.D0*r1x2E*ZxZpE*VRR1(35,46)+WQy*VRR1(35,69)
      VRR0(35,100)=4.D0*V(500)-4.D0*V(501)+QCx*VRR0(35,70)+WQx*VRR1(35,70)
      VRR0(35,101)=V(503)+V(505)+QCx*VRR0(35,71)+WQx*VRR1(35,71)
      VRR0(35,102)=2.D0*V(429)+3.D0*r1x2Z*VRR0(10,102)+PAz*VRR0(20,102)-3.D0*ExZpE*r1x2Z*VRR1(10,102)+WPz*VRR1(20,102)
      VRR0(35,103)=2.D0*V(433)+3.D0*r1x2Z*VRR0(10,103)+PAz*VRR0(20,103)-3.D0*ExZpE*r1x2Z*VRR1(10,103)+WPz*VRR1(20,103)
      VRR0(35,104)=V(507)+V(509)+QCy*VRR0(35,73)+WQy*VRR1(35,73)
      VRR0(35,105)=4.D0*V(510)-4.D0*V(511)+QCy*VRR0(35,74)+WQy*VRR1(35,74)
      VRR0(35,106)=3.D0*V(512)-3.D0*V(513)+QCx*VRR0(35,75)+WQx*VRR1(35,75)
      VRR0(35,107)=3.D0*V(439)+3.D0*r1x2Z*VRR0(10,107)+PAz*VRR0(20,107)-3.D0*ExZpE*r1x2Z*VRR1(10,107)+WPz*VRR1(20,107)
      VRR0(35,108)=3.D0*V(443)+3.D0*r1x2Z*VRR0(10,108)+PAz*VRR0(20,108)-3.D0*ExZpE*r1x2Z*VRR1(10,108)+WPz*VRR1(20,108)
      VRR0(35,109)=3.D0*V(478)+3.D0*r1x2Z*VRR0(10,109)+PAz*VRR0(20,109)-3.D0*ExZpE*r1x2Z*VRR1(10,109)+WPz*VRR1(20,109)
      VRR0(35,110)=3.D0*V(514)-3.D0*V(515)+QCy*VRR0(35,78)+WQy*VRR1(35,78)
      VRR0(35,111)=4.D0*V(450)+3.D0*V(500)-3.D0*V(501)+QCz*VRR0(35,75)+WQz*VRR1(35,75)
      VRR0(35,112)=4.D0*V(454)+V(503)+V(505)+QCz*VRR0(35,76)+WQz*VRR1(35,76)
      VRR0(35,113)=4.D0*V(488)+V(507)+V(509)+QCz*VRR0(35,77)+WQz*VRR1(35,77)
      VRR0(35,114)=4.D0*V(490)+3.D0*V(510)-3.D0*V(511)+QCz*VRR0(35,78)+WQz*VRR1(35,78)
      VRR0(35,115)=4.D0*V(512)-4.D0*V(513)+QCz*VRR0(35,79)+4.D0*HfxZpE*VRR1(20,79)+WQz*VRR1(35,79)
      VRR0(35,116)=4.D0*r1x2E*VRR0(35,52)+QCz*VRR0(35,80)+4.D0*HfxZpE*VRR1(20,80)-4.D0*r1x2E*ZxZpE*VRR1(35,52)+WQz*VRR1(35,80)
      VRR0(35,117)=4.D0*V(514)-4.D0*V(515)+QCz*VRR0(35,81)+4.D0*HfxZpE*VRR1(20,81)+WQz*VRR1(35,81)
      VRR0(35,118)=5.D0*r1x2E*VRR0(35,54)+QCz*VRR0(35,82)+4.D0*HfxZpE*VRR1(20,82)-5.D0*r1x2E*ZxZpE*VRR1(35,54)+WQz*VRR1(35,82)
      VRR0(35,119)=5.D0*r1x2E*VRR0(35,55)+QCz*VRR0(35,83)+4.D0*HfxZpE*VRR1(20,83)-5.D0*r1x2E*ZxZpE*VRR1(35,55)+WQz*VRR1(35,83)
      VRR0(35,120)=6.D0*r1x2E*VRR0(35,56)+QCz*VRR0(35,84)+4.D0*HfxZpE*VRR1(20,84)-6.D0*r1x2E*ZxZpE*VRR1(35,56)+WQz*VRR1(35,84)
END SUBROUTINE VRRg0j0
