!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
   SUBROUTINE VRRg0d0(LB,LK,VRR0,VRR1)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER :: LB,LK
      REAL(DOUBLE), DIMENSION(1:LB,1:LK) :: VRR0,VRR1
      V(1)=r1x2Z*VRR0(6,5)
      V(2)=2.D0*V(1)
      V(3)=ExZpE*r1x2Z*VRR1(6,5)
      V(4)=-2.D0*V(3)
      V(5)=r1x2Z*VRR0(6,6)
      V(6)=2.D0*V(5)
      V(7)=ExZpE*r1x2Z*VRR1(6,6)
      V(8)=-2.D0*V(7)
      V(9)=HfxZpE*VRR1(12,3)
      V(10)=r1x2Z*VRR0(6,7)
      V(11)=2.D0*V(10)
      V(12)=ExZpE*r1x2Z*VRR1(6,7)
      V(13)=-2.D0*V(12)
      V(14)=r1x2Z*VRR0(6,8)
      V(15)=2.D0*V(14)
      V(16)=ExZpE*r1x2Z*VRR1(6,8)
      V(17)=-2.D0*V(16)
      V(18)=HfxZpE*VRR1(12,4)
      V(19)=r1x2Z*VRR0(6,9)
      V(20)=2.D0*V(19)
      V(21)=ExZpE*r1x2Z*VRR1(6,9)
      V(22)=-2.D0*V(21)
      V(23)=r1x2Z*VRR0(6,10)
      V(24)=2.D0*V(23)
      V(25)=ExZpE*r1x2Z*VRR1(6,10)
      V(26)=-2.D0*V(25)
      V(27)=r1x2E*VRR0(23,1)
      V(28)=HfxZpE*VRR1(13,2)
      V(29)=r1x2E*ZxZpE*VRR1(23,1)
      V(30)=-V(29)
      V(31)=r1x2Z*VRR0(7,6)
      V(32)=ExZpE*r1x2Z*VRR1(7,6)
      V(33)=HfxZpE*VRR1(13,3)
      V(34)=r1x2Z*VRR0(7,8)
      V(35)=ExZpE*r1x2Z*VRR1(7,8)
      V(36)=HfxZpE*VRR1(13,4)
      V(37)=r1x2Z*VRR0(7,9)
      V(38)=ExZpE*r1x2Z*VRR1(7,9)
      V(39)=r1x2Z*VRR0(8,5)
      V(40)=2.D0*V(39)
      V(41)=ExZpE*r1x2Z*VRR1(8,5)
      V(42)=-2.D0*V(41)
      V(43)=r1x2Z*VRR0(8,6)
      V(44)=2.D0*V(43)
      V(45)=ExZpE*r1x2Z*VRR1(8,6)
      V(46)=-2.D0*V(45)
      V(47)=HfxZpE*VRR1(15,3)
      V(48)=r1x2Z*VRR0(8,7)
      V(49)=2.D0*V(48)
      V(50)=ExZpE*r1x2Z*VRR1(8,7)
      V(51)=-2.D0*V(50)
      V(52)=r1x2Z*VRR0(8,8)
      V(53)=2.D0*V(52)
      V(54)=ExZpE*r1x2Z*VRR1(8,8)
      V(55)=-2.D0*V(54)
      V(56)=HfxZpE*VRR1(15,4)
      V(57)=r1x2Z*VRR0(8,9)
      V(58)=2.D0*V(57)
      V(59)=ExZpE*r1x2Z*VRR1(8,9)
      V(60)=-2.D0*V(59)
      V(61)=r1x2Z*VRR0(8,10)
      V(62)=2.D0*V(61)
      V(63)=ExZpE*r1x2Z*VRR1(8,10)
      V(64)=-2.D0*V(63)
      V(65)=r1x2E*VRR0(27,1)
      V(66)=HfxZpE*VRR1(16,2)
      V(67)=r1x2E*ZxZpE*VRR1(27,1)
      V(68)=-V(67)
      V(69)=r1x2Z*VRR0(9,6)
      V(70)=ExZpE*r1x2Z*VRR1(9,6)
      V(71)=HfxZpE*VRR1(16,3)
      V(72)=r1x2Z*VRR0(9,8)
      V(73)=ExZpE*r1x2Z*VRR1(9,8)
      V(74)=HfxZpE*VRR1(16,4)
      V(75)=r1x2Z*VRR0(9,9)
      V(76)=ExZpE*r1x2Z*VRR1(9,9)
      V(77)=r1x2E*VRR0(28,1)
      V(78)=HfxZpE*VRR1(17,2)
      V(79)=r1x2E*ZxZpE*VRR1(28,1)
      V(80)=-V(79)
      V(81)=r1x2Z*VRR0(9,5)
      V(82)=2.D0*V(81)
      V(83)=ExZpE*r1x2Z*VRR1(9,5)
      V(84)=-2.D0*V(83)
      V(85)=2.D0*V(69)
      V(86)=-2.D0*V(70)
      V(87)=r1x2Z*VRR0(9,7)
      V(88)=2.D0*V(87)
      V(89)=ExZpE*r1x2Z*VRR1(9,7)
      V(90)=-2.D0*V(89)
      V(91)=2.D0*V(72)
      V(92)=-2.D0*V(73)
      V(93)=2.D0*V(75)
      V(94)=-2.D0*V(76)
      V(95)=HfxZpE*VRR1(17,4)
      V(96)=r1x2Z*VRR0(9,10)
      V(97)=2.D0*V(96)
      V(98)=ExZpE*r1x2Z*VRR1(9,10)
      V(99)=-2.D0*V(98)
      V(100)=r1x2E*VRR0(30,1)
      V(101)=HfxZpE*VRR1(18,2)
      V(102)=r1x2E*ZxZpE*VRR1(30,1)
      V(103)=-V(102)
      V(104)=r1x2Z*VRR0(10,6)
      V(105)=ExZpE*r1x2Z*VRR1(10,6)
      V(106)=-V(105)
      V(107)=HfxZpE*VRR1(18,3)
      V(108)=r1x2Z*VRR0(10,8)
      V(109)=ExZpE*r1x2Z*VRR1(10,8)
      V(110)=-V(109)
      V(111)=HfxZpE*VRR1(18,4)
      V(112)=r1x2Z*VRR0(10,9)
      V(113)=ExZpE*r1x2Z*VRR1(10,9)
      V(114)=-V(113)
      V(115)=r1x2E*VRR0(31,1)
      V(116)=HfxZpE*VRR1(19,2)
      V(117)=r1x2E*ZxZpE*VRR1(31,1)
      V(118)=-V(117)
      V(119)=r1x2E*VRR0(32,1)
      V(120)=r1x2E*ZxZpE*VRR1(32,1)
      V(121)=-V(120)
      V(122)=HfxZpE*VRR1(19,3)
      V(123)=HfxZpE*VRR1(19,4)
      VRR0(21,5)=3.D0*r1x2Z*VRR0(5,5)+PAx*VRR0(11,5)-3.D0*ExZpE*r1x2Z*VRR1(5,5)+2.D0*HfxZpE*VRR1(11,2)+WPx*VRR1(11,5)
      VRR0(21,6)=3.D0*r1x2Z*VRR0(5,6)+PAx*VRR0(11,6)-3.D0*ExZpE*r1x2Z*VRR1(5,6)+HfxZpE*VRR1(11,3)+WPx*VRR1(11,6)
      VRR0(21,7)=3.D0*r1x2Z*VRR0(5,7)+PAx*VRR0(11,7)-3.D0*ExZpE*r1x2Z*VRR1(5,7)+WPx*VRR1(11,7)
      VRR0(21,8)=3.D0*r1x2Z*VRR0(5,8)+PAx*VRR0(11,8)-3.D0*ExZpE*r1x2Z*VRR1(5,8)+HfxZpE*VRR1(11,4)+WPx*VRR1(11,8)
      VRR0(21,9)=3.D0*r1x2Z*VRR0(5,9)+PAx*VRR0(11,9)-3.D0*ExZpE*r1x2Z*VRR1(5,9)+WPx*VRR1(11,9)
      VRR0(21,10)=3.D0*r1x2Z*VRR0(5,10)+PAx*VRR0(11,10)-3.D0*ExZpE*r1x2Z*VRR1(5,10)+WPx*VRR1(11,10)
      VRR0(22,5)=V(2)+V(4)+PAx*VRR0(12,5)+2.D0*HfxZpE*VRR1(12,2)+WPx*VRR1(12,5)
      VRR0(22,6)=V(6)+V(8)+V(9)+PAx*VRR0(12,6)+WPx*VRR1(12,6)
      VRR0(22,7)=V(11)+V(13)+PAx*VRR0(12,7)+WPx*VRR1(12,7)
      VRR0(22,8)=V(15)+V(17)+V(18)+PAx*VRR0(12,8)+WPx*VRR1(12,8)
      VRR0(22,9)=V(20)+V(22)+PAx*VRR0(12,9)+WPx*VRR1(12,9)
      VRR0(22,10)=V(24)+V(26)+PAx*VRR0(12,10)+WPx*VRR1(12,10)
      VRR0(23,5)=V(27)+2.D0*V(28)+V(30)+QCx*VRR0(23,2)+WQx*VRR1(23,2)
      VRR0(23,6)=V(31)-V(32)+V(33)+PAx*VRR0(13,6)+WPx*VRR1(13,6)
      VRR0(23,7)=2.D0*V(9)+V(27)+V(30)+QCy*VRR0(23,3)+WQy*VRR1(23,3)
      VRR0(23,8)=V(34)-V(35)+V(36)+PAx*VRR0(13,8)+WPx*VRR1(13,8)
      VRR0(23,9)=V(37)-V(38)+PAx*VRR0(13,9)+WPx*VRR1(13,9)
      VRR0(23,10)=V(27)+V(30)+QCz*VRR0(23,4)+WQz*VRR1(23,4)
      VRR0(24,5)=V(2)+V(4)+PAy*VRR0(13,5)+WPy*VRR1(13,5)
      VRR0(24,6)=V(6)+V(8)+V(28)+PAy*VRR0(13,6)+WPy*VRR1(13,6)
      VRR0(24,7)=V(11)+V(13)+2.D0*V(33)+PAy*VRR0(13,7)+WPy*VRR1(13,7)
      VRR0(24,8)=V(15)+V(17)+PAy*VRR0(13,8)+WPy*VRR1(13,8)
      VRR0(24,9)=V(20)+V(22)+V(36)+PAy*VRR0(13,9)+WPy*VRR1(13,9)
      VRR0(24,10)=V(24)+V(26)+PAy*VRR0(13,10)+WPy*VRR1(13,10)
      VRR0(25,5)=3.D0*r1x2Z*VRR0(7,5)+PAy*VRR0(14,5)-3.D0*ExZpE*r1x2Z*VRR1(7,5)+WPy*VRR1(14,5)
      VRR0(25,6)=3.D0*V(31)-3.D0*V(32)+PAy*VRR0(14,6)+HfxZpE*VRR1(14,2)+WPy*VRR1(14,6)
      VRR0(25,7)=3.D0*r1x2Z*VRR0(7,7)+PAy*VRR0(14,7)-3.D0*ExZpE*r1x2Z*VRR1(7,7)+2.D0*HfxZpE*VRR1(14,3)+WPy*VRR1(14,7)
      VRR0(25,8)=3.D0*V(34)-3.D0*V(35)+PAy*VRR0(14,8)+WPy*VRR1(14,8)
      VRR0(25,9)=3.D0*V(37)-3.D0*V(38)+PAy*VRR0(14,9)+HfxZpE*VRR1(14,4)+WPy*VRR1(14,9)
      VRR0(25,10)=3.D0*r1x2Z*VRR0(7,10)+PAy*VRR0(14,10)-3.D0*ExZpE*r1x2Z*VRR1(7,10)+WPy*VRR1(14,10)
      VRR0(26,5)=V(40)+V(42)+PAx*VRR0(15,5)+2.D0*HfxZpE*VRR1(15,2)+WPx*VRR1(15,5)
      VRR0(26,6)=V(44)+V(46)+V(47)+PAx*VRR0(15,6)+WPx*VRR1(15,6)
      VRR0(26,7)=V(49)+V(51)+PAx*VRR0(15,7)+WPx*VRR1(15,7)
      VRR0(26,8)=V(53)+V(55)+V(56)+PAx*VRR0(15,8)+WPx*VRR1(15,8)
      VRR0(26,9)=V(58)+V(60)+PAx*VRR0(15,9)+WPx*VRR1(15,9)
      VRR0(26,10)=V(62)+V(64)+PAx*VRR0(15,10)+WPx*VRR1(15,10)
      VRR0(27,5)=V(65)+2.D0*V(66)+V(68)+QCx*VRR0(27,2)+WQx*VRR1(27,2)
      VRR0(27,6)=V(69)-V(70)+V(71)+PAx*VRR0(16,6)+WPx*VRR1(16,6)
      VRR0(27,7)=V(47)+V(65)+V(68)+QCy*VRR0(27,3)+WQy*VRR1(27,3)
      VRR0(27,8)=V(72)-V(73)+V(74)+PAx*VRR0(16,8)+WPx*VRR1(16,8)
      VRR0(27,9)=V(75)-V(76)+PAx*VRR0(16,9)+WPx*VRR1(16,9)
      VRR0(27,10)=V(18)+V(65)+V(68)+QCz*VRR0(27,4)+WQz*VRR1(27,4)
      VRR0(28,5)=V(77)+V(78)+V(80)+QCx*VRR0(28,2)+WQx*VRR1(28,2)
      VRR0(28,6)=V(43)-V(45)+V(66)+PAy*VRR0(16,6)+WPy*VRR1(16,6)
      VRR0(28,7)=2.D0*V(71)+V(77)+V(80)+QCy*VRR0(28,3)+WQy*VRR1(28,3)
      VRR0(28,8)=V(52)-V(54)+PAy*VRR0(16,8)+WPy*VRR1(16,8)
      VRR0(28,9)=V(57)-V(59)+V(74)+PAy*VRR0(16,9)+WPy*VRR1(16,9)
      VRR0(28,10)=V(36)+V(77)+V(80)+QCz*VRR0(28,4)+WQz*VRR1(28,4)
      VRR0(29,5)=V(82)+V(84)+PAy*VRR0(17,5)+WPy*VRR1(17,5)
      VRR0(29,6)=V(78)+V(85)+V(86)+PAy*VRR0(17,6)+WPy*VRR1(17,6)
      VRR0(29,7)=V(88)+V(90)+PAy*VRR0(17,7)+2.D0*HfxZpE*VRR1(17,3)+WPy*VRR1(17,7)
      VRR0(29,8)=V(91)+V(92)+PAy*VRR0(17,8)+WPy*VRR1(17,8)
      VRR0(29,9)=V(93)+V(94)+V(95)+PAy*VRR0(17,9)+WPy*VRR1(17,9)
      VRR0(29,10)=V(97)+V(99)+PAy*VRR0(17,10)+WPy*VRR1(17,10)
      VRR0(30,5)=V(100)+2.D0*V(101)+V(103)+QCx*VRR0(30,2)+WQx*VRR1(30,2)
      VRR0(30,6)=V(104)+V(106)+V(107)+PAx*VRR0(18,6)+WPx*VRR1(18,6)
      VRR0(30,7)=V(100)+V(103)+QCy*VRR0(30,3)+WQy*VRR1(30,3)
      VRR0(30,8)=V(108)+V(110)+V(111)+PAx*VRR0(18,8)+WPx*VRR1(18,8)
      VRR0(30,9)=V(112)+V(114)+PAx*VRR0(18,9)+WPx*VRR1(18,9)
      VRR0(30,10)=2.D0*V(56)+V(100)+V(103)+QCz*VRR0(30,4)+WQz*VRR1(30,4)
      VRR0(31,5)=V(115)+V(116)+V(118)+QCx*VRR0(31,2)+WQx*VRR1(31,2)
      VRR0(31,6)=V(5)-V(7)+PAz*VRR0(16,6)+WPz*VRR1(16,6)
      VRR0(31,7)=V(107)+V(115)+V(118)+QCy*VRR0(31,3)+WQy*VRR1(31,3)
      VRR0(31,8)=V(14)-V(16)+V(66)+PAz*VRR0(16,8)+WPz*VRR1(16,8)
      VRR0(31,9)=V(19)-V(21)+V(71)+PAz*VRR0(16,9)+WPz*VRR1(16,9)
      VRR0(31,10)=2.D0*V(74)+V(115)+V(118)+QCz*VRR0(31,4)+WQz*VRR1(31,4)
      VRR0(32,5)=V(119)+V(121)+QCx*VRR0(32,2)+WQx*VRR1(32,2)
      VRR0(32,6)=V(104)+V(106)+V(116)+PAy*VRR0(19,6)+WPy*VRR1(19,6)
      VRR0(32,7)=V(119)+V(121)+2.D0*V(122)+QCy*VRR0(32,3)+WQy*VRR1(32,3)
      VRR0(32,8)=V(108)+V(110)+PAy*VRR0(19,8)+WPy*VRR1(19,8)
      VRR0(32,9)=V(112)+V(114)+V(123)+PAy*VRR0(19,9)+WPy*VRR1(19,9)
      VRR0(32,10)=2.D0*V(95)+V(119)+V(121)+QCz*VRR0(32,4)+WQz*VRR1(32,4)
      VRR0(33,5)=V(40)+V(42)+PAz*VRR0(18,5)+WPz*VRR1(18,5)
      VRR0(33,6)=V(44)+V(46)+PAz*VRR0(18,6)+WPz*VRR1(18,6)
      VRR0(33,7)=V(49)+V(51)+PAz*VRR0(18,7)+WPz*VRR1(18,7)
      VRR0(33,8)=V(53)+V(55)+V(101)+PAz*VRR0(18,8)+WPz*VRR1(18,8)
      VRR0(33,9)=V(58)+V(60)+V(107)+PAz*VRR0(18,9)+WPz*VRR1(18,9)
      VRR0(33,10)=V(62)+V(64)+2.D0*V(111)+PAz*VRR0(18,10)+WPz*VRR1(18,10)
      VRR0(34,5)=V(82)+V(84)+PAz*VRR0(19,5)+WPz*VRR1(19,5)
      VRR0(34,6)=V(85)+V(86)+PAz*VRR0(19,6)+WPz*VRR1(19,6)
      VRR0(34,7)=V(88)+V(90)+PAz*VRR0(19,7)+WPz*VRR1(19,7)
      VRR0(34,8)=V(91)+V(92)+V(116)+PAz*VRR0(19,8)+WPz*VRR1(19,8)
      VRR0(34,9)=V(93)+V(94)+V(122)+PAz*VRR0(19,9)+WPz*VRR1(19,9)
      VRR0(34,10)=V(97)+V(99)+2.D0*V(123)+PAz*VRR0(19,10)+WPz*VRR1(19,10)
      VRR0(35,5)=3.D0*r1x2Z*VRR0(10,5)+PAz*VRR0(20,5)-3.D0*ExZpE*r1x2Z*VRR1(10,5)+WPz*VRR1(20,5)
      VRR0(35,6)=3.D0*V(104)-3.D0*V(105)+PAz*VRR0(20,6)+WPz*VRR1(20,6)
      VRR0(35,7)=3.D0*r1x2Z*VRR0(10,7)+PAz*VRR0(20,7)-3.D0*ExZpE*r1x2Z*VRR1(10,7)+WPz*VRR1(20,7)
      VRR0(35,8)=3.D0*V(108)-3.D0*V(109)+PAz*VRR0(20,8)+HfxZpE*VRR1(20,2)+WPz*VRR1(20,8)
      VRR0(35,9)=3.D0*V(112)-3.D0*V(113)+PAz*VRR0(20,9)+HfxZpE*VRR1(20,3)+WPz*VRR1(20,9)
      VRR0(35,10)=3.D0*r1x2Z*VRR0(10,10)+PAz*VRR0(20,10)-3.D0*ExZpE*r1x2Z*VRR1(10,10)+2.D0*HfxZpE*VRR1(20,4)+WPz*VRR1(20,10)
END SUBROUTINE VRRg0d0
SUBROUTINE MVRRg0d0(IXYZ,LBS,LKS,VS0,VS1,LBR,LKR,VR1)
USE DerivedTypes
USE VScratchB
USE GlobalScalars
IMPLICIT NONE
INTEGER IXYZ,LBS,LKS,LBR,LKR
REAL(DOUBLE) VS0(LBS,LKS),VS1(LBS,LKS),VR1(LBR,LKR)
SELECT CASE(IXYZ)
CASE(1)
VS0(21,5)=PAx*VS0(11,5)+WPx*VS1(11,5)+r1x2Z*VR1(11,5)&
   +3D0*r1x2Z*(VS0(5,5)-ExZpE*VS1(5,5))&
   +2D0*HfxZpE*VS1(11,2)
VS0(21,6)=PAx*VS0(11,6)+WPx*VS1(11,6)+r1x2Z*VR1(11,6)&
   +3D0*r1x2Z*(VS0(5,6)-ExZpE*VS1(5,6))&
   +HfxZpE*VS1(11,3)
VS0(21,7)=PAx*VS0(11,7)+WPx*VS1(11,7)+r1x2Z*VR1(11,7)&
   +3D0*r1x2Z*(VS0(5,7)-ExZpE*VS1(5,7))
VS0(21,8)=PAx*VS0(11,8)+WPx*VS1(11,8)+r1x2Z*VR1(11,8)&
   +3D0*r1x2Z*(VS0(5,8)-ExZpE*VS1(5,8))&
   +HfxZpE*VS1(11,4)
VS0(21,9)=PAx*VS0(11,9)+WPx*VS1(11,9)+r1x2Z*VR1(11,9)&
   +3D0*r1x2Z*(VS0(5,9)-ExZpE*VS1(5,9))
VS0(21,10)=PAx*VS0(11,10)+WPx*VS1(11,10)+r1x2Z*VR1(11,10)&
   +3D0*r1x2Z*(VS0(5,10)-ExZpE*VS1(5,10))
VS0(22,5)=PAx*VS0(12,5)+WPx*VS1(12,5)+r1x2Z*VR1(12,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))&
   +2D0*HfxZpE*VS1(12,2)
VS0(22,6)=PAx*VS0(12,6)+WPx*VS1(12,6)+r1x2Z*VR1(12,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(12,3)
VS0(22,7)=PAx*VS0(12,7)+WPx*VS1(12,7)+r1x2Z*VR1(12,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(22,8)=PAx*VS0(12,8)+WPx*VS1(12,8)+r1x2Z*VR1(12,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(12,4)
VS0(22,9)=PAx*VS0(12,9)+WPx*VS1(12,9)+r1x2Z*VR1(12,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))
VS0(22,10)=PAx*VS0(12,10)+WPx*VS1(12,10)+r1x2Z*VR1(12,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(23,5)=PAx*VS0(13,5)+WPx*VS1(13,5)+r1x2Z*VR1(13,5)&
   +r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))&
   +2D0*HfxZpE*VS1(13,2)
VS0(23,6)=PAx*VS0(13,6)+WPx*VS1(13,6)+r1x2Z*VR1(13,6)&
   +r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(13,3)
VS0(23,7)=PAx*VS0(13,7)+WPx*VS1(13,7)+r1x2Z*VR1(13,7)&
   +r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))
VS0(23,8)=PAx*VS0(13,8)+WPx*VS1(13,8)+r1x2Z*VR1(13,8)&
   +r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))&
   +HfxZpE*VS1(13,4)
VS0(23,9)=PAx*VS0(13,9)+WPx*VS1(13,9)+r1x2Z*VR1(13,9)&
   +r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))
VS0(23,10)=PAx*VS0(13,10)+WPx*VS1(13,10)+r1x2Z*VR1(13,10)&
   +r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(24,5)=PAy*VS0(13,5)+WPy*VS1(13,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(24,6)=PAy*VS0(13,6)+WPy*VS1(13,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(13,2)
VS0(24,7)=PAy*VS0(13,7)+WPy*VS1(13,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))&
   +2D0*HfxZpE*VS1(13,3)
VS0(24,8)=PAy*VS0(13,8)+WPy*VS1(13,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))
VS0(24,9)=PAy*VS0(13,9)+WPy*VS1(13,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(13,4)
VS0(24,10)=PAy*VS0(13,10)+WPy*VS1(13,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(25,5)=PAy*VS0(14,5)+WPy*VS1(14,5)&
   +3D0*r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))
VS0(25,6)=PAy*VS0(14,6)+WPy*VS1(14,6)&
   +3D0*r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(14,2)
VS0(25,7)=PAy*VS0(14,7)+WPy*VS1(14,7)&
   +3D0*r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))&
   +2D0*HfxZpE*VS1(14,3)
VS0(25,8)=PAy*VS0(14,8)+WPy*VS1(14,8)&
   +3D0*r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))
VS0(25,9)=PAy*VS0(14,9)+WPy*VS1(14,9)&
   +3D0*r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))&
   +HfxZpE*VS1(14,4)
VS0(25,10)=PAy*VS0(14,10)+WPy*VS1(14,10)&
   +3D0*r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(26,5)=PAx*VS0(15,5)+WPx*VS1(15,5)+r1x2Z*VR1(15,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))&
   +2D0*HfxZpE*VS1(15,2)
VS0(26,6)=PAx*VS0(15,6)+WPx*VS1(15,6)+r1x2Z*VR1(15,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(15,3)
VS0(26,7)=PAx*VS0(15,7)+WPx*VS1(15,7)+r1x2Z*VR1(15,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(26,8)=PAx*VS0(15,8)+WPx*VS1(15,8)+r1x2Z*VR1(15,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(15,4)
VS0(26,9)=PAx*VS0(15,9)+WPx*VS1(15,9)+r1x2Z*VR1(15,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))
VS0(26,10)=PAx*VS0(15,10)+WPx*VS1(15,10)+r1x2Z*VR1(15,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(27,5)=PAx*VS0(16,5)+WPx*VS1(16,5)+r1x2Z*VR1(16,5)&
   +r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))&
   +2D0*HfxZpE*VS1(16,2)
VS0(27,6)=PAx*VS0(16,6)+WPx*VS1(16,6)+r1x2Z*VR1(16,6)&
   +r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(16,3)
VS0(27,7)=PAx*VS0(16,7)+WPx*VS1(16,7)+r1x2Z*VR1(16,7)&
   +r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(27,8)=PAx*VS0(16,8)+WPx*VS1(16,8)+r1x2Z*VR1(16,8)&
   +r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(16,4)
VS0(27,9)=PAx*VS0(16,9)+WPx*VS1(16,9)+r1x2Z*VR1(16,9)&
   +r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))
VS0(27,10)=PAx*VS0(16,10)+WPx*VS1(16,10)+r1x2Z*VR1(16,10)&
   +r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(28,5)=PAy*VS0(16,5)+WPy*VS1(16,5)&
   +r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(28,6)=PAy*VS0(16,6)+WPy*VS1(16,6)&
   +r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(16,2)
VS0(28,7)=PAy*VS0(16,7)+WPy*VS1(16,7)&
   +r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))&
   +2D0*HfxZpE*VS1(16,3)
VS0(28,8)=PAy*VS0(16,8)+WPy*VS1(16,8)&
   +r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))
VS0(28,9)=PAy*VS0(16,9)+WPy*VS1(16,9)&
   +r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(16,4)
VS0(28,10)=PAy*VS0(16,10)+WPy*VS1(16,10)&
   +r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(29,5)=PAy*VS0(17,5)+WPy*VS1(17,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(29,6)=PAy*VS0(17,6)+WPy*VS1(17,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(17,2)
VS0(29,7)=PAy*VS0(17,7)+WPy*VS1(17,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))&
   +2D0*HfxZpE*VS1(17,3)
VS0(29,8)=PAy*VS0(17,8)+WPy*VS1(17,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))
VS0(29,9)=PAy*VS0(17,9)+WPy*VS1(17,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(17,4)
VS0(29,10)=PAy*VS0(17,10)+WPy*VS1(17,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(30,5)=PAx*VS0(18,5)+WPx*VS1(18,5)+r1x2Z*VR1(18,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))&
   +2D0*HfxZpE*VS1(18,2)
VS0(30,6)=PAx*VS0(18,6)+WPx*VS1(18,6)+r1x2Z*VR1(18,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(18,3)
VS0(30,7)=PAx*VS0(18,7)+WPx*VS1(18,7)+r1x2Z*VR1(18,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(30,8)=PAx*VS0(18,8)+WPx*VS1(18,8)+r1x2Z*VR1(18,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(18,4)
VS0(30,9)=PAx*VS0(18,9)+WPx*VS1(18,9)+r1x2Z*VR1(18,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))
VS0(30,10)=PAx*VS0(18,10)+WPx*VS1(18,10)+r1x2Z*VR1(18,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(31,5)=PAz*VS0(16,5)+WPz*VS1(16,5)&
   +r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(31,6)=PAz*VS0(16,6)+WPz*VS1(16,6)&
   +r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))
VS0(31,7)=PAz*VS0(16,7)+WPz*VS1(16,7)&
   +r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(31,8)=PAz*VS0(16,8)+WPz*VS1(16,8)&
   +r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(16,2)
VS0(31,9)=PAz*VS0(16,9)+WPz*VS1(16,9)&
   +r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(16,3)
VS0(31,10)=PAz*VS0(16,10)+WPz*VS1(16,10)&
   +r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))&
   +2D0*HfxZpE*VS1(16,4)
VS0(32,5)=PAy*VS0(19,5)+WPy*VS1(19,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(32,6)=PAy*VS0(19,6)+WPy*VS1(19,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(19,2)
VS0(32,7)=PAy*VS0(19,7)+WPy*VS1(19,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))&
   +2D0*HfxZpE*VS1(19,3)
VS0(32,8)=PAy*VS0(19,8)+WPy*VS1(19,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))
VS0(32,9)=PAy*VS0(19,9)+WPy*VS1(19,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(19,4)
VS0(32,10)=PAy*VS0(19,10)+WPy*VS1(19,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(33,5)=PAz*VS0(18,5)+WPz*VS1(18,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(33,6)=PAz*VS0(18,6)+WPz*VS1(18,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))
VS0(33,7)=PAz*VS0(18,7)+WPz*VS1(18,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(33,8)=PAz*VS0(18,8)+WPz*VS1(18,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(18,2)
VS0(33,9)=PAz*VS0(18,9)+WPz*VS1(18,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(18,3)
VS0(33,10)=PAz*VS0(18,10)+WPz*VS1(18,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))&
   +2D0*HfxZpE*VS1(18,4)
VS0(34,5)=PAz*VS0(19,5)+WPz*VS1(19,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(34,6)=PAz*VS0(19,6)+WPz*VS1(19,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))
VS0(34,7)=PAz*VS0(19,7)+WPz*VS1(19,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(34,8)=PAz*VS0(19,8)+WPz*VS1(19,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(19,2)
VS0(34,9)=PAz*VS0(19,9)+WPz*VS1(19,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(19,3)
VS0(34,10)=PAz*VS0(19,10)+WPz*VS1(19,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))&
   +2D0*HfxZpE*VS1(19,4)
VS0(35,5)=PAz*VS0(20,5)+WPz*VS1(20,5)&
   +3D0*r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(35,6)=PAz*VS0(20,6)+WPz*VS1(20,6)&
   +3D0*r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))
VS0(35,7)=PAz*VS0(20,7)+WPz*VS1(20,7)&
   +3D0*r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(35,8)=PAz*VS0(20,8)+WPz*VS1(20,8)&
   +3D0*r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(20,2)
VS0(35,9)=PAz*VS0(20,9)+WPz*VS1(20,9)&
   +3D0*r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(20,3)
VS0(35,10)=PAz*VS0(20,10)+WPz*VS1(20,10)&
   +3D0*r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))&
   +2D0*HfxZpE*VS1(20,4)
CASE(2)
VS0(21,5)=PAx*VS0(11,5)+WPx*VS1(11,5)&
   +3D0*r1x2Z*(VS0(5,5)-ExZpE*VS1(5,5))&
   +2D0*HfxZpE*VS1(11,2)
VS0(21,6)=PAx*VS0(11,6)+WPx*VS1(11,6)&
   +3D0*r1x2Z*(VS0(5,6)-ExZpE*VS1(5,6))&
   +HfxZpE*VS1(11,3)
VS0(21,7)=PAx*VS0(11,7)+WPx*VS1(11,7)&
   +3D0*r1x2Z*(VS0(5,7)-ExZpE*VS1(5,7))
VS0(21,8)=PAx*VS0(11,8)+WPx*VS1(11,8)&
   +3D0*r1x2Z*(VS0(5,8)-ExZpE*VS1(5,8))&
   +HfxZpE*VS1(11,4)
VS0(21,9)=PAx*VS0(11,9)+WPx*VS1(11,9)&
   +3D0*r1x2Z*(VS0(5,9)-ExZpE*VS1(5,9))
VS0(21,10)=PAx*VS0(11,10)+WPx*VS1(11,10)&
   +3D0*r1x2Z*(VS0(5,10)-ExZpE*VS1(5,10))
VS0(22,5)=PAx*VS0(12,5)+WPx*VS1(12,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))&
   +2D0*HfxZpE*VS1(12,2)
VS0(22,6)=PAx*VS0(12,6)+WPx*VS1(12,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(12,3)
VS0(22,7)=PAx*VS0(12,7)+WPx*VS1(12,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(22,8)=PAx*VS0(12,8)+WPx*VS1(12,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(12,4)
VS0(22,9)=PAx*VS0(12,9)+WPx*VS1(12,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))
VS0(22,10)=PAx*VS0(12,10)+WPx*VS1(12,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(23,5)=PAx*VS0(13,5)+WPx*VS1(13,5)&
   +r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))&
   +2D0*HfxZpE*VS1(13,2)
VS0(23,6)=PAx*VS0(13,6)+WPx*VS1(13,6)&
   +r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(13,3)
VS0(23,7)=PAx*VS0(13,7)+WPx*VS1(13,7)&
   +r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))
VS0(23,8)=PAx*VS0(13,8)+WPx*VS1(13,8)&
   +r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))&
   +HfxZpE*VS1(13,4)
VS0(23,9)=PAx*VS0(13,9)+WPx*VS1(13,9)&
   +r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))
VS0(23,10)=PAx*VS0(13,10)+WPx*VS1(13,10)&
   +r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(24,5)=PAy*VS0(13,5)+WPy*VS1(13,5)+r1x2Z*VR1(13,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(24,6)=PAy*VS0(13,6)+WPy*VS1(13,6)+r1x2Z*VR1(13,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(13,2)
VS0(24,7)=PAy*VS0(13,7)+WPy*VS1(13,7)+r1x2Z*VR1(13,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))&
   +2D0*HfxZpE*VS1(13,3)
VS0(24,8)=PAy*VS0(13,8)+WPy*VS1(13,8)+r1x2Z*VR1(13,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))
VS0(24,9)=PAy*VS0(13,9)+WPy*VS1(13,9)+r1x2Z*VR1(13,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(13,4)
VS0(24,10)=PAy*VS0(13,10)+WPy*VS1(13,10)+r1x2Z*VR1(13,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(25,5)=PAy*VS0(14,5)+WPy*VS1(14,5)+r1x2Z*VR1(14,5)&
   +3D0*r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))
VS0(25,6)=PAy*VS0(14,6)+WPy*VS1(14,6)+r1x2Z*VR1(14,6)&
   +3D0*r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(14,2)
VS0(25,7)=PAy*VS0(14,7)+WPy*VS1(14,7)+r1x2Z*VR1(14,7)&
   +3D0*r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))&
   +2D0*HfxZpE*VS1(14,3)
VS0(25,8)=PAy*VS0(14,8)+WPy*VS1(14,8)+r1x2Z*VR1(14,8)&
   +3D0*r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))
VS0(25,9)=PAy*VS0(14,9)+WPy*VS1(14,9)+r1x2Z*VR1(14,9)&
   +3D0*r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))&
   +HfxZpE*VS1(14,4)
VS0(25,10)=PAy*VS0(14,10)+WPy*VS1(14,10)+r1x2Z*VR1(14,10)&
   +3D0*r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(26,5)=PAx*VS0(15,5)+WPx*VS1(15,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))&
   +2D0*HfxZpE*VS1(15,2)
VS0(26,6)=PAx*VS0(15,6)+WPx*VS1(15,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(15,3)
VS0(26,7)=PAx*VS0(15,7)+WPx*VS1(15,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(26,8)=PAx*VS0(15,8)+WPx*VS1(15,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(15,4)
VS0(26,9)=PAx*VS0(15,9)+WPx*VS1(15,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))
VS0(26,10)=PAx*VS0(15,10)+WPx*VS1(15,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(27,5)=PAx*VS0(16,5)+WPx*VS1(16,5)&
   +r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))&
   +2D0*HfxZpE*VS1(16,2)
VS0(27,6)=PAx*VS0(16,6)+WPx*VS1(16,6)&
   +r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(16,3)
VS0(27,7)=PAx*VS0(16,7)+WPx*VS1(16,7)&
   +r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(27,8)=PAx*VS0(16,8)+WPx*VS1(16,8)&
   +r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(16,4)
VS0(27,9)=PAx*VS0(16,9)+WPx*VS1(16,9)&
   +r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))
VS0(27,10)=PAx*VS0(16,10)+WPx*VS1(16,10)&
   +r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(28,5)=PAy*VS0(16,5)+WPy*VS1(16,5)+r1x2Z*VR1(16,5)&
   +r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(28,6)=PAy*VS0(16,6)+WPy*VS1(16,6)+r1x2Z*VR1(16,6)&
   +r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(16,2)
VS0(28,7)=PAy*VS0(16,7)+WPy*VS1(16,7)+r1x2Z*VR1(16,7)&
   +r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))&
   +2D0*HfxZpE*VS1(16,3)
VS0(28,8)=PAy*VS0(16,8)+WPy*VS1(16,8)+r1x2Z*VR1(16,8)&
   +r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))
VS0(28,9)=PAy*VS0(16,9)+WPy*VS1(16,9)+r1x2Z*VR1(16,9)&
   +r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(16,4)
VS0(28,10)=PAy*VS0(16,10)+WPy*VS1(16,10)+r1x2Z*VR1(16,10)&
   +r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(29,5)=PAy*VS0(17,5)+WPy*VS1(17,5)+r1x2Z*VR1(17,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(29,6)=PAy*VS0(17,6)+WPy*VS1(17,6)+r1x2Z*VR1(17,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(17,2)
VS0(29,7)=PAy*VS0(17,7)+WPy*VS1(17,7)+r1x2Z*VR1(17,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))&
   +2D0*HfxZpE*VS1(17,3)
VS0(29,8)=PAy*VS0(17,8)+WPy*VS1(17,8)+r1x2Z*VR1(17,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))
VS0(29,9)=PAy*VS0(17,9)+WPy*VS1(17,9)+r1x2Z*VR1(17,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(17,4)
VS0(29,10)=PAy*VS0(17,10)+WPy*VS1(17,10)+r1x2Z*VR1(17,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(30,5)=PAx*VS0(18,5)+WPx*VS1(18,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))&
   +2D0*HfxZpE*VS1(18,2)
VS0(30,6)=PAx*VS0(18,6)+WPx*VS1(18,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(18,3)
VS0(30,7)=PAx*VS0(18,7)+WPx*VS1(18,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(30,8)=PAx*VS0(18,8)+WPx*VS1(18,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(18,4)
VS0(30,9)=PAx*VS0(18,9)+WPx*VS1(18,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))
VS0(30,10)=PAx*VS0(18,10)+WPx*VS1(18,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(31,5)=PAz*VS0(16,5)+WPz*VS1(16,5)&
   +r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(31,6)=PAz*VS0(16,6)+WPz*VS1(16,6)&
   +r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))
VS0(31,7)=PAz*VS0(16,7)+WPz*VS1(16,7)&
   +r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(31,8)=PAz*VS0(16,8)+WPz*VS1(16,8)&
   +r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(16,2)
VS0(31,9)=PAz*VS0(16,9)+WPz*VS1(16,9)&
   +r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(16,3)
VS0(31,10)=PAz*VS0(16,10)+WPz*VS1(16,10)&
   +r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))&
   +2D0*HfxZpE*VS1(16,4)
VS0(32,5)=PAy*VS0(19,5)+WPy*VS1(19,5)+r1x2Z*VR1(19,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(32,6)=PAy*VS0(19,6)+WPy*VS1(19,6)+r1x2Z*VR1(19,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(19,2)
VS0(32,7)=PAy*VS0(19,7)+WPy*VS1(19,7)+r1x2Z*VR1(19,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))&
   +2D0*HfxZpE*VS1(19,3)
VS0(32,8)=PAy*VS0(19,8)+WPy*VS1(19,8)+r1x2Z*VR1(19,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))
VS0(32,9)=PAy*VS0(19,9)+WPy*VS1(19,9)+r1x2Z*VR1(19,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(19,4)
VS0(32,10)=PAy*VS0(19,10)+WPy*VS1(19,10)+r1x2Z*VR1(19,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(33,5)=PAz*VS0(18,5)+WPz*VS1(18,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(33,6)=PAz*VS0(18,6)+WPz*VS1(18,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))
VS0(33,7)=PAz*VS0(18,7)+WPz*VS1(18,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(33,8)=PAz*VS0(18,8)+WPz*VS1(18,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(18,2)
VS0(33,9)=PAz*VS0(18,9)+WPz*VS1(18,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(18,3)
VS0(33,10)=PAz*VS0(18,10)+WPz*VS1(18,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))&
   +2D0*HfxZpE*VS1(18,4)
VS0(34,5)=PAz*VS0(19,5)+WPz*VS1(19,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(34,6)=PAz*VS0(19,6)+WPz*VS1(19,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))
VS0(34,7)=PAz*VS0(19,7)+WPz*VS1(19,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(34,8)=PAz*VS0(19,8)+WPz*VS1(19,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(19,2)
VS0(34,9)=PAz*VS0(19,9)+WPz*VS1(19,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(19,3)
VS0(34,10)=PAz*VS0(19,10)+WPz*VS1(19,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))&
   +2D0*HfxZpE*VS1(19,4)
VS0(35,5)=PAz*VS0(20,5)+WPz*VS1(20,5)&
   +3D0*r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(35,6)=PAz*VS0(20,6)+WPz*VS1(20,6)&
   +3D0*r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))
VS0(35,7)=PAz*VS0(20,7)+WPz*VS1(20,7)&
   +3D0*r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(35,8)=PAz*VS0(20,8)+WPz*VS1(20,8)&
   +3D0*r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(20,2)
VS0(35,9)=PAz*VS0(20,9)+WPz*VS1(20,9)&
   +3D0*r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(20,3)
VS0(35,10)=PAz*VS0(20,10)+WPz*VS1(20,10)&
   +3D0*r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))&
   +2D0*HfxZpE*VS1(20,4)
CASE(3)
VS0(21,5)=PAx*VS0(11,5)+WPx*VS1(11,5)&
   +3D0*r1x2Z*(VS0(5,5)-ExZpE*VS1(5,5))&
   +2D0*HfxZpE*VS1(11,2)
VS0(21,6)=PAx*VS0(11,6)+WPx*VS1(11,6)&
   +3D0*r1x2Z*(VS0(5,6)-ExZpE*VS1(5,6))&
   +HfxZpE*VS1(11,3)
VS0(21,7)=PAx*VS0(11,7)+WPx*VS1(11,7)&
   +3D0*r1x2Z*(VS0(5,7)-ExZpE*VS1(5,7))
VS0(21,8)=PAx*VS0(11,8)+WPx*VS1(11,8)&
   +3D0*r1x2Z*(VS0(5,8)-ExZpE*VS1(5,8))&
   +HfxZpE*VS1(11,4)
VS0(21,9)=PAx*VS0(11,9)+WPx*VS1(11,9)&
   +3D0*r1x2Z*(VS0(5,9)-ExZpE*VS1(5,9))
VS0(21,10)=PAx*VS0(11,10)+WPx*VS1(11,10)&
   +3D0*r1x2Z*(VS0(5,10)-ExZpE*VS1(5,10))
VS0(22,5)=PAx*VS0(12,5)+WPx*VS1(12,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))&
   +2D0*HfxZpE*VS1(12,2)
VS0(22,6)=PAx*VS0(12,6)+WPx*VS1(12,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(12,3)
VS0(22,7)=PAx*VS0(12,7)+WPx*VS1(12,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(22,8)=PAx*VS0(12,8)+WPx*VS1(12,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(12,4)
VS0(22,9)=PAx*VS0(12,9)+WPx*VS1(12,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))
VS0(22,10)=PAx*VS0(12,10)+WPx*VS1(12,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(23,5)=PAx*VS0(13,5)+WPx*VS1(13,5)&
   +r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))&
   +2D0*HfxZpE*VS1(13,2)
VS0(23,6)=PAx*VS0(13,6)+WPx*VS1(13,6)&
   +r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(13,3)
VS0(23,7)=PAx*VS0(13,7)+WPx*VS1(13,7)&
   +r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))
VS0(23,8)=PAx*VS0(13,8)+WPx*VS1(13,8)&
   +r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))&
   +HfxZpE*VS1(13,4)
VS0(23,9)=PAx*VS0(13,9)+WPx*VS1(13,9)&
   +r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))
VS0(23,10)=PAx*VS0(13,10)+WPx*VS1(13,10)&
   +r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(24,5)=PAy*VS0(13,5)+WPy*VS1(13,5)&
   +2D0*r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(24,6)=PAy*VS0(13,6)+WPy*VS1(13,6)&
   +2D0*r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))&
   +HfxZpE*VS1(13,2)
VS0(24,7)=PAy*VS0(13,7)+WPy*VS1(13,7)&
   +2D0*r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))&
   +2D0*HfxZpE*VS1(13,3)
VS0(24,8)=PAy*VS0(13,8)+WPy*VS1(13,8)&
   +2D0*r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))
VS0(24,9)=PAy*VS0(13,9)+WPy*VS1(13,9)&
   +2D0*r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(13,4)
VS0(24,10)=PAy*VS0(13,10)+WPy*VS1(13,10)&
   +2D0*r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))
VS0(25,5)=PAy*VS0(14,5)+WPy*VS1(14,5)&
   +3D0*r1x2Z*(VS0(7,5)-ExZpE*VS1(7,5))
VS0(25,6)=PAy*VS0(14,6)+WPy*VS1(14,6)&
   +3D0*r1x2Z*(VS0(7,6)-ExZpE*VS1(7,6))&
   +HfxZpE*VS1(14,2)
VS0(25,7)=PAy*VS0(14,7)+WPy*VS1(14,7)&
   +3D0*r1x2Z*(VS0(7,7)-ExZpE*VS1(7,7))&
   +2D0*HfxZpE*VS1(14,3)
VS0(25,8)=PAy*VS0(14,8)+WPy*VS1(14,8)&
   +3D0*r1x2Z*(VS0(7,8)-ExZpE*VS1(7,8))
VS0(25,9)=PAy*VS0(14,9)+WPy*VS1(14,9)&
   +3D0*r1x2Z*(VS0(7,9)-ExZpE*VS1(7,9))&
   +HfxZpE*VS1(14,4)
VS0(25,10)=PAy*VS0(14,10)+WPy*VS1(14,10)&
   +3D0*r1x2Z*(VS0(7,10)-ExZpE*VS1(7,10))
VS0(26,5)=PAx*VS0(15,5)+WPx*VS1(15,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))&
   +2D0*HfxZpE*VS1(15,2)
VS0(26,6)=PAx*VS0(15,6)+WPx*VS1(15,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(15,3)
VS0(26,7)=PAx*VS0(15,7)+WPx*VS1(15,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(26,8)=PAx*VS0(15,8)+WPx*VS1(15,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(15,4)
VS0(26,9)=PAx*VS0(15,9)+WPx*VS1(15,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))
VS0(26,10)=PAx*VS0(15,10)+WPx*VS1(15,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(27,5)=PAx*VS0(16,5)+WPx*VS1(16,5)&
   +r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))&
   +2D0*HfxZpE*VS1(16,2)
VS0(27,6)=PAx*VS0(16,6)+WPx*VS1(16,6)&
   +r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(16,3)
VS0(27,7)=PAx*VS0(16,7)+WPx*VS1(16,7)&
   +r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(27,8)=PAx*VS0(16,8)+WPx*VS1(16,8)&
   +r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(16,4)
VS0(27,9)=PAx*VS0(16,9)+WPx*VS1(16,9)&
   +r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))
VS0(27,10)=PAx*VS0(16,10)+WPx*VS1(16,10)&
   +r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(28,5)=PAy*VS0(16,5)+WPy*VS1(16,5)&
   +r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(28,6)=PAy*VS0(16,6)+WPy*VS1(16,6)&
   +r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))&
   +HfxZpE*VS1(16,2)
VS0(28,7)=PAy*VS0(16,7)+WPy*VS1(16,7)&
   +r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))&
   +2D0*HfxZpE*VS1(16,3)
VS0(28,8)=PAy*VS0(16,8)+WPy*VS1(16,8)&
   +r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))
VS0(28,9)=PAy*VS0(16,9)+WPy*VS1(16,9)&
   +r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(16,4)
VS0(28,10)=PAy*VS0(16,10)+WPy*VS1(16,10)&
   +r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))
VS0(29,5)=PAy*VS0(17,5)+WPy*VS1(17,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(29,6)=PAy*VS0(17,6)+WPy*VS1(17,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))&
   +HfxZpE*VS1(17,2)
VS0(29,7)=PAy*VS0(17,7)+WPy*VS1(17,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))&
   +2D0*HfxZpE*VS1(17,3)
VS0(29,8)=PAy*VS0(17,8)+WPy*VS1(17,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))
VS0(29,9)=PAy*VS0(17,9)+WPy*VS1(17,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(17,4)
VS0(29,10)=PAy*VS0(17,10)+WPy*VS1(17,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))
VS0(30,5)=PAx*VS0(18,5)+WPx*VS1(18,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))&
   +2D0*HfxZpE*VS1(18,2)
VS0(30,6)=PAx*VS0(18,6)+WPx*VS1(18,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(18,3)
VS0(30,7)=PAx*VS0(18,7)+WPx*VS1(18,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(30,8)=PAx*VS0(18,8)+WPx*VS1(18,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(18,4)
VS0(30,9)=PAx*VS0(18,9)+WPx*VS1(18,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))
VS0(30,10)=PAx*VS0(18,10)+WPx*VS1(18,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(31,5)=PAz*VS0(16,5)+WPz*VS1(16,5)+r1x2Z*VR1(16,5)&
   +r1x2Z*(VS0(6,5)-ExZpE*VS1(6,5))
VS0(31,6)=PAz*VS0(16,6)+WPz*VS1(16,6)+r1x2Z*VR1(16,6)&
   +r1x2Z*(VS0(6,6)-ExZpE*VS1(6,6))
VS0(31,7)=PAz*VS0(16,7)+WPz*VS1(16,7)+r1x2Z*VR1(16,7)&
   +r1x2Z*(VS0(6,7)-ExZpE*VS1(6,7))
VS0(31,8)=PAz*VS0(16,8)+WPz*VS1(16,8)+r1x2Z*VR1(16,8)&
   +r1x2Z*(VS0(6,8)-ExZpE*VS1(6,8))&
   +HfxZpE*VS1(16,2)
VS0(31,9)=PAz*VS0(16,9)+WPz*VS1(16,9)+r1x2Z*VR1(16,9)&
   +r1x2Z*(VS0(6,9)-ExZpE*VS1(6,9))&
   +HfxZpE*VS1(16,3)
VS0(31,10)=PAz*VS0(16,10)+WPz*VS1(16,10)+r1x2Z*VR1(16,10)&
   +r1x2Z*(VS0(6,10)-ExZpE*VS1(6,10))&
   +2D0*HfxZpE*VS1(16,4)
VS0(32,5)=PAy*VS0(19,5)+WPy*VS1(19,5)&
   +r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(32,6)=PAy*VS0(19,6)+WPy*VS1(19,6)&
   +r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))&
   +HfxZpE*VS1(19,2)
VS0(32,7)=PAy*VS0(19,7)+WPy*VS1(19,7)&
   +r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))&
   +2D0*HfxZpE*VS1(19,3)
VS0(32,8)=PAy*VS0(19,8)+WPy*VS1(19,8)&
   +r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))
VS0(32,9)=PAy*VS0(19,9)+WPy*VS1(19,9)&
   +r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(19,4)
VS0(32,10)=PAy*VS0(19,10)+WPy*VS1(19,10)&
   +r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))
VS0(33,5)=PAz*VS0(18,5)+WPz*VS1(18,5)+r1x2Z*VR1(18,5)&
   +2D0*r1x2Z*(VS0(8,5)-ExZpE*VS1(8,5))
VS0(33,6)=PAz*VS0(18,6)+WPz*VS1(18,6)+r1x2Z*VR1(18,6)&
   +2D0*r1x2Z*(VS0(8,6)-ExZpE*VS1(8,6))
VS0(33,7)=PAz*VS0(18,7)+WPz*VS1(18,7)+r1x2Z*VR1(18,7)&
   +2D0*r1x2Z*(VS0(8,7)-ExZpE*VS1(8,7))
VS0(33,8)=PAz*VS0(18,8)+WPz*VS1(18,8)+r1x2Z*VR1(18,8)&
   +2D0*r1x2Z*(VS0(8,8)-ExZpE*VS1(8,8))&
   +HfxZpE*VS1(18,2)
VS0(33,9)=PAz*VS0(18,9)+WPz*VS1(18,9)+r1x2Z*VR1(18,9)&
   +2D0*r1x2Z*(VS0(8,9)-ExZpE*VS1(8,9))&
   +HfxZpE*VS1(18,3)
VS0(33,10)=PAz*VS0(18,10)+WPz*VS1(18,10)+r1x2Z*VR1(18,10)&
   +2D0*r1x2Z*(VS0(8,10)-ExZpE*VS1(8,10))&
   +2D0*HfxZpE*VS1(18,4)
VS0(34,5)=PAz*VS0(19,5)+WPz*VS1(19,5)+r1x2Z*VR1(19,5)&
   +2D0*r1x2Z*(VS0(9,5)-ExZpE*VS1(9,5))
VS0(34,6)=PAz*VS0(19,6)+WPz*VS1(19,6)+r1x2Z*VR1(19,6)&
   +2D0*r1x2Z*(VS0(9,6)-ExZpE*VS1(9,6))
VS0(34,7)=PAz*VS0(19,7)+WPz*VS1(19,7)+r1x2Z*VR1(19,7)&
   +2D0*r1x2Z*(VS0(9,7)-ExZpE*VS1(9,7))
VS0(34,8)=PAz*VS0(19,8)+WPz*VS1(19,8)+r1x2Z*VR1(19,8)&
   +2D0*r1x2Z*(VS0(9,8)-ExZpE*VS1(9,8))&
   +HfxZpE*VS1(19,2)
VS0(34,9)=PAz*VS0(19,9)+WPz*VS1(19,9)+r1x2Z*VR1(19,9)&
   +2D0*r1x2Z*(VS0(9,9)-ExZpE*VS1(9,9))&
   +HfxZpE*VS1(19,3)
VS0(34,10)=PAz*VS0(19,10)+WPz*VS1(19,10)+r1x2Z*VR1(19,10)&
   +2D0*r1x2Z*(VS0(9,10)-ExZpE*VS1(9,10))&
   +2D0*HfxZpE*VS1(19,4)
VS0(35,5)=PAz*VS0(20,5)+WPz*VS1(20,5)+r1x2Z*VR1(20,5)&
   +3D0*r1x2Z*(VS0(10,5)-ExZpE*VS1(10,5))
VS0(35,6)=PAz*VS0(20,6)+WPz*VS1(20,6)+r1x2Z*VR1(20,6)&
   +3D0*r1x2Z*(VS0(10,6)-ExZpE*VS1(10,6))
VS0(35,7)=PAz*VS0(20,7)+WPz*VS1(20,7)+r1x2Z*VR1(20,7)&
   +3D0*r1x2Z*(VS0(10,7)-ExZpE*VS1(10,7))
VS0(35,8)=PAz*VS0(20,8)+WPz*VS1(20,8)+r1x2Z*VR1(20,8)&
   +3D0*r1x2Z*(VS0(10,8)-ExZpE*VS1(10,8))&
   +HfxZpE*VS1(20,2)
VS0(35,9)=PAz*VS0(20,9)+WPz*VS1(20,9)+r1x2Z*VR1(20,9)&
   +3D0*r1x2Z*(VS0(10,9)-ExZpE*VS1(10,9))&
   +HfxZpE*VS1(20,3)
VS0(35,10)=PAz*VS0(20,10)+WPz*VS1(20,10)+r1x2Z*VR1(20,10)&
   +3D0*r1x2Z*(VS0(10,10)-ExZpE*VS1(10,10))&
   +2D0*HfxZpE*VS1(20,4)
CASE DEFAULT
WRITE(*,*) 'STOP IN MVRRg0d0'
STOP
END SELECT
END SUBROUTINE MVRRg0d0
