!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
! ----------------------------------------------------------
! COMPUTES THE INTEGRAL CLASS (f f|sp sp)
! ----------------------------------------------------------
   SUBROUTINE IntB10100202(PrmBufB,LBra,PrmBufK,LKet,ACInfo,BDInfo, &
                              OA,LDA,OB,LDB,OC,LDC,OD,LDD,PBC,INTGRL)
      USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      USE ShellPairStruct
      USE GammaF8
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER        :: LBra,LKet,CDOffSet
      REAL(DOUBLE)   :: PrmBufB(10,LBra),PrmBufK(10,LKet)
      TYPE(SmallAtomInfo) :: ACInfo,BDInfo
      TYPE(PBCInfo) :: PBC
      REAL(DOUBLE)  :: INTGRL(*)
      REAL(DOUBLE)  :: Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz
      REAL(DOUBLE)  :: Dx,Dy,Dz,Qx,Qy,Qz,Px,Py,Pz
      REAL(DOUBLE)  :: PQx,PQy,PQz,FPQx,FPQy,FPQz
      REAL(DOUBLE)  :: Zeta,Eta,Omega,Up,Uq,Upq
      REAL(DOUBLE)  :: T,ET,TwoT,InvT,SqInvT
      REAL(DOUBLE)  :: VRR(84,10,0:8)
      REAL(DOUBLE)  :: HRR(84,18,4)
      INTEGER       :: OffSet,OA,LDA,OB,LDB,OC,LDC,OD,LDD,I,J,K,L
      EXTERNAL InitDbl
      CALL InitDbl(84*18,HRR(1,1,1))
      Ax=ACInfo%Atm1X
      Ay=ACInfo%Atm1Y
      Az=ACInfo%Atm1Z
      Bx=ACInfo%Atm2X
      By=ACInfo%Atm2Y
      Bz=ACInfo%Atm2Z
      Cx=BDInfo%Atm1X
      Cy=BDInfo%Atm1Y
      Cz=BDInfo%Atm1Z
      Dx=BDInfo%Atm2X
      Dy=BDInfo%Atm2Y
      Dz=BDInfo%Atm2Z
      ABx=Ax-Bx
      ABy=Ay-By
      ABz=Az-Bz
      CDx=Cx-Dx
      CDy=Cy-Dy
      CDz=Cz-Dz
      DO J=1,LKet ! K^2 VRR |N0) loop
         Eta=PrmBufK(1,J)
         Qx=PrmBufK(2,J)
         Qy=PrmBufK(3,J)
         Qz=PrmBufK(4,J)
         Uq=PrmBufK(5,J)
         SpSpK=PrmBufK(6,J)
         FnSpK=PrmBufK(7,J)
         SpFnK=PrmBufK(8,J)
         QCx=Qx-Cx
         QCy=Qy-Cy
         QCz=Qz-Cz
         DO K=1,LBra ! K^2 VRR (M0| loop
            Zeta=PrmBufB(1,K)
            Px=PrmBufB(2,K)
            Py=PrmBufB(3,K)
            Pz=PrmBufB(4,K)
            Up=PrmBufB(5,K)
            r1xZpE=One/(Zeta+Eta)
            Upq=SQRT(r1xZpE)*Up*Uq
            HfxZpE=Half/(Zeta+Eta)
            r1x2E=Half/Eta
            r1x2Z=Half/Zeta
            ExZpE=Eta*r1xZpE
            ZxZpE=Zeta*r1xZpE
            Omega=Eta*Zeta*r1xZpE
            PAx=Px-Ax
            PAy=Py-Ay
            PAz=Pz-Az
            PQx=Px-Qx
            PQy=Py-Qy
            PQz=Pz-Qz
            ! Begin Minimum Image Convention
            FPQx = PQx*PBC%InvBoxSh%D(1,1)+PQy*PBC%InvBoxSh%D(1,2)+PQz*PBC%InvBoxSh%D(1,3)
            FPQy = PQy*PBC%InvBoxSh%D(2,2)+PQz*PBC%InvBoxSh%D(2,3)
            FPQz = PQz*PBC%InvBoxSh%D(3,3)
            IF(PBC%AutoW%I(1)==1)FPQx=FPQx-ANINT(FPQx-SIGN(1D-15,FPQx))
            IF(PBC%AutoW%I(2)==1)FPQy=FPQy-ANINT(FPQy-SIGN(1D-15,FPQy))
            IF(PBC%AutoW%I(3)==1)FPQz=FPQz-ANINT(FPQz-SIGN(1D-15,FPQz))
            PQx=FPQx*PBC%BoxShape%D(1,1)+FPQy*PBC%BoxShape%D(1,2)+FPQz*PBC%BoxShape%D(1,3)
            PQy=FPQy*PBC%BoxShape%D(2,2)+FPQz*PBC%BoxShape%D(2,3)
            PQz=FPQz*PBC%BoxShape%D(3,3)
            ! End MIC
            WPx = -Eta*PQx*r1xZpE
            WPy = -Eta*PQy*r1xZpE
            WPz = -Eta*PQz*r1xZpE
            WQx = Zeta*PQx*r1xZpE
            WQy = Zeta*PQy*r1xZpE
            WQz = Zeta*PQz*r1xZpE
            T=Omega*(PQx*PQx+PQy*PQy+PQz*PQz)
            IF(T<Gamma_Switch)THEN
              L=AINT(T*Gamma_Grid)
              ET=EXP(-T)
              TwoT=Two*T
              W8=(F8_0(L)+T*(F8_1(L)+T*(F8_2(L)+T*(F8_3(L)+T*F8_4(L)))))
              W7=+6.666666666666666D-02*(TwoT*W8+ET)
              W6=+7.692307692307693D-02*(TwoT*W7+ET)
              W5=+9.090909090909090D-02*(TwoT*W6+ET)
              W4=+1.111111111111111D-01*(TwoT*W5+ET)
              W3=+1.428571428571428D-01*(TwoT*W4+ET)
              W2=+2.000000000000000D-01*(TwoT*W3+ET)
              W1=+3.333333333333333D-01*(TwoT*W2+ET)
              W0=TwoT*W1+ET
              VRR(1,1,0)=Upq*W0
              VRR(1,1,1)=Upq*W1
              VRR(1,1,2)=Upq*W2
              VRR(1,1,3)=Upq*W3
              VRR(1,1,4)=Upq*W4
              VRR(1,1,5)=Upq*W5
              VRR(1,1,6)=Upq*W6
              VRR(1,1,7)=Upq*W7
              VRR(1,1,8)=Upq*W8
            ELSE
              InvT=One/T
              SqInvT=DSQRT(InvT)
              VRR(1,1,0)=+8.862269254527580D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,1)=+4.431134627263790D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,2)=+6.646701940895685D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,3)=+1.661675485223921D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,4)=+5.815864198283724D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,5)=+2.617138889227676D+01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,6)=+1.439426389075222D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,7)=+9.356271528988940D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,8)=+7.017203646741708D+03*Upq*SqInvT
            ENDIF
            ! Generating (p0|s0)^(7)
            VRR(2,1,7)=PAx*VRR(1,1,7)+WPx*VRR(1,1,8)
            VRR(3,1,7)=PAy*VRR(1,1,7)+WPy*VRR(1,1,8)
            VRR(4,1,7)=PAz*VRR(1,1,7)+WPz*VRR(1,1,8)
            ! Generating (p0|s0)^(6)
            VRR(2,1,6)=PAx*VRR(1,1,6)+WPx*VRR(1,1,7)
            VRR(3,1,6)=PAy*VRR(1,1,6)+WPy*VRR(1,1,7)
            VRR(4,1,6)=PAz*VRR(1,1,6)+WPz*VRR(1,1,7)
            ! Generating (p0|s0)^(5)
            VRR(2,1,5)=PAx*VRR(1,1,5)+WPx*VRR(1,1,6)
            VRR(3,1,5)=PAy*VRR(1,1,5)+WPy*VRR(1,1,6)
            VRR(4,1,5)=PAz*VRR(1,1,5)+WPz*VRR(1,1,6)
            ! Generating (p0|s0)^(4)
            VRR(2,1,4)=PAx*VRR(1,1,4)+WPx*VRR(1,1,5)
            VRR(3,1,4)=PAy*VRR(1,1,4)+WPy*VRR(1,1,5)
            VRR(4,1,4)=PAz*VRR(1,1,4)+WPz*VRR(1,1,5)
            ! Generating (p0|s0)^(3)
            VRR(2,1,3)=PAx*VRR(1,1,3)+WPx*VRR(1,1,4)
            VRR(3,1,3)=PAy*VRR(1,1,3)+WPy*VRR(1,1,4)
            VRR(4,1,3)=PAz*VRR(1,1,3)+WPz*VRR(1,1,4)
            ! Generating (p0|s0)^(2)
            VRR(2,1,2)=PAx*VRR(1,1,2)+WPx*VRR(1,1,3)
            VRR(3,1,2)=PAy*VRR(1,1,2)+WPy*VRR(1,1,3)
            VRR(4,1,2)=PAz*VRR(1,1,2)+WPz*VRR(1,1,3)
            ! Generating (p0|s0)^(1)
            VRR(2,1,1)=PAx*VRR(1,1,1)+WPx*VRR(1,1,2)
            VRR(3,1,1)=PAy*VRR(1,1,1)+WPy*VRR(1,1,2)
            VRR(4,1,1)=PAz*VRR(1,1,1)+WPz*VRR(1,1,2)
            ! Generating (p0|s0)^(0)
            VRR(2,1,0)=PAx*VRR(1,1,0)+WPx*VRR(1,1,1)
            VRR(3,1,0)=PAy*VRR(1,1,0)+WPy*VRR(1,1,1)
            VRR(4,1,0)=PAz*VRR(1,1,0)+WPz*VRR(1,1,1)
            ! Generating (d0|s0)^(6)
            VRR(5,1,6)=PAx*VRR(2,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPx*VRR(2,1,7)
            VRR(6,1,6)=PAx*VRR(3,1,6)+WPx*VRR(3,1,7)
            VRR(7,1,6)=PAy*VRR(3,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPy*VRR(3,1,7)
            VRR(8,1,6)=PAx*VRR(4,1,6)+WPx*VRR(4,1,7)
            VRR(9,1,6)=PAy*VRR(4,1,6)+WPy*VRR(4,1,7)
            VRR(10,1,6)=PAz*VRR(4,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPz*VRR(4,1,7)
            ! Generating (d0|s0)^(5)
            VRR(5,1,5)=PAx*VRR(2,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPx*VRR(2,1,6)
            VRR(6,1,5)=PAx*VRR(3,1,5)+WPx*VRR(3,1,6)
            VRR(7,1,5)=PAy*VRR(3,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPy*VRR(3,1,6)
            VRR(8,1,5)=PAx*VRR(4,1,5)+WPx*VRR(4,1,6)
            VRR(9,1,5)=PAy*VRR(4,1,5)+WPy*VRR(4,1,6)
            VRR(10,1,5)=PAz*VRR(4,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPz*VRR(4,1,6)
            ! Generating (d0|s0)^(4)
            VRR(5,1,4)=PAx*VRR(2,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPx*VRR(2,1,5)
            VRR(6,1,4)=PAx*VRR(3,1,4)+WPx*VRR(3,1,5)
            VRR(7,1,4)=PAy*VRR(3,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPy*VRR(3,1,5)
            VRR(8,1,4)=PAx*VRR(4,1,4)+WPx*VRR(4,1,5)
            VRR(9,1,4)=PAy*VRR(4,1,4)+WPy*VRR(4,1,5)
            VRR(10,1,4)=PAz*VRR(4,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPz*VRR(4,1,5)
            ! Generating (d0|s0)^(3)
            VRR(5,1,3)=PAx*VRR(2,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPx*VRR(2,1,4)
            VRR(6,1,3)=PAx*VRR(3,1,3)+WPx*VRR(3,1,4)
            VRR(7,1,3)=PAy*VRR(3,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPy*VRR(3,1,4)
            VRR(8,1,3)=PAx*VRR(4,1,3)+WPx*VRR(4,1,4)
            VRR(9,1,3)=PAy*VRR(4,1,3)+WPy*VRR(4,1,4)
            VRR(10,1,3)=PAz*VRR(4,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPz*VRR(4,1,4)
            ! Generating (d0|s0)^(2)
            VRR(5,1,2)=PAx*VRR(2,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPx*VRR(2,1,3)
            VRR(6,1,2)=PAx*VRR(3,1,2)+WPx*VRR(3,1,3)
            VRR(7,1,2)=PAy*VRR(3,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPy*VRR(3,1,3)
            VRR(8,1,2)=PAx*VRR(4,1,2)+WPx*VRR(4,1,3)
            VRR(9,1,2)=PAy*VRR(4,1,2)+WPy*VRR(4,1,3)
            VRR(10,1,2)=PAz*VRR(4,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPz*VRR(4,1,3)
            ! Generating (d0|s0)^(1)
            VRR(5,1,1)=PAx*VRR(2,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPx*VRR(2,1,2)
            VRR(6,1,1)=PAx*VRR(3,1,1)+WPx*VRR(3,1,2)
            VRR(7,1,1)=PAy*VRR(3,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPy*VRR(3,1,2)
            VRR(8,1,1)=PAx*VRR(4,1,1)+WPx*VRR(4,1,2)
            VRR(9,1,1)=PAy*VRR(4,1,1)+WPy*VRR(4,1,2)
            VRR(10,1,1)=PAz*VRR(4,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPz*VRR(4,1,2)
            ! Generating (d0|s0)^(0)
            VRR(5,1,0)=PAx*VRR(2,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPx*VRR(2,1,1)
            VRR(6,1,0)=PAx*VRR(3,1,0)+WPx*VRR(3,1,1)
            VRR(7,1,0)=PAy*VRR(3,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPy*VRR(3,1,1)
            VRR(8,1,0)=PAx*VRR(4,1,0)+WPx*VRR(4,1,1)
            VRR(9,1,0)=PAy*VRR(4,1,0)+WPy*VRR(4,1,1)
            VRR(10,1,0)=PAz*VRR(4,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPz*VRR(4,1,1)
            ! Generating (f0|s0)^(5)
            CALL VRRf0s0(84,10,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|s0)^(4)
            CALL VRRf0s0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|s0)^(3)
            CALL VRRf0s0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|s0)^(2)
            CALL VRRf0s0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|s0)^(1)
            CALL VRRf0s0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|s0)^(0)
            CALL VRRf0s0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|s0)^(4)
            CALL VRRg0s0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|s0)^(3)
            CALL VRRg0s0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|s0)^(2)
            CALL VRRg0s0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|s0)^(1)
            CALL VRRg0s0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|s0)^(0)
            CALL VRRg0s0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|s0)^(3)
            CALL VRRh0s0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (h0|s0)^(2)
            CALL VRRh0s0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|s0)^(1)
            CALL VRRh0s0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|s0)^(0)
            CALL VRRh0s0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|s0)^(2)
            CALL VRRi0s0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (i0|s0)^(1)
            CALL VRRi0s0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|s0)^(0)
            CALL VRRi0s0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|p0)^(7)
            VRR(1,2,7)=QCx*VRR(1,1,7)+WQx*VRR(1,1,8)
            VRR(1,3,7)=QCy*VRR(1,1,7)+WQy*VRR(1,1,8)
            VRR(1,4,7)=QCz*VRR(1,1,7)+WQz*VRR(1,1,8)
            ! Generating (s0|p0)^(6)
            VRR(1,2,6)=QCx*VRR(1,1,6)+WQx*VRR(1,1,7)
            VRR(1,3,6)=QCy*VRR(1,1,6)+WQy*VRR(1,1,7)
            VRR(1,4,6)=QCz*VRR(1,1,6)+WQz*VRR(1,1,7)
            ! Generating (s0|p0)^(5)
            VRR(1,2,5)=QCx*VRR(1,1,5)+WQx*VRR(1,1,6)
            VRR(1,3,5)=QCy*VRR(1,1,5)+WQy*VRR(1,1,6)
            VRR(1,4,5)=QCz*VRR(1,1,5)+WQz*VRR(1,1,6)
            ! Generating (s0|p0)^(4)
            VRR(1,2,4)=QCx*VRR(1,1,4)+WQx*VRR(1,1,5)
            VRR(1,3,4)=QCy*VRR(1,1,4)+WQy*VRR(1,1,5)
            VRR(1,4,4)=QCz*VRR(1,1,4)+WQz*VRR(1,1,5)
            ! Generating (s0|p0)^(3)
            VRR(1,2,3)=QCx*VRR(1,1,3)+WQx*VRR(1,1,4)
            VRR(1,3,3)=QCy*VRR(1,1,3)+WQy*VRR(1,1,4)
            VRR(1,4,3)=QCz*VRR(1,1,3)+WQz*VRR(1,1,4)
            ! Generating (s0|p0)^(2)
            VRR(1,2,2)=QCx*VRR(1,1,2)+WQx*VRR(1,1,3)
            VRR(1,3,2)=QCy*VRR(1,1,2)+WQy*VRR(1,1,3)
            VRR(1,4,2)=QCz*VRR(1,1,2)+WQz*VRR(1,1,3)
            ! Generating (s0|p0)^(1)
            VRR(1,2,1)=QCx*VRR(1,1,1)+WQx*VRR(1,1,2)
            VRR(1,3,1)=QCy*VRR(1,1,1)+WQy*VRR(1,1,2)
            VRR(1,4,1)=QCz*VRR(1,1,1)+WQz*VRR(1,1,2)
            ! Generating (s0|p0)^(0)
            VRR(1,2,0)=QCx*VRR(1,1,0)+WQx*VRR(1,1,1)
            VRR(1,3,0)=QCy*VRR(1,1,0)+WQy*VRR(1,1,1)
            VRR(1,4,0)=QCz*VRR(1,1,0)+WQz*VRR(1,1,1)
            ! Generating (p0|p0)^(6)
            VRR(2,2,6)=QCx*VRR(2,1,6)+HfxZpE*VRR(1,1,7)+WQx*VRR(2,1,7)
            VRR(2,3,6)=QCy*VRR(2,1,6)+WQy*VRR(2,1,7)
            VRR(2,4,6)=QCz*VRR(2,1,6)+WQz*VRR(2,1,7)
            VRR(3,2,6)=QCx*VRR(3,1,6)+WQx*VRR(3,1,7)
            VRR(3,3,6)=QCy*VRR(3,1,6)+HfxZpE*VRR(1,1,7)+WQy*VRR(3,1,7)
            VRR(3,4,6)=QCz*VRR(3,1,6)+WQz*VRR(3,1,7)
            VRR(4,2,6)=QCx*VRR(4,1,6)+WQx*VRR(4,1,7)
            VRR(4,3,6)=QCy*VRR(4,1,6)+WQy*VRR(4,1,7)
            VRR(4,4,6)=QCz*VRR(4,1,6)+HfxZpE*VRR(1,1,7)+WQz*VRR(4,1,7)
            ! Generating (p0|p0)^(5)
            VRR(2,2,5)=QCx*VRR(2,1,5)+HfxZpE*VRR(1,1,6)+WQx*VRR(2,1,6)
            VRR(2,3,5)=QCy*VRR(2,1,5)+WQy*VRR(2,1,6)
            VRR(2,4,5)=QCz*VRR(2,1,5)+WQz*VRR(2,1,6)
            VRR(3,2,5)=QCx*VRR(3,1,5)+WQx*VRR(3,1,6)
            VRR(3,3,5)=QCy*VRR(3,1,5)+HfxZpE*VRR(1,1,6)+WQy*VRR(3,1,6)
            VRR(3,4,5)=QCz*VRR(3,1,5)+WQz*VRR(3,1,6)
            VRR(4,2,5)=QCx*VRR(4,1,5)+WQx*VRR(4,1,6)
            VRR(4,3,5)=QCy*VRR(4,1,5)+WQy*VRR(4,1,6)
            VRR(4,4,5)=QCz*VRR(4,1,5)+HfxZpE*VRR(1,1,6)+WQz*VRR(4,1,6)
            ! Generating (p0|p0)^(4)
            VRR(2,2,4)=QCx*VRR(2,1,4)+HfxZpE*VRR(1,1,5)+WQx*VRR(2,1,5)
            VRR(2,3,4)=QCy*VRR(2,1,4)+WQy*VRR(2,1,5)
            VRR(2,4,4)=QCz*VRR(2,1,4)+WQz*VRR(2,1,5)
            VRR(3,2,4)=QCx*VRR(3,1,4)+WQx*VRR(3,1,5)
            VRR(3,3,4)=QCy*VRR(3,1,4)+HfxZpE*VRR(1,1,5)+WQy*VRR(3,1,5)
            VRR(3,4,4)=QCz*VRR(3,1,4)+WQz*VRR(3,1,5)
            VRR(4,2,4)=QCx*VRR(4,1,4)+WQx*VRR(4,1,5)
            VRR(4,3,4)=QCy*VRR(4,1,4)+WQy*VRR(4,1,5)
            VRR(4,4,4)=QCz*VRR(4,1,4)+HfxZpE*VRR(1,1,5)+WQz*VRR(4,1,5)
            ! Generating (p0|p0)^(3)
            VRR(2,2,3)=QCx*VRR(2,1,3)+HfxZpE*VRR(1,1,4)+WQx*VRR(2,1,4)
            VRR(2,3,3)=QCy*VRR(2,1,3)+WQy*VRR(2,1,4)
            VRR(2,4,3)=QCz*VRR(2,1,3)+WQz*VRR(2,1,4)
            VRR(3,2,3)=QCx*VRR(3,1,3)+WQx*VRR(3,1,4)
            VRR(3,3,3)=QCy*VRR(3,1,3)+HfxZpE*VRR(1,1,4)+WQy*VRR(3,1,4)
            VRR(3,4,3)=QCz*VRR(3,1,3)+WQz*VRR(3,1,4)
            VRR(4,2,3)=QCx*VRR(4,1,3)+WQx*VRR(4,1,4)
            VRR(4,3,3)=QCy*VRR(4,1,3)+WQy*VRR(4,1,4)
            VRR(4,4,3)=QCz*VRR(4,1,3)+HfxZpE*VRR(1,1,4)+WQz*VRR(4,1,4)
            ! Generating (p0|p0)^(2)
            VRR(2,2,2)=QCx*VRR(2,1,2)+HfxZpE*VRR(1,1,3)+WQx*VRR(2,1,3)
            VRR(2,3,2)=QCy*VRR(2,1,2)+WQy*VRR(2,1,3)
            VRR(2,4,2)=QCz*VRR(2,1,2)+WQz*VRR(2,1,3)
            VRR(3,2,2)=QCx*VRR(3,1,2)+WQx*VRR(3,1,3)
            VRR(3,3,2)=QCy*VRR(3,1,2)+HfxZpE*VRR(1,1,3)+WQy*VRR(3,1,3)
            VRR(3,4,2)=QCz*VRR(3,1,2)+WQz*VRR(3,1,3)
            VRR(4,2,2)=QCx*VRR(4,1,2)+WQx*VRR(4,1,3)
            VRR(4,3,2)=QCy*VRR(4,1,2)+WQy*VRR(4,1,3)
            VRR(4,4,2)=QCz*VRR(4,1,2)+HfxZpE*VRR(1,1,3)+WQz*VRR(4,1,3)
            ! Generating (p0|p0)^(1)
            VRR(2,2,1)=QCx*VRR(2,1,1)+HfxZpE*VRR(1,1,2)+WQx*VRR(2,1,2)
            VRR(2,3,1)=QCy*VRR(2,1,1)+WQy*VRR(2,1,2)
            VRR(2,4,1)=QCz*VRR(2,1,1)+WQz*VRR(2,1,2)
            VRR(3,2,1)=QCx*VRR(3,1,1)+WQx*VRR(3,1,2)
            VRR(3,3,1)=QCy*VRR(3,1,1)+HfxZpE*VRR(1,1,2)+WQy*VRR(3,1,2)
            VRR(3,4,1)=QCz*VRR(3,1,1)+WQz*VRR(3,1,2)
            VRR(4,2,1)=QCx*VRR(4,1,1)+WQx*VRR(4,1,2)
            VRR(4,3,1)=QCy*VRR(4,1,1)+WQy*VRR(4,1,2)
            VRR(4,4,1)=QCz*VRR(4,1,1)+HfxZpE*VRR(1,1,2)+WQz*VRR(4,1,2)
            ! Generating (p0|p0)^(0)
            VRR(2,2,0)=QCx*VRR(2,1,0)+HfxZpE*VRR(1,1,1)+WQx*VRR(2,1,1)
            VRR(2,3,0)=QCy*VRR(2,1,0)+WQy*VRR(2,1,1)
            VRR(2,4,0)=QCz*VRR(2,1,0)+WQz*VRR(2,1,1)
            VRR(3,2,0)=QCx*VRR(3,1,0)+WQx*VRR(3,1,1)
            VRR(3,3,0)=QCy*VRR(3,1,0)+HfxZpE*VRR(1,1,1)+WQy*VRR(3,1,1)
            VRR(3,4,0)=QCz*VRR(3,1,0)+WQz*VRR(3,1,1)
            VRR(4,2,0)=QCx*VRR(4,1,0)+WQx*VRR(4,1,1)
            VRR(4,3,0)=QCy*VRR(4,1,0)+WQy*VRR(4,1,1)
            VRR(4,4,0)=QCz*VRR(4,1,0)+HfxZpE*VRR(1,1,1)+WQz*VRR(4,1,1)
            ! Generating (d0|p0)^(5)
            CALL VRRd0p0(84,10,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|p0)^(4)
            CALL VRRd0p0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|p0)^(3)
            CALL VRRd0p0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|p0)^(2)
            CALL VRRd0p0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|p0)^(1)
            CALL VRRd0p0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|p0)^(0)
            CALL VRRd0p0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|p0)^(4)
            CALL VRRf0p0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|p0)^(3)
            CALL VRRf0p0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|p0)^(2)
            CALL VRRf0p0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|p0)^(1)
            CALL VRRf0p0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|p0)^(0)
            CALL VRRf0p0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|p0)^(3)
            CALL VRRg0p0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|p0)^(2)
            CALL VRRg0p0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|p0)^(1)
            CALL VRRg0p0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|p0)^(0)
            CALL VRRg0p0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|p0)^(2)
            CALL VRRh0p0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|p0)^(1)
            CALL VRRh0p0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|p0)^(0)
            CALL VRRh0p0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|p0)^(1)
            CALL VRRi0p0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|p0)^(0)
            CALL VRRi0p0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|d0)^(6)
            CALL VRRs0d0(84,10,VRR(1,1,6),VRR(1,1,7))
            ! Generating (s0|d0)^(5)
            CALL VRRs0d0(84,10,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|d0)^(4)
            CALL VRRs0d0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|d0)^(3)
            CALL VRRs0d0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|d0)^(2)
            CALL VRRs0d0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|d0)^(1)
            CALL VRRs0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|d0)^(0)
            CALL VRRs0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|d0)^(5)
            CALL VRRp0d0(84,10,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|d0)^(4)
            CALL VRRp0d0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|d0)^(3)
            CALL VRRp0d0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|d0)^(2)
            CALL VRRp0d0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|d0)^(1)
            CALL VRRp0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|d0)^(0)
            CALL VRRp0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|d0)^(4)
            CALL VRRd0d0(84,10,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|d0)^(3)
            CALL VRRd0d0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|d0)^(2)
            CALL VRRd0d0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|d0)^(1)
            CALL VRRd0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|d0)^(0)
            CALL VRRd0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|d0)^(3)
            CALL VRRf0d0(84,10,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|d0)^(2)
            CALL VRRf0d0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|d0)^(1)
            CALL VRRf0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|d0)^(0)
            CALL VRRf0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|d0)^(2)
            CALL VRRg0d0(84,10,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|d0)^(1)
            CALL VRRg0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|d0)^(0)
            CALL VRRg0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|d0)^(1)
            CALL VRRh0d0(84,10,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|d0)^(0)
            CALL VRRh0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|d0)^(0)
            CALL VRRi0d0(84,10,VRR(1,1,0),VRR(1,1,1))
            ! Contracting ...
            CALL CNTRCT101022(VRR,HRR)
         ENDDO ! (M0| loop
      ENDDO ! |N0) loop
      ! Generating (f,0|sp,sp)^(0)
      CALL KetHRR22(84,HRR)
      ! Generating (f,f|sp,sp)^(0)
      DO L=1,4
         DO K=1,4
            CDOffSet=(OC+K-1)*LDC+(OD+L-1)*LDD
            CALL BraHRR1010(OA,OB,LDA,LDB,CDOffSet,HRR(1,K,L),INTGRL)
          ENDDO
      ENDDO
    END SUBROUTINE IntB10100202
    SUBROUTINE CNTRCT101022(VRR,HRR)
      USE DerivedTypes
      USE VScratchB
      REAL(DOUBLE)  :: VRR(84,10,0:8)
      REAL(DOUBLE)  :: HRR(84,18,4)
      HRR(1,1,1)=HRR(1,1,1)+VRR(1,1,0)
      HRR(1,11,1)=HRR(1,11,1)+SpSpK*VRR(1,1,0)
      HRR(1,15,1)=HRR(1,15,1)+SpFnK*VRR(1,1,0)
      HRR(1,2,1)=HRR(1,2,1)+VRR(1,2,0)
      HRR(1,12,1)=HRR(1,12,1)+FnSpK*VRR(1,2,0)
      HRR(1,16,1)=HRR(1,16,1)+SpFnK*VRR(1,2,0)
      HRR(1,3,1)=HRR(1,3,1)+VRR(1,3,0)
      HRR(1,13,1)=HRR(1,13,1)+FnSpK*VRR(1,3,0)
      HRR(1,17,1)=HRR(1,17,1)+SpFnK*VRR(1,3,0)
      HRR(1,4,1)=HRR(1,4,1)+VRR(1,4,0)
      HRR(1,14,1)=HRR(1,14,1)+FnSpK*VRR(1,4,0)
      HRR(1,18,1)=HRR(1,18,1)+SpFnK*VRR(1,4,0)
      HRR(1,5,1)=HRR(1,5,1)+VRR(1,5,0)
      HRR(1,6,1)=HRR(1,6,1)+VRR(1,6,0)
      HRR(1,7,1)=HRR(1,7,1)+VRR(1,7,0)
      HRR(1,8,1)=HRR(1,8,1)+VRR(1,8,0)
      HRR(1,9,1)=HRR(1,9,1)+VRR(1,9,0)
      HRR(1,10,1)=HRR(1,10,1)+VRR(1,10,0)
      HRR(2,1,1)=HRR(2,1,1)+VRR(2,1,0)
      HRR(2,11,1)=HRR(2,11,1)+SpSpK*VRR(2,1,0)
      HRR(2,15,1)=HRR(2,15,1)+SpFnK*VRR(2,1,0)
      HRR(2,2,1)=HRR(2,2,1)+VRR(2,2,0)
      HRR(2,12,1)=HRR(2,12,1)+FnSpK*VRR(2,2,0)
      HRR(2,16,1)=HRR(2,16,1)+SpFnK*VRR(2,2,0)
      HRR(2,3,1)=HRR(2,3,1)+VRR(2,3,0)
      HRR(2,13,1)=HRR(2,13,1)+FnSpK*VRR(2,3,0)
      HRR(2,17,1)=HRR(2,17,1)+SpFnK*VRR(2,3,0)
      HRR(2,4,1)=HRR(2,4,1)+VRR(2,4,0)
      HRR(2,14,1)=HRR(2,14,1)+FnSpK*VRR(2,4,0)
      HRR(2,18,1)=HRR(2,18,1)+SpFnK*VRR(2,4,0)
      HRR(2,5,1)=HRR(2,5,1)+VRR(2,5,0)
      HRR(2,6,1)=HRR(2,6,1)+VRR(2,6,0)
      HRR(2,7,1)=HRR(2,7,1)+VRR(2,7,0)
      HRR(2,8,1)=HRR(2,8,1)+VRR(2,8,0)
      HRR(2,9,1)=HRR(2,9,1)+VRR(2,9,0)
      HRR(2,10,1)=HRR(2,10,1)+VRR(2,10,0)
      HRR(3,1,1)=HRR(3,1,1)+VRR(3,1,0)
      HRR(3,11,1)=HRR(3,11,1)+SpSpK*VRR(3,1,0)
      HRR(3,15,1)=HRR(3,15,1)+SpFnK*VRR(3,1,0)
      HRR(3,2,1)=HRR(3,2,1)+VRR(3,2,0)
      HRR(3,12,1)=HRR(3,12,1)+FnSpK*VRR(3,2,0)
      HRR(3,16,1)=HRR(3,16,1)+SpFnK*VRR(3,2,0)
      HRR(3,3,1)=HRR(3,3,1)+VRR(3,3,0)
      HRR(3,13,1)=HRR(3,13,1)+FnSpK*VRR(3,3,0)
      HRR(3,17,1)=HRR(3,17,1)+SpFnK*VRR(3,3,0)
      HRR(3,4,1)=HRR(3,4,1)+VRR(3,4,0)
      HRR(3,14,1)=HRR(3,14,1)+FnSpK*VRR(3,4,0)
      HRR(3,18,1)=HRR(3,18,1)+SpFnK*VRR(3,4,0)
      HRR(3,5,1)=HRR(3,5,1)+VRR(3,5,0)
      HRR(3,6,1)=HRR(3,6,1)+VRR(3,6,0)
      HRR(3,7,1)=HRR(3,7,1)+VRR(3,7,0)
      HRR(3,8,1)=HRR(3,8,1)+VRR(3,8,0)
      HRR(3,9,1)=HRR(3,9,1)+VRR(3,9,0)
      HRR(3,10,1)=HRR(3,10,1)+VRR(3,10,0)
      HRR(4,1,1)=HRR(4,1,1)+VRR(4,1,0)
      HRR(4,11,1)=HRR(4,11,1)+SpSpK*VRR(4,1,0)
      HRR(4,15,1)=HRR(4,15,1)+SpFnK*VRR(4,1,0)
      HRR(4,2,1)=HRR(4,2,1)+VRR(4,2,0)
      HRR(4,12,1)=HRR(4,12,1)+FnSpK*VRR(4,2,0)
      HRR(4,16,1)=HRR(4,16,1)+SpFnK*VRR(4,2,0)
      HRR(4,3,1)=HRR(4,3,1)+VRR(4,3,0)
      HRR(4,13,1)=HRR(4,13,1)+FnSpK*VRR(4,3,0)
      HRR(4,17,1)=HRR(4,17,1)+SpFnK*VRR(4,3,0)
      HRR(4,4,1)=HRR(4,4,1)+VRR(4,4,0)
      HRR(4,14,1)=HRR(4,14,1)+FnSpK*VRR(4,4,0)
      HRR(4,18,1)=HRR(4,18,1)+SpFnK*VRR(4,4,0)
      HRR(4,5,1)=HRR(4,5,1)+VRR(4,5,0)
      HRR(4,6,1)=HRR(4,6,1)+VRR(4,6,0)
      HRR(4,7,1)=HRR(4,7,1)+VRR(4,7,0)
      HRR(4,8,1)=HRR(4,8,1)+VRR(4,8,0)
      HRR(4,9,1)=HRR(4,9,1)+VRR(4,9,0)
      HRR(4,10,1)=HRR(4,10,1)+VRR(4,10,0)
      HRR(5,1,1)=HRR(5,1,1)+VRR(5,1,0)
      HRR(5,11,1)=HRR(5,11,1)+SpSpK*VRR(5,1,0)
      HRR(5,15,1)=HRR(5,15,1)+SpFnK*VRR(5,1,0)
      HRR(5,2,1)=HRR(5,2,1)+VRR(5,2,0)
      HRR(5,12,1)=HRR(5,12,1)+FnSpK*VRR(5,2,0)
      HRR(5,16,1)=HRR(5,16,1)+SpFnK*VRR(5,2,0)
      HRR(5,3,1)=HRR(5,3,1)+VRR(5,3,0)
      HRR(5,13,1)=HRR(5,13,1)+FnSpK*VRR(5,3,0)
      HRR(5,17,1)=HRR(5,17,1)+SpFnK*VRR(5,3,0)
      HRR(5,4,1)=HRR(5,4,1)+VRR(5,4,0)
      HRR(5,14,1)=HRR(5,14,1)+FnSpK*VRR(5,4,0)
      HRR(5,18,1)=HRR(5,18,1)+SpFnK*VRR(5,4,0)
      HRR(5,5,1)=HRR(5,5,1)+VRR(5,5,0)
      HRR(5,6,1)=HRR(5,6,1)+VRR(5,6,0)
      HRR(5,7,1)=HRR(5,7,1)+VRR(5,7,0)
      HRR(5,8,1)=HRR(5,8,1)+VRR(5,8,0)
      HRR(5,9,1)=HRR(5,9,1)+VRR(5,9,0)
      HRR(5,10,1)=HRR(5,10,1)+VRR(5,10,0)
      HRR(6,1,1)=HRR(6,1,1)+VRR(6,1,0)
      HRR(6,11,1)=HRR(6,11,1)+SpSpK*VRR(6,1,0)
      HRR(6,15,1)=HRR(6,15,1)+SpFnK*VRR(6,1,0)
      HRR(6,2,1)=HRR(6,2,1)+VRR(6,2,0)
      HRR(6,12,1)=HRR(6,12,1)+FnSpK*VRR(6,2,0)
      HRR(6,16,1)=HRR(6,16,1)+SpFnK*VRR(6,2,0)
      HRR(6,3,1)=HRR(6,3,1)+VRR(6,3,0)
      HRR(6,13,1)=HRR(6,13,1)+FnSpK*VRR(6,3,0)
      HRR(6,17,1)=HRR(6,17,1)+SpFnK*VRR(6,3,0)
      HRR(6,4,1)=HRR(6,4,1)+VRR(6,4,0)
      HRR(6,14,1)=HRR(6,14,1)+FnSpK*VRR(6,4,0)
      HRR(6,18,1)=HRR(6,18,1)+SpFnK*VRR(6,4,0)
      HRR(6,5,1)=HRR(6,5,1)+VRR(6,5,0)
      HRR(6,6,1)=HRR(6,6,1)+VRR(6,6,0)
      HRR(6,7,1)=HRR(6,7,1)+VRR(6,7,0)
      HRR(6,8,1)=HRR(6,8,1)+VRR(6,8,0)
      HRR(6,9,1)=HRR(6,9,1)+VRR(6,9,0)
      HRR(6,10,1)=HRR(6,10,1)+VRR(6,10,0)
      HRR(7,1,1)=HRR(7,1,1)+VRR(7,1,0)
      HRR(7,11,1)=HRR(7,11,1)+SpSpK*VRR(7,1,0)
      HRR(7,15,1)=HRR(7,15,1)+SpFnK*VRR(7,1,0)
      HRR(7,2,1)=HRR(7,2,1)+VRR(7,2,0)
      HRR(7,12,1)=HRR(7,12,1)+FnSpK*VRR(7,2,0)
      HRR(7,16,1)=HRR(7,16,1)+SpFnK*VRR(7,2,0)
      HRR(7,3,1)=HRR(7,3,1)+VRR(7,3,0)
      HRR(7,13,1)=HRR(7,13,1)+FnSpK*VRR(7,3,0)
      HRR(7,17,1)=HRR(7,17,1)+SpFnK*VRR(7,3,0)
      HRR(7,4,1)=HRR(7,4,1)+VRR(7,4,0)
      HRR(7,14,1)=HRR(7,14,1)+FnSpK*VRR(7,4,0)
      HRR(7,18,1)=HRR(7,18,1)+SpFnK*VRR(7,4,0)
      HRR(7,5,1)=HRR(7,5,1)+VRR(7,5,0)
      HRR(7,6,1)=HRR(7,6,1)+VRR(7,6,0)
      HRR(7,7,1)=HRR(7,7,1)+VRR(7,7,0)
      HRR(7,8,1)=HRR(7,8,1)+VRR(7,8,0)
      HRR(7,9,1)=HRR(7,9,1)+VRR(7,9,0)
      HRR(7,10,1)=HRR(7,10,1)+VRR(7,10,0)
      HRR(8,1,1)=HRR(8,1,1)+VRR(8,1,0)
      HRR(8,11,1)=HRR(8,11,1)+SpSpK*VRR(8,1,0)
      HRR(8,15,1)=HRR(8,15,1)+SpFnK*VRR(8,1,0)
      HRR(8,2,1)=HRR(8,2,1)+VRR(8,2,0)
      HRR(8,12,1)=HRR(8,12,1)+FnSpK*VRR(8,2,0)
      HRR(8,16,1)=HRR(8,16,1)+SpFnK*VRR(8,2,0)
      HRR(8,3,1)=HRR(8,3,1)+VRR(8,3,0)
      HRR(8,13,1)=HRR(8,13,1)+FnSpK*VRR(8,3,0)
      HRR(8,17,1)=HRR(8,17,1)+SpFnK*VRR(8,3,0)
      HRR(8,4,1)=HRR(8,4,1)+VRR(8,4,0)
      HRR(8,14,1)=HRR(8,14,1)+FnSpK*VRR(8,4,0)
      HRR(8,18,1)=HRR(8,18,1)+SpFnK*VRR(8,4,0)
      HRR(8,5,1)=HRR(8,5,1)+VRR(8,5,0)
      HRR(8,6,1)=HRR(8,6,1)+VRR(8,6,0)
      HRR(8,7,1)=HRR(8,7,1)+VRR(8,7,0)
      HRR(8,8,1)=HRR(8,8,1)+VRR(8,8,0)
      HRR(8,9,1)=HRR(8,9,1)+VRR(8,9,0)
      HRR(8,10,1)=HRR(8,10,1)+VRR(8,10,0)
      HRR(9,1,1)=HRR(9,1,1)+VRR(9,1,0)
      HRR(9,11,1)=HRR(9,11,1)+SpSpK*VRR(9,1,0)
      HRR(9,15,1)=HRR(9,15,1)+SpFnK*VRR(9,1,0)
      HRR(9,2,1)=HRR(9,2,1)+VRR(9,2,0)
      HRR(9,12,1)=HRR(9,12,1)+FnSpK*VRR(9,2,0)
      HRR(9,16,1)=HRR(9,16,1)+SpFnK*VRR(9,2,0)
      HRR(9,3,1)=HRR(9,3,1)+VRR(9,3,0)
      HRR(9,13,1)=HRR(9,13,1)+FnSpK*VRR(9,3,0)
      HRR(9,17,1)=HRR(9,17,1)+SpFnK*VRR(9,3,0)
      HRR(9,4,1)=HRR(9,4,1)+VRR(9,4,0)
      HRR(9,14,1)=HRR(9,14,1)+FnSpK*VRR(9,4,0)
      HRR(9,18,1)=HRR(9,18,1)+SpFnK*VRR(9,4,0)
      HRR(9,5,1)=HRR(9,5,1)+VRR(9,5,0)
      HRR(9,6,1)=HRR(9,6,1)+VRR(9,6,0)
      HRR(9,7,1)=HRR(9,7,1)+VRR(9,7,0)
      HRR(9,8,1)=HRR(9,8,1)+VRR(9,8,0)
      HRR(9,9,1)=HRR(9,9,1)+VRR(9,9,0)
      HRR(9,10,1)=HRR(9,10,1)+VRR(9,10,0)
      HRR(10,1,1)=HRR(10,1,1)+VRR(10,1,0)
      HRR(10,11,1)=HRR(10,11,1)+SpSpK*VRR(10,1,0)
      HRR(10,15,1)=HRR(10,15,1)+SpFnK*VRR(10,1,0)
      HRR(10,2,1)=HRR(10,2,1)+VRR(10,2,0)
      HRR(10,12,1)=HRR(10,12,1)+FnSpK*VRR(10,2,0)
      HRR(10,16,1)=HRR(10,16,1)+SpFnK*VRR(10,2,0)
      HRR(10,3,1)=HRR(10,3,1)+VRR(10,3,0)
      HRR(10,13,1)=HRR(10,13,1)+FnSpK*VRR(10,3,0)
      HRR(10,17,1)=HRR(10,17,1)+SpFnK*VRR(10,3,0)
      HRR(10,4,1)=HRR(10,4,1)+VRR(10,4,0)
      HRR(10,14,1)=HRR(10,14,1)+FnSpK*VRR(10,4,0)
      HRR(10,18,1)=HRR(10,18,1)+SpFnK*VRR(10,4,0)
      HRR(10,5,1)=HRR(10,5,1)+VRR(10,5,0)
      HRR(10,6,1)=HRR(10,6,1)+VRR(10,6,0)
      HRR(10,7,1)=HRR(10,7,1)+VRR(10,7,0)
      HRR(10,8,1)=HRR(10,8,1)+VRR(10,8,0)
      HRR(10,9,1)=HRR(10,9,1)+VRR(10,9,0)
      HRR(10,10,1)=HRR(10,10,1)+VRR(10,10,0)
      HRR(11,1,1)=HRR(11,1,1)+VRR(11,1,0)
      HRR(11,11,1)=HRR(11,11,1)+SpSpK*VRR(11,1,0)
      HRR(11,15,1)=HRR(11,15,1)+SpFnK*VRR(11,1,0)
      HRR(11,2,1)=HRR(11,2,1)+VRR(11,2,0)
      HRR(11,12,1)=HRR(11,12,1)+FnSpK*VRR(11,2,0)
      HRR(11,16,1)=HRR(11,16,1)+SpFnK*VRR(11,2,0)
      HRR(11,3,1)=HRR(11,3,1)+VRR(11,3,0)
      HRR(11,13,1)=HRR(11,13,1)+FnSpK*VRR(11,3,0)
      HRR(11,17,1)=HRR(11,17,1)+SpFnK*VRR(11,3,0)
      HRR(11,4,1)=HRR(11,4,1)+VRR(11,4,0)
      HRR(11,14,1)=HRR(11,14,1)+FnSpK*VRR(11,4,0)
      HRR(11,18,1)=HRR(11,18,1)+SpFnK*VRR(11,4,0)
      HRR(11,5,1)=HRR(11,5,1)+VRR(11,5,0)
      HRR(11,6,1)=HRR(11,6,1)+VRR(11,6,0)
      HRR(11,7,1)=HRR(11,7,1)+VRR(11,7,0)
      HRR(11,8,1)=HRR(11,8,1)+VRR(11,8,0)
      HRR(11,9,1)=HRR(11,9,1)+VRR(11,9,0)
      HRR(11,10,1)=HRR(11,10,1)+VRR(11,10,0)
      HRR(12,1,1)=HRR(12,1,1)+VRR(12,1,0)
      HRR(12,11,1)=HRR(12,11,1)+SpSpK*VRR(12,1,0)
      HRR(12,15,1)=HRR(12,15,1)+SpFnK*VRR(12,1,0)
      HRR(12,2,1)=HRR(12,2,1)+VRR(12,2,0)
      HRR(12,12,1)=HRR(12,12,1)+FnSpK*VRR(12,2,0)
      HRR(12,16,1)=HRR(12,16,1)+SpFnK*VRR(12,2,0)
      HRR(12,3,1)=HRR(12,3,1)+VRR(12,3,0)
      HRR(12,13,1)=HRR(12,13,1)+FnSpK*VRR(12,3,0)
      HRR(12,17,1)=HRR(12,17,1)+SpFnK*VRR(12,3,0)
      HRR(12,4,1)=HRR(12,4,1)+VRR(12,4,0)
      HRR(12,14,1)=HRR(12,14,1)+FnSpK*VRR(12,4,0)
      HRR(12,18,1)=HRR(12,18,1)+SpFnK*VRR(12,4,0)
      HRR(12,5,1)=HRR(12,5,1)+VRR(12,5,0)
      HRR(12,6,1)=HRR(12,6,1)+VRR(12,6,0)
      HRR(12,7,1)=HRR(12,7,1)+VRR(12,7,0)
      HRR(12,8,1)=HRR(12,8,1)+VRR(12,8,0)
      HRR(12,9,1)=HRR(12,9,1)+VRR(12,9,0)
      HRR(12,10,1)=HRR(12,10,1)+VRR(12,10,0)
      HRR(13,1,1)=HRR(13,1,1)+VRR(13,1,0)
      HRR(13,11,1)=HRR(13,11,1)+SpSpK*VRR(13,1,0)
      HRR(13,15,1)=HRR(13,15,1)+SpFnK*VRR(13,1,0)
      HRR(13,2,1)=HRR(13,2,1)+VRR(13,2,0)
      HRR(13,12,1)=HRR(13,12,1)+FnSpK*VRR(13,2,0)
      HRR(13,16,1)=HRR(13,16,1)+SpFnK*VRR(13,2,0)
      HRR(13,3,1)=HRR(13,3,1)+VRR(13,3,0)
      HRR(13,13,1)=HRR(13,13,1)+FnSpK*VRR(13,3,0)
      HRR(13,17,1)=HRR(13,17,1)+SpFnK*VRR(13,3,0)
      HRR(13,4,1)=HRR(13,4,1)+VRR(13,4,0)
      HRR(13,14,1)=HRR(13,14,1)+FnSpK*VRR(13,4,0)
      HRR(13,18,1)=HRR(13,18,1)+SpFnK*VRR(13,4,0)
      HRR(13,5,1)=HRR(13,5,1)+VRR(13,5,0)
      HRR(13,6,1)=HRR(13,6,1)+VRR(13,6,0)
      HRR(13,7,1)=HRR(13,7,1)+VRR(13,7,0)
      HRR(13,8,1)=HRR(13,8,1)+VRR(13,8,0)
      HRR(13,9,1)=HRR(13,9,1)+VRR(13,9,0)
      HRR(13,10,1)=HRR(13,10,1)+VRR(13,10,0)
      HRR(14,1,1)=HRR(14,1,1)+VRR(14,1,0)
      HRR(14,11,1)=HRR(14,11,1)+SpSpK*VRR(14,1,0)
      HRR(14,15,1)=HRR(14,15,1)+SpFnK*VRR(14,1,0)
      HRR(14,2,1)=HRR(14,2,1)+VRR(14,2,0)
      HRR(14,12,1)=HRR(14,12,1)+FnSpK*VRR(14,2,0)
      HRR(14,16,1)=HRR(14,16,1)+SpFnK*VRR(14,2,0)
      HRR(14,3,1)=HRR(14,3,1)+VRR(14,3,0)
      HRR(14,13,1)=HRR(14,13,1)+FnSpK*VRR(14,3,0)
      HRR(14,17,1)=HRR(14,17,1)+SpFnK*VRR(14,3,0)
      HRR(14,4,1)=HRR(14,4,1)+VRR(14,4,0)
      HRR(14,14,1)=HRR(14,14,1)+FnSpK*VRR(14,4,0)
      HRR(14,18,1)=HRR(14,18,1)+SpFnK*VRR(14,4,0)
      HRR(14,5,1)=HRR(14,5,1)+VRR(14,5,0)
      HRR(14,6,1)=HRR(14,6,1)+VRR(14,6,0)
      HRR(14,7,1)=HRR(14,7,1)+VRR(14,7,0)
      HRR(14,8,1)=HRR(14,8,1)+VRR(14,8,0)
      HRR(14,9,1)=HRR(14,9,1)+VRR(14,9,0)
      HRR(14,10,1)=HRR(14,10,1)+VRR(14,10,0)
      HRR(15,1,1)=HRR(15,1,1)+VRR(15,1,0)
      HRR(15,11,1)=HRR(15,11,1)+SpSpK*VRR(15,1,0)
      HRR(15,15,1)=HRR(15,15,1)+SpFnK*VRR(15,1,0)
      HRR(15,2,1)=HRR(15,2,1)+VRR(15,2,0)
      HRR(15,12,1)=HRR(15,12,1)+FnSpK*VRR(15,2,0)
      HRR(15,16,1)=HRR(15,16,1)+SpFnK*VRR(15,2,0)
      HRR(15,3,1)=HRR(15,3,1)+VRR(15,3,0)
      HRR(15,13,1)=HRR(15,13,1)+FnSpK*VRR(15,3,0)
      HRR(15,17,1)=HRR(15,17,1)+SpFnK*VRR(15,3,0)
      HRR(15,4,1)=HRR(15,4,1)+VRR(15,4,0)
      HRR(15,14,1)=HRR(15,14,1)+FnSpK*VRR(15,4,0)
      HRR(15,18,1)=HRR(15,18,1)+SpFnK*VRR(15,4,0)
      HRR(15,5,1)=HRR(15,5,1)+VRR(15,5,0)
      HRR(15,6,1)=HRR(15,6,1)+VRR(15,6,0)
      HRR(15,7,1)=HRR(15,7,1)+VRR(15,7,0)
      HRR(15,8,1)=HRR(15,8,1)+VRR(15,8,0)
      HRR(15,9,1)=HRR(15,9,1)+VRR(15,9,0)
      HRR(15,10,1)=HRR(15,10,1)+VRR(15,10,0)
      HRR(16,1,1)=HRR(16,1,1)+VRR(16,1,0)
      HRR(16,11,1)=HRR(16,11,1)+SpSpK*VRR(16,1,0)
      HRR(16,15,1)=HRR(16,15,1)+SpFnK*VRR(16,1,0)
      HRR(16,2,1)=HRR(16,2,1)+VRR(16,2,0)
      HRR(16,12,1)=HRR(16,12,1)+FnSpK*VRR(16,2,0)
      HRR(16,16,1)=HRR(16,16,1)+SpFnK*VRR(16,2,0)
      HRR(16,3,1)=HRR(16,3,1)+VRR(16,3,0)
      HRR(16,13,1)=HRR(16,13,1)+FnSpK*VRR(16,3,0)
      HRR(16,17,1)=HRR(16,17,1)+SpFnK*VRR(16,3,0)
      HRR(16,4,1)=HRR(16,4,1)+VRR(16,4,0)
      HRR(16,14,1)=HRR(16,14,1)+FnSpK*VRR(16,4,0)
      HRR(16,18,1)=HRR(16,18,1)+SpFnK*VRR(16,4,0)
      HRR(16,5,1)=HRR(16,5,1)+VRR(16,5,0)
      HRR(16,6,1)=HRR(16,6,1)+VRR(16,6,0)
      HRR(16,7,1)=HRR(16,7,1)+VRR(16,7,0)
      HRR(16,8,1)=HRR(16,8,1)+VRR(16,8,0)
      HRR(16,9,1)=HRR(16,9,1)+VRR(16,9,0)
      HRR(16,10,1)=HRR(16,10,1)+VRR(16,10,0)
      HRR(17,1,1)=HRR(17,1,1)+VRR(17,1,0)
      HRR(17,11,1)=HRR(17,11,1)+SpSpK*VRR(17,1,0)
      HRR(17,15,1)=HRR(17,15,1)+SpFnK*VRR(17,1,0)
      HRR(17,2,1)=HRR(17,2,1)+VRR(17,2,0)
      HRR(17,12,1)=HRR(17,12,1)+FnSpK*VRR(17,2,0)
      HRR(17,16,1)=HRR(17,16,1)+SpFnK*VRR(17,2,0)
      HRR(17,3,1)=HRR(17,3,1)+VRR(17,3,0)
      HRR(17,13,1)=HRR(17,13,1)+FnSpK*VRR(17,3,0)
      HRR(17,17,1)=HRR(17,17,1)+SpFnK*VRR(17,3,0)
      HRR(17,4,1)=HRR(17,4,1)+VRR(17,4,0)
      HRR(17,14,1)=HRR(17,14,1)+FnSpK*VRR(17,4,0)
      HRR(17,18,1)=HRR(17,18,1)+SpFnK*VRR(17,4,0)
      HRR(17,5,1)=HRR(17,5,1)+VRR(17,5,0)
      HRR(17,6,1)=HRR(17,6,1)+VRR(17,6,0)
      HRR(17,7,1)=HRR(17,7,1)+VRR(17,7,0)
      HRR(17,8,1)=HRR(17,8,1)+VRR(17,8,0)
      HRR(17,9,1)=HRR(17,9,1)+VRR(17,9,0)
      HRR(17,10,1)=HRR(17,10,1)+VRR(17,10,0)
      HRR(18,1,1)=HRR(18,1,1)+VRR(18,1,0)
      HRR(18,11,1)=HRR(18,11,1)+SpSpK*VRR(18,1,0)
      HRR(18,15,1)=HRR(18,15,1)+SpFnK*VRR(18,1,0)
      HRR(18,2,1)=HRR(18,2,1)+VRR(18,2,0)
      HRR(18,12,1)=HRR(18,12,1)+FnSpK*VRR(18,2,0)
      HRR(18,16,1)=HRR(18,16,1)+SpFnK*VRR(18,2,0)
      HRR(18,3,1)=HRR(18,3,1)+VRR(18,3,0)
      HRR(18,13,1)=HRR(18,13,1)+FnSpK*VRR(18,3,0)
      HRR(18,17,1)=HRR(18,17,1)+SpFnK*VRR(18,3,0)
      HRR(18,4,1)=HRR(18,4,1)+VRR(18,4,0)
      HRR(18,14,1)=HRR(18,14,1)+FnSpK*VRR(18,4,0)
      HRR(18,18,1)=HRR(18,18,1)+SpFnK*VRR(18,4,0)
      HRR(18,5,1)=HRR(18,5,1)+VRR(18,5,0)
      HRR(18,6,1)=HRR(18,6,1)+VRR(18,6,0)
      HRR(18,7,1)=HRR(18,7,1)+VRR(18,7,0)
      HRR(18,8,1)=HRR(18,8,1)+VRR(18,8,0)
      HRR(18,9,1)=HRR(18,9,1)+VRR(18,9,0)
      HRR(18,10,1)=HRR(18,10,1)+VRR(18,10,0)
      HRR(19,1,1)=HRR(19,1,1)+VRR(19,1,0)
      HRR(19,11,1)=HRR(19,11,1)+SpSpK*VRR(19,1,0)
      HRR(19,15,1)=HRR(19,15,1)+SpFnK*VRR(19,1,0)
      HRR(19,2,1)=HRR(19,2,1)+VRR(19,2,0)
      HRR(19,12,1)=HRR(19,12,1)+FnSpK*VRR(19,2,0)
      HRR(19,16,1)=HRR(19,16,1)+SpFnK*VRR(19,2,0)
      HRR(19,3,1)=HRR(19,3,1)+VRR(19,3,0)
      HRR(19,13,1)=HRR(19,13,1)+FnSpK*VRR(19,3,0)
      HRR(19,17,1)=HRR(19,17,1)+SpFnK*VRR(19,3,0)
      HRR(19,4,1)=HRR(19,4,1)+VRR(19,4,0)
      HRR(19,14,1)=HRR(19,14,1)+FnSpK*VRR(19,4,0)
      HRR(19,18,1)=HRR(19,18,1)+SpFnK*VRR(19,4,0)
      HRR(19,5,1)=HRR(19,5,1)+VRR(19,5,0)
      HRR(19,6,1)=HRR(19,6,1)+VRR(19,6,0)
      HRR(19,7,1)=HRR(19,7,1)+VRR(19,7,0)
      HRR(19,8,1)=HRR(19,8,1)+VRR(19,8,0)
      HRR(19,9,1)=HRR(19,9,1)+VRR(19,9,0)
      HRR(19,10,1)=HRR(19,10,1)+VRR(19,10,0)
      HRR(20,1,1)=HRR(20,1,1)+VRR(20,1,0)
      HRR(20,11,1)=HRR(20,11,1)+SpSpK*VRR(20,1,0)
      HRR(20,15,1)=HRR(20,15,1)+SpFnK*VRR(20,1,0)
      HRR(20,2,1)=HRR(20,2,1)+VRR(20,2,0)
      HRR(20,12,1)=HRR(20,12,1)+FnSpK*VRR(20,2,0)
      HRR(20,16,1)=HRR(20,16,1)+SpFnK*VRR(20,2,0)
      HRR(20,3,1)=HRR(20,3,1)+VRR(20,3,0)
      HRR(20,13,1)=HRR(20,13,1)+FnSpK*VRR(20,3,0)
      HRR(20,17,1)=HRR(20,17,1)+SpFnK*VRR(20,3,0)
      HRR(20,4,1)=HRR(20,4,1)+VRR(20,4,0)
      HRR(20,14,1)=HRR(20,14,1)+FnSpK*VRR(20,4,0)
      HRR(20,18,1)=HRR(20,18,1)+SpFnK*VRR(20,4,0)
      HRR(20,5,1)=HRR(20,5,1)+VRR(20,5,0)
      HRR(20,6,1)=HRR(20,6,1)+VRR(20,6,0)
      HRR(20,7,1)=HRR(20,7,1)+VRR(20,7,0)
      HRR(20,8,1)=HRR(20,8,1)+VRR(20,8,0)
      HRR(20,9,1)=HRR(20,9,1)+VRR(20,9,0)
      HRR(20,10,1)=HRR(20,10,1)+VRR(20,10,0)
      HRR(21,1,1)=HRR(21,1,1)+VRR(21,1,0)
      HRR(21,11,1)=HRR(21,11,1)+SpSpK*VRR(21,1,0)
      HRR(21,15,1)=HRR(21,15,1)+SpFnK*VRR(21,1,0)
      HRR(21,2,1)=HRR(21,2,1)+VRR(21,2,0)
      HRR(21,12,1)=HRR(21,12,1)+FnSpK*VRR(21,2,0)
      HRR(21,16,1)=HRR(21,16,1)+SpFnK*VRR(21,2,0)
      HRR(21,3,1)=HRR(21,3,1)+VRR(21,3,0)
      HRR(21,13,1)=HRR(21,13,1)+FnSpK*VRR(21,3,0)
      HRR(21,17,1)=HRR(21,17,1)+SpFnK*VRR(21,3,0)
      HRR(21,4,1)=HRR(21,4,1)+VRR(21,4,0)
      HRR(21,14,1)=HRR(21,14,1)+FnSpK*VRR(21,4,0)
      HRR(21,18,1)=HRR(21,18,1)+SpFnK*VRR(21,4,0)
      HRR(21,5,1)=HRR(21,5,1)+VRR(21,5,0)
      HRR(21,6,1)=HRR(21,6,1)+VRR(21,6,0)
      HRR(21,7,1)=HRR(21,7,1)+VRR(21,7,0)
      HRR(21,8,1)=HRR(21,8,1)+VRR(21,8,0)
      HRR(21,9,1)=HRR(21,9,1)+VRR(21,9,0)
      HRR(21,10,1)=HRR(21,10,1)+VRR(21,10,0)
      HRR(22,1,1)=HRR(22,1,1)+VRR(22,1,0)
      HRR(22,11,1)=HRR(22,11,1)+SpSpK*VRR(22,1,0)
      HRR(22,15,1)=HRR(22,15,1)+SpFnK*VRR(22,1,0)
      HRR(22,2,1)=HRR(22,2,1)+VRR(22,2,0)
      HRR(22,12,1)=HRR(22,12,1)+FnSpK*VRR(22,2,0)
      HRR(22,16,1)=HRR(22,16,1)+SpFnK*VRR(22,2,0)
      HRR(22,3,1)=HRR(22,3,1)+VRR(22,3,0)
      HRR(22,13,1)=HRR(22,13,1)+FnSpK*VRR(22,3,0)
      HRR(22,17,1)=HRR(22,17,1)+SpFnK*VRR(22,3,0)
      HRR(22,4,1)=HRR(22,4,1)+VRR(22,4,0)
      HRR(22,14,1)=HRR(22,14,1)+FnSpK*VRR(22,4,0)
      HRR(22,18,1)=HRR(22,18,1)+SpFnK*VRR(22,4,0)
      HRR(22,5,1)=HRR(22,5,1)+VRR(22,5,0)
      HRR(22,6,1)=HRR(22,6,1)+VRR(22,6,0)
      HRR(22,7,1)=HRR(22,7,1)+VRR(22,7,0)
      HRR(22,8,1)=HRR(22,8,1)+VRR(22,8,0)
      HRR(22,9,1)=HRR(22,9,1)+VRR(22,9,0)
      HRR(22,10,1)=HRR(22,10,1)+VRR(22,10,0)
      HRR(23,1,1)=HRR(23,1,1)+VRR(23,1,0)
      HRR(23,11,1)=HRR(23,11,1)+SpSpK*VRR(23,1,0)
      HRR(23,15,1)=HRR(23,15,1)+SpFnK*VRR(23,1,0)
      HRR(23,2,1)=HRR(23,2,1)+VRR(23,2,0)
      HRR(23,12,1)=HRR(23,12,1)+FnSpK*VRR(23,2,0)
      HRR(23,16,1)=HRR(23,16,1)+SpFnK*VRR(23,2,0)
      HRR(23,3,1)=HRR(23,3,1)+VRR(23,3,0)
      HRR(23,13,1)=HRR(23,13,1)+FnSpK*VRR(23,3,0)
      HRR(23,17,1)=HRR(23,17,1)+SpFnK*VRR(23,3,0)
      HRR(23,4,1)=HRR(23,4,1)+VRR(23,4,0)
      HRR(23,14,1)=HRR(23,14,1)+FnSpK*VRR(23,4,0)
      HRR(23,18,1)=HRR(23,18,1)+SpFnK*VRR(23,4,0)
      HRR(23,5,1)=HRR(23,5,1)+VRR(23,5,0)
      HRR(23,6,1)=HRR(23,6,1)+VRR(23,6,0)
      HRR(23,7,1)=HRR(23,7,1)+VRR(23,7,0)
      HRR(23,8,1)=HRR(23,8,1)+VRR(23,8,0)
      HRR(23,9,1)=HRR(23,9,1)+VRR(23,9,0)
      HRR(23,10,1)=HRR(23,10,1)+VRR(23,10,0)
      HRR(24,1,1)=HRR(24,1,1)+VRR(24,1,0)
      HRR(24,11,1)=HRR(24,11,1)+SpSpK*VRR(24,1,0)
      HRR(24,15,1)=HRR(24,15,1)+SpFnK*VRR(24,1,0)
      HRR(24,2,1)=HRR(24,2,1)+VRR(24,2,0)
      HRR(24,12,1)=HRR(24,12,1)+FnSpK*VRR(24,2,0)
      HRR(24,16,1)=HRR(24,16,1)+SpFnK*VRR(24,2,0)
      HRR(24,3,1)=HRR(24,3,1)+VRR(24,3,0)
      HRR(24,13,1)=HRR(24,13,1)+FnSpK*VRR(24,3,0)
      HRR(24,17,1)=HRR(24,17,1)+SpFnK*VRR(24,3,0)
      HRR(24,4,1)=HRR(24,4,1)+VRR(24,4,0)
      HRR(24,14,1)=HRR(24,14,1)+FnSpK*VRR(24,4,0)
      HRR(24,18,1)=HRR(24,18,1)+SpFnK*VRR(24,4,0)
      HRR(24,5,1)=HRR(24,5,1)+VRR(24,5,0)
      HRR(24,6,1)=HRR(24,6,1)+VRR(24,6,0)
      HRR(24,7,1)=HRR(24,7,1)+VRR(24,7,0)
      HRR(24,8,1)=HRR(24,8,1)+VRR(24,8,0)
      HRR(24,9,1)=HRR(24,9,1)+VRR(24,9,0)
      HRR(24,10,1)=HRR(24,10,1)+VRR(24,10,0)
      HRR(25,1,1)=HRR(25,1,1)+VRR(25,1,0)
      HRR(25,11,1)=HRR(25,11,1)+SpSpK*VRR(25,1,0)
      HRR(25,15,1)=HRR(25,15,1)+SpFnK*VRR(25,1,0)
      HRR(25,2,1)=HRR(25,2,1)+VRR(25,2,0)
      HRR(25,12,1)=HRR(25,12,1)+FnSpK*VRR(25,2,0)
      HRR(25,16,1)=HRR(25,16,1)+SpFnK*VRR(25,2,0)
      HRR(25,3,1)=HRR(25,3,1)+VRR(25,3,0)
      HRR(25,13,1)=HRR(25,13,1)+FnSpK*VRR(25,3,0)
      HRR(25,17,1)=HRR(25,17,1)+SpFnK*VRR(25,3,0)
      HRR(25,4,1)=HRR(25,4,1)+VRR(25,4,0)
      HRR(25,14,1)=HRR(25,14,1)+FnSpK*VRR(25,4,0)
      HRR(25,18,1)=HRR(25,18,1)+SpFnK*VRR(25,4,0)
      HRR(25,5,1)=HRR(25,5,1)+VRR(25,5,0)
      HRR(25,6,1)=HRR(25,6,1)+VRR(25,6,0)
      HRR(25,7,1)=HRR(25,7,1)+VRR(25,7,0)
      HRR(25,8,1)=HRR(25,8,1)+VRR(25,8,0)
      HRR(25,9,1)=HRR(25,9,1)+VRR(25,9,0)
      HRR(25,10,1)=HRR(25,10,1)+VRR(25,10,0)
      HRR(26,1,1)=HRR(26,1,1)+VRR(26,1,0)
      HRR(26,11,1)=HRR(26,11,1)+SpSpK*VRR(26,1,0)
      HRR(26,15,1)=HRR(26,15,1)+SpFnK*VRR(26,1,0)
      HRR(26,2,1)=HRR(26,2,1)+VRR(26,2,0)
      HRR(26,12,1)=HRR(26,12,1)+FnSpK*VRR(26,2,0)
      HRR(26,16,1)=HRR(26,16,1)+SpFnK*VRR(26,2,0)
      HRR(26,3,1)=HRR(26,3,1)+VRR(26,3,0)
      HRR(26,13,1)=HRR(26,13,1)+FnSpK*VRR(26,3,0)
      HRR(26,17,1)=HRR(26,17,1)+SpFnK*VRR(26,3,0)
      HRR(26,4,1)=HRR(26,4,1)+VRR(26,4,0)
      HRR(26,14,1)=HRR(26,14,1)+FnSpK*VRR(26,4,0)
      HRR(26,18,1)=HRR(26,18,1)+SpFnK*VRR(26,4,0)
      HRR(26,5,1)=HRR(26,5,1)+VRR(26,5,0)
      HRR(26,6,1)=HRR(26,6,1)+VRR(26,6,0)
      HRR(26,7,1)=HRR(26,7,1)+VRR(26,7,0)
      HRR(26,8,1)=HRR(26,8,1)+VRR(26,8,0)
      HRR(26,9,1)=HRR(26,9,1)+VRR(26,9,0)
      HRR(26,10,1)=HRR(26,10,1)+VRR(26,10,0)
      HRR(27,1,1)=HRR(27,1,1)+VRR(27,1,0)
      HRR(27,11,1)=HRR(27,11,1)+SpSpK*VRR(27,1,0)
      HRR(27,15,1)=HRR(27,15,1)+SpFnK*VRR(27,1,0)
      HRR(27,2,1)=HRR(27,2,1)+VRR(27,2,0)
      HRR(27,12,1)=HRR(27,12,1)+FnSpK*VRR(27,2,0)
      HRR(27,16,1)=HRR(27,16,1)+SpFnK*VRR(27,2,0)
      HRR(27,3,1)=HRR(27,3,1)+VRR(27,3,0)
      HRR(27,13,1)=HRR(27,13,1)+FnSpK*VRR(27,3,0)
      HRR(27,17,1)=HRR(27,17,1)+SpFnK*VRR(27,3,0)
      HRR(27,4,1)=HRR(27,4,1)+VRR(27,4,0)
      HRR(27,14,1)=HRR(27,14,1)+FnSpK*VRR(27,4,0)
      HRR(27,18,1)=HRR(27,18,1)+SpFnK*VRR(27,4,0)
      HRR(27,5,1)=HRR(27,5,1)+VRR(27,5,0)
      HRR(27,6,1)=HRR(27,6,1)+VRR(27,6,0)
      HRR(27,7,1)=HRR(27,7,1)+VRR(27,7,0)
      HRR(27,8,1)=HRR(27,8,1)+VRR(27,8,0)
      HRR(27,9,1)=HRR(27,9,1)+VRR(27,9,0)
      HRR(27,10,1)=HRR(27,10,1)+VRR(27,10,0)
      HRR(28,1,1)=HRR(28,1,1)+VRR(28,1,0)
      HRR(28,11,1)=HRR(28,11,1)+SpSpK*VRR(28,1,0)
      HRR(28,15,1)=HRR(28,15,1)+SpFnK*VRR(28,1,0)
      HRR(28,2,1)=HRR(28,2,1)+VRR(28,2,0)
      HRR(28,12,1)=HRR(28,12,1)+FnSpK*VRR(28,2,0)
      HRR(28,16,1)=HRR(28,16,1)+SpFnK*VRR(28,2,0)
      HRR(28,3,1)=HRR(28,3,1)+VRR(28,3,0)
      HRR(28,13,1)=HRR(28,13,1)+FnSpK*VRR(28,3,0)
      HRR(28,17,1)=HRR(28,17,1)+SpFnK*VRR(28,3,0)
      HRR(28,4,1)=HRR(28,4,1)+VRR(28,4,0)
      HRR(28,14,1)=HRR(28,14,1)+FnSpK*VRR(28,4,0)
      HRR(28,18,1)=HRR(28,18,1)+SpFnK*VRR(28,4,0)
      HRR(28,5,1)=HRR(28,5,1)+VRR(28,5,0)
      HRR(28,6,1)=HRR(28,6,1)+VRR(28,6,0)
      HRR(28,7,1)=HRR(28,7,1)+VRR(28,7,0)
      HRR(28,8,1)=HRR(28,8,1)+VRR(28,8,0)
      HRR(28,9,1)=HRR(28,9,1)+VRR(28,9,0)
      HRR(28,10,1)=HRR(28,10,1)+VRR(28,10,0)
      HRR(29,1,1)=HRR(29,1,1)+VRR(29,1,0)
      HRR(29,11,1)=HRR(29,11,1)+SpSpK*VRR(29,1,0)
      HRR(29,15,1)=HRR(29,15,1)+SpFnK*VRR(29,1,0)
      HRR(29,2,1)=HRR(29,2,1)+VRR(29,2,0)
      HRR(29,12,1)=HRR(29,12,1)+FnSpK*VRR(29,2,0)
      HRR(29,16,1)=HRR(29,16,1)+SpFnK*VRR(29,2,0)
      HRR(29,3,1)=HRR(29,3,1)+VRR(29,3,0)
      HRR(29,13,1)=HRR(29,13,1)+FnSpK*VRR(29,3,0)
      HRR(29,17,1)=HRR(29,17,1)+SpFnK*VRR(29,3,0)
      HRR(29,4,1)=HRR(29,4,1)+VRR(29,4,0)
      HRR(29,14,1)=HRR(29,14,1)+FnSpK*VRR(29,4,0)
      HRR(29,18,1)=HRR(29,18,1)+SpFnK*VRR(29,4,0)
      HRR(29,5,1)=HRR(29,5,1)+VRR(29,5,0)
      HRR(29,6,1)=HRR(29,6,1)+VRR(29,6,0)
      HRR(29,7,1)=HRR(29,7,1)+VRR(29,7,0)
      HRR(29,8,1)=HRR(29,8,1)+VRR(29,8,0)
      HRR(29,9,1)=HRR(29,9,1)+VRR(29,9,0)
      HRR(29,10,1)=HRR(29,10,1)+VRR(29,10,0)
      HRR(30,1,1)=HRR(30,1,1)+VRR(30,1,0)
      HRR(30,11,1)=HRR(30,11,1)+SpSpK*VRR(30,1,0)
      HRR(30,15,1)=HRR(30,15,1)+SpFnK*VRR(30,1,0)
      HRR(30,2,1)=HRR(30,2,1)+VRR(30,2,0)
      HRR(30,12,1)=HRR(30,12,1)+FnSpK*VRR(30,2,0)
      HRR(30,16,1)=HRR(30,16,1)+SpFnK*VRR(30,2,0)
      HRR(30,3,1)=HRR(30,3,1)+VRR(30,3,0)
      HRR(30,13,1)=HRR(30,13,1)+FnSpK*VRR(30,3,0)
      HRR(30,17,1)=HRR(30,17,1)+SpFnK*VRR(30,3,0)
      HRR(30,4,1)=HRR(30,4,1)+VRR(30,4,0)
      HRR(30,14,1)=HRR(30,14,1)+FnSpK*VRR(30,4,0)
      HRR(30,18,1)=HRR(30,18,1)+SpFnK*VRR(30,4,0)
      HRR(30,5,1)=HRR(30,5,1)+VRR(30,5,0)
      HRR(30,6,1)=HRR(30,6,1)+VRR(30,6,0)
      HRR(30,7,1)=HRR(30,7,1)+VRR(30,7,0)
      HRR(30,8,1)=HRR(30,8,1)+VRR(30,8,0)
      HRR(30,9,1)=HRR(30,9,1)+VRR(30,9,0)
      HRR(30,10,1)=HRR(30,10,1)+VRR(30,10,0)
      HRR(31,1,1)=HRR(31,1,1)+VRR(31,1,0)
      HRR(31,11,1)=HRR(31,11,1)+SpSpK*VRR(31,1,0)
      HRR(31,15,1)=HRR(31,15,1)+SpFnK*VRR(31,1,0)
      HRR(31,2,1)=HRR(31,2,1)+VRR(31,2,0)
      HRR(31,12,1)=HRR(31,12,1)+FnSpK*VRR(31,2,0)
      HRR(31,16,1)=HRR(31,16,1)+SpFnK*VRR(31,2,0)
      HRR(31,3,1)=HRR(31,3,1)+VRR(31,3,0)
      HRR(31,13,1)=HRR(31,13,1)+FnSpK*VRR(31,3,0)
      HRR(31,17,1)=HRR(31,17,1)+SpFnK*VRR(31,3,0)
      HRR(31,4,1)=HRR(31,4,1)+VRR(31,4,0)
      HRR(31,14,1)=HRR(31,14,1)+FnSpK*VRR(31,4,0)
      HRR(31,18,1)=HRR(31,18,1)+SpFnK*VRR(31,4,0)
      HRR(31,5,1)=HRR(31,5,1)+VRR(31,5,0)
      HRR(31,6,1)=HRR(31,6,1)+VRR(31,6,0)
      HRR(31,7,1)=HRR(31,7,1)+VRR(31,7,0)
      HRR(31,8,1)=HRR(31,8,1)+VRR(31,8,0)
      HRR(31,9,1)=HRR(31,9,1)+VRR(31,9,0)
      HRR(31,10,1)=HRR(31,10,1)+VRR(31,10,0)
      HRR(32,1,1)=HRR(32,1,1)+VRR(32,1,0)
      HRR(32,11,1)=HRR(32,11,1)+SpSpK*VRR(32,1,0)
      HRR(32,15,1)=HRR(32,15,1)+SpFnK*VRR(32,1,0)
      HRR(32,2,1)=HRR(32,2,1)+VRR(32,2,0)
      HRR(32,12,1)=HRR(32,12,1)+FnSpK*VRR(32,2,0)
      HRR(32,16,1)=HRR(32,16,1)+SpFnK*VRR(32,2,0)
      HRR(32,3,1)=HRR(32,3,1)+VRR(32,3,0)
      HRR(32,13,1)=HRR(32,13,1)+FnSpK*VRR(32,3,0)
      HRR(32,17,1)=HRR(32,17,1)+SpFnK*VRR(32,3,0)
      HRR(32,4,1)=HRR(32,4,1)+VRR(32,4,0)
      HRR(32,14,1)=HRR(32,14,1)+FnSpK*VRR(32,4,0)
      HRR(32,18,1)=HRR(32,18,1)+SpFnK*VRR(32,4,0)
      HRR(32,5,1)=HRR(32,5,1)+VRR(32,5,0)
      HRR(32,6,1)=HRR(32,6,1)+VRR(32,6,0)
      HRR(32,7,1)=HRR(32,7,1)+VRR(32,7,0)
      HRR(32,8,1)=HRR(32,8,1)+VRR(32,8,0)
      HRR(32,9,1)=HRR(32,9,1)+VRR(32,9,0)
      HRR(32,10,1)=HRR(32,10,1)+VRR(32,10,0)
      HRR(33,1,1)=HRR(33,1,1)+VRR(33,1,0)
      HRR(33,11,1)=HRR(33,11,1)+SpSpK*VRR(33,1,0)
      HRR(33,15,1)=HRR(33,15,1)+SpFnK*VRR(33,1,0)
      HRR(33,2,1)=HRR(33,2,1)+VRR(33,2,0)
      HRR(33,12,1)=HRR(33,12,1)+FnSpK*VRR(33,2,0)
      HRR(33,16,1)=HRR(33,16,1)+SpFnK*VRR(33,2,0)
      HRR(33,3,1)=HRR(33,3,1)+VRR(33,3,0)
      HRR(33,13,1)=HRR(33,13,1)+FnSpK*VRR(33,3,0)
      HRR(33,17,1)=HRR(33,17,1)+SpFnK*VRR(33,3,0)
      HRR(33,4,1)=HRR(33,4,1)+VRR(33,4,0)
      HRR(33,14,1)=HRR(33,14,1)+FnSpK*VRR(33,4,0)
      HRR(33,18,1)=HRR(33,18,1)+SpFnK*VRR(33,4,0)
      HRR(33,5,1)=HRR(33,5,1)+VRR(33,5,0)
      HRR(33,6,1)=HRR(33,6,1)+VRR(33,6,0)
      HRR(33,7,1)=HRR(33,7,1)+VRR(33,7,0)
      HRR(33,8,1)=HRR(33,8,1)+VRR(33,8,0)
      HRR(33,9,1)=HRR(33,9,1)+VRR(33,9,0)
      HRR(33,10,1)=HRR(33,10,1)+VRR(33,10,0)
      HRR(34,1,1)=HRR(34,1,1)+VRR(34,1,0)
      HRR(34,11,1)=HRR(34,11,1)+SpSpK*VRR(34,1,0)
      HRR(34,15,1)=HRR(34,15,1)+SpFnK*VRR(34,1,0)
      HRR(34,2,1)=HRR(34,2,1)+VRR(34,2,0)
      HRR(34,12,1)=HRR(34,12,1)+FnSpK*VRR(34,2,0)
      HRR(34,16,1)=HRR(34,16,1)+SpFnK*VRR(34,2,0)
      HRR(34,3,1)=HRR(34,3,1)+VRR(34,3,0)
      HRR(34,13,1)=HRR(34,13,1)+FnSpK*VRR(34,3,0)
      HRR(34,17,1)=HRR(34,17,1)+SpFnK*VRR(34,3,0)
      HRR(34,4,1)=HRR(34,4,1)+VRR(34,4,0)
      HRR(34,14,1)=HRR(34,14,1)+FnSpK*VRR(34,4,0)
      HRR(34,18,1)=HRR(34,18,1)+SpFnK*VRR(34,4,0)
      HRR(34,5,1)=HRR(34,5,1)+VRR(34,5,0)
      HRR(34,6,1)=HRR(34,6,1)+VRR(34,6,0)
      HRR(34,7,1)=HRR(34,7,1)+VRR(34,7,0)
      HRR(34,8,1)=HRR(34,8,1)+VRR(34,8,0)
      HRR(34,9,1)=HRR(34,9,1)+VRR(34,9,0)
      HRR(34,10,1)=HRR(34,10,1)+VRR(34,10,0)
      HRR(35,1,1)=HRR(35,1,1)+VRR(35,1,0)
      HRR(35,11,1)=HRR(35,11,1)+SpSpK*VRR(35,1,0)
      HRR(35,15,1)=HRR(35,15,1)+SpFnK*VRR(35,1,0)
      HRR(35,2,1)=HRR(35,2,1)+VRR(35,2,0)
      HRR(35,12,1)=HRR(35,12,1)+FnSpK*VRR(35,2,0)
      HRR(35,16,1)=HRR(35,16,1)+SpFnK*VRR(35,2,0)
      HRR(35,3,1)=HRR(35,3,1)+VRR(35,3,0)
      HRR(35,13,1)=HRR(35,13,1)+FnSpK*VRR(35,3,0)
      HRR(35,17,1)=HRR(35,17,1)+SpFnK*VRR(35,3,0)
      HRR(35,4,1)=HRR(35,4,1)+VRR(35,4,0)
      HRR(35,14,1)=HRR(35,14,1)+FnSpK*VRR(35,4,0)
      HRR(35,18,1)=HRR(35,18,1)+SpFnK*VRR(35,4,0)
      HRR(35,5,1)=HRR(35,5,1)+VRR(35,5,0)
      HRR(35,6,1)=HRR(35,6,1)+VRR(35,6,0)
      HRR(35,7,1)=HRR(35,7,1)+VRR(35,7,0)
      HRR(35,8,1)=HRR(35,8,1)+VRR(35,8,0)
      HRR(35,9,1)=HRR(35,9,1)+VRR(35,9,0)
      HRR(35,10,1)=HRR(35,10,1)+VRR(35,10,0)
      HRR(36,1,1)=HRR(36,1,1)+VRR(36,1,0)
      HRR(36,11,1)=HRR(36,11,1)+SpSpK*VRR(36,1,0)
      HRR(36,15,1)=HRR(36,15,1)+SpFnK*VRR(36,1,0)
      HRR(36,2,1)=HRR(36,2,1)+VRR(36,2,0)
      HRR(36,12,1)=HRR(36,12,1)+FnSpK*VRR(36,2,0)
      HRR(36,16,1)=HRR(36,16,1)+SpFnK*VRR(36,2,0)
      HRR(36,3,1)=HRR(36,3,1)+VRR(36,3,0)
      HRR(36,13,1)=HRR(36,13,1)+FnSpK*VRR(36,3,0)
      HRR(36,17,1)=HRR(36,17,1)+SpFnK*VRR(36,3,0)
      HRR(36,4,1)=HRR(36,4,1)+VRR(36,4,0)
      HRR(36,14,1)=HRR(36,14,1)+FnSpK*VRR(36,4,0)
      HRR(36,18,1)=HRR(36,18,1)+SpFnK*VRR(36,4,0)
      HRR(36,5,1)=HRR(36,5,1)+VRR(36,5,0)
      HRR(36,6,1)=HRR(36,6,1)+VRR(36,6,0)
      HRR(36,7,1)=HRR(36,7,1)+VRR(36,7,0)
      HRR(36,8,1)=HRR(36,8,1)+VRR(36,8,0)
      HRR(36,9,1)=HRR(36,9,1)+VRR(36,9,0)
      HRR(36,10,1)=HRR(36,10,1)+VRR(36,10,0)
      HRR(37,1,1)=HRR(37,1,1)+VRR(37,1,0)
      HRR(37,11,1)=HRR(37,11,1)+SpSpK*VRR(37,1,0)
      HRR(37,15,1)=HRR(37,15,1)+SpFnK*VRR(37,1,0)
      HRR(37,2,1)=HRR(37,2,1)+VRR(37,2,0)
      HRR(37,12,1)=HRR(37,12,1)+FnSpK*VRR(37,2,0)
      HRR(37,16,1)=HRR(37,16,1)+SpFnK*VRR(37,2,0)
      HRR(37,3,1)=HRR(37,3,1)+VRR(37,3,0)
      HRR(37,13,1)=HRR(37,13,1)+FnSpK*VRR(37,3,0)
      HRR(37,17,1)=HRR(37,17,1)+SpFnK*VRR(37,3,0)
      HRR(37,4,1)=HRR(37,4,1)+VRR(37,4,0)
      HRR(37,14,1)=HRR(37,14,1)+FnSpK*VRR(37,4,0)
      HRR(37,18,1)=HRR(37,18,1)+SpFnK*VRR(37,4,0)
      HRR(37,5,1)=HRR(37,5,1)+VRR(37,5,0)
      HRR(37,6,1)=HRR(37,6,1)+VRR(37,6,0)
      HRR(37,7,1)=HRR(37,7,1)+VRR(37,7,0)
      HRR(37,8,1)=HRR(37,8,1)+VRR(37,8,0)
      HRR(37,9,1)=HRR(37,9,1)+VRR(37,9,0)
      HRR(37,10,1)=HRR(37,10,1)+VRR(37,10,0)
      HRR(38,1,1)=HRR(38,1,1)+VRR(38,1,0)
      HRR(38,11,1)=HRR(38,11,1)+SpSpK*VRR(38,1,0)
      HRR(38,15,1)=HRR(38,15,1)+SpFnK*VRR(38,1,0)
      HRR(38,2,1)=HRR(38,2,1)+VRR(38,2,0)
      HRR(38,12,1)=HRR(38,12,1)+FnSpK*VRR(38,2,0)
      HRR(38,16,1)=HRR(38,16,1)+SpFnK*VRR(38,2,0)
      HRR(38,3,1)=HRR(38,3,1)+VRR(38,3,0)
      HRR(38,13,1)=HRR(38,13,1)+FnSpK*VRR(38,3,0)
      HRR(38,17,1)=HRR(38,17,1)+SpFnK*VRR(38,3,0)
      HRR(38,4,1)=HRR(38,4,1)+VRR(38,4,0)
      HRR(38,14,1)=HRR(38,14,1)+FnSpK*VRR(38,4,0)
      HRR(38,18,1)=HRR(38,18,1)+SpFnK*VRR(38,4,0)
      HRR(38,5,1)=HRR(38,5,1)+VRR(38,5,0)
      HRR(38,6,1)=HRR(38,6,1)+VRR(38,6,0)
      HRR(38,7,1)=HRR(38,7,1)+VRR(38,7,0)
      HRR(38,8,1)=HRR(38,8,1)+VRR(38,8,0)
      HRR(38,9,1)=HRR(38,9,1)+VRR(38,9,0)
      HRR(38,10,1)=HRR(38,10,1)+VRR(38,10,0)
      HRR(39,1,1)=HRR(39,1,1)+VRR(39,1,0)
      HRR(39,11,1)=HRR(39,11,1)+SpSpK*VRR(39,1,0)
      HRR(39,15,1)=HRR(39,15,1)+SpFnK*VRR(39,1,0)
      HRR(39,2,1)=HRR(39,2,1)+VRR(39,2,0)
      HRR(39,12,1)=HRR(39,12,1)+FnSpK*VRR(39,2,0)
      HRR(39,16,1)=HRR(39,16,1)+SpFnK*VRR(39,2,0)
      HRR(39,3,1)=HRR(39,3,1)+VRR(39,3,0)
      HRR(39,13,1)=HRR(39,13,1)+FnSpK*VRR(39,3,0)
      HRR(39,17,1)=HRR(39,17,1)+SpFnK*VRR(39,3,0)
      HRR(39,4,1)=HRR(39,4,1)+VRR(39,4,0)
      HRR(39,14,1)=HRR(39,14,1)+FnSpK*VRR(39,4,0)
      HRR(39,18,1)=HRR(39,18,1)+SpFnK*VRR(39,4,0)
      HRR(39,5,1)=HRR(39,5,1)+VRR(39,5,0)
      HRR(39,6,1)=HRR(39,6,1)+VRR(39,6,0)
      HRR(39,7,1)=HRR(39,7,1)+VRR(39,7,0)
      HRR(39,8,1)=HRR(39,8,1)+VRR(39,8,0)
      HRR(39,9,1)=HRR(39,9,1)+VRR(39,9,0)
      HRR(39,10,1)=HRR(39,10,1)+VRR(39,10,0)
      HRR(40,1,1)=HRR(40,1,1)+VRR(40,1,0)
      HRR(40,11,1)=HRR(40,11,1)+SpSpK*VRR(40,1,0)
      HRR(40,15,1)=HRR(40,15,1)+SpFnK*VRR(40,1,0)
      HRR(40,2,1)=HRR(40,2,1)+VRR(40,2,0)
      HRR(40,12,1)=HRR(40,12,1)+FnSpK*VRR(40,2,0)
      HRR(40,16,1)=HRR(40,16,1)+SpFnK*VRR(40,2,0)
      HRR(40,3,1)=HRR(40,3,1)+VRR(40,3,0)
      HRR(40,13,1)=HRR(40,13,1)+FnSpK*VRR(40,3,0)
      HRR(40,17,1)=HRR(40,17,1)+SpFnK*VRR(40,3,0)
      HRR(40,4,1)=HRR(40,4,1)+VRR(40,4,0)
      HRR(40,14,1)=HRR(40,14,1)+FnSpK*VRR(40,4,0)
      HRR(40,18,1)=HRR(40,18,1)+SpFnK*VRR(40,4,0)
      HRR(40,5,1)=HRR(40,5,1)+VRR(40,5,0)
      HRR(40,6,1)=HRR(40,6,1)+VRR(40,6,0)
      HRR(40,7,1)=HRR(40,7,1)+VRR(40,7,0)
      HRR(40,8,1)=HRR(40,8,1)+VRR(40,8,0)
      HRR(40,9,1)=HRR(40,9,1)+VRR(40,9,0)
      HRR(40,10,1)=HRR(40,10,1)+VRR(40,10,0)
      HRR(41,1,1)=HRR(41,1,1)+VRR(41,1,0)
      HRR(41,11,1)=HRR(41,11,1)+SpSpK*VRR(41,1,0)
      HRR(41,15,1)=HRR(41,15,1)+SpFnK*VRR(41,1,0)
      HRR(41,2,1)=HRR(41,2,1)+VRR(41,2,0)
      HRR(41,12,1)=HRR(41,12,1)+FnSpK*VRR(41,2,0)
      HRR(41,16,1)=HRR(41,16,1)+SpFnK*VRR(41,2,0)
      HRR(41,3,1)=HRR(41,3,1)+VRR(41,3,0)
      HRR(41,13,1)=HRR(41,13,1)+FnSpK*VRR(41,3,0)
      HRR(41,17,1)=HRR(41,17,1)+SpFnK*VRR(41,3,0)
      HRR(41,4,1)=HRR(41,4,1)+VRR(41,4,0)
      HRR(41,14,1)=HRR(41,14,1)+FnSpK*VRR(41,4,0)
      HRR(41,18,1)=HRR(41,18,1)+SpFnK*VRR(41,4,0)
      HRR(41,5,1)=HRR(41,5,1)+VRR(41,5,0)
      HRR(41,6,1)=HRR(41,6,1)+VRR(41,6,0)
      HRR(41,7,1)=HRR(41,7,1)+VRR(41,7,0)
      HRR(41,8,1)=HRR(41,8,1)+VRR(41,8,0)
      HRR(41,9,1)=HRR(41,9,1)+VRR(41,9,0)
      HRR(41,10,1)=HRR(41,10,1)+VRR(41,10,0)
      HRR(42,1,1)=HRR(42,1,1)+VRR(42,1,0)
      HRR(42,11,1)=HRR(42,11,1)+SpSpK*VRR(42,1,0)
      HRR(42,15,1)=HRR(42,15,1)+SpFnK*VRR(42,1,0)
      HRR(42,2,1)=HRR(42,2,1)+VRR(42,2,0)
      HRR(42,12,1)=HRR(42,12,1)+FnSpK*VRR(42,2,0)
      HRR(42,16,1)=HRR(42,16,1)+SpFnK*VRR(42,2,0)
      HRR(42,3,1)=HRR(42,3,1)+VRR(42,3,0)
      HRR(42,13,1)=HRR(42,13,1)+FnSpK*VRR(42,3,0)
      HRR(42,17,1)=HRR(42,17,1)+SpFnK*VRR(42,3,0)
      HRR(42,4,1)=HRR(42,4,1)+VRR(42,4,0)
      HRR(42,14,1)=HRR(42,14,1)+FnSpK*VRR(42,4,0)
      HRR(42,18,1)=HRR(42,18,1)+SpFnK*VRR(42,4,0)
      HRR(42,5,1)=HRR(42,5,1)+VRR(42,5,0)
      HRR(42,6,1)=HRR(42,6,1)+VRR(42,6,0)
      HRR(42,7,1)=HRR(42,7,1)+VRR(42,7,0)
      HRR(42,8,1)=HRR(42,8,1)+VRR(42,8,0)
      HRR(42,9,1)=HRR(42,9,1)+VRR(42,9,0)
      HRR(42,10,1)=HRR(42,10,1)+VRR(42,10,0)
      HRR(43,1,1)=HRR(43,1,1)+VRR(43,1,0)
      HRR(43,11,1)=HRR(43,11,1)+SpSpK*VRR(43,1,0)
      HRR(43,15,1)=HRR(43,15,1)+SpFnK*VRR(43,1,0)
      HRR(43,2,1)=HRR(43,2,1)+VRR(43,2,0)
      HRR(43,12,1)=HRR(43,12,1)+FnSpK*VRR(43,2,0)
      HRR(43,16,1)=HRR(43,16,1)+SpFnK*VRR(43,2,0)
      HRR(43,3,1)=HRR(43,3,1)+VRR(43,3,0)
      HRR(43,13,1)=HRR(43,13,1)+FnSpK*VRR(43,3,0)
      HRR(43,17,1)=HRR(43,17,1)+SpFnK*VRR(43,3,0)
      HRR(43,4,1)=HRR(43,4,1)+VRR(43,4,0)
      HRR(43,14,1)=HRR(43,14,1)+FnSpK*VRR(43,4,0)
      HRR(43,18,1)=HRR(43,18,1)+SpFnK*VRR(43,4,0)
      HRR(43,5,1)=HRR(43,5,1)+VRR(43,5,0)
      HRR(43,6,1)=HRR(43,6,1)+VRR(43,6,0)
      HRR(43,7,1)=HRR(43,7,1)+VRR(43,7,0)
      HRR(43,8,1)=HRR(43,8,1)+VRR(43,8,0)
      HRR(43,9,1)=HRR(43,9,1)+VRR(43,9,0)
      HRR(43,10,1)=HRR(43,10,1)+VRR(43,10,0)
      HRR(44,1,1)=HRR(44,1,1)+VRR(44,1,0)
      HRR(44,11,1)=HRR(44,11,1)+SpSpK*VRR(44,1,0)
      HRR(44,15,1)=HRR(44,15,1)+SpFnK*VRR(44,1,0)
      HRR(44,2,1)=HRR(44,2,1)+VRR(44,2,0)
      HRR(44,12,1)=HRR(44,12,1)+FnSpK*VRR(44,2,0)
      HRR(44,16,1)=HRR(44,16,1)+SpFnK*VRR(44,2,0)
      HRR(44,3,1)=HRR(44,3,1)+VRR(44,3,0)
      HRR(44,13,1)=HRR(44,13,1)+FnSpK*VRR(44,3,0)
      HRR(44,17,1)=HRR(44,17,1)+SpFnK*VRR(44,3,0)
      HRR(44,4,1)=HRR(44,4,1)+VRR(44,4,0)
      HRR(44,14,1)=HRR(44,14,1)+FnSpK*VRR(44,4,0)
      HRR(44,18,1)=HRR(44,18,1)+SpFnK*VRR(44,4,0)
      HRR(44,5,1)=HRR(44,5,1)+VRR(44,5,0)
      HRR(44,6,1)=HRR(44,6,1)+VRR(44,6,0)
      HRR(44,7,1)=HRR(44,7,1)+VRR(44,7,0)
      HRR(44,8,1)=HRR(44,8,1)+VRR(44,8,0)
      HRR(44,9,1)=HRR(44,9,1)+VRR(44,9,0)
      HRR(44,10,1)=HRR(44,10,1)+VRR(44,10,0)
      HRR(45,1,1)=HRR(45,1,1)+VRR(45,1,0)
      HRR(45,11,1)=HRR(45,11,1)+SpSpK*VRR(45,1,0)
      HRR(45,15,1)=HRR(45,15,1)+SpFnK*VRR(45,1,0)
      HRR(45,2,1)=HRR(45,2,1)+VRR(45,2,0)
      HRR(45,12,1)=HRR(45,12,1)+FnSpK*VRR(45,2,0)
      HRR(45,16,1)=HRR(45,16,1)+SpFnK*VRR(45,2,0)
      HRR(45,3,1)=HRR(45,3,1)+VRR(45,3,0)
      HRR(45,13,1)=HRR(45,13,1)+FnSpK*VRR(45,3,0)
      HRR(45,17,1)=HRR(45,17,1)+SpFnK*VRR(45,3,0)
      HRR(45,4,1)=HRR(45,4,1)+VRR(45,4,0)
      HRR(45,14,1)=HRR(45,14,1)+FnSpK*VRR(45,4,0)
      HRR(45,18,1)=HRR(45,18,1)+SpFnK*VRR(45,4,0)
      HRR(45,5,1)=HRR(45,5,1)+VRR(45,5,0)
      HRR(45,6,1)=HRR(45,6,1)+VRR(45,6,0)
      HRR(45,7,1)=HRR(45,7,1)+VRR(45,7,0)
      HRR(45,8,1)=HRR(45,8,1)+VRR(45,8,0)
      HRR(45,9,1)=HRR(45,9,1)+VRR(45,9,0)
      HRR(45,10,1)=HRR(45,10,1)+VRR(45,10,0)
      HRR(46,1,1)=HRR(46,1,1)+VRR(46,1,0)
      HRR(46,11,1)=HRR(46,11,1)+SpSpK*VRR(46,1,0)
      HRR(46,15,1)=HRR(46,15,1)+SpFnK*VRR(46,1,0)
      HRR(46,2,1)=HRR(46,2,1)+VRR(46,2,0)
      HRR(46,12,1)=HRR(46,12,1)+FnSpK*VRR(46,2,0)
      HRR(46,16,1)=HRR(46,16,1)+SpFnK*VRR(46,2,0)
      HRR(46,3,1)=HRR(46,3,1)+VRR(46,3,0)
      HRR(46,13,1)=HRR(46,13,1)+FnSpK*VRR(46,3,0)
      HRR(46,17,1)=HRR(46,17,1)+SpFnK*VRR(46,3,0)
      HRR(46,4,1)=HRR(46,4,1)+VRR(46,4,0)
      HRR(46,14,1)=HRR(46,14,1)+FnSpK*VRR(46,4,0)
      HRR(46,18,1)=HRR(46,18,1)+SpFnK*VRR(46,4,0)
      HRR(46,5,1)=HRR(46,5,1)+VRR(46,5,0)
      HRR(46,6,1)=HRR(46,6,1)+VRR(46,6,0)
      HRR(46,7,1)=HRR(46,7,1)+VRR(46,7,0)
      HRR(46,8,1)=HRR(46,8,1)+VRR(46,8,0)
      HRR(46,9,1)=HRR(46,9,1)+VRR(46,9,0)
      HRR(46,10,1)=HRR(46,10,1)+VRR(46,10,0)
      HRR(47,1,1)=HRR(47,1,1)+VRR(47,1,0)
      HRR(47,11,1)=HRR(47,11,1)+SpSpK*VRR(47,1,0)
      HRR(47,15,1)=HRR(47,15,1)+SpFnK*VRR(47,1,0)
      HRR(47,2,1)=HRR(47,2,1)+VRR(47,2,0)
      HRR(47,12,1)=HRR(47,12,1)+FnSpK*VRR(47,2,0)
      HRR(47,16,1)=HRR(47,16,1)+SpFnK*VRR(47,2,0)
      HRR(47,3,1)=HRR(47,3,1)+VRR(47,3,0)
      HRR(47,13,1)=HRR(47,13,1)+FnSpK*VRR(47,3,0)
      HRR(47,17,1)=HRR(47,17,1)+SpFnK*VRR(47,3,0)
      HRR(47,4,1)=HRR(47,4,1)+VRR(47,4,0)
      HRR(47,14,1)=HRR(47,14,1)+FnSpK*VRR(47,4,0)
      HRR(47,18,1)=HRR(47,18,1)+SpFnK*VRR(47,4,0)
      HRR(47,5,1)=HRR(47,5,1)+VRR(47,5,0)
      HRR(47,6,1)=HRR(47,6,1)+VRR(47,6,0)
      HRR(47,7,1)=HRR(47,7,1)+VRR(47,7,0)
      HRR(47,8,1)=HRR(47,8,1)+VRR(47,8,0)
      HRR(47,9,1)=HRR(47,9,1)+VRR(47,9,0)
      HRR(47,10,1)=HRR(47,10,1)+VRR(47,10,0)
      HRR(48,1,1)=HRR(48,1,1)+VRR(48,1,0)
      HRR(48,11,1)=HRR(48,11,1)+SpSpK*VRR(48,1,0)
      HRR(48,15,1)=HRR(48,15,1)+SpFnK*VRR(48,1,0)
      HRR(48,2,1)=HRR(48,2,1)+VRR(48,2,0)
      HRR(48,12,1)=HRR(48,12,1)+FnSpK*VRR(48,2,0)
      HRR(48,16,1)=HRR(48,16,1)+SpFnK*VRR(48,2,0)
      HRR(48,3,1)=HRR(48,3,1)+VRR(48,3,0)
      HRR(48,13,1)=HRR(48,13,1)+FnSpK*VRR(48,3,0)
      HRR(48,17,1)=HRR(48,17,1)+SpFnK*VRR(48,3,0)
      HRR(48,4,1)=HRR(48,4,1)+VRR(48,4,0)
      HRR(48,14,1)=HRR(48,14,1)+FnSpK*VRR(48,4,0)
      HRR(48,18,1)=HRR(48,18,1)+SpFnK*VRR(48,4,0)
      HRR(48,5,1)=HRR(48,5,1)+VRR(48,5,0)
      HRR(48,6,1)=HRR(48,6,1)+VRR(48,6,0)
      HRR(48,7,1)=HRR(48,7,1)+VRR(48,7,0)
      HRR(48,8,1)=HRR(48,8,1)+VRR(48,8,0)
      HRR(48,9,1)=HRR(48,9,1)+VRR(48,9,0)
      HRR(48,10,1)=HRR(48,10,1)+VRR(48,10,0)
      HRR(49,1,1)=HRR(49,1,1)+VRR(49,1,0)
      HRR(49,11,1)=HRR(49,11,1)+SpSpK*VRR(49,1,0)
      HRR(49,15,1)=HRR(49,15,1)+SpFnK*VRR(49,1,0)
      HRR(49,2,1)=HRR(49,2,1)+VRR(49,2,0)
      HRR(49,12,1)=HRR(49,12,1)+FnSpK*VRR(49,2,0)
      HRR(49,16,1)=HRR(49,16,1)+SpFnK*VRR(49,2,0)
      HRR(49,3,1)=HRR(49,3,1)+VRR(49,3,0)
      HRR(49,13,1)=HRR(49,13,1)+FnSpK*VRR(49,3,0)
      HRR(49,17,1)=HRR(49,17,1)+SpFnK*VRR(49,3,0)
      HRR(49,4,1)=HRR(49,4,1)+VRR(49,4,0)
      HRR(49,14,1)=HRR(49,14,1)+FnSpK*VRR(49,4,0)
      HRR(49,18,1)=HRR(49,18,1)+SpFnK*VRR(49,4,0)
      HRR(49,5,1)=HRR(49,5,1)+VRR(49,5,0)
      HRR(49,6,1)=HRR(49,6,1)+VRR(49,6,0)
      HRR(49,7,1)=HRR(49,7,1)+VRR(49,7,0)
      HRR(49,8,1)=HRR(49,8,1)+VRR(49,8,0)
      HRR(49,9,1)=HRR(49,9,1)+VRR(49,9,0)
      HRR(49,10,1)=HRR(49,10,1)+VRR(49,10,0)
      HRR(50,1,1)=HRR(50,1,1)+VRR(50,1,0)
      HRR(50,11,1)=HRR(50,11,1)+SpSpK*VRR(50,1,0)
      HRR(50,15,1)=HRR(50,15,1)+SpFnK*VRR(50,1,0)
      HRR(50,2,1)=HRR(50,2,1)+VRR(50,2,0)
      HRR(50,12,1)=HRR(50,12,1)+FnSpK*VRR(50,2,0)
      HRR(50,16,1)=HRR(50,16,1)+SpFnK*VRR(50,2,0)
      HRR(50,3,1)=HRR(50,3,1)+VRR(50,3,0)
      HRR(50,13,1)=HRR(50,13,1)+FnSpK*VRR(50,3,0)
      HRR(50,17,1)=HRR(50,17,1)+SpFnK*VRR(50,3,0)
      HRR(50,4,1)=HRR(50,4,1)+VRR(50,4,0)
      HRR(50,14,1)=HRR(50,14,1)+FnSpK*VRR(50,4,0)
      HRR(50,18,1)=HRR(50,18,1)+SpFnK*VRR(50,4,0)
      HRR(50,5,1)=HRR(50,5,1)+VRR(50,5,0)
      HRR(50,6,1)=HRR(50,6,1)+VRR(50,6,0)
      HRR(50,7,1)=HRR(50,7,1)+VRR(50,7,0)
      HRR(50,8,1)=HRR(50,8,1)+VRR(50,8,0)
      HRR(50,9,1)=HRR(50,9,1)+VRR(50,9,0)
      HRR(50,10,1)=HRR(50,10,1)+VRR(50,10,0)
      HRR(51,1,1)=HRR(51,1,1)+VRR(51,1,0)
      HRR(51,11,1)=HRR(51,11,1)+SpSpK*VRR(51,1,0)
      HRR(51,15,1)=HRR(51,15,1)+SpFnK*VRR(51,1,0)
      HRR(51,2,1)=HRR(51,2,1)+VRR(51,2,0)
      HRR(51,12,1)=HRR(51,12,1)+FnSpK*VRR(51,2,0)
      HRR(51,16,1)=HRR(51,16,1)+SpFnK*VRR(51,2,0)
      HRR(51,3,1)=HRR(51,3,1)+VRR(51,3,0)
      HRR(51,13,1)=HRR(51,13,1)+FnSpK*VRR(51,3,0)
      HRR(51,17,1)=HRR(51,17,1)+SpFnK*VRR(51,3,0)
      HRR(51,4,1)=HRR(51,4,1)+VRR(51,4,0)
      HRR(51,14,1)=HRR(51,14,1)+FnSpK*VRR(51,4,0)
      HRR(51,18,1)=HRR(51,18,1)+SpFnK*VRR(51,4,0)
      HRR(51,5,1)=HRR(51,5,1)+VRR(51,5,0)
      HRR(51,6,1)=HRR(51,6,1)+VRR(51,6,0)
      HRR(51,7,1)=HRR(51,7,1)+VRR(51,7,0)
      HRR(51,8,1)=HRR(51,8,1)+VRR(51,8,0)
      HRR(51,9,1)=HRR(51,9,1)+VRR(51,9,0)
      HRR(51,10,1)=HRR(51,10,1)+VRR(51,10,0)
      HRR(52,1,1)=HRR(52,1,1)+VRR(52,1,0)
      HRR(52,11,1)=HRR(52,11,1)+SpSpK*VRR(52,1,0)
      HRR(52,15,1)=HRR(52,15,1)+SpFnK*VRR(52,1,0)
      HRR(52,2,1)=HRR(52,2,1)+VRR(52,2,0)
      HRR(52,12,1)=HRR(52,12,1)+FnSpK*VRR(52,2,0)
      HRR(52,16,1)=HRR(52,16,1)+SpFnK*VRR(52,2,0)
      HRR(52,3,1)=HRR(52,3,1)+VRR(52,3,0)
      HRR(52,13,1)=HRR(52,13,1)+FnSpK*VRR(52,3,0)
      HRR(52,17,1)=HRR(52,17,1)+SpFnK*VRR(52,3,0)
      HRR(52,4,1)=HRR(52,4,1)+VRR(52,4,0)
      HRR(52,14,1)=HRR(52,14,1)+FnSpK*VRR(52,4,0)
      HRR(52,18,1)=HRR(52,18,1)+SpFnK*VRR(52,4,0)
      HRR(52,5,1)=HRR(52,5,1)+VRR(52,5,0)
      HRR(52,6,1)=HRR(52,6,1)+VRR(52,6,0)
      HRR(52,7,1)=HRR(52,7,1)+VRR(52,7,0)
      HRR(52,8,1)=HRR(52,8,1)+VRR(52,8,0)
      HRR(52,9,1)=HRR(52,9,1)+VRR(52,9,0)
      HRR(52,10,1)=HRR(52,10,1)+VRR(52,10,0)
      HRR(53,1,1)=HRR(53,1,1)+VRR(53,1,0)
      HRR(53,11,1)=HRR(53,11,1)+SpSpK*VRR(53,1,0)
      HRR(53,15,1)=HRR(53,15,1)+SpFnK*VRR(53,1,0)
      HRR(53,2,1)=HRR(53,2,1)+VRR(53,2,0)
      HRR(53,12,1)=HRR(53,12,1)+FnSpK*VRR(53,2,0)
      HRR(53,16,1)=HRR(53,16,1)+SpFnK*VRR(53,2,0)
      HRR(53,3,1)=HRR(53,3,1)+VRR(53,3,0)
      HRR(53,13,1)=HRR(53,13,1)+FnSpK*VRR(53,3,0)
      HRR(53,17,1)=HRR(53,17,1)+SpFnK*VRR(53,3,0)
      HRR(53,4,1)=HRR(53,4,1)+VRR(53,4,0)
      HRR(53,14,1)=HRR(53,14,1)+FnSpK*VRR(53,4,0)
      HRR(53,18,1)=HRR(53,18,1)+SpFnK*VRR(53,4,0)
      HRR(53,5,1)=HRR(53,5,1)+VRR(53,5,0)
      HRR(53,6,1)=HRR(53,6,1)+VRR(53,6,0)
      HRR(53,7,1)=HRR(53,7,1)+VRR(53,7,0)
      HRR(53,8,1)=HRR(53,8,1)+VRR(53,8,0)
      HRR(53,9,1)=HRR(53,9,1)+VRR(53,9,0)
      HRR(53,10,1)=HRR(53,10,1)+VRR(53,10,0)
      HRR(54,1,1)=HRR(54,1,1)+VRR(54,1,0)
      HRR(54,11,1)=HRR(54,11,1)+SpSpK*VRR(54,1,0)
      HRR(54,15,1)=HRR(54,15,1)+SpFnK*VRR(54,1,0)
      HRR(54,2,1)=HRR(54,2,1)+VRR(54,2,0)
      HRR(54,12,1)=HRR(54,12,1)+FnSpK*VRR(54,2,0)
      HRR(54,16,1)=HRR(54,16,1)+SpFnK*VRR(54,2,0)
      HRR(54,3,1)=HRR(54,3,1)+VRR(54,3,0)
      HRR(54,13,1)=HRR(54,13,1)+FnSpK*VRR(54,3,0)
      HRR(54,17,1)=HRR(54,17,1)+SpFnK*VRR(54,3,0)
      HRR(54,4,1)=HRR(54,4,1)+VRR(54,4,0)
      HRR(54,14,1)=HRR(54,14,1)+FnSpK*VRR(54,4,0)
      HRR(54,18,1)=HRR(54,18,1)+SpFnK*VRR(54,4,0)
      HRR(54,5,1)=HRR(54,5,1)+VRR(54,5,0)
      HRR(54,6,1)=HRR(54,6,1)+VRR(54,6,0)
      HRR(54,7,1)=HRR(54,7,1)+VRR(54,7,0)
      HRR(54,8,1)=HRR(54,8,1)+VRR(54,8,0)
      HRR(54,9,1)=HRR(54,9,1)+VRR(54,9,0)
      HRR(54,10,1)=HRR(54,10,1)+VRR(54,10,0)
      HRR(55,1,1)=HRR(55,1,1)+VRR(55,1,0)
      HRR(55,11,1)=HRR(55,11,1)+SpSpK*VRR(55,1,0)
      HRR(55,15,1)=HRR(55,15,1)+SpFnK*VRR(55,1,0)
      HRR(55,2,1)=HRR(55,2,1)+VRR(55,2,0)
      HRR(55,12,1)=HRR(55,12,1)+FnSpK*VRR(55,2,0)
      HRR(55,16,1)=HRR(55,16,1)+SpFnK*VRR(55,2,0)
      HRR(55,3,1)=HRR(55,3,1)+VRR(55,3,0)
      HRR(55,13,1)=HRR(55,13,1)+FnSpK*VRR(55,3,0)
      HRR(55,17,1)=HRR(55,17,1)+SpFnK*VRR(55,3,0)
      HRR(55,4,1)=HRR(55,4,1)+VRR(55,4,0)
      HRR(55,14,1)=HRR(55,14,1)+FnSpK*VRR(55,4,0)
      HRR(55,18,1)=HRR(55,18,1)+SpFnK*VRR(55,4,0)
      HRR(55,5,1)=HRR(55,5,1)+VRR(55,5,0)
      HRR(55,6,1)=HRR(55,6,1)+VRR(55,6,0)
      HRR(55,7,1)=HRR(55,7,1)+VRR(55,7,0)
      HRR(55,8,1)=HRR(55,8,1)+VRR(55,8,0)
      HRR(55,9,1)=HRR(55,9,1)+VRR(55,9,0)
      HRR(55,10,1)=HRR(55,10,1)+VRR(55,10,0)
      HRR(56,1,1)=HRR(56,1,1)+VRR(56,1,0)
      HRR(56,11,1)=HRR(56,11,1)+SpSpK*VRR(56,1,0)
      HRR(56,15,1)=HRR(56,15,1)+SpFnK*VRR(56,1,0)
      HRR(56,2,1)=HRR(56,2,1)+VRR(56,2,0)
      HRR(56,12,1)=HRR(56,12,1)+FnSpK*VRR(56,2,0)
      HRR(56,16,1)=HRR(56,16,1)+SpFnK*VRR(56,2,0)
      HRR(56,3,1)=HRR(56,3,1)+VRR(56,3,0)
      HRR(56,13,1)=HRR(56,13,1)+FnSpK*VRR(56,3,0)
      HRR(56,17,1)=HRR(56,17,1)+SpFnK*VRR(56,3,0)
      HRR(56,4,1)=HRR(56,4,1)+VRR(56,4,0)
      HRR(56,14,1)=HRR(56,14,1)+FnSpK*VRR(56,4,0)
      HRR(56,18,1)=HRR(56,18,1)+SpFnK*VRR(56,4,0)
      HRR(56,5,1)=HRR(56,5,1)+VRR(56,5,0)
      HRR(56,6,1)=HRR(56,6,1)+VRR(56,6,0)
      HRR(56,7,1)=HRR(56,7,1)+VRR(56,7,0)
      HRR(56,8,1)=HRR(56,8,1)+VRR(56,8,0)
      HRR(56,9,1)=HRR(56,9,1)+VRR(56,9,0)
      HRR(56,10,1)=HRR(56,10,1)+VRR(56,10,0)
      HRR(57,1,1)=HRR(57,1,1)+VRR(57,1,0)
      HRR(57,11,1)=HRR(57,11,1)+SpSpK*VRR(57,1,0)
      HRR(57,15,1)=HRR(57,15,1)+SpFnK*VRR(57,1,0)
      HRR(57,2,1)=HRR(57,2,1)+VRR(57,2,0)
      HRR(57,12,1)=HRR(57,12,1)+FnSpK*VRR(57,2,0)
      HRR(57,16,1)=HRR(57,16,1)+SpFnK*VRR(57,2,0)
      HRR(57,3,1)=HRR(57,3,1)+VRR(57,3,0)
      HRR(57,13,1)=HRR(57,13,1)+FnSpK*VRR(57,3,0)
      HRR(57,17,1)=HRR(57,17,1)+SpFnK*VRR(57,3,0)
      HRR(57,4,1)=HRR(57,4,1)+VRR(57,4,0)
      HRR(57,14,1)=HRR(57,14,1)+FnSpK*VRR(57,4,0)
      HRR(57,18,1)=HRR(57,18,1)+SpFnK*VRR(57,4,0)
      HRR(57,5,1)=HRR(57,5,1)+VRR(57,5,0)
      HRR(57,6,1)=HRR(57,6,1)+VRR(57,6,0)
      HRR(57,7,1)=HRR(57,7,1)+VRR(57,7,0)
      HRR(57,8,1)=HRR(57,8,1)+VRR(57,8,0)
      HRR(57,9,1)=HRR(57,9,1)+VRR(57,9,0)
      HRR(57,10,1)=HRR(57,10,1)+VRR(57,10,0)
      HRR(58,1,1)=HRR(58,1,1)+VRR(58,1,0)
      HRR(58,11,1)=HRR(58,11,1)+SpSpK*VRR(58,1,0)
      HRR(58,15,1)=HRR(58,15,1)+SpFnK*VRR(58,1,0)
      HRR(58,2,1)=HRR(58,2,1)+VRR(58,2,0)
      HRR(58,12,1)=HRR(58,12,1)+FnSpK*VRR(58,2,0)
      HRR(58,16,1)=HRR(58,16,1)+SpFnK*VRR(58,2,0)
      HRR(58,3,1)=HRR(58,3,1)+VRR(58,3,0)
      HRR(58,13,1)=HRR(58,13,1)+FnSpK*VRR(58,3,0)
      HRR(58,17,1)=HRR(58,17,1)+SpFnK*VRR(58,3,0)
      HRR(58,4,1)=HRR(58,4,1)+VRR(58,4,0)
      HRR(58,14,1)=HRR(58,14,1)+FnSpK*VRR(58,4,0)
      HRR(58,18,1)=HRR(58,18,1)+SpFnK*VRR(58,4,0)
      HRR(58,5,1)=HRR(58,5,1)+VRR(58,5,0)
      HRR(58,6,1)=HRR(58,6,1)+VRR(58,6,0)
      HRR(58,7,1)=HRR(58,7,1)+VRR(58,7,0)
      HRR(58,8,1)=HRR(58,8,1)+VRR(58,8,0)
      HRR(58,9,1)=HRR(58,9,1)+VRR(58,9,0)
      HRR(58,10,1)=HRR(58,10,1)+VRR(58,10,0)
      HRR(59,1,1)=HRR(59,1,1)+VRR(59,1,0)
      HRR(59,11,1)=HRR(59,11,1)+SpSpK*VRR(59,1,0)
      HRR(59,15,1)=HRR(59,15,1)+SpFnK*VRR(59,1,0)
      HRR(59,2,1)=HRR(59,2,1)+VRR(59,2,0)
      HRR(59,12,1)=HRR(59,12,1)+FnSpK*VRR(59,2,0)
      HRR(59,16,1)=HRR(59,16,1)+SpFnK*VRR(59,2,0)
      HRR(59,3,1)=HRR(59,3,1)+VRR(59,3,0)
      HRR(59,13,1)=HRR(59,13,1)+FnSpK*VRR(59,3,0)
      HRR(59,17,1)=HRR(59,17,1)+SpFnK*VRR(59,3,0)
      HRR(59,4,1)=HRR(59,4,1)+VRR(59,4,0)
      HRR(59,14,1)=HRR(59,14,1)+FnSpK*VRR(59,4,0)
      HRR(59,18,1)=HRR(59,18,1)+SpFnK*VRR(59,4,0)
      HRR(59,5,1)=HRR(59,5,1)+VRR(59,5,0)
      HRR(59,6,1)=HRR(59,6,1)+VRR(59,6,0)
      HRR(59,7,1)=HRR(59,7,1)+VRR(59,7,0)
      HRR(59,8,1)=HRR(59,8,1)+VRR(59,8,0)
      HRR(59,9,1)=HRR(59,9,1)+VRR(59,9,0)
      HRR(59,10,1)=HRR(59,10,1)+VRR(59,10,0)
      HRR(60,1,1)=HRR(60,1,1)+VRR(60,1,0)
      HRR(60,11,1)=HRR(60,11,1)+SpSpK*VRR(60,1,0)
      HRR(60,15,1)=HRR(60,15,1)+SpFnK*VRR(60,1,0)
      HRR(60,2,1)=HRR(60,2,1)+VRR(60,2,0)
      HRR(60,12,1)=HRR(60,12,1)+FnSpK*VRR(60,2,0)
      HRR(60,16,1)=HRR(60,16,1)+SpFnK*VRR(60,2,0)
      HRR(60,3,1)=HRR(60,3,1)+VRR(60,3,0)
      HRR(60,13,1)=HRR(60,13,1)+FnSpK*VRR(60,3,0)
      HRR(60,17,1)=HRR(60,17,1)+SpFnK*VRR(60,3,0)
      HRR(60,4,1)=HRR(60,4,1)+VRR(60,4,0)
      HRR(60,14,1)=HRR(60,14,1)+FnSpK*VRR(60,4,0)
      HRR(60,18,1)=HRR(60,18,1)+SpFnK*VRR(60,4,0)
      HRR(60,5,1)=HRR(60,5,1)+VRR(60,5,0)
      HRR(60,6,1)=HRR(60,6,1)+VRR(60,6,0)
      HRR(60,7,1)=HRR(60,7,1)+VRR(60,7,0)
      HRR(60,8,1)=HRR(60,8,1)+VRR(60,8,0)
      HRR(60,9,1)=HRR(60,9,1)+VRR(60,9,0)
      HRR(60,10,1)=HRR(60,10,1)+VRR(60,10,0)
      HRR(61,1,1)=HRR(61,1,1)+VRR(61,1,0)
      HRR(61,11,1)=HRR(61,11,1)+SpSpK*VRR(61,1,0)
      HRR(61,15,1)=HRR(61,15,1)+SpFnK*VRR(61,1,0)
      HRR(61,2,1)=HRR(61,2,1)+VRR(61,2,0)
      HRR(61,12,1)=HRR(61,12,1)+FnSpK*VRR(61,2,0)
      HRR(61,16,1)=HRR(61,16,1)+SpFnK*VRR(61,2,0)
      HRR(61,3,1)=HRR(61,3,1)+VRR(61,3,0)
      HRR(61,13,1)=HRR(61,13,1)+FnSpK*VRR(61,3,0)
      HRR(61,17,1)=HRR(61,17,1)+SpFnK*VRR(61,3,0)
      HRR(61,4,1)=HRR(61,4,1)+VRR(61,4,0)
      HRR(61,14,1)=HRR(61,14,1)+FnSpK*VRR(61,4,0)
      HRR(61,18,1)=HRR(61,18,1)+SpFnK*VRR(61,4,0)
      HRR(61,5,1)=HRR(61,5,1)+VRR(61,5,0)
      HRR(61,6,1)=HRR(61,6,1)+VRR(61,6,0)
      HRR(61,7,1)=HRR(61,7,1)+VRR(61,7,0)
      HRR(61,8,1)=HRR(61,8,1)+VRR(61,8,0)
      HRR(61,9,1)=HRR(61,9,1)+VRR(61,9,0)
      HRR(61,10,1)=HRR(61,10,1)+VRR(61,10,0)
      HRR(62,1,1)=HRR(62,1,1)+VRR(62,1,0)
      HRR(62,11,1)=HRR(62,11,1)+SpSpK*VRR(62,1,0)
      HRR(62,15,1)=HRR(62,15,1)+SpFnK*VRR(62,1,0)
      HRR(62,2,1)=HRR(62,2,1)+VRR(62,2,0)
      HRR(62,12,1)=HRR(62,12,1)+FnSpK*VRR(62,2,0)
      HRR(62,16,1)=HRR(62,16,1)+SpFnK*VRR(62,2,0)
      HRR(62,3,1)=HRR(62,3,1)+VRR(62,3,0)
      HRR(62,13,1)=HRR(62,13,1)+FnSpK*VRR(62,3,0)
      HRR(62,17,1)=HRR(62,17,1)+SpFnK*VRR(62,3,0)
      HRR(62,4,1)=HRR(62,4,1)+VRR(62,4,0)
      HRR(62,14,1)=HRR(62,14,1)+FnSpK*VRR(62,4,0)
      HRR(62,18,1)=HRR(62,18,1)+SpFnK*VRR(62,4,0)
      HRR(62,5,1)=HRR(62,5,1)+VRR(62,5,0)
      HRR(62,6,1)=HRR(62,6,1)+VRR(62,6,0)
      HRR(62,7,1)=HRR(62,7,1)+VRR(62,7,0)
      HRR(62,8,1)=HRR(62,8,1)+VRR(62,8,0)
      HRR(62,9,1)=HRR(62,9,1)+VRR(62,9,0)
      HRR(62,10,1)=HRR(62,10,1)+VRR(62,10,0)
      HRR(63,1,1)=HRR(63,1,1)+VRR(63,1,0)
      HRR(63,11,1)=HRR(63,11,1)+SpSpK*VRR(63,1,0)
      HRR(63,15,1)=HRR(63,15,1)+SpFnK*VRR(63,1,0)
      HRR(63,2,1)=HRR(63,2,1)+VRR(63,2,0)
      HRR(63,12,1)=HRR(63,12,1)+FnSpK*VRR(63,2,0)
      HRR(63,16,1)=HRR(63,16,1)+SpFnK*VRR(63,2,0)
      HRR(63,3,1)=HRR(63,3,1)+VRR(63,3,0)
      HRR(63,13,1)=HRR(63,13,1)+FnSpK*VRR(63,3,0)
      HRR(63,17,1)=HRR(63,17,1)+SpFnK*VRR(63,3,0)
      HRR(63,4,1)=HRR(63,4,1)+VRR(63,4,0)
      HRR(63,14,1)=HRR(63,14,1)+FnSpK*VRR(63,4,0)
      HRR(63,18,1)=HRR(63,18,1)+SpFnK*VRR(63,4,0)
      HRR(63,5,1)=HRR(63,5,1)+VRR(63,5,0)
      HRR(63,6,1)=HRR(63,6,1)+VRR(63,6,0)
      HRR(63,7,1)=HRR(63,7,1)+VRR(63,7,0)
      HRR(63,8,1)=HRR(63,8,1)+VRR(63,8,0)
      HRR(63,9,1)=HRR(63,9,1)+VRR(63,9,0)
      HRR(63,10,1)=HRR(63,10,1)+VRR(63,10,0)
      HRR(64,1,1)=HRR(64,1,1)+VRR(64,1,0)
      HRR(64,11,1)=HRR(64,11,1)+SpSpK*VRR(64,1,0)
      HRR(64,15,1)=HRR(64,15,1)+SpFnK*VRR(64,1,0)
      HRR(64,2,1)=HRR(64,2,1)+VRR(64,2,0)
      HRR(64,12,1)=HRR(64,12,1)+FnSpK*VRR(64,2,0)
      HRR(64,16,1)=HRR(64,16,1)+SpFnK*VRR(64,2,0)
      HRR(64,3,1)=HRR(64,3,1)+VRR(64,3,0)
      HRR(64,13,1)=HRR(64,13,1)+FnSpK*VRR(64,3,0)
      HRR(64,17,1)=HRR(64,17,1)+SpFnK*VRR(64,3,0)
      HRR(64,4,1)=HRR(64,4,1)+VRR(64,4,0)
      HRR(64,14,1)=HRR(64,14,1)+FnSpK*VRR(64,4,0)
      HRR(64,18,1)=HRR(64,18,1)+SpFnK*VRR(64,4,0)
      HRR(64,5,1)=HRR(64,5,1)+VRR(64,5,0)
      HRR(64,6,1)=HRR(64,6,1)+VRR(64,6,0)
      HRR(64,7,1)=HRR(64,7,1)+VRR(64,7,0)
      HRR(64,8,1)=HRR(64,8,1)+VRR(64,8,0)
      HRR(64,9,1)=HRR(64,9,1)+VRR(64,9,0)
      HRR(64,10,1)=HRR(64,10,1)+VRR(64,10,0)
      HRR(65,1,1)=HRR(65,1,1)+VRR(65,1,0)
      HRR(65,11,1)=HRR(65,11,1)+SpSpK*VRR(65,1,0)
      HRR(65,15,1)=HRR(65,15,1)+SpFnK*VRR(65,1,0)
      HRR(65,2,1)=HRR(65,2,1)+VRR(65,2,0)
      HRR(65,12,1)=HRR(65,12,1)+FnSpK*VRR(65,2,0)
      HRR(65,16,1)=HRR(65,16,1)+SpFnK*VRR(65,2,0)
      HRR(65,3,1)=HRR(65,3,1)+VRR(65,3,0)
      HRR(65,13,1)=HRR(65,13,1)+FnSpK*VRR(65,3,0)
      HRR(65,17,1)=HRR(65,17,1)+SpFnK*VRR(65,3,0)
      HRR(65,4,1)=HRR(65,4,1)+VRR(65,4,0)
      HRR(65,14,1)=HRR(65,14,1)+FnSpK*VRR(65,4,0)
      HRR(65,18,1)=HRR(65,18,1)+SpFnK*VRR(65,4,0)
      HRR(65,5,1)=HRR(65,5,1)+VRR(65,5,0)
      HRR(65,6,1)=HRR(65,6,1)+VRR(65,6,0)
      HRR(65,7,1)=HRR(65,7,1)+VRR(65,7,0)
      HRR(65,8,1)=HRR(65,8,1)+VRR(65,8,0)
      HRR(65,9,1)=HRR(65,9,1)+VRR(65,9,0)
      HRR(65,10,1)=HRR(65,10,1)+VRR(65,10,0)
      HRR(66,1,1)=HRR(66,1,1)+VRR(66,1,0)
      HRR(66,11,1)=HRR(66,11,1)+SpSpK*VRR(66,1,0)
      HRR(66,15,1)=HRR(66,15,1)+SpFnK*VRR(66,1,0)
      HRR(66,2,1)=HRR(66,2,1)+VRR(66,2,0)
      HRR(66,12,1)=HRR(66,12,1)+FnSpK*VRR(66,2,0)
      HRR(66,16,1)=HRR(66,16,1)+SpFnK*VRR(66,2,0)
      HRR(66,3,1)=HRR(66,3,1)+VRR(66,3,0)
      HRR(66,13,1)=HRR(66,13,1)+FnSpK*VRR(66,3,0)
      HRR(66,17,1)=HRR(66,17,1)+SpFnK*VRR(66,3,0)
      HRR(66,4,1)=HRR(66,4,1)+VRR(66,4,0)
      HRR(66,14,1)=HRR(66,14,1)+FnSpK*VRR(66,4,0)
      HRR(66,18,1)=HRR(66,18,1)+SpFnK*VRR(66,4,0)
      HRR(66,5,1)=HRR(66,5,1)+VRR(66,5,0)
      HRR(66,6,1)=HRR(66,6,1)+VRR(66,6,0)
      HRR(66,7,1)=HRR(66,7,1)+VRR(66,7,0)
      HRR(66,8,1)=HRR(66,8,1)+VRR(66,8,0)
      HRR(66,9,1)=HRR(66,9,1)+VRR(66,9,0)
      HRR(66,10,1)=HRR(66,10,1)+VRR(66,10,0)
      HRR(67,1,1)=HRR(67,1,1)+VRR(67,1,0)
      HRR(67,11,1)=HRR(67,11,1)+SpSpK*VRR(67,1,0)
      HRR(67,15,1)=HRR(67,15,1)+SpFnK*VRR(67,1,0)
      HRR(67,2,1)=HRR(67,2,1)+VRR(67,2,0)
      HRR(67,12,1)=HRR(67,12,1)+FnSpK*VRR(67,2,0)
      HRR(67,16,1)=HRR(67,16,1)+SpFnK*VRR(67,2,0)
      HRR(67,3,1)=HRR(67,3,1)+VRR(67,3,0)
      HRR(67,13,1)=HRR(67,13,1)+FnSpK*VRR(67,3,0)
      HRR(67,17,1)=HRR(67,17,1)+SpFnK*VRR(67,3,0)
      HRR(67,4,1)=HRR(67,4,1)+VRR(67,4,0)
      HRR(67,14,1)=HRR(67,14,1)+FnSpK*VRR(67,4,0)
      HRR(67,18,1)=HRR(67,18,1)+SpFnK*VRR(67,4,0)
      HRR(67,5,1)=HRR(67,5,1)+VRR(67,5,0)
      HRR(67,6,1)=HRR(67,6,1)+VRR(67,6,0)
      HRR(67,7,1)=HRR(67,7,1)+VRR(67,7,0)
      HRR(67,8,1)=HRR(67,8,1)+VRR(67,8,0)
      HRR(67,9,1)=HRR(67,9,1)+VRR(67,9,0)
      HRR(67,10,1)=HRR(67,10,1)+VRR(67,10,0)
      HRR(68,1,1)=HRR(68,1,1)+VRR(68,1,0)
      HRR(68,11,1)=HRR(68,11,1)+SpSpK*VRR(68,1,0)
      HRR(68,15,1)=HRR(68,15,1)+SpFnK*VRR(68,1,0)
      HRR(68,2,1)=HRR(68,2,1)+VRR(68,2,0)
      HRR(68,12,1)=HRR(68,12,1)+FnSpK*VRR(68,2,0)
      HRR(68,16,1)=HRR(68,16,1)+SpFnK*VRR(68,2,0)
      HRR(68,3,1)=HRR(68,3,1)+VRR(68,3,0)
      HRR(68,13,1)=HRR(68,13,1)+FnSpK*VRR(68,3,0)
      HRR(68,17,1)=HRR(68,17,1)+SpFnK*VRR(68,3,0)
      HRR(68,4,1)=HRR(68,4,1)+VRR(68,4,0)
      HRR(68,14,1)=HRR(68,14,1)+FnSpK*VRR(68,4,0)
      HRR(68,18,1)=HRR(68,18,1)+SpFnK*VRR(68,4,0)
      HRR(68,5,1)=HRR(68,5,1)+VRR(68,5,0)
      HRR(68,6,1)=HRR(68,6,1)+VRR(68,6,0)
      HRR(68,7,1)=HRR(68,7,1)+VRR(68,7,0)
      HRR(68,8,1)=HRR(68,8,1)+VRR(68,8,0)
      HRR(68,9,1)=HRR(68,9,1)+VRR(68,9,0)
      HRR(68,10,1)=HRR(68,10,1)+VRR(68,10,0)
      HRR(69,1,1)=HRR(69,1,1)+VRR(69,1,0)
      HRR(69,11,1)=HRR(69,11,1)+SpSpK*VRR(69,1,0)
      HRR(69,15,1)=HRR(69,15,1)+SpFnK*VRR(69,1,0)
      HRR(69,2,1)=HRR(69,2,1)+VRR(69,2,0)
      HRR(69,12,1)=HRR(69,12,1)+FnSpK*VRR(69,2,0)
      HRR(69,16,1)=HRR(69,16,1)+SpFnK*VRR(69,2,0)
      HRR(69,3,1)=HRR(69,3,1)+VRR(69,3,0)
      HRR(69,13,1)=HRR(69,13,1)+FnSpK*VRR(69,3,0)
      HRR(69,17,1)=HRR(69,17,1)+SpFnK*VRR(69,3,0)
      HRR(69,4,1)=HRR(69,4,1)+VRR(69,4,0)
      HRR(69,14,1)=HRR(69,14,1)+FnSpK*VRR(69,4,0)
      HRR(69,18,1)=HRR(69,18,1)+SpFnK*VRR(69,4,0)
      HRR(69,5,1)=HRR(69,5,1)+VRR(69,5,0)
      HRR(69,6,1)=HRR(69,6,1)+VRR(69,6,0)
      HRR(69,7,1)=HRR(69,7,1)+VRR(69,7,0)
      HRR(69,8,1)=HRR(69,8,1)+VRR(69,8,0)
      HRR(69,9,1)=HRR(69,9,1)+VRR(69,9,0)
      HRR(69,10,1)=HRR(69,10,1)+VRR(69,10,0)
      HRR(70,1,1)=HRR(70,1,1)+VRR(70,1,0)
      HRR(70,11,1)=HRR(70,11,1)+SpSpK*VRR(70,1,0)
      HRR(70,15,1)=HRR(70,15,1)+SpFnK*VRR(70,1,0)
      HRR(70,2,1)=HRR(70,2,1)+VRR(70,2,0)
      HRR(70,12,1)=HRR(70,12,1)+FnSpK*VRR(70,2,0)
      HRR(70,16,1)=HRR(70,16,1)+SpFnK*VRR(70,2,0)
      HRR(70,3,1)=HRR(70,3,1)+VRR(70,3,0)
      HRR(70,13,1)=HRR(70,13,1)+FnSpK*VRR(70,3,0)
      HRR(70,17,1)=HRR(70,17,1)+SpFnK*VRR(70,3,0)
      HRR(70,4,1)=HRR(70,4,1)+VRR(70,4,0)
      HRR(70,14,1)=HRR(70,14,1)+FnSpK*VRR(70,4,0)
      HRR(70,18,1)=HRR(70,18,1)+SpFnK*VRR(70,4,0)
      HRR(70,5,1)=HRR(70,5,1)+VRR(70,5,0)
      HRR(70,6,1)=HRR(70,6,1)+VRR(70,6,0)
      HRR(70,7,1)=HRR(70,7,1)+VRR(70,7,0)
      HRR(70,8,1)=HRR(70,8,1)+VRR(70,8,0)
      HRR(70,9,1)=HRR(70,9,1)+VRR(70,9,0)
      HRR(70,10,1)=HRR(70,10,1)+VRR(70,10,0)
      HRR(71,1,1)=HRR(71,1,1)+VRR(71,1,0)
      HRR(71,11,1)=HRR(71,11,1)+SpSpK*VRR(71,1,0)
      HRR(71,15,1)=HRR(71,15,1)+SpFnK*VRR(71,1,0)
      HRR(71,2,1)=HRR(71,2,1)+VRR(71,2,0)
      HRR(71,12,1)=HRR(71,12,1)+FnSpK*VRR(71,2,0)
      HRR(71,16,1)=HRR(71,16,1)+SpFnK*VRR(71,2,0)
      HRR(71,3,1)=HRR(71,3,1)+VRR(71,3,0)
      HRR(71,13,1)=HRR(71,13,1)+FnSpK*VRR(71,3,0)
      HRR(71,17,1)=HRR(71,17,1)+SpFnK*VRR(71,3,0)
      HRR(71,4,1)=HRR(71,4,1)+VRR(71,4,0)
      HRR(71,14,1)=HRR(71,14,1)+FnSpK*VRR(71,4,0)
      HRR(71,18,1)=HRR(71,18,1)+SpFnK*VRR(71,4,0)
      HRR(71,5,1)=HRR(71,5,1)+VRR(71,5,0)
      HRR(71,6,1)=HRR(71,6,1)+VRR(71,6,0)
      HRR(71,7,1)=HRR(71,7,1)+VRR(71,7,0)
      HRR(71,8,1)=HRR(71,8,1)+VRR(71,8,0)
      HRR(71,9,1)=HRR(71,9,1)+VRR(71,9,0)
      HRR(71,10,1)=HRR(71,10,1)+VRR(71,10,0)
      HRR(72,1,1)=HRR(72,1,1)+VRR(72,1,0)
      HRR(72,11,1)=HRR(72,11,1)+SpSpK*VRR(72,1,0)
      HRR(72,15,1)=HRR(72,15,1)+SpFnK*VRR(72,1,0)
      HRR(72,2,1)=HRR(72,2,1)+VRR(72,2,0)
      HRR(72,12,1)=HRR(72,12,1)+FnSpK*VRR(72,2,0)
      HRR(72,16,1)=HRR(72,16,1)+SpFnK*VRR(72,2,0)
      HRR(72,3,1)=HRR(72,3,1)+VRR(72,3,0)
      HRR(72,13,1)=HRR(72,13,1)+FnSpK*VRR(72,3,0)
      HRR(72,17,1)=HRR(72,17,1)+SpFnK*VRR(72,3,0)
      HRR(72,4,1)=HRR(72,4,1)+VRR(72,4,0)
      HRR(72,14,1)=HRR(72,14,1)+FnSpK*VRR(72,4,0)
      HRR(72,18,1)=HRR(72,18,1)+SpFnK*VRR(72,4,0)
      HRR(72,5,1)=HRR(72,5,1)+VRR(72,5,0)
      HRR(72,6,1)=HRR(72,6,1)+VRR(72,6,0)
      HRR(72,7,1)=HRR(72,7,1)+VRR(72,7,0)
      HRR(72,8,1)=HRR(72,8,1)+VRR(72,8,0)
      HRR(72,9,1)=HRR(72,9,1)+VRR(72,9,0)
      HRR(72,10,1)=HRR(72,10,1)+VRR(72,10,0)
      HRR(73,1,1)=HRR(73,1,1)+VRR(73,1,0)
      HRR(73,11,1)=HRR(73,11,1)+SpSpK*VRR(73,1,0)
      HRR(73,15,1)=HRR(73,15,1)+SpFnK*VRR(73,1,0)
      HRR(73,2,1)=HRR(73,2,1)+VRR(73,2,0)
      HRR(73,12,1)=HRR(73,12,1)+FnSpK*VRR(73,2,0)
      HRR(73,16,1)=HRR(73,16,1)+SpFnK*VRR(73,2,0)
      HRR(73,3,1)=HRR(73,3,1)+VRR(73,3,0)
      HRR(73,13,1)=HRR(73,13,1)+FnSpK*VRR(73,3,0)
      HRR(73,17,1)=HRR(73,17,1)+SpFnK*VRR(73,3,0)
      HRR(73,4,1)=HRR(73,4,1)+VRR(73,4,0)
      HRR(73,14,1)=HRR(73,14,1)+FnSpK*VRR(73,4,0)
      HRR(73,18,1)=HRR(73,18,1)+SpFnK*VRR(73,4,0)
      HRR(73,5,1)=HRR(73,5,1)+VRR(73,5,0)
      HRR(73,6,1)=HRR(73,6,1)+VRR(73,6,0)
      HRR(73,7,1)=HRR(73,7,1)+VRR(73,7,0)
      HRR(73,8,1)=HRR(73,8,1)+VRR(73,8,0)
      HRR(73,9,1)=HRR(73,9,1)+VRR(73,9,0)
      HRR(73,10,1)=HRR(73,10,1)+VRR(73,10,0)
      HRR(74,1,1)=HRR(74,1,1)+VRR(74,1,0)
      HRR(74,11,1)=HRR(74,11,1)+SpSpK*VRR(74,1,0)
      HRR(74,15,1)=HRR(74,15,1)+SpFnK*VRR(74,1,0)
      HRR(74,2,1)=HRR(74,2,1)+VRR(74,2,0)
      HRR(74,12,1)=HRR(74,12,1)+FnSpK*VRR(74,2,0)
      HRR(74,16,1)=HRR(74,16,1)+SpFnK*VRR(74,2,0)
      HRR(74,3,1)=HRR(74,3,1)+VRR(74,3,0)
      HRR(74,13,1)=HRR(74,13,1)+FnSpK*VRR(74,3,0)
      HRR(74,17,1)=HRR(74,17,1)+SpFnK*VRR(74,3,0)
      HRR(74,4,1)=HRR(74,4,1)+VRR(74,4,0)
      HRR(74,14,1)=HRR(74,14,1)+FnSpK*VRR(74,4,0)
      HRR(74,18,1)=HRR(74,18,1)+SpFnK*VRR(74,4,0)
      HRR(74,5,1)=HRR(74,5,1)+VRR(74,5,0)
      HRR(74,6,1)=HRR(74,6,1)+VRR(74,6,0)
      HRR(74,7,1)=HRR(74,7,1)+VRR(74,7,0)
      HRR(74,8,1)=HRR(74,8,1)+VRR(74,8,0)
      HRR(74,9,1)=HRR(74,9,1)+VRR(74,9,0)
      HRR(74,10,1)=HRR(74,10,1)+VRR(74,10,0)
      HRR(75,1,1)=HRR(75,1,1)+VRR(75,1,0)
      HRR(75,11,1)=HRR(75,11,1)+SpSpK*VRR(75,1,0)
      HRR(75,15,1)=HRR(75,15,1)+SpFnK*VRR(75,1,0)
      HRR(75,2,1)=HRR(75,2,1)+VRR(75,2,0)
      HRR(75,12,1)=HRR(75,12,1)+FnSpK*VRR(75,2,0)
      HRR(75,16,1)=HRR(75,16,1)+SpFnK*VRR(75,2,0)
      HRR(75,3,1)=HRR(75,3,1)+VRR(75,3,0)
      HRR(75,13,1)=HRR(75,13,1)+FnSpK*VRR(75,3,0)
      HRR(75,17,1)=HRR(75,17,1)+SpFnK*VRR(75,3,0)
      HRR(75,4,1)=HRR(75,4,1)+VRR(75,4,0)
      HRR(75,14,1)=HRR(75,14,1)+FnSpK*VRR(75,4,0)
      HRR(75,18,1)=HRR(75,18,1)+SpFnK*VRR(75,4,0)
      HRR(75,5,1)=HRR(75,5,1)+VRR(75,5,0)
      HRR(75,6,1)=HRR(75,6,1)+VRR(75,6,0)
      HRR(75,7,1)=HRR(75,7,1)+VRR(75,7,0)
      HRR(75,8,1)=HRR(75,8,1)+VRR(75,8,0)
      HRR(75,9,1)=HRR(75,9,1)+VRR(75,9,0)
      HRR(75,10,1)=HRR(75,10,1)+VRR(75,10,0)
      HRR(76,1,1)=HRR(76,1,1)+VRR(76,1,0)
      HRR(76,11,1)=HRR(76,11,1)+SpSpK*VRR(76,1,0)
      HRR(76,15,1)=HRR(76,15,1)+SpFnK*VRR(76,1,0)
      HRR(76,2,1)=HRR(76,2,1)+VRR(76,2,0)
      HRR(76,12,1)=HRR(76,12,1)+FnSpK*VRR(76,2,0)
      HRR(76,16,1)=HRR(76,16,1)+SpFnK*VRR(76,2,0)
      HRR(76,3,1)=HRR(76,3,1)+VRR(76,3,0)
      HRR(76,13,1)=HRR(76,13,1)+FnSpK*VRR(76,3,0)
      HRR(76,17,1)=HRR(76,17,1)+SpFnK*VRR(76,3,0)
      HRR(76,4,1)=HRR(76,4,1)+VRR(76,4,0)
      HRR(76,14,1)=HRR(76,14,1)+FnSpK*VRR(76,4,0)
      HRR(76,18,1)=HRR(76,18,1)+SpFnK*VRR(76,4,0)
      HRR(76,5,1)=HRR(76,5,1)+VRR(76,5,0)
      HRR(76,6,1)=HRR(76,6,1)+VRR(76,6,0)
      HRR(76,7,1)=HRR(76,7,1)+VRR(76,7,0)
      HRR(76,8,1)=HRR(76,8,1)+VRR(76,8,0)
      HRR(76,9,1)=HRR(76,9,1)+VRR(76,9,0)
      HRR(76,10,1)=HRR(76,10,1)+VRR(76,10,0)
      HRR(77,1,1)=HRR(77,1,1)+VRR(77,1,0)
      HRR(77,11,1)=HRR(77,11,1)+SpSpK*VRR(77,1,0)
      HRR(77,15,1)=HRR(77,15,1)+SpFnK*VRR(77,1,0)
      HRR(77,2,1)=HRR(77,2,1)+VRR(77,2,0)
      HRR(77,12,1)=HRR(77,12,1)+FnSpK*VRR(77,2,0)
      HRR(77,16,1)=HRR(77,16,1)+SpFnK*VRR(77,2,0)
      HRR(77,3,1)=HRR(77,3,1)+VRR(77,3,0)
      HRR(77,13,1)=HRR(77,13,1)+FnSpK*VRR(77,3,0)
      HRR(77,17,1)=HRR(77,17,1)+SpFnK*VRR(77,3,0)
      HRR(77,4,1)=HRR(77,4,1)+VRR(77,4,0)
      HRR(77,14,1)=HRR(77,14,1)+FnSpK*VRR(77,4,0)
      HRR(77,18,1)=HRR(77,18,1)+SpFnK*VRR(77,4,0)
      HRR(77,5,1)=HRR(77,5,1)+VRR(77,5,0)
      HRR(77,6,1)=HRR(77,6,1)+VRR(77,6,0)
      HRR(77,7,1)=HRR(77,7,1)+VRR(77,7,0)
      HRR(77,8,1)=HRR(77,8,1)+VRR(77,8,0)
      HRR(77,9,1)=HRR(77,9,1)+VRR(77,9,0)
      HRR(77,10,1)=HRR(77,10,1)+VRR(77,10,0)
      HRR(78,1,1)=HRR(78,1,1)+VRR(78,1,0)
      HRR(78,11,1)=HRR(78,11,1)+SpSpK*VRR(78,1,0)
      HRR(78,15,1)=HRR(78,15,1)+SpFnK*VRR(78,1,0)
      HRR(78,2,1)=HRR(78,2,1)+VRR(78,2,0)
      HRR(78,12,1)=HRR(78,12,1)+FnSpK*VRR(78,2,0)
      HRR(78,16,1)=HRR(78,16,1)+SpFnK*VRR(78,2,0)
      HRR(78,3,1)=HRR(78,3,1)+VRR(78,3,0)
      HRR(78,13,1)=HRR(78,13,1)+FnSpK*VRR(78,3,0)
      HRR(78,17,1)=HRR(78,17,1)+SpFnK*VRR(78,3,0)
      HRR(78,4,1)=HRR(78,4,1)+VRR(78,4,0)
      HRR(78,14,1)=HRR(78,14,1)+FnSpK*VRR(78,4,0)
      HRR(78,18,1)=HRR(78,18,1)+SpFnK*VRR(78,4,0)
      HRR(78,5,1)=HRR(78,5,1)+VRR(78,5,0)
      HRR(78,6,1)=HRR(78,6,1)+VRR(78,6,0)
      HRR(78,7,1)=HRR(78,7,1)+VRR(78,7,0)
      HRR(78,8,1)=HRR(78,8,1)+VRR(78,8,0)
      HRR(78,9,1)=HRR(78,9,1)+VRR(78,9,0)
      HRR(78,10,1)=HRR(78,10,1)+VRR(78,10,0)
      HRR(79,1,1)=HRR(79,1,1)+VRR(79,1,0)
      HRR(79,11,1)=HRR(79,11,1)+SpSpK*VRR(79,1,0)
      HRR(79,15,1)=HRR(79,15,1)+SpFnK*VRR(79,1,0)
      HRR(79,2,1)=HRR(79,2,1)+VRR(79,2,0)
      HRR(79,12,1)=HRR(79,12,1)+FnSpK*VRR(79,2,0)
      HRR(79,16,1)=HRR(79,16,1)+SpFnK*VRR(79,2,0)
      HRR(79,3,1)=HRR(79,3,1)+VRR(79,3,0)
      HRR(79,13,1)=HRR(79,13,1)+FnSpK*VRR(79,3,0)
      HRR(79,17,1)=HRR(79,17,1)+SpFnK*VRR(79,3,0)
      HRR(79,4,1)=HRR(79,4,1)+VRR(79,4,0)
      HRR(79,14,1)=HRR(79,14,1)+FnSpK*VRR(79,4,0)
      HRR(79,18,1)=HRR(79,18,1)+SpFnK*VRR(79,4,0)
      HRR(79,5,1)=HRR(79,5,1)+VRR(79,5,0)
      HRR(79,6,1)=HRR(79,6,1)+VRR(79,6,0)
      HRR(79,7,1)=HRR(79,7,1)+VRR(79,7,0)
      HRR(79,8,1)=HRR(79,8,1)+VRR(79,8,0)
      HRR(79,9,1)=HRR(79,9,1)+VRR(79,9,0)
      HRR(79,10,1)=HRR(79,10,1)+VRR(79,10,0)
      HRR(80,1,1)=HRR(80,1,1)+VRR(80,1,0)
      HRR(80,11,1)=HRR(80,11,1)+SpSpK*VRR(80,1,0)
      HRR(80,15,1)=HRR(80,15,1)+SpFnK*VRR(80,1,0)
      HRR(80,2,1)=HRR(80,2,1)+VRR(80,2,0)
      HRR(80,12,1)=HRR(80,12,1)+FnSpK*VRR(80,2,0)
      HRR(80,16,1)=HRR(80,16,1)+SpFnK*VRR(80,2,0)
      HRR(80,3,1)=HRR(80,3,1)+VRR(80,3,0)
      HRR(80,13,1)=HRR(80,13,1)+FnSpK*VRR(80,3,0)
      HRR(80,17,1)=HRR(80,17,1)+SpFnK*VRR(80,3,0)
      HRR(80,4,1)=HRR(80,4,1)+VRR(80,4,0)
      HRR(80,14,1)=HRR(80,14,1)+FnSpK*VRR(80,4,0)
      HRR(80,18,1)=HRR(80,18,1)+SpFnK*VRR(80,4,0)
      HRR(80,5,1)=HRR(80,5,1)+VRR(80,5,0)
      HRR(80,6,1)=HRR(80,6,1)+VRR(80,6,0)
      HRR(80,7,1)=HRR(80,7,1)+VRR(80,7,0)
      HRR(80,8,1)=HRR(80,8,1)+VRR(80,8,0)
      HRR(80,9,1)=HRR(80,9,1)+VRR(80,9,0)
      HRR(80,10,1)=HRR(80,10,1)+VRR(80,10,0)
      HRR(81,1,1)=HRR(81,1,1)+VRR(81,1,0)
      HRR(81,11,1)=HRR(81,11,1)+SpSpK*VRR(81,1,0)
      HRR(81,15,1)=HRR(81,15,1)+SpFnK*VRR(81,1,0)
      HRR(81,2,1)=HRR(81,2,1)+VRR(81,2,0)
      HRR(81,12,1)=HRR(81,12,1)+FnSpK*VRR(81,2,0)
      HRR(81,16,1)=HRR(81,16,1)+SpFnK*VRR(81,2,0)
      HRR(81,3,1)=HRR(81,3,1)+VRR(81,3,0)
      HRR(81,13,1)=HRR(81,13,1)+FnSpK*VRR(81,3,0)
      HRR(81,17,1)=HRR(81,17,1)+SpFnK*VRR(81,3,0)
      HRR(81,4,1)=HRR(81,4,1)+VRR(81,4,0)
      HRR(81,14,1)=HRR(81,14,1)+FnSpK*VRR(81,4,0)
      HRR(81,18,1)=HRR(81,18,1)+SpFnK*VRR(81,4,0)
      HRR(81,5,1)=HRR(81,5,1)+VRR(81,5,0)
      HRR(81,6,1)=HRR(81,6,1)+VRR(81,6,0)
      HRR(81,7,1)=HRR(81,7,1)+VRR(81,7,0)
      HRR(81,8,1)=HRR(81,8,1)+VRR(81,8,0)
      HRR(81,9,1)=HRR(81,9,1)+VRR(81,9,0)
      HRR(81,10,1)=HRR(81,10,1)+VRR(81,10,0)
      HRR(82,1,1)=HRR(82,1,1)+VRR(82,1,0)
      HRR(82,11,1)=HRR(82,11,1)+SpSpK*VRR(82,1,0)
      HRR(82,15,1)=HRR(82,15,1)+SpFnK*VRR(82,1,0)
      HRR(82,2,1)=HRR(82,2,1)+VRR(82,2,0)
      HRR(82,12,1)=HRR(82,12,1)+FnSpK*VRR(82,2,0)
      HRR(82,16,1)=HRR(82,16,1)+SpFnK*VRR(82,2,0)
      HRR(82,3,1)=HRR(82,3,1)+VRR(82,3,0)
      HRR(82,13,1)=HRR(82,13,1)+FnSpK*VRR(82,3,0)
      HRR(82,17,1)=HRR(82,17,1)+SpFnK*VRR(82,3,0)
      HRR(82,4,1)=HRR(82,4,1)+VRR(82,4,0)
      HRR(82,14,1)=HRR(82,14,1)+FnSpK*VRR(82,4,0)
      HRR(82,18,1)=HRR(82,18,1)+SpFnK*VRR(82,4,0)
      HRR(82,5,1)=HRR(82,5,1)+VRR(82,5,0)
      HRR(82,6,1)=HRR(82,6,1)+VRR(82,6,0)
      HRR(82,7,1)=HRR(82,7,1)+VRR(82,7,0)
      HRR(82,8,1)=HRR(82,8,1)+VRR(82,8,0)
      HRR(82,9,1)=HRR(82,9,1)+VRR(82,9,0)
      HRR(82,10,1)=HRR(82,10,1)+VRR(82,10,0)
      HRR(83,1,1)=HRR(83,1,1)+VRR(83,1,0)
      HRR(83,11,1)=HRR(83,11,1)+SpSpK*VRR(83,1,0)
      HRR(83,15,1)=HRR(83,15,1)+SpFnK*VRR(83,1,0)
      HRR(83,2,1)=HRR(83,2,1)+VRR(83,2,0)
      HRR(83,12,1)=HRR(83,12,1)+FnSpK*VRR(83,2,0)
      HRR(83,16,1)=HRR(83,16,1)+SpFnK*VRR(83,2,0)
      HRR(83,3,1)=HRR(83,3,1)+VRR(83,3,0)
      HRR(83,13,1)=HRR(83,13,1)+FnSpK*VRR(83,3,0)
      HRR(83,17,1)=HRR(83,17,1)+SpFnK*VRR(83,3,0)
      HRR(83,4,1)=HRR(83,4,1)+VRR(83,4,0)
      HRR(83,14,1)=HRR(83,14,1)+FnSpK*VRR(83,4,0)
      HRR(83,18,1)=HRR(83,18,1)+SpFnK*VRR(83,4,0)
      HRR(83,5,1)=HRR(83,5,1)+VRR(83,5,0)
      HRR(83,6,1)=HRR(83,6,1)+VRR(83,6,0)
      HRR(83,7,1)=HRR(83,7,1)+VRR(83,7,0)
      HRR(83,8,1)=HRR(83,8,1)+VRR(83,8,0)
      HRR(83,9,1)=HRR(83,9,1)+VRR(83,9,0)
      HRR(83,10,1)=HRR(83,10,1)+VRR(83,10,0)
      HRR(84,1,1)=HRR(84,1,1)+VRR(84,1,0)
      HRR(84,11,1)=HRR(84,11,1)+SpSpK*VRR(84,1,0)
      HRR(84,15,1)=HRR(84,15,1)+SpFnK*VRR(84,1,0)
      HRR(84,2,1)=HRR(84,2,1)+VRR(84,2,0)
      HRR(84,12,1)=HRR(84,12,1)+FnSpK*VRR(84,2,0)
      HRR(84,16,1)=HRR(84,16,1)+SpFnK*VRR(84,2,0)
      HRR(84,3,1)=HRR(84,3,1)+VRR(84,3,0)
      HRR(84,13,1)=HRR(84,13,1)+FnSpK*VRR(84,3,0)
      HRR(84,17,1)=HRR(84,17,1)+SpFnK*VRR(84,3,0)
      HRR(84,4,1)=HRR(84,4,1)+VRR(84,4,0)
      HRR(84,14,1)=HRR(84,14,1)+FnSpK*VRR(84,4,0)
      HRR(84,18,1)=HRR(84,18,1)+SpFnK*VRR(84,4,0)
      HRR(84,5,1)=HRR(84,5,1)+VRR(84,5,0)
      HRR(84,6,1)=HRR(84,6,1)+VRR(84,6,0)
      HRR(84,7,1)=HRR(84,7,1)+VRR(84,7,0)
      HRR(84,8,1)=HRR(84,8,1)+VRR(84,8,0)
      HRR(84,9,1)=HRR(84,9,1)+VRR(84,9,0)
      HRR(84,10,1)=HRR(84,10,1)+VRR(84,10,0)
    END SUBROUTINE CNTRCT101022
