!------------------------------------------------------------------------------
!    This code is part of the MondoSCF suite of programs for linear scaling
!    electronic structure theory and ab initio molecular dynamics.
!
!    Copyright (2004). The Regents of the University of California. This
!    material was produced under U.S. Government contract W-7405-ENG-36
!    for Los Alamos National Laboratory, which is operated by the University
!    of California for the U.S. Department of Energy. The U.S. Government has
!    rights to use, reproduce, and distribute this software.  NEITHER THE
!    GOVERNMENT NOR THE UNIVERSITY MAKES ANY WARRANTY, EXPRESS OR IMPLIED,
!    OR ASSUMES ANY LIABILITY FOR THE USE OF THIS SOFTWARE.
!
!    This program is free software; you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by the
!    Free Software Foundation; either version 2 of the License, or (at your
!    option) any later version. Accordingly, this program is distributed in
!    the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
!    the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
!    PURPOSE. See the GNU General Public License at www.gnu.org for details.
!
!    While you may do as you like with this software, the GNU license requires
!    that you clearly mark derivative software.  In addition, you are encouraged
!    to return derivative works to the MondoSCF group for review, and possible
!    disemination in future releases.
!------------------------------------------------------------------------------
! ----------------------------------------------------------
! COMPUTES THE INTEGRAL CLASS (f d|f d)
! ----------------------------------------------------------
SUBROUTINE dIntB10061006(PrmBufB,LBra,PrmBufK,LKet,ACInfo,BDInfo, &
 OA,LDA,OB,LDB,OC,LDC,OD,LDD,GOA,GOB,GOC,GOD,NINT,PBC,GRADIENTS,STRESS)
       USE DerivedTypes
      USE VScratchB
      USE GlobalScalars
      USE ShellPairStruct
      USE GammaF11
      IMPLICIT REAL(DOUBLE) (W)
      INTEGER        :: LBra,LKet,NINT,CDOffSet
      REAL(DOUBLE)   :: PrmBufB(10,LBra),PrmBufK(10,LKet)
      TYPE(SmallAtomInfo) :: ACInfo,BDInfo
      TYPE(PBCInfo) :: PBC
      REAL(DOUBLE)  :: GRADIENTS(NINT,12)
      REAL(DOUBLE)  :: STRESS(NINT,9)
      REAL(DOUBLE)  :: Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz
      REAL(DOUBLE)  :: Dx,Dy,Dz,Qx,Qy,Qz,Px,Py,Pz
      REAL(DOUBLE)  :: PQx,PQy,PQz,FPQx,FPQy,FPQz
      REAL(DOUBLE)  :: Zeta,Eta,Omega,Up,Uq,Upq
      REAL(DOUBLE)  :: T,ET,TwoT,InvT,SqInvT
      REAL(DOUBLE)  :: Alpha,Beta,Gamma
      REAL(DOUBLE), DIMENSION(84) :: HRRTmp
      REAL(DOUBLE), DIMENSION(56,56,10) :: HRR
      REAL(DOUBLE), DIMENSION(84,56,10) :: HRRA,HRRB
      REAL(DOUBLE), DIMENSION(56,84,10) :: HRRC
      REAL(DOUBLE)  :: VRR(84,84,0:11)
      REAL(DOUBLE)  :: VRRS(56,56,0:10,3)
      REAL(DOUBLE)  :: HRRS(56,56,10,9)
      REAL(DOUBLE)  :: TOm,PQJ(3),FP(9)
      INTEGER       :: OffSet,OA,LDA,GOA,OB,LDB,GOB,OC,LDC,GOC,OD,LDD,GOD,I,J,K,L,IJ
      EXTERNAL InitDbl
      CALL InitDbl(56*56,HRR(1,1,1))
      CALL InitDbl(84*56,HRRA(1,1,1))
      CALL InitDbl(84*56,HRRB(1,1,1))
      CALL InitDbl(56*84,HRRC(1,1,1))
      CALL InitDbl(9*10*56*56,HRRS(1,1,1,1))
      Ax=ACInfo%Atm1X
      Ay=ACInfo%Atm1Y
      Az=ACInfo%Atm1Z
      Bx=ACInfo%Atm2X
      By=ACInfo%Atm2Y
      Bz=ACInfo%Atm2Z
      Cx=BDInfo%Atm1X
      Cy=BDInfo%Atm1Y
      Cz=BDInfo%Atm1Z
      Dx=BDInfo%Atm2X
      Dy=BDInfo%Atm2Y
      Dz=BDInfo%Atm2Z
      ABx=Ax-Bx
      ABy=Ay-By
      ABz=Az-Bz
      CDx=Cx-Dx
      CDy=Cy-Dy
      CDz=Cz-Dz
      !
      !This will feel better above!
      FP(1)=PBC%InvBoxSh%D(1,1)*(Ax-Dx)+PBC%InvBoxSh%D(1,2)*(Ay-Dy)+PBC%InvBoxSh%D(1,3)*(Az-Dz)
      FP(2)=                            PBC%InvBoxSh%D(2,2)*(Ay-Dy)+PBC%InvBoxSh%D(2,3)*(Az-Dz)
      FP(3)=                                                        PBC%InvBoxSh%D(3,3)*(Az-Dz)
      FP(4)=PBC%InvBoxSh%D(1,1)*(Cx-Dx)+PBC%InvBoxSh%D(1,2)*(Cy-Dy)+PBC%InvBoxSh%D(1,3)*(Cz-Dz)
      FP(5)=                            PBC%InvBoxSh%D(2,2)*(Cy-Dy)+PBC%InvBoxSh%D(2,3)*(Cz-Dz)
      FP(6)=                                                        PBC%InvBoxSh%D(3,3)*(Cz-Dz)
      FP(7)=PBC%InvBoxSh%D(1,1)*(Bx-Dx)+PBC%InvBoxSh%D(1,2)*(By-Dy)+PBC%InvBoxSh%D(1,3)*(Bz-Dz)
      FP(8)=                            PBC%InvBoxSh%D(2,2)*(By-Dy)+PBC%InvBoxSh%D(2,3)*(Bz-Dz)
      FP(9)=                                                        PBC%InvBoxSh%D(3,3)*(Bz-Dz)
      !
      DO J=1,LKet ! K^2 VRR |N0) loop
         Eta=PrmBufK(1,J)
         Qx=PrmBufK(2,J)
         Qy=PrmBufK(3,J)
         Qz=PrmBufK(4,J)
         Uq=PrmBufK(5,J)
         Gamma =PrmBufK(9,J)
         QCx=Qx-Cx
         QCy=Qy-Cy
         QCz=Qz-Cz
         DO K=1,LBra ! K^2 VRR (M0| loop
            Zeta=PrmBufB(1,K)
            Px=PrmBufB(2,K)
            Py=PrmBufB(3,K)
            Pz=PrmBufB(4,K)
            Up=PrmBufB(5,K)
            Alpha =PrmBufB(9,K)
            Beta  =PrmBufB(10,K)
            r1xZpE=One/(Zeta+Eta)
            Upq=SQRT(r1xZpE)*Up*Uq
            HfxZpE=Half/(Zeta+Eta)
            r1x2E=Half/Eta
            r1x2Z=Half/Zeta
            ExZpE=Eta*r1xZpE
            ZxZpE=Zeta*r1xZpE
            Omega=Eta*Zeta*r1xZpE
            PAx=Px-Ax
            PAy=Py-Ay
            PAz=Pz-Az
            PQx=Px-Qx
            PQy=Py-Qy
            PQz=Pz-Qz
            ! Begin Minimum Image Convention
            FPQx = PQx*PBC%InvBoxSh%D(1,1)+PQy*PBC%InvBoxSh%D(1,2)+PQz*PBC%InvBoxSh%D(1,3)
            FPQy = PQy*PBC%InvBoxSh%D(2,2)+PQz*PBC%InvBoxSh%D(2,3)
            FPQz = PQz*PBC%InvBoxSh%D(3,3)
            TOm=2.0d0*Omega
            IF(PBC%AutoW%I(1)==1) THEN
              PQJ(1)=ANINT(FPQx-SIGN(1D-15,FPQx));FPQx=FPQx-PQJ(1)
              PQJ(1)=PQJ(1)*TOm
            ELSE
              PQJ(1)=0.0D0
            ENDIF
            IF(PBC%AutoW%I(2)==1) THEN
              PQJ(2)=ANINT(FPQy-SIGN(1D-15,FPQy));FPQy=FPQy-PQJ(2)
              PQJ(2)=PQJ(2)*TOm
            ELSE
              PQJ(2)=0.0D0
            ENDIF
            IF(PBC%AutoW%I(3)==1) THEN
              PQJ(3)=ANINT(FPQz-SIGN(1D-15,FPQz));FPQz=FPQz-PQJ(3)
              PQJ(3)=PQJ(3)*TOm
            ELSE
              PQJ(3)=0.0D0
            ENDIF
            PQx=FPQx*PBC%BoxShape%D(1,1)+FPQy*PBC%BoxShape%D(1,2)+FPQz*PBC%BoxShape%D(1,3)
            PQy=FPQy*PBC%BoxShape%D(2,2)+FPQz*PBC%BoxShape%D(2,3)
            PQz=FPQz*PBC%BoxShape%D(3,3)
            ! End MIC
            WPx = -Eta*PQx*r1xZpE
            WPy = -Eta*PQy*r1xZpE
            WPz = -Eta*PQz*r1xZpE
            WQx = Zeta*PQx*r1xZpE
            WQy = Zeta*PQy*r1xZpE
            WQz = Zeta*PQz*r1xZpE
            T=Omega*(PQx*PQx+PQy*PQy+PQz*PQz)
            IF(T<Gamma_Switch)THEN
              L=AINT(T*Gamma_Grid)
              ET=EXP(-T)
              TwoT=Two*T
              W11=(F11_0(L)+T*(F11_1(L)+T*(F11_2(L)+T*(F11_3(L)+T*F11_4(L)))))
              W10=+4.761904761904762D-02*(TwoT*W11+ET)
              W9=+5.263157894736842D-02*(TwoT*W10+ET)
              W8=+5.882352941176471D-02*(TwoT*W9+ET)
              W7=+6.666666666666666D-02*(TwoT*W8+ET)
              W6=+7.692307692307693D-02*(TwoT*W7+ET)
              W5=+9.090909090909090D-02*(TwoT*W6+ET)
              W4=+1.111111111111111D-01*(TwoT*W5+ET)
              W3=+1.428571428571428D-01*(TwoT*W4+ET)
              W2=+2.000000000000000D-01*(TwoT*W3+ET)
              W1=+3.333333333333333D-01*(TwoT*W2+ET)
              W0=TwoT*W1+ET
              VRR(1,1,0)=Upq*W0
              VRR(1,1,1)=Upq*W1
              VRR(1,1,2)=Upq*W2
              VRR(1,1,3)=Upq*W3
              VRR(1,1,4)=Upq*W4
              VRR(1,1,5)=Upq*W5
              VRR(1,1,6)=Upq*W6
              VRR(1,1,7)=Upq*W7
              VRR(1,1,8)=Upq*W8
              VRR(1,1,9)=Upq*W9
              VRR(1,1,10)=Upq*W10
              VRR(1,1,11)=Upq*W11
            ELSE
              InvT=One/T
              SqInvT=DSQRT(InvT)
              VRR(1,1,0)=+8.862269254527580D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,1)=+4.431134627263790D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,2)=+6.646701940895685D-01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,3)=+1.661675485223921D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,4)=+5.815864198283724D+00*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,5)=+2.617138889227676D+01*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,6)=+1.439426389075222D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,7)=+9.356271528988940D+02*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,8)=+7.017203646741708D+03*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,9)=+5.964623099730450D+04*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,10)=+5.666391944743928D+05*Upq*SqInvT
              SqInvT=SqInvT*InvT
              VRR(1,1,11)=+5.949711541981125D+06*Upq*SqInvT
            ENDIF
            ! Generating (p0|s0)^(10)
            VRR(2,1,10)=PAx*VRR(1,1,10)+WPx*VRR(1,1,11)
            VRR(3,1,10)=PAy*VRR(1,1,10)+WPy*VRR(1,1,11)
            VRR(4,1,10)=PAz*VRR(1,1,10)+WPz*VRR(1,1,11)
            ! Generating (p0|s0)^(9)
            VRR(2,1,9)=PAx*VRR(1,1,9)+WPx*VRR(1,1,10)
            VRR(3,1,9)=PAy*VRR(1,1,9)+WPy*VRR(1,1,10)
            VRR(4,1,9)=PAz*VRR(1,1,9)+WPz*VRR(1,1,10)
            ! Generating (p0|s0)^(8)
            VRR(2,1,8)=PAx*VRR(1,1,8)+WPx*VRR(1,1,9)
            VRR(3,1,8)=PAy*VRR(1,1,8)+WPy*VRR(1,1,9)
            VRR(4,1,8)=PAz*VRR(1,1,8)+WPz*VRR(1,1,9)
            ! Generating (p0|s0)^(7)
            VRR(2,1,7)=PAx*VRR(1,1,7)+WPx*VRR(1,1,8)
            VRR(3,1,7)=PAy*VRR(1,1,7)+WPy*VRR(1,1,8)
            VRR(4,1,7)=PAz*VRR(1,1,7)+WPz*VRR(1,1,8)
            ! Generating (p0|s0)^(6)
            VRR(2,1,6)=PAx*VRR(1,1,6)+WPx*VRR(1,1,7)
            VRR(3,1,6)=PAy*VRR(1,1,6)+WPy*VRR(1,1,7)
            VRR(4,1,6)=PAz*VRR(1,1,6)+WPz*VRR(1,1,7)
            ! Generating (p0|s0)^(5)
            VRR(2,1,5)=PAx*VRR(1,1,5)+WPx*VRR(1,1,6)
            VRR(3,1,5)=PAy*VRR(1,1,5)+WPy*VRR(1,1,6)
            VRR(4,1,5)=PAz*VRR(1,1,5)+WPz*VRR(1,1,6)
            ! Generating (p0|s0)^(4)
            VRR(2,1,4)=PAx*VRR(1,1,4)+WPx*VRR(1,1,5)
            VRR(3,1,4)=PAy*VRR(1,1,4)+WPy*VRR(1,1,5)
            VRR(4,1,4)=PAz*VRR(1,1,4)+WPz*VRR(1,1,5)
            ! Generating (p0|s0)^(3)
            VRR(2,1,3)=PAx*VRR(1,1,3)+WPx*VRR(1,1,4)
            VRR(3,1,3)=PAy*VRR(1,1,3)+WPy*VRR(1,1,4)
            VRR(4,1,3)=PAz*VRR(1,1,3)+WPz*VRR(1,1,4)
            ! Generating (p0|s0)^(2)
            VRR(2,1,2)=PAx*VRR(1,1,2)+WPx*VRR(1,1,3)
            VRR(3,1,2)=PAy*VRR(1,1,2)+WPy*VRR(1,1,3)
            VRR(4,1,2)=PAz*VRR(1,1,2)+WPz*VRR(1,1,3)
            ! Generating (p0|s0)^(1)
            VRR(2,1,1)=PAx*VRR(1,1,1)+WPx*VRR(1,1,2)
            VRR(3,1,1)=PAy*VRR(1,1,1)+WPy*VRR(1,1,2)
            VRR(4,1,1)=PAz*VRR(1,1,1)+WPz*VRR(1,1,2)
            ! Generating (p0|s0)^(0)
            VRR(2,1,0)=PAx*VRR(1,1,0)+WPx*VRR(1,1,1)
            VRR(3,1,0)=PAy*VRR(1,1,0)+WPy*VRR(1,1,1)
            VRR(4,1,0)=PAz*VRR(1,1,0)+WPz*VRR(1,1,1)
            ! Generating (d0|s0)^(9)
            VRR(5,1,9)=PAx*VRR(2,1,9)+r1x2Z*(VRR(1,1,9)-ExZpE*VRR(1,1,10))+WPx*VRR(2,1,10)
            VRR(6,1,9)=PAx*VRR(3,1,9)+WPx*VRR(3,1,10)
            VRR(7,1,9)=PAy*VRR(3,1,9)+r1x2Z*(VRR(1,1,9)-ExZpE*VRR(1,1,10))+WPy*VRR(3,1,10)
            VRR(8,1,9)=PAx*VRR(4,1,9)+WPx*VRR(4,1,10)
            VRR(9,1,9)=PAy*VRR(4,1,9)+WPy*VRR(4,1,10)
            VRR(10,1,9)=PAz*VRR(4,1,9)+r1x2Z*(VRR(1,1,9)-ExZpE*VRR(1,1,10))+WPz*VRR(4,1,10)
            ! Generating (d0|s0)^(8)
            VRR(5,1,8)=PAx*VRR(2,1,8)+r1x2Z*(VRR(1,1,8)-ExZpE*VRR(1,1,9))+WPx*VRR(2,1,9)
            VRR(6,1,8)=PAx*VRR(3,1,8)+WPx*VRR(3,1,9)
            VRR(7,1,8)=PAy*VRR(3,1,8)+r1x2Z*(VRR(1,1,8)-ExZpE*VRR(1,1,9))+WPy*VRR(3,1,9)
            VRR(8,1,8)=PAx*VRR(4,1,8)+WPx*VRR(4,1,9)
            VRR(9,1,8)=PAy*VRR(4,1,8)+WPy*VRR(4,1,9)
            VRR(10,1,8)=PAz*VRR(4,1,8)+r1x2Z*(VRR(1,1,8)-ExZpE*VRR(1,1,9))+WPz*VRR(4,1,9)
            ! Generating (d0|s0)^(7)
            VRR(5,1,7)=PAx*VRR(2,1,7)+r1x2Z*(VRR(1,1,7)-ExZpE*VRR(1,1,8))+WPx*VRR(2,1,8)
            VRR(6,1,7)=PAx*VRR(3,1,7)+WPx*VRR(3,1,8)
            VRR(7,1,7)=PAy*VRR(3,1,7)+r1x2Z*(VRR(1,1,7)-ExZpE*VRR(1,1,8))+WPy*VRR(3,1,8)
            VRR(8,1,7)=PAx*VRR(4,1,7)+WPx*VRR(4,1,8)
            VRR(9,1,7)=PAy*VRR(4,1,7)+WPy*VRR(4,1,8)
            VRR(10,1,7)=PAz*VRR(4,1,7)+r1x2Z*(VRR(1,1,7)-ExZpE*VRR(1,1,8))+WPz*VRR(4,1,8)
            ! Generating (d0|s0)^(6)
            VRR(5,1,6)=PAx*VRR(2,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPx*VRR(2,1,7)
            VRR(6,1,6)=PAx*VRR(3,1,6)+WPx*VRR(3,1,7)
            VRR(7,1,6)=PAy*VRR(3,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPy*VRR(3,1,7)
            VRR(8,1,6)=PAx*VRR(4,1,6)+WPx*VRR(4,1,7)
            VRR(9,1,6)=PAy*VRR(4,1,6)+WPy*VRR(4,1,7)
            VRR(10,1,6)=PAz*VRR(4,1,6)+r1x2Z*(VRR(1,1,6)-ExZpE*VRR(1,1,7))+WPz*VRR(4,1,7)
            ! Generating (d0|s0)^(5)
            VRR(5,1,5)=PAx*VRR(2,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPx*VRR(2,1,6)
            VRR(6,1,5)=PAx*VRR(3,1,5)+WPx*VRR(3,1,6)
            VRR(7,1,5)=PAy*VRR(3,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPy*VRR(3,1,6)
            VRR(8,1,5)=PAx*VRR(4,1,5)+WPx*VRR(4,1,6)
            VRR(9,1,5)=PAy*VRR(4,1,5)+WPy*VRR(4,1,6)
            VRR(10,1,5)=PAz*VRR(4,1,5)+r1x2Z*(VRR(1,1,5)-ExZpE*VRR(1,1,6))+WPz*VRR(4,1,6)
            ! Generating (d0|s0)^(4)
            VRR(5,1,4)=PAx*VRR(2,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPx*VRR(2,1,5)
            VRR(6,1,4)=PAx*VRR(3,1,4)+WPx*VRR(3,1,5)
            VRR(7,1,4)=PAy*VRR(3,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPy*VRR(3,1,5)
            VRR(8,1,4)=PAx*VRR(4,1,4)+WPx*VRR(4,1,5)
            VRR(9,1,4)=PAy*VRR(4,1,4)+WPy*VRR(4,1,5)
            VRR(10,1,4)=PAz*VRR(4,1,4)+r1x2Z*(VRR(1,1,4)-ExZpE*VRR(1,1,5))+WPz*VRR(4,1,5)
            ! Generating (d0|s0)^(3)
            VRR(5,1,3)=PAx*VRR(2,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPx*VRR(2,1,4)
            VRR(6,1,3)=PAx*VRR(3,1,3)+WPx*VRR(3,1,4)
            VRR(7,1,3)=PAy*VRR(3,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPy*VRR(3,1,4)
            VRR(8,1,3)=PAx*VRR(4,1,3)+WPx*VRR(4,1,4)
            VRR(9,1,3)=PAy*VRR(4,1,3)+WPy*VRR(4,1,4)
            VRR(10,1,3)=PAz*VRR(4,1,3)+r1x2Z*(VRR(1,1,3)-ExZpE*VRR(1,1,4))+WPz*VRR(4,1,4)
            ! Generating (d0|s0)^(2)
            VRR(5,1,2)=PAx*VRR(2,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPx*VRR(2,1,3)
            VRR(6,1,2)=PAx*VRR(3,1,2)+WPx*VRR(3,1,3)
            VRR(7,1,2)=PAy*VRR(3,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPy*VRR(3,1,3)
            VRR(8,1,2)=PAx*VRR(4,1,2)+WPx*VRR(4,1,3)
            VRR(9,1,2)=PAy*VRR(4,1,2)+WPy*VRR(4,1,3)
            VRR(10,1,2)=PAz*VRR(4,1,2)+r1x2Z*(VRR(1,1,2)-ExZpE*VRR(1,1,3))+WPz*VRR(4,1,3)
            ! Generating (d0|s0)^(1)
            VRR(5,1,1)=PAx*VRR(2,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPx*VRR(2,1,2)
            VRR(6,1,1)=PAx*VRR(3,1,1)+WPx*VRR(3,1,2)
            VRR(7,1,1)=PAy*VRR(3,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPy*VRR(3,1,2)
            VRR(8,1,1)=PAx*VRR(4,1,1)+WPx*VRR(4,1,2)
            VRR(9,1,1)=PAy*VRR(4,1,1)+WPy*VRR(4,1,2)
            VRR(10,1,1)=PAz*VRR(4,1,1)+r1x2Z*(VRR(1,1,1)-ExZpE*VRR(1,1,2))+WPz*VRR(4,1,2)
            ! Generating (d0|s0)^(0)
            VRR(5,1,0)=PAx*VRR(2,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPx*VRR(2,1,1)
            VRR(6,1,0)=PAx*VRR(3,1,0)+WPx*VRR(3,1,1)
            VRR(7,1,0)=PAy*VRR(3,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPy*VRR(3,1,1)
            VRR(8,1,0)=PAx*VRR(4,1,0)+WPx*VRR(4,1,1)
            VRR(9,1,0)=PAy*VRR(4,1,0)+WPy*VRR(4,1,1)
            VRR(10,1,0)=PAz*VRR(4,1,0)+r1x2Z*(VRR(1,1,0)-ExZpE*VRR(1,1,1))+WPz*VRR(4,1,1)
            ! Generating (f0|s0)^(8)
            CALL VRRf0s0(84,84,VRR(1,1,8),VRR(1,1,9))
            ! Generating (f0|s0)^(7)
            CALL VRRf0s0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (f0|s0)^(6)
            CALL VRRf0s0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (f0|s0)^(5)
            CALL VRRf0s0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|s0)^(4)
            CALL VRRf0s0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|s0)^(3)
            CALL VRRf0s0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|s0)^(2)
            CALL VRRf0s0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|s0)^(1)
            CALL VRRf0s0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|s0)^(0)
            CALL VRRf0s0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|s0)^(7)
            CALL VRRg0s0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (g0|s0)^(6)
            CALL VRRg0s0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (g0|s0)^(5)
            CALL VRRg0s0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (g0|s0)^(4)
            CALL VRRg0s0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|s0)^(3)
            CALL VRRg0s0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|s0)^(2)
            CALL VRRg0s0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|s0)^(1)
            CALL VRRg0s0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|s0)^(0)
            CALL VRRg0s0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|s0)^(6)
            CALL VRRh0s0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (h0|s0)^(5)
            CALL VRRh0s0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (h0|s0)^(4)
            CALL VRRh0s0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (h0|s0)^(3)
            CALL VRRh0s0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (h0|s0)^(2)
            CALL VRRh0s0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|s0)^(1)
            CALL VRRh0s0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|s0)^(0)
            CALL VRRh0s0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|s0)^(5)
            CALL VRRi0s0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (i0|s0)^(4)
            CALL VRRi0s0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (i0|s0)^(3)
            CALL VRRi0s0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (i0|s0)^(2)
            CALL VRRi0s0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (i0|s0)^(1)
            CALL VRRi0s0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|s0)^(0)
            CALL VRRi0s0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|p0)^(10)
            VRR(1,2,10)=QCx*VRR(1,1,10)+WQx*VRR(1,1,11)
            VRR(1,3,10)=QCy*VRR(1,1,10)+WQy*VRR(1,1,11)
            VRR(1,4,10)=QCz*VRR(1,1,10)+WQz*VRR(1,1,11)
            ! Generating (s0|p0)^(9)
            VRR(1,2,9)=QCx*VRR(1,1,9)+WQx*VRR(1,1,10)
            VRR(1,3,9)=QCy*VRR(1,1,9)+WQy*VRR(1,1,10)
            VRR(1,4,9)=QCz*VRR(1,1,9)+WQz*VRR(1,1,10)
            ! Generating (s0|p0)^(8)
            VRR(1,2,8)=QCx*VRR(1,1,8)+WQx*VRR(1,1,9)
            VRR(1,3,8)=QCy*VRR(1,1,8)+WQy*VRR(1,1,9)
            VRR(1,4,8)=QCz*VRR(1,1,8)+WQz*VRR(1,1,9)
            ! Generating (s0|p0)^(7)
            VRR(1,2,7)=QCx*VRR(1,1,7)+WQx*VRR(1,1,8)
            VRR(1,3,7)=QCy*VRR(1,1,7)+WQy*VRR(1,1,8)
            VRR(1,4,7)=QCz*VRR(1,1,7)+WQz*VRR(1,1,8)
            ! Generating (s0|p0)^(6)
            VRR(1,2,6)=QCx*VRR(1,1,6)+WQx*VRR(1,1,7)
            VRR(1,3,6)=QCy*VRR(1,1,6)+WQy*VRR(1,1,7)
            VRR(1,4,6)=QCz*VRR(1,1,6)+WQz*VRR(1,1,7)
            ! Generating (s0|p0)^(5)
            VRR(1,2,5)=QCx*VRR(1,1,5)+WQx*VRR(1,1,6)
            VRR(1,3,5)=QCy*VRR(1,1,5)+WQy*VRR(1,1,6)
            VRR(1,4,5)=QCz*VRR(1,1,5)+WQz*VRR(1,1,6)
            ! Generating (s0|p0)^(4)
            VRR(1,2,4)=QCx*VRR(1,1,4)+WQx*VRR(1,1,5)
            VRR(1,3,4)=QCy*VRR(1,1,4)+WQy*VRR(1,1,5)
            VRR(1,4,4)=QCz*VRR(1,1,4)+WQz*VRR(1,1,5)
            ! Generating (s0|p0)^(3)
            VRR(1,2,3)=QCx*VRR(1,1,3)+WQx*VRR(1,1,4)
            VRR(1,3,3)=QCy*VRR(1,1,3)+WQy*VRR(1,1,4)
            VRR(1,4,3)=QCz*VRR(1,1,3)+WQz*VRR(1,1,4)
            ! Generating (s0|p0)^(2)
            VRR(1,2,2)=QCx*VRR(1,1,2)+WQx*VRR(1,1,3)
            VRR(1,3,2)=QCy*VRR(1,1,2)+WQy*VRR(1,1,3)
            VRR(1,4,2)=QCz*VRR(1,1,2)+WQz*VRR(1,1,3)
            ! Generating (s0|p0)^(1)
            VRR(1,2,1)=QCx*VRR(1,1,1)+WQx*VRR(1,1,2)
            VRR(1,3,1)=QCy*VRR(1,1,1)+WQy*VRR(1,1,2)
            VRR(1,4,1)=QCz*VRR(1,1,1)+WQz*VRR(1,1,2)
            ! Generating (s0|p0)^(0)
            VRR(1,2,0)=QCx*VRR(1,1,0)+WQx*VRR(1,1,1)
            VRR(1,3,0)=QCy*VRR(1,1,0)+WQy*VRR(1,1,1)
            VRR(1,4,0)=QCz*VRR(1,1,0)+WQz*VRR(1,1,1)
            ! Generating (p0|p0)^(9)
            VRR(2,2,9)=QCx*VRR(2,1,9)+HfxZpE*VRR(1,1,10)+WQx*VRR(2,1,10)
            VRR(2,3,9)=QCy*VRR(2,1,9)+WQy*VRR(2,1,10)
            VRR(2,4,9)=QCz*VRR(2,1,9)+WQz*VRR(2,1,10)
            VRR(3,2,9)=QCx*VRR(3,1,9)+WQx*VRR(3,1,10)
            VRR(3,3,9)=QCy*VRR(3,1,9)+HfxZpE*VRR(1,1,10)+WQy*VRR(3,1,10)
            VRR(3,4,9)=QCz*VRR(3,1,9)+WQz*VRR(3,1,10)
            VRR(4,2,9)=QCx*VRR(4,1,9)+WQx*VRR(4,1,10)
            VRR(4,3,9)=QCy*VRR(4,1,9)+WQy*VRR(4,1,10)
            VRR(4,4,9)=QCz*VRR(4,1,9)+HfxZpE*VRR(1,1,10)+WQz*VRR(4,1,10)
            ! Generating (p0|p0)^(8)
            VRR(2,2,8)=QCx*VRR(2,1,8)+HfxZpE*VRR(1,1,9)+WQx*VRR(2,1,9)
            VRR(2,3,8)=QCy*VRR(2,1,8)+WQy*VRR(2,1,9)
            VRR(2,4,8)=QCz*VRR(2,1,8)+WQz*VRR(2,1,9)
            VRR(3,2,8)=QCx*VRR(3,1,8)+WQx*VRR(3,1,9)
            VRR(3,3,8)=QCy*VRR(3,1,8)+HfxZpE*VRR(1,1,9)+WQy*VRR(3,1,9)
            VRR(3,4,8)=QCz*VRR(3,1,8)+WQz*VRR(3,1,9)
            VRR(4,2,8)=QCx*VRR(4,1,8)+WQx*VRR(4,1,9)
            VRR(4,3,8)=QCy*VRR(4,1,8)+WQy*VRR(4,1,9)
            VRR(4,4,8)=QCz*VRR(4,1,8)+HfxZpE*VRR(1,1,9)+WQz*VRR(4,1,9)
            ! Generating (p0|p0)^(7)
            VRR(2,2,7)=QCx*VRR(2,1,7)+HfxZpE*VRR(1,1,8)+WQx*VRR(2,1,8)
            VRR(2,3,7)=QCy*VRR(2,1,7)+WQy*VRR(2,1,8)
            VRR(2,4,7)=QCz*VRR(2,1,7)+WQz*VRR(2,1,8)
            VRR(3,2,7)=QCx*VRR(3,1,7)+WQx*VRR(3,1,8)
            VRR(3,3,7)=QCy*VRR(3,1,7)+HfxZpE*VRR(1,1,8)+WQy*VRR(3,1,8)
            VRR(3,4,7)=QCz*VRR(3,1,7)+WQz*VRR(3,1,8)
            VRR(4,2,7)=QCx*VRR(4,1,7)+WQx*VRR(4,1,8)
            VRR(4,3,7)=QCy*VRR(4,1,7)+WQy*VRR(4,1,8)
            VRR(4,4,7)=QCz*VRR(4,1,7)+HfxZpE*VRR(1,1,8)+WQz*VRR(4,1,8)
            ! Generating (p0|p0)^(6)
            VRR(2,2,6)=QCx*VRR(2,1,6)+HfxZpE*VRR(1,1,7)+WQx*VRR(2,1,7)
            VRR(2,3,6)=QCy*VRR(2,1,6)+WQy*VRR(2,1,7)
            VRR(2,4,6)=QCz*VRR(2,1,6)+WQz*VRR(2,1,7)
            VRR(3,2,6)=QCx*VRR(3,1,6)+WQx*VRR(3,1,7)
            VRR(3,3,6)=QCy*VRR(3,1,6)+HfxZpE*VRR(1,1,7)+WQy*VRR(3,1,7)
            VRR(3,4,6)=QCz*VRR(3,1,6)+WQz*VRR(3,1,7)
            VRR(4,2,6)=QCx*VRR(4,1,6)+WQx*VRR(4,1,7)
            VRR(4,3,6)=QCy*VRR(4,1,6)+WQy*VRR(4,1,7)
            VRR(4,4,6)=QCz*VRR(4,1,6)+HfxZpE*VRR(1,1,7)+WQz*VRR(4,1,7)
            ! Generating (p0|p0)^(5)
            VRR(2,2,5)=QCx*VRR(2,1,5)+HfxZpE*VRR(1,1,6)+WQx*VRR(2,1,6)
            VRR(2,3,5)=QCy*VRR(2,1,5)+WQy*VRR(2,1,6)
            VRR(2,4,5)=QCz*VRR(2,1,5)+WQz*VRR(2,1,6)
            VRR(3,2,5)=QCx*VRR(3,1,5)+WQx*VRR(3,1,6)
            VRR(3,3,5)=QCy*VRR(3,1,5)+HfxZpE*VRR(1,1,6)+WQy*VRR(3,1,6)
            VRR(3,4,5)=QCz*VRR(3,1,5)+WQz*VRR(3,1,6)
            VRR(4,2,5)=QCx*VRR(4,1,5)+WQx*VRR(4,1,6)
            VRR(4,3,5)=QCy*VRR(4,1,5)+WQy*VRR(4,1,6)
            VRR(4,4,5)=QCz*VRR(4,1,5)+HfxZpE*VRR(1,1,6)+WQz*VRR(4,1,6)
            ! Generating (p0|p0)^(4)
            VRR(2,2,4)=QCx*VRR(2,1,4)+HfxZpE*VRR(1,1,5)+WQx*VRR(2,1,5)
            VRR(2,3,4)=QCy*VRR(2,1,4)+WQy*VRR(2,1,5)
            VRR(2,4,4)=QCz*VRR(2,1,4)+WQz*VRR(2,1,5)
            VRR(3,2,4)=QCx*VRR(3,1,4)+WQx*VRR(3,1,5)
            VRR(3,3,4)=QCy*VRR(3,1,4)+HfxZpE*VRR(1,1,5)+WQy*VRR(3,1,5)
            VRR(3,4,4)=QCz*VRR(3,1,4)+WQz*VRR(3,1,5)
            VRR(4,2,4)=QCx*VRR(4,1,4)+WQx*VRR(4,1,5)
            VRR(4,3,4)=QCy*VRR(4,1,4)+WQy*VRR(4,1,5)
            VRR(4,4,4)=QCz*VRR(4,1,4)+HfxZpE*VRR(1,1,5)+WQz*VRR(4,1,5)
            ! Generating (p0|p0)^(3)
            VRR(2,2,3)=QCx*VRR(2,1,3)+HfxZpE*VRR(1,1,4)+WQx*VRR(2,1,4)
            VRR(2,3,3)=QCy*VRR(2,1,3)+WQy*VRR(2,1,4)
            VRR(2,4,3)=QCz*VRR(2,1,3)+WQz*VRR(2,1,4)
            VRR(3,2,3)=QCx*VRR(3,1,3)+WQx*VRR(3,1,4)
            VRR(3,3,3)=QCy*VRR(3,1,3)+HfxZpE*VRR(1,1,4)+WQy*VRR(3,1,4)
            VRR(3,4,3)=QCz*VRR(3,1,3)+WQz*VRR(3,1,4)
            VRR(4,2,3)=QCx*VRR(4,1,3)+WQx*VRR(4,1,4)
            VRR(4,3,3)=QCy*VRR(4,1,3)+WQy*VRR(4,1,4)
            VRR(4,4,3)=QCz*VRR(4,1,3)+HfxZpE*VRR(1,1,4)+WQz*VRR(4,1,4)
            ! Generating (p0|p0)^(2)
            VRR(2,2,2)=QCx*VRR(2,1,2)+HfxZpE*VRR(1,1,3)+WQx*VRR(2,1,3)
            VRR(2,3,2)=QCy*VRR(2,1,2)+WQy*VRR(2,1,3)
            VRR(2,4,2)=QCz*VRR(2,1,2)+WQz*VRR(2,1,3)
            VRR(3,2,2)=QCx*VRR(3,1,2)+WQx*VRR(3,1,3)
            VRR(3,3,2)=QCy*VRR(3,1,2)+HfxZpE*VRR(1,1,3)+WQy*VRR(3,1,3)
            VRR(3,4,2)=QCz*VRR(3,1,2)+WQz*VRR(3,1,3)
            VRR(4,2,2)=QCx*VRR(4,1,2)+WQx*VRR(4,1,3)
            VRR(4,3,2)=QCy*VRR(4,1,2)+WQy*VRR(4,1,3)
            VRR(4,4,2)=QCz*VRR(4,1,2)+HfxZpE*VRR(1,1,3)+WQz*VRR(4,1,3)
            ! Generating (p0|p0)^(1)
            VRR(2,2,1)=QCx*VRR(2,1,1)+HfxZpE*VRR(1,1,2)+WQx*VRR(2,1,2)
            VRR(2,3,1)=QCy*VRR(2,1,1)+WQy*VRR(2,1,2)
            VRR(2,4,1)=QCz*VRR(2,1,1)+WQz*VRR(2,1,2)
            VRR(3,2,1)=QCx*VRR(3,1,1)+WQx*VRR(3,1,2)
            VRR(3,3,1)=QCy*VRR(3,1,1)+HfxZpE*VRR(1,1,2)+WQy*VRR(3,1,2)
            VRR(3,4,1)=QCz*VRR(3,1,1)+WQz*VRR(3,1,2)
            VRR(4,2,1)=QCx*VRR(4,1,1)+WQx*VRR(4,1,2)
            VRR(4,3,1)=QCy*VRR(4,1,1)+WQy*VRR(4,1,2)
            VRR(4,4,1)=QCz*VRR(4,1,1)+HfxZpE*VRR(1,1,2)+WQz*VRR(4,1,2)
            ! Generating (p0|p0)^(0)
            VRR(2,2,0)=QCx*VRR(2,1,0)+HfxZpE*VRR(1,1,1)+WQx*VRR(2,1,1)
            VRR(2,3,0)=QCy*VRR(2,1,0)+WQy*VRR(2,1,1)
            VRR(2,4,0)=QCz*VRR(2,1,0)+WQz*VRR(2,1,1)
            VRR(3,2,0)=QCx*VRR(3,1,0)+WQx*VRR(3,1,1)
            VRR(3,3,0)=QCy*VRR(3,1,0)+HfxZpE*VRR(1,1,1)+WQy*VRR(3,1,1)
            VRR(3,4,0)=QCz*VRR(3,1,0)+WQz*VRR(3,1,1)
            VRR(4,2,0)=QCx*VRR(4,1,0)+WQx*VRR(4,1,1)
            VRR(4,3,0)=QCy*VRR(4,1,0)+WQy*VRR(4,1,1)
            VRR(4,4,0)=QCz*VRR(4,1,0)+HfxZpE*VRR(1,1,1)+WQz*VRR(4,1,1)
            ! Generating (d0|p0)^(8)
            CALL VRRd0p0(84,84,VRR(1,1,8),VRR(1,1,9))
            ! Generating (d0|p0)^(7)
            CALL VRRd0p0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (d0|p0)^(6)
            CALL VRRd0p0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (d0|p0)^(5)
            CALL VRRd0p0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|p0)^(4)
            CALL VRRd0p0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|p0)^(3)
            CALL VRRd0p0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|p0)^(2)
            CALL VRRd0p0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|p0)^(1)
            CALL VRRd0p0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|p0)^(0)
            CALL VRRd0p0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|p0)^(7)
            CALL VRRf0p0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (f0|p0)^(6)
            CALL VRRf0p0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (f0|p0)^(5)
            CALL VRRf0p0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|p0)^(4)
            CALL VRRf0p0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|p0)^(3)
            CALL VRRf0p0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|p0)^(2)
            CALL VRRf0p0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|p0)^(1)
            CALL VRRf0p0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|p0)^(0)
            CALL VRRf0p0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|p0)^(6)
            CALL VRRg0p0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (g0|p0)^(5)
            CALL VRRg0p0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (g0|p0)^(4)
            CALL VRRg0p0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|p0)^(3)
            CALL VRRg0p0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|p0)^(2)
            CALL VRRg0p0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|p0)^(1)
            CALL VRRg0p0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|p0)^(0)
            CALL VRRg0p0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|p0)^(5)
            CALL VRRh0p0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (h0|p0)^(4)
            CALL VRRh0p0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (h0|p0)^(3)
            CALL VRRh0p0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (h0|p0)^(2)
            CALL VRRh0p0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|p0)^(1)
            CALL VRRh0p0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|p0)^(0)
            CALL VRRh0p0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|p0)^(4)
            CALL VRRi0p0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (i0|p0)^(3)
            CALL VRRi0p0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (i0|p0)^(2)
            CALL VRRi0p0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (i0|p0)^(1)
            CALL VRRi0p0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|p0)^(0)
            CALL VRRi0p0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|d0)^(9)
            VRR(1,5,9)=r1x2E*VRR(1,1,9)+QCx*VRR(1,2,9)-r1x2E*ZxZpE*VRR(1,1,10)+WQx*VRR(1,2,10)
            VRR(1,6,9)=QCx*VRR(1,3,9)+WQx*VRR(1,3,10)
            VRR(1,7,9)=r1x2E*VRR(1,1,9)+QCy*VRR(1,3,9)-r1x2E*ZxZpE*VRR(1,1,10)+WQy*VRR(1,3,10)
            VRR(1,8,9)=QCx*VRR(1,4,9)+WQx*VRR(1,4,10)
            VRR(1,9,9)=QCy*VRR(1,4,9)+WQy*VRR(1,4,10)
            VRR(1,10,9)=r1x2E*VRR(1,1,9)+QCz*VRR(1,4,9)-r1x2E*ZxZpE*VRR(1,1,10)+WQz*VRR(1,4,10)
            ! Generating (s0|d0)^(8)
            VRR(1,5,8)=r1x2E*VRR(1,1,8)+QCx*VRR(1,2,8)-r1x2E*ZxZpE*VRR(1,1,9)+WQx*VRR(1,2,9)
            VRR(1,6,8)=QCx*VRR(1,3,8)+WQx*VRR(1,3,9)
            VRR(1,7,8)=r1x2E*VRR(1,1,8)+QCy*VRR(1,3,8)-r1x2E*ZxZpE*VRR(1,1,9)+WQy*VRR(1,3,9)
            VRR(1,8,8)=QCx*VRR(1,4,8)+WQx*VRR(1,4,9)
            VRR(1,9,8)=QCy*VRR(1,4,8)+WQy*VRR(1,4,9)
            VRR(1,10,8)=r1x2E*VRR(1,1,8)+QCz*VRR(1,4,8)-r1x2E*ZxZpE*VRR(1,1,9)+WQz*VRR(1,4,9)
            ! Generating (s0|d0)^(7)
            VRR(1,5,7)=r1x2E*VRR(1,1,7)+QCx*VRR(1,2,7)-r1x2E*ZxZpE*VRR(1,1,8)+WQx*VRR(1,2,8)
            VRR(1,6,7)=QCx*VRR(1,3,7)+WQx*VRR(1,3,8)
            VRR(1,7,7)=r1x2E*VRR(1,1,7)+QCy*VRR(1,3,7)-r1x2E*ZxZpE*VRR(1,1,8)+WQy*VRR(1,3,8)
            VRR(1,8,7)=QCx*VRR(1,4,7)+WQx*VRR(1,4,8)
            VRR(1,9,7)=QCy*VRR(1,4,7)+WQy*VRR(1,4,8)
            VRR(1,10,7)=r1x2E*VRR(1,1,7)+QCz*VRR(1,4,7)-r1x2E*ZxZpE*VRR(1,1,8)+WQz*VRR(1,4,8)
            ! Generating (s0|d0)^(6)
            VRR(1,5,6)=r1x2E*VRR(1,1,6)+QCx*VRR(1,2,6)-r1x2E*ZxZpE*VRR(1,1,7)+WQx*VRR(1,2,7)
            VRR(1,6,6)=QCx*VRR(1,3,6)+WQx*VRR(1,3,7)
            VRR(1,7,6)=r1x2E*VRR(1,1,6)+QCy*VRR(1,3,6)-r1x2E*ZxZpE*VRR(1,1,7)+WQy*VRR(1,3,7)
            VRR(1,8,6)=QCx*VRR(1,4,6)+WQx*VRR(1,4,7)
            VRR(1,9,6)=QCy*VRR(1,4,6)+WQy*VRR(1,4,7)
            VRR(1,10,6)=r1x2E*VRR(1,1,6)+QCz*VRR(1,4,6)-r1x2E*ZxZpE*VRR(1,1,7)+WQz*VRR(1,4,7)
            ! Generating (s0|d0)^(5)
            VRR(1,5,5)=r1x2E*VRR(1,1,5)+QCx*VRR(1,2,5)-r1x2E*ZxZpE*VRR(1,1,6)+WQx*VRR(1,2,6)
            VRR(1,6,5)=QCx*VRR(1,3,5)+WQx*VRR(1,3,6)
            VRR(1,7,5)=r1x2E*VRR(1,1,5)+QCy*VRR(1,3,5)-r1x2E*ZxZpE*VRR(1,1,6)+WQy*VRR(1,3,6)
            VRR(1,8,5)=QCx*VRR(1,4,5)+WQx*VRR(1,4,6)
            VRR(1,9,5)=QCy*VRR(1,4,5)+WQy*VRR(1,4,6)
            VRR(1,10,5)=r1x2E*VRR(1,1,5)+QCz*VRR(1,4,5)-r1x2E*ZxZpE*VRR(1,1,6)+WQz*VRR(1,4,6)
            ! Generating (s0|d0)^(4)
            VRR(1,5,4)=r1x2E*VRR(1,1,4)+QCx*VRR(1,2,4)-r1x2E*ZxZpE*VRR(1,1,5)+WQx*VRR(1,2,5)
            VRR(1,6,4)=QCx*VRR(1,3,4)+WQx*VRR(1,3,5)
            VRR(1,7,4)=r1x2E*VRR(1,1,4)+QCy*VRR(1,3,4)-r1x2E*ZxZpE*VRR(1,1,5)+WQy*VRR(1,3,5)
            VRR(1,8,4)=QCx*VRR(1,4,4)+WQx*VRR(1,4,5)
            VRR(1,9,4)=QCy*VRR(1,4,4)+WQy*VRR(1,4,5)
            VRR(1,10,4)=r1x2E*VRR(1,1,4)+QCz*VRR(1,4,4)-r1x2E*ZxZpE*VRR(1,1,5)+WQz*VRR(1,4,5)
            ! Generating (s0|d0)^(3)
            VRR(1,5,3)=r1x2E*VRR(1,1,3)+QCx*VRR(1,2,3)-r1x2E*ZxZpE*VRR(1,1,4)+WQx*VRR(1,2,4)
            VRR(1,6,3)=QCx*VRR(1,3,3)+WQx*VRR(1,3,4)
            VRR(1,7,3)=r1x2E*VRR(1,1,3)+QCy*VRR(1,3,3)-r1x2E*ZxZpE*VRR(1,1,4)+WQy*VRR(1,3,4)
            VRR(1,8,3)=QCx*VRR(1,4,3)+WQx*VRR(1,4,4)
            VRR(1,9,3)=QCy*VRR(1,4,3)+WQy*VRR(1,4,4)
            VRR(1,10,3)=r1x2E*VRR(1,1,3)+QCz*VRR(1,4,3)-r1x2E*ZxZpE*VRR(1,1,4)+WQz*VRR(1,4,4)
            ! Generating (s0|d0)^(2)
            VRR(1,5,2)=r1x2E*VRR(1,1,2)+QCx*VRR(1,2,2)-r1x2E*ZxZpE*VRR(1,1,3)+WQx*VRR(1,2,3)
            VRR(1,6,2)=QCx*VRR(1,3,2)+WQx*VRR(1,3,3)
            VRR(1,7,2)=r1x2E*VRR(1,1,2)+QCy*VRR(1,3,2)-r1x2E*ZxZpE*VRR(1,1,3)+WQy*VRR(1,3,3)
            VRR(1,8,2)=QCx*VRR(1,4,2)+WQx*VRR(1,4,3)
            VRR(1,9,2)=QCy*VRR(1,4,2)+WQy*VRR(1,4,3)
            VRR(1,10,2)=r1x2E*VRR(1,1,2)+QCz*VRR(1,4,2)-r1x2E*ZxZpE*VRR(1,1,3)+WQz*VRR(1,4,3)
            ! Generating (s0|d0)^(1)
            VRR(1,5,1)=r1x2E*VRR(1,1,1)+QCx*VRR(1,2,1)-r1x2E*ZxZpE*VRR(1,1,2)+WQx*VRR(1,2,2)
            VRR(1,6,1)=QCx*VRR(1,3,1)+WQx*VRR(1,3,2)
            VRR(1,7,1)=r1x2E*VRR(1,1,1)+QCy*VRR(1,3,1)-r1x2E*ZxZpE*VRR(1,1,2)+WQy*VRR(1,3,2)
            VRR(1,8,1)=QCx*VRR(1,4,1)+WQx*VRR(1,4,2)
            VRR(1,9,1)=QCy*VRR(1,4,1)+WQy*VRR(1,4,2)
            VRR(1,10,1)=r1x2E*VRR(1,1,1)+QCz*VRR(1,4,1)-r1x2E*ZxZpE*VRR(1,1,2)+WQz*VRR(1,4,2)
            ! Generating (s0|d0)^(0)
            VRR(1,5,0)=r1x2E*VRR(1,1,0)+QCx*VRR(1,2,0)-r1x2E*ZxZpE*VRR(1,1,1)+WQx*VRR(1,2,1)
            VRR(1,6,0)=QCx*VRR(1,3,0)+WQx*VRR(1,3,1)
            VRR(1,7,0)=r1x2E*VRR(1,1,0)+QCy*VRR(1,3,0)-r1x2E*ZxZpE*VRR(1,1,1)+WQy*VRR(1,3,1)
            VRR(1,8,0)=QCx*VRR(1,4,0)+WQx*VRR(1,4,1)
            VRR(1,9,0)=QCy*VRR(1,4,0)+WQy*VRR(1,4,1)
            VRR(1,10,0)=r1x2E*VRR(1,1,0)+QCz*VRR(1,4,0)-r1x2E*ZxZpE*VRR(1,1,1)+WQz*VRR(1,4,1)
            ! Generating (p0|d0)^(8)
            CALL VRRp0d0(84,84,VRR(1,1,8),VRR(1,1,9))
            ! Generating (p0|d0)^(7)
            CALL VRRp0d0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (p0|d0)^(6)
            CALL VRRp0d0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (p0|d0)^(5)
            CALL VRRp0d0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|d0)^(4)
            CALL VRRp0d0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|d0)^(3)
            CALL VRRp0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|d0)^(2)
            CALL VRRp0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|d0)^(1)
            CALL VRRp0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|d0)^(0)
            CALL VRRp0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|d0)^(7)
            CALL VRRd0d0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (d0|d0)^(6)
            CALL VRRd0d0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (d0|d0)^(5)
            CALL VRRd0d0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|d0)^(4)
            CALL VRRd0d0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|d0)^(3)
            CALL VRRd0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|d0)^(2)
            CALL VRRd0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|d0)^(1)
            CALL VRRd0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|d0)^(0)
            CALL VRRd0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|d0)^(6)
            CALL VRRf0d0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (f0|d0)^(5)
            CALL VRRf0d0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|d0)^(4)
            CALL VRRf0d0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|d0)^(3)
            CALL VRRf0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|d0)^(2)
            CALL VRRf0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|d0)^(1)
            CALL VRRf0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|d0)^(0)
            CALL VRRf0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|d0)^(5)
            CALL VRRg0d0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (g0|d0)^(4)
            CALL VRRg0d0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|d0)^(3)
            CALL VRRg0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|d0)^(2)
            CALL VRRg0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|d0)^(1)
            CALL VRRg0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|d0)^(0)
            CALL VRRg0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|d0)^(4)
            CALL VRRh0d0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (h0|d0)^(3)
            CALL VRRh0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (h0|d0)^(2)
            CALL VRRh0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|d0)^(1)
            CALL VRRh0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|d0)^(0)
            CALL VRRh0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|d0)^(3)
            CALL VRRi0d0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (i0|d0)^(2)
            CALL VRRi0d0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (i0|d0)^(1)
            CALL VRRi0d0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|d0)^(0)
            CALL VRRi0d0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|f0)^(8)
            CALL VRRs0f0(84,84,VRR(1,1,8),VRR(1,1,9))
            ! Generating (s0|f0)^(7)
            CALL VRRs0f0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (s0|f0)^(6)
            CALL VRRs0f0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (s0|f0)^(5)
            CALL VRRs0f0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|f0)^(4)
            CALL VRRs0f0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|f0)^(3)
            CALL VRRs0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|f0)^(2)
            CALL VRRs0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|f0)^(1)
            CALL VRRs0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|f0)^(0)
            CALL VRRs0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|f0)^(7)
            CALL VRRp0f0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (p0|f0)^(6)
            CALL VRRp0f0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (p0|f0)^(5)
            CALL VRRp0f0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|f0)^(4)
            CALL VRRp0f0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|f0)^(3)
            CALL VRRp0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|f0)^(2)
            CALL VRRp0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|f0)^(1)
            CALL VRRp0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|f0)^(0)
            CALL VRRp0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|f0)^(6)
            CALL VRRd0f0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (d0|f0)^(5)
            CALL VRRd0f0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|f0)^(4)
            CALL VRRd0f0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|f0)^(3)
            CALL VRRd0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|f0)^(2)
            CALL VRRd0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|f0)^(1)
            CALL VRRd0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|f0)^(0)
            CALL VRRd0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|f0)^(5)
            CALL VRRf0f0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (f0|f0)^(4)
            CALL VRRf0f0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|f0)^(3)
            CALL VRRf0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|f0)^(2)
            CALL VRRf0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|f0)^(1)
            CALL VRRf0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|f0)^(0)
            CALL VRRf0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|f0)^(4)
            CALL VRRg0f0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (g0|f0)^(3)
            CALL VRRg0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|f0)^(2)
            CALL VRRg0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|f0)^(1)
            CALL VRRg0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|f0)^(0)
            CALL VRRg0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|f0)^(3)
            CALL VRRh0f0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (h0|f0)^(2)
            CALL VRRh0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|f0)^(1)
            CALL VRRh0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|f0)^(0)
            CALL VRRh0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|f0)^(2)
            CALL VRRi0f0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (i0|f0)^(1)
            CALL VRRi0f0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|f0)^(0)
            CALL VRRi0f0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|g0)^(7)
            CALL VRRs0g0(84,84,VRR(1,1,7),VRR(1,1,8))
            ! Generating (s0|g0)^(6)
            CALL VRRs0g0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (s0|g0)^(5)
            CALL VRRs0g0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|g0)^(4)
            CALL VRRs0g0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|g0)^(3)
            CALL VRRs0g0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|g0)^(2)
            CALL VRRs0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|g0)^(1)
            CALL VRRs0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|g0)^(0)
            CALL VRRs0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|g0)^(6)
            CALL VRRp0g0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (p0|g0)^(5)
            CALL VRRp0g0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|g0)^(4)
            CALL VRRp0g0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|g0)^(3)
            CALL VRRp0g0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|g0)^(2)
            CALL VRRp0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|g0)^(1)
            CALL VRRp0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|g0)^(0)
            CALL VRRp0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|g0)^(5)
            CALL VRRd0g0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (d0|g0)^(4)
            CALL VRRd0g0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|g0)^(3)
            CALL VRRd0g0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|g0)^(2)
            CALL VRRd0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|g0)^(1)
            CALL VRRd0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|g0)^(0)
            CALL VRRd0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|g0)^(4)
            CALL VRRf0g0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (f0|g0)^(3)
            CALL VRRf0g0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|g0)^(2)
            CALL VRRf0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|g0)^(1)
            CALL VRRf0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|g0)^(0)
            CALL VRRf0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|g0)^(3)
            CALL VRRg0g0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (g0|g0)^(2)
            CALL VRRg0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|g0)^(1)
            CALL VRRg0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|g0)^(0)
            CALL VRRg0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|g0)^(2)
            CALL VRRh0g0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (h0|g0)^(1)
            CALL VRRh0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|g0)^(0)
            CALL VRRh0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|g0)^(1)
            CALL VRRi0g0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (i0|g0)^(0)
            CALL VRRi0g0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|h0)^(6)
            CALL VRRs0h0(84,84,VRR(1,1,6),VRR(1,1,7))
            ! Generating (s0|h0)^(5)
            CALL VRRs0h0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|h0)^(4)
            CALL VRRs0h0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|h0)^(3)
            CALL VRRs0h0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|h0)^(2)
            CALL VRRs0h0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|h0)^(1)
            CALL VRRs0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|h0)^(0)
            CALL VRRs0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|h0)^(5)
            CALL VRRp0h0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (p0|h0)^(4)
            CALL VRRp0h0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|h0)^(3)
            CALL VRRp0h0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|h0)^(2)
            CALL VRRp0h0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|h0)^(1)
            CALL VRRp0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|h0)^(0)
            CALL VRRp0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|h0)^(4)
            CALL VRRd0h0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (d0|h0)^(3)
            CALL VRRd0h0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|h0)^(2)
            CALL VRRd0h0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|h0)^(1)
            CALL VRRd0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|h0)^(0)
            CALL VRRd0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|h0)^(3)
            CALL VRRf0h0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (f0|h0)^(2)
            CALL VRRf0h0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|h0)^(1)
            CALL VRRf0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|h0)^(0)
            CALL VRRf0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|h0)^(2)
            CALL VRRg0h0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (g0|h0)^(1)
            CALL VRRg0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|h0)^(0)
            CALL VRRg0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|h0)^(1)
            CALL VRRh0h0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (h0|h0)^(0)
            CALL VRRh0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (i0|h0)^(0)
            CALL VRRi0h0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (s0|i0)^(5)
            CALL VRRs0i0(84,84,VRR(1,1,5),VRR(1,1,6))
            ! Generating (s0|i0)^(4)
            CALL VRRs0i0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (s0|i0)^(3)
            CALL VRRs0i0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (s0|i0)^(2)
            CALL VRRs0i0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (s0|i0)^(1)
            CALL VRRs0i0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (s0|i0)^(0)
            CALL VRRs0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (p0|i0)^(4)
            CALL VRRp0i0(84,84,VRR(1,1,4),VRR(1,1,5))
            ! Generating (p0|i0)^(3)
            CALL VRRp0i0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (p0|i0)^(2)
            CALL VRRp0i0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (p0|i0)^(1)
            CALL VRRp0i0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (p0|i0)^(0)
            CALL VRRp0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (d0|i0)^(3)
            CALL VRRd0i0(84,84,VRR(1,1,3),VRR(1,1,4))
            ! Generating (d0|i0)^(2)
            CALL VRRd0i0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (d0|i0)^(1)
            CALL VRRd0i0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (d0|i0)^(0)
            CALL VRRd0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (f0|i0)^(2)
            CALL VRRf0i0(84,84,VRR(1,1,2),VRR(1,1,3))
            ! Generating (f0|i0)^(1)
            CALL VRRf0i0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (f0|i0)^(0)
            CALL VRRf0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (g0|i0)^(1)
            CALL VRRg0i0(84,84,VRR(1,1,1),VRR(1,1,2))
            ! Generating (g0|i0)^(0)
            CALL VRRg0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            ! Generating (h0|i0)^(0)
            CALL VRRh0i0(84,84,VRR(1,1,0),VRR(1,1,1))
            !MAY BE BETTER TO PUT WHAT FOLLOWS IN A DO LOOP!
            IF(PBC%AutoW%I(1).EQ.1) THEN
            VRRS(1,1,0,1)=PQx*VRR(1,1,1)
            VRRS(1,1,1,1)=PQx*VRR(1,1,2)
            VRRS(1,1,2,1)=PQx*VRR(1,1,3)
            VRRS(1,1,3,1)=PQx*VRR(1,1,4)
            VRRS(1,1,4,1)=PQx*VRR(1,1,5)
            VRRS(1,1,5,1)=PQx*VRR(1,1,6)
            VRRS(1,1,6,1)=PQx*VRR(1,1,7)
            VRRS(1,1,7,1)=PQx*VRR(1,1,8)
            VRRS(1,1,8,1)=PQx*VRR(1,1,9)
            VRRS(1,1,9,1)=PQx*VRR(1,1,10)
            VRRS(1,1,10,1)=PQx*VRR(1,1,11)
            ! MIC-VRR: Generating [p0|s0]^(9)
            VRRS(2,1,9,1)=PAx*VRRS(1,1,9,1)+WPx*VRRS(1,1,10,1)+r1x2Z*VRR(1,1,10)
            VRRS(3,1,9,1)=PAy*VRRS(1,1,9,1)+WPy*VRRS(1,1,10,1)
            VRRS(4,1,9,1)=PAz*VRRS(1,1,9,1)+WPz*VRRS(1,1,10,1)
            ! MIC-VRR: Generating [p0|s0]^(8)
            VRRS(2,1,8,1)=PAx*VRRS(1,1,8,1)+WPx*VRRS(1,1,9,1)+r1x2Z*VRR(1,1,9)
            VRRS(3,1,8,1)=PAy*VRRS(1,1,8,1)+WPy*VRRS(1,1,9,1)
            VRRS(4,1,8,1)=PAz*VRRS(1,1,8,1)+WPz*VRRS(1,1,9,1)
            ! MIC-VRR: Generating [p0|s0]^(7)
            VRRS(2,1,7,1)=PAx*VRRS(1,1,7,1)+WPx*VRRS(1,1,8,1)+r1x2Z*VRR(1,1,8)
            VRRS(3,1,7,1)=PAy*VRRS(1,1,7,1)+WPy*VRRS(1,1,8,1)
            VRRS(4,1,7,1)=PAz*VRRS(1,1,7,1)+WPz*VRRS(1,1,8,1)
            ! MIC-VRR: Generating [p0|s0]^(6)
            VRRS(2,1,6,1)=PAx*VRRS(1,1,6,1)+WPx*VRRS(1,1,7,1)+r1x2Z*VRR(1,1,7)
            VRRS(3,1,6,1)=PAy*VRRS(1,1,6,1)+WPy*VRRS(1,1,7,1)
            VRRS(4,1,6,1)=PAz*VRRS(1,1,6,1)+WPz*VRRS(1,1,7,1)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,1)=PAx*VRRS(1,1,5,1)+WPx*VRRS(1,1,6,1)+r1x2Z*VRR(1,1,6)
            VRRS(3,1,5,1)=PAy*VRRS(1,1,5,1)+WPy*VRRS(1,1,6,1)
            VRRS(4,1,5,1)=PAz*VRRS(1,1,5,1)+WPz*VRRS(1,1,6,1)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,1)=PAx*VRRS(1,1,4,1)+WPx*VRRS(1,1,5,1)+r1x2Z*VRR(1,1,5)
            VRRS(3,1,4,1)=PAy*VRRS(1,1,4,1)+WPy*VRRS(1,1,5,1)
            VRRS(4,1,4,1)=PAz*VRRS(1,1,4,1)+WPz*VRRS(1,1,5,1)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,1)=PAx*VRRS(1,1,3,1)+WPx*VRRS(1,1,4,1)+r1x2Z*VRR(1,1,4)
            VRRS(3,1,3,1)=PAy*VRRS(1,1,3,1)+WPy*VRRS(1,1,4,1)
            VRRS(4,1,3,1)=PAz*VRRS(1,1,3,1)+WPz*VRRS(1,1,4,1)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,1)=PAx*VRRS(1,1,2,1)+WPx*VRRS(1,1,3,1)+r1x2Z*VRR(1,1,3)
            VRRS(3,1,2,1)=PAy*VRRS(1,1,2,1)+WPy*VRRS(1,1,3,1)
            VRRS(4,1,2,1)=PAz*VRRS(1,1,2,1)+WPz*VRRS(1,1,3,1)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,1)=PAx*VRRS(1,1,1,1)+WPx*VRRS(1,1,2,1)+r1x2Z*VRR(1,1,2)
            VRRS(3,1,1,1)=PAy*VRRS(1,1,1,1)+WPy*VRRS(1,1,2,1)
            VRRS(4,1,1,1)=PAz*VRRS(1,1,1,1)+WPz*VRRS(1,1,2,1)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,1)=PAx*VRRS(1,1,0,1)+WPx*VRRS(1,1,1,1)+r1x2Z*VRR(1,1,1)
            VRRS(3,1,0,1)=PAy*VRRS(1,1,0,1)+WPy*VRRS(1,1,1,1)
            VRRS(4,1,0,1)=PAz*VRRS(1,1,0,1)+WPz*VRRS(1,1,1,1)
            ! MIC-VRR: Generating [d0|s0]^(8)
            VRRS( 5,1,8,1)=PAx*VRRS(2,1,8,1)+r1x2Z*(VRRS(1,1,8,1)-ExZpE*VRRS(1,1,9,1))+WPx*VRRS(2,1,9,1)+r1x2Z*VRR(2,1,9)
            VRRS( 6,1,8,1)=PAx*VRRS(3,1,8,1)+WPx*VRRS(3,1,9,1)+r1x2Z*VRR(3,1,9)
            VRRS( 7,1,8,1)=PAy*VRRS(3,1,8,1)+r1x2Z*(VRRS(1,1,8,1)-ExZpE*VRRS(1,1,9,1))+WPy*VRRS(3,1,9,1)
            VRRS( 8,1,8,1)=PAx*VRRS(4,1,8,1)+WPx*VRRS(4,1,9,1)+r1x2Z*VRR(4,1,9)
            VRRS( 9,1,8,1)=PAy*VRRS(4,1,8,1)+WPy*VRRS(4,1,9,1)
            VRRS(10,1,8,1)=PAz*VRRS(4,1,8,1)+r1x2Z*(VRRS(1,1,8,1)-ExZpE*VRRS(1,1,9,1))+WPz*VRRS(4,1,9,1)
            ! MIC-VRR: Generating [d0|s0]^(7)
            VRRS( 5,1,7,1)=PAx*VRRS(2,1,7,1)+r1x2Z*(VRRS(1,1,7,1)-ExZpE*VRRS(1,1,8,1))+WPx*VRRS(2,1,8,1)+r1x2Z*VRR(2,1,8)
            VRRS( 6,1,7,1)=PAx*VRRS(3,1,7,1)+WPx*VRRS(3,1,8,1)+r1x2Z*VRR(3,1,8)
            VRRS( 7,1,7,1)=PAy*VRRS(3,1,7,1)+r1x2Z*(VRRS(1,1,7,1)-ExZpE*VRRS(1,1,8,1))+WPy*VRRS(3,1,8,1)
            VRRS( 8,1,7,1)=PAx*VRRS(4,1,7,1)+WPx*VRRS(4,1,8,1)+r1x2Z*VRR(4,1,8)
            VRRS( 9,1,7,1)=PAy*VRRS(4,1,7,1)+WPy*VRRS(4,1,8,1)
            VRRS(10,1,7,1)=PAz*VRRS(4,1,7,1)+r1x2Z*(VRRS(1,1,7,1)-ExZpE*VRRS(1,1,8,1))+WPz*VRRS(4,1,8,1)
            ! MIC-VRR: Generating [d0|s0]^(6)
            VRRS( 5,1,6,1)=PAx*VRRS(2,1,6,1)+r1x2Z*(VRRS(1,1,6,1)-ExZpE*VRRS(1,1,7,1))+WPx*VRRS(2,1,7,1)+r1x2Z*VRR(2,1,7)
            VRRS( 6,1,6,1)=PAx*VRRS(3,1,6,1)+WPx*VRRS(3,1,7,1)+r1x2Z*VRR(3,1,7)
            VRRS( 7,1,6,1)=PAy*VRRS(3,1,6,1)+r1x2Z*(VRRS(1,1,6,1)-ExZpE*VRRS(1,1,7,1))+WPy*VRRS(3,1,7,1)
            VRRS( 8,1,6,1)=PAx*VRRS(4,1,6,1)+WPx*VRRS(4,1,7,1)+r1x2Z*VRR(4,1,7)
            VRRS( 9,1,6,1)=PAy*VRRS(4,1,6,1)+WPy*VRRS(4,1,7,1)
            VRRS(10,1,6,1)=PAz*VRRS(4,1,6,1)+r1x2Z*(VRRS(1,1,6,1)-ExZpE*VRRS(1,1,7,1))+WPz*VRRS(4,1,7,1)
            ! MIC-VRR: Generating [d0|s0]^(5)
            VRRS( 5,1,5,1)=PAx*VRRS(2,1,5,1)+r1x2Z*(VRRS(1,1,5,1)-ExZpE*VRRS(1,1,6,1))+WPx*VRRS(2,1,6,1)+r1x2Z*VRR(2,1,6)
            VRRS( 6,1,5,1)=PAx*VRRS(3,1,5,1)+WPx*VRRS(3,1,6,1)+r1x2Z*VRR(3,1,6)
            VRRS( 7,1,5,1)=PAy*VRRS(3,1,5,1)+r1x2Z*(VRRS(1,1,5,1)-ExZpE*VRRS(1,1,6,1))+WPy*VRRS(3,1,6,1)
            VRRS( 8,1,5,1)=PAx*VRRS(4,1,5,1)+WPx*VRRS(4,1,6,1)+r1x2Z*VRR(4,1,6)
            VRRS( 9,1,5,1)=PAy*VRRS(4,1,5,1)+WPy*VRRS(4,1,6,1)
            VRRS(10,1,5,1)=PAz*VRRS(4,1,5,1)+r1x2Z*(VRRS(1,1,5,1)-ExZpE*VRRS(1,1,6,1))+WPz*VRRS(4,1,6,1)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,1)=PAx*VRRS(2,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPx*VRRS(2,1,5,1)+r1x2Z*VRR(2,1,5)
            VRRS( 6,1,4,1)=PAx*VRRS(3,1,4,1)+WPx*VRRS(3,1,5,1)+r1x2Z*VRR(3,1,5)
            VRRS( 7,1,4,1)=PAy*VRRS(3,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPy*VRRS(3,1,5,1)
            VRRS( 8,1,4,1)=PAx*VRRS(4,1,4,1)+WPx*VRRS(4,1,5,1)+r1x2Z*VRR(4,1,5)
            VRRS( 9,1,4,1)=PAy*VRRS(4,1,4,1)+WPy*VRRS(4,1,5,1)
            VRRS(10,1,4,1)=PAz*VRRS(4,1,4,1)+r1x2Z*(VRRS(1,1,4,1)-ExZpE*VRRS(1,1,5,1))+WPz*VRRS(4,1,5,1)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,1)=PAx*VRRS(2,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPx*VRRS(2,1,4,1)+r1x2Z*VRR(2,1,4)
            VRRS( 6,1,3,1)=PAx*VRRS(3,1,3,1)+WPx*VRRS(3,1,4,1)+r1x2Z*VRR(3,1,4)
            VRRS( 7,1,3,1)=PAy*VRRS(3,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPy*VRRS(3,1,4,1)
            VRRS( 8,1,3,1)=PAx*VRRS(4,1,3,1)+WPx*VRRS(4,1,4,1)+r1x2Z*VRR(4,1,4)
            VRRS( 9,1,3,1)=PAy*VRRS(4,1,3,1)+WPy*VRRS(4,1,4,1)
            VRRS(10,1,3,1)=PAz*VRRS(4,1,3,1)+r1x2Z*(VRRS(1,1,3,1)-ExZpE*VRRS(1,1,4,1))+WPz*VRRS(4,1,4,1)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,1)=PAx*VRRS(2,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPx*VRRS(2,1,3,1)+r1x2Z*VRR(2,1,3)
            VRRS( 6,1,2,1)=PAx*VRRS(3,1,2,1)+WPx*VRRS(3,1,3,1)+r1x2Z*VRR(3,1,3)
            VRRS( 7,1,2,1)=PAy*VRRS(3,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPy*VRRS(3,1,3,1)
            VRRS( 8,1,2,1)=PAx*VRRS(4,1,2,1)+WPx*VRRS(4,1,3,1)+r1x2Z*VRR(4,1,3)
            VRRS( 9,1,2,1)=PAy*VRRS(4,1,2,1)+WPy*VRRS(4,1,3,1)
            VRRS(10,1,2,1)=PAz*VRRS(4,1,2,1)+r1x2Z*(VRRS(1,1,2,1)-ExZpE*VRRS(1,1,3,1))+WPz*VRRS(4,1,3,1)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,1)=PAx*VRRS(2,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPx*VRRS(2,1,2,1)+r1x2Z*VRR(2,1,2)
            VRRS( 6,1,1,1)=PAx*VRRS(3,1,1,1)+WPx*VRRS(3,1,2,1)+r1x2Z*VRR(3,1,2)
            VRRS( 7,1,1,1)=PAy*VRRS(3,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPy*VRRS(3,1,2,1)
            VRRS( 8,1,1,1)=PAx*VRRS(4,1,1,1)+WPx*VRRS(4,1,2,1)+r1x2Z*VRR(4,1,2)
            VRRS( 9,1,1,1)=PAy*VRRS(4,1,1,1)+WPy*VRRS(4,1,2,1)
            VRRS(10,1,1,1)=PAz*VRRS(4,1,1,1)+r1x2Z*(VRRS(1,1,1,1)-ExZpE*VRRS(1,1,2,1))+WPz*VRRS(4,1,2,1)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,1)=PAx*VRRS(2,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPx*VRRS(2,1,1,1)+r1x2Z*VRR(2,1,1)
            VRRS( 6,1,0,1)=PAx*VRRS(3,1,0,1)+WPx*VRRS(3,1,1,1)+r1x2Z*VRR(3,1,1)
            VRRS( 7,1,0,1)=PAy*VRRS(3,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPy*VRRS(3,1,1,1)
            VRRS( 8,1,0,1)=PAx*VRRS(4,1,0,1)+WPx*VRRS(4,1,1,1)+r1x2Z*VRR(4,1,1)
            VRRS( 9,1,0,1)=PAy*VRRS(4,1,0,1)+WPy*VRRS(4,1,1,1)
            VRRS(10,1,0,1)=PAz*VRRS(4,1,0,1)+r1x2Z*(VRRS(1,1,0,1)-ExZpE*VRRS(1,1,1,1))+WPz*VRRS(4,1,1,1)
            ! MIC-VRR: Generating [f0|s0]^(7)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,7,1),VRRS(1,1,8,1),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [f0|s0]^(6)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|s0]^(5)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|s0]^(4)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(6)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [g0|s0]^(5)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|s0]^(4)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|s0]^(3)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(5)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [h0|s0]^(4)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|s0]^(3)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|s0]^(2)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|p0]^(9)
            VRRS(1,2,9,1)=QCx*VRRS(1,1,9,1)+WQx*VRRS(1,1,10,1)-r1x2E*VRR(1,1,10)
            VRRS(1,3,9,1)=QCy*VRRS(1,1,9,1)+WQy*VRRS(1,1,10,1)
            VRRS(1,4,9,1)=QCz*VRRS(1,1,9,1)+WQz*VRRS(1,1,10,1)
            ! MIC-VRR: Generating [s0|p0]^(8)
            VRRS(1,2,8,1)=QCx*VRRS(1,1,8,1)+WQx*VRRS(1,1,9,1)-r1x2E*VRR(1,1,9)
            VRRS(1,3,8,1)=QCy*VRRS(1,1,8,1)+WQy*VRRS(1,1,9,1)
            VRRS(1,4,8,1)=QCz*VRRS(1,1,8,1)+WQz*VRRS(1,1,9,1)
            ! MIC-VRR: Generating [s0|p0]^(7)
            VRRS(1,2,7,1)=QCx*VRRS(1,1,7,1)+WQx*VRRS(1,1,8,1)-r1x2E*VRR(1,1,8)
            VRRS(1,3,7,1)=QCy*VRRS(1,1,7,1)+WQy*VRRS(1,1,8,1)
            VRRS(1,4,7,1)=QCz*VRRS(1,1,7,1)+WQz*VRRS(1,1,8,1)
            ! MIC-VRR: Generating [s0|p0]^(6)
            VRRS(1,2,6,1)=QCx*VRRS(1,1,6,1)+WQx*VRRS(1,1,7,1)-r1x2E*VRR(1,1,7)
            VRRS(1,3,6,1)=QCy*VRRS(1,1,6,1)+WQy*VRRS(1,1,7,1)
            VRRS(1,4,6,1)=QCz*VRRS(1,1,6,1)+WQz*VRRS(1,1,7,1)
            ! MIC-VRR: Generating [s0|p0]^(5)
            VRRS(1,2,5,1)=QCx*VRRS(1,1,5,1)+WQx*VRRS(1,1,6,1)-r1x2E*VRR(1,1,6)
            VRRS(1,3,5,1)=QCy*VRRS(1,1,5,1)+WQy*VRRS(1,1,6,1)
            VRRS(1,4,5,1)=QCz*VRRS(1,1,5,1)+WQz*VRRS(1,1,6,1)
            ! MIC-VRR: Generating [s0|p0]^(4)
            VRRS(1,2,4,1)=QCx*VRRS(1,1,4,1)+WQx*VRRS(1,1,5,1)-r1x2E*VRR(1,1,5)
            VRRS(1,3,4,1)=QCy*VRRS(1,1,4,1)+WQy*VRRS(1,1,5,1)
            VRRS(1,4,4,1)=QCz*VRRS(1,1,4,1)+WQz*VRRS(1,1,5,1)
            ! MIC-VRR: Generating [s0|p0]^(3)
            VRRS(1,2,3,1)=QCx*VRRS(1,1,3,1)+WQx*VRRS(1,1,4,1)-r1x2E*VRR(1,1,4)
            VRRS(1,3,3,1)=QCy*VRRS(1,1,3,1)+WQy*VRRS(1,1,4,1)
            VRRS(1,4,3,1)=QCz*VRRS(1,1,3,1)+WQz*VRRS(1,1,4,1)
            ! MIC-VRR: Generating [s0|p0]^(2)
            VRRS(1,2,2,1)=QCx*VRRS(1,1,2,1)+WQx*VRRS(1,1,3,1)-r1x2E*VRR(1,1,3)
            VRRS(1,3,2,1)=QCy*VRRS(1,1,2,1)+WQy*VRRS(1,1,3,1)
            VRRS(1,4,2,1)=QCz*VRRS(1,1,2,1)+WQz*VRRS(1,1,3,1)
            ! MIC-VRR: Generating [s0|p0]^(1)
            VRRS(1,2,1,1)=QCx*VRRS(1,1,1,1)+WQx*VRRS(1,1,2,1)-r1x2E*VRR(1,1,2)
            VRRS(1,3,1,1)=QCy*VRRS(1,1,1,1)+WQy*VRRS(1,1,2,1)
            VRRS(1,4,1,1)=QCz*VRRS(1,1,1,1)+WQz*VRRS(1,1,2,1)
            ! MIC-VRR: Generating [s0|p0]^(0)
            VRRS(1,2,0,1)=QCx*VRRS(1,1,0,1)+WQx*VRRS(1,1,1,1)-r1x2E*VRR(1,1,1)
            VRRS(1,3,0,1)=QCy*VRRS(1,1,0,1)+WQy*VRRS(1,1,1,1)
            VRRS(1,4,0,1)=QCz*VRRS(1,1,0,1)+WQz*VRRS(1,1,1,1)
            ! MIC-VRR: Generating [p0|p0]^(8)
            VRRS(2,2,8,1)=QCx*VRRS(2,1,8,1)+WQx*VRRS(2,1,9,1)+HfxZpE*VRRS(1,1,9,1)-r1x2E *VRR(2,1,9)
            VRRS(2,3,8,1)=QCy*VRRS(2,1,8,1)+WQy*VRRS(2,1,9,1)
            VRRS(2,4,8,1)=QCz*VRRS(2,1,8,1)+WQz*VRRS(2,1,9,1)
            VRRS(3,2,8,1)=QCx*VRRS(3,1,8,1)+WQx*VRRS(3,1,9,1)-r1x2E *VRR(3,1,9)
            VRRS(3,3,8,1)=QCy*VRRS(3,1,8,1)+WQy*VRRS(3,1,9,1)+HfxZpE*VRRS(1,1,9,1)
            VRRS(3,4,8,1)=QCz*VRRS(3,1,8,1)+WQz*VRRS(3,1,9,1)
            VRRS(4,2,8,1)=QCx*VRRS(4,1,8,1)+WQx*VRRS(4,1,9,1)-r1x2E *VRR(4,1,9)
            VRRS(4,3,8,1)=QCy*VRRS(4,1,8,1)+WQy*VRRS(4,1,9,1)
            VRRS(4,4,8,1)=QCz*VRRS(4,1,8,1)+WQz*VRRS(4,1,9,1)+HfxZpE*VRRS(1,1,9,1)
            ! MIC-VRR: Generating [p0|p0]^(7)
            VRRS(2,2,7,1)=QCx*VRRS(2,1,7,1)+WQx*VRRS(2,1,8,1)+HfxZpE*VRRS(1,1,8,1)-r1x2E *VRR(2,1,8)
            VRRS(2,3,7,1)=QCy*VRRS(2,1,7,1)+WQy*VRRS(2,1,8,1)
            VRRS(2,4,7,1)=QCz*VRRS(2,1,7,1)+WQz*VRRS(2,1,8,1)
            VRRS(3,2,7,1)=QCx*VRRS(3,1,7,1)+WQx*VRRS(3,1,8,1)-r1x2E *VRR(3,1,8)
            VRRS(3,3,7,1)=QCy*VRRS(3,1,7,1)+WQy*VRRS(3,1,8,1)+HfxZpE*VRRS(1,1,8,1)
            VRRS(3,4,7,1)=QCz*VRRS(3,1,7,1)+WQz*VRRS(3,1,8,1)
            VRRS(4,2,7,1)=QCx*VRRS(4,1,7,1)+WQx*VRRS(4,1,8,1)-r1x2E *VRR(4,1,8)
            VRRS(4,3,7,1)=QCy*VRRS(4,1,7,1)+WQy*VRRS(4,1,8,1)
            VRRS(4,4,7,1)=QCz*VRRS(4,1,7,1)+WQz*VRRS(4,1,8,1)+HfxZpE*VRRS(1,1,8,1)
            ! MIC-VRR: Generating [p0|p0]^(6)
            VRRS(2,2,6,1)=QCx*VRRS(2,1,6,1)+WQx*VRRS(2,1,7,1)+HfxZpE*VRRS(1,1,7,1)-r1x2E *VRR(2,1,7)
            VRRS(2,3,6,1)=QCy*VRRS(2,1,6,1)+WQy*VRRS(2,1,7,1)
            VRRS(2,4,6,1)=QCz*VRRS(2,1,6,1)+WQz*VRRS(2,1,7,1)
            VRRS(3,2,6,1)=QCx*VRRS(3,1,6,1)+WQx*VRRS(3,1,7,1)-r1x2E *VRR(3,1,7)
            VRRS(3,3,6,1)=QCy*VRRS(3,1,6,1)+WQy*VRRS(3,1,7,1)+HfxZpE*VRRS(1,1,7,1)
            VRRS(3,4,6,1)=QCz*VRRS(3,1,6,1)+WQz*VRRS(3,1,7,1)
            VRRS(4,2,6,1)=QCx*VRRS(4,1,6,1)+WQx*VRRS(4,1,7,1)-r1x2E *VRR(4,1,7)
            VRRS(4,3,6,1)=QCy*VRRS(4,1,6,1)+WQy*VRRS(4,1,7,1)
            VRRS(4,4,6,1)=QCz*VRRS(4,1,6,1)+WQz*VRRS(4,1,7,1)+HfxZpE*VRRS(1,1,7,1)
            ! MIC-VRR: Generating [p0|p0]^(5)
            VRRS(2,2,5,1)=QCx*VRRS(2,1,5,1)+WQx*VRRS(2,1,6,1)+HfxZpE*VRRS(1,1,6,1)-r1x2E *VRR(2,1,6)
            VRRS(2,3,5,1)=QCy*VRRS(2,1,5,1)+WQy*VRRS(2,1,6,1)
            VRRS(2,4,5,1)=QCz*VRRS(2,1,5,1)+WQz*VRRS(2,1,6,1)
            VRRS(3,2,5,1)=QCx*VRRS(3,1,5,1)+WQx*VRRS(3,1,6,1)-r1x2E *VRR(3,1,6)
            VRRS(3,3,5,1)=QCy*VRRS(3,1,5,1)+WQy*VRRS(3,1,6,1)+HfxZpE*VRRS(1,1,6,1)
            VRRS(3,4,5,1)=QCz*VRRS(3,1,5,1)+WQz*VRRS(3,1,6,1)
            VRRS(4,2,5,1)=QCx*VRRS(4,1,5,1)+WQx*VRRS(4,1,6,1)-r1x2E *VRR(4,1,6)
            VRRS(4,3,5,1)=QCy*VRRS(4,1,5,1)+WQy*VRRS(4,1,6,1)
            VRRS(4,4,5,1)=QCz*VRRS(4,1,5,1)+WQz*VRRS(4,1,6,1)+HfxZpE*VRRS(1,1,6,1)
            ! MIC-VRR: Generating [p0|p0]^(4)
            VRRS(2,2,4,1)=QCx*VRRS(2,1,4,1)+WQx*VRRS(2,1,5,1)+HfxZpE*VRRS(1,1,5,1)-r1x2E *VRR(2,1,5)
            VRRS(2,3,4,1)=QCy*VRRS(2,1,4,1)+WQy*VRRS(2,1,5,1)
            VRRS(2,4,4,1)=QCz*VRRS(2,1,4,1)+WQz*VRRS(2,1,5,1)
            VRRS(3,2,4,1)=QCx*VRRS(3,1,4,1)+WQx*VRRS(3,1,5,1)-r1x2E *VRR(3,1,5)
            VRRS(3,3,4,1)=QCy*VRRS(3,1,4,1)+WQy*VRRS(3,1,5,1)+HfxZpE*VRRS(1,1,5,1)
            VRRS(3,4,4,1)=QCz*VRRS(3,1,4,1)+WQz*VRRS(3,1,5,1)
            VRRS(4,2,4,1)=QCx*VRRS(4,1,4,1)+WQx*VRRS(4,1,5,1)-r1x2E *VRR(4,1,5)
            VRRS(4,3,4,1)=QCy*VRRS(4,1,4,1)+WQy*VRRS(4,1,5,1)
            VRRS(4,4,4,1)=QCz*VRRS(4,1,4,1)+WQz*VRRS(4,1,5,1)+HfxZpE*VRRS(1,1,5,1)
            ! MIC-VRR: Generating [p0|p0]^(3)
            VRRS(2,2,3,1)=QCx*VRRS(2,1,3,1)+WQx*VRRS(2,1,4,1)+HfxZpE*VRRS(1,1,4,1)-r1x2E *VRR(2,1,4)
            VRRS(2,3,3,1)=QCy*VRRS(2,1,3,1)+WQy*VRRS(2,1,4,1)
            VRRS(2,4,3,1)=QCz*VRRS(2,1,3,1)+WQz*VRRS(2,1,4,1)
            VRRS(3,2,3,1)=QCx*VRRS(3,1,3,1)+WQx*VRRS(3,1,4,1)-r1x2E *VRR(3,1,4)
            VRRS(3,3,3,1)=QCy*VRRS(3,1,3,1)+WQy*VRRS(3,1,4,1)+HfxZpE*VRRS(1,1,4,1)
            VRRS(3,4,3,1)=QCz*VRRS(3,1,3,1)+WQz*VRRS(3,1,4,1)
            VRRS(4,2,3,1)=QCx*VRRS(4,1,3,1)+WQx*VRRS(4,1,4,1)-r1x2E *VRR(4,1,4)
            VRRS(4,3,3,1)=QCy*VRRS(4,1,3,1)+WQy*VRRS(4,1,4,1)
            VRRS(4,4,3,1)=QCz*VRRS(4,1,3,1)+WQz*VRRS(4,1,4,1)+HfxZpE*VRRS(1,1,4,1)
            ! MIC-VRR: Generating [p0|p0]^(2)
            VRRS(2,2,2,1)=QCx*VRRS(2,1,2,1)+WQx*VRRS(2,1,3,1)+HfxZpE*VRRS(1,1,3,1)-r1x2E *VRR(2,1,3)
            VRRS(2,3,2,1)=QCy*VRRS(2,1,2,1)+WQy*VRRS(2,1,3,1)
            VRRS(2,4,2,1)=QCz*VRRS(2,1,2,1)+WQz*VRRS(2,1,3,1)
            VRRS(3,2,2,1)=QCx*VRRS(3,1,2,1)+WQx*VRRS(3,1,3,1)-r1x2E *VRR(3,1,3)
            VRRS(3,3,2,1)=QCy*VRRS(3,1,2,1)+WQy*VRRS(3,1,3,1)+HfxZpE*VRRS(1,1,3,1)
            VRRS(3,4,2,1)=QCz*VRRS(3,1,2,1)+WQz*VRRS(3,1,3,1)
            VRRS(4,2,2,1)=QCx*VRRS(4,1,2,1)+WQx*VRRS(4,1,3,1)-r1x2E *VRR(4,1,3)
            VRRS(4,3,2,1)=QCy*VRRS(4,1,2,1)+WQy*VRRS(4,1,3,1)
            VRRS(4,4,2,1)=QCz*VRRS(4,1,2,1)+WQz*VRRS(4,1,3,1)+HfxZpE*VRRS(1,1,3,1)
            ! MIC-VRR: Generating [p0|p0]^(1)
            VRRS(2,2,1,1)=QCx*VRRS(2,1,1,1)+WQx*VRRS(2,1,2,1)+HfxZpE*VRRS(1,1,2,1)-r1x2E *VRR(2,1,2)
            VRRS(2,3,1,1)=QCy*VRRS(2,1,1,1)+WQy*VRRS(2,1,2,1)
            VRRS(2,4,1,1)=QCz*VRRS(2,1,1,1)+WQz*VRRS(2,1,2,1)
            VRRS(3,2,1,1)=QCx*VRRS(3,1,1,1)+WQx*VRRS(3,1,2,1)-r1x2E *VRR(3,1,2)
            VRRS(3,3,1,1)=QCy*VRRS(3,1,1,1)+WQy*VRRS(3,1,2,1)+HfxZpE*VRRS(1,1,2,1)
            VRRS(3,4,1,1)=QCz*VRRS(3,1,1,1)+WQz*VRRS(3,1,2,1)
            VRRS(4,2,1,1)=QCx*VRRS(4,1,1,1)+WQx*VRRS(4,1,2,1)-r1x2E *VRR(4,1,2)
            VRRS(4,3,1,1)=QCy*VRRS(4,1,1,1)+WQy*VRRS(4,1,2,1)
            VRRS(4,4,1,1)=QCz*VRRS(4,1,1,1)+WQz*VRRS(4,1,2,1)+HfxZpE*VRRS(1,1,2,1)
            ! MIC-VRR: Generating [p0|p0]^(0)
            VRRS(2,2,0,1)=QCx*VRRS(2,1,0,1)+WQx*VRRS(2,1,1,1)+HfxZpE*VRRS(1,1,1,1)-r1x2E *VRR(2,1,1)
            VRRS(2,3,0,1)=QCy*VRRS(2,1,0,1)+WQy*VRRS(2,1,1,1)
            VRRS(2,4,0,1)=QCz*VRRS(2,1,0,1)+WQz*VRRS(2,1,1,1)
            VRRS(3,2,0,1)=QCx*VRRS(3,1,0,1)+WQx*VRRS(3,1,1,1)-r1x2E *VRR(3,1,1)
            VRRS(3,3,0,1)=QCy*VRRS(3,1,0,1)+WQy*VRRS(3,1,1,1)+HfxZpE*VRRS(1,1,1,1)
            VRRS(3,4,0,1)=QCz*VRRS(3,1,0,1)+WQz*VRRS(3,1,1,1)
            VRRS(4,2,0,1)=QCx*VRRS(4,1,0,1)+WQx*VRRS(4,1,1,1)-r1x2E *VRR(4,1,1)
            VRRS(4,3,0,1)=QCy*VRRS(4,1,0,1)+WQy*VRRS(4,1,1,1)
            VRRS(4,4,0,1)=QCz*VRRS(4,1,0,1)+WQz*VRRS(4,1,1,1)+HfxZpE*VRRS(1,1,1,1)
            ! MIC-VRR: Generating [d0|p0]^(7)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,7,1),VRRS(1,1,8,1),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [d0|p0]^(6)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|p0]^(5)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|p0]^(4)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|p0]^(3)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|p0]^(2)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|p0]^(1)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|p0]^(0)
            CALL MVRRd0p0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|p0]^(6)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|p0]^(5)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|p0]^(4)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|p0]^(3)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|p0]^(2)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|p0]^(1)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|p0]^(0)
            CALL MVRRf0p0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|p0]^(5)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|p0]^(4)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|p0]^(3)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|p0]^(2)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|p0]^(1)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|p0]^(0)
            CALL MVRRg0p0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|p0]^(4)
            CALL MVRRh0p0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|p0]^(3)
            CALL MVRRh0p0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|p0]^(2)
            CALL MVRRh0p0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|p0]^(1)
            CALL MVRRh0p0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|p0]^(0)
            CALL MVRRh0p0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|d0]^(8)
            VRRS(1, 5,8,1)=QCx*VRRS(1,2,8,1)+r1x2E*(VRRS(1,1,8,1)-ZxZpE*VRRS(1,1,9,1))+WQx*VRRS(1,2,9,1)-r1x2E*VRR(1,2,9)
            VRRS(1, 6,8,1)=QCx*VRRS(1,3,8,1)+WQx*VRRS(1,3,9,1)-r1x2E*VRR(1,3,9)
            VRRS(1, 7,8,1)=QCy*VRRS(1,3,8,1)+r1x2E*(VRRS(1,1,8,1)-ZxZpE*VRRS(1,1,9,1))+WQy*VRRS(1,3,9,1)
            VRRS(1, 8,8,1)=QCx*VRRS(1,4,8,1)+WQx*VRRS(1,4,9,1)-r1x2E*VRR(1,4,9)
            VRRS(1, 9,8,1)=QCy*VRRS(1,4,8,1)+WQy*VRRS(1,4,9,1)
            VRRS(1,10,8,1)=QCz*VRRS(1,4,8,1)+r1x2E*(VRRS(1,1,8,1)-ZxZpE*VRRS(1,1,9,1))+WQz*VRRS(1,4,9,1)
            ! MIC-VRR: Generating [s0|d0]^(7)
            VRRS(1, 5,7,1)=QCx*VRRS(1,2,7,1)+r1x2E*(VRRS(1,1,7,1)-ZxZpE*VRRS(1,1,8,1))+WQx*VRRS(1,2,8,1)-r1x2E*VRR(1,2,8)
            VRRS(1, 6,7,1)=QCx*VRRS(1,3,7,1)+WQx*VRRS(1,3,8,1)-r1x2E*VRR(1,3,8)
            VRRS(1, 7,7,1)=QCy*VRRS(1,3,7,1)+r1x2E*(VRRS(1,1,7,1)-ZxZpE*VRRS(1,1,8,1))+WQy*VRRS(1,3,8,1)
            VRRS(1, 8,7,1)=QCx*VRRS(1,4,7,1)+WQx*VRRS(1,4,8,1)-r1x2E*VRR(1,4,8)
            VRRS(1, 9,7,1)=QCy*VRRS(1,4,7,1)+WQy*VRRS(1,4,8,1)
            VRRS(1,10,7,1)=QCz*VRRS(1,4,7,1)+r1x2E*(VRRS(1,1,7,1)-ZxZpE*VRRS(1,1,8,1))+WQz*VRRS(1,4,8,1)
            ! MIC-VRR: Generating [s0|d0]^(6)
            VRRS(1, 5,6,1)=QCx*VRRS(1,2,6,1)+r1x2E*(VRRS(1,1,6,1)-ZxZpE*VRRS(1,1,7,1))+WQx*VRRS(1,2,7,1)-r1x2E*VRR(1,2,7)
            VRRS(1, 6,6,1)=QCx*VRRS(1,3,6,1)+WQx*VRRS(1,3,7,1)-r1x2E*VRR(1,3,7)
            VRRS(1, 7,6,1)=QCy*VRRS(1,3,6,1)+r1x2E*(VRRS(1,1,6,1)-ZxZpE*VRRS(1,1,7,1))+WQy*VRRS(1,3,7,1)
            VRRS(1, 8,6,1)=QCx*VRRS(1,4,6,1)+WQx*VRRS(1,4,7,1)-r1x2E*VRR(1,4,7)
            VRRS(1, 9,6,1)=QCy*VRRS(1,4,6,1)+WQy*VRRS(1,4,7,1)
            VRRS(1,10,6,1)=QCz*VRRS(1,4,6,1)+r1x2E*(VRRS(1,1,6,1)-ZxZpE*VRRS(1,1,7,1))+WQz*VRRS(1,4,7,1)
            ! MIC-VRR: Generating [s0|d0]^(5)
            VRRS(1, 5,5,1)=QCx*VRRS(1,2,5,1)+r1x2E*(VRRS(1,1,5,1)-ZxZpE*VRRS(1,1,6,1))+WQx*VRRS(1,2,6,1)-r1x2E*VRR(1,2,6)
            VRRS(1, 6,5,1)=QCx*VRRS(1,3,5,1)+WQx*VRRS(1,3,6,1)-r1x2E*VRR(1,3,6)
            VRRS(1, 7,5,1)=QCy*VRRS(1,3,5,1)+r1x2E*(VRRS(1,1,5,1)-ZxZpE*VRRS(1,1,6,1))+WQy*VRRS(1,3,6,1)
            VRRS(1, 8,5,1)=QCx*VRRS(1,4,5,1)+WQx*VRRS(1,4,6,1)-r1x2E*VRR(1,4,6)
            VRRS(1, 9,5,1)=QCy*VRRS(1,4,5,1)+WQy*VRRS(1,4,6,1)
            VRRS(1,10,5,1)=QCz*VRRS(1,4,5,1)+r1x2E*(VRRS(1,1,5,1)-ZxZpE*VRRS(1,1,6,1))+WQz*VRRS(1,4,6,1)
            ! MIC-VRR: Generating [s0|d0]^(4)
            VRRS(1, 5,4,1)=QCx*VRRS(1,2,4,1)+r1x2E*(VRRS(1,1,4,1)-ZxZpE*VRRS(1,1,5,1))+WQx*VRRS(1,2,5,1)-r1x2E*VRR(1,2,5)
            VRRS(1, 6,4,1)=QCx*VRRS(1,3,4,1)+WQx*VRRS(1,3,5,1)-r1x2E*VRR(1,3,5)
            VRRS(1, 7,4,1)=QCy*VRRS(1,3,4,1)+r1x2E*(VRRS(1,1,4,1)-ZxZpE*VRRS(1,1,5,1))+WQy*VRRS(1,3,5,1)
            VRRS(1, 8,4,1)=QCx*VRRS(1,4,4,1)+WQx*VRRS(1,4,5,1)-r1x2E*VRR(1,4,5)
            VRRS(1, 9,4,1)=QCy*VRRS(1,4,4,1)+WQy*VRRS(1,4,5,1)
            VRRS(1,10,4,1)=QCz*VRRS(1,4,4,1)+r1x2E*(VRRS(1,1,4,1)-ZxZpE*VRRS(1,1,5,1))+WQz*VRRS(1,4,5,1)
            ! MIC-VRR: Generating [s0|d0]^(3)
            VRRS(1, 5,3,1)=QCx*VRRS(1,2,3,1)+r1x2E*(VRRS(1,1,3,1)-ZxZpE*VRRS(1,1,4,1))+WQx*VRRS(1,2,4,1)-r1x2E*VRR(1,2,4)
            VRRS(1, 6,3,1)=QCx*VRRS(1,3,3,1)+WQx*VRRS(1,3,4,1)-r1x2E*VRR(1,3,4)
            VRRS(1, 7,3,1)=QCy*VRRS(1,3,3,1)+r1x2E*(VRRS(1,1,3,1)-ZxZpE*VRRS(1,1,4,1))+WQy*VRRS(1,3,4,1)
            VRRS(1, 8,3,1)=QCx*VRRS(1,4,3,1)+WQx*VRRS(1,4,4,1)-r1x2E*VRR(1,4,4)
            VRRS(1, 9,3,1)=QCy*VRRS(1,4,3,1)+WQy*VRRS(1,4,4,1)
            VRRS(1,10,3,1)=QCz*VRRS(1,4,3,1)+r1x2E*(VRRS(1,1,3,1)-ZxZpE*VRRS(1,1,4,1))+WQz*VRRS(1,4,4,1)
            ! MIC-VRR: Generating [s0|d0]^(2)
            VRRS(1, 5,2,1)=QCx*VRRS(1,2,2,1)+r1x2E*(VRRS(1,1,2,1)-ZxZpE*VRRS(1,1,3,1))+WQx*VRRS(1,2,3,1)-r1x2E*VRR(1,2,3)
            VRRS(1, 6,2,1)=QCx*VRRS(1,3,2,1)+WQx*VRRS(1,3,3,1)-r1x2E*VRR(1,3,3)
            VRRS(1, 7,2,1)=QCy*VRRS(1,3,2,1)+r1x2E*(VRRS(1,1,2,1)-ZxZpE*VRRS(1,1,3,1))+WQy*VRRS(1,3,3,1)
            VRRS(1, 8,2,1)=QCx*VRRS(1,4,2,1)+WQx*VRRS(1,4,3,1)-r1x2E*VRR(1,4,3)
            VRRS(1, 9,2,1)=QCy*VRRS(1,4,2,1)+WQy*VRRS(1,4,3,1)
            VRRS(1,10,2,1)=QCz*VRRS(1,4,2,1)+r1x2E*(VRRS(1,1,2,1)-ZxZpE*VRRS(1,1,3,1))+WQz*VRRS(1,4,3,1)
            ! MIC-VRR: Generating [s0|d0]^(1)
            VRRS(1, 5,1,1)=QCx*VRRS(1,2,1,1)+r1x2E*(VRRS(1,1,1,1)-ZxZpE*VRRS(1,1,2,1))+WQx*VRRS(1,2,2,1)-r1x2E*VRR(1,2,2)
            VRRS(1, 6,1,1)=QCx*VRRS(1,3,1,1)+WQx*VRRS(1,3,2,1)-r1x2E*VRR(1,3,2)
            VRRS(1, 7,1,1)=QCy*VRRS(1,3,1,1)+r1x2E*(VRRS(1,1,1,1)-ZxZpE*VRRS(1,1,2,1))+WQy*VRRS(1,3,2,1)
            VRRS(1, 8,1,1)=QCx*VRRS(1,4,1,1)+WQx*VRRS(1,4,2,1)-r1x2E*VRR(1,4,2)
            VRRS(1, 9,1,1)=QCy*VRRS(1,4,1,1)+WQy*VRRS(1,4,2,1)
            VRRS(1,10,1,1)=QCz*VRRS(1,4,1,1)+r1x2E*(VRRS(1,1,1,1)-ZxZpE*VRRS(1,1,2,1))+WQz*VRRS(1,4,2,1)
            ! MIC-VRR: Generating [s0|d0]^(0)
            VRRS(1, 5,0,1)=QCx*VRRS(1,2,0,1)+r1x2E*(VRRS(1,1,0,1)-ZxZpE*VRRS(1,1,1,1))+WQx*VRRS(1,2,1,1)-r1x2E*VRR(1,2,1)
            VRRS(1, 6,0,1)=QCx*VRRS(1,3,0,1)+WQx*VRRS(1,3,1,1)-r1x2E*VRR(1,3,1)
            VRRS(1, 7,0,1)=QCy*VRRS(1,3,0,1)+r1x2E*(VRRS(1,1,0,1)-ZxZpE*VRRS(1,1,1,1))+WQy*VRRS(1,3,1,1)
            VRRS(1, 8,0,1)=QCx*VRRS(1,4,0,1)+WQx*VRRS(1,4,1,1)-r1x2E*VRR(1,4,1)
            VRRS(1, 9,0,1)=QCy*VRRS(1,4,0,1)+WQy*VRRS(1,4,1,1)
            VRRS(1,10,0,1)=QCz*VRRS(1,4,0,1)+r1x2E*(VRRS(1,1,0,1)-ZxZpE*VRRS(1,1,1,1))+WQz*VRRS(1,4,1,1)
            ! MIC-VRR: Generating [p0|d0]^(7)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,7,1),VRRS(1,1,8,1),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [p0|d0]^(6)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|d0]^(5)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|d0]^(4)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|d0]^(3)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|d0]^(2)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|d0]^(1)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|d0]^(0)
            CALL MVRRp0d0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|d0]^(6)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|d0]^(5)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|d0]^(4)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|d0]^(3)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|d0]^(2)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|d0]^(1)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|d0]^(0)
            CALL MVRRd0d0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|d0]^(5)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|d0]^(4)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|d0]^(3)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|d0]^(2)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|d0]^(1)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|d0]^(0)
            CALL MVRRf0d0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|d0]^(4)
            CALL MVRRg0d0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|d0]^(3)
            CALL MVRRg0d0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|d0]^(2)
            CALL MVRRg0d0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|d0]^(1)
            CALL MVRRg0d0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|d0]^(0)
            CALL MVRRg0d0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|d0]^(3)
            CALL MVRRh0d0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|d0]^(2)
            CALL MVRRh0d0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|d0]^(1)
            CALL MVRRh0d0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|d0]^(0)
            CALL MVRRh0d0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|f0]^(7)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,7,1),VRRS(1,1,8,1),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [s0|f0]^(6)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|f0]^(5)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|f0]^(4)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|f0]^(3)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|f0]^(2)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|f0]^(1)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|f0]^(0)
            CALL MVRRs0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|f0]^(6)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|f0]^(5)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|f0]^(4)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|f0]^(3)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|f0]^(2)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|f0]^(1)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|f0]^(0)
            CALL MVRRp0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|f0]^(5)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|f0]^(4)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|f0]^(3)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|f0]^(2)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|f0]^(1)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|f0]^(0)
            CALL MVRRd0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|f0]^(4)
            CALL MVRRf0f0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|f0]^(3)
            CALL MVRRf0f0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|f0]^(2)
            CALL MVRRf0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|f0]^(1)
            CALL MVRRf0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|f0]^(0)
            CALL MVRRf0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|f0]^(3)
            CALL MVRRg0f0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|f0]^(2)
            CALL MVRRg0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|f0]^(1)
            CALL MVRRg0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|f0]^(0)
            CALL MVRRg0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|f0]^(2)
            CALL MVRRh0f0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|f0]^(1)
            CALL MVRRh0f0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|f0]^(0)
            CALL MVRRh0f0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|g0]^(6)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,6,1),VRRS(1,1,7,1),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|g0]^(5)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|g0]^(4)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|g0]^(3)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|g0]^(2)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|g0]^(1)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|g0]^(0)
            CALL MVRRs0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|g0]^(5)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|g0]^(4)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|g0]^(3)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|g0]^(2)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|g0]^(1)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|g0]^(0)
            CALL MVRRp0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|g0]^(4)
            CALL MVRRd0g0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|g0]^(3)
            CALL MVRRd0g0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|g0]^(2)
            CALL MVRRd0g0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|g0]^(1)
            CALL MVRRd0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|g0]^(0)
            CALL MVRRd0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|g0]^(3)
            CALL MVRRf0g0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|g0]^(2)
            CALL MVRRf0g0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|g0]^(1)
            CALL MVRRf0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|g0]^(0)
            CALL MVRRf0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|g0]^(2)
            CALL MVRRg0g0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|g0]^(1)
            CALL MVRRg0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|g0]^(0)
            CALL MVRRg0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|g0]^(1)
            CALL MVRRh0g0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|g0]^(0)
            CALL MVRRh0g0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|h0]^(5)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,5,1),VRRS(1,1,6,1),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|h0]^(4)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|h0]^(3)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|h0]^(2)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|h0]^(1)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|h0]^(0)
            CALL MVRRs0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|h0]^(4)
            CALL MVRRp0h0(1,56,56,VRRS(1,1,4,1),VRRS(1,1,5,1),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|h0]^(3)
            CALL MVRRp0h0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|h0]^(2)
            CALL MVRRp0h0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|h0]^(1)
            CALL MVRRp0h0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|h0]^(0)
            CALL MVRRp0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|h0]^(3)
            CALL MVRRd0h0(1,56,56,VRRS(1,1,3,1),VRRS(1,1,4,1),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|h0]^(2)
            CALL MVRRd0h0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|h0]^(1)
            CALL MVRRd0h0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|h0]^(0)
            CALL MVRRd0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|h0]^(2)
            CALL MVRRf0h0(1,56,56,VRRS(1,1,2,1),VRRS(1,1,3,1),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|h0]^(1)
            CALL MVRRf0h0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|h0]^(0)
            CALL MVRRf0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|h0]^(1)
            CALL MVRRg0h0(1,56,56,VRRS(1,1,1,1),VRRS(1,1,2,1),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|h0]^(0)
            CALL MVRRg0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|h0]^(0)
            CALL MVRRh0h0(1,56,56,VRRS(1,1,0,1),VRRS(1,1,1,1),84,84,VRR(1,1,1))
            ENDIF
            IF(PBC%AutoW%I(2).EQ.1) THEN
            VRRS(1,1,0,2)=PQy*VRR(1,1,1)
            VRRS(1,1,1,2)=PQy*VRR(1,1,2)
            VRRS(1,1,2,2)=PQy*VRR(1,1,3)
            VRRS(1,1,3,2)=PQy*VRR(1,1,4)
            VRRS(1,1,4,2)=PQy*VRR(1,1,5)
            VRRS(1,1,5,2)=PQy*VRR(1,1,6)
            VRRS(1,1,6,2)=PQy*VRR(1,1,7)
            VRRS(1,1,7,2)=PQy*VRR(1,1,8)
            VRRS(1,1,8,2)=PQy*VRR(1,1,9)
            VRRS(1,1,9,2)=PQy*VRR(1,1,10)
            VRRS(1,1,10,2)=PQy*VRR(1,1,11)
            ! MIC-VRR: Generating [p0|s0]^(9)
            VRRS(2,1,9,2)=PAx*VRRS(1,1,9,2)+WPx*VRRS(1,1,10,2)
            VRRS(3,1,9,2)=PAy*VRRS(1,1,9,2)+WPy*VRRS(1,1,10,2)+r1x2Z*VRR(1,1,10)
            VRRS(4,1,9,2)=PAz*VRRS(1,1,9,2)+WPz*VRRS(1,1,10,2)
            ! MIC-VRR: Generating [p0|s0]^(8)
            VRRS(2,1,8,2)=PAx*VRRS(1,1,8,2)+WPx*VRRS(1,1,9,2)
            VRRS(3,1,8,2)=PAy*VRRS(1,1,8,2)+WPy*VRRS(1,1,9,2)+r1x2Z*VRR(1,1,9)
            VRRS(4,1,8,2)=PAz*VRRS(1,1,8,2)+WPz*VRRS(1,1,9,2)
            ! MIC-VRR: Generating [p0|s0]^(7)
            VRRS(2,1,7,2)=PAx*VRRS(1,1,7,2)+WPx*VRRS(1,1,8,2)
            VRRS(3,1,7,2)=PAy*VRRS(1,1,7,2)+WPy*VRRS(1,1,8,2)+r1x2Z*VRR(1,1,8)
            VRRS(4,1,7,2)=PAz*VRRS(1,1,7,2)+WPz*VRRS(1,1,8,2)
            ! MIC-VRR: Generating [p0|s0]^(6)
            VRRS(2,1,6,2)=PAx*VRRS(1,1,6,2)+WPx*VRRS(1,1,7,2)
            VRRS(3,1,6,2)=PAy*VRRS(1,1,6,2)+WPy*VRRS(1,1,7,2)+r1x2Z*VRR(1,1,7)
            VRRS(4,1,6,2)=PAz*VRRS(1,1,6,2)+WPz*VRRS(1,1,7,2)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,2)=PAx*VRRS(1,1,5,2)+WPx*VRRS(1,1,6,2)
            VRRS(3,1,5,2)=PAy*VRRS(1,1,5,2)+WPy*VRRS(1,1,6,2)+r1x2Z*VRR(1,1,6)
            VRRS(4,1,5,2)=PAz*VRRS(1,1,5,2)+WPz*VRRS(1,1,6,2)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,2)=PAx*VRRS(1,1,4,2)+WPx*VRRS(1,1,5,2)
            VRRS(3,1,4,2)=PAy*VRRS(1,1,4,2)+WPy*VRRS(1,1,5,2)+r1x2Z*VRR(1,1,5)
            VRRS(4,1,4,2)=PAz*VRRS(1,1,4,2)+WPz*VRRS(1,1,5,2)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,2)=PAx*VRRS(1,1,3,2)+WPx*VRRS(1,1,4,2)
            VRRS(3,1,3,2)=PAy*VRRS(1,1,3,2)+WPy*VRRS(1,1,4,2)+r1x2Z*VRR(1,1,4)
            VRRS(4,1,3,2)=PAz*VRRS(1,1,3,2)+WPz*VRRS(1,1,4,2)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,2)=PAx*VRRS(1,1,2,2)+WPx*VRRS(1,1,3,2)
            VRRS(3,1,2,2)=PAy*VRRS(1,1,2,2)+WPy*VRRS(1,1,3,2)+r1x2Z*VRR(1,1,3)
            VRRS(4,1,2,2)=PAz*VRRS(1,1,2,2)+WPz*VRRS(1,1,3,2)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,2)=PAx*VRRS(1,1,1,2)+WPx*VRRS(1,1,2,2)
            VRRS(3,1,1,2)=PAy*VRRS(1,1,1,2)+WPy*VRRS(1,1,2,2)+r1x2Z*VRR(1,1,2)
            VRRS(4,1,1,2)=PAz*VRRS(1,1,1,2)+WPz*VRRS(1,1,2,2)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,2)=PAx*VRRS(1,1,0,2)+WPx*VRRS(1,1,1,2)
            VRRS(3,1,0,2)=PAy*VRRS(1,1,0,2)+WPy*VRRS(1,1,1,2)+r1x2Z*VRR(1,1,1)
            VRRS(4,1,0,2)=PAz*VRRS(1,1,0,2)+WPz*VRRS(1,1,1,2)
            ! MIC-VRR: Generating [d0|s0]^(8)
            VRRS( 5,1,8,2)=PAx*VRRS(2,1,8,2)+r1x2Z*(VRRS(1,1,8,2)-ExZpE*VRRS(1,1,9,2))+WPx*VRRS(2,1,9,2)
            VRRS( 6,1,8,2)=PAx*VRRS(3,1,8,2)+WPx*VRRS(3,1,9,2)
            VRRS( 7,1,8,2)=PAy*VRRS(3,1,8,2)+r1x2Z*(VRRS(1,1,8,2)-ExZpE*VRRS(1,1,9,2))+WPy*VRRS(3,1,9,2)+r1x2Z*VRR(3,1,9)
            VRRS( 8,1,8,2)=PAx*VRRS(4,1,8,2)+WPx*VRRS(4,1,9,2)
            VRRS( 9,1,8,2)=PAy*VRRS(4,1,8,2)+WPy*VRRS(4,1,9,2)+r1x2Z*VRR(4,1,9)
            VRRS(10,1,8,2)=PAz*VRRS(4,1,8,2)+r1x2Z*(VRRS(1,1,8,2)-ExZpE*VRRS(1,1,9,2))+WPz*VRRS(4,1,9,2)
            ! MIC-VRR: Generating [d0|s0]^(7)
            VRRS( 5,1,7,2)=PAx*VRRS(2,1,7,2)+r1x2Z*(VRRS(1,1,7,2)-ExZpE*VRRS(1,1,8,2))+WPx*VRRS(2,1,8,2)
            VRRS( 6,1,7,2)=PAx*VRRS(3,1,7,2)+WPx*VRRS(3,1,8,2)
            VRRS( 7,1,7,2)=PAy*VRRS(3,1,7,2)+r1x2Z*(VRRS(1,1,7,2)-ExZpE*VRRS(1,1,8,2))+WPy*VRRS(3,1,8,2)+r1x2Z*VRR(3,1,8)
            VRRS( 8,1,7,2)=PAx*VRRS(4,1,7,2)+WPx*VRRS(4,1,8,2)
            VRRS( 9,1,7,2)=PAy*VRRS(4,1,7,2)+WPy*VRRS(4,1,8,2)+r1x2Z*VRR(4,1,8)
            VRRS(10,1,7,2)=PAz*VRRS(4,1,7,2)+r1x2Z*(VRRS(1,1,7,2)-ExZpE*VRRS(1,1,8,2))+WPz*VRRS(4,1,8,2)
            ! MIC-VRR: Generating [d0|s0]^(6)
            VRRS( 5,1,6,2)=PAx*VRRS(2,1,6,2)+r1x2Z*(VRRS(1,1,6,2)-ExZpE*VRRS(1,1,7,2))+WPx*VRRS(2,1,7,2)
            VRRS( 6,1,6,2)=PAx*VRRS(3,1,6,2)+WPx*VRRS(3,1,7,2)
            VRRS( 7,1,6,2)=PAy*VRRS(3,1,6,2)+r1x2Z*(VRRS(1,1,6,2)-ExZpE*VRRS(1,1,7,2))+WPy*VRRS(3,1,7,2)+r1x2Z*VRR(3,1,7)
            VRRS( 8,1,6,2)=PAx*VRRS(4,1,6,2)+WPx*VRRS(4,1,7,2)
            VRRS( 9,1,6,2)=PAy*VRRS(4,1,6,2)+WPy*VRRS(4,1,7,2)+r1x2Z*VRR(4,1,7)
            VRRS(10,1,6,2)=PAz*VRRS(4,1,6,2)+r1x2Z*(VRRS(1,1,6,2)-ExZpE*VRRS(1,1,7,2))+WPz*VRRS(4,1,7,2)
            ! MIC-VRR: Generating [d0|s0]^(5)
            VRRS( 5,1,5,2)=PAx*VRRS(2,1,5,2)+r1x2Z*(VRRS(1,1,5,2)-ExZpE*VRRS(1,1,6,2))+WPx*VRRS(2,1,6,2)
            VRRS( 6,1,5,2)=PAx*VRRS(3,1,5,2)+WPx*VRRS(3,1,6,2)
            VRRS( 7,1,5,2)=PAy*VRRS(3,1,5,2)+r1x2Z*(VRRS(1,1,5,2)-ExZpE*VRRS(1,1,6,2))+WPy*VRRS(3,1,6,2)+r1x2Z*VRR(3,1,6)
            VRRS( 8,1,5,2)=PAx*VRRS(4,1,5,2)+WPx*VRRS(4,1,6,2)
            VRRS( 9,1,5,2)=PAy*VRRS(4,1,5,2)+WPy*VRRS(4,1,6,2)+r1x2Z*VRR(4,1,6)
            VRRS(10,1,5,2)=PAz*VRRS(4,1,5,2)+r1x2Z*(VRRS(1,1,5,2)-ExZpE*VRRS(1,1,6,2))+WPz*VRRS(4,1,6,2)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,2)=PAx*VRRS(2,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPx*VRRS(2,1,5,2)
            VRRS( 6,1,4,2)=PAx*VRRS(3,1,4,2)+WPx*VRRS(3,1,5,2)
            VRRS( 7,1,4,2)=PAy*VRRS(3,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPy*VRRS(3,1,5,2)+r1x2Z*VRR(3,1,5)
            VRRS( 8,1,4,2)=PAx*VRRS(4,1,4,2)+WPx*VRRS(4,1,5,2)
            VRRS( 9,1,4,2)=PAy*VRRS(4,1,4,2)+WPy*VRRS(4,1,5,2)+r1x2Z*VRR(4,1,5)
            VRRS(10,1,4,2)=PAz*VRRS(4,1,4,2)+r1x2Z*(VRRS(1,1,4,2)-ExZpE*VRRS(1,1,5,2))+WPz*VRRS(4,1,5,2)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,2)=PAx*VRRS(2,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPx*VRRS(2,1,4,2)
            VRRS( 6,1,3,2)=PAx*VRRS(3,1,3,2)+WPx*VRRS(3,1,4,2)
            VRRS( 7,1,3,2)=PAy*VRRS(3,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPy*VRRS(3,1,4,2)+r1x2Z*VRR(3,1,4)
            VRRS( 8,1,3,2)=PAx*VRRS(4,1,3,2)+WPx*VRRS(4,1,4,2)
            VRRS( 9,1,3,2)=PAy*VRRS(4,1,3,2)+WPy*VRRS(4,1,4,2)+r1x2Z*VRR(4,1,4)
            VRRS(10,1,3,2)=PAz*VRRS(4,1,3,2)+r1x2Z*(VRRS(1,1,3,2)-ExZpE*VRRS(1,1,4,2))+WPz*VRRS(4,1,4,2)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,2)=PAx*VRRS(2,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPx*VRRS(2,1,3,2)
            VRRS( 6,1,2,2)=PAx*VRRS(3,1,2,2)+WPx*VRRS(3,1,3,2)
            VRRS( 7,1,2,2)=PAy*VRRS(3,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPy*VRRS(3,1,3,2)+r1x2Z*VRR(3,1,3)
            VRRS( 8,1,2,2)=PAx*VRRS(4,1,2,2)+WPx*VRRS(4,1,3,2)
            VRRS( 9,1,2,2)=PAy*VRRS(4,1,2,2)+WPy*VRRS(4,1,3,2)+r1x2Z*VRR(4,1,3)
            VRRS(10,1,2,2)=PAz*VRRS(4,1,2,2)+r1x2Z*(VRRS(1,1,2,2)-ExZpE*VRRS(1,1,3,2))+WPz*VRRS(4,1,3,2)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,2)=PAx*VRRS(2,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPx*VRRS(2,1,2,2)
            VRRS( 6,1,1,2)=PAx*VRRS(3,1,1,2)+WPx*VRRS(3,1,2,2)
            VRRS( 7,1,1,2)=PAy*VRRS(3,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPy*VRRS(3,1,2,2)+r1x2Z*VRR(3,1,2)
            VRRS( 8,1,1,2)=PAx*VRRS(4,1,1,2)+WPx*VRRS(4,1,2,2)
            VRRS( 9,1,1,2)=PAy*VRRS(4,1,1,2)+WPy*VRRS(4,1,2,2)+r1x2Z*VRR(4,1,2)
            VRRS(10,1,1,2)=PAz*VRRS(4,1,1,2)+r1x2Z*(VRRS(1,1,1,2)-ExZpE*VRRS(1,1,2,2))+WPz*VRRS(4,1,2,2)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,2)=PAx*VRRS(2,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPx*VRRS(2,1,1,2)
            VRRS( 6,1,0,2)=PAx*VRRS(3,1,0,2)+WPx*VRRS(3,1,1,2)
            VRRS( 7,1,0,2)=PAy*VRRS(3,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPy*VRRS(3,1,1,2)+r1x2Z*VRR(3,1,1)
            VRRS( 8,1,0,2)=PAx*VRRS(4,1,0,2)+WPx*VRRS(4,1,1,2)
            VRRS( 9,1,0,2)=PAy*VRRS(4,1,0,2)+WPy*VRRS(4,1,1,2)+r1x2Z*VRR(4,1,1)
            VRRS(10,1,0,2)=PAz*VRRS(4,1,0,2)+r1x2Z*(VRRS(1,1,0,2)-ExZpE*VRRS(1,1,1,2))+WPz*VRRS(4,1,1,2)
            ! MIC-VRR: Generating [f0|s0]^(7)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,7,2),VRRS(1,1,8,2),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [f0|s0]^(6)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|s0]^(5)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|s0]^(4)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(6)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [g0|s0]^(5)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|s0]^(4)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|s0]^(3)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(5)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [h0|s0]^(4)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|s0]^(3)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|s0]^(2)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|p0]^(9)
            VRRS(1,2,9,2)=QCx*VRRS(1,1,9,2)+WQx*VRRS(1,1,10,2)
            VRRS(1,3,9,2)=QCy*VRRS(1,1,9,2)+WQy*VRRS(1,1,10,2)-r1x2E*VRR(1,1,10)
            VRRS(1,4,9,2)=QCz*VRRS(1,1,9,2)+WQz*VRRS(1,1,10,2)
            ! MIC-VRR: Generating [s0|p0]^(8)
            VRRS(1,2,8,2)=QCx*VRRS(1,1,8,2)+WQx*VRRS(1,1,9,2)
            VRRS(1,3,8,2)=QCy*VRRS(1,1,8,2)+WQy*VRRS(1,1,9,2)-r1x2E*VRR(1,1,9)
            VRRS(1,4,8,2)=QCz*VRRS(1,1,8,2)+WQz*VRRS(1,1,9,2)
            ! MIC-VRR: Generating [s0|p0]^(7)
            VRRS(1,2,7,2)=QCx*VRRS(1,1,7,2)+WQx*VRRS(1,1,8,2)
            VRRS(1,3,7,2)=QCy*VRRS(1,1,7,2)+WQy*VRRS(1,1,8,2)-r1x2E*VRR(1,1,8)
            VRRS(1,4,7,2)=QCz*VRRS(1,1,7,2)+WQz*VRRS(1,1,8,2)
            ! MIC-VRR: Generating [s0|p0]^(6)
            VRRS(1,2,6,2)=QCx*VRRS(1,1,6,2)+WQx*VRRS(1,1,7,2)
            VRRS(1,3,6,2)=QCy*VRRS(1,1,6,2)+WQy*VRRS(1,1,7,2)-r1x2E*VRR(1,1,7)
            VRRS(1,4,6,2)=QCz*VRRS(1,1,6,2)+WQz*VRRS(1,1,7,2)
            ! MIC-VRR: Generating [s0|p0]^(5)
            VRRS(1,2,5,2)=QCx*VRRS(1,1,5,2)+WQx*VRRS(1,1,6,2)
            VRRS(1,3,5,2)=QCy*VRRS(1,1,5,2)+WQy*VRRS(1,1,6,2)-r1x2E*VRR(1,1,6)
            VRRS(1,4,5,2)=QCz*VRRS(1,1,5,2)+WQz*VRRS(1,1,6,2)
            ! MIC-VRR: Generating [s0|p0]^(4)
            VRRS(1,2,4,2)=QCx*VRRS(1,1,4,2)+WQx*VRRS(1,1,5,2)
            VRRS(1,3,4,2)=QCy*VRRS(1,1,4,2)+WQy*VRRS(1,1,5,2)-r1x2E*VRR(1,1,5)
            VRRS(1,4,4,2)=QCz*VRRS(1,1,4,2)+WQz*VRRS(1,1,5,2)
            ! MIC-VRR: Generating [s0|p0]^(3)
            VRRS(1,2,3,2)=QCx*VRRS(1,1,3,2)+WQx*VRRS(1,1,4,2)
            VRRS(1,3,3,2)=QCy*VRRS(1,1,3,2)+WQy*VRRS(1,1,4,2)-r1x2E*VRR(1,1,4)
            VRRS(1,4,3,2)=QCz*VRRS(1,1,3,2)+WQz*VRRS(1,1,4,2)
            ! MIC-VRR: Generating [s0|p0]^(2)
            VRRS(1,2,2,2)=QCx*VRRS(1,1,2,2)+WQx*VRRS(1,1,3,2)
            VRRS(1,3,2,2)=QCy*VRRS(1,1,2,2)+WQy*VRRS(1,1,3,2)-r1x2E*VRR(1,1,3)
            VRRS(1,4,2,2)=QCz*VRRS(1,1,2,2)+WQz*VRRS(1,1,3,2)
            ! MIC-VRR: Generating [s0|p0]^(1)
            VRRS(1,2,1,2)=QCx*VRRS(1,1,1,2)+WQx*VRRS(1,1,2,2)
            VRRS(1,3,1,2)=QCy*VRRS(1,1,1,2)+WQy*VRRS(1,1,2,2)-r1x2E*VRR(1,1,2)
            VRRS(1,4,1,2)=QCz*VRRS(1,1,1,2)+WQz*VRRS(1,1,2,2)
            ! MIC-VRR: Generating [s0|p0]^(0)
            VRRS(1,2,0,2)=QCx*VRRS(1,1,0,2)+WQx*VRRS(1,1,1,2)
            VRRS(1,3,0,2)=QCy*VRRS(1,1,0,2)+WQy*VRRS(1,1,1,2)-r1x2E*VRR(1,1,1)
            VRRS(1,4,0,2)=QCz*VRRS(1,1,0,2)+WQz*VRRS(1,1,1,2)
            ! MIC-VRR: Generating [p0|p0]^(8)
            VRRS(2,2,8,2)=QCx*VRRS(2,1,8,2)+WQx*VRRS(2,1,9,2)+HfxZpE*VRRS(1,1,9,2)
            VRRS(2,3,8,2)=QCy*VRRS(2,1,8,2)+WQy*VRRS(2,1,9,2)-r1x2E *VRR(2,1,9)
            VRRS(2,4,8,2)=QCz*VRRS(2,1,8,2)+WQz*VRRS(2,1,9,2)
            VRRS(3,2,8,2)=QCx*VRRS(3,1,8,2)+WQx*VRRS(3,1,9,2)
            VRRS(3,3,8,2)=QCy*VRRS(3,1,8,2)+WQy*VRRS(3,1,9,2)+HfxZpE*VRRS(1,1,9,2)-r1x2E *VRR(3,1,9)
            VRRS(3,4,8,2)=QCz*VRRS(3,1,8,2)+WQz*VRRS(3,1,9,2)
            VRRS(4,2,8,2)=QCx*VRRS(4,1,8,2)+WQx*VRRS(4,1,9,2)
            VRRS(4,3,8,2)=QCy*VRRS(4,1,8,2)+WQy*VRRS(4,1,9,2)-r1x2E *VRR(4,1,9)
            VRRS(4,4,8,2)=QCz*VRRS(4,1,8,2)+WQz*VRRS(4,1,9,2)+HfxZpE*VRRS(1,1,9,2)
            ! MIC-VRR: Generating [p0|p0]^(7)
            VRRS(2,2,7,2)=QCx*VRRS(2,1,7,2)+WQx*VRRS(2,1,8,2)+HfxZpE*VRRS(1,1,8,2)
            VRRS(2,3,7,2)=QCy*VRRS(2,1,7,2)+WQy*VRRS(2,1,8,2)-r1x2E *VRR(2,1,8)
            VRRS(2,4,7,2)=QCz*VRRS(2,1,7,2)+WQz*VRRS(2,1,8,2)
            VRRS(3,2,7,2)=QCx*VRRS(3,1,7,2)+WQx*VRRS(3,1,8,2)
            VRRS(3,3,7,2)=QCy*VRRS(3,1,7,2)+WQy*VRRS(3,1,8,2)+HfxZpE*VRRS(1,1,8,2)-r1x2E *VRR(3,1,8)
            VRRS(3,4,7,2)=QCz*VRRS(3,1,7,2)+WQz*VRRS(3,1,8,2)
            VRRS(4,2,7,2)=QCx*VRRS(4,1,7,2)+WQx*VRRS(4,1,8,2)
            VRRS(4,3,7,2)=QCy*VRRS(4,1,7,2)+WQy*VRRS(4,1,8,2)-r1x2E *VRR(4,1,8)
            VRRS(4,4,7,2)=QCz*VRRS(4,1,7,2)+WQz*VRRS(4,1,8,2)+HfxZpE*VRRS(1,1,8,2)
            ! MIC-VRR: Generating [p0|p0]^(6)
            VRRS(2,2,6,2)=QCx*VRRS(2,1,6,2)+WQx*VRRS(2,1,7,2)+HfxZpE*VRRS(1,1,7,2)
            VRRS(2,3,6,2)=QCy*VRRS(2,1,6,2)+WQy*VRRS(2,1,7,2)-r1x2E *VRR(2,1,7)
            VRRS(2,4,6,2)=QCz*VRRS(2,1,6,2)+WQz*VRRS(2,1,7,2)
            VRRS(3,2,6,2)=QCx*VRRS(3,1,6,2)+WQx*VRRS(3,1,7,2)
            VRRS(3,3,6,2)=QCy*VRRS(3,1,6,2)+WQy*VRRS(3,1,7,2)+HfxZpE*VRRS(1,1,7,2)-r1x2E *VRR(3,1,7)
            VRRS(3,4,6,2)=QCz*VRRS(3,1,6,2)+WQz*VRRS(3,1,7,2)
            VRRS(4,2,6,2)=QCx*VRRS(4,1,6,2)+WQx*VRRS(4,1,7,2)
            VRRS(4,3,6,2)=QCy*VRRS(4,1,6,2)+WQy*VRRS(4,1,7,2)-r1x2E *VRR(4,1,7)
            VRRS(4,4,6,2)=QCz*VRRS(4,1,6,2)+WQz*VRRS(4,1,7,2)+HfxZpE*VRRS(1,1,7,2)
            ! MIC-VRR: Generating [p0|p0]^(5)
            VRRS(2,2,5,2)=QCx*VRRS(2,1,5,2)+WQx*VRRS(2,1,6,2)+HfxZpE*VRRS(1,1,6,2)
            VRRS(2,3,5,2)=QCy*VRRS(2,1,5,2)+WQy*VRRS(2,1,6,2)-r1x2E *VRR(2,1,6)
            VRRS(2,4,5,2)=QCz*VRRS(2,1,5,2)+WQz*VRRS(2,1,6,2)
            VRRS(3,2,5,2)=QCx*VRRS(3,1,5,2)+WQx*VRRS(3,1,6,2)
            VRRS(3,3,5,2)=QCy*VRRS(3,1,5,2)+WQy*VRRS(3,1,6,2)+HfxZpE*VRRS(1,1,6,2)-r1x2E *VRR(3,1,6)
            VRRS(3,4,5,2)=QCz*VRRS(3,1,5,2)+WQz*VRRS(3,1,6,2)
            VRRS(4,2,5,2)=QCx*VRRS(4,1,5,2)+WQx*VRRS(4,1,6,2)
            VRRS(4,3,5,2)=QCy*VRRS(4,1,5,2)+WQy*VRRS(4,1,6,2)-r1x2E *VRR(4,1,6)
            VRRS(4,4,5,2)=QCz*VRRS(4,1,5,2)+WQz*VRRS(4,1,6,2)+HfxZpE*VRRS(1,1,6,2)
            ! MIC-VRR: Generating [p0|p0]^(4)
            VRRS(2,2,4,2)=QCx*VRRS(2,1,4,2)+WQx*VRRS(2,1,5,2)+HfxZpE*VRRS(1,1,5,2)
            VRRS(2,3,4,2)=QCy*VRRS(2,1,4,2)+WQy*VRRS(2,1,5,2)-r1x2E *VRR(2,1,5)
            VRRS(2,4,4,2)=QCz*VRRS(2,1,4,2)+WQz*VRRS(2,1,5,2)
            VRRS(3,2,4,2)=QCx*VRRS(3,1,4,2)+WQx*VRRS(3,1,5,2)
            VRRS(3,3,4,2)=QCy*VRRS(3,1,4,2)+WQy*VRRS(3,1,5,2)+HfxZpE*VRRS(1,1,5,2)-r1x2E *VRR(3,1,5)
            VRRS(3,4,4,2)=QCz*VRRS(3,1,4,2)+WQz*VRRS(3,1,5,2)
            VRRS(4,2,4,2)=QCx*VRRS(4,1,4,2)+WQx*VRRS(4,1,5,2)
            VRRS(4,3,4,2)=QCy*VRRS(4,1,4,2)+WQy*VRRS(4,1,5,2)-r1x2E *VRR(4,1,5)
            VRRS(4,4,4,2)=QCz*VRRS(4,1,4,2)+WQz*VRRS(4,1,5,2)+HfxZpE*VRRS(1,1,5,2)
            ! MIC-VRR: Generating [p0|p0]^(3)
            VRRS(2,2,3,2)=QCx*VRRS(2,1,3,2)+WQx*VRRS(2,1,4,2)+HfxZpE*VRRS(1,1,4,2)
            VRRS(2,3,3,2)=QCy*VRRS(2,1,3,2)+WQy*VRRS(2,1,4,2)-r1x2E *VRR(2,1,4)
            VRRS(2,4,3,2)=QCz*VRRS(2,1,3,2)+WQz*VRRS(2,1,4,2)
            VRRS(3,2,3,2)=QCx*VRRS(3,1,3,2)+WQx*VRRS(3,1,4,2)
            VRRS(3,3,3,2)=QCy*VRRS(3,1,3,2)+WQy*VRRS(3,1,4,2)+HfxZpE*VRRS(1,1,4,2)-r1x2E *VRR(3,1,4)
            VRRS(3,4,3,2)=QCz*VRRS(3,1,3,2)+WQz*VRRS(3,1,4,2)
            VRRS(4,2,3,2)=QCx*VRRS(4,1,3,2)+WQx*VRRS(4,1,4,2)
            VRRS(4,3,3,2)=QCy*VRRS(4,1,3,2)+WQy*VRRS(4,1,4,2)-r1x2E *VRR(4,1,4)
            VRRS(4,4,3,2)=QCz*VRRS(4,1,3,2)+WQz*VRRS(4,1,4,2)+HfxZpE*VRRS(1,1,4,2)
            ! MIC-VRR: Generating [p0|p0]^(2)
            VRRS(2,2,2,2)=QCx*VRRS(2,1,2,2)+WQx*VRRS(2,1,3,2)+HfxZpE*VRRS(1,1,3,2)
            VRRS(2,3,2,2)=QCy*VRRS(2,1,2,2)+WQy*VRRS(2,1,3,2)-r1x2E *VRR(2,1,3)
            VRRS(2,4,2,2)=QCz*VRRS(2,1,2,2)+WQz*VRRS(2,1,3,2)
            VRRS(3,2,2,2)=QCx*VRRS(3,1,2,2)+WQx*VRRS(3,1,3,2)
            VRRS(3,3,2,2)=QCy*VRRS(3,1,2,2)+WQy*VRRS(3,1,3,2)+HfxZpE*VRRS(1,1,3,2)-r1x2E *VRR(3,1,3)
            VRRS(3,4,2,2)=QCz*VRRS(3,1,2,2)+WQz*VRRS(3,1,3,2)
            VRRS(4,2,2,2)=QCx*VRRS(4,1,2,2)+WQx*VRRS(4,1,3,2)
            VRRS(4,3,2,2)=QCy*VRRS(4,1,2,2)+WQy*VRRS(4,1,3,2)-r1x2E *VRR(4,1,3)
            VRRS(4,4,2,2)=QCz*VRRS(4,1,2,2)+WQz*VRRS(4,1,3,2)+HfxZpE*VRRS(1,1,3,2)
            ! MIC-VRR: Generating [p0|p0]^(1)
            VRRS(2,2,1,2)=QCx*VRRS(2,1,1,2)+WQx*VRRS(2,1,2,2)+HfxZpE*VRRS(1,1,2,2)
            VRRS(2,3,1,2)=QCy*VRRS(2,1,1,2)+WQy*VRRS(2,1,2,2)-r1x2E *VRR(2,1,2)
            VRRS(2,4,1,2)=QCz*VRRS(2,1,1,2)+WQz*VRRS(2,1,2,2)
            VRRS(3,2,1,2)=QCx*VRRS(3,1,1,2)+WQx*VRRS(3,1,2,2)
            VRRS(3,3,1,2)=QCy*VRRS(3,1,1,2)+WQy*VRRS(3,1,2,2)+HfxZpE*VRRS(1,1,2,2)-r1x2E *VRR(3,1,2)
            VRRS(3,4,1,2)=QCz*VRRS(3,1,1,2)+WQz*VRRS(3,1,2,2)
            VRRS(4,2,1,2)=QCx*VRRS(4,1,1,2)+WQx*VRRS(4,1,2,2)
            VRRS(4,3,1,2)=QCy*VRRS(4,1,1,2)+WQy*VRRS(4,1,2,2)-r1x2E *VRR(4,1,2)
            VRRS(4,4,1,2)=QCz*VRRS(4,1,1,2)+WQz*VRRS(4,1,2,2)+HfxZpE*VRRS(1,1,2,2)
            ! MIC-VRR: Generating [p0|p0]^(0)
            VRRS(2,2,0,2)=QCx*VRRS(2,1,0,2)+WQx*VRRS(2,1,1,2)+HfxZpE*VRRS(1,1,1,2)
            VRRS(2,3,0,2)=QCy*VRRS(2,1,0,2)+WQy*VRRS(2,1,1,2)-r1x2E *VRR(2,1,1)
            VRRS(2,4,0,2)=QCz*VRRS(2,1,0,2)+WQz*VRRS(2,1,1,2)
            VRRS(3,2,0,2)=QCx*VRRS(3,1,0,2)+WQx*VRRS(3,1,1,2)
            VRRS(3,3,0,2)=QCy*VRRS(3,1,0,2)+WQy*VRRS(3,1,1,2)+HfxZpE*VRRS(1,1,1,2)-r1x2E *VRR(3,1,1)
            VRRS(3,4,0,2)=QCz*VRRS(3,1,0,2)+WQz*VRRS(3,1,1,2)
            VRRS(4,2,0,2)=QCx*VRRS(4,1,0,2)+WQx*VRRS(4,1,1,2)
            VRRS(4,3,0,2)=QCy*VRRS(4,1,0,2)+WQy*VRRS(4,1,1,2)-r1x2E *VRR(4,1,1)
            VRRS(4,4,0,2)=QCz*VRRS(4,1,0,2)+WQz*VRRS(4,1,1,2)+HfxZpE*VRRS(1,1,1,2)
            ! MIC-VRR: Generating [d0|p0]^(7)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,7,2),VRRS(1,1,8,2),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [d0|p0]^(6)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|p0]^(5)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|p0]^(4)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|p0]^(3)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|p0]^(2)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|p0]^(1)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|p0]^(0)
            CALL MVRRd0p0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|p0]^(6)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|p0]^(5)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|p0]^(4)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|p0]^(3)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|p0]^(2)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|p0]^(1)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|p0]^(0)
            CALL MVRRf0p0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|p0]^(5)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|p0]^(4)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|p0]^(3)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|p0]^(2)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|p0]^(1)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|p0]^(0)
            CALL MVRRg0p0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|p0]^(4)
            CALL MVRRh0p0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|p0]^(3)
            CALL MVRRh0p0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|p0]^(2)
            CALL MVRRh0p0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|p0]^(1)
            CALL MVRRh0p0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|p0]^(0)
            CALL MVRRh0p0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|d0]^(8)
            VRRS(1, 5,8,2)=QCx*VRRS(1,2,8,2)+r1x2E*(VRRS(1,1,8,2)-ZxZpE*VRRS(1,1,9,2))+WQx*VRRS(1,2,9,2)
            VRRS(1, 6,8,2)=QCx*VRRS(1,3,8,2)+WQx*VRRS(1,3,9,2)
            VRRS(1, 7,8,2)=QCy*VRRS(1,3,8,2)+r1x2E*(VRRS(1,1,8,2)-ZxZpE*VRRS(1,1,9,2))+WQy*VRRS(1,3,9,2)-r1x2E*VRR(1,3,9)
            VRRS(1, 8,8,2)=QCx*VRRS(1,4,8,2)+WQx*VRRS(1,4,9,2)
            VRRS(1, 9,8,2)=QCy*VRRS(1,4,8,2)+WQy*VRRS(1,4,9,2)-r1x2E*VRR(1,4,9)
            VRRS(1,10,8,2)=QCz*VRRS(1,4,8,2)+r1x2E*(VRRS(1,1,8,2)-ZxZpE*VRRS(1,1,9,2))+WQz*VRRS(1,4,9,2)
            ! MIC-VRR: Generating [s0|d0]^(7)
            VRRS(1, 5,7,2)=QCx*VRRS(1,2,7,2)+r1x2E*(VRRS(1,1,7,2)-ZxZpE*VRRS(1,1,8,2))+WQx*VRRS(1,2,8,2)
            VRRS(1, 6,7,2)=QCx*VRRS(1,3,7,2)+WQx*VRRS(1,3,8,2)
            VRRS(1, 7,7,2)=QCy*VRRS(1,3,7,2)+r1x2E*(VRRS(1,1,7,2)-ZxZpE*VRRS(1,1,8,2))+WQy*VRRS(1,3,8,2)-r1x2E*VRR(1,3,8)
            VRRS(1, 8,7,2)=QCx*VRRS(1,4,7,2)+WQx*VRRS(1,4,8,2)
            VRRS(1, 9,7,2)=QCy*VRRS(1,4,7,2)+WQy*VRRS(1,4,8,2)-r1x2E*VRR(1,4,8)
            VRRS(1,10,7,2)=QCz*VRRS(1,4,7,2)+r1x2E*(VRRS(1,1,7,2)-ZxZpE*VRRS(1,1,8,2))+WQz*VRRS(1,4,8,2)
            ! MIC-VRR: Generating [s0|d0]^(6)
            VRRS(1, 5,6,2)=QCx*VRRS(1,2,6,2)+r1x2E*(VRRS(1,1,6,2)-ZxZpE*VRRS(1,1,7,2))+WQx*VRRS(1,2,7,2)
            VRRS(1, 6,6,2)=QCx*VRRS(1,3,6,2)+WQx*VRRS(1,3,7,2)
            VRRS(1, 7,6,2)=QCy*VRRS(1,3,6,2)+r1x2E*(VRRS(1,1,6,2)-ZxZpE*VRRS(1,1,7,2))+WQy*VRRS(1,3,7,2)-r1x2E*VRR(1,3,7)
            VRRS(1, 8,6,2)=QCx*VRRS(1,4,6,2)+WQx*VRRS(1,4,7,2)
            VRRS(1, 9,6,2)=QCy*VRRS(1,4,6,2)+WQy*VRRS(1,4,7,2)-r1x2E*VRR(1,4,7)
            VRRS(1,10,6,2)=QCz*VRRS(1,4,6,2)+r1x2E*(VRRS(1,1,6,2)-ZxZpE*VRRS(1,1,7,2))+WQz*VRRS(1,4,7,2)
            ! MIC-VRR: Generating [s0|d0]^(5)
            VRRS(1, 5,5,2)=QCx*VRRS(1,2,5,2)+r1x2E*(VRRS(1,1,5,2)-ZxZpE*VRRS(1,1,6,2))+WQx*VRRS(1,2,6,2)
            VRRS(1, 6,5,2)=QCx*VRRS(1,3,5,2)+WQx*VRRS(1,3,6,2)
            VRRS(1, 7,5,2)=QCy*VRRS(1,3,5,2)+r1x2E*(VRRS(1,1,5,2)-ZxZpE*VRRS(1,1,6,2))+WQy*VRRS(1,3,6,2)-r1x2E*VRR(1,3,6)
            VRRS(1, 8,5,2)=QCx*VRRS(1,4,5,2)+WQx*VRRS(1,4,6,2)
            VRRS(1, 9,5,2)=QCy*VRRS(1,4,5,2)+WQy*VRRS(1,4,6,2)-r1x2E*VRR(1,4,6)
            VRRS(1,10,5,2)=QCz*VRRS(1,4,5,2)+r1x2E*(VRRS(1,1,5,2)-ZxZpE*VRRS(1,1,6,2))+WQz*VRRS(1,4,6,2)
            ! MIC-VRR: Generating [s0|d0]^(4)
            VRRS(1, 5,4,2)=QCx*VRRS(1,2,4,2)+r1x2E*(VRRS(1,1,4,2)-ZxZpE*VRRS(1,1,5,2))+WQx*VRRS(1,2,5,2)
            VRRS(1, 6,4,2)=QCx*VRRS(1,3,4,2)+WQx*VRRS(1,3,5,2)
            VRRS(1, 7,4,2)=QCy*VRRS(1,3,4,2)+r1x2E*(VRRS(1,1,4,2)-ZxZpE*VRRS(1,1,5,2))+WQy*VRRS(1,3,5,2)-r1x2E*VRR(1,3,5)
            VRRS(1, 8,4,2)=QCx*VRRS(1,4,4,2)+WQx*VRRS(1,4,5,2)
            VRRS(1, 9,4,2)=QCy*VRRS(1,4,4,2)+WQy*VRRS(1,4,5,2)-r1x2E*VRR(1,4,5)
            VRRS(1,10,4,2)=QCz*VRRS(1,4,4,2)+r1x2E*(VRRS(1,1,4,2)-ZxZpE*VRRS(1,1,5,2))+WQz*VRRS(1,4,5,2)
            ! MIC-VRR: Generating [s0|d0]^(3)
            VRRS(1, 5,3,2)=QCx*VRRS(1,2,3,2)+r1x2E*(VRRS(1,1,3,2)-ZxZpE*VRRS(1,1,4,2))+WQx*VRRS(1,2,4,2)
            VRRS(1, 6,3,2)=QCx*VRRS(1,3,3,2)+WQx*VRRS(1,3,4,2)
            VRRS(1, 7,3,2)=QCy*VRRS(1,3,3,2)+r1x2E*(VRRS(1,1,3,2)-ZxZpE*VRRS(1,1,4,2))+WQy*VRRS(1,3,4,2)-r1x2E*VRR(1,3,4)
            VRRS(1, 8,3,2)=QCx*VRRS(1,4,3,2)+WQx*VRRS(1,4,4,2)
            VRRS(1, 9,3,2)=QCy*VRRS(1,4,3,2)+WQy*VRRS(1,4,4,2)-r1x2E*VRR(1,4,4)
            VRRS(1,10,3,2)=QCz*VRRS(1,4,3,2)+r1x2E*(VRRS(1,1,3,2)-ZxZpE*VRRS(1,1,4,2))+WQz*VRRS(1,4,4,2)
            ! MIC-VRR: Generating [s0|d0]^(2)
            VRRS(1, 5,2,2)=QCx*VRRS(1,2,2,2)+r1x2E*(VRRS(1,1,2,2)-ZxZpE*VRRS(1,1,3,2))+WQx*VRRS(1,2,3,2)
            VRRS(1, 6,2,2)=QCx*VRRS(1,3,2,2)+WQx*VRRS(1,3,3,2)
            VRRS(1, 7,2,2)=QCy*VRRS(1,3,2,2)+r1x2E*(VRRS(1,1,2,2)-ZxZpE*VRRS(1,1,3,2))+WQy*VRRS(1,3,3,2)-r1x2E*VRR(1,3,3)
            VRRS(1, 8,2,2)=QCx*VRRS(1,4,2,2)+WQx*VRRS(1,4,3,2)
            VRRS(1, 9,2,2)=QCy*VRRS(1,4,2,2)+WQy*VRRS(1,4,3,2)-r1x2E*VRR(1,4,3)
            VRRS(1,10,2,2)=QCz*VRRS(1,4,2,2)+r1x2E*(VRRS(1,1,2,2)-ZxZpE*VRRS(1,1,3,2))+WQz*VRRS(1,4,3,2)
            ! MIC-VRR: Generating [s0|d0]^(1)
            VRRS(1, 5,1,2)=QCx*VRRS(1,2,1,2)+r1x2E*(VRRS(1,1,1,2)-ZxZpE*VRRS(1,1,2,2))+WQx*VRRS(1,2,2,2)
            VRRS(1, 6,1,2)=QCx*VRRS(1,3,1,2)+WQx*VRRS(1,3,2,2)
            VRRS(1, 7,1,2)=QCy*VRRS(1,3,1,2)+r1x2E*(VRRS(1,1,1,2)-ZxZpE*VRRS(1,1,2,2))+WQy*VRRS(1,3,2,2)-r1x2E*VRR(1,3,2)
            VRRS(1, 8,1,2)=QCx*VRRS(1,4,1,2)+WQx*VRRS(1,4,2,2)
            VRRS(1, 9,1,2)=QCy*VRRS(1,4,1,2)+WQy*VRRS(1,4,2,2)-r1x2E*VRR(1,4,2)
            VRRS(1,10,1,2)=QCz*VRRS(1,4,1,2)+r1x2E*(VRRS(1,1,1,2)-ZxZpE*VRRS(1,1,2,2))+WQz*VRRS(1,4,2,2)
            ! MIC-VRR: Generating [s0|d0]^(0)
            VRRS(1, 5,0,2)=QCx*VRRS(1,2,0,2)+r1x2E*(VRRS(1,1,0,2)-ZxZpE*VRRS(1,1,1,2))+WQx*VRRS(1,2,1,2)
            VRRS(1, 6,0,2)=QCx*VRRS(1,3,0,2)+WQx*VRRS(1,3,1,2)
            VRRS(1, 7,0,2)=QCy*VRRS(1,3,0,2)+r1x2E*(VRRS(1,1,0,2)-ZxZpE*VRRS(1,1,1,2))+WQy*VRRS(1,3,1,2)-r1x2E*VRR(1,3,1)
            VRRS(1, 8,0,2)=QCx*VRRS(1,4,0,2)+WQx*VRRS(1,4,1,2)
            VRRS(1, 9,0,2)=QCy*VRRS(1,4,0,2)+WQy*VRRS(1,4,1,2)-r1x2E*VRR(1,4,1)
            VRRS(1,10,0,2)=QCz*VRRS(1,4,0,2)+r1x2E*(VRRS(1,1,0,2)-ZxZpE*VRRS(1,1,1,2))+WQz*VRRS(1,4,1,2)
            ! MIC-VRR: Generating [p0|d0]^(7)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,7,2),VRRS(1,1,8,2),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [p0|d0]^(6)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|d0]^(5)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|d0]^(4)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|d0]^(3)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|d0]^(2)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|d0]^(1)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|d0]^(0)
            CALL MVRRp0d0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|d0]^(6)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|d0]^(5)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|d0]^(4)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|d0]^(3)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|d0]^(2)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|d0]^(1)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|d0]^(0)
            CALL MVRRd0d0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|d0]^(5)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|d0]^(4)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|d0]^(3)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|d0]^(2)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|d0]^(1)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|d0]^(0)
            CALL MVRRf0d0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|d0]^(4)
            CALL MVRRg0d0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|d0]^(3)
            CALL MVRRg0d0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|d0]^(2)
            CALL MVRRg0d0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|d0]^(1)
            CALL MVRRg0d0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|d0]^(0)
            CALL MVRRg0d0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|d0]^(3)
            CALL MVRRh0d0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|d0]^(2)
            CALL MVRRh0d0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|d0]^(1)
            CALL MVRRh0d0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|d0]^(0)
            CALL MVRRh0d0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|f0]^(7)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,7,2),VRRS(1,1,8,2),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [s0|f0]^(6)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|f0]^(5)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|f0]^(4)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|f0]^(3)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|f0]^(2)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|f0]^(1)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|f0]^(0)
            CALL MVRRs0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|f0]^(6)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|f0]^(5)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|f0]^(4)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|f0]^(3)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|f0]^(2)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|f0]^(1)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|f0]^(0)
            CALL MVRRp0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|f0]^(5)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|f0]^(4)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|f0]^(3)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|f0]^(2)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|f0]^(1)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|f0]^(0)
            CALL MVRRd0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|f0]^(4)
            CALL MVRRf0f0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|f0]^(3)
            CALL MVRRf0f0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|f0]^(2)
            CALL MVRRf0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|f0]^(1)
            CALL MVRRf0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|f0]^(0)
            CALL MVRRf0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|f0]^(3)
            CALL MVRRg0f0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|f0]^(2)
            CALL MVRRg0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|f0]^(1)
            CALL MVRRg0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|f0]^(0)
            CALL MVRRg0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|f0]^(2)
            CALL MVRRh0f0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|f0]^(1)
            CALL MVRRh0f0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|f0]^(0)
            CALL MVRRh0f0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|g0]^(6)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,6,2),VRRS(1,1,7,2),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|g0]^(5)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|g0]^(4)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|g0]^(3)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|g0]^(2)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|g0]^(1)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|g0]^(0)
            CALL MVRRs0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|g0]^(5)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|g0]^(4)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|g0]^(3)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|g0]^(2)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|g0]^(1)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|g0]^(0)
            CALL MVRRp0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|g0]^(4)
            CALL MVRRd0g0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|g0]^(3)
            CALL MVRRd0g0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|g0]^(2)
            CALL MVRRd0g0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|g0]^(1)
            CALL MVRRd0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|g0]^(0)
            CALL MVRRd0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|g0]^(3)
            CALL MVRRf0g0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|g0]^(2)
            CALL MVRRf0g0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|g0]^(1)
            CALL MVRRf0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|g0]^(0)
            CALL MVRRf0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|g0]^(2)
            CALL MVRRg0g0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|g0]^(1)
            CALL MVRRg0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|g0]^(0)
            CALL MVRRg0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|g0]^(1)
            CALL MVRRh0g0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|g0]^(0)
            CALL MVRRh0g0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|h0]^(5)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,5,2),VRRS(1,1,6,2),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|h0]^(4)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|h0]^(3)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|h0]^(2)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|h0]^(1)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|h0]^(0)
            CALL MVRRs0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|h0]^(4)
            CALL MVRRp0h0(2,56,56,VRRS(1,1,4,2),VRRS(1,1,5,2),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|h0]^(3)
            CALL MVRRp0h0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|h0]^(2)
            CALL MVRRp0h0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|h0]^(1)
            CALL MVRRp0h0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|h0]^(0)
            CALL MVRRp0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|h0]^(3)
            CALL MVRRd0h0(2,56,56,VRRS(1,1,3,2),VRRS(1,1,4,2),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|h0]^(2)
            CALL MVRRd0h0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|h0]^(1)
            CALL MVRRd0h0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|h0]^(0)
            CALL MVRRd0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|h0]^(2)
            CALL MVRRf0h0(2,56,56,VRRS(1,1,2,2),VRRS(1,1,3,2),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|h0]^(1)
            CALL MVRRf0h0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|h0]^(0)
            CALL MVRRf0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|h0]^(1)
            CALL MVRRg0h0(2,56,56,VRRS(1,1,1,2),VRRS(1,1,2,2),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|h0]^(0)
            CALL MVRRg0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|h0]^(0)
            CALL MVRRh0h0(2,56,56,VRRS(1,1,0,2),VRRS(1,1,1,2),84,84,VRR(1,1,1))
            ENDIF
            IF(PBC%AutoW%I(3).EQ.1) THEN
            VRRS(1,1,0,3)=PQz*VRR(1,1,1)
            VRRS(1,1,1,3)=PQz*VRR(1,1,2)
            VRRS(1,1,2,3)=PQz*VRR(1,1,3)
            VRRS(1,1,3,3)=PQz*VRR(1,1,4)
            VRRS(1,1,4,3)=PQz*VRR(1,1,5)
            VRRS(1,1,5,3)=PQz*VRR(1,1,6)
            VRRS(1,1,6,3)=PQz*VRR(1,1,7)
            VRRS(1,1,7,3)=PQz*VRR(1,1,8)
            VRRS(1,1,8,3)=PQz*VRR(1,1,9)
            VRRS(1,1,9,3)=PQz*VRR(1,1,10)
            VRRS(1,1,10,3)=PQz*VRR(1,1,11)
            ! MIC-VRR: Generating [p0|s0]^(9)
            VRRS(2,1,9,3)=PAx*VRRS(1,1,9,3)+WPx*VRRS(1,1,10,3)
            VRRS(3,1,9,3)=PAy*VRRS(1,1,9,3)+WPy*VRRS(1,1,10,3)
            VRRS(4,1,9,3)=PAz*VRRS(1,1,9,3)+WPz*VRRS(1,1,10,3)+r1x2Z*VRR(1,1,10)
            ! MIC-VRR: Generating [p0|s0]^(8)
            VRRS(2,1,8,3)=PAx*VRRS(1,1,8,3)+WPx*VRRS(1,1,9,3)
            VRRS(3,1,8,3)=PAy*VRRS(1,1,8,3)+WPy*VRRS(1,1,9,3)
            VRRS(4,1,8,3)=PAz*VRRS(1,1,8,3)+WPz*VRRS(1,1,9,3)+r1x2Z*VRR(1,1,9)
            ! MIC-VRR: Generating [p0|s0]^(7)
            VRRS(2,1,7,3)=PAx*VRRS(1,1,7,3)+WPx*VRRS(1,1,8,3)
            VRRS(3,1,7,3)=PAy*VRRS(1,1,7,3)+WPy*VRRS(1,1,8,3)
            VRRS(4,1,7,3)=PAz*VRRS(1,1,7,3)+WPz*VRRS(1,1,8,3)+r1x2Z*VRR(1,1,8)
            ! MIC-VRR: Generating [p0|s0]^(6)
            VRRS(2,1,6,3)=PAx*VRRS(1,1,6,3)+WPx*VRRS(1,1,7,3)
            VRRS(3,1,6,3)=PAy*VRRS(1,1,6,3)+WPy*VRRS(1,1,7,3)
            VRRS(4,1,6,3)=PAz*VRRS(1,1,6,3)+WPz*VRRS(1,1,7,3)+r1x2Z*VRR(1,1,7)
            ! MIC-VRR: Generating [p0|s0]^(5)
            VRRS(2,1,5,3)=PAx*VRRS(1,1,5,3)+WPx*VRRS(1,1,6,3)
            VRRS(3,1,5,3)=PAy*VRRS(1,1,5,3)+WPy*VRRS(1,1,6,3)
            VRRS(4,1,5,3)=PAz*VRRS(1,1,5,3)+WPz*VRRS(1,1,6,3)+r1x2Z*VRR(1,1,6)
            ! MIC-VRR: Generating [p0|s0]^(4)
            VRRS(2,1,4,3)=PAx*VRRS(1,1,4,3)+WPx*VRRS(1,1,5,3)
            VRRS(3,1,4,3)=PAy*VRRS(1,1,4,3)+WPy*VRRS(1,1,5,3)
            VRRS(4,1,4,3)=PAz*VRRS(1,1,4,3)+WPz*VRRS(1,1,5,3)+r1x2Z*VRR(1,1,5)
            ! MIC-VRR: Generating [p0|s0]^(3)
            VRRS(2,1,3,3)=PAx*VRRS(1,1,3,3)+WPx*VRRS(1,1,4,3)
            VRRS(3,1,3,3)=PAy*VRRS(1,1,3,3)+WPy*VRRS(1,1,4,3)
            VRRS(4,1,3,3)=PAz*VRRS(1,1,3,3)+WPz*VRRS(1,1,4,3)+r1x2Z*VRR(1,1,4)
            ! MIC-VRR: Generating [p0|s0]^(2)
            VRRS(2,1,2,3)=PAx*VRRS(1,1,2,3)+WPx*VRRS(1,1,3,3)
            VRRS(3,1,2,3)=PAy*VRRS(1,1,2,3)+WPy*VRRS(1,1,3,3)
            VRRS(4,1,2,3)=PAz*VRRS(1,1,2,3)+WPz*VRRS(1,1,3,3)+r1x2Z*VRR(1,1,3)
            ! MIC-VRR: Generating [p0|s0]^(1)
            VRRS(2,1,1,3)=PAx*VRRS(1,1,1,3)+WPx*VRRS(1,1,2,3)
            VRRS(3,1,1,3)=PAy*VRRS(1,1,1,3)+WPy*VRRS(1,1,2,3)
            VRRS(4,1,1,3)=PAz*VRRS(1,1,1,3)+WPz*VRRS(1,1,2,3)+r1x2Z*VRR(1,1,2)
            ! MIC-VRR: Generating [p0|s0]^(0)
            VRRS(2,1,0,3)=PAx*VRRS(1,1,0,3)+WPx*VRRS(1,1,1,3)
            VRRS(3,1,0,3)=PAy*VRRS(1,1,0,3)+WPy*VRRS(1,1,1,3)
            VRRS(4,1,0,3)=PAz*VRRS(1,1,0,3)+WPz*VRRS(1,1,1,3)+r1x2Z*VRR(1,1,1)
            ! MIC-VRR: Generating [d0|s0]^(8)
            VRRS( 5,1,8,3)=PAx*VRRS(2,1,8,3)+r1x2Z*(VRRS(1,1,8,3)-ExZpE*VRRS(1,1,9,3))+WPx*VRRS(2,1,9,3)
            VRRS( 6,1,8,3)=PAx*VRRS(3,1,8,3)+WPx*VRRS(3,1,9,3)
            VRRS( 7,1,8,3)=PAy*VRRS(3,1,8,3)+r1x2Z*(VRRS(1,1,8,3)-ExZpE*VRRS(1,1,9,3))+WPy*VRRS(3,1,9,3)
            VRRS( 8,1,8,3)=PAx*VRRS(4,1,8,3)+WPx*VRRS(4,1,9,3)
            VRRS( 9,1,8,3)=PAy*VRRS(4,1,8,3)+WPy*VRRS(4,1,9,3)
            VRRS(10,1,8,3)=PAz*VRRS(4,1,8,3)+r1x2Z*(VRRS(1,1,8,3)-ExZpE*VRRS(1,1,9,3))+WPz*VRRS(4,1,9,3)+r1x2Z*VRR(4,1,9)
            ! MIC-VRR: Generating [d0|s0]^(7)
            VRRS( 5,1,7,3)=PAx*VRRS(2,1,7,3)+r1x2Z*(VRRS(1,1,7,3)-ExZpE*VRRS(1,1,8,3))+WPx*VRRS(2,1,8,3)
            VRRS( 6,1,7,3)=PAx*VRRS(3,1,7,3)+WPx*VRRS(3,1,8,3)
            VRRS( 7,1,7,3)=PAy*VRRS(3,1,7,3)+r1x2Z*(VRRS(1,1,7,3)-ExZpE*VRRS(1,1,8,3))+WPy*VRRS(3,1,8,3)
            VRRS( 8,1,7,3)=PAx*VRRS(4,1,7,3)+WPx*VRRS(4,1,8,3)
            VRRS( 9,1,7,3)=PAy*VRRS(4,1,7,3)+WPy*VRRS(4,1,8,3)
            VRRS(10,1,7,3)=PAz*VRRS(4,1,7,3)+r1x2Z*(VRRS(1,1,7,3)-ExZpE*VRRS(1,1,8,3))+WPz*VRRS(4,1,8,3)+r1x2Z*VRR(4,1,8)
            ! MIC-VRR: Generating [d0|s0]^(6)
            VRRS( 5,1,6,3)=PAx*VRRS(2,1,6,3)+r1x2Z*(VRRS(1,1,6,3)-ExZpE*VRRS(1,1,7,3))+WPx*VRRS(2,1,7,3)
            VRRS( 6,1,6,3)=PAx*VRRS(3,1,6,3)+WPx*VRRS(3,1,7,3)
            VRRS( 7,1,6,3)=PAy*VRRS(3,1,6,3)+r1x2Z*(VRRS(1,1,6,3)-ExZpE*VRRS(1,1,7,3))+WPy*VRRS(3,1,7,3)
            VRRS( 8,1,6,3)=PAx*VRRS(4,1,6,3)+WPx*VRRS(4,1,7,3)
            VRRS( 9,1,6,3)=PAy*VRRS(4,1,6,3)+WPy*VRRS(4,1,7,3)
            VRRS(10,1,6,3)=PAz*VRRS(4,1,6,3)+r1x2Z*(VRRS(1,1,6,3)-ExZpE*VRRS(1,1,7,3))+WPz*VRRS(4,1,7,3)+r1x2Z*VRR(4,1,7)
            ! MIC-VRR: Generating [d0|s0]^(5)
            VRRS( 5,1,5,3)=PAx*VRRS(2,1,5,3)+r1x2Z*(VRRS(1,1,5,3)-ExZpE*VRRS(1,1,6,3))+WPx*VRRS(2,1,6,3)
            VRRS( 6,1,5,3)=PAx*VRRS(3,1,5,3)+WPx*VRRS(3,1,6,3)
            VRRS( 7,1,5,3)=PAy*VRRS(3,1,5,3)+r1x2Z*(VRRS(1,1,5,3)-ExZpE*VRRS(1,1,6,3))+WPy*VRRS(3,1,6,3)
            VRRS( 8,1,5,3)=PAx*VRRS(4,1,5,3)+WPx*VRRS(4,1,6,3)
            VRRS( 9,1,5,3)=PAy*VRRS(4,1,5,3)+WPy*VRRS(4,1,6,3)
            VRRS(10,1,5,3)=PAz*VRRS(4,1,5,3)+r1x2Z*(VRRS(1,1,5,3)-ExZpE*VRRS(1,1,6,3))+WPz*VRRS(4,1,6,3)+r1x2Z*VRR(4,1,6)
            ! MIC-VRR: Generating [d0|s0]^(4)
            VRRS( 5,1,4,3)=PAx*VRRS(2,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPx*VRRS(2,1,5,3)
            VRRS( 6,1,4,3)=PAx*VRRS(3,1,4,3)+WPx*VRRS(3,1,5,3)
            VRRS( 7,1,4,3)=PAy*VRRS(3,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPy*VRRS(3,1,5,3)
            VRRS( 8,1,4,3)=PAx*VRRS(4,1,4,3)+WPx*VRRS(4,1,5,3)
            VRRS( 9,1,4,3)=PAy*VRRS(4,1,4,3)+WPy*VRRS(4,1,5,3)
            VRRS(10,1,4,3)=PAz*VRRS(4,1,4,3)+r1x2Z*(VRRS(1,1,4,3)-ExZpE*VRRS(1,1,5,3))+WPz*VRRS(4,1,5,3)+r1x2Z*VRR(4,1,5)
            ! MIC-VRR: Generating [d0|s0]^(3)
            VRRS( 5,1,3,3)=PAx*VRRS(2,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPx*VRRS(2,1,4,3)
            VRRS( 6,1,3,3)=PAx*VRRS(3,1,3,3)+WPx*VRRS(3,1,4,3)
            VRRS( 7,1,3,3)=PAy*VRRS(3,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPy*VRRS(3,1,4,3)
            VRRS( 8,1,3,3)=PAx*VRRS(4,1,3,3)+WPx*VRRS(4,1,4,3)
            VRRS( 9,1,3,3)=PAy*VRRS(4,1,3,3)+WPy*VRRS(4,1,4,3)
            VRRS(10,1,3,3)=PAz*VRRS(4,1,3,3)+r1x2Z*(VRRS(1,1,3,3)-ExZpE*VRRS(1,1,4,3))+WPz*VRRS(4,1,4,3)+r1x2Z*VRR(4,1,4)
            ! MIC-VRR: Generating [d0|s0]^(2)
            VRRS( 5,1,2,3)=PAx*VRRS(2,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPx*VRRS(2,1,3,3)
            VRRS( 6,1,2,3)=PAx*VRRS(3,1,2,3)+WPx*VRRS(3,1,3,3)
            VRRS( 7,1,2,3)=PAy*VRRS(3,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPy*VRRS(3,1,3,3)
            VRRS( 8,1,2,3)=PAx*VRRS(4,1,2,3)+WPx*VRRS(4,1,3,3)
            VRRS( 9,1,2,3)=PAy*VRRS(4,1,2,3)+WPy*VRRS(4,1,3,3)
            VRRS(10,1,2,3)=PAz*VRRS(4,1,2,3)+r1x2Z*(VRRS(1,1,2,3)-ExZpE*VRRS(1,1,3,3))+WPz*VRRS(4,1,3,3)+r1x2Z*VRR(4,1,3)
            ! MIC-VRR: Generating [d0|s0]^(1)
            VRRS( 5,1,1,3)=PAx*VRRS(2,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPx*VRRS(2,1,2,3)
            VRRS( 6,1,1,3)=PAx*VRRS(3,1,1,3)+WPx*VRRS(3,1,2,3)
            VRRS( 7,1,1,3)=PAy*VRRS(3,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPy*VRRS(3,1,2,3)
            VRRS( 8,1,1,3)=PAx*VRRS(4,1,1,3)+WPx*VRRS(4,1,2,3)
            VRRS( 9,1,1,3)=PAy*VRRS(4,1,1,3)+WPy*VRRS(4,1,2,3)
            VRRS(10,1,1,3)=PAz*VRRS(4,1,1,3)+r1x2Z*(VRRS(1,1,1,3)-ExZpE*VRRS(1,1,2,3))+WPz*VRRS(4,1,2,3)+r1x2Z*VRR(4,1,2)
            ! MIC-VRR: Generating [d0|s0]^(0)
            VRRS( 5,1,0,3)=PAx*VRRS(2,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPx*VRRS(2,1,1,3)
            VRRS( 6,1,0,3)=PAx*VRRS(3,1,0,3)+WPx*VRRS(3,1,1,3)
            VRRS( 7,1,0,3)=PAy*VRRS(3,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPy*VRRS(3,1,1,3)
            VRRS( 8,1,0,3)=PAx*VRRS(4,1,0,3)+WPx*VRRS(4,1,1,3)
            VRRS( 9,1,0,3)=PAy*VRRS(4,1,0,3)+WPy*VRRS(4,1,1,3)
            VRRS(10,1,0,3)=PAz*VRRS(4,1,0,3)+r1x2Z*(VRRS(1,1,0,3)-ExZpE*VRRS(1,1,1,3))+WPz*VRRS(4,1,1,3)+r1x2Z*VRR(4,1,1)
            ! MIC-VRR: Generating [f0|s0]^(7)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,7,3),VRRS(1,1,8,3),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [f0|s0]^(6)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|s0]^(5)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|s0]^(4)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|s0]^(3)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|s0]^(2)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|s0]^(1)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|s0]^(0)
            CALL MVRRf0s0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|s0]^(6)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [g0|s0]^(5)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|s0]^(4)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|s0]^(3)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|s0]^(2)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|s0]^(1)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|s0]^(0)
            CALL MVRRg0s0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|s0]^(5)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [h0|s0]^(4)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|s0]^(3)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|s0]^(2)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|s0]^(1)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|s0]^(0)
            CALL MVRRh0s0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|p0]^(9)
            VRRS(1,2,9,3)=QCx*VRRS(1,1,9,3)+WQx*VRRS(1,1,10,3)
            VRRS(1,3,9,3)=QCy*VRRS(1,1,9,3)+WQy*VRRS(1,1,10,3)
            VRRS(1,4,9,3)=QCz*VRRS(1,1,9,3)+WQz*VRRS(1,1,10,3)-r1x2E*VRR(1,1,10)
            ! MIC-VRR: Generating [s0|p0]^(8)
            VRRS(1,2,8,3)=QCx*VRRS(1,1,8,3)+WQx*VRRS(1,1,9,3)
            VRRS(1,3,8,3)=QCy*VRRS(1,1,8,3)+WQy*VRRS(1,1,9,3)
            VRRS(1,4,8,3)=QCz*VRRS(1,1,8,3)+WQz*VRRS(1,1,9,3)-r1x2E*VRR(1,1,9)
            ! MIC-VRR: Generating [s0|p0]^(7)
            VRRS(1,2,7,3)=QCx*VRRS(1,1,7,3)+WQx*VRRS(1,1,8,3)
            VRRS(1,3,7,3)=QCy*VRRS(1,1,7,3)+WQy*VRRS(1,1,8,3)
            VRRS(1,4,7,3)=QCz*VRRS(1,1,7,3)+WQz*VRRS(1,1,8,3)-r1x2E*VRR(1,1,8)
            ! MIC-VRR: Generating [s0|p0]^(6)
            VRRS(1,2,6,3)=QCx*VRRS(1,1,6,3)+WQx*VRRS(1,1,7,3)
            VRRS(1,3,6,3)=QCy*VRRS(1,1,6,3)+WQy*VRRS(1,1,7,3)
            VRRS(1,4,6,3)=QCz*VRRS(1,1,6,3)+WQz*VRRS(1,1,7,3)-r1x2E*VRR(1,1,7)
            ! MIC-VRR: Generating [s0|p0]^(5)
            VRRS(1,2,5,3)=QCx*VRRS(1,1,5,3)+WQx*VRRS(1,1,6,3)
            VRRS(1,3,5,3)=QCy*VRRS(1,1,5,3)+WQy*VRRS(1,1,6,3)
            VRRS(1,4,5,3)=QCz*VRRS(1,1,5,3)+WQz*VRRS(1,1,6,3)-r1x2E*VRR(1,1,6)
            ! MIC-VRR: Generating [s0|p0]^(4)
            VRRS(1,2,4,3)=QCx*VRRS(1,1,4,3)+WQx*VRRS(1,1,5,3)
            VRRS(1,3,4,3)=QCy*VRRS(1,1,4,3)+WQy*VRRS(1,1,5,3)
            VRRS(1,4,4,3)=QCz*VRRS(1,1,4,3)+WQz*VRRS(1,1,5,3)-r1x2E*VRR(1,1,5)
            ! MIC-VRR: Generating [s0|p0]^(3)
            VRRS(1,2,3,3)=QCx*VRRS(1,1,3,3)+WQx*VRRS(1,1,4,3)
            VRRS(1,3,3,3)=QCy*VRRS(1,1,3,3)+WQy*VRRS(1,1,4,3)
            VRRS(1,4,3,3)=QCz*VRRS(1,1,3,3)+WQz*VRRS(1,1,4,3)-r1x2E*VRR(1,1,4)
            ! MIC-VRR: Generating [s0|p0]^(2)
            VRRS(1,2,2,3)=QCx*VRRS(1,1,2,3)+WQx*VRRS(1,1,3,3)
            VRRS(1,3,2,3)=QCy*VRRS(1,1,2,3)+WQy*VRRS(1,1,3,3)
            VRRS(1,4,2,3)=QCz*VRRS(1,1,2,3)+WQz*VRRS(1,1,3,3)-r1x2E*VRR(1,1,3)
            ! MIC-VRR: Generating [s0|p0]^(1)
            VRRS(1,2,1,3)=QCx*VRRS(1,1,1,3)+WQx*VRRS(1,1,2,3)
            VRRS(1,3,1,3)=QCy*VRRS(1,1,1,3)+WQy*VRRS(1,1,2,3)
            VRRS(1,4,1,3)=QCz*VRRS(1,1,1,3)+WQz*VRRS(1,1,2,3)-r1x2E*VRR(1,1,2)
            ! MIC-VRR: Generating [s0|p0]^(0)
            VRRS(1,2,0,3)=QCx*VRRS(1,1,0,3)+WQx*VRRS(1,1,1,3)
            VRRS(1,3,0,3)=QCy*VRRS(1,1,0,3)+WQy*VRRS(1,1,1,3)
            VRRS(1,4,0,3)=QCz*VRRS(1,1,0,3)+WQz*VRRS(1,1,1,3)-r1x2E*VRR(1,1,1)
            ! MIC-VRR: Generating [p0|p0]^(8)
            VRRS(2,2,8,3)=QCx*VRRS(2,1,8,3)+WQx*VRRS(2,1,9,3)+HfxZpE*VRRS(1,1,9,3)
            VRRS(2,3,8,3)=QCy*VRRS(2,1,8,3)+WQy*VRRS(2,1,9,3)
            VRRS(2,4,8,3)=QCz*VRRS(2,1,8,3)+WQz*VRRS(2,1,9,3)-r1x2E *VRR(2,1,9)
            VRRS(3,2,8,3)=QCx*VRRS(3,1,8,3)+WQx*VRRS(3,1,9,3)
            VRRS(3,3,8,3)=QCy*VRRS(3,1,8,3)+WQy*VRRS(3,1,9,3)+HfxZpE*VRRS(1,1,9,3)
            VRRS(3,4,8,3)=QCz*VRRS(3,1,8,3)+WQz*VRRS(3,1,9,3)-r1x2E *VRR(3,1,9)
            VRRS(4,2,8,3)=QCx*VRRS(4,1,8,3)+WQx*VRRS(4,1,9,3)
            VRRS(4,3,8,3)=QCy*VRRS(4,1,8,3)+WQy*VRRS(4,1,9,3)
            VRRS(4,4,8,3)=QCz*VRRS(4,1,8,3)+WQz*VRRS(4,1,9,3)+HfxZpE*VRRS(1,1,9,3)-r1x2E *VRR(4,1,9)
            ! MIC-VRR: Generating [p0|p0]^(7)
            VRRS(2,2,7,3)=QCx*VRRS(2,1,7,3)+WQx*VRRS(2,1,8,3)+HfxZpE*VRRS(1,1,8,3)
            VRRS(2,3,7,3)=QCy*VRRS(2,1,7,3)+WQy*VRRS(2,1,8,3)
            VRRS(2,4,7,3)=QCz*VRRS(2,1,7,3)+WQz*VRRS(2,1,8,3)-r1x2E *VRR(2,1,8)
            VRRS(3,2,7,3)=QCx*VRRS(3,1,7,3)+WQx*VRRS(3,1,8,3)
            VRRS(3,3,7,3)=QCy*VRRS(3,1,7,3)+WQy*VRRS(3,1,8,3)+HfxZpE*VRRS(1,1,8,3)
            VRRS(3,4,7,3)=QCz*VRRS(3,1,7,3)+WQz*VRRS(3,1,8,3)-r1x2E *VRR(3,1,8)
            VRRS(4,2,7,3)=QCx*VRRS(4,1,7,3)+WQx*VRRS(4,1,8,3)
            VRRS(4,3,7,3)=QCy*VRRS(4,1,7,3)+WQy*VRRS(4,1,8,3)
            VRRS(4,4,7,3)=QCz*VRRS(4,1,7,3)+WQz*VRRS(4,1,8,3)+HfxZpE*VRRS(1,1,8,3)-r1x2E *VRR(4,1,8)
            ! MIC-VRR: Generating [p0|p0]^(6)
            VRRS(2,2,6,3)=QCx*VRRS(2,1,6,3)+WQx*VRRS(2,1,7,3)+HfxZpE*VRRS(1,1,7,3)
            VRRS(2,3,6,3)=QCy*VRRS(2,1,6,3)+WQy*VRRS(2,1,7,3)
            VRRS(2,4,6,3)=QCz*VRRS(2,1,6,3)+WQz*VRRS(2,1,7,3)-r1x2E *VRR(2,1,7)
            VRRS(3,2,6,3)=QCx*VRRS(3,1,6,3)+WQx*VRRS(3,1,7,3)
            VRRS(3,3,6,3)=QCy*VRRS(3,1,6,3)+WQy*VRRS(3,1,7,3)+HfxZpE*VRRS(1,1,7,3)
            VRRS(3,4,6,3)=QCz*VRRS(3,1,6,3)+WQz*VRRS(3,1,7,3)-r1x2E *VRR(3,1,7)
            VRRS(4,2,6,3)=QCx*VRRS(4,1,6,3)+WQx*VRRS(4,1,7,3)
            VRRS(4,3,6,3)=QCy*VRRS(4,1,6,3)+WQy*VRRS(4,1,7,3)
            VRRS(4,4,6,3)=QCz*VRRS(4,1,6,3)+WQz*VRRS(4,1,7,3)+HfxZpE*VRRS(1,1,7,3)-r1x2E *VRR(4,1,7)
            ! MIC-VRR: Generating [p0|p0]^(5)
            VRRS(2,2,5,3)=QCx*VRRS(2,1,5,3)+WQx*VRRS(2,1,6,3)+HfxZpE*VRRS(1,1,6,3)
            VRRS(2,3,5,3)=QCy*VRRS(2,1,5,3)+WQy*VRRS(2,1,6,3)
            VRRS(2,4,5,3)=QCz*VRRS(2,1,5,3)+WQz*VRRS(2,1,6,3)-r1x2E *VRR(2,1,6)
            VRRS(3,2,5,3)=QCx*VRRS(3,1,5,3)+WQx*VRRS(3,1,6,3)
            VRRS(3,3,5,3)=QCy*VRRS(3,1,5,3)+WQy*VRRS(3,1,6,3)+HfxZpE*VRRS(1,1,6,3)
            VRRS(3,4,5,3)=QCz*VRRS(3,1,5,3)+WQz*VRRS(3,1,6,3)-r1x2E *VRR(3,1,6)
            VRRS(4,2,5,3)=QCx*VRRS(4,1,5,3)+WQx*VRRS(4,1,6,3)
            VRRS(4,3,5,3)=QCy*VRRS(4,1,5,3)+WQy*VRRS(4,1,6,3)
            VRRS(4,4,5,3)=QCz*VRRS(4,1,5,3)+WQz*VRRS(4,1,6,3)+HfxZpE*VRRS(1,1,6,3)-r1x2E *VRR(4,1,6)
            ! MIC-VRR: Generating [p0|p0]^(4)
            VRRS(2,2,4,3)=QCx*VRRS(2,1,4,3)+WQx*VRRS(2,1,5,3)+HfxZpE*VRRS(1,1,5,3)
            VRRS(2,3,4,3)=QCy*VRRS(2,1,4,3)+WQy*VRRS(2,1,5,3)
            VRRS(2,4,4,3)=QCz*VRRS(2,1,4,3)+WQz*VRRS(2,1,5,3)-r1x2E *VRR(2,1,5)
            VRRS(3,2,4,3)=QCx*VRRS(3,1,4,3)+WQx*VRRS(3,1,5,3)
            VRRS(3,3,4,3)=QCy*VRRS(3,1,4,3)+WQy*VRRS(3,1,5,3)+HfxZpE*VRRS(1,1,5,3)
            VRRS(3,4,4,3)=QCz*VRRS(3,1,4,3)+WQz*VRRS(3,1,5,3)-r1x2E *VRR(3,1,5)
            VRRS(4,2,4,3)=QCx*VRRS(4,1,4,3)+WQx*VRRS(4,1,5,3)
            VRRS(4,3,4,3)=QCy*VRRS(4,1,4,3)+WQy*VRRS(4,1,5,3)
            VRRS(4,4,4,3)=QCz*VRRS(4,1,4,3)+WQz*VRRS(4,1,5,3)+HfxZpE*VRRS(1,1,5,3)-r1x2E *VRR(4,1,5)
            ! MIC-VRR: Generating [p0|p0]^(3)
            VRRS(2,2,3,3)=QCx*VRRS(2,1,3,3)+WQx*VRRS(2,1,4,3)+HfxZpE*VRRS(1,1,4,3)
            VRRS(2,3,3,3)=QCy*VRRS(2,1,3,3)+WQy*VRRS(2,1,4,3)
            VRRS(2,4,3,3)=QCz*VRRS(2,1,3,3)+WQz*VRRS(2,1,4,3)-r1x2E *VRR(2,1,4)
            VRRS(3,2,3,3)=QCx*VRRS(3,1,3,3)+WQx*VRRS(3,1,4,3)
            VRRS(3,3,3,3)=QCy*VRRS(3,1,3,3)+WQy*VRRS(3,1,4,3)+HfxZpE*VRRS(1,1,4,3)
            VRRS(3,4,3,3)=QCz*VRRS(3,1,3,3)+WQz*VRRS(3,1,4,3)-r1x2E *VRR(3,1,4)
            VRRS(4,2,3,3)=QCx*VRRS(4,1,3,3)+WQx*VRRS(4,1,4,3)
            VRRS(4,3,3,3)=QCy*VRRS(4,1,3,3)+WQy*VRRS(4,1,4,3)
            VRRS(4,4,3,3)=QCz*VRRS(4,1,3,3)+WQz*VRRS(4,1,4,3)+HfxZpE*VRRS(1,1,4,3)-r1x2E *VRR(4,1,4)
            ! MIC-VRR: Generating [p0|p0]^(2)
            VRRS(2,2,2,3)=QCx*VRRS(2,1,2,3)+WQx*VRRS(2,1,3,3)+HfxZpE*VRRS(1,1,3,3)
            VRRS(2,3,2,3)=QCy*VRRS(2,1,2,3)+WQy*VRRS(2,1,3,3)
            VRRS(2,4,2,3)=QCz*VRRS(2,1,2,3)+WQz*VRRS(2,1,3,3)-r1x2E *VRR(2,1,3)
            VRRS(3,2,2,3)=QCx*VRRS(3,1,2,3)+WQx*VRRS(3,1,3,3)
            VRRS(3,3,2,3)=QCy*VRRS(3,1,2,3)+WQy*VRRS(3,1,3,3)+HfxZpE*VRRS(1,1,3,3)
            VRRS(3,4,2,3)=QCz*VRRS(3,1,2,3)+WQz*VRRS(3,1,3,3)-r1x2E *VRR(3,1,3)
            VRRS(4,2,2,3)=QCx*VRRS(4,1,2,3)+WQx*VRRS(4,1,3,3)
            VRRS(4,3,2,3)=QCy*VRRS(4,1,2,3)+WQy*VRRS(4,1,3,3)
            VRRS(4,4,2,3)=QCz*VRRS(4,1,2,3)+WQz*VRRS(4,1,3,3)+HfxZpE*VRRS(1,1,3,3)-r1x2E *VRR(4,1,3)
            ! MIC-VRR: Generating [p0|p0]^(1)
            VRRS(2,2,1,3)=QCx*VRRS(2,1,1,3)+WQx*VRRS(2,1,2,3)+HfxZpE*VRRS(1,1,2,3)
            VRRS(2,3,1,3)=QCy*VRRS(2,1,1,3)+WQy*VRRS(2,1,2,3)
            VRRS(2,4,1,3)=QCz*VRRS(2,1,1,3)+WQz*VRRS(2,1,2,3)-r1x2E *VRR(2,1,2)
            VRRS(3,2,1,3)=QCx*VRRS(3,1,1,3)+WQx*VRRS(3,1,2,3)
            VRRS(3,3,1,3)=QCy*VRRS(3,1,1,3)+WQy*VRRS(3,1,2,3)+HfxZpE*VRRS(1,1,2,3)
            VRRS(3,4,1,3)=QCz*VRRS(3,1,1,3)+WQz*VRRS(3,1,2,3)-r1x2E *VRR(3,1,2)
            VRRS(4,2,1,3)=QCx*VRRS(4,1,1,3)+WQx*VRRS(4,1,2,3)
            VRRS(4,3,1,3)=QCy*VRRS(4,1,1,3)+WQy*VRRS(4,1,2,3)
            VRRS(4,4,1,3)=QCz*VRRS(4,1,1,3)+WQz*VRRS(4,1,2,3)+HfxZpE*VRRS(1,1,2,3)-r1x2E *VRR(4,1,2)
            ! MIC-VRR: Generating [p0|p0]^(0)
            VRRS(2,2,0,3)=QCx*VRRS(2,1,0,3)+WQx*VRRS(2,1,1,3)+HfxZpE*VRRS(1,1,1,3)
            VRRS(2,3,0,3)=QCy*VRRS(2,1,0,3)+WQy*VRRS(2,1,1,3)
            VRRS(2,4,0,3)=QCz*VRRS(2,1,0,3)+WQz*VRRS(2,1,1,3)-r1x2E *VRR(2,1,1)
            VRRS(3,2,0,3)=QCx*VRRS(3,1,0,3)+WQx*VRRS(3,1,1,3)
            VRRS(3,3,0,3)=QCy*VRRS(3,1,0,3)+WQy*VRRS(3,1,1,3)+HfxZpE*VRRS(1,1,1,3)
            VRRS(3,4,0,3)=QCz*VRRS(3,1,0,3)+WQz*VRRS(3,1,1,3)-r1x2E *VRR(3,1,1)
            VRRS(4,2,0,3)=QCx*VRRS(4,1,0,3)+WQx*VRRS(4,1,1,3)
            VRRS(4,3,0,3)=QCy*VRRS(4,1,0,3)+WQy*VRRS(4,1,1,3)
            VRRS(4,4,0,3)=QCz*VRRS(4,1,0,3)+WQz*VRRS(4,1,1,3)+HfxZpE*VRRS(1,1,1,3)-r1x2E *VRR(4,1,1)
            ! MIC-VRR: Generating [d0|p0]^(7)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,7,3),VRRS(1,1,8,3),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [d0|p0]^(6)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|p0]^(5)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|p0]^(4)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|p0]^(3)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|p0]^(2)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|p0]^(1)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|p0]^(0)
            CALL MVRRd0p0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|p0]^(6)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [f0|p0]^(5)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|p0]^(4)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|p0]^(3)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|p0]^(2)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|p0]^(1)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|p0]^(0)
            CALL MVRRf0p0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|p0]^(5)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [g0|p0]^(4)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|p0]^(3)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|p0]^(2)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|p0]^(1)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|p0]^(0)
            CALL MVRRg0p0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|p0]^(4)
            CALL MVRRh0p0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [h0|p0]^(3)
            CALL MVRRh0p0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|p0]^(2)
            CALL MVRRh0p0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|p0]^(1)
            CALL MVRRh0p0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|p0]^(0)
            CALL MVRRh0p0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|d0]^(8)
            VRRS(1, 5,8,3)=QCx*VRRS(1,2,8,3)+r1x2E*(VRRS(1,1,8,3)-ZxZpE*VRRS(1,1,9,3))+WQx*VRRS(1,2,9,3)
            VRRS(1, 6,8,3)=QCx*VRRS(1,3,8,3)+WQx*VRRS(1,3,9,3)
            VRRS(1, 7,8,3)=QCy*VRRS(1,3,8,3)+r1x2E*(VRRS(1,1,8,3)-ZxZpE*VRRS(1,1,9,3))+WQy*VRRS(1,3,9,3)
            VRRS(1, 8,8,3)=QCx*VRRS(1,4,8,3)+WQx*VRRS(1,4,9,3)
            VRRS(1, 9,8,3)=QCy*VRRS(1,4,8,3)+WQy*VRRS(1,4,9,3)
            VRRS(1,10,8,3)=QCz*VRRS(1,4,8,3)+r1x2E*(VRRS(1,1,8,3)-ZxZpE*VRRS(1,1,9,3))+WQz*VRRS(1,4,9,3)-r1x2E*VRR(1,4,9)
            ! MIC-VRR: Generating [s0|d0]^(7)
            VRRS(1, 5,7,3)=QCx*VRRS(1,2,7,3)+r1x2E*(VRRS(1,1,7,3)-ZxZpE*VRRS(1,1,8,3))+WQx*VRRS(1,2,8,3)
            VRRS(1, 6,7,3)=QCx*VRRS(1,3,7,3)+WQx*VRRS(1,3,8,3)
            VRRS(1, 7,7,3)=QCy*VRRS(1,3,7,3)+r1x2E*(VRRS(1,1,7,3)-ZxZpE*VRRS(1,1,8,3))+WQy*VRRS(1,3,8,3)
            VRRS(1, 8,7,3)=QCx*VRRS(1,4,7,3)+WQx*VRRS(1,4,8,3)
            VRRS(1, 9,7,3)=QCy*VRRS(1,4,7,3)+WQy*VRRS(1,4,8,3)
            VRRS(1,10,7,3)=QCz*VRRS(1,4,7,3)+r1x2E*(VRRS(1,1,7,3)-ZxZpE*VRRS(1,1,8,3))+WQz*VRRS(1,4,8,3)-r1x2E*VRR(1,4,8)
            ! MIC-VRR: Generating [s0|d0]^(6)
            VRRS(1, 5,6,3)=QCx*VRRS(1,2,6,3)+r1x2E*(VRRS(1,1,6,3)-ZxZpE*VRRS(1,1,7,3))+WQx*VRRS(1,2,7,3)
            VRRS(1, 6,6,3)=QCx*VRRS(1,3,6,3)+WQx*VRRS(1,3,7,3)
            VRRS(1, 7,6,3)=QCy*VRRS(1,3,6,3)+r1x2E*(VRRS(1,1,6,3)-ZxZpE*VRRS(1,1,7,3))+WQy*VRRS(1,3,7,3)
            VRRS(1, 8,6,3)=QCx*VRRS(1,4,6,3)+WQx*VRRS(1,4,7,3)
            VRRS(1, 9,6,3)=QCy*VRRS(1,4,6,3)+WQy*VRRS(1,4,7,3)
            VRRS(1,10,6,3)=QCz*VRRS(1,4,6,3)+r1x2E*(VRRS(1,1,6,3)-ZxZpE*VRRS(1,1,7,3))+WQz*VRRS(1,4,7,3)-r1x2E*VRR(1,4,7)
            ! MIC-VRR: Generating [s0|d0]^(5)
            VRRS(1, 5,5,3)=QCx*VRRS(1,2,5,3)+r1x2E*(VRRS(1,1,5,3)-ZxZpE*VRRS(1,1,6,3))+WQx*VRRS(1,2,6,3)
            VRRS(1, 6,5,3)=QCx*VRRS(1,3,5,3)+WQx*VRRS(1,3,6,3)
            VRRS(1, 7,5,3)=QCy*VRRS(1,3,5,3)+r1x2E*(VRRS(1,1,5,3)-ZxZpE*VRRS(1,1,6,3))+WQy*VRRS(1,3,6,3)
            VRRS(1, 8,5,3)=QCx*VRRS(1,4,5,3)+WQx*VRRS(1,4,6,3)
            VRRS(1, 9,5,3)=QCy*VRRS(1,4,5,3)+WQy*VRRS(1,4,6,3)
            VRRS(1,10,5,3)=QCz*VRRS(1,4,5,3)+r1x2E*(VRRS(1,1,5,3)-ZxZpE*VRRS(1,1,6,3))+WQz*VRRS(1,4,6,3)-r1x2E*VRR(1,4,6)
            ! MIC-VRR: Generating [s0|d0]^(4)
            VRRS(1, 5,4,3)=QCx*VRRS(1,2,4,3)+r1x2E*(VRRS(1,1,4,3)-ZxZpE*VRRS(1,1,5,3))+WQx*VRRS(1,2,5,3)
            VRRS(1, 6,4,3)=QCx*VRRS(1,3,4,3)+WQx*VRRS(1,3,5,3)
            VRRS(1, 7,4,3)=QCy*VRRS(1,3,4,3)+r1x2E*(VRRS(1,1,4,3)-ZxZpE*VRRS(1,1,5,3))+WQy*VRRS(1,3,5,3)
            VRRS(1, 8,4,3)=QCx*VRRS(1,4,4,3)+WQx*VRRS(1,4,5,3)
            VRRS(1, 9,4,3)=QCy*VRRS(1,4,4,3)+WQy*VRRS(1,4,5,3)
            VRRS(1,10,4,3)=QCz*VRRS(1,4,4,3)+r1x2E*(VRRS(1,1,4,3)-ZxZpE*VRRS(1,1,5,3))+WQz*VRRS(1,4,5,3)-r1x2E*VRR(1,4,5)
            ! MIC-VRR: Generating [s0|d0]^(3)
            VRRS(1, 5,3,3)=QCx*VRRS(1,2,3,3)+r1x2E*(VRRS(1,1,3,3)-ZxZpE*VRRS(1,1,4,3))+WQx*VRRS(1,2,4,3)
            VRRS(1, 6,3,3)=QCx*VRRS(1,3,3,3)+WQx*VRRS(1,3,4,3)
            VRRS(1, 7,3,3)=QCy*VRRS(1,3,3,3)+r1x2E*(VRRS(1,1,3,3)-ZxZpE*VRRS(1,1,4,3))+WQy*VRRS(1,3,4,3)
            VRRS(1, 8,3,3)=QCx*VRRS(1,4,3,3)+WQx*VRRS(1,4,4,3)
            VRRS(1, 9,3,3)=QCy*VRRS(1,4,3,3)+WQy*VRRS(1,4,4,3)
            VRRS(1,10,3,3)=QCz*VRRS(1,4,3,3)+r1x2E*(VRRS(1,1,3,3)-ZxZpE*VRRS(1,1,4,3))+WQz*VRRS(1,4,4,3)-r1x2E*VRR(1,4,4)
            ! MIC-VRR: Generating [s0|d0]^(2)
            VRRS(1, 5,2,3)=QCx*VRRS(1,2,2,3)+r1x2E*(VRRS(1,1,2,3)-ZxZpE*VRRS(1,1,3,3))+WQx*VRRS(1,2,3,3)
            VRRS(1, 6,2,3)=QCx*VRRS(1,3,2,3)+WQx*VRRS(1,3,3,3)
            VRRS(1, 7,2,3)=QCy*VRRS(1,3,2,3)+r1x2E*(VRRS(1,1,2,3)-ZxZpE*VRRS(1,1,3,3))+WQy*VRRS(1,3,3,3)
            VRRS(1, 8,2,3)=QCx*VRRS(1,4,2,3)+WQx*VRRS(1,4,3,3)
            VRRS(1, 9,2,3)=QCy*VRRS(1,4,2,3)+WQy*VRRS(1,4,3,3)
            VRRS(1,10,2,3)=QCz*VRRS(1,4,2,3)+r1x2E*(VRRS(1,1,2,3)-ZxZpE*VRRS(1,1,3,3))+WQz*VRRS(1,4,3,3)-r1x2E*VRR(1,4,3)
            ! MIC-VRR: Generating [s0|d0]^(1)
            VRRS(1, 5,1,3)=QCx*VRRS(1,2,1,3)+r1x2E*(VRRS(1,1,1,3)-ZxZpE*VRRS(1,1,2,3))+WQx*VRRS(1,2,2,3)
            VRRS(1, 6,1,3)=QCx*VRRS(1,3,1,3)+WQx*VRRS(1,3,2,3)
            VRRS(1, 7,1,3)=QCy*VRRS(1,3,1,3)+r1x2E*(VRRS(1,1,1,3)-ZxZpE*VRRS(1,1,2,3))+WQy*VRRS(1,3,2,3)
            VRRS(1, 8,1,3)=QCx*VRRS(1,4,1,3)+WQx*VRRS(1,4,2,3)
            VRRS(1, 9,1,3)=QCy*VRRS(1,4,1,3)+WQy*VRRS(1,4,2,3)
            VRRS(1,10,1,3)=QCz*VRRS(1,4,1,3)+r1x2E*(VRRS(1,1,1,3)-ZxZpE*VRRS(1,1,2,3))+WQz*VRRS(1,4,2,3)-r1x2E*VRR(1,4,2)
            ! MIC-VRR: Generating [s0|d0]^(0)
            VRRS(1, 5,0,3)=QCx*VRRS(1,2,0,3)+r1x2E*(VRRS(1,1,0,3)-ZxZpE*VRRS(1,1,1,3))+WQx*VRRS(1,2,1,3)
            VRRS(1, 6,0,3)=QCx*VRRS(1,3,0,3)+WQx*VRRS(1,3,1,3)
            VRRS(1, 7,0,3)=QCy*VRRS(1,3,0,3)+r1x2E*(VRRS(1,1,0,3)-ZxZpE*VRRS(1,1,1,3))+WQy*VRRS(1,3,1,3)
            VRRS(1, 8,0,3)=QCx*VRRS(1,4,0,3)+WQx*VRRS(1,4,1,3)
            VRRS(1, 9,0,3)=QCy*VRRS(1,4,0,3)+WQy*VRRS(1,4,1,3)
            VRRS(1,10,0,3)=QCz*VRRS(1,4,0,3)+r1x2E*(VRRS(1,1,0,3)-ZxZpE*VRRS(1,1,1,3))+WQz*VRRS(1,4,1,3)-r1x2E*VRR(1,4,1)
            ! MIC-VRR: Generating [p0|d0]^(7)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,7,3),VRRS(1,1,8,3),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [p0|d0]^(6)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|d0]^(5)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|d0]^(4)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|d0]^(3)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|d0]^(2)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|d0]^(1)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|d0]^(0)
            CALL MVRRp0d0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|d0]^(6)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [d0|d0]^(5)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|d0]^(4)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|d0]^(3)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|d0]^(2)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|d0]^(1)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|d0]^(0)
            CALL MVRRd0d0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|d0]^(5)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [f0|d0]^(4)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|d0]^(3)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|d0]^(2)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|d0]^(1)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|d0]^(0)
            CALL MVRRf0d0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|d0]^(4)
            CALL MVRRg0d0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [g0|d0]^(3)
            CALL MVRRg0d0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|d0]^(2)
            CALL MVRRg0d0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|d0]^(1)
            CALL MVRRg0d0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|d0]^(0)
            CALL MVRRg0d0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|d0]^(3)
            CALL MVRRh0d0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [h0|d0]^(2)
            CALL MVRRh0d0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|d0]^(1)
            CALL MVRRh0d0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|d0]^(0)
            CALL MVRRh0d0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|f0]^(7)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,7,3),VRRS(1,1,8,3),84,84,VRR(1,1,8))
            ! MIC-VRR: Generating [s0|f0]^(6)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|f0]^(5)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|f0]^(4)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|f0]^(3)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|f0]^(2)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|f0]^(1)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|f0]^(0)
            CALL MVRRs0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|f0]^(6)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [p0|f0]^(5)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|f0]^(4)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|f0]^(3)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|f0]^(2)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|f0]^(1)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|f0]^(0)
            CALL MVRRp0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|f0]^(5)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [d0|f0]^(4)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|f0]^(3)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|f0]^(2)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|f0]^(1)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|f0]^(0)
            CALL MVRRd0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|f0]^(4)
            CALL MVRRf0f0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [f0|f0]^(3)
            CALL MVRRf0f0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|f0]^(2)
            CALL MVRRf0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|f0]^(1)
            CALL MVRRf0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|f0]^(0)
            CALL MVRRf0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|f0]^(3)
            CALL MVRRg0f0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [g0|f0]^(2)
            CALL MVRRg0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|f0]^(1)
            CALL MVRRg0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|f0]^(0)
            CALL MVRRg0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|f0]^(2)
            CALL MVRRh0f0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [h0|f0]^(1)
            CALL MVRRh0f0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|f0]^(0)
            CALL MVRRh0f0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|g0]^(6)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,6,3),VRRS(1,1,7,3),84,84,VRR(1,1,7))
            ! MIC-VRR: Generating [s0|g0]^(5)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|g0]^(4)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|g0]^(3)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|g0]^(2)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|g0]^(1)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|g0]^(0)
            CALL MVRRs0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|g0]^(5)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [p0|g0]^(4)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|g0]^(3)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|g0]^(2)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|g0]^(1)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|g0]^(0)
            CALL MVRRp0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|g0]^(4)
            CALL MVRRd0g0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [d0|g0]^(3)
            CALL MVRRd0g0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|g0]^(2)
            CALL MVRRd0g0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|g0]^(1)
            CALL MVRRd0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|g0]^(0)
            CALL MVRRd0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|g0]^(3)
            CALL MVRRf0g0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [f0|g0]^(2)
            CALL MVRRf0g0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|g0]^(1)
            CALL MVRRf0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|g0]^(0)
            CALL MVRRf0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|g0]^(2)
            CALL MVRRg0g0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [g0|g0]^(1)
            CALL MVRRg0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|g0]^(0)
            CALL MVRRg0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|g0]^(1)
            CALL MVRRh0g0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [h0|g0]^(0)
            CALL MVRRh0g0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [s0|h0]^(5)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,5,3),VRRS(1,1,6,3),84,84,VRR(1,1,6))
            ! MIC-VRR: Generating [s0|h0]^(4)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [s0|h0]^(3)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [s0|h0]^(2)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [s0|h0]^(1)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [s0|h0]^(0)
            CALL MVRRs0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [p0|h0]^(4)
            CALL MVRRp0h0(3,56,56,VRRS(1,1,4,3),VRRS(1,1,5,3),84,84,VRR(1,1,5))
            ! MIC-VRR: Generating [p0|h0]^(3)
            CALL MVRRp0h0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [p0|h0]^(2)
            CALL MVRRp0h0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [p0|h0]^(1)
            CALL MVRRp0h0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [p0|h0]^(0)
            CALL MVRRp0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [d0|h0]^(3)
            CALL MVRRd0h0(3,56,56,VRRS(1,1,3,3),VRRS(1,1,4,3),84,84,VRR(1,1,4))
            ! MIC-VRR: Generating [d0|h0]^(2)
            CALL MVRRd0h0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [d0|h0]^(1)
            CALL MVRRd0h0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [d0|h0]^(0)
            CALL MVRRd0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [f0|h0]^(2)
            CALL MVRRf0h0(3,56,56,VRRS(1,1,2,3),VRRS(1,1,3,3),84,84,VRR(1,1,3))
            ! MIC-VRR: Generating [f0|h0]^(1)
            CALL MVRRf0h0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [f0|h0]^(0)
            CALL MVRRf0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [g0|h0]^(1)
            CALL MVRRg0h0(3,56,56,VRRS(1,1,1,3),VRRS(1,1,2,3),84,84,VRR(1,1,2))
            ! MIC-VRR: Generating [g0|h0]^(0)
            CALL MVRRg0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ! MIC-VRR: Generating [h0|h0]^(0)
            CALL MVRRh0h0(3,56,56,VRRS(1,1,0,3),VRRS(1,1,1,3),84,84,VRR(1,1,1))
            ENDIF
            ! Contracting ...
            CALL CNTRCTG106106(VRR,HRR,Alpha,HRRA,Beta,HRRB,Gamma,HRRC, &
                       VRRS,HRRS(1,1,1,1),PQJ(1),PBC%AutoW%I(1))
         ENDDO ! (M0| loop
      ENDDO ! |N0) loop
      ! Generating (h,0|f,d)
      CALL KetHRR106(56,HRR)
      ! Generating (i,0|f,d)^a
      CALL KetHRR106(84,HRRA)
      ! Generating (i,0|f,d)^b
      CALL KetHRR106(84,HRRB)
      ! Generating (h,0|g,d)^c
      CALL KetHRR156(56,HRRC)
      ! Stress: Generating [f,0|f,d]
      DO IJ=1,9
        CALL KetHRR106(56,HRRS(1,1,1,IJ))
      ENDDO
      DO L=5,10

         !K = 11
         CDOffSet=(OC+11-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|11,L)  and (f,d'|11,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,11,L),&
                      HRRA(1,11,L),HRRB(1,11,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|11_x,L)  and (f,d|11,L_x)
         HRRTmp(1:56)=HRRC(1:56,21,L)-3D0*HRR(1:56,5,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|11_y,L)  and (f,d|11,L_y)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRC(1,22,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|11_z,L)  and (f,d|11,L_z)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRC(1,26,L),GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 12
         CDOffSet=(OC+12-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|12,L)  and (f,d'|12,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,12,L),&
                      HRRA(1,12,L),HRRB(1,12,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|12_x,L)  and (f,d|12,L_x)
         HRRTmp(1:56)=HRRC(1:56,22,L)-2D0*HRR(1:56,6,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|12_y,L)  and (f,d|12,L_y)
         HRRTmp(1:56)=HRRC(1:56,23,L)-1D0*HRR(1:56,5,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|12_z,L)  and (f,d|12,L_z)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRC(1,27,L),GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 13
         CDOffSet=(OC+13-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|13,L)  and (f,d'|13,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,13,L),&
                      HRRA(1,13,L),HRRB(1,13,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|13_x,L)  and (f,d|13,L_x)
         HRRTmp(1:56)=HRRC(1:56,23,L)-1D0*HRR(1:56,7,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|13_y,L)  and (f,d|13,L_y)
         HRRTmp(1:56)=HRRC(1:56,24,L)-2D0*HRR(1:56,6,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|13_z,L)  and (f,d|13,L_z)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRC(1,28,L),GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 14
         CDOffSet=(OC+14-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|14,L)  and (f,d'|14,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,14,L),&
                      HRRA(1,14,L),HRRB(1,14,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|14_x,L)  and (f,d|14,L_x)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRC(1,24,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|14_y,L)  and (f,d|14,L_y)
         HRRTmp(1:56)=HRRC(1:56,25,L)-3D0*HRR(1:56,7,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|14_z,L)  and (f,d|14,L_z)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRC(1,29,L),GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 15
         CDOffSet=(OC+15-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|15,L)  and (f,d'|15,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,15,L),&
                      HRRA(1,15,L),HRRB(1,15,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|15_x,L)  and (f,d|15,L_x)
         HRRTmp(1:56)=HRRC(1:56,26,L)-2D0*HRR(1:56,8,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|15_y,L)  and (f,d|15,L_y)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRC(1,27,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|15_z,L)  and (f,d|15,L_z)
         HRRTmp(1:56)=HRRC(1:56,30,L)-1D0*HRR(1:56,5,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 16
         CDOffSet=(OC+16-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|16,L)  and (f,d'|16,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,16,L),&
                      HRRA(1,16,L),HRRB(1,16,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|16_x,L)  and (f,d|16,L_x)
         HRRTmp(1:56)=HRRC(1:56,27,L)-1D0*HRR(1:56,9,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|16_y,L)  and (f,d|16,L_y)
         HRRTmp(1:56)=HRRC(1:56,28,L)-1D0*HRR(1:56,8,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|16_z,L)  and (f,d|16,L_z)
         HRRTmp(1:56)=HRRC(1:56,31,L)-1D0*HRR(1:56,6,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 17
         CDOffSet=(OC+17-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|17,L)  and (f,d'|17,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,17,L),&
                      HRRA(1,17,L),HRRB(1,17,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|17_x,L)  and (f,d|17,L_x)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRC(1,28,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|17_y,L)  and (f,d|17,L_y)
         HRRTmp(1:56)=HRRC(1:56,29,L)-2D0*HRR(1:56,9,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|17_z,L)  and (f,d|17,L_z)
         HRRTmp(1:56)=HRRC(1:56,32,L)-1D0*HRR(1:56,7,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 18
         CDOffSet=(OC+18-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|18,L)  and (f,d'|18,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,18,L),&
                      HRRA(1,18,L),HRRB(1,18,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|18_x,L)  and (f,d|18,L_x)
         HRRTmp(1:56)=HRRC(1:56,30,L)-1D0*HRR(1:56,10,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|18_y,L)  and (f,d|18,L_y)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRC(1,31,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|18_z,L)  and (f,d|18,L_z)
         HRRTmp(1:56)=HRRC(1:56,33,L)-2D0*HRR(1:56,8,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 19
         CDOffSet=(OC+19-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|19,L)  and (f,d'|19,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,19,L),&
                      HRRA(1,19,L),HRRB(1,19,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|19_x,L)  and (f,d|19,L_x)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRC(1,31,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|19_y,L)  and (f,d|19,L_y)
         HRRTmp(1:56)=HRRC(1:56,32,L)-1D0*HRR(1:56,10,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|19_z,L)  and (f,d|19,L_z)
         HRRTmp(1:56)=HRRC(1:56,34,L)-2D0*HRR(1:56,9,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))

         !K = 20
         CDOffSet=(OC+20-11)*LDC+(OD+L-5)*LDD
         ! Generating (f',d|20,L)  and (f,d'|20,L)
         CALL BraHRR106ab(NINT,LDA,LDB,OA,OB,GOA,GOB,CDOffSet,HRR(1,20,L),&
                      HRRA(1,20,L),HRRB(1,20,L),GRADIENTS(1,1),FP(1),&
                      STRESS(1,1))
         ! Generating (f,d|20_x,L)  and (f,d|20,L_x)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,0,&
                      HRRC(1,33,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|20_y,L)  and (f,d|20,L_y)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,1,&
                      HRRC(1,34,L),GRADIENTS(1,1),FP(1),STRESS(1,1))
         ! Generating (f,d|20_z,L)  and (f,d|20,L_z)
         HRRTmp(1:56)=HRRC(1:56,35,L)-3D0*HRR(1:56,10,L)
         CALL BraHRR106cd(NINT,LDA,LDB,OA,OB,GOA,GOB,GOC,GOD,CDOffSet,2,&
                      HRRTmp,GRADIENTS(1,1),FP(1),STRESS(1,1))
      ENDDO
      ! Stress: Generating (f,d|f,d)^(1)
      DO J=1,3
      DO I=1,3
      IJ=3*(J-1)+I
        DO L=5,10
          DO K=11,20
            CDOffSet=(OC+K-11)*LDC+(OD+L-5)*LDD
            CALL BraHRR106(OA,OB,LDA,LDB,CDOffSet,HRRS(1,K,L,IJ),STRESS(1,IJ))
          ENDDO
        ENDDO
      ENDDO
      ENDDO
   END SUBROUTINE dIntB10061006
    SUBROUTINE CNTRCTG106106(VRR,HRR,Alpha,HRRA,Beta,HRRB,Gamma,HRRC,VRRS,HRRS,PQJ,IW)
      USE DerivedTypes
      USE VScratchB
      IMPLICIT NONE
      INTEGER :: K
      REAL(DOUBLE)  :: Alpha,Beta,Gamma
      REAL(DOUBLE), DIMENSION(56,56,10) :: HRR
      REAL(DOUBLE), DIMENSION(84,56,10) :: HRRA,HRRB
      REAL(DOUBLE), DIMENSION(56,84,10) :: HRRC
      REAL(DOUBLE)  :: VRR(84,84,0:11)
      REAL(DOUBLE)  :: VRRS(56,56,0:10,3)
      REAL(DOUBLE)  :: HRRS(56,56,10,9),PQJ(3)
      INTEGER :: IJ,J,I,IW(3)
      DO K=1,56
         HRR(1,K,1)=HRR(1,K,1)+VRR(1,K,0)
         HRRC(1,K,1)=HRRC(1,K,1)+Gamma*VRR(1,K,0)
         HRRA(1,K,1)=HRRA(1,K,1)+Alpha*VRR(1,K,0)
         HRRB(1,K,1)=HRRB(1,K,1)+Beta*VRR(1,K,0)
         HRR(2,K,1)=HRR(2,K,1)+VRR(2,K,0)
         HRRC(2,K,1)=HRRC(2,K,1)+Gamma*VRR(2,K,0)
         HRRA(2,K,1)=HRRA(2,K,1)+Alpha*VRR(2,K,0)
         HRRB(2,K,1)=HRRB(2,K,1)+Beta*VRR(2,K,0)
         HRR(3,K,1)=HRR(3,K,1)+VRR(3,K,0)
         HRRC(3,K,1)=HRRC(3,K,1)+Gamma*VRR(3,K,0)
         HRRA(3,K,1)=HRRA(3,K,1)+Alpha*VRR(3,K,0)
         HRRB(3,K,1)=HRRB(3,K,1)+Beta*VRR(3,K,0)
         HRR(4,K,1)=HRR(4,K,1)+VRR(4,K,0)
         HRRC(4,K,1)=HRRC(4,K,1)+Gamma*VRR(4,K,0)
         HRRA(4,K,1)=HRRA(4,K,1)+Alpha*VRR(4,K,0)
         HRRB(4,K,1)=HRRB(4,K,1)+Beta*VRR(4,K,0)
         HRR(5,K,1)=HRR(5,K,1)+VRR(5,K,0)
         HRRC(5,K,1)=HRRC(5,K,1)+Gamma*VRR(5,K,0)
         HRRA(5,K,1)=HRRA(5,K,1)+Alpha*VRR(5,K,0)
         HRRB(5,K,1)=HRRB(5,K,1)+Beta*VRR(5,K,0)
         HRR(6,K,1)=HRR(6,K,1)+VRR(6,K,0)
         HRRC(6,K,1)=HRRC(6,K,1)+Gamma*VRR(6,K,0)
         HRRA(6,K,1)=HRRA(6,K,1)+Alpha*VRR(6,K,0)
         HRRB(6,K,1)=HRRB(6,K,1)+Beta*VRR(6,K,0)
         HRR(7,K,1)=HRR(7,K,1)+VRR(7,K,0)
         HRRC(7,K,1)=HRRC(7,K,1)+Gamma*VRR(7,K,0)
         HRRA(7,K,1)=HRRA(7,K,1)+Alpha*VRR(7,K,0)
         HRRB(7,K,1)=HRRB(7,K,1)+Beta*VRR(7,K,0)
         HRR(8,K,1)=HRR(8,K,1)+VRR(8,K,0)
         HRRC(8,K,1)=HRRC(8,K,1)+Gamma*VRR(8,K,0)
         HRRA(8,K,1)=HRRA(8,K,1)+Alpha*VRR(8,K,0)
         HRRB(8,K,1)=HRRB(8,K,1)+Beta*VRR(8,K,0)
         HRR(9,K,1)=HRR(9,K,1)+VRR(9,K,0)
         HRRC(9,K,1)=HRRC(9,K,1)+Gamma*VRR(9,K,0)
         HRRA(9,K,1)=HRRA(9,K,1)+Alpha*VRR(9,K,0)
         HRRB(9,K,1)=HRRB(9,K,1)+Beta*VRR(9,K,0)
         HRR(10,K,1)=HRR(10,K,1)+VRR(10,K,0)
         HRRC(10,K,1)=HRRC(10,K,1)+Gamma*VRR(10,K,0)
         HRRA(10,K,1)=HRRA(10,K,1)+Alpha*VRR(10,K,0)
         HRRB(10,K,1)=HRRB(10,K,1)+Beta*VRR(10,K,0)
         HRR(11,K,1)=HRR(11,K,1)+VRR(11,K,0)
         HRRC(11,K,1)=HRRC(11,K,1)+Gamma*VRR(11,K,0)
         HRRA(11,K,1)=HRRA(11,K,1)+Alpha*VRR(11,K,0)
         HRRB(11,K,1)=HRRB(11,K,1)+Beta*VRR(11,K,0)
         HRR(12,K,1)=HRR(12,K,1)+VRR(12,K,0)
         HRRC(12,K,1)=HRRC(12,K,1)+Gamma*VRR(12,K,0)
         HRRA(12,K,1)=HRRA(12,K,1)+Alpha*VRR(12,K,0)
         HRRB(12,K,1)=HRRB(12,K,1)+Beta*VRR(12,K,0)
         HRR(13,K,1)=HRR(13,K,1)+VRR(13,K,0)
         HRRC(13,K,1)=HRRC(13,K,1)+Gamma*VRR(13,K,0)
         HRRA(13,K,1)=HRRA(13,K,1)+Alpha*VRR(13,K,0)
         HRRB(13,K,1)=HRRB(13,K,1)+Beta*VRR(13,K,0)
         HRR(14,K,1)=HRR(14,K,1)+VRR(14,K,0)
         HRRC(14,K,1)=HRRC(14,K,1)+Gamma*VRR(14,K,0)
         HRRA(14,K,1)=HRRA(14,K,1)+Alpha*VRR(14,K,0)
         HRRB(14,K,1)=HRRB(14,K,1)+Beta*VRR(14,K,0)
         HRR(15,K,1)=HRR(15,K,1)+VRR(15,K,0)
         HRRC(15,K,1)=HRRC(15,K,1)+Gamma*VRR(15,K,0)
         HRRA(15,K,1)=HRRA(15,K,1)+Alpha*VRR(15,K,0)
         HRRB(15,K,1)=HRRB(15,K,1)+Beta*VRR(15,K,0)
         HRR(16,K,1)=HRR(16,K,1)+VRR(16,K,0)
         HRRC(16,K,1)=HRRC(16,K,1)+Gamma*VRR(16,K,0)
         HRRA(16,K,1)=HRRA(16,K,1)+Alpha*VRR(16,K,0)
         HRRB(16,K,1)=HRRB(16,K,1)+Beta*VRR(16,K,0)
         HRR(17,K,1)=HRR(17,K,1)+VRR(17,K,0)
         HRRC(17,K,1)=HRRC(17,K,1)+Gamma*VRR(17,K,0)
         HRRA(17,K,1)=HRRA(17,K,1)+Alpha*VRR(17,K,0)
         HRRB(17,K,1)=HRRB(17,K,1)+Beta*VRR(17,K,0)
         HRR(18,K,1)=HRR(18,K,1)+VRR(18,K,0)
         HRRC(18,K,1)=HRRC(18,K,1)+Gamma*VRR(18,K,0)
         HRRA(18,K,1)=HRRA(18,K,1)+Alpha*VRR(18,K,0)
         HRRB(18,K,1)=HRRB(18,K,1)+Beta*VRR(18,K,0)
         HRR(19,K,1)=HRR(19,K,1)+VRR(19,K,0)
         HRRC(19,K,1)=HRRC(19,K,1)+Gamma*VRR(19,K,0)
         HRRA(19,K,1)=HRRA(19,K,1)+Alpha*VRR(19,K,0)
         HRRB(19,K,1)=HRRB(19,K,1)+Beta*VRR(19,K,0)
         HRR(20,K,1)=HRR(20,K,1)+VRR(20,K,0)
         HRRC(20,K,1)=HRRC(20,K,1)+Gamma*VRR(20,K,0)
         HRRA(20,K,1)=HRRA(20,K,1)+Alpha*VRR(20,K,0)
         HRRB(20,K,1)=HRRB(20,K,1)+Beta*VRR(20,K,0)
         HRR(21,K,1)=HRR(21,K,1)+VRR(21,K,0)
         HRRC(21,K,1)=HRRC(21,K,1)+Gamma*VRR(21,K,0)
         HRRA(21,K,1)=HRRA(21,K,1)+Alpha*VRR(21,K,0)
         HRRB(21,K,1)=HRRB(21,K,1)+Beta*VRR(21,K,0)
         HRR(22,K,1)=HRR(22,K,1)+VRR(22,K,0)
         HRRC(22,K,1)=HRRC(22,K,1)+Gamma*VRR(22,K,0)
         HRRA(22,K,1)=HRRA(22,K,1)+Alpha*VRR(22,K,0)
         HRRB(22,K,1)=HRRB(22,K,1)+Beta*VRR(22,K,0)
         HRR(23,K,1)=HRR(23,K,1)+VRR(23,K,0)
         HRRC(23,K,1)=HRRC(23,K,1)+Gamma*VRR(23,K,0)
         HRRA(23,K,1)=HRRA(23,K,1)+Alpha*VRR(23,K,0)
         HRRB(23,K,1)=HRRB(23,K,1)+Beta*VRR(23,K,0)
         HRR(24,K,1)=HRR(24,K,1)+VRR(24,K,0)
         HRRC(24,K,1)=HRRC(24,K,1)+Gamma*VRR(24,K,0)
         HRRA(24,K,1)=HRRA(24,K,1)+Alpha*VRR(24,K,0)
         HRRB(24,K,1)=HRRB(24,K,1)+Beta*VRR(24,K,0)
         HRR(25,K,1)=HRR(25,K,1)+VRR(25,K,0)
         HRRC(25,K,1)=HRRC(25,K,1)+Gamma*VRR(25,K,0)
         HRRA(25,K,1)=HRRA(25,K,1)+Alpha*VRR(25,K,0)
         HRRB(25,K,1)=HRRB(25,K,1)+Beta*VRR(25,K,0)
         HRR(26,K,1)=HRR(26,K,1)+VRR(26,K,0)
         HRRC(26,K,1)=HRRC(26,K,1)+Gamma*VRR(26,K,0)
         HRRA(26,K,1)=HRRA(26,K,1)+Alpha*VRR(26,K,0)
         HRRB(26,K,1)=HRRB(26,K,1)+Beta*VRR(26,K,0)
         HRR(27,K,1)=HRR(27,K,1)+VRR(27,K,0)
         HRRC(27,K,1)=HRRC(27,K,1)+Gamma*VRR(27,K,0)
         HRRA(27,K,1)=HRRA(27,K,1)+Alpha*VRR(27,K,0)
         HRRB(27,K,1)=HRRB(27,K,1)+Beta*VRR(27,K,0)
         HRR(28,K,1)=HRR(28,K,1)+VRR(28,K,0)
         HRRC(28,K,1)=HRRC(28,K,1)+Gamma*VRR(28,K,0)
         HRRA(28,K,1)=HRRA(28,K,1)+Alpha*VRR(28,K,0)
         HRRB(28,K,1)=HRRB(28,K,1)+Beta*VRR(28,K,0)
         HRR(29,K,1)=HRR(29,K,1)+VRR(29,K,0)
         HRRC(29,K,1)=HRRC(29,K,1)+Gamma*VRR(29,K,0)
         HRRA(29,K,1)=HRRA(29,K,1)+Alpha*VRR(29,K,0)
         HRRB(29,K,1)=HRRB(29,K,1)+Beta*VRR(29,K,0)
         HRR(30,K,1)=HRR(30,K,1)+VRR(30,K,0)
         HRRC(30,K,1)=HRRC(30,K,1)+Gamma*VRR(30,K,0)
         HRRA(30,K,1)=HRRA(30,K,1)+Alpha*VRR(30,K,0)
         HRRB(30,K,1)=HRRB(30,K,1)+Beta*VRR(30,K,0)
         HRR(31,K,1)=HRR(31,K,1)+VRR(31,K,0)
         HRRC(31,K,1)=HRRC(31,K,1)+Gamma*VRR(31,K,0)
         HRRA(31,K,1)=HRRA(31,K,1)+Alpha*VRR(31,K,0)
         HRRB(31,K,1)=HRRB(31,K,1)+Beta*VRR(31,K,0)
         HRR(32,K,1)=HRR(32,K,1)+VRR(32,K,0)
         HRRC(32,K,1)=HRRC(32,K,1)+Gamma*VRR(32,K,0)
         HRRA(32,K,1)=HRRA(32,K,1)+Alpha*VRR(32,K,0)
         HRRB(32,K,1)=HRRB(32,K,1)+Beta*VRR(32,K,0)
         HRR(33,K,1)=HRR(33,K,1)+VRR(33,K,0)
         HRRC(33,K,1)=HRRC(33,K,1)+Gamma*VRR(33,K,0)
         HRRA(33,K,1)=HRRA(33,K,1)+Alpha*VRR(33,K,0)
         HRRB(33,K,1)=HRRB(33,K,1)+Beta*VRR(33,K,0)
         HRR(34,K,1)=HRR(34,K,1)+VRR(34,K,0)
         HRRC(34,K,1)=HRRC(34,K,1)+Gamma*VRR(34,K,0)
         HRRA(34,K,1)=HRRA(34,K,1)+Alpha*VRR(34,K,0)
         HRRB(34,K,1)=HRRB(34,K,1)+Beta*VRR(34,K,0)
         HRR(35,K,1)=HRR(35,K,1)+VRR(35,K,0)
         HRRC(35,K,1)=HRRC(35,K,1)+Gamma*VRR(35,K,0)
         HRRA(35,K,1)=HRRA(35,K,1)+Alpha*VRR(35,K,0)
         HRRB(35,K,1)=HRRB(35,K,1)+Beta*VRR(35,K,0)
         HRR(36,K,1)=HRR(36,K,1)+VRR(36,K,0)
         HRRC(36,K,1)=HRRC(36,K,1)+Gamma*VRR(36,K,0)
         HRRA(36,K,1)=HRRA(36,K,1)+Alpha*VRR(36,K,0)
         HRRB(36,K,1)=HRRB(36,K,1)+Beta*VRR(36,K,0)
         HRR(37,K,1)=HRR(37,K,1)+VRR(37,K,0)
         HRRC(37,K,1)=HRRC(37,K,1)+Gamma*VRR(37,K,0)
         HRRA(37,K,1)=HRRA(37,K,1)+Alpha*VRR(37,K,0)
         HRRB(37,K,1)=HRRB(37,K,1)+Beta*VRR(37,K,0)
         HRR(38,K,1)=HRR(38,K,1)+VRR(38,K,0)
         HRRC(38,K,1)=HRRC(38,K,1)+Gamma*VRR(38,K,0)
         HRRA(38,K,1)=HRRA(38,K,1)+Alpha*VRR(38,K,0)
         HRRB(38,K,1)=HRRB(38,K,1)+Beta*VRR(38,K,0)
         HRR(39,K,1)=HRR(39,K,1)+VRR(39,K,0)
         HRRC(39,K,1)=HRRC(39,K,1)+Gamma*VRR(39,K,0)
         HRRA(39,K,1)=HRRA(39,K,1)+Alpha*VRR(39,K,0)
         HRRB(39,K,1)=HRRB(39,K,1)+Beta*VRR(39,K,0)
         HRR(40,K,1)=HRR(40,K,1)+VRR(40,K,0)
         HRRC(40,K,1)=HRRC(40,K,1)+Gamma*VRR(40,K,0)
         HRRA(40,K,1)=HRRA(40,K,1)+Alpha*VRR(40,K,0)
         HRRB(40,K,1)=HRRB(40,K,1)+Beta*VRR(40,K,0)
         HRR(41,K,1)=HRR(41,K,1)+VRR(41,K,0)
         HRRC(41,K,1)=HRRC(41,K,1)+Gamma*VRR(41,K,0)
         HRRA(41,K,1)=HRRA(41,K,1)+Alpha*VRR(41,K,0)
         HRRB(41,K,1)=HRRB(41,K,1)+Beta*VRR(41,K,0)
         HRR(42,K,1)=HRR(42,K,1)+VRR(42,K,0)
         HRRC(42,K,1)=HRRC(42,K,1)+Gamma*VRR(42,K,0)
         HRRA(42,K,1)=HRRA(42,K,1)+Alpha*VRR(42,K,0)
         HRRB(42,K,1)=HRRB(42,K,1)+Beta*VRR(42,K,0)
         HRR(43,K,1)=HRR(43,K,1)+VRR(43,K,0)
         HRRC(43,K,1)=HRRC(43,K,1)+Gamma*VRR(43,K,0)
         HRRA(43,K,1)=HRRA(43,K,1)+Alpha*VRR(43,K,0)
         HRRB(43,K,1)=HRRB(43,K,1)+Beta*VRR(43,K,0)
         HRR(44,K,1)=HRR(44,K,1)+VRR(44,K,0)
         HRRC(44,K,1)=HRRC(44,K,1)+Gamma*VRR(44,K,0)
         HRRA(44,K,1)=HRRA(44,K,1)+Alpha*VRR(44,K,0)
         HRRB(44,K,1)=HRRB(44,K,1)+Beta*VRR(44,K,0)
         HRR(45,K,1)=HRR(45,K,1)+VRR(45,K,0)
         HRRC(45,K,1)=HRRC(45,K,1)+Gamma*VRR(45,K,0)
         HRRA(45,K,1)=HRRA(45,K,1)+Alpha*VRR(45,K,0)
         HRRB(45,K,1)=HRRB(45,K,1)+Beta*VRR(45,K,0)
         HRR(46,K,1)=HRR(46,K,1)+VRR(46,K,0)
         HRRC(46,K,1)=HRRC(46,K,1)+Gamma*VRR(46,K,0)
         HRRA(46,K,1)=HRRA(46,K,1)+Alpha*VRR(46,K,0)
         HRRB(46,K,1)=HRRB(46,K,1)+Beta*VRR(46,K,0)
         HRR(47,K,1)=HRR(47,K,1)+VRR(47,K,0)
         HRRC(47,K,1)=HRRC(47,K,1)+Gamma*VRR(47,K,0)
         HRRA(47,K,1)=HRRA(47,K,1)+Alpha*VRR(47,K,0)
         HRRB(47,K,1)=HRRB(47,K,1)+Beta*VRR(47,K,0)
         HRR(48,K,1)=HRR(48,K,1)+VRR(48,K,0)
         HRRC(48,K,1)=HRRC(48,K,1)+Gamma*VRR(48,K,0)
         HRRA(48,K,1)=HRRA(48,K,1)+Alpha*VRR(48,K,0)
         HRRB(48,K,1)=HRRB(48,K,1)+Beta*VRR(48,K,0)
         HRR(49,K,1)=HRR(49,K,1)+VRR(49,K,0)
         HRRC(49,K,1)=HRRC(49,K,1)+Gamma*VRR(49,K,0)
         HRRA(49,K,1)=HRRA(49,K,1)+Alpha*VRR(49,K,0)
         HRRB(49,K,1)=HRRB(49,K,1)+Beta*VRR(49,K,0)
         HRR(50,K,1)=HRR(50,K,1)+VRR(50,K,0)
         HRRC(50,K,1)=HRRC(50,K,1)+Gamma*VRR(50,K,0)
         HRRA(50,K,1)=HRRA(50,K,1)+Alpha*VRR(50,K,0)
         HRRB(50,K,1)=HRRB(50,K,1)+Beta*VRR(50,K,0)
         HRR(51,K,1)=HRR(51,K,1)+VRR(51,K,0)
         HRRC(51,K,1)=HRRC(51,K,1)+Gamma*VRR(51,K,0)
         HRRA(51,K,1)=HRRA(51,K,1)+Alpha*VRR(51,K,0)
         HRRB(51,K,1)=HRRB(51,K,1)+Beta*VRR(51,K,0)
         HRR(52,K,1)=HRR(52,K,1)+VRR(52,K,0)
         HRRC(52,K,1)=HRRC(52,K,1)+Gamma*VRR(52,K,0)
         HRRA(52,K,1)=HRRA(52,K,1)+Alpha*VRR(52,K,0)
         HRRB(52,K,1)=HRRB(52,K,1)+Beta*VRR(52,K,0)
         HRR(53,K,1)=HRR(53,K,1)+VRR(53,K,0)
         HRRC(53,K,1)=HRRC(53,K,1)+Gamma*VRR(53,K,0)
         HRRA(53,K,1)=HRRA(53,K,1)+Alpha*VRR(53,K,0)
         HRRB(53,K,1)=HRRB(53,K,1)+Beta*VRR(53,K,0)
         HRR(54,K,1)=HRR(54,K,1)+VRR(54,K,0)
         HRRC(54,K,1)=HRRC(54,K,1)+Gamma*VRR(54,K,0)
         HRRA(54,K,1)=HRRA(54,K,1)+Alpha*VRR(54,K,0)
         HRRB(54,K,1)=HRRB(54,K,1)+Beta*VRR(54,K,0)
         HRR(55,K,1)=HRR(55,K,1)+VRR(55,K,0)
         HRRC(55,K,1)=HRRC(55,K,1)+Gamma*VRR(55,K,0)
         HRRA(55,K,1)=HRRA(55,K,1)+Alpha*VRR(55,K,0)
         HRRB(55,K,1)=HRRB(55,K,1)+Beta*VRR(55,K,0)
         HRR(56,K,1)=HRR(56,K,1)+VRR(56,K,0)
         HRRC(56,K,1)=HRRC(56,K,1)+Gamma*VRR(56,K,0)
         HRRA(56,K,1)=HRRA(56,K,1)+Alpha*VRR(56,K,0)
         HRRB(56,K,1)=HRRB(56,K,1)+Beta*VRR(56,K,0)
         HRRA(57,K,1)=HRRA(57,K,1)+Alpha*VRR(57,K,0)
         HRRB(57,K,1)=HRRB(57,K,1)+Beta*VRR(57,K,0)
         HRRA(58,K,1)=HRRA(58,K,1)+Alpha*VRR(58,K,0)
         HRRB(58,K,1)=HRRB(58,K,1)+Beta*VRR(58,K,0)
         HRRA(59,K,1)=HRRA(59,K,1)+Alpha*VRR(59,K,0)
         HRRB(59,K,1)=HRRB(59,K,1)+Beta*VRR(59,K,0)
         HRRA(60,K,1)=HRRA(60,K,1)+Alpha*VRR(60,K,0)
         HRRB(60,K,1)=HRRB(60,K,1)+Beta*VRR(60,K,0)
         HRRA(61,K,1)=HRRA(61,K,1)+Alpha*VRR(61,K,0)
         HRRB(61,K,1)=HRRB(61,K,1)+Beta*VRR(61,K,0)
         HRRA(62,K,1)=HRRA(62,K,1)+Alpha*VRR(62,K,0)
         HRRB(62,K,1)=HRRB(62,K,1)+Beta*VRR(62,K,0)
         HRRA(63,K,1)=HRRA(63,K,1)+Alpha*VRR(63,K,0)
         HRRB(63,K,1)=HRRB(63,K,1)+Beta*VRR(63,K,0)
         HRRA(64,K,1)=HRRA(64,K,1)+Alpha*VRR(64,K,0)
         HRRB(64,K,1)=HRRB(64,K,1)+Beta*VRR(64,K,0)
         HRRA(65,K,1)=HRRA(65,K,1)+Alpha*VRR(65,K,0)
         HRRB(65,K,1)=HRRB(65,K,1)+Beta*VRR(65,K,0)
         HRRA(66,K,1)=HRRA(66,K,1)+Alpha*VRR(66,K,0)
         HRRB(66,K,1)=HRRB(66,K,1)+Beta*VRR(66,K,0)
         HRRA(67,K,1)=HRRA(67,K,1)+Alpha*VRR(67,K,0)
         HRRB(67,K,1)=HRRB(67,K,1)+Beta*VRR(67,K,0)
         HRRA(68,K,1)=HRRA(68,K,1)+Alpha*VRR(68,K,0)
         HRRB(68,K,1)=HRRB(68,K,1)+Beta*VRR(68,K,0)
         HRRA(69,K,1)=HRRA(69,K,1)+Alpha*VRR(69,K,0)
         HRRB(69,K,1)=HRRB(69,K,1)+Beta*VRR(69,K,0)
         HRRA(70,K,1)=HRRA(70,K,1)+Alpha*VRR(70,K,0)
         HRRB(70,K,1)=HRRB(70,K,1)+Beta*VRR(70,K,0)
         HRRA(71,K,1)=HRRA(71,K,1)+Alpha*VRR(71,K,0)
         HRRB(71,K,1)=HRRB(71,K,1)+Beta*VRR(71,K,0)
         HRRA(72,K,1)=HRRA(72,K,1)+Alpha*VRR(72,K,0)
         HRRB(72,K,1)=HRRB(72,K,1)+Beta*VRR(72,K,0)
         HRRA(73,K,1)=HRRA(73,K,1)+Alpha*VRR(73,K,0)
         HRRB(73,K,1)=HRRB(73,K,1)+Beta*VRR(73,K,0)
         HRRA(74,K,1)=HRRA(74,K,1)+Alpha*VRR(74,K,0)
         HRRB(74,K,1)=HRRB(74,K,1)+Beta*VRR(74,K,0)
         HRRA(75,K,1)=HRRA(75,K,1)+Alpha*VRR(75,K,0)
         HRRB(75,K,1)=HRRB(75,K,1)+Beta*VRR(75,K,0)
         HRRA(76,K,1)=HRRA(76,K,1)+Alpha*VRR(76,K,0)
         HRRB(76,K,1)=HRRB(76,K,1)+Beta*VRR(76,K,0)
         HRRA(77,K,1)=HRRA(77,K,1)+Alpha*VRR(77,K,0)
         HRRB(77,K,1)=HRRB(77,K,1)+Beta*VRR(77,K,0)
         HRRA(78,K,1)=HRRA(78,K,1)+Alpha*VRR(78,K,0)
         HRRB(78,K,1)=HRRB(78,K,1)+Beta*VRR(78,K,0)
         HRRA(79,K,1)=HRRA(79,K,1)+Alpha*VRR(79,K,0)
         HRRB(79,K,1)=HRRB(79,K,1)+Beta*VRR(79,K,0)
         HRRA(80,K,1)=HRRA(80,K,1)+Alpha*VRR(80,K,0)
         HRRB(80,K,1)=HRRB(80,K,1)+Beta*VRR(80,K,0)
         HRRA(81,K,1)=HRRA(81,K,1)+Alpha*VRR(81,K,0)
         HRRB(81,K,1)=HRRB(81,K,1)+Beta*VRR(81,K,0)
         HRRA(82,K,1)=HRRA(82,K,1)+Alpha*VRR(82,K,0)
         HRRB(82,K,1)=HRRB(82,K,1)+Beta*VRR(82,K,0)
         HRRA(83,K,1)=HRRA(83,K,1)+Alpha*VRR(83,K,0)
         HRRB(83,K,1)=HRRB(83,K,1)+Beta*VRR(83,K,0)
         HRRA(84,K,1)=HRRA(84,K,1)+Alpha*VRR(84,K,0)
         HRRB(84,K,1)=HRRB(84,K,1)+Beta*VRR(84,K,0)
      ENDDO
      DO K=57,84
         HRRC(1,K,1)=HRRC(1,K,1)+Gamma*VRR(1,K,0)
         HRRC(2,K,1)=HRRC(2,K,1)+Gamma*VRR(2,K,0)
         HRRC(3,K,1)=HRRC(3,K,1)+Gamma*VRR(3,K,0)
         HRRC(4,K,1)=HRRC(4,K,1)+Gamma*VRR(4,K,0)
         HRRC(5,K,1)=HRRC(5,K,1)+Gamma*VRR(5,K,0)
         HRRC(6,K,1)=HRRC(6,K,1)+Gamma*VRR(6,K,0)
         HRRC(7,K,1)=HRRC(7,K,1)+Gamma*VRR(7,K,0)
         HRRC(8,K,1)=HRRC(8,K,1)+Gamma*VRR(8,K,0)
         HRRC(9,K,1)=HRRC(9,K,1)+Gamma*VRR(9,K,0)
         HRRC(10,K,1)=HRRC(10,K,1)+Gamma*VRR(10,K,0)
         HRRC(11,K,1)=HRRC(11,K,1)+Gamma*VRR(11,K,0)
         HRRC(12,K,1)=HRRC(12,K,1)+Gamma*VRR(12,K,0)
         HRRC(13,K,1)=HRRC(13,K,1)+Gamma*VRR(13,K,0)
         HRRC(14,K,1)=HRRC(14,K,1)+Gamma*VRR(14,K,0)
         HRRC(15,K,1)=HRRC(15,K,1)+Gamma*VRR(15,K,0)
         HRRC(16,K,1)=HRRC(16,K,1)+Gamma*VRR(16,K,0)
         HRRC(17,K,1)=HRRC(17,K,1)+Gamma*VRR(17,K,0)
         HRRC(18,K,1)=HRRC(18,K,1)+Gamma*VRR(18,K,0)
         HRRC(19,K,1)=HRRC(19,K,1)+Gamma*VRR(19,K,0)
         HRRC(20,K,1)=HRRC(20,K,1)+Gamma*VRR(20,K,0)
         HRRC(21,K,1)=HRRC(21,K,1)+Gamma*VRR(21,K,0)
         HRRC(22,K,1)=HRRC(22,K,1)+Gamma*VRR(22,K,0)
         HRRC(23,K,1)=HRRC(23,K,1)+Gamma*VRR(23,K,0)
         HRRC(24,K,1)=HRRC(24,K,1)+Gamma*VRR(24,K,0)
         HRRC(25,K,1)=HRRC(25,K,1)+Gamma*VRR(25,K,0)
         HRRC(26,K,1)=HRRC(26,K,1)+Gamma*VRR(26,K,0)
         HRRC(27,K,1)=HRRC(27,K,1)+Gamma*VRR(27,K,0)
         HRRC(28,K,1)=HRRC(28,K,1)+Gamma*VRR(28,K,0)
         HRRC(29,K,1)=HRRC(29,K,1)+Gamma*VRR(29,K,0)
         HRRC(30,K,1)=HRRC(30,K,1)+Gamma*VRR(30,K,0)
         HRRC(31,K,1)=HRRC(31,K,1)+Gamma*VRR(31,K,0)
         HRRC(32,K,1)=HRRC(32,K,1)+Gamma*VRR(32,K,0)
         HRRC(33,K,1)=HRRC(33,K,1)+Gamma*VRR(33,K,0)
         HRRC(34,K,1)=HRRC(34,K,1)+Gamma*VRR(34,K,0)
         HRRC(35,K,1)=HRRC(35,K,1)+Gamma*VRR(35,K,0)
         HRRC(36,K,1)=HRRC(36,K,1)+Gamma*VRR(36,K,0)
         HRRC(37,K,1)=HRRC(37,K,1)+Gamma*VRR(37,K,0)
         HRRC(38,K,1)=HRRC(38,K,1)+Gamma*VRR(38,K,0)
         HRRC(39,K,1)=HRRC(39,K,1)+Gamma*VRR(39,K,0)
         HRRC(40,K,1)=HRRC(40,K,1)+Gamma*VRR(40,K,0)
         HRRC(41,K,1)=HRRC(41,K,1)+Gamma*VRR(41,K,0)
         HRRC(42,K,1)=HRRC(42,K,1)+Gamma*VRR(42,K,0)
         HRRC(43,K,1)=HRRC(43,K,1)+Gamma*VRR(43,K,0)
         HRRC(44,K,1)=HRRC(44,K,1)+Gamma*VRR(44,K,0)
         HRRC(45,K,1)=HRRC(45,K,1)+Gamma*VRR(45,K,0)
         HRRC(46,K,1)=HRRC(46,K,1)+Gamma*VRR(46,K,0)
         HRRC(47,K,1)=HRRC(47,K,1)+Gamma*VRR(47,K,0)
         HRRC(48,K,1)=HRRC(48,K,1)+Gamma*VRR(48,K,0)
         HRRC(49,K,1)=HRRC(49,K,1)+Gamma*VRR(49,K,0)
         HRRC(50,K,1)=HRRC(50,K,1)+Gamma*VRR(50,K,0)
         HRRC(51,K,1)=HRRC(51,K,1)+Gamma*VRR(51,K,0)
         HRRC(52,K,1)=HRRC(52,K,1)+Gamma*VRR(52,K,0)
         HRRC(53,K,1)=HRRC(53,K,1)+Gamma*VRR(53,K,0)
         HRRC(54,K,1)=HRRC(54,K,1)+Gamma*VRR(54,K,0)
         HRRC(55,K,1)=HRRC(55,K,1)+Gamma*VRR(55,K,0)
         HRRC(56,K,1)=HRRC(56,K,1)+Gamma*VRR(56,K,0)
      ENDDO
      DO J=1,3
      DO I=1,3
      IF(IW(J).EQ.1.AND.IW(I).EQ.1) THEN
      IJ=3*(J-1)+I
      DO K=1,56
         HRRS(1,K,1,IJ)=HRRS(1,K,1,IJ)+PQJ(J)*VRRS(1,K,0,I)
         HRRS(2,K,1,IJ)=HRRS(2,K,1,IJ)+PQJ(J)*VRRS(2,K,0,I)
         HRRS(3,K,1,IJ)=HRRS(3,K,1,IJ)+PQJ(J)*VRRS(3,K,0,I)
         HRRS(4,K,1,IJ)=HRRS(4,K,1,IJ)+PQJ(J)*VRRS(4,K,0,I)
         HRRS(5,K,1,IJ)=HRRS(5,K,1,IJ)+PQJ(J)*VRRS(5,K,0,I)
         HRRS(6,K,1,IJ)=HRRS(6,K,1,IJ)+PQJ(J)*VRRS(6,K,0,I)
         HRRS(7,K,1,IJ)=HRRS(7,K,1,IJ)+PQJ(J)*VRRS(7,K,0,I)
         HRRS(8,K,1,IJ)=HRRS(8,K,1,IJ)+PQJ(J)*VRRS(8,K,0,I)
         HRRS(9,K,1,IJ)=HRRS(9,K,1,IJ)+PQJ(J)*VRRS(9,K,0,I)
         HRRS(10,K,1,IJ)=HRRS(10,K,1,IJ)+PQJ(J)*VRRS(10,K,0,I)
         HRRS(11,K,1,IJ)=HRRS(11,K,1,IJ)+PQJ(J)*VRRS(11,K,0,I)
         HRRS(12,K,1,IJ)=HRRS(12,K,1,IJ)+PQJ(J)*VRRS(12,K,0,I)
         HRRS(13,K,1,IJ)=HRRS(13,K,1,IJ)+PQJ(J)*VRRS(13,K,0,I)
         HRRS(14,K,1,IJ)=HRRS(14,K,1,IJ)+PQJ(J)*VRRS(14,K,0,I)
         HRRS(15,K,1,IJ)=HRRS(15,K,1,IJ)+PQJ(J)*VRRS(15,K,0,I)
         HRRS(16,K,1,IJ)=HRRS(16,K,1,IJ)+PQJ(J)*VRRS(16,K,0,I)
         HRRS(17,K,1,IJ)=HRRS(17,K,1,IJ)+PQJ(J)*VRRS(17,K,0,I)
         HRRS(18,K,1,IJ)=HRRS(18,K,1,IJ)+PQJ(J)*VRRS(18,K,0,I)
         HRRS(19,K,1,IJ)=HRRS(19,K,1,IJ)+PQJ(J)*VRRS(19,K,0,I)
         HRRS(20,K,1,IJ)=HRRS(20,K,1,IJ)+PQJ(J)*VRRS(20,K,0,I)
         HRRS(21,K,1,IJ)=HRRS(21,K,1,IJ)+PQJ(J)*VRRS(21,K,0,I)
         HRRS(22,K,1,IJ)=HRRS(22,K,1,IJ)+PQJ(J)*VRRS(22,K,0,I)
         HRRS(23,K,1,IJ)=HRRS(23,K,1,IJ)+PQJ(J)*VRRS(23,K,0,I)
         HRRS(24,K,1,IJ)=HRRS(24,K,1,IJ)+PQJ(J)*VRRS(24,K,0,I)
         HRRS(25,K,1,IJ)=HRRS(25,K,1,IJ)+PQJ(J)*VRRS(25,K,0,I)
         HRRS(26,K,1,IJ)=HRRS(26,K,1,IJ)+PQJ(J)*VRRS(26,K,0,I)
         HRRS(27,K,1,IJ)=HRRS(27,K,1,IJ)+PQJ(J)*VRRS(27,K,0,I)
         HRRS(28,K,1,IJ)=HRRS(28,K,1,IJ)+PQJ(J)*VRRS(28,K,0,I)
         HRRS(29,K,1,IJ)=HRRS(29,K,1,IJ)+PQJ(J)*VRRS(29,K,0,I)
         HRRS(30,K,1,IJ)=HRRS(30,K,1,IJ)+PQJ(J)*VRRS(30,K,0,I)
         HRRS(31,K,1,IJ)=HRRS(31,K,1,IJ)+PQJ(J)*VRRS(31,K,0,I)
         HRRS(32,K,1,IJ)=HRRS(32,K,1,IJ)+PQJ(J)*VRRS(32,K,0,I)
         HRRS(33,K,1,IJ)=HRRS(33,K,1,IJ)+PQJ(J)*VRRS(33,K,0,I)
         HRRS(34,K,1,IJ)=HRRS(34,K,1,IJ)+PQJ(J)*VRRS(34,K,0,I)
         HRRS(35,K,1,IJ)=HRRS(35,K,1,IJ)+PQJ(J)*VRRS(35,K,0,I)
         HRRS(36,K,1,IJ)=HRRS(36,K,1,IJ)+PQJ(J)*VRRS(36,K,0,I)
         HRRS(37,K,1,IJ)=HRRS(37,K,1,IJ)+PQJ(J)*VRRS(37,K,0,I)
         HRRS(38,K,1,IJ)=HRRS(38,K,1,IJ)+PQJ(J)*VRRS(38,K,0,I)
         HRRS(39,K,1,IJ)=HRRS(39,K,1,IJ)+PQJ(J)*VRRS(39,K,0,I)
         HRRS(40,K,1,IJ)=HRRS(40,K,1,IJ)+PQJ(J)*VRRS(40,K,0,I)
         HRRS(41,K,1,IJ)=HRRS(41,K,1,IJ)+PQJ(J)*VRRS(41,K,0,I)
         HRRS(42,K,1,IJ)=HRRS(42,K,1,IJ)+PQJ(J)*VRRS(42,K,0,I)
         HRRS(43,K,1,IJ)=HRRS(43,K,1,IJ)+PQJ(J)*VRRS(43,K,0,I)
         HRRS(44,K,1,IJ)=HRRS(44,K,1,IJ)+PQJ(J)*VRRS(44,K,0,I)
         HRRS(45,K,1,IJ)=HRRS(45,K,1,IJ)+PQJ(J)*VRRS(45,K,0,I)
         HRRS(46,K,1,IJ)=HRRS(46,K,1,IJ)+PQJ(J)*VRRS(46,K,0,I)
         HRRS(47,K,1,IJ)=HRRS(47,K,1,IJ)+PQJ(J)*VRRS(47,K,0,I)
         HRRS(48,K,1,IJ)=HRRS(48,K,1,IJ)+PQJ(J)*VRRS(48,K,0,I)
         HRRS(49,K,1,IJ)=HRRS(49,K,1,IJ)+PQJ(J)*VRRS(49,K,0,I)
         HRRS(50,K,1,IJ)=HRRS(50,K,1,IJ)+PQJ(J)*VRRS(50,K,0,I)
         HRRS(51,K,1,IJ)=HRRS(51,K,1,IJ)+PQJ(J)*VRRS(51,K,0,I)
         HRRS(52,K,1,IJ)=HRRS(52,K,1,IJ)+PQJ(J)*VRRS(52,K,0,I)
         HRRS(53,K,1,IJ)=HRRS(53,K,1,IJ)+PQJ(J)*VRRS(53,K,0,I)
         HRRS(54,K,1,IJ)=HRRS(54,K,1,IJ)+PQJ(J)*VRRS(54,K,0,I)
         HRRS(55,K,1,IJ)=HRRS(55,K,1,IJ)+PQJ(J)*VRRS(55,K,0,I)
         HRRS(56,K,1,IJ)=HRRS(56,K,1,IJ)+PQJ(J)*VRRS(56,K,0,I)
      ENDDO !K
      ENDIF
      ENDDO !I
      ENDDO !J
    END SUBROUTINE CNTRCTG106106
