/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *   search.cc  *
 *    ~~~~~~    *
 ****************/

#ifndef SEARCH_H
#define SEARCH_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include <list>
// i18n
#include "../include/gettext.h"

using namespace std;

class Cli;

class Search
{
public:
  Search ();

  // Thread function.
  void do_work (Cli* caller);
  std::list<std::string> getdir (std::string search, std::string dir);
  void stop_work ();
  void recursive_search (std::list<std::string> results,
			 std::string search,
			 std::string dir, Cli* caller);
  bool has_stopped ();
  static std::list<std::string> extr_files (std::string search,
					    std::list<std::string> rs,
					    std::string dr);
  std::list<std::string> extr_dirs (std::list<std::string> rs, std::string dr);
  static std::string get_type (std::string file, std::string dir);
  
private:
    bool search_shall_stop;
    bool search_has_stopped;
};

#endif // SEARCH_H
