#!/bin/sh
# 2015-2016 (C) Copyright Felicien PILLOT <felicien.pillot@member.fsf.org>
# Look at COPYING for license details
# Fisoco
#
# Bootstrap script

usage () {
    echo "Usage: $0 OPTION"
    echo "Options :"
    echo -e "  -c  --clean-all\tRemove all derivated files"
    echo -e "  -g  --get-config\tGet autoconf/automake derivated files"
    echo -e "  -h  --help     \tDisplay this message"
    exit 1
}

clean_all () {
    echo "Cleaning files to come back to a developer/maintainer's directory..."
    for mkf in $(find . -name Makefile.in); do rm $mkf; done;
    [ -f po/messages.po ] && rm po/messages.po
    [ -f po/Makefile.in.in ] && rm po/Makefile.in.in
    [ -f po/*~ ] && rm po/*~
    [ -f *~ ] && rm *~
    [ -d m4 ] && rm -fr m4
    [ -d autom4te.cache ] && rm -fr autom4te.cache
    [ -f aclocal.m4 ] && rm aclocal.m4
    [ -f configure ] && rm configure
}

get_config () {
    echo "Linking shared libraries..."
    libtoolize
    if [ -f m4/ax_generate_changelog.m4 ]; then
	echo "Skipping changelog macro linkage"
    else
	echo "Linking local changelog generating macro"
	cd m4 && ln -s ../config/ax_generate_changelog.m4 && cd ..
    fi
    echo "Generating macros..."
    aclocal
    echo "Preparing config headers..."
    autoheader
    echo "Preparing Makefiles..."
    automake -Wgnu --gnu --add-missing
    if [ -f po/Makefile.in.in ]; then
	echo "Skipping intltoolize invocation"
    else
	echo "Preparing PO Makefile.in"
    intltoolize --automake
    fi
    echo "Generating configure script"
    autoconf
    echo "Done."
}

while [ $# -gt 0 ]; do
    case "$1" in
	-g | --get-config ) get_config ;;
	-c | --clean-all ) clean_all ;;
	-h | --help ) usage;;
	* ) usage ;;
    esac
    exit 0
done

usage
