#include <iostream>
#include "Tank.hh"
#include "Turent.hh"

extern CL_ResourceManager* resources;

const float circle = 6.2831854;

Turent::Turent (Tank* arg_tank, int r_speed, std::string surface, std::string fire) :
  sur (surface.c_str (), resources),
  fire_sur (fire.c_str (), resources),
  fireing (false),
  reloading (0),
  reloading_speed (r_speed)
{
  tank = arg_tank;
}

Turent::~Turent ()
{
}

void 
Turent::draw ()
{
  float absolute_angle = tank->get_angle () + angle;
  int frame = int(fmod (absolute_angle, circle) / circle * 16.0);
  
  sur.put_screen (tank->get_x_pos () - (sur.get_width ()/2), 
		  tank->get_y_pos () - (sur.get_height ()/2),
		  frame);

  if (fireing && reloading == 0)
    {
      fire_sur.put_screen (tank->get_x_pos () - (fire_sur.get_width ()/2), 
			   tank->get_y_pos () - (fire_sur.get_height ()/2),
			   frame);
      fireing = false;
      reloading = reloading_speed;
    }
}

void
Turent::update ()
{
  if (reloading)
    reloading--;
}

void 
Turent::increase_angle ()
{
  angle += tank->get_increment ();
  angle = fmod (angle + circle, circle);
}

void
Turent::decrease_angle ()
{
  angle -= tank->get_increment ();
  angle = fmod (angle + circle, circle);
}

void
Turent::start_fire ()
{
  fireing = true;
}

void
Turent::stop_fire ()
{
  fireing = false;
}

void 
Turent::set_angle (float arg_angle)
{
  angle = arg_angle;
}

// EOF 
