#file: rpg.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file is the first file accessed upon game start.
#It allows the player to select the module, or, if there is only one,
#automatically selects for the player.

from Tkinter import *
from os import listdir

#Load other windows after starting the main one,
#to prevent Tk trouble.
window_sel_game = Tk()
import g
import new_game
dirnames = []

#take the selected module from the listbox, and send to sel_mod
def sel_list_mod():
	if (len(listbox_mods.curselection()) == 0): return 0
	try: mod_num = map(int, listbox_mods.curselection())
	except ValueError: pass
	mod_name = dirnames[mod_num[0]]
	sel_mod(mod_name)

#given a certain mod, run it.
def sel_mod(selected_mod):
	window_sel_game.withdraw()
	g.mod_directory = "../modules/" + selected_mod
	loading_window = Toplevel(window_sel_game)
	templbl = Label(loading_window, text="Loading " + selected_mod)
	templbl.grid()
	loading_window.title("Loading")
	loading_window.resizable(0, 0)
	loading_window.maxsize(1000, 1000)
	loading_window.wm_geometry("+%d+%d" % (20, 20))
	loading_window.update_idletasks()
	g.init_data()
	loading_window.withdraw()
	new_game.init_window()
	quit_game()

def quit_game():
	raise SystemExit

def init_window():
	array_mods = listdir("../modules/")
	#remove CVS directory
	i = 0
	while i < len(array_mods):
		if array_mods[i] == "CVS":
			array_mods.pop(i)
		elif array_mods[i] == "default":
			array_mods.pop(i)
		else:
			i += 1

	#if there is only one module, run it.
	if (len(array_mods) == 1):
		sel_mod(array_mods[0])
		return 0

	global window_sel_game

	window_sel_game.title("Select module")
	window_sel_game.resizable(0, 0)
	window_sel_game.maxsize(900, 900)
	window_sel_game.wm_geometry("+%d+%d" % (20, 20))

	global listbox_mods
	listbox_mods = Listbox(window_sel_game, height=10)
	listbox_mods.grid(row=1, column=1, rowspan=10, sticky=N+W+E)

	global button_sel
	button_sel = Button(window_sel_game, text="Select mod",
		command=sel_list_mod)
	button_sel.grid(row=1, column=0)

	global button_quit
	button_quit = Button(window_sel_game, text="Quit", command=quit_game)
	button_quit.grid(row=2, column=0)

	for modname in array_mods:
		g.mod_directory = "../modules/" + modname
		listbox_mods.insert(END, g.read_game_name())
		global dirnames
		dirnames.append(modname)

	window_sel_game.mainloop()

init_window()
