#file: main.py
#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#This file controls the wilderness and dungeon.

from Tkinter import *
#needed for the tiles.
import ImageTk
import Image
#needed for random battles
from random import random
#needed for dialog boxes
import tkMessageBox

#needed for benchmarking. Uncomment to use.
#from time import clock

#local imports.
import g
import inv
import battle
import shop
import action

from player import *

#size, in tiles, of the main screen. While this is adjustable,
#odd numbers would work much better. (To keep the player centered.)
mapsizex = 23
mapsizey = 13

sidebarsize = 5
status_box_width = 19
width = 20
tilesize = 32

#division is nasty. Only do it once. Used for centering items on the player.
half_mapx = mapsizex/2
half_mapy = mapsizey/2

#used for yes/no dialog boxes.
active_button = 0
return_from_yesno = StringVar()

#used to prevent drawing problems.
global already_refreshed
already_refreshed = 0

#max number of messages to keep.
max_messages = 25

#number of free moves after attack left.
global free_move


name = StringVar()
hp = StringVar()
ep = StringVar()
attack = StringVar()
defense = StringVar()
gold = StringVar()
exp = StringVar()
level = StringVar()

#Image used for the inventory icon.
inv_icon_image = "inv.png"

#Print a message in status box. Works with ~Action~ embedded commands.
def print_message(message):
	try:
		if window_main.state() != "normal":
			return 0
		message = action.interpret_line(message)
		listbox_status.insert(END, message)
		listbox_status.see(END)

		if listbox_status.size() > max_messages:
			listbox_status.delete(0, listbox_status.size() - max_messages -1)
		return 1
	except NameError:
		return 0

#save game
def save_game(event=0):
	if action.has_dialog == 1: return 0
	g.savegame(player.name)
	print_message("** Game Saved **");

#determine if the player is dead, and, if so, end the game.
def dead_yet():
	#did you die?
	if player.hp <= 0:
		action.run_command(g.xgrid, g.ygrid, g.zgrid, "die()")
		return 1
	return 0

#back to main menu. Called on death.
def close_window(event=0):
	if action.has_dialog == 1: return
	if (g.cur_window == "battle"): #if called from battle window
		if player.hp < 1 or battle.battle_show_yesno("Leave this game?"):
			try:
				window_main.destroy()
			except TclError:
				pass
# 	elif (g.cur_window == "inventory"): #if called from inventory window
# 		if player.hp < 1 or inv.inv_show_yesno("Leave this game?"):
# 			try:
# 				window_main.destroy()
# 			except TclError:
# 				pass
	elif canvas_map.winfo_exists():
		if player.hp < 1 or show_yesno("Leave this game?"):
			try:
				window_main.destroy()
			except TclError:
				pass



#Activate any scripting associated with a tile. X and Y are absolute coords.
#Assumes scripting stored in maps[zgrid].field[y][x].actions[]
def activate_scripting(x, y, z):
	return_num = 0
	temp_zgrid = z

	#Make sure this is a "real" tile:
	if(z < 0 or x < 0 or y < 0 or z >= len(g.maps) or
	y >= len(g.maps[g.zgrid].field) or x >= len(g.maps[g.zgrid].field[y])):
		return

	itemnum = 0
	while itemnum < len(g.maps[g.zgrid].field[y][x].items):
		itemname = g.maps[g.zgrid].field[y][x].items[itemnum]
		if action.run_command(x, y, z, "find(\"" + itemname + "\", \"a\")"):
			g.maps[g.zgrid].del_item(itemname, x, y)
			refresh_tile(x, y)
			refresh_inv_icon()
			refresh_bars()
		else: itemnum += 1

	#if there are no actions, leave immediately
	if len(g.maps[temp_zgrid].field[y][x].actions) == 0: return

	#go through all action lines.
	action.activate_lines(x, y, temp_zgrid,
					g.maps[temp_zgrid].field[y][x].actions)


#redraws the main map. Call after moving.
def refreshmap():
	#redraw the tiles
	for x in range(mapsizex):
		for y in range(mapsizey):
			refresh_tile(g.xgrid - half_mapx + x, g.ygrid - half_mapy + y)

	refreshhero()
	refresh_inv_icon()
	refresh_bars()
	recalc_stats()

#refreshes the inventory icon in the upper-left.
def refresh_inv_icon():
	canvas_map.delete("inv_icon")
	canvas_map.create_image(0, 0, image=g.buttons[inv_icon_image], anchor=NW,
				tags="inv_icon")

def refresh_bars():
	canvas_map.delete("point_bars")
	canvas_map.create_rectangle(0, g.buttons[inv_icon_image].height(),
		g.buttons[inv_icon_image].width(), g.buttons[inv_icon_image].height()+5,
				fill="#EE0505", tags="point_bars")
	hpbar_width=g.buttons[inv_icon_image].width()*player.hp/player.adj_maxhp
	canvas_map.create_rectangle(0, g.buttons[inv_icon_image].height(),
		hpbar_width, g.buttons[inv_icon_image].height()+5,
				fill="#05BB05", tags="point_bars")

	canvas_map.create_rectangle(0, g.buttons[inv_icon_image].height()+6,
		g.buttons[inv_icon_image].width(), g.buttons[inv_icon_image].height()+11,
				fill="#EE0505", tags="point_bars")
	epbar_width=g.buttons[inv_icon_image].width()*player.ep/player.adj_maxep

	canvas_map.create_rectangle(0, g.buttons[inv_icon_image].height()+6,
		epbar_width, g.buttons[inv_icon_image].height()+11,
				fill="#0505EE", tags="point_bars")


#given x and y (absolute coods.) refresh the given tile.
def refresh_tile(x, y):
	search_for = str(x)+"."+str(y)
	canvas_map.delete(search_for)
	for picture in findtile(x, y):
		canvas_map.create_image((x-g.xgrid + half_mapx)*g.tilesize,
		(y-g.ygrid + half_mapy)*g.tilesize, anchor=NW,
		image=picture, tags=str(x)+"."+str(y))

#refreshs the hero; faster than refreshing the whole map.
def refreshhero():
	canvas_map.delete("hero")
	canvas_map.create_image(mapsizex*g.tilesize/2, mapsizey*g.tilesize/2,
		image=g.tiles[player.cur_hero], tags="hero")
	for picture in g.maps[g.zgrid].field[g.ygrid][g.xgrid].addoverpix:
		canvas_map.create_image(mapsizex*g.tilesize/2, mapsizey*g.tilesize/2,
					image=picture, tags="hero")

#called to process the onload portion of a level. Called whenever entering
#a level. Set g.zgrid properly before calling.
def process_onload():
	for y in range(len(g.maps[g.zgrid].field)):
		for x in range(len(g.maps[g.zgrid].field[y])):
			action.activate_lines(x, y, g.zgrid,
							g.maps[g.zgrid].field[y][x].onload)
			if dead_yet() == 1: break

#re-display stats.
def recalc_stats():
# 	name.set(player.name)
# 	attack.set(player.adj_attack)
# 	defense.set(player.adj_defense)
# 	gold.set(player.gold)
# 	exp.set(player.exp)
# 	level.set(player.level)

	#hp/ep bars
# 	canvas_hp.delete("show_hp")
# 	temp_width = g.hpbar_width*player.hp/player.adj_maxhp
# 	if temp_width < 0: temp_width=0
# 	canvas_hp.create_rectangle(0, 0, temp_width,
# 		g.hpbar_width/6, fill="#05BB05", tags="show_hp")
# 	canvas_ep.delete("show_ep")
# 	temp_width = g.hpbar_width*player.ep/player.adj_maxep
# 	if temp_width < 0: temp_width=0
# 	canvas_ep.create_rectangle(0, 0, temp_width,
# 		g.hpbar_width/6, fill="#0505EE", tags="show_ep")
# 	hp.set(str(player.hp) + "/" + str(player.adj_maxhp))
# 	ep.set(str(player.ep) + "/" + str(player.adj_maxep))
	refresh_bars()

#Return an array of pictures that the given tile should display.
#x and y are absolute coords.
def findtile(x, y):

	returnpix = []
	#If dealing with an off-map area, grab the nearest known tile.
	if x < 0: x = 0
	if y < 0: y = 0
	if y >= len(g.maps[g.zgrid].field): y = len(g.maps[g.zgrid].field) -1
	if x >= len(g.maps[g.zgrid].field[y]): x = len(g.maps[g.zgrid].field[y]) -1
	try:
		#This should not (normally) fail.
		returnpix.append(g.maps[g.zgrid].field[y][x].pix)
		for picture in g.maps[g.zgrid].field[y][x].addpix:
			returnpix.append(picture)
		for picture in g.maps[g.zgrid].field[y][x].addoverpix:
			returnpix.append(picture)
		for itemname in g.maps[g.zgrid].field[y][x].items:
			returnpix.append(
				g.tiles[g.item.item[g.item.finditem(itemname)].picturename])
		return returnpix
	except IndexError:
		#If it fails, there is rock there.
		returnpix.append(g.maps[g.zgrid].field[0][0].pix)
		return returnpix
	except KeyError:
		#if the author forgot to define the tile, point out the mistake.
		print "Tile of " + g.maps[g.zgrid].field[y][x].name + " is not defined" \
			+ " in map " + g.maps[g.zgrid].name
		returnpix.append(g.maps[g.zgrid].field[0][0].pix)
		return returnpix


#movement commands. Check to see if window_main is visible, and if there is no
#dialog box showing, then if travel is possible to a spot, move there.
#requires the change in xy coordinates. Called with move_north and the like.
def move_hero(x, y):
	try:
		tempy = g.ygrid + y
		tempx = g.xgrid + x

		#check for either the main window not existing, or a current dialog
		if window_main.state() != "normal" or action.has_dialog == 1:
			return
		#tempclock = clock()
		#check for any objects of interest. Called before moving, in case
		#the scripting changes the walkable status.
		activate_scripting(tempx, tempy, g.zgrid)

		if g.iswalkable(tempx, tempy, x, y):
			if g.allow_move == 1:
				g.xgrid=g.xgrid + x
				g.ygrid=g.ygrid + y
				passturn()
				if g.allow_change_hero == 1:
					if y == -1: player.cur_hero = "people/hero_n" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if y ==  1: player.cur_hero = "people/hero_s" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if x == -1: player.cur_hero = "people/hero_w" + \
							g.maps[g.zgrid].hero_suffix + ".png"
					if x ==  1: player.cur_hero = "people/hero_e" + \
							g.maps[g.zgrid].hero_suffix + ".png"
				g.allow_change_hero = 1
				#Sometimes, quick refresh is bad.
				global already_refreshed
				if already_refreshed == 1:
					refreshhero()
					already_refreshed = 0
					#print clock() - tempclock
					return

				#quick refresh.
				#Moves the canvas over a bit
				canvas_map.move(ALL, -x*tilesize, -y*tilesize)

				#Refreshes the new part.
				refreshhero()
				recalc_stats()
				g.allow_move = 1
				if y == -1:
					for tilenum in range(mapsizex):
						refresh_tile(g.xgrid-half_mapx+tilenum, g.ygrid-half_mapy)
				if y ==  1:
					for tilenum in range(mapsizex):
						refresh_tile(g.xgrid-half_mapx+tilenum, g.ygrid+half_mapy)
				if x == -1:
					for tilenum in range(mapsizey):
						refresh_tile(g.xgrid-half_mapx, g.ygrid-half_mapy+tilenum)
				if x ==  1:
					for tilenum in range(mapsizey):
						refresh_tile(g.xgrid+half_mapx, g.ygrid-half_mapy+tilenum)
				refresh_inv_icon()
				refresh_bars()

		else:
			if (tempx == g.xgrid + x) and (tempy == g.ygrid + y) and \
									(g.allow_change_hero == 1):
				if y == -1: player.cur_hero = "people/hero_n" + g.maps[g.zgrid].hero_suffix + ".png"
				if y ==  1: player.cur_hero = "people/hero_s" + g.maps[g.zgrid].hero_suffix + ".png"
				if x == -1: player.cur_hero = "people/hero_w" + g.maps[g.zgrid].hero_suffix + ".png"
				if x ==  1: player.cur_hero = "people/hero_e" + g.maps[g.zgrid].hero_suffix + ".png"
			g.allow_change_hero = 1
			refreshhero()
			recalc_stats()
		g.allow_move = 1
		#print clock() - tempclock
	except TclError:
		pass


def move_north(event=0): move_hero(0, -1)
def move_east(event=0):  move_hero(1, 0)
def move_south(event=0): move_hero(0, 1)
def move_west(event=0):  move_hero(-1, 0)


#called at the end of movement. Controls the passing of time.
def passturn():
	global free_move

	#handle timed effects
	g.timestep = g.timestep + 1
	if g.timestep >= 30: g.timestep = g.timestep - 30

	action.activate_lines(g.xgrid, g.ygrid, g.zgrid,
		g.per_turn_script[g.timestep])
	if dead_yet() == 1: return

	#is there a monster here?
	chance = random() * 100
	#allow free moves after attack
	if free_move > 0:
		free_move = free_move - 1
		chance = 99

	if chance < 15:
		#battle
		temp = g.monster.find_level_monster(g.zgrid)
		#if there exists a monster to battle:
		if temp != -1:
			start_battle(temp)
			if dead_yet() != 1:
				#If I don't do this, the quick refresh wigs out.
				global already_refreshed
				already_refreshed = 1


#Starts a battle. Takes the index of the monster in g.monster.monster_groups
def start_battle(mon_index):
	global free_move
#	right.destroy()
#	button_inv.config(state=DISABLED)
#	button_save.config(state=DISABLED)
	tmp=battle.begin(mon_index)
	if tmp == 1:  #if you ran, you failed
		return_num = 0
	elif tmp == 0:
		return_num = 1  #otherwise, you succeeded.
	elif tmp == "end":
		return_num = "end"
		dead_yet()
	#number of free moves after attack:
	free_move = 4
	g.cur_window = "main"
#	button_inv.config(state=NORMAL)
#	button_save.config(state=NORMAL)
	player.reset_stats()
	refreshmap()
	bind_keys()
	return return_num


#Call to display a dialog box. Used to work with action.py.
#Note this only works if window_main is visible.
def show_dialog(line=None):
	unbind_keys()
	line = action.interpret_line(line)
	if window_main.state() != "normal":
		return 0

	action.has_dialog = 1
	global return_from_yesno
	return_from_yesno.set("0")
	#text
	canvas_map.create_text((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), text=line, anchor="s",
		width=(g.buttons["no.png"].width()+g.buttons["yes.png"].width())*4/3-6,
		tags="dialogtxt")
	#generate the background size.
	x1, y1, x2, y2 = canvas_map.bbox("dialogtxt")
	if x1 > (mapsizex*tilesize/2) - g.buttons["no.png"].width():
		x1 = (mapsizex*tilesize/2) - g.buttons["no.png"].width()
	if x2 < (mapsizex*tilesize/2) + g.buttons["yes.png"].width():
		x2 = (mapsizex*tilesize/2) + g.buttons["yes.png"].width()
	#background
	canvas_map.create_rectangle(x1-5, y1-5, x2+5, y2+g.buttons["no.png"].height(),
		fill=g.fill_colour, outline="Black", tags="background_box")
	canvas_map.lift("dialogtxt")
	#button
	canvas_map.create_image((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), image=g.buttons["begin_sel.png"], anchor="n", tags="ok")
	#bindings
	window_main.bind(g.binding_action, activate_yesno)
	canvas_map.tag_bind("ok", "<Button-1>", activate_yesno)
	#wait. Continue after activate_yesno() is run.
	window_main.wait_variable(return_from_yesno)
	#cleanup
	try:
		if window_main.state() != "normal": return 1
	except TclError: return 1
	bind_keys()
	action.has_dialog = 0
	canvas_map.delete("dialogtxt", "ok", "background_box")
	return 1

#given a string, display that string, along with yes and no buttons.
def show_yesno(line=""):
	line = action.interpret_line(line)
	if window_main.state() != "normal":
		return 0
	action.has_dialog = 1
	global active_button
	active_button = 0
	global return_from_yesno
	return_from_yesno.set("0")
	#text
	canvas_map.create_text((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), text=line, anchor="s",
		width=g.buttons["no.png"].width()*4/3+g.buttons["yes.png"].width()*4/3-6, tags="dialogtxt")
	#generate the background size.
	x1, y1, x2, y2 = canvas_map.bbox("dialogtxt")
	if x1 > (mapsizex*tilesize/2) - g.buttons["no.png"].width():
		x1 = (mapsizex*tilesize/2) - g.buttons["no.png"].width()
	if x2 < (mapsizex*tilesize/2) + g.buttons["yes.png"].width():
		x2 = (mapsizex*tilesize/2) + g.buttons["yes.png"].width()
	#background
	canvas_map.create_rectangle(x1-5, y1-5, x2+5, y2+g.buttons["no.png"].height(),
		fill=g.fill_colour, outline="Black", tags="background_box")
	canvas_map.lift("dialogtxt")
	#buttons
	canvas_map.create_image((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), image=g.buttons["no_sel.png"], anchor="ne", tags="no")
	canvas_map.create_image((mapsizex*tilesize/2),
		(6*mapsizey*tilesize/7), image=g.buttons["yes.png"], anchor="nw", tags="yes")
	#bindings
	canvas_map.unbind("<Motion>")
	window_main.bind(g.binding_up, change_yesno_sel)
	window_main.bind(g.binding_right, change_yesno_sel)
	window_main.bind(g.binding_left, change_yesno_sel)
	window_main.bind(g.binding_down, change_yesno_sel)
	window_main.bind(g.binding_action, activate_yesno)
	canvas_map.tag_bind("no", "<Enter>", change_yesno_to_no)
	canvas_map.tag_bind("yes", "<Enter>", change_yesno_to_yes)
	canvas_map.tag_bind("no", "<Button-1>", activate_yesno)
	canvas_map.tag_bind("yes", "<Button-1>", activate_yesno)
	#wait. Continue after activate_yesno() is run.
	window_main.wait_variable(return_from_yesno)
	#cleanup
	try:
		if window_main.state() != "normal": return 1
	except TclError: return 1
	bind_keys()
	action.has_dialog = 0
	canvas_map.delete("dialogtxt", "no", "yes", "background_box")

	return active_button

#when a yesno dialog box is active, switch to yes.
def change_yesno_to_yes(event=None):
	global active_button
	active_button = 1
	canvas_map.itemconfigure("no", image=g.buttons["no.png"])
	canvas_map.itemconfigure("yes", image=g.buttons["yes_sel.png"])

#when a yesno dialog box is active, switch to no.
def change_yesno_to_no(event=None):
	global active_button
	active_button = 0
	canvas_map.itemconfigure("no", image=g.buttons["no_sel.png"])
	canvas_map.itemconfigure("yes", image=g.buttons["yes.png"])

#when a yesno dialog box is active, switch the yes and no buttons.
def change_yesno_sel(event=None):
	if active_button == 0: change_yesno_to_yes()
	else: change_yesno_to_no()

#called on Return when the yesno dialog box is active.
def activate_yesno(event=None):
	global return_from_yesno
	return_from_yesno.set("1")

#Display the scripting console. This window will take scripting, then
#execute it.
def load_console(event=None):
	#Only let cheaters access the console.
	if player.name != "testing123" and player.name != "god" and \
									player.name != "script_test":
		return 0
	global console_text
	console_text = Text(right, width=80, height=12)
	console_text.grid(row=0, column=0, columnspan=2)
	global accept_button
	accept_button = Button(right, text="run scripting", command=accept_console)
	accept_button.grid(row=0, column=0, sticky=S)
	window_main.unbind(g.binding_up)
	window_main.unbind(g.binding_right)
	window_main.unbind(g.binding_left)
	window_main.unbind(g.binding_down)
	window_main.unbind(g.binding_cancel)
	window_main.unbind(g.binding_inv)
	window_main.unbind(g.binding_attack)
	window_main.unbind(g.binding_save)
	window_main.unbind(g.binding_quit)
	window_main.unbind(g.binding_action)
	window_main.unbind(g.binding_console)

#Called on hitting the "run scripting" button in the console. Runs the scripting
#in the console, then destroys the console.
def accept_console(event=None):
	global console_text
	global accept_button
	console_input = console_text.get(1.0, END)
	console_array = console_input.split("\n")

	console_text.destroy()
	accept_button.destroy()
	bind_keys()
	action.activate_lines(g.xgrid, g.ygrid, g.zgrid, g.interpret_lines(console_array))


#If the main window is destroyed unexpectedly, try to prevent the worst errors.
def cleanup(event=None):
	activate_yesno()
	battle.return_from_dialog.set("2")
	inv.leave_inv()
	shop.leave_shop()
	window_main.destroy()
	action.has_dialog = 0

#call to create window_main.
def init_window_main(new_game = 0):
	global window_main
	global top
	window_main = Toplevel()
	global bgcolour
	bgcolour="lightgrey"
	global buttoncolour
	buttoncolour="lightgrey"
	global statusboxcolour
	statusboxcolour = "lightgrey"

	main_frame = Frame(window_main, bg=bgcolour)
	main_frame.grid(row=0, column=0)

	#top frame contains left and right
	top = Frame(main_frame, bd=1, relief=SUNKEN, bg=bgcolour);
	top.grid(row=0, column=0, columnspan=width, sticky=NW)

	#status window, scrollbar
	global move_scroll
	global listbox_status
	listbox_status = Listbox(window_main, height=g.message_lines,
		bg=statusboxcolour)
	listbox_status.grid(row=1, column=0, sticky=N+S+E+W) #status_box_width)
	move_scroll = Scrollbar(window_main, orient=VERTICAL,
		command=listbox_status.yview, bg=statusboxcolour)
	move_scroll.grid(row=1, column=0, sticky=N+S+E)
	listbox_status.config(yscrollcommand=move_scroll.set)
	window_main.rowconfigure(1, weight=1)


	g.load_tiles()

	#width of the hp/ep bars.
	g.hpbar_width = g.tilesize*3

	name.set(player.name)

	#left (stats) side frame
# 	global left
# 	left = Frame(top, bg=bgcolour);
# 	left.grid(row=1, column=0, columnspan=sidebarsize, sticky=NW)
#
# 	#formatting for the labels.
# 	label_formatting = Label(left, text="Name:", bg=bgcolour).grid(row=5,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="HP:", bg=bgcolour).grid(row=6,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="EP:", bg=bgcolour).grid(row=8,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="Attack:", bg=bgcolour).grid(row=10,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="Defense:", bg=bgcolour).grid(row=11,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="Gold:", bg=bgcolour).grid(row=12,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="Exp:", bg=bgcolour).grid(row=13,
# 		column=1, sticky=E)
# 	label_formatting = Label(left, text="Level:", bg=bgcolour).grid(row=14,
# 		column=1, sticky=E)
#
# 	#display of stats
# 	label_name = Label(left, textvariable=name, bg=bgcolour).grid(row=5,
# 		column=2, sticky=W)
#
# 	global canvas_hp
# 	canvas_hp = Canvas(left, width=g.hpbar_width,
# 		height=g.hpbar_width/6, highlightthickness=0)
# 	canvas_hp.grid(column=1, row=7, columnspan=2, sticky=W, padx=5)
# 	canvas_hp.create_rectangle(0, 0, g.hpbar_width,
# 		g.hpbar_width/2, fill="#EE0505")
# 	global canvas_ep
# 	canvas_ep = Canvas(left, width=g.hpbar_width,
# 		height=g.hpbar_width/6, highlightthickness=0)
# 	canvas_ep.grid(column=1, row=9, columnspan=2, sticky=W, padx=5)
# 	canvas_ep.create_rectangle(0, 0, g.hpbar_width,
# 		g.hpbar_width/2, fill="#EE0505")
#
# 	label_hp = Label(left, textvariable=hp, bg=bgcolour).grid(row=6,
# 		column=2, sticky=W)
# 	label_ep = Label(left, textvariable=ep, bg=bgcolour).grid(row=8,
# 		column=2, sticky=W)
# 	label_attack = Label(left, textvariable=attack, bg=bgcolour).grid(row=10,
# 		column=2, sticky=W)
# 	label_defense = Label(left, textvariable=defense, bg=bgcolour).grid(row=11,
# 		column=2, sticky=W)
# 	label_gold = Label(left, textvariable=gold, bg=bgcolour).grid(row=12,
# 		column=2, sticky=W)
# 	label_exp = Label(left, textvariable=exp, bg=bgcolour).grid(row=13,
# 		column=2, sticky=W)
# 	label_level = Label(left, textvariable=level, bg=bgcolour).grid(row=14,
# 		column=2, sticky=W)
#
#
# 	#inventory and movement buttons.
# 	global button_inv #global because we need to disable it sometimes.
# 	global button_save
# 	global button_quit
# 	button_inv = Button(left, text="Inventory", underline="0",
# 		command=show_inv, bg=buttoncolour)
# 	button_inv.grid(row=15, column=1, columnspan=2, sticky=EW)
# 	button_save = Button(left, text="Save", underline="0",
# 		command=save_game, bg=buttoncolour)
# 	button_save.grid(row=16, column=1, columnspan=2, sticky=EW)
# 	button_quit = Button(left, text="Quit", underline="0",
# 		command=close_window, bg=buttoncolour)
# 	button_quit.grid(row=17, column=1, columnspan=2, sticky=EW)
	#this creates the actual map portion.
	create_map()

	#put in the map, and do finishing touches on the window.
	process_onload()
	player.cur_hero = "people/hero_w" + g.maps[g.zgrid].hero_suffix + ".png"
	player.reset_stats()
	refreshmap()
	window_main.wm_geometry("+%d+%d" % (10, 10))
	window_main.focus()
	window_main.resizable(0, 0)
	window_main.maxsize(1000, 10000)
	window_main.title(g.game_name)
	global free_move
	free_move = 0
	g.cur_window = "main"

	bind_keys()
	window_main.protocol("WM_DELETE_WINDOW", cleanup)

	#action.has_dialog = 0
	#call newgame script
	if new_game == 1:
		action.activate_lines(g.xgrid, g.ygrid, g.zgrid, g.newgame_act)
	g.allow_move = 1

	#keep the new_game window asleep until this one is closed.
	window_main.master.wait_window(window_main)
	return 0

#needed for some bindings.
def do_nothing(event=0):
	pass

#this binds keys to the appropriate commands. Needs to be called after
#returning from various subwindows.
def bind_keys():
	window_main.bind(g.binding_up, move_north)
	window_main.bind(g.binding_right, move_east)
	window_main.bind(g.binding_left, move_west)
	window_main.bind(g.binding_down, move_south)
	window_main.bind(g.binding_cancel, close_window)
	window_main.bind(g.binding_inv, show_inv)
	window_main.unbind(g.binding_attack)
	window_main.bind(g.binding_save, save_game)
	window_main.bind(g.binding_quit, close_window)
	window_main.bind(g.binding_action, show_inv)
	window_main.bind(g.binding_console, load_console)
	canvas_map.bind("<Button-1>", mouse_handler)
	canvas_map.unbind("<Double-Button-1>")
	canvas_map.unbind("<ButtonRelease-1>")
	canvas_map.bind("<Motion>", mouse_move)

def unbind_keys():
	window_main.unbind(g.binding_up)
	window_main.unbind(g.binding_right)
	window_main.unbind(g.binding_left)
	window_main.unbind(g.binding_down)
	window_main.unbind(g.binding_cancel)
	window_main.unbind(g.binding_inv)
	window_main.unbind(g.binding_attack)
	window_main.unbind(g.binding_save)
	window_main.unbind(g.binding_quit)
	window_main.unbind(g.binding_action)
	window_main.unbind(g.binding_console)
	canvas_map.unbind("<Button-1>")
	canvas_map.unbind("<Double-Button-1>")
	canvas_map.unbind("<Motion>")

#handles mouse clicks on the main tile canvas.
def mouse_handler(event=0):
	if event.x < g.buttons["inv.png"].width() and \
					event.y < g.buttons["inv.png"].height():
		show_inv()
		return

	#set variables, based on the shape of the main window. (tall or wide)
	if mapsizex > mapsizey:
		mapsz = mapsizey*g.tilesize
		mapstartx = (mapsizex*g.tilesize - mapsz)/2
		mapstarty = 0
	else:
		mapsz = mapsizex*g.tilesize
		mapstartx = 0
		mapstarty = (mapsizey*g.tilesize - mapsz)/2
	#This basically divides the screen along diagonals, then finds the
	#current quadrent of the mouse.
	if (event.x - mapstartx < event.y - mapstarty): #south or west
		if (event.x + event.y > mapstartx+mapstarty+mapsz): move_south()
		else: move_west()
	else: #north or east
		if (event.x + event.y > mapstartx+mapstarty+mapsz): move_east()
		else: move_north()

#called whenever the mouse moves
def mouse_move(event=0):
	global inv_icon_image
	if event.x < g.buttons["inv.png"].width() and \
					event.y < g.buttons["inv.png"].height():
		new_icon_image = "inv_sel.png"
	else:
		new_icon_image = "inv.png"
	if new_icon_image != inv_icon_image:
		inv_icon_image = new_icon_image
		refresh_inv_icon()

def create_map():
	#right side frame contains map
	global right
	right = Frame(top,bd=2, relief=SUNKEN, bg=bgcolour);
	right.grid(row=1, column=sidebarsize, columnspan=mapsizex, sticky=E)
	global canvas_map
	canvas_map = Canvas(right, width=g.tilesize*mapsizex,
		height=g.tilesize*mapsizey, highlightthickness=0)
	canvas_map.grid(column=0, row=0)
	canvas_map.bind("<Button-1>", mouse_handler)

#show the inventory.
def show_inv(event=0):
	try:
		if window_main.state() != "normal" or action.has_dialog == 1:
			return
#		right.destroy()
# 		button_inv.config(state=DISABLED)
# 		button_save.config(state=DISABLED)
# 		button_quit.config(state=DISABLED)
		inv.init_window_inv()
# 		button_inv.config(state=NORMAL)
# 		button_save.config(state=NORMAL)
# 		button_quit.config(state=NORMAL)
#		create_map()
		refreshmap()
		recalc_stats()
		bind_keys()
	except TclError:
		pass

def enter_store(cur_loc):
#	right.destroy()
# 	button_inv.config(state=DISABLED)
# 	button_save.config(state=DISABLED)
# 	button_quit.config(state=DISABLED)
	unbind_keys()
	shop.init_window_shop(cur_loc)
# 	button_inv.config(state=NORMAL)
# 	button_save.config(state=NORMAL)
# 	button_quit.config(state=NORMAL)
#	create_map()
	refreshmap()
	recalc_stats()
	bind_keys()
