#Copyright (C) 2005 Free Software Foundation
#This file is part of Dragon Hunt.

#Dragon Hunt is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.

#Dragon Hunt is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with Dragon Hunt; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#allows selection of a map to load

from Tkinter import *
from os import listdir
#import m

global my_map

global result
result = 0

#take the selected module from the listbox, and send to sel_mod
def sel_list_map(event=0):
	if (len(listbox_mods.curselection()) == 0): return 0
	try: mod_num = map(int, listbox_mods.curselection())
	except ValueError: pass
	map_name = listbox_mods.get(mod_num[0])
	sel_map(map_name)

#given a certain map, open it.
def sel_map(selected_map):
	global mapname
	mapname = selected_map
	global result
	result = 1
	window_sel_game.destroy()

def cancel():
	global result
	result = 0
	window_sel_game.destroy()

def quit():
	window_sel_game.destroy()

def init_window():
	global window_sel_game
	window_sel_game = Toplevel()

	array_mods = listdir("../modules/Dragon Hunt/data/maps/")
	#remove CVS directory
	i = 0
	while i < len(array_mods):
		if array_mods[i] == "CVS":
			array_mods.pop(i)
		else:
			i += 1

	#if there is only one module, run it.
	if (len(array_mods) == 1):
		sel_map(array_mods[0])
		return 1

	window_sel_game.title("Select Map")
	window_sel_game.resizable(10, 10)
	window_sel_game.wm_geometry("+%d+%d" % (20, 20))

	global listbox_mods
	listbox_mods = Listbox(window_sel_game, height=10) #, takefocus=0)
	listbox_mods.grid(row=1, column=1, rowspan=10, sticky=N+W+E)

	global mods_saves
	mods_saves = Scrollbar(window_sel_game, command=listbox_mods.yview)
	mods_saves.grid(row=1, column=2, rowspan=10, sticky="NSE")
	listbox_mods.config(yscrollcommand=mods_saves.set)

	global button_sel
	button_sel = Button(window_sel_game, text="Select Map",
		command=sel_list_map)
	button_sel.grid(row=1, column=0)

	global button_quit
	button_quit = Button(window_sel_game, text="Cancel", command=cancel)
	button_quit.grid(row=2, column=0)

	window_sel_game.bind("<Double-Button-1>", sel_list_map)
	for modname in array_mods:
		listbox_mods.insert(END, modname)

	window_sel_game.master.wait_window(window_sel_game)
	return result
