/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"
#include "dfile.h"
#include "where.h"
#include "_where.h"


/*
** This function starts building the syntax tree for the WHERE filter condition.
*/

int _where_build_syntax_tree( condition_t **ret_condition, sexpr_t *sexpr, dfile_t *dfile )
{
	int	ret;
	condition_t	*condition;

	assert( ret_condition != (condition_t **)0 );
	assert( sexpr != (sexpr_t *)0 );
	assert( dfile != (dfile_t *)0 );

	DEBUG_FUNC_START;

	*ret_condition = (condition_t *)0;

	if ( SEXPR_CAR_TYPE( sexpr ) != string_sexpr || strcasecmp( SEXPR_CAR_STRING( sexpr ), "where" ) != 0 ) {
		RETURN_INT( WHERE_SYNTAX );
	}

	/*
	** Discard 'where'.
	*/
	assert( SEXPR_CDR_TYPE( sexpr ) == list_sexpr );

	condition = (condition_t *)malloc( sizeof( condition_t ) );
	if ( condition == (condition_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( WHERE_UNIXERR );
	}

	ret = _where_condition_syntax( condition, SEXPR_CDR_LIST( sexpr ), dfile );
	if ( ret != WHERE_NOERR ) {
		RETURN_INT( ret );
	}

	*ret_condition = condition;

	RETURN_INT( WHERE_NOERR );
}
