/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <assert.h>

#include "tbox.h"


/*
** Perform a binary search for KEY in BASE which has NMEMB elements
** of SIZE bytes each.  The comparisons are done by (*COMPAR)().
** Key value is expected to be greater than or equal to minimum array value.
*/
void *psearch (const void *key, const void *base, size_t nmemb, size_t size, int (*compar) (const void *, const void *))
{
	size_t	l, u, idx;
	int	comparison;
	const void	*p;

	assert( key != (const void *)0 );
	assert( base != (const void *)0 );
	assert( nmemb > (size_t)0 );
	assert( size > (size_t)0 );
	assert( compar != (int (*)(const void *, const void *))0 );

	DEBUG_FUNC_START;

	l = 0;
	u = nmemb;
	p = (const void *)0;
	comparison = 0;

	while ( l < u ) {
		idx = ( l + u ) / 2;
		p = (void *)( ( (const char *)base ) + ( idx * size ) );
		comparison = (*compar) ( key, p );
		if ( comparison < 0 ) {
			u = idx;
		} else {
			if ( comparison > 0 ) {
				l = idx + 1;
			} else {
				RETURN_POINTER( (void *)p );
			}
		}
	}

	if ( comparison < 0 ) {
		if ( p > base ) {
			p = (const void *)( ( (const char *)p ) - size );
		}
	}

	RETURN_POINTER( (void *)p );
}
