/* Copyright (C) 2009, 2010, 2011 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "tbox.h"


static const int	true = 1, false = 0;
static int composite( unsigned long, unsigned long );

int isprime( unsigned long value, unsigned short iterations )
{
	unsigned short	i;
	long	random_value;
	const unsigned long	first_prime = 2;

	if ( value < first_prime ) {
		return false;
	}

	/*
	** This check prevents division by zero when assigning random_value.
	*/
	if ( value == first_prime ) {
		return true;
	}

	if ( iterations == (unsigned short)0 ) {
		/*
		** Default iterations to 10.
		*/
		iterations = (unsigned short)10;
	}

	srand( 3L );

	for ( i = (unsigned short)0; i < iterations; ++i ) {
		/*
		** Random value must be between 1 and value-1.
		*/
		random_value = ( lrand48() % ( value - 2L ) ) + 1L;
		if ( composite( (unsigned long)random_value, value ) ) {
			return false;
		}
	}

	return true;
}

#define LONG_BIT	32

static int composite( unsigned long random_value, unsigned long value )
{
	unsigned long	value_bits, mask, x;
	unsigned long long	d;
	const unsigned short	bit_size = LONG_BIT;
	unsigned short	bit_ndx;

	value_bits = value - 1;

	/*
	** Find the length in bits of value - 1.
	** Set most significant bit on in mask.
	*/
	mask = 01 << ( bit_size - 1 );

	for ( bit_ndx = bit_size; bit_ndx > (unsigned short)0; --bit_ndx ) {
		if ( mask & value_bits ) {
			break;
		}
		mask >>= 1;
	}

	d = 1ULL;

	for ( ; bit_ndx > (unsigned short)0; --bit_ndx ) {
		x = (unsigned long)d;
		d = ( d * d ) % value;
		if ( d == 1ULL && x != 1UL && x != value_bits ) {
			return true;
		}
		if ( mask & value_bits ) {
			d = ( d * random_value ) % value;
		}
		mask >>= 1;
	}

	/*
	** d will be one if value is not a composite number (non-prime).
	*/
	return ( d == 1UL ) ? false : true;
}

#if 0
int main( void )
{
	char	buf[40];
	unsigned long	value, i;
	int	result;

	while ( gets( buf ) != (char *)0 ) {
		value = strtoul( buf, (char **)0, 10 );
		result = isprime( value, (unsigned short)10 );
		(void) printf( "%lu %s prime\n", value, ( result ) ? "is" : "is not" );
	}

	for ( i = 70000UL; i < 100000UL; ++i ) {
		if ( isprime( i, (unsigned short)0 ) ) {
			(void) printf( "%lu is prime\n", i );
		}
	}

	return 0;
}
#endif
